/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.util;

import java.util.Comparator;
import javax.xml.namespace.QName;
import org.apache.ws.jaxme.generator.QNameOwner;

public class QNameComparator
implements Comparator {
    private static final QNameComparator theInstance = new QNameComparator();

    protected QNameComparator() {
    }

    public static QNameComparator getInstance() {
        return theInstance;
    }

    public int compare(Object o1, Object o2) {
        int result;
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        QNameOwner qo1 = (QNameOwner)o1;
        QNameOwner qo2 = (QNameOwner)o2;
        QName n1 = qo1.getQName();
        QName n2 = qo2.getQName();
        if (n1 == null) {
            return n2 == null ? 0 : -1;
        }
        if (n2 == null) {
            return 1;
        }
        String s1 = n1.getNamespaceURI();
        String s2 = n2.getNamespaceURI();
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        if ((result = s1.compareTo(s2)) == 0) {
            result = n1.getLocalPart().compareTo(n2.getLocalPart());
        }
        return result;
    }
}

