/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.util;

import org.apache.ws.jaxme.generator.sg.SchemaSG;

public class JavaNamer {
    public static final char[] PUNCTUATION_CHARS = new char[]{'-', '.', ':', '_', '\u00b7', '\u0387', '\u06dd', '\u06de'};

    public static boolean isPunctuationCharacter(char c, SchemaSG pSchema) {
        for (int i = 0; i < PUNCTUATION_CHARS.length; ++i) {
            char pc = PUNCTUATION_CHARS[i];
            if (pc == '_' && !pSchema.isUnderscoreWordSeparator() || c != pc) continue;
            return true;
        }
        return false;
    }

    public static String convert(String pLocalName, SchemaSG pSchema) {
        if (!pSchema.isJavaNamingConventionsEnabled()) {
            return pLocalName;
        }
        StringBuffer result = new StringBuffer();
        char c = pLocalName.charAt(0);
        if (Character.isJavaIdentifierStart(c)) {
            result.append(Character.toUpperCase(c));
        } else {
            result.append('_');
        }
        for (int i = 1; i < pLocalName.length(); ++i) {
            c = pLocalName.charAt(i);
            if (Character.isJavaIdentifierPart(c) && c != '_') {
                result.append(c);
                continue;
            }
            if (JavaNamer.isPunctuationCharacter(c, pSchema)) {
                c = pLocalName.charAt(++i);
                result.append(Character.toUpperCase(c));
                continue;
            }
            result.append('_');
        }
        return result.toString();
    }
}

