/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.sg.impl;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.jaxme.generator.sg.Context;
import org.apache.ws.jaxme.generator.sg.GroupSG;
import org.apache.ws.jaxme.generator.sg.ObjectSG;
import org.apache.ws.jaxme.generator.sg.SGFactory;
import org.apache.ws.jaxme.generator.sg.SGItem;
import org.apache.ws.jaxme.generator.sg.SchemaSG;
import org.apache.ws.jaxme.generator.sg.SchemaSGChain;
import org.apache.ws.jaxme.generator.sg.TypeSG;
import org.apache.ws.jaxme.impl.XMLWriterImpl;
import org.apache.ws.jaxme.js.JavaConstructor;
import org.apache.ws.jaxme.js.JavaField;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceFactory;
import org.apache.ws.jaxme.js.Parameter;
import org.apache.ws.jaxme.js.TextFile;
import org.apache.ws.jaxme.logging.Logger;
import org.apache.ws.jaxme.logging.LoggerAccess;
import org.apache.ws.jaxme.util.DOMSerializer;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSSchema;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.jaxb.JAXBGlobalBindings;
import org.apache.ws.jaxme.xs.jaxb.JAXBJavaType;
import org.apache.ws.jaxme.xs.jaxb.JAXBSchema;
import org.apache.ws.jaxme.xs.types.XSNCName;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class JAXBSchemaSG
implements SchemaSGChain {
    private static final Logger log = LoggerAccess.getLogger((Class)(class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaSG == null ? (class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaSG = JAXBSchemaSG.class$("org.apache.ws.jaxme.generator.sg.impl.JAXBSchemaSG")) : class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaSG));
    private final Map elementsByName = new HashMap();
    private final Map groupsByName = new HashMap();
    private final Map typesByName = new HashMap();
    private final SGFactory factory;
    private final XSSchema xsSchema;
    private final JavaSourceFactory javaSourceFactory = new JavaSourceFactory();
    private TypeSG[] typesByOrder;
    private ObjectSG[] elementsByOrder;
    private ObjectSG[] objectsByOrder;
    private GroupSG[] groupsByOrder;
    static /* synthetic */ Class class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaSG;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$org$apache$ws$jaxme$impl$JAXBContextImpl;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$javax$xml$bind$JAXBException;
    static /* synthetic */ Class class$javax$xml$bind$JAXBContext;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$HashMap;

    public JAXBSchemaSG(SGFactory pFactory, XSSchema pSchema) {
        this.factory = pFactory;
        this.xsSchema = pSchema;
        this.javaSourceFactory.setOverwriteForced(pFactory.getGenerator().isForcingOverwrite());
        this.javaSourceFactory.setSettingReadOnly(pFactory.getGenerator().isSettingReadOnly());
    }

    public SchemaSG getSchema(SchemaSG pController) {
        return pController;
    }

    public Locator getLocator(SchemaSG pController) {
        return this.xsSchema.getLocator();
    }

    public SGFactory getFactory(SchemaSG pController) {
        return this.factory;
    }

    protected XSSchema getXSSchema() {
        return this.xsSchema;
    }

    public void init(SchemaSG pController) throws SAXException {
        String mName = "init";
        log.finest("init", "->");
        Object[] childs = this.getXSSchema().getChilds();
        ArrayList<ObjectSG> elements = new ArrayList<ObjectSG>();
        ArrayList<TypeSG> types = new ArrayList<TypeSG>();
        ArrayList<GroupSG> groups = new ArrayList<GroupSG>();
        ArrayList<ObjectSG> objects = new ArrayList<ObjectSG>();
        for (int i = 0; i < childs.length; ++i) {
            Object o = childs[i];
            log.finest("init", "Child" + o);
            if (o instanceof XSType) {
                TypeSG typeSG = pController.getType(((XSType)o).getName());
                if (typeSG == null) {
                    throw new IllegalStateException("TypeSG not created");
                }
                types.add(typeSG);
                continue;
            }
            if (o instanceof XSGroup) {
                GroupSG groupSG = pController.getGroup(((XSGroup)o).getName());
                if (groupSG == null) {
                    throw new IllegalStateException("GroupSG not created");
                }
                groups.add(groupSG);
                continue;
            }
            if (!(o instanceof XSElement)) continue;
            ObjectSG objectSG = pController.getElement(((XSElement)o).getName());
            if (objectSG == null) {
                throw new IllegalStateException("ObjectSG not created");
            }
            objects.add(objectSG);
            elements.add(objectSG);
        }
        this.elementsByOrder = elements.toArray(new ObjectSG[elements.size()]);
        this.typesByOrder = types.toArray(new TypeSG[types.size()]);
        this.groupsByOrder = groups.toArray(new GroupSG[groups.size()]);
        this.objectsByOrder = objects.toArray(new ObjectSG[objects.size()]);
        log.finest("init", "<-");
    }

    public TypeSG getType(SchemaSG pController, XsQName pName) throws SAXException {
        TypeSG typeSG = (TypeSG)this.typesByName.get(pName);
        if (typeSG != null) {
            return typeSG;
        }
        XSType type = this.getXSSchema().getType(pName);
        if (type == null) {
            return null;
        }
        typeSG = pController.getFactory().getTypeSG(type);
        this.typesByName.put(pName, typeSG);
        return typeSG;
    }

    public GroupSG[] getGroups(SchemaSG pController) throws SAXException {
        return this.groupsByOrder;
    }

    public GroupSG getGroup(SchemaSG pController, XsQName pName) throws SAXException {
        GroupSG groupSG = (GroupSG)this.groupsByName.get(pName);
        if (groupSG != null) {
            return groupSG;
        }
        XSGroup group = this.getXSSchema().getGroup(pName);
        if (group == null) {
            return null;
        }
        groupSG = pController.getFactory().getGroupSG(group);
        this.groupsByName.put(pName, groupSG);
        return groupSG;
    }

    public TypeSG[] getTypes(SchemaSG pController) throws SAXException {
        return this.typesByOrder;
    }

    public ObjectSG[] getObjects(SchemaSG pController) throws SAXException {
        return this.objectsByOrder;
    }

    public ObjectSG getElement(SchemaSG pController, XsQName pName) throws SAXException {
        ObjectSG objectSG = (ObjectSG)this.elementsByName.get(pName);
        if (objectSG != null) {
            return objectSG;
        }
        XSElement element = this.getXSSchema().getElement(pName);
        if (element == null) {
            return null;
        }
        objectSG = pController.getFactory().getObjectSG(element);
        this.elementsByName.put(pName, objectSG);
        return objectSG;
    }

    public String getCollectionType(SchemaSG pController) {
        String result;
        JAXBSchema jaxbSchema;
        JAXBGlobalBindings globalBindings;
        XSSchema schema = this.getXSSchema();
        if (schema instanceof JAXBSchema && (globalBindings = (jaxbSchema = (JAXBSchema)schema).getJAXBGlobalBindings()) != null && (result = globalBindings.getCollectionType()) != null) {
            return result;
        }
        return (class$java$util$ArrayList == null ? (class$java$util$ArrayList = JAXBSchemaSG.class$("java.util.ArrayList")) : class$java$util$ArrayList).getName();
    }

    public JavaSourceFactory getJavaSourceFactory(SchemaSG pController) {
        return this.javaSourceFactory;
    }

    public void generate(SchemaSG pController) throws SAXException {
        GroupSG[] groups = pController.getGroups();
        for (int i = 0; i < groups.length; ++i) {
            groups[i].generate();
        }
        TypeSG[] types = pController.getTypes();
        for (int i = 0; i < types.length; ++i) {
            types[i].generate();
        }
        ObjectSG[] objects = pController.getObjects();
        for (int i = 0; i < objects.length; ++i) {
            objects[i].generate();
        }
        pController.generateJaxbProperties();
    }

    public ObjectSG[] getElements(SchemaSG pController) throws SAXException {
        return this.elementsByOrder;
    }

    public boolean isBindingStyleModelGroup(SchemaSG pController) {
        JAXBSchema jaxbSchema;
        JAXBGlobalBindings globalBindings;
        XSSchema schema = this.getXSSchema();
        if (schema instanceof JAXBSchema && (globalBindings = (jaxbSchema = (JAXBSchema)schema).getJAXBGlobalBindings()) != null) {
            return globalBindings.isBindingStyleModelGroup();
        }
        return false;
    }

    public boolean isChoiceContentProperty(SchemaSG pController) {
        JAXBSchema jaxbSchema;
        JAXBGlobalBindings globalBindings;
        XSSchema schema = this.getXSSchema();
        if (schema instanceof JAXBSchema && (globalBindings = (jaxbSchema = (JAXBSchema)schema).getJAXBGlobalBindings()) != null) {
            return globalBindings.isChoiceContentProperty();
        }
        return false;
    }

    public boolean isFailFastCheckEnabled(SchemaSG pController) {
        JAXBSchema jaxbSchema;
        JAXBGlobalBindings globalBindings;
        XSSchema schema = this.getXSSchema();
        if (schema instanceof JAXBSchema && (globalBindings = (jaxbSchema = (JAXBSchema)schema).getJAXBGlobalBindings()) != null) {
            return globalBindings.isEnableFailFastCheck();
        }
        return false;
    }

    public boolean isJavaNamingConventionsEnabled(SchemaSG pController) {
        JAXBSchema jaxbSchema;
        JAXBGlobalBindings globalBindings;
        XSSchema schema = this.getXSSchema();
        if (schema instanceof JAXBSchema && (globalBindings = (jaxbSchema = (JAXBSchema)schema).getJAXBGlobalBindings()) != null) {
            return globalBindings.isEnableJavaNamingConventions();
        }
        return true;
    }

    public boolean isFixedAttributeConstantProperty(SchemaSG pController) {
        JAXBSchema jaxbSchema;
        JAXBGlobalBindings globalBindings;
        XSSchema schema = this.getXSSchema();
        if (schema instanceof JAXBSchema && (globalBindings = (jaxbSchema = (JAXBSchema)schema).getJAXBGlobalBindings()) != null) {
            return globalBindings.isFixedAttributeAsConstantProperty();
        }
        return false;
    }

    public boolean isGeneratingIsSetMethod(SchemaSG pController) {
        JAXBSchema jaxbSchema;
        JAXBGlobalBindings globalBindings;
        XSSchema schema = this.getXSSchema();
        if (schema instanceof JAXBSchema && (globalBindings = (jaxbSchema = (JAXBSchema)schema).getJAXBGlobalBindings()) != null) {
            return globalBindings.isGenerateIsSetMethod();
        }
        return false;
    }

    public boolean isUnderscoreWordSeparator(SchemaSG pController) {
        JAXBSchema jaxbSchema;
        JAXBGlobalBindings globalBindings;
        XSSchema schema = this.getXSSchema();
        if (schema instanceof JAXBSchema && (globalBindings = (jaxbSchema = (JAXBSchema)schema).getJAXBGlobalBindings()) != null) {
            return JAXBGlobalBindings.UnderscoreBinding.AS_WORD_SEPARATOR.equals(globalBindings.getUnderscoreBinding());
        }
        return true;
    }

    public JAXBJavaType[] getJAXBJavaTypes(SchemaSG pController) {
        JAXBSchema jaxbSchema;
        JAXBGlobalBindings globalBindings;
        XSSchema schema = this.getXSSchema();
        if (schema instanceof JAXBSchema && (globalBindings = (jaxbSchema = (JAXBSchema)schema).getJAXBGlobalBindings()) != null) {
            return globalBindings.getJavaType();
        }
        return new JAXBJavaType[0];
    }

    public XsQName[] getTypesafeEnumBase(SchemaSG pController) {
        JAXBSchema jaxbSchema;
        JAXBGlobalBindings globalBindings;
        XSSchema schema = this.getXSSchema();
        if (schema instanceof JAXBSchema && (globalBindings = (jaxbSchema = (JAXBSchema)schema).getJAXBGlobalBindings()) != null) {
            return globalBindings.getTypesafeEnumBase();
        }
        return new XsQName[]{XSNCName.getInstance().getName()};
    }

    public Document getConfigFile(SchemaSG pController, String pPackageName, List pContextList) throws SAXException {
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException("Failed to create a DocumentBuilder: " + e.getMessage(), e);
        }
        Document doc = db.newDocument();
        String uri = "http://ws.apache.org/jaxme/namespaces/jaxme2/configuration";
        Element root = doc.createElementNS("http://ws.apache.org/jaxme/namespaces/jaxme2/configuration", "Configuration");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://ws.apache.org/jaxme/namespaces/jaxme2/configuration");
        doc.appendChild(root);
        Iterator iter = pContextList.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            Context ctx = o instanceof ObjectSG ? ((ObjectSG)o).getClassContext() : ((TypeSG)o).getComplexTypeSG().getClassContext();
            String packageName = ctx.getXMLInterfaceName().getPackageName();
            if (packageName == null) {
                packageName = "";
            }
            if (!packageName.equals(pPackageName)) continue;
            Element manager = doc.createElementNS("http://ws.apache.org/jaxme/namespaces/jaxme2/configuration", "Manager");
            root.appendChild(manager);
            manager.setAttributeNS(null, "elementInterface", ctx.getXMLInterfaceName().toString());
            manager.setAttributeNS(null, "elementClass", ctx.getXMLImplementationName().toString());
            manager.setAttributeNS(null, "handlerClass", ctx.getXMLHandlerName().toString());
            manager.setAttributeNS(null, "marshallerClass", ctx.getXMLSerializerName().toString());
            manager.setAttributeNS(null, "validatorClass", ctx.getXMLValidatorName().toString());
            if (!(o instanceof ObjectSG)) continue;
            manager.setAttributeNS(null, "qName", ((ObjectSG)o).getName().toString());
        }
        return doc;
    }

    protected String generateConfigFile(SchemaSG pController, String pPackageName, List pContextList) throws SAXException {
        Document doc = pController.getConfigFile(pPackageName, pContextList);
        StringWriter sw = new StringWriter();
        XMLWriterImpl xw = new XMLWriterImpl();
        try {
            xw.setWriter(sw);
        }
        catch (JAXBException e) {
            throw new SAXException((Exception)((Object)e));
        }
        DOMSerializer ds = new DOMSerializer();
        ds.serialize(doc, xw);
        return sw.toString();
    }

    public void generateJaxbProperties(SchemaSG pController) throws SAXException {
        ArrayList<SGItem> contextList = new ArrayList<SGItem>();
        ObjectSG[] elements = pController.getElements();
        for (int i = 0; i < elements.length; ++i) {
            if (!elements[i].getTypeSG().isComplex()) continue;
            contextList.add(elements[i]);
        }
        TypeSG[] types = pController.getTypes();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].isComplex()) continue;
            contextList.add(types[i]);
        }
        HashSet<String> packages = new HashSet<String>();
        Iterator iter = contextList.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            Context ctx = o instanceof ObjectSG ? ((ObjectSG)o).getClassContext() : ((TypeSG)o).getComplexTypeSG().getClassContext();
            String packageName = ctx.getXMLInterfaceName().getPackageName();
            if (packages.contains(packageName)) continue;
            TextFile textFile = pController.getJavaSourceFactory().newTextFile(packageName, "jaxb.properties");
            textFile.addLine((Object)("javax.xml.bind.context.factory=" + (class$org$apache$ws$jaxme$impl$JAXBContextImpl == null ? JAXBSchemaSG.class$("org.apache.ws.jaxme.impl.JAXBContextImpl") : class$org$apache$ws$jaxme$impl$JAXBContextImpl).getName()));
            packages.add(packageName);
            String configFile = this.generateConfigFile(pController, packageName, contextList);
            TextFile confFile = pController.getJavaSourceFactory().newTextFile(packageName, "Configuration.xml");
            confFile.setContents(configFile);
            this.getObjectFactory(pController, packageName, contextList);
        }
    }

    protected JavaSource getObjectFactory(SchemaSG pController, String pPackageName, List pContextList) {
        JavaQName qName = JavaQNameImpl.getInstance((String)pPackageName, (String)"ObjectFactory");
        JavaSource js = pController.getJavaSourceFactory().newJavaSource(qName, "public");
        JavaField jf = js.newJavaField("jaxbContext", class$org$apache$ws$jaxme$impl$JAXBContextImpl == null ? (class$org$apache$ws$jaxme$impl$JAXBContextImpl = JAXBSchemaSG.class$("org.apache.ws.jaxme.impl.JAXBContextImpl")) : class$org$apache$ws$jaxme$impl$JAXBContextImpl, "private");
        JavaField properties = js.newJavaField("properties", class$java$util$Map == null ? (class$java$util$Map = JAXBSchemaSG.class$("java.util.Map")) : class$java$util$Map, "private");
        JavaConstructor jcon = js.newJavaConstructor("public");
        jcon.addThrows(class$javax$xml$bind$JAXBException == null ? (class$javax$xml$bind$JAXBException = JAXBSchemaSG.class$("javax.xml.bind.JAXBException")) : class$javax$xml$bind$JAXBException);
        jcon.addLine((Object)jf, (Object)" = (", (Object)(class$org$apache$ws$jaxme$impl$JAXBContextImpl == null ? (class$org$apache$ws$jaxme$impl$JAXBContextImpl = JAXBSchemaSG.class$("org.apache.ws.jaxme.impl.JAXBContextImpl")) : class$org$apache$ws$jaxme$impl$JAXBContextImpl), (Object)") ", (Object)(class$javax$xml$bind$JAXBContext == null ? (class$javax$xml$bind$JAXBContext = JAXBSchemaSG.class$("javax.xml.bind.JAXBContext")) : class$javax$xml$bind$JAXBContext), (Object)".newInstance(", (Object)JavaSource.getQuoted((String)pPackageName), (Object)");");
        JavaMethod newInstanceMethod = js.newJavaMethod("newInstance", class$java$lang$Object == null ? (class$java$lang$Object = JAXBSchemaSG.class$("java.lang.Object")) : class$java$lang$Object, "public");
        newInstanceMethod.addThrows(class$javax$xml$bind$JAXBException == null ? (class$javax$xml$bind$JAXBException = JAXBSchemaSG.class$("javax.xml.bind.JAXBException")) : class$javax$xml$bind$JAXBException);
        Parameter pElementInterface = newInstanceMethod.addParam(class$java$lang$Class == null ? (class$java$lang$Class = JAXBSchemaSG.class$("java.lang.Class")) : class$java$lang$Class, "pElementInterface");
        newInstanceMethod.addLine((Object)"return ", (Object)jf, (Object)".getElement(", (Object)pElementInterface, (Object)");");
        JavaMethod getPropertyMethod = js.newJavaMethod("getProperty", class$java$lang$Object == null ? (class$java$lang$Object = JAXBSchemaSG.class$("java.lang.Object")) : class$java$lang$Object, "public");
        Parameter pName = getPropertyMethod.addParam(class$java$lang$String == null ? (class$java$lang$String = JAXBSchemaSG.class$("java.lang.String")) : class$java$lang$String, "pName");
        getPropertyMethod.addIf((Object)properties, (Object)" == null");
        getPropertyMethod.addLine((Object)"return null;");
        getPropertyMethod.addEndIf();
        getPropertyMethod.addLine((Object)"return ", (Object)properties, (Object)".get(", (Object)pName, (Object)");");
        JavaMethod setPropertyMethod = js.newJavaMethod("setProperty", Void.TYPE, "public");
        pName = setPropertyMethod.addParam(class$java$lang$String == null ? (class$java$lang$String = JAXBSchemaSG.class$("java.lang.String")) : class$java$lang$String, "pName");
        Parameter pValue = setPropertyMethod.addParam(class$java$lang$Object == null ? (class$java$lang$Object = JAXBSchemaSG.class$("java.lang.Object")) : class$java$lang$Object, "pValue");
        setPropertyMethod.addIf((Object)properties, (Object)" == null");
        setPropertyMethod.addLine((Object)properties, (Object)" = new ", (Object)(class$java$util$HashMap == null ? (class$java$util$HashMap = JAXBSchemaSG.class$("java.util.HashMap")) : class$java$util$HashMap), (Object)"();");
        setPropertyMethod.addEndIf();
        setPropertyMethod.addLine((Object)properties, (Object)".put(", (Object)pName, (Object)", ", (Object)pValue, (Object)");");
        HashSet<TypeSG> contextSet = new HashSet<TypeSG>();
        Iterator iter = pContextList.iterator();
        while (iter.hasNext()) {
            TypeSG typeSG;
            Object o = iter.next();
            if (o instanceof ObjectSG) {
                ObjectSG objectSG = (ObjectSG)o;
                typeSG = objectSG.getTypeSG();
                this.generateCreateMethod(js, objectSG.getClassContext());
            } else {
                if (!(o instanceof TypeSG)) continue;
                typeSG = (TypeSG)o;
            }
            if (!typeSG.isComplex() || contextSet.contains(typeSG)) continue;
            this.generateCreateMethod(js, typeSG.getComplexTypeSG().getClassContext());
            contextSet.add(typeSG);
        }
        return js;
    }

    private void generateCreateMethod(JavaSource pSource, Context pContext) {
        JavaQName resultName = pContext.getXMLInterfaceName();
        String className = resultName.getClassName();
        String methodName = "create" + Character.toUpperCase(className.charAt(0)) + className.substring(1);
        JavaMethod createMethod = pSource.newJavaMethod(methodName, resultName, "public");
        createMethod.addThrows(class$javax$xml$bind$JAXBException == null ? (class$javax$xml$bind$JAXBException = JAXBSchemaSG.class$("javax.xml.bind.JAXBException")) : class$javax$xml$bind$JAXBException);
        createMethod.addLine((Object)"return (", (Object)resultName, (Object)") newInstance(", (Object)resultName, (Object)".class);");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

