/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.sg.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.ws.jaxme.generator.sg.ComplexTypeSG;
import org.apache.ws.jaxme.generator.sg.Context;
import org.apache.ws.jaxme.generator.sg.GroupSG;
import org.apache.ws.jaxme.generator.sg.GroupSGChain;
import org.apache.ws.jaxme.generator.sg.ObjectSG;
import org.apache.ws.jaxme.generator.sg.ParticleSG;
import org.apache.ws.jaxme.generator.sg.ParticleSGChain;
import org.apache.ws.jaxme.generator.sg.PropertySG;
import org.apache.ws.jaxme.generator.sg.SGFactory;
import org.apache.ws.jaxme.generator.sg.SGlet;
import org.apache.ws.jaxme.generator.sg.SchemaSG;
import org.apache.ws.jaxme.generator.sg.TypeSG;
import org.apache.ws.jaxme.generator.sg.impl.GlobalContext;
import org.apache.ws.jaxme.generator.sg.impl.JAXBParticleSG;
import org.apache.ws.jaxme.generator.sg.impl.JAXBSGItem;
import org.apache.ws.jaxme.generator.sg.impl.ParticleSGImpl;
import org.apache.ws.jaxme.generator.sg.impl.SerializableSG;
import org.apache.ws.jaxme.js.DirectAccessible;
import org.apache.ws.jaxme.js.JavaComment;
import org.apache.ws.jaxme.js.JavaField;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceFactory;
import org.apache.ws.jaxme.js.LocalJavaField;
import org.apache.ws.jaxme.js.Parameter;
import org.apache.ws.jaxme.js.PlaceHolder;
import org.apache.ws.jaxme.logging.Logger;
import org.apache.ws.jaxme.logging.LoggerAccess;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSObject;
import org.apache.ws.jaxme.xs.XSParticle;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class JAXBGroupSG
extends JAXBSGItem
implements GroupSGChain {
    private static final Logger log = LoggerAccess.getLogger((Class)(class$org$apache$ws$jaxme$generator$sg$impl$JAXBGroupSG == null ? (class$org$apache$ws$jaxme$generator$sg$impl$JAXBGroupSG = JAXBGroupSG.class$("org.apache.ws.jaxme.generator.sg.impl.JAXBGroupSG")) : class$org$apache$ws$jaxme$generator$sg$impl$JAXBGroupSG));
    private ParticleSG[] particles;
    private final boolean isGlobal;
    private final boolean isAll;
    private final boolean isSequence;
    private final boolean isChoice;
    private final Context classContext;
    static /* synthetic */ Class class$org$apache$ws$jaxme$generator$sg$impl$JAXBGroupSG;
    static /* synthetic */ Class class$org$apache$ws$jaxme$impl$JAXBContextImpl;
    static /* synthetic */ Class class$javax$xml$bind$JAXBException;
    static /* synthetic */ Class class$org$apache$ws$jaxme$JMElement;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$org$apache$ws$jaxme$JMXmlSerializer$Data;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$xml$sax$SAXException;
    static /* synthetic */ Class class$org$apache$ws$jaxme$JMHandler$Data;
    static /* synthetic */ Class class$org$apache$ws$jaxme$JMHandler;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$xml$sax$Attributes;
    static /* synthetic */ Class class$java$lang$IllegalStateException;
    static /* synthetic */ Class array$C;

    protected JAXBGroupSG(SGFactory pFactory, SchemaSG pSchema, XSGroup pGroup) throws SAXException {
        super(pFactory, pSchema, (XSObject)pGroup);
        this.isGlobal = true;
        this.isAll = pGroup.isAll();
        this.isSequence = pGroup.isSequence();
        this.isChoice = pGroup.isChoice();
        this.classContext = new GlobalContext(pGroup.getName(), (XSObject)pGroup, null, "Group", pSchema);
    }

    protected JAXBGroupSG(SGFactory pFactory, SchemaSG pSchema, XSGroup pGroup, Context pContext) throws SAXException {
        super(pFactory, pSchema, (XSObject)pGroup);
        this.isGlobal = false;
        this.isAll = pGroup.isAll();
        this.isSequence = pGroup.isSequence();
        this.isChoice = pGroup.isChoice();
        this.classContext = pContext;
    }

    public Object newParticleSG(GroupSG pController, XSParticle pParticle) throws SAXException {
        return new JAXBParticleSG(pController, pParticle, this.classContext);
    }

    public Context getClassContext(GroupSG pController) {
        return this.classContext;
    }

    public SGFactory getFactory(GroupSG pController) {
        return this.getFactory();
    }

    public SchemaSG getSchema(GroupSG pController) {
        return this.getSchema();
    }

    public Locator getLocator(GroupSG pController) {
        return this.getLocator();
    }

    public ParticleSG[] getParticles(GroupSG pController) {
        return this.particles;
    }

    public void init(GroupSG pController) throws SAXException {
        XSParticle[] xsParticles = ((XSGroup)this.getXSObject()).getParticles();
        this.particles = new ParticleSG[xsParticles.length];
        for (int i = 0; i < xsParticles.length; ++i) {
            ParticleSGChain chain = (ParticleSGChain)pController.newParticleSG(xsParticles[i]);
            ParticleSGImpl particle = new ParticleSGImpl(chain);
            particle.init();
            this.particles[i] = particle;
        }
    }

    public boolean isAll(GroupSG pController) {
        return this.isAll;
    }

    public boolean isGlobal(GroupSG pController) {
        return this.isGlobal;
    }

    public boolean isChoice(GroupSG pController) {
        return this.isChoice;
    }

    public boolean isSequence(GroupSG pController) {
        return this.isSequence;
    }

    public JavaSource getXMLInterface(GroupSG pController) throws SAXException {
        JavaQName qName = pController.getClassContext().getXMLInterfaceName();
        JavaSourceFactory jsf = this.getSchema().getJavaSourceFactory();
        JavaSource js = jsf.newJavaSource(qName, JavaSource.PUBLIC);
        js.setType(JavaSource.INTERFACE);
        pController.generateProperties(js);
        return js;
    }

    public JavaSource getXMLImplementation(GroupSG pController) throws SAXException {
        JavaQName qName = pController.getClassContext().getXMLImplementationName();
        JavaSourceFactory jsf = this.getSchema().getJavaSourceFactory();
        JavaSource js = jsf.newJavaSource(qName, JavaSource.PUBLIC);
        js.addImplements(pController.getClassContext().getXMLInterfaceName());
        SerializableSG.makeSerializable(pController.getSchema(), js);
        pController.generateProperties(js);
        return js;
    }

    public void generateProperties(GroupSG pController, JavaSource pSource) throws SAXException {
        String mName = "generateProperties(JavaSource)";
        log.finest("generateProperties(JavaSource)", "->", (Object)pSource.getQName());
        ParticleSG[] myParticles = pController.getParticles();
        for (int i = 0; i < this.particles.length; ++i) {
            ParticleSG particle = myParticles[i];
            if (particle.isElement()) {
                PropertySG elementSG = particle.getPropertySG();
                elementSG.generate(pSource);
                continue;
            }
            if (particle.isGroup()) {
                GroupSG groupSG = particle.getGroupSG();
                groupSG.generateProperties(pSource);
                continue;
            }
            if (particle.isWildcard()) {
                PropertySG wildcardSG = particle.getPropertySG();
                wildcardSG.generate(pSource);
                continue;
            }
            throw new IllegalStateException("Unknown particle type: Neither of element, group, or wildcard");
        }
        log.finest("generateProperties(JavaSource)", "<-");
    }

    public void generateXMLInterfaceSubclasses(GroupSG pController, JavaSource pSource) throws SAXException {
        String mName = "generateSubClasses(JavaSource)";
        log.finest("generateSubClasses(JavaSource)", "->", (Object)pSource.getQName());
        ParticleSG[] myParticles = pController.getParticles();
        for (int i = 0; i < this.particles.length; ++i) {
            ParticleSG particle = myParticles[i];
            if (particle.isElement()) {
                ObjectSG elementSG = particle.getObjectSG();
                TypeSG typeSG = elementSG.getTypeSG();
                if (typeSG.isGlobalType() || !typeSG.isComplex()) continue;
                ComplexTypeSG complexTypeSG = typeSG.getComplexTypeSG();
                complexTypeSG.getXMLInterface(pSource);
                continue;
            }
            if (particle.isGroup()) {
                GroupSG groupSG = particle.getGroupSG();
                groupSG.generateXMLInterfaceSubclasses(pSource);
                continue;
            }
            if (particle.isWildcard()) continue;
            throw new IllegalStateException("Unknown particle type: Neither of element, group, or wildcard");
        }
        log.finest("generateSubClasses(JavaSource)", "<-");
    }

    public void generateXMLImplementationSubclasses(GroupSG pController, JavaSource pSource) throws SAXException {
        String mName = "generateSubClasses(JavaSource,JavaQName)";
        log.finest("generateSubClasses(JavaSource,JavaQName)", "->", new Object[]{pSource.getQName()});
        ParticleSG[] myParticles = pController.getParticles();
        for (int i = 0; i < this.particles.length; ++i) {
            ParticleSG particle = myParticles[i];
            if (particle.isElement()) {
                ObjectSG elementSG = particle.getObjectSG();
                TypeSG typeSG = elementSG.getTypeSG();
                if (typeSG.isGlobalType() || !typeSG.isComplex()) continue;
                ComplexTypeSG complexTypeSG = typeSG.getComplexTypeSG();
                complexTypeSG.getXMLImplementation(pSource);
                continue;
            }
            if (particle.isGroup()) {
                GroupSG groupSG = particle.getGroupSG();
                groupSG.generateXMLImplementationSubclasses(pSource);
                continue;
            }
            if (particle.isWildcard()) continue;
            throw new IllegalStateException("Unknown particle type: Neither of element, group, or wildcard");
        }
        log.finest("generateSubClasses(JavaSource,JavaQName)", "<-");
    }

    private String getXMLSerializersFieldName(PropertySG pChild) throws SAXException {
        return "__ser_" + pChild.getXMLFieldName();
    }

    private JavaMethod getXMLSerializersInitMethod(GroupSG pController, JavaSource pSource) throws SAXException {
        ParticleSG[] myParticles = pController.getParticles();
        JavaMethod jm = null;
        Parameter pFactory = null;
        for (int i = 0; i < myParticles.length; ++i) {
            ObjectSG child;
            ParticleSG particle = myParticles[i];
            if (!particle.isElement() || !(child = particle.getObjectSG()).getTypeSG().isComplex()) continue;
            if (jm == null) {
                jm = pSource.newJavaMethod("init", JavaQNameImpl.VOID, JavaSource.PUBLIC);
                pFactory = jm.addParam(class$org$apache$ws$jaxme$impl$JAXBContextImpl == null ? JAXBGroupSG.class$("org.apache.ws.jaxme.impl.JAXBContextImpl") : class$org$apache$ws$jaxme$impl$JAXBContextImpl, "pFactory");
                jm.addLine((Object)"super.init(", (Object)pFactory, (Object)");");
                jm.addThrows(class$javax$xml$bind$JAXBException == null ? JAXBGroupSG.class$("javax.xml.bind.JAXBException") : class$javax$xml$bind$JAXBException);
            }
            String serializerName = this.getXMLSerializersFieldName(particle.getPropertySG());
            Context myClassContext = child.getTypeSG().getComplexTypeSG().getClassContext();
            JavaQName serializerClass = myClassContext.getXMLSerializerName();
            JavaField jf = pSource.newJavaField(serializerName, serializerClass, JavaSource.PRIVATE);
            JavaQName elementInterface = myClassContext.getXMLInterfaceName();
            if (child.getTypeSG().isGlobalClass()) {
                jm.addLine((Object)jf, (Object)" = (", (Object)serializerClass, (Object)") ", (Object)pFactory, (Object)".getJMXmlSerializer(", (Object)elementInterface, (Object)".class);");
            } else {
                jm.addLine((Object)jf, (Object)" = new ", (Object)serializerClass, (Object)"();");
            }
            jm.addLine((Object)jf, (Object)".init(pFactory);");
        }
        return jm;
    }

    private JavaMethod getXMLSerializersMarshalChildsMethod(GroupSG pController, JavaSource pSource) throws SAXException {
        String mName = "getXMLSerializersMarshalChildsMethod";
        log.finest("getXMLSerializersMarshalChildsMethod", "->", (Object)pSource.getQName());
        ParticleSG[] myParticles = pController.getParticles();
        JavaMethod jm = null;
        LocalJavaField pElement = null;
        XMLSerializersMarshalChildsSGlet sgLet = null;
        for (int i = 0; i < myParticles.length; ++i) {
            ParticleSG particle = myParticles[i];
            if (jm == null) {
                jm = pSource.newJavaMethod("marshalChilds", JavaQNameImpl.VOID, JavaSource.PROTECTED);
                Parameter pData = jm.addParam(JavaQNameImpl.getInstance((Class)(class$org$apache$ws$jaxme$JMXmlSerializer$Data == null ? JAXBGroupSG.class$("org.apache.ws.jaxme.JMXmlSerializer$Data") : class$org$apache$ws$jaxme$JMXmlSerializer$Data)), "pData");
                sgLet = new XMLSerializersMarshalChildsSGlet((DirectAccessible)pData);
                JavaQName elementInterface = pController.getClassContext().getXMLInterfaceName();
                Parameter pObject = jm.addParam(class$java$lang$Object == null ? JAXBGroupSG.class$("java.lang.Object") : class$java$lang$Object, "pObject");
                pElement = jm.newJavaField(elementInterface);
                pElement.addLine((Object)"(", (Object)elementInterface, (Object)") ", (Object)pObject);
                jm.addThrows(class$org$xml$sax$SAXException == null ? JAXBGroupSG.class$("org.xml.sax.SAXException") : class$org$xml$sax$SAXException);
            }
            if (!particle.isElement()) {
                return jm;
            }
            sgLet.setChild(particle);
            sgLet.setFieldName(this.getXMLSerializersFieldName(particle.getPropertySG()));
            particle.getPropertySG().forAllNonNullValues(jm, (DirectAccessible)pElement, sgLet);
        }
        log.finest("getXMLSerializersMarshalChildsMethod", "<-");
        return jm;
    }

    public void generateXMLSerializersElements(GroupSG pController, JavaSource pSource) throws SAXException {
        String mName = "generateXMLSerializersElements";
        log.finest("generateXMLSerializersElements", "->", (Object)pSource.getQName());
        this.getXMLSerializersInitMethod(pController, pSource);
        this.getXMLSerializersMarshalChildsMethod(pController, pSource);
        ParticleSG[] myParticles = pController.getParticles();
        for (int i = 0; i < myParticles.length; ++i) {
            ObjectSG objectSG;
            TypeSG typeSG;
            ParticleSG particle = myParticles[i];
            if (!particle.isElement() || !(typeSG = (objectSG = particle.getObjectSG()).getTypeSG()).isComplex() || typeSG.isGlobalClass()) continue;
            typeSG.getComplexTypeSG().getXMLSerializer(pSource);
        }
        log.finest("generateXMLSerializersElements", "<-");
    }

    private void getXMLHandlersElements(GroupSG pController, JavaSource pSource) throws SAXException {
        ParticleSG[] myParticles = pController.getParticles();
        for (int i = 0; i < myParticles.length; ++i) {
            ObjectSG objectSG;
            TypeSG typeSG;
            ParticleSG particle = myParticles[i];
            if (!particle.isElement() || !(typeSG = (objectSG = particle.getObjectSG()).getTypeSG()).isComplex() || typeSG.isGlobalClass()) continue;
            typeSG.getComplexTypeSG().getXMLHandler(pSource);
        }
    }

    private String getXMLHandlersMethodName(PropertySG pPropertySG) throws SAXException {
        String f = pPropertySG.getXMLFieldName();
        return "getHandlerFor" + Character.toUpperCase(f.charAt(0)) + f.substring(1);
    }

    private JavaMethod getXMLHandlersInitMethod(GroupSG pController, JavaSource pSource) throws SAXException {
        JavaMethod jm = null;
        Parameter pData = null;
        ParticleSG[] myParticles = pController.getParticles();
        for (int i = 0; i < myParticles.length; ++i) {
            ObjectSG objectSG;
            TypeSG typeSG;
            ParticleSG particle = myParticles[i];
            if (!particle.isElement() || !(typeSG = (objectSG = particle.getObjectSG()).getTypeSG()).isComplex()) continue;
            if (jm == null) {
                jm = pSource.newJavaMethod("init", JavaQNameImpl.VOID, JavaSource.PUBLIC);
                pData = jm.addParam(class$org$apache$ws$jaxme$JMHandler$Data == null ? JAXBGroupSG.class$("org.apache.ws.jaxme.JMHandler$Data") : class$org$apache$ws$jaxme$JMHandler$Data, "pData");
                jm.addThrows(class$javax$xml$bind$JAXBException == null ? JAXBGroupSG.class$("javax.xml.bind.JAXBException") : class$javax$xml$bind$JAXBException);
                jm.addLine((Object)"super.init(", (Object)pData, (Object)");");
            }
            String f = particle.getPropertySG().getXMLFieldName();
            String handlerFieldName = "__handler_" + f;
            String handlerMethodName = this.getXMLHandlersMethodName(particle.getPropertySG());
            JavaField jf = pSource.newJavaField(handlerFieldName, class$org$apache$ws$jaxme$JMHandler == null ? JAXBGroupSG.class$("org.apache.ws.jaxme.JMHandler") : class$org$apache$ws$jaxme$JMHandler, JavaSource.PRIVATE);
            JavaMethod jm2 = pSource.newJavaMethod(handlerMethodName, class$org$apache$ws$jaxme$JMHandler == null ? JAXBGroupSG.class$("org.apache.ws.jaxme.JMHandler") : class$org$apache$ws$jaxme$JMHandler, "protected");
            jm2.addThrows(class$org$xml$sax$SAXException == null ? JAXBGroupSG.class$("org.xml.sax.SAXException") : class$org$xml$sax$SAXException);
            jm2.addIf((Object)handlerFieldName, (Object)" == null");
            ComplexTypeSG childSG = typeSG.getComplexTypeSG();
            JavaQName interfaceName = childSG.getClassContext().getXMLInterfaceName();
            JavaQName handlerClassName = childSG.getClassContext().getXMLHandlerName();
            jm2.addTry();
            if (typeSG.isGlobalClass()) {
                jm2.addLine((Object)handlerFieldName, (Object)" = getData().getFactory().getJMHandler(", (Object)interfaceName, (Object)".class);");
            } else {
                jm2.addLine((Object)jf, (Object)" = new ", (Object)handlerClassName, (Object)"();");
            }
            jm2.addLine((Object)jf, (Object)".init(getData());");
            DirectAccessible e = jm2.addCatch(class$javax$xml$bind$JAXBException == null ? JAXBGroupSG.class$("javax.xml.bind.JAXBException") : class$javax$xml$bind$JAXBException);
            jm2.addThrowNew(class$org$xml$sax$SAXException == null ? JAXBGroupSG.class$("org.xml.sax.SAXException") : class$org$xml$sax$SAXException, (Object)e);
            jm2.addEndTry();
            jm2.addEndIf();
            jm2.addLine((Object)"return ", (Object)jf, (Object)";");
            jm.addIf((Object)jf, (Object)" != null");
            jm.addLine((Object)jf, (Object)".init(", (Object)pData, (Object)");");
            jm.addEndIf();
        }
        return jm;
    }

    private JavaField getXMLHandlersStateField(GroupSG pController, JavaSource pSource) throws SAXException {
        ParticleSG[] myParticles = pController.getParticles();
        if (myParticles.length > 0) {
            JavaField jf = pSource.newJavaField("__state", Integer.TYPE, JavaSource.PRIVATE);
            JavaComment jc = jf.newComment();
            jc.addLine("The current state. The following values are valid states:");
            jc.addLine(" 0 = Before parsing the element");
            jc.addLine(" 1 = Parsing an unknown element");
            jc.addLine(" 2 = After parsing the element");
            for (int i = 0; i < myParticles.length; ++i) {
                ParticleSG particle = myParticles[i];
                if (particle.isGroup()) continue;
                if (particle.isElement()) {
                    jc.addLine(" " + (3 + i) + " = While parsing the child element " + myParticles[i].getObjectSG().getName());
                    continue;
                }
                if (particle.isWildcard()) {
                    jc.addLine(" " + (3 + i) + " = While parsing the wildcard");
                    continue;
                }
                throw new IllegalStateException("Invalid particle type.");
            }
            JavaMethod[] methods = pSource.getMethods();
            boolean ok = false;
            for (int i = 0; i < methods.length; ++i) {
                if (!"startDocument".equals(methods[i].getName())) continue;
                methods[i].addLine((Object)jf, (Object)" = 0;");
                ok = true;
                break;
            }
            if (!ok) {
                throw new IllegalStateException("Unable to find the handlers 'startDocument' method.");
            }
            return jf;
        }
        return null;
    }

    private JavaField getXMLHandlersHandlerField(GroupSG pController, JavaSource pSource) throws SAXException {
        ParticleSG[] myParticles = pController.getParticles();
        if (myParticles.length > 0) {
            JavaField jf = pSource.newJavaField("__handler", class$org$apache$ws$jaxme$JMHandler == null ? (class$org$apache$ws$jaxme$JMHandler = JAXBGroupSG.class$("org.apache.ws.jaxme.JMHandler")) : class$org$apache$ws$jaxme$JMHandler, JavaSource.PRIVATE);
            jf.newComment().addLine("The current handler for parsing child elements or simple content.");
            return jf;
        }
        return null;
    }

    private void extendXMLHandlersStartDocumentMethod(GroupSG pController, JavaSource pSource, DirectAccessible pStateVar, DirectAccessible pHandlerVar) throws SAXException {
        JavaMethod[] methods = pSource.getMethods();
        boolean ok = false;
        for (int i = 0; i < methods.length; ++i) {
            if (!"startDocument".equals(methods[i].getName())) continue;
            methods[i].addLine((Object)pStateVar, (Object)" = 0;");
            methods[i].addLine((Object)pHandlerVar, (Object)" = null;");
            ok = true;
            break;
        }
        if (!ok) {
            throw new IllegalStateException("Unable to find the handlers 'startDocument' method.");
        }
    }

    private void extendXMLHandlersStartElementMethodAddNamespace(GroupSG pController, DirectAccessible pHandlerVar, DirectAccessible pStateVar, JavaMethod pMethod, String pURI, Parameter pNamespaceURI, Parameter pQName, Parameter pLocalName, Parameter pAttr, ParticleSG[] pParticles) throws SAXException {
        boolean first = true;
        for (int j = 0; j < pParticles.length; ++j) {
            XsQName name;
            ParticleSG child = pParticles[j];
            if (!child.isElement() || !(name = child.getObjectSG().getName()).getNamespaceURI().equals(pURI)) continue;
            pMethod.addIf(first, (Object)JavaSource.getQuoted((String)name.getLocalName()), (Object)".equals(", (Object)pLocalName, (Object)")");
            first = false;
            ArrayList<Integer> validStates = new ArrayList<Integer>();
            if (child.isMultiple()) {
                validStates.add(new Integer(j + 3));
            }
            if (pController.isChoice()) {
                validStates.add(new Integer(0));
            } else if (pController.isSequence()) {
                boolean stateZeroIsValid = true;
                for (int k = j - 1; k >= 0; --k) {
                    ParticleSG kChild = pParticles[k];
                    validStates.add(new Integer(k + 3));
                    if (kChild.getMinOccurs() <= 0) continue;
                    stateZeroIsValid = false;
                    break;
                }
                if (stateZeroIsValid) {
                    validStates.add(new Integer(0));
                }
            } else if (pController.isAll()) {
                validStates.add(new Integer(0));
                for (int k = 0; k < pParticles.length; ++k) {
                    validStates.add(new Integer(k));
                }
            } else {
                throw new IllegalStateException("Don't know how to handle type which is neither sequence nor choice, or all.");
            }
            Collections.sort(validStates);
            pMethod.addSwitch((Object)pStateVar);
            for (int k = 0; k < validStates.size(); ++k) {
                pMethod.addCase(validStates.get(k));
            }
            pMethod.addLine((Object)pStateVar, (Object)(" = " + (j + 3) + ";"));
            if (child.getObjectSG().getTypeSG().isComplex()) {
                String handlerMethodName = this.getXMLHandlersMethodName(child.getPropertySG());
                pMethod.addLine((Object)pHandlerVar, (Object)" = ", (Object)handlerMethodName, (Object)"();");
            } else {
                pMethod.addLine((Object)pHandlerVar, (Object)" = getData().getAtomicHandler();");
            }
            pMethod.addLine((Object)pHandlerVar, (Object)".startDocument();");
            pMethod.addLine((Object)pHandlerVar, (Object)".startElement(pNamespaceURI, pLocalName, pQName, pAttr);");
            pMethod.addBreak();
            pMethod.addDefault();
            pMethod.addLine((Object)"super.startElement(", (Object)pNamespaceURI, (Object)", ", (Object)pLocalName, (Object)", ", (Object)pQName, (Object)", ", (Object)pAttr, (Object)");");
            pMethod.addBreak();
            pMethod.addEndSwitch();
        }
        if (!first) {
            pMethod.addElse();
        }
        pMethod.addLine((Object)"super.startElement(", (Object)pNamespaceURI, (Object)", ", (Object)pLocalName, (Object)", ", (Object)pQName, (Object)", ", (Object)pAttr, (Object)");");
        if (!first) {
            pMethod.addEndIf();
        }
    }

    private void extendXMLHandlersStartElementMethod(GroupSG pController, JavaSource pSource, DirectAccessible pStateVar, DirectAccessible pHandlerVar) throws SAXException {
        JavaQName ATTRIBUTES_TYPE;
        ParticleSG[] myParticles = pController.getParticles();
        if (myParticles.length == 0) {
            return;
        }
        JavaQName STRING_TYPE = JavaQNameImpl.getInstance((Class)(class$java$lang$String == null ? (class$java$lang$String = JAXBGroupSG.class$("java.lang.String")) : class$java$lang$String));
        JavaMethod jm = pSource.getMethod("startElement", new JavaQName[]{STRING_TYPE, STRING_TYPE, STRING_TYPE, ATTRIBUTES_TYPE = JavaQNameImpl.getInstance((Class)(class$org$xml$sax$Attributes == null ? (class$org$xml$sax$Attributes = JAXBGroupSG.class$("org.xml.sax.Attributes")) : class$org$xml$sax$Attributes))});
        if (jm == null) {
            throw new IllegalStateException("No such method: 'startElement' in '" + pSource.getQName() + "'.");
        }
        PlaceHolder placeHolder = jm.getPlaceHolder("GroupSG");
        if (placeHolder == null) {
            throw new IllegalStateException("No such placeholder: 'GroupSG' in method 'startElement'");
        }
        placeHolder.remove();
        Parameter[] parameters = jm.getParams();
        Parameter pNamespaceURI = parameters[0];
        Parameter pLocalName = parameters[1];
        Parameter pQName = parameters[2];
        Parameter pAttr = parameters[3];
        jm.addCase((Object)"1");
        HashSet<String> namespaces = new HashSet<String>();
        for (int i = 0; i < myParticles.length; ++i) {
            ParticleSG child = myParticles[i];
            if (child.isGroup()) continue;
            if (child.isWildcard()) {
                throw new IllegalStateException("Wildcards aren't implemented yet.");
            }
            if (child.isElement()) {
                namespaces.add(child.getObjectSG().getName().getNamespaceURI());
                continue;
            }
            throw new IllegalStateException("Unknown particle type");
        }
        boolean firstNamespace = true;
        Iterator iter = namespaces.iterator();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            if ("".equals(uri)) {
                jm.addIf(firstNamespace, (Object)pNamespaceURI, (Object)" == null  ||  ", (Object)pNamespaceURI, (Object)".length() == 0");
            } else {
                jm.addIf(firstNamespace, (Object)JavaSource.getQuoted((String)uri), (Object)".equals(", (Object)pNamespaceURI, (Object)")");
            }
            firstNamespace = false;
            this.extendXMLHandlersStartElementMethodAddNamespace(pController, pHandlerVar, pStateVar, jm, uri, pNamespaceURI, pQName, pLocalName, pAttr, myParticles);
        }
        if (!firstNamespace) {
            jm.addElse();
        }
        jm.addLine((Object)"super.startElement(", (Object)pNamespaceURI, (Object)", ", (Object)pLocalName, (Object)", ", (Object)pQName, (Object)", ", (Object)pAttr, (Object)");");
        if (!firstNamespace) {
            jm.addEndIf();
        }
        jm.addBreak();
        jm.addDefault();
        jm.addIf((Object)pHandlerVar, (Object)" == null");
        jm.addLine((Object)"super.startElement(", (Object)pNamespaceURI, (Object)", ", (Object)pLocalName, (Object)", ", (Object)pQName, (Object)", ", (Object)pAttr, (Object)");");
        jm.addElse();
        jm.addLine((Object)pHandlerVar, (Object)".startElement(", (Object)pNamespaceURI, (Object)", ", (Object)pLocalName, (Object)", ", (Object)pQName, (Object)", ", (Object)pAttr, (Object)");");
        jm.addEndIf();
    }

    public JavaMethod getXMLHandlersEndElementMethod(GroupSG pController, JavaSource pSource, DirectAccessible pLevelVar, DirectAccessible pStateVar, DirectAccessible pHandlerVar) throws SAXException {
        ParticleSG[] myParticles = pController.getParticles();
        if (myParticles.length == 0) {
            return null;
        }
        JavaMethod jm = pSource.newJavaMethod("endElement", JavaQNameImpl.VOID, JavaSource.PUBLIC);
        Parameter pNamespaceURI = jm.addParam(class$java$lang$String == null ? (class$java$lang$String = JAXBGroupSG.class$("java.lang.String")) : class$java$lang$String, "pNamespaceURI");
        Parameter pLocalName = jm.addParam(class$java$lang$String == null ? (class$java$lang$String = JAXBGroupSG.class$("java.lang.String")) : class$java$lang$String, "pLocalName");
        Parameter pQName = jm.addParam(class$java$lang$String == null ? (class$java$lang$String = JAXBGroupSG.class$("java.lang.String")) : class$java$lang$String, "pQName");
        jm.addThrows(class$org$xml$sax$SAXException == null ? (class$org$xml$sax$SAXException = JAXBGroupSG.class$("org.xml.sax.SAXException")) : class$org$xml$sax$SAXException);
        jm.addIf((Object)pHandlerVar, (Object)" == null");
        jm.addIf((Object)pLevelVar, (Object)" > 1");
        jm.addLine((Object)"super.endElement(", (Object)pNamespaceURI, (Object)", ", (Object)pLocalName, (Object)", ", (Object)pQName, (Object)");");
        jm.addEndIf();
        jm.addElse();
        jm.addLine((Object)pHandlerVar, (Object)".endElement(", (Object)pNamespaceURI, (Object)", ", (Object)pLocalName, (Object)", ", (Object)pQName, (Object)");");
        jm.addEndIf();
        jm.addSwitch((Object)"--", (Object)pLevelVar);
        jm.addCase((Object)"0");
        jm.addBreak();
        jm.addCase((Object)"1");
        JavaQName elementInterface = pController.getClassContext().getXMLInterfaceName();
        LocalJavaField element = jm.newJavaField(elementInterface);
        element.addLine((Object)"(", (Object)elementInterface, (Object)") getResult()");
        jm.addSwitch((Object)pStateVar);
        for (int i = 0; i < myParticles.length; ++i) {
            Object v;
            JavaQName type;
            ParticleSG child = myParticles[i];
            if (myParticles[i].isGroup()) continue;
            ObjectSG osg = child.getObjectSG();
            TypeSG childType = osg.getTypeSG();
            jm.addCase((Object)Integer.toString(3 + i));
            jm.addIf((Object)pHandlerVar, (Object)" != null");
            jm.addLine((Object)pHandlerVar, (Object)".endDocument();");
            jm.addEndIf();
            if (childType.isComplex()) {
                type = childType.getComplexTypeSG().getClassContext().getXMLInterfaceName();
                v = new Object[]{pHandlerVar, ".getResult()"};
            } else {
                Object castedValue;
                type = null;
                v = new Object[]{"(", class$java$lang$String == null ? JAXBGroupSG.class$("java.lang.String") : class$java$lang$String, ") ", pHandlerVar, ".getResult()"};
                if (v == (castedValue = childType.getSimpleTypeSG().getCastFromString(jm, v, "getData()"))) {
                    v = new Object[]{pHandlerVar, ".getResult()"};
                    type = JavaQNameImpl.getInstance((Class)(class$java$lang$String == null ? JAXBGroupSG.class$("java.lang.String") : class$java$lang$String));
                } else {
                    v = castedValue;
                    type = null;
                }
            }
            child.getPropertySG().addValue(jm, (DirectAccessible)element, v, type);
            jm.addBreak();
        }
        jm.addDefault();
        jm.addThrowNew(class$java$lang$IllegalStateException == null ? (class$java$lang$IllegalStateException = JAXBGroupSG.class$("java.lang.IllegalStateException")) : class$java$lang$IllegalStateException, (Object)JavaSource.getQuoted((String)"Illegal state: "), (Object)" + ", (Object)pStateVar);
        jm.addEndSwitch();
        jm.addEndSwitch();
        return jm;
    }

    public JavaMethod getXMLHandlersCharactersMethod(GroupSG pController, JavaSource pSource, DirectAccessible pHandlerVar) throws SAXException {
        JavaMethod jm = pSource.newJavaMethod("characters", JavaQNameImpl.VOID, JavaSource.PUBLIC);
        Parameter pChars = jm.addParam(array$C == null ? (array$C = JAXBGroupSG.class$("[C")) : array$C, "pChars");
        Parameter pOffset = jm.addParam(Integer.TYPE, "pOffset");
        Parameter pLen = jm.addParam(Integer.TYPE, "pLen");
        jm.addThrows(class$org$xml$sax$SAXException == null ? (class$org$xml$sax$SAXException = JAXBGroupSG.class$("org.xml.sax.SAXException")) : class$org$xml$sax$SAXException);
        jm.addIf((Object)pHandlerVar, (Object)" == null");
        jm.addLine((Object)"super.characters(", (Object)pChars, (Object)", ", (Object)pOffset, (Object)", ", (Object)pLen, (Object)");");
        jm.addElse();
        jm.addLine((Object)pHandlerVar, (Object)".characters(", (Object)pChars, (Object)", ", (Object)pOffset, (Object)", ", (Object)pLen, (Object)");");
        jm.addEndIf();
        return jm;
    }

    public void generateXMLHandlersElements(GroupSG pController, JavaSource pSource, DirectAccessible pLevelVar) throws SAXException {
        JavaField stateVar = this.getXMLHandlersStateField(pController, pSource);
        JavaField handlerVar = this.getXMLHandlersHandlerField(pController, pSource);
        this.extendXMLHandlersStartDocumentMethod(pController, pSource, (DirectAccessible)stateVar, (DirectAccessible)handlerVar);
        this.extendXMLHandlersStartElementMethod(pController, pSource, (DirectAccessible)stateVar, (DirectAccessible)handlerVar);
        this.getXMLHandlersEndElementMethod(pController, pSource, pLevelVar, (DirectAccessible)stateVar, (DirectAccessible)handlerVar);
        this.getXMLHandlersCharactersMethod(pController, pSource, (DirectAccessible)handlerVar);
        this.getXMLHandlersElements(pController, pSource);
        this.getXMLHandlersInitMethod(pController, pSource);
    }

    public void generate(GroupSG pController) throws SAXException {
        String mName = "generate";
        log.finest("generate", "->", (Object)(pController.isGlobal() ? pController.getClassContext().toString() : "Local group"));
        log.finest("generate", "<-");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class XMLSerializersMarshalChildsSGlet
    implements SGlet.TypedSGlet {
        private ParticleSG child;
        private String fieldName;
        private final DirectAccessible data;

        public XMLSerializersMarshalChildsSGlet(DirectAccessible pData) {
            this.data = pData;
        }

        public void setChild(ParticleSG pChild) {
            this.child = pChild;
        }

        public JavaQName getType() {
            if (this.child.getObjectSG().getTypeSG().isComplex()) {
                return JavaQNameImpl.getInstance((Class)(class$org$apache$ws$jaxme$JMElement == null ? (class$org$apache$ws$jaxme$JMElement = JAXBGroupSG.class$("org.apache.ws.jaxme.JMElement")) : class$org$apache$ws$jaxme$JMElement));
            }
            return null;
        }

        public void setFieldName(String pFieldName) {
            this.fieldName = pFieldName;
        }

        public boolean isCasting() {
            return !this.child.getObjectSG().getTypeSG().isComplex();
        }

        public void generate(JavaMethod pMethod, Object pValue) throws SAXException {
            ObjectSG objectSG = this.child.getObjectSG();
            JavaField f = pMethod.getJavaSource().newJavaField(this.fieldName + "_qname", class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = JAXBGroupSG.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
            f.setStatic(true);
            f.setFinal(true);
            f.addLine((Object)"new ", (Object)(class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = JAXBGroupSG.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName), (Object)"(", (Object)JavaSource.getQuoted((String)objectSG.getName().getNamespaceURI()), (Object)", ", (Object)JavaSource.getQuoted((String)objectSG.getName().getLocalName()), (Object)");");
            if (objectSG.getTypeSG().isComplex()) {
                pMethod.addLine((Object)this.fieldName, (Object)".marshal(", (Object)this.data, (Object)", ", (Object)f, (Object)", ", pValue, (Object)");");
            } else {
                Object v = this.child.getObjectSG().getTypeSG().getSimpleTypeSG().getCastToString(pMethod, pValue, this.data);
                pMethod.addLine((Object)"marshalAtomicChild(", (Object)this.data, (Object)", ", (Object)f, (Object)", ", v, (Object)");");
            }
        }
    }
}

