/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.oracle;

import org.apache.ws.jaxme.sqls.ColumnReference;
import org.apache.ws.jaxme.sqls.JoinReference;
import org.apache.ws.jaxme.sqls.SelectStatement;
import org.apache.ws.jaxme.sqls.SelectTableReference;
import org.apache.ws.jaxme.sqls.impl.SQLGeneratorImpl;
import org.apache.ws.jaxme.sqls.impl.SelectStatementMetaData;
import org.apache.ws.jaxme.sqls.oracle.OraJoinReferenceImpl;
import org.apache.ws.jaxme.sqls.oracle.OraSQLGenerator;
import org.apache.ws.jaxme.sqls.oracle.OraSelectStatement;
import org.apache.ws.jaxme.sqls.oracle.OraSelectStatementMetaData;

public class OraSQLGeneratorImpl
extends SQLGeneratorImpl
implements OraSQLGenerator {
    private boolean isOracle8Compatibility;

    protected boolean isTableAliasUsingAs() {
        return false;
    }

    public void setOracle8Compatibility(boolean pOracle8Compatibility) {
        this.isOracle8Compatibility = pOracle8Compatibility;
    }

    public boolean isOracle8Compatibility() {
        return this.isOracle8Compatibility;
    }

    protected SelectStatementMetaData newSelectStatementMetaData(SelectStatement pQuery) {
        return new OraSelectStatementMetaData(pQuery);
    }

    protected String getSelectQueryFromClause(SelectStatement pQuery, SelectStatementMetaData pData) {
        if (this.isOracle8Compatibility()) {
            SelectTableReference tableReference = pQuery.getSelectTableReference();
            if (tableReference == null) {
                return super.getSelectQueryFromClause(pQuery, pData);
            }
            StringBuffer sb = new StringBuffer(" FROM ");
            sb.append(this.getTableAlias(pData, tableReference));
            for (JoinReference joinReference = tableReference.getRightJoinedTableReference(); joinReference != null; joinReference = joinReference.getRightJoinedTableReference()) {
                sb.append(", ");
                sb.append(this.getTableAlias(pData, joinReference));
            }
            return sb.toString();
        }
        return super.getSelectQueryFromClause(pQuery, pData);
    }

    protected String getSelectQueryConstraints(SelectStatement pQuery, SelectStatementMetaData pData, SelectStatementMetaData.LocalData pLocalData) {
        String result;
        if (this.isOracle8Compatibility()) {
            SelectTableReference tableReference = pQuery.getSelectTableReference();
            if (tableReference == null) {
                result = super.getSelectQuery(pQuery, pData);
            } else {
                StringBuffer sb = new StringBuffer();
                for (JoinReference joinReference = tableReference.getRightJoinedTableReference(); joinReference != null; joinReference = joinReference.getRightJoinedTableReference()) {
                    String onClause;
                    OraJoinReferenceImpl oraJoin = null;
                    if (joinReference instanceof OraJoinReferenceImpl) {
                        oraJoin = (OraJoinReferenceImpl)joinReference;
                    }
                    if (oraJoin == null) {
                        onClause = this.getWhereClause(pData, joinReference.getOn());
                    } else {
                        oraJoin.setIsOracle8LeftOuterJoin(true);
                        onClause = this.getWhereClause(pData, joinReference.getOn());
                        oraJoin.setIsOracle8LeftOuterJoin(false);
                    }
                    if (onClause == null || onClause.length() <= 0) continue;
                    if (pLocalData.hasWhereClause()) {
                        sb.append(" AND ");
                    } else {
                        pLocalData.setWhereClause(true);
                    }
                    sb.append(onClause);
                }
                String whereClause = this.getWhereClause(pData, pQuery.getWhere());
                if (whereClause != null && whereClause.length() > 0) {
                    if (pLocalData.hasWhereClause()) {
                        sb.append(" AND ");
                    } else {
                        pLocalData.setWhereClause(true);
                    }
                    sb.append(whereClause);
                }
                result = sb.toString();
            }
        } else {
            result = super.getSelectQuery(pQuery, pData);
        }
        if (pQuery instanceof OraSelectStatement) {
            OraSelectStatement oraStatement = (OraSelectStatement)pQuery;
            String s = this.getWhereClause(pData, oraStatement.getStartWith());
            if (s != null && s.length() > 0) {
                result = result + " START WITH " + s;
            }
            if ((s = this.getWhereClause(pData, oraStatement.getConnectByPrior())) != null && s.length() > 0) {
                result = result + " CONNECT BY PRIOR " + s;
            }
        }
        return result;
    }

    protected String getColumnAlias(SelectStatementMetaData pData, ColumnReference pColumn) {
        OraJoinReferenceImpl oraJoin;
        String s = super.getColumnAlias(pData, pColumn);
        if (pColumn.getTableReference() instanceof OraJoinReferenceImpl && (oraJoin = (OraJoinReferenceImpl)pColumn.getTableReference()).isOracle8LeftOuterJoin()) {
            return s + "(+)";
        }
        return s;
    }
}

