/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.ColumnReference;
import org.apache.ws.jaxme.sqls.Statement;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.TableReference;
import org.apache.ws.jaxme.sqls.impl.ColumnImpl;
import org.apache.ws.jaxme.sqls.impl.ColumnReferenceImpl;
import org.apache.ws.jaxme.sqls.impl.TableImpl;

public class TableReferenceImpl
implements TableReference {
    private Statement statement;
    private Table table;
    private Table.Name alias;
    private List columnReferences = new ArrayList();

    TableReferenceImpl(Statement pStatement, Table pTable) {
        this.statement = pStatement;
        this.table = pTable;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public Table getTable() {
        return this.table;
    }

    public Table.Name getAlias() {
        return this.alias;
    }

    public void setAlias(Table.Name pName) {
        this.alias = pName;
    }

    public void setAlias(String pName) {
        this.setAlias(new TableImpl.NameImpl(pName));
    }

    public ColumnReference newColumnReference(String pName) {
        return this.newColumnReference(new ColumnImpl.NameImpl(pName));
    }

    public ColumnReference newColumnReference(Column.Name pName) {
        Column column = this.getTable().getColumn(pName);
        if (column == null) {
            throw new NullPointerException("Unknown column name in table " + this.getTable().getName() + ": " + pName);
        }
        return this.newColumnReference(column);
    }

    public ColumnReference newColumnReference(Column pColumn) {
        ColumnReferenceImpl columnReference = new ColumnReferenceImpl(this, pColumn);
        this.columnReferences.add(columnReference);
        return columnReference;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TableReference)) {
            return false;
        }
        TableReference ref = (TableReference)o;
        return ref.getStatement().equals(this.getStatement()) && ref.getTable().equals(this.getTable());
    }

    public int hashCode() {
        return this.getStatement().hashCode() + this.getTable().hashCode();
    }
}

