/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ws.jaxme.sqls.BooleanConstraint;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.ColumnReference;
import org.apache.ws.jaxme.sqls.CombinedConstraint;
import org.apache.ws.jaxme.sqls.Function;
import org.apache.ws.jaxme.sqls.JoinReference;
import org.apache.ws.jaxme.sqls.Parts;
import org.apache.ws.jaxme.sqls.RawSQLCode;
import org.apache.ws.jaxme.sqls.SelectStatement;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.TableReference;
import org.apache.ws.jaxme.sqls.Value;
import org.apache.ws.jaxme.sqls.impl.ViewImpl;
import org.apache.ws.jaxme.sqls.impl.VirtualColumn;

public class SelectStatementMetaData {
    private final Map aliases = new HashMap();
    private final Map columnNames = new HashMap();
    private final List tables = new ArrayList();

    public SelectStatementMetaData(SelectStatement pQuery) {
        this.addSelectStatement(pQuery);
        this.createTableAliases();
        this.createColumnNames();
    }

    protected void addSelectStatement(SelectStatement pQuery) {
        Iterator tableIter = pQuery.getSelectTableReferences();
        while (tableIter.hasNext()) {
            TableReference tableReference = (TableReference)tableIter.next();
            Table t = tableReference.getTable();
            Table.Name alias = tableReference.getAlias();
            if (alias != null) {
                if (this.aliases.containsKey(alias.getName())) {
                    throw new IllegalStateException("The alias " + alias + " is used twice ");
                }
                this.aliases.put(alias.getName(), tableReference);
            }
            this.tables.add(tableReference);
            if (t instanceof ViewImpl) {
                ViewImpl v = (ViewImpl)t;
                this.addSelectStatement(v.getViewStatement());
            }
            if (!(tableReference instanceof JoinReference)) continue;
            this.addCombinedConstraint(((JoinReference)tableReference).getOn());
        }
        this.addCombinedConstraint(pQuery.getWhere());
        Iterator iter = pQuery.getResultColumns();
        while (iter.hasNext()) {
            this.addColumn((ColumnReference)iter.next());
        }
    }

    protected void addColumn(ColumnReference pColumn) {
        if (pColumn instanceof VirtualColumn) {
            VirtualColumn vc = (VirtualColumn)pColumn;
            Object o = vc.getValue();
            if (o instanceof SelectStatement) {
                this.addSelectStatement((SelectStatement)o);
            } else if (o instanceof Function) {
                this.addParts((Function)o);
            } else if (!(o instanceof String)) {
                throw new IllegalStateException("Invalid type of VirtualColumn: " + o);
            }
            this.addColumnName(vc.getName());
        }
    }

    private void addColumnName(Column.Name pName) {
        String key = pName.toString().toUpperCase();
        Integer num = (Integer)this.columnNames.get(key);
        num = num == null ? new Integer(1) : new Integer(num + 1);
        this.columnNames.put(key, num);
    }

    protected void addCombinedConstraint(CombinedConstraint pConstraint) {
        Iterator iter = pConstraint.getParts();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof CombinedConstraint) {
                this.addCombinedConstraint((CombinedConstraint)o);
                continue;
            }
            if (o instanceof BooleanConstraint) {
                this.addBooleanConstraint((BooleanConstraint)o);
                continue;
            }
            throw new IllegalStateException("Invalid part type in CombinedConstraint: " + o);
        }
    }

    protected void addParts(Parts pParts) {
        Iterator iter = pParts.getParts();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof SelectStatement) {
                this.addSelectStatement((SelectStatement)o);
                continue;
            }
            if (o instanceof CombinedConstraint) {
                this.addCombinedConstraint((CombinedConstraint)o);
                continue;
            }
            if (o instanceof Function) {
                this.addParts((Function)o);
                continue;
            }
            if (o instanceof ColumnReference || o instanceof Value || o instanceof RawSQLCode) continue;
            throw new IllegalStateException("Invalid part in boolean constraint: " + o);
        }
    }

    protected void addBooleanConstraint(BooleanConstraint pConstraint) {
        BooleanConstraint.Type type = pConstraint.getType();
        if (!(BooleanConstraint.Type.EQ.equals(type) || BooleanConstraint.Type.EXISTS.equals(type) || BooleanConstraint.Type.GE.equals(type) || BooleanConstraint.Type.GT.equals(type) || BooleanConstraint.Type.IN.equals(type) || BooleanConstraint.Type.ISNULL.equals(type) || BooleanConstraint.Type.LE.equals(type) || BooleanConstraint.Type.LIKE.equals(type) || BooleanConstraint.Type.LT.equals(type) || BooleanConstraint.Type.NE.equals(type))) {
            throw new IllegalStateException("Invalid part type in BooleanConstraint: " + type);
        }
        this.addParts(pConstraint);
    }

    protected String getUniqueAlias(String pSuggestion, Map pAliases) {
        String s;
        char c;
        String prefix = pSuggestion == null ? "" : pSuggestion;
        if (!pAliases.containsKey(prefix)) {
            return prefix;
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            s = prefix + c;
            if (pAliases.containsKey(s)) continue;
            return s;
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            s = prefix + c;
            if (pAliases.containsKey(s)) continue;
            return s;
        }
        return this.getUniqueAlias(prefix + '0', pAliases);
    }

    protected void createTableAliases() {
        if (this.tables.size() > 1) {
            Iterator iter = this.tables.iterator();
            while (iter.hasNext()) {
                TableReference tableReference = (TableReference)iter.next();
                if (tableReference.getAlias() != null) continue;
                String alias = this.getUniqueAlias(tableReference.getTable().getName().getName(), this.aliases);
                this.aliases.put(alias, tableReference);
                if (alias.equals(tableReference.getTable().getName().getName())) continue;
                tableReference.setAlias(alias);
            }
        }
    }

    protected void createColumnNames() {
        for (int i = 0; i < this.tables.size(); ++i) {
            TableReference table = (TableReference)this.tables.get(i);
            Iterator iter = table.getTable().getColumns();
            while (iter.hasNext()) {
                Column col = (Column)iter.next();
                this.addColumnName(col.getName());
            }
        }
    }

    public Map getColumnNames() {
        return this.columnNames;
    }

    public static class LocalData {
        private boolean hasWhereClause;

        public boolean hasWhereClause() {
            return this.hasWhereClause;
        }

        public void setWhereClause(boolean pHasWhereClause) {
            this.hasWhereClause = pHasWhereClause;
        }
    }
}

