"""Convenience functions that are useful in subdomains and expressions. Matches
some of the functions in dolfin/math/basic.h."""

__all__ = ["sqr"]

from . constants import DOLFIN_EPS

# The cpp version of these functions are about 3 times faster
#def between(x0, x, x1):
#    """Returns true if x0-epsilon < x < x1+epsilon"""
#    return x0-DOLFIN_EPS < x < x1+DOLFIN_EPS
#
#def near(x, x0):
#    """Returns true if x0-epsilon < x < x0+epsilon"""
#    return x0-DOLFIN_EPS < x < x0+DOLFIN_EPS

def sqr(x):
    return x*x
