# 0.22.0 Migration Guide

## Deprecations

- Calling `logs:failed` without either a `<name>` or the `--all` flag is deprecated.

## Changes

- Underscores are no longer valid characters in app names. Please rename applications before upgrading.
- Process type names specified in Procfile may no longer use characters not valid in DNS Label Names ([RFC 1123](https://tools.ietf.org/html/rfc1123)).
- The minimum Docker version is now 17.05.0.
- The `common.GetDeployingAppImageName()` function now returns an `error` as the second return argument instead of calling `common.LogFail()` internally.
- Setting `DOKKU_DISABLE_ANSI_PREFIX_REMOVAL` is deprecated; Dokku 0.23.0 will avoid removing the `remote:` ansi prefix entirely. No warning will be added in this release.

## Removals

The `ps` command has had a few removals as a result of a rewrite to Golang:

- The `ps:set-restart-policy` command has been removed in favor the `ps:set` command.
- The `ps:restart-policy` command has been removed in favor of the `ps:report` command.
- The `ps:rebuildall` command has been removed in favor of calling the `ps:rebuild` with the `--all` flag instead of an app name.
- The `ps:restartall` command has been removed in favor of calling the `ps:restart` with the `--all` flag instead of an app name.
- The `ps:stopall` command has been removed in favor of calling the `ps:stop` with the `--all` flag instead of an app name.
- The `ps:startall` command has been removed in favor of calling the `ps:start` with the `--all` flag instead of an app name.
- The `DOKKU_PROCFILE` file is no longer located in the git directory for a given app on the server. It's location is currently not exposed.
- The `procfile-get-command` plugin trigger no longer takes a `procfile path` as the final argument.
- All `ps` functions have been removed. Please us a trigger as appropriate or file a PR to have a new trigger/wrapper function added.
