/*
 *  DOCSIS configuration file encoder.
 *  Copyright (c) 2001 Cornel Ciocirlan, ctrl@users.sourceforge.net.
 *  Copyright (c) 2002,2003,2004,2005 Evvolve Media SRL,office@evvolve.com
 *  Copyright (c) 2014 - 2015 Adrian Simionov, daniel.simionov@gmail.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *  DOCSIS is a registered trademark of Cablelabs, http://www.cablelabs.com
 */

/*
    change history
	2004-07-29 fix bug # 970994 ... SubMgmtControl had wrong docsis code
	2003-01-10 added three new TLV types for BPI+ (courtesy of Adrian Kwong)

*/


#ifndef _DOCSIS_SYMTABLE_H


#include "docsis_common.h"
#include "docsis_decode.h"
#include "docsis_encode.h"

/*
 * encode_nothing is used for non-trivial settings, where the encoding functions
 * must have prototypes that don't match symbol_type (i.e. generic TLV, SNMP, etc).
 *
 * This is a list and a tree at the same time. The "parent_id" of each entry is a pointer to the
 * parent row in this table; ClassId for example has "6" as parent ID which is the index
 * in the table of ClassOfService
 */

/*id  "identifier" docsis_code parent_id encode_func decode_func low_limit high_limit */

symbol_type symtable[NUM_IDENTIFIERS] =  {
{ 0,      "/* Pad */",                         0,      0,      (encode_nothing),        (decode_special),        0,           0             },
{ 1,      "DownstreamFrequency",               1,      0,      (encode_uint),           (decode_uint),           88000000,    1008000000    }, /* TLV 1 MULPIv3.0-I24 Annex C.1.1.1 */
{ 2,      "UpstreamChannelId",                 2,      0,      (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 2 MULPIv3.0-I24 Annex C.1.1.2 */
{ 3,      "NetworkAccess",                     3,      0,      (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 3 MULPIv3.0-I24 Annex C.1.1.3 */
{ 6,      "ClassOfService",                    4,      0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 4 MULPIv3.0-I24 Annex C.1.1.4 */
{ 7,      "ClassID",                           1,      6,      (encode_uchar),          (decode_uchar),          1,           16            }, /* TLV 4.1 MULPIv3.0-I24 Annex C.1.1.4.1 */
{ 8,      "MaxRateDown",                       2,      6,      (encode_uint),           (decode_uint),           0,           1334880000    }, /* TLV 4.2 MULPIv3.0-I24 Annex C.1.1.4.2 */
{ 9,      "MaxRateUp",                         3,      6,      (encode_uint),           (decode_uint),           0,           183900000     }, /* TLV 4.3 MULPIv3.0-I24 Annex C.1.1.4.3 */
{ 10,     "PriorityUp",                        4,      6,      (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 4.4 MULPIv3.0-I24 Annex C.1.1.4.4 */
{ 11,     "GuaranteedUp",                      5,      6,      (encode_uint),           (decode_uint),           0,           183900000     }, /* TLV 4.5 MULPIv3.0-I24 Annex C.1.1.4.5 */
{ 12,     "MaxBurstUp",                        6,      6,      (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 4.6 MULPIv3.0-I24 Annex C.1.1.4.6 */
{ 13,     "PrivacyEnable",                     7,      6,      (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 4.7 MULPIv3.0-I24 Annex C.1.1.4.7 */
{ 144,    "ModemCapabilities",                 5,      0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 5 MULPIv3.0-I24 Annex C.1.3.1 */
{ 145,    "ConcatenationSupport",              1,      144,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 5.1 MULPIv3.0-I24 Annex C.1.3.1.1 */
{ 146,    "ModemDocsisVersion",                2,      144,    (encode_uchar),          (decode_uchar),          0,           3             }, /* TLV 5.2 MULPIv3.0-I24 Annex C.1.3.1.2 */
{ 147,    "FragmentationSupport",              3,      144,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 5.3 MULPIv3.0-I24 Annex C.1.3.1.3 */
{ 148,    "PHSSupport",                        4,      144,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 5.4 MULPIv3.0-I24 Annex C.1.3.1.4 */
{ 149,    "IGMPSupport",                       5,      144,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 5.5 MULPIv3.0-I24 Annex C.1.3.1.5 */
{ 150,    "BaselinePrivacySupport",            6,      144,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 5.6 MULPIv3.0-I24 Annex C.1.3.1.6 */
{ 151,    "DownstreamSAIDSupport",             7,      144,    (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 5.7 MULPIv3.0-I24 Annex C.1.3.1.7 */
{ 152,    "UpstreamSIDSupport",                8,      144,    (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 5.8 MULPIv3.0-I24 Annex C.1.3.1.8 */
{ 274,    "OptionalFilteringSupport",          9,      144,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 5.9 MULPIv3.0-I24 Annex C.1.3.1.9 */
{ 275,    "TransmitPreEqualizerTapsPerModulationInterval",  10,  144,  (encode_uchar),  (decode_uchar),          1,           4             }, /* TLV 5.10 MULPIv3.0-I24 Annex C.1.3.1.10 */
{ 276,    "NumberofTransmitEqualizerTaps",     11,     144,    (encode_uchar),          (decode_uchar),          8,           64            }, /* TLV 5.11 MULPIv3.0-I24 Annex C.1.3.1.11 */
{ 153,    "DCCSupport",                        12,     144,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 5.12 MULPIv3.0-I24 Annex C.1.3.1.12 */
{ 242,    "IPFiltersSupport",                  13,     144,    (encode_ushort),         (decode_ushort),         64,          65535         }, /* TLV 5.13 MULPIv3.0-I24 Annex C.1.3.1.13 */
{ 243,    "LLCFiltersSupport",                 14,     144,    (encode_ushort),         (decode_ushort),         10,          65535         }, /* TLV 5.14 MULPIv3.0-I24 Annex C.1.3.1.14 */
{ 244,    "ExpandedUnicastSIDSpace",           15,     144,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 5.15 MULPIv3.0-I24 Annex C.1.3.1.15 */
{ 245,    "RangingHoldOffSupport",             16,     144,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 5.16 MULPIv3.0-I24 Annex C.1.3.1.16 */
{ 246,    "L2VPNCapability",                   17,     144,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 5.17 MULPIv3.0-I24 Annex C.1.3.1.17 */
{ 247,    "L2VPNeSAFEHostCapability",          18,     144,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 5.18 MULPIv3.0-I24 Annex C.1.3.1.18 */
{ 248,    "DUTFilteringSupport",               19,     144,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 5.19 MULPIv3.0-I24 Annex C.1.3.1.19 */
{ 249,    "UpstreamFrequencyRangeSupport",     20,     144,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 5.20 MULPIv3.0-I24 Annex C.1.3.1.20 */
{ 250,    "UpstreamSymbolRateSupport",         21,     144,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 5.21 MULPIv3.0-I24 Annex C.1.3.1.21 */
{ 251,    "SelectableActiveCodeMode2Support",  22,     144,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 5.22 MULPIv3.0-I24 Annex C.1.3.1.22 */
{ 252,    "CodeHoppingMode2Support",           23,     144,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 5.23 MULPIv3.0-I24 Annex C.1.3.1.23 */
{ 253,    "MultipleTransmitChannelSupport",    24,     144,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 5.24 MULPIv3.0-I24 Annex C.1.3.1.24 */
{ 254,    "M512MspsUpstreamTransmitChannel",   25,     144,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 5.25 MULPIv3.0-I24 Aneex C.1.3.1.25 */
{ 254,    "M256MspsUpstreamTransmitChannel",   26,     144,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 5.26 MULPIv3.0-I24 Aneex C.1.3.1.26 */
{ 255,    "TotalSIDClusterSupport",            27,     144,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 5.27 MULPIv3.0-I24 Annex C.1.3.1.27 */
{ 256,    "SIDClustersPerServiceFlow",         28,     144,    (encode_uchar),          (decode_uchar),          2,           8             }, /* TLV 5.28 MULPIv3.0-I24 Annex C.1.3.1.28 */
{ 257,    "MultipleReceiveChannelSupport",     29,     144,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 5.29 MULPIv3.0-I24 Annex C.1.3.1.29 */
{ 258,    "TotalDownstreamServiceIDSupport",   30,     144,    (encode_uchar),          (decode_uchar),          32,          255           }, /* TLV 5.30 MULPIv3.0-I24 Annex C.1.3.1.30 */
{ 259,    "ResequencingDownstreamServiceID",   31,     144,    (encode_uchar),          (decode_uchar),          16,          255           }, /* TLV 5.31 MULPIv3.0-I24 Annex C.1.3.1.31 */
{ 260,    "MulticastDownstreamServiceID",      32,     144,    (encode_uchar),          (decode_uchar),          16,          255           }, /* TLV 5.32 MULPIv3.0-I24 Annex C.1.3.1.32 */
{ 261,    "MulticastDSIDForwarding",           33,     144,    (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 5.33 MULPIv3.0-I24 Annex C.1.3.1.33 */
{ 262,    "FrameControlTypeForwarding",        34,     144,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 5.34 MULPIv3.0-I24 Annex C.1.3.1.34 */
{ 263,    "DPVCapability",                     35,     144,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 5.35 MULPIv3.0-I24 Annex C.1.3.1.35 */
{ 264,    "UnsolicitedGrantServiceSupport",    36,     144,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 5.36 MULPIv3.0-I24 Annex C.1.3.1.36 */
{ 265,    "MAPandUCDReceiptSupport",           37,     144,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 5.37 MULPIv3.0-I24 Annex C.1.3.1.37 */
{ 266,    "UpstreamDropClassifierSupport",     38,     144,    (encode_ushort),         (decode_ushort),         64,          65535         }, /* TLV 5.38 MULPIv3.0-I24 Annex C.1.3.1.38 */
{ 267,    "IPv6Support",                       39,     144,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 5.39 MULPIv3.0-I24 Annex C.1.3.1.39 */
{ 268,    "ExtendedUpstreamTransmitPower",     40,     144,    (encode_uchar),          (decode_uchar),          0,           244           }, /* TLV 5.40 MULPIv3.0-I24 Annex C.1.3.1.40 */
{ 269,    "MPLSClassificationSupport",         41,     144,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 5.41 MULPIv3.0-I24 Annex C.1.3.1.41 */
{ 270,    "DONUCapabilitiesEncoding",          42,     144,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 5.42 MULPIv3.0-I24 Annex C.1.3.1.42 */
{ 271,    "EnergyManagementCapabilities",      44,     144,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 5.44 MULPIv3.0-I24 Annex C.1.3.1.43 */
{ 272,    "CDOCSISCapabilityEncoding",         45,     144,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 5.45 MULPIv3.0-I24 Annex C.1.3.1.44 */
{ 273,    "CMSTATUSACK",                       46,     144,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 5.46 MULPIv3.0-I24 Annex C.1.3.1.45 */
{ 4,      "CmMic",                             6,      0,      (encode_nothing),        (decode_md5),            0,           0             }, /* TLV 6 MULPIv3.0-I24 Annex C.1.1.5 */
{ 5,      "CmtsMic",                           7,      0,      (encode_nothing),        (decode_md5),            0,           0             }, /* TLV 7 MULPIv3.0-I24 Annex C.1.1.6 */
{ 14,     "SwUpgradeFilename",                 9,      0,      (encode_string),         (decode_string),         0,           0             }, /* TLV 9 MULPIv3.0-I24 Annex C.1.2.3 */
{ 15,     "SnmpWriteControl",                  10,     0,      (encode_nothing),        (decode_snmp_wd),        0,           0             }, /* TLV 10 MULPIv3.0-I24 Annex C.1.2.4 */
{ 16,     "SnmpMibObject",                     11,     0,      (encode_nothing),        (decode_snmp_object),    0,           0             }, /* TLV 11 MULPIv3.0-I24 Annex C.1.2.5 */
{ 277,    "ModemIPAddress",                    12,     0,      (encode_ip),             (decode_ip),             0,           0             }, /* TLV 12 MULPIv3.0-I24 Annex C.1.3.3 */
{ 17,     "CpeMacAddress",                     14,     0,      (encode_ether),          (decode_ether),          0,           0             }, /* TLV 14 MULPIv3.0-I24 Annex C.1.2.6 */
{ 18,     "BaselinePrivacy",                   17,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 17 SECv3.0-I15 Annex A.1.1.1 */
{ 19,     "AuthTimeout",                       1,      18,     (encode_uint),           (decode_uint),           1,           30            }, /* TLV 17.1 SECv3.0-I15 Annex A.1.1.1.1 */
{ 20,     "ReAuthTimeout",                     2,      18,     (encode_uint),           (decode_uint),           1,           30            }, /* TLV 17.2 SECv3.0-I15 Annex A.1.1.1.2 */
{ 21,     "AuthGraceTime",                     3,      18,     (encode_uint),           (decode_uint),           1,           6047999       }, /* TLV 17.3 SECv3.0-I15 Annex A.1.1.1.3 */
{ 22,     "OperTimeout",                       4,      18,     (encode_uint),           (decode_uint),           1,           10            }, /* TLV 17.4 SECv3.0-I15 Annex A.1.1.1.4 */
{ 23,     "ReKeyTimeout",                      5,      18,     (encode_uint),           (decode_uint),           1,           10            }, /* TLV 17.5 SECv3.0-I15 Annex A.1.1.1.5 */
{ 24,     "TEKGraceTime",                      6,      18,     (encode_uint),           (decode_uint),           1,           302399        }, /* TLV 17.6 SECv3.0-I15 Annex A.1.1.1.6 */
{ 25,     "AuthRejectTimeout",                 7,      18,     (encode_uint),           (decode_uint),           1,           600           }, /* TLV 17.7 SECv3.0-I15 Annex A.1.1.1.7 */
{ 127,    "SAMapWaitTimeout",                  8,      18,     (encode_uint),           (decode_uint),           1,           10            }, /* TLV 17.8 SECv3.0-I15 Annex A.1.1.1.8 */
{ 128,    "SAMapMaxRetries",                   9,      18,     (encode_uint),           (decode_uint),           0,           10            }, /* TLV 17.9 SECv3.0-I15 Annex A.1.1.1.9 */
{ 26,     "MaxCPE",                            18,     0,      (encode_uchar),          (decode_uchar),          1,           254           }, /* TLV 18 MULPIv3.0-I24 Annex C.1.1.7 */
{ 168,    "TftpTimestamp",                     19,     0,      (encode_uint),           (decode_uint),           0,           0xFFFFFFFF    }, /* TLV 19 MULPIv3.0-I24 Annex C.1.1.8 */
{ 169,    "TftpModemAddress",                  20,     0,      (encode_ip),             (decode_ip),             0,           0             }, /* TLV 20 MULPIv3.0-I24 Annex C.1.1.9 */
{ 27,     "SwUpgradeServer",                   21,     0,      (encode_ip),             (decode_ip),             0,           0             }, /* TLV 21 MULPIv3.0-I24 Annex C.1.2.7 */
{ 28,     "UsPacketClass",                     22,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22 MULPIv3.0-I24 Annex C.2.1.1 */
{ 29,     "ClassifierRef",                     1,      28,     (encode_uchar),          (decode_uchar),          1,           255           }, /* TLV 22.1 MULPIv3.0-I24 Annex C.2.1.4.1 */
{ 30,     "ClassifierId",                      2,      28,     (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 22.2 MULPIv3.0-I24 Annex C.2.1.4.2 */
{ 31,     "ServiceFlowRef",                    3,      28,     (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 22.3 MULPIv3.0-I24 Annex C.2.1.4.3 */
{ 32,     "ServiceFlowId",                     4,      28,     (encode_uint),           (decode_uint),           1,           0xFFFFFFFF    }, /* TLV 22.4 MULPIv3.0-I24 Annex C.2.1.4.4 */
{ 33,     "RulePriority",                      5,      28,     (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 22.5 MULPIv3.0-I24 Annex C.2.1.4.5 */
{ 34,     "ActivationState",                   6,      28,     (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 22.6 MULPIv3.0-I24 Annex C.2.1.4.6 */
{ 35,     "DscAction",                         7,      28,     (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 22.7 MULPIv3.0-I24 Annex C.2.1.4.7 */
{ 36,     "IpPacketClassifier",                9,      28,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.9 MULPIv3.0-I24 Annex C.2.1.6 */
{ 37,     "IpTos",                             1,      36,     (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 22.9.1 MULPIv3.0-I24 Annex C.2.1.6.1 */
{ 38,     "IpProto",                           2,      36,     (encode_ushort),         (decode_ushort),         0,           257           }, /* TLV 22.9.2 MULPIv3.0-I24 Annex C.2.1.6.2 */
{ 39,     "IpSrcAddr",                         3,      36,     (encode_ip),             (decode_ip),             0,           0             }, /* TLV 22.9.3 MULPIv3.0-I24 Annex C.2.1.6.3 */
{ 40,     "IpSrcMask",                         4,      36,     (encode_ip),             (decode_ip),             0,           0             }, /* TLV 22.9.4 MULPIv3.0-I24 Annex C.2.1.6.4 */
{ 41,     "IpDstAddr",                         5,      36,     (encode_ip),             (decode_ip),             0,           0             }, /* TLV 22.9.5 MULPIv3.0-I24 Annex C.2.1.6.5 */
{ 42,     "IpDstMask",                         6,      36,     (encode_ip),             (decode_ip),             0,           0             }, /* TLV 22.9.6 MULPIv3.0-I24 Annex C.2.1.6.6 */
{ 43,     "SrcPortStart",                      7,      36,     (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 22.9.7 MULPIv3.0-I24 Annex C.2.1.7.1 */
{ 44,     "SrcPortEnd",                        8,      36,     (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 22.9.8 MULPIv3.0-I24 Annex C.2.1.7.2 */
{ 45,     "DstPortStart",                      9,      36,     (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 22.9.9 MULPIv3.0-I24 Annex C.2.1.7.3 */
{ 46,     "DstPortEnd",                        10,     36,     (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 22.9.10 MULPIv3.0-I24 Annex C.2.1.7.4 */
{ 47,     "LLCPacketClassifier",               10,     28,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.10 MULPIv3.0-I24 Annex C.2.1.8 */
{ 48,     "DstMacAddress",                     1,      47,     (encode_ethermask),      (decode_ethermask),      0,           0             }, /* TLV 22.10.1 MULPIv3.0-I24 Annex C.2.1.8.1 */
{ 49,     "SrcMacAddress",                     2,      47,     (encode_ether),          (decode_ether),          0,           0             }, /* TLV 22.10.2 MULPIv3.0-I24 Annex C.2.1.8.2 */
{ 50,     "EtherType",                         3,      47,     (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 22.10.3 MULPIv3.0-I24 Annex C.2.1.8.3 */
{ 51,     "IEEE802Classifier",                 11,     28,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.11 MULPIv3.0-I24 Annex C.2.1.9 */
{ 52,     "UserPriority",                      1,      51,     (encode_char_list),      (decode_char_list),      0,           0             }, /* TLV 22.11.1 MULPIv3.0-I24 Annex C.2.1.9.1 */
{ 53,     "VlanID",                            2,      51,     (encode_ushort),         (decode_ushort),         0,           4096          }, /* TLV 22.11.2 MULPIv3.0-I24 Annex C.2.1.9.2 */
{ 211,    "PcIPv6PacketClassification",        12,     28,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.12 MULPIv3.0-I24 Annex C.2.1.10 */
{ 212,    "PcIPv6TrafficClassRangeAndMask",    1,      211,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 22.12.1 MULPIv3.0-I24 Annex C.2.1.10.1 */
{ 213,    "PcIPv6FlowLabel",                   2,      211,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 22.12.2 MULPIv3.0-I24 Annex C.2.1.10.2 */
{ 214,    "PcIPv6NextHeaderType",              3,      211,    (encode_ushort),         (decode_ushort),         0,           257           }, /* TLV 22.12.3 MULPIv3.0-I24 Annex C.2.1.10.3 */
{ 215,    "PcIPv6SourceAddress",               4,      211,    (encode_ip6),            (decode_ip6),            0,           0             }, /* TLV 22.12.4 MULPIv3.0-I24 Annex C.2.1.10.4 */
{ 216,    "PcIPv6SourcePrefixLength",          5,      211,    (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 22.12.5 MULPIv3.0-I24 Annex C.2.1.10.5 */
{ 217,    "PcIPv6DestAddress",                 6,      211,    (encode_ip6),            (decode_ip6),            0,           0             }, /* TLV 22.12.6 MULPIv3.0-I24 Annex C.2.1.10.6 */
{ 218,    "PcIPv6DestPrefixLength",            7,      211,    (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 22.12.7 MULPIv3.0-I24 Annex C.2.1.10.7 */
{ 219,    "PcCMIMEncoding",                    13,     28,     (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 22.13 MULPIv3.0-I24 Annex C.2.1.4.8 */
{ 278,    "STagCTagFrameClassification",       14,     28,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.14 MULPIv3.0-I24 Annex C.2.1.13 */
{ 279,    "STPID",                             1,      278,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.14.1 MULPIv3.0-I24 Annex C.2.1.13.1 */
{ 280,    "SVID",                              2,      278,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.14.2 MULPIv3.0-I24 Annex C.2.1.13.2 */
{ 281,    "SPCP",                              3,      278,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 22.14.3 MULPIv3.0-I24 Annex C.2.1.13.3 */
{ 282,    "SDEI",                              4,      278,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 22.14.4 MULPIv3.0-I24 Annex C.2.1.13.4 */
{ 283,    "CTPID",                             5,      278,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.14.5 MULPIv3.0-I24 Annex C.2.1.13.5 */
{ 284,    "CVID",                              6,      278,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.14.6 MULPIv3.0-I24 Annex C.2.1.13.6 */
{ 285,    "CPCP",                              7,      278,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 22.14.7 MULPIv3.0-I24 Annex C.2.1.13.7 */
{ 286,    "CCFI",                              8,      278,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 22.14.8 MULPIv3.0-I24 Annex C.2.1.13.8 */
{ 287,    "STCI",                              9,      278,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.14.9 MULPIv3.0-I24 Annex C.2.1.13.9 */
{ 288,    "CTCI",                              10,     278,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.14.10 MULPIv3.0-I24 Annex C.2.1.13.10 */
{ 300,    "IEEE8021ahPacketClassification",    15,     28,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.15 MULPIv3.0-I24 Annex C.2.1.14 */
{ 301,    "ITPID",                             1,      300,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.15.1 MULPIv3.0-I24 Annex C.2.1.14.1 */
{ 302,    "ISID",                              2,      300,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 22.15.2 MULPIv3.0-I24 Annex C.2.1.14.2 */
{ 303,    "ITCI",                              3,      300,    (encode_hexstr),         (decode_hexstr),         5,           5             }, /* TLV 22.15.3 MULPIv3.0-I24 Annex C.2.1.14.3 */
{ 304,    "IPCP",                              4,      300,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 22.15.4 MULPIv3.0-I24 Annex C.2.1.14.4 */
{ 305,    "IDEI",                              5,      300,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 22.15.5 MULPIv3.0-I24 Annex C.2.1.14.5 */
{ 306,    "IUCA",                              6,      300,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 22.15.6 MULPIv3.0-I24 Annex C.2.1.14.6 */
{ 307,    "BTPID",                             7,      300,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.15.7 MULPIv3.0-I24 Annex C.2.1.14.7 */
{ 308,    "BTCI",                              8,      300,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.15.8 MULPIv3.0-I24 Annex C.2.1.14.8 */
{ 309,    "BPCP",                              9,      300,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 22.15.9 MULPIv3.0-I24 Annex C.2.1.14.9 */
{ 310,    "BDEI",                              10,     300,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 22.15.10 MULPIv3.0-I24 Annex C.2.1.14.10 */
{ 311,    "BVID",                              11,     300,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.15.11 MULPIv3.0-I24 Annex C.2.1.14.11 */
{ 312,    "BDA",                               12,     300,    (encode_ether),          (decode_ether),          0,           0             }, /* TLV 22.15.12 MULPIv3.0-I24 Annex C.2.1.14.12 */
{ 313,    "BSA",                               13,     300,    (encode_ether),          (decode_ether),          0,           0             }, /* TLV 22.15.13 MULPIv3.0-I24 Annex C.2.1.14.13 */
{ 328,    "ICMPv4ICMPv6PacketClassification",  16,     28,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.16 MULPIv3.0-I24 Annex C.2.1.12 */
{ 329,    "ICMPv4ICMPv6TypeStart",             1,      328,    (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 22.16.1 MULPIv3.0-I24 Annex C.2.1.12.1 */
{ 330,    "ICMPv4ICMPv6TypeEnd",               2,      328,    (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 22.16.2 MULPIv3.0-I24 Annex C.2.1.12.2 */
{ 334,    "MPLSClassificationEncoding",        17,     28,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.17 MULPIv3.0-I24 Annex C.2.1.15 */
{ 335,    "MPLSTCbits",                        1,      334,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 22.17.1 MULPIv3.0-I24 Annex C.2.1.15.1 */
{ 336,    "MPLSLabel",                         2,      334,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 22.17.2 MULPIv3.0-I24 Annex C.2.1.15.2 */
{ 200,    "VendorSpecific",                    43,     28,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43 MULPIv3.0-I24 Annex C.2.1.11 */
{ 352,    "CMLoadBalancingPolicyID",           1,      200,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 22.43.1 MULPIv3.0-I24 Annex C.1.1.18.1.1 */
{ 353,    "CMLoadBalancingPriority",           2,      200,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 22.43.2 MULPIv3.0-I24 Annex C.1.1.18.1.2 */
{ 354,    "CMLoadBalancingGroupID",            3,      200,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 22.43.3 MULPIv3.0-I24 Annex C.1.1.18.1.3 */
{ 355,    "CMRangingClassIDExtension",         4,      200,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 22.43.4 MULPIv3.0-I24 Annex C.1.1.18.1.4 */
{ 202,    "L2VPNEncoding",                     5,      200,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.5 MULPIv3.0-I24 Annex C.1.1.18.1.5 */
{ 203,    "VPNIdentifier",                     1,      202,    (encode_hexstr),         (decode_hexstr),         4,           255           }, /* TLV 22.43.5.1 L2VPN-I13 Annex B.3.1 */
{ 350,    "NSIEncapsulation",                  2,      202,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.5.2 L2VPN-I13 Annex B.3.2 */
{ 351,    "ServiceMultiplexingValueOther",     1,      350,    (encode_lenzero),        (decode_lenzero),        0,           0             }, /* TLV 22.43.5.2.1 L2VPN-I13 Annex B.3.2 */
{ 356,    "NSIEncapsulationSingleQTag",        2,      350,    (encode_ushort),         (decode_ushort),         0,           4096          }, /* TLV 22.43.5.2.2 L2VPN-I13 Annex B.3.2 */
{ 357,    "NSIEncapsulationDualQTag",          3,      350,    (encode_dual_qtag),      (decode_dual_qtag),      0,           0             }, /* TLV 22.43.5.2.3 L2VPN-I13 Annex B.3.2 */
{ 358,    "ServiceMultiplexingValueMPLSPW",    4,      350,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.5.2.4 L2VPN-I13 Annex B.3.2 */
{ 359,    "MPLSPseudowireID",                  1,      358,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 22.43.5.2.4.1 L2VPN-I13 Annex B.3.2 */
{ 360,    "MPLSPeerIpAddress",                 2,      358,    (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 22.43.5.2.4.2 L2VPN-I13 Annex B.3.2 */
{ 361,    "MPLSPseudowireType",                3,      358,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 22.43.5.2.4.3 L2VPN-I13 Annex B.3.2 */
{ 362,    "MPLSBackupPseudowireID",            4,      358,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 22.43.5.2.4.4 L2VPN-I13 Annex B.3.2 */
{ 363,    "MPLSBackupPeerIpAddress",           5,      358,    (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 22.43.5.2.4.5 L2VPN-I13 Annex B.3.2 */
{ 384,    "ServiceMultiplexingValueL2TPv3Peer", 5,     350,    (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 22.43.5.2.5 L2VPN-I13 Annex B.3.2 */
{ 364,    "IEEE8021ahEncapsulation",           6,      350,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.5.2.6 L2VPN-I13 Annex B.3.2.2 */
{ 365,    "ITCIEncapsulation",                 1,      364,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 22.43.5.2.6.1 L2VPN-I13 Annex B.3.2.2.1 */
{ 366,    "BDAEncapsulation",                  2,      364,    (encode_hexstr),         (decode_hexstr),         6,           6             }, /* TLV 22.43.5.2.6.2 L2VPN-I13 Annex B.3.2.2.2 */
{ 367,    "BTCIEncapsulation",                 3,      364,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.2.6.3 L2VPN-I13 Annex B.3.2.2.3 */
{ 368,    "ITPIDEncapsulation",                4,      364,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.2.6.4 L2VPN-I13 Annex B.3.2.2.4 */
{ 369,    "IPCPEncapsulation",                 5,      364,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 22.43.5.2.6.5 L2VPN-I13 Annex B.3.2.2.5 */
{ 370,    "IDEIEncapsulation",                 6,      364,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 22.43.5.2.6.6 L2VPN-I13 Annex B.3.2.2.6 */
{ 371,    "IUCAEncapsulation",                 7,      364,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 22.43.5.2.6.7 L2VPN-I13 Annex B.3.2.2.7 */
{ 372,    "ISIDEncapsulation",                 8,      364,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 22.43.5.2.6.8 L2VPN-I13 Annex B.3.2.2.8 */
{ 373,    "BTPIDEncapsulation",                9,      364,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.2.6.9 L2VPN-I13 Annex B.3.2.2.9 */
{ 374,    "BPCPEncapsulation",                 10,     364,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 22.43.5.2.6.10 L2VPN-I13 Annex B.3.2.2.10 */
{ 375,    "BDEIEncapsulation",                 11,     364,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 22.43.5.2.6.11 L2VPN-I13 Annex B.3.2.2.11 */
{ 376,    "BVIDEncapsulation",                 12,     364,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.2.6.12 L2VPN-I13 Annex B.3.2.2.11 */
{ 377,    "ServiceMultiplexingValueIEEE8021adSTPID", 8, 350,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.2.8 L2VPN-I13 Annex B.3.2.1 */
{ 378,    "eSAFEDHCPSnooping",                 3,      202,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 22.43.5.3 L2VPN-I13 Annex B.3.3 */
{ 378,    "CMInterfaceMaskCMIMSubtype",        4,      202,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 22.43.5.4 L2VPN-I13 Annex B.3.4 */
{ 379,    "AttachmentGroupID",                 5,      202,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 22.43.5.5 L2VPN-I13 Annex B.3.5 */
{ 380,    "SourceAttachmentIndividualID",      6,      202,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 22.43.5.6 L2VPN-I13 Annex B.3.6 */
{ 381,    "TargetAttachmentIndividualID",      7,      202,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 22.43.5.7 L2VPN-I13 Annex B.3.7 */
{ 382,    "IngressUserPriority",               8,      202,    (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 22.43.5.8 L2VPN-I13 Annex B.3.8 */
{ 383,    "UserPriorityRange",                 9,      202,    (encode_char_list),      (decode_char_list),      0,           0             }, /* TLV 22.43.5.9 L2VPN-I13 Annex B.3.9 */
{ 385,    "L2VPNSADescriptorSubtype",          10,     202,    (encode_hexstr),         (decode_hexstr),         14,          14            }, /* TLV 22.43.5.10 L2VPN-I13 Annex B.3.10 */
{ 386,    "PseudowireType",                    12,     202,    (encode_uchar),          (decode_uchar),          4,           5             }, /* TLV 22.43.5.12 L2VPN-I13 Annex B.3.13 */
{ 387,    "L2VPNMode",                         13,     202,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 22.43.5.13 L2VPN-I13 Annex B.3.14 */
{ 388,    "TPIDTranslation",                   14,     202,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.5.14 L2VPN-I13 Annex B.3.15 */
{ 389,    "UpstreamTPIDTranslation",           1,      388,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.14.1 L2VPN-I13 Annex B.3.15.1 */
{ 390,    "DownstreamTPIDTranslation",         2,      388,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.14.2 L2VPN-I13 Annex B.3.15.1 */
{ 391,    "UpstreamSTPIDTranslation",          3,      388,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.14.3 L2VPN-I13 Annex B.3.15.1 */
{ 392,    "DownstreamSTPIDTranslation",        4,      388,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.14.4 L2VPN-I13 Annex B.3.15.1 */
{ 393,    "UpstreamBTPIDTranslation",          5,      388,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.14.5 L2VPN-I13 Annex B.3.15.1 */
{ 394,    "DownstreamBTPIDTranslation",        6,      388,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.14.6 L2VPN-I13 Annex B.3.15.1 */
{ 395,    "UpstreamITPIDTranslation",          7,      388,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.14.7 L2VPN-I13 Annex B.3.15.1 */
{ 396,    "DownstreamITPIDTranslation",        8,      388,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.14.8 L2VPN-I13 Annex B.3.15.1 */
{ 397,    "L2CPProcessing",                    15,     202,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.5.15 L2VPN-I13 Annex B.3.16 */
{ 398,    "L2CPTunnelMode",                    1,      397,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 22.43.5.15.1 L2VPN-I13 Annex B.3.16.1 */
{ 399,    "L2CPDMACAddress",                   2,      397,    (encode_ether),          (decode_ether),          0,           0             }, /* TLV 22.43.5.15.2 L2VPN-I13 Annex B.3.16.1 */
{ 400,    "L2CPOverwrotingDMACAddress",        3,      397,    (encode_ether),          (decode_ether),          0,           0             }, /* TLV 22.43.5.15.3 L2VPN-I13 Annex B.3.16.1 */
{ 401,    "DACDisableEnableConfiguration",     16,     202,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 22.43.5.16 L2VPN-I13 Annex B.3.17 */
{ 402,    "PseudowireClass",                   18,     202,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 22.43.5.18 L2VPN-I13 Annex B.3.18 */
{ 403,    "ServiceDelimiter",                  19,     202,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.5.19 L2VPN-I13 Annex B.3.19 */
{ 404,    "CVIDDelimiter",                     1,      403,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.19.1 L2VPN-I13 Annex B.3.19.1 */
{ 405,    "SVIDDelimiter",                     2,      403,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.19.2 L2VPN-I13 Annex B.3.19.2 */
{ 406,    "ISIDDelimiter",                     3,      403,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 22.43.5.19.3 L2VPN-I13 Annex B.3.19.3 */
{ 407,    "BVIDDelimiter",                     4,      403,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.19.4 L2VPN-I13 Annex B.3.19.4 */
{ 408,    "VirtualSwitchInstanceEncoding",     20,     202,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.5.20 L2VPN-I13 Annex B.3.20 */
{ 409,    "VPLSClass",                         1,      408,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 22.43.5.20.1 L2VPN-I13 Annex B.3.20.1 */
{ 410,    "ETreeRole",                         2,      408,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 22.43.5.20.2 L2VPN-I13 Annex B.3.20.2 */
{ 411,    "ETreeRootVID",                      3,      408,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.20.3 L2VPN-I13 Annex B.3.20.3 */
{ 412,    "ETreeLeafVID",                      4,      408,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 22.43.5.20.4 L2VPN-I13 Annex B.3.20.4 */
{ 413,    "BGPAttribute",                      21,     202,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.5.21 L2VPN-I13 Annex B.3.21 */
{ 414,    "BGPVPNID",                          1,      413,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 22.43.5.21.1 L2VPN-I13 Annex B.3.21.1 */
{ 415,    "RouteDistinguisher",                2,      413,    (encode_hexstr),         (decode_hexstr),         8,           8             }, /* TLV 22.43.5.21.2 L2VPN-I13 Annex B.3.21.2 */
{ 416,    "RouteTargetImport",                 3,      413,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 22.43.5.21.3 L2VPN-I13 Annex B.3.21.3 */
{ 417,    "RouteTargetExport",                 4,      413,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 22.43.5.21.4 L2VPN-I13 Annex B.3.21.4 */
{ 418,    "CEIDVEID",                          5,      413,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 22.43.5.21.5 L2VPN-I13 Annex B.3.21.5 */
{ 419,    "PseudowireSignaling",               23,     202,    (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 22.43.5.23 L2VPN-I13 Annex B.3.23 */
{ 420,    "SOAMSubtype",                       24,     202,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.5.24 L2VPN-I13 Annex B.3.24 */
{ 421,    "MEPConfiguration",                  1,      420,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.5.24.1 L2VPN-I13 Annex B.3.24.1 */
{ 422,    "MDLevel",                           1,      421,    (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 22.43.5.24.1.1 L2VPN-I13 Annex B.3.24.1.1 */
{ 423,    "MDName",                            2,      421,    (encode_string),         (decode_string),         2,           16            }, /* TLV 22.43.5.24.1.2 L2VPN-I13 Annex B.3.24.1.2 */
{ 424,    "MAName",                            3,      421,    (encode_string),         (decode_string),         2,           28            }, /* TLV 22.43.5.24.1.3 L2VPN-I13 Annex B.3.24.1.3 */
{ 425,    "MEPID",                             4,      421,    (encode_ushort),         (decode_ushort),         1,           8191          }, /* TLV 22.43.5.24.1.4 L2VPN-I13 Annex B.3.24.1.4 */
{ 426,    "RemoteMEPConfiguration",            2,      420,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.5.24.2 L2VPN-I13 Annex B.3.24.2 */
{ 427,    "RemoteMDLevel",                     1,      426,    (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 22.43.5.24.2.1 L2VPN-I13 Annex B.3.24.2.1 */
{ 428,    "RemoteMDName",                      2,      426,    (encode_string),         (decode_string),         2,           16            }, /* TLV 22.43.5.24.2.2 L2VPN-I13 Annex B.3.24.2.2 */
{ 429,    "RemoteMAName",                      3,      426,    (encode_string),         (decode_string),         2,           28            }, /* TLV 22.43.5.24.2.3 L2VPN-I13 Annex B.3.24.2.3 */
{ 430,    "RemoteMEPID",                       4,      426,    (encode_ushort),         (decode_ushort),         1,           8191          }, /* TLV 22.43.5.24.2.4 L2VPN-I13 Annex B.3.24.2.4 */
{ 431,    "FaultManagementConfiguration",      3,      420,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.5.24.3 L2VPN-I13 Annex B.3.24.3 */
{ 432,    "ContinuityCheckMessages",           1,      431,    (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 22.43.5.24.3.1 L2VPN-I13 Annex B.3.24.3.1 */
{ 433,    "LoopbackFunction",                  2,      431,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 22.43.5.24.3.2 L2VPN-I13 Annex B.3.24.3.2 */
{ 434,    "LinktraceFunction",                 3,      431,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 22.43.5.24.3.3 L2VPN-I13 Annex B.3.24.3.3 */
{ 435,    "PerformanceManagementConfiguration", 4,     420,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.5.24.4 L2VPN-I13 Annex B.3.24.4 */
{ 436,    "FrameDelayMeasurement",             1,      435,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.5.24.4.1 L2VPN-I13 Annex B.3.24.4.1 */
{ 437,    "FrameDelayMeasurementEnable",       1,      436,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 22.43.5.24.4.1.1 L2VPN-I13 Annex B.3.24.4.1.1 */
{ 438,    "FrameDelayMeasurementOneWayTwoWay", 2,      436,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 22.43.5.24.4.1.2 L2VPN-I13 Annex B.3.24.4.1.2 */
{ 439,    "FrameDelayMeasurementTransmissionPeriodicity", 3, 436, (encode_ushort),      (decode_ushort),         0,           0             }, /* TLV 22.43.5.24.4.1.3 L2VPN-I13 Annex B.3.24.4.1.3 */
{ 440,    "FrameLossMeasurement",              2,      435,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.5.24.4.2 L2VPN-I13 Annex B.3.24.4.2 */
{ 441,    "FrameLossMeasurementEnable",        1,      440,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 22.43.5.24.4.2.1 L2VPN-I13 Annex B.3.24.4.2.1 */
{ 442,    "FrameLossMeasurementTransmissionPeriodicity", 2, 440, (encode_ushort),       (decode_ushort),         0,           0             }, /* TLV 22.43.5.24.4.2.2 L2VPN-I13 Annex B.3.24.4.2.2 */
{ 443,    "L2VPNDSID",                         26,     202,    (encode_uint24),         (decode_uint24),         1,           1048575       }, /* TLV 22.43.5.26 L2VPN-I13 Annex B.3.26 */
{ 448,    "VendorSpecificL2VPNSubtype",        43,     202,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.5.43 L2VPN-I13 Annex B.3.11 */
{ 449,    "VendorIdentifier",                  8,      448,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 22.43.5.43.8 L2VPN-I13 Annex B.3.11 */
{ 444,    "ExtendedCMTSMICConfigurationSetting", 6,    200,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.6 MULPIv3.0-I24 Annex C.1.1.18.1.6 */
{ 445,    "ExtendedCMTSMICHMACtype",           1,      444,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 22.43.6.1 MULPIv3.0-I24 Annex C.1.1.18.1.6.1 */
{ 446,    "ExtendedCMTSMICBitmap",             2,      444,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 22.43.6.2 MULPIv3.0-I24 Annex C.1.1.18.1.6.2 */
{ 447,    "ExplicitExtendedCMTSMICDigest",     3,      444,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 22.43.6.3 MULPIv3.0-I24 Annex C.1.1.18.1.6.3 */
{ 450,    "SAVAuthorizationEncoding",          7,      200,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.7 MULPIv3.0-I24 Annex C.1.1.18.1.7 */
{ 451,    "SAVGroupName",                      1,      450,    (encode_string),         (decode_string),         1,           15            }, /* TLV 22.43.7.1 MULPIv3.0-I24 Annex C.1.1.18.1.7.1 */
{ 452,    "SAVStaticPrefixRule",               2,      450,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.7.2 MULPIv3.0-I24 Annex C.1.1.18.1.7.2 */
{ 453,    "SAVStaticPrefixAddress",            1,      452,    (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 22.43.7.2.1 MULPIv3.0-I24 Annex C.1.1.18.1.7.2.1 */
{ 454,    "SAVStaticPrefixLength",             2,      452,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 22.43.7.2.2 MULPIv3.0-I24 Annex C.1.1.18.1.7.2.2 */
{ 201,    "VendorIdentifier",                  8,      200,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 22.43.8 MULPIv3.0-I24 Annex C.2.1.11 */
{ 455,    "CMAttributeMasks",                  9,      200,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.9 MULPIv3.0-I24 Annex C.1.1.18.1.8 */
{ 456,    "CMDownstreamRequiredAttributeMask", 1,      455,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 22.43.9.1 MULPIv3.0-I24 Annex C.1.1.18.1.8.1 */
{ 457,    "CMDownstreamForbiddenAttributeMask", 2,     455,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 22.43.9.2 MULPIv3.0-I24 Annex C.1.1.18.1.8.2 */
{ 458,    "CMUpstreamRequiredAttributeMask",   3,      455,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 22.43.9.3 MULPIv3.0-I24 Annex C.1.1.18.1.8.3 */
{ 459,    "CMUpstreamForbiddenAttributeMask",  4,      455,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 22.43.9.4 MULPIv3.0-I24 Annex C.1.1.18.1.8.4 */
{ 460,    "IPMulticastJoinAuthorization",      10,     200,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.10 MULPIv3.0-I24 Annex C.1.1.18.1.9 */
{ 461,    "IPMulticastProfileName",            1,      460,    (encode_string),         (decode_string),         1,           15            }, /* TLV 22.43.10.1 MULPIv3.0-I24 Annex C.1.1.18.1.9.1 */
{ 462,    "IPMulticastJoinAuthStaticSessionRule", 2,   460,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.10.2 MULPIv3.0-I24 Annex C.1.1.18.1.9.2 */
{ 463,    "MulticastRulePriority",             1,      462,    (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 22.43.10.2.1 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.1 */
{ 464,    "AuthorizationAction",               2,      462,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 22.43.10.2.2 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.2 */
{ 465,    "SourcePrefixAddress",               3,      462,    (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 22.43.10.2.3 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.3 */
{ 466,    "SourcePrefixLength",                4,      462,    (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 22.43.10.2.4 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.4 */
{ 467,    "GroupPrefixAddress",                5,      462,    (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 22.43.10.2.5 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.5 */
{ 468,    "GroupPrefixLength",                 6,      462,    (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 22.43.10.2.6 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.6 */
{ 469,    "MaximumMulticastSessions",          3,      460,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 22.43.10.3 MULPIv3.0-I24 Annex C.1.1.18.1.9.3 */
{ 470,    "ServiceTypeIdentifier",             11,     200,    (encode_string),         (decode_string),         1,           16            }, /* TLV 22.43.11 MULPIv3.0-I24 Annex C.1.1.18.1.10 */
{ 471,    "DEMARCAutoConfiguration",           12,     200,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 22.43.12 MULPIv3.0-I24 Annex C.1.1.18.1.11 */
{ 472,    "DACDisableEnableConfig",            1,      471,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 22.43.12.1 DEMARCv1.0-I04 Annex B.1 */
{ 473,    "CMIMEncoding",                      2,      471,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 22.43.12.2 DEMARCv1.0-I04 Annex B.2 */
{ 474,    "UpstreamServiceClassName",          3,      471,    (encode_strzero),        (decode_strzero),        2,           16            }, /* TLV 22.43.12.3 DEMARCv1.0-I04 Annex B.3 */
{ 475,    "DownstreamServiceClassName",        4,      471,    (encode_strzero),        (decode_strzero),        2,           16            }, /* TLV 22.43.12.4 DEMARCv1.0-I04 Annex B.4 */
{ 54,     "DsPacketClass",                     23,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23 MULPIv3.0-I24 Annex C.2.1.3 */
{ 55,     "ClassifierRef",                     1,      54,     (encode_uchar),          (decode_uchar),          1,           255           }, /* TLV 23.1 MULPIv3.0-I24 Annex C.2.1.4.1 */
{ 56,     "ClassifierId",                      2,      54,     (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 23.2 MULPIv3.0-I24 Annex C.2.1.4.2 */
{ 57,     "ServiceFlowRef",                    3,      54,     (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 23.3 MULPIv3.0-I24 Annex C.2.1.4.3 */
{ 58,     "ServiceFlowId",                     4,      54,     (encode_uint),           (decode_uint),           1,           0xFFFFFFFF    }, /* TLV 23.4 MULPIv3.0-I24 Annex C.2.1.4.4 */
{ 59,     "RulePriority",                      5,      54,     (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 23.5 MULPIv3.0-I24 Annex C.2.1.4.5 */
{ 60,     "ActivationState",                   6,      54,     (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 23.6 MULPIv3.0-I24 Annex C.2.1.4.6 */
{ 61,     "DscAction",                         7,      54,     (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 23.7 MULPIv3.0-I24 Annex C.2.1.4.7 */
{ 62,     "IpPacketClassifier",                9,      54,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.9 MULPIv3.0-I24 Annex C.2.1.6 */
{ 63,     "IpTos",                             1,      62,     (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 23.9.1 MULPIv3.0-I24 Annex C.2.1.6.1 */
{ 64,     "IpProto",                           2,      62,     (encode_ushort),         (decode_ushort),         0,           257           }, /* TLV 23.9.2 MULPIv3.0-I24 Annex C.2.1.6.2 */
{ 65,     "IpSrcAddr",                         3,      62,     (encode_ip),             (decode_ip),             0,           0             }, /* TLV 23.9.3 MULPIv3.0-I24 Annex C.2.1.6.3 */
{ 66,     "IpSrcMask",                         4,      62,     (encode_ip),             (decode_ip),             0,           0             }, /* TLV 23.9.4 MULPIv3.0-I24 Annex C.2.1.6.4 */
{ 67,     "IpDstAddr",                         5,      62,     (encode_ip),             (decode_ip),             0,           0             }, /* TLV 23.9.5 MULPIv3.0-I24 Annex C.2.1.6.5 */
{ 68,     "IpDstMask",                         6,      62,     (encode_ip),             (decode_ip),             0,           0             }, /* TLV 23.9.6 MULPIv3.0-I24 Annex C.2.1.6.6 */
{ 69,     "SrcPortStart",                      7,      62,     (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 23.9.7 MULPIv3.0-I24 Annex C.2.1.7.1 */
{ 70,     "SrcPortEnd",                        8,      62,     (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 23.9.8 MULPIv3.0-I24 Annex C.2.1.7.2 */
{ 71,     "DstPortStart",                      9,      62,     (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 23.9.9 MULPIv3.0-I24 Annex C.2.1.7.3 */
{ 72,     "DstPortEnd",                        10,     62,     (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 23.9.10 MULPIv3.0-I24 Annex C.2.1.7.4 */
{ 73,     "LLCPacketClassifier",               10,     54,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.10 MULPIv3.0-I24 Annex C.2.1.8 */
{ 74,     "DstMacAddress",                     1,      73,     (encode_ethermask),      (decode_ethermask),      0,           0             }, /* TLV 23.10.1 MULPIv3.0-I24 Annex C.2.1.8.1 */
{ 75,     "SrcMacAddress",                     2,      73,     (encode_ether),          (decode_ether),          0,           0             }, /* TLV 23.10.2 MULPIv3.0-I24 Annex C.2.1.8.2 */
{ 76,     "EtherType",                         3,      73,     (encode_hexstr),         (decode_hexstr),         0,           3             }, /* TLV 23.10.3 MULPIv3.0-I24 Annex C.2.1.8.3 */
{ 77,     "IEEE802Classifier",                 11,     54,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.11 MULPIv3.0-I24 Annex C.2.1.9 */
{ 78,     "UserPriority",                      1,      77,     (encode_char_list),      (decode_char_list),      0,           0             }, /* TLV 23.11.1 MULPIv3.0-I24 Annex C.2.1.9.1 */
{ 79,     "VlanID",                            2,      77,     (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 23.11.2 MULPIv3.0-I24 Annex C.2.1.9.2 */
{ 220,    "PcIPv6PacketClassification",        12,     54,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.12 MULPIv3.0-I24 Annex C.2.1.10 */
{ 221,    "PcIPv6TrafficClassRangeAndMask",    1,      220,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 23.12.1 MULPIv3.0-I24 Annex C.2.1.10.1 */
{ 222,    "PcIPv6FlowLabel",                   2,      220,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 23.12.2 MULPIv3.0-I24 Annex C.2.1.10.2 */
{ 223,    "PcIPv6NextHeaderType",              3,      220,    (encode_ushort),         (decode_ushort),         0,           257           }, /* TLV 23.12.3 MULPIv3.0-I24 Annex C.2.1.10.3 */
{ 224,    "PcIPv6SourceAddress",               4,      220,    (encode_ip6),            (decode_ip6),            0,           0             }, /* TLV 23.12.4 MULPIv3.0-I24 Annex C.2.1.10.4 */
{ 225,    "PcIPv6SourcePrefixLength",          5,      220,    (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 23.12.5 MULPIv3.0-I24 Annex C.2.1.10.5 */
{ 226,    "PcIPv6DestAddress",                 6,      220,    (encode_ip6),            (decode_ip6),            0,           0             }, /* TLV 23.12.6 MULPIv3.0-I24 Annex C.2.1.10.6 */
{ 227,    "PcIPv6DestPrefixLength",            7,      220,    (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 23.12.7 MULPIv3.0-I24 Annex C.2.1.10.7 */
{ 289,    "STagCTagFrameClassification",       14,     54,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.14 MULPIv3.0-I24 Annex C.2.1.13 */
{ 290,    "STPID",                             1,      289,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.14.1 MULPIv3.0-I24 Annex C.2.1.13.1 */
{ 291,    "SVID",                              2,      289,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.14.2 MULPIv3.0-I24 Annex C.2.1.13.2 */
{ 292,    "SPCP",                              3,      289,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 23.14.3 MULPIv3.0-I24 Annex C.2.1.13.3 */
{ 293,    "SDEI",                              4,      289,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 23.14.4 MULPIv3.0-I24 Annex C.2.1.13.4 */
{ 294,    "CTPID",                             5,      289,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.14.5 MULPIv3.0-I24 Annex C.2.1.13.5 */
{ 295,    "CVID",                              6,      289,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.14.6 MULPIv3.0-I24 Annex C.2.1.13.6 */
{ 296,    "CPCP",                              7,      289,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 23.14.7 MULPIv3.0-I24 Annex C.2.1.13.7 */
{ 297,    "CCFI",                              8,      289,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 23.14.8 MULPIv3.0-I24 Annex C.2.1.13.8 */
{ 298,    "STCI",                              9,      289,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.14.9 MULPIv3.0-I24 Annex C.2.1.13.9 */
{ 299,    "CTCI",                              10,     289,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.14.10 MULPIv3.0-I24 Annex C.2.1.13.10 */
{ 314,    "IEEE8021ahPacketClassification",    15,     54,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.15 MULPIv3.0-I24 Annex C.2.1.14 */
{ 315,    "ITPID",                             1,      314,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.15.1 MULPIv3.0-I24 Annex C.2.1.14.1 */
{ 316,    "ISID",                              2,      314,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 23.15.2 MULPIv3.0-I24 Annex C.2.1.14.2 */
{ 317,    "ITCI",                              3,      314,    (encode_hexstr),         (decode_hexstr),         5,           5             }, /* TLV 23.15.3 MULPIv3.0-I24 Annex C.2.1.14.3 */
{ 318,    "IPCP",                              4,      314,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 23.15.4 MULPIv3.0-I24 Annex C.2.1.14.4 */
{ 319,    "IDEI",                              5,      314,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 23.15.5 MULPIv3.0-I24 Annex C.2.1.14.5 */
{ 320,    "IUCA",                              6,      314,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 23.15.6 MULPIv3.0-I24 Annex C.2.1.14.6 */
{ 321,    "BTPID",                             7,      314,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.15.7 MULPIv3.0-I24 Annex C.2.1.14.7 */
{ 322,    "BTCI",                              8,      314,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.15.8 MULPIv3.0-I24 Annex C.2.1.14.8 */
{ 323,    "BPCP",                              9,      314,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 23.15.9 MULPIv3.0-I24 Annex C.2.1.14.9 */
{ 324,    "BDEI",                              10,     314,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 23.15.10 MULPIv3.0-I24 Annex C.2.1.14.10 */
{ 325,    "BVID",                              11,     314,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.15.11 MULPIv3.0-I24 Annex C.2.1.14.11 */
{ 326,    "BDA",                               12,     314,    (encode_ether),          (decode_ether),          0,           0             }, /* TLV 23.15.12 MULPIv3.0-I24 Annex C.2.1.14.12 */
{ 327,    "BSA",                               13,     314,    (encode_ether),          (decode_ether),          0,           0             }, /* TLV 23.15.13 MULPIv3.0-I24 Annex C.2.1.14.13 */
{ 331,    "ICMPv4ICMPv6PacketClassification",  16,     54,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.16 MULPIv3.0-I24 Annex C.2.1.12 */
{ 332,    "ICMPv4ICMPv6TypeStart",             1,      331,    (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 23.16.1 MULPIv3.0-I24 Annex C.2.1.12.1 */
{ 333,    "ICMPv4ICMPv6TypeEnd",               2,      331,    (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 23.16.2 MULPIv3.0-I24 Annex C.2.1.12.2 */
{ 337,    "MPLSClassificationEncoding",        17,     54,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.17 MULPIv3.0-I24 Annex C.2.1.15 */
{ 338,    "MPLSTCbits",                        1,      337,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 23.17.1 MULPIv3.0-I24 Annex C.2.1.15.1 */
{ 339,    "MPLSLabel",                         2,      337,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 23.17.2 MULPIv3.0-I24 Annex C.2.1.15.2 */
{ 204,    "VendorSpecific",                    43,     54,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43 MULPIv3.0-I24 Annex C.2.1.11 */
{ 757,    "CMLoadBalancingPolicyID",           1,      204,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 23.43.1 MULPIv3.0-I24 Annex C.1.1.18.1.1 */
{ 758,    "CMLoadBalancingPriority",           2,      204,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 23.43.2 MULPIv3.0-I24 Annex C.1.1.18.1.2 */
{ 759,    "CMLoadBalancingGroupID",            3,      204,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 23.43.3 MULPIv3.0-I24 Annex C.1.1.18.1.3 */
{ 760,    "CMRangingClassIDExtension",         4,      204,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 23.43.4 MULPIv3.0-I24 Annex C.1.1.18.1.4 */
{ 761,    "L2VPNEncoding",                     5,      204,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.5 MULPIv3.0-I24 Annex C.1.1.18.1.5 */
{ 762,    "VPNIdentifier",                     1,      761,    (encode_hexstr),         (decode_hexstr),         4,           255           }, /* TLV 23.43.5.1 L2VPN-I13 Annex B.3.1 */
{ 763,    "NSIEncapsulation",                  2,      761,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.5.2 L2VPN-I13 Annex B.3.2 */
{ 764,    "ServiceMultiplexingValueOther",     1,      763,    (encode_lenzero),        (decode_lenzero),        0,           0             }, /* TLV 23.43.5.2.1 L2VPN-I13 Annex B.3.2 */
{ 765,    "NSIEncapsulationSingleQTag",        2,      763,    (encode_ushort),         (decode_ushort),         0,           4096          }, /* TLV 23.43.5.2.2 L2VPN-I13 Annex B.3.2 */
{ 766,    "NSIEncapsulationDualQTag",          3,      763,    (encode_dual_qtag),      (decode_dual_qtag),      0,           0             }, /* TLV 23.43.5.2.3 L2VPN-I13 Annex B.3.2 */
{ 767,    "ServiceMultiplexingValueMPLSPW",    4,      763,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.5.2.4 L2VPN-I13 Annex B.3.2 */
{ 768,    "MPLSPseudowireID",                  1,      767,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 23.43.5.2.4.1 L2VPN-I13 Annex B.3.2 */
{ 769,    "MPLSPeerIpAddress",                 2,      767,    (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 23.43.5.2.4.2 L2VPN-I13 Annex B.3.2 */
{ 770,    "MPLSPseudowireType",                3,      767,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 23.43.5.2.4.3 L2VPN-I13 Annex B.3.2 */
{ 771,    "MPLSBackupPseudowireID",            4,      767,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 23.43.5.2.4.4 L2VPN-I13 Annex B.3.2 */
{ 772,    "MPLSBackupPeerIpAddress",           5,      767,    (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 23.43.5.2.4.5 L2VPN-I13 Annex B.3.2 */
{ 773,    "ServiceMultiplexingValueL2TPv3Peer", 5,     763,    (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 23.43.5.2.5 L2VPN-I13 Annex B.3.2 */
{ 774,    "IEEE8021ahEncapsulation",           6,      763,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.5.2.6 L2VPN-I13 Annex B.3.2.2 */
{ 775,    "ITCIEncapsulation",                 1,      774,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 23.43.5.2.6.1 L2VPN-I13 Annex B.3.2.2.1 */
{ 776,    "BDAEncapsulation",                  2,      774,    (encode_hexstr),         (decode_hexstr),         6,           6             }, /* TLV 23.43.5.2.6.2 L2VPN-I13 Annex B.3.2.2.2 */
{ 777,    "BTCIEncapsulation",                 3,      774,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.2.6.3 L2VPN-I13 Annex B.3.2.2.3 */
{ 778,    "ITPIDEncapsulation",                4,      774,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.2.6.4 L2VPN-I13 Annex B.3.2.2.4 */
{ 779,    "IPCPEncapsulation",                 5,      774,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 23.43.5.2.6.5 L2VPN-I13 Annex B.3.2.2.5 */
{ 780,    "IDEIEncapsulation",                 6,      774,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 23.43.5.2.6.6 L2VPN-I13 Annex B.3.2.2.6 */
{ 781,    "IUCAEncapsulation",                 7,      774,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 23.43.5.2.6.7 L2VPN-I13 Annex B.3.2.2.7 */
{ 782,    "ISIDEncapsulation",                 8,      774,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 23.43.5.2.6.8 L2VPN-I13 Annex B.3.2.2.8 */
{ 783,    "BTPIDEncapsulation",                9,      774,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.2.6.9 L2VPN-I13 Annex B.3.2.2.9 */
{ 784,    "BPCPEncapsulation",                 10,     774,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 23.43.5.2.6.10 L2VPN-I13 Annex B.3.2.2.10 */
{ 785,    "BDEIEncapsulation",                 11,     774,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 23.43.5.2.6.11 L2VPN-I13 Annex B.3.2.2.11 */
{ 786,    "BVIDEncapsulation",                 12,     774,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.2.6.12 L2VPN-I13 Annex B.3.2.2.11 */
{ 787,    "ServiceMultiplexingValueIEEE8021adSTPID", 8, 763,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.2.8 L2VPN-I13 Annex B.3.2.1 */
{ 788,    "eSAFEDHCPSnooping",                 3,      761,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 23.43.5.3 L2VPN-I13 Annex B.3.3 */
{ 789,    "CMInterfaceMaskCMIMSubtype",        4,      761,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 23.43.5.4 L2VPN-I13 Annex B.3.4 */
{ 790,    "AttachmentGroupID",                 5,      761,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 23.43.5.5 L2VPN-I13 Annex B.3.5 */
{ 791,    "SourceAttachmentIndividualID",      6,      761,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 23.43.5.6 L2VPN-I13 Annex B.3.6 */
{ 792,    "TargetAttachmentIndividualID",      7,      761,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 23.43.5.7 L2VPN-I13 Annex B.3.7 */
{ 793,    "IngressUserPriority",               8,      761,    (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 23.43.5.8 L2VPN-I13 Annex B.3.8 */
{ 794,    "UserPriorityRange",                 9,      761,    (encode_char_list),      (decode_char_list),      0,           0             }, /* TLV 23.43.5.9 L2VPN-I13 Annex B.3.9 */
{ 795,    "L2VPNSADescriptorSubtype",          10,     761,    (encode_hexstr),         (decode_hexstr),         14,          14            }, /* TLV 23.43.5.10 L2VPN-I13 Annex B.3.10 */
{ 796,    "PseudowireType",                    12,     761,    (encode_uchar),          (decode_uchar),          4,           5             }, /* TLV 23.43.5.12 L2VPN-I13 Annex B.3.13 */
{ 797,    "L2VPNMode",                         13,     761,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 23.43.5.13 L2VPN-I13 Annex B.3.14 */
{ 798,    "TPIDTranslation",                   14,     761,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.5.14 L2VPN-I13 Annex B.3.15 */
{ 799,    "UpstreamTPIDTranslation",           1,      798,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.14.1 L2VPN-I13 Annex B.3.15.1 */
{ 800,    "DownstreamTPIDTranslation",         2,      798,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.14.2 L2VPN-I13 Annex B.3.15.1 */
{ 801,    "UpstreamSTPIDTranslation",          3,      798,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.14.3 L2VPN-I13 Annex B.3.15.1 */
{ 802,    "DownstreamSTPIDTranslation",        4,      798,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.14.4 L2VPN-I13 Annex B.3.15.1 */
{ 803,    "UpstreamBTPIDTranslation",          5,      798,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.14.5 L2VPN-I13 Annex B.3.15.1 */
{ 804,    "DownstreamBTPIDTranslation",        6,      798,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.14.6 L2VPN-I13 Annex B.3.15.1 */
{ 805,    "UpstreamITPIDTranslation",          7,      798,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.14.7 L2VPN-I13 Annex B.3.15.1 */
{ 806,    "DownstreamITPIDTranslation",        8,      798,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.14.8 L2VPN-I13 Annex B.3.15.1 */
{ 807,    "L2CPProcessing",                    15,     761,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.5.15 L2VPN-I13 Annex B.3.16 */
{ 808,    "L2CPTunnelMode",                    1,      807,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 23.43.5.15.1 L2VPN-I13 Annex B.3.16.1 */
{ 809,    "L2CPDMACAddress",                   2,      807,    (encode_ether),          (decode_ether),          0,           0             }, /* TLV 23.43.5.15.2 L2VPN-I13 Annex B.3.16.1 */
{ 810,    "L2CPOverwrotingDMACAddress",        3,      807,    (encode_ether),          (decode_ether),          0,           0             }, /* TLV 23.43.5.15.3 L2VPN-I13 Annex B.3.16.1 */
{ 811,    "DACDisableEnableConfiguration",     16,     761,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 23.43.5.16 L2VPN-I13 Annex B.3.17 */
{ 812,    "PseudowireClass",                   18,     761,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 23.43.5.18 L2VPN-I13 Annex B.3.18 */
{ 813,    "ServiceDelimiter",                  19,     761,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.5.19 L2VPN-I13 Annex B.3.19 */
{ 814,    "CVIDDelimiter",                     1,      813,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.19.1 L2VPN-I13 Annex B.3.19.1 */
{ 815,    "SVIDDelimiter",                     2,      813,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.19.2 L2VPN-I13 Annex B.3.19.2 */
{ 816,    "ISIDDelimiter",                     3,      813,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 23.43.5.19.3 L2VPN-I13 Annex B.3.19.3 */
{ 817,    "BVIDDelimiter",                     4,      813,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.19.4 L2VPN-I13 Annex B.3.19.4 */
{ 818,    "VirtualSwitchInstanceEncoding",     20,     761,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.5.20 L2VPN-I13 Annex B.3.20 */
{ 819,    "VPLSClass",                         1,      818,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 23.43.5.20.1 L2VPN-I13 Annex B.3.20.1 */
{ 820,    "ETreeRole",                         2,      818,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 23.43.5.20.2 L2VPN-I13 Annex B.3.20.2 */
{ 821,    "ETreeRootVID",                      3,      818,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.20.3 L2VPN-I13 Annex B.3.20.3 */
{ 822,    "ETreeLeafVID",                      4,      818,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 23.43.5.20.4 L2VPN-I13 Annex B.3.20.4 */
{ 823,    "BGPAttribute",                      21,     761,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.5.21 L2VPN-I13 Annex B.3.21 */
{ 824,    "BGPVPNID",                          1,      823,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 23.43.5.21.1 L2VPN-I13 Annex B.3.21.1 */
{ 825,    "RouteDistinguisher",                2,      823,    (encode_hexstr),         (decode_hexstr),         8,           8             }, /* TLV 23.43.5.21.2 L2VPN-I13 Annex B.3.21.2 */
{ 826,    "RouteTargetImport",                 3,      823,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 23.43.5.21.3 L2VPN-I13 Annex B.3.21.3 */
{ 827,    "RouteTargetExport",                 4,      823,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 23.43.5.21.4 L2VPN-I13 Annex B.3.21.4 */
{ 828,    "CEIDVEID",                          5,      823,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 23.43.5.21.5 L2VPN-I13 Annex B.3.21.5 */
{ 829,    "PseudowireSignaling",               23,     761,    (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 23.43.5.23 L2VPN-I13 Annex B.3.23 */
{ 830,    "SOAMSubtype",                       24,     761,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.5.24 L2VPN-I13 Annex B.3.24 */
{ 831,    "MEPConfiguration",                  1,      830,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.5.24.1 L2VPN-I13 Annex B.3.24.1 */
{ 832,    "MDLevel",                           1,      831,    (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 23.43.5.24.1.1 L2VPN-I13 Annex B.3.24.1.1 */
{ 833,    "MDName",                            2,      831,    (encode_string),         (decode_string),         2,           16            }, /* TLV 23.43.5.24.1.2 L2VPN-I13 Annex B.3.24.1.2 */
{ 834,    "MAName",                            3,      831,    (encode_string),         (decode_string),         2,           28            }, /* TLV 23.43.5.24.1.3 L2VPN-I13 Annex B.3.24.1.3 */
{ 835,    "MEPID",                             4,      831,    (encode_ushort),         (decode_ushort),         1,           8191          }, /* TLV 23.43.5.24.1.4 L2VPN-I13 Annex B.3.24.1.4 */
{ 836,    "RemoteMEPConfiguration",            2,      830,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.5.24.2 L2VPN-I13 Annex B.3.24.2 */
{ 837,    "RemoteMDLevel",                     1,      836,    (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 23.43.5.24.2.1 L2VPN-I13 Annex B.3.24.2.1 */
{ 838,    "RemoteMDName",                      2,      836,    (encode_string),         (decode_string),         2,           16            }, /* TLV 23.43.5.24.2.2 L2VPN-I13 Annex B.3.24.2.2 */
{ 839,    "RemoteMAName",                      3,      836,    (encode_string),         (decode_string),         2,           28            }, /* TLV 23.43.5.24.2.3 L2VPN-I13 Annex B.3.24.2.3 */
{ 840,    "RemoteMEPID",                       4,      836,    (encode_ushort),         (decode_ushort),         1,           8191          }, /* TLV 23.43.5.24.2.4 L2VPN-I13 Annex B.3.24.2.4 */
{ 841,    "FaultManagementConfiguration",      3,      830,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.5.24.3 L2VPN-I13 Annex B.3.24.3 */
{ 842,    "ContinuityCheckMessages",           1,      841,    (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 23.43.5.24.3.1 L2VPN-I13 Annex B.3.24.3.1 */
{ 843,    "LoopbackFunction",                  2,      841,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 23.43.5.24.3.2 L2VPN-I13 Annex B.3.24.3.2 */
{ 844,    "LinktraceFunction",                 3,      841,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 23.43.5.24.3.3 L2VPN-I13 Annex B.3.24.3.3 */
{ 845,    "PerformanceManagementConfiguration", 4,     830,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.5.24.4 L2VPN-I13 Annex B.3.24.4 */
{ 846,    "FrameDelayMeasurement",             1,      845,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.5.24.4.1 L2VPN-I13 Annex B.3.24.4.1 */
{ 847,    "FrameDelayMeasurementEnable",       1,      846,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 23.43.5.24.4.1.1 L2VPN-I13 Annex B.3.24.4.1.1 */
{ 848,    "FrameDelayMeasurementOneWayTwoWay", 2,      846,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 23.43.5.24.4.1.2 L2VPN-I13 Annex B.3.24.4.1.2 */
{ 849,    "FrameDelayMeasurementTransmissionPeriodicity", 3, 846, (encode_ushort),      (decode_ushort),         0,           0             }, /* TLV 23.43.5.24.4.1.3 L2VPN-I13 Annex B.3.24.4.1.3 */
{ 850,    "FrameLossMeasurement",              2,      845,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.5.24.4.2 L2VPN-I13 Annex B.3.24.4.2 */
{ 851,    "FrameLossMeasurementEnable",        1,      850,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 23.43.5.24.4.2.1 L2VPN-I13 Annex B.3.24.4.2.1 */
{ 852,    "FrameLossMeasurementTransmissionPeriodicity", 2, 850, (encode_ushort),       (decode_ushort),         0,           0             }, /* TLV 23.43.5.24.4.2.2 L2VPN-I13 Annex B.3.24.4.2.2 */
{ 853,    "L2VPNDSID",                         26,     761,    (encode_uint24),         (decode_uint24),         1,           1048575       }, /* TLV 23.43.5.26 L2VPN-I13 Annex B.3.26 */
{ 854,    "VendorSpecificL2VPNSubtype",        43,     761,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.5.43 L2VPN-I13 Annex B.3.11 */
{ 206,    "VendorIdentifier",                  8,      854,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 23.43.5.43.8 L2VPN-I13 Annex B.3.11 */
{ 855,    "ExtendedCMTSMICConfigurationSetting", 6,    204,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.6 MULPIv3.0-I24 Annex C.1.1.18.1.6 */
{ 856,    "ExtendedCMTSMICHMACtype",           1,      855,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 23.43.6.1 MULPIv3.0-I24 Annex C.1.1.18.1.6.1 */
{ 857,    "ExtendedCMTSMICBitmap",             2,      855,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 23.43.6.2 MULPIv3.0-I24 Annex C.1.1.18.1.6.2 */
{ 858,    "ExplicitExtendedCMTSMICDigest",     3,      855,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 23.43.6.3 MULPIv3.0-I24 Annex C.1.1.18.1.6.3 */
{ 859,    "SAVAuthorizationEncoding",          7,      204,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.7 MULPIv3.0-I24 Annex C.1.1.18.1.7 */
{ 860,    "SAVGroupName",                      1,      859,    (encode_string),         (decode_string),         1,           15            }, /* TLV 23.43.7.1 MULPIv3.0-I24 Annex C.1.1.18.1.7.1 */
{ 861,    "SAVStaticPrefixRule",               2,      859,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.7.2 MULPIv3.0-I24 Annex C.1.1.18.1.7.2 */
{ 862,    "SAVStaticPrefixAddress",            1,      861,    (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 23.43.7.2.1 MULPIv3.0-I24 Annex C.1.1.18.1.7.2.1 */
{ 863,    "SAVStaticPrefixLength",             2,      861,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 23.43.7.2.2 MULPIv3.0-I24 Annex C.1.1.18.1.7.2.2 */
{ 864,    "VendorIdentifier",                  8,      204,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 23.43.8 MULPIv3.0-I24 Annex C.2.1.11 */
{ 865,    "CMAttributeMasks",                  9,      204,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.9 MULPIv3.0-I24 Annex C.1.1.18.1.8 */
{ 866,    "CMDownstreamRequiredAttributeMask", 1,      865,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 23.43.9.1 MULPIv3.0-I24 Annex C.1.1.18.1.8.1 */
{ 867,    "CMDownstreamForbiddenAttributeMask", 2,     865,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 23.43.9.2 MULPIv3.0-I24 Annex C.1.1.18.1.8.2 */
{ 868,    "CMUpstreamRequiredAttributeMask",   3,      865,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 23.43.9.3 MULPIv3.0-I24 Annex C.1.1.18.1.8.3 */
{ 869,    "CMUpstreamForbiddenAttributeMask",  4,      865,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 23.43.9.4 MULPIv3.0-I24 Annex C.1.1.18.1.8.4 */
{ 870,    "IPMulticastJoinAuthorization",      10,     204,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.10 MULPIv3.0-I24 Annex C.1.1.18.1.9 */
{ 871,    "IPMulticastProfileName",            1,      870,    (encode_string),         (decode_string),         1,           15            }, /* TLV 23.43.10.1 MULPIv3.0-I24 Annex C.1.1.18.1.9.1 */
{ 872,    "IPMulticastJoinAuthStaticSessionRule", 2,   870,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.10.2 MULPIv3.0-I24 Annex C.1.1.18.1.9.2 */
{ 873,    "MulticastRulePriority",             1,      872,    (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 23.43.10.2.1 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.1 */
{ 874,    "AuthorizationAction",               2,      872,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 23.43.10.2.2 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.2 */
{ 875,    "SourcePrefixAddress",               3,      872,    (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 23.43.10.2.3 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.3 */
{ 876,    "SourcePrefixLength",                4,      872,    (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 23.43.10.2.4 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.4 */
{ 877,    "GroupPrefixAddress",                5,      872,    (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 23.43.10.2.5 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.5 */
{ 878,    "GroupPrefixLength",                 6,      872,    (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 23.43.10.2.6 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.6 */
{ 879,    "MaximumMulticastSessions",          3,      870,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 23.43.10.3 MULPIv3.0-I24 Annex C.1.1.18.1.9.3 */
{ 880,    "ServiceTypeIdentifier",             11,     204,    (encode_string),         (decode_string),         1,           16            }, /* TLV 23.43.11 MULPIv3.0-I24 Annex C.1.1.18.1.10 */
{ 881,    "DEMARCAutoConfiguration",           12,     204,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 23.43.12 MULPIv3.0-I24 Annex C.1.1.18.1.11 */
{ 882,    "DACDisableEnableConfig",            1,      881,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 23.43.12.1 DEMARCv1.0-I04 Annex B.1 */
{ 883,    "CMIMEncoding",                      2,      881,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 23.43.12.2 DEMARCv1.0-I04 Annex B.2 */
{ 884,    "UpstreamServiceClassName",          3,      881,    (encode_strzero),        (decode_strzero),        2,           16            }, /* TLV 23.43.12.3 DEMARCv1.0-I04 Annex B.3 */
{ 885,    "DownstreamServiceClassName",        4,      881,    (encode_strzero),        (decode_strzero),        2,           16            }, /* TLV 23.43.12.4 DEMARCv1.0-I04 Annex B.4 */
{ 80,     "UsServiceFlow",                     24,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24 MULPIv3.0-I24 Annex C.2.2.5 */
{ 81,     "UsServiceFlowRef",                  1,      80,     (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 24.1 MULPIv3.0-I24 Annex C.2.2.5.1 */
{ 82,     "UsServiceFlowId",                   2,      80,     (encode_uint),           (decode_uint),           1,           0xFFFFFFFF    }, /* TLV 24.2 MULPIv3.0-I24 Annex C.2.2.5.2 */
{ 614,    "ServiceIdentifier",                 3,      80,     (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 24.3 MULPIv3.0-I24 Annex C.2.2.5.3 */                                                                                                                                               /* TLV 24.3 MULPIv3.0-I24 Annex C.2.2.5.3 */
{ 83,     "ServiceClassName",                  4,      80,     (encode_strzero),        (decode_strzero),        2,           16            }, /* TLV 24.4 MULPIv3.0-I24 Annex C.2.2.5.4 */
{ 84,     "QosParamSetType",                   6,      80,     (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 24.6 MULPIv3.0-I24 Annex C.2.2.5.5 */
{ 85,     "TrafficPriority",                   7,      80,     (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 24.7 MULPIv3.0-I24 Annex C.2.2.7.1 */
{ 86,     "MaxRateSustained",                  8,      80,     (encode_uint),           (decode_uint),           0,           0             }, /* TLV 24.8 MULPIv3.0-I24 Annex C.2.2.7.2.1 */
{ 87,     "MaxTrafficBurst",                   9,      80,     (encode_uint),           (decode_uint),           0,           0             }, /* TLV 24.9 MULPIv3.0-I24 Annex C.2.2.7.3 */
{ 88,     "MinReservedRate",                   10,     80,     (encode_uint),           (decode_uint),           0,           0             }, /* TLV 24.10 MULPIv3.0-I24 Annex C.2.2.7.4 */
{ 89,     "MinResPacketSize",                  11,     80,     (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 24.11 MULPIv3.0-I24 Annex C.2.2.7.5 */
{ 90,     "ActQosParamsTimeout",               12,     80,     (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 24.12 MULPIv3.0-I24 Annex C.2.2.7.6 */
{ 91,     "AdmQosParamsTimeout",               13,     80,     (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 24.13 MULPIv3.0-I24 Annex C.2.2.7.7 */
{ 92,     "MaxConcatenatedBurst",              14,     80,     (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 24.14 MULPIv3.0-I24 Annex C.2.2.8.1 */
{ 93,     "SchedulingType",                    15,     80,     (encode_uchar),          (decode_uchar),          0,           6             }, /* TLV 24.15 MULPIv3.0-I24 Annex C.2.2.8.2 */
{ 94,     "RequestOrTxPolicy",                 16,     80,     (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 24.16 MULPIv3.0-I24 Annex C.2.2.8.3 */
{ 95,     "NominalPollInterval",               17,     80,     (encode_uint),           (decode_uint),           0,           0             }, /* TLV 24.17 MULPIv3.0-I24 Annex C.2.2.8.4 */
{ 96,     "ToleratedPollJitter",               18,     80,     (encode_uint),           (decode_uint),           0,           0             }, /* TLV 24.18 MULPIv3.0-I24 Annex C.2.2.8.5 */
{ 97,     "UnsolicitedGrantSize",              19,     80,     (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 24.19 MULPIv3.0-I24 Annex C.2.2.8.6 */
{ 98,     "NominalGrantInterval",              20,     80,     (encode_uint),           (decode_uint),           0,           0             }, /* TLV 24.20 MULPIv3.0-I24 Annex C.2.2.8.7 */
{ 99,     "ToleratedGrantJitter",              21,     80,     (encode_uint),           (decode_uint),           0,           0             }, /* TLV 24.21 MULPIv3.0-I24 Annex C.2.2.8.8 */
{ 100,    "GrantsPerInterval",                 22,     80,     (encode_uchar),          (decode_uchar),          0,           127           }, /* TLV 24.22 MULPIv3.0-I24 Annex C.2.2.8.9 */
{ 101,    "IpTosOverwrite",                    23,     80,     (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.23 MULPIv3.0-I24 Annex C.2.2.7.9 */
{ 741,    "MultipliertoNumberofBytesRequested", 26,    80,     (encode_uchar),          (decode_uchar),          1,           16            }, /* TLV 24.26 MULPIv3.0-I24 Annex C.2.2.8.12 */
{ 742,    "UpstreamPeakTrafficRate",           27,     80,     (encode_uint),           (decode_uint),           0,           0             }, /* TLV 24.27 MULPIv3.0-I24 Annex C.2.2.7.10.1 */
{ 743,    "ServiceFlowRequiredAttributeMask",  31,     80,     (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 24.31 MULPIv3.0-I24 Annex C.2.2.5.6 */
{ 744,    "ServiceFlowForbiddenAttributeMask", 32,     80,     (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 24.32 MULPIv3.0-I24 Annex C.2.2.5.7 */
{ 745,    "ServiceFlowAttributeAggregationRuleMask", 33, 80,   (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 24.33 MULPIv3.0-I24 Annex C.2.2.5.8 */
{ 746,    "ApplicationIdentifier",             34,     80,     (encode_uint),           (decode_uint),           0,           0             }, /* TLV 24.34 MULPIv3.0-I24 Annex C.2.2.5.9 */
{ 747,    "BufferControl",                     35,     80,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.35 MULPIv3.0-I24 Annex C.2.2.7.11.1 */
{ 748,    "MinimumBuffer",                     1,      747,    (encode_uint),           (decode_uint),           0,           4294967295    }, /* TLV 24.35.1 MULPIv3.0-I24 Annex C.2.2.7.11.3 */
{ 749,    "TargetBuffer",                      2,      747,    (encode_uint),           (decode_uint),           0,           4294967295    }, /* TLV 24.35.2 MULPIv3.0-I24 Annex C.2.2.7.11.4 */
{ 750,    "MaximumBuffer",                     3,      747,    (encode_uint),           (decode_uint),           0,           4294967295    }, /* TLV 24.35.3 MULPIv3.0-I24 Annex C.2.2.7.11.5 */
{ 751,    "UpstreamAggregateServiceFlowReference", 36, 80,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.36 MULPIv3.0-I24 Annex C.2.2.5.10 */
{ 752,    "UpstreamMESPReference",             37,     80,     (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 24.37 MULPIv3.0-I24 Annex C.2.2.5.11 */
{ 753,    "AQMEncodings",                      40,     80,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.40 MULPIv3.0-I24 Annex C.2.2.7.12 */
{ 754,    "SFAQMDisable",                      1,      753,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 24.40.1 MULPIv3.0-I24 Annex C.2.2.7.12.3 */
{ 755,    "SFAQMLatencyTarget",                2,      753,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 24.40.2 MULPIv3.0-I24 Annex C.2.2.7.12.4 */
{ 756,    "DataRateUnitSetting",               41,     80,     (encode_uchar),          (decode_uchar),          0,           3             }, /* TLV 24.41 MULPIv3.0-I24 Annex C.2.2.7.13.1 */
{ 205,    "VendorSpecific",                    43,     80,     (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43 MULPIv3.0-I24 Annex C.2.1.11 */
{ 207,    "CMLoadBalancingPolicyID",           1,      205,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 24.43.1 MULPIv3.0-I24 Annex C.1.1.18.1.1 */
{ 192,    "CMLoadBalancingPriority",           2,      205,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 24.43.2 MULPIv3.0-I24 Annex C.1.1.18.1.2 */
{ 193,    "CMLoadBalancingGroupID",            3,      205,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 24.43.3 MULPIv3.0-I24 Annex C.1.1.18.1.3 */
{ 194,    "CMRangingClassIDExtension",         4,      205,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 24.43.4 MULPIv3.0-I24 Annex C.1.1.18.1.4 */
{ 195,    "L2VPNEncoding",                     5,      205,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.5 MULPIv3.0-I24 Annex C.1.1.18.1.5 */
{ 886,    "VPNIdentifier",                     1,      195,    (encode_hexstr),         (decode_hexstr),         4,           255           }, /* TLV 24.43.5.1 L2VPN-I13 Annex B.3.1 */
{ 887,    "NSIEncapsulation",                  2,      195,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.5.2 L2VPN-I13 Annex B.3.2 */
{ 888,    "ServiceMultiplexingValueOther",     1,      887,    (encode_lenzero),        (decode_lenzero),        0,           0             }, /* TLV 24.43.5.2.1 L2VPN-I13 Annex B.3.2 */
{ 889,    "NSIEncapsulationSingleQTag",        2,      887,    (encode_ushort),         (decode_ushort),         0,           4096          }, /* TLV 24.43.5.2.2 L2VPN-I13 Annex B.3.2 */
{ 890,    "NSIEncapsulationDualQTag",          3,      887,    (encode_dual_qtag),      (decode_dual_qtag),      0,           0             }, /* TLV 24.43.5.2.3 L2VPN-I13 Annex B.3.2 */
{ 891,    "ServiceMultiplexingValueMPLSPW",    4,      887,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.5.2.4 L2VPN-I13 Annex B.3.2 */
{ 892,    "MPLSPseudowireID",                  1,      891,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 24.43.5.2.4.1 L2VPN-I13 Annex B.3.2 */
{ 893,    "MPLSPeerIpAddress",                 2,      891,    (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 24.43.5.2.4.2 L2VPN-I13 Annex B.3.2 */
{ 894,    "MPLSPseudowireType",                3,      891,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 24.43.5.2.4.3 L2VPN-I13 Annex B.3.2 */
{ 895,    "MPLSBackupPseudowireID",            4,      891,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 24.43.5.2.4.4 L2VPN-I13 Annex B.3.2 */
{ 896,    "MPLSBackupPeerIpAddress",           5,      891,    (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 24.43.5.2.4.5 L2VPN-I13 Annex B.3.2 */
{ 897,    "ServiceMultiplexingValueL2TPv3Peer", 5,     887,    (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 24.43.5.2.5 L2VPN-I13 Annex B.3.2 */
{ 898,    "IEEE8021ahEncapsulation",           6,      887,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.5.2.6 L2VPN-I13 Annex B.3.2.2 */
{ 899,    "ITCIEncapsulation",                 1,      898,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 24.43.5.2.6.1 L2VPN-I13 Annex B.3.2.2.1 */
{ 900,    "BDAEncapsulation",                  2,      898,    (encode_hexstr),         (decode_hexstr),         6,           6             }, /* TLV 24.43.5.2.6.2 L2VPN-I13 Annex B.3.2.2.2 */
{ 901,    "BTCIEncapsulation",                 3,      898,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.2.6.3 L2VPN-I13 Annex B.3.2.2.3 */
{ 902,    "ITPIDEncapsulation",                4,      898,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.2.6.4 L2VPN-I13 Annex B.3.2.2.4 */
{ 903,    "IPCPEncapsulation",                 5,      898,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 24.43.5.2.6.5 L2VPN-I13 Annex B.3.2.2.5 */
{ 904,    "IDEIEncapsulation",                 6,      898,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 24.43.5.2.6.6 L2VPN-I13 Annex B.3.2.2.6 */
{ 905,    "IUCAEncapsulation",                 7,      898,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 24.43.5.2.6.7 L2VPN-I13 Annex B.3.2.2.7 */
{ 906,    "ISIDEncapsulation",                 8,      898,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 24.43.5.2.6.8 L2VPN-I13 Annex B.3.2.2.8 */
{ 907,    "BTPIDEncapsulation",                9,      898,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.2.6.9 L2VPN-I13 Annex B.3.2.2.9 */
{ 908,    "BPCPEncapsulation",                 10,     898,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 24.43.5.2.6.10 L2VPN-I13 Annex B.3.2.2.10 */
{ 909,    "BDEIEncapsulation",                 11,     898,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 24.43.5.2.6.11 L2VPN-I13 Annex B.3.2.2.11 */
{ 910,    "BVIDEncapsulation",                 12,     898,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.2.6.12 L2VPN-I13 Annex B.3.2.2.11 */
{ 911,    "ServiceMultiplexingValueIEEE8021adSTPID", 8, 887,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.2.8 L2VPN-I13 Annex B.3.2.1 */
{ 912,    "eSAFEDHCPSnooping",                 3,      195,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 24.43.5.3 L2VPN-I13 Annex B.3.3 */
{ 913,    "CMInterfaceMaskCMIMSubtype",        4,      195,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 24.43.5.4 L2VPN-I13 Annex B.3.4 */
{ 914,    "AttachmentGroupID",                 5,      195,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 24.43.5.5 L2VPN-I13 Annex B.3.5 */
{ 915,    "SourceAttachmentIndividualID",      6,      195,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 24.43.5.6 L2VPN-I13 Annex B.3.6 */
{ 916,    "TargetAttachmentIndividualID",      7,      195,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 24.43.5.7 L2VPN-I13 Annex B.3.7 */
{ 917,    "IngressUserPriority",               8,      195,    (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 24.43.5.8 L2VPN-I13 Annex B.3.8 */
{ 918,    "UserPriorityRange",                 9,      195,    (encode_char_list),      (decode_char_list),      0,           0             }, /* TLV 24.43.5.9 L2VPN-I13 Annex B.3.9 */
{ 919,    "L2VPNSADescriptorSubtype",          10,     195,    (encode_hexstr),         (decode_hexstr),         14,          14            }, /* TLV 24.43.5.10 L2VPN-I13 Annex B.3.10 */
{ 920,    "PseudowireType",                    12,     195,    (encode_uchar),          (decode_uchar),          4,           5             }, /* TLV 24.43.5.12 L2VPN-I13 Annex B.3.13 */
{ 921,    "L2VPNMode",                         13,     195,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 24.43.5.13 L2VPN-I13 Annex B.3.14 */
{ 922,    "TPIDTranslation",                   14,     195,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.5.14 L2VPN-I13 Annex B.3.15 */
{ 923,    "UpstreamTPIDTranslation",           1,      922,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.14.1 L2VPN-I13 Annex B.3.15.1 */
{ 924,    "DownstreamTPIDTranslation",         2,      922,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.14.2 L2VPN-I13 Annex B.3.15.1 */
{ 925,    "UpstreamSTPIDTranslation",          3,      922,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.14.3 L2VPN-I13 Annex B.3.15.1 */
{ 926,    "DownstreamSTPIDTranslation",        4,      922,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.14.4 L2VPN-I13 Annex B.3.15.1 */
{ 927,    "UpstreamBTPIDTranslation",          5,      922,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.14.5 L2VPN-I13 Annex B.3.15.1 */
{ 928,    "DownstreamBTPIDTranslation",        6,      922,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.14.6 L2VPN-I13 Annex B.3.15.1 */
{ 929,    "UpstreamITPIDTranslation",          7,      922,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.14.7 L2VPN-I13 Annex B.3.15.1 */
{ 930,    "DownstreamITPIDTranslation",        8,      922,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.14.8 L2VPN-I13 Annex B.3.15.1 */
{ 931,    "L2CPProcessing",                    15,     195,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.5.15 L2VPN-I13 Annex B.3.16 */
{ 932,    "L2CPTunnelMode",                    1,      931,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 24.43.5.15.1 L2VPN-I13 Annex B.3.16.1 */
{ 933,    "L2CPDMACAddress",                   2,      931,    (encode_ether),          (decode_ether),          0,           0             }, /* TLV 24.43.5.15.2 L2VPN-I13 Annex B.3.16.1 */
{ 934,    "L2CPOverwrotingDMACAddress",        3,      931,    (encode_ether),          (decode_ether),          0,           0             }, /* TLV 24.43.5.15.3 L2VPN-I13 Annex B.3.16.1 */
{ 935,    "DACDisableEnableConfiguration",     16,     195,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 24.43.5.16 L2VPN-I13 Annex B.3.17 */
{ 936,    "PseudowireClass",                   18,     195,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 24.43.5.18 L2VPN-I13 Annex B.3.18 */
{ 937,    "ServiceDelimiter",                  19,     195,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.5.19 L2VPN-I13 Annex B.3.19 */
{ 938,    "CVIDDelimiter",                     1,      937,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.19.1 L2VPN-I13 Annex B.3.19.1 */
{ 939,    "SVIDDelimiter",                     2,      937,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.19.2 L2VPN-I13 Annex B.3.19.2 */
{ 940,    "ISIDDelimiter",                     3,      937,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 24.43.5.19.3 L2VPN-I13 Annex B.3.19.3 */
{ 941,    "BVIDDelimiter",                     4,      937,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.19.4 L2VPN-I13 Annex B.3.19.4 */
{ 942,    "VirtualSwitchInstanceEncoding",     20,     195,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.5.20 L2VPN-I13 Annex B.3.20 */
{ 943,    "VPLSClass",                         1,      942,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 24.43.5.20.1 L2VPN-I13 Annex B.3.20.1 */
{ 944,    "ETreeRole",                         2,      942,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 24.43.5.20.2 L2VPN-I13 Annex B.3.20.2 */
{ 945,    "ETreeRootVID",                      3,      942,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.20.3 L2VPN-I13 Annex B.3.20.3 */
{ 946,    "ETreeLeafVID",                      4,      942,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 24.43.5.20.4 L2VPN-I13 Annex B.3.20.4 */
{ 947,    "BGPAttribute",                      21,     195,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.5.21 L2VPN-I13 Annex B.3.21 */
{ 948,    "BGPVPNID",                          1,      947,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 24.43.5.21.1 L2VPN-I13 Annex B.3.21.1 */
{ 949,    "RouteDistinguisher",                2,      947,    (encode_hexstr),         (decode_hexstr),         8,           8             }, /* TLV 24.43.5.21.2 L2VPN-I13 Annex B.3.21.2 */
{ 950,    "RouteTargetImport",                 3,      947,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 24.43.5.21.3 L2VPN-I13 Annex B.3.21.3 */
{ 951,    "RouteTargetExport",                 4,      947,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 24.43.5.21.4 L2VPN-I13 Annex B.3.21.4 */
{ 952,    "CEIDVEID",                          5,      947,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 24.43.5.21.5 L2VPN-I13 Annex B.3.21.5 */
{ 953,    "PseudowireSignaling",               23,     195,    (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 24.43.5.23 L2VPN-I13 Annex B.3.23 */
{ 954,    "SOAMSubtype",                       24,     195,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.5.24 L2VPN-I13 Annex B.3.24 */
{ 955,    "MEPConfiguration",                  1,      954,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.5.24.1 L2VPN-I13 Annex B.3.24.1 */
{ 956,    "MDLevel",                           1,      955,    (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 24.43.5.24.1.1 L2VPN-I13 Annex B.3.24.1.1 */
{ 957,    "MDName",                            2,      955,    (encode_string),         (decode_string),         2,           16            }, /* TLV 24.43.5.24.1.2 L2VPN-I13 Annex B.3.24.1.2 */
{ 958,    "MAName",                            3,      955,    (encode_string),         (decode_string),         2,           28            }, /* TLV 24.43.5.24.1.3 L2VPN-I13 Annex B.3.24.1.3 */
{ 959,    "MEPID",                             4,      955,    (encode_ushort),         (decode_ushort),         1,           8191          }, /* TLV 24.43.5.24.1.4 L2VPN-I13 Annex B.3.24.1.4 */
{ 960,    "RemoteMEPConfiguration",            2,      954,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.5.24.2 L2VPN-I13 Annex B.3.24.2 */
{ 961,    "RemoteMDLevel",                     1,      960,    (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 24.43.5.24.2.1 L2VPN-I13 Annex B.3.24.2.1 */
{ 962,    "RemoteMDName",                      2,      960,    (encode_string),         (decode_string),         2,           16            }, /* TLV 24.43.5.24.2.2 L2VPN-I13 Annex B.3.24.2.2 */
{ 963,    "RemoteMAName",                      3,      960,    (encode_string),         (decode_string),         2,           28            }, /* TLV 24.43.5.24.2.3 L2VPN-I13 Annex B.3.24.2.3 */
{ 964,    "RemoteMEPID",                       4,      960,    (encode_ushort),         (decode_ushort),         1,           8191          }, /* TLV 24.43.5.24.2.4 L2VPN-I13 Annex B.3.24.2.4 */
{ 965,    "FaultManagementConfiguration",      3,      954,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.5.24.3 L2VPN-I13 Annex B.3.24.3 */
{ 966,    "ContinuityCheckMessages",           1,      965,    (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 24.43.5.24.3.1 L2VPN-I13 Annex B.3.24.3.1 */
{ 967,    "LoopbackFunction",                  2,      965,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 24.43.5.24.3.2 L2VPN-I13 Annex B.3.24.3.2 */
{ 968,    "LinktraceFunction",                 3,      965,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 24.43.5.24.3.3 L2VPN-I13 Annex B.3.24.3.3 */
{ 969,    "PerformanceManagementConfiguration", 4,     954,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.5.24.4 L2VPN-I13 Annex B.3.24.4 */
{ 970,    "FrameDelayMeasurement",             1,      969,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.5.24.4.1 L2VPN-I13 Annex B.3.24.4.1 */
{ 971,    "FrameDelayMeasurementEnable",       1,      970,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 24.43.5.24.4.1.1 L2VPN-I13 Annex B.3.24.4.1.1 */
{ 972,    "FrameDelayMeasurementOneWayTwoWay", 2,      970,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 24.43.5.24.4.1.2 L2VPN-I13 Annex B.3.24.4.1.2 */
{ 973,    "FrameDelayMeasurementTransmissionPeriodicity", 3, 970, (encode_ushort),      (decode_ushort),         0,           0             }, /* TLV 24.43.5.24.4.1.3 L2VPN-I13 Annex B.3.24.4.1.3 */
{ 974,    "FrameLossMeasurement",              2,      969,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.5.24.4.2 L2VPN-I13 Annex B.3.24.4.2 */
{ 975,    "FrameLossMeasurementEnable",        1,      974,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 24.43.5.24.4.2.1 L2VPN-I13 Annex B.3.24.4.2.1 */
{ 976,    "FrameLossMeasurementTransmissionPeriodicity", 2, 974, (encode_ushort),       (decode_ushort),         0,           0             }, /* TLV 24.43.5.24.4.2.2 L2VPN-I13 Annex B.3.24.4.2.2 */
{ 977,    "L2VPNDSID",                         26,     195,    (encode_uint24),         (decode_uint24),         1,           1048575       }, /* TLV 24.43.5.26 L2VPN-I13 Annex B.3.26 */
{ 978,    "VendorSpecificL2VPNSubtype",        43,     195,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.5.43 L2VPN-I13 Annex B.3.11 */
{ 979,    "VendorIdentifier",                  8,      978,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 24.43.5.43.8 L2VPN-I13 Annex B.3.11 */
{ 980,    "ExtendedCMTSMICConfigurationSetting", 6,    205,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.6 MULPIv3.0-I24 Annex C.1.1.18.1.6 */
{ 981,    "ExtendedCMTSMICHMACtype",           1,      980,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 24.43.6.1 MULPIv3.0-I24 Annex C.1.1.18.1.6.1 */
{ 982,    "ExtendedCMTSMICBitmap",             2,      980,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 24.43.6.2 MULPIv3.0-I24 Annex C.1.1.18.1.6.2 */
{ 983,    "ExplicitExtendedCMTSMICDigest",     3,      980,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 24.43.6.3 MULPIv3.0-I24 Annex C.1.1.18.1.6.3 */
{ 984,    "SAVAuthorizationEncoding",          7,      205,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.7 MULPIv3.0-I24 Annex C.1.1.18.1.7 */
{ 985,    "SAVGroupName",                      1,      984,    (encode_string),         (decode_string),         1,           15            }, /* TLV 24.43.7.1 MULPIv3.0-I24 Annex C.1.1.18.1.7.1 */
{ 986,    "SAVStaticPrefixRule",               2,      984,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.7.2 MULPIv3.0-I24 Annex C.1.1.18.1.7.2 */
{ 987,    "SAVStaticPrefixAddress",            1,      986,    (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 24.43.7.2.1 MULPIv3.0-I24 Annex C.1.1.18.1.7.2.1 */
{ 988,    "SAVStaticPrefixLength",             2,      986,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 24.43.7.2.2 MULPIv3.0-I24 Annex C.1.1.18.1.7.2.2 */
{ 989,    "VendorIdentifier",                  8,      205,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 24.43.8 MULPIv3.0-I24 Annex C.2.1.11 */
{ 990,    "CMAttributeMasks",                  9,      205,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.9 MULPIv3.0-I24 Annex C.1.1.18.1.8 */
{ 991,    "CMDownstreamRequiredAttributeMask", 1,      990,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 24.43.9.1 MULPIv3.0-I24 Annex C.1.1.18.1.8.1 */
{ 992,    "CMDownstreamForbiddenAttributeMask", 2,     990,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 24.43.9.2 MULPIv3.0-I24 Annex C.1.1.18.1.8.2 */
{ 993,    "CMUpstreamRequiredAttributeMask",   3,      990,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 24.43.9.3 MULPIv3.0-I24 Annex C.1.1.18.1.8.3 */
{ 994,    "CMUpstreamForbiddenAttributeMask",  4,      990,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 24.43.9.4 MULPIv3.0-I24 Annex C.1.1.18.1.8.4 */
{ 995,    "IPMulticastJoinAuthorization",      10,     205,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.10 MULPIv3.0-I24 Annex C.1.1.18.1.9 */
{ 996,    "IPMulticastProfileName",            1,      995,    (encode_string),         (decode_string),         1,           15            }, /* TLV 24.43.10.1 MULPIv3.0-I24 Annex C.1.1.18.1.9.1 */
{ 997,    "IPMulticastJoinAuthStaticSessionRule", 2,   995,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.10.2 MULPIv3.0-I24 Annex C.1.1.18.1.9.2 */
{ 998,    "MulticastRulePriority",             1,      997,    (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 24.43.10.2.1 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.1 */
{ 999,    "AuthorizationAction",               2,      997,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 24.43.10.2.2 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.2 */
{ 1000,   "SourcePrefixAddress",               3,      997,    (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 24.43.10.2.3 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.3 */
{ 1001,   "SourcePrefixLength",                4,      997,    (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 24.43.10.2.4 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.4 */
{ 1002,   "GroupPrefixAddress",                5,      997,    (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 24.43.10.2.5 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.5 */
{ 1003,   "GroupPrefixLength",                 6,      997,    (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 24.43.10.2.6 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.6 */
{ 1004,   "MaximumMulticastSessions",          3,      995,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 24.43.10.3 MULPIv3.0-I24 Annex C.1.1.18.1.9.3 */
{ 1005,   "ServiceTypeIdentifier",             11,     205,    (encode_string),         (decode_string),         1,           16            }, /* TLV 24.43.11 MULPIv3.0-I24 Annex C.1.1.18.1.10 */
{ 1006,   "DEMARCAutoConfiguration",           12,     205,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 24.43.12 MULPIv3.0-I24 Annex C.1.1.18.1.11 */
{ 1007,   "DACDisableEnableConfig",            1,      1006,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 24.43.12.1 DEMARCv1.0-I04 Annex B.1 */
{ 1008,   "CMIMEncoding",                      2,      1006,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 24.43.12.2 DEMARCv1.0-I04 Annex B.2 */
{ 1009,   "UpstreamServiceClassName",          3,      1006,   (encode_strzero),        (decode_strzero),        2,           16            }, /* TLV 24.43.12.3 DEMARCv1.0-I04 Annex B.3 */
{ 1010,   "DownstreamServiceClassName",        4,      1006,   (encode_strzero),        (decode_strzero),        2,           16            }, /* TLV 24.43.12.4 DEMARCv1.0-I04 Annex B.4 */
{ 102,    "DsServiceFlow",                     25,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25 MULPIv3.0-I24 Annex C.2.2.5 */
{ 103,    "DsServiceFlowRef",                  1,      102,    (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 25.1 MULPIv3.0-I24 Annex C.2.2.5.1 */
{ 104,    "DsServiceFlowId",                   2,      102,    (encode_uint),           (decode_uint),           1,           0xFFFFFFFF    }, /* TLV 25.2 MULPIv3.0-I24 Annex C.2.2.5.2 */
{ 105,    "ServiceClassName",                  4,      102,    (encode_strzero),        (decode_strzero),        2,           16            }, /* TLV 25.4 MULPIv3.0-I24 Annex C.2.2.5.4 */
{ 106,    "QosParamSetType",                   6,      102,    (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 25.6 MULPIv3.0-I24 Annex C.2.2.5.5 */
{ 107,    "TrafficPriority",                   7,      102,    (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 25.7 MULPIv3.0-I24 Annex C.2.2.7.1 */
{ 108,    "MaxRateSustained",                  8,      102,    (encode_uint),           (decode_uint),           0,           0xFFFFFFFF    }, /* TLV 25.8 MULPIv3.0-I24 Annex C.2.2.7.2.2 */
{ 109,    "MaxTrafficBurst",                   9,      102,    (encode_uint),           (decode_uint),           0,           0xFFFFFFFF    }, /* TLV 25.9 MULPIv3.0-I24 Annex C.2.2.7.3 */
{ 110,    "MinReservedRate",                   10,     102,    (encode_uint),           (decode_uint),           0,           0xFFFFFFFF    }, /* TLV 25.10 MULPIv3.0-I24 Annex C.2.2.7.4 */
{ 111,    "MinResPacketSize",                  11,     102,    (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 25.11 MULPIv3.0-I24 Annex C.2.2.7.5 */
{ 112,    "ActQosParamsTimeout",               12,     102,    (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 25.12 MULPIv3.0-I24 Annex C.2.2.7.6 */
{ 113,    "AdmQosParamsTimeout",               13,     102,    (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 25.13 MULPIv3.0-I24 Annex C.2.2.7.7 */
{ 114,    "MaxDsLatency",                      14,     102,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 25.14 MULPIv3.0-I24 Annex C.2.2.9.1 */
{ 1269,   "DsResequencing",                    17,     102,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 25.17 MULPIv3.0-I24 Annex C.2.2.9.2 */
{ 1270,   "IpTosOverwrite",                    23,     102,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.23 MULPIv3.0-I24 Annex C.2.2.7.9 */
{ 1271,   "DownstreamPeakTrafficRate",         27,     102,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 25.27 MULPIv3.0-I24 Annex C.2.2.7.10.2 */
{ 1272,   "ServiceFlowRequiredAttributeMask",  31,     102,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 25.31 MULPIv3.0-I24 Annex C.2.2.5.6 */
{ 1273,   "ServiceFlowForbiddenAttributeMask", 32,     102,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 25.32 MULPIv3.0-I24 Annex C.2.2.5.7 */
{ 1274,   "ServiceFlowAttributeAggregationRuleMask", 33, 102,  (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 25.33 MULPIv3.0-I24 Annex C.2.2.5.8 */
{ 1275,   "ApplicationIdentifier",             34,     102,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 25.34 MULPIv3.0-I24 Annex C.2.2.5.9 */
{ 1276,   "BufferControl",                     35,     102,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.35 MULPIv3.0-I24 Annex C.2.2.7.11.1 */
{ 1277,   "MinimumBuffer",                     1,      1276,   (encode_uint),           (decode_uint),           0,           4294967295    }, /* TLV 25.35.1 MULPIv3.0-I24 Annex C.2.2.7.11.3 */
{ 1278,   "TargetBuffer",                      2,      1276,   (encode_uint),           (decode_uint),           0,           4294967295    }, /* TLV 25.35.2 MULPIv3.0-I24 Annex C.2.2.7.11.4 */
{ 1279,   "MaximumBuffer",                     3,      1276,   (encode_uint),           (decode_uint),           0,           4294967295    }, /* TLV 25.35.3 MULPIv3.0-I24 Annex C.2.2.7.11.5 */
{ 1280,   "DownstreamAggregateServiceFlowReference", 36, 102,  (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.36 MULPIv3.0-I24 Annex C.2.2.5.10 */
{ 1281,   "DownstreamMESPReference",           37,     102,    (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 25.37 MULPIv3.0-I24 Annex C.2.2.5.11 */
{ 1282,   "AQMEncodings",                      40,     102,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.40 MULPIv3.0-I24 Annex C.2.2.7.12 */
{ 1283,   "SFAQMDisable",                      1,      1282,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 25.40.1 MULPIv3.0-I24 Annex C.2.2.7.12.3 */
{ 1284,   "SFAQMLatencyTarget",                2,      1282,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 25.40.2 MULPIv3.0-I24 Annex C.2.2.7.12.4 */
{ 1285,   "DataRateUnitSetting",               41,     102,    (encode_uchar),          (decode_uchar),          0,           3             }, /* TLV 25.41 MULPIv3.0-I24 Annex C.2.2.7.13.1 */
{ 199,    "VendorSpecific",                    43,     102,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43 MULPIv3.0-I24 Annex C.2.1.11 */
{ 196,    "CMLoadBalancingPolicyID",           1,      199,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 25.43.1 MULPIv3.0-I24 Annex C.1.1.18.1.1 */
{ 197,    "CMLoadBalancingPriority",           2,      199,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 25.43.2 MULPIv3.0-I24 Annex C.1.1.18.1.2 */
{ 198,    "CMLoadBalancingGroupID",            3,      199,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 25.43.3 MULPIv3.0-I24 Annex C.1.1.18.1.3 */
{ 1011,   "CMRangingClassIDExtension",         4,      199,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 25.43.4 MULPIv3.0-I24 Annex C.1.1.18.1.4 */
{ 1012,   "L2VPNEncoding",                     5,      199,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.5 MULPIv3.0-I24 Annex C.1.1.18.1.5 */
{ 1013,   "VPNIdentifier",                     1,      1012,   (encode_hexstr),         (decode_hexstr),         4,           255           }, /* TLV 25.43.5.1 L2VPN-I13 Annex B.3.1 */
{ 1014,   "NSIEncapsulation",                  2,      1012,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.5.2 L2VPN-I13 Annex B.3.2 */
{ 1015,   "ServiceMultiplexingValueOther",     1,      1014,   (encode_lenzero),        (decode_lenzero),        0,           0             }, /* TLV 25.43.5.2.1 L2VPN-I13 Annex B.3.2 */
{ 1016,   "NSIEncapsulationSingleQTag",        2,      1014,   (encode_ushort),         (decode_ushort),         0,           4096          }, /* TLV 25.43.5.2.2 L2VPN-I13 Annex B.3.2 */
{ 1017,   "NSIEncapsulationDualQTag",          3,      1014,   (encode_dual_qtag),      (decode_dual_qtag),      0,           0             }, /* TLV 25.43.5.2.3 L2VPN-I13 Annex B.3.2 */
{ 1018,   "ServiceMultiplexingValueMPLSPW",    4,      1014,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.5.2.4 L2VPN-I13 Annex B.3.2 */
{ 1019,   "MPLSPseudowireID",                  1,      1018,   (encode_uint),           (decode_uint),           0,           0             }, /* TLV 25.43.5.2.4.1 L2VPN-I13 Annex B.3.2 */
{ 1020,   "MPLSPeerIpAddress",                 2,      1018,   (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 25.43.5.2.4.2 L2VPN-I13 Annex B.3.2 */
{ 1021,   "MPLSPseudowireType",                3,      1018,   (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 25.43.5.2.4.3 L2VPN-I13 Annex B.3.2 */
{ 1022,   "MPLSBackupPseudowireID",            4,      1018,   (encode_uint),           (decode_uint),           0,           0             }, /* TLV 25.43.5.2.4.4 L2VPN-I13 Annex B.3.2 */
{ 1023,   "MPLSBackupPeerIpAddress",           5,      1018,   (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 25.43.5.2.4.5 L2VPN-I13 Annex B.3.2 */
{ 1024,   "ServiceMultiplexingValueL2TPv3Peer", 5,     1014,   (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 25.43.5.2.5 L2VPN-I13 Annex B.3.2 */
{ 1025,   "IEEE8021ahEncapsulation",           6,      1014,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.5.2.6 L2VPN-I13 Annex B.3.2.2 */
{ 1026,   "ITCIEncapsulation",                 1,      1025,   (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 25.43.5.2.6.1 L2VPN-I13 Annex B.3.2.2.1 */
{ 1027,   "BDAEncapsulation",                  2,      1025,   (encode_hexstr),         (decode_hexstr),         6,           6             }, /* TLV 25.43.5.2.6.2 L2VPN-I13 Annex B.3.2.2.2 */
{ 1028,   "BTCIEncapsulation",                 3,      1025,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.2.6.3 L2VPN-I13 Annex B.3.2.2.3 */
{ 1029,   "ITPIDEncapsulation",                4,      1025,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.2.6.4 L2VPN-I13 Annex B.3.2.2.4 */
{ 1030,   "IPCPEncapsulation",                 5,      1025,   (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 25.43.5.2.6.5 L2VPN-I13 Annex B.3.2.2.5 */
{ 1031,   "IDEIEncapsulation",                 6,      1025,   (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 25.43.5.2.6.6 L2VPN-I13 Annex B.3.2.2.6 */
{ 1032,   "IUCAEncapsulation",                 7,      1025,   (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 25.43.5.2.6.7 L2VPN-I13 Annex B.3.2.2.7 */
{ 1033,   "ISIDEncapsulation",                 8,      1025,   (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 25.43.5.2.6.8 L2VPN-I13 Annex B.3.2.2.8 */
{ 1034,   "BTPIDEncapsulation",                9,      1025,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.2.6.9 L2VPN-I13 Annex B.3.2.2.9 */
{ 1035,   "BPCPEncapsulation",                 10,     1025,   (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 25.43.5.2.6.10 L2VPN-I13 Annex B.3.2.2.10 */
{ 1036,   "BDEIEncapsulation",                 11,     1025,   (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 25.43.5.2.6.11 L2VPN-I13 Annex B.3.2.2.11 */
{ 1037,   "BVIDEncapsulation",                 12,     1025,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.2.6.12 L2VPN-I13 Annex B.3.2.2.11 */
{ 1038,   "ServiceMultiplexingValueIEEE8021adSTPID", 8, 1014,  (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.2.8 L2VPN-I13 Annex B.3.2.1 */
{ 1039,   "eSAFEDHCPSnooping",                 3,      1012,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 25.43.5.3 L2VPN-I13 Annex B.3.3 */
{ 1040,   "CMInterfaceMaskCMIMSubtype",        4,      1012,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 25.43.5.4 L2VPN-I13 Annex B.3.4 */
{ 1041,   "AttachmentGroupID",                 5,      1012,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 25.43.5.5 L2VPN-I13 Annex B.3.5 */
{ 1042,   "SourceAttachmentIndividualID",      6,      1012,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 25.43.5.6 L2VPN-I13 Annex B.3.6 */
{ 1043,   "TargetAttachmentIndividualID",      7,      1012,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 25.43.5.7 L2VPN-I13 Annex B.3.7 */
{ 1044,   "IngressUserPriority",               8,      1012,   (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 25.43.5.8 L2VPN-I13 Annex B.3.8 */
{ 1045,   "UserPriorityRange",                 9,      1012,   (encode_char_list),      (decode_char_list),      0,           0             }, /* TLV 25.43.5.9 L2VPN-I13 Annex B.3.9 */
{ 1046,   "L2VPNSADescriptorSubtype",          10,     1012,   (encode_hexstr),         (decode_hexstr),         14,          14            }, /* TLV 25.43.5.10 L2VPN-I13 Annex B.3.10 */
{ 1047,   "PseudowireType",                    12,     1012,   (encode_uchar),          (decode_uchar),          4,           5             }, /* TLV 25.43.5.12 L2VPN-I13 Annex B.3.13 */
{ 1048,   "L2VPNMode",                         13,     1012,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 25.43.5.13 L2VPN-I13 Annex B.3.14 */
{ 1049,   "TPIDTranslation",                   14,     1012,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.5.14 L2VPN-I13 Annex B.3.15 */
{ 1050,   "UpstreamTPIDTranslation",           1,      1049,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.14.1 L2VPN-I13 Annex B.3.15.1 */
{ 1051,   "DownstreamTPIDTranslation",         2,      1049,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.14.2 L2VPN-I13 Annex B.3.15.1 */
{ 1052,   "UpstreamSTPIDTranslation",          3,      1049,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.14.3 L2VPN-I13 Annex B.3.15.1 */
{ 1053,   "DownstreamSTPIDTranslation",        4,      1049,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.14.4 L2VPN-I13 Annex B.3.15.1 */
{ 1054,   "UpstreamBTPIDTranslation",          5,      1049,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.14.5 L2VPN-I13 Annex B.3.15.1 */
{ 1055,   "DownstreamBTPIDTranslation",        6,      1049,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.14.6 L2VPN-I13 Annex B.3.15.1 */
{ 1056,   "UpstreamITPIDTranslation",          7,      1049,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.14.7 L2VPN-I13 Annex B.3.15.1 */
{ 1057,   "DownstreamITPIDTranslation",        8,      1049,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.14.8 L2VPN-I13 Annex B.3.15.1 */
{ 1058,   "L2CPProcessing",                    15,     1012,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.5.15 L2VPN-I13 Annex B.3.16 */
{ 1059,   "L2CPTunnelMode",                    1,      1058,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 25.43.5.15.1 L2VPN-I13 Annex B.3.16.1 */
{ 1060,   "L2CPDMACAddress",                   2,      1058,   (encode_ether),          (decode_ether),          0,           0             }, /* TLV 25.43.5.15.2 L2VPN-I13 Annex B.3.16.1 */
{ 1061,   "L2CPOverwrotingDMACAddress",        3,      1058,   (encode_ether),          (decode_ether),          0,           0             }, /* TLV 25.43.5.15.3 L2VPN-I13 Annex B.3.16.1 */
{ 1062,   "DACDisableEnableConfiguration",     16,     1012,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 25.43.5.16 L2VPN-I13 Annex B.3.17 */
{ 1063,   "PseudowireClass",                   18,     1012,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 25.43.5.18 L2VPN-I13 Annex B.3.18 */
{ 1064,   "ServiceDelimiter",                  19,     1012,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.5.19 L2VPN-I13 Annex B.3.19 */
{ 1065,   "CVIDDelimiter",                     1,      1064,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.19.1 L2VPN-I13 Annex B.3.19.1 */
{ 1066,   "SVIDDelimiter",                     2,      1064,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.19.2 L2VPN-I13 Annex B.3.19.2 */
{ 1067,   "ISIDDelimiter",                     3,      1064,   (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 25.43.5.19.3 L2VPN-I13 Annex B.3.19.3 */
{ 1068,   "BVIDDelimiter",                     4,      1064,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.19.4 L2VPN-I13 Annex B.3.19.4 */
{ 1069,   "VirtualSwitchInstanceEncoding",     20,     1012,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.5.20 L2VPN-I13 Annex B.3.20 */
{ 1070,   "VPLSClass",                         1,      1069,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 25.43.5.20.1 L2VPN-I13 Annex B.3.20.1 */
{ 1071,   "ETreeRole",                         2,      1069,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 25.43.5.20.2 L2VPN-I13 Annex B.3.20.2 */
{ 1072,   "ETreeRootVID",                      3,      1069,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.20.3 L2VPN-I13 Annex B.3.20.3 */
{ 1073,   "ETreeLeafVID",                      4,      1069,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 25.43.5.20.4 L2VPN-I13 Annex B.3.20.4 */
{ 1074,   "BGPAttribute",                      21,     1012,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.5.21 L2VPN-I13 Annex B.3.21 */
{ 1075,   "BGPVPNID",                          1,      1074,   (encode_uint),           (decode_uint),           0,           0             }, /* TLV 25.43.5.21.1 L2VPN-I13 Annex B.3.21.1 */
{ 1076,   "RouteDistinguisher",                2,      1074,   (encode_hexstr),         (decode_hexstr),         8,           8             }, /* TLV 25.43.5.21.2 L2VPN-I13 Annex B.3.21.2 */
{ 1077,   "RouteTargetImport",                 3,      1074,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 25.43.5.21.3 L2VPN-I13 Annex B.3.21.3 */
{ 1078,   "RouteTargetExport",                 4,      1074,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 25.43.5.21.4 L2VPN-I13 Annex B.3.21.4 */
{ 1079,   "CEIDVEID",                          5,      1074,   (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 25.43.5.21.5 L2VPN-I13 Annex B.3.21.5 */
{ 1080,   "PseudowireSignaling",               23,     1012,   (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 25.43.5.23 L2VPN-I13 Annex B.3.23 */
{ 1081,   "SOAMSubtype",                       24,     1012,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.5.24 L2VPN-I13 Annex B.3.24 */
{ 1082,   "MEPConfiguration",                  1,      1081,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.5.24.1 L2VPN-I13 Annex B.3.24.1 */
{ 1083,   "MDLevel",                           1,      1082,   (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 25.43.5.24.1.1 L2VPN-I13 Annex B.3.24.1.1 */
{ 1084,   "MDName",                            2,      1082,   (encode_string),         (decode_string),         2,           16            }, /* TLV 25.43.5.24.1.2 L2VPN-I13 Annex B.3.24.1.2 */
{ 1085,   "MAName",                            3,      1082,   (encode_string),         (decode_string),         2,           28            }, /* TLV 25.43.5.24.1.3 L2VPN-I13 Annex B.3.24.1.3 */
{ 1086,   "MEPID",                             4,      1082,   (encode_ushort),         (decode_ushort),         1,           8191          }, /* TLV 25.43.5.24.1.4 L2VPN-I13 Annex B.3.24.1.4 */
{ 1087,   "RemoteMEPConfiguration",            2,      1081,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.5.24.2 L2VPN-I13 Annex B.3.24.2 */
{ 1088,   "RemoteMDLevel",                     1,      1087,   (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 25.43.5.24.2.1 L2VPN-I13 Annex B.3.24.2.1 */
{ 1089,   "RemoteMDName",                      2,      1087,   (encode_string),         (decode_string),         2,           16            }, /* TLV 25.43.5.24.2.2 L2VPN-I13 Annex B.3.24.2.2 */
{ 1090,   "RemoteMAName",                      3,      1087,   (encode_string),         (decode_string),         2,           28            }, /* TLV 25.43.5.24.2.3 L2VPN-I13 Annex B.3.24.2.3 */
{ 1091,   "RemoteMEPID",                       4,      1087,   (encode_ushort),         (decode_ushort),         1,           8191          }, /* TLV 25.43.5.24.2.4 L2VPN-I13 Annex B.3.24.2.4 */
{ 1092,   "FaultManagementConfiguration",      3,      1081,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.5.24.3 L2VPN-I13 Annex B.3.24.3 */
{ 1093,   "ContinuityCheckMessages",           1,      1092,   (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 25.43.5.24.3.1 L2VPN-I13 Annex B.3.24.3.1 */
{ 1094,   "LoopbackFunction",                  2,      1092,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 25.43.5.24.3.2 L2VPN-I13 Annex B.3.24.3.2 */
{ 1095,   "LinktraceFunction",                 3,      1092,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 25.43.5.24.3.3 L2VPN-I13 Annex B.3.24.3.3 */
{ 1096,   "PerformanceManagementConfiguration", 4,     1081,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.5.24.4 L2VPN-I13 Annex B.3.24.4 */
{ 1097,   "FrameDelayMeasurement",             1,      1096,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.5.24.4.1 L2VPN-I13 Annex B.3.24.4.1 */
{ 1098,   "FrameDelayMeasurementEnable",       1,      1097,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 25.43.5.24.4.1.1 L2VPN-I13 Annex B.3.24.4.1.1 */
{ 1099,   "FrameDelayMeasurementOneWayTwoWay", 2,      1097,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 25.43.5.24.4.1.2 L2VPN-I13 Annex B.3.24.4.1.2 */
{ 1100,   "FrameDelayMeasurementTransmissionPeriodicity", 3, 1097, (encode_ushort),     (decode_ushort),         0,           0             }, /* TLV 25.43.5.24.4.1.3 L2VPN-I13 Annex B.3.24.4.1.3 */
{ 1101,   "FrameLossMeasurement",              2,      1096,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.5.24.4.2 L2VPN-I13 Annex B.3.24.4.2 */
{ 1102,   "FrameLossMeasurementEnable",        1,      1101,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 25.43.5.24.4.2.1 L2VPN-I13 Annex B.3.24.4.2.1 */
{ 1103,   "FrameLossMeasurementTransmissionPeriodicity", 2, 1101, (encode_ushort),      (decode_ushort),         0,           0             }, /* TLV 25.43.5.24.4.2.2 L2VPN-I13 Annex B.3.24.4.2.2 */
{ 1104,   "L2VPNDSID",                         26,     1012,   (encode_uint24),         (decode_uint24),         1,           1048575       }, /* TLV 25.43.5.26 L2VPN-I13 Annex B.3.26 */
{ 1105,   "VendorSpecificL2VPNSubtype",        43,     1012,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.5.43 L2VPN-I13 Annex B.3.11 */
{ 1106,   "VendorIdentifier",                  8,      1105,   (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 25.43.5.43.8 L2VPN-I13 Annex B.3.11 */
{ 1107,   "ExtendedCMTSMICConfigurationSetting", 6,    199,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.6 MULPIv3.0-I24 Annex C.1.1.18.1.6 */
{ 1108,   "ExtendedCMTSMICHMACtype",           1,      1107,   (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 25.43.6.1 MULPIv3.0-I24 Annex C.1.1.18.1.6.1 */
{ 1109,   "ExtendedCMTSMICBitmap",             2,      1107,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 25.43.6.2 MULPIv3.0-I24 Annex C.1.1.18.1.6.2 */
{ 1110,   "ExplicitExtendedCMTSMICDigest",     3,      1107,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 25.43.6.3 MULPIv3.0-I24 Annex C.1.1.18.1.6.3 */
{ 1111,   "SAVAuthorizationEncoding",          7,      199,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.7 MULPIv3.0-I24 Annex C.1.1.18.1.7 */
{ 1112,   "SAVGroupName",                      1,      1111,   (encode_string),         (decode_string),         1,           15            }, /* TLV 25.43.7.1 MULPIv3.0-I24 Annex C.1.1.18.1.7.1 */
{ 1113,   "SAVStaticPrefixRule",               2,      1111,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.7.2 MULPIv3.0-I24 Annex C.1.1.18.1.7.2 */
{ 1114,   "SAVStaticPrefixAddress",            1,      1113,   (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 25.43.7.2.1 MULPIv3.0-I24 Annex C.1.1.18.1.7.2.1 */
{ 1115,   "SAVStaticPrefixLength",             2,      1113,   (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 25.43.7.2.2 MULPIv3.0-I24 Annex C.1.1.18.1.7.2.2 */
{ 1116,   "VendorIdentifier",                  8,      199,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 25.43.8 MULPIv3.0-I24 Annex C.2.1.11 */
{ 1117,   "CMAttributeMasks",                  9,      199,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.9 MULPIv3.0-I24 Annex C.1.1.18.1.8 */
{ 1118,   "CMDownstreamRequiredAttributeMask", 1,      1117,   (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 25.43.9.1 MULPIv3.0-I24 Annex C.1.1.18.1.8.1 */
{ 1119,   "CMDownstreamForbiddenAttributeMask", 2,     1117,   (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 25.43.9.2 MULPIv3.0-I24 Annex C.1.1.18.1.8.2 */
{ 1120,   "CMUpstreamRequiredAttributeMask",   3,      1117,   (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 25.43.9.3 MULPIv3.0-I24 Annex C.1.1.18.1.8.3 */
{ 1121,   "CMUpstreamForbiddenAttributeMask",  4,      1117,   (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 25.43.9.4 MULPIv3.0-I24 Annex C.1.1.18.1.8.4 */
{ 1122,   "IPMulticastJoinAuthorization",      10,     199,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.10 MULPIv3.0-I24 Annex C.1.1.18.1.9 */
{ 1123,   "IPMulticastProfileName",            1,      1122,   (encode_string),         (decode_string),         1,           15            }, /* TLV 25.43.10.1 MULPIv3.0-I24 Annex C.1.1.18.1.9.1 */
{ 1124,   "IPMulticastJoinAuthStaticSessionRule", 2,   1122,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.10.2 MULPIv3.0-I24 Annex C.1.1.18.1.9.2 */
{ 1125,   "MulticastRulePriority",             1,      1124,   (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 25.43.10.2.1 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.1 */
{ 1126,   "AuthorizationAction",               2,      1124,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 25.43.10.2.2 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.2 */
{ 1127,   "SourcePrefixAddress",               3,      1124,   (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 25.43.10.2.3 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.3 */
{ 1128,   "SourcePrefixLength",                4,      1124,   (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 25.43.10.2.4 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.4 */
{ 1129,   "GroupPrefixAddress",                5,      1124,   (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 25.43.10.2.5 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.5 */
{ 1130,   "GroupPrefixLength",                 6,      1124,   (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 25.43.10.2.6 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.6 */
{ 1131,   "MaximumMulticastSessions",          3,      1122,   (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 25.43.10.3 MULPIv3.0-I24 Annex C.1.1.18.1.9.3 */
{ 1132,   "ServiceTypeIdentifier",             11,     199,    (encode_string),         (decode_string),         1,           16            }, /* TLV 25.43.11 MULPIv3.0-I24 Annex C.1.1.18.1.10 */
{ 1133,   "DEMARCAutoConfiguration",           12,     199,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 25.43.12 MULPIv3.0-I24 Annex C.1.1.18.1.11 */
{ 1134,   "DACDisableEnableConfig",            1,      1133,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 25.43.12.1 DEMARCv1.0-I04 Annex B.1 */
{ 1135,   "CMIMEncoding",                      2,      1133,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 25.43.12.2 DEMARCv1.0-I04 Annex B.2 */
{ 1136,   "UpstreamServiceClassName",          3,      1133,   (encode_strzero),        (decode_strzero),        2,           16            }, /* TLV 25.43.12.3 DEMARCv1.0-I04 Annex B.3 */
{ 1137,   "DownstreamServiceClassName",        4,      1133,   (encode_strzero),        (decode_strzero),        2,           16            }, /* TLV 25.43.12.4 DEMARCv1.0-I04 Annex B.4 */
{ 115,    "PHS",                               26,     0,      (encode_nothing),        (decode_aggregate)   ,   0,           0             }, /* TLV 26 MULPIv3.0-I24 Annex C.2.3 */
{ 116,    "PHSClassifierRef",                  1,      115,    (encode_uchar),          (decode_uchar),          1,           255           }, /* TLV 26.1 MULPIv3.0-I24 Annex C.2.3.1.1 */
{ 117,    "PHSClassifierId",                   2,      115,    (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 26.2 MULPIv3.0-I24 Annex C.2.3.1.2 */
{ 118,    "PHSServiceFlowRef",                 3,      115,    (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 26.3 MULPIv3.0-I24 Annex C.2.3.1.3 */
{ 119,    "PHSServiceFlowId",                  4,      115,    (encode_uint),           (decode_uint),           1,           0xFFFFFFFF    }, /* TLV 26.4 MULPIv3.0-I24 Annex C.2.3.1.4 */
{ 1286,   "PHSDSCAction",                      5,      115,    (encode_uchar),          (decode_uchar),          0,           3             }, /* TLV 26.5 MULPIv3.0-I24 Annex C.2.3.1.5 */
{ 120,    "PHSField",                          7,      115,    (encode_hexstr),         (decode_hexstr),         1,           255           }, /* TLV 26.7 MULPIv3.0-I24 Annex C.2.4.2.1 */
{ 121,    "PHSIndex",                          8,      115,    (encode_uchar),          (decode_uchar),          1,           255           }, /* TLV 26.8 MULPIv3.0-I24 Annex C.2.4.2.2 */
{ 122,    "PHSMask",                           9,      115,    (encode_hexstr),         (decode_hexstr),         1,           255           }, /* TLV 26.9 MULPIv3.0-I24 Annex C.2.4.2.3 */
{ 123,    "PHSSize",                           10,     115,    (encode_uchar),          (decode_uchar),          1,           255           }, /* TLV 26.10 MULPIv3.0-I24 Annex C.2.4.2.4 */
{ 124,    "PHSVerify",                         11,     115,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 26.11 MULPIv3.0-I24 Annex C.2.4.2.5 */
{ 1287,   "PHSDBCAction",                      13,     115,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 26.13 MULPIv3.0-I24 Annex C.2.3.1.6 */
{ 1138,   "VendorSpecific",                    43,     115,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43 MULPIv3.0-I24 Annex C.2.1.11 */
{ 1139,   "CMLoadBalancingPolicyID",           1,      1138,   (encode_uint),           (decode_uint),           0,           0             }, /* TLV 26.43.1 MULPIv3.0-I24 Annex C.1.1.18.1.1 */
{ 1140,   "CMLoadBalancingPriority",           2,      1138,   (encode_uint),           (decode_uint),           0,           0             }, /* TLV 26.43.2 MULPIv3.0-I24 Annex C.1.1.18.1.2 */
{ 1141,   "CMLoadBalancingGroupID",            3,      1138,   (encode_uint),           (decode_uint),           0,           0             }, /* TLV 26.43.3 MULPIv3.0-I24 Annex C.1.1.18.1.3 */
{ 1142,   "CMRangingClassIDExtension",         4,      1138,   (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 26.43.4 MULPIv3.0-I24 Annex C.1.1.18.1.4 */
{ 1143,   "L2VPNEncoding",                     5,      1138,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.5 MULPIv3.0-I24 Annex C.1.1.18.1.5 */
{ 1144,   "VPNIdentifier",                     1,      1143,   (encode_hexstr),         (decode_hexstr),         4,           255           }, /* TLV 26.43.5.1 L2VPN-I13 Annex B.3.1 */
{ 1145,   "NSIEncapsulation",                  2,      1143,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.5.2 L2VPN-I13 Annex B.3.2 */
{ 1146,   "ServiceMultiplexingValueOther",     1,      1145,   (encode_lenzero),        (decode_lenzero),        0,           0             }, /* TLV 26.43.5.2.1 L2VPN-I13 Annex B.3.2 */
{ 1147,   "NSIEncapsulationSingleQTag",        2,      1145,   (encode_ushort),         (decode_ushort),         0,           4096          }, /* TLV 26.43.5.2.2 L2VPN-I13 Annex B.3.2 */
{ 1148,   "NSIEncapsulationDualQTag",          3,      1145,   (encode_dual_qtag),      (decode_dual_qtag),      0,           0             }, /* TLV 26.43.5.2.3 L2VPN-I13 Annex B.3.2 */
{ 1149,   "ServiceMultiplexingValueMPLSPW",    4,      1145,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.5.2.4 L2VPN-I13 Annex B.3.2 */
{ 1150,   "MPLSPseudowireID",                  1,      1149,   (encode_uint),           (decode_uint),           0,           0             }, /* TLV 26.43.5.2.4.1 L2VPN-I13 Annex B.3.2 */
{ 1151,   "MPLSPeerIpAddress",                 2,      1149,   (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 26.43.5.2.4.2 L2VPN-I13 Annex B.3.2 */
{ 1152,   "MPLSPseudowireType",                3,      1149,   (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 26.43.5.2.4.3 L2VPN-I13 Annex B.3.2 */
{ 1153,   "MPLSBackupPseudowireID",            4,      1149,   (encode_uint),           (decode_uint),           0,           0             }, /* TLV 26.43.5.2.4.4 L2VPN-I13 Annex B.3.2 */
{ 1154,   "MPLSBackupPeerIpAddress",           5,      1149,   (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 26.43.5.2.4.5 L2VPN-I13 Annex B.3.2 */
{ 1155,   "ServiceMultiplexingValueL2TPv3Peer", 5,     1145,   (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 26.43.5.2.5 L2VPN-I13 Annex B.3.2 */
{ 1156,   "IEEE8021ahEncapsulation",           6,      1145,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.5.2.6 L2VPN-I13 Annex B.3.2.2 */
{ 1157,   "ITCIEncapsulation",                 1,      1156,   (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 26.43.5.2.6.1 L2VPN-I13 Annex B.3.2.2.1 */
{ 1158,   "BDAEncapsulation",                  2,      1156,   (encode_hexstr),         (decode_hexstr),         6,           6             }, /* TLV 26.43.5.2.6.2 L2VPN-I13 Annex B.3.2.2.2 */
{ 1159,   "BTCIEncapsulation",                 3,      1156,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.2.6.3 L2VPN-I13 Annex B.3.2.2.3 */
{ 1160,   "ITPIDEncapsulation",                4,      1156,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.2.6.4 L2VPN-I13 Annex B.3.2.2.4 */
{ 1161,   "IPCPEncapsulation",                 5,      1156,   (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 26.43.5.2.6.5 L2VPN-I13 Annex B.3.2.2.5 */
{ 1162,   "IDEIEncapsulation",                 6,      1156,   (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 26.43.5.2.6.6 L2VPN-I13 Annex B.3.2.2.6 */
{ 1163,   "IUCAEncapsulation",                 7,      1156,   (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 26.43.5.2.6.7 L2VPN-I13 Annex B.3.2.2.7 */
{ 1164,   "ISIDEncapsulation",                 8,      1156,   (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 26.43.5.2.6.8 L2VPN-I13 Annex B.3.2.2.8 */
{ 1165,   "BTPIDEncapsulation",                9,      1156,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.2.6.9 L2VPN-I13 Annex B.3.2.2.9 */
{ 1166,   "BPCPEncapsulation",                 10,     1156,   (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 26.43.5.2.6.10 L2VPN-I13 Annex B.3.2.2.10 */
{ 1167,   "BDEIEncapsulation",                 11,     1156,   (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 26.43.5.2.6.11 L2VPN-I13 Annex B.3.2.2.11 */
{ 1168,   "BVIDEncapsulation",                 12,     1156,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.2.6.12 L2VPN-I13 Annex B.3.2.2.11 */
{ 1169,   "ServiceMultiplexingValueIEEE8021adSTPID", 8, 1145,  (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.2.8 L2VPN-I13 Annex B.3.2.1 */
{ 1170,   "eSAFEDHCPSnooping",                 3,      1143,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 26.43.5.3 L2VPN-I13 Annex B.3.3 */
{ 1171,   "CMInterfaceMaskCMIMSubtype",        4,      1143,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 26.43.5.4 L2VPN-I13 Annex B.3.4 */
{ 1172,   "AttachmentGroupID",                 5,      1143,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 26.43.5.5 L2VPN-I13 Annex B.3.5 */
{ 1173,   "SourceAttachmentIndividualID",      6,      1143,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 26.43.5.6 L2VPN-I13 Annex B.3.6 */
{ 1174,   "TargetAttachmentIndividualID",      7,      1143,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 26.43.5.7 L2VPN-I13 Annex B.3.7 */
{ 1175,   "IngressUserPriority",               8,      1143,   (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 26.43.5.8 L2VPN-I13 Annex B.3.8 */
{ 1176,   "UserPriorityRange",                 9,      1143,   (encode_char_list),      (decode_char_list),      0,           0             }, /* TLV 26.43.5.9 L2VPN-I13 Annex B.3.9 */
{ 1177,   "L2VPNSADescriptorSubtype",          10,     1143,   (encode_hexstr),         (decode_hexstr),         14,          14            }, /* TLV 26.43.5.10 L2VPN-I13 Annex B.3.10 */
{ 1178,   "PseudowireType",                    12,     1143,   (encode_uchar),          (decode_uchar),          4,           5             }, /* TLV 26.43.5.12 L2VPN-I13 Annex B.3.13 */
{ 1179,   "L2VPNMode",                         13,     1143,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 26.43.5.13 L2VPN-I13 Annex B.3.14 */
{ 1180,   "TPIDTranslation",                   14,     1143,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.5.14 L2VPN-I13 Annex B.3.15 */
{ 1181,   "UpstreamTPIDTranslation",           1,      1180,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.14.1 L2VPN-I13 Annex B.3.15.1 */
{ 1182,   "DownstreamTPIDTranslation",         2,      1180,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.14.2 L2VPN-I13 Annex B.3.15.1 */
{ 1183,   "UpstreamSTPIDTranslation",          3,      1180,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.14.3 L2VPN-I13 Annex B.3.15.1 */
{ 1184,   "DownstreamSTPIDTranslation",        4,      1180,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.14.4 L2VPN-I13 Annex B.3.15.1 */
{ 1185,   "UpstreamBTPIDTranslation",          5,      1180,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.14.5 L2VPN-I13 Annex B.3.15.1 */
{ 1186,   "DownstreamBTPIDTranslation",        6,      1180,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.14.6 L2VPN-I13 Annex B.3.15.1 */
{ 1187,   "UpstreamITPIDTranslation",          7,      1180,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.14.7 L2VPN-I13 Annex B.3.15.1 */
{ 1188,   "DownstreamITPIDTranslation",        8,      1180,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.14.8 L2VPN-I13 Annex B.3.15.1 */
{ 1189,   "L2CPProcessing",                    15,     1143,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.5.15 L2VPN-I13 Annex B.3.16 */
{ 1190,   "L2CPTunnelMode",                    1,      1189,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 26.43.5.15.1 L2VPN-I13 Annex B.3.16.1 */
{ 1191,   "L2CPDMACAddress",                   2,      1189,   (encode_ether),          (decode_ether),          0,           0             }, /* TLV 26.43.5.15.2 L2VPN-I13 Annex B.3.16.1 */
{ 1192,   "L2CPOverwrotingDMACAddress",        3,      1189,   (encode_ether),          (decode_ether),          0,           0             }, /* TLV 26.43.5.15.3 L2VPN-I13 Annex B.3.16.1 */
{ 1193,   "DACDisableEnableConfiguration",     16,     1143,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 26.43.5.16 L2VPN-I13 Annex B.3.17 */
{ 1194,   "PseudowireClass",                   18,     1143,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 26.43.5.18 L2VPN-I13 Annex B.3.18 */
{ 1195,   "ServiceDelimiter",                  19,     1143,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.5.19 L2VPN-I13 Annex B.3.19 */
{ 1196,   "CVIDDelimiter",                     1,      1195,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.19.1 L2VPN-I13 Annex B.3.19.1 */
{ 1197,   "SVIDDelimiter",                     2,      1195,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.19.2 L2VPN-I13 Annex B.3.19.2 */
{ 1198,   "ISIDDelimiter",                     3,      1195,   (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 26.43.5.19.3 L2VPN-I13 Annex B.3.19.3 */
{ 1199,   "BVIDDelimiter",                     4,      1195,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.19.4 L2VPN-I13 Annex B.3.19.4 */
{ 1200,   "VirtualSwitchInstanceEncoding",     20,     1143,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.5.20 L2VPN-I13 Annex B.3.20 */
{ 1201,   "VPLSClass",                         1,      1200,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 26.43.5.20.1 L2VPN-I13 Annex B.3.20.1 */
{ 1202,   "ETreeRole",                         2,      1200,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 26.43.5.20.2 L2VPN-I13 Annex B.3.20.2 */
{ 1203,   "ETreeRootVID",                      3,      1200,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.20.3 L2VPN-I13 Annex B.3.20.3 */
{ 1204,   "ETreeLeafVID",                      4,      1200,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 26.43.5.20.4 L2VPN-I13 Annex B.3.20.4 */
{ 1205,   "BGPAttribute",                      21,     1143,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.5.21 L2VPN-I13 Annex B.3.21 */
{ 1206,   "BGPVPNID",                          1,      1205,   (encode_uint),           (decode_uint),           0,           0             }, /* TLV 26.43.5.21.1 L2VPN-I13 Annex B.3.21.1 */
{ 1207,   "RouteDistinguisher",                2,      1205,   (encode_hexstr),         (decode_hexstr),         8,           8             }, /* TLV 26.43.5.21.2 L2VPN-I13 Annex B.3.21.2 */
{ 1208,   "RouteTargetImport",                 3,      1205,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 26.43.5.21.3 L2VPN-I13 Annex B.3.21.3 */
{ 1209,   "RouteTargetExport",                 4,      1205,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 26.43.5.21.4 L2VPN-I13 Annex B.3.21.4 */
{ 1210,   "CEIDVEID",                          5,      1205,   (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 26.43.5.21.5 L2VPN-I13 Annex B.3.21.5 */
{ 1211,   "PseudowireSignaling",               23,     1143,   (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 26.43.5.23 L2VPN-I13 Annex B.3.23 */
{ 1212,   "SOAMSubtype",                       24,     1143,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.5.24 L2VPN-I13 Annex B.3.24 */
{ 1213,   "MEPConfiguration",                  1,      1212,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.5.24.1 L2VPN-I13 Annex B.3.24.1 */
{ 1214,   "MDLevel",                           1,      1213,   (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 26.43.5.24.1.1 L2VPN-I13 Annex B.3.24.1.1 */
{ 1215,   "MDName",                            2,      1213,   (encode_string),         (decode_string),         2,           16            }, /* TLV 26.43.5.24.1.2 L2VPN-I13 Annex B.3.24.1.2 */
{ 1216,   "MAName",                            3,      1213,   (encode_string),         (decode_string),         2,           28            }, /* TLV 26.43.5.24.1.3 L2VPN-I13 Annex B.3.24.1.3 */
{ 1217,   "MEPID",                             4,      1213,   (encode_ushort),         (decode_ushort),         1,           8191          }, /* TLV 26.43.5.24.1.4 L2VPN-I13 Annex B.3.24.1.4 */
{ 1218,   "RemoteMEPConfiguration",            2,      1212,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.5.24.2 L2VPN-I13 Annex B.3.24.2 */
{ 1219,   "RemoteMDLevel",                     1,      1218,   (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 26.43.5.24.2.1 L2VPN-I13 Annex B.3.24.2.1 */
{ 1220,   "RemoteMDName",                      2,      1218,   (encode_string),         (decode_string),         2,           16            }, /* TLV 26.43.5.24.2.2 L2VPN-I13 Annex B.3.24.2.2 */
{ 1221,   "RemoteMAName",                      3,      1218,   (encode_string),         (decode_string),         2,           28            }, /* TLV 26.43.5.24.2.3 L2VPN-I13 Annex B.3.24.2.3 */
{ 1222,   "RemoteMEPID",                       4,      1218,   (encode_ushort),         (decode_ushort),         1,           8191          }, /* TLV 26.43.5.24.2.4 L2VPN-I13 Annex B.3.24.2.4 */
{ 1223,   "FaultManagementConfiguration",      3,      1212,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.5.24.3 L2VPN-I13 Annex B.3.24.3 */
{ 1224,   "ContinuityCheckMessages",           1,      1223,   (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 26.43.5.24.3.1 L2VPN-I13 Annex B.3.24.3.1 */
{ 1225,   "LoopbackFunction",                  2,      1223,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 26.43.5.24.3.2 L2VPN-I13 Annex B.3.24.3.2 */
{ 1226,   "LinktraceFunction",                 3,      1223,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 26.43.5.24.3.3 L2VPN-I13 Annex B.3.24.3.3 */
{ 1227,   "PerformanceManagementConfiguration", 4,     1212,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.5.24.4 L2VPN-I13 Annex B.3.24.4 */
{ 1228,   "FrameDelayMeasurement",             1,      1227,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.5.24.4.1 L2VPN-I13 Annex B.3.24.4.1 */
{ 1229,   "FrameDelayMeasurementEnable",       1,      1228,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 26.43.5.24.4.1.1 L2VPN-I13 Annex B.3.24.4.1.1 */
{ 1230,   "FrameDelayMeasurementOneWayTwoWay", 2,      1228,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 26.43.5.24.4.1.2 L2VPN-I13 Annex B.3.24.4.1.2 */
{ 1231,   "FrameDelayMeasurementTransmissionPeriodicity", 3, 1228, (encode_ushort),     (decode_ushort),         0,           0             }, /* TLV 26.43.5.24.4.1.3 L2VPN-I13 Annex B.3.24.4.1.3 */
{ 1232,   "FrameLossMeasurement",              2,      1227,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.5.24.4.2 L2VPN-I13 Annex B.3.24.4.2 */
{ 1233,   "FrameLossMeasurementEnable",        1,      1232,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 26.43.5.24.4.2.1 L2VPN-I13 Annex B.3.24.4.2.1 */
{ 1234,   "FrameLossMeasurementTransmissionPeriodicity", 2, 1232, (encode_ushort),      (decode_ushort),         0,           0             }, /* TLV 26.43.5.24.4.2.2 L2VPN-I13 Annex B.3.24.4.2.2 */
{ 1235,   "L2VPNDSID",                         26,     1143,   (encode_uint24),         (decode_uint24),         1,           1048575       }, /* TLV 26.43.5.26 L2VPN-I13 Annex B.3.26 */
{ 1236,   "VendorSpecificL2VPNSubtype",        43,     1143,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.5.43 L2VPN-I13 Annex B.3.11 */
{ 1237,   "VendorIdentifier",                  8,      1236,   (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 26.43.5.43.8 L2VPN-I13 Annex B.3.11 */
{ 1238,   "ExtendedCMTSMICConfigurationSetting", 6,    1138,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.6 MULPIv3.0-I24 Annex C.1.1.18.1.6 */
{ 1239,   "ExtendedCMTSMICHMACtype",           1,      1238,   (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 26.43.6.1 MULPIv3.0-I24 Annex C.1.1.18.1.6.1 */
{ 1240,   "ExtendedCMTSMICBitmap",             2,      1238,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 26.43.6.2 MULPIv3.0-I24 Annex C.1.1.18.1.6.2 */
{ 1241,   "ExplicitExtendedCMTSMICDigest",     3,      1238,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 26.43.6.3 MULPIv3.0-I24 Annex C.1.1.18.1.6.3 */
{ 1242,   "SAVAuthorizationEncoding",          7,      1138,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.7 MULPIv3.0-I24 Annex C.1.1.18.1.7 */
{ 1243,   "SAVGroupName",                      1,      1242,   (encode_string),         (decode_string),         1,           15            }, /* TLV 26.43.7.1 MULPIv3.0-I24 Annex C.1.1.18.1.7.1 */
{ 1244,   "SAVStaticPrefixRule",               2,      1242,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.7.2 MULPIv3.0-I24 Annex C.1.1.18.1.7.2 */
{ 1245,   "SAVStaticPrefixAddress",            1,      1244,   (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 26.43.7.2.1 MULPIv3.0-I24 Annex C.1.1.18.1.7.2.1 */
{ 1246,   "SAVStaticPrefixLength",             2,      1244,   (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 26.43.7.2.2 MULPIv3.0-I24 Annex C.1.1.18.1.7.2.2 */
{ 1247,   "VendorIdentifier",                  8,      1138,   (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 26.43.8 MULPIv3.0-I24 Annex C.2.1.11 */
{ 1248,   "CMAttributeMasks",                  9,      1138,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.9 MULPIv3.0-I24 Annex C.1.1.18.1.8 */
{ 1249,   "CMDownstreamRequiredAttributeMask", 1,      1248,   (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 26.43.9.1 MULPIv3.0-I24 Annex C.1.1.18.1.8.1 */
{ 1250,   "CMDownstreamForbiddenAttributeMask", 2,     1248,   (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 26.43.9.2 MULPIv3.0-I24 Annex C.1.1.18.1.8.2 */
{ 1251,   "CMUpstreamRequiredAttributeMask",   3,      1248,   (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 26.43.9.3 MULPIv3.0-I24 Annex C.1.1.18.1.8.3 */
{ 1252,   "CMUpstreamForbiddenAttributeMask",  4,      1248,   (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 26.43.9.4 MULPIv3.0-I24 Annex C.1.1.18.1.8.4 */
{ 1253,   "IPMulticastJoinAuthorization",      10,     1138,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.10 MULPIv3.0-I24 Annex C.1.1.18.1.9 */
{ 1254,   "IPMulticastProfileName",            1,      1253,   (encode_string),         (decode_string),         1,           15            }, /* TLV 26.43.10.1 MULPIv3.0-I24 Annex C.1.1.18.1.9.1 */
{ 1255,   "IPMulticastJoinAuthStaticSessionRule", 2,   1253,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.10.2 MULPIv3.0-I24 Annex C.1.1.18.1.9.2 */
{ 1256,   "MulticastRulePriority",             1,      1255,   (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 26.43.10.2.1 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.1 */
{ 1257,   "AuthorizationAction",               2,      1255,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 26.43.10.2.2 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.2 */
{ 1258,   "SourcePrefixAddress",               3,      1255,   (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 26.43.10.2.3 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.3 */
{ 1259,   "SourcePrefixLength",                4,      1255,   (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 26.43.10.2.4 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.4 */
{ 1260,   "GroupPrefixAddress",                5,      1255,   (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 26.43.10.2.5 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.5 */
{ 1261,   "GroupPrefixLength",                 6,      1255,   (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 26.43.10.2.6 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.6 */
{ 1262,   "MaximumMulticastSessions",          3,      1253,   (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 26.43.10.3 MULPIv3.0-I24 Annex C.1.1.18.1.9.3 */
{ 1263,   "ServiceTypeIdentifier",             11,     1138,   (encode_string),         (decode_string),         1,           16            }, /* TLV 26.43.11 MULPIv3.0-I24 Annex C.1.1.18.1.10 */
{ 1264,   "DEMARCAutoConfiguration",           12,     1138,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 26.43.12 MULPIv3.0-I24 Annex C.1.1.18.1.11 */
{ 1265,   "DACDisableEnableConfig",            1,      1264,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 26.43.12.1 DEMARCv1.0-I04 Annex B.1 */
{ 1266,   "CMIMEncoding",                      2,      1264,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 26.43.12.2 DEMARCv1.0-I04 Annex B.2 */
{ 1267,   "UpstreamServiceClassName",          3,      1264,   (encode_strzero),        (decode_strzero),        2,           16            }, /* TLV 26.43.12.3 DEMARCv1.0-I04 Annex B.3 */
{ 1268,   "DownstreamServiceClassName",        4,      1264,   (encode_strzero),        (decode_strzero),        2,           16            }, /* TLV 26.43.12.4 DEMARCv1.0-I04 Annex B.4 */
{ 125,    "MaxClassifiers",                    28,     0,      (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 28 MULPIv3.0-I24 Annex C.1.1.16 */
{ 126,    "GlobalPrivacyEnable",               29,     0,      (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 29 MULPIv3.0-I24 Annex C.1.1.17 */
{ 129,    "MfgCVCData",                        32,     0,      (encode_hexstr),         (decode_hexstr),         0,           255           }, /* TLV 32 MULPIv3.0-I24 Annex C.1.2.10 */
{ 170,    "ManufacturerCVC",                   32,     0,      (encode_nothing),        (decode_hexstr),         0,           255           },
{ 171,    "CoSignerCVCData",                   33,     0,      (encode_hexstr),         (decode_hexstr),         0,           255           }, /* TLV 33 MULPIv3.0-I24 Annex C.1.2.11 */
{ 172,    "CoSignerCVC",                       33,     0,      (encode_nothing),        (decode_hexstr),         0,           255           },
{ 132,    "SnmpV3Kickstart",                   34,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 34 MULPIv3.0-I24 Annex C.1.2.9 */
{ 133,    "SnmpV3SecurityName",                1,      132,    (encode_string),         (decode_string),         1,           16            }, /* TLV 34.1 MULPIv3.0-I24 Annex C.1.2.9.1 */
{ 134,    "SnmpV3MgrPublicNumber",             2,      132,    (encode_hexstr),         (decode_hexstr),         1,           514           }, /* TLV 34.2 MULPIv3.0-I24 Annex C.1.2.9.2 */
{ 154,    "SubMgmtControl",                    35,     0,      (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 35 MULPIv3.0-I24 Annex C.1.1.19.1 */
{ 477,    "SubscriberManagementCPEIPTable",    36,     0,      (encode_ip_list),        (decode_ip_list),        0,           0             }, /* TLV 36 MULPIv3.0-I24 Annex C.1.1.19.2 */
{ 155,    "SubMgmtFilters",                    37,     0,      (encode_ushort_list),    (decode_ushort_list),    4,           10            }, /* TLV 37 MULPIv3.0-I24 Annex C.1.1.19.4 */
{ 135,    "SnmpV3TrapReceiver",                38,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 38 MULPIv3.0-I24 Annex C.1.2.12 */
{ 136,    "SnmpV3TrapRxIP",                    1,      135,    (encode_ip),             (decode_ip),             0,           0             }, /* TLV 38.1 MULPIv3.0-I24 Annex C.1.2.12.1 */
{ 137,    "SnmpV3TrapRxPort",                  2,      135,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 38.2 MULPIv3.0-I24 Annex C.1.2.12.2 */
{ 138,    "SnmpV3TrapRxType",                  3,      135,    (encode_ushort),         (decode_ushort),         1,           5             }, /* TLV 38.3 MULPIv3.0-I24 Annex C.1.2.12.3 */
{ 139,    "SnmpV3TrapRxTimeout",               4,      135,    (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 38.4 MULPIv3.0-I24 Annex C.1.2.12.4 */
{ 140,    "SnmpV3TrapRxRetries",               5,      135,    (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 38.5 MULPIv3.0-I24 Annex C.1.2.12.5 */
{ 141,    "SnmpV3TrapRxFilterOID",             6,      135,    (encode_oid),            (decode_oid),            1,           5             }, /* TLV 38.6 MULPIv3.0-I24 Annex C.1.2.12.6 */
{ 142,    "SnmpV3TrapRxSecurityName",          7,      135,    (encode_string),         (decode_string),         1,           16            }, /* TLV 38.7 MULPIv3.0-I24 Annex C.1.2.12.7 */
{ 533,    "SnmpV3TrapRxIP6",                   8,      135,    (encode_ip6),            (decode_ip6),            0,           0             }, /* TLV 38.8 MULPIv3.0-I24 Annex C.1.2.12.8 */
{ 143,    "DocsisTwoEnable",                   39,     0,      (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 39 MULPIv3.0-I24 Annex C.1.1.20 */
{ 532,    "EnableTestModes",                   40,     0,      (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 40 MULPIv3.0-I24 Annex C.1.1.21 */
{ 158,    "DsChannelList",                     41,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 41 MULPIv3.0-I24 Annex C.1.1.22 */
{ 159,    "SingleDsChannel",                   1,      158,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 41.1 MULPIv3.0-I24 Annex C.1.1.22.1 */
{ 160,    "SingleDsTimeout",                   1,      159,    (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 41.1.1 MULPIv3.0-I24 Annex C.1.1.22.1.1 */
{ 161,    "SingleDsFrequency",                 2,      159,    (encode_uint),           (decode_uint),           0,           0xFFFFFFFF    }, /* TLV 41.1.2 MULPIv3.0-I24 Annex C.1.1.22.1.2 */
{ 162,    "DsFreqRange",                       2,      158,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 41.2 MULPIv3.0-I24 Annex C.1.1.22.2 */
{ 163,    "DsFreqRangeTimeout",                1,      162,    (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 41.2.1 MULPIv3.0-I24 Annex C.1.1.22.2.1 */
{ 164,    "DsFreqRangeStart",                  2,      162,    (encode_uint),           (decode_uint),           0,           0xFFFFFFFF    }, /* TLV 41.2.2 MULPIv3.0-I24 Annex C.1.1.22.2.2 */
{ 165,    "DsFreqRangeEnd",                    3,      162,    (encode_uint),           (decode_uint),           0,           0xFFFFFFFF    }, /* TLV 41.2.3 MULPIv3.0-I24 Annex C.1.1.22.2.3 */
{ 166,    "DsFreqRangeStepSize",               4,      162,    (encode_uint),           (decode_uint),           0,           0xFFFFFFFF    }, /* TLV 41.2.4 MULPIv3.0-I24 Annex C.1.1.22.2.4 */
{ 167,    "DefaultScanTimeout",                3,      158,    (encode_ushort),         (decode_ushort),         0,           65535         }, /* TLV 41.3 MULPIv3.0-I24 Annex C.1.1.22.3 */
{ 340,    "MulticastMACAddress",               42,     0,      (encode_ether),          (decode_ether),          0,           0             }, /* TLV 42 MULPIv3.0-I24 Annex C.1.1.23 */
{ 1288,   "VendorSpecific",                    43,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43 MULPIv3.0-I24 Annex C.2.1.11 */
{ 1289,   "CMLoadBalancingPolicyID",           1,      1288,   (encode_uint),           (decode_uint),           0,           0             }, /* TLV 43.1 MULPIv3.0-I24 Annex C.1.1.18.1.1 */
{ 1290,   "CMLoadBalancingPriority",           2,      1288,   (encode_uint),           (decode_uint),           0,           0             }, /* TLV 43.2 MULPIv3.0-I24 Annex C.1.1.18.1.2 */
{ 1291,   "CMLoadBalancingGroupID",            3,      1288,   (encode_uint),           (decode_uint),           0,           0             }, /* TLV 43.3 MULPIv3.0-I24 Annex C.1.1.18.1.3 */
{ 1292,   "CMRangingClassIDExtension",         4,      1288,   (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 43.4 MULPIv3.0-I24 Annex C.1.1.18.1.4 */
{ 1293,   "L2VPNEncoding",                     5,      1288,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.5 MULPIv3.0-I24 Annex C.1.1.18.1.5 */
{ 1294,   "VPNIdentifier",                     1,      1293,   (encode_hexstr),         (decode_hexstr),         4,           255           }, /* TLV 43.5.1 L2VPN-I13 Annex B.3.1 */
{ 1295,   "NSIEncapsulation",                  2,      1293,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.5.2 L2VPN-I13 Annex B.3.2 */
{ 1296,   "ServiceMultiplexingValueOther",     1,      1295,   (encode_lenzero),        (decode_lenzero),        0,           0             }, /* TLV 43.5.2.1 L2VPN-I13 Annex B.3.2 */
{ 1297,   "NSIEncapsulationSingleQTag",        2,      1295,   (encode_ushort),         (decode_ushort),         0,           4096          }, /* TLV 43.5.2.2 L2VPN-I13 Annex B.3.2 */
{ 1298,   "NSIEncapsulationDualQTag",          3,      1295,   (encode_dual_qtag),      (decode_dual_qtag),      0,           0             }, /* TLV 43.5.2.3 L2VPN-I13 Annex B.3.2 */
{ 1299,   "ServiceMultiplexingValueMPLSPW",    4,      1295,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.5.2.4 L2VPN-I13 Annex B.3.2 */
{ 1300,   "MPLSPseudowireID",                  1,      1299,   (encode_uint),           (decode_uint),           0,           0             }, /* TLV 43.5.2.4.1 L2VPN-I13 Annex B.3.2 */
{ 1301,   "MPLSPeerIpAddress",                 2,      1299,   (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 43.5.2.4.2 L2VPN-I13 Annex B.3.2 */
{ 1302,   "MPLSPseudowireType",                3,      1299,   (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 43.5.2.4.3 L2VPN-I13 Annex B.3.2 */
{ 1303,   "MPLSBackupPseudowireID",            4,      1299,   (encode_uint),           (decode_uint),           0,           0             }, /* TLV 43.5.2.4.4 L2VPN-I13 Annex B.3.2 */
{ 1304,   "MPLSBackupPeerIpAddress",           5,      1299,   (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 43.5.2.4.5 L2VPN-I13 Annex B.3.2 */
{ 1305,   "ServiceMultiplexingValueL2TPv3Peer", 5,     1295,   (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 43.5.2.5 L2VPN-I13 Annex B.3.2 */
{ 1306,   "IEEE8021ahEncapsulation",           6,      1295,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.5.2.6 L2VPN-I13 Annex B.3.2.2 */
{ 1307,   "ITCIEncapsulation",                 1,      1306,   (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 43.5.2.6.1 L2VPN-I13 Annex B.3.2.2.1 */
{ 1308,   "BDAEncapsulation",                  2,      1306,   (encode_hexstr),         (decode_hexstr),         6,           6             }, /* TLV 43.5.2.6.2 L2VPN-I13 Annex B.3.2.2.2 */
{ 1309,   "BTCIEncapsulation",                 3,      1306,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.2.6.3 L2VPN-I13 Annex B.3.2.2.3 */
{ 1310,   "ITPIDEncapsulation",                4,      1306,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.2.6.4 L2VPN-I13 Annex B.3.2.2.4 */
{ 1311,   "IPCPEncapsulation",                 5,      1306,   (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 43.5.2.6.5 L2VPN-I13 Annex B.3.2.2.5 */
{ 1312,   "IDEIEncapsulation",                 6,      1306,   (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 43.5.2.6.6 L2VPN-I13 Annex B.3.2.2.6 */
{ 1313,   "IUCAEncapsulation",                 7,      1306,   (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 43.5.2.6.7 L2VPN-I13 Annex B.3.2.2.7 */
{ 1314,   "ISIDEncapsulation",                 8,      1306,   (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 43.5.2.6.8 L2VPN-I13 Annex B.3.2.2.8 */
{ 1315,   "BTPIDEncapsulation",                9,      1306,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.2.6.9 L2VPN-I13 Annex B.3.2.2.9 */
{ 1316,   "BPCPEncapsulation",                 10,     1306,   (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 43.5.2.6.10 L2VPN-I13 Annex B.3.2.2.10 */
{ 1317,   "BDEIEncapsulation",                 11,     1306,   (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 43.5.2.6.11 L2VPN-I13 Annex B.3.2.2.11 */
{ 1318,   "BVIDEncapsulation",                 12,     1306,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.2.6.12 L2VPN-I13 Annex B.3.2.2.11 */
{ 1319,   "ServiceMultiplexingValueIEEE8021adSTPID", 8, 1295,  (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.2.8 L2VPN-I13 Annex B.3.2.1 */
{ 1320,   "eSAFEDHCPSnooping",                 3,      1293,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 43.5.3 L2VPN-I13 Annex B.3.3 */
{ 1321,   "CMInterfaceMaskCMIMSubtype",        4,      1293,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 43.5.4 L2VPN-I13 Annex B.3.4 */
{ 1322,   "AttachmentGroupID",                 5,      1293,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 43.5.5 L2VPN-I13 Annex B.3.5 */
{ 1323,   "SourceAttachmentIndividualID",      6,      1293,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 43.5.6 L2VPN-I13 Annex B.3.6 */
{ 1324,   "TargetAttachmentIndividualID",      7,      1293,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 43.5.7 L2VPN-I13 Annex B.3.7 */
{ 1325,   "IngressUserPriority",               8,      1293,   (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 43.5.8 L2VPN-I13 Annex B.3.8 */
{ 1326,   "UserPriorityRange",                 9,      1293,   (encode_char_list),      (decode_char_list),      0,           0             }, /* TLV 43.5.9 L2VPN-I13 Annex B.3.9 */
{ 1327,   "L2VPNSADescriptorSubtype",          10,     1293,   (encode_hexstr),         (decode_hexstr),         14,          14            }, /* TLV 43.5.10 L2VPN-I13 Annex B.3.10 */
{ 1328,   "PseudowireType",                    12,     1293,   (encode_uchar),          (decode_uchar),          4,           5             }, /* TLV 43.5.12 L2VPN-I13 Annex B.3.13 */
{ 1329,   "L2VPNMode",                         13,     1293,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 43.5.13 L2VPN-I13 Annex B.3.14 */
{ 1330,   "TPIDTranslation",                   14,     1293,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.5.14 L2VPN-I13 Annex B.3.15 */
{ 1331,   "UpstreamTPIDTranslation",           1,      1330,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.14.1 L2VPN-I13 Annex B.3.15.1 */
{ 1332,   "DownstreamTPIDTranslation",         2,      1330,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.14.2 L2VPN-I13 Annex B.3.15.1 */
{ 1333,   "UpstreamSTPIDTranslation",          3,      1330,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.14.3 L2VPN-I13 Annex B.3.15.1 */
{ 1334,   "DownstreamSTPIDTranslation",        4,      1330,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.14.4 L2VPN-I13 Annex B.3.15.1 */
{ 1335,   "UpstreamBTPIDTranslation",          5,      1330,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.14.5 L2VPN-I13 Annex B.3.15.1 */
{ 1336,   "DownstreamBTPIDTranslation",        6,      1330,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.14.6 L2VPN-I13 Annex B.3.15.1 */
{ 1337,   "UpstreamITPIDTranslation",          7,      1330,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.14.7 L2VPN-I13 Annex B.3.15.1 */
{ 1338,   "DownstreamITPIDTranslation",        8,      1330,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.14.8 L2VPN-I13 Annex B.3.15.1 */
{ 1339,   "L2CPProcessing",                    15,     1293,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.5.15 L2VPN-I13 Annex B.3.16 */
{ 1340,   "L2CPTunnelMode",                    1,      1339,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 43.5.15.1 L2VPN-I13 Annex B.3.16.1 */
{ 1341,   "L2CPDMACAddress",                   2,      1339,   (encode_ether),          (decode_ether),          0,           0             }, /* TLV 43.5.15.2 L2VPN-I13 Annex B.3.16.1 */
{ 1342,   "L2CPOverwrotingDMACAddress",        3,      1339,   (encode_ether),          (decode_ether),          0,           0             }, /* TLV 43.5.15.3 L2VPN-I13 Annex B.3.16.1 */
{ 1343,   "DACDisableEnableConfiguration",     16,     1293,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 43.5.16 L2VPN-I13 Annex B.3.17 */
{ 1344,   "PseudowireClass",                   18,     1293,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 43.5.18 L2VPN-I13 Annex B.3.18 */
{ 1345,   "ServiceDelimiter",                  19,     1293,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.5.19 L2VPN-I13 Annex B.3.19 */
{ 1346,   "CVIDDelimiter",                     1,      1345,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.19.1 L2VPN-I13 Annex B.3.19.1 */
{ 1347,   "SVIDDelimiter",                     2,      1345,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.19.2 L2VPN-I13 Annex B.3.19.2 */
{ 1348,   "ISIDDelimiter",                     3,      1345,   (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 43.5.19.3 L2VPN-I13 Annex B.3.19.3 */
{ 1349,   "BVIDDelimiter",                     4,      1345,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.19.4 L2VPN-I13 Annex B.3.19.4 */
{ 1350,   "VirtualSwitchInstanceEncoding",     20,     1293,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.5.20 L2VPN-I13 Annex B.3.20 */
{ 1351,   "VPLSClass",                         1,      1350,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 43.5.20.1 L2VPN-I13 Annex B.3.20.1 */
{ 1352,   "ETreeRole",                         2,      1350,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 43.5.20.2 L2VPN-I13 Annex B.3.20.2 */
{ 1353,   "ETreeRootVID",                      3,      1350,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.20.3 L2VPN-I13 Annex B.3.20.3 */
{ 1354,   "ETreeLeafVID",                      4,      1350,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 43.5.20.4 L2VPN-I13 Annex B.3.20.4 */
{ 1355,   "BGPAttribute",                      21,     1293,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.5.21 L2VPN-I13 Annex B.3.21 */
{ 1356,   "BGPVPNID",                          1,      1355,   (encode_uint),           (decode_uint),           0,           0             }, /* TLV 43.5.21.1 L2VPN-I13 Annex B.3.21.1 */
{ 1357,   "RouteDistinguisher",                2,      1355,   (encode_hexstr),         (decode_hexstr),         8,           8             }, /* TLV 43.5.21.2 L2VPN-I13 Annex B.3.21.2 */
{ 1358,   "RouteTargetImport",                 3,      1355,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 43.5.21.3 L2VPN-I13 Annex B.3.21.3 */
{ 1359,   "RouteTargetExport",                 4,      1355,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 43.5.21.4 L2VPN-I13 Annex B.3.21.4 */
{ 1360,   "CEIDVEID",                          5,      1355,   (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 43.5.21.5 L2VPN-I13 Annex B.3.21.5 */
{ 1361,   "PseudowireSignaling",               23,     1293,   (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 43.5.23 L2VPN-I13 Annex B.3.23 */
{ 1362,   "SOAMSubtype",                       24,     1293,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.5.24 L2VPN-I13 Annex B.3.24 */
{ 1363,   "MEPConfiguration",                  1,      1362,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.5.24.1 L2VPN-I13 Annex B.3.24.1 */
{ 1364,   "MDLevel",                           1,      1363,   (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 43.5.24.1.1 L2VPN-I13 Annex B.3.24.1.1 */
{ 1365,   "MDName",                            2,      1363,   (encode_string),         (decode_string),         2,           16            }, /* TLV 43.5.24.1.2 L2VPN-I13 Annex B.3.24.1.2 */
{ 1366,   "MAName",                            3,      1363,   (encode_string),         (decode_string),         2,           28            }, /* TLV 43.5.24.1.3 L2VPN-I13 Annex B.3.24.1.3 */
{ 1367,   "MEPID",                             4,      1363,   (encode_ushort),         (decode_ushort),         1,           8191          }, /* TLV 43.5.24.1.4 L2VPN-I13 Annex B.3.24.1.4 */
{ 1368,   "RemoteMEPConfiguration",            2,      1362,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.5.24.2 L2VPN-I13 Annex B.3.24.2 */
{ 1369,   "RemoteMDLevel",                     1,      1368,   (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 43.5.24.2.1 L2VPN-I13 Annex B.3.24.2.1 */
{ 1370,   "RemoteMDName",                      2,      1368,   (encode_string),         (decode_string),         2,           16            }, /* TLV 43.5.24.2.2 L2VPN-I13 Annex B.3.24.2.2 */
{ 1371,   "RemoteMAName",                      3,      1368,   (encode_string),         (decode_string),         2,           28            }, /* TLV 43.5.24.2.3 L2VPN-I13 Annex B.3.24.2.3 */
{ 1372,   "RemoteMEPID",                       4,      1368,   (encode_ushort),         (decode_ushort),         1,           8191          }, /* TLV 43.5.24.2.4 L2VPN-I13 Annex B.3.24.2.4 */
{ 1373,   "FaultManagementConfiguration",      3,      1362,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.5.24.3 L2VPN-I13 Annex B.3.24.3 */
{ 1374,   "ContinuityCheckMessages",           1,      1373,   (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 43.5.24.3.1 L2VPN-I13 Annex B.3.24.3.1 */
{ 1375,   "LoopbackFunction",                  2,      1373,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 43.5.24.3.2 L2VPN-I13 Annex B.3.24.3.2 */
{ 1376,   "LinktraceFunction",                 3,      1373,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 43.5.24.3.3 L2VPN-I13 Annex B.3.24.3.3 */
{ 1377,   "PerformanceManagementConfiguration", 4,     1362,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.5.24.4 L2VPN-I13 Annex B.3.24.4 */
{ 1378,   "FrameDelayMeasurement",             1,      1377,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.5.24.4.1 L2VPN-I13 Annex B.3.24.4.1 */
{ 1379,   "FrameDelayMeasurementEnable",       1,      1378,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 43.5.24.4.1.1 L2VPN-I13 Annex B.3.24.4.1.1 */
{ 1380,   "FrameDelayMeasurementOneWayTwoWay", 2,      1378,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 43.5.24.4.1.2 L2VPN-I13 Annex B.3.24.4.1.2 */
{ 1381,   "FrameDelayMeasurementTransmissionPeriodicity", 3, 1378, (encode_ushort),     (decode_ushort),         0,           0             }, /* TLV 43.5.24.4.1.3 L2VPN-I13 Annex B.3.24.4.1.3 */
{ 1382,   "FrameLossMeasurement",              2,      1377,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.5.24.4.2 L2VPN-I13 Annex B.3.24.4.2 */
{ 1383,   "FrameLossMeasurementEnable",        1,      1382,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 43.5.24.4.2.1 L2VPN-I13 Annex B.3.24.4.2.1 */
{ 1384,   "FrameLossMeasurementTransmissionPeriodicity", 2, 1382, (encode_ushort),      (decode_ushort),         0,           0             }, /* TLV 43.5.24.4.2.2 L2VPN-I13 Annex B.3.24.4.2.2 */
{ 1385,   "L2VPNDSID",                         26,     1293,   (encode_uint24),         (decode_uint24),         1,           1048575       }, /* TLV 43.5.26 L2VPN-I13 Annex B.3.26 */
{ 1386,   "VendorSpecificL2VPNSubtype",        43,     1293,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.5.43 L2VPN-I13 Annex B.3.11 */
{ 1387,   "VendorIdentifier",                  8,      1386,   (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 43.5.43.8 L2VPN-I13 Annex B.3.11 */
{ 1388,   "ExtendedCMTSMICConfiguration",      6,      1288,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.6 MULPIv3.0-I24 Annex C.1.1.18.1.6 */
{ 1389,   "ExtendedCMTSMICHMACDigestType",     1,      1388,   (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 43.6.1 MULPIv3.0-I24 Annex C.1.1.18.1.6.1 */
{ 1390,   "ExtendedCMTSMICHMACBitmap",         2,      1388,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 43.6.2 MULPIv3.0-I24 Annex C.1.1.18.1.6.2 */
{ 1391,   "ExtendedCMTSMICHMACDigest",         3,      1388,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 43.6.3 MULPIv3.0-I24 Annex C.1.1.18.1.6.3 */
{ 1392,   "SAVAuthorizationEncoding",          7,      1288,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.7 MULPIv3.0-I24 Annex C.1.1.18.1.7 */
{ 1393,   "SAVGroupName",                      1,      1392,   (encode_string),         (decode_string),         1,           15            }, /* TLV 43.7.1 MULPIv3.0-I24 Annex C.1.1.18.1.7.1 */
{ 1394,   "SAVStaticPrefixRule",               2,      1392,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.7.2 MULPIv3.0-I24 Annex C.1.1.18.1.7.2 */
{ 1395,   "SAVStaticPrefixAddress",            1,      1394,   (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 43.7.2.1 MULPIv3.0-I24 Annex C.1.1.18.1.7.2.1 */
{ 1396,   "SAVStaticPrefixLength",             2,      1394,   (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 43.7.2.2 MULPIv3.0-I24 Annex C.1.1.18.1.7.2.2 */
{ 1397,   "VendorIdentifier",                  8,      1288,   (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 43.8 MULPIv3.0-I24 Annex C.2.1.11 */
{ 1398,   "CMAttributeMasks",                  9,      1288,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.9 MULPIv3.0-I24 Annex C.1.1.18.1.8 */
{ 1399,   "CMDownstreamRequiredAttributeMask", 1,      1398,   (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 43.9.1 MULPIv3.0-I24 Annex C.1.1.18.1.8.1 */
{ 1400,   "CMDownstreamForbiddenAttributeMask", 2,     1398,   (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 43.9.2 MULPIv3.0-I24 Annex C.1.1.18.1.8.2 */
{ 1401,   "CMUpstreamRequiredAttributeMask",   3,      1398,   (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 43.9.3 MULPIv3.0-I24 Annex C.1.1.18.1.8.3 */
{ 1402,   "CMUpstreamForbiddenAttributeMask",  4,      1398,   (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 43.9.4 MULPIv3.0-I24 Annex C.1.1.18.1.8.4 */
{ 1403,   "IPMulticastJoinAuthorization",      10,     1288,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.10 MULPIv3.0-I24 Annex C.1.1.18.1.9 */
{ 1404,   "IPMulticastProfileName",            1,      1403,   (encode_string),         (decode_string),         1,           15            }, /* TLV 43.10.1 MULPIv3.0-I24 Annex C.1.1.18.1.9.1 */
{ 1405,   "IPMulticastJoinAuthStaticSessionRule", 2,   1403,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.10.2 MULPIv3.0-I24 Annex C.1.1.18.1.9.2 */
{ 1406,   "MulticastRulePriority",             1,      1405,   (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 43.10.2.1 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.1 */
{ 1407,   "AuthorizationAction",               2,      1405,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 43.10.2.2 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.2 */
{ 1408,   "SourcePrefixAddress",               3,      1405,   (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 43.10.2.3 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.3 */
{ 1409,   "SourcePrefixLength",                4,      1405,   (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 43.10.2.4 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.4 */
{ 1410,   "GroupPrefixAddress",                5,      1405,   (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 43.10.2.5 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.5 */
{ 1411,   "GroupPrefixLength",                 6,      1405,   (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 43.10.2.6 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.6 */
{ 1412,   "MaximumMulticastSessions",          3,      1403,   (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 43.10.3 MULPIv3.0-I24 Annex C.1.1.18.1.9.3 */
{ 1413,   "ServiceTypeIdentifier",             11,     1288,   (encode_string),         (decode_string),         1,           16            }, /* TLV 43.11 MULPIv3.0-I24 Annex C.1.1.18.1.10 */
{ 1414,   "DEMARCAutoConfiguration",           12,     1288,   (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 43.12 MULPIv3.0-I24 Annex C.1.1.18.1.11 */
{ 1415,   "DACDisableEnableConfig",            1,      1414,   (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 43.12.1 DEMARCv1.0-I04 Annex B.1 */
{ 1416,   "CMIMEncoding",                      2,      1414,   (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 43.12.2 DEMARCv1.0-I04 Annex B.2 */
{ 1417,   "UpstreamServiceClassName",          3,      1414,   (encode_strzero),        (decode_strzero),        2,           16            }, /* TLV 43.12.3 DEMARCv1.0-I04 Annex B.3 */
{ 1418,   "DownstreamServiceClassName",        4,      1414,   (encode_strzero),        (decode_strzero),        2,           16            }, /* TLV 43.12.4 DEMARCv1.0-I04 Annex B.4 */
{ 208,    "DUTFiltering",                      45,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 45 MULPIv3.0-I24 Annex C.1.1.24 */
{ 209,    "DUTControl",                        1,      208,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 45.1 L2VPN-I13 Annex B.2.1 */
{ 210,    "DUTCMIM",                           2,      208,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 45.2 L2VPN-I13 Annex B.2.2 */
{ 534,    "SNMPv1v2cCoexistenceConfig",        53,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 53 MULPIv3.0-I24 Annex C.1.2.13 */
{ 535,    "SNMPv1v2cCommunityName",            1,      534,    (encode_string),         (decode_string),         0,           0             }, /* TLV 53.1 MULPIv3.0-I24 Annex C.1.2.13.1 */
{ 536,    "SNMPv1v2cTransportAddressAccess",   2,      534,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 53.2 MULPIv3.0-I24 Annex C.1.2.13.2 */
{ 537,    "SNMPv1v2cTransportAddress",         1,      536,    (encode_ip_ip6_port),    (decode_ip_ip6_port),    0,           0             }, /* TLV 53.2.1 MULPIv3.0-I24 Annex C.1.2.13.2.1 */
{ 538,    "SNMPv1v2cTransportAddressMask",     2,      536,    (encode_ip_ip6_port),    (decode_ip_ip6_port),    0,           0             }, /* TLV 53.2.2 MULPIv3.0-I24 Annex C.1.2.13.2.2 */
{ 539,    "SNMPv1v2cAccessViewType",           3,      534,    (encode_uchar),          (decode_uchar),          1,           2             }, /* TLV 53.3 MULPIv3.0-I24 Annex C.1.2.13.3 */
{ 540,    "SNMPv1v2cAccessViewName",           4,      534,    (encode_string),         (decode_string),         0,           0             }, /* TLV 53.4 MULPIv3.0-I24 Annex C.1.2.13.4 */
{ 541,    "SNMPv3AccessViewConfiguration",     54,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 54 MULPIv3.0-I24 Annex C.1.2.14 */
{ 542,    "SNMPv3AccessViewName",              1,      541,    (encode_string),         (decode_string),         0,           0             }, /* TLV 54.1 MULPIv3.0-I24 Annex C.1.2.14.1 */
{ 543,    "SNMPv3AccessViewSubtree",           2,      541,    (encode_oid),            (decode_oid),            0,           0             }, /* TLV 54.2 MULPIv3.0-I24 Annex C.1.2.14.2 */
{ 544,    "SNMPv3AccessViewMask",              3,      541,    (encode_hexstr),         (decode_hexstr),         1,           2             }, /* TLV 54.3 MULPIv3.0-I24 Annex C.1.2.14.3 */
{ 545,    "SNMPv3AccessViewType",              4,      541,    (encode_uchar),          (decode_uchar),          1,           2             }, /* TLV 54.4 MULPIv3.0-I24 Annex C.1.2.14.4 */
{ 531,    "SNMPCPEAccessControl",              55,     0,      (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 55 MULPIv3.0-I24 Annex C.1.2.15 */
{ 185,    "ChannelAssignmentConfig",           56,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 56 MULPIv3.0-I24 Annex C.1.1.25 */
{ 186,    "CaTransmit",                        1,      185,    (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 56.1 MULPIv3.0-I24 Annex C.1.1.25.1 */
{ 187,    "CaReceive",                         2,      185,    (encode_uint),           (decode_uint),           88000000,    860000000     }, /* TLV 56.2 MULPIv3.0-I24 Annex C.1.1.25.2 */
{ 173,    "SwUpgradeServer6",                  58,     0,      (encode_ip6),            (decode_ip6),            0,           0             }, /* TLV 58 MULPIv3.0-I24 Annex C.1.2.8 */
{ 530,    "TFTPProvisionedModemIPv6Address",   59,     0,      (encode_ip6),            (decode_ip6),            0,           0             }, /* TLV 59 MULPIv3.0-I24 Annex C.1.1.10 */
{ 546,    "UpstreamDropPacketClassification",  60,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60 MULPIv3.0-I24 Annex C.2.1.2 */
{ 547,    "ClassifierReference",               1,      546,    (encode_uchar),          (decode_uchar),          1,           255           }, /* TLV 60.1 MULPIv3.0-I24 Annex C.2.1.4.1 */
{ 548,    "ClassifierIdentifier",              2,      546,    (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 60.2 MULPIv3.0-I24 Annex C.2.1.4.2 */
{ 549,    "RulePriority",                      5,      546,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 60.5 MULPIv3.0-I24 Annex C.2.1.4.5 */
{ 550,    "DynamicServiceChangeAction",        7,      546,    (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 60.7 MULPIv3.0-I24 Annex C.2.1.4.7 */
{ 551,    "IPv4PacketClassification",          9,      546,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.9 MULPIv3.0-I24 Annex C.2.1.6 */
{ 552,    "IPv4Tos",                           1,      551,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 60.9.1 MULPIv3.0-I24 Annex C.2.1.6.1 */
{ 553,    "IPProtocol",                        2,      551,    (encode_ushort),         (decode_ushort),         0,           257           }, /* TLV 60.9.2 MULPIv3.0-I24 Annex C.2.1.6.2 */
{ 554,    "IPv4SourceAddress",                 3,      551,    (encode_ip),             (decode_ip),             0,           0             }, /* TLV 60.9.3 MULPIv3.0-I24 Annex C.2.1.6.3 */
{ 555,    "IPv4SourceMask",                    4,      551,    (encode_ip),             (decode_ip),             0,           0             }, /* TLV 60.9.4 MULPIv3.0-I24 Annex C.2.1.6.4 */
{ 556,    "IPv4DestinationAddress",            5,      551,    (encode_ip),             (decode_ip),             0,           0             }, /* TLV 60.9.5 MULPIv3.0-I24 Annex C.2.1.6.5 */
{ 557,    "IPv4DestinationMask",               6,      551,    (encode_ip),             (decode_ip),             0,           0             }, /* TLV 60.9.6 MULPIv3.0-I24 Annex C.2.1.6.6 */
{ 558,    "SourcePortStart",                   7,      551,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 60.9.7 MULPIv3.0-I24 Annex C.2.1.7.1 */
{ 559,    "SourcePortEnd",                     8,      551,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 60.9.8 MULPIv3.0-I24 Annex C.2.1.7.2 */
{ 560,    "DestinationPortStart",              9,      551,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 60.9.9 MULPIv3.0-I24 Annex C.2.1.7.3 */
{ 561,    "DestinationPortEnd",                10,     551,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 60.9.10 MULPIv3.0-I24 Annex C.2.1.7.4 */
{ 562,    "EthernetLLCPacketClassification",   10,     546,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.10 MULPIv3.0-I24 Annex C.2.1.8 */
{ 563,    "DestinationMACAddress",             1,      562,    (encode_ethermask),      (decode_ethermask),      0,           0             }, /* TLV 60.10.1 MULPIv3.0-I24 Annex C.2.1.8.1 */
{ 564,    "SourceMACAddress",                  2,      562,    (encode_ether),          (decode_ether),          0,           0             }, /* TLV 60.10.2 MULPIv3.0-I24 Annex C.2.1.8.2 */
{ 565,    "EthertypeDSAPMacType",              3,      562,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 60.10.3 MULPIv3.0-I24 Annex C.2.1.8.3 */
{ 566,    "IEEE8021PQPacketClassification",    11,     546,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.11 MULPIv3.0-I24 Annex C.2.1.9 */
{ 567,    "UserPriority",                      1,      566,    (encode_char_list),      (decode_char_list),      0,           0             }, /* TLV 60.11.1 MULPIv3.0-I24 Annex C.2.1.9.1 */
{ 568,    "VlanID",                            2,      566,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 60.11.2 MULPIv3.0-I24 Annex C.2.1.9.2 */
{ 569,    "IPv6PacketClassification",          12,     546,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.12 MULPIv3.0-I24 Annex C.2.1.10 */
{ 570,    "IPv6TrafficClassRangeandMask",      1,      569,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 60.12.1 MULPIv3.0-I24 Annex C.2.1.10.1 */
{ 571,    "IPv6FlowLabel",                     2,      569,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 60.12.2 MULPIv3.0-I24 Annex C.2.1.10.2 */
{ 572,    "IPv6NextHeaderType",                3,      569,    (encode_ushort),         (decode_ushort),         0,           257           }, /* TLV 60.12.3 MULPIv3.0-I24 Annex C.2.1.10.3 */
{ 573,    "IPv6SourceAddress",                 4,      569,    (encode_ip6),            (decode_ip6),            0,           0             }, /* TLV 60.12.4 MULPIv3.0-I24 Annex C.2.1.10.4 */
{ 574,    "IPv6SourcePrefixLength",            5,      569,    (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 60.12.5 MULPIv3.0-I24 Annex C.2.1.10.5 */
{ 575,    "IPv6DestinationAddress",            6,      569,    (encode_ip6),            (decode_ip6),            0,           0             }, /* TLV 60.12.6 MULPIv3.0-I24 Annex C.2.1.10.6 */
{ 576,    "IPv6DestinationPrefixLength",       7,      569,    (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 60.12.7 MULPIv3.0-I24 Annex C.2.1.10.7 */
{ 577,    "CMInterfaceMaskEncoding",           13,     546,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 60.13 MULPIv3.0-I24 Annex C.2.1.4.8 */
{ 578,    "STagCTagFrameClassification",       14,     546,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.14 MULPIv3.0-I24 Annex C.2.1.13 */
{ 579,    "STPID",                             1,      578,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.14.1 MULPIv3.0-I24 Annex C.2.1.13.1 */
{ 580,    "SVID",                              2,      578,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.14.2 MULPIv3.0-I24 Annex C.2.1.13.2 */
{ 581,    "SPCP",                              3,      578,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 60.14.3 MULPIv3.0-I24 Annex C.2.1.13.3 */
{ 582,    "SDEI",                              4,      578,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 60.14.4 MULPIv3.0-I24 Annex C.2.1.13.4 */
{ 583,    "CTPID",                             5,      578,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.14.5 MULPIv3.0-I24 Annex C.2.1.13.5 */
{ 584,    "CVID",                              6,      578,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.14.6 MULPIv3.0-I24 Annex C.2.1.13.6 */
{ 585,    "CPCP",                              7,      578,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 60.14.7 MULPIv3.0-I24 Annex C.2.1.13.7 */
{ 586,    "CCFI",                              8,      578,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 60.14.8 MULPIv3.0-I24 Annex C.2.1.13.8 */
{ 587,    "STCI",                              9,      578,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.14.9 MULPIv3.0-I24 Annex C.2.1.13.9 */
{ 588,    "CTCI",                              10,     578,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.14.10 MULPIv3.0-I24 Annex C.2.1.13.10 */
{ 589,    "IEEE8021ahPacketClassification",    15,     546,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.15 MULPIv3.0-I24 Annex C.2.1.14 */
{ 590,    "ITPID",                             1,      589,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.15.1 MULPIv3.0-I24 Annex C.2.1.14.1 */
{ 591,    "ISID",                              2,      589,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 60.15.2 MULPIv3.0-I24 Annex C.2.1.14.2 */
{ 592,    "ITCI",                              3,      589,    (encode_hexstr),         (decode_hexstr),         5,           5             }, /* TLV 60.15.3 MULPIv3.0-I24 Annex C.2.1.14.3 */
{ 593,    "IPCP",                              4,      589,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 60.15.4 MULPIv3.0-I24 Annex C.2.1.14.4 */
{ 594,    "IDEI",                              5,      589,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 60.15.5 MULPIv3.0-I24 Annex C.2.1.14.5 */
{ 595,    "IUCA",                              6,      589,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 60.15.6 MULPIv3.0-I24 Annex C.2.1.14.6 */
{ 596,    "BTPID",                             7,      589,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.15.7 MULPIv3.0-I24 Annex C.2.1.14.7 */
{ 597,    "BTCI",                              8,      589,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.15.8 MULPIv3.0-I24 Annex C.2.1.14.8 */
{ 598,    "BPCP",                              9,      589,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 60.15.9 MULPIv3.0-I24 Annex C.2.1.14.9 */
{ 599,    "BDEI",                              10,     589,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 60.15.10 MULPIv3.0-I24 Annex C.2.1.14.10 */
{ 600,    "BVID",                              11,     589,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.15.11 MULPIv3.0-I24 Annex C.2.1.14.11 */
{ 601,    "BDA",                               12,     589,    (encode_ether),          (decode_ether),          0,           0             }, /* TLV 60.15.12 MULPIv3.0-I24 Annex C.2.1.14.12 */
{ 602,    "BSA",                               13,     589,    (encode_ether),          (decode_ether),          0,           0             }, /* TLV 60.15.13 MULPIv3.0-I24 Annex C.2.1.14.13 */
{ 603,    "ICMPv4ICMPv6PacketClassification",  16,     546,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.16 MULPIv3.0-I24 Annex C.2.1.12 */
{ 604,    "ICMPv4ICMPv6TypeStart",             1,      603,    (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 60.16.1 MULPIv3.0-I24 Annex C.2.1.12.1 */
{ 605,    "ICMPv4ICMPv6TypeEnd",               2,      603,    (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 60.16.2 MULPIv3.0-I24 Annex C.2.1.12.2 */
{ 606,    "MPLSClassificationEncoding",        17,     546,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.17 MULPIv3.0-I24 Annex C.2.1.15 */
{ 607,    "MPLSTCbits",                        1,      606,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 60.17.1 MULPIv3.0-I24 Annex C.2.1.15.1 */
{ 608,    "MPLSLabel",                         2,      606,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 60.17.2 MULPIv3.0-I24 Annex C.2.1.15.2 */
{ 609,    "VendorSpecific",                    43,     546,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43 MULPIv3.0-I24 Annex C.2.1.11 */
{ 610,    "CMLoadBalancingPolicyID",           1,      609,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 60.43.1 MULPIv3.0-I24 Annex C.1.1.18.1.1 */
{ 611,    "CMLoadBalancingPriority",           2,      609,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 60.43.2 MULPIv3.0-I24 Annex C.1.1.18.1.2 */
{ 612,    "CMLoadBalancingGroupID",            3,      609,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 60.43.3 MULPIv3.0-I24 Annex C.1.1.18.1.3 */
{ 613,    "CMRangingClassIDExtension",         4,      609,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 60.43.4 MULPIv3.0-I24 Annex C.1.1.18.1.4 */
{ 615,    "L2VPNEncoding",                     5,      609,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.5 MULPIv3.0-I24 Annex C.1.1.18.1.5 */
{ 616,    "VPNIdentifier",                     1,      615,    (encode_hexstr),         (decode_hexstr),         4,           255           }, /* TLV 60.43.5.1 L2VPN-I13 Annex B.3.1 */
{ 617,    "NSIEncapsulation",                  2,      615,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.5.2 L2VPN-I13 Annex B.3.2 */
{ 618,    "ServiceMultiplexingValueOther",     1,      617,    (encode_lenzero),        (decode_lenzero),        0,           0             }, /* TLV 60.43.5.2.1 L2VPN-I13 Annex B.3.2 */
{ 619,    "NSIEncapsulationSingleQTag",        2,      617,    (encode_ushort),         (decode_ushort),         0,           4096          }, /* TLV 60.43.5.2.2 L2VPN-I13 Annex B.3.2 */
{ 620,    "NSIEncapsulationDualQTag",          3,      617,    (encode_dual_qtag),      (decode_dual_qtag),      0,           0             }, /* TLV 60.43.5.2.3 L2VPN-I13 Annex B.3.2 */
{ 621,    "ServiceMultiplexingValueMPLSPW",    4,      617,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.5.2.4 L2VPN-I13 Annex B.3.2 */
{ 622,    "MPLSPseudowireID",                  1,      621,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 60.43.5.2.4.1 L2VPN-I13 Annex B.3.2 */
{ 623,    "MPLSPeerIpAddress",                 2,      621,    (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 60.43.5.2.4.2 L2VPN-I13 Annex B.3.2 */
{ 624,    "MPLSPseudowireType",                3,      621,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 60.43.5.2.4.3 L2VPN-I13 Annex B.3.2 */
{ 625,    "MPLSBackupPseudowireID",            4,      621,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 60.43.5.2.4.4 L2VPN-I13 Annex B.3.2 */
{ 626,    "MPLSBackupPeerIpAddress",           5,      621,    (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 60.43.5.2.4.5 L2VPN-I13 Annex B.3.2 */
{ 627,    "ServiceMultiplexingValueL2TPv3Peer", 5,     617,    (encode_char_ip_ip6),    (decode_char_ip_ip6),    0,           0             }, /* TLV 60.43.5.2.5 L2VPN-I13 Annex B.3.2 */
{ 628,    "IEEE8021ahEncapsulation",           6,      617,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.5.2.6 L2VPN-I13 Annex B.3.2.2 */
{ 629,    "ITCIEncapsulation",                 1,      628,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 60.43.5.2.6.1 L2VPN-I13 Annex B.3.2.2.1 */
{ 630,    "BDAEncapsulation",                  2,      628,    (encode_hexstr),         (decode_hexstr),         6,           6             }, /* TLV 60.43.5.2.6.2 L2VPN-I13 Annex B.3.2.2.2 */
{ 631,    "BTCIEncapsulation",                 3,      628,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.2.6.3 L2VPN-I13 Annex B.3.2.2.3 */
{ 632,    "ITPIDEncapsulation",                4,      628,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.2.6.4 L2VPN-I13 Annex B.3.2.2.4 */
{ 633,    "IPCPEncapsulation",                 5,      628,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 60.43.5.2.6.5 L2VPN-I13 Annex B.3.2.2.5 */
{ 634,    "IDEIEncapsulation",                 6,      628,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 60.43.5.2.6.6 L2VPN-I13 Annex B.3.2.2.6 */
{ 635,    "IUCAEncapsulation",                 7,      628,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 60.43.5.2.6.7 L2VPN-I13 Annex B.3.2.2.7 */
{ 636,    "ISIDEncapsulation",                 8,      628,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 60.43.5.2.6.8 L2VPN-I13 Annex B.3.2.2.8 */
{ 637,    "BTPIDEncapsulation",                9,      628,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.2.6.9 L2VPN-I13 Annex B.3.2.2.9 */
{ 638,    "BPCPEncapsulation",                 10,     628,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 60.43.5.2.6.10 L2VPN-I13 Annex B.3.2.2.10 */
{ 639,    "BDEIEncapsulation",                 11,     628,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 60.43.5.2.6.11 L2VPN-I13 Annex B.3.2.2.11 */
{ 640,    "BVIDEncapsulation",                 12,     628,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.2.6.12 L2VPN-I13 Annex B.3.2.2.11 */
{ 641,    "ServiceMultiplexingValueIEEE8021adSTPID", 8, 617,   (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.2.8 L2VPN-I13 Annex B.3.2.1 */
{ 642,    "eSAFEDHCPSnooping",                 3,      615,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 60.43.5.3 L2VPN-I13 Annex B.3.3 */
{ 643,    "CMInterfaceMaskCMIMSubtype",        4,      615,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 60.43.5.4 L2VPN-I13 Annex B.3.4 */
{ 644,    "AttachmentGroupID",                 5,      615,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 60.43.5.5 L2VPN-I13 Annex B.3.5 */
{ 645,    "SourceAttachmentIndividualID",      6,      615,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 60.43.5.6 L2VPN-I13 Annex B.3.6 */
{ 646,    "TargetAttachmentIndividualID",      7,      615,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 60.43.5.7 L2VPN-I13 Annex B.3.7 */
{ 647,    "IngressUserPriority",               8,      615,    (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 60.43.5.8 L2VPN-I13 Annex B.3.8 */
{ 648,    "UserPriorityRange",                 9,      615,    (encode_char_list),      (decode_char_list),      0,           0             }, /* TLV 60.43.5.9 L2VPN-I13 Annex B.3.9 */
{ 649,    "L2VPNSADescriptorSubtype",          10,     615,    (encode_hexstr),         (decode_hexstr),         14,          14            }, /* TLV 60.43.5.10 L2VPN-I13 Annex B.3.10 */
{ 650,    "PseudowireType",                    12,     615,    (encode_uchar),          (decode_uchar),          4,           5             }, /* TLV 60.43.5.12 L2VPN-I13 Annex B.3.13 */
{ 651,    "L2VPNMode",                         13,     615,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 60.43.5.13 L2VPN-I13 Annex B.3.14 */
{ 658,    "TPIDTranslation",                   14,     615,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.5.14 L2VPN-I13 Annex B.3.15 */
{ 659,    "UpstreamTPIDTranslation",           1,      658,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.14.1 L2VPN-I13 Annex B.3.15.1 */
{ 660,    "DownstreamTPIDTranslation",         2,      658,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.14.2 L2VPN-I13 Annex B.3.15.1 */
{ 661,    "UpstreamSTPIDTranslation",          3,      658,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.14.3 L2VPN-I13 Annex B.3.15.1 */
{ 662,    "DownstreamSTPIDTranslation",        4,      658,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.14.4 L2VPN-I13 Annex B.3.15.1 */
{ 663,    "UpstreamBTPIDTranslation",          5,      658,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.14.5 L2VPN-I13 Annex B.3.15.1 */
{ 664,    "DownstreamBTPIDTranslation",        6,      658,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.14.6 L2VPN-I13 Annex B.3.15.1 */
{ 665,    "UpstreamITPIDTranslation",          7,      658,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.14.7 L2VPN-I13 Annex B.3.15.1 */
{ 666,    "DownstreamITPIDTranslation",        8,      658,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.14.8 L2VPN-I13 Annex B.3.15.1 */
{ 667,    "L2CPProcessing",                    15,     615,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.5.15 L2VPN-I13 Annex B.3.16 */
{ 668,    "L2CPTunnelMode",                    1,      667,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 60.43.5.15.1 L2VPN-I13 Annex B.3.16.1 */
{ 669,    "L2CPDMACAddress",                   2,      667,    (encode_ether),          (decode_ether),          0,           0             }, /* TLV 60.43.5.15.2 L2VPN-I13 Annex B.3.16.1 */
{ 670,    "L2CPOverwrotingDMACAddress",        3,      667,    (encode_ether),          (decode_ether),          0,           0             }, /* TLV 60.43.5.15.3 L2VPN-I13 Annex B.3.16.1 */
{ 671,    "DACDisableEnableConfiguration",     16,     615,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 60.43.5.16 L2VPN-I13 Annex B.3.17 */
{ 672,    "PseudowireClass",                   18,     615,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 60.43.5.18 L2VPN-I13 Annex B.3.18 */
{ 673,    "ServiceDelimiter",                  19,     615,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.5.19 L2VPN-I13 Annex B.3.19 */
{ 674,    "CVIDDelimiter",                     1,      673,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.19.1 L2VPN-I13 Annex B.3.19.1 */
{ 675,    "SVIDDelimiter",                     2,      673,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.19.2 L2VPN-I13 Annex B.3.19.2 */
{ 676,    "ISIDDelimiter",                     3,      673,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 60.43.5.19.3 L2VPN-I13 Annex B.3.19.3 */
{ 677,    "BVIDDelimiter",                     4,      673,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.19.4 L2VPN-I13 Annex B.3.19.4 */
{ 678,    "VirtualSwitchInstanceEncoding",     20,     615,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.5.20 L2VPN-I13 Annex B.3.20 */
{ 679,    "VPLSClass",                         1,      678,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 60.43.5.20.1 L2VPN-I13 Annex B.3.20.1 */
{ 680,    "ETreeRole",                         2,      678,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 60.43.5.20.2 L2VPN-I13 Annex B.3.20.2 */
{ 681,    "ETreeRootVID",                      3,      678,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.20.3 L2VPN-I13 Annex B.3.20.3 */
{ 682,    "ETreeLeafVID",                      4,      678,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 60.43.5.20.4 L2VPN-I13 Annex B.3.20.4 */
{ 652,    "BGPAttribute",                      21,     615,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.5.21 L2VPN-I13 Annex B.3.21 */
{ 653,    "BGPVPNID",                          1,      652,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 60.43.5.21.1 L2VPN-I13 Annex B.3.21.1 */
{ 654,    "RouteDistinguisher",                2,      652,    (encode_hexstr),         (decode_hexstr),         8,           8             }, /* TLV 60.43.5.21.2 L2VPN-I13 Annex B.3.21.2 */
{ 655,    "RouteTargetImport",                 3,      652,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 60.43.5.21.3 L2VPN-I13 Annex B.3.21.3 */
{ 656,    "RouteTargetExport",                 4,      652,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 60.43.5.21.4 L2VPN-I13 Annex B.3.21.4 */
{ 657,    "CEIDVEID",                          5,      652,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 60.43.5.21.5 L2VPN-I13 Annex B.3.21.5 */
{ 683,    "PseudowireSignaling",               23,     615,    (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 60.43.5.23 L2VPN-I13 Annex B.3.23 */
{ 684,    "SOAMSubtype",                       24,     615,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.5.24 L2VPN-I13 Annex B.3.24 */
{ 685,    "MEPConfiguration",                  1,      684,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.5.24.1 L2VPN-I13 Annex B.3.24.1 */
{ 686,    "MDLevel",                           1,      685,    (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 60.43.5.24.1.1 L2VPN-I13 Annex B.3.24.1.1 */
{ 687,    "MDName",                            2,      685,    (encode_string),         (decode_string),         2,           16            }, /* TLV 60.43.5.24.1.2 L2VPN-I13 Annex B.3.24.1.2 */
{ 688,    "MAName",                            3,      685,    (encode_string),         (decode_string),         2,           28            }, /* TLV 60.43.5.24.1.3 L2VPN-I13 Annex B.3.24.1.3 */
{ 689,    "MEPID",                             4,      685,    (encode_ushort),         (decode_ushort),         1,           8191          }, /* TLV 60.43.5.24.1.4 L2VPN-I13 Annex B.3.24.1.4 */
{ 690,    "RemoteMEPConfiguration",            2,      684,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.5.24.2 L2VPN-I13 Annex B.3.24.2 */
{ 691,    "RemoteMDLevel",                     1,      690,    (encode_uchar),          (decode_uchar),          0,           7             }, /* TLV 60.43.5.24.2.1 L2VPN-I13 Annex B.3.24.2.1 */
{ 692,    "RemoteMDName",                      2,      690,    (encode_string),         (decode_string),         2,           16            }, /* TLV 60.43.5.24.2.2 L2VPN-I13 Annex B.3.24.2.2 */
{ 693,    "RemoteMAName",                      3,      690,    (encode_string),         (decode_string),         2,           28            }, /* TLV 60.43.5.24.2.3 L2VPN-I13 Annex B.3.24.2.3 */
{ 694,    "RemoteMEPID",                       4,      690,    (encode_ushort),         (decode_ushort),         1,           8191          }, /* TLV 60.43.5.24.2.4 L2VPN-I13 Annex B.3.24.2.4 */
{ 695,    "FaultManagementConfiguration",      3,      684,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.5.24.3 L2VPN-I13 Annex B.3.24.3 */
{ 696,    "ContinuityCheckMessages",           1,      695,    (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 60.43.5.24.3.1 L2VPN-I13 Annex B.3.24.3.1 */
{ 697,    "LoopbackFunction",                  2,      695,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 60.43.5.24.3.2 L2VPN-I13 Annex B.3.24.3.2 */
{ 698,    "LinktraceFunction",                 3,      695,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 60.43.5.24.3.3 L2VPN-I13 Annex B.3.24.3.3 */
{ 699,    "PerformanceManagementConfiguration", 4,     684,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.5.24.4 L2VPN-I13 Annex B.3.24.4 */
{ 700,    "FrameDelayMeasurement",             1,      699,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.5.24.4.1 L2VPN-I13 Annex B.3.24.4.1 */
{ 701,    "FrameDelayMeasurementEnable",       1,      700,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 60.43.5.24.4.1.1 L2VPN-I13 Annex B.3.24.4.1.1 */
{ 702,    "FrameDelayMeasurementOneWayTwoWay", 2,      700,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 60.43.5.24.4.1.2 L2VPN-I13 Annex B.3.24.4.1.2 */
{ 703,    "FrameDelayMeasurementTransmissionPeriodicity", 3, 700, (encode_ushort),      (decode_ushort),         0,           0             }, /* TLV 60.43.5.24.4.1.3 L2VPN-I13 Annex B.3.24.4.1.3 */
{ 704,    "FrameLossMeasurement",              2,      699,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.5.24.4.2 L2VPN-I13 Annex B.3.24.4.2 */
{ 705,    "FrameLossMeasurementEnable",        1,      704,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 60.43.5.24.4.2.1 L2VPN-I13 Annex B.3.24.4.2.1 */
{ 706,    "FrameLossMeasurementTransmissionPeriodicity", 2, 704, (encode_ushort),       (decode_ushort),         0,           0             }, /* TLV 60.43.5.24.4.2.2 L2VPN-I13 Annex B.3.24.4.2.2 */
{ 707,    "L2VPNDSID",                         26,     615,    (encode_uint24),         (decode_uint24),         1,           1048575       }, /* TLV 60.43.5.26 L2VPN-I13 Annex B.3.26 */
{ 708,    "VendorSpecificL2VPNSubtype",        43,     615,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.5.43 L2VPN-I13 Annex B.3.11 */
{ 709,    "VendorIdentifier",                  8,      708,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 60.43.5.43.8 L2VPN-I13 Annex B.3.11 */
{ 710,    "ExtendedCMTSMICConfigurationSetting", 6,    609,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.6 MULPIv3.0-I24 Annex C.1.1.18.1.6 */
{ 711,    "ExtendedCMTSMICHMACtype",           1,      710,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 60.43.6.1 MULPIv3.0-I24 Annex C.1.1.18.1.6.1 */
{ 712,    "ExtendedCMTSMICBitmap",             2,      710,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 60.43.6.2 MULPIv3.0-I24 Annex C.1.1.18.1.6.2 */
{ 713,    "ExplicitExtendedCMTSMICDigest",     3,      710,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 60.43.6.3 MULPIv3.0-I24 Annex C.1.1.18.1.6.3 */
{ 714,    "SAVAuthorizationEncoding",          7,      609,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.7 MULPIv3.0-I24 Annex C.1.1.18.1.7 */
{ 715,    "SAVGroupName",                      1,      714,    (encode_string),         (decode_string),         1,           15            }, /* TLV 60.43.7.1 MULPIv3.0-I24 Annex C.1.1.18.1.7.1 */
{ 716,    "SAVStaticPrefixRule",               2,      714,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.7.2 MULPIv3.0-I24 Annex C.1.1.18.1.7.2 */
{ 717,    "SAVStaticPrefixAddress",            1,      716,    (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 60.43.7.2.1 MULPIv3.0-I24 Annex C.1.1.18.1.7.2.1 */
{ 718,    "SAVStaticPrefixLength",             2,      716,    (encode_uchar),          (decode_uchar),          0,           0             }, /* TLV 60.43.7.2.2 MULPIv3.0-I24 Annex C.1.1.18.1.7.2.2 */
{ 719,    "VendorIdentifier",                  8,      609,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 60.43.8 MULPIv3.0-I24 Annex C.2.1.11 */
{ 720,    "CMAttributeMasks",                  9,      609,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.9 MULPIv3.0-I24 Annex C.1.1.18.1.8 */
{ 721,    "CMDownstreamRequiredAttributeMask", 1,      720,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 60.43.9.1 MULPIv3.0-I24 Annex C.1.1.18.1.8.1 */
{ 722,    "CMDownstreamForbiddenAttributeMask", 2,     720,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 60.43.9.2 MULPIv3.0-I24 Annex C.1.1.18.1.8.2 */
{ 723,    "CMUpstreamRequiredAttributeMask",   3,      720,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 60.43.9.3 MULPIv3.0-I24 Annex C.1.1.18.1.8.3 */
{ 724,    "CMUpstreamForbiddenAttributeMask",  4,      720,    (encode_hexstr),         (decode_hexstr),         4,           4             }, /* TLV 60.43.9.4 MULPIv3.0-I24 Annex C.1.1.18.1.8.4 */
{ 725,    "IPMulticastJoinAuthorization",      10,     609,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.10 MULPIv3.0-I24 Annex C.1.1.18.1.9 */
{ 726,    "IPMulticastProfileName",            1,      725,    (encode_string),         (decode_string),         1,           15            }, /* TLV 60.43.10.1 MULPIv3.0-I24 Annex C.1.1.18.1.9.1 */
{ 727,    "IPMulticastJoinAuthStaticSessionRule", 2,   725,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.10.2 MULPIv3.0-I24 Annex C.1.1.18.1.9.2 */
{ 728,    "MulticastRulePriority",             1,      727,    (encode_uchar),          (decode_uchar),          0,           255           }, /* TLV 60.43.10.2.1 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.1 */
{ 729,    "AuthorizationAction",               2,      727,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 60.43.10.2.2 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.2 */
{ 730,    "SourcePrefixAddress",               3,      727,    (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 60.43.10.2.3 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.3 */
{ 731,    "SourcePrefixLength",                4,      727,    (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 60.43.10.2.4 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.4 */
{ 732,    "GroupPrefixAddress",                5,      727,    (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 60.43.10.2.5 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.5 */
{ 733,    "GroupPrefixLength",                 6,      727,    (encode_uchar),          (decode_uchar),          0,           128           }, /* TLV 60.43.10.2.6 MULPIv3.0-I24 Annex C.1.1.18.1.9.2.6 */
{ 734,    "MaximumMulticastSessions",          3,      725,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 60.43.10.3 MULPIv3.0-I24 Annex C.1.1.18.1.9.3 */
{ 735,    "ServiceTypeIdentifier",             11,     609,    (encode_string),         (decode_string),         1,           16            }, /* TLV 60.43.11 MULPIv3.0-I24 Annex C.1.1.18.1.10 */
{ 736,    "DEMARCAutoConfiguration",           12,     609,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 60.43.12 MULPIv3.0-I24 Annex C.1.1.18.1.11 */
{ 737,    "DACDisableEnableConfig",            1,      736,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 60.43.12.1 DEMARCv1.0-I04 Annex B.1 */
{ 738,    "CMIMEncoding",                      2,      736,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 60.43.12.2 DEMARCv1.0-I04 Annex B.2 */
{ 739,    "UpstreamServiceClassName",          3,      736,    (encode_strzero),        (decode_strzero),        2,           16            }, /* TLV 60.43.12.3 DEMARCv1.0-I04 Annex B.3 */
{ 740,    "DownstreamServiceClassName",        4,      736,    (encode_strzero),        (decode_strzero),        2,           16            }, /* TLV 60.43.12.4 DEMARCv1.0-I04 Annex B.4 */
{ 528,    "SubMgmtCPEIPv6PrefixList",          61,     0,      (encode_ip6_prefix_list), (decode_ip6_prefix_list), 0,         0             }, /* TLV 61 MULPIv3.0-I24 Annex C.1.1.19.3 */
{ 529,    "UpstreamDropClassifierGroupID",     62,     0,      (encode_char_list),      (decode_char_list),      0,           0             }, /* TLV 62 MULPIv3.0-I24 Annex C.1.1.26 */
{ 174,    "SubMgmtControl6",                   63,     0,      (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 63 MULPIv3.0-I24 Annex C.1.1.19.5 */
{ 341,    "CMTSStaticMulticastSessionEncodings",  64,  0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 64 MULPIv3.0-I24 Annex C.1.1.27 */
{ 342,    "CMTSStaticMulticastSessionGroup",   1,      341,    (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 64.1 MULPIv3.0-I24 Annex C.1.1.27.1 */
{ 343,    "CMTSStaticMulticastSessionSource",  2,      341,    (encode_ip_ip6),         (decode_ip_ip6),         0,           0             }, /* TLV 64.2 MULPIv3.0-I24 Annex C.1.1.27.2 */
{ 344,    "CMTSStaticMulticastSessionCMIM",    3,      341,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 64.3 MULPIv3.0-I24 Annex C.1.1.27.3 */
{ 526,    "L2VPNMACAgingEncoding",             65,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 65 L2VPN-I13 Annex B.7 */
{ 527,    "L2VPNMACAgingMode",                 1,      526,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 65.1 L2VPN-I13 Annex B.7.1 */
{ 525,    "ManagementEventControl",            66,     0,      (encode_uint),           (decode_uint),           0,           0             }, /* TLV 66 MULPIv3.0-I24 Annex C.1.2.16 */
{ 478,    "SubscriberManagementCPEIPv6Table",  67,     0,      (encode_ip6_list),       (decode_ip6_list),       0,           0             }, /* TLV 67 MULPIv3.0-I24 Annex C.1.1.19.6 */
{ 513,    "DefaultUpstreamTargetBuffer",       68,     0,      (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 68 MULPIv3.0-I24 Annex C.1.2.17 */
{ 514,    "MACAddressLearningControlEncoding", 69,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 69 MULPIv3.0-I24 Annex C.1.2.18 */
{ 515,    "MACAddressLearningControl",         1,      514,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 69.1 MULPIv3.0-I24 Annex C.1.2.18.1 */
{ 516,    "MACAddressLearningHoldoffTimer",    2,      514,    (encode_uchar),          (decode_uchar),          0,           10            }, /* TLV 69.2 MULPIv3.0-I24 Annex C.1.2.18.2 */
{ 517,    "UpstreamAggregateServiceFlow",      70,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 70 MULPIv3.0-I24 Annex C.2.2.3 */
{ 518,    "UpstreamServiceFlowReference",      1,      517,    (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 70.1 MULPIv3.0-I24 Annex C.2.2.5.1 */
{ 519,    "UpstreamAggregateServiceFlowReference", 36, 517,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 70.36 MULPIv3.0-I24 Annex C.2.2.5.10 */
{ 520,    "UpstreamMESPReference",             37,     517,    (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 70.37 MULPIv3.0-I24 Annex C.2.2.5.11 */
{ 521,    "DownstreamAggregateServiceFlow",    71,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 71 MULPIv3.0-I24 Annex C.2.2.3 */
{ 522,    "DownstreamServiceFlowReference",    1,      521,    (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 71.1 MULPIv3.0-I24 Annex C.2.2.5.1 */
{ 523,    "DownstreamAggregateServiceFlowReference", 36, 521,  (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 71.36 MULPIv3.0-I24 Annex C.2.2.5.10 */
{ 524,    "DownstreamMESPReference",           37,     521,    (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 71.37 MULPIv3.0-I24 Annex C.2.2.5.11 */
{ 498,    "MetroEthernetServiceProfile",       72,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 72 MULPIv3.0-I24 Annex C.2.2.10 */
{ 499,    "MESPReference",                     1,      498,    (encode_uchar),          (decode_uchar),          1,           255           }, /* TLV 72.1 MULPIv3.0-I24 Annex C.2.2.10.1 */
{ 500,    "MESPBandwidthProfile",              2,      498,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 72.2 MULPIv3.0-I24 Annex C.2.2.10.2 */
{ 501,    "CIR",                               1,      500,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 72.2.1 MULPIv3.0-I24 Annex C.2.2.10.2.1 */
{ 502,    "CBR",                               2,      500,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 72.2.2 MULPIv3.0-I24 Annex C.2.2.10.2.2 */
{ 503,    "EIR",                               3,      500,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 72.2.3 MULPIv3.0-I24 Annex C.2.2.10.2.3 */
{ 504,    "EBS",                               4,      500,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 72.2.4 MULPIv3.0-I24 Annex C.2.2.10.2.4 */
{ 505,    "CouplingFlag",                      5,      500,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 72.2.5 MULPIv3.0-I24 Annex C.2.2.10.2.5 */
{ 506,    "ColorMode",                         6,      500,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 72.2.6 MULPIv3.0-I24 Annex C.2.2.10.2.6 */
{ 507,    "ColorIdentificationField",          1,      506,    (encode_uchar),          (decode_uchar),          0,           9             }, /* TLV 72.2.6.1 MULPIv3.0-I24 Annex C.2.2.10.2.6.1 */
{ 508,    "ColorIdentificationFieldValue",     2,      506,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 72.2.6.2 MULPIv3.0-I24 Annex C.2.2.10.2.6.2 */
{ 509,    "ColorMarking",                      7,      500,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 72.2.7 MULPIv3.0-I24 Annex C.2.2.10.2.7 */
{ 510,    "ColorMarkingField",                 1,      509,    (encode_uchar),          (decode_uchar),          0,           5             }, /* TLV 72.2.7.1 MULPIv3.0-I24 Annex C.2.2.10.2.7.1 */
{ 511,    "ColorMarkingFieldValue",            2,      509,    (encode_hexstr),         (decode_hexstr),         1,           1             }, /* TLV 72.2.7.2 MULPIv3.0-I24 Annex C.2.2.10.2.7.2 */
{ 512,    "MESPName",                          3,      498,    (encode_strzero),        (decode_strzero),        2,           254           }, /* TLV 72.3 MULPIv3.0-I24 Annex C.2.2.10.3 */
{ 495,    "NetworkTimingProfile",              73,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 73 MULPIv3.0-I24 Annex C.1.2.19 */
{ 496,    "NetworkTimingProfileReference",     1,      495,    (encode_ushort),         (decode_ushort),         1,           65536         }, /* TLV 73.1 MULPIv3.0-I24 Annex C.1.2.19.1 */
{ 497,    "NetworkTimingProfileName",          2,      495,    (encode_strzero),        (decode_strzero),        2,           16            }, /* TLV 73.2 MULPIv3.0-I24 Annex C.1.2.19.2 */
{ 481,    "EnergyManagementParameter",         74,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 74 MULPIv3.0-I24 Annex C.1.1.30 */
{ 482,    "EnergyManagementFeatureControl",    1,      481,    (encode_uint),           (decode_uint),           0,           1             }, /* TLV 74.1 MULPIv3.0-I24 Annex C.1.1.30.1 */
{ 483,    "EnergyManagement1x1Mode",           2,      481,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 74.2 MULPIv3.0-I24 Annex C.1.1.30.2 */
{ 484,    "DownstreamActivityDetectionParameters", 1,  483,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 74.2.1 MULPIv3.0-I24 Annex C.1.1.30.2.1 */
{ 485,    "DownstreamEntryBitrateThreshold",   1,      484,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 74.2.1.1 MULPIv3.0-I24 Annex C.1.1.30.2.1.1 */
{ 486,    "DownstreamEntryTimeThreshold",      2,      484,    (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 74.2.1.2 MULPIv3.0-I24 Annex C.1.1.30.2.1.2 */
{ 487,    "DownstreamExitBitrateThreshold",    3,      484,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 74.2.1.3 MULPIv3.0-I24 Annex C.1.1.30.2.1.3 */
{ 488,    "DownstreamExitTimeThreshold",       4,      484,    (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 74.2.1.4 MULPIv3.0-I24 Annex C.1.1.30.2.1.4 */
{ 489,    "UpstreamActivityDetectionParameters", 2,    483,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 74.2.2 MULPIv3.0-I24 Annex C.1.1.30.2.2 */
{ 490,    "UpstreamEntryBitrateThreshold",     1,      489,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 74.2.2.1 MULPIv3.0-I24 Annex C.1.1.30.2.2.1 */
{ 491,    "UpstreamEntryTimeThreshold",        2,      489,    (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 74.2.2.2 MULPIv3.0-I24 Annex C.1.1.30.2.2.2 */
{ 492,    "UpstreamExitBitrateThreshold",      3,      489,    (encode_uint),           (decode_uint),           0,           0             }, /* TLV 74.2.2.3 MULPIv3.0-I24 Annex C.1.1.30.2.2.3 */
{ 493,    "UpstreamExitTimeThreshold",         4,      489,    (encode_ushort),         (decode_ushort),         1,           65535         }, /* TLV 74.2.2.4 MULPIv3.0-I24 Annex C.1.1.30.2.2.4 */
{ 494,    "EnergyManagementCyclePeriod",       3,      481,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 74.2.3 MULPIv3.0-I24 Annex C.1.1.30.3 */
{ 479,    "EnergyManagement1x1ModeIndicator",  75,     0,      (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 75 MULPIv3.0-I24 Annex C.1.4.4 */
{ 480,    "CMUpstreamAQMDisable",              76,     0,      (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 76 MULPIv3.0-I24 Annex C.1.2.20 */
{ 130,    "UNIControlEncodings",               79,     0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 79 MULPIv3.0-I25 Annex C.3.3 */
{ 131,    "ContextCMIM",                       1,      130,    (encode_hexstr),         (decode_hexstr),         0,           0             }, /* TLV 79.1 MULPIv3.0-I25 Annex C.3.3.1 */
{ 188,    "UNIAdminStatus",                    2,      130,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 79.2 MULPIv3.0-I25 Annex C.3.3.2 */
{ 189,    "UNIAutoNegotiationStatus",          3,      130,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 79.3 MULPIv3.0-I25 Annex C.3.3.3 */
{ 190,    "UNIOperatingSpeed",                 4,      130,    (encode_uchar),          (decode_uchar),          0,           6             }, /* TLV 79.4 MULPIv3.0-I25 Annex C.3.3.4 */
{ 191,    "UNIDuplex",                         5,      130,    (encode_uchar),          (decode_uchar),          0,           2             }, /* TLV 79.5 MULPIv3.0-I25 Annex C.3.3.5 */
{ 345,    "EEEStatus",                         6,      130,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 79.6 MULPIv3.0-I25 Annex C.3.3.6 */
{ 346,    "MaximumFrameSize",                  7,      130,    (encode_ushort),         (decode_ushort),         0,           0             }, /* TLV 79.7 MULPIv3.0-I25 Annex C.3.3.7 */
{ 347,    "PowerOverEthernetStatus",           8,      130,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 79.8 MULPIv3.0-I25 Annex C.3.3.8 */
{ 348,    "MediaType",                         9,      130,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 79.9 MULPIv3.0-I25 Annex C.3.3.9 */

/* eRouter TLVs */
{ 175,    "eRouter",                           202,    0,      (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 202 eRouter-I12 */
{ 176,    "InitializationMode",                1,      175,    (encode_uchar),          (decode_uchar),          0,           3             }, /* TLV 202.1 eRouter-I12 Annex B.4.2 */
{ 177,    "TR69ManagementServer",              2,      175,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 202.2 eRouter-I12 Annex B.4.3 */
{ 178,    "EnableCWMP",                        1,      177,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 202.2.1 eRouter-I12 Annex B.4.3.1 */
{ 179,    "URL",                               2,      177,    (encode_string),         (decode_string),         0,           0             }, /* TLV 202.2.2 eRouter-I12 Annex B.4.3.2 */
{ 180,    "Username",                          3,      177,    (encode_string),         (decode_string),         0,           0             }, /* TLV 202.2.3 eRouter-I12 Annex B.4.3.3 */
{ 181,    "Password",                          4,      177,    (encode_string),         (decode_string),         0,           0             }, /* TLV 202.2.4 eRouter-I12 Annex B.4.3.4 */
{ 182,    "ConnectionRequestUsername",         5,      177,    (encode_string),         (decode_string),         0,           0             }, /* TLV 202.2.5 eRouter-I12 Annex B.4.3.5 */
{ 183,    "ConnectionRequestPassword",         6,      177,    (encode_string),         (decode_string),         0,           0             }, /* TLV 202.2.6 eRouter-I12 Annex B.4.3.6 */
{ 184,    "ACSOverride",                       7,      177,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 202.2.7 eRouter-I12 Annex B.4.3.7 */
{ 227,    "InitializationModeOverride",        3,      175,    (encode_uchar),          (decode_uchar),          0,           1             }, /* TLV 202.3 eRouter-I12 Annex B.4.4 */
{ 238,    "RATransmissionInterval",            10,     175,    (encode_ushort),         (decode_ushort),         3,           1800          }, /* TLV 202.10 eRouter-I12 Annex B.4.10 */
{ 239,    "SnmpMibObject",                     11,     175,    (encode_nothing),        (decode_snmp_object),    0,           0             }, /* TLV 202.11 eRouter-I12 Annex B.4.8 */
{ 239,    "TopologyModeEncoding",              42,     175,    (encode_uchar),          (decode_uchar),          1,           2             }, /* TLV 202.42 eRouter-I12 Annex B.4.9 */
{ 240,    "VendorSpecific",                    43,     175,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 202.43 eRouter-I12 Annex B.4.7 */
{ 241,    "VendorIdentifier",                  8,      240,    (encode_hexstr),         (decode_hexstr),         3,           3             }, /* TLV 202.43.8 eRouter-I12 Annex B.4.7.1 */
{ 228,    "SNMPv1v2cCoexistenceConfig",        53,     175,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 202.53 eRouter-I12 Annex B.4.5 */
{ 229,    "SNMPv1v2cCommunityName",            1,      228,    (encode_string),         (decode_string),         0,           0             }, /* TLV 202.53.1 eRouter-I12 Annex B.4.5.1 */
{ 230,    "SNMPv1v2cTransportAddressAccess",   2,      228,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 202.53.2 eRouter-I12 Annex B.4.5.2 */
{ 340,    "SNMPv1v2cTransportAddress",         1,      230,    (encode_ip_ip6_port),    (decode_ip_ip6_port),    0,           0             }, /* TLV 202.53.2.1 eRouter-I12 Annex B.4.5.2.1 */
{ 349,    "SNMPv1v2cTransportAddressMask",     2,      230,    (encode_ip_ip6_port),    (decode_ip_ip6_port),    0,           0             }, /* TLV 202.53.2.2 eRouter-I12 Annex B.4.5.2.2 */
{ 231,    "SNMPv1v2cAccessViewType",           3,      228,    (encode_uchar),          (decode_uchar),          1,           2             }, /* TLV 202.53.3 eRouter-I12 Annex B.4.5.3 */
{ 232,    "SNMPv1v2cAccessViewName",           4,      228,    (encode_string),         (decode_string),         0,           0             }, /* TLV 202.53.4 eRouter-I12 Annex B.4.5.4 */
{ 233,    "SNMPv3AccessViewConfiguration",     54,     175,    (encode_nothing),        (decode_aggregate),      0,           0             }, /* TLV 202.54 eRouter-I12 Annex B.4.6 */
{ 234,    "SNMPv3AccessViewName",              1,      233,    (encode_string),         (decode_string),         0,           0             }, /* TLV 202.54.1 eRouter-I12 Annex B.4.6.1 */
{ 235,    "SNMPv3AccessViewSubtree",           2,      233,    (encode_oid),            (decode_oid),            0,           0             }, /* TLV 202.54.2 eRouter-I12 Annex B.4.6.2 */
{ 236,    "SNMPv3AccessViewMask",              3,      233,    (encode_hexstr),         (decode_hexstr),         2,           2             }, /* TLV 202.54.3 eRouter-I12 Annex B.4.6.3 */
{ 237,    "SNMPv3AccessViewType",              4,      233,    (encode_uchar),          (decode_uchar),          1,           2             }, /* TLV 202.54.4 eRouter-I12 Annex B.4.6.4 */

/* A little more organized -> Start with 1419 */

/* Generic TLV ... we only use the limits, code and length don't matter ...*/
{ 998,    "GenericTLV",                        0,      0,      (encode_nothing),        (decode_special),        0,           0             },
/* PacketCable MTA Configuration File Delimiter  */
{ 157,    "MtaConfigDelimiter",                254,    0,      (encode_uchar),          (decode_uchar),          1,           255           }, /* TLV 254 PKT-SP-PROV1.5-I04 Chapter 9.1 */
{ 999,    "/*EndOfDataMkr*/",                  255,    0,      (encode_nothing),        (decode_special),        0,           0             }  /* TLV 255 MULPIv3.0-I24 Annex C.1.2.1 */
};

#endif /* _DOCSIS_SYMTABLE_H */
