<!--[metadata]>
+++
draft = true
title = "Machine plugins"
description = "Machine plugins"
keywords = ["Docker, documentation, manual, guide, reference, api"]
+++
<![end-metadata]-->

# Available driver plugins

This document is intended to act as a reference for the available 3rd-party
driver plugins available in the ecosystem beyond the core Machine drivers.  If
you have created a Docker Machine driver, we highly encourage you to submit a
pull request adding the relevant information to the list.  Submitting your
driver here will allow others to discover it and the core Machine team to keep
you informed of upstream changes.

**NOTE**: The linked repositories are not maintained by or formally associated
with Docker Inc.  Use 3rd party plugins at your own risk.

| Name                   | Repository                                                          | Maintainer GitHub Handle                                                                           | Maintainer Email                                             |
| ---------------------- | ------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------- | ------------------------------------------------------------ |
| Amazon Cloud Formation | <https://github.com/jeffellin/machine-cloudformation>               | [Jeff Ellin](https://github.com/jeffellin)                                                         | acf@ellin.com                                                |
| BrightBox              | <https://github.com/brightbox/docker-machine-driver-brightbox>      | [NeilW](https://github.com/NeilW)                                                                  | neil@aldur.co.uk                                             |
| CenturyLink Cloud      | <https://github.com/CenturyLinkCloud/docker-machine-driver-clc>     | [ack](https://github.com/ack)                                                                      | albert.choi@ctl.io                                           |
| Docker-In-Docker       | <https://github.com/nathanleclaire/docker-machine-driver-dind>      | [nathanleclaire](https://github.com/nathanleclaire)                                                | nathan.leclaire@gmail.com                                    |
| HPE OneView            | <https://github.com/HewlettPackard/docker-machine-oneview>          | [wenlock](https://github.com/wenlock)<br>[miqui](https://github.com/miqui)                                                              | wenlock@hpe.com<br>miqui@hpe.com                                              |
| OpenNebula             | <https://github.com/OpenNebula/docker-machine-opennebula>           | [jmelis](https://github.com/jmelis)                                                                | jmelis@opennebula.org                                        |
| OVH Cloud              | <https://github.com/yadutaf/docker-machine-driver-ovh>              | [yadutaf](https://github.com/yadutaf)                                                              | jt@yadutaf.fr                                                |
| Packet                 | <https://github.com/packethost/docker-machine-driver-packet>        | [betawaffle](https://github.com/betawaffle)                                                        | andy@packet.net                                              |
| Parallels for OSX      | <https://github.com/Parallels/docker-machine-parallels>             | [legal90](https://github.com/legal90)                                                              | legal90@gmail.com                                            |
| SAKURA CLOUD           | <https://github.com/yamamoto-febc/docker-machine-sakuracloud>       | [yamamoto-febc](https://github.com/yamamoto-febc)                                                  | yamamoto.febc@gmail.com                                      |
| Ubiquity Hosting       | <https://github.com/ubiquityhosting/docker-machine-driver-ubiquity> | [Justin Canington](https://github.com/justacan)<br>[Andrew Ayers](https://github.com/andrew-ayers) | justin.canington@nobistech.net<br>andrew.ayers@nobistech.net |
| UCloud                 | <https://github.com/ucloud/docker-machine-ucloud>                   | [xiaohui](https://github.com/xiaohui)                                                              | xiaohui.zju@gmail.com                                        |
| VMWare Workstation     | <https://github.com/pecigonzalo/docker-machine-vmwareworkstation>   | [pecigonzalo](https://github.com/pecigonzalo)                                                      | pecigonzalo@outlook.com                                      |
| VULTR                  | <https://github.com/janeczku/docker-machine-vultr>                  | [janeczku](https://github.com/janeczku)                                                            | jb@festplatte.eu.org                                         |
| xhyve                  | <https://github.com/zchee/docker-machine-driver-xhyve>              | [zchee](https://github.com/zchee)                                                                  | zchee.io@gmail.com                                           |
| KVM                    | <https://github.com/dhiltgen/docker-machine-kvm>                    | [dhiltgen](https://github.com/dhiltgen)                                                            | daniel.hiltgen@docker.com                                    |
| Aliyun  ECS            | <https://github.com/denverdino/docker-machine-driver-aliyunecs>     | [denverdino](https://github.com/denverdino)<br/>[menglingwei](https://github.com/menglingwei)                                                                                                       | denverdino@gmail.com<br/>v.con@qq.com                        |
