Ddoc

$(D_S D Change Log,

$(UPCOMING
	$(LI Shared libraries for Linux)
)

$(VERSION 075, Aug 2, 2012, =================================================,

    $(WHATSNEW
	$(LI $(BUGZILLA 8127): dmd link library paths not given precedence over gcc defaults)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 1175): nested class inheritance)
	$(LI $(BUGZILLA 1780): Type tuple deduction failure for class templates)
	$(LI $(BUGZILLA 2328): setTypeInfo in gc.d backwards.)
	$(LI $(BUGZILLA 2472): Delegates are not lvalue.)
	$(LI $(BUGZILLA 2962): ICE(glue.c) or bad codegen passing variable as template value parameter)
	$(LI $(BUGZILLA 3574): post-condition in void main() is not evaluated if there is no return statement)
	$(LI $(BUGZILLA 3608): Allow isExpression and templates to capture template parameters and FQN of template)
	$(LI $(BUGZILLA 4024): Last catch only accepts block statement)
	$(LI $(BUGZILLA 4155): return of NaN to temporary fails equality test)
	$(LI $(BUGZILLA 4288): Error on passing delegate to C linkage function)
	$(LI $(BUGZILLA 4364): ICE(class.c) compiling a struct def named 'Object' followed by a class definition)
	$(LI $(BUGZILLA 4583): PIC code not working: EBX register set incorrectly)
	$(LI $(BUGZILLA 4785): auto return of a function with in contract)
	$(LI $(BUGZILLA 4967): member default initializers not working in static struct initializers)
	$(LI $(BUGZILLA 5039): Cannot use invariant() with auto methods)
	$(LI $(BUGZILLA 5809): [64 bit] wrong code for *p==0, when widening conversion occurs)
	$(LI $(BUGZILLA 6189): [64bit] optimizer: register content destroyed in function prolog)
	$(LI $(BUGZILLA 6475): template identifier is not a member of alias)
	$(LI $(BUGZILLA 6591): di header generation loses selective import symbols)
	$(LI $(BUGZILLA 6612): Associative arrays with associative array keys literals)
	$(LI $(BUGZILLA 6758): std.c.stdarg problems with 8 or more integer arguments on x86_64)
	$(LI $(BUGZILLA 6891): template with uint value parameter causes several issues)
	$(LI $(BUGZILLA 7396): Indicate default alignment with 0.)
	$(LI $(BUGZILLA 7453): Can't return value from within opApply)
	$(LI $(BUGZILLA 7478): stack overflow compiling with -deps -release -inline -noboundscheck)
	$(LI $(BUGZILLA 7537): File.tmpfile requires administrator rights on Windows)
	$(LI $(BUGZILLA 7581): Compiler uses wrong instructions to move complex value from ST to xmm registers)
	$(LI $(BUGZILLA 7750): while(true) loop with try/catch block causes segfault)
	$(LI $(BUGZILLA 7770): __dollar cannot be read at compile time)
	$(LI $(BUGZILLA 7784): ICE with self-referencing literals)
	$(LI $(BUGZILLA 7793): static assert( void_function() ) gives misleading error message)
	$(LI $(BUGZILLA 7851): Internal error: e2ir.c 688)
	$(LI $(BUGZILLA 7880): [CTFE] cast from void array allowed with different results than at runtime)
	$(LI $(BUGZILLA 7893): Spec completely wrong for D variadic arguments on 64 bits)
	$(LI $(BUGZILLA 7894): [CTFE] - goto within ForStatement restarts loop)
	$(LI $(BUGZILLA 7907): [ICE] invalid expression on template argument crashes dmd)
	$(LI $(BUGZILLA 7911): Nested static if failing to execute)
	$(LI $(BUGZILLA 7931): Error message with _error_ with var[1,2])
	$(LI $(BUGZILLA 7932): Corrupted argument inside out contract in x86_64)
	$(LI $(BUGZILLA 7933): Illegal interaction of templates)
	$(LI $(BUGZILLA 7950): Type tuples are incorrectly flattened in base type list of interface)
	$(LI $(BUGZILLA 7974): forward reference of mixin declaration)
	$(LI $(BUGZILLA 7987): [CTFE] cannot compare arrays of slices)
	$(LI $(BUGZILLA 8002): Excess initial errors when passing template args to non-templated struct)
	$(LI $(BUGZILLA 8016): Methods defined in external object files when template alias parameter is involved)
	$(LI $(BUGZILLA 8032): `mixin template` before virtual method with same method causes an error)
	$(LI $(BUGZILLA 8060): xmmstore cannot allocate store for optimized operation that uses int and floats)
	$(LI $(BUGZILLA 8066): ICE on missing return statement if invariant is present)
	$(LI $(BUGZILLA 8069): incorrect ambiguous virtual function error)
	$(LI $(BUGZILLA 8073): Regression (git) Error: undefined identifier __result)
	$(LI $(BUGZILLA 8089): Importing package as module causes segfault)
	$(LI $(BUGZILLA 8091): Optimizer generates wrong code when reducing comparisons)
	$(LI $(BUGZILLA 8094): Static if matching using alias parameter in template fails)
	$(LI $(BUGZILLA 8095): [64 bit] Wrong code generation with spilled register, -m64 -O)
	$(LI $(BUGZILLA 8125): TypeInstance dedunction problem)
	$(LI $(BUGZILLA 8147): Blah!R.init now requires parens - (Blah!R).init)
	$(LI $(BUGZILLA 8188): need this to access member when mixining in a function)
	$(LI $(BUGZILLA 8190): Externally defined struct error message)
	$(LI $(BUGZILLA 8199): stack is not aligned in finally block)
	$(LI $(BUGZILLA 8216): CTFE should allow 'pointer is inside range' comparisons)
	$(LI $(BUGZILLA 8237): Error message with _error_ when using failed type inference in template parameter)
	$(LI $(BUGZILLA 8276): [CTFE] ICE when reading variable from nested function)
	$(LI $(BUGZILLA 8283): ICE(cod1.c): returning struct with constructor as member of another struct)
	$(LI $(BUGZILLA 8423): Wrong code for bool parameter in 5th integer register.)
	$(LI $(BUGZILLA 8437): [2.060 beta] static struct no size yet for forward reference)
	$(LI $(BUGZILLA 8454): [ICE] (backend\cg87.c 3497) with cdouble and sqrt)
    )
)

<div class="version">
$(UL 
	$(NEW1 075)
	$(NEW1 074)
	$(NEW1 073)
	$(NEW1 072)
	$(NEW1 071)
	$(NEW1 070)
	$(NEW1 069)
	$(NEW1 068)
	$(NEW1 067)
	$(NEW1 066)
	$(NEW1 065)
	$(NEW1 064)
	$(NEW1 063)
	$(NEW1 062)
	$(NEW1 061)
	$(NEW1 060)
	$(NEW1 059)
	$(NEW1 058)
	$(NEW1 057)
	$(NEW1 056)
	$(NEW1 055)
	$(NEW1 054)
	$(NEW1 053)
	$(NEW1 052)
	$(NEW1 051)
	$(NEW1 050)
	$(NEW1 049)
	$(NEW1 048)
	$(NEW1 047)
	$(NEW1 046)
	$(NEW1 045)
	$(NEW1 044)
	$(NEW1 043)
	$(NEW1 042)
	$(NEW1 041)
	$(NEW1 040)
	$(NEW1 039)
	$(NEW1 038)
	$(NEW1 037)
	$(NEW1 036)
	$(NEW1 035)
	$(NEW1 034)
	$(NEW1 033)
	$(NEW1 032)
	$(NEW1 031)
	$(NEW1 030)
	$(NEW1 029)
	$(NEW1 028)
	$(NEW1 027)
	$(NEW1 026)
	$(NEW1 025)
	$(NEW1 024)
	$(NEW1 023)
	$(NEW1 022)
	$(NEW1 021)
	$(NEW1 020)
	$(NEW1 019)
	$(NEW1 018)
	$(NEW1 017)
	$(NEW1 016)
	$(NEW1 015)
	$(NEW1 014)
	$(NEW1 013)
	$(NEW1 012)
	$(NEW1 011)
	$(NEW1 010)
	$(NEW1 009)
	$(NEW1 007)
	$(NEW1 006)
	$(NEW1 005)
	$(NEW1 004)
	$(NEW1 003)
	$(NEW1 002)
	$(NEW1 001)

	$(LI $(LINK2 http://www.digitalmars.com/d/changelog.html, change log for D 2.0))
	$(LI $(LINK2 changelog2.html, older versions))
	$(LI $(LINK2 changelog1.html, even older versions))

	$(LI Download latest stable (1.030)
	 <a HREF="http://ftp.digitalmars.com/dmd.1.030.zip" title="download D compiler">
	 D compiler</a> for Win32 and x86 linux)

	$(LI $(LINK2 http://www.digitalmars.com/pnews/index.php?category=2, tech support))
$(COMMENT
	$(LI $(LINK2 http://www.digitalmars.com/drn-bin/wwwnews?newsgroups=*, tech support))
)
)
</div>

$(VERSION 074, Apr 12, 2012, =================================================,

    $(WHATSNEW
	$(LI Add predefined Ddoc macro SRCFILENAME)
	$(LI Added std.c.stdint)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 176): [module] message "module and package have the same name")
	$(LI $(BUGZILLA 783): Cannot use an array w/ const or variable index as new[] size argument.)
	$(LI $(BUGZILLA 977): Expressions inside a struct or array initializer get wrong line number)
	$(LI $(BUGZILLA 3354): invalid number of args accepted for 1/2 arg floating point instructions)
	$(LI $(BUGZILLA 3509): Cannot forward reference a template mixin's members in a compile-time context)
	$(LI $(BUGZILLA 3510): Cannot forward reference a templated type from within a template mixin)
	$(LI $(BUGZILLA 3559): DMD 1.048+ fails to take function pointer from overloaded member functions)
	$(LI $(BUGZILLA 3630): bad error location in "has no effect in expression" error)
	$(LI $(BUGZILLA 3682): Regression(2.038) is expression fails to match types)
	$(LI $(BUGZILLA 3812): Missing line number for implicit cast of variadic function to array)
	$(LI $(BUGZILLA 3822): Invalid optimization of alloca called with constant size)
	$(LI $(BUGZILLA 4241): duplicate union initialization error doesn't give a file location)
	$(LI $(BUGZILLA 4269): Regression(2.031): invalid type accepted if evaluated while errors are gagged)
	$(LI $(BUGZILLA 4820): Regression(1.058, 2.044) in DStress caused by changeset 452)
	$(LI $(BUGZILLA 4993): Temporary values and opIndexAssign)
	$(LI $(BUGZILLA 5181): Excess cast on in-place operation op= involving conversion)
	$(LI $(BUGZILLA 5554): [qtd] Covariance detection failure)
	$(LI $(BUGZILLA 5879): Not all frontend errors use stderr)
	$(LI $(BUGZILLA 6391): Line-less error when passing the '.im' of floating pointer value by reference)
	$(LI $(BUGZILLA 6438): [CTFE] wrong error "value used before set" when slicing =void array)
	$(LI $(BUGZILLA 6699): More cases of __error in error messages)
	$(LI $(BUGZILLA 6681): struct constructor call is converted to struct literal that breaks union initialization)
	$(LI $(BUGZILLA 7380): Crash trying to use address of variable in struct constructor at module level)
	$(LI $(BUGZILLA 7399): Broken import statement in trySemantic() causes silent compiler error)
	$(LI $(BUGZILLA 7406): tuple foreach doesn't work with mixed tuples)
	$(LI $(BUGZILLA 7462): Error message with _error_ in overridden function)
	$(LI $(BUGZILLA 7463): Duplicated error message with bad template value parameter)
	$(LI $(BUGZILLA 7473): [CTFE] Non-ref argument behaves as if it's a ref argument)
	$(LI $(BUGZILLA 7493): Initialization of void[][N])
	$(LI $(BUGZILLA 7527): [CTFE] Segfault when slicing a pointer at compile time)
	$(LI $(BUGZILLA 7536): ctfeAdrOnStack triggered)
	$(LI $(BUGZILLA 7544): ICE(interpret.c) Catching an exception with a null catch block)
	$(LI $(BUGZILLA 7547): -deps output lists object as a top level module)
	$(LI $(BUGZILLA 7550): Missing AVX instruction VPMULDQ)
	$(LI $(BUGZILLA 7557): Sea of errors after template failure)
	$(LI $(BUGZILLA 7563): Class members with default template arguments have no type)
	$(LI $(BUGZILLA 7568): pragma(msg) segfaults with an aggregate including a class.)
	$(LI $(BUGZILLA 7592): Conversion from ireal to ifloat broken when using xmm)
	$(LI $(BUGZILLA 7633): Missing CTFE error message)
	$(LI $(BUGZILLA 7639): Undefined enum AA key crashes compiler)
	$(LI $(BUGZILLA 7641): std.typecons.Proxy incorrectly allows implicit conversion to class)
	$(LI $(BUGZILLA 7667): ICE(interpret.c): 'ctfeStack.stackPointer() == 0')
	$(LI $(BUGZILLA 7681): Regression(2.059head):ICE:opCatAssign(delegate) to undefined identifier)
	$(LI $(BUGZILLA 7694): Internal error: e2ir.c 1251 when calling member function inside struct via alias param)
	$(LI $(BUGZILLA 7699): Cannot get frame pointer to in contract when compiling with -inline)
	$(LI $(BUGZILLA 7735): Functions with variadic void[][]... arguments corrupt passed data)
	$(LI $(BUGZILLA 7745): Regression (1.x git-415e48a) Methods defined in external object files when a pointer to it is taken)
	$(LI $(BUGZILLA 7754): static this() in template is stripped during header gen)
	$(LI $(BUGZILLA 7755): regression(2.059head): ICE in glue.c)
	$(LI $(BUGZILLA 7768): More readable template error messages)
	$(LI $(BUGZILLA 7781): [CTFE] Segmentation fault on 'mixin({return;}());)
	$(LI $(BUGZILLA 7782): [ICE] With wrong import syntax)
	$(LI $(BUGZILLA 7785): [CTFE] ICE when slicing pointer to variable)
	$(LI $(BUGZILLA 7786): dmd crashes with invalid module name)
	$(LI $(BUGZILLA 7789):  [CTFE] null pointer exception on setting array length)
	$(LI $(BUGZILLA 7794): Sea of errors when calling regex() after compile error)
	$(LI $(BUGZILLA 7812): Segfault on invalid code during template match deduction with errors gagged)
	$(LI $(BUGZILLA 7814): Regression(2.059head) ICE(tocsym.c) using scope(failure) within foreach-range)
	$(LI $(BUGZILLA 7817): opAssign to in declaration broken in dmd 1.074 beta1)
    )
)

$(VERSION 073, Feb 8, 2012, =================================================,

    $(WHATSNEW
	$(LI Convert to -shared dmd switch instead of -dylib)
	$(LI Better use of XMM registers in OS X 32 bit target.)
	$(LI Add inline assembler support for AVX instructions (64 bit targets only).)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 516): Mutually calling constructors allowed)
	$(LI $(BUGZILLA 664): is(func T == function) ignores variadic arguments)
	$(LI $(BUGZILLA 678): Compiler accepts, for a function T[] t(), t().ptr but not t.ptr)
	$(LI $(BUGZILLA 796): Asserting a null object reference throws AssertError Failure internal\invariant.d(14) or Access Violation)
	$(LI $(BUGZILLA 949): Wrong spec/compiler behaviour for Strings, Integers and Floats)
	$(LI $(BUGZILLA 955): Passing arguments into functions - in, out, inout, const, and contracts)
	$(LI $(BUGZILLA 1313): out/body disables escape analysis)
	$(LI $(BUGZILLA 1521): Ambiguous documentation)
	$(LI $(BUGZILLA 1563): dynamic cast is not always performed)
	$(LI $(BUGZILLA 1570): Wrong return for address operator)
	$(LI $(BUGZILLA 1918): __traits(getVirtualFunctions) returns final functions)
	$(LI $(BUGZILLA 1920): Class documentation incomplete)
	$(LI $(BUGZILLA 1943): Templates can't take function pointer parameters)
	$(LI $(BUGZILLA 2106): export class doesn't affect, what is exported)
	$(LI $(BUGZILLA 2351): enum with no members allowed)
	$(LI $(BUGZILLA 2382): spec is not clear on what is allowed as global/static initializers)
	$(LI $(BUGZILLA 2387): Static array terminology)
	$(LI $(BUGZILLA 2417): [module] protected base member is not available via base handle in a derived class if it is defined in a separate module)
	$(LI $(BUGZILLA 2483): DMD allows assignment to a scope variable)
	$(LI $(BUGZILLA 2494): describe explicit casting of arrays)
	$(LI $(BUGZILLA 2495): const syntax for member functions needs better description)
	$(LI $(BUGZILLA 2497): delete and null relationship needs more details)
	$(LI $(BUGZILLA 2639): Hex and octal string values not completely specified)
	$(LI $(BUGZILLA 2819): array.sort segfaults if array length >=0x8F_FFFF)
	$(LI $(BUGZILLA 2894): abstract classes sometimes allow non-abstract bodyless functions)
	$(LI $(BUGZILLA 3084): Formatting of lazy in parameters section)
	$(LI $(BUGZILLA 3092): Indexing a tuple produces a tuple containing the indexed element)
	$(LI $(BUGZILLA 3111): 'mangleof' can't be member of a struct not documented)
	$(LI $(BUGZILLA 3187): Nested foreach over opApply doesn't work)
	$(LI $(BUGZILLA 3204): Document global properties)
	$(LI $(BUGZILLA 3265): .classinfo for Interface-typed reference does not return instance's ClassInfo)
	$(LI $(BUGZILLA 3492): Can't overload nested functions)
	$(LI $(BUGZILLA 3578): Impossible to run a struct invariant using assert(s))
	$(LI $(BUGZILLA 3735): op=)
	$(LI $(BUGZILLA 3757): Overloading const function with overridden non-const function results in seg fault.)
	$(LI $(BUGZILLA 3777): size_t is undefined)
	$(LI $(BUGZILLA 3783): Text inconsistent with EscapeSequence rules)
	$(LI $(BUGZILLA 3787): clarification: assigment to 'this')
	$(LI $(BUGZILLA 3791): Reference anonymous nested classes when describing new expressions)
	$(LI $(BUGZILLA 3838): PrimaryExpression rule doesn't permit module scope template instances)
	$(LI $(BUGZILLA 3886): Bad example of definition file for DLLs)
	$(LI $(BUGZILLA 3906): Undefined struct and union declarations are not documented)
	$(LI $(BUGZILLA 3954): DeclDef rule is missing TemplateMixinDeclaration)
	$(LI $(BUGZILLA 3988): Provide canonical example for operator overloading)
	$(LI $(BUGZILLA 4135): Regression(1.034): ICE(statement.c): mixin in bad foreach, D1 only)
	$(LI $(BUGZILLA 4180): D DWARF extensions conflict with DWARF-4)
	$(LI $(BUGZILLA 4235): !in not working (D1))
	$(LI $(BUGZILLA 4371): segfault(template.c) template tuple in is() expression)
	$(LI $(BUGZILLA 4413): typeof(this) doesn't work in method template signature)
	$(LI $(BUGZILLA 4523): [tdpl] .remove method for Associative Arrays returns void in all cases)
	$(LI $(BUGZILLA 4545): Alias to members possible without "this" instance)
	$(LI $(BUGZILLA 4647): [tdpl] Cannot explicitly call final interface method, ambiguous calls allowed)
	$(LI $(BUGZILLA 4711): Incorrect handling of && operator with void operand)
	$(LI $(BUGZILLA 4887): Right-shifting by 32 is allowed and broken)
	$(LI $(BUGZILLA 4956): remove direct references to gcc from linux.mak)
	$(LI $(BUGZILLA 5023): Docs about order of execution of invariant and pre/post conditions)
	$(LI $(BUGZILLA 5111): Static function-level variables are not in the language spec.)
	$(LI $(BUGZILLA 5114): Too many error messages)
	$(LI $(BUGZILLA 5132): ~ unary operator silently different from C)
	$(LI $(BUGZILLA 5138): Special token sequence)
	$(LI $(BUGZILLA 5337): Documentation regarding interfacing with C does not account for TLS differences)
	$(LI $(BUGZILLA 5476): spec: attributes have an optional else clause)
	$(LI $(BUGZILLA 5527): Bug in http://www.digitalmars.com/d/2.0/ctod.html#closures)
	$(LI $(BUGZILLA 5648): dmd command line option list inconsistencies)
	$(LI $(BUGZILLA 5715): Contradiction in spec: meaning of variable.init)
	$(LI $(BUGZILLA 5796): ICE with pragma(msg, ...) after missing ';' in a template)
	$(LI $(BUGZILLA 5820): Documentation states string literals can implicitly convert to char*)
	$(LI $(BUGZILLA 5841): alias grammar is incorrect)
	$(LI $(BUGZILLA 6013): private ignored for aliases)
	$(LI $(BUGZILLA 6037): [CTFE] recursive ref parameters evaluated incorrectly)
	$(LI $(BUGZILLA 6451): [64bit] ICE(expression.c:4434): SymbolExp::SymbolExp(Loc, TOK, int, Declaration*, int): Assertion 'var' failed)
	$(LI $(BUGZILLA 6504): Regression(2.041): "str" ~ [arr] allows string literal to be modified)
	$(LI $(BUGZILLA 6701): template specialization resolution failure)
	$(LI $(BUGZILLA 6933): Segfault(declaration.c) using struct with destructor in CTFE)
	$(LI $(BUGZILLA 6934): [CTFE] can't use $ in a slice of an array passed by ref)
	$(LI $(BUGZILLA 6964): Error message with __error: static assert(undefined+1))
	$(LI $(BUGZILLA 6968): Segmantation fault, if exclamation mark absent)
	$(LI $(BUGZILLA 6971): [lex.dd] Type of string literals are outdated)
	$(LI $(BUGZILLA 6984): CTFE generates a torrent of spurious errors, if there was a previous error)
	$(LI $(BUGZILLA 6985): [CTFE] Non-constant case expressions can't be interpreted)
	$(LI $(BUGZILLA 6995): [CTFE] can't interpret static template method)
	$(LI $(BUGZILLA 7011): No line number error for vector power)
	$(LI $(BUGZILLA 7043): CTFE: ICE illegal reference value 0LU, only with -inline)
	$(LI $(BUGZILLA 7073): Parsing of class-returning varargs function inside module ctor fails)
	$(LI $(BUGZILLA 7108): ICE: TraitsExp::semantic(Scope*) 2.056 -> 2.057 regression - segfault)
	$(LI $(BUGZILLA 7120): Scope Delegates + Delegate Literals)
	$(LI $(BUGZILLA 7123): static assert(is(typeof(toDelegate(&main)))) is false)
	$(LI $(BUGZILLA 7127): Const-related infinite recursion in DWARF generation)
	$(LI $(BUGZILLA 7143): [CTFE] cannot compare class references with "is")
	$(LI $(BUGZILLA 7144): [CTFE] base class does not call overridden members)
	$(LI $(BUGZILLA 7154): [CTFE] failing downcast causes error)
	$(LI $(BUGZILLA 7158): [CTFE] ICE(interpret.c) calling a class member using a dotvar expression)
	$(LI $(BUGZILLA 7162): [CTFE] "bool || void" expression crashes dmd)
	$(LI $(BUGZILLA 7165): [CTFE] ice converting null pointer to bool with constant member function)
	$(LI $(BUGZILLA 7166): Internal error: ../ztc/cgxmm.c 60)
	$(LI $(BUGZILLA 7173): dmd: glue.c:1065: virtual unsigned int Type::totym(): Assertion `0' failed.)
	$(LI $(BUGZILLA 7178): Segfault with import of invalid template)
	$(LI $(BUGZILLA 7185): [CTFE] ICE on changing char array length)
	$(LI $(BUGZILLA 7187): Regression(head 12d62ca5): [CTFE] ICE on slicing)
	$(LI $(BUGZILLA 7188): "import phobos;" crashes DMD)
	$(LI $(BUGZILLA 7189): inline failed)
	$(LI $(BUGZILLA 7190): Tuple length incorrect)
	$(LI $(BUGZILLA 7194): [CTFE] Incorrect behaviour with pointers as local struct variable)
	$(LI $(BUGZILLA 7197): enum string doesn't work with CTFE)
	$(LI $(BUGZILLA 7216): [CTFE] Can't call struct member function using pointer field)
	$(LI $(BUGZILLA 7217): [CTFE] ICE on accessing struct array field)
	$(LI $(BUGZILLA 7218): Nested function with contract is rejected)
	$(LI $(BUGZILLA 7228): MOVDQ2Q instruction is emitted with swapped register indices)
	$(LI $(BUGZILLA 7231): Segfault using opDispatch with property notation)
	$(LI $(BUGZILLA 7232): Warning: statement is not reachable has no line number)
	$(LI $(BUGZILLA 7239): C style struct initialization doesn't work with aliases)
	$(LI $(BUGZILLA 7245): [CTFE] Address of ref foreach parameter changes to point after array)
	$(LI $(BUGZILLA 7248): [CTFE] Stack overflow on using struct filed pointer with address of array element)
	$(LI $(BUGZILLA 7266): [CTFE] Assign to ref param (that's taken from struct member) is noop)
	$(LI $(BUGZILLA 7277): [CTFE ICE] Assertion failure: 'thisval' on line 1690 in file 'interpret.c')
	$(LI $(BUGZILLA 7285): Implicit fixed-size array cast)
	$(LI $(BUGZILLA 7309): [2.058] Regression caused by new inlining code)
	$(LI $(BUGZILLA 7335): sometimes the OUT - block have undefined class members-acces)
	$(LI $(BUGZILLA 7351): Possible asm bug: bad type/size of operands 'xadd')
	$(LI $(BUGZILLA 7359): Template function with typesafe variadic rejects more than one string arguments)
	$(LI $(BUGZILLA 7367): wrong char comparison result)
	$(LI $(BUGZILLA 7373): (Regression git) Renamed imports conflict with other implicitly imported symbols)
	$(LI $(BUGZILLA 7375): Regression(2.057): Invalid downcast permitted with derived/aliased template classes)
	$(LI $(BUGZILLA 7377): Compiler segfault in: TemplateMixin::hasPointers())
	$(LI $(BUGZILLA 7383): Blank lines in code sections cause premature section termination)
	$(LI $(BUGZILLA 7419): [2.058/CTFE] Constructor of struct is overwritten inside a unittest with -inline)
	$(LI $(BUGZILLA 7435): Regression(master):dmd crashes when 'scope(failure) debug ...' without -debug option.)
    )
)

$(VERSION 072, Dec 10, 2011, =================================================,

    $(WHATSNEW
	$(LI Better use of XMM registers in 64 bit targets.)
	$(LI Add Mach-O 64 bit support for obj2asm and dumpobj)
	$(LI Add OSX 64 bit target)
	$(LI classes, interfaces, and exceptions are supported in CTFE)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 2532): '=' does not give a boolean result)
	$(LI $(BUGZILLA 2856): static opIndex does not compile for a templated struct/class)
	$(LI $(BUGZILLA 3990): Deferencing a dynamic array as pointer)
	$(LI $(BUGZILLA 4047): [CTFE] class/struct heap allocation)
	$(LI $(BUGZILLA 4511): Contravariance problem)
	$(LI $(BUGZILLA 4583): PIC code not working: EBX register set incorrectly)
	$(LI $(BUGZILLA 5311): Pure is broken when accessing globals / static data through instance reference)
	$(LI $(BUGZILLA 5364): optimizer kills high dword of -1)
	$(LI $(BUGZILLA 6077): CTFE: Cannot append null array to null array.)
	$(LI $(BUGZILLA 6354): Optimizer bug on x86_64: Bitshift optimized out when foreach and scope(failure) are used)
	$(LI $(BUGZILLA 6416): [CTFE] Declaration static struct is not yet implemented in CTFE)
	$(LI $(BUGZILLA 6522): [CTFE] Problem with opAssign call in foreach(ref))
	$(LI $(BUGZILLA 6603): [CTFE] Can't call through a manifest constant function pointer)
	$(LI $(BUGZILLA 6792): [CTFE] ICE with pointer cast of indexed array)
	$(LI $(BUGZILLA 6800): [CTFE] dangerous pointer casts should be rejected)
	$(LI $(BUGZILLA 6816): [CTFE] nested function can't access this)
	$(LI $(BUGZILLA 6817): [CTFE] Error on interpreting inlined IfStatement)
	$(LI $(BUGZILLA 6851): [CTFE] Cannot deref pointer passed by argument)
	$(LI $(BUGZILLA 6859): Segfault when abstract method uses with contract.)
	$(LI $(BUGZILLA 6868): IsExp + incorrect static array type = error)
	$(LI $(BUGZILLA 6877): [XMM] regression, clobbered float value)
	$(LI $(BUGZILLA 6879): The difference of between template matching and IsExp)
	$(LI $(BUGZILLA 6881): [XMM] ICE with painted float)
	$(LI $(BUGZILLA 6885): [CTFE] wrong code with dynamically allocated 2D array)
	$(LI $(BUGZILLA 6886): [CTFE] ICE(interpret.c) new array with initializer)
	$(LI $(BUGZILLA 6901): wrong error "override cannot be applied to variable" in CTFE forward reference)
	$(LI $(BUGZILLA 6910): __traits(hasMember, "<name>") does not work, if template has alias param)
	$(LI $(BUGZILLA 6919): [CTFE] Cannot get effect to local variable through its pointer)
	$(LI $(BUGZILLA 6972): [CTFE] ICE with ubyte/=uint)
	$(LI $(BUGZILLA 6997): 64bit optimizer bug)
	$(LI $(BUGZILLA 7004): Iterating tuple with index which explicitly typed as size_t causes an error)
	$(LI $(BUGZILLA 7026): 64 bit optimizer bug)
	$(LI $(BUGZILLA 7028): Fails to save FPU regs when executing finally block)
    )
)

$(VERSION 071, Oct 26, 2011, =================================================,

    $(WHATSNEW
	$(LI add -gs compiler switch)
	$(LI $(BUGZILLA 6752): Add separate option to control stack frame generation)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 546): Error message for accessing a deprecated variable is doubled)
	$(LI $(BUGZILLA 1891): Array-concatenation of T* and T*[] produces corrupted result)
	$(LI $(BUGZILLA 1993): Error calling vararg delegate with null)
	$(LI $(BUGZILLA 2315): DMD Stack Overflow on unwanted ctfe recursion)
	$(LI $(BUGZILLA 2553): Excess attribute propagation for interfaces)
	$(LI $(BUGZILLA 2740): Template Mixins do not work as advertised)
	$(LI $(BUGZILLA 2953): tuple.length rejected as a tuple parameter in a static foreach)
	$(LI $(BUGZILLA 3069): Array literals do not implicitly cast to void[])
	$(LI $(BUGZILLA 3133): Compiler does not check that static array casts are legal)
	$(LI $(BUGZILLA 4022): [CTFE] AA get)
	$(LI $(BUGZILLA 4197): ICE(glue.c): error in forward-referenced in/out contract)
	$(LI $(BUGZILLA 4206): type accepted as enum initializer)
	$(LI $(BUGZILLA 4237): Typedefs of the same name cause initializer conflict)
	$(LI $(BUGZILLA 4269): Regression(2.031): invalid type accepted if evaluated while errors are gagged)
	$(LI $(BUGZILLA 4284): empty string[] alias lacks .length in a template)
	$(LI $(BUGZILLA 5453): ICE(statement.c): invalid switch statement forward referenced by CTFE)
	$(LI $(BUGZILLA 5696): Templates typetuple iteration)
	$(LI $(BUGZILLA 5932): Internal error: s2ir.c 339)
	$(LI $(BUGZILLA 6073): Cannot pass __traits(parent, ...) as a template parameter if it is a module)
	$(LI $(BUGZILLA 6084): Impossible to instantiate local template with TypeTuple-foreach iterator variable.)
	$(LI $(BUGZILLA 6087): typeof(this) doesn't work outside member function)
	$(LI $(BUGZILLA 6139): Duplicate error message on compile-time out of bounds array index)
	$(LI $(BUGZILLA 6296): ICE(glue.c): invalid template instantiated in is(typeof()).)
	$(LI $(BUGZILLA 6584): ICE on large version number/debug level)
	$(LI $(BUGZILLA 6599): Segfault: invalid expression in initializer)
	$(LI $(BUGZILLA 6661): Templates instantiated only through is(typeof()) shouldn't cause errors)
	$(LI $(BUGZILLA 6665): Regression(2.055) ICE(cg87.c): static double inside closure)
	$(LI $(BUGZILLA 6672): [CTFE] ICE on compile time std.algorithm.sort)
	$(LI $(BUGZILLA 6693): [CTFE] Cannot set value to nested AA)
	$(LI $(BUGZILLA 6695): typeof(this) does not take into account const/immutable attributes inside member functions)
	$(LI $(BUGZILLA 6721): [CTFE] Cannot get pointer to start of char[])
	$(LI $(BUGZILLA 6727): [CTFE] ICE(interpret.c): assignment from string literal.dup.ptr)
	$(LI $(BUGZILLA 6733): Regression(2.054) ICE(cod2.c) pure nothrow func with side-effect parameters)
	$(LI $(BUGZILLA 6739): [CTFE] Cannot set a value to an outer AA of a nested AA)
	$(LI $(BUGZILLA 6749): [CTFE] problem with array of structs)
	$(LI $(BUGZILLA 6751): [CTFE] ref argument of AA doesn't work)
	$(LI $(BUGZILLA 6765): [CTFE]: AA.length doesn't compile when AA is null)
	$(LI $(BUGZILLA 6769): [CTFE] AA.keys doesn't compile when -inline is used)
	$(LI $(BUGZILLA 6775): Regression(2.054) ICE(glue.c) template parameter deduction with errors gagged)
	$(LI $(BUGZILLA 6813): Yet another "cannot get frame pointer" error)
	$(LI $(BUGZILLA 6825): Regression(2.055+): Address of templated method incorrectly taken)
    )
)

$(VERSION 070, Sep 4, 2011, =================================================,

    $(WHATSNEW
	$(LI Add support for Mac OS X 10.7 Lion)
	$(LI Add protection to json output)
	$(LI Add SSE4.1 and SSE4.2 assembly instructions)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 1471): Linker error on template function. Error 42: Symbol Undefined ...)
	$(LI $(BUGZILLA 1567): call to private super-constructor should not be allowed)
	$(LI $(BUGZILLA 1684): offsetof does not work, adding cast is workaround)
	$(LI $(BUGZILLA 1904): wrong protection lookup for private template functions)
	$(LI $(BUGZILLA 2156): [] and null should be accepted where a compile-time string is required)
	$(LI $(BUGZILLA 2246): Regression(2.046, 1.061): Specialization of template to template containing int arguments fails)
	$(LI $(BUGZILLA 2355): is() doesn't resolve aliases before template matching)
	$(LI $(BUGZILLA 2634): Function literals are non-constant.)
	$(LI $(BUGZILLA 2774): Functions-as-properties makes it impossible to get the .mangleof a function)
	$(LI $(BUGZILLA 2941): Wrong code for inline asm because CPU type is set too late)
	$(LI $(BUGZILLA 3512): dchar iteration over string in CTFE fails)
	$(LI $(BUGZILLA 4021): [CTFE] AA rehash)
	$(LI $(BUGZILLA 4444): Cannot index built-in array with expression tuple)
	$(LI $(BUGZILLA 4460): Regression(2.036) ICE(e2ir.c) when compiling foreach over associative array literal)
	$(LI $(BUGZILLA 4682): [CTFE] Run-time Vs Compile-time of int.min % -1)
	$(LI $(BUGZILLA 4837): ICE(constfold.c) CTFE with >>>=)
	$(LI $(BUGZILLA 5046): Wrong type of implicit 'this' in struct/class templates)
	$(LI $(BUGZILLA 5239): optimizer misreports an used before set error)
	$(LI $(BUGZILLA 5585): bad debug line number info for return statements with enumerator expressions)
	$(LI $(BUGZILLA 5790): 'Error: variable result used before set' when -release -inline -O)
	$(LI $(BUGZILLA 5799): Address-of operator fails on nested conditional operator expression)
	$(LI $(BUGZILLA 5953): Too many trailing commas are accepted)
	$(LI $(BUGZILLA 6097): SSSE3 not working with MMX instructions)
	$(LI $(BUGZILLA 6215): LLVM-compiled DMD segfaults due to mem.c alignment issues)
	$(LI $(BUGZILLA 6250): [CTFE] Crash when swapping two pointers to arrays.)
	$(LI $(BUGZILLA 6270): XMMREGS not preserved on indirect function call)
	$(LI $(BUGZILLA 6276): [CTFE] Strange behavior of using ~= operator twice)
	$(LI $(BUGZILLA 6280): [CTFE] Cannot put 'in' expression of AA in an 'if' condition)
	$(LI $(BUGZILLA 6281): [CTFE] A null pointer '!is null' returns 'true'.)
	$(LI $(BUGZILLA 6282): [CTFE] ICE when dereferencing a pointer to reference type from 'in' of an AA)
	$(LI $(BUGZILLA 6283): [CTFE][Regression 2.054] Failed to assign to AA using a constness-changed array as key)
	$(LI $(BUGZILLA 6306): Regression(2.054): [CTFE] Strange behavior of indirect recursive call in CTFE)
	$(LI $(BUGZILLA 6331): [CTFE] Cannot evaluate SliceExp on if condition)
	$(LI $(BUGZILLA 6337): [CTFE] ICE when touching member variable of struct during CTFE)
	$(LI $(BUGZILLA 6344): [CTFE] Assertion Failure in interpret.c when create an empty slice from null pointer)
	$(LI $(BUGZILLA 6355): Template constructor cannot initialize non-mutable field)
	$(LI $(BUGZILLA 6374): [CTFE] Cannot subscript using pointer to array)
	$(LI $(BUGZILLA 6375): [CTFE] Segfault when using std.array.appender with an initial array)
	$(LI $(BUGZILLA 6386): [CTFE] ICE on pointer casting)
	$(LI $(BUGZILLA 6399): [CTFE] struct member array.length -= x doesn't work, while array[0..$-x] works)
	$(LI $(BUGZILLA 6418): [CTFE] Cannot call a struct member function with name 'length'.)
	$(LI $(BUGZILLA 6429): Nested function error in reduce)
	$(LI $(BUGZILLA 6491): Fully qualified values in default arguments of non-template functions are generated with an extra 'module' keyword)
	$(LI $(BUGZILLA 6505): Wrong code for expression involving 8 floats, only with -O)
	$(LI $(BUGZILLA 6512): [CTFE] new T[][] doesn't work)
	$(LI $(BUGZILLA 6516): Regression(2.055 beta) [CTFE] ICE(constfold.c) involving new dchar[])
	$(LI $(BUGZILLA 6558): [CTFE] UTF-decoding foreach gives wrong index (1-indexed))
	$(LI $(BUGZILLA 6563): wrong code when using at least 8 XMM regs)
	$(LI $(BUGZILLA 6601): Regression(2.053): CTFE segfault taking address of function template)
	$(LI $(BUGZILLA 6602): Invalid template instantiations leaked by is(typeof())/__traits(compiles, )/Type::trySemantic)
    )
)

$(VERSION 069, Jul 10, 2011, =================================================,

    $(WHATSNEW
	$(LI Allow labelled break and continue in CTFE)
	$(LI Pointers are now supported in CTFE)
	$(LI Heap-allocated structs are now supported in CTFE)
	$(LI Added SSSE3 instructions to inline assembler)
	$(LI Change win32 dmd to not emit a map file unless asked for with -map)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 693): 'this' can't be used as an alias parameter for a mixin)
	$(LI $(BUGZILLA 1373): typeof(func).stringof fails when func has parameters.)
	$(LI $(BUGZILLA 1570): Wrong return for address operator)
	$(LI $(BUGZILLA 2180): filename error with #line)
	$(LI $(BUGZILLA 2842): std.file.listdir on OSX produces invalid UTF-8 sequence)
	$(LI $(BUGZILLA 3445): partial fix)
	$(LI $(BUGZILLA 3722): A method without an in contract should always succeed, even if overridden)
	$(LI $(BUGZILLA 4063): [CTFE] key not found in AA gives bad error message)
	$(LI $(BUGZILLA 4065): [CTFE] AA "in" operator doesn't work)
	$(LI $(BUGZILLA 4107): Duplicate documentation for member function templates)
	$(LI $(BUGZILLA 4448): [CTFE] labeled break doesn't work in CTFE)
	$(LI $(BUGZILLA 4494): ICE(cod1.c) Array literal filled with results of void function)
	$(LI $(BUGZILLA 4633): typeof({return 1;}()) declaration fails if inside main)
	$(LI $(BUGZILLA 4745): Non-uniform handling of commas in static initialization of structs)
	$(LI $(BUGZILLA 4910): [CTFE] Cannot evaluate a function that has failed at once)
	$(LI $(BUGZILLA 4963): ICE(type.c:320) for struct append where T.sizeof < 3)
	$(LI $(BUGZILLA 4969): nothrow check can't handle multiple catches)
	$(LI $(BUGZILLA 5086): Regression(1.061): Stack overflow with recursive alias declaration)
	$(LI $(BUGZILLA 5258): [CTFE] Stack overflow with struct by ref)
	$(LI $(BUGZILLA 5396): [CTFE] Invalid code with nested functions in CTFE)
	$(LI $(BUGZILLA 5615): [CTFE] std.string.indexOf broken at compile time)
	$(LI $(BUGZILLA 5633): [CTFE] ICE(constfold.c): is expression with struct, struct pointer, array literal...)
	$(LI $(BUGZILLA 5676): [CTFE] segfault using tuple containing struct that has opAssign)
	$(LI $(BUGZILLA 5682): [CTFE] Silently wrong result possibly related to operator overloading and expression order)
	$(LI $(BUGZILLA 5682): Wrong CTFE with operator overloading)
	$(LI $(BUGZILLA 5708): [CTFE] Incorrect string constant folding with -inline)
	$(LI $(BUGZILLA 5845): Regression(2.041) [CTFE] "stack overflow" with recursive ref argument)
	$(LI $(BUGZILLA 5936): Invalid code with nested functions in CTFE)
	$(LI $(BUGZILLA 5946): failing lookup 'this' from function in template)
	$(LI $(BUGZILLA 5963): iasm does not accept 64bit integer literal)
	$(LI $(BUGZILLA 5885): wrong codegen for OPu32_d)
	$(LI $(BUGZILLA 6001): [CTFE] ICE(interpret.c) mutating ref array)
	$(LI $(BUGZILLA 6015): [CTFE] Strange behavior of assignment appears in a situation)
	$(LI $(BUGZILLA 6049): [CTFE] Array literals of structs with invariant() are wrong)
	$(LI $(BUGZILLA 6052): [CTFE] Struct elements in an array are treated like reference type)
	$(LI $(BUGZILLA 6053): [CTFE] Two ICEs involving pointers (dereference and assign; pointer variable on stack))
	$(LI $(BUGZILLA 6054): [CTFE] ICE when returning a returned compile-time associative array containing a key of an idup-ed array literal)
	$(LI $(BUGZILLA 6072): [CTFE] Regression(git master): Cannot declare variable inside an 'if' condition)
	$(LI $(BUGZILLA 6077): [CTFE] Cannot append null array to null array.)
	$(LI $(BUGZILLA 6078): [CTFE] ICE on foreach over array struct member which is null)
	$(LI $(BUGZILLA 6079): [CTFE] Array index out of bound detection is off-by-one)
	$(LI $(BUGZILLA 6090): DDoc parenthesis escape issues.)
	$(LI $(BUGZILLA 6100): [CTFE] Regression: struct return values wrong if used in array initializer)
	$(LI $(BUGZILLA 6120): [CTFE] ICE on calling constructor of template struct with -inline in function/delegate literal.)
	$(LI $(BUGZILLA 6123): [CTFE] Cannot call a template member method inside delegate/function literal with -inline.)
	$(LI $(BUGZILLA 6137): [CTFE] Foreach on semantically wrong initialized array crashes the compiler)
	$(LI $(BUGZILLA 6164): [CTFE] Local arrays in a recursive local function behave funny)
	$(LI $(BUGZILLA 6242): Disallow inoperant "in" contracts)
    )
)

$(VERSION 068, May 12, 2011, =================================================,

    $(WHATSNEW
	$(LI Added 64 bit tools to Linux)
	$(LI Renamed linux/bin to linux/bin32, added linux/bin64)
	$(LI $(BUGZILLA 4833): dmd -od doesn't make it to optlink's command line for map files)
	$(LI Added cmpxchg16b, 64 bit bswap and movq instructions to IASM)

    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 937): C-style variadic functions broken)
	$(LI $(BUGZILLA 1330): Array slicing does not work the same way in CTFE as at runtime)
	$(LI $(BUGZILLA 1389): Can't use mixin expressions when start of a statement.)
	$(LI $(BUGZILLA 2436): Unexpected OPTLINK termination EIP = 00425303 with /co)
	$(LI $(BUGZILLA 2990): TypeInfo.init() returns invalid array)
	$(LI $(BUGZILLA 3214): Incorrect DWARF line number debugging information on Linux)
	$(LI $(BUGZILLA 3372): optlink silently mistreats object files with more than 16384 symbols)
	$(LI $(BUGZILLA 3779): ["123"][0][$-1] causes __dollar unresolved in compile-time.)
	$(LI $(BUGZILLA 3792): Regression(1.053) "non-constant expression" for a template inside)
	$(LI $(BUGZILLA 3801): CTFE: this.arr[i] cannot be evaluated at compile time for structs)
	$(LI $(BUGZILLA 3809): Struct initializers apparently always CTFE'd)
	$(LI $(BUGZILLA 3835): ref foreach does not work in CTFE)
	$(LI $(BUGZILLA 4001): const variables should be readable inside CTFE)
	$(LI $(BUGZILLA 4048): [CTFE] struct initializer: missing line number in error message)
	$(LI $(BUGZILLA 4050): [CTFE] array struct member slice update)
	$(LI $(BUGZILLA 4051): [CTFE] array struct member item update)
	$(LI $(BUGZILLA 4140): Error: non-constant expression "hello"[1u..__dollar])
	$(LI $(BUGZILLA 4275): Unexpected optlink termination when 'export' attribute is missing)
	$(LI $(BUGZILLA 4543): Regression(1.054, 2.038) typedef circular definition and segfault)
	$(LI $(BUGZILLA 4815): CodeView: Global and Static symbols should have unmangled names)
	$(LI $(BUGZILLA 4817): CodeView: Enum members should have simple names)
	$(LI $(BUGZILLA 4917): Symbol conflict error message refers to aliased symbol instead of the alias)
	$(LI $(BUGZILLA 5147): [CTFE] Return fixed-sized matrix)
	$(LI $(BUGZILLA 5362): checking $ in bracket is broken.)
	$(LI $(BUGZILLA 5647): [64-bit] Valgrind complains about illegal instruction)
	$(LI $(BUGZILLA 5664): Cannot compile static synchronized member function.)
	$(LI $(BUGZILLA 5670): Optlink 8.00.11 crash)
	$(LI $(BUGZILLA 5671): Issue 5671 - CTFE string concat problem)
	$(LI $(BUGZILLA 5672): ICE(cod2.c): incorrect optimization of (long &1) == 1)
	$(LI $(BUGZILLA 5680): wrong calling convention on wsprintfA/W)
	$(LI $(BUGZILLA 5694): va_arg doesn't work with idouble and ifloat)
	$(LI $(BUGZILLA 5706): Incorrect opcode prefix generated for x86_64 inline assembly)
	$(LI $(BUGZILLA 5708): Incorrect string constant folding with -inline)
	$(LI $(BUGZILLA 5717): 1.067 regression: appending Unicode char to string broken)
	$(LI $(BUGZILLA 5722): Regression(2.052): Appending code-unit from multi-unit code-point at compile-time gives wrong result.)
	$(LI $(BUGZILLA 5735): non-scalar types implicitly converted to boolean.)
	$(LI $(BUGZILLA 5740): Unable to use "this" pointer in inline assembly)
	$(LI $(BUGZILLA 5741): Add the SYSCALL and SYSRET opcodes to the inline assembler)
	$(LI $(BUGZILLA 5840): Cannot assign to an array member of struct in CTFE)
	$(LI $(BUGZILLA 5852): CTFE: wrong code for string[] ~= const(string))
	$(LI $(BUGZILLA 5858): Import not acctept const string as arguments)
	$(LI $(BUGZILLA 5865): __dollar cannot be read at compile time)
	$(LI $(BUGZILLA 5916): DMD: bad message for incorrect operands error)
	$(LI $(BUGZILLA 5966): [2.053 beta][CTFE] Stack overflow on trivial func)
	$(LI $(BUGZILLA 5972): CTFE: Can't assign to elements of arrays of slices)
	$(LI $(BUGZILLA 5975): [2.053 beta][CTFE] ICE: 'global.errors' on line 1416 in file 'constfold.c')
	$(LI $(BUGZILLA 5976): "variable used before set" with foreach with ref + scope(failure) + structure method + -O -inline)
	$(LI Fix spelling of $(CODE cmpxchgb8))
    )
)

$(VERSION 067, Feb 17, 2011, =================================================,

    $(WHATSNEW
	$(LI 64 bit support for Linux)
	$(LI Support HTML5 entities)
	$(LI FreeBSD version upgraded to FreeBSD 8.1)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 190): Cannot forward reference typedef/alias in default value for function parameter)
	$(LI $(BUGZILLA 1914): Array initialisation from const array yields memory trample)
	$(LI $(BUGZILLA 3198): wrong initializer for structs arrays)
	$(LI $(BUGZILLA 3681): ICE(go.c): when function takes too long to optimize, only with -O.)
	$(LI $(BUGZILLA 4245): Declaring conflicting symbols in single function scope allowed)
	$(LI $(BUGZILLA 4379): ICE(blockopt.c): foreach over huge tuple, only with -O)
	$(LI $(BUGZILLA 4389): ICE(constfold.c, expression.c), or wrong code: string~=dchar in CTFE)
	$(LI $(BUGZILLA 4486): CodeView debug info should contain absolute path names)
	$(LI $(BUGZILLA 4753): fail_compilation/fail116.d sends dmd into a loop, exhausting memory)
	$(LI $(BUGZILLA 4878): Ddoc: Default arguments can break Ddoc output)
	$(LI $(BUGZILLA 4973): map file with spaces in file name passed without quotes to linker)
	$(LI $(BUGZILLA 5015): Regression(1.061): Cyclic import breaks is() in a static if)
	$(LI $(BUGZILLA 5090): ICE(todt.c) struct literal initializing zero length array)
	$(LI $(BUGZILLA 5105): Member function template cannot be synchronized)
	$(LI $(BUGZILLA 5221): entity.c: Merge Walter's list with Thomas')
	$(LI $(BUGZILLA 5241): dmd: ABI breakage/regression (TypeInfo.toString() returns partially corrupted string))
	$(LI $(BUGZILLA 5242): self referencing template constraint crashes compiler)
	$(LI $(BUGZILLA 5244): PATCH: fix use of uninitialised variable in toObj.c)
	$(LI $(BUGZILLA 5246): PATCH(s): fix a couple more uninitialised variables)
	$(LI $(BUGZILLA 5349): ICE(toir.c): nested class in static member function)
	$(LI $(BUGZILLA 5391): Crash with recursive alias declaration)
	$(LI $(BUGZILLA 5439): 64bit struct alignment inconsistent with C ABI)
	$(LI $(BUGZILLA 5455): ICE(cgcod.c): Optimization (register allocation?) regression in DMD 1.065)
	$(LI $(BUGZILLA 5486): Missing define for running dmd as 64 bit)
	$(LI $(BUGZILLA 5534): [64-bit] Inexplicable segfault in small code snippet, -O -release -m64 only)
	$(LI $(BUGZILLA 5536): Array append with dollar op on 64-bit)
	$(LI $(BUGZILLA 5545): [64-bit] DMD fails to postincrement ubytes.)
	$(LI $(BUGZILLA 5549): [64-bit] Internal error: backend/cgcod.c 1845)
	$(LI $(BUGZILLA 5556): [64-bit] Wrong Implicit Conversion to Double)
	$(LI $(BUGZILLA 5557): [64-Bit] FP (alignment?) issues with Rvalues)
	$(LI $(BUGZILLA 5564): [64-bit] loading of wrong constant byte value)
	$(LI $(BUGZILLA 5565): [64-bit] Wrong Floating Point Results, Related to Mixing With size_t)
	$(LI $(BUGZILLA 5566): [64-bit] More erratic FP results with size_t)
	$(LI $(BUGZILLA 5571): [64-bit] new bool returns bogus address)
	$(LI $(BUGZILLA 5572): [64-bit] Global Hidden Mutexes Seem to share Addresses W/ Global Variables)
	$(LI $(BUGZILLA 5580): [64-bit] String switch statements broken in 64-bit mode)
	$(LI $(BUGZILLA 5581): [64-bit] Wrong code with bitwise operations on bools)
	$(LI $(BUGZILLA 5592): Previous definition different: __arrayExpSliceMulSliceAddass_d)
    )
)

$(VERSION 066, Dec 21, 2010, =================================================,

    $(WHATSNEW
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 603): Undocumented behaviour: case and default create a scope)
	$(LI $(BUGZILLA 632): Typedef/enum promotions spec ambiguous - ultimate base type or lowest common denominator?)
	$(LI $(BUGZILLA 679): Spec needs allowances for copying garbage collection)
	$(LI $(BUGZILLA 690): ABI not fully documented)
	$(LI $(BUGZILLA 1351): Discrepancies in the language specification)
	$(LI $(BUGZILLA 1466): Spec claims maximal munch technique always works: not for "1..3")
	$(LI $(BUGZILLA 2206): unnamed template mixin of class inside function or class has incorrect classinfo and mangleof)
	$(LI $(BUGZILLA 2385): spec says all structs are returned via hidden pointer on linux, but it uses registers)
	$(LI $(BUGZILLA 2392): Parsing ambiguity between function pointer declaration and function call)
	$(LI $(BUGZILLA 2406): Declarator2 definition error)
	$(LI $(BUGZILLA 2556): Property classinfo needs better documentation (RTTI, typeof, typeid, runtime type information))
	$(LI $(BUGZILLA 2616): Undocumented behaviour: part-explicit, part-implicit instantiations of function templates are accepted)
	$(LI $(BUGZILLA 2651): class body declaration grammar incorrect)
	$(LI $(BUGZILLA 2652): DeclDef grammar is wrong)
	$(LI $(BUGZILLA 2734): Ambiguity in tokenizing: _._ as a float literal)
	$(LI $(BUGZILLA 2994): Incomplete "Predefined Versions" documentation)
	$(LI $(BUGZILLA 3112): Specification on what operations call the GC is missing)
	$(LI $(BUGZILLA 3276): Recursion broken by alias template parameter)
	$(LI $(BUGZILLA 3554): Ddoc generates invalid output for documentation comments with non paired parantheses)
	$(LI $(BUGZILLA 4529): Segfault(typinf.c) involving typeid(typeof(functionName)))
	$(LI $(BUGZILLA 4728): Segfault(toctype.c) by protected/private constructor in an other module)
	$(LI $(BUGZILLA 4864): ICE(statement.c) Crash on invalid 'if statement' body inside mixin)
	$(LI $(BUGZILLA 5110): Excess attribute propagation of structs and classes)
	$(LI $(BUGZILLA 5117): [CTFE] Member function call with rather complex this: side effects ignored)
	$(LI $(BUGZILLA 5120): ICE(mtype.c) void associative arrays)
	$(LI $(BUGZILLA 5145): Regression(2.050, 1.065) override error with forward ref of superclass)
	$(LI $(BUGZILLA 5159): Segfault(interpret.c): calling a static function pointer variable in CTFE)
	$(LI $(BUGZILLA 5164): Error without line number using "is (T...)")
	$(LI $(BUGZILLA 5180): ICE(arrayop.c) in-place array operation on incompatible types)
	$(LI $(BUGZILLA 5182): ICE(expression.c): calling unittest from a function)
	$(LI $(BUGZILLA 5195): Forward references ignore const)
	$(LI $(BUGZILLA 5230): Regression(2.041, 1.057) ICE(tocsym.c) overriding a method that has an out contract)
	$(LI $(BUGZILLA 5238): PATCH: fix return of uninitialised var in interpret.c)
	$(LI $(BUGZILLA 5275): x86_64 related hidden function parameter mishandled)
	$(LI $(BUGZILLA 5294): -O optimization breaks for loop)
	$(LI $(BUGZILLA 5331): mach format problem)
    )
)

$(VERSION 065, Oct 29, 2010, =================================================,

    $(WHATSNEW
	$(LI added talign() and argTypes() to TypeInfo)
	$(LI Upgrade zlib support to zlib 1.2.5)
    )
    $(BUGSFIXED
	$(LI Unlisted bug:  signed long comparisons under OS X)
	$(LI $(BUGZILLA 3602): ICE(tocsym.c) compiling a class, if its super class has preconditions)
	$(LI $(BUGZILLA 3665): Regression(1.051, 2.036) Assignment with array slicing does not work)
	$(LI $(BUGZILLA 4398): dmd always uses Windows name mangling for _d_throw
	$(RED may require update to Tango))
	$(LI $(BUGZILLA 4623): Non-integer type allowed as static array size)
	$(LI $(BUGZILLA 4768): Regression(1.056): wrong code with forward declaration of enum)
	$(LI $(BUGZILLA 4825): Regression(1.057, 2.040) "Error: non-constant expression" with -inline)
	$(LI $(BUGZILLA 4873): Assertion failure: '0' on line 1483 in file 'expression.c')
	$(LI $(BUGZILLA 4897): CodeView: No locals or parameters are shown when debugging, because of missing function info)
	$(LI $(BUGZILLA 4925): [ICE] segfault with module-scope assert(0))
	$(LI $(BUGZILLA 4926): ICE: PREC_zero assertion failure due to unset precedence)
	$(LI $(BUGZILLA 4941): Built-in tuple slice boundaries are not CTFE'd)
	$(LI $(BUGZILLA 4949): ICE on invalid static if using value of 'this')
	$(LI $(BUGZILLA 5026): ICE(expression.c) Incomplete mixin expression + char[] to char assignment)
    )
)

$(VERSION 064, Sep 13, 2010, =================================================,

    $(WHATSNEW
    )
    $(BUGSFIXED
	$(xxLI $(BUGZILLA 190): Cannot forward reference typedef/alias in default value for function parameter)
	$(LI $(BUGZILLA 1715): Template specialization checks for equality rather than convertibility)
	$(LI $(BUGZILLA 1970): Templated interfaces not matched)
	$(LI $(BUGZILLA 2511): Covariant return type doesn't work with circular import)
	$(LI $(BUGZILLA 2716): Confusion of auto and scope as the class attribute)
	$(LI $(BUGZILLA 3046): Segfault with C++ static variable (Linux only))
	$(LI $(BUGZILLA 3418): link error with cast(ulong)(ulong*real))
	$(xxLI $(BUGZILLA 3493): Segfault(cast.c) Forward reference with type inference, D1 only.)
	$(LI $(BUGZILLA 3544): optlink termination 0041338f with recursive nested functions)
	$(LI $(BUGZILLA 3554): Ddoc generats invalid output for documentation comments with non paired paranthasis)
	$(LI $(BUGZILLA 3627): -of with a filename with a double extension confuses linker)
	$(LI $(BUGZILLA 4009): OPTLINK ruins the day yet again)
	$(LI $(BUGZILLA 4173): Regression(2.037) Explicitly instantiated templates still try to do IFTI in some cases)
	$(LI $(BUGZILLA 4278): allow inlining of super calls (undo limitations of bug3500's fix))
	$(LI $(BUGZILLA 4302): Regression(2.046, 1.061): compiler errors using startsWith in CTFE)
	$(LI $(BUGZILLA 4645): to!string(const char*) in library causes Optlink to issue warning)
	$(LI $(BUGZILLA 4652): Compiler hangs on template with zero-length tuple and another argument)
	$(LI $(BUGZILLA 4655): Regression(1.063, 2.048) goto to a try block ICEs)
	$(LI $(BUGZILLA 4676): Overload resolution rejects valid code when mixing variadics, non-variadics)
	$(LI $(BUGZILLA 4691): Incorrect comparison of double and long)
	$(LI $(BUGZILLA 4721): compilation slow when compiling unittests on dcollections)
	$(LI $(BUGZILLA 4751): Regression(1.062, 2.047) ICE(constfold.c) >> after error)
	$(LI $(BUGZILLA 4752): fail_compilation/fail345.d asserts in expression.c)
	$(LI $(BUGZILLA 4771): fail_compilation/fail274.d hits a halt in iasm.c)
	$(LI $(BUGZILLA 4828): ICE w/ non-boolean dot expression sth.template_instance in static if)
    )
)

$(VERSION 063, Aug 8, 2010, =================================================,

    $(WHATSNEW
	$(LI $(BUGZILLA 4080): Patch for building dynamic libraries on Mac OS X)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 1418): tupleof bug on nested classes)
	$(LI $(BUGZILLA 1678): ref with varargs generates invalid code)
	$(LI $(BUGZILLA 2931): Initialization struct with array from another struct)
	$(LI $(BUGZILLA 3326): $ in delegate literal causes Access Violation)
	$(LI $(BUGZILLA 3560): foreach over nested function generates wrong code)
	$(LI $(BUGZILLA 3569): DMD Stack Overflow with a struct member function inside a C-style struct initializer)
	$(LI $(BUGZILLA 3679): Regression(2.031) template forward reference regression)
	$(LI $(BUGZILLA 3706): delegates of interfaces with multiple inheritance fail)
	$(LI $(BUGZILLA 4191): [FreeBSD] real constants are rounded to double precision)
	$(LI $(BUGZILLA 4198): [FreeBSD] imprecision in decimal floating-point literals)
	$(LI $(BUGZILLA 4238): Segfault(statement.c): with(typeof(int)))
	$(LI $(BUGZILLA 4303): __traits(compiles) returns wrong result when used recursively)
	$(LI $(BUGZILLA 4314): Regression(1.062): Expression array1 && array2 doesn't compile)
	$(LI $(BUGZILLA 4339): Struct destructor + invariant + struct parameter = horrific error message)
	$(LI $(BUGZILLA 4396): mkdir race prevents concurrent compiling with DMD using make -j)
	$(LI $(BUGZILLA 4443): Optimizer produces wrong code for || or && with struct arrays)
	$(LI $(BUGZILLA 4503): forward reference to aliased template instance)
	$(LI $(BUGZILLA 4506): Regression(2.034): -O flag breaks some recursive functions)
	$(LI $(BUGZILLA 4514): Regression: Cannot cast from X* to X)
	$(LI $(BUGZILLA 4569): extern(c++) doesn't understand const types, produces bad mangled symbol)
	$(LI $(BUGZILLA 4578): Regression(2.047,1.062): ICE(cgcod.c): var+arr[])
    )
)


$(VERSION 062, Jun 9, 2010, =================================================,

    $(WHATSNEW
	$(LI $(BUGZILLA 2008): Poor optimization of functions with ref parameters)
	$(LI $(BUGZILLA 4296): Reduce parasitic error messages)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 1193): regression: "matches more than one template declaration" doesn't list the location of the conflicting templates)
	$(LI $(BUGZILLA 1894): scope(exit) is ignored except in compound statements)
	$(LI $(BUGZILLA 1941): missing line on inaccesable external private module member)
	$(LI $(BUGZILLA 2127): inliner turns struct "return *this" from by-value into by-ref)
	$(LI $(BUGZILLA 2276): Error message missing line number on array operation)
	$(LI $(BUGZILLA 2546): Array Ops silently fail when no slice symbol is used.)
	$(LI $(BUGZILLA 2881): x.stringof returns typeof(x).stringof when x is an enum)
	$(LI $(BUGZILLA 3064): Invalid array operation accepted, generates bad code)
	$(LI $(BUGZILLA 3323): Segfault or ICE(e2ir.c) using struct with destructor almost anywhere)
	$(LI $(BUGZILLA 3398): Attributes inside a union screws data alignment)
	$(LI $(BUGZILLA 3547): for option -od for relative path the path is added twice)
	$(LI $(BUGZILLA 3548): ICE occurs when an array is returned from a function is incorrectly used in an array op expression.)
	$(LI $(BUGZILLA 3651): mangleof broken for enums)
	$(LI $(BUGZILLA 3854): Error on static initialization of arrays with trailing comma.)
	$(LI $(BUGZILLA 4003): The result changes only with the order of source files.)
	$(LI $(BUGZILLA 4045): [CTFE] increasing array length)
	$(LI $(BUGZILLA 4052): [CTFE] increment from array item)
	$(LI $(BUGZILLA 4078): [CTFE] Failed return of dynamic array item)
	$(LI $(BUGZILLA 4084): Ignored missing main() closing bracket)
	$(LI $(BUGZILLA 4143): fix warnings in dmd build)
	$(LI $(BUGZILLA 4156): Segfault with array+=array)
	$(LI $(BUGZILLA 4169): building dmd with a modern gcc produces a buggy compiler)
	$(LI $(BUGZILLA 4175): linux.mak doesn't declare sufficient dependencies to support parallel builds)
	$(LI $(BUGZILLA 4210): Random crashes / heisenbugs caused by dmd commit 478: compiler messes up vtables)
	$(LI $(BUGZILLA 4212): DWARF: void arrays cause gdb errors)
	$(LI $(BUGZILLA 4213): Strange behaviour with static void[] arrays)
	$(LI $(BUGZILLA 4242): ICE(module.c): importing a module with same name as package)
	$(LI $(BUGZILLA 4252): [CTFE] No array bounds checking in assignment to char[] array)
	$(LI $(BUGZILLA 4257): ICE(interpret.c): passing parameter into CTFE as ref parameter)
	$(LI $(BUGZILLA 4259): Header generation omits leading '@' for properties)
	$(LI $(BUGZILLA 4270): Missing line number in 'can only catch class objects' error message)
    )
)

$(VERSION 061, May 10, 2010, =================================================,

    $(WHATSNEW
	$(LI Add hints for missing import declarations.)
	$(LI Speed up compilation.)
    )
    $(BUGSFIXED
	$(LI Fix hanging problem on undefined identifiers.)
	$(LI $(BUGZILLA 461): Constant not understood to be constant when circular module dependency exists.)
	$(LI $(BUGZILLA 945): template forward reference with named nested struct only)
	$(LI $(BUGZILLA 1055): union forward reference "overlapping initialization" error)
	$(LI $(BUGZILLA 2085): CTFE fails if the function is forward referenced)
	$(LI $(BUGZILLA 2386): Array of forward referenced struct doesn't compile)
	$(LI $(BUGZILLA 4015): forward reference in alias causes error)
	$(LI $(BUGZILLA 4016): const initializer cannot forward reference other const initializer)
	$(LI $(BUGZILLA 4042): Unable to instantiate a struct template.)
	$(LI $(BUGZILLA 4100): Break and continue to label should mention foreach)
    )
)


$(VERSION 060, May 4, 2010, =================================================,

    $(WHATSNEW
    )
    $(BUGSFIXED
	$(LI Another try at fixing the Dwarf issues.)
    )
)

$(VERSION 059, Apr 30, 2010, =================================================,

    $(WHATSNEW
	$(LI Improve spelling checking distance to 2.)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 1079): gdb: Dwarf Error: Cannot find DIE at 0xb705 referenced from DIE at 0x250)
	$(LI $(BUGZILLA 2549): Segfault on array multiplication.)
	$(LI $(BUGZILLA 3066): Array operation without a slice as the lvalue accepted, bad codegen)
	$(LI $(BUGZILLA 3207): gdb: Push D patches upstream)
	$(LI $(BUGZILLA 3415): broken JSON output)
	$(LI $(BUGZILLA 3522): ICE(cg87.c): variable*array[].)
	$(LI $(BUGZILLA 3974): ICE(init.c): Static array initializer with more elements than destination array)
	$(LI $(BUGZILLA 3987): [gdb] Invalid DWARF output for function pointers)
	$(LI $(BUGZILLA 4036): Segfault with -inline and literal of struct containing union)
	$(LI $(BUGZILLA 4037): [gdb] Invalid DWARF output for wchar)
	$(LI $(BUGZILLA 4038): [gdb] Invalid DWARF output for function pointers with ref args)
	$(LI $(BUGZILLA 4067): [CTFE] Code inside try-catch blocks is silently ignored)
	$(LI $(BUGZILLA 4089): crash when creating JSON output for incomplete struct)
	$(LI $(BUGZILLA 4093): Segfault(interpret.c): with recursive struct templates)
	$(LI $(BUGZILLA 4105): Stack overflow involving alias template parameters and undefined identifier)
    )
)

$(VERSION 058, Apr 6, 2010, =================================================,

    $(WHATSNEW
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 122): DDoc newline behaviour produces suboptimal results)
	$(LI $(BUGZILLA 1628): Ddoc produces invalid documentation for --- blocks)
	$(LI $(BUGZILLA 2609): No documentation generated for destructor)
	$(LI $(BUGZILLA 3808): Assertion Failure : Assertion failure: 'classinfo->structsize == CLASSINFO_SIZE' on line 870 in file 'toobj.c')
	$(LI $(BUGZILLA 3842): ICE(expression.c) using pointer in CTFE)
	$(LI $(BUGZILLA 3884): Segfault: defining a typedef with an invalid object.d)
	$(LI $(BUGZILLA 3885): No multithread support for Windows DLL)
	$(LI $(BUGZILLA 3899): CTFE: poor error message for use of uninitialized variable)
	$(LI $(BUGZILLA 3900): CTFE: Wrong return value for array.var assignment)
	$(LI $(BUGZILLA 3901): PATCH: Nested struct assignment for CTFE)
	$(LI $(BUGZILLA 3914): Struct as argument that fits in register has member accessed wrong)
	$(LI $(BUGZILLA 3919): ICE(expression.c, 9944): * or / with typedef ireal)
	$(LI $(BUGZILLA 3920): Assertion failure: '0' on line 10018 in file 'expression.c')
	$(LI $(BUGZILLA 3958): mixin(non-static method) crashes compiler)
	$(LI $(BUGZILLA 3972): Regarding module with name different from its file name)
	$(LI $(BUGZILLA 4002): dmd.conf and binary path in dmd -v output)
	$(LI $(BUGZILLA 4004): DMD 2.042 CTFE regression with functions taking ref parameters)
	$(LI $(BUGZILLA 4005): std.c.stdlib.exit in CTFE and more)
	$(LI $(BUGZILLA 4011): Incorrect function overloading using mixins)
	$(LI $(BUGZILLA 4019): [CTFE] Adding an item to an empty AA)
	$(LI $(BUGZILLA 4020): [ICE][CTFE] struct postblit in CTFE)
	$(LI $(BUGZILLA 4027): Closures in CTFE generate wrong code)
	$(LI $(BUGZILLA 4029): CTFE: cannot invoke delegate returned from function)
    )
)


$(VERSION 057, Mar 7, 2010, =================================================,

    $(WHATSNEW
	$(LI Warnings no longer halt the parsing/semantic passes, though they still return
	 an error status and still do not generate output files. They also no longer count
	 as errors when testing with "compiles" traits.)
	$(LI Added $(B -wi) switch for $(BUGZILLA 2567))
	$(LI Associative array contents can now be compared for equality)
	$(LI Add simple spell checking.)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 2321): spec on inline asm can be misunderstood)
	$(LI $(BUGZILLA 2463): No line number in "statement is not reachable" warning)
	$(LI $(BUGZILLA 3029): Bug in array value mangling rule)
	$(LI $(BUGZILLA 3306): bad function/delegate literal generated into header files)
	$(LI $(BUGZILLA 3373): bad codeview debug info for long and ulong)
	$(LI Posix only, $(BUGZILLA 3420): [PATCH] Allow string import of files using subdirectories)
	$(LI $(BUGZILLA 3450): incorrect result for is (typeof({ ... }())) inside a struct)
	$(LI $(BUGZILLA 3500): super behaves differently with -inline)
	$(LI $(BUGZILLA 3558): Optimizer bug results in false if condition being taken)
	$(LI $(BUGZILLA 3670): Declarator grammar rule is broken)
	$(LI $(BUGZILLA 3710): Typo in allMembers description?)
	$(LI $(BUGZILLA 3736): corrupted struct returned by function with optimizations (-O))
	$(LI $(BUGZILLA 3737): SEG-V at expression.c:6255 from bad opDispatch)
	$(LI $(BUGZILLA 3768): reapeted quotes in ddoc.html)
	$(LI $(BUGZILLA 3769): Regression: Segfault(constfold.c) array literals and case statements)
	$(LI $(BUGZILLA 3775): Segfault(cast.c): casting no-parameter template function using property syntax)
	$(LI $(BUGZILLA 3781): ICE(interpret.c): using no-argument C-style variadic function in CTFE)
	$(LI $(BUGZILLA 3792): Regression: "non-constant expression" for a template inside a struct using a struct initializer)
	$(LI $(BUGZILLA 3803): compiler segfaults)
	$(LI $(BUGZILLA 3840): Jump to: section in the docs should be sorted)
    )
)

$(VERSION 056, Jan 29, 2010, =================================================,

    $(WHATSNEW
	$(LI Clarification: function returns are not lvalues)
	$(LI Add $(B -map) command line switch)
	$(LI Delegates and function pointers may be used in CTFE)
	$(LI Delegate literals and function literals may be used in CTFE)
	$(LI Lazy function parameters may now be used in CTFE)
	$(LI Slicing of char[] arrays may now be used in CTFE)
    )
    $(BUGSFIXED
	$(LI $(CPPBUGZILLA 48): Internal error: cgreg 784)
	$(LI $(BUGZILLA 1298): CTFE: tuple foreach bugs)
	$(LI $(BUGZILLA 1790): CTFE: foreach(Tuple) won't compile if Tuple contains string)
	$(LI $(BUGZILLA 2101): CTFE: Please may I use mutable arrays at compile time?)
	$(LI Partial fix for $(BUGZILLA 3569), stops the stack overflow)
	$(LI $(BUGZILLA 3668): foreach over typedef'd array crashes dmd)
	$(LI $(BUGZILLA 3674): forward reference error with multiple overloads with same name)
	$(LI $(BUGZILLA 3685): Regression(D1 only): DMD silently exits on valid code)
	$(LI $(BUGZILLA 3687): Array operation "slice times scalar" tramples over memory)
	$(LI $(BUGZILLA 3719): forward references can cause out-of-memory error)
	$(LI $(BUGZILLA 3723): Regression: forward referenced enum)
	$(LI $(BUGZILLA 3724): bug in Expression::arraySyntaxCopy (null pointer dereference on struct->union->struct))
	$(LI $(BUGZILLA 3726): Regression: ICE(mangle.c 81): struct forward reference with static this)
	$(LI $(BUGZILLA 3740): Regression: class with fwd reference of a nested struct breaks abstract)
    )
)

$(VERSION 055, Jan 1, 2010, =================================================,

    $(WHATSNEW
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 3663): struct forward reference regresssion)
	$(LI $(BUGZILLA 3664): struct forward declaration causes enum to conflict with itself)
    )
)

$(VERSION 054, Dec 30, 2009, =================================================,

    $(WHATSNEW
    )
    $(BUGSFIXED
	$(LI $(CPPBUGZILLA 45): Internal error: cgcod 1594)
	$(LI $(CPPBUGZILLA 46): Constant folding with long doubles)
	$(LI $(NG_digitalmars_D 103391): D1 garbage collector + threads + malloc = garbage?)
	$(LI $(BUGZILLA 282): Bizarre circular import nested name invisibility issue)
	$(LI $(BUGZILLA 390): Cannot forward reference enum nested in struct)
	$(LI $(BUGZILLA 400): forward reference error; no propety X for type Y (struct within struct))
	$(LI $(BUGZILLA 1160): enums can not be forward referenced)
	$(LI $(BUGZILLA 1564): Forward reference error for enum in circular import)
	$(LI $(BUGZILLA 2029): Typesafe variadic functions don't work in CTFE)
	$(LI $(BUGZILLA 2816): Sudden-death static assert is not very useful)
	$(LI $(BUGZILLA 3455): Some Unicode characters not allowed in identifiers)
	$(LI $(BUGZILLA 3575): CTFE: member structs not initialized correctly)
	$(LI $(BUGZILLA 3584): DeclDef rule is missing entries)
	$(LI $(BUGZILLA 3585): Duplicate clauses in EqualExpression and RelExpression rules)
	$(LI $(BUGZILLA 3587): Aggregate rule references undefined Tuple)
	$(LI $(BUGZILLA 3588): WithStatement rule references unspecified Symbol)
	$(LI $(BUGZILLA 3589): BaseClassList and InterfaceClasses rules are incorrect, missing ',')
	$(LI $(BUGZILLA 3590): FunctionParameterList rule is missing)
	$(LI $(BUGZILLA 3591): TemplateIdentifier rule is misspelled)
	$(LI $(BUGZILLA 3592): ClassTemplateDeclaration and FunctionTemplateDeclaration rules are unreferenced)
	$(LI $(BUGZILLA 3593): IntegerExpression rule unspecified)
	$(LI $(BUGZILLA 3594): AsmPrimaryExp rule references unspecified rules)
	$(LI $(BUGZILLA 3595): Several rules are missing ':' after rule name)
	$(LI $(BUGZILLA 3601): Debug and Release builds of DMD produce different object files)
	$(LI $(BUGZILLA 3611): Enum forward referencing regression)
	$(LI $(BUGZILLA 3612): ExpressionList is undefined)
	$(LI $(BUGZILLA 3617): CTFE: wrong code for if(x) where x is int or smaller)
	$(LI $(BUGZILLA 3628): can't cast null to int)
	$(LI $(BUGZILLA 3633): Optimizer causes access violation)
	$(LI $(BUGZILLA 3645): manifest constant (enum) crashes dmd)
    )
)

$(VERSION 053, Dec 3, 2009, =================================================,

    $(WHATSNEW
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 111): appending a dchar to a char[])
	$(LI $(BUGZILLA 370): Compiler stack overflow on recursive typeof in function declaration.)
	$(LI $(BUGZILLA 2229): ICE(template.c) instantiating an invalid variadic template with more than one argument)
	$(LI $(BUGZILLA 2967): spec does not mention that inline asm is a valid "return" statement)
	$(LI $(BUGZILLA 3115): &gt;&gt;&gt; and &gt;&gt;&gt;= generate wrong code)
	$(LI $(BUGZILLA 3171): % not implemented correctly for floats)
	$(LI $(BUGZILLA 3381): [tdpl] Incorrect assessment of overriding in triangular-shaped hierarchy)
	$(LI $(BUGZILLA 3469): ICE(func.c): Regression. Calling non-template function as a template, from another module)
	$(LI $(BUGZILLA 3495): Segfault(typinf.c) instantiating D variadic function with too few arguments)
	$(LI $(BUGZILLA 3496): ICE(cgelem.c, optimizer bug) cast(void *)(x&1)== null.)
	$(LI $(BUGZILLA 3502): Fix for dropped Mac OS X 10.5)
	$(LI $(BUGZILLA 3521): Optimized code access popped register)
	$(LI $(BUGZILLA 3540): Another DWARF line number fix)
    )
)

$(VERSION 052, Nov 12, 2009, =================================================,

    $(WHATSNEW
	$(LI OSX versions 10.5 and older are no longer supported.)
    )
    $(BUGSFIXED
	$(LI Works on OSX 10.6 now.)
    )
)

$(VERSION 051, Nov 5, 2009, =================================================,

    $(WHATSNEW
    )
    $(BUGSFIXED
	$(LI Problem with complicated array op expressions)
	$(LI $(BUGZILLA 195): DDoc generates bad output when example contains "protected" attribute)
	$(LI $(BUGZILLA 424): Unexpected OPTLINK Termination at EIP=0044C37B (too many fixups))
	$(LI $(BUGZILLA 874): Bad codegen: wrong value variable in tuple foreach, D1 only)
	$(LI $(BUGZILLA 1117): ddoc generates corrupted docs if code examples contain attributes with colons)
	$(LI $(BUGZILLA 1812): DDOC - Unicode identifiers are not correctly marked.)
	$(LI $(BUGZILLA 2862): ICE(template.c) using type tuple as function argument)
	$(LI $(BUGZILLA 3292): ICE(todt.c) when using a named mixin with an initializer as template alias parameter)
	$(LI $(BUGZILLA 3397): Unintended function call to static opCall)
	$(LI $(BUGZILLA 3401): Compiler crash on invariant + method overload)
	$(LI $(BUGZILLA 3422): ICE(cgcod.c) Structs with default initializers bigger than register size cannot be default parameters)
	$(LI $(BUGZILLA 3426): ICE(optimize.c): struct literal with cast, as function default parameter.)
	$(LI $(BUGZILLA 3432): ICE(e2ir.c): casting template expression)
    )
)

$(VERSION 050, Oct 14, 2009, =================================================,

    $(WHATSNEW
	$(LI Use $(B -X) to generate JSON files.)
    )
    $(BUGSFIXED
	$(LI Fold in patch from $(BUGZILLA 1170))
	$(LI $(BUGZILLA 923): No constant folding for template value default arguments, D1 only)
	$(LI $(BUGZILLA 1534): Can't mix in a case statement.)
	$(LI $(BUGZILLA 2423): Erroneous unreachable statement warning)
	$(LI $(BUGZILLA 3392): a cast of this to void in tango.core.Thread is not allowed)
    )
)

$(VERSION 049, Oct 11, 2009, =================================================,

    $(WHATSNEW
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 258): Undefined identifier error for circular import)
	$(LI $(BUGZILLA 928): nested struct definition in unittest section of a templated class, hangs DMD)
	$(LI $(BUGZILLA 1140): ICE(cod1.c) casting last function parameter to 8 byte value)
	$(LI $(BUGZILLA 1592): dmd fail to resolve class symbol when i put files in a package)
	$(LI $(BUGZILLA 1787): Compiler segfaults on circular references.)
	$(LI $(BUGZILLA 1897): ICE(template.c) with tuple delegate)
	$(LI $(BUGZILLA 1934): ICE(e2ir.c) using static array as AA key)
	$(LI $(BUGZILLA 2229): ICE(template.c) instantiating an invalid variadic template with more than one argument)
	$(LI $(BUGZILLA 2687): ICE(statement.c): tuple foreach in an erroneous template.)
	$(LI $(BUGZILLA 2773): ICE(go.c) array assignment through a pointer, only with -O.)
	$(LI $(BUGZILLA 2829): ICE(expression.c) static array block-initialized in struct literal)
	$(LI $(BUGZILLA 2851): Segfault(expression.c) using C-style struct initializer with too few arguments)
	$(LI $(BUGZILLA 3006): ICE(e2ir.c, tocsym.c) template module using array operation)
	$(LI $(BUGZILLA 3041): Array slices can be compared to their element type: bad codegen or ICE)
	$(LI $(BUGZILLA 3101): Stack overflow: declaring aggregate member twice with static if)
	$(LI $(BUGZILLA 3174): ICE(mtype.c): Compiler crash or compiler error with auto returns and const / immutable / invarient / pure)
	$(LI $(BUGZILLA 3176): Compiler hangs on poorly formed mixin in variadic template)
	$(LI $(BUGZILLA 3261): compiler crash with mixin and forward reference)
	$(LI $(BUGZILLA 3286): Default parameter prevents to resolve inter-module circular dependency)
	$(LI $(BUGZILLA 3301): Undefined identifier error dependent on order of imports when a circular import is involved)
	$(LI $(BUGZILLA 3325): ICE(func.c) function literal with post-contract)
	$(LI $(BUGZILLA 3343): Crash by "auto main(){}")
	$(LI $(BUGZILLA 3344): ICE(e2ir.c) returning an invalid function from main())
	$(LI $(BUGZILLA 3357): ICE(cod1.c) using 'in' with a static char array as AA key)
	$(LI $(BUGZILLA 3366): Segfault(declaration.c) variadic template with unmatched constraint)
	$(LI $(BUGZILLA 3374): [tdpl] ICE(init.c): Associative array type not inferred)
    )
)

$(VERSION 048, Oct 5, 2009, =================================================,

    $(WHATSNEW
	$(LI Compiler now detects some cases of illegal null dereferencing when compiled with -O)
	$(LI $(BUGZILLA 2905): Faster +-*/ involving a floating-pointing literal)
    )
    $(BUGSFIXED
	$(LI gdb stack trace should work now)
	$(LI $(BUGZILLA 302): in/out contract inheritance yet to be implemented)
	$(LI $(BUGZILLA 718): ICE(cgcod.c) with int /= cast(creal))
	$(LI $(BUGZILLA 814): lazy argument + variadic arguments = segfault)
	$(LI $(BUGZILLA 1168): Passing a .stringof of an expression as a template value parameter results in the string of the type)
	$(LI $(BUGZILLA 1571): Segfault(class.c) const on function parameters not carried through to .di file)
	$(LI $(BUGZILLA 1731): forward reference of function type alias resets calling convention)
	$(LI $(BUGZILLA 2202): Error getting type of non-static member of a class)
	$(LI $(BUGZILLA 2469): ICE(cod1.c) arbitrary struct accepted as struct initializer)
	$(LI $(BUGZILLA 2697): Cast of float function return to ulong or uint gives bogus value)
	$(LI $(BUGZILLA 2702): Struct initialisation silently inserts deadly casts)
	$(LI $(BUGZILLA 2839): ICE(cgcs.c) with int /= imaginary)
	$(LI $(BUGZILLA 3049): ICE(cod4.c) or segfault: Array operation on void[] array)
	$(LI $(BUGZILLA 3059): Nonsensical complex op= should be illegal)
	$(LI $(BUGZILLA 3160): ICE(cgcod.c 1511-D1) or bad code-D2 returning string from void main)
	$(LI $(BUGZILLA 3304): Segfault using 'is' with a pointer enum.)
	$(LI $(BUGZILLA 3305): Segfault(expression.c) with recursive struct template alias expressions)
	$(LI $(BUGZILLA 3335): minor warning cleanups)
	$(LI $(BUGZILLA 3336): ICE(glue.c) declaring AA with tuple key, only with -g)
	$(LI $(BUGZILLA 3353): storage class of a member function is propagated to default arguments)
    )
)

$(VERSION 047, Sep 2, 2009, =================================================,

    $(WHATSNEW
	$(LI $(BUGZILLA 3122): [patch] Adding support for fast and reliable build tools to the frontend)
	$(LI Added support for:
---
a[i].var = e2
---
	and:
---
a[] = e
---
	in CTFE. $(I (thanks, Don!)))
	$(LI Member functions can now be used in CTFE)
	$(LI Operator overloading can now be used in CTFE)
	$(LI Nested functions can now be used in CTFE)
	$(LI CTFE error messages now explain why the function could not be
	interpreted at compile time)
    )
    $(BUGSFIXED
	$(LI Fixed bug processing spaces in dmd's directory)
	$(LI $(BUGZILLA 601): statement.html - Formatting/markup errors in BNF)
	$(LI $(BUGZILLA 1461): Local variable as template alias parameter breaks CTFE)
	$(LI $(BUGZILLA 1605): break in switch with goto breaks in ctfe)
	$(LI $(BUGZILLA 1948): CTFE fails when mutating a struct in an array)
	$(LI $(BUGZILLA 1950): CTFE doesn't work correctly for structs passed by ref)
	$(LI $(BUGZILLA 2569): static arrays in CTFE functions don't compile)
	$(LI $(BUGZILLA 2575): gdb can not show code)
	$(LI $(BUGZILLA 2604): DW_TAG_module and GDB)
	$(LI $(BUGZILLA 2940): null is null cannot be evaluated at compile time)
	$(LI $(BUGZILLA 2960): CTFE rejects static array to dynamic array casts)
	$(LI $(BUGZILLA 3039): -vtls compiler flag not listed in man file)
	$(LI $(BUGZILLA 3165): What kind of integer division does D use?)
	$(LI $(BUGZILLA 3166): "positive" -> "non-negative" in modulo operator description)
	$(LI $(BUGZILLA 3168): Declaring structs as incomplete types no longer works)
	$(LI $(BUGZILLA 3170): Forward reference of nested class fails if outer class is not plain)
	$(LI $(BUGZILLA 3183): Spec of align attribute needs work)
	$(LI $(BUGZILLA 3186): corrections for http://www.digitalmars.com/d/2.0/dmd-osx.html)
	$(LI $(BUGZILLA 3192): asm in a anonymous delegate crash the compiler)
	$(LI $(BUGZILLA 3196): Segfault(mtype.c) after almost any error involving a delegate literal)
	$(LI $(BUGZILLA 3205): CTFE: $ cannot be used in lvalues)
	$(LI $(BUGZILLA 3246): ICE(init.c) using indexed array initializer on local array)
	$(LI $(BUGZILLA 3264): -O causes wrong "used before set" error when using enum.)
    )
)

$(VERSION 046, Jul 6, 2009, =================================================,

    $(WHATSNEW
	$(LI $(BUGZILLA 3080): dmd should output compilation errors to stderr, not stdout)
    )
    $(BUGSFIXED
	$(LI Fix dmd crash on multicore Windows.)
	$(LI $(BUGZILLA 106): template - mixin sequence)
	$(LI $(BUGZILLA 810): Cannot forward reference template)
	$(LI $(BUGZILLA 852): ICE(toir.c) using local class in non-static nested function in nested static function)
	$(LI $(BUGZILLA 854): TypeTuple in anonymous delegate causes ice in glue.c)
	$(LI $(BUGZILLA 1054): regression: circular aliases cause compiler stack overflow)
	$(LI $(BUGZILLA 1343): Various errors with static initialization of structs and arrays)
	$(LI $(BUGZILLA 1358): ICE(root.c) on Unicode codepoints greater than 0x7FFFFFFF)
	$(LI $(BUGZILLA 1459): ICE(cgcs.c) on attempt to set value of non-lvalue return struct)
	$(LI $(BUGZILLA 1524): ICE(constfold.c) on using "is" with strings in CTFE)
	$(LI $(BUGZILLA 1984): Assertion failure: 'e1->type' on line 1198 in file 'constfold.c')
	$(LI $(BUGZILLA 2323): ICE(cgcs.c): taking address of a method of a temporary struct)
	$(LI $(BUGZILLA 2429): std.stream.File incorrect flag parsing and sharing mode)
	$(LI $(BUGZILLA 2432): complex alias -> mtype.c:125: virtual Type* Type::syntaxCopy(): Assertion `0' failed.)
	$(LI $(BUGZILLA 2603): ICE(cgcs.c) on subtracting string literals)
	$(LI $(BUGZILLA 2843): ICE(constfold.c) with is-expression with invalid dot-expression in is-expression involving typeid)
	$(LI $(BUGZILLA 2884): ICE: Assert: 'template.c', line 3773, 'global.errors')
	$(LI $(BUGZILLA 2888): [PATCH] speedup for float * 2.0)
	$(LI $(BUGZILLA 2915): [Patch]: Optimize -a*-b into a*b)
	$(LI $(BUGZILLA 2923): -O generates bad code for ?:)
	$(LI $(BUGZILLA 2932): bad e_ehsize (36 != 52))
	$(LI $(BUGZILLA 2952): Segfault on exit when using array ops with arrays of doubles larger than 8 elements)
	$(LI $(BUGZILLA 3003): Need to implicitly add () on member template function calls)
	$(LI $(BUGZILLA 3014): ICE(template.c) instantiating template with tuple)
	$(LI $(BUGZILLA 3016): Errors in the documentation of std.math.acos)
	$(LI $(BUGZILLA 3026): Segfault with incomplete static array initializer)
	$(LI $(BUGZILLA 3044): Segfault(template.c) instantiating struct tuple constructor with zero arguments.)
	$(LI $(BUGZILLA 3078): NaN reported as equal to zero)
	$(LI $(BUGZILLA 3114): optlink failing on multicore machines)
	$(LI $(BUGZILLA 3117): dmd crash by *1)
	$(LI $(BUGZILLA 3128): Internal error: ..\ztc\cod4.c 2737)
	$(LI $(BUGZILLA 3130): Crashed with triple stars)
    )
)

$(VERSION 045, May 11, 2009, =================================================,

    $(WHATSNEW
	$(LI Folded in compiler/library changes by Unknown W. Brackets
	to support Solaris.)
	$(LI Migrate Posix uses of std.c.linux.linux to std.c.posix.posix)
	$(LI added .typeinfo to ClassInfo $(BUGZILLA 2836): Navigate from ClassInfo to TypeInfo)
    )
    $(BUGSFIXED
	$(LI Fix instruction scheduler bug on Linux)
        $(LI $(BUGZILLA 642): error: mixin "static this" into where it cannot be)
        $(LI $(BUGZILLA 713): circular const definitions with module operator "." cause the compiler to segfault)
        $(LI $(BUGZILLA 752): Assertion failure: 'e->type->ty != Ttuple' on line 4518 in file 'mtype.c')
        $(LI $(BUGZILLA 858): Forward reference to struct inside class crashes the compiler)
        $(LI $(BUGZILLA 884): Segfault in recursive template)
        $(LI $(BUGZILLA 934): Segfault taking mangleof a forward reference in a  template.)
        $(LI $(BUGZILLA 1011): illegal import declaration causes compile time segfault)
        $(LI $(BUGZILLA 1054): regression: circular aliases cause segfaults)
        $(LI $(BUGZILLA 1061): "asm inc [;" segfaults compiler.)
        $(LI $(BUGZILLA 1195): regression: aliasing an enum member causes compile time segfaults)
        $(LI $(BUGZILLA 1305): Compiler hangs with templated opCmp returning templated class)
        $(LI $(BUGZILLA 1385): Stack Overflow with huge array literal.)
        $(LI $(BUGZILLA 1428): Segfault on template specialization with delegates and tuples)
        $(LI $(BUGZILLA 1586): DMD and GDC segfaults on incomplete code segment.)
        $(LI $(BUGZILLA 1791): Segmentation fault with anon class in anon class and non-constant variable init)
        $(LI $(BUGZILLA 1916): segfault on invalid string concat)
        $(LI $(BUGZILLA 1946): Compiler crashes on attempt to implicit cast const typedef to non-const.)
        $(LI $(BUGZILLA 2048): DMD crash on CTFE that involves assigning to member variables of void-initialized struct)
        $(LI $(BUGZILLA 2061): wrong vtable call with multiple interface inheritance)
        $(LI $(BUGZILLA 2215): Forward reference enum with base type within a struct causes Segmentation Fault in the compiler)
        $(LI $(BUGZILLA 2309): Crash on a template mixing in a variadic template with an undefined template identifier)
        $(LI $(BUGZILLA 2346): ICE when comparing typedef'd class)
        $(LI $(BUGZILLA 2821): struct alignment inconsistent with C for { int, long })
	$(LI $(BUGZILLA 2920): recursive templates blow compiler stack)
    )
)

$(VERSION 044, Apr 9, 2009, =================================================,

    $(WHATSNEW
	$(LI Added std.c.posix.* to Phobos.)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 675): %a format has an out-by-1 bug for denormals.)
	$(LI $(BUGZILLA 2064): Segfault with mixin(for/foreach) with empty loop body)
	$(LI $(BUGZILLA 2199): Segfault using array operation in function call)
	$(LI $(BUGZILLA 2203): typeof(class.template.foo) crashes compiler)
    )
)

$(VERSION 043, Apr 6, 2009, =================================================,

    $(WHATSNEW
	$(LI Added FreeBSD 7.1 support.)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 2796): Dependency on libstdc++-v3)
    )
)

$(VERSION 042, Mar 31, 2009, =================================================,

    $(WHATSNEW
	$(LI Added response files for Linux and OSX)
	$(LI On Windows, if there are multiple source files on the command
	 line they are now read with a background thread. This may speed up
	 compilation.)
	$(LI Folded in patches for LDC compatibility from Tomas Lindquist Olsen)
	$(LI The $(B Posix) version identifier can now be set even though
	 it is reserved and predefined, because many build systems and makefiles
	 try to set it.)
    )
    $(BUGSFIXED
	$(LI std.math.hypot is wrong for subnormal arguments)
	$(LI Fix bug where / wasn't recognized as a path separator on Windows.)
	$(LI $(BUGZILLA 920): Fix one more out of date reference to 'auto' rather than 'scope')
	$(LI $(BUGZILLA 1923): GC optimization for contiguous pointers to the same page)
	$(LI $(BUGZILLA 2319): "Win32 Exception" not very useful)
	$(LI $(BUGZILLA 2570): Patch for some mistakes in Ddoc comments)
	$(LI $(BUGZILLA 2591): custom allocator new argument should be size_t instead of uint)
	$(LI $(BUGZILLA 2689): seek behaves incorrectly on MAC OSX)
	$(LI $(BUGZILLA 2692): alignment of double on x86 linux is incorrect)
	$(LI $(BUGZILLA 2705): Response file size cannot exceed 64kb)
	$(LI $(BUGZILLA 2711): -H produces bad headers files if function defintion is templated and have auto return value)
	$(LI $(BUGZILLA 2731): Errors in associative array example)
	$(LI $(BUGZILLA 2743): dumpobj gives "buss error" on Tiger)
	$(LI $(BUGZILLA 2744): wrong init tocbuffer of forstatement)
	$(LI $(BUGZILLA 2745): missing token tochars in lexer.c)
	$(LI $(BUGZILLA 2747): improper toCBuffer of funcexp)
	$(LI $(BUGZILLA 2750): Optimize slice copy with size known at compile time)
	$(LI $(BUGZILLA 2751): incorrect scope storage class vardeclaration tocbuffer)
	$(LI $(BUGZILLA 2767): DMD incorrectly mangles NTFS stream names)
	$(LI $(BUGZILLA 2772): lib can't open response file)
    )
)

$(VERSION 041, Mar 3, 2009, =================================================,

    $(WHATSNEW
	$(LI Added buildable dmd source.)
        $(LI Improved accuracy of exp, expm1, exp2, sinh, cosh, tanh on Mac OSX,
           and tripled speed on all platforms.)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 1629): Link error: Previous Definition Different:  blablah__initZ)
	$(LI $(BUGZILLA 1662): Falls back to libphobos if -debuglib isn't used when -g is)
	$(LI $(BUGZILLA 1681): cast(real) ulong.max == 0)
	$(LI $(BUGZILLA 2416): Slice of typedef'ed array should preserve the typedef'ed type)
	$(LI $(BUGZILLA 2582): Significantly Increased Compile Times For DWT)
	$(LI $(BUGZILLA 2670): std.file.read() should read files of 0 length)
	$(LI $(BUGZILLA 2673): Static constructors sometimes do not run when compiling with -lib)
	$(LI $(BUGZILLA 2678): for loops are already assumed to terminate)
	$(LI $(BUGZILLA 2679): Spurious "warning - " messages and erratic behaviour with is(typeof({void function}())))
	$(LI $(BUGZILLA 2690): DMD aborts with MALLOC_CHECK_ set)
    )
)

$(VERSION 040, Feb 11, 2009, =================================================,

    $(WHATSNEW
	$(LI Added Mac OSX support.)
	$(LI Separated bin and lib directories into windows, linux,
	and osx.)
	$(LI No longer need to download dmc to use the windows version.)
	$(LI Use version(OSX) for Mac OSX. Although version(darwin) is
	also supported for the time being, it is deprecated.)
    )
    $(BUGSFIXED
    )
)

$(VERSION 039, Jan 14, 2009, =================================================,

    $(WHATSNEW
	$(LI Improved speed of long division.)
	$(LI Added predefined $(LINK2 version.html#PredefinedVersions, version)
	$(B D_Ddoc) which is predefined when $(B -D) switch is thrown.)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 2517): DDoc omits abstract on classes)
	$(LI $(BUGZILLA 2518): scope(success) not execuate and RAII variable destructor is not called)
	$(LI $(BUGZILLA 2519): Segfault when >> used in an invalid slice)
	$(LI $(BUGZILLA 2527): Alias Template Params Are Always Same Type As First Instantiation (according to typeof(x).stringof))
	$(LI $(BUGZILLA 2531): DDoc not generated correctly for struct methods inside static if)
	$(LI $(BUGZILLA 2537): compiler crashes on this code:)
	$(LI $(BUGZILLA 2542): array casts behave differently at compile and runtime)
    )
)

$(VERSION 038, Dec 11, 2008, =================================================,

    $(WHATSNEW
	$(LI Changed IUnknown to use the extern(System) interface rather
	that extern(Windows).)
	$(LI Added Partial IFTI $(BUGZILLA 493))
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 1518): Crash using 'scope', 'with' and undefined 'RegExp')
	$(LI $(BUGZILLA 1685): Array index is evaluated twice)
	$(LI $(BUGZILLA 1963): -H creates broken headers)
	$(LI $(BUGZILLA 2041): Spec implies relationship between interfaces and COM objects)
	$(LI $(BUGZILLA 2105): added patch)
	$(LI $(BUGZILLA 2468): result type of AndAndExp and OrOrExp deduced incorrectly)
	$(LI $(BUGZILLA 2489): import in struct causes assertion failure)
	$(LI $(BUGZILLA 2490): extern(C++) can not handle structs as return types)
	$(LI $(BUGZILLA 2492): ICE building on Linux with -lib option)
	$(LI $(BUGZILLA 2499): Template alias default value cannot be template instantiation)
	$(LI $(BUGZILLA 2500): template struct methods are left unresolved if imported from multiple modules)
	$(LI $(BUGZILLA 2501): member function marked as final override ignores override requirements)
	$(LI Incorporated some of the patches from $(BUGZILLA 1752))
    )
)

$(VERSION 037, Nov 25, 2008, =================================================,

    $(WHATSNEW
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 313): Fully qualified names bypass private imports)
	$(LI $(BUGZILLA 341): Undocumented function void print() in object.d)
	$(LI $(BUGZILLA 929): Resizing array of associative arrays (uint[char[]][]) causes infinite loop / hang)
	$(LI $(BUGZILLA 1372): Compiler accepts pragma(msg,))
	$(LI $(BUGZILLA 1610): Enum.stringof is int, not the name of the enum)
	$(LI $(BUGZILLA 1663): pragma(lib, "") don't work on linux)
	$(LI $(BUGZILLA 1797): Documentation comments - ///)
	$(LI $(BUGZILLA 2326): Methods within final class are not considered final when optimizing)
	$(LI $(BUGZILLA 2429): std.stream.File incorrect flag parsing and sharing mode)
	$(LI $(BUGZILLA 2431): Internal error: ../ztc/cgcod.c 1031 when using -O)
	$(LI $(BUGZILLA 2470): Cannot build libraries from other libraries)
	$(LI unittest functions now always use D linkage)
    )
)

$(VERSION 036, Oct 20, 2008, =================================================,

    $(WHATSNEW
	$(LI Improved performance of AAs by rebalancing trees when rehashing.)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 1229): Linker fills disk)
	$(LI $(BUGZILLA 2340): Template properties don't work)
	$(LI $(BUGZILLA 2365): compilation error: static const array in struct)
	$(LI $(BUGZILLA 2368): Calling a function with an address of another function, then calling a returned object is rejected)
	$(LI $(BUGZILLA 2373): freebsd select does not accept values  &gt; 999,999)
	$(LI $(BUGZILLA 2376): CTFE fails on array literal of array literals of chars)
	$(LI $(BUGZILLA 2380): static struct initializer accepted as non static initializer is not documented)
	$(LI $(BUGZILLA 2383): default arguments can implicitly access private global variables that are not visible at call site)
	$(LI $(BUGZILLA 2385): spec says all structs are returned via hidden pointer on linux, but it uses registers)
	$(LI $(BUGZILLA 2390): Missing warning on conversion from int to char)
    )
)

$(VERSION 035, Sep 2, 2008, =================================================,

    $(WHATSNEW
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 1627): ICE with a method called _ctor)
	$(LI $(BUGZILLA 1633): Nonsensical "C style cast illegal" message with !is)
	$(LI $(BUGZILLA 1637): regression: new unittest failure in std/math2.d, odd cosh() behavior)
	$(LI $(BUGZILLA 1763): EndianStream doesn't handle ubyte/byte read/writes. Simple fix.)
	$(LI $(BUGZILLA 1771): dmd fails to execute on linux)
	$(LI $(BUGZILLA 1773): excessively long integer literal)
	$(LI $(BUGZILLA 1785): Mixing in an incorrect array literal causes infinite loop.)
	$(LI $(BUGZILLA 2176): Assertion failure: 'sz == es2->sz' on line 1339 in file 'constfold.c' (concatenating strings of different types))
	$(LI $(BUGZILLA 2183): Bad formatting in std.c.stdlib)
	$(LI $(BUGZILLA 2232): DMD generates invalid code when an object file is compiled -inline)
	$(LI $(BUGZILLA 2241): DMD abort)
	$(LI $(BUGZILLA 2243): const bool = is(function literal), badly miscast)
	$(LI $(BUGZILLA 2262): -inline breaks -lib library)
	$(LI $(BUGZILLA 2286): movmskpd compiled incorrectly)
	$(LI $(BUGZILLA 2308): CTFE crash on foreach over nonexistent variable)
	$(LI $(BUGZILLA 2311): Static destructors in templates are never run)
	$(LI $(BUGZILLA 2314): Crash on anonymous class variable instantiation)
	$(LI $(BUGZILLA 2317): asm offsetof generates: Internal error: ../ztc/cod3.c 2651)
    )
)

$(VERSION 034, Aug 7, 2008, =================================================,

    $(WHATSNEW
	$(LI Now supports $(LINK2 arrays.html#array-operations, array operations).)
    )
    $(BUGSFIXED
	$(LI Added hash to generated module names when building libs to reduce collisions)
	$(LI $(BUGZILLA 1622): parameters to TypeInfo_Struct.compare seem to be switched around.)
	$(LI $(BUGZILLA 2216): bad code generation for static arrays of zero length static arrays)
	$(LI $(BUGZILLA 2223): Typo in error message)
	$(LI $(BUGZILLA 2242): linux system calls are canceled by GC)
	$(LI $(BUGZILLA 2247): bad header file generated for if (auto o = ...) {})
	$(LI $(BUGZILLA 2248): .di should be a supported file extension)
	$(LI $(BUGZILLA 2250): Update of user32.lib and kernel32.lib)
	$(LI $(BUGZILLA 2254): Size of executable almost triples)
	$(LI $(BUGZILLA 2258): Docs -> Inline Assembler -> Operand Types -> qword missing)
	$(LI $(BUGZILLA 2259): Assertion failure: '0' on line 122 in file 'statement.c')
	$(LI $(BUGZILLA 2269): D BUG: cosine of complex)
	$(LI $(BUGZILLA 2272): synchronized attribute documentation)
	$(LI $(BUGZILLA 2273): Whitespace is not inserted after commas)
    )
)

$(VERSION 033, Jul 11, 2008, =================================================,

    $(WHATSNEW
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 870): contradictory error messages for templates)
	$(LI $(BUGZILLA 2207): overload resolution fails with deprecation)
	$(LI $(BUGZILLA 2208): Deprecated function declarations cannot use deprecated types)
	$(LI $(BUGZILLA 2209): Typo in doc for offsetof)
    )
)

$(VERSION 032, Jul 9, 2008, =================================================,

    $(WHATSNEW
	$(LI Added $(B .__vptr) and $(B .__monitor) properties for class objects
	 for use in the internal runtime library.
	)
    )
    $(BUGSFIXED
	$(LI $(NG_digitalmars_D_announce 12322): mixin regression)
	$(LI $(BUGZILLA 203): std.format.doFormat() pads width incorrectly on Unicode strings)
	$(LI $(BUGZILLA 211): Linking error with alias mixin params and anonymous methods)
	$(LI $(BUGZILLA 224): Incorrect warning "no return at end of function")
	$(LI $(BUGZILLA 252): -w and switch returns = bogus "no return at end of function" warning)
	$(LI $(BUGZILLA 253): Invalid &lt;dl&gt; tag generated by Ddoc)
	$(LI $(BUGZILLA 294): DDoc: Function templates get double and incomplete documentation)
	$(LI $(BUGZILLA 398): No way to abort compilation in a doubly recursive mixin)
	$(LI $(BUGZILLA 423): dmd ignores empty commandline arguments)
	$(LI $(BUGZILLA 515): Spec incorrect in where .offsetof can be applied)
	$(LI $(BUGZILLA 520): Invariants allowed to call public functions)
	$(LI $(BUGZILLA 542): Function parameter of a deprecated type (other than a class) is not caught)
	$(LI $(BUGZILLA 543): Function return of a deprecated type is not caught)
	$(LI $(BUGZILLA 544): Variable declared of a deprecated type (other than a class) is not caught)
	$(LI $(BUGZILLA 545): Attempt to access a static built-in property of a deprecated struct, union, enum or typedef is not caught)
	$(LI $(BUGZILLA 547): Accessing a deprecated member variable through an explicit object reference is not caught)
	$(LI $(BUGZILLA 548): Accessing a value of a deprecated enum is not caught)
	$(LI $(BUGZILLA 566): Adding non-static members and functions to classes using a template doesn't error)
	$(LI $(BUGZILLA 570): Bogus recursive mixin error)
	$(LI $(BUGZILLA 571): class instance member template returns strange value)
	$(LI $(BUGZILLA 572): parse error when using template instantiation with typeof)
	$(LI $(BUGZILLA 581): Error message w/o line number in dot-instantiated template)
	$(LI $(BUGZILLA 617): IFTI doesn't use normal promotion rules for non-template parameters)
	$(LI $(BUGZILLA 951): Missing line number: no constructor provided for a class derived from a class with no default constructor)
	$(LI $(BUGZILLA 1097): Missing line number: casting array to array of different element size)
	$(LI $(BUGZILLA 1158): Missing line number: invalid mixin outside function scope)
	$(LI $(BUGZILLA 1176): Error missing file and line number)
	$(LI $(BUGZILLA 1187): Segfault with syntax error in two-level mixin.)
	$(LI $(BUGZILLA 1194): fcmov* emmits incorrect code)
	$(LI $(BUGZILLA 1207): Documentation on destructors is confusing)
	$(LI $(BUGZILLA 1341): typeof(int) should probably be legal)
	$(LI $(BUGZILLA 1601): shr and shl error message is missing line numbers)
	$(LI $(BUGZILLA 1612): No file/line number for using an undefined label in inline assembly)
	$(LI $(BUGZILLA 1907): Error message without a line number)
	$(LI $(BUGZILLA 1912): Error without line number (Tuple, invalid value argument))
	$(LI $(BUGZILLA 1936): Error with no line number (array dimension overflow))
	$(LI $(BUGZILLA 2161): Modify compiler to pass array TypeInfo to _adEq and _adCmp instead of element TypeInfo)
	$(LI $(BUGZILLA 2166): More stuff that doesn't compile in Phobos)
	$(LI $(BUGZILLA 2178): 3 errors without line number: typeof)
    )
)

$(VERSION 031, June 18, 2008, =================================================,

    $(WHATSNEW
	$(LI Added $(LINK2 version.html#PredefinedVersions, version identifier
	 $(B D_PIC)) when $(B -fPIC) switch is used.)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 1383): Implicit Function Instantiation with typesafe-variadic of delegates doesn't work)
	$(LI $(BUGZILLA 1559): version statement makes code outside of it disappear)
	$(LI $(BUGZILLA 1675): "Identifier too long" error with OMF object files)
	$(LI $(BUGZILLA 1963): -H creates broken headers)
	$(LI $(BUGZILLA 2111): Protection incorrectly resolved when accessing super class' tupleof)
	$(LI $(BUGZILLA 2118): Inconsistent use of string vs invariant(char[]) in doc)
	$(LI $(BUGZILLA 2123): Anonymous class crashes)
	$(LI $(BUGZILLA 2132): CTFE: can't evaluate ~= at compile time, D2 only.)
	$(LI $(BUGZILLA 2136): typeof(super(...)) counted as a constructor call)
	$(LI $(BUGZILLA 2140): static if as final statement with no code causes containing code to be skipped)
	$(LI $(BUGZILLA 2143): Mixed-in identifier is not recognized by static if)
	$(LI $(BUGZILLA 2144): 'is' is defined to be the same as '==' for non-class and non-array types, but does not call opEquals)
	$(LI $(BUGZILLA 2146): Multiple execution of 'static this' defined in template)
	$(LI $(BUGZILLA 2149): Auto variables loose the keyword "auto" in di files generated with -H option.)
    )
)

$(VERSION 030, May 16, 2008, =================================================,

    $(WHATSNEW
	$(LI Added $(B -lib) switch to generate library files.)
	$(LI Added $(B -man) switch to browse manual.)
	$(LI When generating an executable file, only one object file
	 is now generated containing all the modules that were compiled, rather
	 than one object file per module.)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 2031): Documentation: template value parameters)
	$(LI $(BUGZILLA 2032): Documentation for creating a class on the stack is unintuitive)
	$(LI $(BUGZILLA 2033): -g + circular refs =&gt; dmd hangs)
	$(LI $(BUGZILLA 2039): -ignore switch is missing from compiler docs)
	$(LI $(BUGZILLA 2044): -g hangs DMD)
	$(LI $(BUGZILLA 2055): (ICE) Compiler crash on struct initializer with too many elements)
	$(LI $(BUGZILLA 2058): Describe hidden value passed to class member functions)
	$(LI $(BUGZILLA 2067): call from anonymous class makes access violation.)
	$(LI $(BUGZILLA 2071): spec doesn't mention pointer arithmetic with two pointer operands)
	$(LI $(BUGZILLA 2075): Spec does not specify how array literals are stored.)
	$(LI $(BUGZILLA 2084): operator ?: does not compute the tightest type)
	$(LI $(BUGZILLA 2086): Describe relationship between string and char[] more explicitly)
	$(LI $(BUGZILLA 2089): Issues with CTFE and tuple indexes)
	$(LI $(BUGZILLA 2090): Cannot alias a tuple member which is a template instance)
    )
)

$(VERSION 029, Apr 23, 2008, =================================================,

    $(WHATSNEW
	$(LI Added $(B -ignore) switch to ignore unsupported pragmas.)
	$(LI Unsupported pragmas now printed out with $(B -v) switch.)
	$(LI Incorporated Benjamin Shropshire's doc changes)
    )
    $(BUGSFIXED
	$(LI $(BUGZILLA 1712): vtbl[0] for interface not set to corresponding Interface*)
	$(LI $(BUGZILLA 1741): crash on associative array with static array as index type)
	$(LI $(BUGZILLA 1905): foreach docs inconsistency)
	$(LI $(BUGZILLA 1906): foreach cannot use index with large arrays)
	$(LI $(BUGZILLA 1908): fix closure14.d)
	$(LI $(BUGZILLA 1935): The std.recls samples in the DMD .zip are obsolete.)
	$(LI $(BUGZILLA 1967): getDirName does not seem to use altsep on windows)
	$(LI $(BUGZILLA 1978): Wrong vtable call)
	$(LI $(BUGZILLA 1991): Dmd hangs)
	$(LI $(BUGZILLA 2019): Appending a one-element array literal doesn't work)
    )
)

$(VERSION 028, Mar 6, 2008, =================================================,

$(WHATSNEW
	$(LI Added compile time error for comparing class types against $(CODE null).)
)

$(BUGSFIXED
	$(LI Fixed dwarf bug with DT_AT_upper_bound)
	$(LI $(BUGZILLA 756): IFTI for tuples only works if tuple parameter is last)
	$(LI $(BUGZILLA 1454): IFTI cant  deduce parameter if alias argument used)
	$(LI $(BUGZILLA 1661): Not possible to specialize on template with integer parameter)
	$(LI $(BUGZILLA 1809): template.c:2600)
	$(LI $(BUGZILLA 1810): MmFile anonymous mapping does not work under win32)
	$(LI $(BUGZILLA 1819): spurious warning about missing return statement after synchronized)
	$(LI $(BUGZILLA 1828): Several Thread Issues)
	$(LI $(BUGZILLA 1833): std.c.windows.windows should use enums for constants, or be more selective about use of extern(Windows))
	$(LI $(BUGZILLA 1836): Inline assembler can't use enum values as parameters.)
	$(LI $(BUGZILLA 1837): Make dmd stop flooding the console: prints content of passed parameter file)
	$(LI $(BUGZILLA 1843): Bogus unreachable statement on forward referenced struct, lacks line number)
	$(LI $(BUGZILLA 1850): The compiler accepts lower case asm registers.)
	$(LI $(BUGZILLA 1852): you get opCall missing when cast to a struct(diagnostic))
	$(LI $(BUGZILLA 1853): opCmp documentation really needs some examples)
	$(LI $(BUGZILLA 1857): Runtime segfault while profileing - jump to invalid code address)
	$(LI $(BUGZILLA 1862): asm: [ESI+1*EAX] should be a legal addr mode)
	$(LI $(BUGZILLA 1864): Variable incorrectly declared final in final class template)
	$(LI $(BUGZILLA 1865): Escape sequences are flawed.)
	$(LI $(BUGZILLA 1877): Errors in the documentation of std.math.atan2)
	$(LI $(BUGZILLA 1879): Compiler segfaults on 'scope' and 'static if')
	$(LI $(BUGZILLA 1882): Internal error: ..\ztc\cod1.c 2529)
)
)


$(VERSION 027, Feb 18, 2008, =================================================,

$(WHATSNEW
	$(LI Re-enabled auto interfaces.)
)

$(BUGSFIXED
	$(LI Fixed display of ddoc template parameters that were aliased)
	$(LI $(BUGZILLA 1072): CTFE: crash on for loop with blank increment)
	$(LI $(BUGZILLA 1435): DDoc: Don't apply DDOC_PSYMBOL everywhere)
	$(LI $(BUGZILLA 1825): local instantiation and function nesting)
	$(LI $(BUGZILLA 1837): Make dmd stop flooding the console: prints content of passed parameter file)
	$(LI $(BUGZILLA 1842): Useless linker command line output during compilation on Linux)
)
)

$(VERSION 026, Jan 20, 2008, =================================================,

$(WHATSNEW
	$(LI $(CODE WinMain) and $(CODE DllMain) can now be in template mixins.)
)

$(BUGSFIXED
	$(LI $(BUGZILLA 1697): Internal error: ..\ztc\cgcod.c 2322 with -O)
	$(LI $(BUGZILLA 1707): '==' in TemplateParameterList in IsExpression causes segfault)
	$(LI $(BUGZILLA 1711): typeof with delegate literal not allowed as template parameter)
	$(LI $(BUGZILLA 1718): obscure exit with error code 5)
	$(LI $(BUGZILLA 1719): Compiler crash or unstable code generation with scoped interface instances)
	$(LI $(BUGZILLA 1724): Internal error: toir.c 177)
	$(LI $(BUGZILLA 1725): std.stream.BufferedFile.create should use FileMode.OutNew)
	$(LI $(BUGZILLA 1767): rejects-valid, diagnostic)
	$(LI $(BUGZILLA 1769): Typo on the page about exceptions)
	$(LI $(BUGZILLA 1773): excessively long integer literal)
	$(LI $(BUGZILLA 1779): Compiler crash when deducing more than 2 type args)
	$(LI $(BUGZILLA 1783): DMD 1.025 asserts on code with struct, template, and alias)
	$(LI $(BUGZILLA 1788): dmd segfaults without info)
)
)


$(VERSION 025, Jan 1, 2008, =================================================,

$(BUGSFIXED
	$(LI $(BUGZILLA 1111): enum value referred to by another value of same enum is considered as enum's base type, not enum type)
	$(LI $(BUGZILLA 1720): std.math.NotImplemented missing a space in message)
	$(LI $(BUGZILLA 1738): Error on struct without line number)
	$(LI $(BUGZILLA 1742): CTFE fails on some template functions)
	$(LI $(BUGZILLA 1743): interpret.c:1421 assertion failure on CTFE code)
	$(LI $(BUGZILLA 1744): CTFE: crash on assigning void-returning function to variable)
	$(LI $(BUGZILLA 1749): std.socket not thread-safe due to strerror)
	$(LI $(BUGZILLA 1753): String corruption in recursive CTFE functions)
)
)


$(VERSION 024, Nov 27, 2007, =================================================,

$(WHATSNEW
	$(LI Changed the way coverage analysis is done so it is independent
	 of order dependencies among modules.)
)

$(BUGSFIXED
	$(LI $(BUGZILLA 70): valgrind: Conditional jump or move depends on uninitialised value(s) in elf_findstr)
	$(LI $(BUGZILLA 71): valgrind: Invalid read of size 4 in elf_renumbersyms)
	$(LI $(BUGZILLA 204): Error message on attempting to instantiate an abstract class needs to be improved)
	$(LI $(BUGZILLA 1508): dmd/linux template symbol issues)
	$(LI $(BUGZILLA 1656): illegal declaration accepted)
	$(LI $(BUGZILLA 1664): (1.23).stringof  generates bad code)
	$(LI $(BUGZILLA 1665): Internal error: ..\ztc\cod2.c 411)
)
)


$(VERSION 023, Oct 31, 2007, =================================================,

$(WHATSNEW
	$(LI Data items in static data segment &gt;= 16 bytes in size
	are now paragraph aligned.)
)

$(BUGSFIXED
	$(LI $(BUGZILLA 318): wait does not release thread resources on Linux)
	$(LI $(BUGZILLA 322): Spawning threads which allocate and free memory leads to pause error on collect)
	$(LI $(BUGZILLA 645): Race condition in std.thread.Thread.pauseAll)
	$(LI $(BUGZILLA 689): Clean up the spec printfs!)
	$(LI $(BUGZILLA 697): No const folding on asm db,dw, etc)
	$(LI $(BUGZILLA 706): incorrect type deduction for array literals in functions)
	$(LI $(BUGZILLA 708): inline assembler: "CVTPS2PI mm, xmm/m128" fails to compile)
	$(LI $(BUGZILLA 709): inline assembler: "CVTPD2PI mm, xmm/m128" fails to compile)
	$(LI $(BUGZILLA 718): Internal error: ../ztc/cgcod.c 562)
	$(LI $(BUGZILLA 723): bad mixin of class definitions at function level: func.c:535: virtual void FuncDeclaration::semantic3(Scope*): Assertion `0' failed)
	$(LI $(BUGZILLA 725): expression.c:6516: virtual Expression* MinAssignExp::semantic(Scope*): Assertion `e2->type->isfloating()' failed.)
	$(LI $(BUGZILLA 726): incorrect error line for "override" mixin)
	$(LI $(BUGZILLA 729): scope(...) statement in SwitchBody causes compiler to segfault)
	$(LI $(BUGZILLA 733): std.conv.toFloat does not catch errors)
	$(LI $(BUGZILLA 1258): Garbage collector loses memory upon array concatenation)
	$(LI $(BUGZILLA 1478): Avoid libc network api threadsafety issues)
	$(LI $(BUGZILLA 1480): std.stream throws the new override warning all over the place)
	$(LI $(BUGZILLA 1483): Errors in threads not directed to stderr)
	$(LI $(BUGZILLA 1491): Suppress SIGPIPE when sending to a dead socket)
	$(LI $(BUGZILLA 1557): std.zlib allocates void[]s instead of ubyte[]s, causing leaks.)
	$(LI $(BUGZILLA 1562): Deduction of template alias parameter fails)
	$(LI $(BUGZILLA 1575): Cannot do assignment of tuples)
	$(LI $(BUGZILLA 1593): ICE compiler crash empty return statement in function)
	$(LI $(BUGZILLA 1613): DMD hangs on syntax error)
	$(LI $(BUGZILLA 1618): Typo in std\system.d)
)
)

$(VERSION 022, Oct 1, 2007, =================================================,

$(BUGSFIXED
	$(LI Fix std.boxer boxing of Object's (unit test failure))
	$(LI Fix std.demangle to not show hidden parameters (this and delegate context pointers))
	$(LI $(BUGZILLA 217): typeof not working properly in internal/object.d)
	$(LI $(BUGZILLA 218): Clean up old code for packed bit array support)
	$(LI $(BUGZILLA 223): Error message for unset constants doesn't specify error location)
	$(LI $(BUGZILLA 278): dmd.conf search path doesn't work)
	$(LI $(BUGZILLA 479): can't compare arrayliteral statically with string)
	$(LI $(BUGZILLA 549): A class derived from a deprecated class is not caught)
	$(LI $(BUGZILLA 550): Shifting by more bits than size of quantity is allowed)
	$(LI $(BUGZILLA 551): Modulo operator works with imaginary and complex operands)
	$(LI $(BUGZILLA 556): is (Type Identifier : TypeSpecialization) doesn't work as it should)
	$(LI $(BUGZILLA 668): Use of *.di files breaks the order of static module construction)
	$(LI $(BUGZILLA 1125): Segfault using tuple in asm code, when size not specified)
	$(LI $(BUGZILLA 1437): dmd crash: "Internal error: ..\ztc\cod4.c 357")
	$(LI $(BUGZILLA 1474): regression: const struct with an initializer not recognized as a valid alias template param)
	$(LI $(BUGZILLA 1484): Forward reference of enum member crashes DMD)
	$(LI $(BUGZILLA 1488): Bad code generation when using tuple from asm)
	$(LI $(BUGZILLA 1510): ICE: Assertion failure: 'ad' on line 925 in file 'func.c')
	$(LI $(BUGZILLA 1523): struct literals not work with typedef)
	$(LI $(BUGZILLA 1531): cannot access typedef'd class field)
	$(LI $(BUGZILLA 1537): Internal error: ..\ztc\cgcod.c 1521)
	$(LI $(BUGZILLA 1609): TypeInfo_Typedef has incorrect implementation of next())
)
)

$(VERSION 021, Sep 5, 2007, =================================================,

$(WHATSNEW
	$(LI Added command line switches $(B -defaultlib) and $(B -debuglib))
	$(LI $(BUGZILLA 1445): Add default library options to sc.ini / dmd.conf)
	$(LI Added trace_term() to object.d to fix $(BUGZILLA 971): No profiling output is generated if the application terminates with exit)
	$(LI Multiple module static constructors/destructors allowed.)
)

$(BUGSFIXED
	$(LI $(BUGZILLA 961): std.windows.registry stack corruption)
	$(LI $(BUGZILLA 1315): CTFE doesn't default initialise arrays of structs)
	$(LI $(BUGZILLA 1363): Compile-time issue with structs in 'for')
	$(LI $(BUGZILLA 1375): CTFE fails for null arrays)
	$(LI $(BUGZILLA 1378): A function call in an array literal causes compiler to crash)
	$(LI $(BUGZILLA 1384): Compiler segfaults when using struct variable like a function with no opCall member.)
	$(LI $(BUGZILLA 1388): multiple static constructors allowed in module)
	$(LI $(BUGZILLA 1414): compiler crashes with CTFE and structs)
	$(LI $(BUGZILLA 1423): Registry: corrupted value)
	$(LI $(BUGZILLA 1436): std.date.getLocalTZA() returns wrong values when in DST under Windows)
	$(LI $(BUGZILLA 1447): CTFE does not work for static member functions of a class)
	$(LI $(BUGZILLA 1448): UTF-8 output to console is seriously broken)
	$(LI $(BUGZILLA 1450): Registry: invalid UTF-8 sequence)
	$(LI $(BUGZILLA 1460): Compiler crash on valid code)
	$(LI $(BUGZILLA 1464): "static" foreach breaks CTFE)
)
)

$(VERSION 020, Jul 23, 2007, =================================================,

$(BUGSFIXED
	$(LI Fixed $(B extern (System)))
)
)

$(VERSION 019, Jul 21, 2007, =================================================,

$(WHATSNEW
	$(LI Added 0x78 Codeview extension for type $(B dchar).)
	$(LI Added $(B extern (System)))
	$(LI $(BUGZILLA 345): updated std.uni.isUniAlpha to Unicode 5.0.0)
)

$(BUGSFIXED
	$(LI $(BUGZILLA 46): Included man files should be updated)
	$(LI $(BUGZILLA 268): Bug with SocketSet and classes)
	$(LI $(BUGZILLA 406): std.loader is broken on linux)
	$(LI $(BUGZILLA 561): Incorrect duplicate error message when trying to create instance of interface)
	$(LI $(BUGZILLA 588): lazy argument and nested symbol support to std.demangle)
	$(LI $(BUGZILLA 668): Use of *.di files breaks the order of static module construction)
	$(LI $(BUGZILLA 1110): std.format.doFormat + struct without toString() == crash)
	$(LI $(BUGZILLA 1199): Strange error messages when indexing empty arrays or strings at compile time)
	$(LI $(BUGZILLA 1300): Issues with struct in compile-time function)
	$(LI $(BUGZILLA 1306): extern (Windows) should work like extern (C) for variables)
	$(LI $(BUGZILLA 1331): header file genaration generates a ":" instead of ";" at pragma)
	$(LI $(BUGZILLA 1332): Internal error: ../ztc/cod4.c 357)
	$(LI $(BUGZILLA 1333): -inline ICE: passing an array element to an inner class's constructor in a nested function, all in a class or struct)
	$(LI $(BUGZILLA 1336): Internal error when trying to construct a class declared within a unittest from a templated class.)
)
)

$(VERSION 018, Jul 1, 2007, =================================================,

$(BUGSFIXED
	$(LI $(BUGZILLA 540): Nested template member function error - "function expected before ()")
	$(LI $(BUGZILLA 559): Final has no effect on methods)
	$(LI $(BUGZILLA 627): Concatenation of strings to string arrays with ~ corrupts data)
	$(LI $(BUGZILLA 629): Misleading error message "Can only append to dynamic arrays")
	$(LI $(BUGZILLA 639): Escaped tuple parameter ICEs dmd)
	$(LI $(BUGZILLA 641): Complex string operations in template argument ICEs dmd)
	$(LI $(BUGZILLA 657): version(): ignored)
	$(LI $(BUGZILLA 689): Clean up the spec printfs!)
	$(LI $(BUGZILLA 1103): metastrings.ToString fails for long &gt; 0xFFFF_FFFF)
	$(LI $(BUGZILLA 1107): CodeView: wrong CV type for bool)
	$(LI $(BUGZILLA 1118): weird switch statement behaviour)
	$(LI $(BUGZILLA 1186): Bind needs a small fix)
	$(LI $(BUGZILLA 1199): Strange error messages when indexing empty arrays or strings at compile time)
	$(LI $(BUGZILLA 1200): DMD crash: some statements containing only a ConditionalStatement with a false condition)
	$(LI $(BUGZILLA 1203): Cannot create Anonclass in loop)
	$(LI $(BUGZILLA 1204): segfault using struct in CTFE)
	$(LI $(BUGZILLA 1206): Compiler hangs on this() after method in class that forward references struct)
	$(LI $(BUGZILLA 1207): Documentation on destructors is confusing)
	$(LI $(BUGZILLA 1211): mixin("__LINE__") gives incorrect value)
	$(LI $(BUGZILLA 1212): dmd generates bad line info)
	$(LI $(BUGZILLA 1216): Concatenation gives 'non-constant expression' outside CTFE)
	$(LI $(BUGZILLA 1217): Dollar ($) seen as non-constant expression in non-char[] array)
	$(LI $(BUGZILLA 1219): long.max.stringof gets corrupted)
	$(LI $(BUGZILLA 1224): Compilation does not stop on asserts during CTFE)
	$(LI $(BUGZILLA 1228): Class invariants should not be called before the object is fully constructed)
	$(LI $(BUGZILLA 1233): std.string.ifind(char[] s, char[] sub) fails on certain non ascii strings)
	$(LI $(BUGZILLA 1234): Occurrence is misspelled almost everywhere)
	$(LI $(BUGZILLA 1235): std.string.tolower() fails on certain utf8 characters)
	$(LI $(BUGZILLA 1236): Grammar for Floating Literals is incomplete)
	$(LI $(BUGZILLA 1239): ICE when empty tuple is passed to variadic template function)
	$(LI $(BUGZILLA 1242): DMD AV)
	$(LI $(BUGZILLA 1244): Type of array length is unspecified)
	$(LI $(BUGZILLA 1247): No time zone info for India)
	$(LI $(BUGZILLA 1285): Exception typedefs not distinguished by catch)
	$(LI $(BUGZILLA 1287): Iterating over an array of tuples causes "glue.c:710: virtual unsigned int Type::totym(): Assertion `0' failed.")
	$(LI $(BUGZILLA 1290): Two ICEs, both involving real, imaginary, ? : and +=.)
	$(LI $(BUGZILLA 1291): .stringof for a class type returned from a template doesn't work)
	$(LI $(BUGZILLA 1292): Template argument deduction doesn't work)
	$(LI $(BUGZILLA 1294): referencing fields in static arrays of structs passed as arguments generates invalid code)
	$(LI $(BUGZILLA 1295): Some minor errors in the lexer grammar)
)
)

$(VERSION 017, Jun 25, 2007, =================================================,

$(WHATSNEW
	$(LI Added $(B __VENDOR__) and $(B __VERSION__).)
	$(LI The $(B .init) property for a variable is now based on its
	type, not its initializer.)
)

$(BUGSFIXED
	$(LI $(B std.compiler) now is automatically updated.)
	$(LI Fixed CFTE bug with e++ and e--.)
	$(LI $(BUGZILLA 1254): Using a parameter initialized to void in a compile-time evaluated function doesn't work)
	$(LI $(BUGZILLA 1256): "with" statement with symbol)
	$(LI $(BUGZILLA 1259): Inline build triggers an illegal error msg "Error: S() is not an lvalue")
	$(LI $(BUGZILLA 1260): Another tuple bug)
	$(LI $(BUGZILLA 1261): Regression from overzealous error message)
	$(LI $(BUGZILLA 1262): Local variable of struct type initialized by literal resets when compared to .init)
	$(LI $(BUGZILLA 1263): Template function overload fails when overloading on both template and non-template class)
	$(LI $(BUGZILLA 1268): Struct literals try to initialize static arrays of non-static structs incorrectly)
	$(LI $(BUGZILLA 1269): Compiler crash on assigning to an element of a void-initialized array in CTFE)
	$(LI $(BUGZILLA 1270): -inline produces an ICE)
	$(LI $(BUGZILLA 1272): problems with the new 1.0 section)
	$(LI $(BUGZILLA 1276): static assert message displayed with escaped characters)
	$(LI $(BUGZILLA 1283): writefln: formatter applies to following variable)
)
)

$(VERSION 016, Jun 14, 2007, =================================================,

$(WHATSNEW
	$(LI The compiler was not changed.)
	$(LI Added aliases $(B string), $(B wstring), and $(B dstring) to ease
	compatiblity with 2.0.)
)

$(BUGSFIXED
)
)

$(VERSION 015, Jun 5, 2007, =================================================,

$(BUGSFIXED
	$(LI Added missing \n to exception message going to stderr.)
	$(LI Fixed default struct initialization for CTFE.)
	$(LI $(BUGZILLA 1226): ICE on a struct literal)
	$(LI Fixed gc memory corrupting problem.)
)
)

$(VERSION 014, Apr 26, 2007, =================================================,

$(WHATSNEW
	$(LI Added $(LINK2 expression.html#AssocArrayLiteral, associative array literals))
	$(LI Added struct literals)
	$(LI Array element assignments can now be done in CTFE)
)

$(BUGSFIXED
	$(LI $(BUGZILLA 1000): writefln fails on nested arrays)
	$(LI $(BUGZILLA 1143): Assertion failure: '0' on line 850 in 'template.c' - On specialization of IFTI template parameters.)
	$(LI $(BUGZILLA 1144): template mixin causes DMD crash)
	$(LI $(BUGZILLA 1146): mixin + assert() crashes compiler)
	$(LI $(BUGZILLA 1153): dmd assertion failure)
	$(LI $(BUGZILLA 1159): Various mixins cause "CompileExp::semantic" message, some crash DMD)
	$(LI $(BUGZILLA 1174): Program hangs creating an array of enums with nonzero initializer)
	$(LI $(BUGZILLA 1177): $(DOLLAR) no longer works inside CTFE functions.)
	$(LI $(BUGZILLA 1180): the GC failes to handle large allocation requests propperly)
	$(LI $(BUGZILLA 1189): Reverse the titles on web pages)
)
)

$(VERSION 013, Apr 19, 2007, =================================================,

$(BUGSFIXED
	$(LI Fixed crash with std.format and static arrrays)
	$(LI $(BUGZILLA 582): Cannot slice mixed tuples)
	$(LI $(BUGZILLA 594): can't cast arrayliteral statically)
	$(LI $(BUGZILLA 595): can't append to array/arrayliteral statically)
	$(LI $(BUGZILLA 997): [Regression] Struct-returning function that conditionally passes the result of another function straight through doesn't work (NRVO bug?))
	$(LI $(BUGZILLA 1090): Attribute specification: "}" vs "end of scope")
	$(LI $(BUGZILLA 1091): Wrong size reserved for critical sections)
	$(LI $(BUGZILLA 1094): switch bug)
	$(LI $(BUGZILLA 1096): Mysterious hang with toUTCString + UTCtoLocalTime + d_time_nan)
	$(LI $(BUGZILLA 1098): symbol collision in d/dmd/expression.c between math.h and port.h)
	$(LI $(BUGZILLA 1119): Internal error: ../ztc/cgcod.c 2190 (template instantiation))
	$(LI $(BUGZILLA 1121): Assertion codegen issue with templated function)
	$(LI $(BUGZILLA 1132): DMD calling linker over commandline)
	$(LI $(BUGZILLA 1134): incorrect calling convention used)
	$(LI $(BUGZILLA 1135): invariant keyword parsing is messed up)
	$(LI $(BUGZILLA 1147): Typo in phobos/std/file.d: 4069 should be 4096)
	$(LI $(BUGZILLA 1148): Problems returning structs from functions)
	$(LI $(BUGZILLA 1150): Compiler creates wrong code)
	$(LI $(BUGZILLA 1156): Installed libraries need to be passed in different order)
	$(LI $(BUGZILLA 1163): Can't initialize multiple variables with void.)
)
)

$(VERSION 012, Apr 12, 2007, =================================================,

$(BUGSFIXED
	$(LI $(NG_digitalmars_D_announce 8190) now works with $(B -v1))
	$(LI $(NG_digitalmars_D_announce 8193))
	$(LI $(BUGZILLA 532): Wrong name mangling for template alias params of local vars)
	$(LI $(BUGZILLA 1068): stack corruption with mixins and function templates)
	$(LI $(BUGZILLA 1089): Unsafe pointer comparison in TypeInfo_Pointer.compare)
	$(LI $(BUGZILLA 1127): -v1 doesn't disable the ref and macro keywords)
)
)

$(VERSION 011, Apr 11, 2007, =================================================,

$(WHATSNEW
	$(LI Extended $(LINK2 abi.html#codeview, Codeview)
	symbolic debug output with LF_OEM types.)
	$(LI Extended $(LINK2 abi.html#dwarf, Dwarf)
	symbolic debug output with DW_TAG_darray_type,
	DW_TAG_aarray_type, and DW_TAG_delegate types.)
	$(LI Added keywords $(B ref) and $(B macro).)
	$(LI $(B final) classes cannot be subclassed.)
	$(LI $(B final) for variables now works.)
	$(LI $(B ref) now works as a replacement for $(B inout).)
	$(LI Fixed so multiple type inferring declarations like
	$(CODE auto a=1,c=2;) works.)
)

$(BUGSFIXED
	$(LI Fixed problem with overloading of function templates that
	have the same template parameter list, but different function
	parameters.)
	$(LI Fixed problems with type deduction from specializations that
	are template instances.)
	$(LI Fixed assert template.c(2956) s->parent)
	$(LI Got .$(I property) to work for typeof.)
	$(LI Fixed bug in DW_AT_comp_dir output for some linux versions.)
	$(LI $(NG_digitalmars_D_announce 8027))
	$(LI $(NG_digitalmars_D_announce 8047))
	$(LI $(NG_digitalmars_D 51800))
	$(LI $(BUGZILLA 1028): Segfault using tuple inside asm code.)
	$(LI $(BUGZILLA 1052): DMD 1.009 - aliasing functions from superclasses may result in incorrect conflicts)
	$(LI $(BUGZILLA 1080): Failed to link to std.windows.registry)
	$(LI $(BUGZILLA 1081): with using real and -O option, dmd generate bug code)
	$(LI $(BUGZILLA 1082): The .offsetof property yields a signed int, a size_t would be more appropriate)
	$(LI $(BUGZILLA 1086): CodeView: missing line information for string switch)
	$(LI $(BUGZILLA 1092): compiler crash in ..\ztc\cod1.c 2528)
	$(LI $(BUGZILLA 1102): switch case couldn't contain template member)
	$(LI $(BUGZILLA 1108): Indexing an int[] not evaluatable at compile time)
	$(LI $(BUGZILLA 1122): dmd generate bad line number while reporting error message)
)
)

$(VERSION 010, Mar 24, 2007, =================================================,

$(WHATSNEW
	$(LI Added template partial specialization derived from multiple
	parameters.)
	$(LI Added Object.factory(char[] classname) method to create
	class objects based on a string.)
	$(LI Added std.gc.malloc(), std.gc.extend() and std.gc.capacity().)
	$(LI Added std.string.isEmail() and std.string.isURL().)
	$(LI Added std.stdio.readln().)
	$(LI Improved gc performance for array resize and append.)
	$(LI $(BUGZILLA 64): Unhandled errors should go to stderr)
	$(LI Added predefined Ddoc macro DOCFILENAME)
)

$(BUGSFIXED
	$(LI Fixed $(LINK2 http://www.digitalmars.com/d/archives/digitalmars/D/bugs/Broken_link_in_http_digitalmars.com_d_comparison.html_10906.html, Broken link in http://digitalmars.com/d/comparison.html))
	$(LI Fixed problem with CTFE and array literals)
	$(LI $(BUGZILLA 931): D Strings vs C++ Strings Page Incorrect)
	$(LI $(BUGZILLA 935): Extern Global C Variables)
	$(LI $(BUGZILLA 948): operatoroverloading.html - Rationale section is both out of date and incomplete)
	$(LI $(BUGZILLA 950): Missing filename and line number: conflict between implicit length in [...] and explicit length declared in the scope)
	$(LI $(BUGZILLA 959): smaller ddoc documentation issue)
	$(LI $(BUGZILLA 1056): segfault with pragma(msg) inside CTFE)
	$(LI $(BUGZILLA 1062): Cannot catch typedef'd class)
	$(LI $(BUGZILLA 1074): Dead link to std.c.locale webpage)
)
)

$(VERSION 009, Mar 10, 2007, =================================================,

$(BUGSFIXED
	$(LI $(NG_digitalmars_D 49928) 1)
	$(COMMENT $(NG_digitalmars_D_announce 7563))
	$(LI $(LINK2 http://www.digitalmars.com/d/archives/digitalmars/D/announce/DMD_1.007_release_7507.html#N7563, D.announce 7563))
	$(LI $(BUGZILLA 146): Wrong filename in DWARF debugging information for templates)
	$(LI $(BUGZILLA 992): CTFE Failure with static if)
	$(LI $(BUGZILLA 993): incorrect ABI documentation for float parameters)
	$(LI $(BUGZILLA 995): compile-time function return element of Tuple / const array)
	$(LI $(BUGZILLA 1005): dmd: tocsym.c:343: virtual Symbol* FuncDeclaration::toSymbol(): Assertion `0' failed.)
	$(LI $(BUGZILLA 1009): CodeView: out and inout parameters are declared void*)
	$(LI $(BUGZILLA 1014): Error with character literal escaping when generating header with -H)
	$(LI $(BUGZILLA 1016): CTFE fails with recursive functions)
	$(LI $(BUGZILLA 1017): CTFE doesn't support (string == string))
	$(LI $(BUGZILLA 1018): regression: Error: divide by 0)
	$(LI $(BUGZILLA 1019): regression: missing filename and line number: Error: array index X is out of bounds [0 .. Y])
	$(LI $(BUGZILLA 1020): regression: mov EAX, func)
	$(LI $(BUGZILLA 1021): CTFE and functions returning void)
	$(LI $(BUGZILLA 1022): CodeView: unions have zero length in typeleafs and datasymbols)
	$(LI $(BUGZILLA 1026): dmd SEGV when checking length of Tuple elements when length == 0)
	$(LI $(BUGZILLA 1030): ICE one-liner; struct in delegate)
	$(LI $(BUGZILLA 1038): explicit class cast breakage in 1.007)
)
)

$(VERSION 007, Feb 20, 2007, =================================================,

$(WHATSNEW
	$(LI Comparison operators are no longer associative; comparison,
	equality, identity and in operators all have the same precedence.)
	$(LI $(CODE out) and $(CODE inout) parameters are now allowed
	for compile time function execution.)
	$(LI The $(CODE .dup) property is now allowed
	for compile time function execution.)
	$(LI Updated $(LINK2 http://www.digitalmars.com/ctg/lib.html, lib)
	to insert COMDATs into symbol table.)
	$(LI Class references can no longer be implicitly converted to
	$(CODE void*).)
)

$(BUGSFIXED
	$(LI $(NG_digitalmars_D 48806) crash)
	$(LI $(NG_digitalmars_D 48811))
	$(LI $(NG_digitalmars_D 48845))
	$(LI $(NG_digitalmars_D 48869))
	$(LI $(NG_digitalmars_D 48917))
	$(LI $(NG_digitalmars_D 48953))
	$(LI $(NG_digitalmars_D 48990))
	$(LI $(NG_digitalmars_D 49033))
	$(LI $(NG_digitalmars_D_announce 7496))
	$(LI $(BUGZILLA 968): ICE on compile-time execution)
	$(LI $(BUGZILLA 974): compile-time parenthesis bug)
	$(LI $(BUGZILLA 975): compile-time const array makes dmd crash)
	$(LI $(BUGZILLA 980): If a function tries to concatenate a char to a empty array, dmd complains that the function can't be evaluated at compile time)
	$(LI $(BUGZILLA 981): CFTE fails in non-template and functions that takes no args.)
	$(LI $(BUGZILLA 986): Internal error: e2ir.c 1098)
)
)

$(VERSION 006, Feb 15, 2007, =================================================,

$(WHATSNEW
	$(LI Added $(B -J)$(I path) switch, which is now required in
	order to import text files.)
	$(LI Enhanced $(B -v) output to include actual filename.)
	$(LI name string for TypeInfo_Struct now part of the
	TypeInfo_Struct comdat.)
	$(LI $(LINK2 function.html#interpretation, Compile time execution)
	of functions)
)

$(BUGSFIXED
	$(LI $(BUGZILLA 960): New: DMD 1.0 is in the past -- not the future)
	$(LI Codeview for classes now gives correct LF_CLASS)
)
)

$(VERSION 005, Feb 5, 2007, =================================================,

$(WHATSNEW
	$(LI $(B -v) now emits pragma library statements and
	imported file names)
	$(LI deprecated $(B ===), and $(B !==), tokens no longer recognized)
	$(LI $(CODE length) can no longer shadow other $(CODE length) declarations)
	$(LI Added $(LINK2 statement.html#MixinStatement, MixinStatement)s,
	  $(LINK2 expression.html#MixinExpression, MixinExpression)s,
	  and $(LINK2 module.html#MixinDeclaration, MixinDeclaration)s.)
	$(LI Added $(LINK2 expression.html#ImportExpression, ImportExpression)s.)
	$(LI Added $(LINK2 phobos/std_metastrings.html, std.metastrings))
)

$(BUGSFIXED
	$(LI $(BUGZILLA 761): std.format.doFormat fails for items of a char[][] containing %s)
	$(LI $(BUGZILLA 784): regression: [Issue 402] compiler crash with mixin and forward reference)
	$(LI $(BUGZILLA 787): incorrect documentation of std.ctype.isprint)
	$(LI $(BUGZILLA 788): Compiler rejects hex floats in the format: HexPrefix HexDigits . HexDigits(opt) with binary-exponent-part required)
	$(LI $(BUGZILLA 789): const initialization in forwarding constructors doesn't work)
	$(LI $(BUGZILLA 791): dhry.d example doesn't compile in 1.0 without trivial change)
	$(LI $(BUGZILLA 794): std.math.exp2(0) equals 0 instead of 1)
	$(LI $(BUGZILLA 800): writefln() on an associative array fails hard)
	$(LI $(BUGZILLA 821): segfault with char array copy; mistaken samples in doc)
	$(LI $(BUGZILLA 831): Warning!! String literals are read-only one some platforms.)
	$(LI $(BUGZILLA 832): NRVO: return inside foreach results in junk)
	$(LI $(BUGZILLA 835): RegExp.test wrongly matches strings on case insensitive attribute)
	$(LI $(BUGZILLA 846): Error 42: Symbol Undefined _D1a7__arrayZ)
	$(LI $(BUGZILLA 848): typo in C sorting example)
	$(LI $(BUGZILLA 862): Selectively importing a nonexistent identifier results in spurious and incorrect error message)
	$(LI $(BUGZILLA 872): Assertion in expression.c caused by taking typeof of "this.outer" in nested classes.)
	$(LI $(BUGZILLA 875): crash in glue.c line 700)
	$(LI $(BUGZILLA 886): std.zlib uncompression routines do not mark result as containing no pointers)
	$(LI $(BUGZILLA 887): TypeInfo does not correctly override opCmp, toHash)
	$(LI $(BUGZILLA 888): -cov and _ModuleInfo  linking bugs)
	$(LI $(BUGZILLA 890): Returning char[4] and assigning to char[] produces unexpected results.)
	$(LI $(BUGZILLA 891): Crash when compiling the following code (tested with 1.0, 1.001 and 1.002))
	$(LI $(BUGZILLA 893): The profile flag no longer seems to work on Linux x86 64)
	$(LI $(BUGZILLA 894): base class with implemented abstract method problem)
	$(LI $(BUGZILLA 897): fix default dmd.conf file)
	$(LI $(BUGZILLA 898): std.conv.toInt doesn't raise ConvOverflowError)
	$(LI $(BUGZILLA 901): Comparison of array literals fails)
	$(LI $(BUGZILLA 903): Example with printf and string literals crashes)
	$(LI $(BUGZILLA 908): compiler dies trying to inline static method call to nonstatic method in template code.)
	$(LI $(BUGZILLA 910): Error in description of "this" and "super" keywords)
	$(LI $(BUGZILLA 913): deprecated tokens still listed)
	$(LI $(BUGZILLA 915): dmd generate bad form return(retn 4) for invariant func)
	$(LI $(BUGZILLA 916): regression: Internal error: ../ztc/gloop.c 1305)
	$(LI $(BUGZILLA 917): regression: circular typedefs cause segfaults)
	$(LI $(BUGZILLA 924): GC collects valid objects)
	$(LI $(NG_digitalmars_D_announce 6983))
)
)

$(VERSION 004, Jan 26, 2007, =================================================,

$(BUGSFIXED
	$(LI $(BUGZILLA 892): Another bug in the new GC - pointers in mixins)
)
)

$(VERSION 003, Jan 26, 2007, =================================================,

$(BUGSFIXED
	$(LI $(NG_digitalmars_D_announce 6929))
	$(LI $(NG_digitalmars_D_announce 6953))
)
)

$(VERSION 002, Jan 24, 2007, =================================================,

$(BUGSFIXED
	$(LI $(NG_digitalmars_D_announce 6893): ClassInfo.flags incorrectly set)
	$(LI $(NG_digitalmars_D_announce 6906): Three subtle cases of tail recursion item 1 and 2)
)
)

$(VERSION 001, Jan 23, 2007, =================================================,

$(WHATSNEW
	$(LI tail recursion works again)
	$(LI New type aware GC)
)

$(BUGSFIXED
	$(LI $(BUGZILLA 621): When inside a loop, if you call break inside a try block the finally block is never executed)
	$(LI $(BUGZILLA 804): missing linux functions)
	$(LI $(BUGZILLA 815): scope(exit) isn't executed when "continue" is used to continue a while-loop)
	$(LI $(BUGZILLA 817): const char[] = string_literal - string_literal gets included for every reference)
	$(LI $(BUGZILLA 819): mention response files in cmd line usage)
	$(LI $(BUGZILLA 820): gc should scan only pointer types for pointers)
	$(LI $(BUGZILLA 823): frontend: incorrect verror declaration in mars.h)
	$(LI $(BUGZILLA 824): "mov EAX, func;" and "lea EAX, func;" generate incorrect code)
	$(LI $(BUGZILLA 825): dmd segmentation fault with large char[] template value parameter)
	$(LI $(BUGZILLA 826): ICE: is-expression with invalid template instantiation)
)
)

)

Macros:
	TITLE=Change Log
	WIKI=ChangeLog

	NEW1 = $(LI What's new for <a href="#new1_$0">D 1.$0</a>)

	VERSION=
	<div class="version">
	$(B $(LARGE <a name="new1_$1">
	  Version
	  <a HREF="http://ftp.digitalmars.com/dmd.1.$1.zip" title="D 1.$1">D 1.$1</a>
	))
	$(SMALL $(I $2, $3))
	$5
	</div>

	BUGZILLA = <a href="https://d.puremagic.com/issues/show_bug.cgi?id=$0">Bugzilla $0</a>
	CPPBUGZILLA = <a href="http://bugzilla.digitalmars.com/issues/show_bug.cgi?id=$0">Bugzilla $0</a>
	DSTRESS = dstress $0
	BUGSFIXED = <h4>Bugs Fixed</h4> $(UL $0 )
	UPCOMING = <h4>Under Construction</h4> $(OL $0 )
	WHATSNEW = <h4>New/Changed Features</h4> $(UL $0 )
	LARGE=<font size=4>$0</font>

