#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 5000
#define LARGE_STATE_COUNT 1094
#define SYMBOL_COUNT 386
#define ALIAS_COUNT 7
#define TOKEN_COUNT 164
#define EXTERNAL_TOKEN_COUNT 5
#define FIELD_COUNT 47
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 323

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_type = 6,
  anon_sym_EQ = 7,
  anon_sym_as = 8,
  anon_sym_namespace = 9,
  anon_sym_LBRACE = 10,
  anon_sym_COMMA = 11,
  anon_sym_RBRACE = 12,
  anon_sym_typeof = 13,
  anon_sym_import = 14,
  anon_sym_from = 15,
  anon_sym_var = 16,
  anon_sym_let = 17,
  anon_sym_const = 18,
  anon_sym_BANG = 19,
  anon_sym_else = 20,
  anon_sym_if = 21,
  anon_sym_switch = 22,
  anon_sym_for = 23,
  anon_sym_LPAREN = 24,
  anon_sym_RPAREN = 25,
  anon_sym_await = 26,
  anon_sym_in = 27,
  anon_sym_of = 28,
  anon_sym_while = 29,
  anon_sym_do = 30,
  anon_sym_try = 31,
  anon_sym_with = 32,
  anon_sym_break = 33,
  anon_sym_continue = 34,
  anon_sym_debugger = 35,
  anon_sym_return = 36,
  anon_sym_throw = 37,
  anon_sym_SEMI = 38,
  anon_sym_COLON = 39,
  anon_sym_case = 40,
  anon_sym_catch = 41,
  anon_sym_finally = 42,
  anon_sym_yield = 43,
  anon_sym_LBRACK = 44,
  anon_sym_RBRACK = 45,
  anon_sym_LT = 46,
  anon_sym_GT = 47,
  anon_sym_SLASH = 48,
  anon_sym_DOT = 49,
  anon_sym_class = 50,
  anon_sym_async = 51,
  anon_sym_function = 52,
  anon_sym_EQ_GT = 53,
  anon_sym_QMARK_DOT = 54,
  anon_sym_new = 55,
  anon_sym_PLUS_EQ = 56,
  anon_sym_DASH_EQ = 57,
  anon_sym_STAR_EQ = 58,
  anon_sym_SLASH_EQ = 59,
  anon_sym_PERCENT_EQ = 60,
  anon_sym_CARET_EQ = 61,
  anon_sym_AMP_EQ = 62,
  anon_sym_PIPE_EQ = 63,
  anon_sym_GT_GT_EQ = 64,
  anon_sym_GT_GT_GT_EQ = 65,
  anon_sym_LT_LT_EQ = 66,
  anon_sym_STAR_STAR_EQ = 67,
  anon_sym_AMP_AMP_EQ = 68,
  anon_sym_PIPE_PIPE_EQ = 69,
  anon_sym_QMARK_QMARK_EQ = 70,
  anon_sym_DOT_DOT_DOT = 71,
  anon_sym_AMP_AMP = 72,
  anon_sym_PIPE_PIPE = 73,
  anon_sym_GT_GT = 74,
  anon_sym_GT_GT_GT = 75,
  anon_sym_LT_LT = 76,
  anon_sym_AMP = 77,
  anon_sym_CARET = 78,
  anon_sym_PIPE = 79,
  anon_sym_PLUS = 80,
  anon_sym_DASH = 81,
  anon_sym_PERCENT = 82,
  anon_sym_STAR_STAR = 83,
  anon_sym_LT_EQ = 84,
  anon_sym_EQ_EQ = 85,
  anon_sym_EQ_EQ_EQ = 86,
  anon_sym_BANG_EQ = 87,
  anon_sym_BANG_EQ_EQ = 88,
  anon_sym_GT_EQ = 89,
  anon_sym_QMARK_QMARK = 90,
  anon_sym_instanceof = 91,
  anon_sym_TILDE = 92,
  anon_sym_void = 93,
  anon_sym_delete = 94,
  anon_sym_PLUS_PLUS = 95,
  anon_sym_DASH_DASH = 96,
  anon_sym_DQUOTE = 97,
  anon_sym_SQUOTE = 98,
  sym_unescaped_double_string_fragment = 99,
  sym_unescaped_single_string_fragment = 100,
  sym_escape_sequence = 101,
  sym_comment = 102,
  anon_sym_BQUOTE = 103,
  anon_sym_DOLLAR_LBRACE = 104,
  anon_sym_SLASH2 = 105,
  sym_regex_pattern = 106,
  sym_regex_flags = 107,
  sym_number = 108,
  sym_private_property_identifier = 109,
  anon_sym_target = 110,
  sym_this = 111,
  sym_super = 112,
  sym_true = 113,
  sym_false = 114,
  sym_null = 115,
  sym_undefined = 116,
  anon_sym_AT = 117,
  anon_sym_static = 118,
  anon_sym_readonly = 119,
  anon_sym_get = 120,
  anon_sym_set = 121,
  anon_sym_QMARK = 122,
  anon_sym_declare = 123,
  anon_sym_public = 124,
  anon_sym_private = 125,
  anon_sym_protected = 126,
  anon_sym_override = 127,
  anon_sym_module = 128,
  anon_sym_any = 129,
  anon_sym_number = 130,
  anon_sym_boolean = 131,
  anon_sym_string = 132,
  anon_sym_symbol = 133,
  anon_sym_property = 134,
  anon_sym_signal = 135,
  anon_sym_on = 136,
  anon_sym_required = 137,
  anon_sym_component = 138,
  anon_sym_abstract = 139,
  anon_sym_require = 140,
  anon_sym_extends = 141,
  anon_sym_implements = 142,
  anon_sym_global = 143,
  anon_sym_interface = 144,
  anon_sym_enum = 145,
  anon_sym_DASH_QMARK_COLON = 146,
  anon_sym_QMARK_COLON = 147,
  anon_sym_asserts = 148,
  anon_sym_infer = 149,
  anon_sym_is = 150,
  anon_sym_keyof = 151,
  anon_sym_unknown = 152,
  anon_sym_never = 153,
  anon_sym_object = 154,
  anon_sym_LBRACE_PIPE = 155,
  anon_sym_PIPE_RBRACE = 156,
  anon_sym_pragma = 157,
  aux_sym_ui_version_specifier_token1 = 158,
  anon_sym_list = 159,
  sym__automatic_semicolon = 160,
  sym__template_chars = 161,
  sym__ternary_qmark = 162,
  sym__function_signature_automatic_semicolon = 163,
  sym_program = 164,
  sym_export_statement = 165,
  sym_export_clause = 166,
  sym__import_export_specifier = 167,
  sym_declaration = 168,
  sym_import = 169,
  sym_import_statement = 170,
  sym_import_clause = 171,
  sym__from_clause = 172,
  sym_namespace_import_export = 173,
  sym_named_imports = 174,
  sym_expression_statement = 175,
  sym_variable_declaration = 176,
  sym_lexical_declaration = 177,
  sym_variable_declarator = 178,
  sym_statement_block = 179,
  sym_else_clause = 180,
  sym_if_statement = 181,
  sym_switch_statement = 182,
  sym_for_statement = 183,
  sym_for_in_statement = 184,
  sym__for_header = 185,
  sym_while_statement = 186,
  sym_do_statement = 187,
  sym_try_statement = 188,
  sym_with_statement = 189,
  sym_break_statement = 190,
  sym_continue_statement = 191,
  sym_debugger_statement = 192,
  sym_return_statement = 193,
  sym_throw_statement = 194,
  sym_empty_statement = 195,
  sym_labeled_statement = 196,
  sym_switch_body = 197,
  sym_switch_case = 198,
  sym_switch_default = 199,
  sym_catch_clause = 200,
  sym_finally_clause = 201,
  sym_parenthesized_expression = 202,
  sym_expression = 203,
  sym_primary_expression = 204,
  sym_yield_expression = 205,
  sym_object = 206,
  sym_object_pattern = 207,
  sym_assignment_pattern = 208,
  sym_object_assignment_pattern = 209,
  sym_array = 210,
  sym_array_pattern = 211,
  sym_nested_identifier = 212,
  sym_class = 213,
  sym_class_declaration = 214,
  sym_class_heritage = 215,
  sym_function = 216,
  sym_function_declaration = 217,
  sym_generator_function = 218,
  sym_generator_function_declaration = 219,
  sym_arrow_function = 220,
  sym__call_signature = 221,
  sym__formal_parameter = 222,
  sym_call_expression = 223,
  sym_new_expression = 224,
  sym_await_expression = 225,
  sym_member_expression = 226,
  sym_subscript_expression = 227,
  sym_assignment_expression = 228,
  sym__augmented_assignment_lhs = 229,
  sym_augmented_assignment_expression = 230,
  sym__initializer = 231,
  sym__destructuring_pattern = 232,
  sym_spread_element = 233,
  sym_ternary_expression = 234,
  sym_binary_expression = 235,
  sym_unary_expression = 236,
  sym_update_expression = 237,
  sym_sequence_expression = 238,
  sym_string = 239,
  sym_template_string = 240,
  sym_template_substitution = 241,
  sym_regex = 242,
  sym_meta_property = 243,
  sym_arguments = 244,
  sym_decorator = 245,
  sym_decorator_member_expression = 246,
  sym_decorator_call_expression = 247,
  sym_class_body = 248,
  sym_formal_parameters = 249,
  sym_pattern = 250,
  sym_rest_pattern = 251,
  sym_method_definition = 252,
  sym_pair = 253,
  sym_pair_pattern = 254,
  sym__property_name = 255,
  sym_computed_property_name = 256,
  sym_public_field_definition = 257,
  sym_non_null_expression = 258,
  sym_method_signature = 259,
  sym_abstract_method_signature = 260,
  sym_function_signature = 261,
  sym_type_assertion = 262,
  sym_as_expression = 263,
  sym_import_require_clause = 264,
  sym_extends_clause = 265,
  sym_implements_clause = 266,
  sym_ambient_declaration = 267,
  sym_abstract_class_declaration = 268,
  sym_module = 269,
  sym_internal_module = 270,
  sym__module = 271,
  sym_import_alias = 272,
  sym_nested_type_identifier = 273,
  sym_interface_declaration = 274,
  sym_extends_type_clause = 275,
  sym_enum_declaration = 276,
  sym_enum_body = 277,
  sym_enum_assignment = 278,
  sym_type_alias_declaration = 279,
  sym_accessibility_modifier = 280,
  sym_override_modifier = 281,
  sym_required_parameter = 282,
  sym_optional_parameter = 283,
  sym__parameter_name = 284,
  sym_omitting_type_annotation = 285,
  sym_opting_type_annotation = 286,
  sym_type_annotation = 287,
  sym_asserts = 288,
  sym__type = 289,
  sym_tuple_parameter = 290,
  sym_optional_tuple_parameter = 291,
  sym_optional_type = 292,
  sym_rest_type = 293,
  sym__tuple_type_member = 294,
  sym_constructor_type = 295,
  sym__primary_type = 296,
  sym_template_type = 297,
  sym_template_literal_type = 298,
  sym_infer_type = 299,
  sym_conditional_type = 300,
  sym_generic_type = 301,
  sym_type_predicate = 302,
  sym_type_predicate_annotation = 303,
  sym__type_query_member_expression = 304,
  sym__type_query_subscript_expression = 305,
  sym__type_query_call_expression = 306,
  sym_type_query = 307,
  sym_index_type_query = 308,
  sym_lookup_type = 309,
  sym_mapped_type_clause = 310,
  sym_literal_type = 311,
  sym__number = 312,
  sym_existential_type = 313,
  sym_flow_maybe_type = 314,
  sym_parenthesized_type = 315,
  sym_predefined_type = 316,
  sym_type_arguments = 317,
  sym_object_type = 318,
  sym_call_signature = 319,
  sym_property_signature = 320,
  sym_type_parameters = 321,
  sym_type_parameter = 322,
  sym_default_type = 323,
  sym_constraint = 324,
  sym_construct_signature = 325,
  sym_index_signature = 326,
  sym_array_type = 327,
  sym_tuple_type = 328,
  sym_readonly_type = 329,
  sym_union_type = 330,
  sym_intersection_type = 331,
  sym_function_type = 332,
  sym_ui_pragma = 333,
  sym_ui_import = 334,
  sym_ui_version_specifier = 335,
  sym_ui_object_definition = 336,
  sym_ui_annotated_object = 337,
  sym_ui_annotation = 338,
  sym_ui_object_initializer = 339,
  sym_ui_annotated_object_member = 340,
  sym_ui_object_definition_binding = 341,
  sym_ui_binding = 342,
  sym_ui_property = 343,
  sym_ui_list_property_type = 344,
  sym_ui_property_modifier = 345,
  sym_ui_object_array = 346,
  sym_ui_required = 347,
  sym_ui_signal = 348,
  sym_ui_signal_parameters = 349,
  sym_ui_signal_parameter = 350,
  sym_ui_inline_component = 351,
  sym__qml_enum_declaration = 352,
  sym__qml_enum_body = 353,
  sym__qml_enum_assignment = 354,
  sym_ui_nested_identifier = 355,
  aux_sym_program_repeat1 = 356,
  aux_sym_export_statement_repeat1 = 357,
  aux_sym_export_clause_repeat1 = 358,
  aux_sym_named_imports_repeat1 = 359,
  aux_sym_variable_declaration_repeat1 = 360,
  aux_sym_statement_block_repeat1 = 361,
  aux_sym_switch_body_repeat1 = 362,
  aux_sym_object_repeat1 = 363,
  aux_sym_object_pattern_repeat1 = 364,
  aux_sym_array_repeat1 = 365,
  aux_sym_array_pattern_repeat1 = 366,
  aux_sym_string_repeat1 = 367,
  aux_sym_string_repeat2 = 368,
  aux_sym_template_string_repeat1 = 369,
  aux_sym_class_body_repeat1 = 370,
  aux_sym_formal_parameters_repeat1 = 371,
  aux_sym_extends_clause_repeat1 = 372,
  aux_sym_implements_clause_repeat1 = 373,
  aux_sym_extends_type_clause_repeat1 = 374,
  aux_sym_enum_body_repeat1 = 375,
  aux_sym_template_literal_type_repeat1 = 376,
  aux_sym_object_type_repeat1 = 377,
  aux_sym_type_parameters_repeat1 = 378,
  aux_sym_tuple_type_repeat1 = 379,
  aux_sym_ui_annotated_object_repeat1 = 380,
  aux_sym_ui_object_initializer_repeat1 = 381,
  aux_sym_ui_property_repeat1 = 382,
  aux_sym_ui_object_array_repeat1 = 383,
  aux_sym_ui_signal_parameters_repeat1 = 384,
  aux_sym__qml_enum_body_repeat1 = 385,
  alias_sym_import_specifier = 386,
  alias_sym_namespace_export = 387,
  alias_sym_property_identifier = 388,
  alias_sym_shorthand_property_identifier = 389,
  alias_sym_shorthand_property_identifier_pattern = 390,
  alias_sym_statement_identifier = 391,
  alias_sym_this_type = 392,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_as] = "as",
  [anon_sym_namespace] = "namespace",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_typeof] = "typeof",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_BANG] = "!",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_with] = "with",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_SEMI] = ";",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SLASH] = "/",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_new] = "new",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_TILDE] = "~",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [sym_private_property_identifier] = "private_property_identifier",
  [anon_sym_target] = "target",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_readonly] = "readonly",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [anon_sym_QMARK] = "\?",
  [anon_sym_declare] = "declare",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_override] = "override",
  [anon_sym_module] = "module",
  [anon_sym_any] = "any",
  [anon_sym_number] = "number",
  [anon_sym_boolean] = "boolean",
  [anon_sym_string] = "string",
  [anon_sym_symbol] = "symbol",
  [anon_sym_property] = "property",
  [anon_sym_signal] = "signal",
  [anon_sym_on] = "on",
  [anon_sym_required] = "required",
  [anon_sym_component] = "component",
  [anon_sym_abstract] = "abstract",
  [anon_sym_require] = "require",
  [anon_sym_extends] = "extends",
  [anon_sym_implements] = "implements",
  [anon_sym_global] = "global",
  [anon_sym_interface] = "interface",
  [anon_sym_enum] = "enum",
  [anon_sym_DASH_QMARK_COLON] = "-\?:",
  [anon_sym_QMARK_COLON] = "\?:",
  [anon_sym_asserts] = "asserts",
  [anon_sym_infer] = "infer",
  [anon_sym_is] = "is",
  [anon_sym_keyof] = "keyof",
  [anon_sym_unknown] = "unknown",
  [anon_sym_never] = "never",
  [anon_sym_object] = "object",
  [anon_sym_LBRACE_PIPE] = "{|",
  [anon_sym_PIPE_RBRACE] = "|}",
  [anon_sym_pragma] = "pragma",
  [aux_sym_ui_version_specifier_token1] = "number",
  [anon_sym_list] = "type_identifier",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "_template_chars",
  [sym__ternary_qmark] = "\?",
  [sym__function_signature_automatic_semicolon] = "_function_signature_automatic_semicolon",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_export_clause] = "export_clause",
  [sym__import_export_specifier] = "export_specifier",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import_export] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_nested_identifier] = "nested_identifier",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function] = "function",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym__call_signature] = "_call_signature",
  [sym__formal_parameter] = "_formal_parameter",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_formal_parameters] = "formal_parameters",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [sym_public_field_definition] = "public_field_definition",
  [sym_non_null_expression] = "non_null_expression",
  [sym_method_signature] = "method_signature",
  [sym_abstract_method_signature] = "abstract_method_signature",
  [sym_function_signature] = "function_signature",
  [sym_type_assertion] = "type_assertion",
  [sym_as_expression] = "as_expression",
  [sym_import_require_clause] = "import_require_clause",
  [sym_extends_clause] = "extends_clause",
  [sym_implements_clause] = "implements_clause",
  [sym_ambient_declaration] = "ambient_declaration",
  [sym_abstract_class_declaration] = "abstract_class_declaration",
  [sym_module] = "module",
  [sym_internal_module] = "internal_module",
  [sym__module] = "_module",
  [sym_import_alias] = "import_alias",
  [sym_nested_type_identifier] = "nested_type_identifier",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_type_clause] = "extends_type_clause",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_assignment] = "enum_assignment",
  [sym_type_alias_declaration] = "type_alias_declaration",
  [sym_accessibility_modifier] = "accessibility_modifier",
  [sym_override_modifier] = "override_modifier",
  [sym_required_parameter] = "required_parameter",
  [sym_optional_parameter] = "optional_parameter",
  [sym__parameter_name] = "_parameter_name",
  [sym_omitting_type_annotation] = "omitting_type_annotation",
  [sym_opting_type_annotation] = "opting_type_annotation",
  [sym_type_annotation] = "type_annotation",
  [sym_asserts] = "asserts",
  [sym__type] = "_type",
  [sym_tuple_parameter] = "required_parameter",
  [sym_optional_tuple_parameter] = "optional_parameter",
  [sym_optional_type] = "optional_type",
  [sym_rest_type] = "rest_type",
  [sym__tuple_type_member] = "_tuple_type_member",
  [sym_constructor_type] = "constructor_type",
  [sym__primary_type] = "_primary_type",
  [sym_template_type] = "template_type",
  [sym_template_literal_type] = "template_literal_type",
  [sym_infer_type] = "infer_type",
  [sym_conditional_type] = "conditional_type",
  [sym_generic_type] = "generic_type",
  [sym_type_predicate] = "type_predicate",
  [sym_type_predicate_annotation] = "type_predicate_annotation",
  [sym__type_query_member_expression] = "member_expression",
  [sym__type_query_subscript_expression] = "subscript_expression",
  [sym__type_query_call_expression] = "call_expression",
  [sym_type_query] = "type_query",
  [sym_index_type_query] = "index_type_query",
  [sym_lookup_type] = "lookup_type",
  [sym_mapped_type_clause] = "mapped_type_clause",
  [sym_literal_type] = "literal_type",
  [sym__number] = "unary_expression",
  [sym_existential_type] = "existential_type",
  [sym_flow_maybe_type] = "flow_maybe_type",
  [sym_parenthesized_type] = "parenthesized_type",
  [sym_predefined_type] = "predefined_type",
  [sym_type_arguments] = "type_arguments",
  [sym_object_type] = "object_type",
  [sym_call_signature] = "call_signature",
  [sym_property_signature] = "property_signature",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_default_type] = "default_type",
  [sym_constraint] = "constraint",
  [sym_construct_signature] = "construct_signature",
  [sym_index_signature] = "index_signature",
  [sym_array_type] = "array_type",
  [sym_tuple_type] = "tuple_type",
  [sym_readonly_type] = "readonly_type",
  [sym_union_type] = "union_type",
  [sym_intersection_type] = "intersection_type",
  [sym_function_type] = "function_type",
  [sym_ui_pragma] = "ui_pragma",
  [sym_ui_import] = "ui_import",
  [sym_ui_version_specifier] = "ui_version_specifier",
  [sym_ui_object_definition] = "ui_object_definition",
  [sym_ui_annotated_object] = "ui_annotated_object",
  [sym_ui_annotation] = "ui_annotation",
  [sym_ui_object_initializer] = "ui_object_initializer",
  [sym_ui_annotated_object_member] = "ui_annotated_object_member",
  [sym_ui_object_definition_binding] = "ui_object_definition_binding",
  [sym_ui_binding] = "ui_binding",
  [sym_ui_property] = "ui_property",
  [sym_ui_list_property_type] = "ui_list_property_type",
  [sym_ui_property_modifier] = "ui_property_modifier",
  [sym_ui_object_array] = "ui_object_array",
  [sym_ui_required] = "ui_required",
  [sym_ui_signal] = "ui_signal",
  [sym_ui_signal_parameters] = "ui_signal_parameters",
  [sym_ui_signal_parameter] = "ui_signal_parameter",
  [sym_ui_inline_component] = "ui_inline_component",
  [sym__qml_enum_declaration] = "enum_declaration",
  [sym__qml_enum_body] = "enum_body",
  [sym__qml_enum_assignment] = "enum_assignment",
  [sym_ui_nested_identifier] = "nested_identifier",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_statement_block_repeat1] = "statement_block_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym_extends_clause_repeat1] = "extends_clause_repeat1",
  [aux_sym_implements_clause_repeat1] = "implements_clause_repeat1",
  [aux_sym_extends_type_clause_repeat1] = "extends_type_clause_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_template_literal_type_repeat1] = "template_literal_type_repeat1",
  [aux_sym_object_type_repeat1] = "object_type_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_ui_annotated_object_repeat1] = "ui_annotated_object_repeat1",
  [aux_sym_ui_object_initializer_repeat1] = "ui_object_initializer_repeat1",
  [aux_sym_ui_property_repeat1] = "ui_property_repeat1",
  [aux_sym_ui_object_array_repeat1] = "ui_object_array_repeat1",
  [aux_sym_ui_signal_parameters_repeat1] = "ui_signal_parameters_repeat1",
  [aux_sym__qml_enum_body_repeat1] = "_qml_enum_body_repeat1",
  [alias_sym_import_specifier] = "import_specifier",
  [alias_sym_namespace_export] = "namespace_export",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_this_type] = "this_type",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_unescaped_double_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_unescaped_single_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [sym_private_property_identifier] = sym_private_property_identifier,
  [anon_sym_target] = anon_sym_target,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_readonly] = anon_sym_readonly,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_declare] = anon_sym_declare,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_number] = anon_sym_number,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_symbol] = anon_sym_symbol,
  [anon_sym_property] = anon_sym_property,
  [anon_sym_signal] = anon_sym_signal,
  [anon_sym_on] = anon_sym_on,
  [anon_sym_required] = anon_sym_required,
  [anon_sym_component] = anon_sym_component,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_require] = anon_sym_require,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_DASH_QMARK_COLON] = anon_sym_DASH_QMARK_COLON,
  [anon_sym_QMARK_COLON] = anon_sym_QMARK_COLON,
  [anon_sym_asserts] = anon_sym_asserts,
  [anon_sym_infer] = anon_sym_infer,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_keyof] = anon_sym_keyof,
  [anon_sym_unknown] = anon_sym_unknown,
  [anon_sym_never] = anon_sym_never,
  [anon_sym_object] = anon_sym_object,
  [anon_sym_LBRACE_PIPE] = anon_sym_LBRACE_PIPE,
  [anon_sym_PIPE_RBRACE] = anon_sym_PIPE_RBRACE,
  [anon_sym_pragma] = anon_sym_pragma,
  [aux_sym_ui_version_specifier_token1] = sym_number,
  [anon_sym_list] = anon_sym_list,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym__ternary_qmark] = anon_sym_QMARK,
  [sym__function_signature_automatic_semicolon] = sym__function_signature_automatic_semicolon,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_export_clause] = sym_export_clause,
  [sym__import_export_specifier] = sym__import_export_specifier,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import_export] = sym_namespace_import_export,
  [sym_named_imports] = sym_named_imports,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function] = sym_function,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym__call_signature] = sym__call_signature,
  [sym__formal_parameter] = sym__formal_parameter,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [sym_public_field_definition] = sym_public_field_definition,
  [sym_non_null_expression] = sym_non_null_expression,
  [sym_method_signature] = sym_method_signature,
  [sym_abstract_method_signature] = sym_abstract_method_signature,
  [sym_function_signature] = sym_function_signature,
  [sym_type_assertion] = sym_type_assertion,
  [sym_as_expression] = sym_as_expression,
  [sym_import_require_clause] = sym_import_require_clause,
  [sym_extends_clause] = sym_extends_clause,
  [sym_implements_clause] = sym_implements_clause,
  [sym_ambient_declaration] = sym_ambient_declaration,
  [sym_abstract_class_declaration] = sym_abstract_class_declaration,
  [sym_module] = sym_module,
  [sym_internal_module] = sym_internal_module,
  [sym__module] = sym__module,
  [sym_import_alias] = sym_import_alias,
  [sym_nested_type_identifier] = sym_nested_type_identifier,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_type_clause] = sym_extends_type_clause,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_assignment] = sym_enum_assignment,
  [sym_type_alias_declaration] = sym_type_alias_declaration,
  [sym_accessibility_modifier] = sym_accessibility_modifier,
  [sym_override_modifier] = sym_override_modifier,
  [sym_required_parameter] = sym_required_parameter,
  [sym_optional_parameter] = sym_optional_parameter,
  [sym__parameter_name] = sym__parameter_name,
  [sym_omitting_type_annotation] = sym_omitting_type_annotation,
  [sym_opting_type_annotation] = sym_opting_type_annotation,
  [sym_type_annotation] = sym_type_annotation,
  [sym_asserts] = sym_asserts,
  [sym__type] = sym__type,
  [sym_tuple_parameter] = sym_required_parameter,
  [sym_optional_tuple_parameter] = sym_optional_parameter,
  [sym_optional_type] = sym_optional_type,
  [sym_rest_type] = sym_rest_type,
  [sym__tuple_type_member] = sym__tuple_type_member,
  [sym_constructor_type] = sym_constructor_type,
  [sym__primary_type] = sym__primary_type,
  [sym_template_type] = sym_template_type,
  [sym_template_literal_type] = sym_template_literal_type,
  [sym_infer_type] = sym_infer_type,
  [sym_conditional_type] = sym_conditional_type,
  [sym_generic_type] = sym_generic_type,
  [sym_type_predicate] = sym_type_predicate,
  [sym_type_predicate_annotation] = sym_type_predicate_annotation,
  [sym__type_query_member_expression] = sym_member_expression,
  [sym__type_query_subscript_expression] = sym_subscript_expression,
  [sym__type_query_call_expression] = sym_call_expression,
  [sym_type_query] = sym_type_query,
  [sym_index_type_query] = sym_index_type_query,
  [sym_lookup_type] = sym_lookup_type,
  [sym_mapped_type_clause] = sym_mapped_type_clause,
  [sym_literal_type] = sym_literal_type,
  [sym__number] = sym_unary_expression,
  [sym_existential_type] = sym_existential_type,
  [sym_flow_maybe_type] = sym_flow_maybe_type,
  [sym_parenthesized_type] = sym_parenthesized_type,
  [sym_predefined_type] = sym_predefined_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_object_type] = sym_object_type,
  [sym_call_signature] = sym_call_signature,
  [sym_property_signature] = sym_property_signature,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_default_type] = sym_default_type,
  [sym_constraint] = sym_constraint,
  [sym_construct_signature] = sym_construct_signature,
  [sym_index_signature] = sym_index_signature,
  [sym_array_type] = sym_array_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_readonly_type] = sym_readonly_type,
  [sym_union_type] = sym_union_type,
  [sym_intersection_type] = sym_intersection_type,
  [sym_function_type] = sym_function_type,
  [sym_ui_pragma] = sym_ui_pragma,
  [sym_ui_import] = sym_ui_import,
  [sym_ui_version_specifier] = sym_ui_version_specifier,
  [sym_ui_object_definition] = sym_ui_object_definition,
  [sym_ui_annotated_object] = sym_ui_annotated_object,
  [sym_ui_annotation] = sym_ui_annotation,
  [sym_ui_object_initializer] = sym_ui_object_initializer,
  [sym_ui_annotated_object_member] = sym_ui_annotated_object_member,
  [sym_ui_object_definition_binding] = sym_ui_object_definition_binding,
  [sym_ui_binding] = sym_ui_binding,
  [sym_ui_property] = sym_ui_property,
  [sym_ui_list_property_type] = sym_ui_list_property_type,
  [sym_ui_property_modifier] = sym_ui_property_modifier,
  [sym_ui_object_array] = sym_ui_object_array,
  [sym_ui_required] = sym_ui_required,
  [sym_ui_signal] = sym_ui_signal,
  [sym_ui_signal_parameters] = sym_ui_signal_parameters,
  [sym_ui_signal_parameter] = sym_ui_signal_parameter,
  [sym_ui_inline_component] = sym_ui_inline_component,
  [sym__qml_enum_declaration] = sym_enum_declaration,
  [sym__qml_enum_body] = sym_enum_body,
  [sym__qml_enum_assignment] = sym_enum_assignment,
  [sym_ui_nested_identifier] = sym_nested_identifier,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_statement_block_repeat1] = aux_sym_statement_block_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym_extends_clause_repeat1] = aux_sym_extends_clause_repeat1,
  [aux_sym_implements_clause_repeat1] = aux_sym_implements_clause_repeat1,
  [aux_sym_extends_type_clause_repeat1] = aux_sym_extends_type_clause_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_template_literal_type_repeat1] = aux_sym_template_literal_type_repeat1,
  [aux_sym_object_type_repeat1] = aux_sym_object_type_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_ui_annotated_object_repeat1] = aux_sym_ui_annotated_object_repeat1,
  [aux_sym_ui_object_initializer_repeat1] = aux_sym_ui_object_initializer_repeat1,
  [aux_sym_ui_property_repeat1] = aux_sym_ui_property_repeat1,
  [aux_sym_ui_object_array_repeat1] = aux_sym_ui_object_array_repeat1,
  [aux_sym_ui_signal_parameters_repeat1] = aux_sym_ui_signal_parameters_repeat1,
  [aux_sym__qml_enum_body_repeat1] = aux_sym__qml_enum_body_repeat1,
  [alias_sym_import_specifier] = alias_sym_import_specifier,
  [alias_sym_namespace_export] = alias_sym_namespace_export,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_this_type] = alias_sym_this_type,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_private_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_symbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_property] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_on] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_required] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_component] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_require] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asserts] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_infer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keyof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unknown] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_never] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_object] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pragma] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_ui_version_specifier_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = false,
    .named = true,
  },
  [sym__ternary_qmark] = {
    .visible = true,
    .named = false,
  },
  [sym__function_signature_automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__import_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import_export] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym__call_signature] = {
    .visible = false,
    .named = true,
  },
  [sym__formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [sym_public_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_non_null_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_assertion] = {
    .visible = true,
    .named = true,
  },
  [sym_as_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_import_require_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_implements_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_ambient_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_internal_module] = {
    .visible = true,
    .named = true,
  },
  [sym__module] = {
    .visible = false,
    .named = true,
  },
  [sym_import_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_accessibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_override_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_required_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_name] = {
    .visible = false,
    .named = true,
  },
  [sym_omitting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_opting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_asserts] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_type] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_type_member] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_type] = {
    .visible = true,
    .named = true,
  },
  [sym__primary_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_template_type] = {
    .visible = true,
    .named = true,
  },
  [sym_template_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym_infer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_index_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_lookup_type] = {
    .visible = true,
    .named = true,
  },
  [sym_mapped_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = true,
    .named = true,
  },
  [sym_existential_type] = {
    .visible = true,
    .named = true,
  },
  [sym_flow_maybe_type] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type] = {
    .visible = true,
    .named = true,
  },
  [sym_predefined_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_object_type] = {
    .visible = true,
    .named = true,
  },
  [sym_call_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_property_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_default_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_construct_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_index_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_readonly_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_pragma] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_import] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_version_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_object_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_annotated_object] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_object_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_annotated_object_member] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_object_definition_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_property] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_list_property_type] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_property_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_object_array] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_required] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_signal] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_signal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_signal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_inline_component] = {
    .visible = true,
    .named = true,
  },
  [sym__qml_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__qml_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym__qml_enum_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_implements_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_type_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_literal_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ui_annotated_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ui_object_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ui_property_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ui_object_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ui_signal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__qml_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_namespace_export] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_this_type] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_annotation = 3,
  field_argument = 4,
  field_arguments = 5,
  field_body = 6,
  field_component = 7,
  field_condition = 8,
  field_consequence = 9,
  field_constraint = 10,
  field_constructor = 11,
  field_declaration = 12,
  field_decorator = 13,
  field_definition = 14,
  field_finalizer = 15,
  field_flags = 16,
  field_function = 17,
  field_handler = 18,
  field_increment = 19,
  field_index = 20,
  field_index_type = 21,
  field_initializer = 22,
  field_key = 23,
  field_kind = 24,
  field_label = 25,
  field_left = 26,
  field_major = 27,
  field_minor = 28,
  field_module = 29,
  field_name = 30,
  field_object = 31,
  field_operator = 32,
  field_parameter = 33,
  field_parameters = 34,
  field_pattern = 35,
  field_property = 36,
  field_return_type = 37,
  field_right = 38,
  field_root = 39,
  field_sign = 40,
  field_source = 41,
  field_type = 42,
  field_type_arguments = 43,
  field_type_name = 44,
  field_type_parameters = 45,
  field_value = 46,
  field_version = 47,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_annotation] = "annotation",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_component] = "component",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constraint] = "constraint",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_definition] = "definition",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_index_type] = "index_type",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_kind] = "kind",
  [field_label] = "label",
  [field_left] = "left",
  [field_major] = "major",
  [field_minor] = "minor",
  [field_module] = "module",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_root] = "root",
  [field_sign] = "sign",
  [field_source] = "source",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_name] = "type_name",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
  [field_version] = "version",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 3, .length = 2},
  [6] = {.index = 5, .length = 2},
  [7] = {.index = 7, .length = 2},
  [8] = {.index = 9, .length = 1},
  [9] = {.index = 10, .length = 2},
  [11] = {.index = 12, .length = 1},
  [12] = {.index = 13, .length = 1},
  [13] = {.index = 14, .length = 2},
  [14] = {.index = 16, .length = 1},
  [15] = {.index = 17, .length = 1},
  [16] = {.index = 18, .length = 4},
  [17] = {.index = 22, .length = 2},
  [18] = {.index = 24, .length = 2},
  [19] = {.index = 26, .length = 1},
  [20] = {.index = 27, .length = 1},
  [22] = {.index = 28, .length = 2},
  [23] = {.index = 30, .length = 2},
  [24] = {.index = 24, .length = 2},
  [25] = {.index = 16, .length = 1},
  [26] = {.index = 32, .length = 3},
  [27] = {.index = 35, .length = 2},
  [28] = {.index = 37, .length = 2},
  [29] = {.index = 39, .length = 2},
  [30] = {.index = 41, .length = 2},
  [31] = {.index = 43, .length = 2},
  [32] = {.index = 45, .length = 1},
  [33] = {.index = 46, .length = 2},
  [34] = {.index = 48, .length = 1},
  [36] = {.index = 17, .length = 1},
  [38] = {.index = 49, .length = 2},
  [39] = {.index = 51, .length = 1},
  [40] = {.index = 52, .length = 2},
  [41] = {.index = 54, .length = 2},
  [42] = {.index = 56, .length = 2},
  [43] = {.index = 58, .length = 2},
  [44] = {.index = 60, .length = 2},
  [45] = {.index = 62, .length = 3},
  [46] = {.index = 62, .length = 3},
  [49] = {.index = 65, .length = 1},
  [50] = {.index = 66, .length = 2},
  [51] = {.index = 68, .length = 3},
  [52] = {.index = 71, .length = 5},
  [53] = {.index = 62, .length = 3},
  [54] = {.index = 62, .length = 3},
  [55] = {.index = 76, .length = 2},
  [56] = {.index = 78, .length = 2},
  [57] = {.index = 76, .length = 2},
  [58] = {.index = 76, .length = 2},
  [59] = {.index = 76, .length = 2},
  [60] = {.index = 80, .length = 2},
  [61] = {.index = 82, .length = 2},
  [62] = {.index = 84, .length = 3},
  [63] = {.index = 87, .length = 2},
  [64] = {.index = 89, .length = 2},
  [65] = {.index = 91, .length = 2},
  [67] = {.index = 93, .length = 1},
  [68] = {.index = 94, .length = 2},
  [69] = {.index = 96, .length = 2},
  [70] = {.index = 98, .length = 1},
  [71] = {.index = 99, .length = 3},
  [72] = {.index = 102, .length = 3},
  [73] = {.index = 105, .length = 2},
  [74] = {.index = 107, .length = 2},
  [75] = {.index = 109, .length = 2},
  [76] = {.index = 111, .length = 2},
  [77] = {.index = 113, .length = 3},
  [78] = {.index = 116, .length = 2},
  [79] = {.index = 118, .length = 2},
  [80] = {.index = 120, .length = 2},
  [81] = {.index = 122, .length = 2},
  [82] = {.index = 124, .length = 2},
  [83] = {.index = 126, .length = 2},
  [85] = {.index = 122, .length = 2},
  [86] = {.index = 128, .length = 2},
  [87] = {.index = 130, .length = 1},
  [88] = {.index = 131, .length = 2},
  [89] = {.index = 133, .length = 4},
  [90] = {.index = 137, .length = 2},
  [91] = {.index = 139, .length = 2},
  [92] = {.index = 87, .length = 2},
  [93] = {.index = 89, .length = 2},
  [94] = {.index = 141, .length = 3},
  [95] = {.index = 144, .length = 2},
  [96] = {.index = 144, .length = 2},
  [97] = {.index = 146, .length = 3},
  [98] = {.index = 149, .length = 2},
  [99] = {.index = 151, .length = 4},
  [100] = {.index = 155, .length = 3},
  [101] = {.index = 158, .length = 2},
  [102] = {.index = 87, .length = 2},
  [103] = {.index = 160, .length = 2},
  [104] = {.index = 162, .length = 5},
  [105] = {.index = 167, .length = 3},
  [106] = {.index = 167, .length = 3},
  [108] = {.index = 167, .length = 3},
  [109] = {.index = 167, .length = 3},
  [110] = {.index = 170, .length = 2},
  [111] = {.index = 170, .length = 2},
  [112] = {.index = 172, .length = 2},
  [113] = {.index = 174, .length = 2},
  [114] = {.index = 174, .length = 2},
  [115] = {.index = 174, .length = 2},
  [116] = {.index = 174, .length = 2},
  [117] = {.index = 176, .length = 1},
  [118] = {.index = 177, .length = 2},
  [119] = {.index = 179, .length = 1},
  [120] = {.index = 180, .length = 6},
  [121] = {.index = 186, .length = 2},
  [122] = {.index = 188, .length = 1},
  [123] = {.index = 128, .length = 2},
  [124] = {.index = 189, .length = 5},
  [125] = {.index = 194, .length = 2},
  [126] = {.index = 196, .length = 3},
  [127] = {.index = 199, .length = 1},
  [128] = {.index = 200, .length = 1},
  [129] = {.index = 201, .length = 3},
  [130] = {.index = 204, .length = 3},
  [131] = {.index = 207, .length = 4},
  [132] = {.index = 211, .length = 2},
  [133] = {.index = 213, .length = 3},
  [134] = {.index = 216, .length = 1},
  [135] = {.index = 217, .length = 4},
  [136] = {.index = 221, .length = 4},
  [137] = {.index = 225, .length = 4},
  [138] = {.index = 229, .length = 3},
  [139] = {.index = 232, .length = 2},
  [140] = {.index = 234, .length = 2},
  [141] = {.index = 236, .length = 2},
  [142] = {.index = 238, .length = 3},
  [143] = {.index = 241, .length = 2},
  [144] = {.index = 243, .length = 3},
  [145] = {.index = 246, .length = 2},
  [146] = {.index = 248, .length = 2},
  [147] = {.index = 250, .length = 4},
  [148] = {.index = 248, .length = 2},
  [149] = {.index = 254, .length = 4},
  [150] = {.index = 258, .length = 3},
  [151] = {.index = 261, .length = 2},
  [152] = {.index = 263, .length = 3},
  [153] = {.index = 266, .length = 3},
  [154] = {.index = 269, .length = 2},
  [155] = {.index = 271, .length = 3},
  [156] = {.index = 274, .length = 5},
  [157] = {.index = 279, .length = 4},
  [158] = {.index = 279, .length = 4},
  [159] = {.index = 279, .length = 4},
  [160] = {.index = 279, .length = 4},
  [161] = {.index = 66, .length = 2},
  [162] = {.index = 283, .length = 2},
  [163] = {.index = 285, .length = 2},
  [164] = {.index = 287, .length = 3},
  [165] = {.index = 290, .length = 3},
  [166] = {.index = 290, .length = 3},
  [167] = {.index = 290, .length = 3},
  [168] = {.index = 290, .length = 3},
  [169] = {.index = 293, .length = 1},
  [170] = {.index = 294, .length = 1},
  [171] = {.index = 295, .length = 2},
  [172] = {.index = 293, .length = 1},
  [173] = {.index = 297, .length = 1},
  [174] = {.index = 295, .length = 2},
  [175] = {.index = 298, .length = 2},
  [176] = {.index = 300, .length = 6},
  [177] = {.index = 306, .length = 4},
  [178] = {.index = 298, .length = 2},
  [179] = {.index = 310, .length = 1},
  [180] = {.index = 310, .length = 1},
  [181] = {.index = 311, .length = 5},
  [182] = {.index = 316, .length = 2},
  [183] = {.index = 318, .length = 1},
  [184] = {.index = 319, .length = 4},
  [185] = {.index = 323, .length = 2},
  [186] = {.index = 325, .length = 2},
  [187] = {.index = 327, .length = 2},
  [188] = {.index = 329, .length = 1},
  [189] = {.index = 330, .length = 2},
  [190] = {.index = 332, .length = 1},
  [191] = {.index = 333, .length = 4},
  [192] = {.index = 337, .length = 4},
  [193] = {.index = 337, .length = 4},
  [194] = {.index = 341, .length = 4},
  [195] = {.index = 341, .length = 4},
  [196] = {.index = 345, .length = 4},
  [197] = {.index = 345, .length = 4},
  [198] = {.index = 349, .length = 2},
  [199] = {.index = 351, .length = 3},
  [200] = {.index = 354, .length = 2},
  [201] = {.index = 356, .length = 2},
  [202] = {.index = 358, .length = 3},
  [203] = {.index = 361, .length = 4},
  [204] = {.index = 365, .length = 4},
  [205] = {.index = 369, .length = 4},
  [206] = {.index = 373, .length = 3},
  [207] = {.index = 376, .length = 2},
  [208] = {.index = 378, .length = 3},
  [209] = {.index = 381, .length = 4},
  [210] = {.index = 385, .length = 3},
  [211] = {.index = 388, .length = 4},
  [212] = {.index = 388, .length = 4},
  [213] = {.index = 388, .length = 4},
  [214] = {.index = 388, .length = 4},
  [215] = {.index = 392, .length = 1},
  [216] = {.index = 393, .length = 2},
  [217] = {.index = 395, .length = 5},
  [218] = {.index = 39, .length = 2},
  [219] = {.index = 400, .length = 2},
  [220] = {.index = 402, .length = 4},
  [221] = {.index = 406, .length = 2},
  [222] = {.index = 408, .length = 3},
  [223] = {.index = 411, .length = 2},
  [224] = {.index = 411, .length = 2},
  [225] = {.index = 413, .length = 2},
  [226] = {.index = 415, .length = 3},
  [227] = {.index = 418, .length = 2},
  [228] = {.index = 420, .length = 4},
  [229] = {.index = 66, .length = 2},
  [230] = {.index = 424, .length = 1},
  [231] = {.index = 425, .length = 3},
  [232] = {.index = 428, .length = 2},
  [233] = {.index = 430, .length = 2},
  [234] = {.index = 432, .length = 1},
  [235] = {.index = 433, .length = 2},
  [236] = {.index = 435, .length = 2},
  [237] = {.index = 437, .length = 4},
  [238] = {.index = 441, .length = 4},
  [239] = {.index = 445, .length = 4},
  [240] = {.index = 449, .length = 3},
  [241] = {.index = 452, .length = 2},
  [242] = {.index = 454, .length = 2},
  [243] = {.index = 456, .length = 2},
  [244] = {.index = 458, .length = 3},
  [245] = {.index = 461, .length = 3},
  [246] = {.index = 464, .length = 4},
  [247] = {.index = 468, .length = 2},
  [248] = {.index = 470, .length = 3},
  [249] = {.index = 473, .length = 3},
  [250] = {.index = 473, .length = 3},
  [251] = {.index = 476, .length = 3},
  [252] = {.index = 479, .length = 5},
  [253] = {.index = 484, .length = 3},
  [254] = {.index = 487, .length = 2},
  [255] = {.index = 489, .length = 1},
  [256] = {.index = 490, .length = 3},
  [257] = {.index = 493, .length = 4},
  [258] = {.index = 497, .length = 2},
  [259] = {.index = 499, .length = 2},
  [260] = {.index = 501, .length = 4},
  [261] = {.index = 505, .length = 4},
  [262] = {.index = 509, .length = 2},
  [263] = {.index = 511, .length = 2},
  [264] = {.index = 513, .length = 1},
  [265] = {.index = 514, .length = 3},
  [266] = {.index = 517, .length = 1},
  [267] = {.index = 518, .length = 4},
  [268] = {.index = 522, .length = 4},
  [269] = {.index = 526, .length = 4},
  [270] = {.index = 530, .length = 3},
  [271] = {.index = 533, .length = 2},
  [272] = {.index = 535, .length = 3},
  [273] = {.index = 538, .length = 3},
  [274] = {.index = 541, .length = 2},
  [275] = {.index = 543, .length = 1},
  [276] = {.index = 544, .length = 4},
  [277] = {.index = 548, .length = 4},
  [278] = {.index = 552, .length = 5},
  [279] = {.index = 557, .length = 5},
  [281] = {.index = 562, .length = 4},
  [282] = {.index = 566, .length = 3},
  [283] = {.index = 569, .length = 3},
  [284] = {.index = 572, .length = 3},
  [285] = {.index = 569, .length = 3},
  [286] = {.index = 575, .length = 2},
  [287] = {.index = 577, .length = 4},
  [288] = {.index = 581, .length = 4},
  [289] = {.index = 585, .length = 2},
  [290] = {.index = 587, .length = 2},
  [291] = {.index = 589, .length = 4},
  [292] = {.index = 593, .length = 3},
  [293] = {.index = 596, .length = 2},
  [294] = {.index = 598, .length = 3},
  [295] = {.index = 601, .length = 2},
  [296] = {.index = 603, .length = 1},
  [297] = {.index = 604, .length = 5},
  [298] = {.index = 609, .length = 5},
  [299] = {.index = 614, .length = 5},
  [300] = {.index = 619, .length = 4},
  [301] = {.index = 623, .length = 4},
  [302] = {.index = 627, .length = 3},
  [303] = {.index = 627, .length = 3},
  [304] = {.index = 630, .length = 2},
  [305] = {.index = 632, .length = 3},
  [306] = {.index = 635, .length = 2},
  [307] = {.index = 637, .length = 3},
  [308] = {.index = 640, .length = 2},
  [309] = {.index = 642, .length = 2},
  [310] = {.index = 644, .length = 5},
  [311] = {.index = 649, .length = 5},
  [312] = {.index = 654, .length = 4},
  [313] = {.index = 654, .length = 4},
  [314] = {.index = 658, .length = 4},
  [315] = {.index = 662, .length = 4},
  [316] = {.index = 666, .length = 3},
  [317] = {.index = 669, .length = 2},
  [318] = {.index = 671, .length = 2},
  [319] = {.index = 673, .length = 3},
  [320] = {.index = 676, .length = 5},
  [321] = {.index = 681, .length = 4},
  [322] = {.index = 685, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_root, 0},
  [1] =
    {field_annotation, 0},
  [2] =
    {field_root, 1},
  [3] =
    {field_initializer, 1},
    {field_type_name, 0},
  [5] =
    {field_annotation, 0, .inherited = true},
    {field_definition, 1},
  [7] =
    {field_annotation, 0, .inherited = true},
    {field_annotation, 1, .inherited = true},
  [9] =
    {field_root, 2},
  [10] =
    {field_body, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [12] =
    {field_source, 1},
  [13] =
    {field_major, 0},
  [14] =
    {field_initializer, 2},
    {field_type_name, 1},
  [16] =
    {field_name, 1},
  [17] =
    {field_name, 0},
  [18] =
    {field_annotation, 0, .inherited = true},
    {field_body, 1, .inherited = true},
    {field_definition, 1},
    {field_name, 1, .inherited = true},
  [22] =
    {field_source, 1},
    {field_version, 2},
  [24] =
    {field_name, 0},
    {field_value, 2},
  [26] =
    {field_decorator, 0},
  [27] =
    {field_parameters, 0},
  [28] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [30] =
    {field_name, 0},
    {field_type, 1},
  [32] =
    {field_body, 2},
    {field_name, 1},
    {field_name, 2, .inherited = true},
  [35] =
    {field_alias, 3},
    {field_source, 1},
  [37] =
    {field_major, 0},
    {field_minor, 2},
  [39] =
    {field_name, 1},
    {field_value, 3},
  [41] =
    {field_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [43] =
    {field_argument, 1},
    {field_operator, 0},
  [45] =
    {field_pattern, 0},
  [46] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
  [48] =
    {field_body, 1},
  [49] =
    {field_argument, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
  [51] =
    {field_constructor, 1},
  [52] =
    {field_argument, 0},
    {field_operator, 1},
  [54] =
    {field_arguments, 1},
    {field_function, 0},
  [56] =
    {field_parameters, 0},
    {field_return_type, 1},
  [58] =
    {field_parameters, 1},
    {field_type_parameters, 0},
  [60] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [62] =
    {field_initializer, 3},
    {field_name, 2},
    {field_type_name, 0},
  [65] =
    {field_value, 1},
  [66] =
    {field_name, 0},
    {field_type, 2},
  [68] =
    {field_name, 0},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [71] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [76] =
    {field_name, 2},
    {field_type, 1},
  [78] =
    {field_module, 0},
    {field_name, 2},
  [80] =
    {field_name, 1},
    {field_parameters, 2},
  [82] =
    {field_component, 3},
    {field_name, 1},
  [84] =
    {field_alias, 4},
    {field_source, 1},
    {field_version, 2},
  [87] =
    {field_left, 0},
    {field_right, 2},
  [89] =
    {field_body, 2},
    {field_parameter, 0},
  [91] =
    {field_body, 1},
    {field_name, 0},
  [93] =
    {field_declaration, 1},
  [94] =
    {field_condition, 1},
    {field_consequence, 2},
  [96] =
    {field_body, 2},
    {field_value, 1},
  [98] =
    {field_pattern, 1},
  [99] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [102] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
  [105] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 1},
  [107] =
    {field_body, 1},
    {field_handler, 2},
  [109] =
    {field_body, 1},
    {field_finalizer, 2},
  [111] =
    {field_body, 2},
    {field_object, 1},
  [113] =
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [116] =
    {field_object, 1, .inherited = true},
    {field_property, 1, .inherited = true},
  [118] =
    {field_index, 1, .inherited = true},
    {field_object, 1, .inherited = true},
  [120] =
    {field_arguments, 1, .inherited = true},
    {field_function, 1, .inherited = true},
  [122] =
    {field_name, 0},
    {field_type_arguments, 1},
  [124] =
    {field_name, 0},
    {field_value, 1},
  [126] =
    {field_constraint, 1},
    {field_name, 0},
  [128] =
    {field_body, 2},
    {field_name, 1},
  [130] =
    {field_body, 2},
  [131] =
    {field_body, 2},
    {field_type_parameters, 1},
  [133] =
    {field_body, 2},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [137] =
    {field_arguments, 2},
    {field_constructor, 1},
  [139] =
    {field_constructor, 1},
    {field_type_arguments, 2},
  [141] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [144] =
    {field_object, 0},
    {field_property, 2},
  [146] =
    {field_arguments, 2},
    {field_function, 0},
    {field_type_arguments, 1},
  [149] =
    {field_arguments, 2},
    {field_function, 0},
  [151] =
    {field_body, 2},
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [155] =
    {field_parameters, 1},
    {field_return_type, 2},
    {field_type_parameters, 0},
  [158] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [160] =
    {field_key, 0},
    {field_value, 2},
  [162] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [167] =
    {field_name, 2},
    {field_type, 1},
    {field_value, 4},
  [170] =
    {field_name, 1},
    {field_type, 0},
  [172] =
    {field_name, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [174] =
    {field_name, 3},
    {field_type, 2},
  [176] =
    {field_declaration, 2},
  [177] =
    {field_body, 2},
    {field_label, 0},
  [179] =
    {field_kind, 0},
  [180] =
    {field_body, 2},
    {field_kind, 1, .inherited = true},
    {field_left, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_right, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [186] =
    {field_body, 2},
    {field_condition, 1},
  [188] =
    {field_label, 1},
  [189] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [194] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [196] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [199] =
    {field_type, 2},
  [200] =
    {field_pattern, 2},
  [201] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 2, .inherited = true},
  [204] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
  [207] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [211] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 2},
  [213] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [216] =
    {field_parameters, 1},
  [217] =
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [221] =
    {field_arguments, 1},
    {field_function, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [225] =
    {field_arguments, 1},
    {field_function, 0},
    {field_index, 0, .inherited = true},
    {field_object, 0, .inherited = true},
  [229] =
    {field_constraint, 1},
    {field_name, 0},
    {field_value, 2},
  [232] =
    {field_parameters, 0},
    {field_return_type, 2},
  [234] =
    {field_flags, 3},
    {field_pattern, 1},
  [236] =
    {field_body, 3},
    {field_name, 1},
  [238] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [241] =
    {field_type_arguments, 2},
    {field_value, 1},
  [243] =
    {field_type_arguments, 2, .inherited = true},
    {field_value, 1},
    {field_value, 2, .inherited = true},
  [246] =
    {field_body, 3},
    {field_type_parameters, 1},
  [248] =
    {field_body, 3},
    {field_parameter, 1},
  [250] =
    {field_body, 3},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [254] =
    {field_body, 3},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [258] =
    {field_arguments, 3},
    {field_constructor, 1},
    {field_type_arguments, 2},
  [261] =
    {field_index, 2},
    {field_object, 0},
  [263] =
    {field_arguments, 3},
    {field_function, 0},
    {field_type_arguments, 2},
  [266] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [269] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [271] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [274] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [279] =
    {field_name, 2},
    {field_type, 1},
    {field_value, 4},
    {field_value, 5},
  [283] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
  [285] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [287] =
    {field_name, 1, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_value, 1, .inherited = true},
  [290] =
    {field_name, 3},
    {field_type, 2},
    {field_value, 5},
  [293] =
    {field_source, 2, .inherited = true},
  [294] =
    {field_value, 2},
  [295] =
    {field_alias, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [297] =
    {field_source, 2},
  [298] =
    {field_body, 3},
    {field_name, 2},
  [300] =
    {field_body, 3},
    {field_kind, 2, .inherited = true},
    {field_left, 2, .inherited = true},
    {field_operator, 2, .inherited = true},
    {field_right, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [306] =
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [310] =
    {field_type, 1},
  [311] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [316] =
    {field_declaration, 3},
    {field_decorator, 0, .inherited = true},
  [318] =
    {field_pattern, 3},
  [319] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [323] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 3},
  [325] =
    {field_parameters, 1},
    {field_type, 2},
  [327] =
    {field_parameters, 2},
    {field_type_parameters, 1},
  [329] =
    {field_name, 2},
  [330] =
    {field_name, 1},
    {field_type, 2},
  [332] =
    {field_parameters, 2},
  [333] =
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [337] =
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
    {field_property, 2},
  [341] =
    {field_index, 0, .inherited = true},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 2},
  [345] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_object, 0},
    {field_property, 2},
  [349] =
    {field_parameters, 1},
    {field_type, 3},
  [351] =
    {field_parameters, 1},
    {field_return_type, 3},
    {field_type_parameters, 0},
  [354] =
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [356] =
    {field_name, 0},
    {field_value, 2, .inherited = true},
  [358] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [361] =
    {field_type_arguments, 2},
    {field_type_arguments, 3, .inherited = true},
    {field_value, 1},
    {field_value, 3, .inherited = true},
  [365] =
    {field_type_arguments, 0, .inherited = true},
    {field_type_arguments, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [369] =
    {field_body, 4},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [373] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [376] =
    {field_index, 3},
    {field_object, 0},
  [378] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [381] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [385] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [388] =
    {field_name, 3},
    {field_type, 2},
    {field_value, 5},
    {field_value, 6},
  [392] =
    {field_source, 3, .inherited = true},
  [393] =
    {field_alias, 2},
    {field_name, 0},
  [395] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [400] =
    {field_body, 1},
    {field_condition, 3},
  [402] =
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [406] =
    {field_body, 4},
    {field_name, 2},
  [408] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [411] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
  [413] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [415] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [418] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 4},
  [420] =
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [424] =
    {field_type, 3},
  [425] =
    {field_parameters, 2},
    {field_type, 3},
    {field_type_parameters, 1},
  [428] =
    {field_name, 2},
    {field_type, 3},
  [430] =
    {field_name, 1},
    {field_type, 3},
  [432] =
    {field_name, 3},
  [433] =
    {field_parameters, 2},
    {field_type, 3},
  [435] =
    {field_parameters, 3},
    {field_type_parameters, 2},
  [437] =
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [441] =
    {field_index, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [445] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
  [449] =
    {field_parameters, 2},
    {field_type, 4},
    {field_type_parameters, 1},
  [452] =
    {field_parameters, 2},
    {field_type, 4},
  [454] =
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [456] =
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [458] =
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [461] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [464] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [468] =
    {field_alias, 3},
    {field_name, 1},
  [470] =
    {field_name, 1},
    {field_type_parameters, 2},
    {field_value, 4},
  [473] =
    {field_left, 1},
    {field_operator, 2},
    {field_right, 3},
  [476] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [479] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [484] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [487] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [489] =
    {field_name, 2, .inherited = true},
  [490] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [493] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [497] =
    {field_body, 3},
    {field_value, 1},
  [499] =
    {field_body, 4},
    {field_parameter, 2},
  [501] =
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [505] =
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [509] =
    {field_name, 2},
    {field_type, 4},
  [511] =
    {field_name, 3},
    {field_type, 4},
  [513] =
    {field_type, 4},
  [514] =
    {field_parameters, 3},
    {field_type, 4},
    {field_type_parameters, 2},
  [517] =
    {field_name, 4},
  [518] =
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [522] =
    {field_index, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [526] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
  [530] =
    {field_parameters, 3},
    {field_type, 5},
    {field_type_parameters, 2},
  [533] =
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [535] =
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [538] =
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [541] =
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [543] =
    {field_source, 4},
  [544] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 3},
    {field_right, 4},
  [548] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [552] =
    {field_body, 6},
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [557] =
    {field_body, 6},
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [562] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [566] =
    {field_body, 5},
    {field_parameter, 2},
    {field_type, 3},
  [569] =
    {field_index_type, 3},
    {field_name, 1},
    {field_type, 5},
  [572] =
    {field_alias, 4},
    {field_name, 0},
    {field_type, 2},
  [575] =
    {field_sign, 0},
    {field_type, 5},
  [577] =
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [581] =
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [585] =
    {field_name, 3},
    {field_type, 5},
  [587] =
    {field_name, 4},
    {field_type, 5},
  [589] =
    {field_alternative, 6},
    {field_consequence, 4},
    {field_left, 0},
    {field_right, 2},
  [593] =
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [596] =
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [598] =
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [601] =
    {field_name, 4},
    {field_value, 5, .inherited = true},
  [603] =
    {field_name, 5},
  [604] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
    {field_value, 3, .inherited = true},
  [609] =
    {field_body, 7},
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [614] =
    {field_body, 7},
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [619] =
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [623] =
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [627] =
    {field_index_type, 4},
    {field_name, 2},
    {field_type, 6},
  [630] =
    {field_name, 4},
    {field_type, 6},
  [632] =
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [635] =
    {field_name, 4},
    {field_value, 6, .inherited = true},
  [637] =
    {field_name, 4},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [640] =
    {field_name, 5},
    {field_value, 6, .inherited = true},
  [642] =
    {field_name, 5},
    {field_type, 6},
  [644] =
    {field_body, 8},
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [649] =
    {field_body, 8},
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [654] =
    {field_index_type, 5},
    {field_name, 3},
    {field_sign, 0},
    {field_type, 7},
  [658] =
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [662] =
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [666] =
    {field_name, 4},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [669] =
    {field_name, 5},
    {field_value, 7, .inherited = true},
  [671] =
    {field_name, 5},
    {field_type, 7},
  [673] =
    {field_name, 5},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [676] =
    {field_body, 9},
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [681] =
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [685] =
    {field_name, 5},
    {field_type, 7},
    {field_value, 8, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [4] = {
    [0] = sym_identifier,
  },
  [10] = {
    [0] = sym_identifier,
  },
  [18] = {
    [0] = sym_identifier,
  },
  [21] = {
    [0] = alias_sym_property_identifier,
  },
  [25] = {
    [1] = sym_identifier,
  },
  [35] = {
    [0] = anon_sym_list,
  },
  [36] = {
    [0] = anon_sym_list,
  },
  [37] = {
    [0] = alias_sym_this_type,
  },
  [45] = {
    [0] = sym_identifier,
    [2] = sym_identifier,
  },
  [46] = {
    [0] = sym_identifier,
  },
  [47] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [48] = {
    [1] = sym_identifier,
  },
  [53] = {
    [2] = sym_identifier,
  },
  [55] = {
    [1] = anon_sym_list,
    [2] = sym_identifier,
  },
  [56] = {
    [2] = anon_sym_list,
  },
  [57] = {
    [1] = anon_sym_list,
  },
  [58] = {
    [2] = sym_identifier,
  },
  [63] = {
    [0] = sym_identifier,
  },
  [64] = {
    [0] = sym_identifier,
  },
  [66] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [81] = {
    [0] = anon_sym_list,
  },
  [82] = {
    [0] = anon_sym_list,
  },
  [83] = {
    [0] = anon_sym_list,
  },
  [84] = {
    [1] = anon_sym_list,
  },
  [86] = {
    [1] = anon_sym_list,
  },
  [95] = {
    [2] = alias_sym_property_identifier,
  },
  [102] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [105] = {
    [1] = anon_sym_list,
    [2] = sym_identifier,
  },
  [106] = {
    [1] = anon_sym_list,
  },
  [107] = {
    [2] = anon_sym_list,
  },
  [108] = {
    [2] = sym_identifier,
  },
  [110] = {
    [0] = anon_sym_list,
  },
  [113] = {
    [2] = anon_sym_list,
    [3] = sym_identifier,
  },
  [114] = {
    [2] = anon_sym_list,
  },
  [115] = {
    [3] = sym_identifier,
  },
  [118] = {
    [0] = alias_sym_statement_identifier,
  },
  [122] = {
    [1] = alias_sym_statement_identifier,
  },
  [138] = {
    [0] = anon_sym_list,
  },
  [141] = {
    [1] = anon_sym_list,
  },
  [142] = {
    [1] = anon_sym_list,
  },
  [146] = {
    [1] = sym_identifier,
  },
  [153] = {
    [2] = anon_sym_list,
  },
  [157] = {
    [1] = anon_sym_list,
    [2] = sym_identifier,
  },
  [158] = {
    [1] = anon_sym_list,
  },
  [159] = {
    [2] = sym_identifier,
  },
  [161] = {
    [2] = anon_sym_list,
  },
  [165] = {
    [2] = anon_sym_list,
    [3] = sym_identifier,
  },
  [166] = {
    [2] = anon_sym_list,
  },
  [167] = {
    [3] = sym_identifier,
  },
  [172] = {
    [1] = alias_sym_namespace_export,
  },
  [174] = {
    [1] = alias_sym_import_specifier,
  },
  [178] = {
    [2] = anon_sym_list,
  },
  [179] = {
    [1] = anon_sym_list,
  },
  [192] = {
    [2] = alias_sym_property_identifier,
  },
  [194] = {
    [2] = alias_sym_property_identifier,
  },
  [196] = {
    [2] = alias_sym_property_identifier,
  },
  [202] = {
    [1] = anon_sym_list,
  },
  [208] = {
    [2] = anon_sym_list,
  },
  [209] = {
    [2] = anon_sym_list,
  },
  [211] = {
    [2] = anon_sym_list,
    [3] = sym_identifier,
  },
  [212] = {
    [2] = anon_sym_list,
  },
  [213] = {
    [3] = sym_identifier,
  },
  [218] = {
    [1] = anon_sym_list,
  },
  [221] = {
    [2] = anon_sym_list,
  },
  [222] = {
    [2] = anon_sym_list,
  },
  [223] = {
    [1] = anon_sym_list,
  },
  [226] = {
    [3] = anon_sym_list,
  },
  [229] = {
    [0] = anon_sym_list,
  },
  [246] = {
    [2] = anon_sym_list,
  },
  [248] = {
    [1] = anon_sym_list,
  },
  [249] = {
    [1] = sym_identifier,
  },
  [253] = {
    [2] = anon_sym_list,
  },
  [256] = {
    [3] = anon_sym_list,
  },
  [257] = {
    [3] = anon_sym_list,
  },
  [280] = {
    [3] = alias_sym_property_identifier,
  },
  [281] = {
    [3] = anon_sym_list,
  },
  [283] = {
    [1] = sym_identifier,
  },
  [284] = {
    [0] = anon_sym_list,
  },
  [302] = {
    [2] = sym_identifier,
  },
  [312] = {
    [3] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__import_export_specifier, 2,
    sym__import_export_specifier,
    alias_sym_import_specifier,
  sym_namespace_import_export, 2,
    sym_namespace_import_export,
    alias_sym_namespace_export,
  0,
};

static inline bool anon_sym_BANG_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ' '
      ? (c < '\r'
        ? (c >= '\t' && c <= '\n')
        : c <= '\r')
      : (c <= ' ' || (c < 5760
        ? c == 160
        : c <= 5760)))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static inline bool sym_regex_pattern_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ' '
      ? (c < '\r'
        ? c == '\t'
        : c <= '\r')
      : (c <= ' ' || (c < 5760
        ? c == 160
        : c <= 5760)))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 160
    ? (c < ':'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '/')))
      : (c <= '@' || (c < '`'
        ? (c >= '[' && c <= '^')
        : (c <= '`' || (c >= '{' && c <= '~')))))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 160
    ? (c < ':'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '/')))
      : (c <= '@' || (c < '`'
        ? (c >= '[' && c <= '^')
        : c <= '~')))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 160
    ? (c < ':'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '/')))
      : (c <= '@' || (c < '`'
        ? (c >= '[' && c <= '^')
        : (c <= '`' || (c >= '|' && c <= '~')))))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static inline bool sym_private_property_identifier_character_set_1(int32_t c) {
  return (c < 160
    ? (c < '['
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '@')))
      : (c <= '^' || (c < '{'
        ? c == '`'
        : c <= '~')))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(76);
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '#') ADVANCE(8);
      if (lookahead == '$') ADVANCE(204);
      if (lookahead == '%') ADVANCE(154);
      if (lookahead == '&') ADVANCE(136);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(90);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '*') ADVANCE(79);
      if (lookahead == '+') ADVANCE(148);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '-') ADVANCE(152);
      if (lookahead == '.') ADVANCE(105);
      if (lookahead == '/') ADVANCE(190);
      if (lookahead == '0') ADVANCE(195);
      if (lookahead == ':') ADVANCE(93);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(97);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(100);
      if (lookahead == '?') ADVANCE(210);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(34);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '^') ADVANCE(139);
      if (lookahead == '`') ADVANCE(188);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(142);
      if (lookahead == '}') ADVANCE(87);
      if (lookahead == '~') ADVANCE(165);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(196);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(74)
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(205);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(27)
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '[') ADVANCE(33);
      if (lookahead == '\\') ADVANCE(73);
      if (sym_regex_pattern_character_set_1(lookahead)) ADVANCE(191);
      if (lookahead != 0) ADVANCE(192);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '%') ADVANCE(154);
      if (lookahead == '&') ADVANCE(136);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(90);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '*') ADVANCE(79);
      if (lookahead == '+') ADVANCE(148);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '-') ADVANCE(151);
      if (lookahead == '.') ADVANCE(105);
      if (lookahead == '/') ADVANCE(103);
      if (lookahead == '0') ADVANCE(195);
      if (lookahead == ':') ADVANCE(93);
      if (lookahead == '<') ADVANCE(97);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(100);
      if (lookahead == '?') ADVANCE(210);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == '^') ADVANCE(139);
      if (lookahead == '`') ADVANCE(188);
      if (lookahead == '{') ADVANCE(84);
      if (lookahead == '|') ADVANCE(141);
      if (lookahead == '~') ADVANCE(165);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(196);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(2)
      if (lookahead != 0 &&
          lookahead > '#' &&
          lookahead != ';' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(205);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '%') ADVANCE(154);
      if (lookahead == '&') ADVANCE(136);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(90);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '*') ADVANCE(79);
      if (lookahead == '+') ADVANCE(148);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '-') ADVANCE(151);
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == '/') ADVANCE(103);
      if (lookahead == ':') ADVANCE(93);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(97);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(100);
      if (lookahead == '?') ADVANCE(210);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '^') ADVANCE(139);
      if (lookahead == '`') ADVANCE(188);
      if (lookahead == '{') ADVANCE(84);
      if (lookahead == '|') ADVANCE(142);
      if (lookahead == '}') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(216);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(3)
      if (lookahead != 0 &&
          lookahead > '#' &&
          lookahead != '~') ADVANCE(205);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '%') ADVANCE(153);
      if (lookahead == '&') ADVANCE(137);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(90);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '*') ADVANCE(80);
      if (lookahead == '+') ADVANCE(147);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '-') ADVANCE(150);
      if (lookahead == '.') ADVANCE(106);
      if (lookahead == '/') ADVANCE(102);
      if (lookahead == '0') ADVANCE(195);
      if (lookahead == ':') ADVANCE(93);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(98);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '>') ADVANCE(101);
      if (lookahead == '?') ADVANCE(25);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '^') ADVANCE(138);
      if (lookahead == '`') ADVANCE(188);
      if (lookahead == '{') ADVANCE(84);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '}') ADVANCE(87);
      if (lookahead == '~') ADVANCE(165);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(196);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(4)
      if (lookahead != 0 &&
          lookahead > '#') ADVANCE(205);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '%') ADVANCE(153);
      if (lookahead == '&') ADVANCE(137);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(90);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '*') ADVANCE(80);
      if (lookahead == '+') ADVANCE(147);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '-') ADVANCE(150);
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == '/') ADVANCE(102);
      if (lookahead == ':') ADVANCE(93);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(98);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '>') ADVANCE(101);
      if (lookahead == '?') ADVANCE(211);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '^') ADVANCE(138);
      if (lookahead == '`') ADVANCE(188);
      if (lookahead == '{') ADVANCE(84);
      if (lookahead == '|') ADVANCE(144);
      if (lookahead == '}') ADVANCE(87);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(5)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '~') ADVANCE(205);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '%') ADVANCE(153);
      if (lookahead == '&') ADVANCE(137);
      if (lookahead == '(') ADVANCE(90);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '*') ADVANCE(80);
      if (lookahead == '+') ADVANCE(147);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '-') ADVANCE(150);
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == '/') ADVANCE(102);
      if (lookahead == ':') ADVANCE(93);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(98);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == '>') ADVANCE(101);
      if (lookahead == '?') ADVANCE(25);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '^') ADVANCE(138);
      if (lookahead == '`') ADVANCE(188);
      if (lookahead == '{') ADVANCE(84);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '}') ADVANCE(87);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(7)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(205);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '%') ADVANCE(153);
      if (lookahead == '&') ADVANCE(137);
      if (lookahead == '(') ADVANCE(90);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '*') ADVANCE(80);
      if (lookahead == '+') ADVANCE(147);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '-') ADVANCE(150);
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == '/') ADVANCE(102);
      if (lookahead == ':') ADVANCE(93);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(98);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == '>') ADVANCE(101);
      if (lookahead == '?') ADVANCE(25);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '^') ADVANCE(138);
      if (lookahead == '`') ADVANCE(188);
      if (lookahead == '{') ADVANCE(84);
      if (lookahead == '|') ADVANCE(143);
      if (lookahead == '}') ADVANCE(87);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(7)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(205);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(77);
      if (lookahead == '\\') ADVANCE(35);
      if (!sym_private_property_identifier_character_set_1(lookahead)) ADVANCE(206);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '#') ADVANCE(32);
      if (lookahead == '&') ADVANCE(135);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(90);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '+') ADVANCE(147);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '-') ADVANCE(150);
      if (lookahead == '.') ADVANCE(105);
      if (lookahead == '/') ADVANCE(102);
      if (lookahead == '0') ADVANCE(195);
      if (lookahead == ':') ADVANCE(93);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(96);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(99);
      if (lookahead == '?') ADVANCE(208);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '`') ADVANCE(188);
      if (lookahead == '{') ADVANCE(84);
      if (lookahead == '|') ADVANCE(145);
      if (lookahead == '}') ADVANCE(87);
      if (lookahead == '~') ADVANCE(165);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(196);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(9)
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '%' &&
          lookahead != '^') ADVANCE(205);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '&') ADVANCE(135);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(90);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '+') ADVANCE(147);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '-') ADVANCE(150);
      if (lookahead == '.') ADVANCE(24);
      if (lookahead == '/') ADVANCE(102);
      if (lookahead == '0') ADVANCE(195);
      if (lookahead == '<') ADVANCE(96);
      if (lookahead == '?') ADVANCE(208);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '`') ADVANCE(188);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(140);
      if (lookahead == '~') ADVANCE(165);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(196);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(10)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '>' < lookahead) &&
          lookahead != '^' &&
          lookahead != '}') ADVANCE(205);
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '&') ADVANCE(135);
      if (lookahead == '(') ADVANCE(90);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == ':') ADVANCE(93);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(96);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(99);
      if (lookahead == '?') ADVANCE(208);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '{') ADVANCE(84);
      if (lookahead == '|') ADVANCE(145);
      if (lookahead == '}') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(216);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(11)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          lookahead != '^' &&
          lookahead != '`' &&
          lookahead != '~') ADVANCE(205);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '#') ADVANCE(32);
      if (lookahead == '&') ADVANCE(135);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(90);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '+') ADVANCE(146);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '-') ADVANCE(149);
      if (lookahead == '.') ADVANCE(105);
      if (lookahead == '/') ADVANCE(190);
      if (lookahead == '0') ADVANCE(195);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(96);
      if (lookahead == '>') ADVANCE(99);
      if (lookahead == '?') ADVANCE(208);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '`') ADVANCE(188);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(145);
      if (lookahead == '}') ADVANCE(87);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(196);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(13)
      if (lookahead != 0 &&
          lookahead > '!' &&
          (lookahead < '%' || '=' < lookahead) &&
          lookahead != '^' &&
          lookahead != '~') ADVANCE(205);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '#') ADVANCE(32);
      if (lookahead == '&') ADVANCE(135);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(90);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '+') ADVANCE(146);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '-') ADVANCE(149);
      if (lookahead == '.') ADVANCE(105);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '0') ADVANCE(195);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(96);
      if (lookahead == '>') ADVANCE(99);
      if (lookahead == '?') ADVANCE(208);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '`') ADVANCE(188);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(145);
      if (lookahead == '}') ADVANCE(87);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(196);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(13)
      if (lookahead != 0 &&
          lookahead > '!' &&
          (lookahead < '%' || '=' < lookahead) &&
          lookahead != '^' &&
          lookahead != '~') ADVANCE(205);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '#') ADVANCE(32);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(90);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '-') ADVANCE(149);
      if (lookahead == '.') ADVANCE(24);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '0') ADVANCE(195);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(96);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == '{') ADVANCE(84);
      if (lookahead == '|') ADVANCE(46);
      if (lookahead == '}') ADVANCE(87);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(196);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(14)
      if (lookahead != 0 &&
          lookahead > '!' &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != ']' &&
          lookahead != '^' &&
          lookahead != '`' &&
          lookahead != '~') ADVANCE(205);
      END_STATE();
    case 15:
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '/') ADVANCE(171);
      if (lookahead == '\\') ADVANCE(37);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(174);
      if (lookahead != 0) ADVANCE(175);
      END_STATE();
    case 16:
      if (lookahead == '$') ADVANCE(38);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '\\') ADVANCE(37);
      if (lookahead == '`') ADVANCE(188);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(17)
      END_STATE();
    case 17:
      if (lookahead == '$') ADVANCE(38);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '`') ADVANCE(188);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(17)
      END_STATE();
    case 18:
      if (lookahead == '&') ADVANCE(135);
      if (lookahead == '(') ADVANCE(90);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == ':') ADVANCE(93);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '=') ADVANCE(83);
      if (lookahead == '>') ADVANCE(99);
      if (lookahead == '?') ADVANCE(209);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '{') ADVANCE(84);
      if (lookahead == '|') ADVANCE(145);
      if (lookahead == '}') ADVANCE(87);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(18)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          lookahead != '^' &&
          lookahead != '`' &&
          lookahead != '~') ADVANCE(205);
      END_STATE();
    case 19:
      if (lookahead == '&') ADVANCE(135);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '-') ADVANCE(31);
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == ':') ADVANCE(93);
      if (lookahead == '<') ADVANCE(96);
      if (lookahead == '?') ADVANCE(29);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(140);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(19)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          lookahead != '^' &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(205);
      END_STATE();
    case 20:
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '/') ADVANCE(177);
      if (lookahead == '\\') ADVANCE(37);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(180);
      if (lookahead != 0) ADVANCE(181);
      END_STATE();
    case 21:
      if (lookahead == '*') ADVANCE(23);
      if (lookahead == '/') ADVANCE(187);
      END_STATE();
    case 22:
      if (lookahead == '*') ADVANCE(22);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead != 0) ADVANCE(23);
      END_STATE();
    case 23:
      if (lookahead == '*') ADVANCE(22);
      if (lookahead != 0) ADVANCE(23);
      END_STATE();
    case 24:
      if (lookahead == '.') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(202);
      END_STATE();
    case 25:
      if (lookahead == '.') ADVANCE(108);
      if (lookahead == '?') ADVANCE(163);
      END_STATE();
    case 26:
      if (lookahead == '.') ADVANCE(124);
      END_STATE();
    case 27:
      if (lookahead == '/') ADVANCE(21);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(27)
      END_STATE();
    case 28:
      if (lookahead == ':') ADVANCE(212);
      END_STATE();
    case 29:
      if (lookahead == ':') ADVANCE(213);
      END_STATE();
    case 30:
      if (lookahead == '=') ADVANCE(158);
      END_STATE();
    case 31:
      if (lookahead == '?') ADVANCE(28);
      END_STATE();
    case 32:
      if (lookahead == '\\') ADVANCE(35);
      if (!sym_private_property_identifier_character_set_1(lookahead)) ADVANCE(206);
      END_STATE();
    case 33:
      if (lookahead == '\\') ADVANCE(72);
      if (lookahead == ']') ADVANCE(192);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(33);
      END_STATE();
    case 34:
      if (lookahead == 'u') ADVANCE(39);
      if (lookahead == 'x') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(185);
      if (lookahead != 0) ADVANCE(182);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 36:
      if (lookahead == 'u') ADVANCE(41);
      END_STATE();
    case 37:
      if (lookahead == 'u') ADVANCE(42);
      if (lookahead == 'x') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(185);
      if (lookahead != 0) ADVANCE(182);
      END_STATE();
    case 38:
      if (lookahead == '{') ADVANCE(189);
      END_STATE();
    case 39:
      if (lookahead == '{') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      END_STATE();
    case 40:
      if (lookahead == '{') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(70);
      END_STATE();
    case 41:
      if (lookahead == '{') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(71);
      END_STATE();
    case 42:
      if (lookahead == '{') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(61);
      END_STATE();
    case 43:
      if (lookahead == '}') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 44:
      if (lookahead == '}') ADVANCE(206);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 45:
      if (lookahead == '}') ADVANCE(182);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 46:
      if (lookahead == '}') ADVANCE(215);
      END_STATE();
    case 47:
      if (lookahead == '}') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 48:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(201);
      END_STATE();
    case 49:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(197);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(198);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(196);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(202);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(201);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(205);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(206);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(182);
      END_STATE();
    case 58:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(199);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(183);
      END_STATE();
    case 61:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(64);
      END_STATE();
    case 62:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 63:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 64:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      END_STATE();
    case 65:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 66:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(60);
      END_STATE();
    case 67:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 68:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 69:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(66);
      END_STATE();
    case 70:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 71:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(68);
      END_STATE();
    case 72:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(33);
      END_STATE();
    case 73:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(192);
      END_STATE();
    case 74:
      if (eof) ADVANCE(76);
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '#') ADVANCE(8);
      if (lookahead == '$') ADVANCE(204);
      if (lookahead == '%') ADVANCE(154);
      if (lookahead == '&') ADVANCE(136);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(90);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '*') ADVANCE(79);
      if (lookahead == '+') ADVANCE(148);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '-') ADVANCE(152);
      if (lookahead == '.') ADVANCE(105);
      if (lookahead == '/') ADVANCE(102);
      if (lookahead == '0') ADVANCE(195);
      if (lookahead == ':') ADVANCE(93);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(97);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(100);
      if (lookahead == '?') ADVANCE(210);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '^') ADVANCE(139);
      if (lookahead == '`') ADVANCE(188);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(142);
      if (lookahead == '}') ADVANCE(87);
      if (lookahead == '~') ADVANCE(165);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(196);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(74)
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(205);
      END_STATE();
    case 75:
      if (eof) ADVANCE(76);
      if (lookahead == '!') ADVANCE(89);
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '#') ADVANCE(8);
      if (lookahead == '%') ADVANCE(154);
      if (lookahead == '&') ADVANCE(136);
      if (lookahead == '\'') ADVANCE(169);
      if (lookahead == '(') ADVANCE(90);
      if (lookahead == ')') ADVANCE(91);
      if (lookahead == '*') ADVANCE(79);
      if (lookahead == '+') ADVANCE(148);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '-') ADVANCE(151);
      if (lookahead == '.') ADVANCE(105);
      if (lookahead == '/') ADVANCE(103);
      if (lookahead == '0') ADVANCE(195);
      if (lookahead == ':') ADVANCE(93);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(97);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(100);
      if (lookahead == '?') ADVANCE(210);
      if (lookahead == '@') ADVANCE(207);
      if (lookahead == '[') ADVANCE(94);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == ']') ADVANCE(95);
      if (lookahead == '^') ADVANCE(139);
      if (lookahead == '`') ADVANCE(188);
      if (lookahead == '{') ADVANCE(85);
      if (lookahead == '|') ADVANCE(141);
      if (lookahead == '}') ADVANCE(87);
      if (lookahead == '~') ADVANCE(165);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(196);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(75)
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(205);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(77);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(156);
      if (lookahead == '=') ADVANCE(111);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(155);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(158);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(158);
      if (lookahead == '>') ADVANCE(107);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(107);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '|') ADVANCE(214);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(160);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(134);
      if (lookahead == '=') ADVANCE(157);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(133);
      if (lookahead == '=') ADVANCE(157);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(129);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(130);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(23);
      if (lookahead == '/') ADVANCE(187);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(23);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '=') ADVANCE(112);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(202);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(202);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(117);
      if (lookahead == '>') ADVANCE(132);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(131);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(126);
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(125);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(116);
      if (lookahead == '|') ADVANCE(128);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(116);
      if (lookahead == '|') ADVANCE(128);
      if (lookahead == '}') ADVANCE(215);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(127);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(127);
      if (lookahead == '}') ADVANCE(215);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '}') ADVANCE(215);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(166);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(167);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '=') ADVANCE(110);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '=') ADVANCE(110);
      if (lookahead == '?') ADVANCE(28);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(113);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(159);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(161);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '\n') ADVANCE(175);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(170);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(173);
      if (lookahead == '/') ADVANCE(170);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(175);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(172);
      if (lookahead == '/') ADVANCE(175);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(173);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(172);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(173);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(171);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(174);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(175);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(175);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '\n') ADVANCE(181);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(176);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(179);
      if (lookahead == '/') ADVANCE(176);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(181);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(178);
      if (lookahead == '/') ADVANCE(181);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(179);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(178);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(179);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '/') ADVANCE(177);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(180);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(181);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(181);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(36);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(205);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(182);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(184);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(187);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      if (lookahead == '*') ADVANCE(23);
      if (lookahead == '/') ADVANCE(187);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(27)
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '[') ADVANCE(33);
      if (lookahead == '\\') ADVANCE(73);
      if (sym_regex_pattern_character_set_1(lookahead)) ADVANCE(191);
      if (lookahead != 0) ADVANCE(192);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(33);
      if (lookahead == '\\') ADVANCE(73);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(192);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(36);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(193);
      if (!sym_identifier_character_set_2(lookahead)) ADVANCE(205);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(203);
      if (lookahead == '0') ADVANCE(200);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(49);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(48);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(50);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(58);
      if (lookahead == '_') ADVANCE(53);
      if (lookahead == 'n') ADVANCE(194);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(196);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(203);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(48);
      if (lookahead == '_') ADVANCE(51);
      if (lookahead == 'n') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(196);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(49);
      if (lookahead == 'n') ADVANCE(194);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(197);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(50);
      if (lookahead == 'n') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(198);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(58);
      if (lookahead == 'n') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(199);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(53);
      if (lookahead == 'n') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(201);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(48);
      if (lookahead == '_') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(202);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(202);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == '{') ADVANCE(189);
      if (!sym_identifier_character_set_3(lookahead)) ADVANCE(205);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(36);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(205);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_private_property_identifier);
      if (lookahead == '\\') ADVANCE(35);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(206);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(108);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(108);
      if (lookahead == '?') ADVANCE(164);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(108);
      if (lookahead == '?') ADVANCE(163);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_DASH_QMARK_COLON);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_QMARK_COLON);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_LBRACE_PIPE);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_PIPE_RBRACE);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(aux_sym_ui_version_specifier_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(216);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'k') ADVANCE(9);
      if (lookahead == 'l') ADVANCE(10);
      if (lookahead == 'm') ADVANCE(11);
      if (lookahead == 'n') ADVANCE(12);
      if (lookahead == 'o') ADVANCE(13);
      if (lookahead == 'p') ADVANCE(14);
      if (lookahead == 'r') ADVANCE(15);
      if (lookahead == 's') ADVANCE(16);
      if (lookahead == 't') ADVANCE(17);
      if (lookahead == 'u') ADVANCE(18);
      if (lookahead == 'v') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8203) ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 8288 ||
          lookahead == 12288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(23);
      if (lookahead == 's') ADVANCE(24);
      if (lookahead == 'w') ADVANCE(25);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(26);
      if (lookahead == 'r') ADVANCE(27);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(28);
      if (lookahead == 'l') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(33);
      if (lookahead == 'n') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(36);
      if (lookahead == 'i') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(38);
      if (lookahead == 'r') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(41);
      if (lookahead == 'l') ADVANCE(42);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(43);
      if (lookahead == 'm') ADVANCE(44);
      if (lookahead == 'n') ADVANCE(45);
      if (lookahead == 's') ADVANCE(46);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'i') ADVANCE(49);
      END_STATE();
    case 11:
      if (lookahead == 'o') ADVANCE(50);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(51);
      if (lookahead == 'e') ADVANCE(52);
      if (lookahead == 'u') ADVANCE(53);
      END_STATE();
    case 13:
      if (lookahead == 'b') ADVANCE(54);
      if (lookahead == 'f') ADVANCE(55);
      if (lookahead == 'n') ADVANCE(56);
      if (lookahead == 'v') ADVANCE(57);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(58);
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(62);
      if (lookahead == 't') ADVANCE(63);
      if (lookahead == 'u') ADVANCE(64);
      if (lookahead == 'w') ADVANCE(65);
      if (lookahead == 'y') ADVANCE(66);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(67);
      if (lookahead == 'h') ADVANCE(68);
      if (lookahead == 'r') ADVANCE(69);
      if (lookahead == 'y') ADVANCE(70);
      END_STATE();
    case 18:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(72);
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(74);
      if (lookahead == 'i') ADVANCE(75);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(76);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 23:
      if (lookahead == 'y') ADVANCE(78);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(79);
      if (lookahead == 'y') ADVANCE(80);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(81);
      END_STATE();
    case 26:
      if (lookahead == 'o') ADVANCE(82);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(84);
      if (lookahead == 't') ADVANCE(85);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(86);
      END_STATE();
    case 30:
      if (lookahead == 'm') ADVANCE(87);
      if (lookahead == 'n') ADVANCE(88);
      END_STATE();
    case 31:
      if (lookahead == 'b') ADVANCE(89);
      if (lookahead == 'c') ADVANCE(90);
      if (lookahead == 'f') ADVANCE(91);
      if (lookahead == 'l') ADVANCE(92);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 33:
      if (lookahead == 's') ADVANCE(93);
      END_STATE();
    case 34:
      if (lookahead == 'u') ADVANCE(94);
      END_STATE();
    case 35:
      if (lookahead == 'p') ADVANCE(95);
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 36:
      if (lookahead == 'l') ADVANCE(97);
      END_STATE();
    case 37:
      if (lookahead == 'n') ADVANCE(98);
      END_STATE();
    case 38:
      if (lookahead == 'r') ADVANCE(99);
      END_STATE();
    case 39:
      if (lookahead == 'o') ADVANCE(100);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(101);
      END_STATE();
    case 41:
      if (lookahead == 't') ADVANCE(102);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(103);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 44:
      if (lookahead == 'p') ADVANCE(104);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'f') ADVANCE(105);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == 't') ADVANCE(107);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 47:
      if (lookahead == 'y') ADVANCE(108);
      END_STATE();
    case 48:
      if (lookahead == 't') ADVANCE(109);
      END_STATE();
    case 49:
      if (lookahead == 's') ADVANCE(110);
      END_STATE();
    case 50:
      if (lookahead == 'd') ADVANCE(111);
      END_STATE();
    case 51:
      if (lookahead == 'm') ADVANCE(112);
      END_STATE();
    case 52:
      if (lookahead == 'v') ADVANCE(113);
      if (lookahead == 'w') ADVANCE(114);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(115);
      if (lookahead == 'm') ADVANCE(116);
      END_STATE();
    case 54:
      if (lookahead == 'j') ADVANCE(117);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_on);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(119);
      if (lookahead == 'i') ADVANCE(120);
      if (lookahead == 'o') ADVANCE(121);
      END_STATE();
    case 59:
      if (lookahead == 'b') ADVANCE(122);
      END_STATE();
    case 60:
      if (lookahead == 'a') ADVANCE(123);
      if (lookahead == 'q') ADVANCE(124);
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 62:
      if (lookahead == 'g') ADVANCE(127);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(128);
      if (lookahead == 'r') ADVANCE(129);
      END_STATE();
    case 64:
      if (lookahead == 'p') ADVANCE(130);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(131);
      END_STATE();
    case 66:
      if (lookahead == 'm') ADVANCE(132);
      END_STATE();
    case 67:
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(134);
      if (lookahead == 'r') ADVANCE(135);
      END_STATE();
    case 69:
      if (lookahead == 'u') ADVANCE(136);
      if (lookahead == 'y') ADVANCE(137);
      END_STATE();
    case 70:
      if (lookahead == 'p') ADVANCE(138);
      END_STATE();
    case 71:
      if (lookahead == 'd') ADVANCE(139);
      if (lookahead == 'k') ADVANCE(140);
      END_STATE();
    case 72:
      if (lookahead == 'r') ADVANCE(141);
      END_STATE();
    case 73:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 74:
      if (lookahead == 'i') ADVANCE(143);
      END_STATE();
    case 75:
      if (lookahead == 't') ADVANCE(144);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 77:
      if (lookahead == 't') ADVANCE(146);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_any);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(147);
      END_STATE();
    case 80:
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 81:
      if (lookahead == 'i') ADVANCE(149);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(150);
      END_STATE();
    case 83:
      if (lookahead == 'a') ADVANCE(151);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 85:
      if (lookahead == 'c') ADVANCE(153);
      END_STATE();
    case 86:
      if (lookahead == 's') ADVANCE(154);
      END_STATE();
    case 87:
      if (lookahead == 'p') ADVANCE(155);
      END_STATE();
    case 88:
      if (lookahead == 's') ADVANCE(156);
      if (lookahead == 't') ADVANCE(157);
      END_STATE();
    case 89:
      if (lookahead == 'u') ADVANCE(158);
      END_STATE();
    case 90:
      if (lookahead == 'l') ADVANCE(159);
      END_STATE();
    case 91:
      if (lookahead == 'a') ADVANCE(160);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(161);
      END_STATE();
    case 93:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 94:
      if (lookahead == 'm') ADVANCE(163);
      END_STATE();
    case 95:
      if (lookahead == 'o') ADVANCE(164);
      END_STATE();
    case 96:
      if (lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 97:
      if (lookahead == 's') ADVANCE(166);
      END_STATE();
    case 98:
      if (lookahead == 'a') ADVANCE(167);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 100:
      if (lookahead == 'm') ADVANCE(168);
      END_STATE();
    case 101:
      if (lookahead == 'c') ADVANCE(169);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 103:
      if (lookahead == 'b') ADVANCE(170);
      END_STATE();
    case 104:
      if (lookahead == 'l') ADVANCE(171);
      if (lookahead == 'o') ADVANCE(172);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(173);
      END_STATE();
    case 106:
      if (lookahead == 't') ADVANCE(174);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 108:
      if (lookahead == 'o') ADVANCE(176);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 110:
      if (lookahead == 't') ADVANCE(177);
      END_STATE();
    case 111:
      if (lookahead == 'u') ADVANCE(178);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(179);
      END_STATE();
    case 113:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 115:
      if (lookahead == 'l') ADVANCE(181);
      END_STATE();
    case 116:
      if (lookahead == 'b') ADVANCE(182);
      END_STATE();
    case 117:
      if (lookahead == 'e') ADVANCE(183);
      END_STATE();
    case 118:
      if (lookahead == 'r') ADVANCE(184);
      END_STATE();
    case 119:
      if (lookahead == 'g') ADVANCE(185);
      END_STATE();
    case 120:
      if (lookahead == 'v') ADVANCE(186);
      END_STATE();
    case 121:
      if (lookahead == 'p') ADVANCE(187);
      if (lookahead == 't') ADVANCE(188);
      END_STATE();
    case 122:
      if (lookahead == 'l') ADVANCE(189);
      END_STATE();
    case 123:
      if (lookahead == 'd') ADVANCE(190);
      END_STATE();
    case 124:
      if (lookahead == 'u') ADVANCE(191);
      END_STATE();
    case 125:
      if (lookahead == 'u') ADVANCE(192);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 127:
      if (lookahead == 'n') ADVANCE(193);
      END_STATE();
    case 128:
      if (lookahead == 't') ADVANCE(194);
      END_STATE();
    case 129:
      if (lookahead == 'i') ADVANCE(195);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(196);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(197);
      END_STATE();
    case 132:
      if (lookahead == 'b') ADVANCE(198);
      END_STATE();
    case 133:
      if (lookahead == 'g') ADVANCE(199);
      END_STATE();
    case 134:
      if (lookahead == 's') ADVANCE(200);
      END_STATE();
    case 135:
      if (lookahead == 'o') ADVANCE(201);
      END_STATE();
    case 136:
      if (lookahead == 'e') ADVANCE(202);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(203);
      END_STATE();
    case 139:
      if (lookahead == 'e') ADVANCE(204);
      END_STATE();
    case 140:
      if (lookahead == 'n') ADVANCE(205);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 142:
      if (lookahead == 'd') ADVANCE(206);
      END_STATE();
    case 143:
      if (lookahead == 'l') ADVANCE(207);
      END_STATE();
    case 144:
      if (lookahead == 'h') ADVANCE(208);
      END_STATE();
    case 145:
      if (lookahead == 'l') ADVANCE(209);
      END_STATE();
    case 146:
      if (lookahead == 'r') ADVANCE(210);
      END_STATE();
    case 147:
      if (lookahead == 'r') ADVANCE(211);
      END_STATE();
    case 148:
      if (lookahead == 'c') ADVANCE(212);
      END_STATE();
    case 149:
      if (lookahead == 't') ADVANCE(213);
      END_STATE();
    case 150:
      if (lookahead == 'e') ADVANCE(214);
      END_STATE();
    case 151:
      if (lookahead == 'k') ADVANCE(215);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 153:
      if (lookahead == 'h') ADVANCE(216);
      END_STATE();
    case 154:
      if (lookahead == 's') ADVANCE(217);
      END_STATE();
    case 155:
      if (lookahead == 'o') ADVANCE(218);
      END_STATE();
    case 156:
      if (lookahead == 't') ADVANCE(219);
      END_STATE();
    case 157:
      if (lookahead == 'i') ADVANCE(220);
      END_STATE();
    case 158:
      if (lookahead == 'g') ADVANCE(221);
      END_STATE();
    case 159:
      if (lookahead == 'a') ADVANCE(222);
      END_STATE();
    case 160:
      if (lookahead == 'u') ADVANCE(223);
      END_STATE();
    case 161:
      if (lookahead == 't') ADVANCE(224);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 164:
      if (lookahead == 'r') ADVANCE(225);
      END_STATE();
    case 165:
      if (lookahead == 'n') ADVANCE(226);
      END_STATE();
    case 166:
      if (lookahead == 'e') ADVANCE(227);
      END_STATE();
    case 167:
      if (lookahead == 'l') ADVANCE(228);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 169:
      if (lookahead == 't') ADVANCE(229);
      END_STATE();
    case 170:
      if (lookahead == 'a') ADVANCE(230);
      END_STATE();
    case 171:
      if (lookahead == 'e') ADVANCE(231);
      END_STATE();
    case 172:
      if (lookahead == 'r') ADVANCE(232);
      END_STATE();
    case 173:
      if (lookahead == 'r') ADVANCE(233);
      END_STATE();
    case 174:
      if (lookahead == 'a') ADVANCE(234);
      END_STATE();
    case 175:
      if (lookahead == 'r') ADVANCE(235);
      END_STATE();
    case 176:
      if (lookahead == 'f') ADVANCE(236);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_list);
      END_STATE();
    case 178:
      if (lookahead == 'l') ADVANCE(237);
      END_STATE();
    case 179:
      if (lookahead == 's') ADVANCE(238);
      END_STATE();
    case 180:
      if (lookahead == 'r') ADVANCE(239);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(240);
      END_STATE();
    case 183:
      if (lookahead == 'c') ADVANCE(241);
      END_STATE();
    case 184:
      if (lookahead == 'r') ADVANCE(242);
      END_STATE();
    case 185:
      if (lookahead == 'm') ADVANCE(243);
      END_STATE();
    case 186:
      if (lookahead == 'a') ADVANCE(244);
      END_STATE();
    case 187:
      if (lookahead == 'e') ADVANCE(245);
      END_STATE();
    case 188:
      if (lookahead == 'e') ADVANCE(246);
      END_STATE();
    case 189:
      if (lookahead == 'i') ADVANCE(247);
      END_STATE();
    case 190:
      if (lookahead == 'o') ADVANCE(248);
      END_STATE();
    case 191:
      if (lookahead == 'i') ADVANCE(249);
      END_STATE();
    case 192:
      if (lookahead == 'r') ADVANCE(250);
      END_STATE();
    case 193:
      if (lookahead == 'a') ADVANCE(251);
      END_STATE();
    case 194:
      if (lookahead == 'i') ADVANCE(252);
      END_STATE();
    case 195:
      if (lookahead == 'n') ADVANCE(253);
      END_STATE();
    case 196:
      if (lookahead == 'r') ADVANCE(254);
      END_STATE();
    case 197:
      if (lookahead == 'c') ADVANCE(255);
      END_STATE();
    case 198:
      if (lookahead == 'o') ADVANCE(256);
      END_STATE();
    case 199:
      if (lookahead == 'e') ADVANCE(257);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 201:
      if (lookahead == 'w') ADVANCE(258);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == 'o') ADVANCE(259);
      END_STATE();
    case 204:
      if (lookahead == 'f') ADVANCE(260);
      END_STATE();
    case 205:
      if (lookahead == 'o') ADVANCE(261);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 207:
      if (lookahead == 'e') ADVANCE(262);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 209:
      if (lookahead == 'd') ADVANCE(263);
      END_STATE();
    case 210:
      if (lookahead == 'a') ADVANCE(264);
      END_STATE();
    case 211:
      if (lookahead == 't') ADVANCE(265);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 214:
      if (lookahead == 'a') ADVANCE(266);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 218:
      if (lookahead == 'n') ADVANCE(267);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 220:
      if (lookahead == 'n') ADVANCE(268);
      END_STATE();
    case 221:
      if (lookahead == 'g') ADVANCE(269);
      END_STATE();
    case 222:
      if (lookahead == 'r') ADVANCE(270);
      END_STATE();
    case 223:
      if (lookahead == 'l') ADVANCE(271);
      END_STATE();
    case 224:
      if (lookahead == 'e') ADVANCE(272);
      END_STATE();
    case 225:
      if (lookahead == 't') ADVANCE(273);
      END_STATE();
    case 226:
      if (lookahead == 'd') ADVANCE(274);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 228:
      if (lookahead == 'l') ADVANCE(275);
      END_STATE();
    case 229:
      if (lookahead == 'i') ADVANCE(276);
      END_STATE();
    case 230:
      if (lookahead == 'l') ADVANCE(277);
      END_STATE();
    case 231:
      if (lookahead == 'm') ADVANCE(278);
      END_STATE();
    case 232:
      if (lookahead == 't') ADVANCE(279);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_infer);
      END_STATE();
    case 234:
      if (lookahead == 'n') ADVANCE(280);
      END_STATE();
    case 235:
      if (lookahead == 'f') ADVANCE(281);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_keyof);
      END_STATE();
    case 237:
      if (lookahead == 'e') ADVANCE(282);
      END_STATE();
    case 238:
      if (lookahead == 'p') ADVANCE(283);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_never);
      END_STATE();
    case 240:
      if (lookahead == 'r') ADVANCE(284);
      END_STATE();
    case 241:
      if (lookahead == 't') ADVANCE(285);
      END_STATE();
    case 242:
      if (lookahead == 'i') ADVANCE(286);
      END_STATE();
    case 243:
      if (lookahead == 'a') ADVANCE(287);
      END_STATE();
    case 244:
      if (lookahead == 't') ADVANCE(288);
      END_STATE();
    case 245:
      if (lookahead == 'r') ADVANCE(289);
      END_STATE();
    case 246:
      if (lookahead == 'c') ADVANCE(290);
      END_STATE();
    case 247:
      if (lookahead == 'c') ADVANCE(291);
      END_STATE();
    case 248:
      if (lookahead == 'n') ADVANCE(292);
      END_STATE();
    case 249:
      if (lookahead == 'r') ADVANCE(293);
      END_STATE();
    case 250:
      if (lookahead == 'n') ADVANCE(294);
      END_STATE();
    case 251:
      if (lookahead == 'l') ADVANCE(295);
      END_STATE();
    case 252:
      if (lookahead == 'c') ADVANCE(296);
      END_STATE();
    case 253:
      if (lookahead == 'g') ADVANCE(297);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 255:
      if (lookahead == 'h') ADVANCE(298);
      END_STATE();
    case 256:
      if (lookahead == 'l') ADVANCE(299);
      END_STATE();
    case 257:
      if (lookahead == 't') ADVANCE(300);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 259:
      if (lookahead == 'f') ADVANCE(301);
      END_STATE();
    case 260:
      if (lookahead == 'i') ADVANCE(302);
      END_STATE();
    case 261:
      if (lookahead == 'w') ADVANCE(303);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 264:
      if (lookahead == 'c') ADVANCE(304);
      END_STATE();
    case 265:
      if (lookahead == 's') ADVANCE(305);
      END_STATE();
    case 266:
      if (lookahead == 'n') ADVANCE(306);
      END_STATE();
    case 267:
      if (lookahead == 'e') ADVANCE(307);
      END_STATE();
    case 268:
      if (lookahead == 'u') ADVANCE(308);
      END_STATE();
    case 269:
      if (lookahead == 'e') ADVANCE(309);
      END_STATE();
    case 270:
      if (lookahead == 'e') ADVANCE(310);
      END_STATE();
    case 271:
      if (lookahead == 't') ADVANCE(311);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 274:
      if (lookahead == 's') ADVANCE(312);
      END_STATE();
    case 275:
      if (lookahead == 'y') ADVANCE(313);
      END_STATE();
    case 276:
      if (lookahead == 'o') ADVANCE(314);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 278:
      if (lookahead == 'e') ADVANCE(315);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 280:
      if (lookahead == 'c') ADVANCE(316);
      END_STATE();
    case 281:
      if (lookahead == 'a') ADVANCE(317);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 283:
      if (lookahead == 'a') ADVANCE(318);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_number);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_object);
      END_STATE();
    case 286:
      if (lookahead == 'd') ADVANCE(319);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_pragma);
      END_STATE();
    case 288:
      if (lookahead == 'e') ADVANCE(320);
      END_STATE();
    case 289:
      if (lookahead == 't') ADVANCE(321);
      END_STATE();
    case 290:
      if (lookahead == 't') ADVANCE(322);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 292:
      if (lookahead == 'l') ADVANCE(323);
      END_STATE();
    case 293:
      if (lookahead == 'e') ADVANCE(324);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_signal);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_symbol);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 302:
      if (lookahead == 'n') ADVANCE(325);
      END_STATE();
    case 303:
      if (lookahead == 'n') ADVANCE(326);
      END_STATE();
    case 304:
      if (lookahead == 't') ADVANCE(327);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_asserts);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 307:
      if (lookahead == 'n') ADVANCE(328);
      END_STATE();
    case 308:
      if (lookahead == 'e') ADVANCE(329);
      END_STATE();
    case 309:
      if (lookahead == 'r') ADVANCE(330);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 314:
      if (lookahead == 'n') ADVANCE(331);
      END_STATE();
    case 315:
      if (lookahead == 'n') ADVANCE(332);
      END_STATE();
    case 316:
      if (lookahead == 'e') ADVANCE(333);
      END_STATE();
    case 317:
      if (lookahead == 'c') ADVANCE(334);
      END_STATE();
    case 318:
      if (lookahead == 'c') ADVANCE(335);
      END_STATE();
    case 319:
      if (lookahead == 'e') ADVANCE(336);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 321:
      if (lookahead == 'y') ADVANCE(337);
      END_STATE();
    case 322:
      if (lookahead == 'e') ADVANCE(338);
      END_STATE();
    case 323:
      if (lookahead == 'y') ADVANCE(339);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_require);
      if (lookahead == 'd') ADVANCE(340);
      END_STATE();
    case 325:
      if (lookahead == 'e') ADVANCE(341);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_unknown);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 328:
      if (lookahead == 't') ADVANCE(342);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 332:
      if (lookahead == 't') ADVANCE(343);
      END_STATE();
    case 333:
      if (lookahead == 'o') ADVANCE(344);
      END_STATE();
    case 334:
      if (lookahead == 'e') ADVANCE(345);
      END_STATE();
    case 335:
      if (lookahead == 'e') ADVANCE(346);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_property);
      END_STATE();
    case 338:
      if (lookahead == 'd') ADVANCE(347);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_required);
      END_STATE();
    case 341:
      if (lookahead == 'd') ADVANCE(348);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_component);
      END_STATE();
    case 343:
      if (lookahead == 's') ADVANCE(349);
      END_STATE();
    case 344:
      if (lookahead == 'f') ADVANCE(350);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 75},
  [2] = {.lex_state = 75, .external_lex_state = 2},
  [3] = {.lex_state = 75, .external_lex_state = 2},
  [4] = {.lex_state = 9},
  [5] = {.lex_state = 9},
  [6] = {.lex_state = 9},
  [7] = {.lex_state = 9},
  [8] = {.lex_state = 9},
  [9] = {.lex_state = 9},
  [10] = {.lex_state = 9},
  [11] = {.lex_state = 9},
  [12] = {.lex_state = 9},
  [13] = {.lex_state = 9},
  [14] = {.lex_state = 9},
  [15] = {.lex_state = 9},
  [16] = {.lex_state = 9},
  [17] = {.lex_state = 9},
  [18] = {.lex_state = 9},
  [19] = {.lex_state = 9},
  [20] = {.lex_state = 9},
  [21] = {.lex_state = 9},
  [22] = {.lex_state = 9},
  [23] = {.lex_state = 9},
  [24] = {.lex_state = 9},
  [25] = {.lex_state = 9},
  [26] = {.lex_state = 9},
  [27] = {.lex_state = 9},
  [28] = {.lex_state = 9},
  [29] = {.lex_state = 9},
  [30] = {.lex_state = 9},
  [31] = {.lex_state = 9},
  [32] = {.lex_state = 9},
  [33] = {.lex_state = 9},
  [34] = {.lex_state = 9},
  [35] = {.lex_state = 9},
  [36] = {.lex_state = 9},
  [37] = {.lex_state = 9},
  [38] = {.lex_state = 9},
  [39] = {.lex_state = 9},
  [40] = {.lex_state = 9},
  [41] = {.lex_state = 9},
  [42] = {.lex_state = 9},
  [43] = {.lex_state = 9},
  [44] = {.lex_state = 9},
  [45] = {.lex_state = 9},
  [46] = {.lex_state = 9},
  [47] = {.lex_state = 9},
  [48] = {.lex_state = 9},
  [49] = {.lex_state = 9},
  [50] = {.lex_state = 9},
  [51] = {.lex_state = 9},
  [52] = {.lex_state = 9},
  [53] = {.lex_state = 9},
  [54] = {.lex_state = 9},
  [55] = {.lex_state = 9},
  [56] = {.lex_state = 9},
  [57] = {.lex_state = 9},
  [58] = {.lex_state = 9},
  [59] = {.lex_state = 9},
  [60] = {.lex_state = 9},
  [61] = {.lex_state = 10},
  [62] = {.lex_state = 10},
  [63] = {.lex_state = 10},
  [64] = {.lex_state = 10},
  [65] = {.lex_state = 10},
  [66] = {.lex_state = 10},
  [67] = {.lex_state = 10},
  [68] = {.lex_state = 10},
  [69] = {.lex_state = 10},
  [70] = {.lex_state = 10},
  [71] = {.lex_state = 2, .external_lex_state = 2},
  [72] = {.lex_state = 2, .external_lex_state = 2},
  [73] = {.lex_state = 2, .external_lex_state = 2},
  [74] = {.lex_state = 2, .external_lex_state = 2},
  [75] = {.lex_state = 2, .external_lex_state = 2},
  [76] = {.lex_state = 2, .external_lex_state = 2},
  [77] = {.lex_state = 2, .external_lex_state = 2},
  [78] = {.lex_state = 2, .external_lex_state = 2},
  [79] = {.lex_state = 10},
  [80] = {.lex_state = 10},
  [81] = {.lex_state = 10},
  [82] = {.lex_state = 10},
  [83] = {.lex_state = 10},
  [84] = {.lex_state = 10},
  [85] = {.lex_state = 10},
  [86] = {.lex_state = 10},
  [87] = {.lex_state = 10},
  [88] = {.lex_state = 10},
  [89] = {.lex_state = 10},
  [90] = {.lex_state = 10},
  [91] = {.lex_state = 10},
  [92] = {.lex_state = 10},
  [93] = {.lex_state = 10},
  [94] = {.lex_state = 10},
  [95] = {.lex_state = 10},
  [96] = {.lex_state = 10},
  [97] = {.lex_state = 10},
  [98] = {.lex_state = 10},
  [99] = {.lex_state = 10},
  [100] = {.lex_state = 4, .external_lex_state = 2},
  [101] = {.lex_state = 4, .external_lex_state = 3},
  [102] = {.lex_state = 4, .external_lex_state = 3},
  [103] = {.lex_state = 4, .external_lex_state = 3},
  [104] = {.lex_state = 4, .external_lex_state = 2},
  [105] = {.lex_state = 4, .external_lex_state = 2},
  [106] = {.lex_state = 4, .external_lex_state = 2},
  [107] = {.lex_state = 4, .external_lex_state = 2},
  [108] = {.lex_state = 4, .external_lex_state = 2},
  [109] = {.lex_state = 9},
  [110] = {.lex_state = 9},
  [111] = {.lex_state = 9},
  [112] = {.lex_state = 9},
  [113] = {.lex_state = 9},
  [114] = {.lex_state = 9},
  [115] = {.lex_state = 9},
  [116] = {.lex_state = 9},
  [117] = {.lex_state = 9},
  [118] = {.lex_state = 9},
  [119] = {.lex_state = 9},
  [120] = {.lex_state = 9},
  [121] = {.lex_state = 9},
  [122] = {.lex_state = 9},
  [123] = {.lex_state = 9},
  [124] = {.lex_state = 9},
  [125] = {.lex_state = 9},
  [126] = {.lex_state = 9},
  [127] = {.lex_state = 75, .external_lex_state = 2},
  [128] = {.lex_state = 75, .external_lex_state = 3},
  [129] = {.lex_state = 75, .external_lex_state = 3},
  [130] = {.lex_state = 75, .external_lex_state = 2},
  [131] = {.lex_state = 75, .external_lex_state = 2},
  [132] = {.lex_state = 4, .external_lex_state = 3},
  [133] = {.lex_state = 75, .external_lex_state = 3},
  [134] = {.lex_state = 75, .external_lex_state = 2},
  [135] = {.lex_state = 9},
  [136] = {.lex_state = 9},
  [137] = {.lex_state = 75, .external_lex_state = 2},
  [138] = {.lex_state = 9},
  [139] = {.lex_state = 9},
  [140] = {.lex_state = 4, .external_lex_state = 3},
  [141] = {.lex_state = 4, .external_lex_state = 3},
  [142] = {.lex_state = 75, .external_lex_state = 2},
  [143] = {.lex_state = 4, .external_lex_state = 3},
  [144] = {.lex_state = 4, .external_lex_state = 3},
  [145] = {.lex_state = 4, .external_lex_state = 3},
  [146] = {.lex_state = 9},
  [147] = {.lex_state = 4, .external_lex_state = 3},
  [148] = {.lex_state = 4, .external_lex_state = 3},
  [149] = {.lex_state = 4, .external_lex_state = 3},
  [150] = {.lex_state = 4, .external_lex_state = 3},
  [151] = {.lex_state = 4, .external_lex_state = 3},
  [152] = {.lex_state = 4, .external_lex_state = 3},
  [153] = {.lex_state = 9},
  [154] = {.lex_state = 4, .external_lex_state = 3},
  [155] = {.lex_state = 75, .external_lex_state = 2},
  [156] = {.lex_state = 4, .external_lex_state = 3},
  [157] = {.lex_state = 9},
  [158] = {.lex_state = 4, .external_lex_state = 3},
  [159] = {.lex_state = 4, .external_lex_state = 3},
  [160] = {.lex_state = 9},
  [161] = {.lex_state = 4, .external_lex_state = 3},
  [162] = {.lex_state = 75, .external_lex_state = 2},
  [163] = {.lex_state = 4, .external_lex_state = 3},
  [164] = {.lex_state = 75, .external_lex_state = 2},
  [165] = {.lex_state = 9},
  [166] = {.lex_state = 4, .external_lex_state = 3},
  [167] = {.lex_state = 9},
  [168] = {.lex_state = 9},
  [169] = {.lex_state = 9},
  [170] = {.lex_state = 4, .external_lex_state = 3},
  [171] = {.lex_state = 9},
  [172] = {.lex_state = 4, .external_lex_state = 3},
  [173] = {.lex_state = 75, .external_lex_state = 2},
  [174] = {.lex_state = 4, .external_lex_state = 3},
  [175] = {.lex_state = 4, .external_lex_state = 3},
  [176] = {.lex_state = 4, .external_lex_state = 3},
  [177] = {.lex_state = 4, .external_lex_state = 3},
  [178] = {.lex_state = 4, .external_lex_state = 3},
  [179] = {.lex_state = 4, .external_lex_state = 3},
  [180] = {.lex_state = 9},
  [181] = {.lex_state = 9},
  [182] = {.lex_state = 9},
  [183] = {.lex_state = 9},
  [184] = {.lex_state = 9},
  [185] = {.lex_state = 9},
  [186] = {.lex_state = 9},
  [187] = {.lex_state = 9},
  [188] = {.lex_state = 75, .external_lex_state = 2},
  [189] = {.lex_state = 9},
  [190] = {.lex_state = 9},
  [191] = {.lex_state = 9},
  [192] = {.lex_state = 9},
  [193] = {.lex_state = 9},
  [194] = {.lex_state = 9, .external_lex_state = 4},
  [195] = {.lex_state = 9},
  [196] = {.lex_state = 2, .external_lex_state = 2},
  [197] = {.lex_state = 9},
  [198] = {.lex_state = 9},
  [199] = {.lex_state = 9},
  [200] = {.lex_state = 9},
  [201] = {.lex_state = 9},
  [202] = {.lex_state = 9},
  [203] = {.lex_state = 2, .external_lex_state = 2},
  [204] = {.lex_state = 9},
  [205] = {.lex_state = 2, .external_lex_state = 2},
  [206] = {.lex_state = 2, .external_lex_state = 2},
  [207] = {.lex_state = 9},
  [208] = {.lex_state = 9},
  [209] = {.lex_state = 9},
  [210] = {.lex_state = 9},
  [211] = {.lex_state = 9},
  [212] = {.lex_state = 9},
  [213] = {.lex_state = 9},
  [214] = {.lex_state = 9},
  [215] = {.lex_state = 9},
  [216] = {.lex_state = 9},
  [217] = {.lex_state = 9},
  [218] = {.lex_state = 9},
  [219] = {.lex_state = 9},
  [220] = {.lex_state = 9},
  [221] = {.lex_state = 9},
  [222] = {.lex_state = 9},
  [223] = {.lex_state = 9},
  [224] = {.lex_state = 9},
  [225] = {.lex_state = 9},
  [226] = {.lex_state = 9},
  [227] = {.lex_state = 9},
  [228] = {.lex_state = 9},
  [229] = {.lex_state = 9},
  [230] = {.lex_state = 9},
  [231] = {.lex_state = 9},
  [232] = {.lex_state = 9, .external_lex_state = 4},
  [233] = {.lex_state = 9},
  [234] = {.lex_state = 9},
  [235] = {.lex_state = 9},
  [236] = {.lex_state = 9},
  [237] = {.lex_state = 9},
  [238] = {.lex_state = 9, .external_lex_state = 4},
  [239] = {.lex_state = 9},
  [240] = {.lex_state = 9},
  [241] = {.lex_state = 9},
  [242] = {.lex_state = 9},
  [243] = {.lex_state = 9},
  [244] = {.lex_state = 9},
  [245] = {.lex_state = 9},
  [246] = {.lex_state = 9},
  [247] = {.lex_state = 9},
  [248] = {.lex_state = 9},
  [249] = {.lex_state = 9},
  [250] = {.lex_state = 9},
  [251] = {.lex_state = 9},
  [252] = {.lex_state = 9},
  [253] = {.lex_state = 9},
  [254] = {.lex_state = 9},
  [255] = {.lex_state = 9},
  [256] = {.lex_state = 9},
  [257] = {.lex_state = 9},
  [258] = {.lex_state = 9},
  [259] = {.lex_state = 9},
  [260] = {.lex_state = 9},
  [261] = {.lex_state = 9},
  [262] = {.lex_state = 9},
  [263] = {.lex_state = 9},
  [264] = {.lex_state = 9},
  [265] = {.lex_state = 9},
  [266] = {.lex_state = 9},
  [267] = {.lex_state = 9},
  [268] = {.lex_state = 9},
  [269] = {.lex_state = 9},
  [270] = {.lex_state = 9},
  [271] = {.lex_state = 9},
  [272] = {.lex_state = 9},
  [273] = {.lex_state = 9},
  [274] = {.lex_state = 9},
  [275] = {.lex_state = 9},
  [276] = {.lex_state = 9},
  [277] = {.lex_state = 9},
  [278] = {.lex_state = 9},
  [279] = {.lex_state = 9},
  [280] = {.lex_state = 9},
  [281] = {.lex_state = 9},
  [282] = {.lex_state = 9},
  [283] = {.lex_state = 9},
  [284] = {.lex_state = 9},
  [285] = {.lex_state = 9},
  [286] = {.lex_state = 9},
  [287] = {.lex_state = 9},
  [288] = {.lex_state = 9},
  [289] = {.lex_state = 9},
  [290] = {.lex_state = 9},
  [291] = {.lex_state = 9},
  [292] = {.lex_state = 9},
  [293] = {.lex_state = 9},
  [294] = {.lex_state = 9},
  [295] = {.lex_state = 9},
  [296] = {.lex_state = 9},
  [297] = {.lex_state = 9},
  [298] = {.lex_state = 9},
  [299] = {.lex_state = 9},
  [300] = {.lex_state = 9},
  [301] = {.lex_state = 9},
  [302] = {.lex_state = 9},
  [303] = {.lex_state = 9},
  [304] = {.lex_state = 9},
  [305] = {.lex_state = 9},
  [306] = {.lex_state = 9},
  [307] = {.lex_state = 9},
  [308] = {.lex_state = 9},
  [309] = {.lex_state = 9},
  [310] = {.lex_state = 9},
  [311] = {.lex_state = 9},
  [312] = {.lex_state = 9},
  [313] = {.lex_state = 9},
  [314] = {.lex_state = 9},
  [315] = {.lex_state = 9},
  [316] = {.lex_state = 9},
  [317] = {.lex_state = 9},
  [318] = {.lex_state = 9},
  [319] = {.lex_state = 9},
  [320] = {.lex_state = 9},
  [321] = {.lex_state = 9},
  [322] = {.lex_state = 9},
  [323] = {.lex_state = 9},
  [324] = {.lex_state = 9},
  [325] = {.lex_state = 9},
  [326] = {.lex_state = 9},
  [327] = {.lex_state = 9},
  [328] = {.lex_state = 9},
  [329] = {.lex_state = 9},
  [330] = {.lex_state = 9},
  [331] = {.lex_state = 9},
  [332] = {.lex_state = 9},
  [333] = {.lex_state = 9},
  [334] = {.lex_state = 9},
  [335] = {.lex_state = 9},
  [336] = {.lex_state = 9},
  [337] = {.lex_state = 9},
  [338] = {.lex_state = 9},
  [339] = {.lex_state = 9},
  [340] = {.lex_state = 9},
  [341] = {.lex_state = 9},
  [342] = {.lex_state = 9},
  [343] = {.lex_state = 9},
  [344] = {.lex_state = 9},
  [345] = {.lex_state = 9},
  [346] = {.lex_state = 9},
  [347] = {.lex_state = 9},
  [348] = {.lex_state = 9},
  [349] = {.lex_state = 9},
  [350] = {.lex_state = 9},
  [351] = {.lex_state = 9},
  [352] = {.lex_state = 9},
  [353] = {.lex_state = 9},
  [354] = {.lex_state = 9},
  [355] = {.lex_state = 9},
  [356] = {.lex_state = 9},
  [357] = {.lex_state = 9},
  [358] = {.lex_state = 9},
  [359] = {.lex_state = 9},
  [360] = {.lex_state = 9},
  [361] = {.lex_state = 9},
  [362] = {.lex_state = 9},
  [363] = {.lex_state = 9},
  [364] = {.lex_state = 9},
  [365] = {.lex_state = 9},
  [366] = {.lex_state = 9},
  [367] = {.lex_state = 9},
  [368] = {.lex_state = 9},
  [369] = {.lex_state = 9},
  [370] = {.lex_state = 9},
  [371] = {.lex_state = 9},
  [372] = {.lex_state = 9},
  [373] = {.lex_state = 9},
  [374] = {.lex_state = 9},
  [375] = {.lex_state = 9},
  [376] = {.lex_state = 9},
  [377] = {.lex_state = 9},
  [378] = {.lex_state = 9},
  [379] = {.lex_state = 9},
  [380] = {.lex_state = 9},
  [381] = {.lex_state = 9},
  [382] = {.lex_state = 9},
  [383] = {.lex_state = 9},
  [384] = {.lex_state = 9},
  [385] = {.lex_state = 9},
  [386] = {.lex_state = 9},
  [387] = {.lex_state = 9},
  [388] = {.lex_state = 9},
  [389] = {.lex_state = 9},
  [390] = {.lex_state = 9},
  [391] = {.lex_state = 9},
  [392] = {.lex_state = 9},
  [393] = {.lex_state = 9},
  [394] = {.lex_state = 9},
  [395] = {.lex_state = 9},
  [396] = {.lex_state = 9},
  [397] = {.lex_state = 9},
  [398] = {.lex_state = 9},
  [399] = {.lex_state = 9},
  [400] = {.lex_state = 9},
  [401] = {.lex_state = 9},
  [402] = {.lex_state = 9},
  [403] = {.lex_state = 9},
  [404] = {.lex_state = 9},
  [405] = {.lex_state = 9},
  [406] = {.lex_state = 9},
  [407] = {.lex_state = 9},
  [408] = {.lex_state = 9},
  [409] = {.lex_state = 9},
  [410] = {.lex_state = 9},
  [411] = {.lex_state = 9},
  [412] = {.lex_state = 9},
  [413] = {.lex_state = 9},
  [414] = {.lex_state = 9},
  [415] = {.lex_state = 9},
  [416] = {.lex_state = 9},
  [417] = {.lex_state = 9},
  [418] = {.lex_state = 9},
  [419] = {.lex_state = 9},
  [420] = {.lex_state = 9},
  [421] = {.lex_state = 9},
  [422] = {.lex_state = 9},
  [423] = {.lex_state = 9},
  [424] = {.lex_state = 9},
  [425] = {.lex_state = 9},
  [426] = {.lex_state = 9},
  [427] = {.lex_state = 9},
  [428] = {.lex_state = 9},
  [429] = {.lex_state = 9},
  [430] = {.lex_state = 9},
  [431] = {.lex_state = 9},
  [432] = {.lex_state = 9},
  [433] = {.lex_state = 9},
  [434] = {.lex_state = 9},
  [435] = {.lex_state = 9},
  [436] = {.lex_state = 9},
  [437] = {.lex_state = 9},
  [438] = {.lex_state = 9},
  [439] = {.lex_state = 9},
  [440] = {.lex_state = 9},
  [441] = {.lex_state = 9},
  [442] = {.lex_state = 9},
  [443] = {.lex_state = 9},
  [444] = {.lex_state = 9},
  [445] = {.lex_state = 9},
  [446] = {.lex_state = 9},
  [447] = {.lex_state = 9},
  [448] = {.lex_state = 9},
  [449] = {.lex_state = 9},
  [450] = {.lex_state = 9},
  [451] = {.lex_state = 9},
  [452] = {.lex_state = 9},
  [453] = {.lex_state = 9},
  [454] = {.lex_state = 9},
  [455] = {.lex_state = 9},
  [456] = {.lex_state = 9},
  [457] = {.lex_state = 9},
  [458] = {.lex_state = 9},
  [459] = {.lex_state = 9},
  [460] = {.lex_state = 9},
  [461] = {.lex_state = 9},
  [462] = {.lex_state = 9},
  [463] = {.lex_state = 75, .external_lex_state = 3},
  [464] = {.lex_state = 9},
  [465] = {.lex_state = 9},
  [466] = {.lex_state = 9},
  [467] = {.lex_state = 9},
  [468] = {.lex_state = 9},
  [469] = {.lex_state = 9},
  [470] = {.lex_state = 9},
  [471] = {.lex_state = 9},
  [472] = {.lex_state = 9},
  [473] = {.lex_state = 9},
  [474] = {.lex_state = 9},
  [475] = {.lex_state = 9},
  [476] = {.lex_state = 9},
  [477] = {.lex_state = 9},
  [478] = {.lex_state = 9},
  [479] = {.lex_state = 9},
  [480] = {.lex_state = 9},
  [481] = {.lex_state = 75, .external_lex_state = 3},
  [482] = {.lex_state = 9},
  [483] = {.lex_state = 9},
  [484] = {.lex_state = 9},
  [485] = {.lex_state = 9},
  [486] = {.lex_state = 9},
  [487] = {.lex_state = 9},
  [488] = {.lex_state = 9},
  [489] = {.lex_state = 9},
  [490] = {.lex_state = 9},
  [491] = {.lex_state = 9},
  [492] = {.lex_state = 9},
  [493] = {.lex_state = 9},
  [494] = {.lex_state = 9},
  [495] = {.lex_state = 9},
  [496] = {.lex_state = 9},
  [497] = {.lex_state = 9},
  [498] = {.lex_state = 9},
  [499] = {.lex_state = 9},
  [500] = {.lex_state = 9},
  [501] = {.lex_state = 9},
  [502] = {.lex_state = 9},
  [503] = {.lex_state = 9},
  [504] = {.lex_state = 9},
  [505] = {.lex_state = 9},
  [506] = {.lex_state = 9},
  [507] = {.lex_state = 9},
  [508] = {.lex_state = 9},
  [509] = {.lex_state = 9},
  [510] = {.lex_state = 9},
  [511] = {.lex_state = 9},
  [512] = {.lex_state = 9},
  [513] = {.lex_state = 9},
  [514] = {.lex_state = 9},
  [515] = {.lex_state = 9},
  [516] = {.lex_state = 9},
  [517] = {.lex_state = 9},
  [518] = {.lex_state = 9},
  [519] = {.lex_state = 9},
  [520] = {.lex_state = 9},
  [521] = {.lex_state = 9},
  [522] = {.lex_state = 9},
  [523] = {.lex_state = 9},
  [524] = {.lex_state = 75, .external_lex_state = 3},
  [525] = {.lex_state = 9},
  [526] = {.lex_state = 9},
  [527] = {.lex_state = 9},
  [528] = {.lex_state = 9},
  [529] = {.lex_state = 9},
  [530] = {.lex_state = 9},
  [531] = {.lex_state = 9},
  [532] = {.lex_state = 9},
  [533] = {.lex_state = 9},
  [534] = {.lex_state = 9},
  [535] = {.lex_state = 9},
  [536] = {.lex_state = 9},
  [537] = {.lex_state = 9},
  [538] = {.lex_state = 9},
  [539] = {.lex_state = 9},
  [540] = {.lex_state = 9},
  [541] = {.lex_state = 9},
  [542] = {.lex_state = 9},
  [543] = {.lex_state = 9},
  [544] = {.lex_state = 9},
  [545] = {.lex_state = 9},
  [546] = {.lex_state = 9},
  [547] = {.lex_state = 9},
  [548] = {.lex_state = 9},
  [549] = {.lex_state = 9},
  [550] = {.lex_state = 9},
  [551] = {.lex_state = 9},
  [552] = {.lex_state = 9},
  [553] = {.lex_state = 75, .external_lex_state = 3},
  [554] = {.lex_state = 9},
  [555] = {.lex_state = 9},
  [556] = {.lex_state = 9},
  [557] = {.lex_state = 9},
  [558] = {.lex_state = 9},
  [559] = {.lex_state = 9},
  [560] = {.lex_state = 9},
  [561] = {.lex_state = 9},
  [562] = {.lex_state = 9},
  [563] = {.lex_state = 9},
  [564] = {.lex_state = 9},
  [565] = {.lex_state = 9},
  [566] = {.lex_state = 9},
  [567] = {.lex_state = 9},
  [568] = {.lex_state = 9},
  [569] = {.lex_state = 9},
  [570] = {.lex_state = 9},
  [571] = {.lex_state = 9},
  [572] = {.lex_state = 9},
  [573] = {.lex_state = 9},
  [574] = {.lex_state = 9},
  [575] = {.lex_state = 9},
  [576] = {.lex_state = 9},
  [577] = {.lex_state = 9},
  [578] = {.lex_state = 9},
  [579] = {.lex_state = 9},
  [580] = {.lex_state = 9},
  [581] = {.lex_state = 9},
  [582] = {.lex_state = 9},
  [583] = {.lex_state = 9},
  [584] = {.lex_state = 9},
  [585] = {.lex_state = 9},
  [586] = {.lex_state = 9},
  [587] = {.lex_state = 9},
  [588] = {.lex_state = 9},
  [589] = {.lex_state = 9},
  [590] = {.lex_state = 9},
  [591] = {.lex_state = 3, .external_lex_state = 3},
  [592] = {.lex_state = 3, .external_lex_state = 3},
  [593] = {.lex_state = 3, .external_lex_state = 3},
  [594] = {.lex_state = 3, .external_lex_state = 3},
  [595] = {.lex_state = 75, .external_lex_state = 3},
  [596] = {.lex_state = 75, .external_lex_state = 3},
  [597] = {.lex_state = 75, .external_lex_state = 3},
  [598] = {.lex_state = 75, .external_lex_state = 3},
  [599] = {.lex_state = 75, .external_lex_state = 3},
  [600] = {.lex_state = 75, .external_lex_state = 3},
  [601] = {.lex_state = 75, .external_lex_state = 3},
  [602] = {.lex_state = 75, .external_lex_state = 3},
  [603] = {.lex_state = 75, .external_lex_state = 3},
  [604] = {.lex_state = 75, .external_lex_state = 3},
  [605] = {.lex_state = 75, .external_lex_state = 3},
  [606] = {.lex_state = 75, .external_lex_state = 3},
  [607] = {.lex_state = 3, .external_lex_state = 3},
  [608] = {.lex_state = 3, .external_lex_state = 3},
  [609] = {.lex_state = 3, .external_lex_state = 3},
  [610] = {.lex_state = 3, .external_lex_state = 3},
  [611] = {.lex_state = 3, .external_lex_state = 3},
  [612] = {.lex_state = 3, .external_lex_state = 3},
  [613] = {.lex_state = 9},
  [614] = {.lex_state = 9},
  [615] = {.lex_state = 9},
  [616] = {.lex_state = 9},
  [617] = {.lex_state = 3, .external_lex_state = 3},
  [618] = {.lex_state = 9},
  [619] = {.lex_state = 9},
  [620] = {.lex_state = 9},
  [621] = {.lex_state = 75, .external_lex_state = 3},
  [622] = {.lex_state = 75, .external_lex_state = 3},
  [623] = {.lex_state = 75, .external_lex_state = 3},
  [624] = {.lex_state = 75, .external_lex_state = 3},
  [625] = {.lex_state = 75, .external_lex_state = 3},
  [626] = {.lex_state = 75, .external_lex_state = 3},
  [627] = {.lex_state = 75, .external_lex_state = 3},
  [628] = {.lex_state = 75, .external_lex_state = 3},
  [629] = {.lex_state = 3, .external_lex_state = 3},
  [630] = {.lex_state = 3, .external_lex_state = 3},
  [631] = {.lex_state = 3, .external_lex_state = 2},
  [632] = {.lex_state = 3, .external_lex_state = 3},
  [633] = {.lex_state = 3, .external_lex_state = 2},
  [634] = {.lex_state = 3, .external_lex_state = 2},
  [635] = {.lex_state = 3, .external_lex_state = 3},
  [636] = {.lex_state = 3, .external_lex_state = 3},
  [637] = {.lex_state = 3, .external_lex_state = 2},
  [638] = {.lex_state = 3, .external_lex_state = 2},
  [639] = {.lex_state = 3, .external_lex_state = 3},
  [640] = {.lex_state = 3, .external_lex_state = 3},
  [641] = {.lex_state = 3, .external_lex_state = 3},
  [642] = {.lex_state = 3, .external_lex_state = 2},
  [643] = {.lex_state = 3, .external_lex_state = 3},
  [644] = {.lex_state = 3, .external_lex_state = 2},
  [645] = {.lex_state = 3, .external_lex_state = 3},
  [646] = {.lex_state = 3, .external_lex_state = 3},
  [647] = {.lex_state = 3, .external_lex_state = 3},
  [648] = {.lex_state = 3, .external_lex_state = 3},
  [649] = {.lex_state = 3, .external_lex_state = 3},
  [650] = {.lex_state = 3, .external_lex_state = 2},
  [651] = {.lex_state = 3, .external_lex_state = 2},
  [652] = {.lex_state = 3, .external_lex_state = 3},
  [653] = {.lex_state = 3, .external_lex_state = 2},
  [654] = {.lex_state = 3, .external_lex_state = 3},
  [655] = {.lex_state = 3, .external_lex_state = 3},
  [656] = {.lex_state = 3, .external_lex_state = 2},
  [657] = {.lex_state = 3, .external_lex_state = 3},
  [658] = {.lex_state = 3, .external_lex_state = 3},
  [659] = {.lex_state = 3, .external_lex_state = 2},
  [660] = {.lex_state = 3, .external_lex_state = 3},
  [661] = {.lex_state = 3, .external_lex_state = 2},
  [662] = {.lex_state = 3, .external_lex_state = 3},
  [663] = {.lex_state = 3, .external_lex_state = 3},
  [664] = {.lex_state = 3, .external_lex_state = 3},
  [665] = {.lex_state = 9},
  [666] = {.lex_state = 3, .external_lex_state = 2},
  [667] = {.lex_state = 3, .external_lex_state = 2},
  [668] = {.lex_state = 3, .external_lex_state = 2},
  [669] = {.lex_state = 9, .external_lex_state = 4},
  [670] = {.lex_state = 9, .external_lex_state = 4},
  [671] = {.lex_state = 3, .external_lex_state = 2},
  [672] = {.lex_state = 9, .external_lex_state = 4},
  [673] = {.lex_state = 9, .external_lex_state = 4},
  [674] = {.lex_state = 9},
  [675] = {.lex_state = 3, .external_lex_state = 2},
  [676] = {.lex_state = 3, .external_lex_state = 2},
  [677] = {.lex_state = 9},
  [678] = {.lex_state = 3, .external_lex_state = 2},
  [679] = {.lex_state = 9},
  [680] = {.lex_state = 9},
  [681] = {.lex_state = 3, .external_lex_state = 2},
  [682] = {.lex_state = 9},
  [683] = {.lex_state = 9, .external_lex_state = 4},
  [684] = {.lex_state = 9, .external_lex_state = 4},
  [685] = {.lex_state = 9, .external_lex_state = 4},
  [686] = {.lex_state = 9},
  [687] = {.lex_state = 9, .external_lex_state = 4},
  [688] = {.lex_state = 9, .external_lex_state = 4},
  [689] = {.lex_state = 9, .external_lex_state = 4},
  [690] = {.lex_state = 9, .external_lex_state = 4},
  [691] = {.lex_state = 9},
  [692] = {.lex_state = 9},
  [693] = {.lex_state = 9, .external_lex_state = 4},
  [694] = {.lex_state = 9},
  [695] = {.lex_state = 9, .external_lex_state = 4},
  [696] = {.lex_state = 9},
  [697] = {.lex_state = 9, .external_lex_state = 4},
  [698] = {.lex_state = 9, .external_lex_state = 4},
  [699] = {.lex_state = 9, .external_lex_state = 4},
  [700] = {.lex_state = 9},
  [701] = {.lex_state = 9, .external_lex_state = 4},
  [702] = {.lex_state = 9},
  [703] = {.lex_state = 9, .external_lex_state = 4},
  [704] = {.lex_state = 9, .external_lex_state = 4},
  [705] = {.lex_state = 9, .external_lex_state = 4},
  [706] = {.lex_state = 9},
  [707] = {.lex_state = 9},
  [708] = {.lex_state = 9},
  [709] = {.lex_state = 9},
  [710] = {.lex_state = 9},
  [711] = {.lex_state = 9},
  [712] = {.lex_state = 9},
  [713] = {.lex_state = 9},
  [714] = {.lex_state = 9},
  [715] = {.lex_state = 9},
  [716] = {.lex_state = 9},
  [717] = {.lex_state = 9},
  [718] = {.lex_state = 9},
  [719] = {.lex_state = 9},
  [720] = {.lex_state = 9},
  [721] = {.lex_state = 9},
  [722] = {.lex_state = 9},
  [723] = {.lex_state = 9},
  [724] = {.lex_state = 9},
  [725] = {.lex_state = 9},
  [726] = {.lex_state = 9},
  [727] = {.lex_state = 9},
  [728] = {.lex_state = 9},
  [729] = {.lex_state = 9},
  [730] = {.lex_state = 9},
  [731] = {.lex_state = 9},
  [732] = {.lex_state = 9},
  [733] = {.lex_state = 9},
  [734] = {.lex_state = 9},
  [735] = {.lex_state = 9},
  [736] = {.lex_state = 9},
  [737] = {.lex_state = 9},
  [738] = {.lex_state = 9},
  [739] = {.lex_state = 9},
  [740] = {.lex_state = 9},
  [741] = {.lex_state = 9},
  [742] = {.lex_state = 9},
  [743] = {.lex_state = 9},
  [744] = {.lex_state = 9},
  [745] = {.lex_state = 9},
  [746] = {.lex_state = 9},
  [747] = {.lex_state = 9},
  [748] = {.lex_state = 9},
  [749] = {.lex_state = 9},
  [750] = {.lex_state = 9},
  [751] = {.lex_state = 9},
  [752] = {.lex_state = 9},
  [753] = {.lex_state = 9},
  [754] = {.lex_state = 9},
  [755] = {.lex_state = 9},
  [756] = {.lex_state = 9},
  [757] = {.lex_state = 9},
  [758] = {.lex_state = 9},
  [759] = {.lex_state = 9},
  [760] = {.lex_state = 9},
  [761] = {.lex_state = 9},
  [762] = {.lex_state = 9},
  [763] = {.lex_state = 9},
  [764] = {.lex_state = 9},
  [765] = {.lex_state = 9},
  [766] = {.lex_state = 9},
  [767] = {.lex_state = 9},
  [768] = {.lex_state = 9},
  [769] = {.lex_state = 9},
  [770] = {.lex_state = 9},
  [771] = {.lex_state = 9},
  [772] = {.lex_state = 9},
  [773] = {.lex_state = 9},
  [774] = {.lex_state = 9},
  [775] = {.lex_state = 9},
  [776] = {.lex_state = 9},
  [777] = {.lex_state = 9},
  [778] = {.lex_state = 9},
  [779] = {.lex_state = 9},
  [780] = {.lex_state = 9},
  [781] = {.lex_state = 9},
  [782] = {.lex_state = 9},
  [783] = {.lex_state = 9},
  [784] = {.lex_state = 9},
  [785] = {.lex_state = 9},
  [786] = {.lex_state = 9},
  [787] = {.lex_state = 9},
  [788] = {.lex_state = 9},
  [789] = {.lex_state = 9},
  [790] = {.lex_state = 9},
  [791] = {.lex_state = 9},
  [792] = {.lex_state = 9},
  [793] = {.lex_state = 9},
  [794] = {.lex_state = 9},
  [795] = {.lex_state = 9},
  [796] = {.lex_state = 9},
  [797] = {.lex_state = 9},
  [798] = {.lex_state = 9},
  [799] = {.lex_state = 9},
  [800] = {.lex_state = 9},
  [801] = {.lex_state = 9},
  [802] = {.lex_state = 9},
  [803] = {.lex_state = 9},
  [804] = {.lex_state = 9},
  [805] = {.lex_state = 9},
  [806] = {.lex_state = 9},
  [807] = {.lex_state = 9},
  [808] = {.lex_state = 9},
  [809] = {.lex_state = 9},
  [810] = {.lex_state = 9},
  [811] = {.lex_state = 9},
  [812] = {.lex_state = 9},
  [813] = {.lex_state = 9},
  [814] = {.lex_state = 9},
  [815] = {.lex_state = 9},
  [816] = {.lex_state = 9},
  [817] = {.lex_state = 9},
  [818] = {.lex_state = 9},
  [819] = {.lex_state = 9},
  [820] = {.lex_state = 9},
  [821] = {.lex_state = 9},
  [822] = {.lex_state = 9},
  [823] = {.lex_state = 9},
  [824] = {.lex_state = 9},
  [825] = {.lex_state = 9},
  [826] = {.lex_state = 9},
  [827] = {.lex_state = 9},
  [828] = {.lex_state = 9},
  [829] = {.lex_state = 9},
  [830] = {.lex_state = 9},
  [831] = {.lex_state = 9},
  [832] = {.lex_state = 9},
  [833] = {.lex_state = 9},
  [834] = {.lex_state = 9},
  [835] = {.lex_state = 9},
  [836] = {.lex_state = 9},
  [837] = {.lex_state = 9},
  [838] = {.lex_state = 9},
  [839] = {.lex_state = 9},
  [840] = {.lex_state = 9},
  [841] = {.lex_state = 9},
  [842] = {.lex_state = 9},
  [843] = {.lex_state = 9},
  [844] = {.lex_state = 9},
  [845] = {.lex_state = 9},
  [846] = {.lex_state = 9},
  [847] = {.lex_state = 9},
  [848] = {.lex_state = 9},
  [849] = {.lex_state = 9},
  [850] = {.lex_state = 9},
  [851] = {.lex_state = 9},
  [852] = {.lex_state = 9},
  [853] = {.lex_state = 9},
  [854] = {.lex_state = 9},
  [855] = {.lex_state = 9},
  [856] = {.lex_state = 9},
  [857] = {.lex_state = 9},
  [858] = {.lex_state = 9},
  [859] = {.lex_state = 9},
  [860] = {.lex_state = 9},
  [861] = {.lex_state = 9},
  [862] = {.lex_state = 9},
  [863] = {.lex_state = 9},
  [864] = {.lex_state = 9},
  [865] = {.lex_state = 5, .external_lex_state = 3},
  [866] = {.lex_state = 5, .external_lex_state = 3},
  [867] = {.lex_state = 5, .external_lex_state = 3},
  [868] = {.lex_state = 12},
  [869] = {.lex_state = 12},
  [870] = {.lex_state = 5, .external_lex_state = 3},
  [871] = {.lex_state = 5, .external_lex_state = 3},
  [872] = {.lex_state = 12},
  [873] = {.lex_state = 5, .external_lex_state = 3},
  [874] = {.lex_state = 12},
  [875] = {.lex_state = 12},
  [876] = {.lex_state = 5, .external_lex_state = 3},
  [877] = {.lex_state = 5, .external_lex_state = 3},
  [878] = {.lex_state = 14},
  [879] = {.lex_state = 5, .external_lex_state = 3},
  [880] = {.lex_state = 5, .external_lex_state = 3},
  [881] = {.lex_state = 14},
  [882] = {.lex_state = 14},
  [883] = {.lex_state = 14},
  [884] = {.lex_state = 5, .external_lex_state = 3},
  [885] = {.lex_state = 14},
  [886] = {.lex_state = 5, .external_lex_state = 3},
  [887] = {.lex_state = 14},
  [888] = {.lex_state = 5, .external_lex_state = 3},
  [889] = {.lex_state = 14},
  [890] = {.lex_state = 5, .external_lex_state = 3},
  [891] = {.lex_state = 12},
  [892] = {.lex_state = 5, .external_lex_state = 3},
  [893] = {.lex_state = 12},
  [894] = {.lex_state = 5, .external_lex_state = 3},
  [895] = {.lex_state = 14},
  [896] = {.lex_state = 5, .external_lex_state = 3},
  [897] = {.lex_state = 12},
  [898] = {.lex_state = 14},
  [899] = {.lex_state = 5, .external_lex_state = 3},
  [900] = {.lex_state = 5, .external_lex_state = 3},
  [901] = {.lex_state = 5, .external_lex_state = 3},
  [902] = {.lex_state = 12},
  [903] = {.lex_state = 5, .external_lex_state = 3},
  [904] = {.lex_state = 12},
  [905] = {.lex_state = 12},
  [906] = {.lex_state = 5, .external_lex_state = 3},
  [907] = {.lex_state = 12},
  [908] = {.lex_state = 5, .external_lex_state = 3},
  [909] = {.lex_state = 14},
  [910] = {.lex_state = 12},
  [911] = {.lex_state = 14},
  [912] = {.lex_state = 5, .external_lex_state = 3},
  [913] = {.lex_state = 5, .external_lex_state = 3},
  [914] = {.lex_state = 5, .external_lex_state = 3},
  [915] = {.lex_state = 14},
  [916] = {.lex_state = 12},
  [917] = {.lex_state = 5, .external_lex_state = 3},
  [918] = {.lex_state = 14},
  [919] = {.lex_state = 12},
  [920] = {.lex_state = 9},
  [921] = {.lex_state = 9},
  [922] = {.lex_state = 9},
  [923] = {.lex_state = 12},
  [924] = {.lex_state = 14},
  [925] = {.lex_state = 14},
  [926] = {.lex_state = 3, .external_lex_state = 3},
  [927] = {.lex_state = 12},
  [928] = {.lex_state = 3, .external_lex_state = 3},
  [929] = {.lex_state = 3, .external_lex_state = 3},
  [930] = {.lex_state = 12},
  [931] = {.lex_state = 3, .external_lex_state = 3},
  [932] = {.lex_state = 12},
  [933] = {.lex_state = 3, .external_lex_state = 3},
  [934] = {.lex_state = 3, .external_lex_state = 3},
  [935] = {.lex_state = 3, .external_lex_state = 3},
  [936] = {.lex_state = 3, .external_lex_state = 3},
  [937] = {.lex_state = 12},
  [938] = {.lex_state = 12},
  [939] = {.lex_state = 12},
  [940] = {.lex_state = 12},
  [941] = {.lex_state = 12},
  [942] = {.lex_state = 12},
  [943] = {.lex_state = 12},
  [944] = {.lex_state = 12},
  [945] = {.lex_state = 12},
  [946] = {.lex_state = 12},
  [947] = {.lex_state = 12},
  [948] = {.lex_state = 12},
  [949] = {.lex_state = 12},
  [950] = {.lex_state = 12},
  [951] = {.lex_state = 12},
  [952] = {.lex_state = 12},
  [953] = {.lex_state = 12},
  [954] = {.lex_state = 12},
  [955] = {.lex_state = 12},
  [956] = {.lex_state = 12},
  [957] = {.lex_state = 12},
  [958] = {.lex_state = 12},
  [959] = {.lex_state = 12},
  [960] = {.lex_state = 12},
  [961] = {.lex_state = 12},
  [962] = {.lex_state = 12},
  [963] = {.lex_state = 12},
  [964] = {.lex_state = 12},
  [965] = {.lex_state = 12},
  [966] = {.lex_state = 12},
  [967] = {.lex_state = 12},
  [968] = {.lex_state = 12},
  [969] = {.lex_state = 12},
  [970] = {.lex_state = 12},
  [971] = {.lex_state = 12},
  [972] = {.lex_state = 12},
  [973] = {.lex_state = 12},
  [974] = {.lex_state = 12},
  [975] = {.lex_state = 12},
  [976] = {.lex_state = 12},
  [977] = {.lex_state = 12},
  [978] = {.lex_state = 12},
  [979] = {.lex_state = 12},
  [980] = {.lex_state = 12},
  [981] = {.lex_state = 12},
  [982] = {.lex_state = 12},
  [983] = {.lex_state = 12},
  [984] = {.lex_state = 12},
  [985] = {.lex_state = 12},
  [986] = {.lex_state = 12},
  [987] = {.lex_state = 12},
  [988] = {.lex_state = 12},
  [989] = {.lex_state = 12},
  [990] = {.lex_state = 12},
  [991] = {.lex_state = 12},
  [992] = {.lex_state = 12},
  [993] = {.lex_state = 12},
  [994] = {.lex_state = 12},
  [995] = {.lex_state = 12},
  [996] = {.lex_state = 12},
  [997] = {.lex_state = 12},
  [998] = {.lex_state = 12},
  [999] = {.lex_state = 12},
  [1000] = {.lex_state = 12},
  [1001] = {.lex_state = 12},
  [1002] = {.lex_state = 12},
  [1003] = {.lex_state = 12},
  [1004] = {.lex_state = 12},
  [1005] = {.lex_state = 12},
  [1006] = {.lex_state = 12},
  [1007] = {.lex_state = 12},
  [1008] = {.lex_state = 12},
  [1009] = {.lex_state = 12},
  [1010] = {.lex_state = 12},
  [1011] = {.lex_state = 12},
  [1012] = {.lex_state = 12},
  [1013] = {.lex_state = 12},
  [1014] = {.lex_state = 12},
  [1015] = {.lex_state = 12},
  [1016] = {.lex_state = 12},
  [1017] = {.lex_state = 12},
  [1018] = {.lex_state = 12},
  [1019] = {.lex_state = 12},
  [1020] = {.lex_state = 12},
  [1021] = {.lex_state = 12},
  [1022] = {.lex_state = 12},
  [1023] = {.lex_state = 12},
  [1024] = {.lex_state = 12},
  [1025] = {.lex_state = 12},
  [1026] = {.lex_state = 12},
  [1027] = {.lex_state = 12},
  [1028] = {.lex_state = 12},
  [1029] = {.lex_state = 12},
  [1030] = {.lex_state = 12},
  [1031] = {.lex_state = 12},
  [1032] = {.lex_state = 12},
  [1033] = {.lex_state = 12},
  [1034] = {.lex_state = 12},
  [1035] = {.lex_state = 12},
  [1036] = {.lex_state = 12},
  [1037] = {.lex_state = 12},
  [1038] = {.lex_state = 12},
  [1039] = {.lex_state = 12},
  [1040] = {.lex_state = 12},
  [1041] = {.lex_state = 12},
  [1042] = {.lex_state = 12},
  [1043] = {.lex_state = 12},
  [1044] = {.lex_state = 12},
  [1045] = {.lex_state = 12},
  [1046] = {.lex_state = 12},
  [1047] = {.lex_state = 12},
  [1048] = {.lex_state = 12},
  [1049] = {.lex_state = 12},
  [1050] = {.lex_state = 12},
  [1051] = {.lex_state = 12},
  [1052] = {.lex_state = 12},
  [1053] = {.lex_state = 12},
  [1054] = {.lex_state = 12},
  [1055] = {.lex_state = 12},
  [1056] = {.lex_state = 12},
  [1057] = {.lex_state = 12},
  [1058] = {.lex_state = 12},
  [1059] = {.lex_state = 12},
  [1060] = {.lex_state = 12},
  [1061] = {.lex_state = 12},
  [1062] = {.lex_state = 12},
  [1063] = {.lex_state = 12},
  [1064] = {.lex_state = 3, .external_lex_state = 2},
  [1065] = {.lex_state = 12},
  [1066] = {.lex_state = 12},
  [1067] = {.lex_state = 12},
  [1068] = {.lex_state = 12},
  [1069] = {.lex_state = 12},
  [1070] = {.lex_state = 12},
  [1071] = {.lex_state = 12},
  [1072] = {.lex_state = 12},
  [1073] = {.lex_state = 12},
  [1074] = {.lex_state = 12},
  [1075] = {.lex_state = 12},
  [1076] = {.lex_state = 12},
  [1077] = {.lex_state = 12},
  [1078] = {.lex_state = 12},
  [1079] = {.lex_state = 12},
  [1080] = {.lex_state = 12},
  [1081] = {.lex_state = 12},
  [1082] = {.lex_state = 12},
  [1083] = {.lex_state = 12},
  [1084] = {.lex_state = 3, .external_lex_state = 2},
  [1085] = {.lex_state = 12},
  [1086] = {.lex_state = 12},
  [1087] = {.lex_state = 12},
  [1088] = {.lex_state = 12},
  [1089] = {.lex_state = 3, .external_lex_state = 2},
  [1090] = {.lex_state = 12},
  [1091] = {.lex_state = 12},
  [1092] = {.lex_state = 12},
  [1093] = {.lex_state = 12},
  [1094] = {.lex_state = 3, .external_lex_state = 2},
  [1095] = {.lex_state = 3, .external_lex_state = 3},
  [1096] = {.lex_state = 3, .external_lex_state = 2},
  [1097] = {.lex_state = 3, .external_lex_state = 3},
  [1098] = {.lex_state = 3, .external_lex_state = 3},
  [1099] = {.lex_state = 3, .external_lex_state = 2},
  [1100] = {.lex_state = 3, .external_lex_state = 2},
  [1101] = {.lex_state = 3, .external_lex_state = 3},
  [1102] = {.lex_state = 3, .external_lex_state = 3},
  [1103] = {.lex_state = 3, .external_lex_state = 3},
  [1104] = {.lex_state = 3, .external_lex_state = 3},
  [1105] = {.lex_state = 3, .external_lex_state = 3},
  [1106] = {.lex_state = 3, .external_lex_state = 3},
  [1107] = {.lex_state = 3, .external_lex_state = 3},
  [1108] = {.lex_state = 3, .external_lex_state = 3},
  [1109] = {.lex_state = 3, .external_lex_state = 3},
  [1110] = {.lex_state = 3, .external_lex_state = 3},
  [1111] = {.lex_state = 3, .external_lex_state = 3},
  [1112] = {.lex_state = 3, .external_lex_state = 2},
  [1113] = {.lex_state = 9},
  [1114] = {.lex_state = 3, .external_lex_state = 3},
  [1115] = {.lex_state = 9},
  [1116] = {.lex_state = 3, .external_lex_state = 2},
  [1117] = {.lex_state = 3, .external_lex_state = 2},
  [1118] = {.lex_state = 3, .external_lex_state = 3},
  [1119] = {.lex_state = 3, .external_lex_state = 3},
  [1120] = {.lex_state = 9},
  [1121] = {.lex_state = 3, .external_lex_state = 3},
  [1122] = {.lex_state = 9},
  [1123] = {.lex_state = 9},
  [1124] = {.lex_state = 3, .external_lex_state = 3},
  [1125] = {.lex_state = 3, .external_lex_state = 3},
  [1126] = {.lex_state = 3, .external_lex_state = 2},
  [1127] = {.lex_state = 3, .external_lex_state = 2},
  [1128] = {.lex_state = 3, .external_lex_state = 2},
  [1129] = {.lex_state = 3, .external_lex_state = 3},
  [1130] = {.lex_state = 3, .external_lex_state = 2},
  [1131] = {.lex_state = 3, .external_lex_state = 3},
  [1132] = {.lex_state = 3, .external_lex_state = 3},
  [1133] = {.lex_state = 9},
  [1134] = {.lex_state = 3, .external_lex_state = 3},
  [1135] = {.lex_state = 9},
  [1136] = {.lex_state = 3, .external_lex_state = 3},
  [1137] = {.lex_state = 3, .external_lex_state = 2},
  [1138] = {.lex_state = 3, .external_lex_state = 3},
  [1139] = {.lex_state = 3, .external_lex_state = 3},
  [1140] = {.lex_state = 9},
  [1141] = {.lex_state = 3, .external_lex_state = 3},
  [1142] = {.lex_state = 9},
  [1143] = {.lex_state = 3, .external_lex_state = 2},
  [1144] = {.lex_state = 3, .external_lex_state = 2},
  [1145] = {.lex_state = 3, .external_lex_state = 3},
  [1146] = {.lex_state = 3, .external_lex_state = 3},
  [1147] = {.lex_state = 9},
  [1148] = {.lex_state = 3, .external_lex_state = 3},
  [1149] = {.lex_state = 3, .external_lex_state = 3},
  [1150] = {.lex_state = 3, .external_lex_state = 2},
  [1151] = {.lex_state = 3, .external_lex_state = 3},
  [1152] = {.lex_state = 3, .external_lex_state = 2},
  [1153] = {.lex_state = 12},
  [1154] = {.lex_state = 3, .external_lex_state = 2},
  [1155] = {.lex_state = 12},
  [1156] = {.lex_state = 12},
  [1157] = {.lex_state = 12},
  [1158] = {.lex_state = 3, .external_lex_state = 2},
  [1159] = {.lex_state = 12},
  [1160] = {.lex_state = 12},
  [1161] = {.lex_state = 3, .external_lex_state = 3},
  [1162] = {.lex_state = 3, .external_lex_state = 2},
  [1163] = {.lex_state = 3, .external_lex_state = 2},
  [1164] = {.lex_state = 3, .external_lex_state = 2},
  [1165] = {.lex_state = 3, .external_lex_state = 2},
  [1166] = {.lex_state = 3, .external_lex_state = 2},
  [1167] = {.lex_state = 3, .external_lex_state = 2},
  [1168] = {.lex_state = 3, .external_lex_state = 2},
  [1169] = {.lex_state = 3, .external_lex_state = 2},
  [1170] = {.lex_state = 3, .external_lex_state = 3},
  [1171] = {.lex_state = 3, .external_lex_state = 2},
  [1172] = {.lex_state = 3, .external_lex_state = 2},
  [1173] = {.lex_state = 12},
  [1174] = {.lex_state = 3, .external_lex_state = 3},
  [1175] = {.lex_state = 3, .external_lex_state = 2},
  [1176] = {.lex_state = 3, .external_lex_state = 3},
  [1177] = {.lex_state = 3, .external_lex_state = 3},
  [1178] = {.lex_state = 3, .external_lex_state = 2},
  [1179] = {.lex_state = 3, .external_lex_state = 2},
  [1180] = {.lex_state = 3, .external_lex_state = 2},
  [1181] = {.lex_state = 3, .external_lex_state = 3},
  [1182] = {.lex_state = 3, .external_lex_state = 2},
  [1183] = {.lex_state = 3, .external_lex_state = 2},
  [1184] = {.lex_state = 3, .external_lex_state = 2},
  [1185] = {.lex_state = 3, .external_lex_state = 2},
  [1186] = {.lex_state = 3, .external_lex_state = 3},
  [1187] = {.lex_state = 3, .external_lex_state = 2},
  [1188] = {.lex_state = 3, .external_lex_state = 2},
  [1189] = {.lex_state = 3, .external_lex_state = 2},
  [1190] = {.lex_state = 3, .external_lex_state = 3},
  [1191] = {.lex_state = 12},
  [1192] = {.lex_state = 3, .external_lex_state = 3},
  [1193] = {.lex_state = 12},
  [1194] = {.lex_state = 3, .external_lex_state = 2},
  [1195] = {.lex_state = 12},
  [1196] = {.lex_state = 12},
  [1197] = {.lex_state = 12},
  [1198] = {.lex_state = 3, .external_lex_state = 2},
  [1199] = {.lex_state = 12},
  [1200] = {.lex_state = 3, .external_lex_state = 2},
  [1201] = {.lex_state = 12},
  [1202] = {.lex_state = 3, .external_lex_state = 3},
  [1203] = {.lex_state = 3, .external_lex_state = 3},
  [1204] = {.lex_state = 3, .external_lex_state = 2},
  [1205] = {.lex_state = 3, .external_lex_state = 3},
  [1206] = {.lex_state = 12},
  [1207] = {.lex_state = 3, .external_lex_state = 2},
  [1208] = {.lex_state = 3, .external_lex_state = 3},
  [1209] = {.lex_state = 12},
  [1210] = {.lex_state = 12},
  [1211] = {.lex_state = 12},
  [1212] = {.lex_state = 12},
  [1213] = {.lex_state = 12},
  [1214] = {.lex_state = 12},
  [1215] = {.lex_state = 3, .external_lex_state = 2},
  [1216] = {.lex_state = 3, .external_lex_state = 2},
  [1217] = {.lex_state = 12},
  [1218] = {.lex_state = 3, .external_lex_state = 3},
  [1219] = {.lex_state = 12},
  [1220] = {.lex_state = 12},
  [1221] = {.lex_state = 3, .external_lex_state = 2},
  [1222] = {.lex_state = 3, .external_lex_state = 3},
  [1223] = {.lex_state = 3, .external_lex_state = 2},
  [1224] = {.lex_state = 12},
  [1225] = {.lex_state = 3, .external_lex_state = 3},
  [1226] = {.lex_state = 3, .external_lex_state = 2},
  [1227] = {.lex_state = 3, .external_lex_state = 2},
  [1228] = {.lex_state = 3, .external_lex_state = 2},
  [1229] = {.lex_state = 12},
  [1230] = {.lex_state = 3, .external_lex_state = 3},
  [1231] = {.lex_state = 12},
  [1232] = {.lex_state = 3, .external_lex_state = 3},
  [1233] = {.lex_state = 12},
  [1234] = {.lex_state = 3, .external_lex_state = 2},
  [1235] = {.lex_state = 3, .external_lex_state = 2},
  [1236] = {.lex_state = 3, .external_lex_state = 3},
  [1237] = {.lex_state = 3, .external_lex_state = 2},
  [1238] = {.lex_state = 3, .external_lex_state = 3},
  [1239] = {.lex_state = 3, .external_lex_state = 3},
  [1240] = {.lex_state = 3, .external_lex_state = 3},
  [1241] = {.lex_state = 3, .external_lex_state = 2},
  [1242] = {.lex_state = 3, .external_lex_state = 2},
  [1243] = {.lex_state = 3, .external_lex_state = 2},
  [1244] = {.lex_state = 3, .external_lex_state = 2},
  [1245] = {.lex_state = 3, .external_lex_state = 2},
  [1246] = {.lex_state = 3, .external_lex_state = 3},
  [1247] = {.lex_state = 3, .external_lex_state = 3},
  [1248] = {.lex_state = 3, .external_lex_state = 3},
  [1249] = {.lex_state = 3, .external_lex_state = 3},
  [1250] = {.lex_state = 3, .external_lex_state = 3},
  [1251] = {.lex_state = 3, .external_lex_state = 2},
  [1252] = {.lex_state = 3, .external_lex_state = 3},
  [1253] = {.lex_state = 3, .external_lex_state = 3},
  [1254] = {.lex_state = 3, .external_lex_state = 3},
  [1255] = {.lex_state = 3, .external_lex_state = 2},
  [1256] = {.lex_state = 3, .external_lex_state = 3},
  [1257] = {.lex_state = 3, .external_lex_state = 2},
  [1258] = {.lex_state = 3, .external_lex_state = 3},
  [1259] = {.lex_state = 3, .external_lex_state = 3},
  [1260] = {.lex_state = 3, .external_lex_state = 2},
  [1261] = {.lex_state = 3, .external_lex_state = 3},
  [1262] = {.lex_state = 3, .external_lex_state = 3},
  [1263] = {.lex_state = 3, .external_lex_state = 3},
  [1264] = {.lex_state = 3, .external_lex_state = 3},
  [1265] = {.lex_state = 3, .external_lex_state = 3},
  [1266] = {.lex_state = 3, .external_lex_state = 2},
  [1267] = {.lex_state = 3, .external_lex_state = 3},
  [1268] = {.lex_state = 3, .external_lex_state = 3},
  [1269] = {.lex_state = 3, .external_lex_state = 2},
  [1270] = {.lex_state = 3, .external_lex_state = 2},
  [1271] = {.lex_state = 3, .external_lex_state = 3},
  [1272] = {.lex_state = 3, .external_lex_state = 3},
  [1273] = {.lex_state = 3, .external_lex_state = 2},
  [1274] = {.lex_state = 3, .external_lex_state = 2},
  [1275] = {.lex_state = 3, .external_lex_state = 3},
  [1276] = {.lex_state = 3, .external_lex_state = 2},
  [1277] = {.lex_state = 3, .external_lex_state = 2},
  [1278] = {.lex_state = 3, .external_lex_state = 3},
  [1279] = {.lex_state = 3, .external_lex_state = 3},
  [1280] = {.lex_state = 12},
  [1281] = {.lex_state = 3, .external_lex_state = 3},
  [1282] = {.lex_state = 12},
  [1283] = {.lex_state = 3, .external_lex_state = 2},
  [1284] = {.lex_state = 3, .external_lex_state = 2},
  [1285] = {.lex_state = 3, .external_lex_state = 2},
  [1286] = {.lex_state = 3, .external_lex_state = 2},
  [1287] = {.lex_state = 3, .external_lex_state = 2},
  [1288] = {.lex_state = 3, .external_lex_state = 3},
  [1289] = {.lex_state = 3, .external_lex_state = 2},
  [1290] = {.lex_state = 3, .external_lex_state = 3},
  [1291] = {.lex_state = 3, .external_lex_state = 2},
  [1292] = {.lex_state = 3, .external_lex_state = 2},
  [1293] = {.lex_state = 3, .external_lex_state = 2},
  [1294] = {.lex_state = 12},
  [1295] = {.lex_state = 3, .external_lex_state = 2},
  [1296] = {.lex_state = 12},
  [1297] = {.lex_state = 3, .external_lex_state = 2},
  [1298] = {.lex_state = 3, .external_lex_state = 2},
  [1299] = {.lex_state = 12},
  [1300] = {.lex_state = 12},
  [1301] = {.lex_state = 12},
  [1302] = {.lex_state = 12},
  [1303] = {.lex_state = 3, .external_lex_state = 2},
  [1304] = {.lex_state = 3, .external_lex_state = 3},
  [1305] = {.lex_state = 3, .external_lex_state = 2},
  [1306] = {.lex_state = 3, .external_lex_state = 3},
  [1307] = {.lex_state = 3, .external_lex_state = 2},
  [1308] = {.lex_state = 3, .external_lex_state = 3},
  [1309] = {.lex_state = 3, .external_lex_state = 2},
  [1310] = {.lex_state = 3, .external_lex_state = 2},
  [1311] = {.lex_state = 3, .external_lex_state = 2},
  [1312] = {.lex_state = 3, .external_lex_state = 2},
  [1313] = {.lex_state = 3, .external_lex_state = 3},
  [1314] = {.lex_state = 3, .external_lex_state = 2},
  [1315] = {.lex_state = 3, .external_lex_state = 3},
  [1316] = {.lex_state = 3, .external_lex_state = 2},
  [1317] = {.lex_state = 3, .external_lex_state = 2},
  [1318] = {.lex_state = 9},
  [1319] = {.lex_state = 3, .external_lex_state = 2},
  [1320] = {.lex_state = 3, .external_lex_state = 2},
  [1321] = {.lex_state = 3, .external_lex_state = 2},
  [1322] = {.lex_state = 9},
  [1323] = {.lex_state = 3, .external_lex_state = 2},
  [1324] = {.lex_state = 9},
  [1325] = {.lex_state = 9},
  [1326] = {.lex_state = 3, .external_lex_state = 2},
  [1327] = {.lex_state = 3, .external_lex_state = 2},
  [1328] = {.lex_state = 9},
  [1329] = {.lex_state = 9},
  [1330] = {.lex_state = 3, .external_lex_state = 2},
  [1331] = {.lex_state = 3, .external_lex_state = 2},
  [1332] = {.lex_state = 3, .external_lex_state = 3},
  [1333] = {.lex_state = 3, .external_lex_state = 2},
  [1334] = {.lex_state = 3, .external_lex_state = 2},
  [1335] = {.lex_state = 3, .external_lex_state = 2},
  [1336] = {.lex_state = 3, .external_lex_state = 2},
  [1337] = {.lex_state = 3, .external_lex_state = 2},
  [1338] = {.lex_state = 3, .external_lex_state = 2},
  [1339] = {.lex_state = 3, .external_lex_state = 2},
  [1340] = {.lex_state = 9},
  [1341] = {.lex_state = 3, .external_lex_state = 2},
  [1342] = {.lex_state = 3, .external_lex_state = 2},
  [1343] = {.lex_state = 3, .external_lex_state = 2},
  [1344] = {.lex_state = 3, .external_lex_state = 2},
  [1345] = {.lex_state = 3, .external_lex_state = 2},
  [1346] = {.lex_state = 3, .external_lex_state = 2},
  [1347] = {.lex_state = 75},
  [1348] = {.lex_state = 75},
  [1349] = {.lex_state = 75},
  [1350] = {.lex_state = 75},
  [1351] = {.lex_state = 75},
  [1352] = {.lex_state = 9},
  [1353] = {.lex_state = 9, .external_lex_state = 4},
  [1354] = {.lex_state = 9, .external_lex_state = 4},
  [1355] = {.lex_state = 9, .external_lex_state = 4},
  [1356] = {.lex_state = 9, .external_lex_state = 4},
  [1357] = {.lex_state = 9, .external_lex_state = 4},
  [1358] = {.lex_state = 9, .external_lex_state = 4},
  [1359] = {.lex_state = 12},
  [1360] = {.lex_state = 12},
  [1361] = {.lex_state = 12},
  [1362] = {.lex_state = 9, .external_lex_state = 4},
  [1363] = {.lex_state = 12},
  [1364] = {.lex_state = 12},
  [1365] = {.lex_state = 12},
  [1366] = {.lex_state = 9, .external_lex_state = 4},
  [1367] = {.lex_state = 12},
  [1368] = {.lex_state = 12},
  [1369] = {.lex_state = 5, .external_lex_state = 3},
  [1370] = {.lex_state = 9, .external_lex_state = 4},
  [1371] = {.lex_state = 12},
  [1372] = {.lex_state = 12},
  [1373] = {.lex_state = 9, .external_lex_state = 4},
  [1374] = {.lex_state = 12},
  [1375] = {.lex_state = 9, .external_lex_state = 4},
  [1376] = {.lex_state = 12},
  [1377] = {.lex_state = 5, .external_lex_state = 3},
  [1378] = {.lex_state = 12},
  [1379] = {.lex_state = 12},
  [1380] = {.lex_state = 9, .external_lex_state = 4},
  [1381] = {.lex_state = 12},
  [1382] = {.lex_state = 12},
  [1383] = {.lex_state = 12},
  [1384] = {.lex_state = 9, .external_lex_state = 4},
  [1385] = {.lex_state = 9, .external_lex_state = 4},
  [1386] = {.lex_state = 9, .external_lex_state = 4},
  [1387] = {.lex_state = 9, .external_lex_state = 4},
  [1388] = {.lex_state = 9, .external_lex_state = 4},
  [1389] = {.lex_state = 9, .external_lex_state = 4},
  [1390] = {.lex_state = 75},
  [1391] = {.lex_state = 9, .external_lex_state = 4},
  [1392] = {.lex_state = 9, .external_lex_state = 4},
  [1393] = {.lex_state = 9, .external_lex_state = 4},
  [1394] = {.lex_state = 9, .external_lex_state = 4},
  [1395] = {.lex_state = 9, .external_lex_state = 4},
  [1396] = {.lex_state = 9, .external_lex_state = 4},
  [1397] = {.lex_state = 9, .external_lex_state = 4},
  [1398] = {.lex_state = 9, .external_lex_state = 4},
  [1399] = {.lex_state = 5, .external_lex_state = 3},
  [1400] = {.lex_state = 9, .external_lex_state = 4},
  [1401] = {.lex_state = 9, .external_lex_state = 4},
  [1402] = {.lex_state = 12, .external_lex_state = 4},
  [1403] = {.lex_state = 9, .external_lex_state = 4},
  [1404] = {.lex_state = 12, .external_lex_state = 4},
  [1405] = {.lex_state = 12, .external_lex_state = 4},
  [1406] = {.lex_state = 9, .external_lex_state = 4},
  [1407] = {.lex_state = 9, .external_lex_state = 4},
  [1408] = {.lex_state = 5, .external_lex_state = 3},
  [1409] = {.lex_state = 9, .external_lex_state = 4},
  [1410] = {.lex_state = 9, .external_lex_state = 4},
  [1411] = {.lex_state = 12, .external_lex_state = 4},
  [1412] = {.lex_state = 9, .external_lex_state = 4},
  [1413] = {.lex_state = 9, .external_lex_state = 4},
  [1414] = {.lex_state = 9, .external_lex_state = 4},
  [1415] = {.lex_state = 9, .external_lex_state = 4},
  [1416] = {.lex_state = 5, .external_lex_state = 2},
  [1417] = {.lex_state = 9},
  [1418] = {.lex_state = 9, .external_lex_state = 4},
  [1419] = {.lex_state = 9},
  [1420] = {.lex_state = 9, .external_lex_state = 4},
  [1421] = {.lex_state = 9, .external_lex_state = 4},
  [1422] = {.lex_state = 9, .external_lex_state = 4},
  [1423] = {.lex_state = 9},
  [1424] = {.lex_state = 9},
  [1425] = {.lex_state = 9},
  [1426] = {.lex_state = 9},
  [1427] = {.lex_state = 9, .external_lex_state = 4},
  [1428] = {.lex_state = 9},
  [1429] = {.lex_state = 9, .external_lex_state = 4},
  [1430] = {.lex_state = 9},
  [1431] = {.lex_state = 9},
  [1432] = {.lex_state = 9, .external_lex_state = 4},
  [1433] = {.lex_state = 5, .external_lex_state = 3},
  [1434] = {.lex_state = 9},
  [1435] = {.lex_state = 9, .external_lex_state = 4},
  [1436] = {.lex_state = 9},
  [1437] = {.lex_state = 9, .external_lex_state = 4},
  [1438] = {.lex_state = 9},
  [1439] = {.lex_state = 5, .external_lex_state = 2},
  [1440] = {.lex_state = 5, .external_lex_state = 3},
  [1441] = {.lex_state = 9},
  [1442] = {.lex_state = 9, .external_lex_state = 4},
  [1443] = {.lex_state = 9},
  [1444] = {.lex_state = 9, .external_lex_state = 4},
  [1445] = {.lex_state = 9},
  [1446] = {.lex_state = 9},
  [1447] = {.lex_state = 9},
  [1448] = {.lex_state = 9, .external_lex_state = 4},
  [1449] = {.lex_state = 9, .external_lex_state = 4},
  [1450] = {.lex_state = 9, .external_lex_state = 4},
  [1451] = {.lex_state = 9, .external_lex_state = 4},
  [1452] = {.lex_state = 9, .external_lex_state = 4},
  [1453] = {.lex_state = 9, .external_lex_state = 4},
  [1454] = {.lex_state = 9, .external_lex_state = 4},
  [1455] = {.lex_state = 9, .external_lex_state = 4},
  [1456] = {.lex_state = 9, .external_lex_state = 4},
  [1457] = {.lex_state = 9, .external_lex_state = 4},
  [1458] = {.lex_state = 9, .external_lex_state = 4},
  [1459] = {.lex_state = 9, .external_lex_state = 4},
  [1460] = {.lex_state = 9, .external_lex_state = 4},
  [1461] = {.lex_state = 9, .external_lex_state = 4},
  [1462] = {.lex_state = 9, .external_lex_state = 4},
  [1463] = {.lex_state = 5, .external_lex_state = 3},
  [1464] = {.lex_state = 9, .external_lex_state = 4},
  [1465] = {.lex_state = 5, .external_lex_state = 2},
  [1466] = {.lex_state = 9, .external_lex_state = 4},
  [1467] = {.lex_state = 9, .external_lex_state = 4},
  [1468] = {.lex_state = 5, .external_lex_state = 2},
  [1469] = {.lex_state = 9, .external_lex_state = 4},
  [1470] = {.lex_state = 9, .external_lex_state = 4},
  [1471] = {.lex_state = 9, .external_lex_state = 4},
  [1472] = {.lex_state = 9},
  [1473] = {.lex_state = 9, .external_lex_state = 4},
  [1474] = {.lex_state = 5, .external_lex_state = 2},
  [1475] = {.lex_state = 5, .external_lex_state = 2},
  [1476] = {.lex_state = 9},
  [1477] = {.lex_state = 5, .external_lex_state = 2},
  [1478] = {.lex_state = 9, .external_lex_state = 4},
  [1479] = {.lex_state = 9, .external_lex_state = 4},
  [1480] = {.lex_state = 9},
  [1481] = {.lex_state = 9},
  [1482] = {.lex_state = 9, .external_lex_state = 4},
  [1483] = {.lex_state = 9, .external_lex_state = 4},
  [1484] = {.lex_state = 5, .external_lex_state = 2},
  [1485] = {.lex_state = 5, .external_lex_state = 2},
  [1486] = {.lex_state = 5, .external_lex_state = 2},
  [1487] = {.lex_state = 9},
  [1488] = {.lex_state = 9, .external_lex_state = 4},
  [1489] = {.lex_state = 9, .external_lex_state = 4},
  [1490] = {.lex_state = 9, .external_lex_state = 4},
  [1491] = {.lex_state = 9, .external_lex_state = 4},
  [1492] = {.lex_state = 9, .external_lex_state = 4},
  [1493] = {.lex_state = 9},
  [1494] = {.lex_state = 9},
  [1495] = {.lex_state = 9, .external_lex_state = 4},
  [1496] = {.lex_state = 9, .external_lex_state = 4},
  [1497] = {.lex_state = 9, .external_lex_state = 4},
  [1498] = {.lex_state = 5, .external_lex_state = 2},
  [1499] = {.lex_state = 5, .external_lex_state = 2},
  [1500] = {.lex_state = 5, .external_lex_state = 2},
  [1501] = {.lex_state = 5, .external_lex_state = 2},
  [1502] = {.lex_state = 5, .external_lex_state = 2},
  [1503] = {.lex_state = 5, .external_lex_state = 2},
  [1504] = {.lex_state = 5, .external_lex_state = 2},
  [1505] = {.lex_state = 9, .external_lex_state = 4},
  [1506] = {.lex_state = 9, .external_lex_state = 4},
  [1507] = {.lex_state = 5, .external_lex_state = 2},
  [1508] = {.lex_state = 5, .external_lex_state = 2},
  [1509] = {.lex_state = 5, .external_lex_state = 2},
  [1510] = {.lex_state = 5, .external_lex_state = 2},
  [1511] = {.lex_state = 5, .external_lex_state = 2},
  [1512] = {.lex_state = 5, .external_lex_state = 2},
  [1513] = {.lex_state = 9, .external_lex_state = 4},
  [1514] = {.lex_state = 5, .external_lex_state = 2},
  [1515] = {.lex_state = 9, .external_lex_state = 4},
  [1516] = {.lex_state = 5, .external_lex_state = 2},
  [1517] = {.lex_state = 9, .external_lex_state = 4},
  [1518] = {.lex_state = 9, .external_lex_state = 4},
  [1519] = {.lex_state = 9, .external_lex_state = 4},
  [1520] = {.lex_state = 5, .external_lex_state = 2},
  [1521] = {.lex_state = 9, .external_lex_state = 4},
  [1522] = {.lex_state = 5, .external_lex_state = 2},
  [1523] = {.lex_state = 5, .external_lex_state = 3},
  [1524] = {.lex_state = 5, .external_lex_state = 3},
  [1525] = {.lex_state = 5, .external_lex_state = 2},
  [1526] = {.lex_state = 5, .external_lex_state = 2},
  [1527] = {.lex_state = 5, .external_lex_state = 2},
  [1528] = {.lex_state = 5, .external_lex_state = 2},
  [1529] = {.lex_state = 5, .external_lex_state = 2},
  [1530] = {.lex_state = 5, .external_lex_state = 2},
  [1531] = {.lex_state = 5, .external_lex_state = 2},
  [1532] = {.lex_state = 5, .external_lex_state = 2},
  [1533] = {.lex_state = 5, .external_lex_state = 2},
  [1534] = {.lex_state = 5, .external_lex_state = 2},
  [1535] = {.lex_state = 5, .external_lex_state = 2},
  [1536] = {.lex_state = 9},
  [1537] = {.lex_state = 5, .external_lex_state = 2},
  [1538] = {.lex_state = 5, .external_lex_state = 2},
  [1539] = {.lex_state = 5, .external_lex_state = 2},
  [1540] = {.lex_state = 5, .external_lex_state = 2},
  [1541] = {.lex_state = 5, .external_lex_state = 2},
  [1542] = {.lex_state = 5, .external_lex_state = 2},
  [1543] = {.lex_state = 5, .external_lex_state = 2},
  [1544] = {.lex_state = 5, .external_lex_state = 2},
  [1545] = {.lex_state = 9, .external_lex_state = 4},
  [1546] = {.lex_state = 5, .external_lex_state = 2},
  [1547] = {.lex_state = 5, .external_lex_state = 2},
  [1548] = {.lex_state = 5, .external_lex_state = 2},
  [1549] = {.lex_state = 5, .external_lex_state = 2},
  [1550] = {.lex_state = 9, .external_lex_state = 4},
  [1551] = {.lex_state = 5, .external_lex_state = 2},
  [1552] = {.lex_state = 9, .external_lex_state = 4},
  [1553] = {.lex_state = 5, .external_lex_state = 2},
  [1554] = {.lex_state = 5, .external_lex_state = 2},
  [1555] = {.lex_state = 5, .external_lex_state = 2},
  [1556] = {.lex_state = 5, .external_lex_state = 2},
  [1557] = {.lex_state = 5, .external_lex_state = 2},
  [1558] = {.lex_state = 5, .external_lex_state = 2},
  [1559] = {.lex_state = 9, .external_lex_state = 4},
  [1560] = {.lex_state = 5, .external_lex_state = 2},
  [1561] = {.lex_state = 5, .external_lex_state = 2},
  [1562] = {.lex_state = 5, .external_lex_state = 2},
  [1563] = {.lex_state = 5, .external_lex_state = 2},
  [1564] = {.lex_state = 5, .external_lex_state = 2},
  [1565] = {.lex_state = 5, .external_lex_state = 2},
  [1566] = {.lex_state = 5, .external_lex_state = 2},
  [1567] = {.lex_state = 5, .external_lex_state = 2},
  [1568] = {.lex_state = 5, .external_lex_state = 2},
  [1569] = {.lex_state = 9, .external_lex_state = 4},
  [1570] = {.lex_state = 5, .external_lex_state = 2},
  [1571] = {.lex_state = 5, .external_lex_state = 2},
  [1572] = {.lex_state = 9, .external_lex_state = 4},
  [1573] = {.lex_state = 5, .external_lex_state = 2},
  [1574] = {.lex_state = 5, .external_lex_state = 2},
  [1575] = {.lex_state = 9, .external_lex_state = 4},
  [1576] = {.lex_state = 5, .external_lex_state = 2},
  [1577] = {.lex_state = 5, .external_lex_state = 2},
  [1578] = {.lex_state = 9},
  [1579] = {.lex_state = 5, .external_lex_state = 2},
  [1580] = {.lex_state = 5, .external_lex_state = 2},
  [1581] = {.lex_state = 5, .external_lex_state = 2},
  [1582] = {.lex_state = 5, .external_lex_state = 2},
  [1583] = {.lex_state = 5, .external_lex_state = 2},
  [1584] = {.lex_state = 9},
  [1585] = {.lex_state = 5, .external_lex_state = 2},
  [1586] = {.lex_state = 5, .external_lex_state = 2},
  [1587] = {.lex_state = 5, .external_lex_state = 2},
  [1588] = {.lex_state = 5, .external_lex_state = 2},
  [1589] = {.lex_state = 9, .external_lex_state = 4},
  [1590] = {.lex_state = 5, .external_lex_state = 2},
  [1591] = {.lex_state = 9, .external_lex_state = 4},
  [1592] = {.lex_state = 9},
  [1593] = {.lex_state = 5, .external_lex_state = 2},
  [1594] = {.lex_state = 5, .external_lex_state = 2},
  [1595] = {.lex_state = 5, .external_lex_state = 2},
  [1596] = {.lex_state = 9},
  [1597] = {.lex_state = 5, .external_lex_state = 2},
  [1598] = {.lex_state = 5, .external_lex_state = 2},
  [1599] = {.lex_state = 5, .external_lex_state = 2},
  [1600] = {.lex_state = 5, .external_lex_state = 2},
  [1601] = {.lex_state = 9},
  [1602] = {.lex_state = 5, .external_lex_state = 2},
  [1603] = {.lex_state = 5, .external_lex_state = 2},
  [1604] = {.lex_state = 5, .external_lex_state = 2},
  [1605] = {.lex_state = 5, .external_lex_state = 2},
  [1606] = {.lex_state = 5, .external_lex_state = 2},
  [1607] = {.lex_state = 5, .external_lex_state = 2},
  [1608] = {.lex_state = 5, .external_lex_state = 2},
  [1609] = {.lex_state = 5, .external_lex_state = 3},
  [1610] = {.lex_state = 9},
  [1611] = {.lex_state = 5, .external_lex_state = 2},
  [1612] = {.lex_state = 5, .external_lex_state = 2},
  [1613] = {.lex_state = 5, .external_lex_state = 2},
  [1614] = {.lex_state = 5, .external_lex_state = 2},
  [1615] = {.lex_state = 9},
  [1616] = {.lex_state = 5, .external_lex_state = 2},
  [1617] = {.lex_state = 9},
  [1618] = {.lex_state = 5, .external_lex_state = 2},
  [1619] = {.lex_state = 5, .external_lex_state = 2},
  [1620] = {.lex_state = 5, .external_lex_state = 2},
  [1621] = {.lex_state = 5, .external_lex_state = 2},
  [1622] = {.lex_state = 5, .external_lex_state = 2},
  [1623] = {.lex_state = 5, .external_lex_state = 2},
  [1624] = {.lex_state = 9, .external_lex_state = 4},
  [1625] = {.lex_state = 5, .external_lex_state = 2},
  [1626] = {.lex_state = 5, .external_lex_state = 2},
  [1627] = {.lex_state = 9, .external_lex_state = 4},
  [1628] = {.lex_state = 5, .external_lex_state = 2},
  [1629] = {.lex_state = 5, .external_lex_state = 2},
  [1630] = {.lex_state = 5, .external_lex_state = 3},
  [1631] = {.lex_state = 5, .external_lex_state = 2},
  [1632] = {.lex_state = 9},
  [1633] = {.lex_state = 5, .external_lex_state = 2},
  [1634] = {.lex_state = 5, .external_lex_state = 2},
  [1635] = {.lex_state = 5, .external_lex_state = 2},
  [1636] = {.lex_state = 5, .external_lex_state = 2},
  [1637] = {.lex_state = 5, .external_lex_state = 2},
  [1638] = {.lex_state = 9},
  [1639] = {.lex_state = 5, .external_lex_state = 2},
  [1640] = {.lex_state = 5, .external_lex_state = 2},
  [1641] = {.lex_state = 5, .external_lex_state = 2},
  [1642] = {.lex_state = 5, .external_lex_state = 2},
  [1643] = {.lex_state = 5, .external_lex_state = 2},
  [1644] = {.lex_state = 5, .external_lex_state = 2},
  [1645] = {.lex_state = 5, .external_lex_state = 2},
  [1646] = {.lex_state = 5, .external_lex_state = 2},
  [1647] = {.lex_state = 5, .external_lex_state = 2},
  [1648] = {.lex_state = 5, .external_lex_state = 2},
  [1649] = {.lex_state = 5, .external_lex_state = 2},
  [1650] = {.lex_state = 5, .external_lex_state = 2},
  [1651] = {.lex_state = 5, .external_lex_state = 2},
  [1652] = {.lex_state = 5, .external_lex_state = 2},
  [1653] = {.lex_state = 5, .external_lex_state = 2},
  [1654] = {.lex_state = 5, .external_lex_state = 2},
  [1655] = {.lex_state = 5, .external_lex_state = 2},
  [1656] = {.lex_state = 5, .external_lex_state = 2},
  [1657] = {.lex_state = 5, .external_lex_state = 2},
  [1658] = {.lex_state = 5, .external_lex_state = 3},
  [1659] = {.lex_state = 9, .external_lex_state = 4},
  [1660] = {.lex_state = 5, .external_lex_state = 2},
  [1661] = {.lex_state = 5, .external_lex_state = 2},
  [1662] = {.lex_state = 5, .external_lex_state = 2},
  [1663] = {.lex_state = 9, .external_lex_state = 4},
  [1664] = {.lex_state = 5, .external_lex_state = 2},
  [1665] = {.lex_state = 5, .external_lex_state = 2},
  [1666] = {.lex_state = 5, .external_lex_state = 2},
  [1667] = {.lex_state = 5, .external_lex_state = 2},
  [1668] = {.lex_state = 5, .external_lex_state = 2},
  [1669] = {.lex_state = 5, .external_lex_state = 3},
  [1670] = {.lex_state = 5, .external_lex_state = 2},
  [1671] = {.lex_state = 5, .external_lex_state = 2},
  [1672] = {.lex_state = 9},
  [1673] = {.lex_state = 5, .external_lex_state = 2},
  [1674] = {.lex_state = 5, .external_lex_state = 2},
  [1675] = {.lex_state = 5, .external_lex_state = 2},
  [1676] = {.lex_state = 5, .external_lex_state = 2},
  [1677] = {.lex_state = 5, .external_lex_state = 2},
  [1678] = {.lex_state = 5, .external_lex_state = 2},
  [1679] = {.lex_state = 5, .external_lex_state = 2},
  [1680] = {.lex_state = 5, .external_lex_state = 2},
  [1681] = {.lex_state = 5, .external_lex_state = 2},
  [1682] = {.lex_state = 5, .external_lex_state = 2},
  [1683] = {.lex_state = 5, .external_lex_state = 2},
  [1684] = {.lex_state = 5, .external_lex_state = 2},
  [1685] = {.lex_state = 5, .external_lex_state = 2},
  [1686] = {.lex_state = 5, .external_lex_state = 2},
  [1687] = {.lex_state = 5, .external_lex_state = 2},
  [1688] = {.lex_state = 5, .external_lex_state = 2},
  [1689] = {.lex_state = 5, .external_lex_state = 2},
  [1690] = {.lex_state = 5, .external_lex_state = 2},
  [1691] = {.lex_state = 5, .external_lex_state = 2},
  [1692] = {.lex_state = 5, .external_lex_state = 2},
  [1693] = {.lex_state = 5, .external_lex_state = 2},
  [1694] = {.lex_state = 5, .external_lex_state = 2},
  [1695] = {.lex_state = 5, .external_lex_state = 2},
  [1696] = {.lex_state = 5, .external_lex_state = 2},
  [1697] = {.lex_state = 9, .external_lex_state = 4},
  [1698] = {.lex_state = 5, .external_lex_state = 2},
  [1699] = {.lex_state = 5, .external_lex_state = 2},
  [1700] = {.lex_state = 5, .external_lex_state = 2},
  [1701] = {.lex_state = 5, .external_lex_state = 3},
  [1702] = {.lex_state = 5, .external_lex_state = 2},
  [1703] = {.lex_state = 5, .external_lex_state = 2},
  [1704] = {.lex_state = 5, .external_lex_state = 2},
  [1705] = {.lex_state = 5, .external_lex_state = 2},
  [1706] = {.lex_state = 5, .external_lex_state = 2},
  [1707] = {.lex_state = 5, .external_lex_state = 2},
  [1708] = {.lex_state = 5, .external_lex_state = 3},
  [1709] = {.lex_state = 5, .external_lex_state = 2},
  [1710] = {.lex_state = 5, .external_lex_state = 3},
  [1711] = {.lex_state = 5, .external_lex_state = 2},
  [1712] = {.lex_state = 5, .external_lex_state = 2},
  [1713] = {.lex_state = 5, .external_lex_state = 2},
  [1714] = {.lex_state = 5, .external_lex_state = 2},
  [1715] = {.lex_state = 5, .external_lex_state = 2},
  [1716] = {.lex_state = 5, .external_lex_state = 2},
  [1717] = {.lex_state = 5, .external_lex_state = 2},
  [1718] = {.lex_state = 9, .external_lex_state = 4},
  [1719] = {.lex_state = 9, .external_lex_state = 4},
  [1720] = {.lex_state = 5, .external_lex_state = 2},
  [1721] = {.lex_state = 5, .external_lex_state = 3},
  [1722] = {.lex_state = 5, .external_lex_state = 2},
  [1723] = {.lex_state = 5, .external_lex_state = 2},
  [1724] = {.lex_state = 5, .external_lex_state = 2},
  [1725] = {.lex_state = 5, .external_lex_state = 2},
  [1726] = {.lex_state = 5, .external_lex_state = 2},
  [1727] = {.lex_state = 11},
  [1728] = {.lex_state = 5, .external_lex_state = 3},
  [1729] = {.lex_state = 5, .external_lex_state = 2},
  [1730] = {.lex_state = 5, .external_lex_state = 2},
  [1731] = {.lex_state = 5, .external_lex_state = 2},
  [1732] = {.lex_state = 5, .external_lex_state = 2},
  [1733] = {.lex_state = 5, .external_lex_state = 2},
  [1734] = {.lex_state = 5, .external_lex_state = 2},
  [1735] = {.lex_state = 5, .external_lex_state = 2},
  [1736] = {.lex_state = 5, .external_lex_state = 3},
  [1737] = {.lex_state = 5, .external_lex_state = 2},
  [1738] = {.lex_state = 5, .external_lex_state = 2},
  [1739] = {.lex_state = 5, .external_lex_state = 3},
  [1740] = {.lex_state = 5, .external_lex_state = 3},
  [1741] = {.lex_state = 5, .external_lex_state = 3},
  [1742] = {.lex_state = 5, .external_lex_state = 3},
  [1743] = {.lex_state = 5, .external_lex_state = 3},
  [1744] = {.lex_state = 5, .external_lex_state = 2},
  [1745] = {.lex_state = 5, .external_lex_state = 3},
  [1746] = {.lex_state = 5, .external_lex_state = 3},
  [1747] = {.lex_state = 5, .external_lex_state = 3},
  [1748] = {.lex_state = 5, .external_lex_state = 3},
  [1749] = {.lex_state = 5, .external_lex_state = 3},
  [1750] = {.lex_state = 9},
  [1751] = {.lex_state = 5, .external_lex_state = 3},
  [1752] = {.lex_state = 5, .external_lex_state = 3},
  [1753] = {.lex_state = 5, .external_lex_state = 3},
  [1754] = {.lex_state = 5, .external_lex_state = 3},
  [1755] = {.lex_state = 5, .external_lex_state = 3},
  [1756] = {.lex_state = 5, .external_lex_state = 3},
  [1757] = {.lex_state = 5, .external_lex_state = 3},
  [1758] = {.lex_state = 5, .external_lex_state = 3},
  [1759] = {.lex_state = 5, .external_lex_state = 3},
  [1760] = {.lex_state = 5, .external_lex_state = 3},
  [1761] = {.lex_state = 5, .external_lex_state = 3},
  [1762] = {.lex_state = 9},
  [1763] = {.lex_state = 5, .external_lex_state = 3},
  [1764] = {.lex_state = 5, .external_lex_state = 3},
  [1765] = {.lex_state = 5, .external_lex_state = 2},
  [1766] = {.lex_state = 5, .external_lex_state = 3},
  [1767] = {.lex_state = 5, .external_lex_state = 2},
  [1768] = {.lex_state = 9},
  [1769] = {.lex_state = 5, .external_lex_state = 2},
  [1770] = {.lex_state = 5, .external_lex_state = 3},
  [1771] = {.lex_state = 5, .external_lex_state = 3},
  [1772] = {.lex_state = 5, .external_lex_state = 3},
  [1773] = {.lex_state = 5, .external_lex_state = 3},
  [1774] = {.lex_state = 5, .external_lex_state = 2},
  [1775] = {.lex_state = 5, .external_lex_state = 3},
  [1776] = {.lex_state = 5, .external_lex_state = 3},
  [1777] = {.lex_state = 5, .external_lex_state = 3},
  [1778] = {.lex_state = 5, .external_lex_state = 3},
  [1779] = {.lex_state = 5, .external_lex_state = 3},
  [1780] = {.lex_state = 5, .external_lex_state = 3},
  [1781] = {.lex_state = 9},
  [1782] = {.lex_state = 5, .external_lex_state = 2},
  [1783] = {.lex_state = 5, .external_lex_state = 3},
  [1784] = {.lex_state = 5, .external_lex_state = 3},
  [1785] = {.lex_state = 5, .external_lex_state = 3},
  [1786] = {.lex_state = 9},
  [1787] = {.lex_state = 5, .external_lex_state = 3},
  [1788] = {.lex_state = 9},
  [1789] = {.lex_state = 9},
  [1790] = {.lex_state = 9},
  [1791] = {.lex_state = 5, .external_lex_state = 3},
  [1792] = {.lex_state = 5, .external_lex_state = 2},
  [1793] = {.lex_state = 9, .external_lex_state = 4},
  [1794] = {.lex_state = 5, .external_lex_state = 2},
  [1795] = {.lex_state = 5, .external_lex_state = 2},
  [1796] = {.lex_state = 5, .external_lex_state = 3},
  [1797] = {.lex_state = 9},
  [1798] = {.lex_state = 9},
  [1799] = {.lex_state = 5, .external_lex_state = 3},
  [1800] = {.lex_state = 5, .external_lex_state = 3},
  [1801] = {.lex_state = 5, .external_lex_state = 3},
  [1802] = {.lex_state = 5, .external_lex_state = 2},
  [1803] = {.lex_state = 5, .external_lex_state = 3},
  [1804] = {.lex_state = 5, .external_lex_state = 3},
  [1805] = {.lex_state = 5, .external_lex_state = 3},
  [1806] = {.lex_state = 5, .external_lex_state = 3},
  [1807] = {.lex_state = 5, .external_lex_state = 3},
  [1808] = {.lex_state = 5, .external_lex_state = 3},
  [1809] = {.lex_state = 5, .external_lex_state = 3},
  [1810] = {.lex_state = 5, .external_lex_state = 3},
  [1811] = {.lex_state = 5, .external_lex_state = 3},
  [1812] = {.lex_state = 5, .external_lex_state = 3},
  [1813] = {.lex_state = 9},
  [1814] = {.lex_state = 5, .external_lex_state = 3},
  [1815] = {.lex_state = 5, .external_lex_state = 3},
  [1816] = {.lex_state = 9},
  [1817] = {.lex_state = 9},
  [1818] = {.lex_state = 9, .external_lex_state = 4},
  [1819] = {.lex_state = 5, .external_lex_state = 3},
  [1820] = {.lex_state = 5, .external_lex_state = 3},
  [1821] = {.lex_state = 5, .external_lex_state = 3},
  [1822] = {.lex_state = 5, .external_lex_state = 3},
  [1823] = {.lex_state = 5, .external_lex_state = 2},
  [1824] = {.lex_state = 5, .external_lex_state = 3},
  [1825] = {.lex_state = 9},
  [1826] = {.lex_state = 5, .external_lex_state = 2},
  [1827] = {.lex_state = 5, .external_lex_state = 3},
  [1828] = {.lex_state = 9},
  [1829] = {.lex_state = 9},
  [1830] = {.lex_state = 5, .external_lex_state = 3},
  [1831] = {.lex_state = 5, .external_lex_state = 3},
  [1832] = {.lex_state = 5, .external_lex_state = 3},
  [1833] = {.lex_state = 5, .external_lex_state = 3},
  [1834] = {.lex_state = 5, .external_lex_state = 2},
  [1835] = {.lex_state = 5, .external_lex_state = 3},
  [1836] = {.lex_state = 5, .external_lex_state = 3},
  [1837] = {.lex_state = 5, .external_lex_state = 3},
  [1838] = {.lex_state = 5, .external_lex_state = 3},
  [1839] = {.lex_state = 5, .external_lex_state = 3},
  [1840] = {.lex_state = 9},
  [1841] = {.lex_state = 5, .external_lex_state = 3},
  [1842] = {.lex_state = 5, .external_lex_state = 3},
  [1843] = {.lex_state = 5, .external_lex_state = 3},
  [1844] = {.lex_state = 5, .external_lex_state = 3},
  [1845] = {.lex_state = 5, .external_lex_state = 3},
  [1846] = {.lex_state = 5, .external_lex_state = 2},
  [1847] = {.lex_state = 5, .external_lex_state = 3},
  [1848] = {.lex_state = 5, .external_lex_state = 3},
  [1849] = {.lex_state = 5, .external_lex_state = 3},
  [1850] = {.lex_state = 5, .external_lex_state = 3},
  [1851] = {.lex_state = 5, .external_lex_state = 3},
  [1852] = {.lex_state = 5, .external_lex_state = 3},
  [1853] = {.lex_state = 5, .external_lex_state = 2},
  [1854] = {.lex_state = 5, .external_lex_state = 3},
  [1855] = {.lex_state = 5, .external_lex_state = 3},
  [1856] = {.lex_state = 5, .external_lex_state = 3},
  [1857] = {.lex_state = 5, .external_lex_state = 3},
  [1858] = {.lex_state = 5, .external_lex_state = 3},
  [1859] = {.lex_state = 5, .external_lex_state = 3},
  [1860] = {.lex_state = 5, .external_lex_state = 3},
  [1861] = {.lex_state = 5, .external_lex_state = 3},
  [1862] = {.lex_state = 5, .external_lex_state = 2},
  [1863] = {.lex_state = 5, .external_lex_state = 3},
  [1864] = {.lex_state = 5, .external_lex_state = 3},
  [1865] = {.lex_state = 5, .external_lex_state = 2},
  [1866] = {.lex_state = 5, .external_lex_state = 2},
  [1867] = {.lex_state = 5, .external_lex_state = 2},
  [1868] = {.lex_state = 5, .external_lex_state = 2},
  [1869] = {.lex_state = 5, .external_lex_state = 2},
  [1870] = {.lex_state = 5, .external_lex_state = 2},
  [1871] = {.lex_state = 5, .external_lex_state = 2},
  [1872] = {.lex_state = 5, .external_lex_state = 2},
  [1873] = {.lex_state = 5, .external_lex_state = 2},
  [1874] = {.lex_state = 5, .external_lex_state = 3},
  [1875] = {.lex_state = 5, .external_lex_state = 3},
  [1876] = {.lex_state = 5, .external_lex_state = 3},
  [1877] = {.lex_state = 5, .external_lex_state = 3},
  [1878] = {.lex_state = 5, .external_lex_state = 3},
  [1879] = {.lex_state = 5, .external_lex_state = 3},
  [1880] = {.lex_state = 5, .external_lex_state = 3},
  [1881] = {.lex_state = 5, .external_lex_state = 3},
  [1882] = {.lex_state = 5, .external_lex_state = 3},
  [1883] = {.lex_state = 5, .external_lex_state = 3},
  [1884] = {.lex_state = 5, .external_lex_state = 3},
  [1885] = {.lex_state = 5, .external_lex_state = 3},
  [1886] = {.lex_state = 9},
  [1887] = {.lex_state = 5, .external_lex_state = 2},
  [1888] = {.lex_state = 5, .external_lex_state = 3},
  [1889] = {.lex_state = 5, .external_lex_state = 3},
  [1890] = {.lex_state = 5, .external_lex_state = 3},
  [1891] = {.lex_state = 5, .external_lex_state = 3},
  [1892] = {.lex_state = 5, .external_lex_state = 3},
  [1893] = {.lex_state = 5, .external_lex_state = 3},
  [1894] = {.lex_state = 5, .external_lex_state = 3},
  [1895] = {.lex_state = 5, .external_lex_state = 3},
  [1896] = {.lex_state = 5, .external_lex_state = 3},
  [1897] = {.lex_state = 5, .external_lex_state = 3},
  [1898] = {.lex_state = 5, .external_lex_state = 3},
  [1899] = {.lex_state = 5, .external_lex_state = 3},
  [1900] = {.lex_state = 5, .external_lex_state = 3},
  [1901] = {.lex_state = 5, .external_lex_state = 3},
  [1902] = {.lex_state = 5, .external_lex_state = 3},
  [1903] = {.lex_state = 5, .external_lex_state = 3},
  [1904] = {.lex_state = 5, .external_lex_state = 3},
  [1905] = {.lex_state = 5, .external_lex_state = 3},
  [1906] = {.lex_state = 5, .external_lex_state = 3},
  [1907] = {.lex_state = 5, .external_lex_state = 3},
  [1908] = {.lex_state = 5, .external_lex_state = 3},
  [1909] = {.lex_state = 5, .external_lex_state = 2},
  [1910] = {.lex_state = 5, .external_lex_state = 2},
  [1911] = {.lex_state = 5, .external_lex_state = 2},
  [1912] = {.lex_state = 5, .external_lex_state = 2},
  [1913] = {.lex_state = 5, .external_lex_state = 2},
  [1914] = {.lex_state = 5, .external_lex_state = 2},
  [1915] = {.lex_state = 5, .external_lex_state = 2},
  [1916] = {.lex_state = 5, .external_lex_state = 2},
  [1917] = {.lex_state = 5, .external_lex_state = 2},
  [1918] = {.lex_state = 5, .external_lex_state = 2},
  [1919] = {.lex_state = 5, .external_lex_state = 3},
  [1920] = {.lex_state = 5, .external_lex_state = 3},
  [1921] = {.lex_state = 5, .external_lex_state = 3},
  [1922] = {.lex_state = 5, .external_lex_state = 3},
  [1923] = {.lex_state = 5, .external_lex_state = 3},
  [1924] = {.lex_state = 5, .external_lex_state = 3},
  [1925] = {.lex_state = 5, .external_lex_state = 3},
  [1926] = {.lex_state = 5, .external_lex_state = 3},
  [1927] = {.lex_state = 5, .external_lex_state = 3},
  [1928] = {.lex_state = 5, .external_lex_state = 3},
  [1929] = {.lex_state = 5, .external_lex_state = 3},
  [1930] = {.lex_state = 5, .external_lex_state = 3},
  [1931] = {.lex_state = 5, .external_lex_state = 2},
  [1932] = {.lex_state = 5, .external_lex_state = 2},
  [1933] = {.lex_state = 5, .external_lex_state = 2},
  [1934] = {.lex_state = 5, .external_lex_state = 3},
  [1935] = {.lex_state = 5, .external_lex_state = 3},
  [1936] = {.lex_state = 5, .external_lex_state = 3},
  [1937] = {.lex_state = 5, .external_lex_state = 3},
  [1938] = {.lex_state = 5, .external_lex_state = 2},
  [1939] = {.lex_state = 5, .external_lex_state = 3},
  [1940] = {.lex_state = 5, .external_lex_state = 3},
  [1941] = {.lex_state = 5, .external_lex_state = 3},
  [1942] = {.lex_state = 5, .external_lex_state = 2},
  [1943] = {.lex_state = 5, .external_lex_state = 3},
  [1944] = {.lex_state = 5, .external_lex_state = 2},
  [1945] = {.lex_state = 5, .external_lex_state = 3},
  [1946] = {.lex_state = 5, .external_lex_state = 2},
  [1947] = {.lex_state = 5, .external_lex_state = 2},
  [1948] = {.lex_state = 5, .external_lex_state = 2},
  [1949] = {.lex_state = 5, .external_lex_state = 3},
  [1950] = {.lex_state = 5, .external_lex_state = 2},
  [1951] = {.lex_state = 5, .external_lex_state = 2},
  [1952] = {.lex_state = 5, .external_lex_state = 3},
  [1953] = {.lex_state = 5, .external_lex_state = 3},
  [1954] = {.lex_state = 5, .external_lex_state = 3},
  [1955] = {.lex_state = 5, .external_lex_state = 2},
  [1956] = {.lex_state = 5, .external_lex_state = 3},
  [1957] = {.lex_state = 5, .external_lex_state = 3},
  [1958] = {.lex_state = 5, .external_lex_state = 3},
  [1959] = {.lex_state = 5, .external_lex_state = 3},
  [1960] = {.lex_state = 5, .external_lex_state = 3},
  [1961] = {.lex_state = 5, .external_lex_state = 3},
  [1962] = {.lex_state = 5, .external_lex_state = 3},
  [1963] = {.lex_state = 5, .external_lex_state = 3},
  [1964] = {.lex_state = 5, .external_lex_state = 3},
  [1965] = {.lex_state = 5, .external_lex_state = 3},
  [1966] = {.lex_state = 5, .external_lex_state = 3},
  [1967] = {.lex_state = 5, .external_lex_state = 3},
  [1968] = {.lex_state = 5, .external_lex_state = 3},
  [1969] = {.lex_state = 5, .external_lex_state = 2},
  [1970] = {.lex_state = 5, .external_lex_state = 2},
  [1971] = {.lex_state = 5, .external_lex_state = 3},
  [1972] = {.lex_state = 6, .external_lex_state = 2},
  [1973] = {.lex_state = 5, .external_lex_state = 3},
  [1974] = {.lex_state = 5, .external_lex_state = 2},
  [1975] = {.lex_state = 5, .external_lex_state = 2},
  [1976] = {.lex_state = 5, .external_lex_state = 3},
  [1977] = {.lex_state = 5, .external_lex_state = 3},
  [1978] = {.lex_state = 5, .external_lex_state = 3},
  [1979] = {.lex_state = 5, .external_lex_state = 3},
  [1980] = {.lex_state = 5, .external_lex_state = 2},
  [1981] = {.lex_state = 5, .external_lex_state = 2},
  [1982] = {.lex_state = 5, .external_lex_state = 2},
  [1983] = {.lex_state = 5, .external_lex_state = 2},
  [1984] = {.lex_state = 5, .external_lex_state = 3},
  [1985] = {.lex_state = 5, .external_lex_state = 2},
  [1986] = {.lex_state = 5, .external_lex_state = 2},
  [1987] = {.lex_state = 5, .external_lex_state = 2},
  [1988] = {.lex_state = 5, .external_lex_state = 3},
  [1989] = {.lex_state = 5, .external_lex_state = 3},
  [1990] = {.lex_state = 5, .external_lex_state = 3},
  [1991] = {.lex_state = 5, .external_lex_state = 3},
  [1992] = {.lex_state = 5, .external_lex_state = 3},
  [1993] = {.lex_state = 5, .external_lex_state = 3},
  [1994] = {.lex_state = 5, .external_lex_state = 3},
  [1995] = {.lex_state = 5, .external_lex_state = 3},
  [1996] = {.lex_state = 5, .external_lex_state = 3},
  [1997] = {.lex_state = 5, .external_lex_state = 3},
  [1998] = {.lex_state = 5, .external_lex_state = 3},
  [1999] = {.lex_state = 5, .external_lex_state = 2},
  [2000] = {.lex_state = 5, .external_lex_state = 2},
  [2001] = {.lex_state = 5, .external_lex_state = 3},
  [2002] = {.lex_state = 5, .external_lex_state = 3},
  [2003] = {.lex_state = 5, .external_lex_state = 2},
  [2004] = {.lex_state = 5, .external_lex_state = 3},
  [2005] = {.lex_state = 5, .external_lex_state = 3},
  [2006] = {.lex_state = 5, .external_lex_state = 3},
  [2007] = {.lex_state = 5, .external_lex_state = 2},
  [2008] = {.lex_state = 5, .external_lex_state = 3},
  [2009] = {.lex_state = 5, .external_lex_state = 3},
  [2010] = {.lex_state = 5, .external_lex_state = 2},
  [2011] = {.lex_state = 5, .external_lex_state = 3},
  [2012] = {.lex_state = 5, .external_lex_state = 3},
  [2013] = {.lex_state = 5, .external_lex_state = 3},
  [2014] = {.lex_state = 5, .external_lex_state = 3},
  [2015] = {.lex_state = 5, .external_lex_state = 2},
  [2016] = {.lex_state = 5, .external_lex_state = 2},
  [2017] = {.lex_state = 5, .external_lex_state = 2},
  [2018] = {.lex_state = 5, .external_lex_state = 2},
  [2019] = {.lex_state = 5, .external_lex_state = 2},
  [2020] = {.lex_state = 5, .external_lex_state = 2},
  [2021] = {.lex_state = 5, .external_lex_state = 3},
  [2022] = {.lex_state = 5, .external_lex_state = 2},
  [2023] = {.lex_state = 5, .external_lex_state = 3},
  [2024] = {.lex_state = 5, .external_lex_state = 2},
  [2025] = {.lex_state = 5, .external_lex_state = 2},
  [2026] = {.lex_state = 5, .external_lex_state = 2},
  [2027] = {.lex_state = 5, .external_lex_state = 2},
  [2028] = {.lex_state = 5, .external_lex_state = 2},
  [2029] = {.lex_state = 5, .external_lex_state = 2},
  [2030] = {.lex_state = 5, .external_lex_state = 3},
  [2031] = {.lex_state = 5, .external_lex_state = 3},
  [2032] = {.lex_state = 12},
  [2033] = {.lex_state = 5, .external_lex_state = 3},
  [2034] = {.lex_state = 5, .external_lex_state = 3},
  [2035] = {.lex_state = 5, .external_lex_state = 2},
  [2036] = {.lex_state = 5, .external_lex_state = 3},
  [2037] = {.lex_state = 5, .external_lex_state = 3},
  [2038] = {.lex_state = 5, .external_lex_state = 3},
  [2039] = {.lex_state = 5, .external_lex_state = 3},
  [2040] = {.lex_state = 5, .external_lex_state = 3},
  [2041] = {.lex_state = 5, .external_lex_state = 3},
  [2042] = {.lex_state = 5, .external_lex_state = 2},
  [2043] = {.lex_state = 5, .external_lex_state = 3},
  [2044] = {.lex_state = 5, .external_lex_state = 3},
  [2045] = {.lex_state = 5, .external_lex_state = 3},
  [2046] = {.lex_state = 5, .external_lex_state = 3},
  [2047] = {.lex_state = 5, .external_lex_state = 2},
  [2048] = {.lex_state = 5, .external_lex_state = 3},
  [2049] = {.lex_state = 5, .external_lex_state = 3},
  [2050] = {.lex_state = 5, .external_lex_state = 3},
  [2051] = {.lex_state = 9},
  [2052] = {.lex_state = 5, .external_lex_state = 3},
  [2053] = {.lex_state = 5, .external_lex_state = 2},
  [2054] = {.lex_state = 5, .external_lex_state = 3},
  [2055] = {.lex_state = 5, .external_lex_state = 2},
  [2056] = {.lex_state = 5, .external_lex_state = 3},
  [2057] = {.lex_state = 5, .external_lex_state = 2},
  [2058] = {.lex_state = 5, .external_lex_state = 3},
  [2059] = {.lex_state = 5, .external_lex_state = 2},
  [2060] = {.lex_state = 5, .external_lex_state = 3},
  [2061] = {.lex_state = 5, .external_lex_state = 3},
  [2062] = {.lex_state = 5, .external_lex_state = 3},
  [2063] = {.lex_state = 5, .external_lex_state = 2},
  [2064] = {.lex_state = 5, .external_lex_state = 3},
  [2065] = {.lex_state = 5, .external_lex_state = 3},
  [2066] = {.lex_state = 5, .external_lex_state = 3},
  [2067] = {.lex_state = 5, .external_lex_state = 3},
  [2068] = {.lex_state = 5, .external_lex_state = 3},
  [2069] = {.lex_state = 5, .external_lex_state = 3},
  [2070] = {.lex_state = 5, .external_lex_state = 2},
  [2071] = {.lex_state = 5, .external_lex_state = 3},
  [2072] = {.lex_state = 5, .external_lex_state = 3},
  [2073] = {.lex_state = 5, .external_lex_state = 3},
  [2074] = {.lex_state = 5, .external_lex_state = 3},
  [2075] = {.lex_state = 5, .external_lex_state = 3},
  [2076] = {.lex_state = 5, .external_lex_state = 3},
  [2077] = {.lex_state = 5, .external_lex_state = 2},
  [2078] = {.lex_state = 5, .external_lex_state = 3},
  [2079] = {.lex_state = 5, .external_lex_state = 3},
  [2080] = {.lex_state = 5, .external_lex_state = 3},
  [2081] = {.lex_state = 5, .external_lex_state = 2},
  [2082] = {.lex_state = 5, .external_lex_state = 3},
  [2083] = {.lex_state = 5, .external_lex_state = 3},
  [2084] = {.lex_state = 5, .external_lex_state = 3},
  [2085] = {.lex_state = 5, .external_lex_state = 3},
  [2086] = {.lex_state = 5, .external_lex_state = 3},
  [2087] = {.lex_state = 5, .external_lex_state = 3},
  [2088] = {.lex_state = 5, .external_lex_state = 3},
  [2089] = {.lex_state = 5, .external_lex_state = 3},
  [2090] = {.lex_state = 5, .external_lex_state = 2},
  [2091] = {.lex_state = 5, .external_lex_state = 2},
  [2092] = {.lex_state = 5, .external_lex_state = 3},
  [2093] = {.lex_state = 5, .external_lex_state = 3},
  [2094] = {.lex_state = 5, .external_lex_state = 2},
  [2095] = {.lex_state = 5, .external_lex_state = 2},
  [2096] = {.lex_state = 5, .external_lex_state = 3},
  [2097] = {.lex_state = 5, .external_lex_state = 3},
  [2098] = {.lex_state = 5, .external_lex_state = 3},
  [2099] = {.lex_state = 5, .external_lex_state = 3},
  [2100] = {.lex_state = 5, .external_lex_state = 3},
  [2101] = {.lex_state = 5, .external_lex_state = 3},
  [2102] = {.lex_state = 5, .external_lex_state = 2},
  [2103] = {.lex_state = 9},
  [2104] = {.lex_state = 5, .external_lex_state = 3},
  [2105] = {.lex_state = 5, .external_lex_state = 3},
  [2106] = {.lex_state = 5, .external_lex_state = 3},
  [2107] = {.lex_state = 5, .external_lex_state = 2},
  [2108] = {.lex_state = 5, .external_lex_state = 3},
  [2109] = {.lex_state = 5, .external_lex_state = 3},
  [2110] = {.lex_state = 5, .external_lex_state = 3},
  [2111] = {.lex_state = 5, .external_lex_state = 2},
  [2112] = {.lex_state = 5, .external_lex_state = 3},
  [2113] = {.lex_state = 5, .external_lex_state = 3},
  [2114] = {.lex_state = 5, .external_lex_state = 2},
  [2115] = {.lex_state = 5, .external_lex_state = 2},
  [2116] = {.lex_state = 5, .external_lex_state = 2},
  [2117] = {.lex_state = 5, .external_lex_state = 3},
  [2118] = {.lex_state = 5, .external_lex_state = 2},
  [2119] = {.lex_state = 5, .external_lex_state = 3},
  [2120] = {.lex_state = 5, .external_lex_state = 2},
  [2121] = {.lex_state = 5, .external_lex_state = 3},
  [2122] = {.lex_state = 5, .external_lex_state = 2},
  [2123] = {.lex_state = 5, .external_lex_state = 3},
  [2124] = {.lex_state = 5, .external_lex_state = 2},
  [2125] = {.lex_state = 9},
  [2126] = {.lex_state = 5, .external_lex_state = 3},
  [2127] = {.lex_state = 5, .external_lex_state = 3},
  [2128] = {.lex_state = 5, .external_lex_state = 2},
  [2129] = {.lex_state = 5, .external_lex_state = 2},
  [2130] = {.lex_state = 5, .external_lex_state = 3},
  [2131] = {.lex_state = 5, .external_lex_state = 2},
  [2132] = {.lex_state = 5, .external_lex_state = 3},
  [2133] = {.lex_state = 5, .external_lex_state = 3},
  [2134] = {.lex_state = 5, .external_lex_state = 2},
  [2135] = {.lex_state = 5, .external_lex_state = 3},
  [2136] = {.lex_state = 5, .external_lex_state = 2},
  [2137] = {.lex_state = 5, .external_lex_state = 2},
  [2138] = {.lex_state = 5, .external_lex_state = 2},
  [2139] = {.lex_state = 5, .external_lex_state = 3},
  [2140] = {.lex_state = 5, .external_lex_state = 3},
  [2141] = {.lex_state = 5, .external_lex_state = 3},
  [2142] = {.lex_state = 5, .external_lex_state = 3},
  [2143] = {.lex_state = 5, .external_lex_state = 3},
  [2144] = {.lex_state = 5, .external_lex_state = 2},
  [2145] = {.lex_state = 5, .external_lex_state = 3},
  [2146] = {.lex_state = 5, .external_lex_state = 3},
  [2147] = {.lex_state = 5, .external_lex_state = 3},
  [2148] = {.lex_state = 5, .external_lex_state = 3},
  [2149] = {.lex_state = 5, .external_lex_state = 3},
  [2150] = {.lex_state = 5, .external_lex_state = 3},
  [2151] = {.lex_state = 5, .external_lex_state = 3},
  [2152] = {.lex_state = 5, .external_lex_state = 3},
  [2153] = {.lex_state = 5, .external_lex_state = 3},
  [2154] = {.lex_state = 5, .external_lex_state = 2},
  [2155] = {.lex_state = 5, .external_lex_state = 2},
  [2156] = {.lex_state = 5, .external_lex_state = 3},
  [2157] = {.lex_state = 5, .external_lex_state = 3},
  [2158] = {.lex_state = 5, .external_lex_state = 3},
  [2159] = {.lex_state = 5, .external_lex_state = 3},
  [2160] = {.lex_state = 5, .external_lex_state = 3},
  [2161] = {.lex_state = 5, .external_lex_state = 3},
  [2162] = {.lex_state = 5, .external_lex_state = 3},
  [2163] = {.lex_state = 5, .external_lex_state = 3},
  [2164] = {.lex_state = 5, .external_lex_state = 3},
  [2165] = {.lex_state = 5, .external_lex_state = 3},
  [2166] = {.lex_state = 6, .external_lex_state = 3},
  [2167] = {.lex_state = 5, .external_lex_state = 3},
  [2168] = {.lex_state = 5, .external_lex_state = 3},
  [2169] = {.lex_state = 5, .external_lex_state = 3},
  [2170] = {.lex_state = 5, .external_lex_state = 3},
  [2171] = {.lex_state = 5, .external_lex_state = 3},
  [2172] = {.lex_state = 5, .external_lex_state = 3},
  [2173] = {.lex_state = 5, .external_lex_state = 2},
  [2174] = {.lex_state = 5, .external_lex_state = 3},
  [2175] = {.lex_state = 5, .external_lex_state = 3},
  [2176] = {.lex_state = 5, .external_lex_state = 3},
  [2177] = {.lex_state = 5, .external_lex_state = 3},
  [2178] = {.lex_state = 6, .external_lex_state = 3},
  [2179] = {.lex_state = 5, .external_lex_state = 3},
  [2180] = {.lex_state = 5, .external_lex_state = 3},
  [2181] = {.lex_state = 5, .external_lex_state = 3},
  [2182] = {.lex_state = 5, .external_lex_state = 3},
  [2183] = {.lex_state = 5, .external_lex_state = 3},
  [2184] = {.lex_state = 5, .external_lex_state = 3},
  [2185] = {.lex_state = 5, .external_lex_state = 3},
  [2186] = {.lex_state = 5, .external_lex_state = 2},
  [2187] = {.lex_state = 5, .external_lex_state = 3},
  [2188] = {.lex_state = 5, .external_lex_state = 3},
  [2189] = {.lex_state = 5, .external_lex_state = 3},
  [2190] = {.lex_state = 5, .external_lex_state = 3},
  [2191] = {.lex_state = 5, .external_lex_state = 3},
  [2192] = {.lex_state = 5, .external_lex_state = 3},
  [2193] = {.lex_state = 5, .external_lex_state = 2},
  [2194] = {.lex_state = 5, .external_lex_state = 2},
  [2195] = {.lex_state = 5, .external_lex_state = 2},
  [2196] = {.lex_state = 5, .external_lex_state = 2},
  [2197] = {.lex_state = 5, .external_lex_state = 2},
  [2198] = {.lex_state = 5, .external_lex_state = 2},
  [2199] = {.lex_state = 5, .external_lex_state = 2},
  [2200] = {.lex_state = 5, .external_lex_state = 2},
  [2201] = {.lex_state = 5, .external_lex_state = 2},
  [2202] = {.lex_state = 5, .external_lex_state = 2},
  [2203] = {.lex_state = 5, .external_lex_state = 2},
  [2204] = {.lex_state = 5, .external_lex_state = 2},
  [2205] = {.lex_state = 5, .external_lex_state = 2},
  [2206] = {.lex_state = 5, .external_lex_state = 2},
  [2207] = {.lex_state = 5, .external_lex_state = 2},
  [2208] = {.lex_state = 5, .external_lex_state = 2},
  [2209] = {.lex_state = 5, .external_lex_state = 2},
  [2210] = {.lex_state = 12},
  [2211] = {.lex_state = 9},
  [2212] = {.lex_state = 5, .external_lex_state = 2},
  [2213] = {.lex_state = 5, .external_lex_state = 2},
  [2214] = {.lex_state = 5, .external_lex_state = 2},
  [2215] = {.lex_state = 9},
  [2216] = {.lex_state = 5, .external_lex_state = 2},
  [2217] = {.lex_state = 5, .external_lex_state = 2},
  [2218] = {.lex_state = 12, .external_lex_state = 4},
  [2219] = {.lex_state = 5, .external_lex_state = 2},
  [2220] = {.lex_state = 12, .external_lex_state = 4},
  [2221] = {.lex_state = 5, .external_lex_state = 2},
  [2222] = {.lex_state = 5, .external_lex_state = 2},
  [2223] = {.lex_state = 9},
  [2224] = {.lex_state = 5, .external_lex_state = 2},
  [2225] = {.lex_state = 5, .external_lex_state = 2},
  [2226] = {.lex_state = 5, .external_lex_state = 2},
  [2227] = {.lex_state = 5, .external_lex_state = 2},
  [2228] = {.lex_state = 5, .external_lex_state = 2},
  [2229] = {.lex_state = 5, .external_lex_state = 2},
  [2230] = {.lex_state = 5, .external_lex_state = 2},
  [2231] = {.lex_state = 5, .external_lex_state = 2},
  [2232] = {.lex_state = 5, .external_lex_state = 2},
  [2233] = {.lex_state = 12, .external_lex_state = 4},
  [2234] = {.lex_state = 5, .external_lex_state = 2},
  [2235] = {.lex_state = 5, .external_lex_state = 2},
  [2236] = {.lex_state = 12, .external_lex_state = 4},
  [2237] = {.lex_state = 5, .external_lex_state = 3},
  [2238] = {.lex_state = 5, .external_lex_state = 2},
  [2239] = {.lex_state = 5, .external_lex_state = 2},
  [2240] = {.lex_state = 9},
  [2241] = {.lex_state = 5, .external_lex_state = 2},
  [2242] = {.lex_state = 5, .external_lex_state = 2},
  [2243] = {.lex_state = 9},
  [2244] = {.lex_state = 9},
  [2245] = {.lex_state = 5, .external_lex_state = 2},
  [2246] = {.lex_state = 5, .external_lex_state = 2},
  [2247] = {.lex_state = 5, .external_lex_state = 2},
  [2248] = {.lex_state = 12, .external_lex_state = 4},
  [2249] = {.lex_state = 5, .external_lex_state = 2},
  [2250] = {.lex_state = 5, .external_lex_state = 2},
  [2251] = {.lex_state = 5, .external_lex_state = 2},
  [2252] = {.lex_state = 12, .external_lex_state = 4},
  [2253] = {.lex_state = 5, .external_lex_state = 2},
  [2254] = {.lex_state = 12, .external_lex_state = 4},
  [2255] = {.lex_state = 5, .external_lex_state = 2},
  [2256] = {.lex_state = 5, .external_lex_state = 2},
  [2257] = {.lex_state = 9},
  [2258] = {.lex_state = 12, .external_lex_state = 4},
  [2259] = {.lex_state = 12, .external_lex_state = 4},
  [2260] = {.lex_state = 5, .external_lex_state = 2},
  [2261] = {.lex_state = 5, .external_lex_state = 3},
  [2262] = {.lex_state = 5, .external_lex_state = 2},
  [2263] = {.lex_state = 12, .external_lex_state = 4},
  [2264] = {.lex_state = 5, .external_lex_state = 2},
  [2265] = {.lex_state = 5, .external_lex_state = 2},
  [2266] = {.lex_state = 5, .external_lex_state = 2},
  [2267] = {.lex_state = 12, .external_lex_state = 4},
  [2268] = {.lex_state = 5, .external_lex_state = 2},
  [2269] = {.lex_state = 5, .external_lex_state = 2},
  [2270] = {.lex_state = 12, .external_lex_state = 4},
  [2271] = {.lex_state = 5, .external_lex_state = 2},
  [2272] = {.lex_state = 12, .external_lex_state = 4},
  [2273] = {.lex_state = 12, .external_lex_state = 4},
  [2274] = {.lex_state = 9},
  [2275] = {.lex_state = 5, .external_lex_state = 2},
  [2276] = {.lex_state = 9},
  [2277] = {.lex_state = 5, .external_lex_state = 2},
  [2278] = {.lex_state = 75},
  [2279] = {.lex_state = 12, .external_lex_state = 4},
  [2280] = {.lex_state = 12, .external_lex_state = 4},
  [2281] = {.lex_state = 5, .external_lex_state = 2},
  [2282] = {.lex_state = 5, .external_lex_state = 2},
  [2283] = {.lex_state = 5, .external_lex_state = 2},
  [2284] = {.lex_state = 12, .external_lex_state = 4},
  [2285] = {.lex_state = 5, .external_lex_state = 2},
  [2286] = {.lex_state = 9},
  [2287] = {.lex_state = 5, .external_lex_state = 2},
  [2288] = {.lex_state = 5, .external_lex_state = 2},
  [2289] = {.lex_state = 5, .external_lex_state = 2},
  [2290] = {.lex_state = 5, .external_lex_state = 2},
  [2291] = {.lex_state = 5, .external_lex_state = 3},
  [2292] = {.lex_state = 5, .external_lex_state = 2},
  [2293] = {.lex_state = 5, .external_lex_state = 2},
  [2294] = {.lex_state = 5, .external_lex_state = 2},
  [2295] = {.lex_state = 5, .external_lex_state = 2},
  [2296] = {.lex_state = 5, .external_lex_state = 2},
  [2297] = {.lex_state = 5, .external_lex_state = 2},
  [2298] = {.lex_state = 5, .external_lex_state = 2},
  [2299] = {.lex_state = 5, .external_lex_state = 2},
  [2300] = {.lex_state = 5, .external_lex_state = 2},
  [2301] = {.lex_state = 5, .external_lex_state = 2},
  [2302] = {.lex_state = 5, .external_lex_state = 2},
  [2303] = {.lex_state = 5, .external_lex_state = 2},
  [2304] = {.lex_state = 5, .external_lex_state = 2},
  [2305] = {.lex_state = 5, .external_lex_state = 2},
  [2306] = {.lex_state = 5, .external_lex_state = 2},
  [2307] = {.lex_state = 75, .external_lex_state = 4},
  [2308] = {.lex_state = 12, .external_lex_state = 4},
  [2309] = {.lex_state = 5, .external_lex_state = 2},
  [2310] = {.lex_state = 5, .external_lex_state = 2},
  [2311] = {.lex_state = 5, .external_lex_state = 2},
  [2312] = {.lex_state = 12, .external_lex_state = 4},
  [2313] = {.lex_state = 5, .external_lex_state = 2},
  [2314] = {.lex_state = 12, .external_lex_state = 4},
  [2315] = {.lex_state = 5, .external_lex_state = 2},
  [2316] = {.lex_state = 5, .external_lex_state = 2},
  [2317] = {.lex_state = 5, .external_lex_state = 2},
  [2318] = {.lex_state = 5, .external_lex_state = 2},
  [2319] = {.lex_state = 5, .external_lex_state = 2},
  [2320] = {.lex_state = 5, .external_lex_state = 2},
  [2321] = {.lex_state = 5, .external_lex_state = 2},
  [2322] = {.lex_state = 5, .external_lex_state = 2},
  [2323] = {.lex_state = 5, .external_lex_state = 2},
  [2324] = {.lex_state = 6, .external_lex_state = 2},
  [2325] = {.lex_state = 5, .external_lex_state = 2},
  [2326] = {.lex_state = 5, .external_lex_state = 2},
  [2327] = {.lex_state = 5, .external_lex_state = 2},
  [2328] = {.lex_state = 5, .external_lex_state = 2},
  [2329] = {.lex_state = 5, .external_lex_state = 2},
  [2330] = {.lex_state = 5, .external_lex_state = 2},
  [2331] = {.lex_state = 12, .external_lex_state = 4},
  [2332] = {.lex_state = 12, .external_lex_state = 4},
  [2333] = {.lex_state = 5, .external_lex_state = 2},
  [2334] = {.lex_state = 5, .external_lex_state = 2},
  [2335] = {.lex_state = 5, .external_lex_state = 2},
  [2336] = {.lex_state = 12, .external_lex_state = 4},
  [2337] = {.lex_state = 5, .external_lex_state = 2},
  [2338] = {.lex_state = 5, .external_lex_state = 2},
  [2339] = {.lex_state = 5, .external_lex_state = 2},
  [2340] = {.lex_state = 75, .external_lex_state = 4},
  [2341] = {.lex_state = 5, .external_lex_state = 2},
  [2342] = {.lex_state = 5, .external_lex_state = 2},
  [2343] = {.lex_state = 5, .external_lex_state = 2},
  [2344] = {.lex_state = 5, .external_lex_state = 2},
  [2345] = {.lex_state = 9},
  [2346] = {.lex_state = 5, .external_lex_state = 2},
  [2347] = {.lex_state = 5, .external_lex_state = 2},
  [2348] = {.lex_state = 9},
  [2349] = {.lex_state = 5, .external_lex_state = 2},
  [2350] = {.lex_state = 5, .external_lex_state = 2},
  [2351] = {.lex_state = 5, .external_lex_state = 3},
  [2352] = {.lex_state = 5, .external_lex_state = 2},
  [2353] = {.lex_state = 5, .external_lex_state = 2},
  [2354] = {.lex_state = 5, .external_lex_state = 2},
  [2355] = {.lex_state = 9},
  [2356] = {.lex_state = 9},
  [2357] = {.lex_state = 9},
  [2358] = {.lex_state = 5, .external_lex_state = 2},
  [2359] = {.lex_state = 9},
  [2360] = {.lex_state = 75},
  [2361] = {.lex_state = 5, .external_lex_state = 2},
  [2362] = {.lex_state = 5, .external_lex_state = 2},
  [2363] = {.lex_state = 75},
  [2364] = {.lex_state = 5, .external_lex_state = 2},
  [2365] = {.lex_state = 5, .external_lex_state = 3},
  [2366] = {.lex_state = 5, .external_lex_state = 2},
  [2367] = {.lex_state = 5, .external_lex_state = 2},
  [2368] = {.lex_state = 5, .external_lex_state = 2},
  [2369] = {.lex_state = 5, .external_lex_state = 2},
  [2370] = {.lex_state = 5, .external_lex_state = 2},
  [2371] = {.lex_state = 9},
  [2372] = {.lex_state = 9},
  [2373] = {.lex_state = 5, .external_lex_state = 2},
  [2374] = {.lex_state = 9},
  [2375] = {.lex_state = 5, .external_lex_state = 2},
  [2376] = {.lex_state = 5, .external_lex_state = 2},
  [2377] = {.lex_state = 75},
  [2378] = {.lex_state = 9},
  [2379] = {.lex_state = 9},
  [2380] = {.lex_state = 5, .external_lex_state = 2},
  [2381] = {.lex_state = 5, .external_lex_state = 2},
  [2382] = {.lex_state = 5, .external_lex_state = 2},
  [2383] = {.lex_state = 9},
  [2384] = {.lex_state = 5, .external_lex_state = 2},
  [2385] = {.lex_state = 9},
  [2386] = {.lex_state = 9},
  [2387] = {.lex_state = 5, .external_lex_state = 2},
  [2388] = {.lex_state = 5, .external_lex_state = 2},
  [2389] = {.lex_state = 5, .external_lex_state = 2},
  [2390] = {.lex_state = 5, .external_lex_state = 2},
  [2391] = {.lex_state = 5, .external_lex_state = 2},
  [2392] = {.lex_state = 9},
  [2393] = {.lex_state = 5, .external_lex_state = 2},
  [2394] = {.lex_state = 9},
  [2395] = {.lex_state = 75},
  [2396] = {.lex_state = 5, .external_lex_state = 2},
  [2397] = {.lex_state = 5, .external_lex_state = 2},
  [2398] = {.lex_state = 5, .external_lex_state = 2},
  [2399] = {.lex_state = 5, .external_lex_state = 2},
  [2400] = {.lex_state = 5, .external_lex_state = 2},
  [2401] = {.lex_state = 5, .external_lex_state = 2},
  [2402] = {.lex_state = 9},
  [2403] = {.lex_state = 5, .external_lex_state = 2},
  [2404] = {.lex_state = 9},
  [2405] = {.lex_state = 5, .external_lex_state = 2},
  [2406] = {.lex_state = 5, .external_lex_state = 2},
  [2407] = {.lex_state = 9},
  [2408] = {.lex_state = 5, .external_lex_state = 3},
  [2409] = {.lex_state = 5, .external_lex_state = 2},
  [2410] = {.lex_state = 5, .external_lex_state = 2},
  [2411] = {.lex_state = 5, .external_lex_state = 2},
  [2412] = {.lex_state = 5, .external_lex_state = 2},
  [2413] = {.lex_state = 9},
  [2414] = {.lex_state = 5, .external_lex_state = 2},
  [2415] = {.lex_state = 5, .external_lex_state = 3},
  [2416] = {.lex_state = 5, .external_lex_state = 2},
  [2417] = {.lex_state = 5, .external_lex_state = 2},
  [2418] = {.lex_state = 75},
  [2419] = {.lex_state = 9},
  [2420] = {.lex_state = 75},
  [2421] = {.lex_state = 75},
  [2422] = {.lex_state = 75},
  [2423] = {.lex_state = 3},
  [2424] = {.lex_state = 75},
  [2425] = {.lex_state = 9},
  [2426] = {.lex_state = 12},
  [2427] = {.lex_state = 75},
  [2428] = {.lex_state = 3},
  [2429] = {.lex_state = 5, .external_lex_state = 2},
  [2430] = {.lex_state = 75},
  [2431] = {.lex_state = 5, .external_lex_state = 2},
  [2432] = {.lex_state = 5, .external_lex_state = 2},
  [2433] = {.lex_state = 5, .external_lex_state = 2},
  [2434] = {.lex_state = 12},
  [2435] = {.lex_state = 75},
  [2436] = {.lex_state = 75},
  [2437] = {.lex_state = 75},
  [2438] = {.lex_state = 75},
  [2439] = {.lex_state = 6, .external_lex_state = 2},
  [2440] = {.lex_state = 5, .external_lex_state = 2},
  [2441] = {.lex_state = 75},
  [2442] = {.lex_state = 75},
  [2443] = {.lex_state = 5, .external_lex_state = 2},
  [2444] = {.lex_state = 75},
  [2445] = {.lex_state = 5, .external_lex_state = 2},
  [2446] = {.lex_state = 75},
  [2447] = {.lex_state = 9},
  [2448] = {.lex_state = 9},
  [2449] = {.lex_state = 12},
  [2450] = {.lex_state = 75},
  [2451] = {.lex_state = 75},
  [2452] = {.lex_state = 12},
  [2453] = {.lex_state = 12},
  [2454] = {.lex_state = 75},
  [2455] = {.lex_state = 12},
  [2456] = {.lex_state = 9},
  [2457] = {.lex_state = 9},
  [2458] = {.lex_state = 9},
  [2459] = {.lex_state = 75},
  [2460] = {.lex_state = 9},
  [2461] = {.lex_state = 9},
  [2462] = {.lex_state = 9},
  [2463] = {.lex_state = 9},
  [2464] = {.lex_state = 75},
  [2465] = {.lex_state = 9},
  [2466] = {.lex_state = 9},
  [2467] = {.lex_state = 9},
  [2468] = {.lex_state = 9},
  [2469] = {.lex_state = 75, .external_lex_state = 4},
  [2470] = {.lex_state = 75},
  [2471] = {.lex_state = 75},
  [2472] = {.lex_state = 75, .external_lex_state = 4},
  [2473] = {.lex_state = 9},
  [2474] = {.lex_state = 75},
  [2475] = {.lex_state = 75, .external_lex_state = 4},
  [2476] = {.lex_state = 9},
  [2477] = {.lex_state = 9},
  [2478] = {.lex_state = 75},
  [2479] = {.lex_state = 75},
  [2480] = {.lex_state = 75},
  [2481] = {.lex_state = 9},
  [2482] = {.lex_state = 75, .external_lex_state = 4},
  [2483] = {.lex_state = 9},
  [2484] = {.lex_state = 75},
  [2485] = {.lex_state = 75},
  [2486] = {.lex_state = 75},
  [2487] = {.lex_state = 75},
  [2488] = {.lex_state = 75},
  [2489] = {.lex_state = 75},
  [2490] = {.lex_state = 75, .external_lex_state = 4},
  [2491] = {.lex_state = 75},
  [2492] = {.lex_state = 75, .external_lex_state = 4},
  [2493] = {.lex_state = 75},
  [2494] = {.lex_state = 75},
  [2495] = {.lex_state = 75},
  [2496] = {.lex_state = 75},
  [2497] = {.lex_state = 75},
  [2498] = {.lex_state = 75},
  [2499] = {.lex_state = 75},
  [2500] = {.lex_state = 75},
  [2501] = {.lex_state = 75},
  [2502] = {.lex_state = 75},
  [2503] = {.lex_state = 75},
  [2504] = {.lex_state = 75},
  [2505] = {.lex_state = 75},
  [2506] = {.lex_state = 75},
  [2507] = {.lex_state = 75},
  [2508] = {.lex_state = 75},
  [2509] = {.lex_state = 75},
  [2510] = {.lex_state = 75, .external_lex_state = 4},
  [2511] = {.lex_state = 75, .external_lex_state = 4},
  [2512] = {.lex_state = 75},
  [2513] = {.lex_state = 75},
  [2514] = {.lex_state = 75, .external_lex_state = 4},
  [2515] = {.lex_state = 75},
  [2516] = {.lex_state = 75},
  [2517] = {.lex_state = 75},
  [2518] = {.lex_state = 75},
  [2519] = {.lex_state = 75, .external_lex_state = 4},
  [2520] = {.lex_state = 75},
  [2521] = {.lex_state = 75, .external_lex_state = 4},
  [2522] = {.lex_state = 75, .external_lex_state = 4},
  [2523] = {.lex_state = 75},
  [2524] = {.lex_state = 75},
  [2525] = {.lex_state = 75},
  [2526] = {.lex_state = 9},
  [2527] = {.lex_state = 75},
  [2528] = {.lex_state = 75},
  [2529] = {.lex_state = 75},
  [2530] = {.lex_state = 9},
  [2531] = {.lex_state = 75},
  [2532] = {.lex_state = 75},
  [2533] = {.lex_state = 75},
  [2534] = {.lex_state = 75},
  [2535] = {.lex_state = 75, .external_lex_state = 4},
  [2536] = {.lex_state = 75},
  [2537] = {.lex_state = 75},
  [2538] = {.lex_state = 75},
  [2539] = {.lex_state = 75},
  [2540] = {.lex_state = 75},
  [2541] = {.lex_state = 75},
  [2542] = {.lex_state = 75},
  [2543] = {.lex_state = 75},
  [2544] = {.lex_state = 75, .external_lex_state = 4},
  [2545] = {.lex_state = 75},
  [2546] = {.lex_state = 75},
  [2547] = {.lex_state = 75},
  [2548] = {.lex_state = 75},
  [2549] = {.lex_state = 75},
  [2550] = {.lex_state = 75},
  [2551] = {.lex_state = 75},
  [2552] = {.lex_state = 75},
  [2553] = {.lex_state = 75},
  [2554] = {.lex_state = 75},
  [2555] = {.lex_state = 75},
  [2556] = {.lex_state = 75},
  [2557] = {.lex_state = 75},
  [2558] = {.lex_state = 75},
  [2559] = {.lex_state = 75},
  [2560] = {.lex_state = 75},
  [2561] = {.lex_state = 75},
  [2562] = {.lex_state = 75},
  [2563] = {.lex_state = 75},
  [2564] = {.lex_state = 75},
  [2565] = {.lex_state = 75},
  [2566] = {.lex_state = 75},
  [2567] = {.lex_state = 75},
  [2568] = {.lex_state = 75},
  [2569] = {.lex_state = 75},
  [2570] = {.lex_state = 75},
  [2571] = {.lex_state = 75},
  [2572] = {.lex_state = 75},
  [2573] = {.lex_state = 75},
  [2574] = {.lex_state = 75},
  [2575] = {.lex_state = 75},
  [2576] = {.lex_state = 75},
  [2577] = {.lex_state = 75},
  [2578] = {.lex_state = 75},
  [2579] = {.lex_state = 75},
  [2580] = {.lex_state = 75},
  [2581] = {.lex_state = 75},
  [2582] = {.lex_state = 75},
  [2583] = {.lex_state = 75},
  [2584] = {.lex_state = 75},
  [2585] = {.lex_state = 75},
  [2586] = {.lex_state = 75},
  [2587] = {.lex_state = 75},
  [2588] = {.lex_state = 75},
  [2589] = {.lex_state = 75},
  [2590] = {.lex_state = 75},
  [2591] = {.lex_state = 75},
  [2592] = {.lex_state = 75},
  [2593] = {.lex_state = 75},
  [2594] = {.lex_state = 75},
  [2595] = {.lex_state = 75},
  [2596] = {.lex_state = 75},
  [2597] = {.lex_state = 75},
  [2598] = {.lex_state = 75},
  [2599] = {.lex_state = 75},
  [2600] = {.lex_state = 75},
  [2601] = {.lex_state = 75},
  [2602] = {.lex_state = 75},
  [2603] = {.lex_state = 75},
  [2604] = {.lex_state = 75},
  [2605] = {.lex_state = 75},
  [2606] = {.lex_state = 75},
  [2607] = {.lex_state = 75},
  [2608] = {.lex_state = 75},
  [2609] = {.lex_state = 75},
  [2610] = {.lex_state = 75},
  [2611] = {.lex_state = 75},
  [2612] = {.lex_state = 75},
  [2613] = {.lex_state = 75},
  [2614] = {.lex_state = 75},
  [2615] = {.lex_state = 75},
  [2616] = {.lex_state = 75},
  [2617] = {.lex_state = 75},
  [2618] = {.lex_state = 75},
  [2619] = {.lex_state = 75},
  [2620] = {.lex_state = 75},
  [2621] = {.lex_state = 75},
  [2622] = {.lex_state = 75},
  [2623] = {.lex_state = 75},
  [2624] = {.lex_state = 75},
  [2625] = {.lex_state = 75},
  [2626] = {.lex_state = 75},
  [2627] = {.lex_state = 75},
  [2628] = {.lex_state = 75},
  [2629] = {.lex_state = 75},
  [2630] = {.lex_state = 75},
  [2631] = {.lex_state = 75},
  [2632] = {.lex_state = 75},
  [2633] = {.lex_state = 75},
  [2634] = {.lex_state = 75},
  [2635] = {.lex_state = 75},
  [2636] = {.lex_state = 75},
  [2637] = {.lex_state = 75},
  [2638] = {.lex_state = 75},
  [2639] = {.lex_state = 75},
  [2640] = {.lex_state = 75},
  [2641] = {.lex_state = 75},
  [2642] = {.lex_state = 75},
  [2643] = {.lex_state = 75},
  [2644] = {.lex_state = 75},
  [2645] = {.lex_state = 75},
  [2646] = {.lex_state = 75},
  [2647] = {.lex_state = 75},
  [2648] = {.lex_state = 75},
  [2649] = {.lex_state = 75},
  [2650] = {.lex_state = 75},
  [2651] = {.lex_state = 75},
  [2652] = {.lex_state = 75},
  [2653] = {.lex_state = 75},
  [2654] = {.lex_state = 75},
  [2655] = {.lex_state = 75},
  [2656] = {.lex_state = 75},
  [2657] = {.lex_state = 75},
  [2658] = {.lex_state = 75},
  [2659] = {.lex_state = 75},
  [2660] = {.lex_state = 75},
  [2661] = {.lex_state = 75},
  [2662] = {.lex_state = 75},
  [2663] = {.lex_state = 75},
  [2664] = {.lex_state = 75},
  [2665] = {.lex_state = 75},
  [2666] = {.lex_state = 75},
  [2667] = {.lex_state = 75},
  [2668] = {.lex_state = 75},
  [2669] = {.lex_state = 75},
  [2670] = {.lex_state = 75},
  [2671] = {.lex_state = 75},
  [2672] = {.lex_state = 75},
  [2673] = {.lex_state = 75},
  [2674] = {.lex_state = 75},
  [2675] = {.lex_state = 75},
  [2676] = {.lex_state = 75},
  [2677] = {.lex_state = 75},
  [2678] = {.lex_state = 75},
  [2679] = {.lex_state = 75},
  [2680] = {.lex_state = 75},
  [2681] = {.lex_state = 75},
  [2682] = {.lex_state = 75},
  [2683] = {.lex_state = 75},
  [2684] = {.lex_state = 75},
  [2685] = {.lex_state = 75},
  [2686] = {.lex_state = 75},
  [2687] = {.lex_state = 75},
  [2688] = {.lex_state = 75},
  [2689] = {.lex_state = 75},
  [2690] = {.lex_state = 75},
  [2691] = {.lex_state = 75},
  [2692] = {.lex_state = 75},
  [2693] = {.lex_state = 75},
  [2694] = {.lex_state = 75},
  [2695] = {.lex_state = 75},
  [2696] = {.lex_state = 75},
  [2697] = {.lex_state = 75},
  [2698] = {.lex_state = 75},
  [2699] = {.lex_state = 75},
  [2700] = {.lex_state = 75},
  [2701] = {.lex_state = 75},
  [2702] = {.lex_state = 75},
  [2703] = {.lex_state = 75},
  [2704] = {.lex_state = 75},
  [2705] = {.lex_state = 75},
  [2706] = {.lex_state = 75},
  [2707] = {.lex_state = 75},
  [2708] = {.lex_state = 75},
  [2709] = {.lex_state = 75},
  [2710] = {.lex_state = 75},
  [2711] = {.lex_state = 75},
  [2712] = {.lex_state = 75},
  [2713] = {.lex_state = 75},
  [2714] = {.lex_state = 75},
  [2715] = {.lex_state = 75},
  [2716] = {.lex_state = 75},
  [2717] = {.lex_state = 75},
  [2718] = {.lex_state = 75},
  [2719] = {.lex_state = 75},
  [2720] = {.lex_state = 75},
  [2721] = {.lex_state = 75},
  [2722] = {.lex_state = 75},
  [2723] = {.lex_state = 75},
  [2724] = {.lex_state = 75},
  [2725] = {.lex_state = 75},
  [2726] = {.lex_state = 75},
  [2727] = {.lex_state = 75},
  [2728] = {.lex_state = 75},
  [2729] = {.lex_state = 75},
  [2730] = {.lex_state = 75},
  [2731] = {.lex_state = 75},
  [2732] = {.lex_state = 75},
  [2733] = {.lex_state = 75},
  [2734] = {.lex_state = 75},
  [2735] = {.lex_state = 75},
  [2736] = {.lex_state = 75},
  [2737] = {.lex_state = 75},
  [2738] = {.lex_state = 75},
  [2739] = {.lex_state = 75},
  [2740] = {.lex_state = 75},
  [2741] = {.lex_state = 75},
  [2742] = {.lex_state = 75},
  [2743] = {.lex_state = 75},
  [2744] = {.lex_state = 75},
  [2745] = {.lex_state = 75},
  [2746] = {.lex_state = 75},
  [2747] = {.lex_state = 3},
  [2748] = {.lex_state = 75},
  [2749] = {.lex_state = 75},
  [2750] = {.lex_state = 75},
  [2751] = {.lex_state = 75},
  [2752] = {.lex_state = 75},
  [2753] = {.lex_state = 75},
  [2754] = {.lex_state = 75},
  [2755] = {.lex_state = 75, .external_lex_state = 4},
  [2756] = {.lex_state = 75},
  [2757] = {.lex_state = 75},
  [2758] = {.lex_state = 75},
  [2759] = {.lex_state = 75},
  [2760] = {.lex_state = 75},
  [2761] = {.lex_state = 75},
  [2762] = {.lex_state = 3},
  [2763] = {.lex_state = 3},
  [2764] = {.lex_state = 75},
  [2765] = {.lex_state = 75},
  [2766] = {.lex_state = 75},
  [2767] = {.lex_state = 75},
  [2768] = {.lex_state = 18},
  [2769] = {.lex_state = 18},
  [2770] = {.lex_state = 18},
  [2771] = {.lex_state = 18},
  [2772] = {.lex_state = 18},
  [2773] = {.lex_state = 18},
  [2774] = {.lex_state = 18},
  [2775] = {.lex_state = 18},
  [2776] = {.lex_state = 18},
  [2777] = {.lex_state = 18},
  [2778] = {.lex_state = 18},
  [2779] = {.lex_state = 18},
  [2780] = {.lex_state = 18},
  [2781] = {.lex_state = 18},
  [2782] = {.lex_state = 18},
  [2783] = {.lex_state = 18},
  [2784] = {.lex_state = 18},
  [2785] = {.lex_state = 18},
  [2786] = {.lex_state = 18},
  [2787] = {.lex_state = 18},
  [2788] = {.lex_state = 18},
  [2789] = {.lex_state = 18},
  [2790] = {.lex_state = 18},
  [2791] = {.lex_state = 18},
  [2792] = {.lex_state = 18},
  [2793] = {.lex_state = 11, .external_lex_state = 4},
  [2794] = {.lex_state = 18},
  [2795] = {.lex_state = 18},
  [2796] = {.lex_state = 18},
  [2797] = {.lex_state = 18},
  [2798] = {.lex_state = 18},
  [2799] = {.lex_state = 18},
  [2800] = {.lex_state = 18},
  [2801] = {.lex_state = 11},
  [2802] = {.lex_state = 18},
  [2803] = {.lex_state = 18},
  [2804] = {.lex_state = 18},
  [2805] = {.lex_state = 18},
  [2806] = {.lex_state = 11, .external_lex_state = 4},
  [2807] = {.lex_state = 18},
  [2808] = {.lex_state = 18},
  [2809] = {.lex_state = 18},
  [2810] = {.lex_state = 18},
  [2811] = {.lex_state = 18},
  [2812] = {.lex_state = 18},
  [2813] = {.lex_state = 18},
  [2814] = {.lex_state = 18},
  [2815] = {.lex_state = 11},
  [2816] = {.lex_state = 9},
  [2817] = {.lex_state = 9},
  [2818] = {.lex_state = 75},
  [2819] = {.lex_state = 75},
  [2820] = {.lex_state = 9},
  [2821] = {.lex_state = 9},
  [2822] = {.lex_state = 75},
  [2823] = {.lex_state = 9},
  [2824] = {.lex_state = 9},
  [2825] = {.lex_state = 9},
  [2826] = {.lex_state = 9},
  [2827] = {.lex_state = 9},
  [2828] = {.lex_state = 9},
  [2829] = {.lex_state = 9},
  [2830] = {.lex_state = 9},
  [2831] = {.lex_state = 9},
  [2832] = {.lex_state = 9},
  [2833] = {.lex_state = 9},
  [2834] = {.lex_state = 9},
  [2835] = {.lex_state = 9},
  [2836] = {.lex_state = 9},
  [2837] = {.lex_state = 9},
  [2838] = {.lex_state = 75},
  [2839] = {.lex_state = 9},
  [2840] = {.lex_state = 9},
  [2841] = {.lex_state = 9},
  [2842] = {.lex_state = 9},
  [2843] = {.lex_state = 9},
  [2844] = {.lex_state = 9},
  [2845] = {.lex_state = 9},
  [2846] = {.lex_state = 9},
  [2847] = {.lex_state = 9},
  [2848] = {.lex_state = 75},
  [2849] = {.lex_state = 75},
  [2850] = {.lex_state = 75},
  [2851] = {.lex_state = 18, .external_lex_state = 4},
  [2852] = {.lex_state = 18, .external_lex_state = 4},
  [2853] = {.lex_state = 9},
  [2854] = {.lex_state = 9},
  [2855] = {.lex_state = 18, .external_lex_state = 4},
  [2856] = {.lex_state = 9},
  [2857] = {.lex_state = 75},
  [2858] = {.lex_state = 9},
  [2859] = {.lex_state = 75},
  [2860] = {.lex_state = 11, .external_lex_state = 4},
  [2861] = {.lex_state = 18, .external_lex_state = 4},
  [2862] = {.lex_state = 75},
  [2863] = {.lex_state = 75},
  [2864] = {.lex_state = 75},
  [2865] = {.lex_state = 75},
  [2866] = {.lex_state = 75},
  [2867] = {.lex_state = 75},
  [2868] = {.lex_state = 11, .external_lex_state = 4},
  [2869] = {.lex_state = 75},
  [2870] = {.lex_state = 75},
  [2871] = {.lex_state = 9},
  [2872] = {.lex_state = 9, .external_lex_state = 4},
  [2873] = {.lex_state = 75},
  [2874] = {.lex_state = 18, .external_lex_state = 4},
  [2875] = {.lex_state = 75},
  [2876] = {.lex_state = 9, .external_lex_state = 4},
  [2877] = {.lex_state = 9},
  [2878] = {.lex_state = 75},
  [2879] = {.lex_state = 75},
  [2880] = {.lex_state = 75},
  [2881] = {.lex_state = 18, .external_lex_state = 4},
  [2882] = {.lex_state = 18, .external_lex_state = 4},
  [2883] = {.lex_state = 75},
  [2884] = {.lex_state = 75},
  [2885] = {.lex_state = 75},
  [2886] = {.lex_state = 18, .external_lex_state = 4},
  [2887] = {.lex_state = 75},
  [2888] = {.lex_state = 18, .external_lex_state = 4},
  [2889] = {.lex_state = 75},
  [2890] = {.lex_state = 75},
  [2891] = {.lex_state = 75},
  [2892] = {.lex_state = 18, .external_lex_state = 4},
  [2893] = {.lex_state = 18, .external_lex_state = 4},
  [2894] = {.lex_state = 75},
  [2895] = {.lex_state = 18, .external_lex_state = 4},
  [2896] = {.lex_state = 18, .external_lex_state = 4},
  [2897] = {.lex_state = 18, .external_lex_state = 4},
  [2898] = {.lex_state = 18, .external_lex_state = 4},
  [2899] = {.lex_state = 18, .external_lex_state = 4},
  [2900] = {.lex_state = 18, .external_lex_state = 4},
  [2901] = {.lex_state = 18, .external_lex_state = 4},
  [2902] = {.lex_state = 9},
  [2903] = {.lex_state = 9, .external_lex_state = 4},
  [2904] = {.lex_state = 9},
  [2905] = {.lex_state = 9},
  [2906] = {.lex_state = 9, .external_lex_state = 4},
  [2907] = {.lex_state = 18, .external_lex_state = 4},
  [2908] = {.lex_state = 75},
  [2909] = {.lex_state = 18, .external_lex_state = 4},
  [2910] = {.lex_state = 18, .external_lex_state = 4},
  [2911] = {.lex_state = 18, .external_lex_state = 4},
  [2912] = {.lex_state = 18, .external_lex_state = 4},
  [2913] = {.lex_state = 18, .external_lex_state = 4},
  [2914] = {.lex_state = 18, .external_lex_state = 4},
  [2915] = {.lex_state = 18, .external_lex_state = 4},
  [2916] = {.lex_state = 18, .external_lex_state = 4},
  [2917] = {.lex_state = 18, .external_lex_state = 4},
  [2918] = {.lex_state = 18, .external_lex_state = 4},
  [2919] = {.lex_state = 18, .external_lex_state = 4},
  [2920] = {.lex_state = 18, .external_lex_state = 4},
  [2921] = {.lex_state = 18, .external_lex_state = 4},
  [2922] = {.lex_state = 75},
  [2923] = {.lex_state = 18, .external_lex_state = 4},
  [2924] = {.lex_state = 18, .external_lex_state = 4},
  [2925] = {.lex_state = 9, .external_lex_state = 4},
  [2926] = {.lex_state = 75},
  [2927] = {.lex_state = 9, .external_lex_state = 4},
  [2928] = {.lex_state = 75},
  [2929] = {.lex_state = 75},
  [2930] = {.lex_state = 9},
  [2931] = {.lex_state = 75},
  [2932] = {.lex_state = 75},
  [2933] = {.lex_state = 9},
  [2934] = {.lex_state = 75},
  [2935] = {.lex_state = 18, .external_lex_state = 4},
  [2936] = {.lex_state = 75},
  [2937] = {.lex_state = 75},
  [2938] = {.lex_state = 75},
  [2939] = {.lex_state = 9, .external_lex_state = 4},
  [2940] = {.lex_state = 75},
  [2941] = {.lex_state = 18, .external_lex_state = 4},
  [2942] = {.lex_state = 18, .external_lex_state = 4},
  [2943] = {.lex_state = 75},
  [2944] = {.lex_state = 75},
  [2945] = {.lex_state = 75},
  [2946] = {.lex_state = 75},
  [2947] = {.lex_state = 75},
  [2948] = {.lex_state = 75},
  [2949] = {.lex_state = 75},
  [2950] = {.lex_state = 11, .external_lex_state = 5},
  [2951] = {.lex_state = 18, .external_lex_state = 4},
  [2952] = {.lex_state = 18, .external_lex_state = 4},
  [2953] = {.lex_state = 9, .external_lex_state = 4},
  [2954] = {.lex_state = 11},
  [2955] = {.lex_state = 9, .external_lex_state = 4},
  [2956] = {.lex_state = 9, .external_lex_state = 4},
  [2957] = {.lex_state = 18, .external_lex_state = 5},
  [2958] = {.lex_state = 18, .external_lex_state = 4},
  [2959] = {.lex_state = 9, .external_lex_state = 4},
  [2960] = {.lex_state = 9, .external_lex_state = 4},
  [2961] = {.lex_state = 18, .external_lex_state = 4},
  [2962] = {.lex_state = 18, .external_lex_state = 5},
  [2963] = {.lex_state = 18, .external_lex_state = 5},
  [2964] = {.lex_state = 9, .external_lex_state = 4},
  [2965] = {.lex_state = 9, .external_lex_state = 4},
  [2966] = {.lex_state = 9, .external_lex_state = 4},
  [2967] = {.lex_state = 18, .external_lex_state = 4},
  [2968] = {.lex_state = 9, .external_lex_state = 4},
  [2969] = {.lex_state = 9, .external_lex_state = 4},
  [2970] = {.lex_state = 18, .external_lex_state = 4},
  [2971] = {.lex_state = 9, .external_lex_state = 4},
  [2972] = {.lex_state = 18, .external_lex_state = 4},
  [2973] = {.lex_state = 11, .external_lex_state = 4},
  [2974] = {.lex_state = 9, .external_lex_state = 4},
  [2975] = {.lex_state = 18, .external_lex_state = 5},
  [2976] = {.lex_state = 18, .external_lex_state = 5},
  [2977] = {.lex_state = 18, .external_lex_state = 5},
  [2978] = {.lex_state = 18, .external_lex_state = 5},
  [2979] = {.lex_state = 18, .external_lex_state = 5},
  [2980] = {.lex_state = 9, .external_lex_state = 4},
  [2981] = {.lex_state = 9, .external_lex_state = 4},
  [2982] = {.lex_state = 9, .external_lex_state = 4},
  [2983] = {.lex_state = 9, .external_lex_state = 4},
  [2984] = {.lex_state = 18, .external_lex_state = 5},
  [2985] = {.lex_state = 11},
  [2986] = {.lex_state = 9, .external_lex_state = 4},
  [2987] = {.lex_state = 18, .external_lex_state = 5},
  [2988] = {.lex_state = 18, .external_lex_state = 5},
  [2989] = {.lex_state = 9, .external_lex_state = 4},
  [2990] = {.lex_state = 9, .external_lex_state = 4},
  [2991] = {.lex_state = 9, .external_lex_state = 4},
  [2992] = {.lex_state = 18, .external_lex_state = 5},
  [2993] = {.lex_state = 18, .external_lex_state = 5},
  [2994] = {.lex_state = 9, .external_lex_state = 4},
  [2995] = {.lex_state = 18, .external_lex_state = 5},
  [2996] = {.lex_state = 9, .external_lex_state = 4},
  [2997] = {.lex_state = 18, .external_lex_state = 5},
  [2998] = {.lex_state = 9, .external_lex_state = 4},
  [2999] = {.lex_state = 9, .external_lex_state = 4},
  [3000] = {.lex_state = 9, .external_lex_state = 4},
  [3001] = {.lex_state = 9, .external_lex_state = 4},
  [3002] = {.lex_state = 18, .external_lex_state = 5},
  [3003] = {.lex_state = 18, .external_lex_state = 5},
  [3004] = {.lex_state = 18, .external_lex_state = 5},
  [3005] = {.lex_state = 18, .external_lex_state = 5},
  [3006] = {.lex_state = 18, .external_lex_state = 5},
  [3007] = {.lex_state = 18, .external_lex_state = 5},
  [3008] = {.lex_state = 18, .external_lex_state = 5},
  [3009] = {.lex_state = 18, .external_lex_state = 5},
  [3010] = {.lex_state = 9, .external_lex_state = 4},
  [3011] = {.lex_state = 9, .external_lex_state = 4},
  [3012] = {.lex_state = 18, .external_lex_state = 5},
  [3013] = {.lex_state = 18, .external_lex_state = 5},
  [3014] = {.lex_state = 18, .external_lex_state = 5},
  [3015] = {.lex_state = 18, .external_lex_state = 5},
  [3016] = {.lex_state = 18, .external_lex_state = 5},
  [3017] = {.lex_state = 18, .external_lex_state = 5},
  [3018] = {.lex_state = 18, .external_lex_state = 5},
  [3019] = {.lex_state = 18, .external_lex_state = 5},
  [3020] = {.lex_state = 18, .external_lex_state = 5},
  [3021] = {.lex_state = 18, .external_lex_state = 5},
  [3022] = {.lex_state = 18, .external_lex_state = 5},
  [3023] = {.lex_state = 18, .external_lex_state = 5},
  [3024] = {.lex_state = 9, .external_lex_state = 4},
  [3025] = {.lex_state = 9, .external_lex_state = 4},
  [3026] = {.lex_state = 18, .external_lex_state = 5},
  [3027] = {.lex_state = 18, .external_lex_state = 5},
  [3028] = {.lex_state = 9, .external_lex_state = 4},
  [3029] = {.lex_state = 9, .external_lex_state = 4},
  [3030] = {.lex_state = 11, .external_lex_state = 5},
  [3031] = {.lex_state = 9, .external_lex_state = 4},
  [3032] = {.lex_state = 9, .external_lex_state = 4},
  [3033] = {.lex_state = 9, .external_lex_state = 4},
  [3034] = {.lex_state = 9, .external_lex_state = 4},
  [3035] = {.lex_state = 9, .external_lex_state = 5},
  [3036] = {.lex_state = 9, .external_lex_state = 4},
  [3037] = {.lex_state = 9, .external_lex_state = 4},
  [3038] = {.lex_state = 9, .external_lex_state = 4},
  [3039] = {.lex_state = 11, .external_lex_state = 5},
  [3040] = {.lex_state = 9, .external_lex_state = 4},
  [3041] = {.lex_state = 9, .external_lex_state = 4},
  [3042] = {.lex_state = 9, .external_lex_state = 4},
  [3043] = {.lex_state = 9, .external_lex_state = 4},
  [3044] = {.lex_state = 18, .external_lex_state = 5},
  [3045] = {.lex_state = 9, .external_lex_state = 4},
  [3046] = {.lex_state = 9, .external_lex_state = 4},
  [3047] = {.lex_state = 9, .external_lex_state = 4},
  [3048] = {.lex_state = 9, .external_lex_state = 4},
  [3049] = {.lex_state = 9, .external_lex_state = 4},
  [3050] = {.lex_state = 9, .external_lex_state = 4},
  [3051] = {.lex_state = 9, .external_lex_state = 4},
  [3052] = {.lex_state = 9, .external_lex_state = 4},
  [3053] = {.lex_state = 9, .external_lex_state = 4},
  [3054] = {.lex_state = 9, .external_lex_state = 4},
  [3055] = {.lex_state = 18, .external_lex_state = 5},
  [3056] = {.lex_state = 9, .external_lex_state = 4},
  [3057] = {.lex_state = 9, .external_lex_state = 4},
  [3058] = {.lex_state = 9, .external_lex_state = 4},
  [3059] = {.lex_state = 9, .external_lex_state = 4},
  [3060] = {.lex_state = 9, .external_lex_state = 4},
  [3061] = {.lex_state = 9, .external_lex_state = 4},
  [3062] = {.lex_state = 9, .external_lex_state = 4},
  [3063] = {.lex_state = 18, .external_lex_state = 5},
  [3064] = {.lex_state = 9, .external_lex_state = 4},
  [3065] = {.lex_state = 9, .external_lex_state = 4},
  [3066] = {.lex_state = 9, .external_lex_state = 4},
  [3067] = {.lex_state = 9, .external_lex_state = 4},
  [3068] = {.lex_state = 9, .external_lex_state = 4},
  [3069] = {.lex_state = 9, .external_lex_state = 4},
  [3070] = {.lex_state = 9, .external_lex_state = 4},
  [3071] = {.lex_state = 9, .external_lex_state = 4},
  [3072] = {.lex_state = 18, .external_lex_state = 5},
  [3073] = {.lex_state = 18, .external_lex_state = 5},
  [3074] = {.lex_state = 18, .external_lex_state = 5},
  [3075] = {.lex_state = 9, .external_lex_state = 4},
  [3076] = {.lex_state = 18, .external_lex_state = 5},
  [3077] = {.lex_state = 9, .external_lex_state = 4},
  [3078] = {.lex_state = 9, .external_lex_state = 4},
  [3079] = {.lex_state = 9, .external_lex_state = 4},
  [3080] = {.lex_state = 9, .external_lex_state = 4},
  [3081] = {.lex_state = 9, .external_lex_state = 4},
  [3082] = {.lex_state = 9, .external_lex_state = 4},
  [3083] = {.lex_state = 9, .external_lex_state = 4},
  [3084] = {.lex_state = 9, .external_lex_state = 4},
  [3085] = {.lex_state = 9, .external_lex_state = 4},
  [3086] = {.lex_state = 9, .external_lex_state = 4},
  [3087] = {.lex_state = 9, .external_lex_state = 4},
  [3088] = {.lex_state = 9, .external_lex_state = 4},
  [3089] = {.lex_state = 9, .external_lex_state = 4},
  [3090] = {.lex_state = 19},
  [3091] = {.lex_state = 9},
  [3092] = {.lex_state = 9},
  [3093] = {.lex_state = 9},
  [3094] = {.lex_state = 9},
  [3095] = {.lex_state = 3},
  [3096] = {.lex_state = 9},
  [3097] = {.lex_state = 9, .external_lex_state = 4},
  [3098] = {.lex_state = 9, .external_lex_state = 4},
  [3099] = {.lex_state = 9, .external_lex_state = 4},
  [3100] = {.lex_state = 11},
  [3101] = {.lex_state = 9},
  [3102] = {.lex_state = 9},
  [3103] = {.lex_state = 9},
  [3104] = {.lex_state = 9, .external_lex_state = 4},
  [3105] = {.lex_state = 9, .external_lex_state = 5},
  [3106] = {.lex_state = 9, .external_lex_state = 4},
  [3107] = {.lex_state = 9},
  [3108] = {.lex_state = 9},
  [3109] = {.lex_state = 9},
  [3110] = {.lex_state = 9},
  [3111] = {.lex_state = 9, .external_lex_state = 4},
  [3112] = {.lex_state = 9},
  [3113] = {.lex_state = 9},
  [3114] = {.lex_state = 9},
  [3115] = {.lex_state = 9, .external_lex_state = 4},
  [3116] = {.lex_state = 9},
  [3117] = {.lex_state = 9, .external_lex_state = 5},
  [3118] = {.lex_state = 9, .external_lex_state = 5},
  [3119] = {.lex_state = 10},
  [3120] = {.lex_state = 10},
  [3121] = {.lex_state = 9, .external_lex_state = 5},
  [3122] = {.lex_state = 9, .external_lex_state = 5},
  [3123] = {.lex_state = 9, .external_lex_state = 5},
  [3124] = {.lex_state = 9, .external_lex_state = 5},
  [3125] = {.lex_state = 9, .external_lex_state = 5},
  [3126] = {.lex_state = 9, .external_lex_state = 5},
  [3127] = {.lex_state = 9, .external_lex_state = 5},
  [3128] = {.lex_state = 9, .external_lex_state = 5},
  [3129] = {.lex_state = 9, .external_lex_state = 5},
  [3130] = {.lex_state = 9, .external_lex_state = 5},
  [3131] = {.lex_state = 9, .external_lex_state = 5},
  [3132] = {.lex_state = 9, .external_lex_state = 5},
  [3133] = {.lex_state = 9, .external_lex_state = 5},
  [3134] = {.lex_state = 9, .external_lex_state = 5},
  [3135] = {.lex_state = 9, .external_lex_state = 5},
  [3136] = {.lex_state = 9, .external_lex_state = 5},
  [3137] = {.lex_state = 9, .external_lex_state = 5},
  [3138] = {.lex_state = 9, .external_lex_state = 5},
  [3139] = {.lex_state = 9, .external_lex_state = 5},
  [3140] = {.lex_state = 9, .external_lex_state = 5},
  [3141] = {.lex_state = 9, .external_lex_state = 5},
  [3142] = {.lex_state = 9, .external_lex_state = 5},
  [3143] = {.lex_state = 9, .external_lex_state = 5},
  [3144] = {.lex_state = 9, .external_lex_state = 5},
  [3145] = {.lex_state = 9, .external_lex_state = 5},
  [3146] = {.lex_state = 9, .external_lex_state = 5},
  [3147] = {.lex_state = 9, .external_lex_state = 5},
  [3148] = {.lex_state = 9, .external_lex_state = 5},
  [3149] = {.lex_state = 9, .external_lex_state = 5},
  [3150] = {.lex_state = 9},
  [3151] = {.lex_state = 9, .external_lex_state = 5},
  [3152] = {.lex_state = 9},
  [3153] = {.lex_state = 9},
  [3154] = {.lex_state = 9},
  [3155] = {.lex_state = 9},
  [3156] = {.lex_state = 9},
  [3157] = {.lex_state = 3},
  [3158] = {.lex_state = 9, .external_lex_state = 5},
  [3159] = {.lex_state = 9},
  [3160] = {.lex_state = 9},
  [3161] = {.lex_state = 9, .external_lex_state = 5},
  [3162] = {.lex_state = 9},
  [3163] = {.lex_state = 9, .external_lex_state = 5},
  [3164] = {.lex_state = 9},
  [3165] = {.lex_state = 9},
  [3166] = {.lex_state = 9, .external_lex_state = 5},
  [3167] = {.lex_state = 9},
  [3168] = {.lex_state = 9, .external_lex_state = 4},
  [3169] = {.lex_state = 9},
  [3170] = {.lex_state = 9},
  [3171] = {.lex_state = 9, .external_lex_state = 5},
  [3172] = {.lex_state = 9},
  [3173] = {.lex_state = 9},
  [3174] = {.lex_state = 9},
  [3175] = {.lex_state = 9},
  [3176] = {.lex_state = 75, .external_lex_state = 4},
  [3177] = {.lex_state = 9, .external_lex_state = 5},
  [3178] = {.lex_state = 9, .external_lex_state = 5},
  [3179] = {.lex_state = 75, .external_lex_state = 4},
  [3180] = {.lex_state = 9},
  [3181] = {.lex_state = 9},
  [3182] = {.lex_state = 9, .external_lex_state = 5},
  [3183] = {.lex_state = 9},
  [3184] = {.lex_state = 9},
  [3185] = {.lex_state = 9},
  [3186] = {.lex_state = 9, .external_lex_state = 5},
  [3187] = {.lex_state = 9, .external_lex_state = 5},
  [3188] = {.lex_state = 9, .external_lex_state = 4},
  [3189] = {.lex_state = 9},
  [3190] = {.lex_state = 9},
  [3191] = {.lex_state = 9, .external_lex_state = 5},
  [3192] = {.lex_state = 9},
  [3193] = {.lex_state = 9},
  [3194] = {.lex_state = 9},
  [3195] = {.lex_state = 9},
  [3196] = {.lex_state = 9, .external_lex_state = 5},
  [3197] = {.lex_state = 9, .external_lex_state = 5},
  [3198] = {.lex_state = 9, .external_lex_state = 5},
  [3199] = {.lex_state = 9},
  [3200] = {.lex_state = 3, .external_lex_state = 4},
  [3201] = {.lex_state = 9},
  [3202] = {.lex_state = 9, .external_lex_state = 5},
  [3203] = {.lex_state = 9, .external_lex_state = 5},
  [3204] = {.lex_state = 9, .external_lex_state = 4},
  [3205] = {.lex_state = 11},
  [3206] = {.lex_state = 9, .external_lex_state = 4},
  [3207] = {.lex_state = 9},
  [3208] = {.lex_state = 9},
  [3209] = {.lex_state = 10},
  [3210] = {.lex_state = 9},
  [3211] = {.lex_state = 9},
  [3212] = {.lex_state = 9},
  [3213] = {.lex_state = 9},
  [3214] = {.lex_state = 9, .external_lex_state = 5},
  [3215] = {.lex_state = 16, .external_lex_state = 6},
  [3216] = {.lex_state = 9, .external_lex_state = 4},
  [3217] = {.lex_state = 16, .external_lex_state = 6},
  [3218] = {.lex_state = 3, .external_lex_state = 4},
  [3219] = {.lex_state = 9, .external_lex_state = 4},
  [3220] = {.lex_state = 16, .external_lex_state = 6},
  [3221] = {.lex_state = 9},
  [3222] = {.lex_state = 16, .external_lex_state = 6},
  [3223] = {.lex_state = 9},
  [3224] = {.lex_state = 16, .external_lex_state = 6},
  [3225] = {.lex_state = 9, .external_lex_state = 4},
  [3226] = {.lex_state = 16, .external_lex_state = 6},
  [3227] = {.lex_state = 16, .external_lex_state = 6},
  [3228] = {.lex_state = 9},
  [3229] = {.lex_state = 9},
  [3230] = {.lex_state = 9, .external_lex_state = 5},
  [3231] = {.lex_state = 16, .external_lex_state = 6},
  [3232] = {.lex_state = 9},
  [3233] = {.lex_state = 9, .external_lex_state = 4},
  [3234] = {.lex_state = 9},
  [3235] = {.lex_state = 9},
  [3236] = {.lex_state = 9},
  [3237] = {.lex_state = 9},
  [3238] = {.lex_state = 9},
  [3239] = {.lex_state = 9},
  [3240] = {.lex_state = 9},
  [3241] = {.lex_state = 9},
  [3242] = {.lex_state = 10},
  [3243] = {.lex_state = 3},
  [3244] = {.lex_state = 9},
  [3245] = {.lex_state = 9},
  [3246] = {.lex_state = 9},
  [3247] = {.lex_state = 75, .external_lex_state = 4},
  [3248] = {.lex_state = 0, .external_lex_state = 4},
  [3249] = {.lex_state = 9, .external_lex_state = 4},
  [3250] = {.lex_state = 9},
  [3251] = {.lex_state = 9},
  [3252] = {.lex_state = 75, .external_lex_state = 4},
  [3253] = {.lex_state = 9},
  [3254] = {.lex_state = 9, .external_lex_state = 4},
  [3255] = {.lex_state = 9, .external_lex_state = 4},
  [3256] = {.lex_state = 9},
  [3257] = {.lex_state = 75, .external_lex_state = 4},
  [3258] = {.lex_state = 9},
  [3259] = {.lex_state = 9, .external_lex_state = 4},
  [3260] = {.lex_state = 75, .external_lex_state = 4},
  [3261] = {.lex_state = 75, .external_lex_state = 4},
  [3262] = {.lex_state = 9},
  [3263] = {.lex_state = 75, .external_lex_state = 4},
  [3264] = {.lex_state = 9},
  [3265] = {.lex_state = 3},
  [3266] = {.lex_state = 0, .external_lex_state = 4},
  [3267] = {.lex_state = 9},
  [3268] = {.lex_state = 9},
  [3269] = {.lex_state = 9},
  [3270] = {.lex_state = 9},
  [3271] = {.lex_state = 0, .external_lex_state = 4},
  [3272] = {.lex_state = 0, .external_lex_state = 4},
  [3273] = {.lex_state = 9, .external_lex_state = 4},
  [3274] = {.lex_state = 9},
  [3275] = {.lex_state = 9, .external_lex_state = 4},
  [3276] = {.lex_state = 9, .external_lex_state = 4},
  [3277] = {.lex_state = 9, .external_lex_state = 4},
  [3278] = {.lex_state = 9},
  [3279] = {.lex_state = 9, .external_lex_state = 4},
  [3280] = {.lex_state = 9, .external_lex_state = 4},
  [3281] = {.lex_state = 9, .external_lex_state = 4},
  [3282] = {.lex_state = 9, .external_lex_state = 4},
  [3283] = {.lex_state = 9},
  [3284] = {.lex_state = 9, .external_lex_state = 4},
  [3285] = {.lex_state = 9},
  [3286] = {.lex_state = 9},
  [3287] = {.lex_state = 9},
  [3288] = {.lex_state = 9},
  [3289] = {.lex_state = 9},
  [3290] = {.lex_state = 9},
  [3291] = {.lex_state = 9},
  [3292] = {.lex_state = 9, .external_lex_state = 4},
  [3293] = {.lex_state = 9, .external_lex_state = 4},
  [3294] = {.lex_state = 9},
  [3295] = {.lex_state = 9},
  [3296] = {.lex_state = 19},
  [3297] = {.lex_state = 9},
  [3298] = {.lex_state = 9},
  [3299] = {.lex_state = 9, .external_lex_state = 4},
  [3300] = {.lex_state = 9, .external_lex_state = 4},
  [3301] = {.lex_state = 9, .external_lex_state = 4},
  [3302] = {.lex_state = 9, .external_lex_state = 4},
  [3303] = {.lex_state = 3},
  [3304] = {.lex_state = 9},
  [3305] = {.lex_state = 9},
  [3306] = {.lex_state = 9},
  [3307] = {.lex_state = 0, .external_lex_state = 4},
  [3308] = {.lex_state = 9},
  [3309] = {.lex_state = 9},
  [3310] = {.lex_state = 9},
  [3311] = {.lex_state = 9},
  [3312] = {.lex_state = 9, .external_lex_state = 4},
  [3313] = {.lex_state = 0, .external_lex_state = 4},
  [3314] = {.lex_state = 9, .external_lex_state = 4},
  [3315] = {.lex_state = 9, .external_lex_state = 4},
  [3316] = {.lex_state = 9, .external_lex_state = 4},
  [3317] = {.lex_state = 9},
  [3318] = {.lex_state = 9},
  [3319] = {.lex_state = 9},
  [3320] = {.lex_state = 9},
  [3321] = {.lex_state = 9},
  [3322] = {.lex_state = 9, .external_lex_state = 4},
  [3323] = {.lex_state = 9, .external_lex_state = 4},
  [3324] = {.lex_state = 9, .external_lex_state = 4},
  [3325] = {.lex_state = 9},
  [3326] = {.lex_state = 0, .external_lex_state = 4},
  [3327] = {.lex_state = 9},
  [3328] = {.lex_state = 0, .external_lex_state = 4},
  [3329] = {.lex_state = 9},
  [3330] = {.lex_state = 10},
  [3331] = {.lex_state = 3},
  [3332] = {.lex_state = 9, .external_lex_state = 4},
  [3333] = {.lex_state = 9},
  [3334] = {.lex_state = 9},
  [3335] = {.lex_state = 10},
  [3336] = {.lex_state = 0, .external_lex_state = 4},
  [3337] = {.lex_state = 3},
  [3338] = {.lex_state = 9},
  [3339] = {.lex_state = 9},
  [3340] = {.lex_state = 9},
  [3341] = {.lex_state = 9},
  [3342] = {.lex_state = 9},
  [3343] = {.lex_state = 9},
  [3344] = {.lex_state = 9},
  [3345] = {.lex_state = 9},
  [3346] = {.lex_state = 9},
  [3347] = {.lex_state = 0, .external_lex_state = 4},
  [3348] = {.lex_state = 9},
  [3349] = {.lex_state = 9},
  [3350] = {.lex_state = 0, .external_lex_state = 4},
  [3351] = {.lex_state = 75, .external_lex_state = 4},
  [3352] = {.lex_state = 9},
  [3353] = {.lex_state = 75, .external_lex_state = 4},
  [3354] = {.lex_state = 0, .external_lex_state = 4},
  [3355] = {.lex_state = 0, .external_lex_state = 4},
  [3356] = {.lex_state = 19},
  [3357] = {.lex_state = 19},
  [3358] = {.lex_state = 19},
  [3359] = {.lex_state = 19},
  [3360] = {.lex_state = 75},
  [3361] = {.lex_state = 9},
  [3362] = {.lex_state = 9},
  [3363] = {.lex_state = 0, .external_lex_state = 4},
  [3364] = {.lex_state = 0, .external_lex_state = 4},
  [3365] = {.lex_state = 0, .external_lex_state = 4},
  [3366] = {.lex_state = 0, .external_lex_state = 4},
  [3367] = {.lex_state = 9},
  [3368] = {.lex_state = 9, .external_lex_state = 5},
  [3369] = {.lex_state = 9, .external_lex_state = 5},
  [3370] = {.lex_state = 16, .external_lex_state = 6},
  [3371] = {.lex_state = 9, .external_lex_state = 5},
  [3372] = {.lex_state = 9},
  [3373] = {.lex_state = 9, .external_lex_state = 5},
  [3374] = {.lex_state = 9},
  [3375] = {.lex_state = 75},
  [3376] = {.lex_state = 9},
  [3377] = {.lex_state = 75},
  [3378] = {.lex_state = 9, .external_lex_state = 5},
  [3379] = {.lex_state = 0, .external_lex_state = 4},
  [3380] = {.lex_state = 9},
  [3381] = {.lex_state = 16, .external_lex_state = 6},
  [3382] = {.lex_state = 75},
  [3383] = {.lex_state = 0, .external_lex_state = 4},
  [3384] = {.lex_state = 9},
  [3385] = {.lex_state = 9},
  [3386] = {.lex_state = 19},
  [3387] = {.lex_state = 19},
  [3388] = {.lex_state = 9, .external_lex_state = 5},
  [3389] = {.lex_state = 9, .external_lex_state = 5},
  [3390] = {.lex_state = 0, .external_lex_state = 4},
  [3391] = {.lex_state = 9},
  [3392] = {.lex_state = 9, .external_lex_state = 5},
  [3393] = {.lex_state = 9, .external_lex_state = 5},
  [3394] = {.lex_state = 9},
  [3395] = {.lex_state = 9},
  [3396] = {.lex_state = 9},
  [3397] = {.lex_state = 9, .external_lex_state = 5},
  [3398] = {.lex_state = 75},
  [3399] = {.lex_state = 75},
  [3400] = {.lex_state = 9},
  [3401] = {.lex_state = 9},
  [3402] = {.lex_state = 9},
  [3403] = {.lex_state = 9, .external_lex_state = 5},
  [3404] = {.lex_state = 75},
  [3405] = {.lex_state = 75},
  [3406] = {.lex_state = 75},
  [3407] = {.lex_state = 19},
  [3408] = {.lex_state = 19},
  [3409] = {.lex_state = 9},
  [3410] = {.lex_state = 9, .external_lex_state = 5},
  [3411] = {.lex_state = 9},
  [3412] = {.lex_state = 0, .external_lex_state = 4},
  [3413] = {.lex_state = 9, .external_lex_state = 5},
  [3414] = {.lex_state = 9},
  [3415] = {.lex_state = 0, .external_lex_state = 4},
  [3416] = {.lex_state = 0, .external_lex_state = 4},
  [3417] = {.lex_state = 9, .external_lex_state = 5},
  [3418] = {.lex_state = 9},
  [3419] = {.lex_state = 9},
  [3420] = {.lex_state = 9},
  [3421] = {.lex_state = 75},
  [3422] = {.lex_state = 75},
  [3423] = {.lex_state = 9, .external_lex_state = 5},
  [3424] = {.lex_state = 9, .external_lex_state = 5},
  [3425] = {.lex_state = 9},
  [3426] = {.lex_state = 9},
  [3427] = {.lex_state = 9},
  [3428] = {.lex_state = 9},
  [3429] = {.lex_state = 75},
  [3430] = {.lex_state = 9},
  [3431] = {.lex_state = 3},
  [3432] = {.lex_state = 0, .external_lex_state = 4},
  [3433] = {.lex_state = 0, .external_lex_state = 4},
  [3434] = {.lex_state = 9},
  [3435] = {.lex_state = 0, .external_lex_state = 4},
  [3436] = {.lex_state = 0, .external_lex_state = 4},
  [3437] = {.lex_state = 9},
  [3438] = {.lex_state = 9, .external_lex_state = 5},
  [3439] = {.lex_state = 9},
  [3440] = {.lex_state = 75},
  [3441] = {.lex_state = 9, .external_lex_state = 5},
  [3442] = {.lex_state = 9},
  [3443] = {.lex_state = 9},
  [3444] = {.lex_state = 0, .external_lex_state = 4},
  [3445] = {.lex_state = 75},
  [3446] = {.lex_state = 9},
  [3447] = {.lex_state = 16, .external_lex_state = 6},
  [3448] = {.lex_state = 3},
  [3449] = {.lex_state = 0, .external_lex_state = 4},
  [3450] = {.lex_state = 9},
  [3451] = {.lex_state = 9},
  [3452] = {.lex_state = 9},
  [3453] = {.lex_state = 9},
  [3454] = {.lex_state = 9, .external_lex_state = 5},
  [3455] = {.lex_state = 9, .external_lex_state = 5},
  [3456] = {.lex_state = 9},
  [3457] = {.lex_state = 9},
  [3458] = {.lex_state = 9, .external_lex_state = 5},
  [3459] = {.lex_state = 10},
  [3460] = {.lex_state = 75},
  [3461] = {.lex_state = 3},
  [3462] = {.lex_state = 0, .external_lex_state = 4},
  [3463] = {.lex_state = 9},
  [3464] = {.lex_state = 0, .external_lex_state = 4},
  [3465] = {.lex_state = 9},
  [3466] = {.lex_state = 0, .external_lex_state = 4},
  [3467] = {.lex_state = 0, .external_lex_state = 4},
  [3468] = {.lex_state = 0, .external_lex_state = 4},
  [3469] = {.lex_state = 3},
  [3470] = {.lex_state = 9},
  [3471] = {.lex_state = 9, .external_lex_state = 4},
  [3472] = {.lex_state = 75},
  [3473] = {.lex_state = 9, .external_lex_state = 4},
  [3474] = {.lex_state = 19},
  [3475] = {.lex_state = 9},
  [3476] = {.lex_state = 9},
  [3477] = {.lex_state = 9},
  [3478] = {.lex_state = 0, .external_lex_state = 4},
  [3479] = {.lex_state = 0, .external_lex_state = 4},
  [3480] = {.lex_state = 75},
  [3481] = {.lex_state = 9},
  [3482] = {.lex_state = 9},
  [3483] = {.lex_state = 9},
  [3484] = {.lex_state = 9},
  [3485] = {.lex_state = 75},
  [3486] = {.lex_state = 19},
  [3487] = {.lex_state = 16, .external_lex_state = 6},
  [3488] = {.lex_state = 9},
  [3489] = {.lex_state = 75},
  [3490] = {.lex_state = 9, .external_lex_state = 5},
  [3491] = {.lex_state = 75},
  [3492] = {.lex_state = 75},
  [3493] = {.lex_state = 75},
  [3494] = {.lex_state = 9, .external_lex_state = 4},
  [3495] = {.lex_state = 9},
  [3496] = {.lex_state = 9},
  [3497] = {.lex_state = 9},
  [3498] = {.lex_state = 9, .external_lex_state = 5},
  [3499] = {.lex_state = 75},
  [3500] = {.lex_state = 0, .external_lex_state = 4},
  [3501] = {.lex_state = 9, .external_lex_state = 4},
  [3502] = {.lex_state = 0, .external_lex_state = 4},
  [3503] = {.lex_state = 9},
  [3504] = {.lex_state = 75},
  [3505] = {.lex_state = 3, .external_lex_state = 4},
  [3506] = {.lex_state = 75},
  [3507] = {.lex_state = 9, .external_lex_state = 5},
  [3508] = {.lex_state = 9, .external_lex_state = 5},
  [3509] = {.lex_state = 9},
  [3510] = {.lex_state = 9},
  [3511] = {.lex_state = 9},
  [3512] = {.lex_state = 9},
  [3513] = {.lex_state = 9},
  [3514] = {.lex_state = 9, .external_lex_state = 5},
  [3515] = {.lex_state = 9},
  [3516] = {.lex_state = 9},
  [3517] = {.lex_state = 9},
  [3518] = {.lex_state = 9},
  [3519] = {.lex_state = 75},
  [3520] = {.lex_state = 0},
  [3521] = {.lex_state = 9},
  [3522] = {.lex_state = 0, .external_lex_state = 4},
  [3523] = {.lex_state = 9},
  [3524] = {.lex_state = 9},
  [3525] = {.lex_state = 9, .external_lex_state = 5},
  [3526] = {.lex_state = 9},
  [3527] = {.lex_state = 9},
  [3528] = {.lex_state = 0, .external_lex_state = 4},
  [3529] = {.lex_state = 9},
  [3530] = {.lex_state = 9},
  [3531] = {.lex_state = 16, .external_lex_state = 6},
  [3532] = {.lex_state = 9},
  [3533] = {.lex_state = 9},
  [3534] = {.lex_state = 75},
  [3535] = {.lex_state = 9},
  [3536] = {.lex_state = 9},
  [3537] = {.lex_state = 75},
  [3538] = {.lex_state = 9},
  [3539] = {.lex_state = 75, .external_lex_state = 4},
  [3540] = {.lex_state = 9},
  [3541] = {.lex_state = 9},
  [3542] = {.lex_state = 9},
  [3543] = {.lex_state = 9},
  [3544] = {.lex_state = 75},
  [3545] = {.lex_state = 0},
  [3546] = {.lex_state = 0, .external_lex_state = 4},
  [3547] = {.lex_state = 9},
  [3548] = {.lex_state = 9},
  [3549] = {.lex_state = 9},
  [3550] = {.lex_state = 75},
  [3551] = {.lex_state = 75, .external_lex_state = 4},
  [3552] = {.lex_state = 9},
  [3553] = {.lex_state = 75},
  [3554] = {.lex_state = 75},
  [3555] = {.lex_state = 0, .external_lex_state = 4},
  [3556] = {.lex_state = 9, .external_lex_state = 5},
  [3557] = {.lex_state = 9},
  [3558] = {.lex_state = 0, .external_lex_state = 4},
  [3559] = {.lex_state = 75},
  [3560] = {.lex_state = 9, .external_lex_state = 5},
  [3561] = {.lex_state = 0, .external_lex_state = 4},
  [3562] = {.lex_state = 9, .external_lex_state = 4},
  [3563] = {.lex_state = 9},
  [3564] = {.lex_state = 0, .external_lex_state = 4},
  [3565] = {.lex_state = 0, .external_lex_state = 4},
  [3566] = {.lex_state = 9},
  [3567] = {.lex_state = 16, .external_lex_state = 6},
  [3568] = {.lex_state = 9, .external_lex_state = 5},
  [3569] = {.lex_state = 0, .external_lex_state = 4},
  [3570] = {.lex_state = 9},
  [3571] = {.lex_state = 9, .external_lex_state = 5},
  [3572] = {.lex_state = 9},
  [3573] = {.lex_state = 0},
  [3574] = {.lex_state = 0, .external_lex_state = 4},
  [3575] = {.lex_state = 9},
  [3576] = {.lex_state = 75},
  [3577] = {.lex_state = 0},
  [3578] = {.lex_state = 0, .external_lex_state = 4},
  [3579] = {.lex_state = 0, .external_lex_state = 4},
  [3580] = {.lex_state = 0},
  [3581] = {.lex_state = 0, .external_lex_state = 4},
  [3582] = {.lex_state = 0, .external_lex_state = 4},
  [3583] = {.lex_state = 9},
  [3584] = {.lex_state = 9},
  [3585] = {.lex_state = 0, .external_lex_state = 4},
  [3586] = {.lex_state = 0},
  [3587] = {.lex_state = 75},
  [3588] = {.lex_state = 0, .external_lex_state = 4},
  [3589] = {.lex_state = 0, .external_lex_state = 4},
  [3590] = {.lex_state = 0, .external_lex_state = 4},
  [3591] = {.lex_state = 0},
  [3592] = {.lex_state = 0, .external_lex_state = 4},
  [3593] = {.lex_state = 9},
  [3594] = {.lex_state = 9},
  [3595] = {.lex_state = 9, .external_lex_state = 4},
  [3596] = {.lex_state = 0, .external_lex_state = 4},
  [3597] = {.lex_state = 9},
  [3598] = {.lex_state = 0, .external_lex_state = 4},
  [3599] = {.lex_state = 9},
  [3600] = {.lex_state = 9},
  [3601] = {.lex_state = 0, .external_lex_state = 4},
  [3602] = {.lex_state = 75},
  [3603] = {.lex_state = 9},
  [3604] = {.lex_state = 9, .external_lex_state = 5},
  [3605] = {.lex_state = 9, .external_lex_state = 4},
  [3606] = {.lex_state = 0, .external_lex_state = 4},
  [3607] = {.lex_state = 9, .external_lex_state = 4},
  [3608] = {.lex_state = 3, .external_lex_state = 4},
  [3609] = {.lex_state = 9},
  [3610] = {.lex_state = 75},
  [3611] = {.lex_state = 0, .external_lex_state = 4},
  [3612] = {.lex_state = 9},
  [3613] = {.lex_state = 9},
  [3614] = {.lex_state = 0, .external_lex_state = 4},
  [3615] = {.lex_state = 9},
  [3616] = {.lex_state = 9},
  [3617] = {.lex_state = 9},
  [3618] = {.lex_state = 75},
  [3619] = {.lex_state = 9},
  [3620] = {.lex_state = 0, .external_lex_state = 4},
  [3621] = {.lex_state = 9},
  [3622] = {.lex_state = 9},
  [3623] = {.lex_state = 9},
  [3624] = {.lex_state = 9},
  [3625] = {.lex_state = 0},
  [3626] = {.lex_state = 9},
  [3627] = {.lex_state = 16, .external_lex_state = 6},
  [3628] = {.lex_state = 3},
  [3629] = {.lex_state = 9},
  [3630] = {.lex_state = 9},
  [3631] = {.lex_state = 9},
  [3632] = {.lex_state = 9},
  [3633] = {.lex_state = 9},
  [3634] = {.lex_state = 9},
  [3635] = {.lex_state = 9},
  [3636] = {.lex_state = 9, .external_lex_state = 4},
  [3637] = {.lex_state = 0, .external_lex_state = 4},
  [3638] = {.lex_state = 0, .external_lex_state = 4},
  [3639] = {.lex_state = 3},
  [3640] = {.lex_state = 16, .external_lex_state = 6},
  [3641] = {.lex_state = 0, .external_lex_state = 4},
  [3642] = {.lex_state = 9},
  [3643] = {.lex_state = 0, .external_lex_state = 4},
  [3644] = {.lex_state = 16, .external_lex_state = 6},
  [3645] = {.lex_state = 9},
  [3646] = {.lex_state = 9},
  [3647] = {.lex_state = 9},
  [3648] = {.lex_state = 0, .external_lex_state = 4},
  [3649] = {.lex_state = 9},
  [3650] = {.lex_state = 0},
  [3651] = {.lex_state = 0, .external_lex_state = 4},
  [3652] = {.lex_state = 0, .external_lex_state = 4},
  [3653] = {.lex_state = 9},
  [3654] = {.lex_state = 9},
  [3655] = {.lex_state = 0, .external_lex_state = 4},
  [3656] = {.lex_state = 0, .external_lex_state = 4},
  [3657] = {.lex_state = 0, .external_lex_state = 4},
  [3658] = {.lex_state = 0, .external_lex_state = 4},
  [3659] = {.lex_state = 0, .external_lex_state = 4},
  [3660] = {.lex_state = 0, .external_lex_state = 4},
  [3661] = {.lex_state = 9},
  [3662] = {.lex_state = 0, .external_lex_state = 4},
  [3663] = {.lex_state = 9},
  [3664] = {.lex_state = 0, .external_lex_state = 4},
  [3665] = {.lex_state = 9},
  [3666] = {.lex_state = 9},
  [3667] = {.lex_state = 9},
  [3668] = {.lex_state = 9, .external_lex_state = 5},
  [3669] = {.lex_state = 0},
  [3670] = {.lex_state = 75},
  [3671] = {.lex_state = 75},
  [3672] = {.lex_state = 0, .external_lex_state = 4},
  [3673] = {.lex_state = 0, .external_lex_state = 4},
  [3674] = {.lex_state = 0, .external_lex_state = 4},
  [3675] = {.lex_state = 0, .external_lex_state = 4},
  [3676] = {.lex_state = 75},
  [3677] = {.lex_state = 0, .external_lex_state = 4},
  [3678] = {.lex_state = 0, .external_lex_state = 4},
  [3679] = {.lex_state = 0, .external_lex_state = 4},
  [3680] = {.lex_state = 9},
  [3681] = {.lex_state = 0, .external_lex_state = 4},
  [3682] = {.lex_state = 9},
  [3683] = {.lex_state = 9, .external_lex_state = 5},
  [3684] = {.lex_state = 9},
  [3685] = {.lex_state = 9, .external_lex_state = 5},
  [3686] = {.lex_state = 0, .external_lex_state = 4},
  [3687] = {.lex_state = 0, .external_lex_state = 4},
  [3688] = {.lex_state = 0, .external_lex_state = 4},
  [3689] = {.lex_state = 0, .external_lex_state = 4},
  [3690] = {.lex_state = 0, .external_lex_state = 4},
  [3691] = {.lex_state = 0, .external_lex_state = 4},
  [3692] = {.lex_state = 0, .external_lex_state = 4},
  [3693] = {.lex_state = 0, .external_lex_state = 4},
  [3694] = {.lex_state = 9},
  [3695] = {.lex_state = 0, .external_lex_state = 4},
  [3696] = {.lex_state = 0, .external_lex_state = 4},
  [3697] = {.lex_state = 9, .external_lex_state = 4},
  [3698] = {.lex_state = 0, .external_lex_state = 4},
  [3699] = {.lex_state = 0, .external_lex_state = 4},
  [3700] = {.lex_state = 0, .external_lex_state = 4},
  [3701] = {.lex_state = 0, .external_lex_state = 4},
  [3702] = {.lex_state = 0, .external_lex_state = 4},
  [3703] = {.lex_state = 9, .external_lex_state = 5},
  [3704] = {.lex_state = 9},
  [3705] = {.lex_state = 9},
  [3706] = {.lex_state = 16, .external_lex_state = 6},
  [3707] = {.lex_state = 0, .external_lex_state = 4},
  [3708] = {.lex_state = 9},
  [3709] = {.lex_state = 0, .external_lex_state = 4},
  [3710] = {.lex_state = 0, .external_lex_state = 4},
  [3711] = {.lex_state = 0, .external_lex_state = 4},
  [3712] = {.lex_state = 0, .external_lex_state = 4},
  [3713] = {.lex_state = 0, .external_lex_state = 4},
  [3714] = {.lex_state = 0, .external_lex_state = 4},
  [3715] = {.lex_state = 9},
  [3716] = {.lex_state = 9},
  [3717] = {.lex_state = 9},
  [3718] = {.lex_state = 9},
  [3719] = {.lex_state = 0, .external_lex_state = 4},
  [3720] = {.lex_state = 9},
  [3721] = {.lex_state = 0, .external_lex_state = 4},
  [3722] = {.lex_state = 0, .external_lex_state = 4},
  [3723] = {.lex_state = 0, .external_lex_state = 4},
  [3724] = {.lex_state = 9, .external_lex_state = 5},
  [3725] = {.lex_state = 9},
  [3726] = {.lex_state = 0, .external_lex_state = 4},
  [3727] = {.lex_state = 0, .external_lex_state = 4},
  [3728] = {.lex_state = 0, .external_lex_state = 4},
  [3729] = {.lex_state = 0, .external_lex_state = 4},
  [3730] = {.lex_state = 0, .external_lex_state = 4},
  [3731] = {.lex_state = 9, .external_lex_state = 5},
  [3732] = {.lex_state = 0, .external_lex_state = 4},
  [3733] = {.lex_state = 0, .external_lex_state = 4},
  [3734] = {.lex_state = 0, .external_lex_state = 4},
  [3735] = {.lex_state = 9},
  [3736] = {.lex_state = 9},
  [3737] = {.lex_state = 0},
  [3738] = {.lex_state = 9},
  [3739] = {.lex_state = 0, .external_lex_state = 4},
  [3740] = {.lex_state = 0, .external_lex_state = 4},
  [3741] = {.lex_state = 0, .external_lex_state = 4},
  [3742] = {.lex_state = 0, .external_lex_state = 4},
  [3743] = {.lex_state = 9, .external_lex_state = 5},
  [3744] = {.lex_state = 0, .external_lex_state = 4},
  [3745] = {.lex_state = 0, .external_lex_state = 4},
  [3746] = {.lex_state = 0, .external_lex_state = 4},
  [3747] = {.lex_state = 9, .external_lex_state = 5},
  [3748] = {.lex_state = 0, .external_lex_state = 4},
  [3749] = {.lex_state = 9, .external_lex_state = 5},
  [3750] = {.lex_state = 0, .external_lex_state = 4},
  [3751] = {.lex_state = 0, .external_lex_state = 4},
  [3752] = {.lex_state = 0, .external_lex_state = 4},
  [3753] = {.lex_state = 0, .external_lex_state = 4},
  [3754] = {.lex_state = 0, .external_lex_state = 4},
  [3755] = {.lex_state = 0, .external_lex_state = 4},
  [3756] = {.lex_state = 0, .external_lex_state = 4},
  [3757] = {.lex_state = 9, .external_lex_state = 5},
  [3758] = {.lex_state = 75},
  [3759] = {.lex_state = 0, .external_lex_state = 4},
  [3760] = {.lex_state = 0, .external_lex_state = 4},
  [3761] = {.lex_state = 0, .external_lex_state = 4},
  [3762] = {.lex_state = 0, .external_lex_state = 4},
  [3763] = {.lex_state = 0, .external_lex_state = 4},
  [3764] = {.lex_state = 0, .external_lex_state = 4},
  [3765] = {.lex_state = 0, .external_lex_state = 4},
  [3766] = {.lex_state = 9, .external_lex_state = 4},
  [3767] = {.lex_state = 9},
  [3768] = {.lex_state = 9, .external_lex_state = 5},
  [3769] = {.lex_state = 0},
  [3770] = {.lex_state = 0},
  [3771] = {.lex_state = 3},
  [3772] = {.lex_state = 10},
  [3773] = {.lex_state = 0},
  [3774] = {.lex_state = 0, .external_lex_state = 4},
  [3775] = {.lex_state = 9, .external_lex_state = 4},
  [3776] = {.lex_state = 0},
  [3777] = {.lex_state = 16, .external_lex_state = 6},
  [3778] = {.lex_state = 9},
  [3779] = {.lex_state = 0, .external_lex_state = 4},
  [3780] = {.lex_state = 0, .external_lex_state = 4},
  [3781] = {.lex_state = 9, .external_lex_state = 5},
  [3782] = {.lex_state = 0, .external_lex_state = 4},
  [3783] = {.lex_state = 0, .external_lex_state = 4},
  [3784] = {.lex_state = 0, .external_lex_state = 4},
  [3785] = {.lex_state = 0, .external_lex_state = 4},
  [3786] = {.lex_state = 0},
  [3787] = {.lex_state = 9},
  [3788] = {.lex_state = 0, .external_lex_state = 4},
  [3789] = {.lex_state = 9},
  [3790] = {.lex_state = 0, .external_lex_state = 4},
  [3791] = {.lex_state = 16, .external_lex_state = 6},
  [3792] = {.lex_state = 9},
  [3793] = {.lex_state = 0, .external_lex_state = 4},
  [3794] = {.lex_state = 0, .external_lex_state = 4},
  [3795] = {.lex_state = 0, .external_lex_state = 4},
  [3796] = {.lex_state = 75},
  [3797] = {.lex_state = 9},
  [3798] = {.lex_state = 0, .external_lex_state = 4},
  [3799] = {.lex_state = 9, .external_lex_state = 5},
  [3800] = {.lex_state = 0, .external_lex_state = 4},
  [3801] = {.lex_state = 9},
  [3802] = {.lex_state = 9},
  [3803] = {.lex_state = 0, .external_lex_state = 4},
  [3804] = {.lex_state = 9},
  [3805] = {.lex_state = 0, .external_lex_state = 4},
  [3806] = {.lex_state = 9},
  [3807] = {.lex_state = 0, .external_lex_state = 4},
  [3808] = {.lex_state = 0, .external_lex_state = 4},
  [3809] = {.lex_state = 16, .external_lex_state = 6},
  [3810] = {.lex_state = 0, .external_lex_state = 4},
  [3811] = {.lex_state = 0, .external_lex_state = 4},
  [3812] = {.lex_state = 0, .external_lex_state = 4},
  [3813] = {.lex_state = 75},
  [3814] = {.lex_state = 0, .external_lex_state = 4},
  [3815] = {.lex_state = 0, .external_lex_state = 4},
  [3816] = {.lex_state = 0, .external_lex_state = 4},
  [3817] = {.lex_state = 0, .external_lex_state = 4},
  [3818] = {.lex_state = 0, .external_lex_state = 4},
  [3819] = {.lex_state = 75},
  [3820] = {.lex_state = 9, .external_lex_state = 4},
  [3821] = {.lex_state = 9, .external_lex_state = 5},
  [3822] = {.lex_state = 16, .external_lex_state = 6},
  [3823] = {.lex_state = 9},
  [3824] = {.lex_state = 0, .external_lex_state = 4},
  [3825] = {.lex_state = 9, .external_lex_state = 5},
  [3826] = {.lex_state = 9},
  [3827] = {.lex_state = 0, .external_lex_state = 4},
  [3828] = {.lex_state = 0, .external_lex_state = 4},
  [3829] = {.lex_state = 0, .external_lex_state = 4},
  [3830] = {.lex_state = 0, .external_lex_state = 4},
  [3831] = {.lex_state = 0, .external_lex_state = 4},
  [3832] = {.lex_state = 0, .external_lex_state = 4},
  [3833] = {.lex_state = 16, .external_lex_state = 6},
  [3834] = {.lex_state = 16, .external_lex_state = 6},
  [3835] = {.lex_state = 0, .external_lex_state = 4},
  [3836] = {.lex_state = 75},
  [3837] = {.lex_state = 0, .external_lex_state = 4},
  [3838] = {.lex_state = 15},
  [3839] = {.lex_state = 9},
  [3840] = {.lex_state = 75, .external_lex_state = 4},
  [3841] = {.lex_state = 9},
  [3842] = {.lex_state = 9},
  [3843] = {.lex_state = 3},
  [3844] = {.lex_state = 0, .external_lex_state = 4},
  [3845] = {.lex_state = 3, .external_lex_state = 4},
  [3846] = {.lex_state = 9},
  [3847] = {.lex_state = 15},
  [3848] = {.lex_state = 15},
  [3849] = {.lex_state = 20},
  [3850] = {.lex_state = 20},
  [3851] = {.lex_state = 15},
  [3852] = {.lex_state = 15},
  [3853] = {.lex_state = 20},
  [3854] = {.lex_state = 9},
  [3855] = {.lex_state = 20},
  [3856] = {.lex_state = 3},
  [3857] = {.lex_state = 9},
  [3858] = {.lex_state = 20},
  [3859] = {.lex_state = 15},
  [3860] = {.lex_state = 0, .external_lex_state = 4},
  [3861] = {.lex_state = 75},
  [3862] = {.lex_state = 9},
  [3863] = {.lex_state = 9},
  [3864] = {.lex_state = 9},
  [3865] = {.lex_state = 0, .external_lex_state = 4},
  [3866] = {.lex_state = 0, .external_lex_state = 4},
  [3867] = {.lex_state = 75, .external_lex_state = 4},
  [3868] = {.lex_state = 75},
  [3869] = {.lex_state = 9},
  [3870] = {.lex_state = 15},
  [3871] = {.lex_state = 9},
  [3872] = {.lex_state = 20},
  [3873] = {.lex_state = 0},
  [3874] = {.lex_state = 75},
  [3875] = {.lex_state = 15},
  [3876] = {.lex_state = 9},
  [3877] = {.lex_state = 9},
  [3878] = {.lex_state = 20},
  [3879] = {.lex_state = 15},
  [3880] = {.lex_state = 20},
  [3881] = {.lex_state = 16, .external_lex_state = 6},
  [3882] = {.lex_state = 0},
  [3883] = {.lex_state = 0},
  [3884] = {.lex_state = 0},
  [3885] = {.lex_state = 9},
  [3886] = {.lex_state = 9},
  [3887] = {.lex_state = 0, .external_lex_state = 4},
  [3888] = {.lex_state = 9},
  [3889] = {.lex_state = 9},
  [3890] = {.lex_state = 15},
  [3891] = {.lex_state = 9},
  [3892] = {.lex_state = 0},
  [3893] = {.lex_state = 0, .external_lex_state = 4},
  [3894] = {.lex_state = 15},
  [3895] = {.lex_state = 20},
  [3896] = {.lex_state = 15},
  [3897] = {.lex_state = 20},
  [3898] = {.lex_state = 15},
  [3899] = {.lex_state = 20},
  [3900] = {.lex_state = 9},
  [3901] = {.lex_state = 15},
  [3902] = {.lex_state = 20},
  [3903] = {.lex_state = 0, .external_lex_state = 4},
  [3904] = {.lex_state = 75, .external_lex_state = 4},
  [3905] = {.lex_state = 15},
  [3906] = {.lex_state = 20},
  [3907] = {.lex_state = 0},
  [3908] = {.lex_state = 16, .external_lex_state = 6},
  [3909] = {.lex_state = 20},
  [3910] = {.lex_state = 9},
  [3911] = {.lex_state = 0, .external_lex_state = 4},
  [3912] = {.lex_state = 0, .external_lex_state = 4},
  [3913] = {.lex_state = 9},
  [3914] = {.lex_state = 75},
  [3915] = {.lex_state = 9},
  [3916] = {.lex_state = 9},
  [3917] = {.lex_state = 9},
  [3918] = {.lex_state = 9},
  [3919] = {.lex_state = 9},
  [3920] = {.lex_state = 9},
  [3921] = {.lex_state = 75},
  [3922] = {.lex_state = 75},
  [3923] = {.lex_state = 20},
  [3924] = {.lex_state = 9},
  [3925] = {.lex_state = 9},
  [3926] = {.lex_state = 9},
  [3927] = {.lex_state = 9},
  [3928] = {.lex_state = 9},
  [3929] = {.lex_state = 9},
  [3930] = {.lex_state = 0},
  [3931] = {.lex_state = 0, .external_lex_state = 4},
  [3932] = {.lex_state = 9},
  [3933] = {.lex_state = 9},
  [3934] = {.lex_state = 9},
  [3935] = {.lex_state = 9},
  [3936] = {.lex_state = 0},
  [3937] = {.lex_state = 9},
  [3938] = {.lex_state = 75, .external_lex_state = 4},
  [3939] = {.lex_state = 20},
  [3940] = {.lex_state = 9},
  [3941] = {.lex_state = 0},
  [3942] = {.lex_state = 75},
  [3943] = {.lex_state = 9},
  [3944] = {.lex_state = 75, .external_lex_state = 4},
  [3945] = {.lex_state = 15},
  [3946] = {.lex_state = 0},
  [3947] = {.lex_state = 0, .external_lex_state = 4},
  [3948] = {.lex_state = 9},
  [3949] = {.lex_state = 0, .external_lex_state = 4},
  [3950] = {.lex_state = 0, .external_lex_state = 4},
  [3951] = {.lex_state = 9},
  [3952] = {.lex_state = 0},
  [3953] = {.lex_state = 0, .external_lex_state = 5},
  [3954] = {.lex_state = 9},
  [3955] = {.lex_state = 9},
  [3956] = {.lex_state = 9},
  [3957] = {.lex_state = 9},
  [3958] = {.lex_state = 9},
  [3959] = {.lex_state = 9},
  [3960] = {.lex_state = 20},
  [3961] = {.lex_state = 15},
  [3962] = {.lex_state = 75},
  [3963] = {.lex_state = 20},
  [3964] = {.lex_state = 0, .external_lex_state = 4},
  [3965] = {.lex_state = 15},
  [3966] = {.lex_state = 9},
  [3967] = {.lex_state = 75},
  [3968] = {.lex_state = 9},
  [3969] = {.lex_state = 0},
  [3970] = {.lex_state = 0},
  [3971] = {.lex_state = 0},
  [3972] = {.lex_state = 0},
  [3973] = {.lex_state = 75},
  [3974] = {.lex_state = 0},
  [3975] = {.lex_state = 20},
  [3976] = {.lex_state = 75, .external_lex_state = 4},
  [3977] = {.lex_state = 9},
  [3978] = {.lex_state = 9},
  [3979] = {.lex_state = 15},
  [3980] = {.lex_state = 9},
  [3981] = {.lex_state = 0},
  [3982] = {.lex_state = 0},
  [3983] = {.lex_state = 0},
  [3984] = {.lex_state = 3},
  [3985] = {.lex_state = 3},
  [3986] = {.lex_state = 0},
  [3987] = {.lex_state = 0},
  [3988] = {.lex_state = 75},
  [3989] = {.lex_state = 3},
  [3990] = {.lex_state = 0, .external_lex_state = 4},
  [3991] = {.lex_state = 0},
  [3992] = {.lex_state = 0},
  [3993] = {.lex_state = 0},
  [3994] = {.lex_state = 0},
  [3995] = {.lex_state = 0},
  [3996] = {.lex_state = 0},
  [3997] = {.lex_state = 75},
  [3998] = {.lex_state = 9},
  [3999] = {.lex_state = 75, .external_lex_state = 4},
  [4000] = {.lex_state = 75, .external_lex_state = 4},
  [4001] = {.lex_state = 0},
  [4002] = {.lex_state = 75, .external_lex_state = 4},
  [4003] = {.lex_state = 0},
  [4004] = {.lex_state = 75, .external_lex_state = 4},
  [4005] = {.lex_state = 0},
  [4006] = {.lex_state = 0},
  [4007] = {.lex_state = 0},
  [4008] = {.lex_state = 0},
  [4009] = {.lex_state = 75, .external_lex_state = 4},
  [4010] = {.lex_state = 0},
  [4011] = {.lex_state = 9},
  [4012] = {.lex_state = 3},
  [4013] = {.lex_state = 3},
  [4014] = {.lex_state = 3},
  [4015] = {.lex_state = 75},
  [4016] = {.lex_state = 0, .external_lex_state = 4},
  [4017] = {.lex_state = 0},
  [4018] = {.lex_state = 0, .external_lex_state = 4},
  [4019] = {.lex_state = 0},
  [4020] = {.lex_state = 0},
  [4021] = {.lex_state = 0},
  [4022] = {.lex_state = 0},
  [4023] = {.lex_state = 0, .external_lex_state = 4},
  [4024] = {.lex_state = 0, .external_lex_state = 4},
  [4025] = {.lex_state = 0, .external_lex_state = 4},
  [4026] = {.lex_state = 0},
  [4027] = {.lex_state = 0, .external_lex_state = 4},
  [4028] = {.lex_state = 0},
  [4029] = {.lex_state = 0, .external_lex_state = 4},
  [4030] = {.lex_state = 75},
  [4031] = {.lex_state = 0, .external_lex_state = 4},
  [4032] = {.lex_state = 0, .external_lex_state = 4},
  [4033] = {.lex_state = 3},
  [4034] = {.lex_state = 3},
  [4035] = {.lex_state = 0, .external_lex_state = 4},
  [4036] = {.lex_state = 0, .external_lex_state = 4},
  [4037] = {.lex_state = 75},
  [4038] = {.lex_state = 16, .external_lex_state = 6},
  [4039] = {.lex_state = 0, .external_lex_state = 4},
  [4040] = {.lex_state = 0},
  [4041] = {.lex_state = 0, .external_lex_state = 4},
  [4042] = {.lex_state = 0},
  [4043] = {.lex_state = 75},
  [4044] = {.lex_state = 75, .external_lex_state = 4},
  [4045] = {.lex_state = 75},
  [4046] = {.lex_state = 9},
  [4047] = {.lex_state = 0},
  [4048] = {.lex_state = 9},
  [4049] = {.lex_state = 0},
  [4050] = {.lex_state = 0},
  [4051] = {.lex_state = 75},
  [4052] = {.lex_state = 75, .external_lex_state = 4},
  [4053] = {.lex_state = 75, .external_lex_state = 4},
  [4054] = {.lex_state = 0},
  [4055] = {.lex_state = 9},
  [4056] = {.lex_state = 0},
  [4057] = {.lex_state = 0},
  [4058] = {.lex_state = 0},
  [4059] = {.lex_state = 0},
  [4060] = {.lex_state = 0},
  [4061] = {.lex_state = 9},
  [4062] = {.lex_state = 9},
  [4063] = {.lex_state = 9},
  [4064] = {.lex_state = 9},
  [4065] = {.lex_state = 9},
  [4066] = {.lex_state = 9},
  [4067] = {.lex_state = 75},
  [4068] = {.lex_state = 0},
  [4069] = {.lex_state = 0},
  [4070] = {.lex_state = 0},
  [4071] = {.lex_state = 0},
  [4072] = {.lex_state = 0},
  [4073] = {.lex_state = 0},
  [4074] = {.lex_state = 75},
  [4075] = {.lex_state = 75},
  [4076] = {.lex_state = 75},
  [4077] = {.lex_state = 0},
  [4078] = {.lex_state = 0},
  [4079] = {.lex_state = 0},
  [4080] = {.lex_state = 0},
  [4081] = {.lex_state = 0},
  [4082] = {.lex_state = 0},
  [4083] = {.lex_state = 0},
  [4084] = {.lex_state = 9},
  [4085] = {.lex_state = 0, .external_lex_state = 4},
  [4086] = {.lex_state = 9},
  [4087] = {.lex_state = 0, .external_lex_state = 4},
  [4088] = {.lex_state = 0, .external_lex_state = 4},
  [4089] = {.lex_state = 75},
  [4090] = {.lex_state = 3},
  [4091] = {.lex_state = 0},
  [4092] = {.lex_state = 0},
  [4093] = {.lex_state = 0},
  [4094] = {.lex_state = 0},
  [4095] = {.lex_state = 0, .external_lex_state = 4},
  [4096] = {.lex_state = 0, .external_lex_state = 4},
  [4097] = {.lex_state = 0, .external_lex_state = 4},
  [4098] = {.lex_state = 0, .external_lex_state = 4},
  [4099] = {.lex_state = 75},
  [4100] = {.lex_state = 9},
  [4101] = {.lex_state = 0},
  [4102] = {.lex_state = 0},
  [4103] = {.lex_state = 0},
  [4104] = {.lex_state = 75},
  [4105] = {.lex_state = 75},
  [4106] = {.lex_state = 75},
  [4107] = {.lex_state = 9},
  [4108] = {.lex_state = 75},
  [4109] = {.lex_state = 75},
  [4110] = {.lex_state = 75},
  [4111] = {.lex_state = 75},
  [4112] = {.lex_state = 75},
  [4113] = {.lex_state = 75},
  [4114] = {.lex_state = 75},
  [4115] = {.lex_state = 0},
  [4116] = {.lex_state = 9},
  [4117] = {.lex_state = 0},
  [4118] = {.lex_state = 75},
  [4119] = {.lex_state = 0, .external_lex_state = 4},
  [4120] = {.lex_state = 0},
  [4121] = {.lex_state = 0},
  [4122] = {.lex_state = 0},
  [4123] = {.lex_state = 9},
  [4124] = {.lex_state = 0, .external_lex_state = 4},
  [4125] = {.lex_state = 0},
  [4126] = {.lex_state = 0},
  [4127] = {.lex_state = 0},
  [4128] = {.lex_state = 0, .external_lex_state = 4},
  [4129] = {.lex_state = 3, .external_lex_state = 4},
  [4130] = {.lex_state = 9},
  [4131] = {.lex_state = 0},
  [4132] = {.lex_state = 0, .external_lex_state = 4},
  [4133] = {.lex_state = 9},
  [4134] = {.lex_state = 0},
  [4135] = {.lex_state = 0},
  [4136] = {.lex_state = 0},
  [4137] = {.lex_state = 3, .external_lex_state = 4},
  [4138] = {.lex_state = 0},
  [4139] = {.lex_state = 9},
  [4140] = {.lex_state = 0},
  [4141] = {.lex_state = 9},
  [4142] = {.lex_state = 9},
  [4143] = {.lex_state = 9},
  [4144] = {.lex_state = 0},
  [4145] = {.lex_state = 9},
  [4146] = {.lex_state = 75},
  [4147] = {.lex_state = 0, .external_lex_state = 4},
  [4148] = {.lex_state = 0},
  [4149] = {.lex_state = 0},
  [4150] = {.lex_state = 0, .external_lex_state = 4},
  [4151] = {.lex_state = 0},
  [4152] = {.lex_state = 75},
  [4153] = {.lex_state = 0},
  [4154] = {.lex_state = 0},
  [4155] = {.lex_state = 0},
  [4156] = {.lex_state = 0},
  [4157] = {.lex_state = 0},
  [4158] = {.lex_state = 0, .external_lex_state = 4},
  [4159] = {.lex_state = 0},
  [4160] = {.lex_state = 75},
  [4161] = {.lex_state = 0},
  [4162] = {.lex_state = 0},
  [4163] = {.lex_state = 0},
  [4164] = {.lex_state = 0},
  [4165] = {.lex_state = 75, .external_lex_state = 4},
  [4166] = {.lex_state = 75},
  [4167] = {.lex_state = 0},
  [4168] = {.lex_state = 75},
  [4169] = {.lex_state = 9},
  [4170] = {.lex_state = 9},
  [4171] = {.lex_state = 0},
  [4172] = {.lex_state = 75},
  [4173] = {.lex_state = 75},
  [4174] = {.lex_state = 75},
  [4175] = {.lex_state = 0},
  [4176] = {.lex_state = 75},
  [4177] = {.lex_state = 0, .external_lex_state = 4},
  [4178] = {.lex_state = 75},
  [4179] = {.lex_state = 75},
  [4180] = {.lex_state = 0, .external_lex_state = 4},
  [4181] = {.lex_state = 0},
  [4182] = {.lex_state = 0, .external_lex_state = 4},
  [4183] = {.lex_state = 3, .external_lex_state = 4},
  [4184] = {.lex_state = 0},
  [4185] = {.lex_state = 0, .external_lex_state = 4},
  [4186] = {.lex_state = 75},
  [4187] = {.lex_state = 0, .external_lex_state = 4},
  [4188] = {.lex_state = 0},
  [4189] = {.lex_state = 0, .external_lex_state = 4},
  [4190] = {.lex_state = 75},
  [4191] = {.lex_state = 0, .external_lex_state = 4},
  [4192] = {.lex_state = 0, .external_lex_state = 4},
  [4193] = {.lex_state = 0, .external_lex_state = 4},
  [4194] = {.lex_state = 0, .external_lex_state = 4},
  [4195] = {.lex_state = 0},
  [4196] = {.lex_state = 0, .external_lex_state = 4},
  [4197] = {.lex_state = 0, .external_lex_state = 4},
  [4198] = {.lex_state = 9},
  [4199] = {.lex_state = 0},
  [4200] = {.lex_state = 0, .external_lex_state = 4},
  [4201] = {.lex_state = 0, .external_lex_state = 4},
  [4202] = {.lex_state = 0, .external_lex_state = 4},
  [4203] = {.lex_state = 0, .external_lex_state = 4},
  [4204] = {.lex_state = 0, .external_lex_state = 4},
  [4205] = {.lex_state = 0, .external_lex_state = 4},
  [4206] = {.lex_state = 0, .external_lex_state = 4},
  [4207] = {.lex_state = 0},
  [4208] = {.lex_state = 0, .external_lex_state = 4},
  [4209] = {.lex_state = 0, .external_lex_state = 4},
  [4210] = {.lex_state = 75},
  [4211] = {.lex_state = 0, .external_lex_state = 4},
  [4212] = {.lex_state = 0},
  [4213] = {.lex_state = 0},
  [4214] = {.lex_state = 75},
  [4215] = {.lex_state = 0},
  [4216] = {.lex_state = 0},
  [4217] = {.lex_state = 75, .external_lex_state = 4},
  [4218] = {.lex_state = 0, .external_lex_state = 4},
  [4219] = {.lex_state = 0},
  [4220] = {.lex_state = 75, .external_lex_state = 4},
  [4221] = {.lex_state = 75},
  [4222] = {.lex_state = 75},
  [4223] = {.lex_state = 75},
  [4224] = {.lex_state = 75},
  [4225] = {.lex_state = 75},
  [4226] = {.lex_state = 0},
  [4227] = {.lex_state = 0},
  [4228] = {.lex_state = 0},
  [4229] = {.lex_state = 0},
  [4230] = {.lex_state = 0},
  [4231] = {.lex_state = 9},
  [4232] = {.lex_state = 0},
  [4233] = {.lex_state = 0},
  [4234] = {.lex_state = 0},
  [4235] = {.lex_state = 9},
  [4236] = {.lex_state = 0},
  [4237] = {.lex_state = 0},
  [4238] = {.lex_state = 9},
  [4239] = {.lex_state = 9},
  [4240] = {.lex_state = 9},
  [4241] = {.lex_state = 0},
  [4242] = {.lex_state = 75, .external_lex_state = 4},
  [4243] = {.lex_state = 0, .external_lex_state = 4},
  [4244] = {.lex_state = 0},
  [4245] = {.lex_state = 0, .external_lex_state = 4},
  [4246] = {.lex_state = 0},
  [4247] = {.lex_state = 0},
  [4248] = {.lex_state = 0},
  [4249] = {.lex_state = 0, .external_lex_state = 4},
  [4250] = {.lex_state = 0, .external_lex_state = 4},
  [4251] = {.lex_state = 0, .external_lex_state = 4},
  [4252] = {.lex_state = 75},
  [4253] = {.lex_state = 9},
  [4254] = {.lex_state = 75},
  [4255] = {.lex_state = 0},
  [4256] = {.lex_state = 75},
  [4257] = {.lex_state = 0, .external_lex_state = 4},
  [4258] = {.lex_state = 75},
  [4259] = {.lex_state = 9},
  [4260] = {.lex_state = 3},
  [4261] = {.lex_state = 0, .external_lex_state = 4},
  [4262] = {.lex_state = 0, .external_lex_state = 4},
  [4263] = {.lex_state = 9},
  [4264] = {.lex_state = 0, .external_lex_state = 4},
  [4265] = {.lex_state = 0},
  [4266] = {.lex_state = 0},
  [4267] = {.lex_state = 9},
  [4268] = {.lex_state = 0},
  [4269] = {.lex_state = 9},
  [4270] = {.lex_state = 0},
  [4271] = {.lex_state = 9},
  [4272] = {.lex_state = 75},
  [4273] = {.lex_state = 0},
  [4274] = {.lex_state = 9},
  [4275] = {.lex_state = 9},
  [4276] = {.lex_state = 0},
  [4277] = {.lex_state = 0},
  [4278] = {.lex_state = 9},
  [4279] = {.lex_state = 0, .external_lex_state = 4},
  [4280] = {.lex_state = 0, .external_lex_state = 4},
  [4281] = {.lex_state = 9},
  [4282] = {.lex_state = 9},
  [4283] = {.lex_state = 75},
  [4284] = {.lex_state = 0, .external_lex_state = 4},
  [4285] = {.lex_state = 9},
  [4286] = {.lex_state = 75},
  [4287] = {.lex_state = 0},
  [4288] = {.lex_state = 9},
  [4289] = {.lex_state = 0},
  [4290] = {.lex_state = 0},
  [4291] = {.lex_state = 9},
  [4292] = {.lex_state = 0},
  [4293] = {.lex_state = 9},
  [4294] = {.lex_state = 9},
  [4295] = {.lex_state = 9},
  [4296] = {.lex_state = 9},
  [4297] = {.lex_state = 9},
  [4298] = {.lex_state = 9},
  [4299] = {.lex_state = 9},
  [4300] = {.lex_state = 9},
  [4301] = {.lex_state = 0},
  [4302] = {.lex_state = 75},
  [4303] = {.lex_state = 0, .external_lex_state = 4},
  [4304] = {.lex_state = 75},
  [4305] = {.lex_state = 0},
  [4306] = {.lex_state = 0},
  [4307] = {.lex_state = 75},
  [4308] = {.lex_state = 75},
  [4309] = {.lex_state = 9},
  [4310] = {.lex_state = 9},
  [4311] = {.lex_state = 0},
  [4312] = {.lex_state = 0, .external_lex_state = 4},
  [4313] = {.lex_state = 0},
  [4314] = {.lex_state = 0},
  [4315] = {.lex_state = 9},
  [4316] = {.lex_state = 0},
  [4317] = {.lex_state = 0},
  [4318] = {.lex_state = 9},
  [4319] = {.lex_state = 9},
  [4320] = {.lex_state = 9},
  [4321] = {.lex_state = 9},
  [4322] = {.lex_state = 9},
  [4323] = {.lex_state = 9},
  [4324] = {.lex_state = 9},
  [4325] = {.lex_state = 9},
  [4326] = {.lex_state = 0},
  [4327] = {.lex_state = 0, .external_lex_state = 4},
  [4328] = {.lex_state = 9},
  [4329] = {.lex_state = 0},
  [4330] = {.lex_state = 0, .external_lex_state = 4},
  [4331] = {.lex_state = 9},
  [4332] = {.lex_state = 0, .external_lex_state = 4},
  [4333] = {.lex_state = 75},
  [4334] = {.lex_state = 0},
  [4335] = {.lex_state = 0, .external_lex_state = 4},
  [4336] = {.lex_state = 0, .external_lex_state = 4},
  [4337] = {.lex_state = 9},
  [4338] = {.lex_state = 9},
  [4339] = {.lex_state = 0},
  [4340] = {.lex_state = 0, .external_lex_state = 4},
  [4341] = {.lex_state = 0, .external_lex_state = 4},
  [4342] = {.lex_state = 0},
  [4343] = {.lex_state = 9},
  [4344] = {.lex_state = 0},
  [4345] = {.lex_state = 0, .external_lex_state = 4},
  [4346] = {.lex_state = 0},
  [4347] = {.lex_state = 0},
  [4348] = {.lex_state = 9},
  [4349] = {.lex_state = 0},
  [4350] = {.lex_state = 0},
  [4351] = {.lex_state = 9},
  [4352] = {.lex_state = 9},
  [4353] = {.lex_state = 0, .external_lex_state = 4},
  [4354] = {.lex_state = 0},
  [4355] = {.lex_state = 0},
  [4356] = {.lex_state = 0},
  [4357] = {.lex_state = 0, .external_lex_state = 4},
  [4358] = {.lex_state = 75},
  [4359] = {.lex_state = 0, .external_lex_state = 4},
  [4360] = {.lex_state = 0},
  [4361] = {.lex_state = 0, .external_lex_state = 4},
  [4362] = {.lex_state = 75},
  [4363] = {.lex_state = 0, .external_lex_state = 4},
  [4364] = {.lex_state = 75},
  [4365] = {.lex_state = 75},
  [4366] = {.lex_state = 0},
  [4367] = {.lex_state = 9},
  [4368] = {.lex_state = 9},
  [4369] = {.lex_state = 9},
  [4370] = {.lex_state = 75},
  [4371] = {.lex_state = 0},
  [4372] = {.lex_state = 0},
  [4373] = {.lex_state = 9},
  [4374] = {.lex_state = 9},
  [4375] = {.lex_state = 9},
  [4376] = {.lex_state = 0, .external_lex_state = 4},
  [4377] = {.lex_state = 0, .external_lex_state = 4},
  [4378] = {.lex_state = 0},
  [4379] = {.lex_state = 0},
  [4380] = {.lex_state = 0, .external_lex_state = 4},
  [4381] = {.lex_state = 0, .external_lex_state = 4},
  [4382] = {.lex_state = 75},
  [4383] = {.lex_state = 9},
  [4384] = {.lex_state = 75},
  [4385] = {.lex_state = 0, .external_lex_state = 4},
  [4386] = {.lex_state = 0},
  [4387] = {.lex_state = 0},
  [4388] = {.lex_state = 75},
  [4389] = {.lex_state = 0, .external_lex_state = 4},
  [4390] = {.lex_state = 9},
  [4391] = {.lex_state = 9},
  [4392] = {.lex_state = 9},
  [4393] = {.lex_state = 9},
  [4394] = {.lex_state = 0, .external_lex_state = 4},
  [4395] = {.lex_state = 9},
  [4396] = {.lex_state = 0, .external_lex_state = 4},
  [4397] = {.lex_state = 0},
  [4398] = {.lex_state = 0},
  [4399] = {.lex_state = 0, .external_lex_state = 4},
  [4400] = {.lex_state = 0},
  [4401] = {.lex_state = 9},
  [4402] = {.lex_state = 9},
  [4403] = {.lex_state = 0},
  [4404] = {.lex_state = 9},
  [4405] = {.lex_state = 9},
  [4406] = {.lex_state = 0},
  [4407] = {.lex_state = 0},
  [4408] = {.lex_state = 0, .external_lex_state = 4},
  [4409] = {.lex_state = 0},
  [4410] = {.lex_state = 0},
  [4411] = {.lex_state = 75},
  [4412] = {.lex_state = 9},
  [4413] = {.lex_state = 0},
  [4414] = {.lex_state = 0},
  [4415] = {.lex_state = 9},
  [4416] = {.lex_state = 0},
  [4417] = {.lex_state = 75},
  [4418] = {.lex_state = 0},
  [4419] = {.lex_state = 0},
  [4420] = {.lex_state = 9},
  [4421] = {.lex_state = 9},
  [4422] = {.lex_state = 0},
  [4423] = {.lex_state = 9},
  [4424] = {.lex_state = 75},
  [4425] = {.lex_state = 0, .external_lex_state = 4},
  [4426] = {.lex_state = 0},
  [4427] = {.lex_state = 75},
  [4428] = {.lex_state = 0, .external_lex_state = 4},
  [4429] = {.lex_state = 0},
  [4430] = {.lex_state = 0, .external_lex_state = 4},
  [4431] = {.lex_state = 0},
  [4432] = {.lex_state = 9},
  [4433] = {.lex_state = 0},
  [4434] = {.lex_state = 9},
  [4435] = {.lex_state = 0},
  [4436] = {.lex_state = 0},
  [4437] = {.lex_state = 9},
  [4438] = {.lex_state = 9},
  [4439] = {.lex_state = 9},
  [4440] = {.lex_state = 0},
  [4441] = {.lex_state = 0},
  [4442] = {.lex_state = 9},
  [4443] = {.lex_state = 75},
  [4444] = {.lex_state = 9},
  [4445] = {.lex_state = 0, .external_lex_state = 4},
  [4446] = {.lex_state = 9},
  [4447] = {.lex_state = 0},
  [4448] = {.lex_state = 9},
  [4449] = {.lex_state = 0},
  [4450] = {.lex_state = 0, .external_lex_state = 4},
  [4451] = {.lex_state = 0},
  [4452] = {.lex_state = 75},
  [4453] = {.lex_state = 9},
  [4454] = {.lex_state = 0},
  [4455] = {.lex_state = 0},
  [4456] = {.lex_state = 0, .external_lex_state = 4},
  [4457] = {.lex_state = 0, .external_lex_state = 4},
  [4458] = {.lex_state = 75},
  [4459] = {.lex_state = 9},
  [4460] = {.lex_state = 9},
  [4461] = {.lex_state = 9},
  [4462] = {.lex_state = 9},
  [4463] = {.lex_state = 0},
  [4464] = {.lex_state = 9},
  [4465] = {.lex_state = 9},
  [4466] = {.lex_state = 9},
  [4467] = {.lex_state = 9},
  [4468] = {.lex_state = 9},
  [4469] = {.lex_state = 9},
  [4470] = {.lex_state = 75},
  [4471] = {.lex_state = 0, .external_lex_state = 4},
  [4472] = {.lex_state = 75},
  [4473] = {.lex_state = 9},
  [4474] = {.lex_state = 0},
  [4475] = {.lex_state = 9},
  [4476] = {.lex_state = 0, .external_lex_state = 4},
  [4477] = {.lex_state = 9},
  [4478] = {.lex_state = 9},
  [4479] = {.lex_state = 0},
  [4480] = {.lex_state = 9},
  [4481] = {.lex_state = 0},
  [4482] = {.lex_state = 0},
  [4483] = {.lex_state = 75},
  [4484] = {.lex_state = 9},
  [4485] = {.lex_state = 9},
  [4486] = {.lex_state = 9},
  [4487] = {.lex_state = 0},
  [4488] = {.lex_state = 0},
  [4489] = {.lex_state = 0},
  [4490] = {.lex_state = 9},
  [4491] = {.lex_state = 0},
  [4492] = {.lex_state = 9},
  [4493] = {.lex_state = 9},
  [4494] = {.lex_state = 9},
  [4495] = {.lex_state = 9},
  [4496] = {.lex_state = 0},
  [4497] = {.lex_state = 9},
  [4498] = {.lex_state = 9},
  [4499] = {.lex_state = 0},
  [4500] = {.lex_state = 9},
  [4501] = {.lex_state = 0},
  [4502] = {.lex_state = 0},
  [4503] = {.lex_state = 75},
  [4504] = {.lex_state = 9},
  [4505] = {.lex_state = 9},
  [4506] = {.lex_state = 0},
  [4507] = {.lex_state = 0},
  [4508] = {.lex_state = 9},
  [4509] = {.lex_state = 9},
  [4510] = {.lex_state = 9},
  [4511] = {.lex_state = 0, .external_lex_state = 4},
  [4512] = {.lex_state = 0, .external_lex_state = 4},
  [4513] = {.lex_state = 0, .external_lex_state = 4},
  [4514] = {.lex_state = 9},
  [4515] = {.lex_state = 0},
  [4516] = {.lex_state = 0},
  [4517] = {.lex_state = 0, .external_lex_state = 4},
  [4518] = {.lex_state = 9},
  [4519] = {.lex_state = 0},
  [4520] = {.lex_state = 75},
  [4521] = {.lex_state = 0, .external_lex_state = 4},
  [4522] = {.lex_state = 9},
  [4523] = {.lex_state = 9},
  [4524] = {.lex_state = 0, .external_lex_state = 4},
  [4525] = {.lex_state = 75},
  [4526] = {.lex_state = 0},
  [4527] = {.lex_state = 9},
  [4528] = {.lex_state = 9},
  [4529] = {.lex_state = 0, .external_lex_state = 4},
  [4530] = {.lex_state = 0},
  [4531] = {.lex_state = 0},
  [4532] = {.lex_state = 11},
  [4533] = {.lex_state = 0, .external_lex_state = 4},
  [4534] = {.lex_state = 0, .external_lex_state = 4},
  [4535] = {.lex_state = 0, .external_lex_state = 4},
  [4536] = {.lex_state = 0, .external_lex_state = 4},
  [4537] = {.lex_state = 0, .external_lex_state = 4},
  [4538] = {.lex_state = 9},
  [4539] = {.lex_state = 9},
  [4540] = {.lex_state = 0, .external_lex_state = 4},
  [4541] = {.lex_state = 0},
  [4542] = {.lex_state = 9},
  [4543] = {.lex_state = 0},
  [4544] = {.lex_state = 0, .external_lex_state = 4},
  [4545] = {.lex_state = 0, .external_lex_state = 4},
  [4546] = {.lex_state = 9},
  [4547] = {.lex_state = 0},
  [4548] = {.lex_state = 9},
  [4549] = {.lex_state = 9},
  [4550] = {.lex_state = 9},
  [4551] = {.lex_state = 9},
  [4552] = {.lex_state = 0},
  [4553] = {.lex_state = 75},
  [4554] = {.lex_state = 75},
  [4555] = {.lex_state = 75},
  [4556] = {.lex_state = 0, .external_lex_state = 4},
  [4557] = {.lex_state = 75},
  [4558] = {.lex_state = 75},
  [4559] = {.lex_state = 75},
  [4560] = {.lex_state = 9},
  [4561] = {.lex_state = 9},
  [4562] = {.lex_state = 75},
  [4563] = {.lex_state = 9},
  [4564] = {.lex_state = 75},
  [4565] = {.lex_state = 0},
  [4566] = {.lex_state = 9},
  [4567] = {.lex_state = 0},
  [4568] = {.lex_state = 0, .external_lex_state = 4},
  [4569] = {.lex_state = 9},
  [4570] = {.lex_state = 9},
  [4571] = {.lex_state = 9},
  [4572] = {.lex_state = 75},
  [4573] = {.lex_state = 9},
  [4574] = {.lex_state = 9},
  [4575] = {.lex_state = 9},
  [4576] = {.lex_state = 75},
  [4577] = {.lex_state = 75},
  [4578] = {.lex_state = 9},
  [4579] = {.lex_state = 0, .external_lex_state = 4},
  [4580] = {.lex_state = 9},
  [4581] = {.lex_state = 9},
  [4582] = {.lex_state = 9},
  [4583] = {.lex_state = 0},
  [4584] = {.lex_state = 0},
  [4585] = {.lex_state = 0, .external_lex_state = 4},
  [4586] = {.lex_state = 9},
  [4587] = {.lex_state = 0},
  [4588] = {.lex_state = 0, .external_lex_state = 4},
  [4589] = {.lex_state = 0},
  [4590] = {.lex_state = 0, .external_lex_state = 4},
  [4591] = {.lex_state = 0, .external_lex_state = 4},
  [4592] = {.lex_state = 0},
  [4593] = {.lex_state = 75},
  [4594] = {.lex_state = 0, .external_lex_state = 4},
  [4595] = {.lex_state = 9},
  [4596] = {.lex_state = 9},
  [4597] = {.lex_state = 0, .external_lex_state = 4},
  [4598] = {.lex_state = 0, .external_lex_state = 4},
  [4599] = {.lex_state = 0, .external_lex_state = 4},
  [4600] = {.lex_state = 0},
  [4601] = {.lex_state = 0, .external_lex_state = 4},
  [4602] = {.lex_state = 0},
  [4603] = {.lex_state = 0},
  [4604] = {.lex_state = 9},
  [4605] = {.lex_state = 0, .external_lex_state = 4},
  [4606] = {.lex_state = 0, .external_lex_state = 4},
  [4607] = {.lex_state = 0, .external_lex_state = 4},
  [4608] = {.lex_state = 9},
  [4609] = {.lex_state = 0, .external_lex_state = 4},
  [4610] = {.lex_state = 9},
  [4611] = {.lex_state = 9},
  [4612] = {.lex_state = 0},
  [4613] = {.lex_state = 0, .external_lex_state = 4},
  [4614] = {.lex_state = 9},
  [4615] = {.lex_state = 9},
  [4616] = {.lex_state = 9},
  [4617] = {.lex_state = 9},
  [4618] = {.lex_state = 9},
  [4619] = {.lex_state = 9},
  [4620] = {.lex_state = 9},
  [4621] = {.lex_state = 9},
  [4622] = {.lex_state = 9},
  [4623] = {.lex_state = 9},
  [4624] = {.lex_state = 0},
  [4625] = {.lex_state = 0},
  [4626] = {.lex_state = 75},
  [4627] = {.lex_state = 75},
  [4628] = {.lex_state = 0},
  [4629] = {.lex_state = 75},
  [4630] = {.lex_state = 0},
  [4631] = {.lex_state = 0},
  [4632] = {.lex_state = 75},
  [4633] = {.lex_state = 0},
  [4634] = {.lex_state = 0},
  [4635] = {.lex_state = 0},
  [4636] = {.lex_state = 0},
  [4637] = {.lex_state = 0},
  [4638] = {.lex_state = 0},
  [4639] = {.lex_state = 0},
  [4640] = {.lex_state = 3},
  [4641] = {.lex_state = 1},
  [4642] = {.lex_state = 0},
  [4643] = {.lex_state = 0},
  [4644] = {.lex_state = 0},
  [4645] = {.lex_state = 0},
  [4646] = {.lex_state = 75},
  [4647] = {.lex_state = 75},
  [4648] = {.lex_state = 0},
  [4649] = {.lex_state = 75},
  [4650] = {.lex_state = 0},
  [4651] = {.lex_state = 0},
  [4652] = {.lex_state = 0},
  [4653] = {.lex_state = 0},
  [4654] = {.lex_state = 75},
  [4655] = {.lex_state = 75},
  [4656] = {.lex_state = 75},
  [4657] = {.lex_state = 75},
  [4658] = {.lex_state = 0},
  [4659] = {.lex_state = 75},
  [4660] = {.lex_state = 0},
  [4661] = {.lex_state = 0},
  [4662] = {.lex_state = 0},
  [4663] = {.lex_state = 0},
  [4664] = {.lex_state = 0},
  [4665] = {.lex_state = 75},
  [4666] = {.lex_state = 0},
  [4667] = {.lex_state = 75},
  [4668] = {.lex_state = 75},
  [4669] = {.lex_state = 0},
  [4670] = {.lex_state = 0},
  [4671] = {.lex_state = 0},
  [4672] = {.lex_state = 75},
  [4673] = {.lex_state = 0},
  [4674] = {.lex_state = 0},
  [4675] = {.lex_state = 75},
  [4676] = {.lex_state = 0},
  [4677] = {.lex_state = 9},
  [4678] = {.lex_state = 0},
  [4679] = {.lex_state = 0},
  [4680] = {.lex_state = 0},
  [4681] = {.lex_state = 0},
  [4682] = {.lex_state = 0},
  [4683] = {.lex_state = 75},
  [4684] = {.lex_state = 0},
  [4685] = {.lex_state = 0},
  [4686] = {.lex_state = 0},
  [4687] = {.lex_state = 0},
  [4688] = {.lex_state = 0},
  [4689] = {.lex_state = 0},
  [4690] = {.lex_state = 0},
  [4691] = {.lex_state = 75},
  [4692] = {.lex_state = 75},
  [4693] = {.lex_state = 75},
  [4694] = {.lex_state = 0},
  [4695] = {.lex_state = 0},
  [4696] = {.lex_state = 75},
  [4697] = {.lex_state = 0},
  [4698] = {.lex_state = 0},
  [4699] = {.lex_state = 0},
  [4700] = {.lex_state = 0},
  [4701] = {.lex_state = 0},
  [4702] = {.lex_state = 0},
  [4703] = {.lex_state = 0},
  [4704] = {.lex_state = 0},
  [4705] = {.lex_state = 0},
  [4706] = {.lex_state = 75},
  [4707] = {.lex_state = 0},
  [4708] = {.lex_state = 0},
  [4709] = {.lex_state = 9},
  [4710] = {.lex_state = 0},
  [4711] = {.lex_state = 0},
  [4712] = {.lex_state = 0},
  [4713] = {.lex_state = 75},
  [4714] = {.lex_state = 0},
  [4715] = {.lex_state = 0},
  [4716] = {.lex_state = 0},
  [4717] = {.lex_state = 0},
  [4718] = {.lex_state = 0},
  [4719] = {.lex_state = 0},
  [4720] = {.lex_state = 75},
  [4721] = {.lex_state = 0},
  [4722] = {.lex_state = 0},
  [4723] = {.lex_state = 0},
  [4724] = {.lex_state = 0},
  [4725] = {.lex_state = 0},
  [4726] = {.lex_state = 0},
  [4727] = {.lex_state = 0},
  [4728] = {.lex_state = 0},
  [4729] = {.lex_state = 0},
  [4730] = {.lex_state = 0},
  [4731] = {.lex_state = 0},
  [4732] = {.lex_state = 75},
  [4733] = {.lex_state = 75},
  [4734] = {.lex_state = 0},
  [4735] = {.lex_state = 0},
  [4736] = {.lex_state = 0},
  [4737] = {.lex_state = 3},
  [4738] = {.lex_state = 1},
  [4739] = {.lex_state = 0},
  [4740] = {.lex_state = 75},
  [4741] = {.lex_state = 0},
  [4742] = {.lex_state = 75},
  [4743] = {.lex_state = 75},
  [4744] = {.lex_state = 0},
  [4745] = {.lex_state = 0},
  [4746] = {.lex_state = 0},
  [4747] = {.lex_state = 0},
  [4748] = {.lex_state = 0},
  [4749] = {.lex_state = 0},
  [4750] = {.lex_state = 0},
  [4751] = {.lex_state = 0},
  [4752] = {.lex_state = 75},
  [4753] = {.lex_state = 0},
  [4754] = {.lex_state = 0},
  [4755] = {.lex_state = 0},
  [4756] = {.lex_state = 0},
  [4757] = {.lex_state = 75},
  [4758] = {.lex_state = 0},
  [4759] = {.lex_state = 75},
  [4760] = {.lex_state = 75},
  [4761] = {.lex_state = 75},
  [4762] = {.lex_state = 0},
  [4763] = {.lex_state = 0},
  [4764] = {.lex_state = 0},
  [4765] = {.lex_state = 0},
  [4766] = {.lex_state = 0},
  [4767] = {.lex_state = 0},
  [4768] = {.lex_state = 75},
  [4769] = {.lex_state = 9},
  [4770] = {.lex_state = 0},
  [4771] = {.lex_state = 0},
  [4772] = {.lex_state = 3},
  [4773] = {.lex_state = 1},
  [4774] = {.lex_state = 12},
  [4775] = {.lex_state = 0},
  [4776] = {.lex_state = 0},
  [4777] = {.lex_state = 0},
  [4778] = {.lex_state = 0},
  [4779] = {.lex_state = 75},
  [4780] = {.lex_state = 0},
  [4781] = {.lex_state = 0},
  [4782] = {.lex_state = 0},
  [4783] = {.lex_state = 75},
  [4784] = {.lex_state = 75},
  [4785] = {.lex_state = 0},
  [4786] = {.lex_state = 0},
  [4787] = {.lex_state = 75},
  [4788] = {.lex_state = 0},
  [4789] = {.lex_state = 0},
  [4790] = {.lex_state = 0},
  [4791] = {.lex_state = 0},
  [4792] = {.lex_state = 0},
  [4793] = {.lex_state = 0},
  [4794] = {.lex_state = 0},
  [4795] = {.lex_state = 0},
  [4796] = {.lex_state = 0},
  [4797] = {.lex_state = 0},
  [4798] = {.lex_state = 3},
  [4799] = {.lex_state = 75},
  [4800] = {.lex_state = 0},
  [4801] = {.lex_state = 0},
  [4802] = {.lex_state = 0},
  [4803] = {.lex_state = 0},
  [4804] = {.lex_state = 0},
  [4805] = {.lex_state = 75},
  [4806] = {.lex_state = 75},
  [4807] = {.lex_state = 75},
  [4808] = {.lex_state = 75},
  [4809] = {.lex_state = 0},
  [4810] = {.lex_state = 75},
  [4811] = {.lex_state = 75},
  [4812] = {.lex_state = 0},
  [4813] = {.lex_state = 75},
  [4814] = {.lex_state = 0},
  [4815] = {.lex_state = 0},
  [4816] = {.lex_state = 75},
  [4817] = {.lex_state = 0},
  [4818] = {.lex_state = 75},
  [4819] = {.lex_state = 0},
  [4820] = {.lex_state = 12},
  [4821] = {.lex_state = 75},
  [4822] = {.lex_state = 75},
  [4823] = {.lex_state = 75},
  [4824] = {.lex_state = 75},
  [4825] = {.lex_state = 75},
  [4826] = {.lex_state = 0},
  [4827] = {.lex_state = 0},
  [4828] = {.lex_state = 0},
  [4829] = {.lex_state = 0},
  [4830] = {.lex_state = 75},
  [4831] = {.lex_state = 75},
  [4832] = {.lex_state = 0},
  [4833] = {.lex_state = 75},
  [4834] = {.lex_state = 0},
  [4835] = {.lex_state = 75},
  [4836] = {.lex_state = 75},
  [4837] = {.lex_state = 0},
  [4838] = {.lex_state = 0},
  [4839] = {.lex_state = 75},
  [4840] = {.lex_state = 75},
  [4841] = {.lex_state = 75},
  [4842] = {.lex_state = 0},
  [4843] = {.lex_state = 0},
  [4844] = {.lex_state = 1},
  [4845] = {.lex_state = 0},
  [4846] = {.lex_state = 0},
  [4847] = {.lex_state = 3},
  [4848] = {.lex_state = 0},
  [4849] = {.lex_state = 0},
  [4850] = {.lex_state = 0},
  [4851] = {.lex_state = 0},
  [4852] = {.lex_state = 0},
  [4853] = {.lex_state = 0},
  [4854] = {.lex_state = 75},
  [4855] = {.lex_state = 0},
  [4856] = {.lex_state = 0},
  [4857] = {.lex_state = 0},
  [4858] = {.lex_state = 75},
  [4859] = {.lex_state = 75},
  [4860] = {.lex_state = 0},
  [4861] = {.lex_state = 0},
  [4862] = {.lex_state = 75},
  [4863] = {.lex_state = 75},
  [4864] = {.lex_state = 0},
  [4865] = {.lex_state = 0},
  [4866] = {.lex_state = 75},
  [4867] = {.lex_state = 0},
  [4868] = {.lex_state = 0},
  [4869] = {.lex_state = 12},
  [4870] = {.lex_state = 0},
  [4871] = {.lex_state = 0},
  [4872] = {.lex_state = 0},
  [4873] = {.lex_state = 0},
  [4874] = {.lex_state = 0},
  [4875] = {.lex_state = 0},
  [4876] = {.lex_state = 75},
  [4877] = {.lex_state = 75},
  [4878] = {.lex_state = 0},
  [4879] = {.lex_state = 0},
  [4880] = {.lex_state = 0},
  [4881] = {.lex_state = 0},
  [4882] = {.lex_state = 0},
  [4883] = {.lex_state = 0},
  [4884] = {.lex_state = 0},
  [4885] = {.lex_state = 75},
  [4886] = {.lex_state = 0},
  [4887] = {.lex_state = 75},
  [4888] = {.lex_state = 75},
  [4889] = {.lex_state = 75},
  [4890] = {.lex_state = 0},
  [4891] = {.lex_state = 0},
  [4892] = {.lex_state = 0},
  [4893] = {.lex_state = 75},
  [4894] = {.lex_state = 75},
  [4895] = {.lex_state = 0},
  [4896] = {.lex_state = 1},
  [4897] = {.lex_state = 0},
  [4898] = {.lex_state = 75},
  [4899] = {.lex_state = 12},
  [4900] = {.lex_state = 0},
  [4901] = {.lex_state = 0},
  [4902] = {.lex_state = 75},
  [4903] = {.lex_state = 3},
  [4904] = {.lex_state = 0},
  [4905] = {.lex_state = 0},
  [4906] = {.lex_state = 0},
  [4907] = {.lex_state = 75},
  [4908] = {.lex_state = 12},
  [4909] = {.lex_state = 0},
  [4910] = {.lex_state = 0},
  [4911] = {.lex_state = 0},
  [4912] = {.lex_state = 0},
  [4913] = {.lex_state = 0},
  [4914] = {.lex_state = 3},
  [4915] = {.lex_state = 9},
  [4916] = {.lex_state = 0},
  [4917] = {.lex_state = 75},
  [4918] = {.lex_state = 75},
  [4919] = {.lex_state = 0},
  [4920] = {.lex_state = 75},
  [4921] = {.lex_state = 0},
  [4922] = {.lex_state = 0},
  [4923] = {.lex_state = 0},
  [4924] = {.lex_state = 0},
  [4925] = {.lex_state = 75},
  [4926] = {.lex_state = 75},
  [4927] = {.lex_state = 0},
  [4928] = {.lex_state = 0},
  [4929] = {.lex_state = 0},
  [4930] = {.lex_state = 75},
  [4931] = {.lex_state = 75},
  [4932] = {.lex_state = 0},
  [4933] = {.lex_state = 0},
  [4934] = {.lex_state = 75},
  [4935] = {.lex_state = 0},
  [4936] = {.lex_state = 75},
  [4937] = {.lex_state = 75},
  [4938] = {.lex_state = 75},
  [4939] = {.lex_state = 0},
  [4940] = {.lex_state = 0},
  [4941] = {.lex_state = 75},
  [4942] = {.lex_state = 75},
  [4943] = {.lex_state = 75},
  [4944] = {.lex_state = 0},
  [4945] = {.lex_state = 0},
  [4946] = {.lex_state = 0},
  [4947] = {.lex_state = 0},
  [4948] = {.lex_state = 0},
  [4949] = {.lex_state = 75},
  [4950] = {.lex_state = 75},
  [4951] = {.lex_state = 75},
  [4952] = {.lex_state = 75},
  [4953] = {.lex_state = 0},
  [4954] = {.lex_state = 0},
  [4955] = {.lex_state = 0},
  [4956] = {.lex_state = 0},
  [4957] = {.lex_state = 75},
  [4958] = {.lex_state = 0},
  [4959] = {.lex_state = 0},
  [4960] = {.lex_state = 0},
  [4961] = {.lex_state = 0},
  [4962] = {.lex_state = 0},
  [4963] = {.lex_state = 0},
  [4964] = {.lex_state = 0},
  [4965] = {.lex_state = 0},
  [4966] = {.lex_state = 0},
  [4967] = {.lex_state = 75},
  [4968] = {.lex_state = 0},
  [4969] = {.lex_state = 0},
  [4970] = {.lex_state = 0},
  [4971] = {.lex_state = 75},
  [4972] = {.lex_state = 0},
  [4973] = {.lex_state = 0},
  [4974] = {.lex_state = 0},
  [4975] = {.lex_state = 75},
  [4976] = {.lex_state = 0},
  [4977] = {.lex_state = 75},
  [4978] = {.lex_state = 75},
  [4979] = {.lex_state = 0},
  [4980] = {.lex_state = 75},
  [4981] = {.lex_state = 0},
  [4982] = {.lex_state = 75},
  [4983] = {.lex_state = 75},
  [4984] = {.lex_state = 0},
  [4985] = {.lex_state = 0},
  [4986] = {.lex_state = 75},
  [4987] = {.lex_state = 0},
  [4988] = {.lex_state = 75},
  [4989] = {.lex_state = 0},
  [4990] = {.lex_state = 0},
  [4991] = {.lex_state = 75},
  [4992] = {.lex_state = 75},
  [4993] = {.lex_state = 0},
  [4994] = {.lex_state = 75},
  [4995] = {.lex_state = 75},
  [4996] = {.lex_state = 75},
  [4997] = {.lex_state = 0},
  [4998] = {.lex_state = 0},
  [4999] = {.lex_state = 0},
};

enum {
  ts_external_token__automatic_semicolon = 0,
  ts_external_token__template_chars = 1,
  ts_external_token__ternary_qmark = 2,
  ts_external_token_PIPE_PIPE = 3,
  ts_external_token__function_signature_automatic_semicolon = 4,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__automatic_semicolon] = sym__automatic_semicolon,
  [ts_external_token__template_chars] = sym__template_chars,
  [ts_external_token__ternary_qmark] = sym__ternary_qmark,
  [ts_external_token_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [ts_external_token__function_signature_automatic_semicolon] = sym__function_signature_automatic_semicolon,
};

static const bool ts_external_scanner_states[7][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__template_chars] = true,
    [ts_external_token__ternary_qmark] = true,
    [ts_external_token_PIPE_PIPE] = true,
    [ts_external_token__function_signature_automatic_semicolon] = true,
  },
  [2] = {
    [ts_external_token__ternary_qmark] = true,
    [ts_external_token_PIPE_PIPE] = true,
  },
  [3] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__ternary_qmark] = true,
    [ts_external_token_PIPE_PIPE] = true,
  },
  [4] = {
    [ts_external_token__automatic_semicolon] = true,
  },
  [5] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__function_signature_automatic_semicolon] = true,
  },
  [6] = {
    [ts_external_token__template_chars] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_private_property_identifier] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_any] = ACTIONS(1),
    [anon_sym_number] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_symbol] = ACTIONS(1),
    [anon_sym_property] = ACTIONS(1),
    [anon_sym_signal] = ACTIONS(1),
    [anon_sym_on] = ACTIONS(1),
    [anon_sym_required] = ACTIONS(1),
    [anon_sym_component] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_require] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_DASH_QMARK_COLON] = ACTIONS(1),
    [anon_sym_asserts] = ACTIONS(1),
    [anon_sym_infer] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_keyof] = ACTIONS(1),
    [anon_sym_unknown] = ACTIONS(1),
    [anon_sym_never] = ACTIONS(1),
    [anon_sym_object] = ACTIONS(1),
    [anon_sym_LBRACE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_RBRACE] = ACTIONS(1),
    [anon_sym_pragma] = ACTIONS(1),
    [aux_sym_ui_version_specifier_token1] = ACTIONS(1),
    [anon_sym_list] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
    [sym__ternary_qmark] = ACTIONS(1),
    [sym__function_signature_automatic_semicolon] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(4993),
    [sym_ui_pragma] = STATE(2360),
    [sym_ui_import] = STATE(2360),
    [sym_ui_object_definition] = STATE(4990),
    [sym_ui_annotated_object] = STATE(4990),
    [sym_ui_annotation] = STATE(2748),
    [sym_ui_nested_identifier] = STATE(3985),
    [aux_sym_program_repeat1] = STATE(2360),
    [aux_sym_ui_annotated_object_repeat1] = STATE(2749),
    [sym_identifier] = ACTIONS(5),
    [sym_hash_bang_line] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(9),
    [anon_sym_type] = ACTIONS(9),
    [anon_sym_namespace] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(9),
    [anon_sym_of] = ACTIONS(9),
    [anon_sym_async] = ACTIONS(9),
    [sym_comment] = ACTIONS(3),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_static] = ACTIONS(9),
    [anon_sym_readonly] = ACTIONS(9),
    [anon_sym_get] = ACTIONS(9),
    [anon_sym_set] = ACTIONS(9),
    [anon_sym_declare] = ACTIONS(9),
    [anon_sym_public] = ACTIONS(9),
    [anon_sym_private] = ACTIONS(9),
    [anon_sym_protected] = ACTIONS(9),
    [anon_sym_override] = ACTIONS(9),
    [anon_sym_module] = ACTIONS(9),
    [anon_sym_any] = ACTIONS(9),
    [anon_sym_number] = ACTIONS(9),
    [anon_sym_boolean] = ACTIONS(9),
    [anon_sym_string] = ACTIONS(9),
    [anon_sym_symbol] = ACTIONS(9),
    [anon_sym_property] = ACTIONS(9),
    [anon_sym_signal] = ACTIONS(9),
    [anon_sym_on] = ACTIONS(9),
    [anon_sym_required] = ACTIONS(9),
    [anon_sym_component] = ACTIONS(9),
    [anon_sym_pragma] = ACTIONS(15),
  },
  [2] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1163),
    [sym_expression] = STATE(2347),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3349),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3349),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4970),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1221),
    [sym_subscript_expression] = STATE(1221),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2849),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3349),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3549),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1221),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(2904),
    [sym_constructor_type] = STATE(2904),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(2904),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(422),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(2904),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(2904),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(17),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(30),
    [anon_sym_COMMA] = ACTIONS(32),
    [anon_sym_typeof] = ACTIONS(34),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(32),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(32),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_LT] = ACTIONS(49),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(56),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_EQ_GT] = ACTIONS(60),
    [anon_sym_QMARK_DOT] = ACTIONS(62),
    [anon_sym_new] = ACTIONS(64),
    [anon_sym_PLUS_EQ] = ACTIONS(66),
    [anon_sym_DASH_EQ] = ACTIONS(66),
    [anon_sym_STAR_EQ] = ACTIONS(66),
    [anon_sym_SLASH_EQ] = ACTIONS(66),
    [anon_sym_PERCENT_EQ] = ACTIONS(66),
    [anon_sym_CARET_EQ] = ACTIONS(66),
    [anon_sym_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_LT_LT_EQ] = ACTIONS(66),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(66),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(66),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(66),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(70),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(72),
    [anon_sym_PLUS] = ACTIONS(74),
    [anon_sym_DASH] = ACTIONS(74),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(62),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(62),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(62),
    [anon_sym_GT_EQ] = ACTIONS(62),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(76),
    [anon_sym_void] = ACTIONS(78),
    [anon_sym_delete] = ACTIONS(80),
    [anon_sym_PLUS_PLUS] = ACTIONS(82),
    [anon_sym_DASH_DASH] = ACTIONS(82),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(103),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(107),
    [anon_sym_number] = ACTIONS(107),
    [anon_sym_boolean] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_symbol] = ACTIONS(107),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
    [sym__ternary_qmark] = ACTIONS(62),
  },
  [3] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1163),
    [sym_expression] = STATE(2347),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3349),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3349),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4970),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1221),
    [sym_subscript_expression] = STATE(1221),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2849),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3349),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3549),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1221),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(2904),
    [sym_constructor_type] = STATE(2904),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(2904),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(422),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(2904),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(2904),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(17),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(119),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(30),
    [anon_sym_COMMA] = ACTIONS(122),
    [anon_sym_typeof] = ACTIONS(34),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(122),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(122),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_LT] = ACTIONS(49),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(56),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_QMARK_DOT] = ACTIONS(62),
    [anon_sym_new] = ACTIONS(64),
    [anon_sym_PLUS_EQ] = ACTIONS(66),
    [anon_sym_DASH_EQ] = ACTIONS(66),
    [anon_sym_STAR_EQ] = ACTIONS(66),
    [anon_sym_SLASH_EQ] = ACTIONS(66),
    [anon_sym_PERCENT_EQ] = ACTIONS(66),
    [anon_sym_CARET_EQ] = ACTIONS(66),
    [anon_sym_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_LT_LT_EQ] = ACTIONS(66),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(66),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(66),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(66),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(70),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(72),
    [anon_sym_PLUS] = ACTIONS(74),
    [anon_sym_DASH] = ACTIONS(74),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(62),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(62),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(62),
    [anon_sym_GT_EQ] = ACTIONS(62),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(76),
    [anon_sym_void] = ACTIONS(78),
    [anon_sym_delete] = ACTIONS(80),
    [anon_sym_PLUS_PLUS] = ACTIONS(82),
    [anon_sym_DASH_DASH] = ACTIONS(82),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(93),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(103),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(107),
    [anon_sym_number] = ACTIONS(107),
    [anon_sym_boolean] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_symbol] = ACTIONS(107),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
    [sym__ternary_qmark] = ACTIONS(62),
  },
  [4] = {
    [sym_export_statement] = STATE(21),
    [sym_declaration] = STATE(21),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(21),
    [sym_expression_statement] = STATE(21),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(21),
    [sym_if_statement] = STATE(21),
    [sym_switch_statement] = STATE(21),
    [sym_for_statement] = STATE(21),
    [sym_for_in_statement] = STATE(21),
    [sym_while_statement] = STATE(21),
    [sym_do_statement] = STATE(21),
    [sym_try_statement] = STATE(21),
    [sym_with_statement] = STATE(21),
    [sym_break_statement] = STATE(21),
    [sym_continue_statement] = STATE(21),
    [sym_debugger_statement] = STATE(21),
    [sym_return_statement] = STATE(21),
    [sym_throw_statement] = STATE(21),
    [sym_empty_statement] = STATE(21),
    [sym_labeled_statement] = STATE(21),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4804),
    [sym_object_assignment_pattern] = STATE(3991),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4804),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4804),
    [sym_spread_element] = STATE(4054),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2168),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_rest_pattern] = STATE(3991),
    [sym_method_definition] = STATE(4054),
    [sym_pair] = STATE(4054),
    [sym_pair_pattern] = STATE(3991),
    [sym__property_name] = STATE(3325),
    [sym_computed_property_name] = STATE(3325),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_accessibility_modifier] = STATE(2447),
    [sym_override_modifier] = STATE(2476),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(21),
    [aux_sym_object_repeat1] = STATE(3982),
    [aux_sym_object_pattern_repeat1] = STATE(3992),
    [sym_identifier] = ACTIONS(127),
    [anon_sym_export] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_type] = ACTIONS(133),
    [anon_sym_namespace] = ACTIONS(135),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_COMMA] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(141),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(147),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(147),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(189),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(197),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(213),
    [sym_private_property_identifier] = ACTIONS(215),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(221),
    [anon_sym_readonly] = ACTIONS(223),
    [anon_sym_get] = ACTIONS(225),
    [anon_sym_set] = ACTIONS(225),
    [anon_sym_declare] = ACTIONS(227),
    [anon_sym_public] = ACTIONS(229),
    [anon_sym_private] = ACTIONS(229),
    [anon_sym_protected] = ACTIONS(229),
    [anon_sym_override] = ACTIONS(231),
    [anon_sym_module] = ACTIONS(233),
    [anon_sym_any] = ACTIONS(147),
    [anon_sym_number] = ACTIONS(147),
    [anon_sym_boolean] = ACTIONS(147),
    [anon_sym_string] = ACTIONS(147),
    [anon_sym_symbol] = ACTIONS(147),
    [anon_sym_property] = ACTIONS(147),
    [anon_sym_signal] = ACTIONS(147),
    [anon_sym_on] = ACTIONS(147),
    [anon_sym_required] = ACTIONS(147),
    [anon_sym_component] = ACTIONS(147),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [5] = {
    [sym_export_statement] = STATE(23),
    [sym_declaration] = STATE(23),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4804),
    [sym_object_assignment_pattern] = STATE(3991),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4804),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4804),
    [sym_spread_element] = STATE(4003),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2168),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_rest_pattern] = STATE(3991),
    [sym_method_definition] = STATE(4003),
    [sym_pair] = STATE(4003),
    [sym_pair_pattern] = STATE(3991),
    [sym__property_name] = STATE(3325),
    [sym_computed_property_name] = STATE(3325),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_accessibility_modifier] = STATE(2447),
    [sym_override_modifier] = STATE(2476),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(23),
    [aux_sym_object_repeat1] = STATE(4005),
    [aux_sym_object_pattern_repeat1] = STATE(3992),
    [sym_identifier] = ACTIONS(241),
    [anon_sym_export] = ACTIONS(243),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_type] = ACTIONS(245),
    [anon_sym_namespace] = ACTIONS(247),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_COMMA] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(249),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(251),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(251),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(189),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(253),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(213),
    [sym_private_property_identifier] = ACTIONS(215),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(255),
    [anon_sym_readonly] = ACTIONS(257),
    [anon_sym_get] = ACTIONS(259),
    [anon_sym_set] = ACTIONS(259),
    [anon_sym_declare] = ACTIONS(261),
    [anon_sym_public] = ACTIONS(263),
    [anon_sym_private] = ACTIONS(263),
    [anon_sym_protected] = ACTIONS(263),
    [anon_sym_override] = ACTIONS(265),
    [anon_sym_module] = ACTIONS(267),
    [anon_sym_any] = ACTIONS(251),
    [anon_sym_number] = ACTIONS(251),
    [anon_sym_boolean] = ACTIONS(251),
    [anon_sym_string] = ACTIONS(251),
    [anon_sym_symbol] = ACTIONS(251),
    [anon_sym_property] = ACTIONS(251),
    [anon_sym_signal] = ACTIONS(251),
    [anon_sym_on] = ACTIONS(251),
    [anon_sym_required] = ACTIONS(251),
    [anon_sym_component] = ACTIONS(251),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [6] = {
    [sym_export_statement] = STATE(23),
    [sym_declaration] = STATE(23),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4804),
    [sym_object_assignment_pattern] = STATE(3991),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4804),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4804),
    [sym_spread_element] = STATE(4003),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2168),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_rest_pattern] = STATE(3991),
    [sym_method_definition] = STATE(4003),
    [sym_pair] = STATE(4003),
    [sym_pair_pattern] = STATE(3991),
    [sym__property_name] = STATE(3325),
    [sym_computed_property_name] = STATE(3325),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_accessibility_modifier] = STATE(2447),
    [sym_override_modifier] = STATE(2476),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(23),
    [aux_sym_object_repeat1] = STATE(4005),
    [aux_sym_object_pattern_repeat1] = STATE(3992),
    [sym_identifier] = ACTIONS(269),
    [anon_sym_export] = ACTIONS(271),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_type] = ACTIONS(273),
    [anon_sym_namespace] = ACTIONS(275),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_COMMA] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(249),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(277),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(277),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(189),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(279),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(213),
    [sym_private_property_identifier] = ACTIONS(215),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(283),
    [anon_sym_get] = ACTIONS(285),
    [anon_sym_set] = ACTIONS(285),
    [anon_sym_declare] = ACTIONS(287),
    [anon_sym_public] = ACTIONS(289),
    [anon_sym_private] = ACTIONS(289),
    [anon_sym_protected] = ACTIONS(289),
    [anon_sym_override] = ACTIONS(291),
    [anon_sym_module] = ACTIONS(293),
    [anon_sym_any] = ACTIONS(277),
    [anon_sym_number] = ACTIONS(277),
    [anon_sym_boolean] = ACTIONS(277),
    [anon_sym_string] = ACTIONS(277),
    [anon_sym_symbol] = ACTIONS(277),
    [anon_sym_property] = ACTIONS(277),
    [anon_sym_signal] = ACTIONS(277),
    [anon_sym_on] = ACTIONS(277),
    [anon_sym_required] = ACTIONS(277),
    [anon_sym_component] = ACTIONS(277),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [7] = {
    [sym_export_statement] = STATE(31),
    [sym_declaration] = STATE(31),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(31),
    [sym_expression_statement] = STATE(31),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(31),
    [sym_if_statement] = STATE(31),
    [sym_switch_statement] = STATE(31),
    [sym_for_statement] = STATE(31),
    [sym_for_in_statement] = STATE(31),
    [sym_while_statement] = STATE(31),
    [sym_do_statement] = STATE(31),
    [sym_try_statement] = STATE(31),
    [sym_with_statement] = STATE(31),
    [sym_break_statement] = STATE(31),
    [sym_continue_statement] = STATE(31),
    [sym_debugger_statement] = STATE(31),
    [sym_return_statement] = STATE(31),
    [sym_throw_statement] = STATE(31),
    [sym_empty_statement] = STATE(31),
    [sym_labeled_statement] = STATE(31),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4804),
    [sym_object_assignment_pattern] = STATE(3991),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4804),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4804),
    [sym_spread_element] = STATE(4054),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2168),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_rest_pattern] = STATE(3991),
    [sym_method_definition] = STATE(4054),
    [sym_pair] = STATE(4054),
    [sym_pair_pattern] = STATE(3991),
    [sym__property_name] = STATE(3325),
    [sym_computed_property_name] = STATE(3325),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_accessibility_modifier] = STATE(2447),
    [sym_override_modifier] = STATE(2476),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(31),
    [aux_sym_object_repeat1] = STATE(3982),
    [aux_sym_object_pattern_repeat1] = STATE(3992),
    [sym_identifier] = ACTIONS(127),
    [anon_sym_export] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_type] = ACTIONS(133),
    [anon_sym_namespace] = ACTIONS(135),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_COMMA] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(295),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(147),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(147),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(189),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(197),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(213),
    [sym_private_property_identifier] = ACTIONS(215),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(221),
    [anon_sym_readonly] = ACTIONS(223),
    [anon_sym_get] = ACTIONS(225),
    [anon_sym_set] = ACTIONS(225),
    [anon_sym_declare] = ACTIONS(227),
    [anon_sym_public] = ACTIONS(229),
    [anon_sym_private] = ACTIONS(229),
    [anon_sym_protected] = ACTIONS(229),
    [anon_sym_override] = ACTIONS(231),
    [anon_sym_module] = ACTIONS(233),
    [anon_sym_any] = ACTIONS(147),
    [anon_sym_number] = ACTIONS(147),
    [anon_sym_boolean] = ACTIONS(147),
    [anon_sym_string] = ACTIONS(147),
    [anon_sym_symbol] = ACTIONS(147),
    [anon_sym_property] = ACTIONS(147),
    [anon_sym_signal] = ACTIONS(147),
    [anon_sym_on] = ACTIONS(147),
    [anon_sym_required] = ACTIONS(147),
    [anon_sym_component] = ACTIONS(147),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [8] = {
    [sym_export_statement] = STATE(17),
    [sym_declaration] = STATE(17),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_for_in_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_try_statement] = STATE(17),
    [sym_with_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_debugger_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_throw_statement] = STATE(17),
    [sym_empty_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4804),
    [sym_object_assignment_pattern] = STATE(3991),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4804),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4804),
    [sym_spread_element] = STATE(4054),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2168),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_rest_pattern] = STATE(3991),
    [sym_method_definition] = STATE(4054),
    [sym_pair] = STATE(4054),
    [sym_pair_pattern] = STATE(3991),
    [sym__property_name] = STATE(3325),
    [sym_computed_property_name] = STATE(3325),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_accessibility_modifier] = STATE(2447),
    [sym_override_modifier] = STATE(2476),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(17),
    [aux_sym_object_repeat1] = STATE(3982),
    [aux_sym_object_pattern_repeat1] = STATE(3992),
    [sym_identifier] = ACTIONS(127),
    [anon_sym_export] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_type] = ACTIONS(133),
    [anon_sym_namespace] = ACTIONS(135),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_COMMA] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(297),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(147),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(147),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(189),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(197),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(213),
    [sym_private_property_identifier] = ACTIONS(215),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(221),
    [anon_sym_readonly] = ACTIONS(223),
    [anon_sym_get] = ACTIONS(225),
    [anon_sym_set] = ACTIONS(225),
    [anon_sym_declare] = ACTIONS(227),
    [anon_sym_public] = ACTIONS(229),
    [anon_sym_private] = ACTIONS(229),
    [anon_sym_protected] = ACTIONS(229),
    [anon_sym_override] = ACTIONS(231),
    [anon_sym_module] = ACTIONS(233),
    [anon_sym_any] = ACTIONS(147),
    [anon_sym_number] = ACTIONS(147),
    [anon_sym_boolean] = ACTIONS(147),
    [anon_sym_string] = ACTIONS(147),
    [anon_sym_symbol] = ACTIONS(147),
    [anon_sym_property] = ACTIONS(147),
    [anon_sym_signal] = ACTIONS(147),
    [anon_sym_on] = ACTIONS(147),
    [anon_sym_required] = ACTIONS(147),
    [anon_sym_component] = ACTIONS(147),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [9] = {
    [sym_export_statement] = STATE(23),
    [sym_declaration] = STATE(23),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4804),
    [sym_object_assignment_pattern] = STATE(3991),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4804),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4804),
    [sym_spread_element] = STATE(4003),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2168),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_rest_pattern] = STATE(3991),
    [sym_method_definition] = STATE(4003),
    [sym_pair] = STATE(4003),
    [sym_pair_pattern] = STATE(3991),
    [sym__property_name] = STATE(3325),
    [sym_computed_property_name] = STATE(3325),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_accessibility_modifier] = STATE(2447),
    [sym_override_modifier] = STATE(2476),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(23),
    [aux_sym_object_repeat1] = STATE(4005),
    [aux_sym_object_pattern_repeat1] = STATE(3992),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_type] = ACTIONS(303),
    [anon_sym_namespace] = ACTIONS(305),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_COMMA] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(249),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(307),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(307),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(189),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(309),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(213),
    [sym_private_property_identifier] = ACTIONS(215),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(311),
    [anon_sym_readonly] = ACTIONS(313),
    [anon_sym_get] = ACTIONS(315),
    [anon_sym_set] = ACTIONS(315),
    [anon_sym_declare] = ACTIONS(317),
    [anon_sym_public] = ACTIONS(319),
    [anon_sym_private] = ACTIONS(319),
    [anon_sym_protected] = ACTIONS(319),
    [anon_sym_override] = ACTIONS(321),
    [anon_sym_module] = ACTIONS(323),
    [anon_sym_any] = ACTIONS(307),
    [anon_sym_number] = ACTIONS(307),
    [anon_sym_boolean] = ACTIONS(307),
    [anon_sym_string] = ACTIONS(307),
    [anon_sym_symbol] = ACTIONS(307),
    [anon_sym_property] = ACTIONS(307),
    [anon_sym_signal] = ACTIONS(307),
    [anon_sym_on] = ACTIONS(307),
    [anon_sym_required] = ACTIONS(307),
    [anon_sym_component] = ACTIONS(307),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [10] = {
    [sym_export_statement] = STATE(17),
    [sym_declaration] = STATE(17),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_for_in_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_try_statement] = STATE(17),
    [sym_with_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_debugger_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_throw_statement] = STATE(17),
    [sym_empty_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4804),
    [sym_object_assignment_pattern] = STATE(3991),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4804),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4804),
    [sym_spread_element] = STATE(4054),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2168),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_rest_pattern] = STATE(3991),
    [sym_method_definition] = STATE(4054),
    [sym_pair] = STATE(4054),
    [sym_pair_pattern] = STATE(3991),
    [sym__property_name] = STATE(3325),
    [sym_computed_property_name] = STATE(3325),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_accessibility_modifier] = STATE(2447),
    [sym_override_modifier] = STATE(2476),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(17),
    [aux_sym_object_repeat1] = STATE(3982),
    [aux_sym_object_pattern_repeat1] = STATE(3992),
    [sym_identifier] = ACTIONS(127),
    [anon_sym_export] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_type] = ACTIONS(133),
    [anon_sym_namespace] = ACTIONS(135),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_COMMA] = ACTIONS(139),
    [anon_sym_RBRACE] = ACTIONS(325),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(147),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(147),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(189),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(197),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(213),
    [sym_private_property_identifier] = ACTIONS(215),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(221),
    [anon_sym_readonly] = ACTIONS(223),
    [anon_sym_get] = ACTIONS(225),
    [anon_sym_set] = ACTIONS(225),
    [anon_sym_declare] = ACTIONS(227),
    [anon_sym_public] = ACTIONS(229),
    [anon_sym_private] = ACTIONS(229),
    [anon_sym_protected] = ACTIONS(229),
    [anon_sym_override] = ACTIONS(231),
    [anon_sym_module] = ACTIONS(233),
    [anon_sym_any] = ACTIONS(147),
    [anon_sym_number] = ACTIONS(147),
    [anon_sym_boolean] = ACTIONS(147),
    [anon_sym_string] = ACTIONS(147),
    [anon_sym_symbol] = ACTIONS(147),
    [anon_sym_property] = ACTIONS(147),
    [anon_sym_signal] = ACTIONS(147),
    [anon_sym_on] = ACTIONS(147),
    [anon_sym_required] = ACTIONS(147),
    [anon_sym_component] = ACTIONS(147),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [11] = {
    [sym_export_statement] = STATE(15),
    [sym_declaration] = STATE(15),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(15),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_default] = ACTIONS(331),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(337),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_case] = ACTIONS(331),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [12] = {
    [sym_export_statement] = STATE(13),
    [sym_declaration] = STATE(13),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(13),
    [sym_expression_statement] = STATE(13),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(13),
    [sym_if_statement] = STATE(13),
    [sym_switch_statement] = STATE(13),
    [sym_for_statement] = STATE(13),
    [sym_for_in_statement] = STATE(13),
    [sym_while_statement] = STATE(13),
    [sym_do_statement] = STATE(13),
    [sym_try_statement] = STATE(13),
    [sym_with_statement] = STATE(13),
    [sym_break_statement] = STATE(13),
    [sym_continue_statement] = STATE(13),
    [sym_debugger_statement] = STATE(13),
    [sym_return_statement] = STATE(13),
    [sym_throw_statement] = STATE(13),
    [sym_empty_statement] = STATE(13),
    [sym_labeled_statement] = STATE(13),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(13),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_default] = ACTIONS(351),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(353),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_case] = ACTIONS(351),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [13] = {
    [sym_export_statement] = STATE(15),
    [sym_declaration] = STATE(15),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(15),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_default] = ACTIONS(355),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_case] = ACTIONS(355),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [14] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(11),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_default] = ACTIONS(359),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(361),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_case] = ACTIONS(359),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [15] = {
    [sym_export_statement] = STATE(15),
    [sym_declaration] = STATE(15),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(15),
    [sym_identifier] = ACTIONS(363),
    [anon_sym_export] = ACTIONS(366),
    [anon_sym_default] = ACTIONS(369),
    [anon_sym_type] = ACTIONS(371),
    [anon_sym_namespace] = ACTIONS(374),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_RBRACE] = ACTIONS(380),
    [anon_sym_typeof] = ACTIONS(382),
    [anon_sym_import] = ACTIONS(385),
    [anon_sym_from] = ACTIONS(388),
    [anon_sym_var] = ACTIONS(391),
    [anon_sym_let] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(397),
    [anon_sym_BANG] = ACTIONS(400),
    [anon_sym_if] = ACTIONS(403),
    [anon_sym_switch] = ACTIONS(406),
    [anon_sym_for] = ACTIONS(409),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_await] = ACTIONS(415),
    [anon_sym_of] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(418),
    [anon_sym_do] = ACTIONS(421),
    [anon_sym_try] = ACTIONS(424),
    [anon_sym_with] = ACTIONS(427),
    [anon_sym_break] = ACTIONS(430),
    [anon_sym_continue] = ACTIONS(433),
    [anon_sym_debugger] = ACTIONS(436),
    [anon_sym_return] = ACTIONS(439),
    [anon_sym_throw] = ACTIONS(442),
    [anon_sym_SEMI] = ACTIONS(445),
    [anon_sym_case] = ACTIONS(369),
    [anon_sym_yield] = ACTIONS(448),
    [anon_sym_LBRACK] = ACTIONS(451),
    [anon_sym_LT] = ACTIONS(454),
    [anon_sym_SLASH] = ACTIONS(457),
    [anon_sym_class] = ACTIONS(460),
    [anon_sym_async] = ACTIONS(463),
    [anon_sym_function] = ACTIONS(466),
    [anon_sym_new] = ACTIONS(469),
    [anon_sym_PLUS] = ACTIONS(382),
    [anon_sym_DASH] = ACTIONS(382),
    [anon_sym_TILDE] = ACTIONS(400),
    [anon_sym_void] = ACTIONS(382),
    [anon_sym_delete] = ACTIONS(382),
    [anon_sym_PLUS_PLUS] = ACTIONS(472),
    [anon_sym_DASH_DASH] = ACTIONS(472),
    [anon_sym_DQUOTE] = ACTIONS(475),
    [anon_sym_SQUOTE] = ACTIONS(478),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(481),
    [sym_number] = ACTIONS(484),
    [sym_this] = ACTIONS(487),
    [sym_super] = ACTIONS(487),
    [sym_true] = ACTIONS(487),
    [sym_false] = ACTIONS(487),
    [sym_null] = ACTIONS(487),
    [sym_undefined] = ACTIONS(490),
    [anon_sym_AT] = ACTIONS(493),
    [anon_sym_static] = ACTIONS(388),
    [anon_sym_readonly] = ACTIONS(388),
    [anon_sym_get] = ACTIONS(388),
    [anon_sym_set] = ACTIONS(388),
    [anon_sym_declare] = ACTIONS(496),
    [anon_sym_public] = ACTIONS(388),
    [anon_sym_private] = ACTIONS(388),
    [anon_sym_protected] = ACTIONS(388),
    [anon_sym_override] = ACTIONS(388),
    [anon_sym_module] = ACTIONS(499),
    [anon_sym_any] = ACTIONS(388),
    [anon_sym_number] = ACTIONS(388),
    [anon_sym_boolean] = ACTIONS(388),
    [anon_sym_string] = ACTIONS(388),
    [anon_sym_symbol] = ACTIONS(388),
    [anon_sym_property] = ACTIONS(388),
    [anon_sym_signal] = ACTIONS(388),
    [anon_sym_on] = ACTIONS(388),
    [anon_sym_required] = ACTIONS(388),
    [anon_sym_component] = ACTIONS(388),
    [anon_sym_abstract] = ACTIONS(502),
    [anon_sym_interface] = ACTIONS(505),
    [anon_sym_enum] = ACTIONS(508),
  },
  [16] = {
    [sym_export_statement] = STATE(15),
    [sym_declaration] = STATE(15),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(15),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(511),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [17] = {
    [sym_export_statement] = STATE(15),
    [sym_declaration] = STATE(15),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(15),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(513),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [18] = {
    [sym_export_statement] = STATE(15),
    [sym_declaration] = STATE(15),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(15),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(515),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [19] = {
    [sym_export_statement] = STATE(16),
    [sym_declaration] = STATE(16),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(16),
    [sym_expression_statement] = STATE(16),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_switch_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_do_statement] = STATE(16),
    [sym_try_statement] = STATE(16),
    [sym_with_statement] = STATE(16),
    [sym_break_statement] = STATE(16),
    [sym_continue_statement] = STATE(16),
    [sym_debugger_statement] = STATE(16),
    [sym_return_statement] = STATE(16),
    [sym_throw_statement] = STATE(16),
    [sym_empty_statement] = STATE(16),
    [sym_labeled_statement] = STATE(16),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(16),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(517),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [20] = {
    [sym_export_statement] = STATE(18),
    [sym_declaration] = STATE(18),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(18),
    [sym_expression_statement] = STATE(18),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(18),
    [sym_if_statement] = STATE(18),
    [sym_switch_statement] = STATE(18),
    [sym_for_statement] = STATE(18),
    [sym_for_in_statement] = STATE(18),
    [sym_while_statement] = STATE(18),
    [sym_do_statement] = STATE(18),
    [sym_try_statement] = STATE(18),
    [sym_with_statement] = STATE(18),
    [sym_break_statement] = STATE(18),
    [sym_continue_statement] = STATE(18),
    [sym_debugger_statement] = STATE(18),
    [sym_return_statement] = STATE(18),
    [sym_throw_statement] = STATE(18),
    [sym_empty_statement] = STATE(18),
    [sym_labeled_statement] = STATE(18),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(18),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(519),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [21] = {
    [sym_export_statement] = STATE(15),
    [sym_declaration] = STATE(15),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(15),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(521),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [22] = {
    [sym_export_statement] = STATE(31),
    [sym_declaration] = STATE(31),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(31),
    [sym_expression_statement] = STATE(31),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(31),
    [sym_if_statement] = STATE(31),
    [sym_switch_statement] = STATE(31),
    [sym_for_statement] = STATE(31),
    [sym_for_in_statement] = STATE(31),
    [sym_while_statement] = STATE(31),
    [sym_do_statement] = STATE(31),
    [sym_try_statement] = STATE(31),
    [sym_with_statement] = STATE(31),
    [sym_break_statement] = STATE(31),
    [sym_continue_statement] = STATE(31),
    [sym_debugger_statement] = STATE(31),
    [sym_return_statement] = STATE(31),
    [sym_throw_statement] = STATE(31),
    [sym_empty_statement] = STATE(31),
    [sym_labeled_statement] = STATE(31),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(31),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(523),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [23] = {
    [sym_export_statement] = STATE(15),
    [sym_declaration] = STATE(15),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(15),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(525),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [24] = {
    [sym_export_statement] = STATE(15),
    [sym_declaration] = STATE(15),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(15),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(527),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [25] = {
    [sym_export_statement] = STATE(17),
    [sym_declaration] = STATE(17),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_for_in_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_try_statement] = STATE(17),
    [sym_with_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_debugger_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_throw_statement] = STATE(17),
    [sym_empty_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(17),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(529),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [26] = {
    [sym_export_statement] = STATE(21),
    [sym_declaration] = STATE(21),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(21),
    [sym_expression_statement] = STATE(21),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(21),
    [sym_if_statement] = STATE(21),
    [sym_switch_statement] = STATE(21),
    [sym_for_statement] = STATE(21),
    [sym_for_in_statement] = STATE(21),
    [sym_while_statement] = STATE(21),
    [sym_do_statement] = STATE(21),
    [sym_try_statement] = STATE(21),
    [sym_with_statement] = STATE(21),
    [sym_break_statement] = STATE(21),
    [sym_continue_statement] = STATE(21),
    [sym_debugger_statement] = STATE(21),
    [sym_return_statement] = STATE(21),
    [sym_throw_statement] = STATE(21),
    [sym_empty_statement] = STATE(21),
    [sym_labeled_statement] = STATE(21),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(21),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(531),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [27] = {
    [sym_export_statement] = STATE(15),
    [sym_declaration] = STATE(15),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(15),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(533),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [28] = {
    [sym_export_statement] = STATE(23),
    [sym_declaration] = STATE(23),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(23),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(535),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [29] = {
    [sym_export_statement] = STATE(27),
    [sym_declaration] = STATE(27),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(27),
    [sym_expression_statement] = STATE(27),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(27),
    [sym_if_statement] = STATE(27),
    [sym_switch_statement] = STATE(27),
    [sym_for_statement] = STATE(27),
    [sym_for_in_statement] = STATE(27),
    [sym_while_statement] = STATE(27),
    [sym_do_statement] = STATE(27),
    [sym_try_statement] = STATE(27),
    [sym_with_statement] = STATE(27),
    [sym_break_statement] = STATE(27),
    [sym_continue_statement] = STATE(27),
    [sym_debugger_statement] = STATE(27),
    [sym_return_statement] = STATE(27),
    [sym_throw_statement] = STATE(27),
    [sym_empty_statement] = STATE(27),
    [sym_labeled_statement] = STATE(27),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(27),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(537),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [30] = {
    [sym_export_statement] = STATE(24),
    [sym_declaration] = STATE(24),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(24),
    [sym_expression_statement] = STATE(24),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(24),
    [sym_if_statement] = STATE(24),
    [sym_switch_statement] = STATE(24),
    [sym_for_statement] = STATE(24),
    [sym_for_in_statement] = STATE(24),
    [sym_while_statement] = STATE(24),
    [sym_do_statement] = STATE(24),
    [sym_try_statement] = STATE(24),
    [sym_with_statement] = STATE(24),
    [sym_break_statement] = STATE(24),
    [sym_continue_statement] = STATE(24),
    [sym_debugger_statement] = STATE(24),
    [sym_return_statement] = STATE(24),
    [sym_throw_statement] = STATE(24),
    [sym_empty_statement] = STATE(24),
    [sym_labeled_statement] = STATE(24),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(24),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(539),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [31] = {
    [sym_export_statement] = STATE(15),
    [sym_declaration] = STATE(15),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [aux_sym_statement_block_repeat1] = STATE(15),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_RBRACE] = ACTIONS(541),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [32] = {
    [sym_export_statement] = STATE(2568),
    [sym_declaration] = STATE(2568),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(2568),
    [sym_expression_statement] = STATE(2568),
    [sym_variable_declaration] = STATE(2559),
    [sym_lexical_declaration] = STATE(2559),
    [sym_statement_block] = STATE(2568),
    [sym_if_statement] = STATE(2568),
    [sym_switch_statement] = STATE(2568),
    [sym_for_statement] = STATE(2568),
    [sym_for_in_statement] = STATE(2568),
    [sym_while_statement] = STATE(2568),
    [sym_do_statement] = STATE(2568),
    [sym_try_statement] = STATE(2568),
    [sym_with_statement] = STATE(2568),
    [sym_break_statement] = STATE(2568),
    [sym_continue_statement] = STATE(2568),
    [sym_debugger_statement] = STATE(2568),
    [sym_return_statement] = STATE(2568),
    [sym_throw_statement] = STATE(2568),
    [sym_empty_statement] = STATE(2568),
    [sym_labeled_statement] = STATE(2568),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(2559),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(2559),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(2559),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(2559),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(2559),
    [sym_abstract_class_declaration] = STATE(2559),
    [sym_module] = STATE(2559),
    [sym_internal_module] = STATE(908),
    [sym_import_alias] = STATE(2559),
    [sym_interface_declaration] = STATE(2559),
    [sym_enum_declaration] = STATE(2559),
    [sym_type_alias_declaration] = STATE(2559),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3506),
    [sym_identifier] = ACTIONS(543),
    [anon_sym_export] = ACTIONS(545),
    [anon_sym_type] = ACTIONS(547),
    [anon_sym_namespace] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(553),
    [anon_sym_from] = ACTIONS(555),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(559),
    [anon_sym_const] = ACTIONS(561),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(563),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(567),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(555),
    [anon_sym_while] = ACTIONS(569),
    [anon_sym_do] = ACTIONS(571),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(575),
    [anon_sym_break] = ACTIONS(577),
    [anon_sym_continue] = ACTIONS(579),
    [anon_sym_debugger] = ACTIONS(581),
    [anon_sym_return] = ACTIONS(583),
    [anon_sym_throw] = ACTIONS(585),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(589),
    [anon_sym_async] = ACTIONS(591),
    [anon_sym_function] = ACTIONS(593),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(555),
    [anon_sym_readonly] = ACTIONS(555),
    [anon_sym_get] = ACTIONS(555),
    [anon_sym_set] = ACTIONS(555),
    [anon_sym_declare] = ACTIONS(595),
    [anon_sym_public] = ACTIONS(555),
    [anon_sym_private] = ACTIONS(555),
    [anon_sym_protected] = ACTIONS(555),
    [anon_sym_override] = ACTIONS(555),
    [anon_sym_module] = ACTIONS(597),
    [anon_sym_any] = ACTIONS(555),
    [anon_sym_number] = ACTIONS(555),
    [anon_sym_boolean] = ACTIONS(555),
    [anon_sym_string] = ACTIONS(555),
    [anon_sym_symbol] = ACTIONS(555),
    [anon_sym_property] = ACTIONS(555),
    [anon_sym_signal] = ACTIONS(555),
    [anon_sym_on] = ACTIONS(555),
    [anon_sym_required] = ACTIONS(555),
    [anon_sym_component] = ACTIONS(555),
    [anon_sym_abstract] = ACTIONS(599),
    [anon_sym_interface] = ACTIONS(601),
    [anon_sym_enum] = ACTIONS(603),
  },
  [33] = {
    [sym_export_statement] = STATE(4836),
    [sym_declaration] = STATE(4836),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(4836),
    [sym_expression_statement] = STATE(4836),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(4836),
    [sym_if_statement] = STATE(4836),
    [sym_switch_statement] = STATE(4836),
    [sym_for_statement] = STATE(4836),
    [sym_for_in_statement] = STATE(4836),
    [sym_while_statement] = STATE(4836),
    [sym_do_statement] = STATE(4836),
    [sym_try_statement] = STATE(4836),
    [sym_with_statement] = STATE(4836),
    [sym_break_statement] = STATE(4836),
    [sym_continue_statement] = STATE(4836),
    [sym_debugger_statement] = STATE(4836),
    [sym_return_statement] = STATE(4836),
    [sym_throw_statement] = STATE(4836),
    [sym_empty_statement] = STATE(4836),
    [sym_labeled_statement] = STATE(4836),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(2151),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3404),
    [sym_identifier] = ACTIONS(605),
    [anon_sym_export] = ACTIONS(607),
    [anon_sym_type] = ACTIONS(609),
    [anon_sym_namespace] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(613),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(615),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(623),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(625),
    [anon_sym_async] = ACTIONS(627),
    [anon_sym_function] = ACTIONS(629),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(615),
    [anon_sym_readonly] = ACTIONS(615),
    [anon_sym_get] = ACTIONS(615),
    [anon_sym_set] = ACTIONS(615),
    [anon_sym_declare] = ACTIONS(631),
    [anon_sym_public] = ACTIONS(615),
    [anon_sym_private] = ACTIONS(615),
    [anon_sym_protected] = ACTIONS(615),
    [anon_sym_override] = ACTIONS(615),
    [anon_sym_module] = ACTIONS(633),
    [anon_sym_any] = ACTIONS(615),
    [anon_sym_number] = ACTIONS(615),
    [anon_sym_boolean] = ACTIONS(615),
    [anon_sym_string] = ACTIONS(615),
    [anon_sym_symbol] = ACTIONS(615),
    [anon_sym_property] = ACTIONS(615),
    [anon_sym_signal] = ACTIONS(615),
    [anon_sym_on] = ACTIONS(615),
    [anon_sym_required] = ACTIONS(615),
    [anon_sym_component] = ACTIONS(615),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [34] = {
    [sym_export_statement] = STATE(715),
    [sym_declaration] = STATE(715),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(715),
    [sym_expression_statement] = STATE(715),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(715),
    [sym_if_statement] = STATE(715),
    [sym_switch_statement] = STATE(715),
    [sym_for_statement] = STATE(715),
    [sym_for_in_statement] = STATE(715),
    [sym_while_statement] = STATE(715),
    [sym_do_statement] = STATE(715),
    [sym_try_statement] = STATE(715),
    [sym_with_statement] = STATE(715),
    [sym_break_statement] = STATE(715),
    [sym_continue_statement] = STATE(715),
    [sym_debugger_statement] = STATE(715),
    [sym_return_statement] = STATE(715),
    [sym_throw_statement] = STATE(715),
    [sym_empty_statement] = STATE(715),
    [sym_labeled_statement] = STATE(715),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [35] = {
    [sym_export_statement] = STATE(2571),
    [sym_declaration] = STATE(2571),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(2571),
    [sym_expression_statement] = STATE(2571),
    [sym_variable_declaration] = STATE(2559),
    [sym_lexical_declaration] = STATE(2559),
    [sym_statement_block] = STATE(2571),
    [sym_if_statement] = STATE(2571),
    [sym_switch_statement] = STATE(2571),
    [sym_for_statement] = STATE(2571),
    [sym_for_in_statement] = STATE(2571),
    [sym_while_statement] = STATE(2571),
    [sym_do_statement] = STATE(2571),
    [sym_try_statement] = STATE(2571),
    [sym_with_statement] = STATE(2571),
    [sym_break_statement] = STATE(2571),
    [sym_continue_statement] = STATE(2571),
    [sym_debugger_statement] = STATE(2571),
    [sym_return_statement] = STATE(2571),
    [sym_throw_statement] = STATE(2571),
    [sym_empty_statement] = STATE(2571),
    [sym_labeled_statement] = STATE(2571),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(2559),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(2559),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(2559),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(2559),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(2559),
    [sym_abstract_class_declaration] = STATE(2559),
    [sym_module] = STATE(2559),
    [sym_internal_module] = STATE(908),
    [sym_import_alias] = STATE(2559),
    [sym_interface_declaration] = STATE(2559),
    [sym_enum_declaration] = STATE(2559),
    [sym_type_alias_declaration] = STATE(2559),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3506),
    [sym_identifier] = ACTIONS(543),
    [anon_sym_export] = ACTIONS(545),
    [anon_sym_type] = ACTIONS(547),
    [anon_sym_namespace] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(553),
    [anon_sym_from] = ACTIONS(555),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(559),
    [anon_sym_const] = ACTIONS(561),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(563),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(567),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(555),
    [anon_sym_while] = ACTIONS(569),
    [anon_sym_do] = ACTIONS(571),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(575),
    [anon_sym_break] = ACTIONS(577),
    [anon_sym_continue] = ACTIONS(579),
    [anon_sym_debugger] = ACTIONS(581),
    [anon_sym_return] = ACTIONS(583),
    [anon_sym_throw] = ACTIONS(585),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(589),
    [anon_sym_async] = ACTIONS(591),
    [anon_sym_function] = ACTIONS(593),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(555),
    [anon_sym_readonly] = ACTIONS(555),
    [anon_sym_get] = ACTIONS(555),
    [anon_sym_set] = ACTIONS(555),
    [anon_sym_declare] = ACTIONS(595),
    [anon_sym_public] = ACTIONS(555),
    [anon_sym_private] = ACTIONS(555),
    [anon_sym_protected] = ACTIONS(555),
    [anon_sym_override] = ACTIONS(555),
    [anon_sym_module] = ACTIONS(597),
    [anon_sym_any] = ACTIONS(555),
    [anon_sym_number] = ACTIONS(555),
    [anon_sym_boolean] = ACTIONS(555),
    [anon_sym_string] = ACTIONS(555),
    [anon_sym_symbol] = ACTIONS(555),
    [anon_sym_property] = ACTIONS(555),
    [anon_sym_signal] = ACTIONS(555),
    [anon_sym_on] = ACTIONS(555),
    [anon_sym_required] = ACTIONS(555),
    [anon_sym_component] = ACTIONS(555),
    [anon_sym_abstract] = ACTIONS(599),
    [anon_sym_interface] = ACTIONS(601),
    [anon_sym_enum] = ACTIONS(603),
  },
  [36] = {
    [sym_export_statement] = STATE(774),
    [sym_declaration] = STATE(774),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(774),
    [sym_expression_statement] = STATE(774),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(774),
    [sym_if_statement] = STATE(774),
    [sym_switch_statement] = STATE(774),
    [sym_for_statement] = STATE(774),
    [sym_for_in_statement] = STATE(774),
    [sym_while_statement] = STATE(774),
    [sym_do_statement] = STATE(774),
    [sym_try_statement] = STATE(774),
    [sym_with_statement] = STATE(774),
    [sym_break_statement] = STATE(774),
    [sym_continue_statement] = STATE(774),
    [sym_debugger_statement] = STATE(774),
    [sym_return_statement] = STATE(774),
    [sym_throw_statement] = STATE(774),
    [sym_empty_statement] = STATE(774),
    [sym_labeled_statement] = STATE(774),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(2151),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3404),
    [sym_identifier] = ACTIONS(605),
    [anon_sym_export] = ACTIONS(607),
    [anon_sym_type] = ACTIONS(609),
    [anon_sym_namespace] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(613),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(615),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(623),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(625),
    [anon_sym_async] = ACTIONS(627),
    [anon_sym_function] = ACTIONS(629),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(615),
    [anon_sym_readonly] = ACTIONS(615),
    [anon_sym_get] = ACTIONS(615),
    [anon_sym_set] = ACTIONS(615),
    [anon_sym_declare] = ACTIONS(631),
    [anon_sym_public] = ACTIONS(615),
    [anon_sym_private] = ACTIONS(615),
    [anon_sym_protected] = ACTIONS(615),
    [anon_sym_override] = ACTIONS(615),
    [anon_sym_module] = ACTIONS(633),
    [anon_sym_any] = ACTIONS(615),
    [anon_sym_number] = ACTIONS(615),
    [anon_sym_boolean] = ACTIONS(615),
    [anon_sym_string] = ACTIONS(615),
    [anon_sym_symbol] = ACTIONS(615),
    [anon_sym_property] = ACTIONS(615),
    [anon_sym_signal] = ACTIONS(615),
    [anon_sym_on] = ACTIONS(615),
    [anon_sym_required] = ACTIONS(615),
    [anon_sym_component] = ACTIONS(615),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [37] = {
    [sym_export_statement] = STATE(825),
    [sym_declaration] = STATE(823),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(821),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(819),
    [sym_if_statement] = STATE(818),
    [sym_switch_statement] = STATE(817),
    [sym_for_statement] = STATE(815),
    [sym_for_in_statement] = STATE(813),
    [sym_while_statement] = STATE(810),
    [sym_do_statement] = STATE(809),
    [sym_try_statement] = STATE(802),
    [sym_with_statement] = STATE(792),
    [sym_break_statement] = STATE(789),
    [sym_continue_statement] = STATE(785),
    [sym_debugger_statement] = STATE(782),
    [sym_return_statement] = STATE(778),
    [sym_throw_statement] = STATE(777),
    [sym_empty_statement] = STATE(776),
    [sym_labeled_statement] = STATE(775),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(2151),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3404),
    [sym_identifier] = ACTIONS(605),
    [anon_sym_export] = ACTIONS(607),
    [anon_sym_type] = ACTIONS(609),
    [anon_sym_namespace] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(613),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(615),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(623),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(625),
    [anon_sym_async] = ACTIONS(627),
    [anon_sym_function] = ACTIONS(629),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(615),
    [anon_sym_readonly] = ACTIONS(615),
    [anon_sym_get] = ACTIONS(615),
    [anon_sym_set] = ACTIONS(615),
    [anon_sym_declare] = ACTIONS(631),
    [anon_sym_public] = ACTIONS(615),
    [anon_sym_private] = ACTIONS(615),
    [anon_sym_protected] = ACTIONS(615),
    [anon_sym_override] = ACTIONS(615),
    [anon_sym_module] = ACTIONS(633),
    [anon_sym_any] = ACTIONS(615),
    [anon_sym_number] = ACTIONS(615),
    [anon_sym_boolean] = ACTIONS(615),
    [anon_sym_string] = ACTIONS(615),
    [anon_sym_symbol] = ACTIONS(615),
    [anon_sym_property] = ACTIONS(615),
    [anon_sym_signal] = ACTIONS(615),
    [anon_sym_on] = ACTIONS(615),
    [anon_sym_required] = ACTIONS(615),
    [anon_sym_component] = ACTIONS(615),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [38] = {
    [sym_export_statement] = STATE(694),
    [sym_declaration] = STATE(694),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(694),
    [sym_expression_statement] = STATE(694),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(694),
    [sym_if_statement] = STATE(694),
    [sym_switch_statement] = STATE(694),
    [sym_for_statement] = STATE(694),
    [sym_for_in_statement] = STATE(694),
    [sym_while_statement] = STATE(694),
    [sym_do_statement] = STATE(694),
    [sym_try_statement] = STATE(694),
    [sym_with_statement] = STATE(694),
    [sym_break_statement] = STATE(694),
    [sym_continue_statement] = STATE(694),
    [sym_debugger_statement] = STATE(694),
    [sym_return_statement] = STATE(694),
    [sym_throw_statement] = STATE(694),
    [sym_empty_statement] = STATE(694),
    [sym_labeled_statement] = STATE(694),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [39] = {
    [sym_export_statement] = STATE(842),
    [sym_declaration] = STATE(842),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(842),
    [sym_expression_statement] = STATE(842),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(842),
    [sym_if_statement] = STATE(842),
    [sym_switch_statement] = STATE(842),
    [sym_for_statement] = STATE(842),
    [sym_for_in_statement] = STATE(842),
    [sym_while_statement] = STATE(842),
    [sym_do_statement] = STATE(842),
    [sym_try_statement] = STATE(842),
    [sym_with_statement] = STATE(842),
    [sym_break_statement] = STATE(842),
    [sym_continue_statement] = STATE(842),
    [sym_debugger_statement] = STATE(842),
    [sym_return_statement] = STATE(842),
    [sym_throw_statement] = STATE(842),
    [sym_empty_statement] = STATE(842),
    [sym_labeled_statement] = STATE(842),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(2151),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3404),
    [sym_identifier] = ACTIONS(605),
    [anon_sym_export] = ACTIONS(607),
    [anon_sym_type] = ACTIONS(609),
    [anon_sym_namespace] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(613),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(615),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(623),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(625),
    [anon_sym_async] = ACTIONS(627),
    [anon_sym_function] = ACTIONS(629),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(615),
    [anon_sym_readonly] = ACTIONS(615),
    [anon_sym_get] = ACTIONS(615),
    [anon_sym_set] = ACTIONS(615),
    [anon_sym_declare] = ACTIONS(631),
    [anon_sym_public] = ACTIONS(615),
    [anon_sym_private] = ACTIONS(615),
    [anon_sym_protected] = ACTIONS(615),
    [anon_sym_override] = ACTIONS(615),
    [anon_sym_module] = ACTIONS(633),
    [anon_sym_any] = ACTIONS(615),
    [anon_sym_number] = ACTIONS(615),
    [anon_sym_boolean] = ACTIONS(615),
    [anon_sym_string] = ACTIONS(615),
    [anon_sym_symbol] = ACTIONS(615),
    [anon_sym_property] = ACTIONS(615),
    [anon_sym_signal] = ACTIONS(615),
    [anon_sym_on] = ACTIONS(615),
    [anon_sym_required] = ACTIONS(615),
    [anon_sym_component] = ACTIONS(615),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [40] = {
    [sym_export_statement] = STATE(822),
    [sym_declaration] = STATE(822),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(822),
    [sym_expression_statement] = STATE(822),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(822),
    [sym_if_statement] = STATE(822),
    [sym_switch_statement] = STATE(822),
    [sym_for_statement] = STATE(822),
    [sym_for_in_statement] = STATE(822),
    [sym_while_statement] = STATE(822),
    [sym_do_statement] = STATE(822),
    [sym_try_statement] = STATE(822),
    [sym_with_statement] = STATE(822),
    [sym_break_statement] = STATE(822),
    [sym_continue_statement] = STATE(822),
    [sym_debugger_statement] = STATE(822),
    [sym_return_statement] = STATE(822),
    [sym_throw_statement] = STATE(822),
    [sym_empty_statement] = STATE(822),
    [sym_labeled_statement] = STATE(822),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [41] = {
    [sym_export_statement] = STATE(2503),
    [sym_declaration] = STATE(2503),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(2503),
    [sym_expression_statement] = STATE(2503),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(2503),
    [sym_if_statement] = STATE(2503),
    [sym_switch_statement] = STATE(2503),
    [sym_for_statement] = STATE(2503),
    [sym_for_in_statement] = STATE(2503),
    [sym_while_statement] = STATE(2503),
    [sym_do_statement] = STATE(2503),
    [sym_try_statement] = STATE(2503),
    [sym_with_statement] = STATE(2503),
    [sym_break_statement] = STATE(2503),
    [sym_continue_statement] = STATE(2503),
    [sym_debugger_statement] = STATE(2503),
    [sym_return_statement] = STATE(2503),
    [sym_throw_statement] = STATE(2503),
    [sym_empty_statement] = STATE(2503),
    [sym_labeled_statement] = STATE(2503),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(2151),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3404),
    [sym_identifier] = ACTIONS(605),
    [anon_sym_export] = ACTIONS(607),
    [anon_sym_type] = ACTIONS(609),
    [anon_sym_namespace] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(613),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(615),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(623),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(625),
    [anon_sym_async] = ACTIONS(627),
    [anon_sym_function] = ACTIONS(629),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(615),
    [anon_sym_readonly] = ACTIONS(615),
    [anon_sym_get] = ACTIONS(615),
    [anon_sym_set] = ACTIONS(615),
    [anon_sym_declare] = ACTIONS(631),
    [anon_sym_public] = ACTIONS(615),
    [anon_sym_private] = ACTIONS(615),
    [anon_sym_protected] = ACTIONS(615),
    [anon_sym_override] = ACTIONS(615),
    [anon_sym_module] = ACTIONS(633),
    [anon_sym_any] = ACTIONS(615),
    [anon_sym_number] = ACTIONS(615),
    [anon_sym_boolean] = ACTIONS(615),
    [anon_sym_string] = ACTIONS(615),
    [anon_sym_symbol] = ACTIONS(615),
    [anon_sym_property] = ACTIONS(615),
    [anon_sym_signal] = ACTIONS(615),
    [anon_sym_on] = ACTIONS(615),
    [anon_sym_required] = ACTIONS(615),
    [anon_sym_component] = ACTIONS(615),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [42] = {
    [sym_export_statement] = STATE(4043),
    [sym_declaration] = STATE(4043),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(4043),
    [sym_expression_statement] = STATE(4043),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(4043),
    [sym_if_statement] = STATE(4043),
    [sym_switch_statement] = STATE(4043),
    [sym_for_statement] = STATE(4043),
    [sym_for_in_statement] = STATE(4043),
    [sym_while_statement] = STATE(4043),
    [sym_do_statement] = STATE(4043),
    [sym_try_statement] = STATE(4043),
    [sym_with_statement] = STATE(4043),
    [sym_break_statement] = STATE(4043),
    [sym_continue_statement] = STATE(4043),
    [sym_debugger_statement] = STATE(4043),
    [sym_return_statement] = STATE(4043),
    [sym_throw_statement] = STATE(4043),
    [sym_empty_statement] = STATE(4043),
    [sym_labeled_statement] = STATE(4043),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(2151),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3404),
    [sym_identifier] = ACTIONS(605),
    [anon_sym_export] = ACTIONS(607),
    [anon_sym_type] = ACTIONS(609),
    [anon_sym_namespace] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(613),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(615),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(623),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(625),
    [anon_sym_async] = ACTIONS(627),
    [anon_sym_function] = ACTIONS(629),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(615),
    [anon_sym_readonly] = ACTIONS(615),
    [anon_sym_get] = ACTIONS(615),
    [anon_sym_set] = ACTIONS(615),
    [anon_sym_declare] = ACTIONS(631),
    [anon_sym_public] = ACTIONS(615),
    [anon_sym_private] = ACTIONS(615),
    [anon_sym_protected] = ACTIONS(615),
    [anon_sym_override] = ACTIONS(615),
    [anon_sym_module] = ACTIONS(633),
    [anon_sym_any] = ACTIONS(615),
    [anon_sym_number] = ACTIONS(615),
    [anon_sym_boolean] = ACTIONS(615),
    [anon_sym_string] = ACTIONS(615),
    [anon_sym_symbol] = ACTIONS(615),
    [anon_sym_property] = ACTIONS(615),
    [anon_sym_signal] = ACTIONS(615),
    [anon_sym_on] = ACTIONS(615),
    [anon_sym_required] = ACTIONS(615),
    [anon_sym_component] = ACTIONS(615),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [43] = {
    [sym_export_statement] = STATE(715),
    [sym_declaration] = STATE(715),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(715),
    [sym_expression_statement] = STATE(715),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(715),
    [sym_if_statement] = STATE(715),
    [sym_switch_statement] = STATE(715),
    [sym_for_statement] = STATE(715),
    [sym_for_in_statement] = STATE(715),
    [sym_while_statement] = STATE(715),
    [sym_do_statement] = STATE(715),
    [sym_try_statement] = STATE(715),
    [sym_with_statement] = STATE(715),
    [sym_break_statement] = STATE(715),
    [sym_continue_statement] = STATE(715),
    [sym_debugger_statement] = STATE(715),
    [sym_return_statement] = STATE(715),
    [sym_throw_statement] = STATE(715),
    [sym_empty_statement] = STATE(715),
    [sym_labeled_statement] = STATE(715),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(2151),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3404),
    [sym_identifier] = ACTIONS(605),
    [anon_sym_export] = ACTIONS(607),
    [anon_sym_type] = ACTIONS(609),
    [anon_sym_namespace] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(613),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(615),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(623),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(625),
    [anon_sym_async] = ACTIONS(627),
    [anon_sym_function] = ACTIONS(629),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(615),
    [anon_sym_readonly] = ACTIONS(615),
    [anon_sym_get] = ACTIONS(615),
    [anon_sym_set] = ACTIONS(615),
    [anon_sym_declare] = ACTIONS(631),
    [anon_sym_public] = ACTIONS(615),
    [anon_sym_private] = ACTIONS(615),
    [anon_sym_protected] = ACTIONS(615),
    [anon_sym_override] = ACTIONS(615),
    [anon_sym_module] = ACTIONS(633),
    [anon_sym_any] = ACTIONS(615),
    [anon_sym_number] = ACTIONS(615),
    [anon_sym_boolean] = ACTIONS(615),
    [anon_sym_string] = ACTIONS(615),
    [anon_sym_symbol] = ACTIONS(615),
    [anon_sym_property] = ACTIONS(615),
    [anon_sym_signal] = ACTIONS(615),
    [anon_sym_on] = ACTIONS(615),
    [anon_sym_required] = ACTIONS(615),
    [anon_sym_component] = ACTIONS(615),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [44] = {
    [sym_export_statement] = STATE(830),
    [sym_declaration] = STATE(831),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(832),
    [sym_expression_statement] = STATE(834),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(835),
    [sym_if_statement] = STATE(836),
    [sym_switch_statement] = STATE(837),
    [sym_for_statement] = STATE(838),
    [sym_for_in_statement] = STATE(787),
    [sym_while_statement] = STATE(716),
    [sym_do_statement] = STATE(724),
    [sym_try_statement] = STATE(725),
    [sym_with_statement] = STATE(726),
    [sym_break_statement] = STATE(727),
    [sym_continue_statement] = STATE(728),
    [sym_debugger_statement] = STATE(730),
    [sym_return_statement] = STATE(731),
    [sym_throw_statement] = STATE(752),
    [sym_empty_statement] = STATE(755),
    [sym_labeled_statement] = STATE(756),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [45] = {
    [sym_export_statement] = STATE(2670),
    [sym_declaration] = STATE(2669),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(2668),
    [sym_expression_statement] = STATE(2667),
    [sym_variable_declaration] = STATE(2559),
    [sym_lexical_declaration] = STATE(2559),
    [sym_statement_block] = STATE(2666),
    [sym_if_statement] = STATE(2665),
    [sym_switch_statement] = STATE(2664),
    [sym_for_statement] = STATE(2663),
    [sym_for_in_statement] = STATE(2662),
    [sym_while_statement] = STATE(2661),
    [sym_do_statement] = STATE(2660),
    [sym_try_statement] = STATE(2659),
    [sym_with_statement] = STATE(2658),
    [sym_break_statement] = STATE(2657),
    [sym_continue_statement] = STATE(2656),
    [sym_debugger_statement] = STATE(2655),
    [sym_return_statement] = STATE(2654),
    [sym_throw_statement] = STATE(2653),
    [sym_empty_statement] = STATE(2652),
    [sym_labeled_statement] = STATE(2651),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(2559),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(2559),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(2559),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(2559),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(2559),
    [sym_abstract_class_declaration] = STATE(2559),
    [sym_module] = STATE(2559),
    [sym_internal_module] = STATE(908),
    [sym_import_alias] = STATE(2559),
    [sym_interface_declaration] = STATE(2559),
    [sym_enum_declaration] = STATE(2559),
    [sym_type_alias_declaration] = STATE(2559),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3506),
    [sym_identifier] = ACTIONS(543),
    [anon_sym_export] = ACTIONS(545),
    [anon_sym_type] = ACTIONS(547),
    [anon_sym_namespace] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(553),
    [anon_sym_from] = ACTIONS(555),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(559),
    [anon_sym_const] = ACTIONS(561),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(563),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(567),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(555),
    [anon_sym_while] = ACTIONS(569),
    [anon_sym_do] = ACTIONS(571),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(575),
    [anon_sym_break] = ACTIONS(577),
    [anon_sym_continue] = ACTIONS(579),
    [anon_sym_debugger] = ACTIONS(581),
    [anon_sym_return] = ACTIONS(583),
    [anon_sym_throw] = ACTIONS(585),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(589),
    [anon_sym_async] = ACTIONS(591),
    [anon_sym_function] = ACTIONS(593),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(555),
    [anon_sym_readonly] = ACTIONS(555),
    [anon_sym_get] = ACTIONS(555),
    [anon_sym_set] = ACTIONS(555),
    [anon_sym_declare] = ACTIONS(595),
    [anon_sym_public] = ACTIONS(555),
    [anon_sym_private] = ACTIONS(555),
    [anon_sym_protected] = ACTIONS(555),
    [anon_sym_override] = ACTIONS(555),
    [anon_sym_module] = ACTIONS(597),
    [anon_sym_any] = ACTIONS(555),
    [anon_sym_number] = ACTIONS(555),
    [anon_sym_boolean] = ACTIONS(555),
    [anon_sym_string] = ACTIONS(555),
    [anon_sym_symbol] = ACTIONS(555),
    [anon_sym_property] = ACTIONS(555),
    [anon_sym_signal] = ACTIONS(555),
    [anon_sym_on] = ACTIONS(555),
    [anon_sym_required] = ACTIONS(555),
    [anon_sym_component] = ACTIONS(555),
    [anon_sym_abstract] = ACTIONS(599),
    [anon_sym_interface] = ACTIONS(601),
    [anon_sym_enum] = ACTIONS(603),
  },
  [46] = {
    [sym_export_statement] = STATE(2497),
    [sym_declaration] = STATE(2497),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(2497),
    [sym_expression_statement] = STATE(2497),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(2497),
    [sym_if_statement] = STATE(2497),
    [sym_switch_statement] = STATE(2497),
    [sym_for_statement] = STATE(2497),
    [sym_for_in_statement] = STATE(2497),
    [sym_while_statement] = STATE(2497),
    [sym_do_statement] = STATE(2497),
    [sym_try_statement] = STATE(2497),
    [sym_with_statement] = STATE(2497),
    [sym_break_statement] = STATE(2497),
    [sym_continue_statement] = STATE(2497),
    [sym_debugger_statement] = STATE(2497),
    [sym_return_statement] = STATE(2497),
    [sym_throw_statement] = STATE(2497),
    [sym_empty_statement] = STATE(2497),
    [sym_labeled_statement] = STATE(2497),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(2151),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3404),
    [sym_identifier] = ACTIONS(605),
    [anon_sym_export] = ACTIONS(607),
    [anon_sym_type] = ACTIONS(609),
    [anon_sym_namespace] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(613),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(615),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(623),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(625),
    [anon_sym_async] = ACTIONS(627),
    [anon_sym_function] = ACTIONS(629),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(615),
    [anon_sym_readonly] = ACTIONS(615),
    [anon_sym_get] = ACTIONS(615),
    [anon_sym_set] = ACTIONS(615),
    [anon_sym_declare] = ACTIONS(631),
    [anon_sym_public] = ACTIONS(615),
    [anon_sym_private] = ACTIONS(615),
    [anon_sym_protected] = ACTIONS(615),
    [anon_sym_override] = ACTIONS(615),
    [anon_sym_module] = ACTIONS(633),
    [anon_sym_any] = ACTIONS(615),
    [anon_sym_number] = ACTIONS(615),
    [anon_sym_boolean] = ACTIONS(615),
    [anon_sym_string] = ACTIONS(615),
    [anon_sym_symbol] = ACTIONS(615),
    [anon_sym_property] = ACTIONS(615),
    [anon_sym_signal] = ACTIONS(615),
    [anon_sym_on] = ACTIONS(615),
    [anon_sym_required] = ACTIONS(615),
    [anon_sym_component] = ACTIONS(615),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [47] = {
    [sym_export_statement] = STATE(842),
    [sym_declaration] = STATE(842),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(842),
    [sym_expression_statement] = STATE(842),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(842),
    [sym_if_statement] = STATE(842),
    [sym_switch_statement] = STATE(842),
    [sym_for_statement] = STATE(842),
    [sym_for_in_statement] = STATE(842),
    [sym_while_statement] = STATE(842),
    [sym_do_statement] = STATE(842),
    [sym_try_statement] = STATE(842),
    [sym_with_statement] = STATE(842),
    [sym_break_statement] = STATE(842),
    [sym_continue_statement] = STATE(842),
    [sym_debugger_statement] = STATE(842),
    [sym_return_statement] = STATE(842),
    [sym_throw_statement] = STATE(842),
    [sym_empty_statement] = STATE(842),
    [sym_labeled_statement] = STATE(842),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [48] = {
    [sym_export_statement] = STATE(2503),
    [sym_declaration] = STATE(2503),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(2503),
    [sym_expression_statement] = STATE(2503),
    [sym_variable_declaration] = STATE(2559),
    [sym_lexical_declaration] = STATE(2559),
    [sym_statement_block] = STATE(2503),
    [sym_if_statement] = STATE(2503),
    [sym_switch_statement] = STATE(2503),
    [sym_for_statement] = STATE(2503),
    [sym_for_in_statement] = STATE(2503),
    [sym_while_statement] = STATE(2503),
    [sym_do_statement] = STATE(2503),
    [sym_try_statement] = STATE(2503),
    [sym_with_statement] = STATE(2503),
    [sym_break_statement] = STATE(2503),
    [sym_continue_statement] = STATE(2503),
    [sym_debugger_statement] = STATE(2503),
    [sym_return_statement] = STATE(2503),
    [sym_throw_statement] = STATE(2503),
    [sym_empty_statement] = STATE(2503),
    [sym_labeled_statement] = STATE(2503),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(2559),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(2559),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(2559),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(2559),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(2559),
    [sym_abstract_class_declaration] = STATE(2559),
    [sym_module] = STATE(2559),
    [sym_internal_module] = STATE(908),
    [sym_import_alias] = STATE(2559),
    [sym_interface_declaration] = STATE(2559),
    [sym_enum_declaration] = STATE(2559),
    [sym_type_alias_declaration] = STATE(2559),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3506),
    [sym_identifier] = ACTIONS(543),
    [anon_sym_export] = ACTIONS(545),
    [anon_sym_type] = ACTIONS(547),
    [anon_sym_namespace] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(553),
    [anon_sym_from] = ACTIONS(555),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(559),
    [anon_sym_const] = ACTIONS(561),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(563),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(567),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(555),
    [anon_sym_while] = ACTIONS(569),
    [anon_sym_do] = ACTIONS(571),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(575),
    [anon_sym_break] = ACTIONS(577),
    [anon_sym_continue] = ACTIONS(579),
    [anon_sym_debugger] = ACTIONS(581),
    [anon_sym_return] = ACTIONS(583),
    [anon_sym_throw] = ACTIONS(585),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(589),
    [anon_sym_async] = ACTIONS(591),
    [anon_sym_function] = ACTIONS(593),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(555),
    [anon_sym_readonly] = ACTIONS(555),
    [anon_sym_get] = ACTIONS(555),
    [anon_sym_set] = ACTIONS(555),
    [anon_sym_declare] = ACTIONS(595),
    [anon_sym_public] = ACTIONS(555),
    [anon_sym_private] = ACTIONS(555),
    [anon_sym_protected] = ACTIONS(555),
    [anon_sym_override] = ACTIONS(555),
    [anon_sym_module] = ACTIONS(597),
    [anon_sym_any] = ACTIONS(555),
    [anon_sym_number] = ACTIONS(555),
    [anon_sym_boolean] = ACTIONS(555),
    [anon_sym_string] = ACTIONS(555),
    [anon_sym_symbol] = ACTIONS(555),
    [anon_sym_property] = ACTIONS(555),
    [anon_sym_signal] = ACTIONS(555),
    [anon_sym_on] = ACTIONS(555),
    [anon_sym_required] = ACTIONS(555),
    [anon_sym_component] = ACTIONS(555),
    [anon_sym_abstract] = ACTIONS(599),
    [anon_sym_interface] = ACTIONS(601),
    [anon_sym_enum] = ACTIONS(603),
  },
  [49] = {
    [sym_export_statement] = STATE(774),
    [sym_declaration] = STATE(774),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(774),
    [sym_expression_statement] = STATE(774),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(774),
    [sym_if_statement] = STATE(774),
    [sym_switch_statement] = STATE(774),
    [sym_for_statement] = STATE(774),
    [sym_for_in_statement] = STATE(774),
    [sym_while_statement] = STATE(774),
    [sym_do_statement] = STATE(774),
    [sym_try_statement] = STATE(774),
    [sym_with_statement] = STATE(774),
    [sym_break_statement] = STATE(774),
    [sym_continue_statement] = STATE(774),
    [sym_debugger_statement] = STATE(774),
    [sym_return_statement] = STATE(774),
    [sym_throw_statement] = STATE(774),
    [sym_empty_statement] = STATE(774),
    [sym_labeled_statement] = STATE(774),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [50] = {
    [sym_export_statement] = STATE(2493),
    [sym_declaration] = STATE(2493),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(2493),
    [sym_expression_statement] = STATE(2493),
    [sym_variable_declaration] = STATE(2559),
    [sym_lexical_declaration] = STATE(2559),
    [sym_statement_block] = STATE(2493),
    [sym_if_statement] = STATE(2493),
    [sym_switch_statement] = STATE(2493),
    [sym_for_statement] = STATE(2493),
    [sym_for_in_statement] = STATE(2493),
    [sym_while_statement] = STATE(2493),
    [sym_do_statement] = STATE(2493),
    [sym_try_statement] = STATE(2493),
    [sym_with_statement] = STATE(2493),
    [sym_break_statement] = STATE(2493),
    [sym_continue_statement] = STATE(2493),
    [sym_debugger_statement] = STATE(2493),
    [sym_return_statement] = STATE(2493),
    [sym_throw_statement] = STATE(2493),
    [sym_empty_statement] = STATE(2493),
    [sym_labeled_statement] = STATE(2493),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(2559),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(2559),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(2559),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(2559),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(2559),
    [sym_abstract_class_declaration] = STATE(2559),
    [sym_module] = STATE(2559),
    [sym_internal_module] = STATE(908),
    [sym_import_alias] = STATE(2559),
    [sym_interface_declaration] = STATE(2559),
    [sym_enum_declaration] = STATE(2559),
    [sym_type_alias_declaration] = STATE(2559),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3506),
    [sym_identifier] = ACTIONS(543),
    [anon_sym_export] = ACTIONS(545),
    [anon_sym_type] = ACTIONS(547),
    [anon_sym_namespace] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(553),
    [anon_sym_from] = ACTIONS(555),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(559),
    [anon_sym_const] = ACTIONS(561),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(563),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(567),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(555),
    [anon_sym_while] = ACTIONS(569),
    [anon_sym_do] = ACTIONS(571),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(575),
    [anon_sym_break] = ACTIONS(577),
    [anon_sym_continue] = ACTIONS(579),
    [anon_sym_debugger] = ACTIONS(581),
    [anon_sym_return] = ACTIONS(583),
    [anon_sym_throw] = ACTIONS(585),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(589),
    [anon_sym_async] = ACTIONS(591),
    [anon_sym_function] = ACTIONS(593),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(555),
    [anon_sym_readonly] = ACTIONS(555),
    [anon_sym_get] = ACTIONS(555),
    [anon_sym_set] = ACTIONS(555),
    [anon_sym_declare] = ACTIONS(595),
    [anon_sym_public] = ACTIONS(555),
    [anon_sym_private] = ACTIONS(555),
    [anon_sym_protected] = ACTIONS(555),
    [anon_sym_override] = ACTIONS(555),
    [anon_sym_module] = ACTIONS(597),
    [anon_sym_any] = ACTIONS(555),
    [anon_sym_number] = ACTIONS(555),
    [anon_sym_boolean] = ACTIONS(555),
    [anon_sym_string] = ACTIONS(555),
    [anon_sym_symbol] = ACTIONS(555),
    [anon_sym_property] = ACTIONS(555),
    [anon_sym_signal] = ACTIONS(555),
    [anon_sym_on] = ACTIONS(555),
    [anon_sym_required] = ACTIONS(555),
    [anon_sym_component] = ACTIONS(555),
    [anon_sym_abstract] = ACTIONS(599),
    [anon_sym_interface] = ACTIONS(601),
    [anon_sym_enum] = ACTIONS(603),
  },
  [51] = {
    [sym_export_statement] = STATE(825),
    [sym_declaration] = STATE(823),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(821),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(819),
    [sym_if_statement] = STATE(818),
    [sym_switch_statement] = STATE(817),
    [sym_for_statement] = STATE(815),
    [sym_for_in_statement] = STATE(813),
    [sym_while_statement] = STATE(810),
    [sym_do_statement] = STATE(809),
    [sym_try_statement] = STATE(802),
    [sym_with_statement] = STATE(792),
    [sym_break_statement] = STATE(789),
    [sym_continue_statement] = STATE(785),
    [sym_debugger_statement] = STATE(782),
    [sym_return_statement] = STATE(778),
    [sym_throw_statement] = STATE(777),
    [sym_empty_statement] = STATE(776),
    [sym_labeled_statement] = STATE(775),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [52] = {
    [sym_export_statement] = STATE(709),
    [sym_declaration] = STATE(709),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(709),
    [sym_expression_statement] = STATE(709),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(709),
    [sym_if_statement] = STATE(709),
    [sym_switch_statement] = STATE(709),
    [sym_for_statement] = STATE(709),
    [sym_for_in_statement] = STATE(709),
    [sym_while_statement] = STATE(709),
    [sym_do_statement] = STATE(709),
    [sym_try_statement] = STATE(709),
    [sym_with_statement] = STATE(709),
    [sym_break_statement] = STATE(709),
    [sym_continue_statement] = STATE(709),
    [sym_debugger_statement] = STATE(709),
    [sym_return_statement] = STATE(709),
    [sym_throw_statement] = STATE(709),
    [sym_empty_statement] = STATE(709),
    [sym_labeled_statement] = STATE(709),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [53] = {
    [sym_export_statement] = STATE(4811),
    [sym_declaration] = STATE(4811),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(4811),
    [sym_expression_statement] = STATE(4811),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(4811),
    [sym_if_statement] = STATE(4811),
    [sym_switch_statement] = STATE(4811),
    [sym_for_statement] = STATE(4811),
    [sym_for_in_statement] = STATE(4811),
    [sym_while_statement] = STATE(4811),
    [sym_do_statement] = STATE(4811),
    [sym_try_statement] = STATE(4811),
    [sym_with_statement] = STATE(4811),
    [sym_break_statement] = STATE(4811),
    [sym_continue_statement] = STATE(4811),
    [sym_debugger_statement] = STATE(4811),
    [sym_return_statement] = STATE(4811),
    [sym_throw_statement] = STATE(4811),
    [sym_empty_statement] = STATE(4811),
    [sym_labeled_statement] = STATE(4811),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(2151),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3404),
    [sym_identifier] = ACTIONS(605),
    [anon_sym_export] = ACTIONS(607),
    [anon_sym_type] = ACTIONS(609),
    [anon_sym_namespace] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(613),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(615),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(623),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(625),
    [anon_sym_async] = ACTIONS(627),
    [anon_sym_function] = ACTIONS(629),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(615),
    [anon_sym_readonly] = ACTIONS(615),
    [anon_sym_get] = ACTIONS(615),
    [anon_sym_set] = ACTIONS(615),
    [anon_sym_declare] = ACTIONS(631),
    [anon_sym_public] = ACTIONS(615),
    [anon_sym_private] = ACTIONS(615),
    [anon_sym_protected] = ACTIONS(615),
    [anon_sym_override] = ACTIONS(615),
    [anon_sym_module] = ACTIONS(633),
    [anon_sym_any] = ACTIONS(615),
    [anon_sym_number] = ACTIONS(615),
    [anon_sym_boolean] = ACTIONS(615),
    [anon_sym_string] = ACTIONS(615),
    [anon_sym_symbol] = ACTIONS(615),
    [anon_sym_property] = ACTIONS(615),
    [anon_sym_signal] = ACTIONS(615),
    [anon_sym_on] = ACTIONS(615),
    [anon_sym_required] = ACTIONS(615),
    [anon_sym_component] = ACTIONS(615),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [54] = {
    [sym_export_statement] = STATE(2585),
    [sym_declaration] = STATE(2585),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(2585),
    [sym_expression_statement] = STATE(2585),
    [sym_variable_declaration] = STATE(2559),
    [sym_lexical_declaration] = STATE(2559),
    [sym_statement_block] = STATE(2585),
    [sym_if_statement] = STATE(2585),
    [sym_switch_statement] = STATE(2585),
    [sym_for_statement] = STATE(2585),
    [sym_for_in_statement] = STATE(2585),
    [sym_while_statement] = STATE(2585),
    [sym_do_statement] = STATE(2585),
    [sym_try_statement] = STATE(2585),
    [sym_with_statement] = STATE(2585),
    [sym_break_statement] = STATE(2585),
    [sym_continue_statement] = STATE(2585),
    [sym_debugger_statement] = STATE(2585),
    [sym_return_statement] = STATE(2585),
    [sym_throw_statement] = STATE(2585),
    [sym_empty_statement] = STATE(2585),
    [sym_labeled_statement] = STATE(2585),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(2559),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(2559),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(2559),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(2559),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(2559),
    [sym_abstract_class_declaration] = STATE(2559),
    [sym_module] = STATE(2559),
    [sym_internal_module] = STATE(908),
    [sym_import_alias] = STATE(2559),
    [sym_interface_declaration] = STATE(2559),
    [sym_enum_declaration] = STATE(2559),
    [sym_type_alias_declaration] = STATE(2559),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3506),
    [sym_identifier] = ACTIONS(543),
    [anon_sym_export] = ACTIONS(545),
    [anon_sym_type] = ACTIONS(547),
    [anon_sym_namespace] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(553),
    [anon_sym_from] = ACTIONS(555),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(559),
    [anon_sym_const] = ACTIONS(561),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(563),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(567),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(555),
    [anon_sym_while] = ACTIONS(569),
    [anon_sym_do] = ACTIONS(571),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(575),
    [anon_sym_break] = ACTIONS(577),
    [anon_sym_continue] = ACTIONS(579),
    [anon_sym_debugger] = ACTIONS(581),
    [anon_sym_return] = ACTIONS(583),
    [anon_sym_throw] = ACTIONS(585),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(589),
    [anon_sym_async] = ACTIONS(591),
    [anon_sym_function] = ACTIONS(593),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(555),
    [anon_sym_readonly] = ACTIONS(555),
    [anon_sym_get] = ACTIONS(555),
    [anon_sym_set] = ACTIONS(555),
    [anon_sym_declare] = ACTIONS(595),
    [anon_sym_public] = ACTIONS(555),
    [anon_sym_private] = ACTIONS(555),
    [anon_sym_protected] = ACTIONS(555),
    [anon_sym_override] = ACTIONS(555),
    [anon_sym_module] = ACTIONS(597),
    [anon_sym_any] = ACTIONS(555),
    [anon_sym_number] = ACTIONS(555),
    [anon_sym_boolean] = ACTIONS(555),
    [anon_sym_string] = ACTIONS(555),
    [anon_sym_symbol] = ACTIONS(555),
    [anon_sym_property] = ACTIONS(555),
    [anon_sym_signal] = ACTIONS(555),
    [anon_sym_on] = ACTIONS(555),
    [anon_sym_required] = ACTIONS(555),
    [anon_sym_component] = ACTIONS(555),
    [anon_sym_abstract] = ACTIONS(599),
    [anon_sym_interface] = ACTIONS(601),
    [anon_sym_enum] = ACTIONS(603),
  },
  [55] = {
    [sym_export_statement] = STATE(2590),
    [sym_declaration] = STATE(2591),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(2592),
    [sym_expression_statement] = STATE(2594),
    [sym_variable_declaration] = STATE(2559),
    [sym_lexical_declaration] = STATE(2559),
    [sym_statement_block] = STATE(2595),
    [sym_if_statement] = STATE(2596),
    [sym_switch_statement] = STATE(2601),
    [sym_for_statement] = STATE(2680),
    [sym_for_in_statement] = STATE(2610),
    [sym_while_statement] = STATE(2621),
    [sym_do_statement] = STATE(2622),
    [sym_try_statement] = STATE(2623),
    [sym_with_statement] = STATE(2624),
    [sym_break_statement] = STATE(2625),
    [sym_continue_statement] = STATE(2626),
    [sym_debugger_statement] = STATE(2627),
    [sym_return_statement] = STATE(2628),
    [sym_throw_statement] = STATE(2629),
    [sym_empty_statement] = STATE(2630),
    [sym_labeled_statement] = STATE(2631),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(2559),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(2559),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(2559),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(2559),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(2559),
    [sym_abstract_class_declaration] = STATE(2559),
    [sym_module] = STATE(2559),
    [sym_internal_module] = STATE(908),
    [sym_import_alias] = STATE(2559),
    [sym_interface_declaration] = STATE(2559),
    [sym_enum_declaration] = STATE(2559),
    [sym_type_alias_declaration] = STATE(2559),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3506),
    [sym_identifier] = ACTIONS(543),
    [anon_sym_export] = ACTIONS(545),
    [anon_sym_type] = ACTIONS(547),
    [anon_sym_namespace] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(553),
    [anon_sym_from] = ACTIONS(555),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(559),
    [anon_sym_const] = ACTIONS(561),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(563),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(567),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(555),
    [anon_sym_while] = ACTIONS(569),
    [anon_sym_do] = ACTIONS(571),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(575),
    [anon_sym_break] = ACTIONS(577),
    [anon_sym_continue] = ACTIONS(579),
    [anon_sym_debugger] = ACTIONS(581),
    [anon_sym_return] = ACTIONS(583),
    [anon_sym_throw] = ACTIONS(585),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(589),
    [anon_sym_async] = ACTIONS(591),
    [anon_sym_function] = ACTIONS(593),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(555),
    [anon_sym_readonly] = ACTIONS(555),
    [anon_sym_get] = ACTIONS(555),
    [anon_sym_set] = ACTIONS(555),
    [anon_sym_declare] = ACTIONS(595),
    [anon_sym_public] = ACTIONS(555),
    [anon_sym_private] = ACTIONS(555),
    [anon_sym_protected] = ACTIONS(555),
    [anon_sym_override] = ACTIONS(555),
    [anon_sym_module] = ACTIONS(597),
    [anon_sym_any] = ACTIONS(555),
    [anon_sym_number] = ACTIONS(555),
    [anon_sym_boolean] = ACTIONS(555),
    [anon_sym_string] = ACTIONS(555),
    [anon_sym_symbol] = ACTIONS(555),
    [anon_sym_property] = ACTIONS(555),
    [anon_sym_signal] = ACTIONS(555),
    [anon_sym_on] = ACTIONS(555),
    [anon_sym_required] = ACTIONS(555),
    [anon_sym_component] = ACTIONS(555),
    [anon_sym_abstract] = ACTIONS(599),
    [anon_sym_interface] = ACTIONS(601),
    [anon_sym_enum] = ACTIONS(603),
  },
  [56] = {
    [sym_export_statement] = STATE(830),
    [sym_declaration] = STATE(831),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(832),
    [sym_expression_statement] = STATE(834),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(835),
    [sym_if_statement] = STATE(836),
    [sym_switch_statement] = STATE(837),
    [sym_for_statement] = STATE(838),
    [sym_for_in_statement] = STATE(787),
    [sym_while_statement] = STATE(716),
    [sym_do_statement] = STATE(724),
    [sym_try_statement] = STATE(725),
    [sym_with_statement] = STATE(726),
    [sym_break_statement] = STATE(727),
    [sym_continue_statement] = STATE(728),
    [sym_debugger_statement] = STATE(730),
    [sym_return_statement] = STATE(731),
    [sym_throw_statement] = STATE(752),
    [sym_empty_statement] = STATE(755),
    [sym_labeled_statement] = STATE(756),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(2151),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3404),
    [sym_identifier] = ACTIONS(605),
    [anon_sym_export] = ACTIONS(607),
    [anon_sym_type] = ACTIONS(609),
    [anon_sym_namespace] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(613),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(615),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(623),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(625),
    [anon_sym_async] = ACTIONS(627),
    [anon_sym_function] = ACTIONS(629),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(615),
    [anon_sym_readonly] = ACTIONS(615),
    [anon_sym_get] = ACTIONS(615),
    [anon_sym_set] = ACTIONS(615),
    [anon_sym_declare] = ACTIONS(631),
    [anon_sym_public] = ACTIONS(615),
    [anon_sym_private] = ACTIONS(615),
    [anon_sym_protected] = ACTIONS(615),
    [anon_sym_override] = ACTIONS(615),
    [anon_sym_module] = ACTIONS(633),
    [anon_sym_any] = ACTIONS(615),
    [anon_sym_number] = ACTIONS(615),
    [anon_sym_boolean] = ACTIONS(615),
    [anon_sym_string] = ACTIONS(615),
    [anon_sym_symbol] = ACTIONS(615),
    [anon_sym_property] = ACTIONS(615),
    [anon_sym_signal] = ACTIONS(615),
    [anon_sym_on] = ACTIONS(615),
    [anon_sym_required] = ACTIONS(615),
    [anon_sym_component] = ACTIONS(615),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [57] = {
    [sym_export_statement] = STATE(751),
    [sym_declaration] = STATE(751),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(751),
    [sym_expression_statement] = STATE(751),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(751),
    [sym_if_statement] = STATE(751),
    [sym_switch_statement] = STATE(751),
    [sym_for_statement] = STATE(751),
    [sym_for_in_statement] = STATE(751),
    [sym_while_statement] = STATE(751),
    [sym_do_statement] = STATE(751),
    [sym_try_statement] = STATE(751),
    [sym_with_statement] = STATE(751),
    [sym_break_statement] = STATE(751),
    [sym_continue_statement] = STATE(751),
    [sym_debugger_statement] = STATE(751),
    [sym_return_statement] = STATE(751),
    [sym_throw_statement] = STATE(751),
    [sym_empty_statement] = STATE(751),
    [sym_labeled_statement] = STATE(751),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(2151),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3404),
    [sym_identifier] = ACTIONS(605),
    [anon_sym_export] = ACTIONS(607),
    [anon_sym_type] = ACTIONS(609),
    [anon_sym_namespace] = ACTIONS(611),
    [anon_sym_LBRACE] = ACTIONS(613),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(615),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(617),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(619),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(615),
    [anon_sym_while] = ACTIONS(621),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(623),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(625),
    [anon_sym_async] = ACTIONS(627),
    [anon_sym_function] = ACTIONS(629),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(615),
    [anon_sym_readonly] = ACTIONS(615),
    [anon_sym_get] = ACTIONS(615),
    [anon_sym_set] = ACTIONS(615),
    [anon_sym_declare] = ACTIONS(631),
    [anon_sym_public] = ACTIONS(615),
    [anon_sym_private] = ACTIONS(615),
    [anon_sym_protected] = ACTIONS(615),
    [anon_sym_override] = ACTIONS(615),
    [anon_sym_module] = ACTIONS(633),
    [anon_sym_any] = ACTIONS(615),
    [anon_sym_number] = ACTIONS(615),
    [anon_sym_boolean] = ACTIONS(615),
    [anon_sym_string] = ACTIONS(615),
    [anon_sym_symbol] = ACTIONS(615),
    [anon_sym_property] = ACTIONS(615),
    [anon_sym_signal] = ACTIONS(615),
    [anon_sym_on] = ACTIONS(615),
    [anon_sym_required] = ACTIONS(615),
    [anon_sym_component] = ACTIONS(615),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [58] = {
    [sym_export_statement] = STATE(2632),
    [sym_declaration] = STATE(2632),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(2632),
    [sym_expression_statement] = STATE(2632),
    [sym_variable_declaration] = STATE(2559),
    [sym_lexical_declaration] = STATE(2559),
    [sym_statement_block] = STATE(2632),
    [sym_if_statement] = STATE(2632),
    [sym_switch_statement] = STATE(2632),
    [sym_for_statement] = STATE(2632),
    [sym_for_in_statement] = STATE(2632),
    [sym_while_statement] = STATE(2632),
    [sym_do_statement] = STATE(2632),
    [sym_try_statement] = STATE(2632),
    [sym_with_statement] = STATE(2632),
    [sym_break_statement] = STATE(2632),
    [sym_continue_statement] = STATE(2632),
    [sym_debugger_statement] = STATE(2632),
    [sym_return_statement] = STATE(2632),
    [sym_throw_statement] = STATE(2632),
    [sym_empty_statement] = STATE(2632),
    [sym_labeled_statement] = STATE(2632),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(2559),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(2559),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(2559),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(2559),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(2559),
    [sym_abstract_class_declaration] = STATE(2559),
    [sym_module] = STATE(2559),
    [sym_internal_module] = STATE(908),
    [sym_import_alias] = STATE(2559),
    [sym_interface_declaration] = STATE(2559),
    [sym_enum_declaration] = STATE(2559),
    [sym_type_alias_declaration] = STATE(2559),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3506),
    [sym_identifier] = ACTIONS(543),
    [anon_sym_export] = ACTIONS(545),
    [anon_sym_type] = ACTIONS(547),
    [anon_sym_namespace] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(553),
    [anon_sym_from] = ACTIONS(555),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(559),
    [anon_sym_const] = ACTIONS(561),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(563),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(567),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(555),
    [anon_sym_while] = ACTIONS(569),
    [anon_sym_do] = ACTIONS(571),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(575),
    [anon_sym_break] = ACTIONS(577),
    [anon_sym_continue] = ACTIONS(579),
    [anon_sym_debugger] = ACTIONS(581),
    [anon_sym_return] = ACTIONS(583),
    [anon_sym_throw] = ACTIONS(585),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(589),
    [anon_sym_async] = ACTIONS(591),
    [anon_sym_function] = ACTIONS(593),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(555),
    [anon_sym_readonly] = ACTIONS(555),
    [anon_sym_get] = ACTIONS(555),
    [anon_sym_set] = ACTIONS(555),
    [anon_sym_declare] = ACTIONS(595),
    [anon_sym_public] = ACTIONS(555),
    [anon_sym_private] = ACTIONS(555),
    [anon_sym_protected] = ACTIONS(555),
    [anon_sym_override] = ACTIONS(555),
    [anon_sym_module] = ACTIONS(597),
    [anon_sym_any] = ACTIONS(555),
    [anon_sym_number] = ACTIONS(555),
    [anon_sym_boolean] = ACTIONS(555),
    [anon_sym_string] = ACTIONS(555),
    [anon_sym_symbol] = ACTIONS(555),
    [anon_sym_property] = ACTIONS(555),
    [anon_sym_signal] = ACTIONS(555),
    [anon_sym_on] = ACTIONS(555),
    [anon_sym_required] = ACTIONS(555),
    [anon_sym_component] = ACTIONS(555),
    [anon_sym_abstract] = ACTIONS(599),
    [anon_sym_interface] = ACTIONS(601),
    [anon_sym_enum] = ACTIONS(603),
  },
  [59] = {
    [sym_export_statement] = STATE(2497),
    [sym_declaration] = STATE(2497),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(2497),
    [sym_expression_statement] = STATE(2497),
    [sym_variable_declaration] = STATE(2559),
    [sym_lexical_declaration] = STATE(2559),
    [sym_statement_block] = STATE(2497),
    [sym_if_statement] = STATE(2497),
    [sym_switch_statement] = STATE(2497),
    [sym_for_statement] = STATE(2497),
    [sym_for_in_statement] = STATE(2497),
    [sym_while_statement] = STATE(2497),
    [sym_do_statement] = STATE(2497),
    [sym_try_statement] = STATE(2497),
    [sym_with_statement] = STATE(2497),
    [sym_break_statement] = STATE(2497),
    [sym_continue_statement] = STATE(2497),
    [sym_debugger_statement] = STATE(2497),
    [sym_return_statement] = STATE(2497),
    [sym_throw_statement] = STATE(2497),
    [sym_empty_statement] = STATE(2497),
    [sym_labeled_statement] = STATE(2497),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(2004),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(2559),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(2559),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(2559),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4353),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(2559),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(2559),
    [sym_abstract_class_declaration] = STATE(2559),
    [sym_module] = STATE(2559),
    [sym_internal_module] = STATE(908),
    [sym_import_alias] = STATE(2559),
    [sym_interface_declaration] = STATE(2559),
    [sym_enum_declaration] = STATE(2559),
    [sym_type_alias_declaration] = STATE(2559),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3506),
    [sym_identifier] = ACTIONS(543),
    [anon_sym_export] = ACTIONS(545),
    [anon_sym_type] = ACTIONS(547),
    [anon_sym_namespace] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(553),
    [anon_sym_from] = ACTIONS(555),
    [anon_sym_var] = ACTIONS(557),
    [anon_sym_let] = ACTIONS(559),
    [anon_sym_const] = ACTIONS(561),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(563),
    [anon_sym_switch] = ACTIONS(565),
    [anon_sym_for] = ACTIONS(567),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(555),
    [anon_sym_while] = ACTIONS(569),
    [anon_sym_do] = ACTIONS(571),
    [anon_sym_try] = ACTIONS(573),
    [anon_sym_with] = ACTIONS(575),
    [anon_sym_break] = ACTIONS(577),
    [anon_sym_continue] = ACTIONS(579),
    [anon_sym_debugger] = ACTIONS(581),
    [anon_sym_return] = ACTIONS(583),
    [anon_sym_throw] = ACTIONS(585),
    [anon_sym_SEMI] = ACTIONS(587),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(589),
    [anon_sym_async] = ACTIONS(591),
    [anon_sym_function] = ACTIONS(593),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(555),
    [anon_sym_readonly] = ACTIONS(555),
    [anon_sym_get] = ACTIONS(555),
    [anon_sym_set] = ACTIONS(555),
    [anon_sym_declare] = ACTIONS(595),
    [anon_sym_public] = ACTIONS(555),
    [anon_sym_private] = ACTIONS(555),
    [anon_sym_protected] = ACTIONS(555),
    [anon_sym_override] = ACTIONS(555),
    [anon_sym_module] = ACTIONS(597),
    [anon_sym_any] = ACTIONS(555),
    [anon_sym_number] = ACTIONS(555),
    [anon_sym_boolean] = ACTIONS(555),
    [anon_sym_string] = ACTIONS(555),
    [anon_sym_symbol] = ACTIONS(555),
    [anon_sym_property] = ACTIONS(555),
    [anon_sym_signal] = ACTIONS(555),
    [anon_sym_on] = ACTIONS(555),
    [anon_sym_required] = ACTIONS(555),
    [anon_sym_component] = ACTIONS(555),
    [anon_sym_abstract] = ACTIONS(599),
    [anon_sym_interface] = ACTIONS(601),
    [anon_sym_enum] = ACTIONS(603),
  },
  [60] = {
    [sym_export_statement] = STATE(751),
    [sym_declaration] = STATE(751),
    [sym_import] = STATE(2086),
    [sym_import_statement] = STATE(751),
    [sym_expression_statement] = STATE(751),
    [sym_variable_declaration] = STATE(735),
    [sym_lexical_declaration] = STATE(735),
    [sym_statement_block] = STATE(751),
    [sym_if_statement] = STATE(751),
    [sym_switch_statement] = STATE(751),
    [sym_for_statement] = STATE(751),
    [sym_for_in_statement] = STATE(751),
    [sym_while_statement] = STATE(751),
    [sym_do_statement] = STATE(751),
    [sym_try_statement] = STATE(751),
    [sym_with_statement] = STATE(751),
    [sym_break_statement] = STATE(751),
    [sym_continue_statement] = STATE(751),
    [sym_debugger_statement] = STATE(751),
    [sym_return_statement] = STATE(751),
    [sym_throw_statement] = STATE(751),
    [sym_empty_statement] = STATE(751),
    [sym_labeled_statement] = STATE(751),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1966),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_class_declaration] = STATE(735),
    [sym_function] = STATE(2086),
    [sym_function_declaration] = STATE(735),
    [sym_generator_function] = STATE(2086),
    [sym_generator_function_declaration] = STATE(735),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_sequence_expression] = STATE(4284),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_function_signature] = STATE(735),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_ambient_declaration] = STATE(735),
    [sym_abstract_class_declaration] = STATE(735),
    [sym_module] = STATE(735),
    [sym_internal_module] = STATE(172),
    [sym_import_alias] = STATE(735),
    [sym_interface_declaration] = STATE(735),
    [sym_enum_declaration] = STATE(735),
    [sym_type_alias_declaration] = STATE(735),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3422),
    [sym_identifier] = ACTIONS(327),
    [anon_sym_export] = ACTIONS(329),
    [anon_sym_type] = ACTIONS(333),
    [anon_sym_namespace] = ACTIONS(335),
    [anon_sym_LBRACE] = ACTIONS(137),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(145),
    [anon_sym_from] = ACTIONS(339),
    [anon_sym_var] = ACTIONS(149),
    [anon_sym_let] = ACTIONS(151),
    [anon_sym_const] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(159),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(339),
    [anon_sym_while] = ACTIONS(167),
    [anon_sym_do] = ACTIONS(169),
    [anon_sym_try] = ACTIONS(171),
    [anon_sym_with] = ACTIONS(173),
    [anon_sym_break] = ACTIONS(175),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(195),
    [anon_sym_async] = ACTIONS(343),
    [anon_sym_function] = ACTIONS(199),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(339),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(339),
    [anon_sym_set] = ACTIONS(339),
    [anon_sym_declare] = ACTIONS(347),
    [anon_sym_public] = ACTIONS(339),
    [anon_sym_private] = ACTIONS(339),
    [anon_sym_protected] = ACTIONS(339),
    [anon_sym_override] = ACTIONS(339),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_property] = ACTIONS(339),
    [anon_sym_signal] = ACTIONS(339),
    [anon_sym_on] = ACTIONS(339),
    [anon_sym_required] = ACTIONS(339),
    [anon_sym_component] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(239),
  },
  [61] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(1975),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3340),
    [sym_assignment_pattern] = STATE(3995),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3340),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1204),
    [sym_subscript_expression] = STATE(1204),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3340),
    [sym_spread_element] = STATE(4007),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3907),
    [sym_rest_pattern] = STATE(3769),
    [sym_non_null_expression] = STATE(1204),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3524),
    [sym_tuple_parameter] = STATE(4138),
    [sym_optional_tuple_parameter] = STATE(4138),
    [sym_optional_type] = STATE(4138),
    [sym_rest_type] = STATE(4138),
    [sym__tuple_type_member] = STATE(4138),
    [sym_constructor_type] = STATE(3524),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3524),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(414),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3524),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3524),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [aux_sym_array_repeat1] = STATE(4010),
    [aux_sym_array_pattern_repeat1] = STATE(3996),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_export] = ACTIONS(637),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(637),
    [anon_sym_namespace] = ACTIONS(641),
    [anon_sym_LBRACE] = ACTIONS(643),
    [anon_sym_COMMA] = ACTIONS(645),
    [anon_sym_typeof] = ACTIONS(647),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(637),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_of] = ACTIONS(637),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_RBRACK] = ACTIONS(657),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(663),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(665),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(671),
    [anon_sym_DASH] = ACTIONS(671),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(673),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(679),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(681),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(637),
    [anon_sym_readonly] = ACTIONS(683),
    [anon_sym_get] = ACTIONS(637),
    [anon_sym_set] = ACTIONS(637),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(637),
    [anon_sym_public] = ACTIONS(637),
    [anon_sym_private] = ACTIONS(637),
    [anon_sym_protected] = ACTIONS(637),
    [anon_sym_override] = ACTIONS(637),
    [anon_sym_module] = ACTIONS(637),
    [anon_sym_any] = ACTIONS(687),
    [anon_sym_number] = ACTIONS(687),
    [anon_sym_boolean] = ACTIONS(687),
    [anon_sym_string] = ACTIONS(687),
    [anon_sym_symbol] = ACTIONS(687),
    [anon_sym_property] = ACTIONS(637),
    [anon_sym_signal] = ACTIONS(637),
    [anon_sym_on] = ACTIONS(637),
    [anon_sym_required] = ACTIONS(637),
    [anon_sym_component] = ACTIONS(637),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [62] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(1975),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3340),
    [sym_assignment_pattern] = STATE(3995),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3340),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1204),
    [sym_subscript_expression] = STATE(1204),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3340),
    [sym_spread_element] = STATE(4007),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3907),
    [sym_rest_pattern] = STATE(3769),
    [sym_non_null_expression] = STATE(1204),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3524),
    [sym_tuple_parameter] = STATE(4138),
    [sym_optional_tuple_parameter] = STATE(4138),
    [sym_optional_type] = STATE(4138),
    [sym_rest_type] = STATE(4138),
    [sym__tuple_type_member] = STATE(4138),
    [sym_constructor_type] = STATE(3524),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3524),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(414),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3524),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3524),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [aux_sym_array_repeat1] = STATE(4010),
    [aux_sym_array_pattern_repeat1] = STATE(3996),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_export] = ACTIONS(637),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(637),
    [anon_sym_namespace] = ACTIONS(641),
    [anon_sym_LBRACE] = ACTIONS(643),
    [anon_sym_COMMA] = ACTIONS(645),
    [anon_sym_typeof] = ACTIONS(647),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(637),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_of] = ACTIONS(637),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_RBRACK] = ACTIONS(689),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(663),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(665),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(671),
    [anon_sym_DASH] = ACTIONS(671),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(673),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(679),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(681),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(637),
    [anon_sym_readonly] = ACTIONS(683),
    [anon_sym_get] = ACTIONS(637),
    [anon_sym_set] = ACTIONS(637),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(637),
    [anon_sym_public] = ACTIONS(637),
    [anon_sym_private] = ACTIONS(637),
    [anon_sym_protected] = ACTIONS(637),
    [anon_sym_override] = ACTIONS(637),
    [anon_sym_module] = ACTIONS(637),
    [anon_sym_any] = ACTIONS(687),
    [anon_sym_number] = ACTIONS(687),
    [anon_sym_boolean] = ACTIONS(687),
    [anon_sym_string] = ACTIONS(687),
    [anon_sym_symbol] = ACTIONS(687),
    [anon_sym_property] = ACTIONS(637),
    [anon_sym_signal] = ACTIONS(637),
    [anon_sym_on] = ACTIONS(637),
    [anon_sym_required] = ACTIONS(637),
    [anon_sym_component] = ACTIONS(637),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [63] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(1975),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3340),
    [sym_assignment_pattern] = STATE(3995),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3340),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1204),
    [sym_subscript_expression] = STATE(1204),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3340),
    [sym_spread_element] = STATE(4007),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3907),
    [sym_rest_pattern] = STATE(3769),
    [sym_non_null_expression] = STATE(1204),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3524),
    [sym_tuple_parameter] = STATE(4138),
    [sym_optional_tuple_parameter] = STATE(4138),
    [sym_optional_type] = STATE(4138),
    [sym_rest_type] = STATE(4138),
    [sym__tuple_type_member] = STATE(4138),
    [sym_constructor_type] = STATE(3524),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3524),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(414),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3524),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3524),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [aux_sym_array_repeat1] = STATE(4010),
    [aux_sym_array_pattern_repeat1] = STATE(3996),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_export] = ACTIONS(637),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(637),
    [anon_sym_namespace] = ACTIONS(641),
    [anon_sym_LBRACE] = ACTIONS(643),
    [anon_sym_COMMA] = ACTIONS(645),
    [anon_sym_typeof] = ACTIONS(647),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(637),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_of] = ACTIONS(637),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_RBRACK] = ACTIONS(691),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(663),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(665),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(671),
    [anon_sym_DASH] = ACTIONS(671),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(673),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(679),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(681),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(637),
    [anon_sym_readonly] = ACTIONS(683),
    [anon_sym_get] = ACTIONS(637),
    [anon_sym_set] = ACTIONS(637),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(637),
    [anon_sym_public] = ACTIONS(637),
    [anon_sym_private] = ACTIONS(637),
    [anon_sym_protected] = ACTIONS(637),
    [anon_sym_override] = ACTIONS(637),
    [anon_sym_module] = ACTIONS(637),
    [anon_sym_any] = ACTIONS(687),
    [anon_sym_number] = ACTIONS(687),
    [anon_sym_boolean] = ACTIONS(687),
    [anon_sym_string] = ACTIONS(687),
    [anon_sym_symbol] = ACTIONS(687),
    [anon_sym_property] = ACTIONS(637),
    [anon_sym_signal] = ACTIONS(637),
    [anon_sym_on] = ACTIONS(637),
    [anon_sym_required] = ACTIONS(637),
    [anon_sym_component] = ACTIONS(637),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [64] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(1975),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3340),
    [sym_assignment_pattern] = STATE(3995),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3340),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1204),
    [sym_subscript_expression] = STATE(1204),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3340),
    [sym_spread_element] = STATE(4007),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3907),
    [sym_rest_pattern] = STATE(3769),
    [sym_non_null_expression] = STATE(1204),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3524),
    [sym_tuple_parameter] = STATE(4138),
    [sym_optional_tuple_parameter] = STATE(4138),
    [sym_optional_type] = STATE(4138),
    [sym_rest_type] = STATE(4138),
    [sym__tuple_type_member] = STATE(4138),
    [sym_constructor_type] = STATE(3524),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3524),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(414),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3524),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3524),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [aux_sym_array_repeat1] = STATE(4010),
    [aux_sym_array_pattern_repeat1] = STATE(3996),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_export] = ACTIONS(637),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(637),
    [anon_sym_namespace] = ACTIONS(641),
    [anon_sym_LBRACE] = ACTIONS(643),
    [anon_sym_COMMA] = ACTIONS(645),
    [anon_sym_typeof] = ACTIONS(647),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(637),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_of] = ACTIONS(637),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_RBRACK] = ACTIONS(693),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(663),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(665),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(671),
    [anon_sym_DASH] = ACTIONS(671),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(673),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(679),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(681),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(637),
    [anon_sym_readonly] = ACTIONS(683),
    [anon_sym_get] = ACTIONS(637),
    [anon_sym_set] = ACTIONS(637),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(637),
    [anon_sym_public] = ACTIONS(637),
    [anon_sym_private] = ACTIONS(637),
    [anon_sym_protected] = ACTIONS(637),
    [anon_sym_override] = ACTIONS(637),
    [anon_sym_module] = ACTIONS(637),
    [anon_sym_any] = ACTIONS(687),
    [anon_sym_number] = ACTIONS(687),
    [anon_sym_boolean] = ACTIONS(687),
    [anon_sym_string] = ACTIONS(687),
    [anon_sym_symbol] = ACTIONS(687),
    [anon_sym_property] = ACTIONS(637),
    [anon_sym_signal] = ACTIONS(637),
    [anon_sym_on] = ACTIONS(637),
    [anon_sym_required] = ACTIONS(637),
    [anon_sym_component] = ACTIONS(637),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [65] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(1975),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3340),
    [sym_assignment_pattern] = STATE(3995),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3340),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1204),
    [sym_subscript_expression] = STATE(1204),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3340),
    [sym_spread_element] = STATE(4007),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3907),
    [sym_rest_pattern] = STATE(3769),
    [sym_non_null_expression] = STATE(1204),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3524),
    [sym_tuple_parameter] = STATE(4138),
    [sym_optional_tuple_parameter] = STATE(4138),
    [sym_optional_type] = STATE(4138),
    [sym_rest_type] = STATE(4138),
    [sym__tuple_type_member] = STATE(4138),
    [sym_constructor_type] = STATE(3524),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3524),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(414),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3524),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3524),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [aux_sym_array_repeat1] = STATE(4010),
    [aux_sym_array_pattern_repeat1] = STATE(3996),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_export] = ACTIONS(637),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(637),
    [anon_sym_namespace] = ACTIONS(641),
    [anon_sym_LBRACE] = ACTIONS(643),
    [anon_sym_COMMA] = ACTIONS(645),
    [anon_sym_typeof] = ACTIONS(647),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(637),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_of] = ACTIONS(637),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_RBRACK] = ACTIONS(695),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(663),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(665),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(671),
    [anon_sym_DASH] = ACTIONS(671),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(673),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(679),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(681),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(637),
    [anon_sym_readonly] = ACTIONS(683),
    [anon_sym_get] = ACTIONS(637),
    [anon_sym_set] = ACTIONS(637),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(637),
    [anon_sym_public] = ACTIONS(637),
    [anon_sym_private] = ACTIONS(637),
    [anon_sym_protected] = ACTIONS(637),
    [anon_sym_override] = ACTIONS(637),
    [anon_sym_module] = ACTIONS(637),
    [anon_sym_any] = ACTIONS(687),
    [anon_sym_number] = ACTIONS(687),
    [anon_sym_boolean] = ACTIONS(687),
    [anon_sym_string] = ACTIONS(687),
    [anon_sym_symbol] = ACTIONS(687),
    [anon_sym_property] = ACTIONS(637),
    [anon_sym_signal] = ACTIONS(637),
    [anon_sym_on] = ACTIONS(637),
    [anon_sym_required] = ACTIONS(637),
    [anon_sym_component] = ACTIONS(637),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [66] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(1853),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3340),
    [sym_assignment_pattern] = STATE(3995),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3340),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1204),
    [sym_subscript_expression] = STATE(1204),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3340),
    [sym_spread_element] = STATE(4058),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3907),
    [sym_rest_pattern] = STATE(3769),
    [sym_non_null_expression] = STATE(1204),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3524),
    [sym_tuple_parameter] = STATE(4138),
    [sym_optional_tuple_parameter] = STATE(4138),
    [sym_optional_type] = STATE(4138),
    [sym_rest_type] = STATE(4138),
    [sym__tuple_type_member] = STATE(4138),
    [sym_constructor_type] = STATE(3524),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3524),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(414),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3524),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3524),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [aux_sym_array_repeat1] = STATE(4060),
    [aux_sym_array_pattern_repeat1] = STATE(3996),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_export] = ACTIONS(637),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(637),
    [anon_sym_namespace] = ACTIONS(641),
    [anon_sym_LBRACE] = ACTIONS(643),
    [anon_sym_COMMA] = ACTIONS(645),
    [anon_sym_typeof] = ACTIONS(647),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(637),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_of] = ACTIONS(637),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_RBRACK] = ACTIONS(697),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(663),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(665),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(671),
    [anon_sym_DASH] = ACTIONS(671),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(673),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(679),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(681),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(637),
    [anon_sym_readonly] = ACTIONS(683),
    [anon_sym_get] = ACTIONS(637),
    [anon_sym_set] = ACTIONS(637),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(637),
    [anon_sym_public] = ACTIONS(637),
    [anon_sym_private] = ACTIONS(637),
    [anon_sym_protected] = ACTIONS(637),
    [anon_sym_override] = ACTIONS(637),
    [anon_sym_module] = ACTIONS(637),
    [anon_sym_any] = ACTIONS(687),
    [anon_sym_number] = ACTIONS(687),
    [anon_sym_boolean] = ACTIONS(687),
    [anon_sym_string] = ACTIONS(687),
    [anon_sym_symbol] = ACTIONS(687),
    [anon_sym_property] = ACTIONS(637),
    [anon_sym_signal] = ACTIONS(637),
    [anon_sym_on] = ACTIONS(637),
    [anon_sym_required] = ACTIONS(637),
    [anon_sym_component] = ACTIONS(637),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [67] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(1853),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3340),
    [sym_assignment_pattern] = STATE(3995),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3340),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1204),
    [sym_subscript_expression] = STATE(1204),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3340),
    [sym_spread_element] = STATE(4058),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3907),
    [sym_rest_pattern] = STATE(3769),
    [sym_non_null_expression] = STATE(1204),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3524),
    [sym_tuple_parameter] = STATE(4138),
    [sym_optional_tuple_parameter] = STATE(4138),
    [sym_optional_type] = STATE(4138),
    [sym_rest_type] = STATE(4138),
    [sym__tuple_type_member] = STATE(4138),
    [sym_constructor_type] = STATE(3524),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3524),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(414),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3524),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3524),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [aux_sym_array_repeat1] = STATE(4060),
    [aux_sym_array_pattern_repeat1] = STATE(3996),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_export] = ACTIONS(637),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(637),
    [anon_sym_namespace] = ACTIONS(641),
    [anon_sym_LBRACE] = ACTIONS(643),
    [anon_sym_COMMA] = ACTIONS(645),
    [anon_sym_typeof] = ACTIONS(647),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(637),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_of] = ACTIONS(637),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_RBRACK] = ACTIONS(699),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(663),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(665),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(671),
    [anon_sym_DASH] = ACTIONS(671),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(673),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(679),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(681),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(637),
    [anon_sym_readonly] = ACTIONS(683),
    [anon_sym_get] = ACTIONS(637),
    [anon_sym_set] = ACTIONS(637),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(637),
    [anon_sym_public] = ACTIONS(637),
    [anon_sym_private] = ACTIONS(637),
    [anon_sym_protected] = ACTIONS(637),
    [anon_sym_override] = ACTIONS(637),
    [anon_sym_module] = ACTIONS(637),
    [anon_sym_any] = ACTIONS(687),
    [anon_sym_number] = ACTIONS(687),
    [anon_sym_boolean] = ACTIONS(687),
    [anon_sym_string] = ACTIONS(687),
    [anon_sym_symbol] = ACTIONS(687),
    [anon_sym_property] = ACTIONS(637),
    [anon_sym_signal] = ACTIONS(637),
    [anon_sym_on] = ACTIONS(637),
    [anon_sym_required] = ACTIONS(637),
    [anon_sym_component] = ACTIONS(637),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [68] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(1975),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3340),
    [sym_assignment_pattern] = STATE(3995),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3340),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1204),
    [sym_subscript_expression] = STATE(1204),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3340),
    [sym_spread_element] = STATE(4007),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3907),
    [sym_rest_pattern] = STATE(3769),
    [sym_non_null_expression] = STATE(1204),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3524),
    [sym_tuple_parameter] = STATE(4138),
    [sym_optional_tuple_parameter] = STATE(4138),
    [sym_optional_type] = STATE(4138),
    [sym_rest_type] = STATE(4138),
    [sym__tuple_type_member] = STATE(4138),
    [sym_constructor_type] = STATE(3524),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3524),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(414),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3524),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3524),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [aux_sym_array_repeat1] = STATE(4010),
    [aux_sym_array_pattern_repeat1] = STATE(3996),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_export] = ACTIONS(637),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(637),
    [anon_sym_namespace] = ACTIONS(641),
    [anon_sym_LBRACE] = ACTIONS(643),
    [anon_sym_COMMA] = ACTIONS(645),
    [anon_sym_typeof] = ACTIONS(647),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(637),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_of] = ACTIONS(637),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_RBRACK] = ACTIONS(701),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(663),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(665),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(671),
    [anon_sym_DASH] = ACTIONS(671),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(673),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(679),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(681),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(637),
    [anon_sym_readonly] = ACTIONS(683),
    [anon_sym_get] = ACTIONS(637),
    [anon_sym_set] = ACTIONS(637),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(637),
    [anon_sym_public] = ACTIONS(637),
    [anon_sym_private] = ACTIONS(637),
    [anon_sym_protected] = ACTIONS(637),
    [anon_sym_override] = ACTIONS(637),
    [anon_sym_module] = ACTIONS(637),
    [anon_sym_any] = ACTIONS(687),
    [anon_sym_number] = ACTIONS(687),
    [anon_sym_boolean] = ACTIONS(687),
    [anon_sym_string] = ACTIONS(687),
    [anon_sym_symbol] = ACTIONS(687),
    [anon_sym_property] = ACTIONS(637),
    [anon_sym_signal] = ACTIONS(637),
    [anon_sym_on] = ACTIONS(637),
    [anon_sym_required] = ACTIONS(637),
    [anon_sym_component] = ACTIONS(637),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [69] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(1975),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3340),
    [sym_assignment_pattern] = STATE(3995),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3340),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1204),
    [sym_subscript_expression] = STATE(1204),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3340),
    [sym_spread_element] = STATE(4007),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3907),
    [sym_rest_pattern] = STATE(3769),
    [sym_non_null_expression] = STATE(1204),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3524),
    [sym_tuple_parameter] = STATE(4057),
    [sym_optional_tuple_parameter] = STATE(4057),
    [sym_optional_type] = STATE(4057),
    [sym_rest_type] = STATE(4057),
    [sym__tuple_type_member] = STATE(4057),
    [sym_constructor_type] = STATE(3524),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3524),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(414),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3524),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3524),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [aux_sym_array_repeat1] = STATE(4010),
    [aux_sym_array_pattern_repeat1] = STATE(3996),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_export] = ACTIONS(637),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(637),
    [anon_sym_namespace] = ACTIONS(641),
    [anon_sym_LBRACE] = ACTIONS(643),
    [anon_sym_COMMA] = ACTIONS(703),
    [anon_sym_typeof] = ACTIONS(647),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(637),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_of] = ACTIONS(637),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_RBRACK] = ACTIONS(705),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(663),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(665),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(671),
    [anon_sym_DASH] = ACTIONS(671),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(673),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(679),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(681),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(637),
    [anon_sym_readonly] = ACTIONS(683),
    [anon_sym_get] = ACTIONS(637),
    [anon_sym_set] = ACTIONS(637),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(637),
    [anon_sym_public] = ACTIONS(637),
    [anon_sym_private] = ACTIONS(637),
    [anon_sym_protected] = ACTIONS(637),
    [anon_sym_override] = ACTIONS(637),
    [anon_sym_module] = ACTIONS(637),
    [anon_sym_any] = ACTIONS(687),
    [anon_sym_number] = ACTIONS(687),
    [anon_sym_boolean] = ACTIONS(687),
    [anon_sym_string] = ACTIONS(687),
    [anon_sym_symbol] = ACTIONS(687),
    [anon_sym_property] = ACTIONS(637),
    [anon_sym_signal] = ACTIONS(637),
    [anon_sym_on] = ACTIONS(637),
    [anon_sym_required] = ACTIONS(637),
    [anon_sym_component] = ACTIONS(637),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [70] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(1975),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3340),
    [sym_assignment_pattern] = STATE(3995),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3340),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1204),
    [sym_subscript_expression] = STATE(1204),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3340),
    [sym_spread_element] = STATE(4007),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3907),
    [sym_rest_pattern] = STATE(3769),
    [sym_non_null_expression] = STATE(1204),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3524),
    [sym_tuple_parameter] = STATE(4138),
    [sym_optional_tuple_parameter] = STATE(4138),
    [sym_optional_type] = STATE(4138),
    [sym_rest_type] = STATE(4138),
    [sym__tuple_type_member] = STATE(4138),
    [sym_constructor_type] = STATE(3524),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3524),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(414),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3524),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3524),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [aux_sym_array_repeat1] = STATE(4010),
    [aux_sym_array_pattern_repeat1] = STATE(3996),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_export] = ACTIONS(637),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(637),
    [anon_sym_namespace] = ACTIONS(641),
    [anon_sym_LBRACE] = ACTIONS(643),
    [anon_sym_COMMA] = ACTIONS(645),
    [anon_sym_typeof] = ACTIONS(647),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(637),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_of] = ACTIONS(637),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_RBRACK] = ACTIONS(707),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(663),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(665),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(671),
    [anon_sym_DASH] = ACTIONS(671),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(673),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(679),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(681),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(637),
    [anon_sym_readonly] = ACTIONS(683),
    [anon_sym_get] = ACTIONS(637),
    [anon_sym_set] = ACTIONS(637),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(637),
    [anon_sym_public] = ACTIONS(637),
    [anon_sym_private] = ACTIONS(637),
    [anon_sym_protected] = ACTIONS(637),
    [anon_sym_override] = ACTIONS(637),
    [anon_sym_module] = ACTIONS(637),
    [anon_sym_any] = ACTIONS(687),
    [anon_sym_number] = ACTIONS(687),
    [anon_sym_boolean] = ACTIONS(687),
    [anon_sym_string] = ACTIONS(687),
    [anon_sym_symbol] = ACTIONS(687),
    [anon_sym_property] = ACTIONS(637),
    [anon_sym_signal] = ACTIONS(637),
    [anon_sym_on] = ACTIONS(637),
    [anon_sym_required] = ACTIONS(637),
    [anon_sym_component] = ACTIONS(637),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [71] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1163),
    [sym_expression] = STATE(2347),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3349),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3349),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4970),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1221),
    [sym_subscript_expression] = STATE(1221),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2849),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3349),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(1648),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_pattern] = STATE(3549),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1221),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_type_arguments] = STATE(422),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(709),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(26),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(119),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(711),
    [anon_sym_COMMA] = ACTIONS(122),
    [anon_sym_typeof] = ACTIONS(80),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(713),
    [anon_sym_RPAREN] = ACTIONS(122),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(122),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(716),
    [anon_sym_LT] = ACTIONS(719),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(56),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_QMARK_DOT] = ACTIONS(62),
    [anon_sym_new] = ACTIONS(722),
    [anon_sym_PLUS_EQ] = ACTIONS(66),
    [anon_sym_DASH_EQ] = ACTIONS(66),
    [anon_sym_STAR_EQ] = ACTIONS(66),
    [anon_sym_SLASH_EQ] = ACTIONS(66),
    [anon_sym_PERCENT_EQ] = ACTIONS(66),
    [anon_sym_CARET_EQ] = ACTIONS(66),
    [anon_sym_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_LT_LT_EQ] = ACTIONS(66),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(66),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(66),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(66),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(26),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(26),
    [anon_sym_PLUS] = ACTIONS(38),
    [anon_sym_DASH] = ACTIONS(38),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(62),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(62),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(62),
    [anon_sym_GT_EQ] = ACTIONS(62),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(76),
    [anon_sym_void] = ACTIONS(80),
    [anon_sym_delete] = ACTIONS(80),
    [anon_sym_PLUS_PLUS] = ACTIONS(82),
    [anon_sym_DASH_DASH] = ACTIONS(82),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(724),
    [sym_number] = ACTIONS(727),
    [sym_this] = ACTIONS(729),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(731),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(19),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(733),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(19),
    [anon_sym_number] = ACTIONS(19),
    [anon_sym_boolean] = ACTIONS(19),
    [anon_sym_string] = ACTIONS(19),
    [anon_sym_symbol] = ACTIONS(19),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [sym__ternary_qmark] = ACTIONS(62),
  },
  [72] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1163),
    [sym_expression] = STATE(2347),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3349),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3349),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4970),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1221),
    [sym_subscript_expression] = STATE(1221),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2849),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3349),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(1648),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_pattern] = STATE(3715),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1221),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_type_arguments] = STATE(422),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(709),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(26),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(711),
    [anon_sym_COMMA] = ACTIONS(32),
    [anon_sym_typeof] = ACTIONS(80),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(713),
    [anon_sym_RPAREN] = ACTIONS(32),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(32),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(716),
    [anon_sym_LT] = ACTIONS(719),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(56),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_EQ_GT] = ACTIONS(60),
    [anon_sym_QMARK_DOT] = ACTIONS(62),
    [anon_sym_new] = ACTIONS(722),
    [anon_sym_PLUS_EQ] = ACTIONS(66),
    [anon_sym_DASH_EQ] = ACTIONS(66),
    [anon_sym_STAR_EQ] = ACTIONS(66),
    [anon_sym_SLASH_EQ] = ACTIONS(66),
    [anon_sym_PERCENT_EQ] = ACTIONS(66),
    [anon_sym_CARET_EQ] = ACTIONS(66),
    [anon_sym_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_LT_LT_EQ] = ACTIONS(66),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(66),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(66),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(66),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(26),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(26),
    [anon_sym_PLUS] = ACTIONS(38),
    [anon_sym_DASH] = ACTIONS(38),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(62),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(62),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(62),
    [anon_sym_GT_EQ] = ACTIONS(62),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(76),
    [anon_sym_void] = ACTIONS(80),
    [anon_sym_delete] = ACTIONS(80),
    [anon_sym_PLUS_PLUS] = ACTIONS(82),
    [anon_sym_DASH_DASH] = ACTIONS(82),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(724),
    [sym_number] = ACTIONS(727),
    [sym_this] = ACTIONS(735),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(731),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(19),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(733),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(19),
    [anon_sym_number] = ACTIONS(19),
    [anon_sym_boolean] = ACTIONS(19),
    [anon_sym_string] = ACTIONS(19),
    [anon_sym_symbol] = ACTIONS(19),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [sym__ternary_qmark] = ACTIONS(62),
  },
  [73] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1163),
    [sym_expression] = STATE(2347),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3349),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3349),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4970),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1221),
    [sym_subscript_expression] = STATE(1221),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2849),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3349),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(1648),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_pattern] = STATE(3767),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1221),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_type_arguments] = STATE(422),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(709),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(26),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(711),
    [anon_sym_COMMA] = ACTIONS(32),
    [anon_sym_typeof] = ACTIONS(80),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(713),
    [anon_sym_RPAREN] = ACTIONS(32),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(32),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(716),
    [anon_sym_LT] = ACTIONS(719),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(56),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_EQ_GT] = ACTIONS(60),
    [anon_sym_QMARK_DOT] = ACTIONS(62),
    [anon_sym_new] = ACTIONS(722),
    [anon_sym_PLUS_EQ] = ACTIONS(66),
    [anon_sym_DASH_EQ] = ACTIONS(66),
    [anon_sym_STAR_EQ] = ACTIONS(66),
    [anon_sym_SLASH_EQ] = ACTIONS(66),
    [anon_sym_PERCENT_EQ] = ACTIONS(66),
    [anon_sym_CARET_EQ] = ACTIONS(66),
    [anon_sym_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_LT_LT_EQ] = ACTIONS(66),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(66),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(66),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(66),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(26),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(26),
    [anon_sym_PLUS] = ACTIONS(38),
    [anon_sym_DASH] = ACTIONS(38),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(62),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(62),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(62),
    [anon_sym_GT_EQ] = ACTIONS(62),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(76),
    [anon_sym_void] = ACTIONS(80),
    [anon_sym_delete] = ACTIONS(80),
    [anon_sym_PLUS_PLUS] = ACTIONS(82),
    [anon_sym_DASH_DASH] = ACTIONS(82),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(724),
    [sym_number] = ACTIONS(727),
    [sym_this] = ACTIONS(737),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(731),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(19),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(733),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(19),
    [anon_sym_number] = ACTIONS(19),
    [anon_sym_boolean] = ACTIONS(19),
    [anon_sym_string] = ACTIONS(19),
    [anon_sym_symbol] = ACTIONS(19),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [sym__ternary_qmark] = ACTIONS(62),
  },
  [74] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1163),
    [sym_expression] = STATE(2347),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3349),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3349),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4970),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1221),
    [sym_subscript_expression] = STATE(1221),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2849),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3349),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(1648),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_pattern] = STATE(3632),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1221),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_type_arguments] = STATE(422),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(709),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(26),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(711),
    [anon_sym_COMMA] = ACTIONS(32),
    [anon_sym_typeof] = ACTIONS(80),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(713),
    [anon_sym_RPAREN] = ACTIONS(32),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(32),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(716),
    [anon_sym_LT] = ACTIONS(719),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(56),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_EQ_GT] = ACTIONS(60),
    [anon_sym_QMARK_DOT] = ACTIONS(62),
    [anon_sym_new] = ACTIONS(722),
    [anon_sym_PLUS_EQ] = ACTIONS(66),
    [anon_sym_DASH_EQ] = ACTIONS(66),
    [anon_sym_STAR_EQ] = ACTIONS(66),
    [anon_sym_SLASH_EQ] = ACTIONS(66),
    [anon_sym_PERCENT_EQ] = ACTIONS(66),
    [anon_sym_CARET_EQ] = ACTIONS(66),
    [anon_sym_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_LT_LT_EQ] = ACTIONS(66),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(66),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(66),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(66),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(26),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(26),
    [anon_sym_PLUS] = ACTIONS(38),
    [anon_sym_DASH] = ACTIONS(38),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(62),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(62),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(62),
    [anon_sym_GT_EQ] = ACTIONS(62),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(76),
    [anon_sym_void] = ACTIONS(80),
    [anon_sym_delete] = ACTIONS(80),
    [anon_sym_PLUS_PLUS] = ACTIONS(82),
    [anon_sym_DASH_DASH] = ACTIONS(82),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(724),
    [sym_number] = ACTIONS(727),
    [sym_this] = ACTIONS(739),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(731),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(19),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(733),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(19),
    [anon_sym_number] = ACTIONS(19),
    [anon_sym_boolean] = ACTIONS(19),
    [anon_sym_string] = ACTIONS(19),
    [anon_sym_symbol] = ACTIONS(19),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [sym__ternary_qmark] = ACTIONS(62),
  },
  [75] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1163),
    [sym_expression] = STATE(2347),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3349),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3349),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4970),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1221),
    [sym_subscript_expression] = STATE(1221),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2849),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3349),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(1648),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_pattern] = STATE(3563),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1221),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_type_arguments] = STATE(422),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(709),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(26),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(711),
    [anon_sym_COMMA] = ACTIONS(32),
    [anon_sym_typeof] = ACTIONS(80),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(713),
    [anon_sym_RPAREN] = ACTIONS(32),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(32),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(716),
    [anon_sym_LT] = ACTIONS(719),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(56),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_EQ_GT] = ACTIONS(60),
    [anon_sym_QMARK_DOT] = ACTIONS(62),
    [anon_sym_new] = ACTIONS(722),
    [anon_sym_PLUS_EQ] = ACTIONS(66),
    [anon_sym_DASH_EQ] = ACTIONS(66),
    [anon_sym_STAR_EQ] = ACTIONS(66),
    [anon_sym_SLASH_EQ] = ACTIONS(66),
    [anon_sym_PERCENT_EQ] = ACTIONS(66),
    [anon_sym_CARET_EQ] = ACTIONS(66),
    [anon_sym_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_LT_LT_EQ] = ACTIONS(66),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(66),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(66),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(66),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(26),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(26),
    [anon_sym_PLUS] = ACTIONS(38),
    [anon_sym_DASH] = ACTIONS(38),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(62),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(62),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(62),
    [anon_sym_GT_EQ] = ACTIONS(62),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(76),
    [anon_sym_void] = ACTIONS(80),
    [anon_sym_delete] = ACTIONS(80),
    [anon_sym_PLUS_PLUS] = ACTIONS(82),
    [anon_sym_DASH_DASH] = ACTIONS(82),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(724),
    [sym_number] = ACTIONS(727),
    [sym_this] = ACTIONS(741),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(731),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(19),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(733),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(19),
    [anon_sym_number] = ACTIONS(19),
    [anon_sym_boolean] = ACTIONS(19),
    [anon_sym_string] = ACTIONS(19),
    [anon_sym_symbol] = ACTIONS(19),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [sym__ternary_qmark] = ACTIONS(62),
  },
  [76] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1163),
    [sym_expression] = STATE(2347),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3349),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3349),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4970),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1221),
    [sym_subscript_expression] = STATE(1221),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2849),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3349),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(1648),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_pattern] = STATE(3708),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1221),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_type_arguments] = STATE(422),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(709),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(26),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(711),
    [anon_sym_COMMA] = ACTIONS(32),
    [anon_sym_typeof] = ACTIONS(80),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(713),
    [anon_sym_RPAREN] = ACTIONS(32),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(32),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(716),
    [anon_sym_LT] = ACTIONS(719),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(56),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_EQ_GT] = ACTIONS(60),
    [anon_sym_QMARK_DOT] = ACTIONS(62),
    [anon_sym_new] = ACTIONS(722),
    [anon_sym_PLUS_EQ] = ACTIONS(66),
    [anon_sym_DASH_EQ] = ACTIONS(66),
    [anon_sym_STAR_EQ] = ACTIONS(66),
    [anon_sym_SLASH_EQ] = ACTIONS(66),
    [anon_sym_PERCENT_EQ] = ACTIONS(66),
    [anon_sym_CARET_EQ] = ACTIONS(66),
    [anon_sym_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_LT_LT_EQ] = ACTIONS(66),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(66),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(66),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(66),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(26),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(26),
    [anon_sym_PLUS] = ACTIONS(38),
    [anon_sym_DASH] = ACTIONS(38),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(62),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(62),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(62),
    [anon_sym_GT_EQ] = ACTIONS(62),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(76),
    [anon_sym_void] = ACTIONS(80),
    [anon_sym_delete] = ACTIONS(80),
    [anon_sym_PLUS_PLUS] = ACTIONS(82),
    [anon_sym_DASH_DASH] = ACTIONS(82),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(724),
    [sym_number] = ACTIONS(727),
    [sym_this] = ACTIONS(743),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(731),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(19),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(733),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(19),
    [anon_sym_number] = ACTIONS(19),
    [anon_sym_boolean] = ACTIONS(19),
    [anon_sym_string] = ACTIONS(19),
    [anon_sym_symbol] = ACTIONS(19),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [sym__ternary_qmark] = ACTIONS(62),
  },
  [77] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1163),
    [sym_expression] = STATE(2347),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3349),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3349),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4970),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1221),
    [sym_subscript_expression] = STATE(1221),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2849),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3349),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(1648),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_pattern] = STATE(3736),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1221),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_type_arguments] = STATE(422),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(709),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(26),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(711),
    [anon_sym_COMMA] = ACTIONS(32),
    [anon_sym_typeof] = ACTIONS(80),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(713),
    [anon_sym_RPAREN] = ACTIONS(32),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(32),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(716),
    [anon_sym_LT] = ACTIONS(719),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(56),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_EQ_GT] = ACTIONS(60),
    [anon_sym_QMARK_DOT] = ACTIONS(62),
    [anon_sym_new] = ACTIONS(722),
    [anon_sym_PLUS_EQ] = ACTIONS(66),
    [anon_sym_DASH_EQ] = ACTIONS(66),
    [anon_sym_STAR_EQ] = ACTIONS(66),
    [anon_sym_SLASH_EQ] = ACTIONS(66),
    [anon_sym_PERCENT_EQ] = ACTIONS(66),
    [anon_sym_CARET_EQ] = ACTIONS(66),
    [anon_sym_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_LT_LT_EQ] = ACTIONS(66),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(66),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(66),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(66),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(26),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(26),
    [anon_sym_PLUS] = ACTIONS(38),
    [anon_sym_DASH] = ACTIONS(38),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(62),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(62),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(62),
    [anon_sym_GT_EQ] = ACTIONS(62),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(76),
    [anon_sym_void] = ACTIONS(80),
    [anon_sym_delete] = ACTIONS(80),
    [anon_sym_PLUS_PLUS] = ACTIONS(82),
    [anon_sym_DASH_DASH] = ACTIONS(82),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(724),
    [sym_number] = ACTIONS(727),
    [sym_this] = ACTIONS(745),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(731),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(19),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(733),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(19),
    [anon_sym_number] = ACTIONS(19),
    [anon_sym_boolean] = ACTIONS(19),
    [anon_sym_string] = ACTIONS(19),
    [anon_sym_symbol] = ACTIONS(19),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [sym__ternary_qmark] = ACTIONS(62),
  },
  [78] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1163),
    [sym_expression] = STATE(2347),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3349),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3349),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4970),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1221),
    [sym_subscript_expression] = STATE(1221),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2849),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3349),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(1648),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_pattern] = STATE(3549),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1221),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_type_arguments] = STATE(422),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(709),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(26),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_as] = ACTIONS(26),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(711),
    [anon_sym_COMMA] = ACTIONS(32),
    [anon_sym_typeof] = ACTIONS(80),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(38),
    [anon_sym_LPAREN] = ACTIONS(713),
    [anon_sym_RPAREN] = ACTIONS(32),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_in] = ACTIONS(26),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_COLON] = ACTIONS(32),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(716),
    [anon_sym_LT] = ACTIONS(719),
    [anon_sym_GT] = ACTIONS(26),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(26),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(56),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_EQ_GT] = ACTIONS(60),
    [anon_sym_QMARK_DOT] = ACTIONS(62),
    [anon_sym_new] = ACTIONS(722),
    [anon_sym_PLUS_EQ] = ACTIONS(66),
    [anon_sym_DASH_EQ] = ACTIONS(66),
    [anon_sym_STAR_EQ] = ACTIONS(66),
    [anon_sym_SLASH_EQ] = ACTIONS(66),
    [anon_sym_PERCENT_EQ] = ACTIONS(66),
    [anon_sym_CARET_EQ] = ACTIONS(66),
    [anon_sym_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(66),
    [anon_sym_LT_LT_EQ] = ACTIONS(66),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(66),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(66),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(66),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(66),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP_AMP] = ACTIONS(26),
    [anon_sym_PIPE_PIPE] = ACTIONS(26),
    [anon_sym_GT_GT] = ACTIONS(26),
    [anon_sym_GT_GT_GT] = ACTIONS(26),
    [anon_sym_LT_LT] = ACTIONS(26),
    [anon_sym_AMP] = ACTIONS(26),
    [anon_sym_CARET] = ACTIONS(26),
    [anon_sym_PIPE] = ACTIONS(26),
    [anon_sym_PLUS] = ACTIONS(38),
    [anon_sym_DASH] = ACTIONS(38),
    [anon_sym_PERCENT] = ACTIONS(26),
    [anon_sym_STAR_STAR] = ACTIONS(26),
    [anon_sym_LT_EQ] = ACTIONS(62),
    [anon_sym_EQ_EQ] = ACTIONS(26),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(62),
    [anon_sym_BANG_EQ] = ACTIONS(26),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(62),
    [anon_sym_GT_EQ] = ACTIONS(62),
    [anon_sym_QMARK_QMARK] = ACTIONS(26),
    [anon_sym_instanceof] = ACTIONS(26),
    [anon_sym_TILDE] = ACTIONS(76),
    [anon_sym_void] = ACTIONS(80),
    [anon_sym_delete] = ACTIONS(80),
    [anon_sym_PLUS_PLUS] = ACTIONS(82),
    [anon_sym_DASH_DASH] = ACTIONS(82),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(724),
    [sym_number] = ACTIONS(727),
    [sym_this] = ACTIONS(729),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(731),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(19),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(733),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(19),
    [anon_sym_private] = ACTIONS(19),
    [anon_sym_protected] = ACTIONS(19),
    [anon_sym_override] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(19),
    [anon_sym_number] = ACTIONS(19),
    [anon_sym_boolean] = ACTIONS(19),
    [anon_sym_string] = ACTIONS(19),
    [anon_sym_symbol] = ACTIONS(19),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [sym__ternary_qmark] = ACTIONS(62),
  },
  [79] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(1744),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3340),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3340),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym__formal_parameter] = STATE(4056),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1204),
    [sym_subscript_expression] = STATE(1204),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3340),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_sequence_expression] = STATE(4933),
    [sym_string] = STATE(2063),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3646),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1204),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym_accessibility_modifier] = STATE(230),
    [sym_override_modifier] = STATE(243),
    [sym_required_parameter] = STATE(4056),
    [sym_optional_parameter] = STATE(4056),
    [sym__parameter_name] = STATE(3320),
    [sym__type] = STATE(3924),
    [sym_constructor_type] = STATE(3924),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3924),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(414),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3924),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3924),
    [aux_sym_export_statement_repeat1] = STATE(218),
    [sym_identifier] = ACTIONS(747),
    [anon_sym_export] = ACTIONS(637),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(637),
    [anon_sym_namespace] = ACTIONS(641),
    [anon_sym_LBRACE] = ACTIONS(749),
    [anon_sym_typeof] = ACTIONS(751),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(637),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(753),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_of] = ACTIONS(637),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(755),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(663),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(757),
    [anon_sym_DASH] = ACTIONS(757),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(673),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(759),
    [sym_number] = ACTIONS(761),
    [sym_this] = ACTIONS(763),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(765),
    [sym_false] = ACTIONS(765),
    [sym_null] = ACTIONS(765),
    [sym_undefined] = ACTIONS(767),
    [anon_sym_AT] = ACTIONS(769),
    [anon_sym_static] = ACTIONS(637),
    [anon_sym_readonly] = ACTIONS(771),
    [anon_sym_get] = ACTIONS(637),
    [anon_sym_set] = ACTIONS(637),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(637),
    [anon_sym_public] = ACTIONS(773),
    [anon_sym_private] = ACTIONS(773),
    [anon_sym_protected] = ACTIONS(773),
    [anon_sym_override] = ACTIONS(775),
    [anon_sym_module] = ACTIONS(637),
    [anon_sym_any] = ACTIONS(777),
    [anon_sym_number] = ACTIONS(777),
    [anon_sym_boolean] = ACTIONS(777),
    [anon_sym_string] = ACTIONS(777),
    [anon_sym_symbol] = ACTIONS(777),
    [anon_sym_property] = ACTIONS(637),
    [anon_sym_signal] = ACTIONS(637),
    [anon_sym_on] = ACTIONS(637),
    [anon_sym_required] = ACTIONS(637),
    [anon_sym_component] = ACTIONS(637),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [80] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(1765),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3340),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3340),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym__formal_parameter] = STATE(4056),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1204),
    [sym_subscript_expression] = STATE(1204),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3340),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_sequence_expression] = STATE(4795),
    [sym_string] = STATE(2063),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3646),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1204),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym_accessibility_modifier] = STATE(230),
    [sym_override_modifier] = STATE(243),
    [sym_required_parameter] = STATE(4056),
    [sym_optional_parameter] = STATE(4056),
    [sym__parameter_name] = STATE(3320),
    [sym__type] = STATE(3959),
    [sym_constructor_type] = STATE(3959),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3959),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(414),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3959),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3959),
    [aux_sym_export_statement_repeat1] = STATE(218),
    [sym_identifier] = ACTIONS(747),
    [anon_sym_export] = ACTIONS(637),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(637),
    [anon_sym_namespace] = ACTIONS(641),
    [anon_sym_LBRACE] = ACTIONS(749),
    [anon_sym_typeof] = ACTIONS(751),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(637),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(753),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_of] = ACTIONS(637),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(755),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(663),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(757),
    [anon_sym_DASH] = ACTIONS(757),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(673),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(759),
    [sym_number] = ACTIONS(761),
    [sym_this] = ACTIONS(763),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(765),
    [sym_false] = ACTIONS(765),
    [sym_null] = ACTIONS(765),
    [sym_undefined] = ACTIONS(767),
    [anon_sym_AT] = ACTIONS(769),
    [anon_sym_static] = ACTIONS(637),
    [anon_sym_readonly] = ACTIONS(771),
    [anon_sym_get] = ACTIONS(637),
    [anon_sym_set] = ACTIONS(637),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(637),
    [anon_sym_public] = ACTIONS(773),
    [anon_sym_private] = ACTIONS(773),
    [anon_sym_protected] = ACTIONS(773),
    [anon_sym_override] = ACTIONS(775),
    [anon_sym_module] = ACTIONS(637),
    [anon_sym_any] = ACTIONS(777),
    [anon_sym_number] = ACTIONS(777),
    [anon_sym_boolean] = ACTIONS(777),
    [anon_sym_string] = ACTIONS(777),
    [anon_sym_symbol] = ACTIONS(777),
    [anon_sym_property] = ACTIONS(637),
    [anon_sym_signal] = ACTIONS(637),
    [anon_sym_on] = ACTIONS(637),
    [anon_sym_required] = ACTIONS(637),
    [anon_sym_component] = ACTIONS(637),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [81] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(1744),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3340),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3340),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym__formal_parameter] = STATE(4056),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1204),
    [sym_subscript_expression] = STATE(1204),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3340),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_sequence_expression] = STATE(4933),
    [sym_string] = STATE(2063),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3646),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1204),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym_accessibility_modifier] = STATE(230),
    [sym_override_modifier] = STATE(243),
    [sym_required_parameter] = STATE(4056),
    [sym_optional_parameter] = STATE(4056),
    [sym__parameter_name] = STATE(3320),
    [sym__type] = STATE(3959),
    [sym_constructor_type] = STATE(3959),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3959),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(414),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3959),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3959),
    [aux_sym_export_statement_repeat1] = STATE(218),
    [sym_identifier] = ACTIONS(747),
    [anon_sym_export] = ACTIONS(637),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(637),
    [anon_sym_namespace] = ACTIONS(641),
    [anon_sym_LBRACE] = ACTIONS(749),
    [anon_sym_typeof] = ACTIONS(751),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(637),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(753),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_of] = ACTIONS(637),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(755),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(663),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(757),
    [anon_sym_DASH] = ACTIONS(757),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(673),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(759),
    [sym_number] = ACTIONS(761),
    [sym_this] = ACTIONS(763),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(765),
    [sym_false] = ACTIONS(765),
    [sym_null] = ACTIONS(765),
    [sym_undefined] = ACTIONS(767),
    [anon_sym_AT] = ACTIONS(769),
    [anon_sym_static] = ACTIONS(637),
    [anon_sym_readonly] = ACTIONS(771),
    [anon_sym_get] = ACTIONS(637),
    [anon_sym_set] = ACTIONS(637),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(637),
    [anon_sym_public] = ACTIONS(773),
    [anon_sym_private] = ACTIONS(773),
    [anon_sym_protected] = ACTIONS(773),
    [anon_sym_override] = ACTIONS(775),
    [anon_sym_module] = ACTIONS(637),
    [anon_sym_any] = ACTIONS(777),
    [anon_sym_number] = ACTIONS(777),
    [anon_sym_boolean] = ACTIONS(777),
    [anon_sym_string] = ACTIONS(777),
    [anon_sym_symbol] = ACTIONS(777),
    [anon_sym_property] = ACTIONS(637),
    [anon_sym_signal] = ACTIONS(637),
    [anon_sym_on] = ACTIONS(637),
    [anon_sym_required] = ACTIONS(637),
    [anon_sym_component] = ACTIONS(637),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [82] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1163),
    [sym_expression] = STATE(2347),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3349),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3349),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4970),
    [sym__formal_parameter] = STATE(4056),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1221),
    [sym_subscript_expression] = STATE(1221),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2849),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3349),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3646),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1221),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym_accessibility_modifier] = STATE(230),
    [sym_override_modifier] = STATE(243),
    [sym_required_parameter] = STATE(4056),
    [sym_optional_parameter] = STATE(4056),
    [sym__parameter_name] = STATE(3320),
    [sym__type] = STATE(3854),
    [sym_constructor_type] = STATE(3854),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3854),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(422),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3854),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3854),
    [aux_sym_export_statement_repeat1] = STATE(218),
    [sym_identifier] = ACTIONS(17),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(30),
    [anon_sym_typeof] = ACTIONS(34),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(76),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(753),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(56),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(64),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(74),
    [anon_sym_DASH] = ACTIONS(74),
    [anon_sym_TILDE] = ACTIONS(76),
    [anon_sym_void] = ACTIONS(78),
    [anon_sym_delete] = ACTIONS(80),
    [anon_sym_PLUS_PLUS] = ACTIONS(779),
    [anon_sym_DASH_DASH] = ACTIONS(779),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(781),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(769),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(783),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(785),
    [anon_sym_private] = ACTIONS(785),
    [anon_sym_protected] = ACTIONS(785),
    [anon_sym_override] = ACTIONS(787),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(107),
    [anon_sym_number] = ACTIONS(107),
    [anon_sym_boolean] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_symbol] = ACTIONS(107),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [83] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1163),
    [sym_expression] = STATE(2347),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3349),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3349),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4970),
    [sym__formal_parameter] = STATE(4056),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1221),
    [sym_subscript_expression] = STATE(1221),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2849),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3349),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3646),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1221),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym_accessibility_modifier] = STATE(230),
    [sym_override_modifier] = STATE(243),
    [sym_required_parameter] = STATE(4056),
    [sym_optional_parameter] = STATE(4056),
    [sym__parameter_name] = STATE(3320),
    [sym__type] = STATE(3913),
    [sym_constructor_type] = STATE(3913),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3913),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(422),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3913),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3913),
    [aux_sym_export_statement_repeat1] = STATE(218),
    [sym_identifier] = ACTIONS(17),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(30),
    [anon_sym_typeof] = ACTIONS(34),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(76),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(753),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(56),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(64),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(74),
    [anon_sym_DASH] = ACTIONS(74),
    [anon_sym_TILDE] = ACTIONS(76),
    [anon_sym_void] = ACTIONS(78),
    [anon_sym_delete] = ACTIONS(80),
    [anon_sym_PLUS_PLUS] = ACTIONS(779),
    [anon_sym_DASH_DASH] = ACTIONS(779),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(781),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(769),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(783),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(785),
    [anon_sym_private] = ACTIONS(785),
    [anon_sym_protected] = ACTIONS(785),
    [anon_sym_override] = ACTIONS(787),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(107),
    [anon_sym_number] = ACTIONS(107),
    [anon_sym_boolean] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_symbol] = ACTIONS(107),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [84] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1163),
    [sym_expression] = STATE(2347),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3349),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3349),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4970),
    [sym__formal_parameter] = STATE(4056),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1221),
    [sym_subscript_expression] = STATE(1221),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2849),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3349),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3646),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1221),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym_accessibility_modifier] = STATE(230),
    [sym_override_modifier] = STATE(243),
    [sym_required_parameter] = STATE(4056),
    [sym_optional_parameter] = STATE(4056),
    [sym__parameter_name] = STATE(3320),
    [sym__type] = STATE(3841),
    [sym_constructor_type] = STATE(3841),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3841),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(422),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3841),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3841),
    [aux_sym_export_statement_repeat1] = STATE(218),
    [sym_identifier] = ACTIONS(17),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(30),
    [anon_sym_typeof] = ACTIONS(34),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(76),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(753),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(56),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(64),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(74),
    [anon_sym_DASH] = ACTIONS(74),
    [anon_sym_TILDE] = ACTIONS(76),
    [anon_sym_void] = ACTIONS(78),
    [anon_sym_delete] = ACTIONS(80),
    [anon_sym_PLUS_PLUS] = ACTIONS(779),
    [anon_sym_DASH_DASH] = ACTIONS(779),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(781),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(769),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(783),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(785),
    [anon_sym_private] = ACTIONS(785),
    [anon_sym_protected] = ACTIONS(785),
    [anon_sym_override] = ACTIONS(787),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(107),
    [anon_sym_number] = ACTIONS(107),
    [anon_sym_boolean] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_symbol] = ACTIONS(107),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [85] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1163),
    [sym_expression] = STATE(2347),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3349),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3349),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4970),
    [sym__formal_parameter] = STATE(4056),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1221),
    [sym_subscript_expression] = STATE(1221),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2849),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3349),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3646),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1221),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym_accessibility_modifier] = STATE(230),
    [sym_override_modifier] = STATE(243),
    [sym_required_parameter] = STATE(4056),
    [sym_optional_parameter] = STATE(4056),
    [sym__parameter_name] = STATE(3320),
    [sym__type] = STATE(3924),
    [sym_constructor_type] = STATE(3924),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3924),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(422),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3924),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3924),
    [aux_sym_export_statement_repeat1] = STATE(218),
    [sym_identifier] = ACTIONS(17),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(30),
    [anon_sym_typeof] = ACTIONS(34),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(76),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(753),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(56),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(64),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(74),
    [anon_sym_DASH] = ACTIONS(74),
    [anon_sym_TILDE] = ACTIONS(76),
    [anon_sym_void] = ACTIONS(78),
    [anon_sym_delete] = ACTIONS(80),
    [anon_sym_PLUS_PLUS] = ACTIONS(779),
    [anon_sym_DASH_DASH] = ACTIONS(779),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(781),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(769),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(783),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(785),
    [anon_sym_private] = ACTIONS(785),
    [anon_sym_protected] = ACTIONS(785),
    [anon_sym_override] = ACTIONS(787),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(107),
    [anon_sym_number] = ACTIONS(107),
    [anon_sym_boolean] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_symbol] = ACTIONS(107),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [86] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1163),
    [sym_expression] = STATE(2347),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3349),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3349),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4970),
    [sym__formal_parameter] = STATE(4056),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1221),
    [sym_subscript_expression] = STATE(1221),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2849),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3349),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_pattern] = STATE(3646),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1221),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym_accessibility_modifier] = STATE(230),
    [sym_override_modifier] = STATE(243),
    [sym_required_parameter] = STATE(4056),
    [sym_optional_parameter] = STATE(4056),
    [sym__parameter_name] = STATE(3320),
    [sym__type] = STATE(3959),
    [sym_constructor_type] = STATE(3959),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3959),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(422),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3959),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3959),
    [aux_sym_export_statement_repeat1] = STATE(218),
    [sym_identifier] = ACTIONS(17),
    [anon_sym_export] = ACTIONS(19),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(19),
    [anon_sym_namespace] = ACTIONS(28),
    [anon_sym_LBRACE] = ACTIONS(30),
    [anon_sym_typeof] = ACTIONS(34),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(19),
    [anon_sym_BANG] = ACTIONS(76),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(753),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_of] = ACTIONS(19),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(56),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(64),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(74),
    [anon_sym_DASH] = ACTIONS(74),
    [anon_sym_TILDE] = ACTIONS(76),
    [anon_sym_void] = ACTIONS(78),
    [anon_sym_delete] = ACTIONS(80),
    [anon_sym_PLUS_PLUS] = ACTIONS(779),
    [anon_sym_DASH_DASH] = ACTIONS(779),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(781),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(99),
    [anon_sym_AT] = ACTIONS(769),
    [anon_sym_static] = ACTIONS(19),
    [anon_sym_readonly] = ACTIONS(783),
    [anon_sym_get] = ACTIONS(19),
    [anon_sym_set] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(19),
    [anon_sym_public] = ACTIONS(785),
    [anon_sym_private] = ACTIONS(785),
    [anon_sym_protected] = ACTIONS(785),
    [anon_sym_override] = ACTIONS(787),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_any] = ACTIONS(107),
    [anon_sym_number] = ACTIONS(107),
    [anon_sym_boolean] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_symbol] = ACTIONS(107),
    [anon_sym_property] = ACTIONS(19),
    [anon_sym_signal] = ACTIONS(19),
    [anon_sym_on] = ACTIONS(19),
    [anon_sym_required] = ACTIONS(19),
    [anon_sym_component] = ACTIONS(19),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [87] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(2090),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3340),
    [sym_assignment_pattern] = STATE(4543),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3340),
    [sym_nested_identifier] = STATE(4847),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1204),
    [sym_subscript_expression] = STATE(1204),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3340),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(1965),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3650),
    [sym_pattern] = STATE(4151),
    [sym_rest_pattern] = STATE(3348),
    [sym_non_null_expression] = STATE(1204),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2971),
    [sym__type] = STATE(3111),
    [sym_constructor_type] = STATE(3111),
    [sym__primary_type] = STATE(3066),
    [sym_template_literal_type] = STATE(3082),
    [sym_infer_type] = STATE(3111),
    [sym_conditional_type] = STATE(3082),
    [sym_generic_type] = STATE(3082),
    [sym_type_query] = STATE(3082),
    [sym_index_type_query] = STATE(3082),
    [sym_lookup_type] = STATE(3082),
    [sym_literal_type] = STATE(3082),
    [sym__number] = STATE(3067),
    [sym_existential_type] = STATE(3082),
    [sym_flow_maybe_type] = STATE(3082),
    [sym_parenthesized_type] = STATE(3082),
    [sym_predefined_type] = STATE(3082),
    [sym_type_arguments] = STATE(414),
    [sym_object_type] = STATE(3082),
    [sym_type_parameters] = STATE(4479),
    [sym_array_type] = STATE(3082),
    [sym_tuple_type] = STATE(3082),
    [sym_readonly_type] = STATE(3111),
    [sym_union_type] = STATE(3082),
    [sym_intersection_type] = STATE(3082),
    [sym_function_type] = STATE(3111),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(789),
    [anon_sym_export] = ACTIONS(637),
    [anon_sym_STAR] = ACTIONS(791),
    [anon_sym_type] = ACTIONS(637),
    [anon_sym_namespace] = ACTIONS(641),
    [anon_sym_LBRACE] = ACTIONS(793),
    [anon_sym_typeof] = ACTIONS(795),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(637),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(797),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_of] = ACTIONS(637),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(799),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(661),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(801),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(68),
    [anon_sym_AMP] = ACTIONS(803),
    [anon_sym_PIPE] = ACTIONS(805),
    [anon_sym_PLUS] = ACTIONS(807),
    [anon_sym_DASH] = ACTIONS(807),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(809),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(811),
    [sym_number] = ACTIONS(813),
    [sym_this] = ACTIONS(815),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(817),
    [sym_false] = ACTIONS(817),
    [sym_null] = ACTIONS(817),
    [sym_undefined] = ACTIONS(819),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(637),
    [anon_sym_readonly] = ACTIONS(821),
    [anon_sym_get] = ACTIONS(637),
    [anon_sym_set] = ACTIONS(637),
    [anon_sym_QMARK] = ACTIONS(823),
    [anon_sym_declare] = ACTIONS(637),
    [anon_sym_public] = ACTIONS(637),
    [anon_sym_private] = ACTIONS(637),
    [anon_sym_protected] = ACTIONS(637),
    [anon_sym_override] = ACTIONS(637),
    [anon_sym_module] = ACTIONS(637),
    [anon_sym_any] = ACTIONS(825),
    [anon_sym_number] = ACTIONS(825),
    [anon_sym_boolean] = ACTIONS(825),
    [anon_sym_string] = ACTIONS(825),
    [anon_sym_symbol] = ACTIONS(825),
    [anon_sym_property] = ACTIONS(637),
    [anon_sym_signal] = ACTIONS(637),
    [anon_sym_on] = ACTIONS(637),
    [anon_sym_required] = ACTIONS(637),
    [anon_sym_component] = ACTIONS(637),
    [anon_sym_abstract] = ACTIONS(827),
    [anon_sym_infer] = ACTIONS(829),
    [anon_sym_keyof] = ACTIONS(831),
    [anon_sym_unknown] = ACTIONS(833),
    [anon_sym_never] = ACTIONS(833),
    [anon_sym_object] = ACTIONS(833),
    [anon_sym_LBRACE_PIPE] = ACTIONS(835),
  },
  [88] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(2077),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(4868),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(4868),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1255),
    [sym_subscript_expression] = STATE(1255),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(4868),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_sequence_expression] = STATE(4681),
    [sym_string] = STATE(2063),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_non_null_expression] = STATE(1255),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(4139),
    [sym_constructor_type] = STATE(4139),
    [sym__primary_type] = STATE(3789),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3871),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(414),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(4139),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(4139),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(837),
    [anon_sym_export] = ACTIONS(839),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(839),
    [anon_sym_namespace] = ACTIONS(841),
    [anon_sym_LBRACE] = ACTIONS(843),
    [anon_sym_typeof] = ACTIONS(751),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(839),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_of] = ACTIONS(839),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(845),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(847),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(663),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(757),
    [anon_sym_DASH] = ACTIONS(757),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(673),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(759),
    [sym_number] = ACTIONS(761),
    [sym_this] = ACTIONS(849),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(765),
    [sym_false] = ACTIONS(765),
    [sym_null] = ACTIONS(765),
    [sym_undefined] = ACTIONS(851),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(839),
    [anon_sym_readonly] = ACTIONS(853),
    [anon_sym_get] = ACTIONS(839),
    [anon_sym_set] = ACTIONS(839),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(839),
    [anon_sym_public] = ACTIONS(839),
    [anon_sym_private] = ACTIONS(839),
    [anon_sym_protected] = ACTIONS(839),
    [anon_sym_override] = ACTIONS(839),
    [anon_sym_module] = ACTIONS(839),
    [anon_sym_any] = ACTIONS(855),
    [anon_sym_number] = ACTIONS(855),
    [anon_sym_boolean] = ACTIONS(855),
    [anon_sym_string] = ACTIONS(855),
    [anon_sym_symbol] = ACTIONS(855),
    [anon_sym_property] = ACTIONS(839),
    [anon_sym_signal] = ACTIONS(839),
    [anon_sym_on] = ACTIONS(839),
    [anon_sym_required] = ACTIONS(839),
    [anon_sym_component] = ACTIONS(839),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [89] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1344),
    [sym_expression] = STATE(2262),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(4845),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(4845),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4838),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1344),
    [sym_subscript_expression] = STATE(1344),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2857),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(4845),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2027),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_non_null_expression] = STATE(1344),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3434),
    [sym_constructor_type] = STATE(3434),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3434),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(394),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3434),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3434),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(857),
    [anon_sym_export] = ACTIONS(859),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(859),
    [anon_sym_namespace] = ACTIONS(861),
    [anon_sym_LBRACE] = ACTIONS(863),
    [anon_sym_typeof] = ACTIONS(865),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(859),
    [anon_sym_BANG] = ACTIONS(867),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(869),
    [anon_sym_of] = ACTIONS(859),
    [anon_sym_yield] = ACTIONS(871),
    [anon_sym_LBRACK] = ACTIONS(873),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(875),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(877),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(879),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(881),
    [anon_sym_DASH] = ACTIONS(881),
    [anon_sym_TILDE] = ACTIONS(867),
    [anon_sym_void] = ACTIONS(883),
    [anon_sym_delete] = ACTIONS(885),
    [anon_sym_PLUS_PLUS] = ACTIONS(887),
    [anon_sym_DASH_DASH] = ACTIONS(887),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [sym_number] = ACTIONS(891),
    [sym_this] = ACTIONS(893),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(895),
    [sym_false] = ACTIONS(895),
    [sym_null] = ACTIONS(895),
    [sym_undefined] = ACTIONS(897),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(859),
    [anon_sym_readonly] = ACTIONS(899),
    [anon_sym_get] = ACTIONS(859),
    [anon_sym_set] = ACTIONS(859),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(859),
    [anon_sym_public] = ACTIONS(859),
    [anon_sym_private] = ACTIONS(859),
    [anon_sym_protected] = ACTIONS(859),
    [anon_sym_override] = ACTIONS(859),
    [anon_sym_module] = ACTIONS(859),
    [anon_sym_any] = ACTIONS(901),
    [anon_sym_number] = ACTIONS(901),
    [anon_sym_boolean] = ACTIONS(901),
    [anon_sym_string] = ACTIONS(901),
    [anon_sym_symbol] = ACTIONS(901),
    [anon_sym_property] = ACTIONS(859),
    [anon_sym_signal] = ACTIONS(859),
    [anon_sym_on] = ACTIONS(859),
    [anon_sym_required] = ACTIONS(859),
    [anon_sym_component] = ACTIONS(859),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [90] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1341),
    [sym_expression] = STATE(2306),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(4644),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(4644),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4725),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1341),
    [sym_subscript_expression] = STATE(1341),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2819),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(4644),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2027),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_non_null_expression] = STATE(1341),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3434),
    [sym_constructor_type] = STATE(3434),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3434),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(467),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3434),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3434),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(903),
    [anon_sym_export] = ACTIONS(905),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(905),
    [anon_sym_namespace] = ACTIONS(907),
    [anon_sym_LBRACE] = ACTIONS(909),
    [anon_sym_typeof] = ACTIONS(911),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(905),
    [anon_sym_BANG] = ACTIONS(913),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(915),
    [anon_sym_of] = ACTIONS(905),
    [anon_sym_yield] = ACTIONS(917),
    [anon_sym_LBRACK] = ACTIONS(873),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(919),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(921),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(923),
    [anon_sym_DASH] = ACTIONS(923),
    [anon_sym_TILDE] = ACTIONS(913),
    [anon_sym_void] = ACTIONS(925),
    [anon_sym_delete] = ACTIONS(927),
    [anon_sym_PLUS_PLUS] = ACTIONS(929),
    [anon_sym_DASH_DASH] = ACTIONS(929),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [sym_number] = ACTIONS(891),
    [sym_this] = ACTIONS(893),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(895),
    [sym_false] = ACTIONS(895),
    [sym_null] = ACTIONS(895),
    [sym_undefined] = ACTIONS(931),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(905),
    [anon_sym_readonly] = ACTIONS(933),
    [anon_sym_get] = ACTIONS(905),
    [anon_sym_set] = ACTIONS(905),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(905),
    [anon_sym_public] = ACTIONS(905),
    [anon_sym_private] = ACTIONS(905),
    [anon_sym_protected] = ACTIONS(905),
    [anon_sym_override] = ACTIONS(905),
    [anon_sym_module] = ACTIONS(905),
    [anon_sym_any] = ACTIONS(935),
    [anon_sym_number] = ACTIONS(935),
    [anon_sym_boolean] = ACTIONS(935),
    [anon_sym_string] = ACTIONS(935),
    [anon_sym_symbol] = ACTIONS(935),
    [anon_sym_property] = ACTIONS(905),
    [anon_sym_signal] = ACTIONS(905),
    [anon_sym_on] = ACTIONS(905),
    [anon_sym_required] = ACTIONS(905),
    [anon_sym_component] = ACTIONS(905),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [91] = {
    [sym_import] = STATE(2086),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1771),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(2086),
    [sym_function] = STATE(2086),
    [sym_generator_function] = STATE(2086),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_string] = STATE(1984),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_non_null_expression] = STATE(1288),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_internal_module] = STATE(2058),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3434),
    [sym_constructor_type] = STATE(3434),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3434),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(522),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3434),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3434),
    [aux_sym_export_statement_repeat1] = STATE(3874),
    [sym_identifier] = ACTIONS(937),
    [anon_sym_export] = ACTIONS(939),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(939),
    [anon_sym_namespace] = ACTIONS(941),
    [anon_sym_LBRACE] = ACTIONS(943),
    [anon_sym_typeof] = ACTIONS(945),
    [anon_sym_import] = ACTIONS(947),
    [anon_sym_from] = ACTIONS(939),
    [anon_sym_BANG] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(949),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_of] = ACTIONS(939),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(951),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(953),
    [anon_sym_async] = ACTIONS(955),
    [anon_sym_function] = ACTIONS(957),
    [anon_sym_new] = ACTIONS(959),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(961),
    [anon_sym_DASH] = ACTIONS(961),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(963),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(965),
    [sym_number] = ACTIONS(967),
    [sym_this] = ACTIONS(969),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(971),
    [sym_false] = ACTIONS(971),
    [sym_null] = ACTIONS(971),
    [sym_undefined] = ACTIONS(973),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(939),
    [anon_sym_readonly] = ACTIONS(975),
    [anon_sym_get] = ACTIONS(939),
    [anon_sym_set] = ACTIONS(939),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(939),
    [anon_sym_public] = ACTIONS(939),
    [anon_sym_private] = ACTIONS(939),
    [anon_sym_protected] = ACTIONS(939),
    [anon_sym_override] = ACTIONS(939),
    [anon_sym_module] = ACTIONS(939),
    [anon_sym_any] = ACTIONS(977),
    [anon_sym_number] = ACTIONS(977),
    [anon_sym_boolean] = ACTIONS(977),
    [anon_sym_string] = ACTIONS(977),
    [anon_sym_symbol] = ACTIONS(977),
    [anon_sym_property] = ACTIONS(939),
    [anon_sym_signal] = ACTIONS(939),
    [anon_sym_on] = ACTIONS(939),
    [anon_sym_required] = ACTIONS(939),
    [anon_sym_component] = ACTIONS(939),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [92] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1163),
    [sym_expression] = STATE(2347),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3268),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3268),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4970),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1227),
    [sym_subscript_expression] = STATE(1227),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2849),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3268),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2375),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_non_null_expression] = STATE(1227),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3778),
    [sym_constructor_type] = STATE(3778),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3778),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(422),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3778),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3778),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(979),
    [anon_sym_export] = ACTIONS(981),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(981),
    [anon_sym_namespace] = ACTIONS(983),
    [anon_sym_LBRACE] = ACTIONS(985),
    [anon_sym_typeof] = ACTIONS(987),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(981),
    [anon_sym_BANG] = ACTIONS(76),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_of] = ACTIONS(981),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(989),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(991),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(64),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(993),
    [anon_sym_DASH] = ACTIONS(993),
    [anon_sym_TILDE] = ACTIONS(76),
    [anon_sym_void] = ACTIONS(78),
    [anon_sym_delete] = ACTIONS(80),
    [anon_sym_PLUS_PLUS] = ACTIONS(779),
    [anon_sym_DASH_DASH] = ACTIONS(779),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(995),
    [sym_number] = ACTIONS(997),
    [sym_this] = ACTIONS(999),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(1001),
    [sym_false] = ACTIONS(1001),
    [sym_null] = ACTIONS(1001),
    [sym_undefined] = ACTIONS(1003),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(981),
    [anon_sym_readonly] = ACTIONS(1005),
    [anon_sym_get] = ACTIONS(981),
    [anon_sym_set] = ACTIONS(981),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(981),
    [anon_sym_public] = ACTIONS(981),
    [anon_sym_private] = ACTIONS(981),
    [anon_sym_protected] = ACTIONS(981),
    [anon_sym_override] = ACTIONS(981),
    [anon_sym_module] = ACTIONS(981),
    [anon_sym_any] = ACTIONS(1007),
    [anon_sym_number] = ACTIONS(1007),
    [anon_sym_boolean] = ACTIONS(1007),
    [anon_sym_string] = ACTIONS(1007),
    [anon_sym_symbol] = ACTIONS(1007),
    [anon_sym_property] = ACTIONS(981),
    [anon_sym_signal] = ACTIONS(981),
    [anon_sym_on] = ACTIONS(981),
    [anon_sym_required] = ACTIONS(981),
    [anon_sym_component] = ACTIONS(981),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [93] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(1823),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(3625),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(3625),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1284),
    [sym_subscript_expression] = STATE(1284),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(3625),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2193),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_non_null_expression] = STATE(1284),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3778),
    [sym_constructor_type] = STATE(3778),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3778),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(414),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3778),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3778),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(1009),
    [anon_sym_export] = ACTIONS(1011),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(1011),
    [anon_sym_namespace] = ACTIONS(1013),
    [anon_sym_LBRACE] = ACTIONS(1015),
    [anon_sym_typeof] = ACTIONS(647),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(1011),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_of] = ACTIONS(1011),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(1017),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(663),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(671),
    [anon_sym_DASH] = ACTIONS(671),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(673),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_this] = ACTIONS(679),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(97),
    [sym_false] = ACTIONS(97),
    [sym_null] = ACTIONS(97),
    [sym_undefined] = ACTIONS(1019),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(1011),
    [anon_sym_readonly] = ACTIONS(1021),
    [anon_sym_get] = ACTIONS(1011),
    [anon_sym_set] = ACTIONS(1011),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(1011),
    [anon_sym_public] = ACTIONS(1011),
    [anon_sym_private] = ACTIONS(1011),
    [anon_sym_protected] = ACTIONS(1011),
    [anon_sym_override] = ACTIONS(1011),
    [anon_sym_module] = ACTIONS(1011),
    [anon_sym_any] = ACTIONS(1023),
    [anon_sym_number] = ACTIONS(1023),
    [anon_sym_boolean] = ACTIONS(1023),
    [anon_sym_string] = ACTIONS(1023),
    [anon_sym_symbol] = ACTIONS(1023),
    [anon_sym_property] = ACTIONS(1011),
    [anon_sym_signal] = ACTIONS(1011),
    [anon_sym_on] = ACTIONS(1011),
    [anon_sym_required] = ACTIONS(1011),
    [anon_sym_component] = ACTIONS(1011),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [94] = {
    [sym_import] = STATE(2086),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1772),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4882),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4882),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(2086),
    [sym_function] = STATE(2086),
    [sym_generator_function] = STATE(2086),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4883),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2818),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4882),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_string] = STATE(1984),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_non_null_expression] = STATE(1304),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_internal_module] = STATE(2058),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3434),
    [sym_constructor_type] = STATE(3434),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3434),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(387),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3434),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3434),
    [aux_sym_export_statement_repeat1] = STATE(3874),
    [sym_identifier] = ACTIONS(1025),
    [anon_sym_export] = ACTIONS(1027),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(1027),
    [anon_sym_namespace] = ACTIONS(1029),
    [anon_sym_LBRACE] = ACTIONS(943),
    [anon_sym_typeof] = ACTIONS(1031),
    [anon_sym_import] = ACTIONS(947),
    [anon_sym_from] = ACTIONS(1027),
    [anon_sym_BANG] = ACTIONS(1033),
    [anon_sym_LPAREN] = ACTIONS(949),
    [anon_sym_await] = ACTIONS(1035),
    [anon_sym_of] = ACTIONS(1027),
    [anon_sym_yield] = ACTIONS(1037),
    [anon_sym_LBRACK] = ACTIONS(951),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(1039),
    [anon_sym_class] = ACTIONS(953),
    [anon_sym_async] = ACTIONS(1041),
    [anon_sym_function] = ACTIONS(957),
    [anon_sym_new] = ACTIONS(1043),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(1045),
    [anon_sym_DASH] = ACTIONS(1045),
    [anon_sym_TILDE] = ACTIONS(1033),
    [anon_sym_void] = ACTIONS(1047),
    [anon_sym_delete] = ACTIONS(1049),
    [anon_sym_PLUS_PLUS] = ACTIONS(1051),
    [anon_sym_DASH_DASH] = ACTIONS(1051),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(965),
    [sym_number] = ACTIONS(967),
    [sym_this] = ACTIONS(969),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(971),
    [sym_false] = ACTIONS(971),
    [sym_null] = ACTIONS(971),
    [sym_undefined] = ACTIONS(1053),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(1027),
    [anon_sym_readonly] = ACTIONS(1055),
    [anon_sym_get] = ACTIONS(1027),
    [anon_sym_set] = ACTIONS(1027),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(1027),
    [anon_sym_public] = ACTIONS(1027),
    [anon_sym_private] = ACTIONS(1027),
    [anon_sym_protected] = ACTIONS(1027),
    [anon_sym_override] = ACTIONS(1027),
    [anon_sym_module] = ACTIONS(1027),
    [anon_sym_any] = ACTIONS(1057),
    [anon_sym_number] = ACTIONS(1057),
    [anon_sym_boolean] = ACTIONS(1057),
    [anon_sym_string] = ACTIONS(1057),
    [anon_sym_symbol] = ACTIONS(1057),
    [anon_sym_property] = ACTIONS(1027),
    [anon_sym_signal] = ACTIONS(1027),
    [anon_sym_on] = ACTIONS(1027),
    [anon_sym_required] = ACTIONS(1027),
    [anon_sym_component] = ACTIONS(1027),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [95] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1163),
    [sym_expression] = STATE(2391),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(4969),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(4969),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4970),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1163),
    [sym_subscript_expression] = STATE(1163),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2849),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(4969),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2027),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_non_null_expression] = STATE(1163),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3434),
    [sym_constructor_type] = STATE(3434),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3434),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(422),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3434),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3434),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(1059),
    [anon_sym_export] = ACTIONS(1061),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(1061),
    [anon_sym_namespace] = ACTIONS(1063),
    [anon_sym_LBRACE] = ACTIONS(863),
    [anon_sym_typeof] = ACTIONS(1065),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(1061),
    [anon_sym_BANG] = ACTIONS(76),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(43),
    [anon_sym_of] = ACTIONS(1061),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(873),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(1067),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(64),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(1069),
    [anon_sym_DASH] = ACTIONS(1069),
    [anon_sym_TILDE] = ACTIONS(76),
    [anon_sym_void] = ACTIONS(78),
    [anon_sym_delete] = ACTIONS(80),
    [anon_sym_PLUS_PLUS] = ACTIONS(779),
    [anon_sym_DASH_DASH] = ACTIONS(779),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [sym_number] = ACTIONS(891),
    [sym_this] = ACTIONS(893),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(895),
    [sym_false] = ACTIONS(895),
    [sym_null] = ACTIONS(895),
    [sym_undefined] = ACTIONS(1071),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(1061),
    [anon_sym_readonly] = ACTIONS(1073),
    [anon_sym_get] = ACTIONS(1061),
    [anon_sym_set] = ACTIONS(1061),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(1061),
    [anon_sym_public] = ACTIONS(1061),
    [anon_sym_private] = ACTIONS(1061),
    [anon_sym_protected] = ACTIONS(1061),
    [anon_sym_override] = ACTIONS(1061),
    [anon_sym_module] = ACTIONS(1061),
    [anon_sym_any] = ACTIONS(1075),
    [anon_sym_number] = ACTIONS(1075),
    [anon_sym_boolean] = ACTIONS(1075),
    [anon_sym_string] = ACTIONS(1075),
    [anon_sym_symbol] = ACTIONS(1075),
    [anon_sym_property] = ACTIONS(1061),
    [anon_sym_signal] = ACTIONS(1061),
    [anon_sym_on] = ACTIONS(1061),
    [anon_sym_required] = ACTIONS(1061),
    [anon_sym_component] = ACTIONS(1061),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [96] = {
    [sym_import] = STATE(2086),
    [sym_parenthesized_expression] = STATE(1332),
    [sym_expression] = STATE(2133),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4817),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4817),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(2086),
    [sym_function] = STATE(2086),
    [sym_generator_function] = STATE(2086),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4815),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1332),
    [sym_subscript_expression] = STATE(1332),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2848),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4817),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_string] = STATE(2291),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_non_null_expression] = STATE(1332),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_internal_module] = STATE(2058),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3434),
    [sym_constructor_type] = STATE(3434),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3434),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(575),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3434),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3434),
    [aux_sym_export_statement_repeat1] = STATE(3874),
    [sym_identifier] = ACTIONS(1077),
    [anon_sym_export] = ACTIONS(1079),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(1079),
    [anon_sym_namespace] = ACTIONS(1081),
    [anon_sym_LBRACE] = ACTIONS(1083),
    [anon_sym_typeof] = ACTIONS(1085),
    [anon_sym_import] = ACTIONS(947),
    [anon_sym_from] = ACTIONS(1079),
    [anon_sym_BANG] = ACTIONS(1087),
    [anon_sym_LPAREN] = ACTIONS(949),
    [anon_sym_await] = ACTIONS(1089),
    [anon_sym_of] = ACTIONS(1079),
    [anon_sym_yield] = ACTIONS(1091),
    [anon_sym_LBRACK] = ACTIONS(1093),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(953),
    [anon_sym_async] = ACTIONS(1095),
    [anon_sym_function] = ACTIONS(957),
    [anon_sym_new] = ACTIONS(1097),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(1099),
    [anon_sym_DASH] = ACTIONS(1099),
    [anon_sym_TILDE] = ACTIONS(1087),
    [anon_sym_void] = ACTIONS(1101),
    [anon_sym_delete] = ACTIONS(1103),
    [anon_sym_PLUS_PLUS] = ACTIONS(1105),
    [anon_sym_DASH_DASH] = ACTIONS(1105),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1107),
    [sym_number] = ACTIONS(1109),
    [sym_this] = ACTIONS(1111),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(1113),
    [sym_false] = ACTIONS(1113),
    [sym_null] = ACTIONS(1113),
    [sym_undefined] = ACTIONS(1115),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(1079),
    [anon_sym_readonly] = ACTIONS(1117),
    [anon_sym_get] = ACTIONS(1079),
    [anon_sym_set] = ACTIONS(1079),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(1079),
    [anon_sym_public] = ACTIONS(1079),
    [anon_sym_private] = ACTIONS(1079),
    [anon_sym_protected] = ACTIONS(1079),
    [anon_sym_override] = ACTIONS(1079),
    [anon_sym_module] = ACTIONS(1079),
    [anon_sym_any] = ACTIONS(1119),
    [anon_sym_number] = ACTIONS(1119),
    [anon_sym_boolean] = ACTIONS(1119),
    [anon_sym_string] = ACTIONS(1119),
    [anon_sym_symbol] = ACTIONS(1119),
    [anon_sym_property] = ACTIONS(1079),
    [anon_sym_signal] = ACTIONS(1079),
    [anon_sym_on] = ACTIONS(1079),
    [anon_sym_required] = ACTIONS(1079),
    [anon_sym_component] = ACTIONS(1079),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [97] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1317),
    [sym_expression] = STATE(2003),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(4921),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(4921),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4919),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1317),
    [sym_subscript_expression] = STATE(1317),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2850),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(4921),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(1679),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_non_null_expression] = STATE(1317),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3434),
    [sym_constructor_type] = STATE(3434),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3434),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(404),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3434),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3434),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(1121),
    [anon_sym_export] = ACTIONS(1123),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(1123),
    [anon_sym_namespace] = ACTIONS(1125),
    [anon_sym_LBRACE] = ACTIONS(1127),
    [anon_sym_typeof] = ACTIONS(1129),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(1123),
    [anon_sym_BANG] = ACTIONS(1131),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(1133),
    [anon_sym_of] = ACTIONS(1123),
    [anon_sym_yield] = ACTIONS(1135),
    [anon_sym_LBRACK] = ACTIONS(1137),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(1139),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(1141),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(1143),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(1145),
    [anon_sym_DASH] = ACTIONS(1145),
    [anon_sym_TILDE] = ACTIONS(1131),
    [anon_sym_void] = ACTIONS(1147),
    [anon_sym_delete] = ACTIONS(1149),
    [anon_sym_PLUS_PLUS] = ACTIONS(1151),
    [anon_sym_DASH_DASH] = ACTIONS(1151),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1153),
    [sym_number] = ACTIONS(1155),
    [sym_this] = ACTIONS(1157),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(1159),
    [sym_false] = ACTIONS(1159),
    [sym_null] = ACTIONS(1159),
    [sym_undefined] = ACTIONS(1161),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(1123),
    [anon_sym_readonly] = ACTIONS(1163),
    [anon_sym_get] = ACTIONS(1123),
    [anon_sym_set] = ACTIONS(1123),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(1123),
    [anon_sym_public] = ACTIONS(1123),
    [anon_sym_private] = ACTIONS(1123),
    [anon_sym_protected] = ACTIONS(1123),
    [anon_sym_override] = ACTIONS(1123),
    [anon_sym_module] = ACTIONS(1123),
    [anon_sym_any] = ACTIONS(1165),
    [anon_sym_number] = ACTIONS(1165),
    [anon_sym_boolean] = ACTIONS(1165),
    [anon_sym_string] = ACTIONS(1165),
    [anon_sym_symbol] = ACTIONS(1165),
    [anon_sym_property] = ACTIONS(1123),
    [anon_sym_signal] = ACTIONS(1123),
    [anon_sym_on] = ACTIONS(1123),
    [anon_sym_required] = ACTIONS(1123),
    [anon_sym_component] = ACTIONS(1123),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [98] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1343),
    [sym_expression] = STATE(2344),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(4727),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(4727),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4650),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1343),
    [sym_subscript_expression] = STATE(1343),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2822),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(4727),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(2027),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_non_null_expression] = STATE(1343),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3434),
    [sym_constructor_type] = STATE(3434),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3434),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(407),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3434),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3434),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(1167),
    [anon_sym_export] = ACTIONS(1169),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(1169),
    [anon_sym_namespace] = ACTIONS(1171),
    [anon_sym_LBRACE] = ACTIONS(1173),
    [anon_sym_typeof] = ACTIONS(1175),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(1169),
    [anon_sym_BANG] = ACTIONS(1177),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(1179),
    [anon_sym_of] = ACTIONS(1169),
    [anon_sym_yield] = ACTIONS(1181),
    [anon_sym_LBRACK] = ACTIONS(873),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(1183),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(1185),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(1187),
    [anon_sym_DASH] = ACTIONS(1187),
    [anon_sym_TILDE] = ACTIONS(1177),
    [anon_sym_void] = ACTIONS(1189),
    [anon_sym_delete] = ACTIONS(1191),
    [anon_sym_PLUS_PLUS] = ACTIONS(1193),
    [anon_sym_DASH_DASH] = ACTIONS(1193),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(889),
    [sym_number] = ACTIONS(891),
    [sym_this] = ACTIONS(893),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(895),
    [sym_false] = ACTIONS(895),
    [sym_null] = ACTIONS(895),
    [sym_undefined] = ACTIONS(1195),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(1169),
    [anon_sym_readonly] = ACTIONS(1197),
    [anon_sym_get] = ACTIONS(1169),
    [anon_sym_set] = ACTIONS(1169),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(1169),
    [anon_sym_public] = ACTIONS(1169),
    [anon_sym_private] = ACTIONS(1169),
    [anon_sym_protected] = ACTIONS(1169),
    [anon_sym_override] = ACTIONS(1169),
    [anon_sym_module] = ACTIONS(1169),
    [anon_sym_any] = ACTIONS(1199),
    [anon_sym_number] = ACTIONS(1199),
    [anon_sym_boolean] = ACTIONS(1199),
    [anon_sym_string] = ACTIONS(1199),
    [anon_sym_symbol] = ACTIONS(1199),
    [anon_sym_property] = ACTIONS(1169),
    [anon_sym_signal] = ACTIONS(1169),
    [anon_sym_on] = ACTIONS(1169),
    [anon_sym_required] = ACTIONS(1169),
    [anon_sym_component] = ACTIONS(1169),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [99] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(1652),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(4868),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(4868),
    [sym_nested_identifier] = STATE(4914),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1255),
    [sym_subscript_expression] = STATE(1255),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(4868),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(1679),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3586),
    [sym_non_null_expression] = STATE(1255),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_nested_type_identifier] = STATE(2816),
    [sym__type] = STATE(3434),
    [sym_constructor_type] = STATE(3434),
    [sym__primary_type] = STATE(2823),
    [sym_template_literal_type] = STATE(2821),
    [sym_infer_type] = STATE(3434),
    [sym_conditional_type] = STATE(2821),
    [sym_generic_type] = STATE(2821),
    [sym_type_query] = STATE(2821),
    [sym_index_type_query] = STATE(2821),
    [sym_lookup_type] = STATE(2821),
    [sym_literal_type] = STATE(2821),
    [sym__number] = STATE(2820),
    [sym_existential_type] = STATE(2821),
    [sym_flow_maybe_type] = STATE(2821),
    [sym_parenthesized_type] = STATE(2821),
    [sym_predefined_type] = STATE(2821),
    [sym_type_arguments] = STATE(414),
    [sym_object_type] = STATE(2821),
    [sym_type_parameters] = STATE(4589),
    [sym_array_type] = STATE(2821),
    [sym_tuple_type] = STATE(2821),
    [sym_readonly_type] = STATE(3434),
    [sym_union_type] = STATE(2821),
    [sym_intersection_type] = STATE(2821),
    [sym_function_type] = STATE(3434),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(1201),
    [anon_sym_export] = ACTIONS(839),
    [anon_sym_STAR] = ACTIONS(639),
    [anon_sym_type] = ACTIONS(839),
    [anon_sym_namespace] = ACTIONS(841),
    [anon_sym_LBRACE] = ACTIONS(1127),
    [anon_sym_typeof] = ACTIONS(1203),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(839),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_of] = ACTIONS(839),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(1137),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(847),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_new] = ACTIONS(663),
    [anon_sym_AMP] = ACTIONS(667),
    [anon_sym_PIPE] = ACTIONS(669),
    [anon_sym_PLUS] = ACTIONS(1205),
    [anon_sym_DASH] = ACTIONS(1205),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(673),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1153),
    [sym_number] = ACTIONS(1155),
    [sym_this] = ACTIONS(1157),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(1159),
    [sym_false] = ACTIONS(1159),
    [sym_null] = ACTIONS(1159),
    [sym_undefined] = ACTIONS(1207),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(839),
    [anon_sym_readonly] = ACTIONS(853),
    [anon_sym_get] = ACTIONS(839),
    [anon_sym_set] = ACTIONS(839),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_declare] = ACTIONS(839),
    [anon_sym_public] = ACTIONS(839),
    [anon_sym_private] = ACTIONS(839),
    [anon_sym_protected] = ACTIONS(839),
    [anon_sym_override] = ACTIONS(839),
    [anon_sym_module] = ACTIONS(839),
    [anon_sym_any] = ACTIONS(1209),
    [anon_sym_number] = ACTIONS(1209),
    [anon_sym_boolean] = ACTIONS(1209),
    [anon_sym_string] = ACTIONS(1209),
    [anon_sym_symbol] = ACTIONS(1209),
    [anon_sym_property] = ACTIONS(839),
    [anon_sym_signal] = ACTIONS(839),
    [anon_sym_on] = ACTIONS(839),
    [anon_sym_required] = ACTIONS(839),
    [anon_sym_component] = ACTIONS(839),
    [anon_sym_abstract] = ACTIONS(109),
    [anon_sym_infer] = ACTIONS(111),
    [anon_sym_keyof] = ACTIONS(113),
    [anon_sym_unknown] = ACTIONS(115),
    [anon_sym_never] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_LBRACE_PIPE] = ACTIONS(117),
  },
  [100] = {
    [sym_import] = STATE(1648),
    [sym_parenthesized_expression] = STATE(1255),
    [sym_expression] = STATE(1723),
    [sym_primary_expression] = STATE(1640),
    [sym_yield_expression] = STATE(1639),
    [sym_object] = STATE(1648),
    [sym_object_pattern] = STATE(4868),
    [sym_array] = STATE(1648),
    [sym_array_pattern] = STATE(4868),
    [sym_class] = STATE(1648),
    [sym_function] = STATE(1648),
    [sym_generator_function] = STATE(1648),
    [sym_arrow_function] = STATE(1648),
    [sym__call_signature] = STATE(4865),
    [sym_call_expression] = STATE(1648),
    [sym_new_expression] = STATE(1639),
    [sym_await_expression] = STATE(1639),
    [sym_member_expression] = STATE(1255),
    [sym_subscript_expression] = STATE(1255),
    [sym_assignment_expression] = STATE(1639),
    [sym__augmented_assignment_lhs] = STATE(2838),
    [sym_augmented_assignment_expression] = STATE(1639),
    [sym__destructuring_pattern] = STATE(4868),
    [sym_ternary_expression] = STATE(1639),
    [sym_binary_expression] = STATE(1639),
    [sym_unary_expression] = STATE(1639),
    [sym_update_expression] = STATE(1639),
    [sym_string] = STATE(1648),
    [sym_template_string] = STATE(1648),
    [sym_regex] = STATE(1648),
    [sym_meta_property] = STATE(1648),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1255),
    [sym_type_assertion] = STATE(1639),
    [sym_as_expression] = STATE(1639),
    [sym_internal_module] = STATE(1639),
    [sym_type_arguments] = STATE(414),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3914),
    [sym_identifier] = ACTIONS(1211),
    [anon_sym_export] = ACTIONS(839),
    [anon_sym_STAR] = ACTIONS(1213),
    [anon_sym_type] = ACTIONS(839),
    [anon_sym_as] = ACTIONS(1215),
    [anon_sym_namespace] = ACTIONS(841),
    [anon_sym_LBRACE] = ACTIONS(1217),
    [anon_sym_COMMA] = ACTIONS(1219),
    [anon_sym_RBRACE] = ACTIONS(1219),
    [anon_sym_typeof] = ACTIONS(675),
    [anon_sym_import] = ACTIONS(36),
    [anon_sym_from] = ACTIONS(839),
    [anon_sym_BANG] = ACTIONS(675),
    [anon_sym_LPAREN] = ACTIONS(1221),
    [anon_sym_RPAREN] = ACTIONS(1219),
    [anon_sym_await] = ACTIONS(651),
    [anon_sym_in] = ACTIONS(1215),
    [anon_sym_of] = ACTIONS(839),
    [anon_sym_COLON] = ACTIONS(1219),
    [anon_sym_yield] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(1223),
    [anon_sym_RBRACK] = ACTIONS(1219),
    [anon_sym_LT] = ACTIONS(49),
    [anon_sym_GT] = ACTIONS(1215),
    [anon_sym_SLASH] = ACTIONS(659),
    [anon_sym_DOT] = ACTIONS(1215),
    [anon_sym_class] = ACTIONS(54),
    [anon_sym_async] = ACTIONS(847),
    [anon_sym_function] = ACTIONS(58),
    [anon_sym_QMARK_DOT] = ACTIONS(1219),
    [anon_sym_new] = ACTIONS(1225),
    [anon_sym_AMP_AMP] = ACTIONS(1219),
    [anon_sym_PIPE_PIPE] = ACTIONS(1219),
    [anon_sym_GT_GT] = ACTIONS(1215),
    [anon_sym_GT_GT_GT] = ACTIONS(1219),
    [anon_sym_LT_LT] = ACTIONS(1219),
    [anon_sym_AMP] = ACTIONS(1215),
    [anon_sym_CARET] = ACTIONS(1219),
    [anon_sym_PIPE] = ACTIONS(1215),
    [anon_sym_PLUS] = ACTIONS(675),
    [anon_sym_DASH] = ACTIONS(675),
    [anon_sym_PERCENT] = ACTIONS(1219),
    [anon_sym_STAR_STAR] = ACTIONS(1219),
    [anon_sym_LT_EQ] = ACTIONS(1219),
    [anon_sym_EQ_EQ] = ACTIONS(1215),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1219),
    [anon_sym_BANG_EQ] = ACTIONS(1215),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1219),
    [anon_sym_GT_EQ] = ACTIONS(1219),
    [anon_sym_QMARK_QMARK] = ACTIONS(1219),
    [anon_sym_instanceof] = ACTIONS(1215),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_void] = ACTIONS(675),
    [anon_sym_delete] = ACTIONS(675),
    [anon_sym_PLUS_PLUS] = ACTIONS(677),
    [anon_sym_DASH_DASH] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_SQUOTE] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1227),
    [sym_number] = ACTIONS(727),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(1229),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(839),
    [anon_sym_readonly] = ACTIONS(839),
    [anon_sym_get] = ACTIONS(839),
    [anon_sym_set] = ACTIONS(839),
    [anon_sym_declare] = ACTIONS(839),
    [anon_sym_public] = ACTIONS(839),
    [anon_sym_private] = ACTIONS(839),
    [anon_sym_protected] = ACTIONS(839),
    [anon_sym_override] = ACTIONS(839),
    [anon_sym_module] = ACTIONS(839),
    [anon_sym_any] = ACTIONS(839),
    [anon_sym_number] = ACTIONS(839),
    [anon_sym_boolean] = ACTIONS(839),
    [anon_sym_string] = ACTIONS(839),
    [anon_sym_symbol] = ACTIONS(839),
    [anon_sym_property] = ACTIONS(839),
    [anon_sym_signal] = ACTIONS(839),
    [anon_sym_on] = ACTIONS(839),
    [anon_sym_required] = ACTIONS(839),
    [anon_sym_component] = ACTIONS(839),
    [sym__ternary_qmark] = ACTIONS(1219),
  },
  [101] = {
    [sym_import] = STATE(2086),
    [sym_parenthesized_expression] = STATE(1288),
    [sym_expression] = STATE(1842),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4891),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4891),
    [sym_class] = STATE(2086),
    [sym_function] = STATE(2086),
    [sym_generator_function] = STATE(2086),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4892),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1288),
    [sym_subscript_expression] = STATE(1288),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2859),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4891),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1288),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_internal_module] = STATE(2058),
    [sym_type_arguments] = STATE(522),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3874),
    [sym_identifier] = ACTIONS(1231),
    [anon_sym_export] = ACTIONS(939),
    [anon_sym_STAR] = ACTIONS(1233),
    [anon_sym_type] = ACTIONS(939),
    [anon_sym_as] = ACTIONS(1215),
    [anon_sym_namespace] = ACTIONS(941),
    [anon_sym_LBRACE] = ACTIONS(1235),
    [anon_sym_COMMA] = ACTIONS(1219),
    [anon_sym_RBRACE] = ACTIONS(1219),
    [anon_sym_typeof] = ACTIONS(143),
    [anon_sym_import] = ACTIONS(947),
    [anon_sym_from] = ACTIONS(939),
    [anon_sym_BANG] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(165),
    [anon_sym_in] = ACTIONS(1215),
    [anon_sym_of] = ACTIONS(939),
    [anon_sym_SEMI] = ACTIONS(1219),
    [anon_sym_yield] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(49),
    [anon_sym_GT] = ACTIONS(1215),
    [anon_sym_SLASH] = ACTIONS(193),
    [anon_sym_DOT] = ACTIONS(1215),
    [anon_sym_class] = ACTIONS(953),
    [anon_sym_async] = ACTIONS(955),
    [anon_sym_function] = ACTIONS(957),
    [anon_sym_QMARK_DOT] = ACTIONS(1219),
    [anon_sym_new] = ACTIONS(201),
    [anon_sym_AMP_AMP] = ACTIONS(1219),
    [anon_sym_PIPE_PIPE] = ACTIONS(1219),
    [anon_sym_GT_GT] = ACTIONS(1215),
    [anon_sym_GT_GT_GT] = ACTIONS(1219),
    [anon_sym_LT_LT] = ACTIONS(1219),
    [anon_sym_AMP] = ACTIONS(1215),
    [anon_sym_CARET] = ACTIONS(1219),
    [anon_sym_PIPE] = ACTIONS(1215),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_PERCENT] = ACTIONS(1219),
    [anon_sym_STAR_STAR] = ACTIONS(1219),
    [anon_sym_LT_EQ] = ACTIONS(1219),
    [anon_sym_EQ_EQ] = ACTIONS(1215),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1219),
    [anon_sym_BANG_EQ] = ACTIONS(1215),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1219),
    [anon_sym_GT_EQ] = ACTIONS(1219),
    [anon_sym_QMARK_QMARK] = ACTIONS(1219),
    [anon_sym_instanceof] = ACTIONS(1215),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_void] = ACTIONS(143),
    [anon_sym_delete] = ACTIONS(143),
    [anon_sym_PLUS_PLUS] = ACTIONS(205),
    [anon_sym_DASH_DASH] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(219),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(939),
    [anon_sym_readonly] = ACTIONS(939),
    [anon_sym_get] = ACTIONS(939),
    [anon_sym_set] = ACTIONS(939),
    [anon_sym_declare] = ACTIONS(939),
    [anon_sym_public] = ACTIONS(939),
    [anon_sym_private] = ACTIONS(939),
    [anon_sym_protected] = ACTIONS(939),
    [anon_sym_override] = ACTIONS(939),
    [anon_sym_module] = ACTIONS(939),
    [anon_sym_any] = ACTIONS(939),
    [anon_sym_number] = ACTIONS(939),
    [anon_sym_boolean] = ACTIONS(939),
    [anon_sym_string] = ACTIONS(939),
    [anon_sym_symbol] = ACTIONS(939),
    [anon_sym_property] = ACTIONS(939),
    [anon_sym_signal] = ACTIONS(939),
    [anon_sym_on] = ACTIONS(939),
    [anon_sym_required] = ACTIONS(939),
    [anon_sym_component] = ACTIONS(939),
    [sym__automatic_semicolon] = ACTIONS(1219),
    [sym__ternary_qmark] = ACTIONS(1219),
  },
  [102] = {
    [sym_import] = STATE(2086),
    [sym_parenthesized_expression] = STATE(1304),
    [sym_expression] = STATE(1814),
    [sym_primary_expression] = STATE(2060),
    [sym_yield_expression] = STATE(2058),
    [sym_object] = STATE(2086),
    [sym_object_pattern] = STATE(4882),
    [sym_array] = STATE(2086),
    [sym_array_pattern] = STATE(4882),
    [sym_class] = STATE(2086),
    [sym_function] = STATE(2086),
    [sym_generator_function] = STATE(2086),
    [sym_arrow_function] = STATE(2086),
    [sym__call_signature] = STATE(4883),
    [sym_call_expression] = STATE(2086),
    [sym_new_expression] = STATE(2058),
    [sym_await_expression] = STATE(2058),
    [sym_member_expression] = STATE(1304),
    [sym_subscript_expression] = STATE(1304),
    [sym_assignment_expression] = STATE(2058),
    [sym__augmented_assignment_lhs] = STATE(2818),
    [sym_augmented_assignment_expression] = STATE(2058),
    [sym__destructuring_pattern] = STATE(4882),
    [sym_ternary_expression] = STATE(2058),
    [sym_binary_expression] = STATE(2058),
    [sym_unary_expression] = STATE(2058),
    [sym_update_expression] = STATE(2058),
    [sym_string] = STATE(2086),
    [sym_template_string] = STATE(2086),
    [sym_regex] = STATE(2086),
    [sym_meta_property] = STATE(2086),
    [sym_decorator] = STATE(1140),
    [sym_formal_parameters] = STATE(3380),
    [sym_non_null_expression] = STATE(1304),
    [sym_type_assertion] = STATE(2058),
    [sym_as_expression] = STATE(2058),
    [sym_internal_module] = STATE(2058),
    [sym_type_arguments] = STATE(387),
    [sym_type_parameters] = STATE(4355),
    [aux_sym_export_statement_repeat1] = STATE(3874),
    [sym_identifier] = ACTIONS(1237),
    [anon_sym_export] = ACTIONS(1027),
    [anon_sym_STAR] = ACTIONS(1239),
    [anon_sym_type] = ACTIONS(1027),
    [anon_sym_as] = ACTIONS(1215),
    [anon_sym_namespace] = ACTIONS(1029),
    [anon_sym_LBRACE] = ACTIONS(1235),
    [anon_sym_COMMA] = ACTIONS(1219),
    [anon_sym_typeof] = ACTIONS(1049),
    [anon_sym_import] = ACTIONS(947),
    [anon_sym_from] = ACTIONS(1027),
    [anon_sym_BANG] = ACTIONS(1049),
    [anon_sym_LPAREN] = ACTIONS(163),
    [anon_sym_await] = ACTIONS(1035),
    [anon_sym_in] = ACTIONS(1215),
    [anon_sym_of] = ACTIONS(1027),
    [anon_sym_SEMI] = ACTIONS(1219),
    [anon_sym_yield] = ACTIONS(1037),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(49),
    [anon_sym_GT] = ACTIONS(1215),
    [anon_sym_SLASH] = ACTIONS(1039),
    [anon_sym_DOT] = ACTIONS(1215),
    [anon_sym_class] = ACTIONS(953),
    [anon_sym_async] = ACTIONS(1041),
    [anon_sym_function] = ACTIONS(957),
    [anon_sym_QMARK_DOT] = ACTIONS(1219),
    [anon_sym_new] = ACTIONS(1241),
    [anon_sym_AMP_AMP] = ACTIONS(1219),
    [anon_sym_PIPE_PIPE] = ACTIONS(1219),
    [anon_sym_GT_GT] = ACTIONS(1215),
    [anon_sym_GT_GT_GT] = ACTIONS(1219),
    [anon_sym_LT_LT] = ACTIONS(1219),
    [anon_sym_AMP] = ACTIONS(1215),
    [anon_sym_CARET] = ACTIONS(1219),
    [anon_sym_PIPE] = ACTIONS(1215),
    [anon_sym_PLUS] = ACTIONS(1049),
    [anon_sym_DASH] = ACTIONS(1049),
    [anon_sym_PERCENT] = ACTIONS(1219),
    [anon_sym_STAR_STAR] = ACTIONS(1219),
    [anon_sym_LT_EQ] = ACTIONS(1219),
    [anon_sym_EQ_EQ] = ACTIONS(1215),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1219),
    [anon_sym_BANG_EQ] = ACTIONS(1215),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1219),
    [anon_sym_GT_EQ] = ACTIONS(1219),
    [anon_sym_QMARK_QMARK] = ACTIONS(1219),
    [anon_sym_instanceof] = ACTIONS(1215),
    [anon_sym_TILDE] = ACTIONS(1033),
    [anon_sym_void] = ACTIONS(1049),
    [anon_sym_delete] = ACTIONS(1049),
    [anon_sym_PLUS_PLUS] = ACTIONS(1051),
    [anon_sym_DASH_DASH] = ACTIONS(1051),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_SQUOTE] = ACTIONS(209),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(211),
    [sym_number] = ACTIONS(345),
    [sym_this] = ACTIONS(217),
    [sym_super] = ACTIONS(217),
    [sym_true] = ACTIONS(217),
    [sym_false] = ACTIONS(217),
    [sym_null] = ACTIONS(217),
    [sym_undefined] = ACTIONS(1243),
    [anon_sym_AT] = ACTIONS(101),
    [anon_sym_static] = ACTIONS(1027),
    [anon_sym_readonly] = ACTIONS(1027),
    [anon_sym_get] = ACTIONS(1027),
    [anon_sym_set] = ACTI