#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 3501
#define LARGE_STATE_COUNT 158
#define SYMBOL_COUNT 164
#define ALIAS_COUNT 0
#define TOKEN_COUNT 103
#define EXTERNAL_TOKEN_COUNT 15
#define FIELD_COUNT 19
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 75

enum {
  sym_word = 1,
  anon_sym_LF = 2,
  anon_sym_for = 3,
  anon_sym_select = 4,
  anon_sym_in = 5,
  anon_sym_LPAREN_LPAREN = 6,
  anon_sym_RPAREN_RPAREN = 7,
  anon_sym_SEMI = 8,
  anon_sym_while = 9,
  anon_sym_until = 10,
  anon_sym_do = 11,
  anon_sym_done = 12,
  anon_sym_if = 13,
  anon_sym_then = 14,
  anon_sym_fi = 15,
  anon_sym_elif = 16,
  anon_sym_else = 17,
  anon_sym_case = 18,
  anon_sym_esac = 19,
  anon_sym_PIPE = 20,
  anon_sym_RPAREN = 21,
  anon_sym_SEMI_SEMI = 22,
  anon_sym_SEMI_AMP = 23,
  anon_sym_SEMI_SEMI_AMP = 24,
  anon_sym_function = 25,
  anon_sym_LPAREN = 26,
  anon_sym_LBRACE = 27,
  anon_sym_RBRACE = 28,
  anon_sym_PIPE_AMP = 29,
  anon_sym_AMP_AMP = 30,
  anon_sym_PIPE_PIPE = 31,
  anon_sym_BANG = 32,
  anon_sym_LBRACK = 33,
  anon_sym_RBRACK = 34,
  anon_sym_LBRACK_LBRACK = 35,
  anon_sym_RBRACK_RBRACK = 36,
  anon_sym_declare = 37,
  anon_sym_typeset = 38,
  anon_sym_export = 39,
  anon_sym_readonly = 40,
  anon_sym_local = 41,
  anon_sym_unset = 42,
  anon_sym_unsetenv = 43,
  anon_sym_EQ_TILDE = 44,
  anon_sym_EQ_EQ = 45,
  anon_sym_EQ = 46,
  anon_sym_PLUS_EQ = 47,
  anon_sym_LT = 48,
  anon_sym_GT = 49,
  anon_sym_GT_GT = 50,
  anon_sym_AMP_GT = 51,
  anon_sym_AMP_GT_GT = 52,
  anon_sym_LT_AMP = 53,
  anon_sym_GT_AMP = 54,
  anon_sym_GT_PIPE = 55,
  anon_sym_LT_LT = 56,
  anon_sym_LT_LT_DASH = 57,
  anon_sym_LT_LT_LT = 58,
  anon_sym_BANG_EQ = 59,
  anon_sym_PLUS = 60,
  anon_sym_DASH = 61,
  anon_sym_DASH_EQ = 62,
  anon_sym_LT_EQ = 63,
  anon_sym_GT_EQ = 64,
  anon_sym_QMARK = 65,
  anon_sym_COLON = 66,
  anon_sym_PLUS_PLUS = 67,
  anon_sym_DASH_DASH = 68,
  anon_sym_DOLLAR = 69,
  sym__special_character = 70,
  anon_sym_DQUOTE = 71,
  sym__string_content = 72,
  sym_raw_string = 73,
  sym_ansi_c_string = 74,
  anon_sym_POUND = 75,
  anon_sym_DOLLAR_LBRACE = 76,
  anon_sym_SLASH = 77,
  anon_sym_COLON_QMARK = 78,
  anon_sym_COLON_DASH = 79,
  anon_sym_PERCENT = 80,
  anon_sym_DOLLAR_LPAREN = 81,
  anon_sym_BQUOTE = 82,
  anon_sym_LT_LPAREN = 83,
  anon_sym_GT_LPAREN = 84,
  sym_comment = 85,
  aux_sym__simple_variable_name_token1 = 86,
  anon_sym_STAR = 87,
  anon_sym_AT = 88,
  anon_sym_0 = 89,
  anon_sym__ = 90,
  sym_test_operator = 91,
  anon_sym_AMP = 92,
  sym_heredoc_start = 93,
  sym__simple_heredoc_body = 94,
  sym__heredoc_body_beginning = 95,
  sym__heredoc_body_middle = 96,
  sym__heredoc_body_end = 97,
  sym_file_descriptor = 98,
  sym__empty_value = 99,
  sym__concat = 100,
  sym_variable_name = 101,
  sym_regex = 102,
  sym_program = 103,
  sym__statements = 104,
  aux_sym__statements2 = 105,
  sym__terminated_statement = 106,
  sym_redirected_statement = 107,
  sym_for_statement = 108,
  sym_c_style_for_statement = 109,
  sym_while_statement = 110,
  sym_do_group = 111,
  sym_if_statement = 112,
  sym_elif_clause = 113,
  sym_else_clause = 114,
  sym_case_statement = 115,
  sym_case_item = 116,
  sym_last_case_item = 117,
  sym_function_definition = 118,
  sym_compound_statement = 119,
  sym_subshell = 120,
  sym_pipeline = 121,
  sym_list = 122,
  sym_negated_command = 123,
  sym_test_command = 124,
  sym_declaration_command = 125,
  sym_unset_command = 126,
  sym_command = 127,
  sym_command_name = 128,
  sym_variable_assignment = 129,
  sym_subscript = 130,
  sym_file_redirect = 131,
  sym_heredoc_redirect = 132,
  sym_heredoc_body = 133,
  sym_herestring_redirect = 134,
  sym__expression = 135,
  sym_binary_expression = 136,
  sym_ternary_expression = 137,
  sym_unary_expression = 138,
  sym_postfix_expression = 139,
  sym_parenthesized_expression = 140,
  sym_concatenation = 141,
  sym_string = 142,
  sym_translated_string = 143,
  sym_array = 144,
  sym_simple_expansion = 145,
  sym_expansion = 146,
  sym_command_substitution = 147,
  sym_process_substitution = 148,
  aux_sym__statements_repeat1 = 149,
  aux_sym_redirected_statement_repeat1 = 150,
  aux_sym_for_statement_repeat1 = 151,
  aux_sym_if_statement_repeat1 = 152,
  aux_sym_case_statement_repeat1 = 153,
  aux_sym_case_item_repeat1 = 154,
  aux_sym_declaration_command_repeat1 = 155,
  aux_sym_unset_command_repeat1 = 156,
  aux_sym_command_repeat1 = 157,
  aux_sym_command_repeat2 = 158,
  aux_sym_heredoc_body_repeat1 = 159,
  aux_sym__literal_repeat1 = 160,
  aux_sym_concatenation_repeat1 = 161,
  aux_sym_string_repeat1 = 162,
  aux_sym_expansion_repeat1 = 163,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_word] = "word",
  [anon_sym_LF] = "\n",
  [anon_sym_for] = "for",
  [anon_sym_select] = "select",
  [anon_sym_in] = "in",
  [anon_sym_LPAREN_LPAREN] = "((",
  [anon_sym_RPAREN_RPAREN] = "))",
  [anon_sym_SEMI] = ";",
  [anon_sym_while] = "while",
  [anon_sym_until] = "until",
  [anon_sym_do] = "do",
  [anon_sym_done] = "done",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_fi] = "fi",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_case] = "case",
  [anon_sym_esac] = "esac",
  [anon_sym_PIPE] = "|",
  [anon_sym_RPAREN] = ")",
  [anon_sym_SEMI_SEMI] = ";;",
  [anon_sym_SEMI_AMP] = ";&",
  [anon_sym_SEMI_SEMI_AMP] = ";;&",
  [anon_sym_function] = "function",
  [anon_sym_LPAREN] = "(",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_PIPE_AMP] = "|&",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_BANG] = "!",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym_declare] = "declare",
  [anon_sym_typeset] = "typeset",
  [anon_sym_export] = "export",
  [anon_sym_readonly] = "readonly",
  [anon_sym_local] = "local",
  [anon_sym_unset] = "unset",
  [anon_sym_unsetenv] = "unsetenv",
  [anon_sym_EQ_TILDE] = "=~",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_AMP_GT] = "&>",
  [anon_sym_AMP_GT_GT] = "&>>",
  [anon_sym_LT_AMP] = "<&",
  [anon_sym_GT_AMP] = ">&",
  [anon_sym_GT_PIPE] = ">|",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_LT_LT_DASH] = "<<-",
  [anon_sym_LT_LT_LT] = "<<<",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COLON] = ":",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DOLLAR] = "$",
  [sym__special_character] = "_special_character",
  [anon_sym_DQUOTE] = "\"",
  [sym__string_content] = "_string_content",
  [sym_raw_string] = "raw_string",
  [sym_ansi_c_string] = "ansi_c_string",
  [anon_sym_POUND] = "#",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH] = "/",
  [anon_sym_COLON_QMARK] = ":\?",
  [anon_sym_COLON_DASH] = ":-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOLLAR_LPAREN] = "$(",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_LT_LPAREN] = "<(",
  [anon_sym_GT_LPAREN] = ">(",
  [sym_comment] = "comment",
  [aux_sym__simple_variable_name_token1] = "variable_name",
  [anon_sym_STAR] = "special_variable_name",
  [anon_sym_AT] = "special_variable_name",
  [anon_sym_0] = "special_variable_name",
  [anon_sym__] = "special_variable_name",
  [sym_test_operator] = "test_operator",
  [anon_sym_AMP] = "&",
  [sym_heredoc_start] = "heredoc_start",
  [sym__simple_heredoc_body] = "_simple_heredoc_body",
  [sym__heredoc_body_beginning] = "_heredoc_body_beginning",
  [sym__heredoc_body_middle] = "_heredoc_body_middle",
  [sym__heredoc_body_end] = "_heredoc_body_end",
  [sym_file_descriptor] = "file_descriptor",
  [sym__empty_value] = "_empty_value",
  [sym__concat] = "_concat",
  [sym_variable_name] = "variable_name",
  [sym_regex] = "regex",
  [sym_program] = "program",
  [sym__statements] = "_statements",
  [aux_sym__statements2] = "_statements2",
  [sym__terminated_statement] = "_terminated_statement",
  [sym_redirected_statement] = "redirected_statement",
  [sym_for_statement] = "for_statement",
  [sym_c_style_for_statement] = "c_style_for_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_group] = "do_group",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_case_statement] = "case_statement",
  [sym_case_item] = "case_item",
  [sym_last_case_item] = "case_item",
  [sym_function_definition] = "function_definition",
  [sym_compound_statement] = "compound_statement",
  [sym_subshell] = "subshell",
  [sym_pipeline] = "pipeline",
  [sym_list] = "list",
  [sym_negated_command] = "negated_command",
  [sym_test_command] = "test_command",
  [sym_declaration_command] = "declaration_command",
  [sym_unset_command] = "unset_command",
  [sym_command] = "command",
  [sym_command_name] = "command_name",
  [sym_variable_assignment] = "variable_assignment",
  [sym_subscript] = "subscript",
  [sym_file_redirect] = "file_redirect",
  [sym_heredoc_redirect] = "heredoc_redirect",
  [sym_heredoc_body] = "heredoc_body",
  [sym_herestring_redirect] = "herestring_redirect",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_postfix_expression] = "postfix_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_concatenation] = "concatenation",
  [sym_string] = "string",
  [sym_translated_string] = "translated_string",
  [sym_array] = "array",
  [sym_simple_expansion] = "simple_expansion",
  [sym_expansion] = "expansion",
  [sym_command_substitution] = "command_substitution",
  [sym_process_substitution] = "process_substitution",
  [aux_sym__statements_repeat1] = "_statements_repeat1",
  [aux_sym_redirected_statement_repeat1] = "redirected_statement_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym_case_item_repeat1] = "case_item_repeat1",
  [aux_sym_declaration_command_repeat1] = "declaration_command_repeat1",
  [aux_sym_unset_command_repeat1] = "unset_command_repeat1",
  [aux_sym_command_repeat1] = "command_repeat1",
  [aux_sym_command_repeat2] = "command_repeat2",
  [aux_sym_heredoc_body_repeat1] = "heredoc_body_repeat1",
  [aux_sym__literal_repeat1] = "_literal_repeat1",
  [aux_sym_concatenation_repeat1] = "concatenation_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_expansion_repeat1] = "expansion_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_word] = sym_word,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_select] = anon_sym_select,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_LPAREN_LPAREN] = anon_sym_LPAREN_LPAREN,
  [anon_sym_RPAREN_RPAREN] = anon_sym_RPAREN_RPAREN,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_until] = anon_sym_until,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_done] = anon_sym_done,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_fi] = anon_sym_fi,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_esac] = anon_sym_esac,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_SEMI_SEMI] = anon_sym_SEMI_SEMI,
  [anon_sym_SEMI_AMP] = anon_sym_SEMI_AMP,
  [anon_sym_SEMI_SEMI_AMP] = anon_sym_SEMI_SEMI_AMP,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_PIPE_AMP] = anon_sym_PIPE_AMP,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACK_LBRACK] = anon_sym_LBRACK_LBRACK,
  [anon_sym_RBRACK_RBRACK] = anon_sym_RBRACK_RBRACK,
  [anon_sym_declare] = anon_sym_declare,
  [anon_sym_typeset] = anon_sym_typeset,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_readonly] = anon_sym_readonly,
  [anon_sym_local] = anon_sym_local,
  [anon_sym_unset] = anon_sym_unset,
  [anon_sym_unsetenv] = anon_sym_unsetenv,
  [anon_sym_EQ_TILDE] = anon_sym_EQ_TILDE,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_AMP_GT] = anon_sym_AMP_GT,
  [anon_sym_AMP_GT_GT] = anon_sym_AMP_GT_GT,
  [anon_sym_LT_AMP] = anon_sym_LT_AMP,
  [anon_sym_GT_AMP] = anon_sym_GT_AMP,
  [anon_sym_GT_PIPE] = anon_sym_GT_PIPE,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_LT_LT_DASH] = anon_sym_LT_LT_DASH,
  [anon_sym_LT_LT_LT] = anon_sym_LT_LT_LT,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [sym__special_character] = sym__special_character,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym__string_content] = sym__string_content,
  [sym_raw_string] = sym_raw_string,
  [sym_ansi_c_string] = sym_ansi_c_string,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_COLON_QMARK] = anon_sym_COLON_QMARK,
  [anon_sym_COLON_DASH] = anon_sym_COLON_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_DOLLAR_LPAREN] = anon_sym_DOLLAR_LPAREN,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_LT_LPAREN] = anon_sym_LT_LPAREN,
  [anon_sym_GT_LPAREN] = anon_sym_GT_LPAREN,
  [sym_comment] = sym_comment,
  [aux_sym__simple_variable_name_token1] = sym_variable_name,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_AT] = anon_sym_STAR,
  [anon_sym_0] = anon_sym_STAR,
  [anon_sym__] = anon_sym_STAR,
  [sym_test_operator] = sym_test_operator,
  [anon_sym_AMP] = anon_sym_AMP,
  [sym_heredoc_start] = sym_heredoc_start,
  [sym__simple_heredoc_body] = sym__simple_heredoc_body,
  [sym__heredoc_body_beginning] = sym__heredoc_body_beginning,
  [sym__heredoc_body_middle] = sym__heredoc_body_middle,
  [sym__heredoc_body_end] = sym__heredoc_body_end,
  [sym_file_descriptor] = sym_file_descriptor,
  [sym__empty_value] = sym__empty_value,
  [sym__concat] = sym__concat,
  [sym_variable_name] = sym_variable_name,
  [sym_regex] = sym_regex,
  [sym_program] = sym_program,
  [sym__statements] = sym__statements,
  [aux_sym__statements2] = aux_sym__statements2,
  [sym__terminated_statement] = sym__terminated_statement,
  [sym_redirected_statement] = sym_redirected_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_c_style_for_statement] = sym_c_style_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_do_group] = sym_do_group,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_case_statement] = sym_case_statement,
  [sym_case_item] = sym_case_item,
  [sym_last_case_item] = sym_case_item,
  [sym_function_definition] = sym_function_definition,
  [sym_compound_statement] = sym_compound_statement,
  [sym_subshell] = sym_subshell,
  [sym_pipeline] = sym_pipeline,
  [sym_list] = sym_list,
  [sym_negated_command] = sym_negated_command,
  [sym_test_command] = sym_test_command,
  [sym_declaration_command] = sym_declaration_command,
  [sym_unset_command] = sym_unset_command,
  [sym_command] = sym_command,
  [sym_command_name] = sym_command_name,
  [sym_variable_assignment] = sym_variable_assignment,
  [sym_subscript] = sym_subscript,
  [sym_file_redirect] = sym_file_redirect,
  [sym_heredoc_redirect] = sym_heredoc_redirect,
  [sym_heredoc_body] = sym_heredoc_body,
  [sym_herestring_redirect] = sym_herestring_redirect,
  [sym__expression] = sym__expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_postfix_expression] = sym_postfix_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_concatenation] = sym_concatenation,
  [sym_string] = sym_string,
  [sym_translated_string] = sym_translated_string,
  [sym_array] = sym_array,
  [sym_simple_expansion] = sym_simple_expansion,
  [sym_expansion] = sym_expansion,
  [sym_command_substitution] = sym_command_substitution,
  [sym_process_substitution] = sym_process_substitution,
  [aux_sym__statements_repeat1] = aux_sym__statements_repeat1,
  [aux_sym_redirected_statement_repeat1] = aux_sym_redirected_statement_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_case_statement_repeat1] = aux_sym_case_statement_repeat1,
  [aux_sym_case_item_repeat1] = aux_sym_case_item_repeat1,
  [aux_sym_declaration_command_repeat1] = aux_sym_declaration_command_repeat1,
  [aux_sym_unset_command_repeat1] = aux_sym_unset_command_repeat1,
  [aux_sym_command_repeat1] = aux_sym_command_repeat1,
  [aux_sym_command_repeat2] = aux_sym_command_repeat2,
  [aux_sym_heredoc_body_repeat1] = aux_sym_heredoc_body_repeat1,
  [aux_sym__literal_repeat1] = aux_sym__literal_repeat1,
  [aux_sym_concatenation_repeat1] = aux_sym_concatenation_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_expansion_repeat1] = aux_sym_expansion_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_word] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_select] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_until] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_done] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_esac] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI_SEMI_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsetenv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym__special_character] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_string] = {
    .visible = true,
    .named = true,
  },
  [sym_ansi_c_string] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__simple_variable_name_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__] = {
    .visible = true,
    .named = true,
  },
  [sym_test_operator] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [sym_heredoc_start] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_heredoc_body] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_beginning] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_middle] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_end] = {
    .visible = false,
    .named = true,
  },
  [sym_file_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_value] = {
    .visible = false,
    .named = true,
  },
  [sym__concat] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_name] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__statements] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__statements2] = {
    .visible = false,
    .named = false,
  },
  [sym__terminated_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_redirected_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_c_style_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_group] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_item] = {
    .visible = true,
    .named = true,
  },
  [sym_last_case_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_subshell] = {
    .visible = true,
    .named = true,
  },
  [sym_pipeline] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_negated_command] = {
    .visible = true,
    .named = true,
  },
  [sym_test_command] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_command] = {
    .visible = true,
    .named = true,
  },
  [sym_unset_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_file_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_body] = {
    .visible = true,
    .named = true,
  },
  [sym_herestring_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_translated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_command_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_process_substitution] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_redirected_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_item_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unset_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_heredoc_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expansion_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_argument = 2,
  field_body = 3,
  field_condition = 4,
  field_consequence = 5,
  field_descriptor = 6,
  field_destination = 7,
  field_fallthrough = 8,
  field_index = 9,
  field_initializer = 10,
  field_left = 11,
  field_name = 12,
  field_operator = 13,
  field_redirect = 14,
  field_right = 15,
  field_termination = 16,
  field_update = 17,
  field_value = 18,
  field_variable = 19,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_descriptor] = "descriptor",
  [field_destination] = "destination",
  [field_fallthrough] = "fallthrough",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_left] = "left",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_redirect] = "redirect",
  [field_right] = "right",
  [field_termination] = "termination",
  [field_update] = "update",
  [field_value] = "value",
  [field_variable] = "variable",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 1, .length = 1},
  [6] = {.index = 2, .length = 2},
  [7] = {.index = 4, .length = 1},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 4, .length = 1},
  [10] = {.index = 7, .length = 1},
  [11] = {.index = 8, .length = 2},
  [12] = {.index = 8, .length = 2},
  [13] = {.index = 10, .length = 2},
  [14] = {.index = 10, .length = 2},
  [15] = {.index = 12, .length = 2},
  [16] = {.index = 14, .length = 2},
  [18] = {.index = 16, .length = 2},
  [19] = {.index = 16, .length = 2},
  [20] = {.index = 18, .length = 2},
  [21] = {.index = 20, .length = 2},
  [22] = {.index = 22, .length = 2},
  [23] = {.index = 22, .length = 2},
  [24] = {.index = 24, .length = 2},
  [25] = {.index = 26, .length = 3},
  [26] = {.index = 29, .length = 1},
  [28] = {.index = 30, .length = 2},
  [29] = {.index = 32, .length = 1},
  [30] = {.index = 32, .length = 1},
  [31] = {.index = 33, .length = 1},
  [32] = {.index = 33, .length = 1},
  [33] = {.index = 34, .length = 2},
  [35] = {.index = 36, .length = 1},
  [36] = {.index = 37, .length = 3},
  [37] = {.index = 40, .length = 3},
  [38] = {.index = 43, .length = 1},
  [39] = {.index = 43, .length = 1},
  [41] = {.index = 44, .length = 1},
  [42] = {.index = 45, .length = 2},
  [43] = {.index = 47, .length = 2},
  [44] = {.index = 49, .length = 2},
  [45] = {.index = 51, .length = 2},
  [46] = {.index = 53, .length = 2},
  [47] = {.index = 55, .length = 2},
  [48] = {.index = 57, .length = 2},
  [49] = {.index = 51, .length = 2},
  [50] = {.index = 53, .length = 2},
  [51] = {.index = 55, .length = 2},
  [52] = {.index = 59, .length = 2},
  [53] = {.index = 61, .length = 2},
  [54] = {.index = 63, .length = 3},
  [55] = {.index = 66, .length = 2},
  [56] = {.index = 68, .length = 3},
  [57] = {.index = 71, .length = 3},
  [58] = {.index = 74, .length = 2},
  [59] = {.index = 76, .length = 2},
  [60] = {.index = 78, .length = 3},
  [61] = {.index = 81, .length = 3},
  [62] = {.index = 74, .length = 2},
  [63] = {.index = 76, .length = 2},
  [64] = {.index = 78, .length = 3},
  [65] = {.index = 81, .length = 3},
  [66] = {.index = 84, .length = 3},
  [67] = {.index = 87, .length = 3},
  [68] = {.index = 90, .length = 3},
  [69] = {.index = 93, .length = 4},
  [70] = {.index = 97, .length = 3},
  [71] = {.index = 100, .length = 3},
  [72] = {.index = 97, .length = 3},
  [73] = {.index = 100, .length = 3},
  [74] = {.index = 103, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_destination, 1},
  [2] =
    {field_body, 0},
    {field_redirect, 1},
  [4] =
    {field_argument, 0},
  [5] =
    {field_argument, 1, .inherited = true},
    {field_name, 0},
  [7] =
    {field_name, 1},
  [8] =
    {field_descriptor, 0},
    {field_destination, 2},
  [10] =
    {field_name, 0},
    {field_value, 2},
  [12] =
    {field_body, 2},
    {field_condition, 1},
  [14] =
    {field_body, 2},
    {field_name, 1},
  [16] =
    {field_argument, 0},
    {field_argument, 1},
  [18] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [20] =
    {field_argument, 2, .inherited = true},
    {field_name, 1},
  [22] =
    {field_index, 2},
    {field_name, 0},
  [24] =
    {field_body, 3},
    {field_variable, 1},
  [26] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [29] =
    {field_condition, 1},
  [30] =
    {field_body, 3},
    {field_name, 0},
  [32] =
    {field_descriptor, 0},
  [33] =
    {field_value, 1},
  [34] =
    {field_body, 4},
    {field_name, 1},
  [36] =
    {field_body, 5},
  [37] =
    {field_body, 5},
    {field_value, 3},
    {field_variable, 1},
  [40] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [43] =
    {field_value, 0},
  [44] =
    {field_body, 6},
  [45] =
    {field_body, 6},
    {field_update, 4},
  [47] =
    {field_body, 6},
    {field_condition, 3},
  [49] =
    {field_body, 6},
    {field_initializer, 2},
  [51] =
    {field_termination, 2},
    {field_value, 0},
  [53] =
    {field_fallthrough, 2},
    {field_value, 0},
  [55] =
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [57] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [59] =
    {field_body, 7},
    {field_update, 4},
  [61] =
    {field_body, 7},
    {field_condition, 3},
  [63] =
    {field_body, 7},
    {field_condition, 3},
    {field_update, 5},
  [66] =
    {field_body, 7},
    {field_initializer, 2},
  [68] =
    {field_body, 7},
    {field_initializer, 2},
    {field_update, 5},
  [71] =
    {field_body, 7},
    {field_condition, 4},
    {field_initializer, 2},
  [74] =
    {field_termination, 3},
    {field_value, 0},
  [76] =
    {field_fallthrough, 3},
    {field_value, 0},
  [78] =
    {field_termination, 3},
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [81] =
    {field_fallthrough, 3},
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [84] =
    {field_body, 8},
    {field_condition, 3},
    {field_update, 5},
  [87] =
    {field_body, 8},
    {field_initializer, 2},
    {field_update, 5},
  [90] =
    {field_body, 8},
    {field_condition, 4},
    {field_initializer, 2},
  [93] =
    {field_body, 8},
    {field_condition, 4},
    {field_initializer, 2},
    {field_update, 6},
  [97] =
    {field_termination, 4},
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [100] =
    {field_fallthrough, 4},
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [103] =
    {field_body, 9},
    {field_condition, 4},
    {field_initializer, 2},
    {field_update, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [0] = sym_word,
  },
  [4] = {
    [1] = sym_word,
  },
  [5] = {
    [1] = anon_sym_STAR,
  },
  [9] = {
    [0] = sym_word,
  },
  [12] = {
    [2] = sym_word,
  },
  [14] = {
    [2] = sym_word,
  },
  [17] = {
    [1] = sym_word,
  },
  [19] = {
    [1] = sym_word,
  },
  [23] = {
    [2] = sym_word,
  },
  [27] = {
    [2] = anon_sym_STAR,
  },
  [30] = {
    [2] = sym_word,
  },
  [32] = {
    [1] = sym_word,
  },
  [34] = {
    [3] = sym_word,
  },
  [39] = {
    [0] = sym_word,
  },
  [40] = {
    [4] = sym_word,
  },
  [49] = {
    [0] = sym_word,
  },
  [50] = {
    [0] = sym_word,
  },
  [51] = {
    [0] = sym_word,
  },
  [62] = {
    [0] = sym_word,
  },
  [63] = {
    [0] = sym_word,
  },
  [64] = {
    [0] = sym_word,
  },
  [65] = {
    [0] = sym_word,
  },
  [72] = {
    [0] = sym_word,
  },
  [73] = {
    [0] = sym_word,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__literal_repeat1, 2,
    aux_sym__literal_repeat1,
    sym_word,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 2,
  [6] = 4,
  [7] = 4,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 21,
  [23] = 21,
  [24] = 18,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 25,
  [29] = 27,
  [30] = 26,
  [31] = 27,
  [32] = 26,
  [33] = 25,
  [34] = 25,
  [35] = 26,
  [36] = 27,
  [37] = 18,
  [38] = 27,
  [39] = 26,
  [40] = 25,
  [41] = 25,
  [42] = 42,
  [43] = 26,
  [44] = 25,
  [45] = 27,
  [46] = 26,
  [47] = 25,
  [48] = 27,
  [49] = 26,
  [50] = 25,
  [51] = 51,
  [52] = 27,
  [53] = 26,
  [54] = 25,
  [55] = 27,
  [56] = 26,
  [57] = 25,
  [58] = 27,
  [59] = 59,
  [60] = 26,
  [61] = 25,
  [62] = 25,
  [63] = 27,
  [64] = 26,
  [65] = 42,
  [66] = 66,
  [67] = 67,
  [68] = 67,
  [69] = 69,
  [70] = 59,
  [71] = 25,
  [72] = 27,
  [73] = 26,
  [74] = 74,
  [75] = 27,
  [76] = 26,
  [77] = 25,
  [78] = 66,
  [79] = 27,
  [80] = 25,
  [81] = 26,
  [82] = 25,
  [83] = 27,
  [84] = 27,
  [85] = 26,
  [86] = 25,
  [87] = 27,
  [88] = 26,
  [89] = 25,
  [90] = 27,
  [91] = 26,
  [92] = 25,
  [93] = 27,
  [94] = 67,
  [95] = 59,
  [96] = 74,
  [97] = 27,
  [98] = 26,
  [99] = 25,
  [100] = 27,
  [101] = 26,
  [102] = 66,
  [103] = 27,
  [104] = 25,
  [105] = 42,
  [106] = 25,
  [107] = 18,
  [108] = 26,
  [109] = 27,
  [110] = 27,
  [111] = 25,
  [112] = 26,
  [113] = 25,
  [114] = 27,
  [115] = 26,
  [116] = 25,
  [117] = 27,
  [118] = 27,
  [119] = 26,
  [120] = 25,
  [121] = 27,
  [122] = 26,
  [123] = 25,
  [124] = 27,
  [125] = 26,
  [126] = 25,
  [127] = 27,
  [128] = 26,
  [129] = 25,
  [130] = 74,
  [131] = 27,
  [132] = 26,
  [133] = 26,
  [134] = 25,
  [135] = 135,
  [136] = 136,
  [137] = 135,
  [138] = 138,
  [139] = 138,
  [140] = 140,
  [141] = 141,
  [142] = 140,
  [143] = 135,
  [144] = 138,
  [145] = 138,
  [146] = 140,
  [147] = 138,
  [148] = 148,
  [149] = 149,
  [150] = 149,
  [151] = 148,
  [152] = 149,
  [153] = 149,
  [154] = 149,
  [155] = 148,
  [156] = 148,
  [157] = 148,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 159,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 158,
  [166] = 166,
  [167] = 162,
  [168] = 160,
  [169] = 163,
  [170] = 166,
  [171] = 171,
  [172] = 159,
  [173] = 164,
  [174] = 174,
  [175] = 164,
  [176] = 163,
  [177] = 177,
  [178] = 159,
  [179] = 162,
  [180] = 158,
  [181] = 166,
  [182] = 160,
  [183] = 177,
  [184] = 184,
  [185] = 185,
  [186] = 158,
  [187] = 164,
  [188] = 162,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 163,
  [193] = 193,
  [194] = 160,
  [195] = 166,
  [196] = 174,
  [197] = 193,
  [198] = 190,
  [199] = 159,
  [200] = 166,
  [201] = 191,
  [202] = 184,
  [203] = 158,
  [204] = 185,
  [205] = 162,
  [206] = 166,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 166,
  [211] = 211,
  [212] = 171,
  [213] = 163,
  [214] = 214,
  [215] = 166,
  [216] = 166,
  [217] = 189,
  [218] = 218,
  [219] = 171,
  [220] = 184,
  [221] = 191,
  [222] = 166,
  [223] = 166,
  [224] = 166,
  [225] = 218,
  [226] = 166,
  [227] = 191,
  [228] = 171,
  [229] = 189,
  [230] = 211,
  [231] = 207,
  [232] = 185,
  [233] = 189,
  [234] = 184,
  [235] = 166,
  [236] = 185,
  [237] = 184,
  [238] = 166,
  [239] = 211,
  [240] = 211,
  [241] = 174,
  [242] = 208,
  [243] = 209,
  [244] = 193,
  [245] = 185,
  [246] = 207,
  [247] = 218,
  [248] = 209,
  [249] = 166,
  [250] = 218,
  [251] = 207,
  [252] = 209,
  [253] = 208,
  [254] = 190,
  [255] = 208,
  [256] = 177,
  [257] = 189,
  [258] = 191,
  [259] = 174,
  [260] = 260,
  [261] = 261,
  [262] = 260,
  [263] = 260,
  [264] = 190,
  [265] = 177,
  [266] = 260,
  [267] = 193,
  [268] = 260,
  [269] = 218,
  [270] = 270,
  [271] = 211,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 280,
  [282] = 275,
  [283] = 283,
  [284] = 284,
  [285] = 272,
  [286] = 286,
  [287] = 279,
  [288] = 276,
  [289] = 283,
  [290] = 290,
  [291] = 273,
  [292] = 274,
  [293] = 276,
  [294] = 294,
  [295] = 272,
  [296] = 290,
  [297] = 276,
  [298] = 286,
  [299] = 275,
  [300] = 300,
  [301] = 284,
  [302] = 278,
  [303] = 277,
  [304] = 273,
  [305] = 274,
  [306] = 290,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 283,
  [317] = 317,
  [318] = 318,
  [319] = 312,
  [320] = 313,
  [321] = 274,
  [322] = 314,
  [323] = 273,
  [324] = 315,
  [325] = 317,
  [326] = 318,
  [327] = 327,
  [328] = 328,
  [329] = 279,
  [330] = 330,
  [331] = 331,
  [332] = 280,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 275,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 294,
  [349] = 349,
  [350] = 350,
  [351] = 283,
  [352] = 327,
  [353] = 328,
  [354] = 279,
  [355] = 330,
  [356] = 280,
  [357] = 272,
  [358] = 331,
  [359] = 279,
  [360] = 280,
  [361] = 333,
  [362] = 334,
  [363] = 335,
  [364] = 336,
  [365] = 337,
  [366] = 338,
  [367] = 339,
  [368] = 341,
  [369] = 342,
  [370] = 343,
  [371] = 344,
  [372] = 345,
  [373] = 346,
  [374] = 347,
  [375] = 279,
  [376] = 280,
  [377] = 283,
  [378] = 350,
  [379] = 349,
  [380] = 283,
  [381] = 300,
  [382] = 327,
  [383] = 336,
  [384] = 335,
  [385] = 290,
  [386] = 283,
  [387] = 334,
  [388] = 333,
  [389] = 315,
  [390] = 314,
  [391] = 331,
  [392] = 277,
  [393] = 330,
  [394] = 313,
  [395] = 312,
  [396] = 328,
  [397] = 327,
  [398] = 350,
  [399] = 349,
  [400] = 294,
  [401] = 347,
  [402] = 346,
  [403] = 345,
  [404] = 344,
  [405] = 279,
  [406] = 343,
  [407] = 342,
  [408] = 338,
  [409] = 341,
  [410] = 339,
  [411] = 338,
  [412] = 337,
  [413] = 339,
  [414] = 336,
  [415] = 335,
  [416] = 334,
  [417] = 333,
  [418] = 331,
  [419] = 336,
  [420] = 330,
  [421] = 328,
  [422] = 327,
  [423] = 300,
  [424] = 318,
  [425] = 337,
  [426] = 341,
  [427] = 342,
  [428] = 338,
  [429] = 339,
  [430] = 343,
  [431] = 341,
  [432] = 342,
  [433] = 343,
  [434] = 344,
  [435] = 345,
  [436] = 318,
  [437] = 344,
  [438] = 317,
  [439] = 346,
  [440] = 347,
  [441] = 294,
  [442] = 349,
  [443] = 315,
  [444] = 350,
  [445] = 314,
  [446] = 345,
  [447] = 346,
  [448] = 312,
  [449] = 277,
  [450] = 313,
  [451] = 451,
  [452] = 347,
  [453] = 294,
  [454] = 335,
  [455] = 349,
  [456] = 280,
  [457] = 457,
  [458] = 314,
  [459] = 313,
  [460] = 315,
  [461] = 312,
  [462] = 317,
  [463] = 278,
  [464] = 350,
  [465] = 465,
  [466] = 278,
  [467] = 283,
  [468] = 279,
  [469] = 307,
  [470] = 334,
  [471] = 318,
  [472] = 327,
  [473] = 283,
  [474] = 328,
  [475] = 284,
  [476] = 333,
  [477] = 477,
  [478] = 290,
  [479] = 308,
  [480] = 280,
  [481] = 280,
  [482] = 482,
  [483] = 279,
  [484] = 284,
  [485] = 485,
  [486] = 309,
  [487] = 310,
  [488] = 465,
  [489] = 330,
  [490] = 311,
  [491] = 465,
  [492] = 331,
  [493] = 331,
  [494] = 318,
  [495] = 290,
  [496] = 337,
  [497] = 286,
  [498] = 498,
  [499] = 317,
  [500] = 280,
  [501] = 465,
  [502] = 333,
  [503] = 334,
  [504] = 315,
  [505] = 335,
  [506] = 314,
  [507] = 336,
  [508] = 330,
  [509] = 509,
  [510] = 279,
  [511] = 274,
  [512] = 273,
  [513] = 451,
  [514] = 280,
  [515] = 313,
  [516] = 280,
  [517] = 312,
  [518] = 337,
  [519] = 338,
  [520] = 275,
  [521] = 339,
  [522] = 341,
  [523] = 342,
  [524] = 524,
  [525] = 343,
  [526] = 344,
  [527] = 345,
  [528] = 346,
  [529] = 279,
  [530] = 347,
  [531] = 294,
  [532] = 349,
  [533] = 317,
  [534] = 286,
  [535] = 283,
  [536] = 328,
  [537] = 283,
  [538] = 279,
  [539] = 283,
  [540] = 350,
  [541] = 276,
  [542] = 542,
  [543] = 543,
  [544] = 312,
  [545] = 342,
  [546] = 344,
  [547] = 339,
  [548] = 345,
  [549] = 346,
  [550] = 347,
  [551] = 327,
  [552] = 344,
  [553] = 294,
  [554] = 300,
  [555] = 350,
  [556] = 328,
  [557] = 283,
  [558] = 312,
  [559] = 451,
  [560] = 333,
  [561] = 317,
  [562] = 451,
  [563] = 313,
  [564] = 330,
  [565] = 477,
  [566] = 317,
  [567] = 314,
  [568] = 311,
  [569] = 349,
  [570] = 311,
  [571] = 310,
  [572] = 309,
  [573] = 338,
  [574] = 315,
  [575] = 333,
  [576] = 334,
  [577] = 335,
  [578] = 336,
  [579] = 317,
  [580] = 482,
  [581] = 310,
  [582] = 318,
  [583] = 350,
  [584] = 337,
  [585] = 338,
  [586] = 280,
  [587] = 309,
  [588] = 339,
  [589] = 279,
  [590] = 485,
  [591] = 341,
  [592] = 342,
  [593] = 343,
  [594] = 283,
  [595] = 344,
  [596] = 345,
  [597] = 346,
  [598] = 347,
  [599] = 294,
  [600] = 327,
  [601] = 328,
  [602] = 312,
  [603] = 166,
  [604] = 327,
  [605] = 294,
  [606] = 509,
  [607] = 313,
  [608] = 327,
  [609] = 349,
  [610] = 330,
  [611] = 350,
  [612] = 312,
  [613] = 331,
  [614] = 279,
  [615] = 331,
  [616] = 347,
  [617] = 308,
  [618] = 350,
  [619] = 349,
  [620] = 294,
  [621] = 347,
  [622] = 328,
  [623] = 337,
  [624] = 330,
  [625] = 318,
  [626] = 346,
  [627] = 346,
  [628] = 331,
  [629] = 331,
  [630] = 312,
  [631] = 345,
  [632] = 344,
  [633] = 343,
  [634] = 342,
  [635] = 341,
  [636] = 333,
  [637] = 334,
  [638] = 343,
  [639] = 335,
  [640] = 339,
  [641] = 338,
  [642] = 337,
  [643] = 327,
  [644] = 328,
  [645] = 341,
  [646] = 315,
  [647] = 313,
  [648] = 330,
  [649] = 336,
  [650] = 337,
  [651] = 338,
  [652] = 339,
  [653] = 300,
  [654] = 341,
  [655] = 313,
  [656] = 336,
  [657] = 342,
  [658] = 343,
  [659] = 342,
  [660] = 344,
  [661] = 328,
  [662] = 331,
  [663] = 280,
  [664] = 336,
  [665] = 335,
  [666] = 334,
  [667] = 333,
  [668] = 290,
  [669] = 280,
  [670] = 330,
  [671] = 330,
  [672] = 524,
  [673] = 279,
  [674] = 345,
  [675] = 328,
  [676] = 327,
  [677] = 318,
  [678] = 345,
  [679] = 346,
  [680] = 347,
  [681] = 315,
  [682] = 294,
  [683] = 314,
  [684] = 317,
  [685] = 341,
  [686] = 315,
  [687] = 333,
  [688] = 334,
  [689] = 335,
  [690] = 336,
  [691] = 317,
  [692] = 315,
  [693] = 318,
  [694] = 314,
  [695] = 334,
  [696] = 313,
  [697] = 339,
  [698] = 338,
  [699] = 312,
  [700] = 333,
  [701] = 331,
  [702] = 543,
  [703] = 337,
  [704] = 349,
  [705] = 336,
  [706] = 350,
  [707] = 334,
  [708] = 308,
  [709] = 335,
  [710] = 283,
  [711] = 313,
  [712] = 343,
  [713] = 314,
  [714] = 451,
  [715] = 335,
  [716] = 542,
  [717] = 315,
  [718] = 318,
  [719] = 337,
  [720] = 338,
  [721] = 339,
  [722] = 314,
  [723] = 317,
  [724] = 314,
  [725] = 349,
  [726] = 307,
  [727] = 280,
  [728] = 307,
  [729] = 345,
  [730] = 346,
  [731] = 347,
  [732] = 294,
  [733] = 283,
  [734] = 290,
  [735] = 451,
  [736] = 477,
  [737] = 318,
  [738] = 341,
  [739] = 342,
  [740] = 343,
  [741] = 344,
  [742] = 279,
  [743] = 300,
  [744] = 485,
  [745] = 349,
  [746] = 482,
  [747] = 350,
  [748] = 339,
  [749] = 749,
  [750] = 337,
  [751] = 300,
  [752] = 336,
  [753] = 335,
  [754] = 334,
  [755] = 333,
  [756] = 330,
  [757] = 328,
  [758] = 509,
  [759] = 327,
  [760] = 749,
  [761] = 318,
  [762] = 317,
  [763] = 315,
  [764] = 314,
  [765] = 313,
  [766] = 312,
  [767] = 485,
  [768] = 485,
  [769] = 482,
  [770] = 166,
  [771] = 477,
  [772] = 331,
  [773] = 331,
  [774] = 350,
  [775] = 349,
  [776] = 294,
  [777] = 347,
  [778] = 346,
  [779] = 477,
  [780] = 341,
  [781] = 345,
  [782] = 342,
  [783] = 343,
  [784] = 344,
  [785] = 345,
  [786] = 749,
  [787] = 346,
  [788] = 344,
  [789] = 343,
  [790] = 342,
  [791] = 347,
  [792] = 294,
  [793] = 349,
  [794] = 350,
  [795] = 482,
  [796] = 166,
  [797] = 341,
  [798] = 350,
  [799] = 339,
  [800] = 338,
  [801] = 337,
  [802] = 318,
  [803] = 331,
  [804] = 524,
  [805] = 317,
  [806] = 349,
  [807] = 294,
  [808] = 347,
  [809] = 346,
  [810] = 451,
  [811] = 312,
  [812] = 300,
  [813] = 313,
  [814] = 336,
  [815] = 314,
  [816] = 345,
  [817] = 335,
  [818] = 334,
  [819] = 333,
  [820] = 315,
  [821] = 315,
  [822] = 477,
  [823] = 317,
  [824] = 451,
  [825] = 314,
  [826] = 318,
  [827] = 509,
  [828] = 344,
  [829] = 451,
  [830] = 338,
  [831] = 451,
  [832] = 524,
  [833] = 327,
  [834] = 328,
  [835] = 451,
  [836] = 330,
  [837] = 313,
  [838] = 330,
  [839] = 312,
  [840] = 328,
  [841] = 327,
  [842] = 451,
  [843] = 333,
  [844] = 334,
  [845] = 335,
  [846] = 336,
  [847] = 337,
  [848] = 338,
  [849] = 339,
  [850] = 341,
  [851] = 342,
  [852] = 343,
  [853] = 344,
  [854] = 482,
  [855] = 345,
  [856] = 346,
  [857] = 347,
  [858] = 294,
  [859] = 349,
  [860] = 350,
  [861] = 343,
  [862] = 331,
  [863] = 543,
  [864] = 342,
  [865] = 485,
  [866] = 312,
  [867] = 313,
  [868] = 314,
  [869] = 315,
  [870] = 317,
  [871] = 318,
  [872] = 543,
  [873] = 327,
  [874] = 328,
  [875] = 330,
  [876] = 333,
  [877] = 334,
  [878] = 335,
  [879] = 542,
  [880] = 336,
  [881] = 337,
  [882] = 338,
  [883] = 749,
  [884] = 339,
  [885] = 749,
  [886] = 341,
  [887] = 542,
  [888] = 451,
  [889] = 451,
  [890] = 166,
  [891] = 451,
  [892] = 485,
  [893] = 477,
  [894] = 477,
  [895] = 482,
  [896] = 482,
  [897] = 485,
  [898] = 451,
  [899] = 899,
  [900] = 166,
  [901] = 899,
  [902] = 902,
  [903] = 902,
  [904] = 904,
  [905] = 904,
  [906] = 904,
  [907] = 166,
  [908] = 902,
  [909] = 899,
  [910] = 166,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 919,
  [920] = 920,
  [921] = 912,
  [922] = 922,
  [923] = 911,
  [924] = 166,
  [925] = 925,
  [926] = 914,
  [927] = 917,
  [928] = 928,
  [929] = 918,
  [930] = 919,
  [931] = 912,
  [932] = 918,
  [933] = 919,
  [934] = 922,
  [935] = 911,
  [936] = 925,
  [937] = 914,
  [938] = 920,
  [939] = 917,
  [940] = 918,
  [941] = 919,
  [942] = 912,
  [943] = 928,
  [944] = 916,
  [945] = 915,
  [946] = 922,
  [947] = 913,
  [948] = 911,
  [949] = 925,
  [950] = 914,
  [951] = 917,
  [952] = 925,
  [953] = 918,
  [954] = 919,
  [955] = 912,
  [956] = 928,
  [957] = 916,
  [958] = 915,
  [959] = 922,
  [960] = 913,
  [961] = 911,
  [962] = 925,
  [963] = 912,
  [964] = 914,
  [965] = 922,
  [966] = 917,
  [967] = 918,
  [968] = 911,
  [969] = 919,
  [970] = 912,
  [971] = 922,
  [972] = 911,
  [973] = 925,
  [974] = 914,
  [975] = 917,
  [976] = 918,
  [977] = 919,
  [978] = 912,
  [979] = 922,
  [980] = 911,
  [981] = 925,
  [982] = 917,
  [983] = 914,
  [984] = 914,
  [985] = 917,
  [986] = 920,
  [987] = 918,
  [988] = 925,
  [989] = 919,
  [990] = 912,
  [991] = 911,
  [992] = 922,
  [993] = 922,
  [994] = 912,
  [995] = 911,
  [996] = 919,
  [997] = 918,
  [998] = 925,
  [999] = 914,
  [1000] = 917,
  [1001] = 920,
  [1002] = 918,
  [1003] = 919,
  [1004] = 912,
  [1005] = 922,
  [1006] = 911,
  [1007] = 925,
  [1008] = 914,
  [1009] = 917,
  [1010] = 918,
  [1011] = 919,
  [1012] = 912,
  [1013] = 917,
  [1014] = 922,
  [1015] = 914,
  [1016] = 911,
  [1017] = 925,
  [1018] = 925,
  [1019] = 914,
  [1020] = 911,
  [1021] = 922,
  [1022] = 912,
  [1023] = 919,
  [1024] = 918,
  [1025] = 917,
  [1026] = 918,
  [1027] = 919,
  [1028] = 912,
  [1029] = 922,
  [1030] = 911,
  [1031] = 925,
  [1032] = 914,
  [1033] = 917,
  [1034] = 918,
  [1035] = 919,
  [1036] = 912,
  [1037] = 917,
  [1038] = 922,
  [1039] = 914,
  [1040] = 911,
  [1041] = 925,
  [1042] = 925,
  [1043] = 911,
  [1044] = 922,
  [1045] = 912,
  [1046] = 919,
  [1047] = 918,
  [1048] = 914,
  [1049] = 917,
  [1050] = 918,
  [1051] = 919,
  [1052] = 912,
  [1053] = 922,
  [1054] = 911,
  [1055] = 925,
  [1056] = 914,
  [1057] = 917,
  [1058] = 918,
  [1059] = 919,
  [1060] = 917,
  [1061] = 912,
  [1062] = 914,
  [1063] = 922,
  [1064] = 925,
  [1065] = 911,
  [1066] = 911,
  [1067] = 922,
  [1068] = 912,
  [1069] = 919,
  [1070] = 918,
  [1071] = 925,
  [1072] = 914,
  [1073] = 917,
  [1074] = 918,
  [1075] = 919,
  [1076] = 912,
  [1077] = 922,
  [1078] = 911,
  [1079] = 925,
  [1080] = 914,
  [1081] = 917,
  [1082] = 918,
  [1083] = 917,
  [1084] = 919,
  [1085] = 914,
  [1086] = 912,
  [1087] = 925,
  [1088] = 922,
  [1089] = 911,
  [1090] = 922,
  [1091] = 912,
  [1092] = 919,
  [1093] = 911,
  [1094] = 918,
  [1095] = 925,
  [1096] = 914,
  [1097] = 917,
  [1098] = 918,
  [1099] = 919,
  [1100] = 912,
  [1101] = 922,
  [1102] = 925,
  [1103] = 914,
  [1104] = 917,
  [1105] = 918,
  [1106] = 919,
  [1107] = 912,
  [1108] = 917,
  [1109] = 922,
  [1110] = 914,
  [1111] = 911,
  [1112] = 925,
  [1113] = 925,
  [1114] = 914,
  [1115] = 917,
  [1116] = 911,
  [1117] = 922,
  [1118] = 912,
  [1119] = 919,
  [1120] = 918,
  [1121] = 918,
  [1122] = 919,
  [1123] = 912,
  [1124] = 922,
  [1125] = 911,
  [1126] = 925,
  [1127] = 914,
  [1128] = 917,
  [1129] = 918,
  [1130] = 919,
  [1131] = 912,
  [1132] = 922,
  [1133] = 917,
  [1134] = 911,
  [1135] = 914,
  [1136] = 925,
  [1137] = 925,
  [1138] = 914,
  [1139] = 911,
  [1140] = 917,
  [1141] = 922,
  [1142] = 912,
  [1143] = 919,
  [1144] = 918,
  [1145] = 918,
  [1146] = 919,
  [1147] = 912,
  [1148] = 922,
  [1149] = 911,
  [1150] = 925,
  [1151] = 914,
  [1152] = 917,
  [1153] = 918,
  [1154] = 919,
  [1155] = 912,
  [1156] = 922,
  [1157] = 917,
  [1158] = 911,
  [1159] = 925,
  [1160] = 914,
  [1161] = 914,
  [1162] = 925,
  [1163] = 917,
  [1164] = 918,
  [1165] = 920,
  [1166] = 919,
  [1167] = 911,
  [1168] = 922,
  [1169] = 912,
  [1170] = 919,
  [1171] = 918,
  [1172] = 166,
  [1173] = 917,
  [1174] = 914,
  [1175] = 925,
  [1176] = 911,
  [1177] = 922,
  [1178] = 1178,
  [1179] = 1179,
  [1180] = 1180,
  [1181] = 1179,
  [1182] = 1182,
  [1183] = 1183,
  [1184] = 1184,
  [1185] = 1185,
  [1186] = 1178,
  [1187] = 1187,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1190,
  [1191] = 1191,
  [1192] = 1192,
  [1193] = 1193,
  [1194] = 1180,
  [1195] = 1189,
  [1196] = 1184,
  [1197] = 1197,
  [1198] = 1178,
  [1199] = 1188,
  [1200] = 1190,
  [1201] = 1191,
  [1202] = 1192,
  [1203] = 1193,
  [1204] = 1185,
  [1205] = 1180,
  [1206] = 1183,
  [1207] = 1207,
  [1208] = 1182,
  [1209] = 1179,
  [1210] = 1182,
  [1211] = 1179,
  [1212] = 1183,
  [1213] = 1213,
  [1214] = 1185,
  [1215] = 1215,
  [1216] = 1216,
  [1217] = 1217,
  [1218] = 1187,
  [1219] = 1187,
  [1220] = 1189,
  [1221] = 1189,
  [1222] = 1185,
  [1223] = 1183,
  [1224] = 1187,
  [1225] = 1182,
  [1226] = 1184,
  [1227] = 1178,
  [1228] = 1188,
  [1229] = 1190,
  [1230] = 1191,
  [1231] = 1192,
  [1232] = 1193,
  [1233] = 1180,
  [1234] = 1179,
  [1235] = 1182,
  [1236] = 1183,
  [1237] = 1179,
  [1238] = 1185,
  [1239] = 1180,
  [1240] = 1187,
  [1241] = 1183,
  [1242] = 1189,
  [1243] = 1192,
  [1244] = 1191,
  [1245] = 1190,
  [1246] = 1188,
  [1247] = 1178,
  [1248] = 1184,
  [1249] = 1178,
  [1250] = 1188,
  [1251] = 1190,
  [1252] = 1191,
  [1253] = 1192,
  [1254] = 1193,
  [1255] = 1180,
  [1256] = 1179,
  [1257] = 1182,
  [1258] = 1183,
  [1259] = 1184,
  [1260] = 1185,
  [1261] = 1261,
  [1262] = 1187,
  [1263] = 1189,
  [1264] = 1189,
  [1265] = 1187,
  [1266] = 1185,
  [1267] = 1183,
  [1268] = 1182,
  [1269] = 1185,
  [1270] = 1184,
  [1271] = 1178,
  [1272] = 1197,
  [1273] = 1188,
  [1274] = 1190,
  [1275] = 1191,
  [1276] = 1192,
  [1277] = 1193,
  [1278] = 1180,
  [1279] = 1179,
  [1280] = 1182,
  [1281] = 1183,
  [1282] = 1179,
  [1283] = 1185,
  [1284] = 1180,
  [1285] = 1187,
  [1286] = 1193,
  [1287] = 1189,
  [1288] = 1192,
  [1289] = 1191,
  [1290] = 1190,
  [1291] = 1188,
  [1292] = 1292,
  [1293] = 1184,
  [1294] = 1178,
  [1295] = 1188,
  [1296] = 1190,
  [1297] = 1191,
  [1298] = 1192,
  [1299] = 1193,
  [1300] = 1180,
  [1301] = 1179,
  [1302] = 1182,
  [1303] = 1183,
  [1304] = 1184,
  [1305] = 1185,
  [1306] = 1189,
  [1307] = 1187,
  [1308] = 1183,
  [1309] = 1189,
  [1310] = 1182,
  [1311] = 1187,
  [1312] = 1185,
  [1313] = 1207,
  [1314] = 1183,
  [1315] = 1184,
  [1316] = 1178,
  [1317] = 1188,
  [1318] = 1190,
  [1319] = 1191,
  [1320] = 1179,
  [1321] = 1192,
  [1322] = 1193,
  [1323] = 1180,
  [1324] = 1179,
  [1325] = 1182,
  [1326] = 1183,
  [1327] = 1182,
  [1328] = 1185,
  [1329] = 1179,
  [1330] = 1187,
  [1331] = 1180,
  [1332] = 1189,
  [1333] = 1193,
  [1334] = 1192,
  [1335] = 1180,
  [1336] = 1191,
  [1337] = 1184,
  [1338] = 1178,
  [1339] = 1188,
  [1340] = 1190,
  [1341] = 1191,
  [1342] = 1192,
  [1343] = 1193,
  [1344] = 1180,
  [1345] = 1179,
  [1346] = 1182,
  [1347] = 1183,
  [1348] = 1190,
  [1349] = 1185,
  [1350] = 1188,
  [1351] = 1187,
  [1352] = 1178,
  [1353] = 1189,
  [1354] = 1184,
  [1355] = 1193,
  [1356] = 1189,
  [1357] = 1187,
  [1358] = 1185,
  [1359] = 1184,
  [1360] = 1178,
  [1361] = 1188,
  [1362] = 1190,
  [1363] = 1191,
  [1364] = 1192,
  [1365] = 1193,
  [1366] = 1180,
  [1367] = 1179,
  [1368] = 1182,
  [1369] = 1183,
  [1370] = 1189,
  [1371] = 1192,
  [1372] = 1185,
  [1373] = 1182,
  [1374] = 1187,
  [1375] = 1179,
  [1376] = 1189,
  [1377] = 1180,
  [1378] = 1193,
  [1379] = 1192,
  [1380] = 1191,
  [1381] = 1190,
  [1382] = 1184,
  [1383] = 1178,
  [1384] = 1188,
  [1385] = 1190,
  [1386] = 1191,
  [1387] = 1192,
  [1388] = 1193,
  [1389] = 1180,
  [1390] = 1191,
  [1391] = 1179,
  [1392] = 1182,
  [1393] = 1183,
  [1394] = 1188,
  [1395] = 1185,
  [1396] = 1178,
  [1397] = 1190,
  [1398] = 1187,
  [1399] = 1184,
  [1400] = 1189,
  [1401] = 1207,
  [1402] = 1188,
  [1403] = 1213,
  [1404] = 1189,
  [1405] = 1187,
  [1406] = 1185,
  [1407] = 1183,
  [1408] = 1184,
  [1409] = 1178,
  [1410] = 1188,
  [1411] = 1207,
  [1412] = 1190,
  [1413] = 1193,
  [1414] = 1191,
  [1415] = 1192,
  [1416] = 1193,
  [1417] = 1180,
  [1418] = 1179,
  [1419] = 1182,
  [1420] = 1183,
  [1421] = 1182,
  [1422] = 1185,
  [1423] = 1179,
  [1424] = 1187,
  [1425] = 1180,
  [1426] = 1189,
  [1427] = 1193,
  [1428] = 1192,
  [1429] = 1191,
  [1430] = 1190,
  [1431] = 1192,
  [1432] = 1184,
  [1433] = 1178,
  [1434] = 1188,
  [1435] = 1190,
  [1436] = 1191,
  [1437] = 1192,
  [1438] = 1193,
  [1439] = 1180,
  [1440] = 1179,
  [1441] = 1182,
  [1442] = 1183,
  [1443] = 1188,
  [1444] = 1185,
  [1445] = 1178,
  [1446] = 1187,
  [1447] = 1184,
  [1448] = 1189,
  [1449] = 1189,
  [1450] = 1187,
  [1451] = 1185,
  [1452] = 1191,
  [1453] = 1183,
  [1454] = 1182,
  [1455] = 1184,
  [1456] = 1178,
  [1457] = 1188,
  [1458] = 1190,
  [1459] = 1191,
  [1460] = 1190,
  [1461] = 1192,
  [1462] = 1193,
  [1463] = 1180,
  [1464] = 1179,
  [1465] = 1182,
  [1466] = 1183,
  [1467] = 1193,
  [1468] = 1185,
  [1469] = 1180,
  [1470] = 1187,
  [1471] = 1188,
  [1472] = 1193,
  [1473] = 1189,
  [1474] = 1192,
  [1475] = 1191,
  [1476] = 1190,
  [1477] = 1188,
  [1478] = 1178,
  [1479] = 1184,
  [1480] = 1178,
  [1481] = 1188,
  [1482] = 1190,
  [1483] = 1191,
  [1484] = 1192,
  [1485] = 1193,
  [1486] = 1180,
  [1487] = 1179,
  [1488] = 1184,
  [1489] = 1182,
  [1490] = 1197,
  [1491] = 1183,
  [1492] = 1178,
  [1493] = 1185,
  [1494] = 1184,
  [1495] = 1187,
  [1496] = 1189,
  [1497] = 1187,
  [1498] = 1215,
  [1499] = 1189,
  [1500] = 1189,
  [1501] = 1187,
  [1502] = 1185,
  [1503] = 1183,
  [1504] = 1182,
  [1505] = 1184,
  [1506] = 1178,
  [1507] = 1188,
  [1508] = 1190,
  [1509] = 1191,
  [1510] = 1192,
  [1511] = 1193,
  [1512] = 1180,
  [1513] = 1179,
  [1514] = 1182,
  [1515] = 1183,
  [1516] = 1179,
  [1517] = 1185,
  [1518] = 1180,
  [1519] = 1187,
  [1520] = 1215,
  [1521] = 1189,
  [1522] = 1193,
  [1523] = 1192,
  [1524] = 1185,
  [1525] = 1183,
  [1526] = 1191,
  [1527] = 1184,
  [1528] = 1178,
  [1529] = 1188,
  [1530] = 1190,
  [1531] = 1191,
  [1532] = 1192,
  [1533] = 1182,
  [1534] = 1213,
  [1535] = 1193,
  [1536] = 1180,
  [1537] = 1179,
  [1538] = 1182,
  [1539] = 1183,
  [1540] = 1190,
  [1541] = 1185,
  [1542] = 1179,
  [1543] = 1188,
  [1544] = 1178,
  [1545] = 1187,
  [1546] = 1178,
  [1547] = 1189,
  [1548] = 1184,
  [1549] = 1184,
  [1550] = 1180,
  [1551] = 1193,
  [1552] = 1189,
  [1553] = 1184,
  [1554] = 1178,
  [1555] = 1188,
  [1556] = 1190,
  [1557] = 1191,
  [1558] = 1192,
  [1559] = 1192,
  [1560] = 1193,
  [1561] = 1180,
  [1562] = 1179,
  [1563] = 1182,
  [1564] = 1183,
  [1565] = 1213,
  [1566] = 1185,
  [1567] = 1187,
  [1568] = 1187,
  [1569] = 1185,
  [1570] = 1189,
  [1571] = 1183,
  [1572] = 1182,
  [1573] = 1179,
  [1574] = 1180,
  [1575] = 1193,
  [1576] = 1184,
  [1577] = 1178,
  [1578] = 1188,
  [1579] = 1190,
  [1580] = 1191,
  [1581] = 1192,
  [1582] = 1193,
  [1583] = 1180,
  [1584] = 1179,
  [1585] = 1182,
  [1586] = 1183,
  [1587] = 1191,
  [1588] = 1190,
  [1589] = 1188,
  [1590] = 1192,
  [1591] = 1185,
  [1592] = 1191,
  [1593] = 1178,
  [1594] = 1187,
  [1595] = 1184,
  [1596] = 1197,
  [1597] = 1187,
  [1598] = 1189,
  [1599] = 1190,
  [1600] = 1188,
  [1601] = 1215,
  [1602] = 1178,
  [1603] = 1261,
  [1604] = 1184,
  [1605] = 1605,
  [1606] = 1184,
  [1607] = 1178,
  [1608] = 1188,
  [1609] = 1190,
  [1610] = 1191,
  [1611] = 1192,
  [1612] = 1193,
  [1613] = 1180,
  [1614] = 1179,
  [1615] = 1182,
  [1616] = 1183,
  [1617] = 1216,
  [1618] = 1185,
  [1619] = 1217,
  [1620] = 1187,
  [1621] = 1207,
  [1622] = 1189,
  [1623] = 1261,
  [1624] = 1605,
  [1625] = 1215,
  [1626] = 1261,
  [1627] = 1189,
  [1628] = 1197,
  [1629] = 1605,
  [1630] = 1184,
  [1631] = 1178,
  [1632] = 1188,
  [1633] = 1190,
  [1634] = 1191,
  [1635] = 1192,
  [1636] = 1193,
  [1637] = 1180,
  [1638] = 1179,
  [1639] = 1182,
  [1640] = 1183,
  [1641] = 1213,
  [1642] = 1185,
  [1643] = 1216,
  [1644] = 1187,
  [1645] = 1217,
  [1646] = 1646,
  [1647] = 1647,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1650,
  [1651] = 166,
  [1652] = 1652,
  [1653] = 1652,
  [1654] = 1650,
  [1655] = 283,
  [1656] = 1646,
  [1657] = 1647,
  [1658] = 1649,
  [1659] = 1650,
  [1660] = 1646,
  [1661] = 1648,
  [1662] = 1647,
  [1663] = 1647,
  [1664] = 1652,
  [1665] = 1652,
  [1666] = 280,
  [1667] = 1649,
  [1668] = 1668,
  [1669] = 1648,
  [1670] = 283,
  [1671] = 1650,
  [1672] = 1672,
  [1673] = 279,
  [1674] = 331,
  [1675] = 1675,
  [1676] = 1676,
  [1677] = 166,
  [1678] = 283,
  [1679] = 1648,
  [1680] = 1649,
  [1681] = 1681,
  [1682] = 1682,
  [1683] = 1652,
  [1684] = 283,
  [1685] = 1646,
  [1686] = 1649,
  [1687] = 1687,
  [1688] = 1648,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 349,
  [1692] = 280,
  [1693] = 345,
  [1694] = 346,
  [1695] = 347,
  [1696] = 294,
  [1697] = 1697,
  [1698] = 350,
  [1699] = 1699,
  [1700] = 279,
  [1701] = 1690,
  [1702] = 1682,
  [1703] = 1697,
  [1704] = 1704,
  [1705] = 1697,
  [1706] = 315,
  [1707] = 1668,
  [1708] = 343,
  [1709] = 1672,
  [1710] = 280,
  [1711] = 279,
  [1712] = 331,
  [1713] = 342,
  [1714] = 283,
  [1715] = 1675,
  [1716] = 1676,
  [1717] = 1717,
  [1718] = 280,
  [1719] = 279,
  [1720] = 341,
  [1721] = 279,
  [1722] = 344,
  [1723] = 283,
  [1724] = 339,
  [1725] = 338,
  [1726] = 337,
  [1727] = 451,
  [1728] = 312,
  [1729] = 313,
  [1730] = 1730,
  [1731] = 336,
  [1732] = 335,
  [1733] = 334,
  [1734] = 330,
  [1735] = 317,
  [1736] = 1736,
  [1737] = 331,
  [1738] = 333,
  [1739] = 318,
  [1740] = 328,
  [1741] = 1697,
  [1742] = 1682,
  [1743] = 327,
  [1744] = 314,
  [1745] = 1690,
  [1746] = 1668,
  [1747] = 1747,
  [1748] = 1675,
  [1749] = 1689,
  [1750] = 1682,
  [1751] = 1690,
  [1752] = 1681,
  [1753] = 1747,
  [1754] = 1747,
  [1755] = 283,
  [1756] = 315,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 1689,
  [1760] = 1690,
  [1761] = 279,
  [1762] = 1681,
  [1763] = 1763,
  [1764] = 1682,
  [1765] = 1765,
  [1766] = 1766,
  [1767] = 1767,
  [1768] = 1768,
  [1769] = 1769,
  [1770] = 1770,
  [1771] = 1676,
  [1772] = 331,
  [1773] = 1675,
  [1774] = 312,
  [1775] = 341,
  [1776] = 280,
  [1777] = 1777,
  [1778] = 1778,
  [1779] = 350,
  [1780] = 349,
  [1781] = 313,
  [1782] = 1782,
  [1783] = 314,
  [1784] = 1784,
  [1785] = 315,
  [1786] = 1786,
  [1787] = 1787,
  [1788] = 1788,
  [1789] = 1789,
  [1790] = 1790,
  [1791] = 317,
  [1792] = 318,
  [1793] = 1793,
  [1794] = 1794,
  [1795] = 1795,
  [1796] = 294,
  [1797] = 347,
  [1798] = 1798,
  [1799] = 1799,
  [1800] = 330,
  [1801] = 346,
  [1802] = 345,
  [1803] = 344,
  [1804] = 343,
  [1805] = 342,
  [1806] = 1806,
  [1807] = 327,
  [1808] = 328,
  [1809] = 1809,
  [1810] = 279,
  [1811] = 339,
  [1812] = 338,
  [1813] = 1813,
  [1814] = 337,
  [1815] = 280,
  [1816] = 318,
  [1817] = 1817,
  [1818] = 333,
  [1819] = 1819,
  [1820] = 317,
  [1821] = 336,
  [1822] = 335,
  [1823] = 334,
  [1824] = 333,
  [1825] = 315,
  [1826] = 334,
  [1827] = 335,
  [1828] = 336,
  [1829] = 337,
  [1830] = 314,
  [1831] = 1831,
  [1832] = 1832,
  [1833] = 338,
  [1834] = 1834,
  [1835] = 1835,
  [1836] = 339,
  [1837] = 1736,
  [1838] = 1838,
  [1839] = 1839,
  [1840] = 1840,
  [1841] = 1841,
  [1842] = 330,
  [1843] = 341,
  [1844] = 313,
  [1845] = 451,
  [1846] = 350,
  [1847] = 349,
  [1848] = 294,
  [1849] = 347,
  [1850] = 346,
  [1851] = 290,
  [1852] = 342,
  [1853] = 343,
  [1854] = 344,
  [1855] = 345,
  [1856] = 344,
  [1857] = 1857,
  [1858] = 312,
  [1859] = 328,
  [1860] = 1786,
  [1861] = 1784,
  [1862] = 327,
  [1863] = 1863,
  [1864] = 1864,
  [1865] = 1865,
  [1866] = 1681,
  [1867] = 1867,
  [1868] = 1868,
  [1869] = 343,
  [1870] = 342,
  [1871] = 1871,
  [1872] = 341,
  [1873] = 339,
  [1874] = 338,
  [1875] = 1875,
  [1876] = 345,
  [1877] = 346,
  [1878] = 347,
  [1879] = 337,
  [1880] = 294,
  [1881] = 1841,
  [1882] = 349,
  [1883] = 1857,
  [1884] = 336,
  [1885] = 335,
  [1886] = 334,
  [1887] = 333,
  [1888] = 350,
  [1889] = 331,
  [1890] = 1857,
  [1891] = 1689,
  [1892] = 1841,
  [1893] = 1893,
  [1894] = 1894,
  [1895] = 451,
  [1896] = 330,
  [1897] = 328,
  [1898] = 1784,
  [1899] = 1786,
  [1900] = 1900,
  [1901] = 327,
  [1902] = 318,
  [1903] = 317,
  [1904] = 1904,
  [1905] = 314,
  [1906] = 1672,
  [1907] = 313,
  [1908] = 1908,
  [1909] = 312,
  [1910] = 1910,
  [1911] = 1911,
  [1912] = 1668,
  [1913] = 1913,
  [1914] = 1875,
  [1915] = 1915,
  [1916] = 166,
  [1917] = 1917,
  [1918] = 1911,
  [1919] = 1919,
  [1920] = 1913,
  [1921] = 283,
  [1922] = 1910,
  [1923] = 1923,
  [1924] = 1908,
  [1925] = 1925,
  [1926] = 1867,
  [1927] = 344,
  [1928] = 343,
  [1929] = 1929,
  [1930] = 1930,
  [1931] = 1835,
  [1932] = 1834,
  [1933] = 342,
  [1934] = 341,
  [1935] = 1915,
  [1936] = 1936,
  [1937] = 331,
  [1938] = 330,
  [1939] = 1939,
  [1940] = 313,
  [1941] = 312,
  [1942] = 328,
  [1943] = 327,
  [1944] = 1923,
  [1945] = 1929,
  [1946] = 1782,
  [1947] = 1787,
  [1948] = 1923,
  [1949] = 1915,
  [1950] = 1838,
  [1951] = 1832,
  [1952] = 1923,
  [1953] = 1788,
  [1954] = 1831,
  [1955] = 1789,
  [1956] = 1790,
  [1957] = 349,
  [1958] = 1930,
  [1959] = 1923,
  [1960] = 1923,
  [1961] = 1961,
  [1962] = 1923,
  [1963] = 1819,
  [1964] = 1915,
  [1965] = 283,
  [1966] = 1913,
  [1967] = 1817,
  [1968] = 1793,
  [1969] = 1794,
  [1970] = 1795,
  [1971] = 339,
  [1972] = 1809,
  [1973] = 338,
  [1974] = 1923,
  [1975] = 337,
  [1976] = 318,
  [1977] = 451,
  [1978] = 314,
  [1979] = 283,
  [1980] = 1923,
  [1981] = 1923,
  [1982] = 1919,
  [1983] = 1904,
  [1984] = 1778,
  [1985] = 350,
  [1986] = 1923,
  [1987] = 1798,
  [1988] = 349,
  [1989] = 1925,
  [1990] = 1777,
  [1991] = 1936,
  [1992] = 1919,
  [1993] = 1799,
  [1994] = 1813,
  [1995] = 315,
  [1996] = 331,
  [1997] = 333,
  [1998] = 1929,
  [1999] = 1923,
  [2000] = 334,
  [2001] = 335,
  [2002] = 1923,
  [2003] = 1923,
  [2004] = 1923,
  [2005] = 1770,
  [2006] = 451,
  [2007] = 350,
  [2008] = 1863,
  [2009] = 1769,
  [2010] = 294,
  [2011] = 347,
  [2012] = 346,
  [2013] = 1923,
  [2014] = 345,
  [2015] = 1923,
  [2016] = 344,
  [2017] = 343,
  [2018] = 1923,
  [2019] = 342,
  [2020] = 341,
  [2021] = 336,
  [2022] = 339,
  [2023] = 317,
  [2024] = 1925,
  [2025] = 338,
  [2026] = 1768,
  [2027] = 1871,
  [2028] = 2028,
  [2029] = 300,
  [2030] = 337,
  [2031] = 1758,
  [2032] = 1923,
  [2033] = 336,
  [2034] = 335,
  [2035] = 1767,
  [2036] = 1915,
  [2037] = 334,
  [2038] = 1930,
  [2039] = 1915,
  [2040] = 1766,
  [2041] = 1875,
  [2042] = 333,
  [2043] = 330,
  [2044] = 1923,
  [2045] = 1806,
  [2046] = 1936,
  [2047] = 1699,
  [2048] = 1923,
  [2049] = 1961,
  [2050] = 1923,
  [2051] = 294,
  [2052] = 1923,
  [2053] = 1923,
  [2054] = 1871,
  [2055] = 347,
  [2056] = 1923,
  [2057] = 2057,
  [2058] = 1923,
  [2059] = 328,
  [2060] = 327,
  [2061] = 2061,
  [2062] = 1923,
  [2063] = 346,
  [2064] = 1894,
  [2065] = 2065,
  [2066] = 1893,
  [2067] = 1915,
  [2068] = 345,
  [2069] = 1765,
  [2070] = 1839,
  [2071] = 2071,
  [2072] = 1757,
  [2073] = 1868,
  [2074] = 1865,
  [2075] = 318,
  [2076] = 1923,
  [2077] = 317,
  [2078] = 1864,
  [2079] = 1915,
  [2080] = 1923,
  [2081] = 1923,
  [2082] = 1961,
  [2083] = 312,
  [2084] = 1840,
  [2085] = 313,
  [2086] = 1763,
  [2087] = 315,
  [2088] = 280,
  [2089] = 1923,
  [2090] = 1915,
  [2091] = 314,
  [2092] = 1900,
  [2093] = 2093,
  [2094] = 314,
  [2095] = 313,
  [2096] = 279,
  [2097] = 1819,
  [2098] = 312,
  [2099] = 1817,
  [2100] = 482,
  [2101] = 2071,
  [2102] = 1809,
  [2103] = 2103,
  [2104] = 1778,
  [2105] = 1777,
  [2106] = 1790,
  [2107] = 315,
  [2108] = 279,
  [2109] = 1834,
  [2110] = 1789,
  [2111] = 1835,
  [2112] = 2112,
  [2113] = 1699,
  [2114] = 317,
  [2115] = 318,
  [2116] = 2103,
  [2117] = 283,
  [2118] = 2118,
  [2119] = 2112,
  [2120] = 1763,
  [2121] = 1813,
  [2122] = 1770,
  [2123] = 2112,
  [2124] = 2124,
  [2125] = 2103,
  [2126] = 1788,
  [2127] = 1806,
  [2128] = 2065,
  [2129] = 2061,
  [2130] = 334,
  [2131] = 485,
  [2132] = 2057,
  [2133] = 1911,
  [2134] = 1799,
  [2135] = 1798,
  [2136] = 1769,
  [2137] = 477,
  [2138] = 1832,
  [2139] = 2112,
  [2140] = 1838,
  [2141] = 1787,
  [2142] = 1736,
  [2143] = 1782,
  [2144] = 1768,
  [2145] = 1766,
  [2146] = 331,
  [2147] = 2112,
  [2148] = 2103,
  [2149] = 2149,
  [2150] = 327,
  [2151] = 2103,
  [2152] = 328,
  [2153] = 451,
  [2154] = 1900,
  [2155] = 1840,
  [2156] = 1863,
  [2157] = 2112,
  [2158] = 330,
  [2159] = 280,
  [2160] = 1765,
  [2161] = 1910,
  [2162] = 2103,
  [2163] = 1864,
  [2164] = 333,
  [2165] = 1865,
  [2166] = 1867,
  [2167] = 1795,
  [2168] = 335,
  [2169] = 1757,
  [2170] = 1794,
  [2171] = 1793,
  [2172] = 1831,
  [2173] = 1917,
  [2174] = 2112,
  [2175] = 336,
  [2176] = 1839,
  [2177] = 1699,
  [2178] = 2103,
  [2179] = 1868,
  [2180] = 280,
  [2181] = 2112,
  [2182] = 1767,
  [2183] = 2183,
  [2184] = 2184,
  [2185] = 1908,
  [2186] = 1736,
  [2187] = 1699,
  [2188] = 2103,
  [2189] = 337,
  [2190] = 1939,
  [2191] = 1871,
  [2192] = 1758,
  [2193] = 2103,
  [2194] = 338,
  [2195] = 339,
  [2196] = 341,
  [2197] = 342,
  [2198] = 1717,
  [2199] = 343,
  [2200] = 2112,
  [2201] = 279,
  [2202] = 344,
  [2203] = 451,
  [2204] = 331,
  [2205] = 345,
  [2206] = 1875,
  [2207] = 346,
  [2208] = 347,
  [2209] = 294,
  [2210] = 1894,
  [2211] = 349,
  [2212] = 350,
  [2213] = 1893,
  [2214] = 1904,
  [2215] = 2215,
  [2216] = 346,
  [2217] = 2217,
  [2218] = 451,
  [2219] = 2215,
  [2220] = 2217,
  [2221] = 2221,
  [2222] = 314,
  [2223] = 315,
  [2224] = 314,
  [2225] = 2217,
  [2226] = 2215,
  [2227] = 317,
  [2228] = 318,
  [2229] = 2217,
  [2230] = 315,
  [2231] = 333,
  [2232] = 334,
  [2233] = 2217,
  [2234] = 335,
  [2235] = 2215,
  [2236] = 336,
  [2237] = 2217,
  [2238] = 2215,
  [2239] = 2217,
  [2240] = 2215,
  [2241] = 327,
  [2242] = 2215,
  [2243] = 2215,
  [2244] = 328,
  [2245] = 317,
  [2246] = 2221,
  [2247] = 318,
  [2248] = 330,
  [2249] = 337,
  [2250] = 350,
  [2251] = 2217,
  [2252] = 2217,
  [2253] = 2253,
  [2254] = 2215,
  [2255] = 2215,
  [2256] = 312,
  [2257] = 2217,
  [2258] = 2217,
  [2259] = 2217,
  [2260] = 2217,
  [2261] = 333,
  [2262] = 2215,
  [2263] = 334,
  [2264] = 2215,
  [2265] = 2215,
  [2266] = 2215,
  [2267] = 335,
  [2268] = 336,
  [2269] = 337,
  [2270] = 338,
  [2271] = 339,
  [2272] = 341,
  [2273] = 342,
  [2274] = 338,
  [2275] = 2217,
  [2276] = 2217,
  [2277] = 343,
  [2278] = 344,
  [2279] = 2217,
  [2280] = 346,
  [2281] = 2215,
  [2282] = 347,
  [2283] = 294,
  [2284] = 349,
  [2285] = 313,
  [2286] = 2217,
  [2287] = 2217,
  [2288] = 2217,
  [2289] = 339,
  [2290] = 2215,
  [2291] = 2215,
  [2292] = 350,
  [2293] = 341,
  [2294] = 2294,
  [2295] = 2215,
  [2296] = 2217,
  [2297] = 2253,
  [2298] = 2215,
  [2299] = 2215,
  [2300] = 2215,
  [2301] = 342,
  [2302] = 2215,
  [2303] = 331,
  [2304] = 345,
  [2305] = 2305,
  [2306] = 2217,
  [2307] = 327,
  [2308] = 343,
  [2309] = 328,
  [2310] = 312,
  [2311] = 2217,
  [2312] = 344,
  [2313] = 2217,
  [2314] = 345,
  [2315] = 2215,
  [2316] = 2215,
  [2317] = 2217,
  [2318] = 347,
  [2319] = 294,
  [2320] = 349,
  [2321] = 2215,
  [2322] = 2221,
  [2323] = 2217,
  [2324] = 2217,
  [2325] = 2217,
  [2326] = 2326,
  [2327] = 2215,
  [2328] = 2215,
  [2329] = 2028,
  [2330] = 2253,
  [2331] = 330,
  [2332] = 2215,
  [2333] = 313,
  [2334] = 2215,
  [2335] = 2217,
  [2336] = 2215,
  [2337] = 451,
  [2338] = 2217,
  [2339] = 2339,
  [2340] = 2217,
  [2341] = 2341,
  [2342] = 2215,
  [2343] = 2253,
  [2344] = 2217,
  [2345] = 2061,
  [2346] = 2346,
  [2347] = 2347,
  [2348] = 2348,
  [2349] = 2349,
  [2350] = 2350,
  [2351] = 2351,
  [2352] = 2352,
  [2353] = 2353,
  [2354] = 2354,
  [2355] = 2346,
  [2356] = 2356,
  [2357] = 2354,
  [2358] = 2347,
  [2359] = 2359,
  [2360] = 2360,
  [2361] = 2360,
  [2362] = 2359,
  [2363] = 2356,
  [2364] = 2354,
  [2365] = 2351,
  [2366] = 2366,
  [2367] = 451,
  [2368] = 2353,
  [2369] = 2366,
  [2370] = 2370,
  [2371] = 2351,
  [2372] = 2372,
  [2373] = 2366,
  [2374] = 2352,
  [2375] = 2349,
  [2376] = 2349,
  [2377] = 2348,
  [2378] = 2354,
  [2379] = 2349,
  [2380] = 2346,
  [2381] = 2352,
  [2382] = 2348,
  [2383] = 2057,
  [2384] = 1917,
  [2385] = 2028,
  [2386] = 2360,
  [2387] = 2351,
  [2388] = 2359,
  [2389] = 2348,
  [2390] = 1939,
  [2391] = 2353,
  [2392] = 2350,
  [2393] = 2372,
  [2394] = 2071,
  [2395] = 2065,
  [2396] = 2366,
  [2397] = 2028,
  [2398] = 2349,
  [2399] = 2028,
  [2400] = 2348,
  [2401] = 2352,
  [2402] = 1917,
  [2403] = 2057,
  [2404] = 2352,
  [2405] = 2065,
  [2406] = 2061,
  [2407] = 2347,
  [2408] = 2356,
  [2409] = 1939,
  [2410] = 2410,
  [2411] = 2350,
  [2412] = 2071,
  [2413] = 2410,
  [2414] = 2410,
  [2415] = 2415,
  [2416] = 2415,
  [2417] = 2417,
  [2418] = 2418,
  [2419] = 2417,
  [2420] = 2418,
  [2421] = 2418,
  [2422] = 2418,
  [2423] = 2423,
  [2424] = 2417,
  [2425] = 283,
  [2426] = 2418,
  [2427] = 2417,
  [2428] = 2418,
  [2429] = 2417,
  [2430] = 2417,
  [2431] = 2418,
  [2432] = 2417,
  [2433] = 2417,
  [2434] = 2418,
  [2435] = 2417,
  [2436] = 2417,
  [2437] = 2418,
  [2438] = 2417,
  [2439] = 2417,
  [2440] = 2418,
  [2441] = 2418,
  [2442] = 2418,
  [2443] = 2418,
  [2444] = 2418,
  [2445] = 2417,
  [2446] = 2418,
  [2447] = 2417,
  [2448] = 2417,
  [2449] = 2418,
  [2450] = 2417,
  [2451] = 2417,
  [2452] = 2418,
  [2453] = 2417,
  [2454] = 2417,
  [2455] = 2417,
  [2456] = 2417,
  [2457] = 2418,
  [2458] = 2418,
  [2459] = 2417,
  [2460] = 2418,
  [2461] = 2417,
  [2462] = 2417,
  [2463] = 2417,
  [2464] = 166,
  [2465] = 2418,
  [2466] = 2418,
  [2467] = 2417,
  [2468] = 2418,
  [2469] = 2417,
  [2470] = 2417,
  [2471] = 2418,
  [2472] = 280,
  [2473] = 2417,
  [2474] = 2418,
  [2475] = 2417,
  [2476] = 2418,
  [2477] = 2418,
  [2478] = 2417,
  [2479] = 2417,
  [2480] = 279,
  [2481] = 2418,
  [2482] = 2418,
  [2483] = 333,
  [2484] = 349,
  [2485] = 344,
  [2486] = 294,
  [2487] = 343,
  [2488] = 314,
  [2489] = 342,
  [2490] = 312,
  [2491] = 341,
  [2492] = 339,
  [2493] = 315,
  [2494] = 347,
  [2495] = 338,
  [2496] = 346,
  [2497] = 337,
  [2498] = 2498,
  [2499] = 350,
  [2500] = 313,
  [2501] = 317,
  [2502] = 336,
  [2503] = 335,
  [2504] = 334,
  [2505] = 331,
  [2506] = 318,
  [2507] = 345,
  [2508] = 330,
  [2509] = 328,
  [2510] = 327,
  [2511] = 451,
  [2512] = 280,
  [2513] = 279,
  [2514] = 166,
  [2515] = 2423,
  [2516] = 166,
  [2517] = 283,
  [2518] = 335,
  [2519] = 2519,
  [2520] = 2519,
  [2521] = 336,
  [2522] = 2519,
  [2523] = 312,
  [2524] = 337,
  [2525] = 338,
  [2526] = 2519,
  [2527] = 166,
  [2528] = 339,
  [2529] = 341,
  [2530] = 342,
  [2531] = 2519,
  [2532] = 2519,
  [2533] = 334,
  [2534] = 333,
  [2535] = 313,
  [2536] = 330,
  [2537] = 343,
  [2538] = 2519,
  [2539] = 2519,
  [2540] = 2519,
  [2541] = 318,
  [2542] = 2519,
  [2543] = 2519,
  [2544] = 328,
  [2545] = 344,
  [2546] = 345,
  [2547] = 346,
  [2548] = 2519,
  [2549] = 347,
  [2550] = 327,
  [2551] = 2498,
  [2552] = 2519,
  [2553] = 2519,
  [2554] = 2519,
  [2555] = 2519,
  [2556] = 2519,
  [2557] = 2519,
  [2558] = 2519,
  [2559] = 2519,
  [2560] = 331,
  [2561] = 2519,
  [2562] = 2519,
  [2563] = 314,
  [2564] = 2519,
  [2565] = 2519,
  [2566] = 315,
  [2567] = 2519,
  [2568] = 2519,
  [2569] = 2519,
  [2570] = 2519,
  [2571] = 2519,
  [2572] = 2519,
  [2573] = 2519,
  [2574] = 350,
  [2575] = 317,
  [2576] = 349,
  [2577] = 294,
  [2578] = 2578,
  [2579] = 2579,
  [2580] = 2579,
  [2581] = 2581,
  [2582] = 2582,
  [2583] = 2583,
  [2584] = 451,
  [2585] = 2578,
  [2586] = 2583,
  [2587] = 2579,
  [2588] = 2588,
  [2589] = 2578,
  [2590] = 2579,
  [2591] = 2578,
  [2592] = 2579,
  [2593] = 2583,
  [2594] = 2583,
  [2595] = 2583,
  [2596] = 2578,
  [2597] = 2578,
  [2598] = 2579,
  [2599] = 2579,
  [2600] = 2579,
  [2601] = 2583,
  [2602] = 2578,
  [2603] = 2579,
  [2604] = 2583,
  [2605] = 2583,
  [2606] = 2578,
  [2607] = 2578,
  [2608] = 2578,
  [2609] = 2609,
  [2610] = 2583,
  [2611] = 2583,
  [2612] = 2583,
  [2613] = 2583,
  [2614] = 2578,
  [2615] = 2579,
  [2616] = 2583,
  [2617] = 2579,
  [2618] = 2618,
  [2619] = 2579,
  [2620] = 2579,
  [2621] = 2579,
  [2622] = 2579,
  [2623] = 2623,
  [2624] = 2579,
  [2625] = 2579,
  [2626] = 2579,
  [2627] = 2579,
  [2628] = 2583,
  [2629] = 2583,
  [2630] = 2578,
  [2631] = 2578,
  [2632] = 2583,
  [2633] = 2579,
  [2634] = 2634,
  [2635] = 2583,
  [2636] = 2578,
  [2637] = 2579,
  [2638] = 2583,
  [2639] = 2578,
  [2640] = 2583,
  [2641] = 2579,
  [2642] = 2578,
  [2643] = 2643,
  [2644] = 2578,
  [2645] = 2579,
  [2646] = 2646,
  [2647] = 2579,
  [2648] = 2583,
  [2649] = 2578,
  [2650] = 2578,
  [2651] = 2579,
  [2652] = 2583,
  [2653] = 2578,
  [2654] = 2583,
  [2655] = 2583,
  [2656] = 2578,
  [2657] = 2583,
  [2658] = 2578,
  [2659] = 2583,
  [2660] = 2578,
  [2661] = 2578,
  [2662] = 2579,
  [2663] = 2579,
  [2664] = 2583,
  [2665] = 2578,
  [2666] = 2583,
  [2667] = 2583,
  [2668] = 2668,
  [2669] = 2583,
  [2670] = 2578,
  [2671] = 2578,
  [2672] = 2578,
  [2673] = 2578,
  [2674] = 2579,
  [2675] = 2579,
  [2676] = 2676,
  [2677] = 2676,
  [2678] = 2676,
  [2679] = 2676,
  [2680] = 2676,
  [2681] = 2676,
  [2682] = 2682,
  [2683] = 2676,
  [2684] = 2684,
  [2685] = 2676,
  [2686] = 2676,
  [2687] = 2687,
  [2688] = 2688,
  [2689] = 2676,
  [2690] = 2690,
  [2691] = 2676,
  [2692] = 2676,
  [2693] = 2693,
  [2694] = 2676,
  [2695] = 2695,
  [2696] = 2676,
  [2697] = 2688,
  [2698] = 2676,
  [2699] = 2676,
  [2700] = 2700,
  [2701] = 2676,
  [2702] = 2676,
  [2703] = 2676,
  [2704] = 2676,
  [2705] = 2705,
  [2706] = 2676,
  [2707] = 2707,
  [2708] = 2676,
  [2709] = 2709,
  [2710] = 2710,
  [2711] = 2711,
  [2712] = 2712,
  [2713] = 2688,
  [2714] = 2714,
  [2715] = 2715,
  [2716] = 2716,
  [2717] = 2717,
  [2718] = 2718,
  [2719] = 2719,
  [2720] = 2676,
  [2721] = 2721,
  [2722] = 2722,
  [2723] = 2723,
  [2724] = 2724,
  [2725] = 2676,
  [2726] = 2688,
  [2727] = 2727,
  [2728] = 2676,
  [2729] = 2676,
  [2730] = 2676,
  [2731] = 2731,
  [2732] = 2732,
  [2733] = 2676,
  [2734] = 2676,
  [2735] = 2676,
  [2736] = 2676,
  [2737] = 2737,
  [2738] = 2738,
  [2739] = 2739,
  [2740] = 2738,
  [2741] = 2738,
  [2742] = 2742,
  [2743] = 2743,
  [2744] = 2738,
  [2745] = 2743,
  [2746] = 2743,
  [2747] = 2738,
  [2748] = 2738,
  [2749] = 2743,
  [2750] = 2743,
  [2751] = 2743,
  [2752] = 2738,
  [2753] = 2743,
  [2754] = 2738,
  [2755] = 2738,
  [2756] = 2743,
  [2757] = 2743,
  [2758] = 2738,
  [2759] = 2739,
  [2760] = 2743,
  [2761] = 2738,
  [2762] = 2762,
  [2763] = 2738,
  [2764] = 2743,
  [2765] = 2743,
  [2766] = 2743,
  [2767] = 2738,
  [2768] = 2738,
  [2769] = 2743,
  [2770] = 2743,
  [2771] = 2743,
  [2772] = 2738,
  [2773] = 2738,
  [2774] = 2743,
  [2775] = 2743,
  [2776] = 2743,
  [2777] = 2738,
  [2778] = 2738,
  [2779] = 2779,
  [2780] = 2779,
  [2781] = 2743,
  [2782] = 2743,
  [2783] = 2743,
  [2784] = 2743,
  [2785] = 2738,
  [2786] = 2738,
  [2787] = 2743,
  [2788] = 2738,
  [2789] = 2743,
  [2790] = 2738,
  [2791] = 2738,
  [2792] = 2738,
  [2793] = 2743,
  [2794] = 2743,
  [2795] = 2743,
  [2796] = 2739,
  [2797] = 2738,
  [2798] = 2738,
  [2799] = 2738,
  [2800] = 2738,
  [2801] = 2801,
  [2802] = 2743,
  [2803] = 2779,
  [2804] = 2738,
  [2805] = 2805,
  [2806] = 2806,
  [2807] = 283,
  [2808] = 2805,
  [2809] = 2809,
  [2810] = 2810,
  [2811] = 2809,
  [2812] = 2806,
  [2813] = 2806,
  [2814] = 2809,
  [2815] = 2805,
  [2816] = 341,
  [2817] = 350,
  [2818] = 2818,
  [2819] = 279,
  [2820] = 2820,
  [2821] = 2821,
  [2822] = 2822,
  [2823] = 2823,
  [2824] = 2824,
  [2825] = 2825,
  [2826] = 331,
  [2827] = 2825,
  [2828] = 327,
  [2829] = 328,
  [2830] = 2830,
  [2831] = 330,
  [2832] = 2830,
  [2833] = 2833,
  [2834] = 342,
  [2835] = 333,
  [2836] = 334,
  [2837] = 335,
  [2838] = 280,
  [2839] = 343,
  [2840] = 344,
  [2841] = 345,
  [2842] = 336,
  [2843] = 346,
  [2844] = 347,
  [2845] = 294,
  [2846] = 349,
  [2847] = 337,
  [2848] = 2825,
  [2849] = 338,
  [2850] = 339,
  [2851] = 2830,
  [2852] = 2852,
  [2853] = 339,
  [2854] = 2854,
  [2855] = 315,
  [2856] = 2822,
  [2857] = 333,
  [2858] = 334,
  [2859] = 335,
  [2860] = 336,
  [2861] = 2861,
  [2862] = 317,
  [2863] = 2818,
  [2864] = 318,
  [2865] = 337,
  [2866] = 338,
  [2867] = 313,
  [2868] = 350,
  [2869] = 349,
  [2870] = 2861,
  [2871] = 294,
  [2872] = 2852,
  [2873] = 347,
  [2874] = 346,
  [2875] = 339,
  [2876] = 345,
  [2877] = 344,
  [2878] = 343,
  [2879] = 342,
  [2880] = 341,
  [2881] = 314,
  [2882] = 451,
  [2883] = 338,
  [2884] = 337,
  [2885] = 2821,
  [2886] = 2861,
  [2887] = 2833,
  [2888] = 330,
  [2889] = 2823,
  [2890] = 341,
  [2891] = 342,
  [2892] = 336,
  [2893] = 335,
  [2894] = 334,
  [2895] = 333,
  [2896] = 343,
  [2897] = 344,
  [2898] = 330,
  [2899] = 328,
  [2900] = 345,
  [2901] = 327,
  [2902] = 346,
  [2903] = 347,
  [2904] = 294,
  [2905] = 2852,
  [2906] = 349,
  [2907] = 350,
  [2908] = 2908,
  [2909] = 327,
  [2910] = 328,
  [2911] = 312,
  [2912] = 2912,
  [2913] = 2913,
  [2914] = 2914,
  [2915] = 2913,
  [2916] = 2916,
  [2917] = 2818,
  [2918] = 2918,
  [2919] = 2919,
  [2920] = 2919,
  [2921] = 2833,
  [2922] = 2922,
  [2923] = 2923,
  [2924] = 2924,
  [2925] = 2925,
  [2926] = 2918,
  [2927] = 2927,
  [2928] = 2928,
  [2929] = 2913,
  [2930] = 2922,
  [2931] = 2914,
  [2932] = 2912,
  [2933] = 2922,
  [2934] = 2923,
  [2935] = 2935,
  [2936] = 2923,
  [2937] = 2919,
  [2938] = 2823,
  [2939] = 283,
  [2940] = 2928,
  [2941] = 2914,
  [2942] = 2942,
  [2943] = 2943,
  [2944] = 2935,
  [2945] = 2822,
  [2946] = 2927,
  [2947] = 2821,
  [2948] = 2928,
  [2949] = 2818,
  [2950] = 2823,
  [2951] = 2927,
  [2952] = 2823,
  [2953] = 2935,
  [2954] = 2912,
  [2955] = 2918,
  [2956] = 2818,
  [2957] = 2957,
  [2958] = 2958,
  [2959] = 2959,
  [2960] = 2960,
  [2961] = 2961,
  [2962] = 2962,
  [2963] = 2963,
  [2964] = 2964,
  [2965] = 2965,
  [2966] = 2966,
  [2967] = 2962,
  [2968] = 2968,
  [2969] = 2969,
  [2970] = 2970,
  [2971] = 2971,
  [2972] = 2972,
  [2973] = 2964,
  [2974] = 2972,
  [2975] = 2961,
  [2976] = 2963,
  [2977] = 279,
  [2978] = 2978,
  [2979] = 2979,
  [2980] = 2971,
  [2981] = 2972,
  [2982] = 2960,
  [2983] = 2959,
  [2984] = 2957,
  [2985] = 2964,
  [2986] = 283,
  [2987] = 2958,
  [2988] = 2988,
  [2989] = 2989,
  [2990] = 2962,
  [2991] = 2961,
  [2992] = 2988,
  [2993] = 2960,
  [2994] = 2989,
  [2995] = 2959,
  [2996] = 2963,
  [2997] = 283,
  [2998] = 2998,
  [2999] = 2957,
  [3000] = 3000,
  [3001] = 3001,
  [3002] = 2971,
  [3003] = 2972,
  [3004] = 3000,
  [3005] = 3000,
  [3006] = 2958,
  [3007] = 3001,
  [3008] = 331,
  [3009] = 3001,
  [3010] = 2989,
  [3011] = 3011,
  [3012] = 3012,
  [3013] = 3013,
  [3014] = 3014,
  [3015] = 3011,
  [3016] = 3016,
  [3017] = 3016,
  [3018] = 3011,
  [3019] = 3011,
  [3020] = 3013,
  [3021] = 3013,
  [3022] = 3016,
  [3023] = 3011,
  [3024] = 3011,
  [3025] = 3013,
  [3026] = 3014,
  [3027] = 3014,
  [3028] = 3011,
  [3029] = 3016,
  [3030] = 3011,
  [3031] = 451,
  [3032] = 3013,
  [3033] = 3016,
  [3034] = 3011,
  [3035] = 3013,
  [3036] = 3014,
  [3037] = 3016,
  [3038] = 3013,
  [3039] = 3014,
  [3040] = 3016,
  [3041] = 3014,
  [3042] = 3042,
  [3043] = 3042,
  [3044] = 3044,
  [3045] = 3014,
  [3046] = 3014,
  [3047] = 3013,
  [3048] = 3048,
  [3049] = 3014,
  [3050] = 3016,
  [3051] = 3016,
  [3052] = 3013,
  [3053] = 2118,
  [3054] = 331,
  [3055] = 3014,
  [3056] = 3013,
  [3057] = 3016,
  [3058] = 3011,
  [3059] = 3011,
  [3060] = 3011,
  [3061] = 3013,
  [3062] = 3013,
  [3063] = 3013,
  [3064] = 3048,
  [3065] = 3013,
  [3066] = 3011,
  [3067] = 3011,
  [3068] = 3011,
  [3069] = 3016,
  [3070] = 3014,
  [3071] = 3014,
  [3072] = 3016,
  [3073] = 3013,
  [3074] = 3011,
  [3075] = 3013,
  [3076] = 3011,
  [3077] = 3011,
  [3078] = 2124,
  [3079] = 3013,
  [3080] = 3080,
  [3081] = 3016,
  [3082] = 3014,
  [3083] = 3083,
  [3084] = 3016,
  [3085] = 3085,
  [3086] = 3086,
  [3087] = 3016,
  [3088] = 3016,
  [3089] = 3014,
  [3090] = 3013,
  [3091] = 3014,
  [3092] = 3014,
  [3093] = 3016,
  [3094] = 3014,
  [3095] = 3016,
  [3096] = 3016,
  [3097] = 3097,
  [3098] = 3098,
  [3099] = 3013,
  [3100] = 3014,
  [3101] = 3011,
  [3102] = 3011,
  [3103] = 279,
  [3104] = 3013,
  [3105] = 3011,
  [3106] = 3013,
  [3107] = 3016,
  [3108] = 3014,
  [3109] = 3014,
  [3110] = 3013,
  [3111] = 3014,
  [3112] = 3042,
  [3113] = 3016,
  [3114] = 3042,
  [3115] = 3115,
  [3116] = 3116,
  [3117] = 3117,
  [3118] = 3016,
  [3119] = 3013,
  [3120] = 3011,
  [3121] = 3121,
  [3122] = 3016,
  [3123] = 3014,
  [3124] = 3014,
  [3125] = 3014,
  [3126] = 2183,
  [3127] = 3014,
  [3128] = 3016,
  [3129] = 3011,
  [3130] = 3016,
  [3131] = 3011,
  [3132] = 3013,
  [3133] = 3011,
  [3134] = 3013,
  [3135] = 3013,
  [3136] = 3011,
  [3137] = 3014,
  [3138] = 3138,
  [3139] = 3042,
  [3140] = 3140,
  [3141] = 3016,
  [3142] = 3016,
  [3143] = 3014,
  [3144] = 3011,
  [3145] = 3013,
  [3146] = 3013,
  [3147] = 3014,
  [3148] = 3016,
  [3149] = 3011,
  [3150] = 3042,
  [3151] = 280,
  [3152] = 3042,
  [3153] = 3014,
  [3154] = 3016,
  [3155] = 3011,
  [3156] = 3011,
  [3157] = 3013,
  [3158] = 3014,
  [3159] = 3042,
  [3160] = 3016,
  [3161] = 3016,
  [3162] = 2184,
  [3163] = 3014,
  [3164] = 279,
  [3165] = 3011,
  [3166] = 3042,
  [3167] = 3013,
  [3168] = 3013,
  [3169] = 3169,
  [3170] = 3170,
  [3171] = 2305,
  [3172] = 3172,
  [3173] = 2294,
  [3174] = 3172,
  [3175] = 3175,
  [3176] = 3172,
  [3177] = 3170,
  [3178] = 3169,
  [3179] = 3170,
  [3180] = 3169,
  [3181] = 3170,
  [3182] = 3169,
  [3183] = 3170,
  [3184] = 3169,
  [3185] = 3185,
  [3186] = 3186,
  [3187] = 3187,
  [3188] = 3170,
  [3189] = 3169,
  [3190] = 3190,
  [3191] = 3170,
  [3192] = 3169,
  [3193] = 3170,
  [3194] = 3169,
  [3195] = 3175,
  [3196] = 3170,
  [3197] = 3169,
  [3198] = 3170,
  [3199] = 3169,
  [3200] = 3169,
  [3201] = 3170,
  [3202] = 3169,
  [3203] = 3170,
  [3204] = 3169,
  [3205] = 3170,
  [3206] = 3169,
  [3207] = 3170,
  [3208] = 3169,
  [3209] = 3169,
  [3210] = 3210,
  [3211] = 3170,
  [3212] = 3169,
  [3213] = 3170,
  [3214] = 3169,
  [3215] = 3170,
  [3216] = 3169,
  [3217] = 3170,
  [3218] = 3169,
  [3219] = 3210,
  [3220] = 3170,
  [3221] = 3169,
  [3222] = 3170,
  [3223] = 3169,
  [3224] = 2339,
  [3225] = 2341,
  [3226] = 3170,
  [3227] = 328,
  [3228] = 3170,
  [3229] = 3169,
  [3230] = 3186,
  [3231] = 3170,
  [3232] = 3169,
  [3233] = 3190,
  [3234] = 3185,
  [3235] = 3170,
  [3236] = 3169,
  [3237] = 3185,
  [3238] = 3170,
  [3239] = 3169,
  [3240] = 3169,
  [3241] = 3185,
  [3242] = 3170,
  [3243] = 3169,
  [3244] = 3185,
  [3245] = 312,
  [3246] = 3170,
  [3247] = 3247,
  [3248] = 3170,
  [3249] = 313,
  [3250] = 3185,
  [3251] = 314,
  [3252] = 3170,
  [3253] = 3210,
  [3254] = 451,
  [3255] = 3169,
  [3256] = 3185,
  [3257] = 350,
  [3258] = 349,
  [3259] = 294,
  [3260] = 347,
  [3261] = 315,
  [3262] = 346,
  [3263] = 345,
  [3264] = 344,
  [3265] = 3170,
  [3266] = 317,
  [3267] = 3169,
  [3268] = 3185,
  [3269] = 343,
  [3270] = 318,
  [3271] = 327,
  [3272] = 342,
  [3273] = 341,
  [3274] = 339,
  [3275] = 330,
  [3276] = 338,
  [3277] = 3175,
  [3278] = 333,
  [3279] = 3170,
  [3280] = 334,
  [3281] = 337,
  [3282] = 3185,
  [3283] = 335,
  [3284] = 336,
  [3285] = 3190,
  [3286] = 3169,
  [3287] = 3287,
  [3288] = 3288,
  [3289] = 3289,
  [3290] = 3290,
  [3291] = 3290,
  [3292] = 3292,
  [3293] = 3293,
  [3294] = 3294,
  [3295] = 3295,
  [3296] = 3293,
  [3297] = 3297,
  [3298] = 3294,
  [3299] = 3299,
  [3300] = 3300,
  [3301] = 3297,
  [3302] = 3302,
  [3303] = 3303,
  [3304] = 3302,
  [3305] = 3297,
  [3306] = 3294,
  [3307] = 3302,
  [3308] = 3300,
  [3309] = 3290,
  [3310] = 3302,
  [3311] = 3311,
  [3312] = 3293,
  [3313] = 3313,
  [3314] = 3294,
  [3315] = 3315,
  [3316] = 3297,
  [3317] = 3302,
  [3318] = 3302,
  [3319] = 3290,
  [3320] = 3297,
  [3321] = 3294,
  [3322] = 3322,
  [3323] = 3297,
  [3324] = 3324,
  [3325] = 3293,
  [3326] = 3326,
  [3327] = 3297,
  [3328] = 3328,
  [3329] = 3294,
  [3330] = 3302,
  [3331] = 3293,
  [3332] = 3290,
  [3333] = 3290,
  [3334] = 3290,
  [3335] = 3293,
  [3336] = 3290,
  [3337] = 3294,
  [3338] = 3338,
  [3339] = 3302,
  [3340] = 3293,
  [3341] = 3294,
  [3342] = 3322,
  [3343] = 3343,
  [3344] = 3287,
  [3345] = 3288,
  [3346] = 3297,
  [3347] = 3295,
  [3348] = 3292,
  [3349] = 3297,
  [3350] = 3297,
  [3351] = 3302,
  [3352] = 3302,
  [3353] = 3294,
  [3354] = 3302,
  [3355] = 3293,
  [3356] = 3297,
  [3357] = 3290,
  [3358] = 3290,
  [3359] = 3302,
  [3360] = 3294,
  [3361] = 3293,
  [3362] = 3293,
  [3363] = 3303,
  [3364] = 3294,
  [3365] = 3297,
  [3366] = 3290,
  [3367] = 3302,
  [3368] = 3294,
  [3369] = 3293,
  [3370] = 3290,
  [3371] = 3371,
  [3372] = 3302,
  [3373] = 3290,
  [3374] = 3302,
  [3375] = 3343,
  [3376] = 3293,
  [3377] = 3294,
  [3378] = 3289,
  [3379] = 3338,
  [3380] = 3287,
  [3381] = 3293,
  [3382] = 3302,
  [3383] = 3293,
  [3384] = 3294,
  [3385] = 3302,
  [3386] = 3302,
  [3387] = 3297,
  [3388] = 3297,
  [3389] = 3324,
  [3390] = 3297,
  [3391] = 3294,
  [3392] = 3293,
  [3393] = 3290,
  [3394] = 3290,
  [3395] = 3294,
  [3396] = 3293,
  [3397] = 3294,
  [3398] = 3293,
  [3399] = 3302,
  [3400] = 3290,
  [3401] = 3297,
  [3402] = 3302,
  [3403] = 3343,
  [3404] = 3290,
  [3405] = 3290,
  [3406] = 3290,
  [3407] = 3302,
  [3408] = 3302,
  [3409] = 3297,
  [3410] = 3294,
  [3411] = 3295,
  [3412] = 3322,
  [3413] = 3311,
  [3414] = 3293,
  [3415] = 3299,
  [3416] = 3290,
  [3417] = 3302,
  [3418] = 3418,
  [3419] = 3294,
  [3420] = 3293,
  [3421] = 3293,
  [3422] = 3294,
  [3423] = 3297,
  [3424] = 3288,
  [3425] = 3425,
  [3426] = 3297,
  [3427] = 3290,
  [3428] = 3294,
  [3429] = 3300,
  [3430] = 3290,
  [3431] = 3290,
  [3432] = 3297,
  [3433] = 3338,
  [3434] = 3302,
  [3435] = 3297,
  [3436] = 3297,
  [3437] = 3294,
  [3438] = 3297,
  [3439] = 3293,
  [3440] = 3293,
  [3441] = 3315,
  [3442] = 3290,
  [3443] = 3290,
  [3444] = 3302,
  [3445] = 3294,
  [3446] = 3302,
  [3447] = 3297,
  [3448] = 3302,
  [3449] = 3449,
  [3450] = 3450,
  [3451] = 3315,
  [3452] = 3297,
  [3453] = 3289,
  [3454] = 3293,
  [3455] = 3302,
  [3456] = 3290,
  [3457] = 3294,
  [3458] = 3297,
  [3459] = 3313,
  [3460] = 3313,
  [3461] = 3292,
  [3462] = 3462,
  [3463] = 3324,
  [3464] = 3297,
  [3465] = 3302,
  [3466] = 3294,
  [3467] = 3418,
  [3468] = 3293,
  [3469] = 3290,
  [3470] = 3328,
  [3471] = 3326,
  [3472] = 3299,
  [3473] = 3303,
  [3474] = 3297,
  [3475] = 3311,
  [3476] = 3302,
  [3477] = 3290,
  [3478] = 3297,
  [3479] = 3294,
  [3480] = 3293,
  [3481] = 3290,
  [3482] = 3294,
  [3483] = 3462,
  [3484] = 3290,
  [3485] = 3302,
  [3486] = 3293,
  [3487] = 3294,
  [3488] = 3297,
  [3489] = 3294,
  [3490] = 3328,
  [3491] = 3326,
  [3492] = 3425,
  [3493] = 3462,
  [3494] = 3297,
  [3495] = 3293,
  [3496] = 3293,
  [3497] = 3293,
  [3498] = 3294,
  [3499] = 3290,
  [3500] = 3294,
};

static inline bool sym_word_character_set_1(int32_t c) {
  return (c < '&'
    ? (c < ' '
      ? (c < '\t'
        ? c == 0
        : (c <= '\n' || c == '\r'))
      : (c <= ' ' || (c < '$'
        ? c == '"'
        : c <= '$')))
    : (c <= ')' || (c < '['
      ? (c < '>'
        ? (c >= ';' && c <= '<')
        : c <= '>')
      : (c <= ']' || (c < '{'
        ? c == '`'
        : c <= '}')))));
}

static inline bool sym_word_character_set_2(int32_t c) {
  return (c < '$'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '"')))
    : (c <= '$' || (c < '>'
      ? (c < ';'
        ? (c >= '&' && c <= ')')
        : c <= '<')
      : (c <= '>' || (c < '`'
        ? (c >= '[' && c <= ']')
        : c <= '}')))));
}

static inline bool sym_word_character_set_3(int32_t c) {
  return (c < '$'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '"')))
    : (c <= '$' || (c < '['
      ? (c < ';'
        ? (c >= '&' && c <= ')')
        : c <= '>')
      : (c <= ']' || (c < '{'
        ? c == '`'
        : c <= '}')))));
}

static inline bool sym_word_character_set_4(int32_t c) {
  return (c < '$'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '"')))
    : (c <= '$' || (c < '['
      ? (c < ';'
        ? (c >= '&' && c <= ')')
        : c <= '>')
      : (c <= ']' || (c >= '`' && c <= '}')))));
}

static inline bool sym_word_character_set_5(int32_t c) {
  return (c < '&'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\t')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '$')))
    : (c <= ')' || (c < '['
      ? (c < '>'
        ? (c >= ';' && c <= '<')
        : c <= '>')
      : (c <= ']' || (c >= '`' && c <= '}')))));
}

static inline bool sym_word_character_set_6(int32_t c) {
  return (c < ';'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\t')
      : (c <= '\r' || (c < '&'
        ? (c >= ' ' && c <= '$')
        : c <= ')')))
    : (c <= '<' || (c < '`'
      ? (c < '['
        ? c == '>'
        : c <= ']')
      : (c <= '`' || (c >= '{' && c <= '}')))));
}

static inline bool sym_word_character_set_7(int32_t c) {
  return (c < '&'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\t')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '$')))
    : (c <= ')' || (c < '`'
      ? (c < '['
        ? (c >= ';' && c <= '>')
        : c <= ']')
      : (c <= '`' || (c >= '{' && c <= '}')))));
}

static inline bool sym_word_character_set_8(int32_t c) {
  return (c < '&'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\t')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '$')))
    : (c <= ')' || (c < '['
      ? (c < '>'
        ? (c >= ';' && c <= '<')
        : c <= '>')
      : (c <= ']' || (c < '{'
        ? c == '`'
        : c <= '}')))));
}

static inline bool sym_word_character_set_9(int32_t c) {
  return (c < ';'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '&'
        ? (c >= ' ' && c <= '$')
        : c <= ')')))
    : (c <= '<' || (c < '`'
      ? (c < '['
        ? c == '>'
        : c <= ']')
      : (c <= '`' || (c >= '{' && c <= '}')))));
}

static inline bool sym_word_character_set_10(int32_t c) {
  return (c < '"'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || c == ' '))
    : (c <= ')' || (c < '`'
      ? (c < '['
        ? (c >= ';' && c <= '>')
        : c <= ']')
      : (c <= '`' || (c >= '{' && c <= '}')))));
}

static inline bool sym_word_character_set_11(int32_t c) {
  return (c < '&'
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '"'
        ? c == ' '
        : c <= '$')))
    : (c <= ')' || (c < '['
      ? (c < '>'
        ? (c >= ';' && c <= '<')
        : c <= '>')
      : (c <= ']' || (c < '{'
        ? c == '`'
        : c <= '}')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(204);
      if (lookahead == '!') ADVANCE(263);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '+') ADVANCE(302);
      if (lookahead == '-') ADVANCE(305);
      if (lookahead == '/') ADVANCE(341);
      if (lookahead == '0') ADVANCE(366);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '=') ADVANCE(276);
      if (lookahead == '>') ADVANCE(287);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(131);
      if (lookahead == ']') ADVANCE(268);
      if (lookahead == '_') ADVANCE(369);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'd') ADVANCE(418);
      if (lookahead == 'e') ADVANCE(414);
      if (lookahead == 'f') ADVANCE(412);
      if (lookahead == 'i') ADVANCE(416);
      if (lookahead == 't') ADVANCE(411);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(76)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(79)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(81)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(80)
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(82)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(83)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(8)
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(205);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(137);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'e') ADVANCE(354);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(60)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(61)
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(62)
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(63)
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(64)
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(65)
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(66)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(67)
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(68)
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(69)
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(70)
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(95)
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(71)
      END_STATE();
    case 22:
      if (lookahead == '\n') SKIP(72)
      END_STATE();
    case 23:
      if (lookahead == '\n') SKIP(73)
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(25)
      END_STATE();
    case 25:
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(285);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') SKIP(165)
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == 'e') ADVANCE(359);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 26:
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(285);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') SKIP(166)
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 27:
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '&') ADVANCE(424);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') SKIP(175)
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == 'i') ADVANCE(358);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 28:
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(285);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') SKIP(170)
      if (lookahead == 'e') ADVANCE(129);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      END_STATE();
    case 29:
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '&') ADVANCE(424);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '\\') SKIP(182)
      if (lookahead == 'e') ADVANCE(129);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(29)
      END_STATE();
    case 30:
      if (lookahead == '\n') SKIP(96)
      END_STATE();
    case 31:
      if (lookahead == '\n') SKIP(26)
      END_STATE();
    case 32:
      if (lookahead == '\n') SKIP(33)
      END_STATE();
    case 33:
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(424);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(255);
      if (lookahead == '-') ADVANCE(420);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(154);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 34:
      if (lookahead == '\n') SKIP(35)
      END_STATE();
    case 35:
      if (lookahead == '\n') ADVANCE(208);
      if (lookahead == '!') ADVANCE(264);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '&') ADVANCE(425);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') SKIP(167)
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(35)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 36:
      if (lookahead == '\n') ADVANCE(208);
      if (lookahead == '!') ADVANCE(113);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '&') ADVANCE(425);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') SKIP(171)
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(36)
      END_STATE();
    case 37:
      if (lookahead == '\n') SKIP(78)
      END_STATE();
    case 38:
      if (lookahead == '\n') SKIP(89)
      END_STATE();
    case 39:
      if (lookahead == '\n') SKIP(94)
      END_STATE();
    case 40:
      if (lookahead == '\n') SKIP(93)
      END_STATE();
    case 41:
      if (lookahead == '\n') SKIP(84)
      END_STATE();
    case 42:
      if (lookahead == '\n') SKIP(88)
      END_STATE();
    case 43:
      if (lookahead == '\n') SKIP(28)
      END_STATE();
    case 44:
      if (lookahead == '\n') SKIP(77)
      END_STATE();
    case 45:
      if (lookahead == '\n') SKIP(36)
      END_STATE();
    case 46:
      if (lookahead == '\n') SKIP(74)
      END_STATE();
    case 47:
      if (lookahead == '\n') SKIP(75)
      END_STATE();
    case 48:
      if (lookahead == '\n') SKIP(90)
      END_STATE();
    case 49:
      if (lookahead == '\n') SKIP(99)
      END_STATE();
    case 50:
      if (lookahead == '\n') SKIP(91)
      END_STATE();
    case 51:
      if (lookahead == '\n') SKIP(92)
      END_STATE();
    case 52:
      if (lookahead == '\n') SKIP(97)
      END_STATE();
    case 53:
      if (lookahead == '\n') SKIP(98)
      END_STATE();
    case 54:
      if (lookahead == '\n') SKIP(27)
      END_STATE();
    case 55:
      if (lookahead == '\n') SKIP(85)
      END_STATE();
    case 56:
      if (lookahead == '\n') SKIP(101)
      END_STATE();
    case 57:
      if (lookahead == '\n') SKIP(102)
      END_STATE();
    case 58:
      if (lookahead == '\n') SKIP(29)
      END_STATE();
    case 59:
      if (lookahead == '\n') SKIP(103)
      END_STATE();
    case 60:
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(138);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'e') ADVANCE(354);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(60)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 61:
      if (lookahead == '\n') ADVANCE(210);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(139);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(61)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 62:
      if (lookahead == '\n') ADVANCE(211);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(140);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(62)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 63:
      if (lookahead == '\n') ADVANCE(212);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(255);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(141);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'e') ADVANCE(419);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(63)
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 64:
      if (lookahead == '\n') ADVANCE(213);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(142);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(64)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(421);
      END_STATE();
    case 65:
      if (lookahead == '\n') ADVANCE(214);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(143);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'e') ADVANCE(354);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(65)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 66:
      if (lookahead == '\n') ADVANCE(215);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(144);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(66)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(421);
      END_STATE();
    case 67:
      if (lookahead == '\n') ADVANCE(216);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(255);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(145);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(67)
      if (lookahead != 0 &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 68:
      if (lookahead == '\n') ADVANCE(217);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(146);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(68)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 69:
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(255);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(69)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 70:
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(70)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(421);
      END_STATE();
    case 71:
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(150);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'e') ADVANCE(419);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(71)
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 72:
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(151);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(72)
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(421);
      END_STATE();
    case 73:
      if (lookahead == '\n') ADVANCE(222);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(152);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(73)
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(421);
      END_STATE();
    case 74:
      if (lookahead == '\n') ADVANCE(223);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(424);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(160);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(74)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 75:
      if (lookahead == '\n') ADVANCE(224);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(424);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(161);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(75)
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 76:
      if (lookahead == '!') ADVANCE(263);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '+') ADVANCE(302);
      if (lookahead == '-') ADVANCE(305);
      if (lookahead == '/') ADVANCE(341);
      if (lookahead == '0') ADVANCE(366);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == ';') ADVANCE(231);
      if (lookahead == '<') ADVANCE(284);
      if (lookahead == '=') ADVANCE(276);
      if (lookahead == '>') ADVANCE(287);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(131);
      if (lookahead == ']') ADVANCE(268);
      if (lookahead == '_') ADVANCE(369);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'd') ADVANCE(418);
      if (lookahead == 'e') ADVANCE(414);
      if (lookahead == 'f') ADVANCE(412);
      if (lookahead == 'i') ADVANCE(416);
      if (lookahead == 't') ADVANCE(411);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(76)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 77:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(159);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(77)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 78:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(78)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 79:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(132);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(79)
      if (lookahead != 0 &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 80:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(134);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'e') ADVANCE(419);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(80)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 81:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(133);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'e') ADVANCE(415);
      if (lookahead == 'f') ADVANCE(412);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(81)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 82:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(135);
      if (lookahead == ']') ADVANCE(323);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(82)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 83:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(136);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'f') ADVANCE(412);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(83)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 84:
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(255);
      if (lookahead == ')') ADVANCE(112);
      if (lookahead == '-') ADVANCE(420);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(158);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(84)
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 85:
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') SKIP(176)
      if (lookahead == ']') ADVANCE(268);
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '|') ADVANCE(247);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(85)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 86:
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') ADVANCE(177);
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(330);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(333);
      END_STATE();
    case 87:
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') ADVANCE(179);
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(331);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '`') ADVANCE(333);
      END_STATE();
    case 88:
      if (lookahead == '!') ADVANCE(264);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') SKIP(169)
      if (lookahead == ']') ADVANCE(268);
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(88)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 89:
      if (lookahead == '!') ADVANCE(264);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == ')') ADVANCE(112);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == ':') ADVANCE(314);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') SKIP(168)
      if (lookahead == ']') ADVANCE(116);
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(89)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 90:
      if (lookahead == '!') ADVANCE(113);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '(') ADVANCE(109);
      if (lookahead == ')') ADVANCE(112);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == ':') ADVANCE(314);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '[' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') SKIP(172)
      if (lookahead == ']') ADVANCE(324);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(90)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 91:
      if (lookahead == '!') ADVANCE(113);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') SKIP(173)
      if (lookahead == '|') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(91)
      END_STATE();
    case 92:
      if (lookahead == '!') ADVANCE(113);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '[' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') SKIP(174)
      if (lookahead == ']') ADVANCE(268);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(92)
      END_STATE();
    case 93:
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '/') ADVANCE(341);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(157);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(93)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 94:
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(156);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(94)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 95:
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(149);
      if (lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(95)
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 96:
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(255);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(153);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(96)
      if (lookahead != 0 &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 97:
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(163);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(97)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 98:
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '[' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(164);
      if (lookahead == ']') ADVANCE(268);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(98)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 99:
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '>') ADVANCE(111);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(162);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'e') ADVANCE(419);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(99)
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 100:
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(327);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '\\') ADVANCE(180);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(332);
      if (lookahead != 0) ADVANCE(333);
      END_STATE();
    case 101:
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '+') ADVANCE(114);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == '<') ADVANCE(285);
      if (lookahead == '=') ADVANCE(275);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') SKIP(178)
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(101)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 102:
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '+') ADVANCE(114);
      if (lookahead == ';') ADVANCE(230);
      if (lookahead == '<') ADVANCE(281);
      if (lookahead == '=') ADVANCE(275);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[') ADVANCE(266);
      if (lookahead == '\\') SKIP(181)
      if (lookahead == 'd') ADVANCE(128);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(102)
      END_STATE();
    case 103:
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{') ADVANCE(323);
      if (lookahead == '\\') SKIP(183)
      if (lookahead == '}') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(103)
      END_STATE();
    case 104:
      if (lookahead == '&') ADVANCE(260);
      END_STATE();
    case 105:
      if (lookahead == '&') ADVANCE(253);
      if (lookahead == ';') ADVANCE(252);
      END_STATE();
    case 106:
      if (lookahead == '\'') ADVANCE(335);
      if (lookahead != 0) ADVANCE(106);
      END_STATE();
    case 107:
      if (lookahead == '\'') ADVANCE(336);
      if (lookahead == '\\') ADVANCE(108);
      if (lookahead != 0) ADVANCE(107);
      END_STATE();
    case 108:
      if (lookahead == '\'') ADVANCE(337);
      if (lookahead == '\\') ADVANCE(108);
      if (lookahead != 0) ADVANCE(107);
      END_STATE();
    case 109:
      if (lookahead == '(') ADVANCE(228);
      END_STATE();
    case 110:
      if (lookahead == '(') ADVANCE(347);
      END_STATE();
    case 111:
      if (lookahead == '(') ADVANCE(348);
      END_STATE();
    case 112:
      if (lookahead == ')') ADVANCE(229);
      END_STATE();
    case 113:
      if (lookahead == '=') ADVANCE(300);
      END_STATE();
    case 114:
      if (lookahead == '=') ADVANCE(279);
      END_STATE();
    case 115:
      if (lookahead == '>') ADVANCE(292);
      END_STATE();
    case 116:
      if (lookahead == ']') ADVANCE(270);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(118);
      END_STATE();
    case 118:
      if (lookahead == 'c') ADVANCE(243);
      END_STATE();
    case 119:
      if (lookahead == 'e') ADVANCE(241);
      END_STATE();
    case 120:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 121:
      if (lookahead == 'f') ADVANCE(239);
      END_STATE();
    case 122:
      if (lookahead == 'h') ADVANCE(120);
      END_STATE();
    case 123:
      if (lookahead == 'i') ADVANCE(237);
      END_STATE();
    case 124:
      if (lookahead == 'i') ADVANCE(121);
      if (lookahead == 's') ADVANCE(119);
      END_STATE();
    case 125:
      if (lookahead == 'l') ADVANCE(124);
      if (lookahead == 's') ADVANCE(117);
      END_STATE();
    case 126:
      if (lookahead == 'n') ADVANCE(225);
      END_STATE();
    case 127:
      if (lookahead == 'n') ADVANCE(235);
      END_STATE();
    case 128:
      if (lookahead == 'o') ADVANCE(233);
      END_STATE();
    case 129:
      if (lookahead == 's') ADVANCE(117);
      END_STATE();
    case 130:
      if (lookahead == '|') ADVANCE(261);
      END_STATE();
    case 131:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(76)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(389);
      if (lookahead == '\r') SKIP(1)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 132:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(79)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(393);
      if (lookahead == '\r') SKIP(2)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 133:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(81)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(394);
      if (lookahead == '\r') SKIP(3)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 134:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(80)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(395);
      if (lookahead == '\r') SKIP(4)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 135:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(82)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(396);
      if (lookahead == '\r') SKIP(5)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 136:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(83)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(397);
      if (lookahead == '\r') SKIP(6)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 137:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(8)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(371);
      if (lookahead == '\r') SKIP(7)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 138:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(60)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(373);
      if (lookahead == '\r') SKIP(9)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 139:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(61)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(374);
      if (lookahead == '\r') SKIP(10)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 140:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(62)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(375);
      if (lookahead == '\r') SKIP(11)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 141:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(63)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(376);
      if (lookahead == '\r') SKIP(12)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 142:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(64)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(377);
      if (lookahead == '\r') SKIP(13)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 143:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(65)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(378);
      if (lookahead == '\r') SKIP(14)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 144:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(66)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(379);
      if (lookahead == '\r') SKIP(15)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 145:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(67)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(380);
      if (lookahead == '\r') SKIP(16)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 146:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(68)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(381);
      if (lookahead == '\r') SKIP(17)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 147:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(69)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(382);
      if (lookahead == '\r') SKIP(18)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 148:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(70)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(383);
      if (lookahead == '\r') SKIP(19)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 149:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(95)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(400);
      if (lookahead == '\r') SKIP(20)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 150:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(71)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(384);
      if (lookahead == '\r') SKIP(21)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 151:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(72)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(385);
      if (lookahead == '\r') SKIP(22)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 152:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(73)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(386);
      if (lookahead == '\r') SKIP(23)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 153:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(96)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(401);
      if (lookahead == '\r') SKIP(30)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 154:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(33)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(372);
      if (lookahead == '\r') SKIP(32)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 155:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(78)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(391);
      if (lookahead == '\r') SKIP(37)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 156:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(94)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(399);
      if (lookahead == '\r') SKIP(39)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 157:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(93)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(398);
      if (lookahead == '\r') SKIP(40)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 158:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(84)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(392);
      if (lookahead == '\r') SKIP(41)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 159:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(77)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(390);
      if (lookahead == '\r') SKIP(44)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 160:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(74)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(387);
      if (lookahead == '\r') SKIP(46)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 161:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(75)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(388);
      if (lookahead == '\r') SKIP(47)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 162:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(99)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(402);
      if (lookahead == '\r') SKIP(49)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 163:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(97)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(403);
      if (lookahead == '\r') SKIP(52)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 164:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(98)
      if (lookahead == 11 ||
          lookahead == '\f') ADVANCE(404);
      if (lookahead == '\r') SKIP(53)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 165:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(25)
      if (lookahead == '\r') SKIP(24)
      END_STATE();
    case 166:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(26)
      if (lookahead == '\r') SKIP(31)
      END_STATE();
    case 167:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(35)
      if (lookahead == '\r') SKIP(34)
      END_STATE();
    case 168:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(89)
      if (lookahead == '\r') SKIP(38)
      END_STATE();
    case 169:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(88)
      if (lookahead == '\r') SKIP(42)
      END_STATE();
    case 170:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(28)
      if (lookahead == '\r') SKIP(43)
      END_STATE();
    case 171:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(36)
      if (lookahead == '\r') SKIP(45)
      END_STATE();
    case 172:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(90)
      if (lookahead == '\r') SKIP(48)
      END_STATE();
    case 173:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(91)
      if (lookahead == '\r') SKIP(50)
      END_STATE();
    case 174:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(92)
      if (lookahead == '\r') SKIP(51)
      END_STATE();
    case 175:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(27)
      if (lookahead == '\r') SKIP(54)
      END_STATE();
    case 176:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(85)
      if (lookahead == '\r') SKIP(55)
      END_STATE();
    case 177:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(330);
      if (lookahead == '\r') ADVANCE(326);
      if (lookahead != 0) ADVANCE(333);
      END_STATE();
    case 178:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(101)
      if (lookahead == '\r') SKIP(56)
      END_STATE();
    case 179:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(331);
      if (lookahead == '\r') ADVANCE(328);
      if (lookahead != 0) ADVANCE(333);
      END_STATE();
    case 180:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(332);
      if (lookahead == '\r') ADVANCE(329);
      if (lookahead != 0) ADVANCE(333);
      END_STATE();
    case 181:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(102)
      if (lookahead == '\r') SKIP(57)
      END_STATE();
    case 182:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(29)
      if (lookahead == '\r') SKIP(58)
      END_STATE();
    case 183:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(103)
      if (lookahead == '\r') SKIP(59)
      END_STATE();
    case 184:
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(421);
      END_STATE();
    case 185:
      if (lookahead != 0 &&
          lookahead != '\r') ADVANCE(333);
      if (lookahead == '\r') ADVANCE(334);
      END_STATE();
    case 186:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(285);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') SKIP(200)
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(186)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 187:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(285);
      if (lookahead == '>') ADVANCE(289);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') SKIP(201)
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(187)
      END_STATE();
    case 188:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') ADVANCE(206);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '&') ADVANCE(424);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') SKIP(203)
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'i') ADVANCE(126);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(188)
      END_STATE();
    case 189:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') SKIP(186)
      END_STATE();
    case 190:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') SKIP(187)
      END_STATE();
    case 191:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') SKIP(199)
      END_STATE();
    case 192:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') SKIP(188)
      END_STATE();
    case 193:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') ADVANCE(213);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(142);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(193)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(421);
      END_STATE();
    case 194:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') ADVANCE(215);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(144);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(194)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(421);
      END_STATE();
    case 195:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(255);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(147);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(195)
      if (lookahead != 0) ADVANCE(421);
      END_STATE();
    case 196:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(196)
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(421);
      END_STATE();
    case 197:
      if (eof) ADVANCE(204);
      if (lookahead == '\n') ADVANCE(222);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(232);
      if (lookahead == '<') ADVANCE(283);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') ADVANCE(152);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '|') ADVANCE(248);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(197)
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(421);
      END_STATE();
    case 198:
      if (eof) ADVANCE(204);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(321);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '(') ADVANCE(256);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(282);
      if (lookahead == '>') ADVANCE(288);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(132);
      if (lookahead == ']' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '{') ADVANCE(257);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(198)
      if (lookahead != 0 &&
          lookahead != '|') ADVANCE(421);
      END_STATE();
    case 199:
      if (eof) ADVANCE(204);
      if (lookahead == '!') ADVANCE(113);
      if (lookahead == '#') ADVANCE(351);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '&') ADVANCE(104);
      if (lookahead == ')') ADVANCE(112);
      if (lookahead == '+') ADVANCE(303);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == ':') ADVANCE(314);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(286);
      if (lookahead == '=') ADVANCE(277);
      if (lookahead == '>') ADVANCE(290);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(323);
      if (lookahead == '\\') SKIP(202)
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == 'd') ADVANCE(128);
      if (lookahead == 'e') ADVANCE(125);
      if (lookahead == 'f') ADVANCE(123);
      if (lookahead == 'i') ADVANCE(126);
      if (lookahead == 't') ADVANCE(122);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(199)
      END_STATE();
    case 200:
      if (eof) ADVANCE(204);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(186)
      if (lookahead == '\r') SKIP(189)
      END_STATE();
    case 201:
      if (eof) ADVANCE(204);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(187)
      if (lookahead == '\r') SKIP(190)
      END_STATE();
    case 202:
      if (eof) ADVANCE(204);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(199)
      if (lookahead == '\r') SKIP(191)
      END_STATE();
    case 203:
      if (eof) ADVANCE(204);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(188)
      if (lookahead == '\r') SKIP(192)
      END_STATE();
    case 204:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(205);
      if (lookahead == '\\') ADVANCE(137);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(206);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '-') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(154);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(208);
      if (lookahead == '-') ADVANCE(306);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '\\') ADVANCE(138);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(210);
      if (lookahead == '\\') ADVANCE(139);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(211);
      if (lookahead == '\\') ADVANCE(140);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(141);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(213);
      if (lookahead == '\\') ADVANCE(142);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(214);
      if (lookahead == '\\') ADVANCE(143);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(215);
      if (lookahead == '\\') ADVANCE(144);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(216);
      if (lookahead == '\\') ADVANCE(145);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(217);
      if (lookahead == '\\') ADVANCE(146);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '\\') ADVANCE(147);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '\\') ADVANCE(148);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '\\') ADVANCE(150);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '\\') ADVANCE(151);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(222);
      if (lookahead == '\\') ADVANCE(152);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(223);
      if (lookahead == '\\') ADVANCE(160);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(224);
      if (lookahead == '\\') ADVANCE(161);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_in);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_LPAREN_LPAREN);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_RPAREN_RPAREN);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_SEMI);
      if (lookahead == '&') ADVANCE(253);
      if (lookahead == ';') ADVANCE(252);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_SEMI);
      if (lookahead == ';') ADVANCE(251);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_then);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_fi);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_fi);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_elif);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_esac);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_esac);
      if (lookahead == '\\') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(421);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_esac);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_esac);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '&') ADVANCE(259);
      if (lookahead == '|') ADVANCE(261);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(261);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_SEMI_SEMI);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_SEMI_SEMI);
      if (lookahead == '&') ADVANCE(254);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_SEMI_AMP);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_SEMI_SEMI_AMP);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '(') ADVANCE(228);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_PIPE_AMP);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(301);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_3(lookahead)) ADVANCE(421);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(300);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(269);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(274);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == '~') ADVANCE(272);
      if (!sym_word_character_set_3(lookahead)) ADVANCE(421);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(273);
      if (lookahead == '~') ADVANCE(271);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(294);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(294);
      if (lookahead == '(') ADVANCE(347);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(294);
      if (lookahead == '(') ADVANCE(347);
      if (lookahead == '<') ADVANCE(297);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(294);
      if (lookahead == '(') ADVANCE(347);
      if (lookahead == '<') ADVANCE(297);
      if (lookahead == '=') ADVANCE(310);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&') ADVANCE(294);
      if (lookahead == '<') ADVANCE(297);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(310);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&') ADVANCE(295);
      if (lookahead == '(') ADVANCE(348);
      if (lookahead == '=') ADVANCE(311);
      if (lookahead == '>') ADVANCE(291);
      if (lookahead == '|') ADVANCE(296);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&') ADVANCE(295);
      if (lookahead == '(') ADVANCE(348);
      if (lookahead == '>') ADVANCE(291);
      if (lookahead == '|') ADVANCE(296);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&') ADVANCE(295);
      if (lookahead == '>') ADVANCE(291);
      if (lookahead == '|') ADVANCE(296);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(311);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_AMP_GT);
      if (lookahead == '>') ADVANCE(293);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_AMP_GT_GT);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_LT_AMP);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_GT_AMP);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_GT_PIPE);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '-') ADVANCE(298);
      if (lookahead == '<') ADVANCE(299);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_LT_LT_DASH);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_LT_LT_LT);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(317);
      if (lookahead == '=') ADVANCE(280);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_3(lookahead)) ADVANCE(421);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(316);
      if (lookahead == '=') ADVANCE(279);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(319);
      if (lookahead == '=') ADVANCE(309);
      if (lookahead == '\\') ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      if (!sym_word_character_set_4(lookahead)) ADVANCE(421);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(318);
      if (lookahead == '=') ADVANCE(308);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '-') ADVANCE(343);
      if (lookahead == '?') ADVANCE(342);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(345);
      if (lookahead == '{') ADVANCE(340);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '(') ADVANCE(345);
      if (lookahead == '{') ADVANCE(340);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym__special_character);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym__special_character);
      if (lookahead == ']') ADVANCE(270);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n') ADVANCE(330);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(333);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n') ADVANCE(333);
      if (lookahead == '\\') ADVANCE(349);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(327);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n') ADVANCE(331);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(333);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n') ADVANCE(332);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(333);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') ADVANCE(177);
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(330);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(333);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '!') ADVANCE(262);
      if (lookahead == '#') ADVANCE(338);
      if (lookahead == '$') ADVANCE(320);
      if (lookahead == '*') ADVANCE(361);
      if (lookahead == '-') ADVANCE(304);
      if (lookahead == '0') ADVANCE(367);
      if (lookahead == '?') ADVANCE(312);
      if (lookahead == '@') ADVANCE(363);
      if (lookahead == '\\') ADVANCE(179);
      if (lookahead == '_') ADVANCE(370);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(331);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '`') ADVANCE(333);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '"') ADVANCE(325);
      if (lookahead == '#') ADVANCE(327);
      if (lookahead == '$') ADVANCE(322);
      if (lookahead == '\\') ADVANCE(180);
      if (lookahead == '`') ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(332);
      if (lookahead != 0) ADVANCE(333);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '`') ADVANCE(333);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(333);
      if (lookahead == '\\') ADVANCE(185);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_raw_string);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_ansi_c_string);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_ansi_c_string);
      if (lookahead == '\'') ADVANCE(336);
      if (lookahead == '\\') ADVANCE(108);
      if (lookahead != 0) ADVANCE(107);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '\\') ADVANCE(350);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(422);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_COLON_QMARK);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_COLON_DASH);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_LT_LPAREN);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_GT_LPAREN);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(333);
      if (lookahead == '\r') ADVANCE(327);
      if (lookahead != 0) ADVANCE(327);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(351);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(422);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(351);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'a') ADVANCE(353);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(421);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'c') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(421);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 's') ADVANCE(352);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(421);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == '\\') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(421);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == 'a') ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == 'c') ADVANCE(246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == 'n') ADVANCE(227);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (lookahead == 's') ADVANCE(356);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(aux_sym__simple_variable_name_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == '\\') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(421);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_0);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '\\') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(421);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym__);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(360);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(205);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(137);
      if (lookahead == 'e') ADVANCE(354);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_5(lookahead)) ADVANCE(421);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '-') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(154);
      if (!sym_word_character_set_6(lookahead)) ADVANCE(421);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(138);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == 'e') ADVANCE(354);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < ';' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(210);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_5(lookahead)) ADVANCE(421);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(211);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(140);
      if (lookahead == '_') ADVANCE(368);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < ';' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(212);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '\\') ADVANCE(141);
      if (lookahead == 'e') ADVANCE(419);
      if (!sym_word_character_set_7(lookahead)) ADVANCE(421);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(213);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (!sym_word_character_set_5(lookahead)) ADVANCE(421);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(214);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(143);
      if (lookahead == '_') ADVANCE(368);
      if (lookahead == 'e') ADVANCE(354);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '>' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(215);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(144);
      if (lookahead == '_') ADVANCE(368);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < ';' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(216);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '\\') ADVANCE(145);
      if (!sym_word_character_set_7(lookahead)) ADVANCE(421);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(217);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(146);
      if (lookahead == '_') ADVANCE(368);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '>' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '\\') ADVANCE(147);
      if (!sym_word_character_set_7(lookahead)) ADVANCE(421);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead == '_') ADVANCE(368);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '>' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(150);
      if (lookahead == 'e') ADVANCE(419);
      if (!sym_word_character_set_8(lookahead)) ADVANCE(421);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(151);
      if (!sym_word_character_set_8(lookahead)) ADVANCE(421);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(222);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(152);
      if (!sym_word_character_set_8(lookahead)) ADVANCE(421);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(223);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(160);
      if (lookahead == '_') ADVANCE(368);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '>' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\n') ADVANCE(224);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(161);
      if (!sym_word_character_set_8(lookahead)) ADVANCE(421);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(263);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '+') ADVANCE(302);
      if (lookahead == '-') ADVANCE(305);
      if (lookahead == '/') ADVANCE(341);
      if (lookahead == '0') ADVANCE(366);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == '=') ADVANCE(276);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(131);
      if (lookahead == '_') ADVANCE(369);
      if (lookahead == 'd') ADVANCE(418);
      if (lookahead == 'e') ADVANCE(414);
      if (lookahead == 'f') ADVANCE(412);
      if (lookahead == 'i') ADVANCE(416);
      if (lookahead == 't') ADVANCE(411);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || ')' < lookahead) &&
          (lookahead < ';' || '>' < lookahead) &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(159);
      if (lookahead == '_') ADVANCE(368);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || ')' < lookahead) &&
          (lookahead < ';' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '*') ADVANCE(362);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '0') ADVANCE(365);
      if (lookahead == '?') ADVANCE(313);
      if (lookahead == '@') ADVANCE(364);
      if (lookahead == '\\') ADVANCE(155);
      if (lookahead == '_') ADVANCE(368);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(355);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '$' < lookahead) &&
          (lookahead < '&' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '>' || ']' < lookahead) &&
          (lookahead < '`' || '}' < lookahead)) ADVANCE(421);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '-') ADVANCE(420);
      if (lookahead == '\\') ADVANCE(158);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(421);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(132);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(421);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(133);
      if (lookahead == 'e') ADVANCE(415);
      if (lookahead == 'f') ADVANCE(412);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(421);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(134);
      if (lookahead == 'e') ADVANCE(419);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(421);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(135);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(421);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '!') ADVANCE(265);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(136);
      if (lookahead == 'f') ADVANCE(412);
      if (!sym_word_character_set_9(lookahead)) ADVANCE(421);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '/') ADVANCE(341);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '\\') ADVANCE(157);
      if (!sym_word_character_set_10(lookahead)) ADVANCE(421);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '%') ADVANCE(344);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == ':') ADVANCE(315);
      if (lookahead == '=') ADVANCE(278);
      if (lookahead == '\\') ADVANCE(156);
      if (!sym_word_character_set_10(lookahead)) ADVANCE(421);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(149);
      if (!sym_word_character_set_11(lookahead)) ADVANCE(421);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(153);
      if (!sym_word_character_set_11(lookahead)) ADVANCE(421);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(162);
      if (lookahead == 'e') ADVANCE(419);
      if (!sym_word_character_set_11(lookahead)) ADVANCE(421);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(163);
      if (!sym_word_character_set_11(lookahead)) ADVANCE(421);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '#') ADVANCE(422);
      if (lookahead == '\\') ADVANCE(164);
      if (!sym_word_character_set_11(lookahead)) ADVANCE(421);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '=') ADVANCE(274);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == '~') ADVANCE(272);
      if (!sym_word_character_set_3(lookahead)) ADVANCE(421);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'a') ADVANCE(407);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'c') ADVANCE(245);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'e') ADVANCE(242);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'e') ADVANCE(417);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'f') ADVANCE(240);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'h') ADVANCE(409);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'i') ADVANCE(238);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'i') ADVANCE(410);
      if (lookahead == 's') ADVANCE(408);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'l') ADVANCE(413);
      if (lookahead == 's') ADVANCE(406);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'l') ADVANCE(413);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'n') ADVANCE(226);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'n') ADVANCE(236);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 'o') ADVANCE(234);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == 's') ADVANCE(406);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      if (!sym_word_character_set_2(lookahead)) ADVANCE(421);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(184);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(421);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\') ADVANCE(350);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(422);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym_test_operator);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(260);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(260);
      if (lookahead == '>') ADVANCE(292);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\\') SKIP(1)
      if (lookahead == 'c') ADVANCE(2);
      if (lookahead == 'd') ADVANCE(3);
      if (lookahead == 'e') ADVANCE(4);
      if (lookahead == 'f') ADVANCE(5);
      if (lookahead == 'i') ADVANCE(6);
      if (lookahead == 'l') ADVANCE(7);
      if (lookahead == 'r') ADVANCE(8);
      if (lookahead == 's') ADVANCE(9);
      if (lookahead == 't') ADVANCE(10);
      if (lookahead == 'u') ADVANCE(11);
      if (lookahead == 'w') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(0)
      if (lookahead == '\r') SKIP(13)
      END_STATE();
    case 2:
      if (lookahead == 'a') ADVANCE(14);
      END_STATE();
    case 3:
      if (lookahead == 'e') ADVANCE(15);
      if (lookahead == 'o') ADVANCE(16);
      END_STATE();
    case 4:
      if (lookahead == 'x') ADVANCE(17);
      END_STATE();
    case 5:
      if (lookahead == 'o') ADVANCE(18);
      if (lookahead == 'u') ADVANCE(19);
      END_STATE();
    case 6:
      if (lookahead == 'f') ADVANCE(20);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(21);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(22);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(23);
      END_STATE();
    case 10:
      if (lookahead == 'y') ADVANCE(24);
      END_STATE();
    case 11:
      if (lookahead == 'n') ADVANCE(25);
      END_STATE();
    case 12:
      if (lookahead == 'h') ADVANCE(26);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 14:
      if (lookahead == 's') ADVANCE(27);
      END_STATE();
    case 15:
      if (lookahead == 'c') ADVANCE(28);
      END_STATE();
    case 16:
      if (lookahead == 'n') ADVANCE(29);
      END_STATE();
    case 17:
      if (lookahead == 'p') ADVANCE(30);
      END_STATE();
    case 18:
      if (lookahead == 'r') ADVANCE(31);
      END_STATE();
    case 19:
      if (lookahead == 'n') ADVANCE(32);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 21:
      if (lookahead == 'c') ADVANCE(33);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(34);
      END_STATE();
    case 23:
      if (lookahead == 'l') ADVANCE(35);
      END_STATE();
    case 24:
      if (lookahead == 'p') ADVANCE(36);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(37);
      if (lookahead == 't') ADVANCE(38);
      END_STATE();
    case 26:
      if (lookahead == 'i') ADVANCE(39);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 28:
      if (lookahead == 'l') ADVANCE(41);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 30:
      if (lookahead == 'o') ADVANCE(43);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 32:
      if (lookahead == 'c') ADVANCE(44);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 34:
      if (lookahead == 'd') ADVANCE(46);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 38:
      if (lookahead == 'i') ADVANCE(50);
      END_STATE();
    case 39:
      if (lookahead == 'l') ADVANCE(51);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(52);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_done);
      END_STATE();
    case 43:
      if (lookahead == 'r') ADVANCE(53);
      END_STATE();
    case 44:
      if (lookahead == 't') ADVANCE(54);
      END_STATE();
    case 45:
      if (lookahead == 'l') ADVANCE(55);
      END_STATE();
    case 46:
      if (lookahead == 'o') ADVANCE(56);
      END_STATE();
    case 47:
      if (lookahead == 'c') ADVANCE(57);
      END_STATE();
    case 48:
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 50:
      if (lookahead == 'l') ADVANCE(60);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 52:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 53:
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(64);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_local);
      END_STATE();
    case 56:
      if (lookahead == 'n') ADVANCE(65);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_unset);
      if (lookahead == 'e') ADVANCE(68);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_until);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(69);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 64:
      if (lookahead == 'o') ADVANCE(70);
      END_STATE();
    case 65:
      if (lookahead == 'l') ADVANCE(71);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_select);
      END_STATE();
    case 67:
      if (lookahead == 't') ADVANCE(72);
      END_STATE();
    case 68:
      if (lookahead == 'n') ADVANCE(73);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 70:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 71:
      if (lookahead == 'y') ADVANCE(75);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_typeset);
      END_STATE();
    case 73:
      if (lookahead == 'v') ADVANCE(76);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_unsetenv);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 198, .external_lex_state = 2},
  [2] = {.lex_state = 81, .external_lex_state = 2},
  [3] = {.lex_state = 81, .external_lex_state = 2},
  [4] = {.lex_state = 81, .external_lex_state = 2},
  [5] = {.lex_state = 81, .external_lex_state = 2},
  [6] = {.lex_state = 81, .external_lex_state = 2},
  [7] = {.lex_state = 81, .external_lex_state = 2},
  [8] = {.lex_state = 80, .external_lex_state = 2},
  [9] = {.lex_state = 80, .external_lex_state = 2},
  [10] = {.lex_state = 80, .external_lex_state = 2},
  [11] = {.lex_state = 80, .external_lex_state = 2},
  [12] = {.lex_state = 80, .external_lex_state = 2},
  [13] = {.lex_state = 198, .external_lex_state = 2},
  [14] = {.lex_state = 198, .external_lex_state = 2},
  [15] = {.lex_state = 198, .external_lex_state = 2},
  [16] = {.lex_state = 198, .external_lex_state = 2},
  [17] = {.lex_state = 198, .external_lex_state = 2},
  [18] = {.lex_state = 81, .external_lex_state = 2},
  [19] = {.lex_state = 81, .external_lex_state = 2},
  [20] = {.lex_state = 81, .external_lex_state = 2},
  [21] = {.lex_state = 198, .external_lex_state = 2},
  [22] = {.lex_state = 198, .external_lex_state = 2},
  [23] = {.lex_state = 198, .external_lex_state = 2},
  [24] = {.lex_state = 82, .external_lex_state = 3},
  [25] = {.lex_state = 198, .external_lex_state = 2},
  [26] = {.lex_state = 198, .external_lex_state = 2},
  [27] = {.lex_state = 198, .external_lex_state = 2},
  [28] = {.lex_state = 198, .external_lex_state = 2},
  [29] = {.lex_state = 198, .external_lex_state = 2},
  [30] = {.lex_state = 198, .external_lex_state = 2},
  [31] = {.lex_state = 198, .external_lex_state = 2},
  [32] = {.lex_state = 198, .external_lex_state = 2},
  [33] = {.lex_state = 198, .external_lex_state = 2},
  [34] = {.lex_state = 198, .external_lex_state = 2},
  [35] = {.lex_state = 198, .external_lex_state = 2},
  [36] = {.lex_state = 198, .external_lex_state = 2},
  [37] = {.lex_state = 198, .external_lex_state = 2},
  [38] = {.lex_state = 198, .external_lex_state = 2},
  [39] = {.lex_state = 198, .external_lex_state = 2},
  [40] = {.lex_state = 198, .external_lex_state = 2},
  [41] = {.lex_state = 198, .external_lex_state = 2},
  [42] = {.lex_state = 198, .external_lex_state = 2},
  [43] = {.lex_state = 198, .external_lex_state = 2},
  [44] = {.lex_state = 198, .external_lex_state = 2},
  [45] = {.lex_state = 198, .external_lex_state = 2},
  [46] = {.lex_state = 198, .external_lex_state = 2},
  [47] = {.lex_state = 198, .external_lex_state = 2},
  [48] = {.lex_state = 198, .external_lex_state = 2},
  [49] = {.lex_state = 198, .external_lex_state = 2},
  [50] = {.lex_state = 198, .external_lex_state = 2},
  [51] = {.lex_state = 83, .external_lex_state = 2},
  [52] = {.lex_state = 198, .external_lex_state = 2},
  [53] = {.lex_state = 198, .external_lex_state = 2},
  [54] = {.lex_state = 198, .external_lex_state = 2},
  [55] = {.lex_state = 198, .external_lex_state = 2},
  [56] = {.lex_state = 198, .external_lex_state = 2},
  [57] = {.lex_state = 198, .external_lex_state = 2},
  [58] = {.lex_state = 198, .external_lex_state = 2},
  [59] = {.lex_state = 82, .external_lex_state = 3},
  [60] = {.lex_state = 198, .external_lex_state = 2},
  [61] = {.lex_state = 198, .external_lex_state = 2},
  [62] = {.lex_state = 198, .external_lex_state = 2},
  [63] = {.lex_state = 198, .external_lex_state = 2},
  [64] = {.lex_state = 198, .external_lex_state = 2},
  [65] = {.lex_state = 198, .external_lex_state = 2},
  [66] = {.lex_state = 198, .external_lex_state = 2},
  [67] = {.lex_state = 82, .external_lex_state = 3},
  [68] = {.lex_state = 82, .external_lex_state = 3},
  [69] = {.lex_state = 83, .external_lex_state = 2},
  [70] = {.lex_state = 82, .external_lex_state = 3},
  [71] = {.lex_state = 198, .external_lex_state = 2},
  [72] = {.lex_state = 198, .external_lex_state = 2},
  [73] = {.lex_state = 198, .external_lex_state = 2},
  [74] = {.lex_state = 198, .external_lex_state = 2},
  [75] = {.lex_state = 198, .external_lex_state = 2},
  [76] = {.lex_state = 198, .external_lex_state = 2},
  [77] = {.lex_state = 198, .external_lex_state = 2},
  [78] = {.lex_state = 198, .external_lex_state = 2},
  [79] = {.lex_state = 198, .external_lex_state = 2},
  [80] = {.lex_state = 198, .external_lex_state = 2},
  [81] = {.lex_state = 198, .external_lex_state = 2},
  [82] = {.lex_state = 198, .external_lex_state = 2},
  [83] = {.lex_state = 198, .external_lex_state = 2},
  [84] = {.lex_state = 198, .external_lex_state = 2},
  [85] = {.lex_state = 198, .external_lex_state = 2},
  [86] = {.lex_state = 198, .external_lex_state = 2},
  [87] = {.lex_state = 198, .external_lex_state = 2},
  [88] = {.lex_state = 198, .external_lex_state = 2},
  [89] = {.lex_state = 198, .external_lex_state = 2},
  [90] = {.lex_state = 198, .external_lex_state = 2},
  [91] = {.lex_state = 198, .external_lex_state = 2},
  [92] = {.lex_state = 198, .external_lex_state = 2},
  [93] = {.lex_state = 198, .external_lex_state = 2},
  [94] = {.lex_state = 82, .external_lex_state = 3},
  [95] = {.lex_state = 82, .external_lex_state = 3},
  [96] = {.lex_state = 198, .external_lex_state = 2},
  [97] = {.lex_state = 198, .external_lex_state = 2},
  [98] = {.lex_state = 198, .external_lex_state = 2},
  [99] = {.lex_state = 198, .external_lex_state = 2},
  [100] = {.lex_state = 198, .external_lex_state = 2},
  [101] = {.lex_state = 198, .external_lex_state = 2},
  [102] = {.lex_state = 198, .external_lex_state = 2},
  [103] = {.lex_state = 198, .external_lex_state = 2},
  [104] = {.lex_state = 198, .external_lex_state = 2},
  [105] = {.lex_state = 198, .external_lex_state = 2},
  [106] = {.lex_state = 198, .external_lex_state = 2},
  [107] = {.lex_state = 83, .external_lex_state = 2},
  [108] = {.lex_state = 198, .external_lex_state = 2},
  [109] = {.lex_state = 198, .external_lex_state = 2},
  [110] = {.lex_state = 198, .external_lex_state = 2},
  [111] = {.lex_state = 198, .external_lex_state = 2},
  [112] = {.lex_state = 198, .external_lex_state = 2},
  [113] = {.lex_state = 198, .external_lex_state = 2},
  [114] = {.lex_state = 198, .external_lex_state = 2},
  [115] = {.lex_state = 198, .external_lex_state = 2},
  [116] = {.lex_state = 198, .external_lex_state = 2},
  [117] = {.lex_state = 198, .external_lex_state = 2},
  [118] = {.lex_state = 198, .external_lex_state = 2},
  [119] = {.lex_state = 198, .external_lex_state = 2},
  [120] = {.lex_state = 198, .external_lex_state = 2},
  [121] = {.lex_state = 198, .external_lex_state = 2},
  [122] = {.lex_state = 198, .external_lex_state = 2},
  [123] = {.lex_state = 198, .external_lex_state = 2},
  [124] = {.lex_state = 198, .external_lex_state = 2},
  [125] = {.lex_state = 198, .external_lex_state = 2},
  [126] = {.lex_state = 198, .external_lex_state = 2},
  [127] = {.lex_state = 198, .external_lex_state = 2},
  [128] = {.lex_state = 198, .external_lex_state = 2},
  [129] = {.lex_state = 198, .external_lex_state = 2},
  [130] = {.lex_state = 198, .external_lex_state = 2},
  [131] = {.lex_state = 198, .external_lex_state = 2},
  [132] = {.lex_state = 198, .external_lex_state = 2},
  [133] = {.lex_state = 198, .external_lex_state = 2},
  [134] = {.lex_state = 198, .external_lex_state = 2},
  [135] = {.lex_state = 198, .external_lex_state = 2},
  [136] = {.lex_state = 198, .external_lex_state = 2},
  [137] = {.lex_state = 198, .external_lex_state = 2},
  [138] = {.lex_state = 198, .external_lex_state = 2},
  [139] = {.lex_state = 198, .external_lex_state = 2},
  [140] = {.lex_state = 198, .external_lex_state = 2},
  [141] = {.lex_state = 198, .external_lex_state = 2},
  [142] = {.lex_state = 198, .external_lex_state = 2},
  [143] = {.lex_state = 198, .external_lex_state = 2},
  [144] = {.lex_state = 198, .external_lex_state = 2},
  [145] = {.lex_state = 198, .external_lex_state = 2},
  [146] = {.lex_state = 198, .external_lex_state = 2},
  [147] = {.lex_state = 198, .external_lex_state = 2},
  [148] = {.lex_state = 198, .external_lex_state = 2},
  [149] = {.lex_state = 198, .external_lex_state = 2},
  [150] = {.lex_state = 198, .external_lex_state = 2},
  [151] = {.lex_state = 198, .external_lex_state = 2},
  [152] = {.lex_state = 198, .external_lex_state = 2},
  [153] = {.lex_state = 198, .external_lex_state = 2},
  [154] = {.lex_state = 198, .external_lex_state = 2},
  [155] = {.lex_state = 198, .external_lex_state = 2},
  [156] = {.lex_state = 198, .external_lex_state = 2},
  [157] = {.lex_state = 198, .external_lex_state = 2},
  [158] = {.lex_state = 80, .external_lex_state = 4},
  [159] = {.lex_state = 80, .external_lex_state = 4},
  [160] = {.lex_state = 8, .external_lex_state = 5},
  [161] = {.lex_state = 198, .external_lex_state = 4},
  [162] = {.lex_state = 8, .external_lex_state = 5},
  [163] = {.lex_state = 8, .external_lex_state = 5},
  [164] = {.lex_state = 81, .external_lex_state = 4},
  [165] = {.lex_state = 198, .external_lex_state = 4},
  [166] = {.lex_state = 60, .external_lex_state = 6},
  [167] = {.lex_state = 61, .external_lex_state = 5},
  [168] = {.lex_state = 61, .external_lex_state = 5},
  [169] = {.lex_state = 61, .external_lex_state = 5},
  [170] = {.lex_state = 62, .external_lex_state = 6},
  [171] = {.lex_state = 63, .external_lex_state = 6},
  [172] = {.lex_state = 198, .external_lex_state = 4},
  [173] = {.lex_state = 198, .external_lex_state = 4},
  [174] = {.lex_state = 198, .external_lex_state = 2},
  [175] = {.lex_state = 83, .external_lex_state = 4},
  [176] = {.lex_state = 193, .external_lex_state = 5},
  [177] = {.lex_state = 198, .external_lex_state = 2},
  [178] = {.lex_state = 198, .external_lex_state = 4},
  [179] = {.lex_state = 193, .external_lex_state = 5},
  [180] = {.lex_state = 198, .external_lex_state = 4},
  [181] = {.lex_state = 65, .external_lex_state = 5},
  [182] = {.lex_state = 193, .external_lex_state = 5},
  [183] = {.lex_state = 80, .external_lex_state = 2},
  [184] = {.lex_state = 63, .external_lex_state = 6},
  [185] = {.lex_state = 63, .external_lex_state = 6},
  [186] = {.lex_state = 198, .external_lex_state = 4},
  [187] = {.lex_state = 82, .external_lex_state = 7},
  [188] = {.lex_state = 193, .external_lex_state = 5},
  [189] = {.lex_state = 63, .external_lex_state = 6},
  [190] = {.lex_state = 80, .external_lex_state = 2},
  [191] = {.lex_state = 63, .external_lex_state = 6},
  [192] = {.lex_state = 193, .external_lex_state = 5},
  [193] = {.lex_state = 80, .external_lex_state = 2},
  [194] = {.lex_state = 193, .external_lex_state = 5},
  [195] = {.lex_state = 65, .external_lex_state = 5},
  [196] = {.lex_state = 80, .external_lex_state = 2},
  [197] = {.lex_state = 198, .external_lex_state = 2},
  [198] = {.lex_state = 198, .external_lex_state = 2},
  [199] = {.lex_state = 198, .external_lex_state = 4},
  [200] = {.lex_state = 194, .external_lex_state = 6},
  [201] = {.lex_state = 67, .external_lex_state = 6},
  [202] = {.lex_state = 67, .external_lex_state = 6},
  [203] = {.lex_state = 198, .external_lex_state = 4},
  [204] = {.lex_state = 67, .external_lex_state = 6},
  [205] = {.lex_state = 193, .external_lex_state = 5},
  [206] = {.lex_state = 194, .external_lex_state = 6},
  [207] = {.lex_state = 8, .external_lex_state = 6},
  [208] = {.lex_state = 81, .external_lex_state = 2},
  [209] = {.lex_state = 81, .external_lex_state = 2},
  [210] = {.lex_state = 68, .external_lex_state = 5},
  [211] = {.lex_state = 8, .external_lex_state = 6},
  [212] = {.lex_state = 67, .external_lex_state = 6},
  [213] = {.lex_state = 193, .external_lex_state = 5},
  [214] = {.lex_state = 198, .external_lex_state = 4},
  [215] = {.lex_state = 68, .external_lex_state = 5},
  [216] = {.lex_state = 65, .external_lex_state = 6},
  [217] = {.lex_state = 67, .external_lex_state = 6},
  [218] = {.lex_state = 8, .external_lex_state = 6},
  [219] = {.lex_state = 195, .external_lex_state = 6},
  [220] = {.lex_state = 195, .external_lex_state = 6},
  [221] = {.lex_state = 195, .external_lex_state = 6},
  [222] = {.lex_state = 68, .external_lex_state = 6},
  [223] = {.lex_state = 196, .external_lex_state = 5},
  [224] = {.lex_state = 196, .external_lex_state = 5},
  [225] = {.lex_state = 61, .external_lex_state = 6},
  [226] = {.lex_state = 196, .external_lex_state = 5},
  [227] = {.lex_state = 195, .external_lex_state = 6},
  [228] = {.lex_state = 195, .external_lex_state = 6},
  [229] = {.lex_state = 195, .external_lex_state = 6},
  [230] = {.lex_state = 61, .external_lex_state = 6},
  [231] = {.lex_state = 61, .external_lex_state = 6},
  [232] = {.lex_state = 195, .external_lex_state = 6},
  [233] = {.lex_state = 195, .external_lex_state = 6},
  [234] = {.lex_state = 195, .external_lex_state = 6},
  [235] = {.lex_state = 196, .external_lex_state = 5},
  [236] = {.lex_state = 195, .external_lex_state = 6},
  [237] = {.lex_state = 195, .external_lex_state = 6},
  [238] = {.lex_state = 196, .external_lex_state = 6},
  [239] = {.lex_state = 193, .external_lex_state = 6},
  [240] = {.lex_state = 193, .external_lex_state = 6},
  [241] = {.lex_state = 198, .external_lex_state = 2},
  [242] = {.lex_state = 198, .external_lex_state = 2},
  [243] = {.lex_state = 83, .external_lex_state = 2},
  [244] = {.lex_state = 198, .external_lex_state = 2},
  [245] = {.lex_state = 195, .external_lex_state = 6},
  [246] = {.lex_state = 193, .external_lex_state = 6},
  [247] = {.lex_state = 193, .external_lex_state = 6},
  [248] = {.lex_state = 198, .external_lex_state = 2},
  [249] = {.lex_state = 196, .external_lex_state = 6},
  [250] = {.lex_state = 193, .external_lex_state = 6},
  [251] = {.lex_state = 193, .external_lex_state = 6},
  [252] = {.lex_state = 82, .external_lex_state = 3},
  [253] = {.lex_state = 83, .external_lex_state = 2},
  [254] = {.lex_state = 198, .external_lex_state = 2},
  [255] = {.lex_state = 82, .external_lex_state = 3},
  [256] = {.lex_state = 198, .external_lex_state = 2},
  [257] = {.lex_state = 195, .external_lex_state = 6},
  [258] = {.lex_state = 195, .external_lex_state = 6},
  [259] = {.lex_state = 198, .external_lex_state = 2},
  [260] = {.lex_state = 95, .external_lex_state = 2},
  [261] = {.lex_state = 198, .external_lex_state = 2},
  [262] = {.lex_state = 95, .external_lex_state = 2},
  [263] = {.lex_state = 95, .external_lex_state = 2},
  [264] = {.lex_state = 198, .external_lex_state = 2},
  [265] = {.lex_state = 198, .external_lex_state = 2},
  [266] = {.lex_state = 95, .external_lex_state = 2},
  [267] = {.lex_state = 198, .external_lex_state = 2},
  [268] = {.lex_state = 95, .external_lex_state = 2},
  [269] = {.lex_state = 193, .external_lex_state = 6},
  [270] = {.lex_state = 198, .external_lex_state = 2},
  [271] = {.lex_state = 193, .external_lex_state = 6},
  [272] = {.lex_state = 63, .external_lex_state = 8},
  [273] = {.lex_state = 71, .external_lex_state = 5},
  [274] = {.lex_state = 71, .external_lex_state = 5},
  [275] = {.lex_state = 71, .external_lex_state = 5},
  [276] = {.lex_state = 71, .external_lex_state = 5},
  [277] = {.lex_state = 63, .external_lex_state = 8},
  [278] = {.lex_state = 8, .external_lex_state = 9},
  [279] = {.lex_state = 63, .external_lex_state = 8},
  [280] = {.lex_state = 63, .external_lex_state = 8},
  [281] = {.lex_state = 8, .external_lex_state = 9},
  [282] = {.lex_state = 72, .external_lex_state = 5},
  [283] = {.lex_state = 8, .external_lex_state = 9},
  [284] = {.lex_state = 63, .external_lex_state = 8},
  [285] = {.lex_state = 67, .external_lex_state = 8},
  [286] = {.lex_state = 63, .external_lex_state = 8},
  [287] = {.lex_state = 8, .external_lex_state = 9},
  [288] = {.lex_state = 72, .external_lex_state = 5},
  [289] = {.lex_state = 63, .external_lex_state = 8},
  [290] = {.lex_state = 8, .external_lex_state = 9},
  [291] = {.lex_state = 72, .external_lex_state = 5},
  [292] = {.lex_state = 72, .external_lex_state = 5},
  [293] = {.lex_state = 197, .external_lex_state = 5},
  [294] = {.lex_state = 8, .external_lex_state = 9},
  [295] = {.lex_state = 195, .external_lex_state = 8},
  [296] = {.lex_state = 71, .external_lex_state = 9},
  [297] = {.lex_state = 197, .external_lex_state = 5},
  [298] = {.lex_state = 67, .external_lex_state = 8},
  [299] = {.lex_state = 197, .external_lex_state = 5},
  [300] = {.lex_state = 8, .external_lex_state = 5},
  [301] = {.lex_state = 67, .external_lex_state = 8},
  [302] = {.lex_state = 61, .external_lex_state = 9},
  [303] = {.lex_state = 67, .external_lex_state = 8},
  [304] = {.lex_state = 197, .external_lex_state = 5},
  [305] = {.lex_state = 197, .external_lex_state = 5},
  [306] = {.lex_state = 61, .external_lex_state = 9},
  [307] = {.lex_state = 63, .external_lex_state = 6},
  [308] = {.lex_state = 63, .external_lex_state = 6},
  [309] = {.lex_state = 8, .external_lex_state = 8},
  [310] = {.lex_state = 8, .external_lex_state = 5},
  [311] = {.lex_state = 63, .external_lex_state = 6},
  [312] = {.lex_state = 63, .external_lex_state = 8},
  [313] = {.lex_state = 63, .external_lex_state = 8},
  [314] = {.lex_state = 63, .external_lex_state = 8},
  [315] = {.lex_state = 63, .external_lex_state = 8},
  [316] = {.lex_state = 61, .external_lex_state = 9},
  [317] = {.lex_state = 63, .external_lex_state = 8},
  [318] = {.lex_state = 63, .external_lex_state = 8},
  [319] = {.lex_state = 8, .external_lex_state = 9},
  [320] = {.lex_state = 8, .external_lex_state = 9},
  [321] = {.lex_state = 197, .external_lex_state = 5},
  [322] = {.lex_state = 8, .external_lex_state = 9},
  [323] = {.lex_state = 197, .external_lex_state = 5},
  [324] = {.lex_state = 8, .external_lex_state = 9},
  [325] = {.lex_state = 8, .external_lex_state = 9},
  [326] = {.lex_state = 8, .external_lex_state = 9},
  [327] = {.lex_state = 63, .external_lex_state = 8},
  [328] = {.lex_state = 63, .external_lex_state = 8},
  [329] = {.lex_state = 8, .external_lex_state = 8},
  [330] = {.lex_state = 63, .external_lex_state = 8},
  [331] = {.lex_state = 63, .external_lex_state = 6},
  [332] = {.lex_state = 8, .external_lex_state = 8},
  [333] = {.lex_state = 63, .external_lex_state = 8},
  [334] = {.lex_state = 63, .external_lex_state = 8},
  [335] = {.lex_state = 63, .external_lex_state = 8},
  [336] = {.lex_state = 63, .external_lex_state = 8},
  [337] = {.lex_state = 63, .external_lex_state = 8},
  [338] = {.lex_state = 63, .external_lex_state = 8},
  [339] = {.lex_state = 63, .external_lex_state = 8},
  [340] = {.lex_state = 197, .external_lex_state = 5},
  [341] = {.lex_state = 63, .external_lex_state = 8},
  [342] = {.lex_state = 63, .external_lex_state = 8},
  [343] = {.lex_state = 63, .external_lex_state = 8},
  [344] = {.lex_state = 63, .external_lex_state = 8},
  [345] = {.lex_state = 63, .external_lex_state = 8},
  [346] = {.lex_state = 63, .external_lex_state = 8},
  [347] = {.lex_state = 63, .external_lex_state = 8},
  [348] = {.lex_state = 63, .external_lex_state = 8},
  [349] = {.lex_state = 63, .external_lex_state = 8},
  [350] = {.lex_state = 63, .external_lex_state = 8},
  [351] = {.lex_state = 67, .external_lex_state = 8},
  [352] = {.lex_state = 8, .external_lex_state = 9},
  [353] = {.lex_state = 8, .external_lex_state = 9},
  [354] = {.lex_state = 71, .external_lex_state = 9},
  [355] = {.lex_state = 8, .external_lex_state = 9},
  [356] = {.lex_state = 61, .external_lex_state = 9},
  [357] = {.lex_state = 195, .external_lex_state = 8},
  [358] = {.lex_state = 8, .external_lex_state = 5},
  [359] = {.lex_state = 61, .external_lex_state = 9},
  [360] = {.lex_state = 71, .external_lex_state = 9},
  [361] = {.lex_state = 8, .external_lex_state = 9},
  [362] = {.lex_state = 8, .external_lex_state = 9},
  [363] = {.lex_state = 8, .external_lex_state = 9},
  [364] = {.lex_state = 8, .external_lex_state = 9},
  [365] = {.lex_state = 8, .external_lex_state = 9},
  [366] = {.lex_state = 8, .external_lex_state = 9},
  [367] = {.lex_state = 8, .external_lex_state = 9},
  [368] = {.lex_state = 8, .external_lex_state = 9},
  [369] = {.lex_state = 8, .external_lex_state = 9},
  [370] = {.lex_state = 8, .external_lex_state = 9},
  [371] = {.lex_state = 8, .external_lex_state = 9},
  [372] = {.lex_state = 8, .external_lex_state = 9},
  [373] = {.lex_state = 8, .external_lex_state = 9},
  [374] = {.lex_state = 8, .external_lex_state = 9},
  [375] = {.lex_state = 67, .external_lex_state = 8},
  [376] = {.lex_state = 67, .external_lex_state = 8},
  [377] = {.lex_state = 8, .external_lex_state = 8},
  [378] = {.lex_state = 8, .external_lex_state = 9},
  [379] = {.lex_state = 8, .external_lex_state = 9},
  [380] = {.lex_state = 71, .external_lex_state = 9},
  [381] = {.lex_state = 61, .external_lex_state = 5},
  [382] = {.lex_state = 61, .external_lex_state = 9},
  [383] = {.lex_state = 71, .external_lex_state = 9},
  [384] = {.lex_state = 71, .external_lex_state = 9},
  [385] = {.lex_state = 193, .external_lex_state = 9},
  [386] = {.lex_state = 195, .external_lex_state = 8},
  [387] = {.lex_state = 71, .external_lex_state = 9},
  [388] = {.lex_state = 71, .external_lex_state = 9},
  [389] = {.lex_state = 67, .external_lex_state = 8},
  [390] = {.lex_state = 67, .external_lex_state = 8},
  [391] = {.lex_state = 71, .external_lex_state = 5},
  [392] = {.lex_state = 195, .external_lex_state = 8},
  [393] = {.lex_state = 71, .external_lex_state = 9},
  [394] = {.lex_state = 67, .external_lex_state = 8},
  [395] = {.lex_state = 67, .external_lex_state = 8},
  [396] = {.lex_state = 71, .external_lex_state = 9},
  [397] = {.lex_state = 71, .external_lex_state = 9},
  [398] = {.lex_state = 8, .external_lex_state = 8},
  [399] = {.lex_state = 8, .external_lex_state = 8},
  [400] = {.lex_state = 8, .external_lex_state = 8},
  [401] = {.lex_state = 8, .external_lex_state = 8},
  [402] = {.lex_state = 8, .external_lex_state = 8},
  [403] = {.lex_state = 8, .external_lex_state = 8},
  [404] = {.lex_state = 8, .external_lex_state = 8},
  [405] = {.lex_state = 193, .external_lex_state = 9},
  [406] = {.lex_state = 8, .external_lex_state = 8},
  [407] = {.lex_state = 8, .external_lex_state = 8},
  [408] = {.lex_state = 61, .external_lex_state = 9},
  [409] = {.lex_state = 8, .external_lex_state = 8},
  [410] = {.lex_state = 8, .external_lex_state = 8},
  [411] = {.lex_state = 8, .external_lex_state = 8},
  [412] = {.lex_state = 8, .external_lex_state = 8},
  [413] = {.lex_state = 61, .external_lex_state = 9},
  [414] = {.lex_state = 8, .external_lex_state = 8},
  [415] = {.lex_state = 8, .external_lex_state = 8},
  [416] = {.lex_state = 8, .external_lex_state = 8},
  [417] = {.lex_state = 8, .external_lex_state = 8},
  [418] = {.lex_state = 8, .external_lex_state = 6},
  [419] = {.lex_state = 61, .external_lex_state = 9},
  [420] = {.lex_state = 8, .external_lex_state = 8},
  [421] = {.lex_state = 8, .external_lex_state = 8},
  [422] = {.lex_state = 8, .external_lex_state = 8},
  [423] = {.lex_state = 71, .external_lex_state = 5},
  [424] = {.lex_state = 67, .external_lex_state = 8},
  [425] = {.lex_state = 71, .external_lex_state = 9},
  [426] = {.lex_state = 61, .external_lex_state = 9},
  [427] = {.lex_state = 61, .external_lex_state = 9},
  [428] = {.lex_state = 71, .external_lex_state = 9},
  [429] = {.lex_state = 71, .external_lex_state = 9},
  [430] = {.lex_state = 61, .external_lex_state = 9},
  [431] = {.lex_state = 71, .external_lex_state = 9},
  [432] = {.lex_state = 71, .external_lex_state = 9},
  [433] = {.lex_state = 71, .external_lex_state = 9},
  [434] = {.lex_state = 71, .external_lex_state = 9},
  [435] = {.lex_state = 71, .external_lex_state = 9},
  [436] = {.lex_state = 71, .external_lex_state = 9},
  [437] = {.lex_state = 61, .external_lex_state = 9},
  [438] = {.lex_state = 71, .external_lex_state = 9},
  [439] = {.lex_state = 71, .external_lex_state = 9},
  [440] = {.lex_state = 71, .external_lex_state = 9},
  [441] = {.lex_state = 71, .external_lex_state = 9},
  [442] = {.lex_state = 71, .external_lex_state = 9},
  [443] = {.lex_state = 71, .external_lex_state = 9},
  [444] = {.lex_state = 71, .external_lex_state = 9},
  [445] = {.lex_state = 71, .external_lex_state = 9},
  [446] = {.lex_state = 61, .external_lex_state = 9},
  [447] = {.lex_state = 61, .external_lex_state = 9},
  [448] = {.lex_state = 61, .external_lex_state = 9},
  [449] = {.lex_state = 195, .external_lex_state = 8},
  [450] = {.lex_state = 61, .external_lex_state = 9},
  [451] = {.lex_state = 8, .external_lex_state = 5},
  [452] = {.lex_state = 61, .external_lex_state = 9},
  [453] = {.lex_state = 61, .external_lex_state = 9},
  [454] = {.lex_state = 61, .external_lex_state = 9},
  [455] = {.lex_state = 61, .external_lex_state = 9},
  [456] = {.lex_state = 193, .external_lex_state = 9},
  [457] = {.lex_state = 197, .external_lex_state = 5},
  [458] = {.lex_state = 61, .external_lex_state = 9},
  [459] = {.lex_state = 71, .external_lex_state = 9},
  [460] = {.lex_state = 61, .external_lex_state = 9},
  [461] = {.lex_state = 71, .external_lex_state = 9},
  [462] = {.lex_state = 61, .external_lex_state = 9},
  [463] = {.lex_state = 193, .external_lex_state = 9},
  [464] = {.lex_state = 61, .external_lex_state = 9},
  [465] = {.lex_state = 197, .external_lex_state = 5},
  [466] = {.lex_state = 193, .external_lex_state = 9},
  [467] = {.lex_state = 61, .external_lex_state = 8},
  [468] = {.lex_state = 195, .external_lex_state = 8},
  [469] = {.lex_state = 67, .external_lex_state = 6},
  [470] = {.lex_state = 61, .external_lex_state = 9},
  [471] = {.lex_state = 61, .external_lex_state = 9},
  [472] = {.lex_state = 67, .external_lex_state = 8},
  [473] = {.lex_state = 193, .external_lex_state = 9},
  [474] = {.lex_state = 67, .external_lex_state = 8},
  [475] = {.lex_state = 195, .external_lex_state = 8},
  [476] = {.lex_state = 61, .external_lex_state = 9},
  [477] = {.lex_state = 8, .external_lex_state = 5},
  [478] = {.lex_state = 193, .external_lex_state = 9},
  [479] = {.lex_state = 67, .external_lex_state = 6},
  [480] = {.lex_state = 72, .external_lex_state = 9},
  [481] = {.lex_state = 195, .external_lex_state = 8},
  [482] = {.lex_state = 8, .external_lex_state = 5},
  [483] = {.lex_state = 61, .external_lex_state = 8},
  [484] = {.lex_state = 195, .external_lex_state = 8},
  [485] = {.lex_state = 8, .external_lex_state = 5},
  [486] = {.lex_state = 61, .external_lex_state = 8},
  [487] = {.lex_state = 61, .external_lex_state = 5},
  [488] = {.lex_state = 197, .external_lex_state = 5},
  [489] = {.lex_state = 67, .external_lex_state = 8},
  [490] = {.lex_state = 67, .external_lex_state = 6},
  [491] = {.lex_state = 197, .external_lex_state = 5},
  [492] = {.lex_state = 67, .external_lex_state = 6},
  [493] = {.lex_state = 61, .external_lex_state = 5},
  [494] = {.lex_state = 8, .external_lex_state = 8},
  [495] = {.lex_state = 72, .external_lex_state = 9},
  [496] = {.lex_state = 61, .external_lex_state = 9},
  [497] = {.lex_state = 195, .external_lex_state = 8},
  [498] = {.lex_state = 197, .external_lex_state = 5},
  [499] = {.lex_state = 8, .external_lex_state = 8},
  [500] = {.lex_state = 61, .external_lex_state = 8},
  [501] = {.lex_state = 197, .external_lex_state = 5},
  [502] = {.lex_state = 67, .external_lex_state = 8},
  [503] = {.lex_state = 67, .external_lex_state = 8},
  [504] = {.lex_state = 8, .external_lex_state = 8},
  [505] = {.lex_state = 67, .external_lex_state = 8},
  [506] = {.lex_state = 8, .external_lex_state = 8},
  [507] = {.lex_state = 67, .external_lex_state = 8},
  [508] = {.lex_state = 61, .external_lex_state = 9},
  [509] = {.lex_state = 63, .external_lex_state = 6},
  [510] = {.lex_state = 193, .external_lex_state = 9},
  [511] = {.lex_state = 197, .external_lex_state = 5},
  [512] = {.lex_state = 197, .external_lex_state = 5},
  [513] = {.lex_state = 63, .external_lex_state = 6},
  [514] = {.lex_state = 193, .external_lex_state = 9},
  [515] = {.lex_state = 8, .external_lex_state = 8},
  [516] = {.lex_state = 195, .external_lex_state = 8},
  [517] = {.lex_state = 8, .external_lex_state = 8},
  [518] = {.lex_state = 67, .external_lex_state = 8},
  [519] = {.lex_state = 67, .external_lex_state = 8},
  [520] = {.lex_state = 197, .external_lex_state = 5},
  [521] = {.lex_state = 67, .external_lex_state = 8},
  [522] = {.lex_state = 67, .external_lex_state = 8},
  [523] = {.lex_state = 67, .external_lex_state = 8},
  [524] = {.lex_state = 63, .external_lex_state = 6},
  [525] = {.lex_state = 67, .external_lex_state = 8},
  [526] = {.lex_state = 67, .external_lex_state = 8},
  [527] = {.lex_state = 67, .external_lex_state = 8},
  [528] = {.lex_state = 67, .external_lex_state = 8},
  [529] = {.lex_state = 195, .external_lex_state = 8},
  [530] = {.lex_state = 67, .external_lex_state = 8},
  [531] = {.lex_state = 67, .external_lex_state = 8},
  [532] = {.lex_state = 67, .external_lex_state = 8},
  [533] = {.lex_state = 67, .external_lex_state = 8},
  [534] = {.lex_state = 195, .external_lex_state = 8},
  [535] = {.lex_state = 193, .external_lex_state = 9},
  [536] = {.lex_state = 61, .external_lex_state = 9},
  [537] = {.lex_state = 72, .external_lex_state = 9},
  [538] = {.lex_state = 72, .external_lex_state = 9},
  [539] = {.lex_state = 195, .external_lex_state = 8},
  [540] = {.lex_state = 67, .external_lex_state = 8},
  [541] = {.lex_state = 197, .external_lex_state = 5},
  [542] = {.lex_state = 63, .external_lex_state = 6},
  [543] = {.lex_state = 8, .external_lex_state = 6},
  [544] = {.lex_state = 195, .external_lex_state = 8},
  [545] = {.lex_state = 72, .external_lex_state = 9},
  [546] = {.lex_state = 61, .external_lex_state = 8},
  [547] = {.lex_state = 195, .external_lex_state = 8},
  [548] = {.lex_state = 61, .external_lex_state = 8},
  [549] = {.lex_state = 61, .external_lex_state = 8},
  [550] = {.lex_state = 61, .external_lex_state = 8},
  [551] = {.lex_state = 193, .external_lex_state = 9},
  [552] = {.lex_state = 195, .external_lex_state = 8},
  [553] = {.lex_state = 61, .external_lex_state = 8},
  [554] = {.lex_state = 193, .external_lex_state = 5},
  [555] = {.lex_state = 195, .external_lex_state = 8},
  [556] = {.lex_state = 193, .external_lex_state = 9},
  [557] = {.lex_state = 197, .external_lex_state = 9},
  [558] = {.lex_state = 193, .external_lex_state = 9},
  [559] = {.lex_state = 71, .external_lex_state = 5},
  [560] = {.lex_state = 61, .external_lex_state = 8},
  [561] = {.lex_state = 72, .external_lex_state = 9},
  [562] = {.lex_state = 8, .external_lex_state = 6},
  [563] = {.lex_state = 193, .external_lex_state = 9},
  [564] = {.lex_state = 193, .external_lex_state = 9},
  [565] = {.lex_state = 71, .external_lex_state = 5},
  [566] = {.lex_state = 61, .external_lex_state = 8},
  [567] = {.lex_state = 193, .external_lex_state = 9},
  [568] = {.lex_state = 195, .external_lex_state = 6},
  [569] = {.lex_state = 61, .external_lex_state = 8},
  [570] = {.lex_state = 195, .external_lex_state = 6},
  [571] = {.lex_state = 193, .external_lex_state = 5},
  [572] = {.lex_state = 193, .external_lex_state = 8},
  [573] = {.lex_state = 195, .external_lex_state = 8},
  [574] = {.lex_state = 193, .external_lex_state = 9},
  [575] = {.lex_state = 193, .external_lex_state = 9},
  [576] = {.lex_state = 193, .external_lex_state = 9},
  [577] = {.lex_state = 193, .external_lex_state = 9},
  [578] = {.lex_state = 193, .external_lex_state = 9},
  [579] = {.lex_state = 193, .external_lex_state = 9},
  [580] = {.lex_state = 71, .external_lex_state = 5},
  [581] = {.lex_state = 193, .external_lex_state = 5},
  [582] = {.lex_state = 193, .external_lex_state = 9},
  [583] = {.lex_state = 61, .external_lex_state = 8},
  [584] = {.lex_state = 193, .external_lex_state = 9},
  [585] = {.lex_state = 193, .external_lex_state = 9},
  [586] = {.lex_state = 197, .external_lex_state = 9},
  [587] = {.lex_state = 193, .external_lex_state = 8},
  [588] = {.lex_state = 193, .external_lex_state = 9},
  [589] = {.lex_state = 197, .external_lex_state = 9},
  [590] = {.lex_state = 71, .external_lex_state = 5},
  [591] = {.lex_state = 193, .external_lex_state = 9},
  [592] = {.lex_state = 193, .external_lex_state = 9},
  [593] = {.lex_state = 193, .external_lex_state = 9},
  [594] = {.lex_state = 193, .external_lex_state = 8},
  [595] = {.lex_state = 193, .external_lex_state = 9},
  [596] = {.lex_state = 193, .external_lex_state = 9},
  [597] = {.lex_state = 193, .external_lex_state = 9},
  [598] = {.lex_state = 193, .external_lex_state = 9},
  [599] = {.lex_state = 193, .external_lex_state = 9},
  [600] = {.lex_state = 195, .external_lex_state = 8},
  [601] = {.lex_state = 195, .external_lex_state = 8},
  [602] = {.lex_state = 195, .external_lex_state = 8},
  [603] = {.lex_state = 25, .external_lex_state = 6},
  [604] = {.lex_state = 61, .external_lex_state = 8},
  [605] = {.lex_state = 195, .external_lex_state = 8},
  [606] = {.lex_state = 67, .external_lex_state = 6},
  [607] = {.lex_state = 195, .external_lex_state = 8},
  [608] = {.lex_state = 72, .external_lex_state = 9},
  [609] = {.lex_state = 193, .external_lex_state = 9},
  [610] = {.lex_state = 195, .external_lex_state = 8},
  [611] = {.lex_state = 193, .external_lex_state = 9},
  [612] = {.lex_state = 61, .external_lex_state = 8},
  [613] = {.lex_state = 193, .external_lex_state = 5},
  [614] = {.lex_state = 193, .external_lex_state = 8},
  [615] = {.lex_state = 193, .external_lex_state = 5},
  [616] = {.lex_state = 195, .external_lex_state = 8},
  [617] = {.lex_state = 195, .external_lex_state = 6},
  [618] = {.lex_state = 193, .external_lex_state = 9},
  [619] = {.lex_state = 193, .external_lex_state = 9},
  [620] = {.lex_state = 193, .external_lex_state = 9},
  [621] = {.lex_state = 193, .external_lex_state = 9},
  [622] = {.lex_state = 72, .external_lex_state = 9},
  [623] = {.lex_state = 195, .external_lex_state = 8},
  [624] = {.lex_state = 72, .external_lex_state = 9},
  [625] = {.lex_state = 195, .external_lex_state = 8},
  [626] = {.lex_state = 193, .external_lex_state = 9},
  [627] = {.lex_state = 195, .external_lex_state = 8},
  [628] = {.lex_state = 72, .external_lex_state = 5},
  [629] = {.lex_state = 195, .external_lex_state = 6},
  [630] = {.lex_state = 72, .external_lex_state = 9},
  [631] = {.lex_state = 193, .external_lex_state = 9},
  [632] = {.lex_state = 193, .external_lex_state = 9},
  [633] = {.lex_state = 193, .external_lex_state = 9},
  [634] = {.lex_state = 193, .external_lex_state = 9},
  [635] = {.lex_state = 193, .external_lex_state = 9},
  [636] = {.lex_state = 72, .external_lex_state = 9},
  [637] = {.lex_state = 72, .external_lex_state = 9},
  [638] = {.lex_state = 195, .external_lex_state = 8},
  [639] = {.lex_state = 72, .external_lex_state = 9},
  [640] = {.lex_state = 193, .external_lex_state = 9},
  [641] = {.lex_state = 193, .external_lex_state = 9},
  [642] = {.lex_state = 193, .external_lex_state = 9},
  [643] = {.lex_state = 195, .external_lex_state = 8},
  [644] = {.lex_state = 195, .external_lex_state = 8},
  [645] = {.lex_state = 195, .external_lex_state = 8},
  [646] = {.lex_state = 72, .external_lex_state = 9},
  [647] = {.lex_state = 195, .external_lex_state = 8},
  [648] = {.lex_state = 195, .external_lex_state = 8},
  [649] = {.lex_state = 72, .external_lex_state = 9},
  [650] = {.lex_state = 72, .external_lex_state = 9},
  [651] = {.lex_state = 72, .external_lex_state = 9},
  [652] = {.lex_state = 72, .external_lex_state = 9},
  [653] = {.lex_state = 193, .external_lex_state = 5},
  [654] = {.lex_state = 72, .external_lex_state = 9},
  [655] = {.lex_state = 72, .external_lex_state = 9},
  [656] = {.lex_state = 195, .external_lex_state = 8},
  [657] = {.lex_state = 195, .external_lex_state = 8},
  [658] = {.lex_state = 72, .external_lex_state = 9},
  [659] = {.lex_state = 61, .external_lex_state = 8},
  [660] = {.lex_state = 72, .external_lex_state = 9},
  [661] = {.lex_state = 61, .external_lex_state = 8},
  [662] = {.lex_state = 195, .external_lex_state = 6},
  [663] = {.lex_state = 193, .external_lex_state = 8},
  [664] = {.lex_state = 193, .external_lex_state = 9},
  [665] = {.lex_state = 193, .external_lex_state = 9},
  [666] = {.lex_state = 193, .external_lex_state = 9},
  [667] = {.lex_state = 193, .external_lex_state = 9},
  [668] = {.lex_state = 197, .external_lex_state = 9},
  [669] = {.lex_state = 193, .external_lex_state = 8},
  [670] = {.lex_state = 61, .external_lex_state = 8},
  [671] = {.lex_state = 193, .external_lex_state = 9},
  [672] = {.lex_state = 67, .external_lex_state = 6},
  [673] = {.lex_state = 193, .external_lex_state = 8},
  [674] = {.lex_state = 195, .external_lex_state = 8},
  [675] = {.lex_state = 193, .external_lex_state = 9},
  [676] = {.lex_state = 193, .external_lex_state = 9},
  [677] = {.lex_state = 193, .external_lex_state = 9},
  [678] = {.lex_state = 72, .external_lex_state = 9},
  [679] = {.lex_state = 72, .external_lex_state = 9},
  [680] = {.lex_state = 72, .external_lex_state = 9},
  [681] = {.lex_state = 195, .external_lex_state = 8},
  [682] = {.lex_state = 72, .external_lex_state = 9},
  [683] = {.lex_state = 195, .external_lex_state = 8},
  [684] = {.lex_state = 193, .external_lex_state = 9},
  [685] = {.lex_state = 61, .external_lex_state = 8},
  [686] = {.lex_state = 195, .external_lex_state = 8},
  [687] = {.lex_state = 195, .external_lex_state = 8},
  [688] = {.lex_state = 195, .external_lex_state = 8},
  [689] = {.lex_state = 195, .external_lex_state = 8},
  [690] = {.lex_state = 195, .external_lex_state = 8},
  [691] = {.lex_state = 195, .external_lex_state = 8},
  [692] = {.lex_state = 193, .external_lex_state = 9},
  [693] = {.lex_state = 61, .external_lex_state = 8},
  [694] = {.lex_state = 193, .external_lex_state = 9},
  [695] = {.lex_state = 61, .external_lex_state = 8},
  [696] = {.lex_state = 193, .external_lex_state = 9},
  [697] = {.lex_state = 61, .external_lex_state = 8},
  [698] = {.lex_state = 61, .external_lex_state = 8},
  [699] = {.lex_state = 193, .external_lex_state = 9},
  [700] = {.lex_state = 195, .external_lex_state = 8},
  [701] = {.lex_state = 61, .external_lex_state = 6},
  [702] = {.lex_state = 61, .external_lex_state = 6},
  [703] = {.lex_state = 61, .external_lex_state = 8},
  [704] = {.lex_state = 72, .external_lex_state = 9},
  [705] = {.lex_state = 61, .external_lex_state = 8},
  [706] = {.lex_state = 72, .external_lex_state = 9},
  [707] = {.lex_state = 195, .external_lex_state = 8},
  [708] = {.lex_state = 195, .external_lex_state = 6},
  [709] = {.lex_state = 61, .external_lex_state = 8},
  [710] = {.lex_state = 197, .external_lex_state = 9},
  [711] = {.lex_state = 61, .external_lex_state = 8},
  [712] = {.lex_state = 61, .external_lex_state = 8},
  [713] = {.lex_state = 72, .external_lex_state = 9},
  [714] = {.lex_state = 67, .external_lex_state = 6},
  [715] = {.lex_state = 195, .external_lex_state = 8},
  [716] = {.lex_state = 67, .external_lex_state = 6},
  [717] = {.lex_state = 61, .external_lex_state = 8},
  [718] = {.lex_state = 195, .external_lex_state = 8},
  [719] = {.lex_state = 195, .external_lex_state = 8},
  [720] = {.lex_state = 195, .external_lex_state = 8},
  [721] = {.lex_state = 195, .external_lex_state = 8},
  [722] = {.lex_state = 195, .external_lex_state = 8},
  [723] = {.lex_state = 195, .external_lex_state = 8},
  [724] = {.lex_state = 61, .external_lex_state = 8},
  [725] = {.lex_state = 195, .external_lex_state = 8},
  [726] = {.lex_state = 195, .external_lex_state = 6},
  [727] = {.lex_state = 197, .external_lex_state = 9},
  [728] = {.lex_state = 195, .external_lex_state = 6},
  [729] = {.lex_state = 195, .external_lex_state = 8},
  [730] = {.lex_state = 195, .external_lex_state = 8},
  [731] = {.lex_state = 195, .external_lex_state = 8},
  [732] = {.lex_state = 195, .external_lex_state = 8},
  [733] = {.lex_state = 193, .external_lex_state = 8},
  [734] = {.lex_state = 197, .external_lex_state = 9},
  [735] = {.lex_state = 61, .external_lex_state = 5},
  [736] = {.lex_state = 61, .external_lex_state = 5},
  [737] = {.lex_state = 72, .external_lex_state = 9},
  [738] = {.lex_state = 195, .external_lex_state = 8},
  [739] = {.lex_state = 195, .external_lex_state = 8},
  [740] = {.lex_state = 195, .external_lex_state = 8},
  [741] = {.lex_state = 195, .external_lex_state = 8},
  [742] = {.lex_state = 197, .external_lex_state = 9},
  [743] = {.lex_state = 72, .external_lex_state = 5},
  [744] = {.lex_state = 61, .external_lex_state = 5},
  [745] = {.lex_state = 195, .external_lex_state = 8},
  [746] = {.lex_state = 61, .external_lex_state = 5},
  [747] = {.lex_state = 195, .external_lex_state = 8},
  [748] = {.lex_state = 197, .external_lex_state = 9},
  [749] = {.lex_state = 96, .external_lex_state = 2},
  [750] = {.lex_state = 197, .external_lex_state = 9},
  [751] = {.lex_state = 197, .external_lex_state = 5},
  [752] = {.lex_state = 197, .external_lex_state = 9},
  [753] = {.lex_state = 197, .external_lex_state = 9},
  [754] = {.lex_state = 197, .external_lex_state = 9},
  [755] = {.lex_state = 197, .external_lex_state = 9},
  [756] = {.lex_state = 197, .external_lex_state = 9},
  [757] = {.lex_state = 197, .external_lex_state = 9},
  [758] = {.lex_state = 195, .external_lex_state = 6},
  [759] = {.lex_state = 197, .external_lex_state = 9},
  [760] = {.lex_state = 96, .external_lex_state = 2},
  [761] = {.lex_state = 197, .external_lex_state = 9},
  [762] = {.lex_state = 197, .external_lex_state = 9},
  [763] = {.lex_state = 197, .external_lex_state = 9},
  [764] = {.lex_state = 197, .external_lex_state = 9},
  [765] = {.lex_state = 197, .external_lex_state = 9},
  [766] = {.lex_state = 197, .external_lex_state = 9},
  [767] = {.lex_state = 72, .external_lex_state = 5},
  [768] = {.lex_state = 193, .external_lex_state = 5},
  [769] = {.lex_state = 72, .external_lex_state = 5},
  [770] = {.lex_state = 186, .external_lex_state = 6},
  [771] = {.lex_state = 72, .external_lex_state = 5},
  [772] = {.lex_state = 193, .external_lex_state = 6},
  [773] = {.lex_state = 197, .external_lex_state = 5},
  [774] = {.lex_state = 193, .external_lex_state = 8},
  [775] = {.lex_state = 193, .external_lex_state = 8},
  [776] = {.lex_state = 193, .external_lex_state = 8},
  [777] = {.lex_state = 193, .external_lex_state = 8},
  [778] = {.lex_state = 193, .external_lex_state = 8},
  [779] = {.lex_state = 193, .external_lex_state = 5},
  [780] = {.lex_state = 197, .external_lex_state = 9},
  [781] = {.lex_state = 193, .external_lex_state = 8},
  [782] = {.lex_state = 197, .external_lex_state = 9},
  [783] = {.lex_state = 197, .external_lex_state = 9},
  [784] = {.lex_state = 197, .external_lex_state = 9},
  [785] = {.lex_state = 197, .external_lex_state = 9},
  [786] = {.lex_state = 96, .external_lex_state = 2},
  [787] = {.lex_state = 197, .external_lex_state = 9},
  [788] = {.lex_state = 193, .external_lex_state = 8},
  [789] = {.lex_state = 193, .external_lex_state = 8},
  [790] = {.lex_state = 193, .external_lex_state = 8},
  [791] = {.lex_state = 197, .external_lex_state = 9},
  [792] = {.lex_state = 197, .external_lex_state = 9},
  [793] = {.lex_state = 197, .external_lex_state = 9},
  [794] = {.lex_state = 197, .external_lex_state = 9},
  [795] = {.lex_state = 193, .external_lex_state = 5},
  [796] = {.lex_state = 26, .external_lex_state = 6},
  [797] = {.lex_state = 193, .external_lex_state = 8},
  [798] = {.lex_state = 197, .external_lex_state = 9},
  [799] = {.lex_state = 193, .external_lex_state = 8},
  [800] = {.lex_state = 193, .external_lex_state = 8},
  [801] = {.lex_state = 193, .external_lex_state = 8},
  [802] = {.lex_state = 193, .external_lex_state = 8},
  [803] = {.lex_state = 197, .external_lex_state = 5},
  [804] = {.lex_state = 195, .external_lex_state = 6},
  [805] = {.lex_state = 193, .external_lex_state = 8},
  [806] = {.lex_state = 197, .external_lex_state = 9},
  [807] = {.lex_state = 197, .external_lex_state = 9},
  [808] = {.lex_state = 197, .external_lex_state = 9},
  [809] = {.lex_state = 197, .external_lex_state = 9},
  [810] = {.lex_state = 61, .external_lex_state = 6},
  [811] = {.lex_state = 193, .external_lex_state = 8},
  [812] = {.lex_state = 197, .external_lex_state = 5},
  [813] = {.lex_state = 193, .external_lex_state = 8},
  [814] = {.lex_state = 193, .external_lex_state = 8},
  [815] = {.lex_state = 193, .external_lex_state = 8},
  [816] = {.lex_state = 197, .external_lex_state = 9},
  [817] = {.lex_state = 193, .external_lex_state = 8},
  [818] = {.lex_state = 193, .external_lex_state = 8},
  [819] = {.lex_state = 193, .external_lex_state = 8},
  [820] = {.lex_state = 193, .external_lex_state = 8},
  [821] = {.lex_state = 193, .external_lex_state = 8},
  [822] = {.lex_state = 193, .external_lex_state = 5},
  [823] = {.lex_state = 193, .external_lex_state = 8},
  [824] = {.lex_state = 195, .external_lex_state = 6},
  [825] = {.lex_state = 193, .external_lex_state = 8},
  [826] = {.lex_state = 193, .external_lex_state = 8},
  [827] = {.lex_state = 195, .external_lex_state = 6},
  [828] = {.lex_state = 197, .external_lex_state = 9},
  [829] = {.lex_state = 195, .external_lex_state = 6},
  [830] = {.lex_state = 197, .external_lex_state = 9},
  [831] = {.lex_state = 72, .external_lex_state = 5},
  [832] = {.lex_state = 195, .external_lex_state = 6},
  [833] = {.lex_state = 193, .external_lex_state = 8},
  [834] = {.lex_state = 193, .external_lex_state = 8},
  [835] = {.lex_state = 193, .external_lex_state = 5},
  [836] = {.lex_state = 193, .external_lex_state = 8},
  [837] = {.lex_state = 193, .external_lex_state = 8},
  [838] = {.lex_state = 193, .external_lex_state = 8},
  [839] = {.lex_state = 193, .external_lex_state = 8},
  [840] = {.lex_state = 193, .external_lex_state = 8},
  [841] = {.lex_state = 193, .external_lex_state = 8},
  [842] = {.lex_state = 193, .external_lex_state = 5},
  [843] = {.lex_state = 193, .external_lex_state = 8},
  [844] = {.lex_state = 193, .external_lex_state = 8},
  [845] = {.lex_state = 193, .external_lex_state = 8},
  [846] = {.lex_state = 193, .external_lex_state = 8},
  [847] = {.lex_state = 193, .external_lex_state = 8},
  [848] = {.lex_state = 193, .external_lex_state = 8},
  [849] = {.lex_state = 193, .external_lex_state = 8},
  [850] = {.lex_state = 193, .external_lex_state = 8},
  [851] = {.lex_state = 193, .external_lex_state = 8},
  [852] = {.lex_state = 193, .external_lex_state = 8},
  [853] = {.lex_state = 193, .external_lex_state = 8},
  [854] = {.lex_state = 193, .external_lex_state = 5},
  [855] = {.lex_state = 193, .external_lex_state = 8},
  [856] = {.lex_state = 193, .external_lex_state = 8},
  [857] = {.lex_state = 193, .external_lex_state = 8},
  [858] = {.lex_state = 193, .external_lex_state = 8},
  [859] = {.lex_state = 193, .external_lex_state = 8},
  [860] = {.lex_state = 193, .external_lex_state = 8},
  [861] = {.lex_state = 197, .external_lex_state = 9},
  [862] = {.lex_state = 193, .external_lex_state = 6},
  [863] = {.lex_state = 193, .external_lex_state = 6},
  [864] = {.lex_state = 197, .external_lex_state = 9},
  [865] = {.lex_state = 193, .external_lex_state = 5},
  [866] = {.lex_state = 197, .external_lex_state = 9},
  [867] = {.lex_state = 197, .external_lex_state = 9},
  [868] = {.lex_state = 197, .external_lex_state = 9},
  [869] = {.lex_state = 197, .external_lex_state = 9},
  [870] = {.lex_state = 197, .external_lex_state = 9},
  [871] = {.lex_state = 197, .external_lex_state = 9},
  [872] = {.lex_state = 193, .external_lex_state = 6},
  [873] = {.lex_state = 197, .external_lex_state = 9},
  [874] = {.lex_state = 197, .external_lex_state = 9},
  [875] = {.lex_state = 197, .external_lex_state = 9},
  [876] = {.lex_state = 197, .external_lex_state = 9},
  [877] = {.lex_state = 197, .external_lex_state = 9},
  [878] = {.lex_state = 197, .external_lex_state = 9},
  [879] = {.lex_state = 195, .external_lex_state = 6},
  [880] = {.lex_state = 197, .external_lex_state = 9},
  [881] = {.lex_state = 197, .external_lex_state = 9},
  [882] = {.lex_state = 197, .external_lex_state = 9},
  [883] = {.lex_state = 96, .external_lex_state = 2},
  [884] = {.lex_state = 197, .external_lex_state = 9},
  [885] = {.lex_state = 96, .external_lex_state = 2},
  [886] = {.lex_state = 197, .external_lex_state = 9},
  [887] = {.lex_state = 195, .external_lex_state = 6},
  [888] = {.lex_state = 197, .external_lex_state = 5},
  [889] = {.lex_state = 197, .external_lex_state = 5},
  [890] = {.lex_state = 186, .external_lex_state = 6},
  [891] = {.lex_state = 193, .external_lex_state = 6},
  [892] = {.lex_state = 197, .external_lex_state = 5},
  [893] = {.lex_state = 197, .external_lex_state = 5},
  [894] = {.lex_state = 197, .external_lex_state = 5},
  [895] = {.lex_state = 197, .external_lex_state = 5},
  [896] = {.lex_state = 197, .external_lex_state = 5},
  [897] = {.lex_state = 197, .external_lex_state = 5},
  [898] = {.lex_state = 193, .external_lex_state = 6},
  [899] = {.lex_state = 33, .external_lex_state = 10},
  [900] = {.lex_state = 35, .external_lex_state = 10},
  [901] = {.lex_state = 33, .external_lex_state = 10},
  [902] = {.lex_state = 33, .external_lex_state = 10},
  [903] = {.lex_state = 33, .external_lex_state = 10},
  [904] = {.lex_state = 33, .external_lex_state = 10},
  [905] = {.lex_state = 33, .external_lex_state = 10},
  [906] = {.lex_state = 33, .external_lex_state = 10},
  [907] = {.lex_state = 78, .external_lex_state = 2},
  [908] = {.lex_state = 33, .external_lex_state = 10},
  [909] = {.lex_state = 33, .external_lex_state = 10},
  [910] = {.lex_state = 89},
  [911] = {.lex_state = 94, .external_lex_state = 11},
  [912] = {.lex_state = 93, .external_lex_state = 12},
  [913] = {.lex_state = 84},
  [914] = {.lex_state = 94, .external_lex_state = 11},
  [915] = {.lex_state = 84},
  [916] = {.lex_state = 84},
  [917] = {.lex_state = 94, .external_lex_state = 11},
  [918] = {.lex_state = 93, .external_lex_state = 12},
  [919] = {.lex_state = 93, .external_lex_state = 12},
  [920] = {.lex_state = 84, .external_lex_state = 13},
  [921] = {.lex_state = 93, .external_lex_state = 12},
  [922] = {.lex_state = 93, .external_lex_state = 12},
  [923] = {.lex_state = 94, .external_lex_state = 11},
  [924] = {.lex_state = 88, .external_lex_state = 14},
  [925] = {.lex_state = 94, .external_lex_state = 11},
  [926] = {.lex_state = 94, .external_lex_state = 11},
  [927] = {.lex_state = 94, .external_lex_state = 11},
  [928] = {.lex_state = 84},
  [929] = {.lex_state = 93, .external_lex_state = 12},
  [930] = {.lex_state = 93, .external_lex_state = 12},
  [931] = {.lex_state = 93, .external_lex_state = 12},
  [932] = {.lex_state = 93, .external_lex_state = 12},
  [933] = {.lex_state = 93, .external_lex_state = 12},
  [934] = {.lex_state = 93, .external_lex_state = 12},
  [935] = {.lex_state = 94, .external_lex_state = 11},
  [936] = {.lex_state = 94, .external_lex_state = 11},
  [937] = {.lex_state = 94, .external_lex_state = 11},
  [938] = {.lex_state = 84, .external_lex_state = 13},
  [939] = {.lex_state = 94, .external_lex_state = 11},
  [940] = {.lex_state = 93, .external_lex_state = 12},
  [941] = {.lex_state = 93, .external_lex_state = 12},
  [942] = {.lex_state = 93, .external_lex_state = 12},
  [943] = {.lex_state = 84},
  [944] = {.lex_state = 84},
  [945] = {.lex_state = 84},
  [946] = {.lex_state = 93, .external_lex_state = 12},
  [947] = {.lex_state = 84},
  [948] = {.lex_state = 94, .external_lex_state = 11},
  [949] = {.lex_state = 94, .external_lex_state = 11},
  [950] = {.lex_state = 94, .external_lex_state = 11},
  [951] = {.lex_state = 94, .external_lex_state = 11},
  [952] = {.lex_state = 94, .external_lex_state = 11},
  [953] = {.lex_state = 93, .external_lex_state = 12},
  [954] = {.lex_state = 93, .external_lex_state = 12},
  [955] = {.lex_state = 93, .external_lex_state = 12},
  [956] = {.lex_state = 84},
  [957] = {.lex_state = 84},
  [958] = {.lex_state = 84},
  [959] = {.lex_state = 93, .external_lex_state = 12},
  [960] = {.lex_state = 84},
  [961] = {.lex_state = 94, .external_lex_state = 11},
  [962] = {.lex_state = 94, .external_lex_state = 11},
  [963] = {.lex_state = 93, .external_lex_state = 12},
  [964] = {.lex_state = 94, .external_lex_state = 11},
  [965] = {.lex_state = 93, .external_lex_state = 12},
  [966] = {.lex_state = 94, .external_lex_state = 11},
  [967] = {.lex_state = 93, .external_lex_state = 12},
  [968] = {.lex_state = 94, .external_lex_state = 11},
  [969] = {.lex_state = 93, .external_lex_state = 12},
  [970] = {.lex_state = 93, .external_lex_state = 12},
  [971] = {.lex_state = 93, .external_lex_state = 12},
  [972] = {.lex_state = 94, .external_lex_state = 11},
  [973] = {.lex_state = 94, .external_lex_state = 11},
  [974] = {.lex_state = 94, .external_lex_state = 11},
  [975] = {.lex_state = 94, .external_lex_state = 11},
  [976] = {.lex_state = 93, .external_lex_state = 12},
  [977] = {.lex_state = 93, .external_lex_state = 12},
  [978] = {.lex_state = 93, .external_lex_state = 12},
  [979] = {.lex_state = 93, .external_lex_state = 12},
  [980] = {.lex_state = 94, .external_lex_state = 11},
  [981] = {.lex_state = 94, .external_lex_state = 11},
  [982] = {.lex_state = 94, .external_lex_state = 11},
  [983] = {.lex_state = 94, .external_lex_state = 11},
  [984] = {.lex_state = 94, .external_lex_state = 11},
  [985] = {.lex_state = 94, .external_lex_state = 11},
  [986] = {.lex_state = 84, .external_lex_state = 13},
  [987] = {.lex_state = 93, .external_lex_state = 12},
  [988] = {.lex_state = 94, .external_lex_state = 11},
  [989] = {.lex_state = 93, .external_lex_state = 12},
  [990] = {.lex_state = 93, .external_lex_state = 12},
  [991] = {.lex_state = 94, .external_lex_state = 11},
  [992] = {.lex_state = 93, .external_lex_state = 12},
  [993] = {.lex_state = 93, .external_lex_state = 12},
  [994] = {.lex_state = 93, .external_lex_state = 12},
  [995] = {.lex_state = 94, .external_lex_state = 11},
  [996] = {.lex_state = 93, .external_lex_state = 12},
  [997] = {.lex_state = 93, .external_lex_state = 12},
  [998] = {.lex_state = 94, .external_lex_state = 11},
  [999] = {.lex_state = 94, .external_lex_state = 11},
  [1000] = {.lex_state = 94, .external_lex_state = 11},
  [1001] = {.lex_state = 84, .external_lex_state = 13},
  [1002] = {.lex_state = 93, .external_lex_state = 12},
  [1003] = {.lex_state = 93, .external_lex_state = 12},
  [1004] = {.lex_state = 93, .external_lex_state = 12},
  [1005] = {.lex_state = 93, .external_lex_state = 12},
  [1006] = {.lex_state = 94, .external_lex_state = 11},
  [1007] = {.lex_state = 94, .external_lex_state = 11},
  [1008] = {.lex_state = 94, .external_lex_state = 11},
  [1009] = {.lex_state = 94, .external_lex_state = 11},
  [1010] = {.lex_state = 93, .external_lex_state = 12},
  [1011] = {.lex_state = 93, .external_lex_state = 12},
  [1012] = {.lex_state = 93, .external_lex_state = 12},
  [1013] = {.lex_state = 94, .external_lex_state = 11},
  [1014] = {.lex_state = 93, .external_lex_state = 12},
  [1015] = {.lex_state = 94, .external_lex_state = 11},
  [1016] = {.lex_state = 94, .external_lex_state = 11},
  [1017] = {.lex_state = 94, .external_lex_state = 11},
  [1018] = {.lex_state = 94, .external_lex_state = 11},
  [1019] = {.lex_state = 94, .external_lex_state = 11},
  [1020] = {.lex_state = 94, .external_lex_state = 11},
  [1021] = {.lex_state = 93, .external_lex_state = 12},
  [1022] = {.lex_state = 93, .external_lex_state = 12},
  [1023] = {.lex_state = 93, .external_lex_state = 12},
  [1024] = {.lex_state = 93, .external_lex_state = 12},
  [1025] = {.lex_state = 94, .external_lex_state = 11},
  [1026] = {.lex_state = 93, .external_lex_state = 12},
  [1027] = {.lex_state = 93, .external_lex_state = 12},
  [1028] = {.lex_state = 93, .external_lex_state = 12},
  [1029] = {.lex_state = 93, .external_lex_state = 12},
  [1030] = {.lex_state = 94, .external_lex_state = 11},
  [1031] = {.lex_state = 94, .external_lex_state = 11},
  [1032] = {.lex_state = 94, .external_lex_state = 11},
  [1033] = {.lex_state = 94, .external_lex_state = 11},
  [1034] = {.lex_state = 93, .external_lex_state = 12},
  [1035] = {.lex_state = 93, .external_lex_state = 12},
  [1036] = {.lex_state = 93, .external_lex_state = 12},
  [1037] = {.lex_state = 94, .external_lex_state = 11},
  [1038] = {.lex_state = 93, .external_lex_state = 12},
  [1039] = {.lex_state = 94, .external_lex_state = 11},
  [1040] = {.lex_state = 94, .external_lex_state = 11},
  [1041] = {.lex_state = 94, .external_lex_state = 11},
  [1042] = {.lex_state = 94, .external_lex_state = 11},
  [1043] = {.lex_state = 94, .external_lex_state = 11},
  [1044] = {.lex_state = 93, .external_lex_state = 12},
  [1045] = {.lex_state = 93, .external_lex_state = 12},
  [1046] = {.lex_state = 93, .external_lex_state = 12},
  [1047] = {.lex_state = 93, .external_lex_state = 12},
  [1048] = {.lex_state = 94, .external_lex_state = 11},
  [1049] = {.lex_state = 94, .external_lex_state = 11},
  [1050] = {.lex_state = 93, .external_lex_state = 12},
  [1051] = {.lex_state = 93, .external_lex_state = 12},
  [1052] = {.lex_state = 93, .external_lex_state = 12},
  [1053] = {.lex_state = 93, .external_lex_state = 12},
  [1054] = {.lex_state = 94, .external_lex_state = 11},
  [1055] = {.lex_state = 94, .external_lex_state = 11},
  [1056] = {.lex_state = 94, .external_lex_state = 11},
  [1057] = {.lex_state = 94, .external_lex_state = 11},
  [1058] = {.lex_state = 93, .external_lex_state = 12},
  [1059] = {.lex_state = 93, .external_lex_state = 12},
  [1060] = {.lex_state = 94, .external_lex_state = 11},
  [1061] = {.lex_state = 93, .external_lex_state = 12},
  [1062] = {.lex_state = 94, .external_lex_state = 11},
  [1063] = {.lex_state = 93, .external_lex_state = 12},
  [1064] = {.lex_state = 94, .external_lex_state = 11},
  [1065] = {.lex_state = 94, .external_lex_state = 11},
  [1066] = {.lex_state = 94, .external_lex_state = 11},
  [1067] = {.lex_state = 93, .external_lex_state = 12},
  [1068] = {.lex_state = 93, .external_lex_state = 12},
  [1069] = {.lex_state = 93, .external_lex_state = 12},
  [1070] = {.lex_state = 93, .external_lex_state = 12},
  [1071] = {.lex_state = 94, .external_lex_state = 11},
  [1072] = {.lex_state = 94, .external_lex_state = 11},
  [1073] = {.lex_state = 94, .external_lex_state = 11},
  [1074] = {.lex_state = 93, .external_lex_state = 12},
  [1075] = {.lex_state = 93, .external_lex_state = 12},
  [1076] = {.lex_state = 93, .external_lex_state = 12},
  [1077] = {.lex_state = 93, .external_lex_state = 12},
  [1078] = {.lex_state = 94, .external_lex_state = 11},
  [1079] = {.lex_state = 94, .external_lex_state = 11},
  [1080] = {.lex_state = 94, .external_lex_state = 11},
  [1081] = {.lex_state = 94, .external_lex_state = 11},
  [1082] = {.lex_state = 93, .external_lex_state = 12},
  [1083] = {.lex_state = 94, .external_lex_state = 11},
  [1084] = {.lex_state = 93, .external_lex_state = 12},
  [1085] = {.lex_state = 94, .external_lex_state = 11},
  [1086] = {.lex_state = 93, .external_lex_state = 12},
  [1087] = {.lex_state = 94, .external_lex_state = 11},
  [1088] = {.lex_state = 93, .external_lex_state = 12},
  [1089] = {.lex_state = 94, .external_lex_state = 11},
  [1090] = {.lex_state = 93, .external_lex_state = 12},
  [1091] = {.lex_state = 93, .external_lex_state = 12},
  [1092] = {.lex_state = 93, .external_lex_state = 12},
  [1093] = {.lex_state = 94, .external_lex_state = 11},
  [1094] = {.lex_state = 93, .external_lex_state = 12},
  [1095] = {.lex_state = 94, .external_lex_state = 11},
  [1096] = {.lex_state = 94, .external_lex_state = 11},
  [1097] = {.lex_state = 94, .external_lex_state = 11},
  [1098] = {.lex_state = 93, .external_lex_state = 12},
  [1099] = {.lex_state = 93, .external_lex_state = 12},
  [1100] = {.lex_state = 93, .external_lex_state = 12},
  [1101] = {.lex_state = 93, .external_lex_state = 12},
  [1102] = {.lex_state = 94, .external_lex_state = 11},
  [1103] = {.lex_state = 94, .external_lex_state = 11},
  [1104] = {.lex_state = 94, .external_lex_state = 11},
  [1105] = {.lex_state = 93, .external_lex_state = 12},
  [1106] = {.lex_state = 93, .external_lex_state = 12},
  [1107] = {.lex_state = 93, .external_lex_state = 12},
  [1108] = {.lex_state = 94, .external_lex_state = 11},
  [1109] = {.lex_state = 93, .external_lex_state = 12},
  [1110] = {.lex_state = 94, .external_lex_state = 11},
  [1111] = {.lex_state = 94, .external_lex_state = 11},
  [1112] = {.lex_state = 94, .external_lex_state = 11},
  [1113] = {.lex_state = 94, .external_lex_state = 11},
  [1114] = {.lex_state = 94, .external_lex_state = 11},
  [1115] = {.lex_state = 94, .external_lex_state = 11},
  [1116] = {.lex_state = 94, .external_lex_state = 11},
  [1117] = {.lex_state = 93, .external_lex_state = 12},
  [1118] = {.lex_state = 93, .external_lex_state = 12},
  [1119] = {.lex_state = 93, .external_lex_state = 12},
  [1120] = {.lex_state = 93, .external_lex_state = 12},
  [1121] = {.lex_state = 93, .external_lex_state = 12},
  [1122] = {.lex_state = 93, .external_lex_state = 12},
  [1123] = {.lex_state = 93, .external_lex_state = 12},
  [1124] = {.lex_state = 93, .external_lex_state = 12},
  [1125] = {.lex_state = 94, .external_lex_state = 11},
  [1126] = {.lex_state = 94, .external_lex_state = 11},
  [1127] = {.lex_state = 94, .external_lex_state = 11},
  [1128] = {.lex_state = 94, .external_lex_state = 11},
  [1129] = {.lex_state = 93, .external_lex_state = 12},
  [1130] = {.lex_state = 93, .external_lex_state = 12},
  [1131] = {.lex_state = 93, .external_lex_state = 12},
  [1132] = {.lex_state = 93, .external_lex_state = 12},
  [1133] = {.lex_state = 94, .external_lex_state = 11},
  [1134] = {.lex_state = 94, .external_lex_state = 11},
  [1135] = {.lex_state = 94, .external_lex_state = 11},
  [1136] = {.lex_state = 94, .external_lex_state = 11},
  [1137] = {.lex_state = 94, .external_lex_state = 11},
  [1138] = {.lex_state = 94, .external_lex_state = 11},
  [1139] = {.lex_state = 94, .external_lex_state = 11},
  [1140] = {.lex_state = 94, .external_lex_state = 11},
  [1141] = {.lex_state = 93, .external_lex_state = 12},
  [1142] = {.lex_state = 93, .external_lex_state = 12},
  [1143] = {.lex_state = 93, .external_lex_state = 12},
  [1144] = {.lex_state = 93, .external_lex_state = 12},
  [1145] = {.lex_state = 93, .external_lex_state = 12},
  [1146] = {.lex_state = 93, .external_lex_state = 12},
  [1147] = {.lex_state = 93, .external_lex_state = 12},
  [1148] = {.lex_state = 93, .external_lex_state = 12},
  [1149] = {.lex_state = 94, .external_lex_state = 11},
  [1150] = {.lex_state = 94, .external_lex_state = 11},
  [1151] = {.lex_state = 94, .external_lex_state = 11},
  [1152] = {.lex_state = 94, .external_lex_state = 11},
  [1153] = {.lex_state = 93, .external_lex_state = 12},
  [1154] = {.lex_state = 93, .external_lex_state = 12},
  [1155] = {.lex_state = 93, .external_lex_state = 12},
  [1156] = {.lex_state = 93, .external_lex_state = 12},
  [1157] = {.lex_state = 94, .external_lex_state = 11},
  [1158] = {.lex_state = 94, .external_lex_state = 11},
  [1159] = {.lex_state = 94, .external_lex_state = 11},
  [1160] = {.lex_state = 94, .external_lex_state = 11},
  [1161] = {.lex_state = 94, .external_lex_state = 11},
  [1162] = {.lex_state = 94, .external_lex_state = 11},
  [1163] = {.lex_state = 94, .external_lex_state = 11},
  [1164] = {.lex_state = 93, .external_lex_state = 12},
  [1165] = {.lex_state = 84, .external_lex_state = 13},
  [1166] = {.lex_state = 93, .external_lex_state = 12},
  [1167] = {.lex_state = 94, .external_lex_state = 11},
  [1168] = {.lex_state = 93, .external_lex_state = 12},
  [1169] = {.lex_state = 93, .external_lex_state = 12},
  [1170] = {.lex_state = 93, .external_lex_state = 12},
  [1171] = {.lex_state = 93, .external_lex_state = 12},
  [1172] = {.lex_state = 88},
  [1173] = {.lex_state = 94, .external_lex_state = 11},
  [1174] = {.lex_state = 94, .external_lex_state = 11},
  [1175] = {.lex_state = 94, .external_lex_state = 11},
  [1176] = {.lex_state = 94, .external_lex_state = 11},
  [1177] = {.lex_state = 93, .external_lex_state = 12},
  [1178] = {.lex_state = 94, .external_lex_state = 12},
  [1179] = {.lex_state = 94, .external_lex_state = 12},
  [1180] = {.lex_state = 94, .external_lex_state = 12},
  [1181] = {.lex_state = 94, .external_lex_state = 12},
  [1182] = {.lex_state = 94, .external_lex_state = 12},
  [1183] = {.lex_state = 94, .external_lex_state = 12},
  [1184] = {.lex_state = 94, .external_lex_state = 12},
  [1185] = {.lex_state = 94, .external_lex_state = 12},
  [1186] = {.lex_state = 94, .external_lex_state = 12},
  [1187] = {.lex_state = 94, .external_lex_state = 12},
  [1188] = {.lex_state = 94, .external_lex_state = 12},
  [1189] = {.lex_state = 94, .external_lex_state = 12},
  [1190] = {.lex_state = 94, .external_lex_state = 12},
  [1191] = {.lex_state = 94, .external_lex_state = 12},
  [1192] = {.lex_state = 94, .external_lex_state = 12},
  [1193] = {.lex_state = 94, .external_lex_state = 12},
  [1194] = {.lex_state = 94, .external_lex_state = 12},
  [1195] = {.lex_state = 94, .external_lex_state = 12},
  [1196] = {.lex_state = 94, .external_lex_state = 12},
  [1197] = {.lex_state = 84},
  [1198] = {.lex_state = 94, .external_lex_state = 12},
  [1199] = {.lex_state = 94, .external_lex_state = 12},
  [1200] = {.lex_state = 94, .external_lex_state = 12},
  [1201] = {.lex_state = 94, .external_lex_state = 12},
  [1202] = {.lex_state = 94, .external_lex_state = 12},
  [1203] = {.lex_state = 94, .external_lex_state = 12},
  [1204] = {.lex_state = 94, .external_lex_state = 12},
  [1205] = {.lex_state = 94, .external_lex_state = 12},
  [1206] = {.lex_state = 94, .external_lex_state = 12},
  [1207] = {.lex_state = 84},
  [1208] = {.lex_state = 94, .external_lex_state = 12},
  [1209] = {.lex_state = 94, .external_lex_state = 12},
  [1210] = {.lex_state = 94, .external_lex_state = 12},
  [1211] = {.lex_state = 94, .external_lex_state = 12},
  [1212] = {.lex_state = 94, .external_lex_state = 12},
  [1213] = {.lex_state = 84},
  [1214] = {.lex_state = 94, .external_lex_state = 12},
  [1215] = {.lex_state = 84},
  [1216] = {.lex_state = 84},
  [1217] = {.lex_state = 84},
  [1218] = {.lex_state = 94, .external_lex_state = 12},
  [1219] = {.lex_state = 94, .external_lex_state = 12},
  [1220] = {.lex_state = 94, .external_lex_state = 12},
  [1221] = {.lex_state = 94, .external_lex_state = 12},
  [1222] = {.lex_state = 94, .external_lex_state = 12},
  [1223] = {.lex_state = 94, .external_lex_state = 12},
  [1224] = {.lex_state = 94, .external_lex_state = 12},
  [1225] = {.lex_state = 94, .external_lex_state = 12},
  [1226] = {.lex_state = 94, .external_lex_state = 12},
  [1227] = {.lex_state = 94, .external_lex_state = 12},
  [1228] = {.lex_state = 94, .external_lex_state = 12},
  [1229] = {.lex_state = 94, .external_lex_state = 12},
  [1230] = {.lex_state = 94, .external_lex_state = 12},
  [1231] = {.lex_state = 94, .external_lex_state = 12},
  [1232] = {.lex_state = 94, .external_lex_state = 12},
  [1233] = {.lex_state = 94, .external_lex_state = 12},
  [1234] = {.lex_state = 94, .external_lex_state = 12},
  [1235] = {.lex_state = 94, .external_lex_state = 12},
  [1236] = {.lex_state = 94, .external_lex_state = 12},
  [1237] = {.lex_state = 94, .external_lex_state = 12},
  [1238] = {.lex_state = 94, .external_lex_state = 12},
  [1239] = {.lex_state = 94, .external_lex_state = 12},
  [1240] = {.lex_state = 94, .external_lex_state = 12},
  [1241] = {.lex_state = 94, .external_lex_state = 12},
  [1242] = {.lex_state = 94, .external_lex_state = 12},
  [1243] = {.lex_state = 94, .external_lex_state = 12},
  [1244] = {.lex_state = 94, .external_lex_state = 12},
  [1245] = {.lex_state = 94, .external_lex_state = 12},
  [1246] = {.lex_state = 94, .external_lex_state = 12},
  [1247] = {.lex_state = 94, .external_lex_state = 12},
  [1248] = {.lex_state = 94, .external_lex_state = 12},
  [1249] = {.lex_state = 94, .external_lex_state = 12},
  [1250] = {.lex_state = 94, .external_lex_state = 12},
  [1251] = {.lex_state = 94, .external_lex_state = 12},
  [1252] = {.lex_state = 94, .external_lex_state = 12},
  [1253] = {.lex_state = 94, .external_lex_state = 12},
  [1254] = {.lex_state = 94, .external_lex_state = 12},
  [1255] = {.lex_state = 94, .external_lex_state = 12},
  [1256] = {.lex_state = 94, .external_lex_state = 12},
  [1257] = {.lex_state = 94, .external_lex_state = 12},
  [1258] = {.lex_state = 94, .external_lex_state = 12},
  [1259] = {.lex_state = 94, .external_lex_state = 12},
  [1260] = {.lex_state = 94, .external_lex_state = 12},
  [1261] = {.lex_state = 84},
  [1262] = {.lex_state = 94, .external_lex_state = 12},
  [1263] = {.lex_state = 94, .external_lex_state = 12},
  [1264] = {.lex_state = 94, .external_lex_state = 12},
  [1265] = {.lex_state = 94, .external_lex_state = 12},
  [1266] = {.lex_state = 94, .external_lex_state = 12},
  [1267] = {.lex_state = 94, .external_lex_state = 12},
  [1268] = {.lex_state = 94, .external_lex_state = 12},
  [1269] = {.lex_state = 94, .external_lex_state = 12},
  [1270] = {.lex_state = 94, .external_lex_state = 12},
  [1271] = {.lex_state = 94, .external_lex_state = 12},
  [1272] = {.lex_state = 84},
  [1273] = {.lex_state = 94, .external_lex_state = 12},
  [1274] = {.lex_state = 94, .external_lex_state = 12},
  [1275] = {.lex_state = 94, .external_lex_state = 12},
  [1276] = {.lex_state = 94, .external_lex_state = 12},
  [1277] = {.lex_state = 94, .external_lex_state = 12},
  [1278] = {.lex_state = 94, .external_lex_state = 12},
  [1279] = {.lex_state = 94, .external_lex_state = 12},
  [1280] = {.lex_state = 94, .external_lex_state = 12},
  [1281] = {.lex_state = 94, .external_lex_state = 12},
  [1282] = {.lex_state = 94, .external_lex_state = 12},
  [1283] = {.lex_state = 94, .external_lex_state = 12},
  [1284] = {.lex_state = 94, .external_lex_state = 12},
  [1285] = {.lex_state = 94, .external_lex_state = 12},
  [1286] = {.lex_state = 94, .external_lex_state = 12},
  [1287] = {.lex_state = 94, .external_lex_state = 12},
  [1288] = {.lex_state = 94, .external_lex_state = 12},
  [1289] = {.lex_state = 94, .external_lex_state = 12},
  [1290] = {.lex_state = 94, .external_lex_state = 12},
  [1291] = {.lex_state = 94, .external_lex_state = 12},
  [1292] = {.lex_state = 94, .external_lex_state = 12},
  [1293] = {.lex_state = 94, .external_lex_state = 12},
  [1294] = {.lex_state = 94, .external_lex_state = 12},
  [1295] = {.lex_state = 94, .external_lex_state = 12},
  [1296] = {.lex_state = 94, .external_lex_state = 12},
  [1297] = {.lex_state = 94, .external_lex_state = 12},
  [1298] = {.lex_state = 94, .external_lex_state = 12},
  [1299] = {.lex_state = 94, .external_lex_state = 12},
  [1300] = {.lex_state = 94, .external_lex_state = 12},
  [1301] = {.lex_state = 94, .external_lex_state = 12},
  [1302] = {.lex_state = 94, .external_lex_state = 12},
  [1303] = {.lex_state = 94, .external_lex_state = 12},
  [1304] = {.lex_state = 94, .external_lex_state = 12},
  [1305] = {.lex_state = 94, .external_lex_state = 12},
  [1306] = {.lex_state = 94, .external_lex_state = 12},
  [1307] = {.lex_state = 94, .external_lex_state = 12},
  [1308] = {.lex_state = 94, .external_lex_state = 12},
  [1309] = {.lex_state = 94, .external_lex_state = 12},
  [1310] = {.lex_state = 94, .external_lex_state = 12},
  [1311] = {.lex_state = 94, .external_lex_state = 12},
  [1312] = {.lex_state = 94, .external_lex_state = 12},
  [1313] = {.lex_state = 84},
  [1314] = {.lex_state = 94, .external_lex_state = 12},
  [1315] = {.lex_state = 94, .external_lex_state = 12},
  [1316] = {.lex_state = 94, .external_lex_state = 12},
  [1317] = {.lex_state = 94, .external_lex_state = 12},
  [1318] = {.lex_state = 94, .external_lex_state = 12},
  [1319] = {.lex_state = 94, .external_lex_state = 12},
  [1320] = {.lex_state = 94, .external_lex_state = 12},
  [1321] = {.lex_state = 94, .external_lex_state = 12},
  [1322] = {.lex_state = 94, .external_lex_state = 12},
  [1323] = {.lex_state = 94, .external_lex_state = 12},
  [1324] = {.lex_state = 94, .external_lex_state = 12},
  [1325] = {.lex_state = 94, .external_lex_state = 12},
  [1326] = {.lex_state = 94, .external_lex_state = 12},
  [1327] = {.lex_state = 94, .external_lex_state = 12},
  [1328] = {.lex_state = 94, .external_lex_state = 12},
  [1329] = {.lex_state = 94, .external_lex_state = 12},
  [1330] = {.lex_state = 94, .external_lex_state = 12},
  [1331] = {.lex_state = 94, .external_lex_state = 12},
  [1332] = {.lex_state = 94, .external_lex_state = 12},
  [1333] = {.lex_state = 94, .external_lex_state = 12},
  [1334] = {.lex_state = 94, .external_lex_state = 12},
  [1335] = {.lex_state = 94, .external_lex_state = 12},
  [1336] = {.lex_state = 94, .external_lex_state = 12},
  [1337] = {.lex_state = 94, .external_lex_state = 12},
  [1338] = {.lex_state = 94, .external_lex_state = 12},
  [1339] = {.lex_state = 94, .external_lex_state = 12},
  [1340] = {.lex_state = 94, .external_lex_state = 12},
  [1341] = {.lex_state = 94, .external_lex_state = 12},
  [1342] = {.lex_state = 94, .external_lex_state = 12},
  [1343] = {.lex_state = 94, .external_lex_state = 12},
  [1344] = {.lex_state = 94, .external_lex_state = 12},
  [1345] = {.lex_state = 94, .external_lex_state = 12},
  [1346] = {.lex_state = 94, .external_lex_state = 12},
  [1347] = {.lex_state = 94, .external_lex_state = 12},
  [1348] = {.lex_state = 94, .external_lex_state = 12},
  [1349] = {.lex_state = 94, .external_lex_state = 12},
  [1350] = {.lex_state = 94, .external_lex_state = 12},
  [1351] = {.lex_state = 94, .external_lex_state = 12},
  [1352] = {.lex_state = 94, .external_lex_state = 12},
  [1353] = {.lex_state = 94, .external_lex_state = 12},
  [1354] = {.lex_state = 94, .external_lex_state = 12},
  [1355] = {.lex_state = 94, .external_lex_state = 12},
  [1356] = {.lex_state = 94, .external_lex_state = 12},
  [1357] = {.lex_state = 94, .external_lex_state = 12},
  [1358] = {.lex_state = 94, .external_lex_state = 12},
  [1359] = {.lex_state = 94, .external_lex_state = 12},
  [1360] = {.lex_state = 94, .external_lex_state = 12},
  [1361] = {.lex_state = 94, .external_lex_state = 12},
  [1362] = {.lex_state = 94, .external_lex_state = 12},
  [1363] = {.lex_state = 94, .external_lex_state = 12},
  [1364] = {.lex_state = 94, .external_lex_state = 12},
  [1365] = {.lex_state = 94, .external_lex_state = 12},
  [1366] = {.lex_state = 94, .external_lex_state = 12},
  [1367] = {.lex_state = 94, .external_lex_state = 12},
  [1368] = {.lex_state = 94, .external_lex_state = 12},
  [1369] = {.lex_state = 94, .external_lex_state = 12},
  [1370] = {.lex_state = 94, .external_lex_state = 12},
  [1371] = {.lex_state = 94, .external_lex_state = 12},
  [1372] = {.lex_state = 94, .external_lex_state = 12},
  [1373] = {.lex_state = 94, .external_lex_state = 12},
  [1374] = {.lex_state = 94, .external_lex_state = 12},
  [1375] = {.lex_state = 94, .external_lex_state = 12},
  [1376] = {.lex_state = 94, .external_lex_state = 12},
  [1377] = {.lex_state = 94, .external_lex_state = 12},
  [1378] = {.lex_state = 94, .external_lex_state = 12},
  [1379] = {.lex_state = 94, .external_lex_state = 12},
  [1380] = {.lex_state = 94, .external_lex_state = 12},
  [1381] = {.lex_state = 94, .external_lex_state = 12},
  [1382] = {.lex_state = 94, .external_lex_state = 12},
  [1383] = {.lex_state = 94, .external_lex_state = 12},
  [1384] = {.lex_state = 94, .external_lex_state = 12},
  [1385] = {.lex_state = 94, .external_lex_state = 12},
  [1386] = {.lex_state = 94, .external_lex_state = 12},
  [1387] = {.lex_state = 94, .external_lex_state = 12},
  [1388] = {.lex_state = 94, .external_lex_state = 12},
  [1389] = {.lex_state = 94, .external_lex_state = 12},
  [1390] = {.lex_state = 94, .external_lex_state = 12},
  [1391] = {.lex_state = 94, .external_lex_state = 12},
  [1392] = {.lex_state = 94, .external_lex_state = 12},
  [1393] = {.lex_state = 94, .external_lex_state = 12},
  [1394] = {.lex_state = 94, .external_lex_state = 12},
  [1395] = {.lex_state = 94, .external_lex_state = 12},
  [1396] = {.lex_state = 94, .external_lex_state = 12},
  [1397] = {.lex_state = 94, .external_lex_state = 12},
  [1398] = {.lex_state = 94, .external_lex_state = 12},
  [1399] = {.lex_state = 94, .external_lex_state = 12},
  [1400] = {.lex_state = 94, .external_lex_state = 12},
  [1401] = {.lex_state = 84},
  [1402] = {.lex_state = 94, .external_lex_state = 12},
  [1403] = {.lex_state = 84},
  [1404] = {.lex_state = 94, .external_lex_state = 12},
  [1405] = {.lex_state = 94, .external_lex_state = 12},
  [1406] = {.lex_state = 94, .external_lex_state = 12},
  [1407] = {.lex_state = 94, .external_lex_state = 12},
  [1408] = {.lex_state = 94, .external_lex_state = 12},
  [1409] = {.lex_state = 94, .external_lex_state = 12},
  [1410] = {.lex_state = 94, .external_lex_state = 12},
  [1411] = {.lex_state = 84},
  [1412] = {.lex_state = 94, .external_lex_state = 12},
  [1413] = {.lex_state = 94, .external_lex_state = 12},
  [1414] = {.lex_state = 94, .external_lex_state = 12},
  [1415] = {.lex_state = 94, .external_lex_state = 12},
  [1416] = {.lex_state = 94, .external_lex_state = 12},
  [1417] = {.lex_state = 94, .external_lex_state = 12},
  [1418] = {.lex_state = 94, .external_lex_state = 12},
  [1419] = {.lex_state = 94, .external_lex_state = 12},
  [1420] = {.lex_state = 94, .external_lex_state = 12},
  [1421] = {.lex_state = 94, .external_lex_state = 12},
  [1422] = {.lex_state = 94, .external_lex_state = 12},
  [1423] = {.lex_state = 94, .external_lex_state = 12},
  [1424] = {.lex_state = 94, .external_lex_state = 12},
  [1425] = {.lex_state = 94, .external_lex_state = 12},
  [1426] = {.lex_state = 94, .external_lex_state = 12},
  [1427] = {.lex_state = 94, .external_lex_state = 12},
  [1428] = {.lex_state = 94, .external_lex_state = 12},
  [1429] = {.lex_state = 94, .external_lex_state = 12},
  [1430] = {.lex_state = 94, .external_lex_state = 12},
  [1431] = {.lex_state = 94, .external_lex_state = 12},
  [1432] = {.lex_state = 94, .external_lex_state = 12},
  [1433] = {.lex_state = 94, .external_lex_state = 12},
  [1434] = {.lex_state = 94, .external_lex_state = 12},
  [1435] = {.lex_state = 94, .external_lex_state = 12},
  [1436] = {.lex_state = 94, .external_lex_state = 12},
  [1437] = {.lex_state = 94, .external_lex_state = 12},
  [1438] = {.lex_state = 94, .external_lex_state = 12},
  [1439] = {.lex_state = 94, .external_lex_state = 12},
  [1440] = {.lex_state = 94, .external_lex_state = 12},
  [1441] = {.lex_state = 94, .external_lex_state = 12},
  [1442] = {.lex_state = 94, .external_lex_state = 12},
  [1443] = {.lex_state = 94, .external_lex_state = 12},
  [1444] = {.lex_state = 94, .external_lex_state = 12},
  [1445] = {.lex_state = 94, .external_lex_state = 12},
  [1446] = {.lex_state = 94, .external_lex_state = 12},
  [1447] = {.lex_state = 94, .external_lex_state = 12},
  [1448] = {.lex_state = 94, .external_lex_state = 12},
  [1449] = {.lex_state = 94, .external_lex_state = 12},
  [1450] = {.lex_state = 94, .external_lex_state = 12},
  [1451] = {.lex_state = 94, .external_lex_state = 12},
  [1452] = {.lex_state = 94, .external_lex_state = 12},
  [1453] = {.lex_state = 94, .external_lex_state = 12},
  [1454] = {.lex_state = 94, .external_lex_state = 12},
  [1455] = {.lex_state = 94, .external_lex_state = 12},
  [1456] = {.lex_state = 94, .external_lex_state = 12},
  [1457] = {.lex_state = 94, .external_lex_state = 12},
  [1458] = {.lex_state = 94, .external_lex_state = 12},
  [1459] = {.lex_state = 94, .external_lex_state = 12},
  [1460] = {.lex_state = 94, .external_lex_state = 12},
  [1461] = {.lex_state = 94, .external_lex_state = 12},
  [1462] = {.lex_state = 94, .external_lex_state = 12},
  [1463] = {.lex_state = 94, .external_lex_state = 12},
  [1464] = {.lex_state = 94, .external_lex_state = 12},
  [1465] = {.lex_state = 94, .external_lex_state = 12},
  [1466] = {.lex_state = 94, .external_lex_state = 12},
  [1467] = {.lex_state = 94, .external_lex_state = 12},
  [1468] = {.lex_state = 94, .external_lex_state = 12},
  [1469] = {.lex_state = 94, .external_lex_state = 12},
  [1470] = {.lex_state = 94, .external_lex_state = 12},
  [1471] = {.lex_state = 94, .external_lex_state = 12},
  [1472] = {.lex_state = 94, .external_lex_state = 12},
  [1473] = {.lex_state = 94, .external_lex_state = 12},
  [1474] = {.lex_state = 94, .external_lex_state = 12},
  [1475] = {.lex_state = 94, .external_lex_state = 12},
  [1476] = {.lex_state = 94, .external_lex_state = 12},
  [1477] = {.lex_state = 94, .external_lex_state = 12},
  [1478] = {.lex_state = 94, .external_lex_state = 12},
  [1479] = {.lex_state = 94, .external_lex_state = 12},
  [1480] = {.lex_state = 94, .external_lex_state = 12},
  [1481] = {.lex_state = 94, .external_lex_state = 12},
  [1482] = {.lex_state = 94, .external_lex_state = 12},
  [1483] = {.lex_state = 94, .external_lex_state = 12},
  [1484] = {.lex_state = 94, .external_lex_state = 12},
  [1485] = {.lex_state = 94, .external_lex_state = 12},
  [1486] = {.lex_state = 94, .external_lex_state = 12},
  [1487] = {.lex_state = 94, .external_lex_state = 12},
  [1488] = {.lex_state = 94, .external_lex_state = 12},
  [1489] = {.lex_state = 94, .external_lex_state = 12},
  [1490] = {.lex_state = 84},
  [1491] = {.lex_state = 94, .external_lex_state = 12},
  [1492] = {.lex_state = 94, .external_lex_state = 12},
  [1493] = {.lex_state = 94, .external_lex_state = 12},
  [1494] = {.lex_state = 94, .external_lex_state = 12},
  [1495] = {.lex_state = 94, .external_lex_state = 12},
  [1496] = {.lex_state = 94, .external_lex_state = 12},
  [1497] = {.lex_state = 94, .external_lex_state = 12},
  [1498] = {.lex_state = 84},
  [1499] = {.lex_state = 94, .external_lex_state = 12},
  [1500] = {.lex_state = 94, .external_lex_state = 12},
  [1501] = {.lex_state = 94, .external_lex_state = 12},
  [1502] = {.lex_state = 94, .external_lex_state = 12},
  [1503] = {.lex_state = 94, .external_lex_state = 12},
  [1504] = {.lex_state = 94, .external_lex_state = 12},
  [1505] = {.lex_state = 94, .external_lex_state = 12},
  [1506] = {.lex_state = 94, .external_lex_state = 12},
  [1507] = {.lex_state = 94, .external_lex_state = 12},
  [1508] = {.lex_state = 94, .external_lex_state = 12},
  [1509] = {.lex_state = 94, .external_lex_state = 12},
  [1510] = {.lex_state = 94, .external_lex_state = 12},
  [1511] = {.lex_state = 94, .external_lex_state = 12},
  [1512] = {.lex_state = 94, .external_lex_state = 12},
  [1513] = {.lex_state = 94, .external_lex_state = 12},
  [1514] = {.lex_state = 94, .external_lex_state = 12},
  [1515] = {.lex_state = 94, .external_lex_state = 12},
  [1516] = {.lex_state = 94, .external_lex_state = 12},
  [1517] = {.lex_state = 94, .external_lex_state = 12},
  [1518] = {.lex_state = 94, .external_lex_state = 12},
  [1519] = {.lex_state = 94, .external_lex_state = 12},
  [1520] = {.lex_state = 84},
  [1521] = {.lex_state = 94, .external_lex_state = 12},
  [1522] = {.lex_state = 94, .external_lex_state = 12},
  [1523] = {.lex_state = 94, .external_lex_state = 12},
  [1524] = {.lex_state = 94, .external_lex_state = 12},
  [1525] = {.lex_state = 94, .external_lex_state = 12},
  [1526] = {.lex_state = 94, .external_lex_state = 12},
  [1527] = {.lex_state = 94, .external_lex_state = 12},
  [1528] = {.lex_state = 94, .external_lex_state = 12},
  [1529] = {.lex_state = 94, .external_lex_state = 12},
  [1530] = {.lex_state = 94, .external_lex_state = 12},
  [1531] = {.lex_state = 94, .external_lex_state = 12},
  [1532] = {.lex_state = 94, .external_lex_state = 12},
  [1533] = {.lex_state = 94, .external_lex_state = 12},
  [1534] = {.lex_state = 84},
  [1535] = {.lex_state = 94, .external_lex_state = 12},
  [1536] = {.lex_state = 94, .external_lex_state = 12},
  [1537] = {.lex_state = 94, .external_lex_state = 12},
  [1538] = {.lex_state = 94, .external_lex_state = 12},
  [1539] = {.lex_state = 94, .external_lex_state = 12},
  [1540] = {.lex_state = 94, .external_lex_state = 12},
  [1541] = {.lex_state = 94, .external_lex_state = 12},
  [1542] = {.lex_state = 94, .external_lex_state = 12},
  [1543] = {.lex_state = 94, .external_lex_state = 12},
  [1544] = {.lex_state = 94, .external_lex_state = 12},
  [1545] = {.lex_state = 94, .external_lex_state = 12},
  [1546] = {.lex_state = 94, .external_lex_state = 12},
  [1547] = {.lex_state = 94, .external_lex_state = 12},
  [1548] = {.lex_state = 94, .external_lex_state = 12},
  [1549] = {.lex_state = 94, .external_lex_state = 12},
  [1550] = {.lex_state = 94, .external_lex_state = 12},
  [1551] = {.lex_state = 94, .external_lex_state = 12},
  [1552] = {.lex_state = 94, .external_lex_state = 12},
  [1553] = {.lex_state = 94, .external_lex_state = 12},
  [1554] = {.lex_state = 94, .external_lex_state = 12},
  [1555] = {.lex_state = 94, .external_lex_state = 12},
  [1556] = {.lex_state = 94, .external_lex_state = 12},
  [1557] = {.lex_state = 94, .external_lex_state = 12},
  [1558] = {.lex_state = 94, .external_lex_state = 12},
  [1559] = {.lex_state = 94, .external_lex_state = 12},
  [1560] = {.lex_state = 94, .external_lex_state = 12},
  [1561] = {.lex_state = 94, .external_lex_state = 12},
  [1562] = {.lex_state = 94, .external_lex_state = 12},
  [1563] = {.lex_state = 94, .external_lex_state = 12},
  [1564] = {.lex_state = 94, .external_lex_state = 12},
  [1565] = {.lex_state = 84},
  [1566] = {.lex_state = 94, .external_lex_state = 12},
  [1567] = {.lex_state = 94, .external_lex_state = 12},
  [1568] = {.lex_state = 94, .external_lex_state = 12},
  [1569] = {.lex_state = 94, .external_lex_state = 12},
  [1570] = {.lex_state = 94, .external_lex_state = 12},
  [1571] = {.lex_state = 94, .external_lex_state = 12},
  [1572] = {.lex_state = 94, .external_lex_state = 12},
  [1573] = {.lex_state = 94, .external_lex_state = 12},
  [1574] = {.lex_state = 94, .external_lex_state = 12},
  [1575] = {.lex_state = 94, .external_lex_state = 12},
  [1576] = {.lex_state = 94, .external_lex_state = 12},
  [1577] = {.lex_state = 94, .external_lex_state = 12},
  [1578] = {.lex_state = 94, .external_lex_state = 12},
  [1579] = {.lex_state = 94, .external_lex_state = 12},
  [1580] = {.lex_state = 94, .external_lex_state = 12},
  [1581] = {.lex_state = 94, .external_lex_state = 12},
  [1582] = {.lex_state = 94, .external_lex_state = 12},
  [1583] = {.lex_state = 94, .external_lex_state = 12},
  [1584] = {.lex_state = 94, .external_lex_state = 12},
  [1585] = {.lex_state = 94, .external_lex_state = 12},
  [1586] = {.lex_state = 94, .external_lex_state = 12},
  [1587] = {.lex_state = 94, .external_lex_state = 12},
  [1588] = {.lex_state = 94, .external_lex_state = 12},
  [1589] = {.lex_state = 94, .external_lex_state = 12},
  [1590] = {.lex_state = 94, .external_lex_state = 12},
  [1591] = {.lex_state = 94, .external_lex_state = 12},
  [1592] = {.lex_state = 94, .external_lex_state = 12},
  [1593] = {.lex_state = 94, .external_lex_state = 12},
  [1594] = {.lex_state = 94, .external_lex_state = 12},
  [1595] = {.lex_state = 94, .external_lex_state = 12},
  [1596] = {.lex_state = 84},
  [1597] = {.lex_state = 94, .external_lex_state = 12},
  [1598] = {.lex_state = 94, .external_lex_state = 12},
  [1599] = {.lex_state = 94, .external_lex_state = 12},
  [1600] = {.lex_state = 94, .external_lex_state = 12},
  [1601] = {.lex_state = 84},
  [1602] = {.lex_state = 94, .external_lex_state = 12},
  [1603] = {.lex_state = 84},
  [1604] = {.lex_state = 94, .external_lex_state = 12},
  [1605] = {.lex_state = 84},
  [1606] = {.lex_state = 94, .external_lex_state = 12},
  [1607] = {.lex_state = 94, .external_lex_state = 12},
  [1608] = {.lex_state = 94, .external_lex_state = 12},
  [1609] = {.lex_state = 94, .external_lex_state = 12},
  [1610] = {.lex_state = 94, .external_lex_state = 12},
  [1611] = {.lex_state = 94, .external_lex_state = 12},
  [1612] = {.lex_state = 94, .external_lex_state = 12},
  [1613] = {.lex_state = 94, .external_lex_state = 12},
  [1614] = {.lex_state = 94, .external_lex_state = 12},
  [1615] = {.lex_state = 94, .external_lex_state = 12},
  [1616] = {.lex_state = 94, .external_lex_state = 12},
  [1617] = {.lex_state = 84},
  [1618] = {.lex_state = 94, .external_lex_state = 12},
  [1619] = {.lex_state = 84},
  [1620] = {.lex_state = 94, .external_lex_state = 12},
  [1621] = {.lex_state = 84},
  [1622] = {.lex_state = 94, .external_lex_state = 12},
  [1623] = {.lex_state = 84},
  [1624] = {.lex_state = 84},
  [1625] = {.lex_state = 84},
  [1626] = {.lex_state = 84},
  [1627] = {.lex_state = 94, .external_lex_state = 12},
  [1628] = {.lex_state = 84},
  [1629] = {.lex_state = 84},
  [1630] = {.lex_state = 94, .external_lex_state = 12},
  [1631] = {.lex_state = 94, .external_lex_state = 12},
  [1632] = {.lex_state = 94, .external_lex_state = 12},
  [1633] = {.lex_state = 94, .external_lex_state = 12},
  [1634] = {.lex_state = 94, .external_lex_state = 12},
  [1635] = {.lex_state = 94, .external_lex_state = 12},
  [1636] = {.lex_state = 94, .external_lex_state = 12},
  [1637] = {.lex_state = 94, .external_lex_state = 12},
  [1638] = {.lex_state = 94, .external_lex_state = 12},
  [1639] = {.lex_state = 94, .external_lex_state = 12},
  [1640] = {.lex_state = 94, .external_lex_state = 12},
  [1641] = {.lex_state = 84},
  [1642] = {.lex_state = 94, .external_lex_state = 12},
  [1643] = {.lex_state = 84},
  [1644] = {.lex_state = 94, .external_lex_state = 12},
  [1645] = {.lex_state = 84},
  [1646] = {.lex_state = 28, .external_lex_state = 6},
  [1647] = {.lex_state = 28, .external_lex_state = 6},
  [1648] = {.lex_state = 28, .external_lex_state = 6},
  [1649] = {.lex_state = 28, .external_lex_state = 6},
  [1650] = {.lex_state = 28, .external_lex_state = 6},
  [1651] = {.lex_state = 77, .external_lex_state = 12},
  [1652] = {.lex_state = 28, .external_lex_state = 6},
  [1653] = {.lex_state = 28, .external_lex_state = 6},
  [1654] = {.lex_state = 28, .external_lex_state = 6},
  [1655] = {.lex_state = 28, .external_lex_state = 8},
  [1656] = {.lex_state = 28, .external_lex_state = 6},
  [1657] = {.lex_state = 28, .external_lex_state = 6},
  [1658] = {.lex_state = 28, .external_lex_state = 6},
  [1659] = {.lex_state = 187, .external_lex_state = 6},
  [1660] = {.lex_state = 187, .external_lex_state = 6},
  [1661] = {.lex_state = 28, .external_lex_state = 6},
  [1662] = {.lex_state = 187, .external_lex_state = 6},
  [1663] = {.lex_state = 187, .external_lex_state = 6},
  [1664] = {.lex_state = 187, .external_lex_state = 6},
  [1665] = {.lex_state = 187, .external_lex_state = 6},
  [1666] = {.lex_state = 28, .external_lex_state = 8},
  [1667] = {.lex_state = 187, .external_lex_state = 6},
  [1668] = {.lex_state = 28, .external_lex_state = 8},
  [1669] = {.lex_state = 187, .external_lex_state = 6},
  [1670] = {.lex_state = 36, .external_lex_state = 15},
  [1671] = {.lex_state = 187, .external_lex_state = 6},
  [1672] = {.lex_state = 28, .external_lex_state = 6},
  [1673] = {.lex_state = 28, .external_lex_state = 8},
  [1674] = {.lex_state = 28, .external_lex_state = 6},
  [1675] = {.lex_state = 28, .external_lex_state = 8},
  [1676] = {.lex_state = 28, .external_lex_state = 6},
  [1677] = {.lex_state = 74, .external_lex_state = 10},
  [1678] = {.lex_state = 187, .external_lex_state = 8},
  [1679] = {.lex_state = 187, .external_lex_state = 6},
  [1680] = {.lex_state = 187, .external_lex_state = 6},
  [1681] = {.lex_state = 28, .external_lex_state = 6},
  [1682] = {.lex_state = 28, .external_lex_state = 8},
  [1683] = {.lex_state = 187, .external_lex_state = 6},
  [1684] = {.lex_state = 28, .external_lex_state = 8},
  [1685] = {.lex_state = 187, .external_lex_state = 6},
  [1686] = {.lex_state = 187, .external_lex_state = 6},
  [1687] = {.lex_state = 96, .external_lex_state = 2},
  [1688] = {.lex_state = 187, .external_lex_state = 6},
  [1689] = {.lex_state = 28, .external_lex_state = 6},
  [1690] = {.lex_state = 28, .external_lex_state = 8},
  [1691] = {.lex_state = 28, .external_lex_state = 8},
  [1692] = {.lex_state = 36, .external_lex_state = 15},
  [1693] = {.lex_state = 28, .external_lex_state = 8},
  [1694] = {.lex_state = 28, .external_lex_state = 8},
  [1695] = {.lex_state = 28, .external_lex_state = 8},
  [1696] = {.lex_state = 28, .external_lex_state = 8},
  [1697] = {.lex_state = 187, .external_lex_state = 6},
  [1698] = {.lex_state = 28, .external_lex_state = 8},
  [1699] = {.lex_state = 36, .external_lex_state = 10},
  [1700] = {.lex_state = 96, .external_lex_state = 16},
  [1701] = {.lex_state = 96, .external_lex_state = 16},
  [1702] = {.lex_state = 96, .external_lex_state = 16},
  [1703] = {.lex_state = 187, .external_lex_state = 6},
  [1704] = {.lex_state = 187, .external_lex_state = 6},
  [1705] = {.lex_state = 187, .external_lex_state = 6},
  [1706] = {.lex_state = 28, .external_lex_state = 8},
  [1707] = {.lex_state = 187, .external_lex_state = 8},
  [1708] = {.lex_state = 28, .external_lex_state = 8},
  [1709] = {.lex_state = 187, .external_lex_state = 6},
  [1710] = {.lex_state = 96, .external_lex_state = 16},
  [1711] = {.lex_state = 28, .external_lex_state = 8},
  [1712] = {.lex_state = 187, .external_lex_state = 6},
  [1713] = {.lex_state = 28, .external_lex_state = 8},
  [1714] = {.lex_state = 96, .external_lex_state = 16},
  [1715] = {.lex_state = 187, .external_lex_state = 8},
  [1716] = {.lex_state = 187, .external_lex_state = 6},
  [1717] = {.lex_state = 75, .external_lex_state = 10},
  [1718] = {.lex_state = 187, .external_lex_state = 8},
  [1719] = {.lex_state = 187, .external_lex_state = 8},
  [1720] = {.lex_state = 28, .external_lex_state = 8},
  [1721] = {.lex_state = 36, .external_lex_state = 15},
  [1722] = {.lex_state = 28, .external_lex_state = 8},
  [1723] = {.lex_state = 187, .external_lex_state = 8},
  [1724] = {.lex_state = 28, .external_lex_state = 8},
  [1725] = {.lex_state = 28, .external_lex_state = 8},
  [1726] = {.lex_state = 28, .external_lex_state = 8},
  [1727] = {.lex_state = 28, .external_lex_state = 6},
  [1728] = {.lex_state = 28, .external_lex_state = 8},
  [1729] = {.lex_state = 28, .external_lex_state = 8},
  [1730] = {.lex_state = 187, .external_lex_state = 6},
  [1731] = {.lex_state = 28, .external_lex_state = 8},
  [1732] = {.lex_state = 28, .external_lex_state = 8},
  [1733] = {.lex_state = 28, .external_lex_state = 8},
  [1734] = {.lex_state = 28, .external_lex_state = 8},
  [1735] = {.lex_state = 28, .external_lex_state = 8},
  [1736] = {.lex_state = 36, .external_lex_state = 15},
  [1737] = {.lex_state = 36, .external_lex_state = 10},
  [1738] = {.lex_state = 28, .external_lex_state = 8},
  [1739] = {.lex_state = 28, .external_lex_state = 8},
  [1740] = {.lex_state = 28, .external_lex_state = 8},
  [1741] = {.lex_state = 187, .external_lex_state = 6},
  [1742] = {.lex_state = 187, .external_lex_state = 8},
  [1743] = {.lex_state = 28, .external_lex_state = 8},
  [1744] = {.lex_state = 28, .external_lex_state = 8},
  [1745] = {.lex_state = 187, .external_lex_state = 8},
  [1746] = {.lex_state = 28, .external_lex_state = 8},
  [1747] = {.lex_state = 75, .external_lex_state = 10},
  [1748] = {.lex_state = 28, .external_lex_state = 8},
  [1749] = {.lex_state = 187, .external_lex_state = 6},
  [1750] = {.lex_state = 28, .external_lex_state = 8},
  [1751] = {.lex_state = 28, .external_lex_state = 8},
  [1752] = {.lex_state = 187, .external_lex_state = 6},
  [1753] = {.lex_state = 75, .external_lex_state = 10},
  [1754] = {.lex_state = 75, .external_lex_state = 10},
  [1755] = {.lex_state = 199, .external_lex_state = 17},
  [1756] = {.lex_state = 187, .external_lex_state = 8},
  [1757] = {.lex_state = 28, .external_lex_state = 6},
  [1758] = {.lex_state = 28, .external_lex_state = 6},
  [1759] = {.lex_state = 187, .external_lex_state = 6},
  [1760] = {.lex_state = 187, .external_lex_state = 8},
  [1761] = {.lex_state = 90, .external_lex_state = 17},
  [1762] = {.lex_state = 187, .external_lex_state = 6},
  [1763] = {.lex_state = 28, .external_lex_state = 6},
  [1764] = {.lex_state = 187, .external_lex_state = 8},
  [1765] = {.lex_state = 28, .external_lex_state = 6},
  [1766] = {.lex_state = 28, .external_lex_state = 6},
  [1767] = {.lex_state = 28, .external_lex_state = 6},
  [1768] = {.lex_state = 28, .external_lex_state = 6},
  [1769] = {.lex_state = 28, .external_lex_state = 6},
  [1770] = {.lex_state = 28, .external_lex_state = 6},
  [1771] = {.lex_state = 187, .external_lex_state = 6},
  [1772] = {.lex_state = 96, .external_lex_state = 2},
  [1773] = {.lex_state = 187, .external_lex_state = 8},
  [1774] = {.lex_state = 36, .external_lex_state = 15},
  [1775] = {.lex_state = 96, .external_lex_state = 16},
  [1776] = {.lex_state = 90, .external_lex_state = 17},
  [1777] = {.lex_state = 28, .external_lex_state = 6},
  [1778] = {.lex_state = 28, .external_lex_state = 6},
  [1779] = {.lex_state = 96, .external_lex_state = 16},
  [1780] = {.lex_state = 96, .external_lex_state = 16},
  [1781] = {.lex_state = 36, .external_lex_state = 15},
  [1782] = {.lex_state = 28, .external_lex_state = 6},
  [1783] = {.lex_state = 36, .external_lex_state = 15},
  [1784] = {.lex_state = 99},
  [1785] = {.lex_state = 36, .external_lex_state = 15},
  [1786] = {.lex_state = 99},
  [1787] = {.lex_state = 28, .external_lex_state = 6},
  [1788] = {.lex_state = 28, .external_lex_state = 6},
  [1789] = {.lex_state = 28, .external_lex_state = 6},
  [1790] = {.lex_state = 28, .external_lex_state = 6},
  [1791] = {.lex_state = 36, .external_lex_state = 15},
  [1792] = {.lex_state = 36, .external_lex_state = 15},
  [1793] = {.lex_state = 28, .external_lex_state = 6},
  [1794] = {.lex_state = 28, .external_lex_state = 6},
  [1795] = {.lex_state = 28, .external_lex_state = 6},
  [1796] = {.lex_state = 96, .external_lex_state = 16},
  [1797] = {.lex_state = 96, .external_lex_state = 16},
  [1798] = {.lex_state = 28, .external_lex_state = 6},
  [1799] = {.lex_state = 28, .external_lex_state = 6},
  [1800] = {.lex_state = 187, .external_lex_state = 8},
  [1801] = {.lex_state = 96, .external_lex_state = 16},
  [1802] = {.lex_state = 96, .external_lex_state = 16},
  [1803] = {.lex_state = 96, .external_lex_state = 16},
  [1804] = {.lex_state = 96, .external_lex_state = 16},
  [1805] = {.lex_state = 96, .external_lex_state = 16},
  [1806] = {.lex_state = 28, .external_lex_state = 6},
  [1807] = {.lex_state = 36, .external_lex_state = 15},
  [1808] = {.lex_state = 36, .external_lex_state = 15},
  [1809] = {.lex_state = 28, .external_lex_state = 6},
  [1810] = {.lex_state = 187, .external_lex_state = 8},
  [1811] = {.lex_state = 96, .external_lex_state = 16},
  [1812] = {.lex_state = 96, .external_lex_state = 16},
  [1813] = {.lex_state = 28, .external_lex_state = 6},
  [1814] = {.lex_state = 96, .external_lex_state = 16},
  [1815] = {.lex_state = 187, .external_lex_state = 8},
  [1816] = {.lex_state = 96, .external_lex_state = 16},
  [1817] = {.lex_state = 28, .external_lex_state = 6},
  [1818] = {.lex_state = 36, .external_lex_state = 15},
  [1819] = {.lex_state = 28, .external_lex_state = 6},
  [1820] = {.lex_state = 96, .external_lex_state = 16},
  [1821] = {.lex_state = 96, .external_lex_state = 16},
  [1822] = {.lex_state = 96, .external_lex_state = 16},
  [1823] = {.lex_state = 96, .external_lex_state = 16},
  [1824] = {.lex_state = 96, .external_lex_state = 16},
  [1825] = {.lex_state = 96, .external_lex_state = 16},
  [1826] = {.lex_state = 36, .external_lex_state = 15},
  [1827] = {.lex_state = 36, .external_lex_state = 15},
  [1828] = {.lex_state = 36, .external_lex_state = 15},
  [1829] = {.lex_state = 36, .external_lex_state = 15},
  [1830] = {.lex_state = 96, .external_lex_state = 16},
  [1831] = {.lex_state = 28, .external_lex_state = 6},
  [1832] = {.lex_state = 28, .external_lex_state = 6},
  [1833] = {.lex_state = 36, .external_lex_state = 15},
  [1834] = {.lex_state = 28, .external_lex_state = 6},
  [1835] = {.lex_state = 28, .external_lex_state = 6},
  [1836] = {.lex_state = 36, .external_lex_state = 15},
  [1837] = {.lex_state = 90, .external_lex_state = 17},
  [1838] = {.lex_state = 28, .external_lex_state = 6},
  [1839] = {.lex_state = 28, .external_lex_state = 6},
  [1840] = {.lex_state = 28, .external_lex_state = 6},
  [1841] = {.lex_state = 99},
  [1842] = {.lex_state = 96, .external_lex_state = 16},
  [1843] = {.lex_state = 36, .external_lex_state = 15},
  [1844] = {.lex_state = 96, .external_lex_state = 16},
  [1845] = {.lex_state = 187, .external_lex_state = 6},
  [1846] = {.lex_state = 187, .external_lex_state = 8},
  [1847] = {.lex_state = 187, .external_lex_state = 8},
  [1848] = {.lex_state = 187, .external_lex_state = 8},
  [1849] = {.lex_state = 187, .external_lex_state = 8},
  [1850] = {.lex_state = 187, .external_lex_state = 8},
  [1851] = {.lex_state = 96, .external_lex_state = 16},
  [1852] = {.lex_state = 36, .external_lex_state = 15},
  [1853] = {.lex_state = 36, .external_lex_state = 15},
  [1854] = {.lex_state = 36, .external_lex_state = 15},
  [1855] = {.lex_state = 187, .external_lex_state = 8},
  [1856] = {.lex_state = 187, .external_lex_state = 8},
  [1857] = {.lex_state = 99},
  [1858] = {.lex_state = 96, .external_lex_state = 16},
  [1859] = {.lex_state = 96, .external_lex_state = 16},
  [1860] = {.lex_state = 99},
  [1861] = {.lex_state = 99},
  [1862] = {.lex_state = 96, .external_lex_state = 16},
  [1863] = {.lex_state = 28, .external_lex_state = 6},
  [1864] = {.lex_state = 28, .external_lex_state = 6},
  [1865] = {.lex_state = 28, .external_lex_state = 6},
  [1866] = {.lex_state = 96, .external_lex_state = 2},
  [1867] = {.lex_state = 28, .external_lex_state = 6},
  [1868] = {.lex_state = 28, .external_lex_state = 6},
  [1869] = {.lex_state = 187, .external_lex_state = 8},
  [1870] = {.lex_state = 187, .external_lex_state = 8},
  [1871] = {.lex_state = 28, .external_lex_state = 6},
  [1872] = {.lex_state = 187, .external_lex_state = 8},
  [1873] = {.lex_state = 187, .external_lex_state = 8},
  [1874] = {.lex_state = 187, .external_lex_state = 8},
  [1875] = {.lex_state = 28, .external_lex_state = 6},
  [1876] = {.lex_state = 36, .external_lex_state = 15},
  [1877] = {.lex_state = 36, .external_lex_state = 15},
  [1878] = {.lex_state = 36, .external_lex_state = 15},
  [1879] = {.lex_state = 187, .external_lex_state = 8},
  [1880] = {.lex_state = 36, .external_lex_state = 15},
  [1881] = {.lex_state = 99},
  [1882] = {.lex_state = 36, .external_lex_state = 15},
  [1883] = {.lex_state = 99},
  [1884] = {.lex_state = 187, .external_lex_state = 8},
  [1885] = {.lex_state = 187, .external_lex_state = 8},
  [1886] = {.lex_state = 187, .external_lex_state = 8},
  [1887] = {.lex_state = 187, .external_lex_state = 8},
  [1888] = {.lex_state = 36, .external_lex_state = 15},
  [1889] = {.lex_state = 187, .external_lex_state = 6},
  [1890] = {.lex_state = 99},
  [1891] = {.lex_state = 96, .external_lex_state = 2},
  [1892] = {.lex_state = 99},
  [1893] = {.lex_state = 28, .external_lex_state = 6},
  [1894] = {.lex_state = 28, .external_lex_state = 6},
  [1895] = {.lex_state = 36, .external_lex_state = 10},
  [1896] = {.lex_state = 36, .external_lex_state = 15},
  [1897] = {.lex_state = 187, .external_lex_state = 8},
  [1898] = {.lex_state = 99},
  [1899] = {.lex_state = 99},
  [1900] = {.lex_state = 28, .external_lex_state = 6},
  [1901] = {.lex_state = 187, .external_lex_state = 8},
  [1902] = {.lex_state = 187, .external_lex_state = 8},
  [1903] = {.lex_state = 187, .external_lex_state = 8},
  [1904] = {.lex_state = 28, .external_lex_state = 6},
  [1905] = {.lex_state = 187, .external_lex_state = 8},
  [1906] = {.lex_state = 187, .external_lex_state = 6},
  [1907] = {.lex_state = 187, .external_lex_state = 8},
  [1908] = {.lex_state = 28, .external_lex_state = 6},
  [1909] = {.lex_state = 187, .external_lex_state = 8},
  [1910] = {.lex_state = 28, .external_lex_state = 6},
  [1911] = {.lex_state = 28, .external_lex_state = 6},
  [1912] = {.lex_state = 187, .external_lex_state = 8},
  [1913] = {.lex_state = 96},
  [1914] = {.lex_state = 96, .external_lex_state = 2},
  [1915] = {.lex_state = 96, .external_lex_state = 18},
  [1916] = {.lex_state = 78},
  [1917] = {.lex_state = 36, .external_lex_state = 10},
  [1918] = {.lex_state = 187, .external_lex_state = 6},
  [1919] = {.lex_state = 96},
  [1920] = {.lex_state = 96},
  [1921] = {.lex_state = 91, .external_lex_state = 17},
  [1922] = {.lex_state = 187, .external_lex_state = 6},
  [1923] = {.lex_state = 96, .external_lex_state = 2},
  [1924] = {.lex_state = 187, .external_lex_state = 6},
  [1925] = {.lex_state = 96},
  [1926] = {.lex_state = 187, .external_lex_state = 6},
  [1927] = {.lex_state = 90, .external_lex_state = 17},
  [1928] = {.lex_state = 90, .external_lex_state = 17},
  [1929] = {.lex_state = 36, .external_lex_state = 10},
  [1930] = {.lex_state = 36, .external_lex_state = 10},
  [1931] = {.lex_state = 187, .external_lex_state = 6},
  [1932] = {.lex_state = 187, .external_lex_state = 6},
  [1933] = {.lex_state = 90, .external_lex_state = 17},
  [1934] = {.lex_state = 90, .external_lex_state = 17},
  [1935] = {.lex_state = 96, .external_lex_state = 18},
  [1936] = {.lex_state = 96},
  [1937] = {.lex_state = 199},
  [1938] = {.lex_state = 90, .external_lex_state = 17},
  [1939] = {.lex_state = 36, .external_lex_state = 10},
  [1940] = {.lex_state = 90, .external_lex_state = 17},
  [1941] = {.lex_state = 90, .external_lex_state = 17},
  [1942] = {.lex_state = 90, .external_lex_state = 17},
  [1943] = {.lex_state = 90, .external_lex_state = 17},
  [1944] = {.lex_state = 96, .external_lex_state = 2},
  [1945] = {.lex_state = 36, .external_lex_state = 10},
  [1946] = {.lex_state = 187, .external_lex_state = 6},
  [1947] = {.lex_state = 187, .external_lex_state = 6},
  [1948] = {.lex_state = 96, .external_lex_state = 2},
  [1949] = {.lex_state = 96, .external_lex_state = 18},
  [1950] = {.lex_state = 187, .external_lex_state = 6},
  [1951] = {.lex_state = 187, .external_lex_state = 6},
  [1952] = {.lex_state = 96, .external_lex_state = 2},
  [1953] = {.lex_state = 187, .external_lex_state = 6},
  [1954] = {.lex_state = 187, .external_lex_state = 6},
  [1955] = {.lex_state = 187, .external_lex_state = 6},
  [1956] = {.lex_state = 187, .external_lex_state = 6},
  [1957] = {.lex_state = 187, .external_lex_state = 8},
  [1958] = {.lex_state = 36, .external_lex_state = 10},
  [1959] = {.lex_state = 96, .external_lex_state = 2},
  [1960] = {.lex_state = 96, .external_lex_state = 2},
  [1961] = {.lex_state = 36, .external_lex_state = 10},
  [1962] = {.lex_state = 96, .external_lex_state = 2},
  [1963] = {.lex_state = 187, .external_lex_state = 6},
  [1964] = {.lex_state = 96, .external_lex_state = 18},
  [1965] = {.lex_state = 92, .external_lex_state = 19},
  [1966] = {.lex_state = 96},
  [1967] = {.lex_state = 187, .external_lex_state = 6},
  [1968] = {.lex_state = 187, .external_lex_state = 6},
  [1969] = {.lex_state = 187, .external_lex_state = 6},
  [1970] = {.lex_state = 187, .external_lex_state = 6},
  [1971] = {.lex_state = 90, .external_lex_state = 17},
  [1972] = {.lex_state = 187, .external_lex_state = 6},
  [1973] = {.lex_state = 90, .external_lex_state = 17},
  [1974] = {.lex_state = 96, .external_lex_state = 2},
  [1975] = {.lex_state = 90, .external_lex_state = 17},
  [1976] = {.lex_state = 90, .external_lex_state = 17},
  [1977] = {.lex_state = 96, .external_lex_state = 2},
  [1978] = {.lex_state = 90, .external_lex_state = 17},
  [1979] = {.lex_state = 90, .external_lex_state = 17},
  [1980] = {.lex_state = 96, .external_lex_state = 2},
  [1981] = {.lex_state = 96, .external_lex_state = 2},
  [1982] = {.lex_state = 96},
  [1983] = {.lex_state = 187, .external_lex_state = 6},
  [1984] = {.lex_state = 187, .external_lex_state = 6},
  [1985] = {.lex_state = 90, .external_lex_state = 17},
  [1986] = {.lex_state = 96, .external_lex_state = 2},
  [1987] = {.lex_state = 187, .external_lex_state = 6},
  [1988] = {.lex_state = 90, .external_lex_state = 17},
  [1989] = {.lex_state = 96},
  [1990] = {.lex_state = 187, .external_lex_state = 6},
  [1991] = {.lex_state = 96},
  [1992] = {.lex_state = 96},
  [1993] = {.lex_state = 187, .external_lex_state = 6},
  [1994] = {.lex_state = 187, .external_lex_state = 6},
  [1995] = {.lex_state = 90, .external_lex_state = 17},
  [1996] = {.lex_state = 91},
  [1997] = {.lex_state = 90, .external_lex_state = 17},
  [1998] = {.lex_state = 36, .external_lex_state = 10},
  [1999] = {.lex_state = 96, .external_lex_state = 2},
  [2000] = {.lex_state = 90, .external_lex_state = 17},
  [2001] = {.lex_state = 90, .external_lex_state = 17},
  [2002] = {.lex_state = 96, .external_lex_state = 2},
  [2003] = {.lex_state = 96, .external_lex_state = 2},
  [2004] = {.lex_state = 96, .external_lex_state = 2},
  [2005] = {.lex_state = 187, .external_lex_state = 6},
  [2006] = {.lex_state = 187, .external_lex_state = 6},
  [2007] = {.lex_state = 187, .external_lex_state = 8},
  [2008] = {.lex_state = 187, .external_lex_state = 6},
  [2009] = {.lex_state = 187, .external_lex_state = 6},
  [2010] = {.lex_state = 187, .external_lex_state = 8},
  [2011] = {.lex_state = 187, .external_lex_state = 8},
  [2012] = {.lex_state = 187, .external_lex_state = 8},
  [2013] = {.lex_state = 96, .external_lex_state = 2},
  [2014] = {.lex_state = 187, .external_lex_state = 8},
  [2015] = {.lex_state = 96, .external_lex_state = 2},
  [2016] = {.lex_state = 187, .external_lex_state = 8},
  [2017] = {.lex_state = 187, .external_lex_state = 8},
  [2018] = {.lex_state = 96, .external_lex_state = 2},
  [2019] = {.lex_state = 187, .external_lex_state = 8},
  [2020] = {.lex_state = 187, .external_lex_state = 8},
  [2021] = {.lex_state = 90, .external_lex_state = 17},
  [2022] = {.lex_state = 187, .external_lex_state = 8},
  [2023] = {.lex_state = 90, .external_lex_state = 17},
  [2024] = {.lex_state = 96},
  [2025] = {.lex_state = 187, .external_lex_state = 8},
  [2026] = {.lex_state = 187, .external_lex_state = 6},
  [2027] = {.lex_state = 96, .external_lex_state = 2},
  [2028] = {.lex_state = 36, .external_lex_state = 10},
  [2029] = {.lex_state = 96, .external_lex_state = 2},
  [2030] = {.lex_state = 187, .external_lex_state = 8},
  [2031] = {.lex_state = 187, .external_lex_state = 6},
  [2032] = {.lex_state = 96, .external_lex_state = 2},
  [2033] = {.lex_state = 187, .external_lex_state = 8},
  [2034] = {.lex_state = 187, .external_lex_state = 8},
  [2035] = {.lex_state = 187, .external_lex_state = 6},
  [2036] = {.lex_state = 96, .external_lex_state = 18},
  [2037] = {.lex_state = 187, .external_lex_state = 8},
  [2038] = {.lex_state = 36, .external_lex_state = 10},
  [2039] = {.lex_state = 96, .external_lex_state = 18},
  [2040] = {.lex_state = 187, .external_lex_state = 6},
  [2041] = {.lex_state = 187, .external_lex_state = 6},
  [2042] = {.lex_state = 187, .external_lex_state = 8},
  [2043] = {.lex_state = 187, .external_lex_state = 8},
  [2044] = {.lex_state = 96, .external_lex_state = 2},
  [2045] = {.lex_state = 187, .external_lex_state = 6},
  [2046] = {.lex_state = 96},
  [2047] = {.lex_state = 199},
  [2048] = {.lex_state = 96, .external_lex_state = 2},
  [2049] = {.lex_state = 36, .external_lex_state = 10},
  [2050] = {.lex_state = 96, .external_lex_state = 2},
  [2051] = {.lex_state = 90, .external_lex_state = 17},
  [2052] = {.lex_state = 96, .external_lex_state = 2},
  [2053] = {.lex_state = 96, .external_lex_state = 2},
  [2054] = {.lex_state = 187, .external_lex_state = 6},
  [2055] = {.lex_state = 90, .external_lex_state = 17},
  [2056] = {.lex_state = 96, .external_lex_state = 2},
  [2057] = {.lex_state = 36, .external_lex_state = 10},
  [2058] = {.lex_state = 96, .external_lex_state = 2},
  [2059] = {.lex_state = 187, .external_lex_state = 8},
  [2060] = {.lex_state = 187, .external_lex_state = 8},
  [2061] = {.lex_state = 36, .external_lex_state = 10},
  [2062] = {.lex_state = 96, .external_lex_state = 2},
  [2063] = {.lex_state = 90, .external_lex_state = 17},
  [2064] = {.lex_state = 187, .external_lex_state = 6},
  [2065] = {.lex_state = 36, .external_lex_state = 10},
  [2066] = {.lex_state = 187, .external_lex_state = 6},
  [2067] = {.lex_state = 96, .external_lex_state = 18},
  [2068] = {.lex_state = 90, .external_lex_state = 17},
  [2069] = {.lex_state = 187, .external_lex_state = 6},
  [2070] = {.lex_state = 187, .external_lex_state = 6},
  [2071] = {.lex_state = 36, .external_lex_state = 10},
  [2072] = {.lex_state = 187, .external_lex_state = 6},
  [2073] = {.lex_state = 187, .external_lex_state = 6},
  [2074] = {.lex_state = 187, .external_lex_state = 6},
  [2075] = {.lex_state = 187, .external_lex_state = 8},
  [2076] = {.lex_state = 96, .external_lex_state = 2},
  [2077] = {.lex_state = 187, .external_lex_state = 8},
  [2078] = {.lex_state = 187, .external_lex_state = 6},
  [2079] = {.lex_state = 96, .external_lex_state = 18},
  [2080] = {.lex_state = 96, .external_lex_state = 2},
  [2081] = {.lex_state = 96, .external_lex_state = 2},
  [2082] = {.lex_state = 36, .external_lex_state = 10},
  [2083] = {.lex_state = 187, .external_lex_state = 8},
  [2084] = {.lex_state = 187, .external_lex_state = 6},
  [2085] = {.lex_state = 187, .external_lex_state = 8},
  [2086] = {.lex_state = 187, .external_lex_state = 6},
  [2087] = {.lex_state = 187, .external_lex_state = 8},
  [2088] = {.lex_state = 91, .external_lex_state = 17},
  [2089] = {.lex_state = 96, .external_lex_state = 2},
  [2090] = {.lex_state = 96, .external_lex_state = 18},
  [2091] = {.lex_state = 187, .external_lex_state = 8},
  [2092] = {.lex_state = 187, .external_lex_state = 6},
  [2093] = {.lex_state = 96},
  [2094] = {.lex_state = 91, .external_lex_state = 17},
  [2095] = {.lex_state = 91, .external_lex_state = 17},
  [2096] = {.lex_state = 91, .external_lex_state = 17},
  [2097] = {.lex_state = 187, .external_lex_state = 6},
  [2098] = {.lex_state = 91, .external_lex_state = 17},
  [2099] = {.lex_state = 187, .external_lex_state = 6},
  [2100] = {.lex_state = 96, .external_lex_state = 2},
  [2101] = {.lex_state = 90},
  [2102] = {.lex_state = 187, .external_lex_state = 6},
  [2103] = {.lex_state = 96},
  [2104] = {.lex_state = 187, .external_lex_state = 6},
  [2105] = {.lex_state = 187, .external_lex_state = 6},
  [2106] = {.lex_state = 187, .external_lex_state = 6},
  [2107] = {.lex_state = 91, .external_lex_state = 17},
  [2108] = {.lex_state = 94, .external_lex_state = 20},
  [2109] = {.lex_state = 187, .external_lex_state = 6},
  [2110] = {.lex_state = 187, .external_lex_state = 6},
  [2111] = {.lex_state = 187, .external_lex_state = 6},
  [2112] = {.lex_state = 96},
  [2113] = {.lex_state = 90},
  [2114] = {.lex_state = 91, .external_lex_state = 17},
  [2115] = {.lex_state = 91, .external_lex_state = 17},
  [2116] = {.lex_state = 96},
  [2117] = {.lex_state = 94, .external_lex_state = 20},
  [2118] = {.lex_state = 93, .external_lex_state = 20},
  [2119] = {.lex_state = 96},
  [2120] = {.lex_state = 187, .external_lex_state = 6},
  [2121] = {.lex_state = 187, .external_lex_state = 6},
  [2122] = {.lex_state = 187, .external_lex_state = 6},
  [2123] = {.lex_state = 96},
  [2124] = {.lex_state = 93, .external_lex_state = 20},
  [2125] = {.lex_state = 96},
  [2126] = {.lex_state = 187, .external_lex_state = 6},
  [2127] = {.lex_state = 187, .external_lex_state = 6},
  [2128] = {.lex_state = 90},
  [2129] = {.lex_state = 90},
  [2130] = {.lex_state = 91, .external_lex_state = 17},
  [2131] = {.lex_state = 96, .external_lex_state = 2},
  [2132] = {.lex_state = 90},
  [2133] = {.lex_state = 187, .external_lex_state = 6},
  [2134] = {.lex_state = 187, .external_lex_state = 6},
  [2135] = {.lex_state = 187, .external_lex_state = 6},
  [2136] = {.lex_state = 187, .external_lex_state = 6},
  [2137] = {.lex_state = 96, .external_lex_state = 2},
  [2138] = {.lex_state = 187, .external_lex_state = 6},
  [2139] = {.lex_state = 96},
  [2140] = {.lex_state = 187, .external_lex_state = 6},
  [2141] = {.lex_state = 187, .external_lex_state = 6},
  [2142] = {.lex_state = 91, .external_lex_state = 17},
  [2143] = {.lex_state = 187, .external_lex_state = 6},
  [2144] = {.lex_state = 187, .external_lex_state = 6},
  [2145] = {.lex_state = 187, .external_lex_state = 6},
  [2146] = {.lex_state = 92, .external_lex_state = 14},
  [2147] = {.lex_state = 96},
  [2148] = {.lex_state = 96},
  [2149] = {.lex_state = 94, .external_lex_state = 20},
  [2150] = {.lex_state = 91, .external_lex_state = 17},
  [2151] = {.lex_state = 96},
  [2152] = {.lex_state = 91, .external_lex_state = 17},
  [2153] = {.lex_state = 91},
  [2154] = {.lex_state = 187, .external_lex_state = 6},
  [2155] = {.lex_state = 187, .external_lex_state = 6},
  [2156] = {.lex_state = 187, .external_lex_state = 6},
  [2157] = {.lex_state = 96},
  [2158] = {.lex_state = 91, .external_lex_state = 17},
  [2159] = {.lex_state = 92, .external_lex_state = 19},
  [2160] = {.lex_state = 187, .external_lex_state = 6},
  [2161] = {.lex_state = 187, .external_lex_state = 6},
  [2162] = {.lex_state = 96},
  [2163] = {.lex_state = 187, .external_lex_state = 6},
  [2164] = {.lex_state = 91, .external_lex_state = 17},
  [2165] = {.lex_state = 187, .external_lex_state = 6},
  [2166] = {.lex_state = 187, .external_lex_state = 6},
  [2167] = {.lex_state = 187, .external_lex_state = 6},
  [2168] = {.lex_state = 91, .external_lex_state = 17},
  [2169] = {.lex_state = 187, .external_lex_state = 6},
  [2170] = {.lex_state = 187, .external_lex_state = 6},
  [2171] = {.lex_state = 187, .external_lex_state = 6},
  [2172] = {.lex_state = 187, .external_lex_state = 6},
  [2173] = {.lex_state = 90},
  [2174] = {.lex_state = 96},
  [2175] = {.lex_state = 91, .external_lex_state = 17},
  [2176] = {.lex_state = 187, .external_lex_state = 6},
  [2177] = {.lex_state = 91},
  [2178] = {.lex_state = 96},
  [2179] = {.lex_state = 187, .external_lex_state = 6},
  [2180] = {.lex_state = 94, .external_lex_state = 20},
  [2181] = {.lex_state = 96},
  [2182] = {.lex_state = 187, .external_lex_state = 6},
  [2183] = {.lex_state = 93, .external_lex_state = 20},
  [2184] = {.lex_state = 93, .external_lex_state = 20},
  [2185] = {.lex_state = 187, .external_lex_state = 6},
  [2186] = {.lex_state = 92, .external_lex_state = 19},
  [2187] = {.lex_state = 92, .external_lex_state = 14},
  [2188] = {.lex_state = 96},
  [2189] = {.lex_state = 91, .external_lex_state = 17},
  [2190] = {.lex_state = 90},
  [2191] = {.lex_state = 187, .external_lex_state = 6},
  [2192] = {.lex_state = 187, .external_lex_state = 6},
  [2193] = {.lex_state = 96},
  [2194] = {.lex_state = 91, .external_lex_state = 17},
  [2195] = {.lex_state = 91, .external_lex_state = 17},
  [2196] = {.lex_state = 91, .external_lex_state = 17},
  [2197] = {.lex_state = 91, .external_lex_state = 17},
  [2198] = {.lex_state = 96},
  [2199] = {.lex_state = 91, .external_lex_state = 17},
  [2200] = {.lex_state = 96},
  [2201] = {.lex_state = 92, .external_lex_state = 19},
  [2202] = {.lex_state = 91, .external_lex_state = 17},
  [2203] = {.lex_state = 199},
  [2204] = {.lex_state = 90},
  [2205] = {.lex_state = 91, .external_lex_state = 17},
  [2206] = {.lex_state = 187, .external_lex_state = 6},
  [2207] = {.lex_state = 91, .external_lex_state = 17},
  [2208] = {.lex_state = 91, .external_lex_state = 17},
  [2209] = {.lex_state = 91, .external_lex_state = 17},
  [2210] = {.lex_state = 187, .external_lex_state = 6},
  [2211] = {.lex_state = 91, .external_lex_state = 17},
  [2212] = {.lex_state = 91, .external_lex_state = 17},
  [2213] = {.lex_state = 187, .external_lex_state = 6},
  [2214] = {.lex_state = 187, .external_lex_state = 6},
  [2215] = {.lex_state = 97, .external_lex_state = 12},
  [2216] = {.lex_state = 92, .external_lex_state = 19},
  [2217] = {.lex_state = 97, .external_lex_state = 12},
  [2218] = {.lex_state = 92, .external_lex_state = 14},
  [2219] = {.lex_state = 97, .external_lex_state = 12},
  [2220] = {.lex_state = 97, .external_lex_state = 12},
  [2221] = {.lex_state = 96},
  [2222] = {.lex_state = 94, .external_lex_state = 20},
  [2223] = {.lex_state = 94, .external_lex_state = 20},
  [2224] = {.lex_state = 92, .external_lex_state = 19},
  [2225] = {.lex_state = 97, .external_lex_state = 12},
  [2226] = {.lex_state = 97, .external_lex_state = 12},
  [2227] = {.lex_state = 94, .external_lex_state = 20},
  [2228] = {.lex_state = 94, .external_lex_state = 20},
  [2229] = {.lex_state = 97, .external_lex_state = 12},
  [2230] = {.lex_state = 92, .external_lex_state = 19},
  [2231] = {.lex_state = 92, .external_lex_state = 19},
  [2232] = {.lex_state = 92, .external_lex_state = 19},
  [2233] = {.lex_state = 97, .external_lex_state = 12},
  [2234] = {.lex_state = 92, .external_lex_state = 19},
  [2235] = {.lex_state = 97, .external_lex_state = 12},
  [2236] = {.lex_state = 92, .external_lex_state = 19},
  [2237] = {.lex_state = 97, .external_lex_state = 12},
  [2238] = {.lex_state = 97, .external_lex_state = 12},
  [2239] = {.lex_state = 97, .external_lex_state = 12},
  [2240] = {.lex_state = 97, .external_lex_state = 12},
  [2241] = {.lex_state = 94, .external_lex_state = 20},
  [2242] = {.lex_state = 97, .external_lex_state = 12},
  [2243] = {.lex_state = 97, .external_lex_state = 12},
  [2244] = {.lex_state = 94, .external_lex_state = 20},
  [2245] = {.lex_state = 92, .external_lex_state = 19},
  [2246] = {.lex_state = 96},
  [2247] = {.lex_state = 92, .external_lex_state = 19},
  [2248] = {.lex_state = 94, .external_lex_state = 20},
  [2249] = {.lex_state = 92, .external_lex_state = 19},
  [2250] = {.lex_state = 92, .external_lex_state = 19},
  [2251] = {.lex_state = 97, .external_lex_state = 12},
  [2252] = {.lex_state = 97, .external_lex_state = 12},
  [2253] = {.lex_state = 96, .external_lex_state = 13},
  [2254] = {.lex_state = 97, .external_lex_state = 12},
  [2255] = {.lex_state = 97, .external_lex_state = 12},
  [2256] = {.lex_state = 94, .external_lex_state = 20},
  [2257] = {.lex_state = 97, .external_lex_state = 12},
  [2258] = {.lex_state = 97, .external_lex_state = 12},
  [2259] = {.lex_state = 97, .external_lex_state = 12},
  [2260] = {.lex_state = 97, .external_lex_state = 12},
  [2261] = {.lex_state = 94, .external_lex_state = 20},
  [2262] = {.lex_state = 97, .external_lex_state = 12},
  [2263] = {.lex_state = 94, .external_lex_state = 20},
  [2264] = {.lex_state = 97, .external_lex_state = 12},
  [2265] = {.lex_state = 97, .external_lex_state = 12},
  [2266] = {.lex_state = 97, .external_lex_state = 12},
  [2267] = {.lex_state = 94, .external_lex_state = 20},
  [2268] = {.lex_state = 94, .external_lex_state = 20},
  [2269] = {.lex_state = 94, .external_lex_state = 20},
  [2270] = {.lex_state = 94, .external_lex_state = 20},
  [2271] = {.lex_state = 94, .external_lex_state = 20},
  [2272] = {.lex_state = 94, .external_lex_state = 20},
  [2273] = {.lex_state = 94, .external_lex_state = 20},
  [2274] = {.lex_state = 92, .external_lex_state = 19},
  [2275] = {.lex_state = 97, .external_lex_state = 12},
  [2276] = {.lex_state = 97, .external_lex_state = 12},
  [2277] = {.lex_state = 94, .external_lex_state = 20},
  [2278] = {.lex_state = 94, .external_lex_state = 20},
  [2279] = {.lex_state = 97, .external_lex_state = 12},
  [2280] = {.lex_state = 94, .external_lex_state = 20},
  [2281] = {.lex_state = 97, .external_lex_state = 12},
  [2282] = {.lex_state = 94, .external_lex_state = 20},
  [2283] = {.lex_state = 94, .external_lex_state = 20},
  [2284] = {.lex_state = 94, .external_lex_state = 20},
  [2285] = {.lex_state = 94, .external_lex_state = 20},
  [2286] = {.lex_state = 97, .external_lex_state = 12},
  [2287] = {.lex_state = 97, .external_lex_state = 12},
  [2288] = {.lex_state = 97, .external_lex_state = 12},
  [2289] = {.lex_state = 92, .external_lex_state = 19},
  [2290] = {.lex_state = 97, .external_lex_state = 12},
  [2291] = {.lex_state = 97, .external_lex_state = 12},
  [2292] = {.lex_state = 94, .external_lex_state = 20},
  [2293] = {.lex_state = 92, .external_lex_state = 19},
  [2294] = {.lex_state = 93, .external_lex_state = 12},
  [2295] = {.lex_state = 97, .external_lex_state = 12},
  [2296] = {.lex_state = 97, .external_lex_state = 12},
  [2297] = {.lex_state = 96, .external_lex_state = 13},
  [2298] = {.lex_state = 97, .external_lex_state = 12},
  [2299] = {.lex_state = 97, .external_lex_state = 12},
  [2300] = {.lex_state = 97, .external_lex_state = 12},
  [2301] = {.lex_state = 92, .external_lex_state = 19},
  [2302] = {.lex_state = 97, .external_lex_state = 12},
  [2303] = {.lex_state = 94, .external_lex_state = 12},
  [2304] = {.lex_state = 94, .external_lex_state = 20},
  [2305] = {.lex_state = 93, .external_lex_state = 12},
  [2306] = {.lex_state = 97, .external_lex_state = 12},
  [2307] = {.lex_state = 92, .external_lex_state = 19},
  [2308] = {.lex_state = 92, .external_lex_state = 19},
  [2309] = {.lex_state = 92, .external_lex_state = 19},
  [2310] = {.lex_state = 92, .external_lex_state = 19},
  [2311] = {.lex_state = 97, .external_lex_state = 12},
  [2312] = {.lex_state = 92, .external_lex_state = 19},
  [2313] = {.lex_state = 97, .external_lex_state = 12},
  [2314] = {.lex_state = 92, .external_lex_state = 19},
  [2315] = {.lex_state = 97, .external_lex_state = 12},
  [2316] = {.lex_state = 97, .external_lex_state = 12},
  [2317] = {.lex_state = 97, .external_lex_state = 12},
  [2318] = {.lex_state = 92, .external_lex_state = 19},
  [2319] = {.lex_state = 92, .external_lex_state = 19},
  [2320] = {.lex_state = 92, .external_lex_state = 19},
  [2321] = {.lex_state = 97, .external_lex_state = 12},
  [2322] = {.lex_state = 96},
  [2323] = {.lex_state = 97, .external_lex_state = 12},
  [2324] = {.lex_state = 97, .external_lex_state = 12},
  [2325] = {.lex_state = 97, .external_lex_state = 12},
  [2326] = {.lex_state = 94, .external_lex_state = 12},
  [2327] = {.lex_state = 97, .external_lex_state = 12},
  [2328] = {.lex_state = 97, .external_lex_state = 12},
  [2329] = {.lex_state = 199},
  [2330] = {.lex_state = 96, .external_lex_state = 13},
  [2331] = {.lex_state = 92, .external_lex_state = 19},
  [2332] = {.lex_state = 97, .external_lex_state = 12},
  [2333] = {.lex_state = 92, .external_lex_state = 19},
  [2334] = {.lex_state = 97, .external_lex_state = 12},
  [2335] = {.lex_state = 97, .external_lex_state = 12},
  [2336] = {.lex_state = 97, .external_lex_state = 12},
  [2337] = {.lex_state = 90},
  [2338] = {.lex_state = 97, .external_lex_state = 12},
  [2339] = {.lex_state = 93, .external_lex_state = 12},
  [2340] = {.lex_state = 97, .external_lex_state = 12},
  [2341] = {.lex_state = 93, .external_lex_state = 12},
  [2342] = {.lex_state = 97, .external_lex_state = 12},
  [2343] = {.lex_state = 96, .external_lex_state = 13},
  [2344] = {.lex_state = 97, .external_lex_state = 12},
  [2345] = {.lex_state = 92, .external_lex_state = 14},
  [2346] = {.lex_state = 199},
  [2347] = {.lex_state = 199},
  [2348] = {.lex_state = 96},
  [2349] = {.lex_state = 96},
  [2350] = {.lex_state = 199},
  [2351] = {.lex_state = 91},
  [2352] = {.lex_state = 199},
  [2353] = {.lex_state = 199},
  [2354] = {.lex_state = 96},
  [2355] = {.lex_state = 199},
  [2356] = {.lex_state = 199},
  [2357] = {.lex_state = 96},
  [2358] = {.lex_state = 199},
  [2359] = {.lex_state = 92, .external_lex_state = 14},
  [2360] = {.lex_state = 90},
  [2361] = {.lex_state = 90},
  [2362] = {.lex_state = 92, .external_lex_state = 14},
  [2363] = {.lex_state = 199},
  [2364] = {.lex_state = 96},
  [2365] = {.lex_state = 91},
  [2366] = {.lex_state = 96},
  [2367] = {.lex_state = 94, .external_lex_state = 12},
  [2368] = {.lex_state = 199},
  [2369] = {.lex_state = 96},
  [2370] = {.lex_state = 96},
  [2371] = {.lex_state = 91},
  [2372] = {.lex_state = 96},
  [2373] = {.lex_state = 96},
  [2374] = {.lex_state = 199},
  [2375] = {.lex_state = 96},
  [2376] = {.lex_state = 96},
  [2377] = {.lex_state = 96},
  [2378] = {.lex_state = 96},
  [2379] = {.lex_state = 96},
  [2380] = {.lex_state = 199},
  [2381] = {.lex_state = 199},
  [2382] = {.lex_state = 96},
  [2383] = {.lex_state = 91},
  [2384] = {.lex_state = 92, .external_lex_state = 14},
  [2385] = {.lex_state = 92, .external_lex_state = 14},
  [2386] = {.lex_state = 90},
  [2387] = {.lex_state = 91},
  [2388] = {.lex_state = 92, .external_lex_state = 14},
  [2389] = {.lex_state = 96},
  [2390] = {.lex_state = 92, .external_lex_state = 14},
  [2391] = {.lex_state = 199},
  [2392] = {.lex_state = 199},
  [2393] = {.lex_state = 96},
  [2394] = {.lex_state = 91},
  [2395] = {.lex_state = 92, .external_lex_state = 14},
  [2396] = {.lex_state = 96},
  [2397] = {.lex_state = 90},
  [2398] = {.lex_state = 96},
  [2399] = {.lex_state = 91},
  [2400] = {.lex_state = 96},
  [2401] = {.lex_state = 199},
  [2402] = {.lex_state = 91},
  [2403] = {.lex_state = 92, .external_lex_state = 14},
  [2404] = {.lex_state = 199},
  [2405] = {.lex_state = 91},
  [2406] = {.lex_state = 91},
  [2407] = {.lex_state = 199},
  [2408] = {.lex_state = 199},
  [2409] = {.lex_state = 91},
  [2410] = {.lex_state = 96},
  [2411] = {.lex_state = 199},
  [2412] = {.lex_state = 92, .external_lex_state = 14},
  [2413] = {.lex_state = 96},
  [2414] = {.lex_state = 96},
  [2415] = {.lex_state = 98, .external_lex_state = 14},
  [2416] = {.lex_state = 98, .external_lex_state = 14},
  [2417] = {.lex_state = 96},
  [2418] = {.lex_state = 96},
  [2419] = {.lex_state = 96},
  [2420] = {.lex_state = 96},
  [2421] = {.lex_state = 96},
  [2422] = {.lex_state = 96},
  [2423] = {.lex_state = 75, .external_lex_state = 15},
  [2424] = {.lex_state = 96},
  [2425] = {.lex_state = 75, .external_lex_state = 15},
  [2426] = {.lex_state = 96},
  [2427] = {.lex_state = 96},
  [2428] = {.lex_state = 96},
  [2429] = {.lex_state = 96},
  [2430] = {.lex_state = 96},
  [2431] = {.lex_state = 96},
  [2432] = {.lex_state = 96},
  [2433] = {.lex_state = 96},
  [2434] = {.lex_state = 96},
  [2435] = {.lex_state = 96},
  [2436] = {.lex_state = 96},
  [2437] = {.lex_state = 96},
  [2438] = {.lex_state = 96},
  [2439] = {.lex_state = 96},
  [2440] = {.lex_state = 96},
  [2441] = {.lex_state = 96},
  [2442] = {.lex_state = 96},
  [2443] = {.lex_state = 96},
  [2444] = {.lex_state = 96},
  [2445] = {.lex_state = 96},
  [2446] = {.lex_state = 96},
  [2447] = {.lex_state = 96},
  [2448] = {.lex_state = 96},
  [2449] = {.lex_state = 96},
  [2450] = {.lex_state = 96},
  [2451] = {.lex_state = 96},
  [2452] = {.lex_state = 96},
  [2453] = {.lex_state = 96},
  [2454] = {.lex_state = 96},
  [2455] = {.lex_state = 96},
  [2456] = {.lex_state = 96},
  [2457] = {.lex_state = 96},
  [2458] = {.lex_state = 96},
  [2459] = {.lex_state = 96},
  [2460] = {.lex_state = 96},
  [2461] = {.lex_state = 96},
  [2462] = {.lex_state = 96},
  [2463] = {.lex_state = 96},
  [2464] = {.lex_state = 27, .external_lex_state = 10},
  [2465] = {.lex_state = 96},
  [2466] = {.lex_state = 96},
  [2467] = {.lex_state = 96},
  [2468] = {.lex_state = 96},
  [2469] = {.lex_state = 96},
  [2470] = {.lex_state = 96},
  [2471] = {.lex_state = 96},
  [2472] = {.lex_state = 75, .external_lex_state = 15},
  [2473] = {.lex_state = 96},
  [2474] = {.lex_state = 96},
  [2475] = {.lex_state = 96},
  [2476] = {.lex_state = 96},
  [2477] = {.lex_state = 96},
  [2478] = {.lex_state = 96},
  [2479] = {.lex_state = 96},
  [2480] = {.lex_state = 75, .external_lex_state = 15},
  [2481] = {.lex_state = 96},
  [2482] = {.lex_state = 96},
  [2483] = {.lex_state = 75, .external_lex_state = 15},
  [2484] = {.lex_state = 75, .external_lex_state = 15},
  [2485] = {.lex_state = 75, .external_lex_state = 15},
  [2486] = {.lex_state = 75, .external_lex_state = 15},
  [2487] = {.lex_state = 75, .external_lex_state = 15},
  [2488] = {.lex_state = 75, .external_lex_state = 15},
  [2489] = {.lex_state = 75, .external_lex_state = 15},
  [2490] = {.lex_state = 75, .external_lex_state = 15},
  [2491] = {.lex_state = 75, .external_lex_state = 15},
  [2492] = {.lex_state = 75, .external_lex_state = 15},
  [2493] = {.lex_state = 75, .external_lex_state = 15},
  [2494] = {.lex_state = 75, .external_lex_state = 15},
  [2495] = {.lex_state = 75, .external_lex_state = 15},
  [2496] = {.lex_state = 75, .external_lex_state = 15},
  [2497] = {.lex_state = 75, .external_lex_state = 15},
  [2498] = {.lex_state = 75, .external_lex_state = 10},
  [2499] = {.lex_state = 75, .external_lex_state = 15},
  [2500] = {.lex_state = 75, .external_lex_state = 15},
  [2501] = {.lex_state = 75, .external_lex_state = 15},
  [2502] = {.lex_state = 75, .external_lex_state = 15},
  [2503] = {.lex_state = 75, .external_lex_state = 15},
  [2504] = {.lex_state = 75, .external_lex_state = 15},
  [2505] = {.lex_state = 75, .external_lex_state = 10},
  [2506] = {.lex_state = 75, .external_lex_state = 15},
  [2507] = {.lex_state = 75, .external_lex_state = 15},
  [2508] = {.lex_state = 75, .external_lex_state = 15},
  [2509] = {.lex_state = 75, .external_lex_state = 15},
  [2510] = {.lex_state = 75, .external_lex_state = 15},
  [2511] = {.lex_state = 75, .external_lex_state = 10},
  [2512] = {.lex_state = 96, .external_lex_state = 17},
  [2513] = {.lex_state = 96, .external_lex_state = 17},
  [2514] = {.lex_state = 85},
  [2515] = {.lex_state = 96, .external_lex_state = 17},
  [2516] = {.lex_state = 85, .external_lex_state = 19},
  [2517] = {.lex_state = 96, .external_lex_state = 17},
  [2518] = {.lex_state = 96, .external_lex_state = 17},
  [2519] = {.lex_state = 85, .external_lex_state = 21},
  [2520] = {.lex_state = 85, .external_lex_state = 21},
  [2521] = {.lex_state = 96, .external_lex_state = 17},
  [2522] = {.lex_state = 85, .external_lex_state = 21},
  [2523] = {.lex_state = 96, .external_lex_state = 17},
  [2524] = {.lex_state = 96, .external_lex_state = 17},
  [2525] = {.lex_state = 96, .external_lex_state = 17},
  [2526] = {.lex_state = 85, .external_lex_state = 21},
  [2527] = {.lex_state = 85, .external_lex_state = 12},
  [2528] = {.lex_state = 96, .external_lex_state = 17},
  [2529] = {.lex_state = 96, .external_lex_state = 17},
  [2530] = {.lex_state = 96, .external_lex_state = 17},
  [2531] = {.lex_state = 85, .external_lex_state = 21},
  [2532] = {.lex_state = 85, .external_lex_state = 21},
  [2533] = {.lex_state = 96, .external_lex_state = 17},
  [2534] = {.lex_state = 96, .external_lex_state = 17},
  [2535] = {.lex_state = 96, .external_lex_state = 17},
  [2536] = {.lex_state = 96, .external_lex_state = 17},
  [2537] = {.lex_state = 96, .external_lex_state = 17},
  [2538] = {.lex_state = 85, .external_lex_state = 21},
  [2539] = {.lex_state = 85, .external_lex_state = 21},
  [2540] = {.lex_state = 85, .external_lex_state = 21},
  [2541] = {.lex_state = 96, .external_lex_state = 17},
  [2542] = {.lex_state = 85, .external_lex_state = 21},
  [2543] = {.lex_state = 85, .external_lex_state = 21},
  [2544] = {.lex_state = 96, .external_lex_state = 17},
  [2545] = {.lex_state = 96, .external_lex_state = 17},
  [2546] = {.lex_state = 96, .external_lex_state = 17},
  [2547] = {.lex_state = 96, .external_lex_state = 17},
  [2548] = {.lex_state = 85, .external_lex_state = 21},
  [2549] = {.lex_state = 96, .external_lex_state = 17},
  [2550] = {.lex_state = 96, .external_lex_state = 17},
  [2551] = {.lex_state = 96},
  [2552] = {.lex_state = 85, .external_lex_state = 21},
  [2553] = {.lex_state = 85, .external_lex_state = 21},
  [2554] = {.lex_state = 85, .external_lex_state = 21},
  [2555] = {.lex_state = 85, .external_lex_state = 21},
  [2556] = {.lex_state = 85, .external_lex_state = 21},
  [2557] = {.lex_state = 85, .external_lex_state = 21},
  [2558] = {.lex_state = 85, .external_lex_state = 21},
  [2559] = {.lex_state = 85, .external_lex_state = 21},
  [2560] = {.lex_state = 96},
  [2561] = {.lex_state = 85, .external_lex_state = 21},
  [2562] = {.lex_state = 85, .external_lex_state = 21},
  [2563] = {.lex_state = 96, .external_lex_state = 17},
  [2564] = {.lex_state = 85, .external_lex_state = 21},
  [2565] = {.lex_state = 85, .external_lex_state = 21},
  [2566] = {.lex_state = 96, .external_lex_state = 17},
  [2567] = {.lex_state = 85, .external_lex_state = 21},
  [2568] = {.lex_state = 85, .external_lex_state = 21},
  [2569] = {.lex_state = 85, .external_lex_state = 21},
  [2570] = {.lex_state = 85, .external_lex_state = 21},
  [2571] = {.lex_state = 85, .external_lex_state = 21},
  [2572] = {.lex_state = 85, .external_lex_state = 21},
  [2573] = {.lex_state = 85, .external_lex_state = 21},
  [2574] = {.lex_state = 96, .external_lex_state = 17},
  [2575] = {.lex_state = 96, .external_lex_state = 17},
  [2576] = {.lex_state = 96, .external_lex_state = 17},
  [2577] = {.lex_state = 96, .external_lex_state = 17},
  [2578] = {.lex_state = 85},
  [2579] = {.lex_state = 86},
  [2580] = {.lex_state = 86},
  [2581] = {.lex_state = 99},
  [2582] = {.lex_state = 99},
  [2583] = {.lex_state = 86},
  [2584] = {.lex_state = 96},
  [2585] = {.lex_state = 85},
  [2586] = {.lex_state = 86},
  [2587] = {.lex_state = 86},
  [2588] = {.lex_state = 99},
  [2589] = {.lex_state = 85},
  [2590] = {.lex_state = 86},
  [2591] = {.lex_state = 85},
  [2592] = {.lex_state = 86},
  [2593] = {.lex_state = 86},
  [2594] = {.lex_state = 86},
  [2595] = {.lex_state = 86},
  [2596] = {.lex_state = 85},
  [2597] = {.lex_state = 85},
  [2598] = {.lex_state = 86},
  [2599] = {.lex_state = 86},
  [2600] = {.lex_state = 86},
  [2601] = {.lex_state = 86},
  [2602] = {.lex_state = 85},
  [2603] = {.lex_state = 86},
  [2604] = {.lex_state = 86},
  [2605] = {.lex_state = 86},
  [2606] = {.lex_state = 85},
  [2607] = {.lex_state = 85},
  [2608] = {.lex_state = 85},
  [2609] = {.lex_state = 99},
  [2610] = {.lex_state = 86},
  [2611] = {.lex_state = 86},
  [2612] = {.lex_state = 86},
  [2613] = {.lex_state = 86},
  [2614] = {.lex_state = 85},
  [2615] = {.lex_state = 86},
  [2616] = {.lex_state = 86},
  [2617] = {.lex_state = 86},
  [2618] = {.lex_state = 99},
  [2619] = {.lex_state = 86},
  [2620] = {.lex_state = 86},
  [2621] = {.lex_state = 86},
  [2622] = {.lex_state = 86},
  [2623] = {.lex_state = 99},
  [2624] = {.lex_state = 86},
  [2625] = {.lex_state = 86},
  [2626] = {.lex_state = 86},
  [2627] = {.lex_state = 86},
  [2628] = {.lex_state = 86},
  [2629] = {.lex_state = 86},
  [2630] = {.lex_state = 85},
  [2631] = {.lex_state = 85},
  [2632] = {.lex_state = 86},
  [2633] = {.lex_state = 86},
  [2634] = {.lex_state = 99},
  [2635] = {.lex_state = 86},
  [2636] = {.lex_state = 85},
  [2637] = {.lex_state = 86},
  [2638] = {.lex_state = 86},
  [2639] = {.lex_state = 85},
  [2640] = {.lex_state = 86},
  [2641] = {.lex_state = 86},
  [2642] = {.lex_state = 85},
  [2643] = {.lex_state = 99},
  [2644] = {.lex_state = 85},
  [2645] = {.lex_state = 86},
  [2646] = {.lex_state = 99},
  [2647] = {.lex_state = 86},
  [2648] = {.lex_state = 86},
  [2649] = {.lex_state = 85},
  [2650] = {.lex_state = 85},
  [2651] = {.lex_state = 86},
  [2652] = {.lex_state = 86},
  [2653] = {.lex_state = 85},
  [2654] = {.lex_state = 86},
  [2655] = {.lex_state = 86},
  [2656] = {.lex_state = 85},
  [2657] = {.lex_state = 86},
  [2658] = {.lex_state = 85},
  [2659] = {.lex_state = 86},
  [2660] = {.lex_state = 85},
  [2661] = {.lex_state = 85},
  [2662] = {.lex_state = 86},
  [2663] = {.lex_state = 86},
  [2664] = {.lex_state = 86},
  [2665] = {.lex_state = 85},
  [2666] = {.lex_state = 86},
  [2667] = {.lex_state = 86},
  [2668] = {.lex_state = 99},
  [2669] = {.lex_state = 86},
  [2670] = {.lex_state = 85},
  [2671] = {.lex_state = 85},
  [2672] = {.lex_state = 85},
  [2673] = {.lex_state = 85},
  [2674] = {.lex_state = 86},
  [2675] = {.lex_state = 86},
  [2676] = {.lex_state = 101, .external_lex_state = 21},
  [2677] = {.lex_state = 101, .external_lex_state = 21},
  [2678] = {.lex_state = 101, .external_lex_state = 21},
  [2679] = {.lex_state = 101, .external_lex_state = 21},
  [2680] = {.lex_state = 101, .external_lex_state = 21},
  [2681] = {.lex_state = 101, .external_lex_state = 21},
  [2682] = {.lex_state = 96},
  [2683] = {.lex_state = 101, .external_lex_state = 21},
  [2684] = {.lex_state = 96},
  [2685] = {.lex_state = 101, .external_lex_state = 21},
  [2686] = {.lex_state = 101, .external_lex_state = 21},
  [2687] = {.lex_state = 96},
  [2688] = {.lex_state = 101, .external_lex_state = 22},
  [2689] = {.lex_state = 101, .external_lex_state = 21},
  [2690] = {.lex_state = 87},
  [2691] = {.lex_state = 101, .external_lex_state = 21},
  [2692] = {.lex_state = 101, .external_lex_state = 21},
  [2693] = {.lex_state = 96},
  [2694] = {.lex_state = 101, .external_lex_state = 21},
  [2695] = {.lex_state = 96},
  [2696] = {.lex_state = 101, .external_lex_state = 21},
  [2697] = {.lex_state = 101, .external_lex_state = 22},
  [2698] = {.lex_state = 101, .external_lex_state = 21},
  [2699] = {.lex_state = 101, .external_lex_state = 21},
  [2700] = {.lex_state = 96},
  [2701] = {.lex_state = 101, .external_lex_state = 21},
  [2702] = {.lex_state = 101, .external_lex_state = 21},
  [2703] = {.lex_state = 101, .external_lex_state = 21},
  [2704] = {.lex_state = 101, .external_lex_state = 21},
  [2705] = {.lex_state = 96},
  [2706] = {.lex_state = 101, .external_lex_state = 21},
  [2707] = {.lex_state = 96},
  [2708] = {.lex_state = 101, .external_lex_state = 21},
  [2709] = {.lex_state = 96},
  [2710] = {.lex_state = 96},
  [2711] = {.lex_state = 96},
  [2712] = {.lex_state = 96},
  [2713] = {.lex_state = 101, .external_lex_state = 22},
  [2714] = {.lex_state = 96},
  [2715] = {.lex_state = 96},
  [2716] = {.lex_state = 96},
  [2717] = {.lex_state = 96},
  [2718] = {.lex_state = 96},
  [2719] = {.lex_state = 96},
  [2720] = {.lex_state = 101, .external_lex_state = 21},
  [2721] = {.lex_state = 96},
  [2722] = {.lex_state = 96},
  [2723] = {.lex_state = 96},
  [2724] = {.lex_state = 96},
  [2725] = {.lex_state = 101, .external_lex_state = 21},
  [2726] = {.lex_state = 101, .external_lex_state = 22},
  [2727] = {.lex_state = 96},
  [2728] = {.lex_state = 101, .external_lex_state = 21},
  [2729] = {.lex_state = 101, .external_lex_state = 21},
  [2730] = {.lex_state = 101, .external_lex_state = 21},
  [2731] = {.lex_state = 96},
  [2732] = {.lex_state = 96},
  [2733] = {.lex_state = 101, .external_lex_state = 21},
  [2734] = {.lex_state = 101, .external_lex_state = 21},
  [2735] = {.lex_state = 101, .external_lex_state = 21},
  [2736] = {.lex_state = 101, .external_lex_state = 21},
  [2737] = {.lex_state = 96},
  [2738] = {.lex_state = 100},
  [2739] = {.lex_state = 199, .external_lex_state = 23},
  [2740] = {.lex_state = 100},
  [2741] = {.lex_state = 100},
  [2742] = {.lex_state = 199, .external_lex_state = 23},
  [2743] = {.lex_state = 100},
  [2744] = {.lex_state = 100},
  [2745] = {.lex_state = 100},
  [2746] = {.lex_state = 100},
  [2747] = {.lex_state = 100},
  [2748] = {.lex_state = 100},
  [2749] = {.lex_state = 100},
  [2750] = {.lex_state = 100},
  [2751] = {.lex_state = 100},
  [2752] = {.lex_state = 100},
  [2753] = {.lex_state = 100},
  [2754] = {.lex_state = 100},
  [2755] = {.lex_state = 100},
  [2756] = {.lex_state = 100},
  [2757] = {.lex_state = 100},
  [2758] = {.lex_state = 100},
  [2759] = {.lex_state = 199, .external_lex_state = 23},
  [2760] = {.lex_state = 100},
  [2761] = {.lex_state = 100},
  [2762] = {.lex_state = 100},
  [2763] = {.lex_state = 100},
  [2764] = {.lex_state = 100},
  [2765] = {.lex_state = 100},
  [2766] = {.lex_state = 100},
  [2767] = {.lex_state = 100},
  [2768] = {.lex_state = 100},
  [2769] = {.lex_state = 100},
  [2770] = {.lex_state = 100},
  [2771] = {.lex_state = 100},
  [2772] = {.lex_state = 100},
  [2773] = {.lex_state = 100},
  [2774] = {.lex_state = 100},
  [2775] = {.lex_state = 100},
  [2776] = {.lex_state = 100},
  [2777] = {.lex_state = 100},
  [2778] = {.lex_state = 100},
  [2779] = {.lex_state = 199, .external_lex_state = 23},
  [2780] = {.lex_state = 199, .external_lex_state = 23},
  [2781] = {.lex_state = 100},
  [2782] = {.lex_state = 100},
  [2783] = {.lex_state = 100},
  [2784] = {.lex_state = 100},
  [2785] = {.lex_state = 100},
  [2786] = {.lex_state = 100},
  [2787] = {.lex_state = 100},
  [2788] = {.lex_state = 100},
  [2789] = {.lex_state = 100},
  [2790] = {.lex_state = 100},
  [2791] = {.lex_state = 100},
  [2792] = {.lex_state = 100},
  [2793] = {.lex_state = 100},
  [2794] = {.lex_state = 100},
  [2795] = {.lex_state = 100},
  [2796] = {.lex_state = 199, .external_lex_state = 23},
  [2797] = {.lex_state = 100},
  [2798] = {.lex_state = 100},
  [2799] = {.lex_state = 100},
  [2800] = {.lex_state = 100},
  [2801] = {.lex_state = 85},
  [2802] = {.lex_state = 100},
  [2803] = {.lex_state = 199, .external_lex_state = 23},
  [2804] = {.lex_state = 100},
  [2805] = {.lex_state = 101},
  [2806] = {.lex_state = 101},
  [2807] = {.lex_state = 188, .external_lex_state = 15},
  [2808] = {.lex_state = 101},
  [2809] = {.lex_state = 101},
  [2810] = {.lex_state = 102},
  [2811] = {.lex_state = 101},
  [2812] = {.lex_state = 101},
  [2813] = {.lex_state = 101},
  [2814] = {.lex_state = 101},
  [2815] = {.lex_state = 101},
  [2816] = {.lex_state = 100, .external_lex_state = 17},
  [2817] = {.lex_state = 100, .external_lex_state = 17},
  [2818] = {.lex_state = 29, .external_lex_state = 10},
  [2819] = {.lex_state = 188, .external_lex_state = 15},
  [2820] = {.lex_state = 100, .external_lex_state = 17},
  [2821] = {.lex_state = 29, .external_lex_state = 10},
  [2822] = {.lex_state = 29, .external_lex_state = 10},
  [2823] = {.lex_state = 29, .external_lex_state = 10},
  [2824] = {.lex_state = 100, .external_lex_state = 17},
  [2825] = {.lex_state = 188, .external_lex_state = 10},
  [2826] = {.lex_state = 188, .external_lex_state = 10},
  [2827] = {.lex_state = 188, .external_lex_state = 10},
  [2828] = {.lex_state = 100, .external_lex_state = 17},
  [2829] = {.lex_state = 100, .external_lex_state = 17},
  [2830] = {.lex_state = 188, .external_lex_state = 15},
  [2831] = {.lex_state = 100, .external_lex_state = 17},
  [2832] = {.lex_state = 188, .external_lex_state = 15},
  [2833] = {.lex_state = 29, .external_lex_state = 10},
  [2834] = {.lex_state = 100, .external_lex_state = 17},
  [2835] = {.lex_state = 100, .external_lex_state = 17},
  [2836] = {.lex_state = 100, .external_lex_state = 17},
  [2837] = {.lex_state = 100, .external_lex_state = 17},
  [2838] = {.lex_state = 188, .external_lex_state = 15},
  [2839] = {.lex_state = 100, .external_lex_state = 17},
  [2840] = {.lex_state = 100, .external_lex_state = 17},
  [2841] = {.lex_state = 100, .external_lex_state = 17},
  [2842] = {.lex_state = 100, .external_lex_state = 17},
  [2843] = {.lex_state = 100, .external_lex_state = 17},
  [2844] = {.lex_state = 100, .external_lex_state = 17},
  [2845] = {.lex_state = 100, .external_lex_state = 17},
  [2846] = {.lex_state = 100, .external_lex_state = 17},
  [2847] = {.lex_state = 100, .external_lex_state = 17},
  [2848] = {.lex_state = 188, .external_lex_state = 10},
  [2849] = {.lex_state = 100, .external_lex_state = 17},
  [2850] = {.lex_state = 100, .external_lex_state = 17},
  [2851] = {.lex_state = 188, .external_lex_state = 15},
  [2852] = {.lex_state = 199},
  [2853] = {.lex_state = 199, .external_lex_state = 23},
  [2854] = {.lex_state = 100},
  [2855] = {.lex_state = 188, .external_lex_state = 15},
  [2856] = {.lex_state = 188, .external_lex_state = 10},
  [2857] = {.lex_state = 188, .external_lex_state = 15},
  [2858] = {.lex_state = 188, .external_lex_state = 15},
  [2859] = {.lex_state = 188, .external_lex_state = 15},
  [2860] = {.lex_state = 188, .external_lex_state = 15},
  [2861] = {.lex_state = 199},
  [2862] = {.lex_state = 188, .external_lex_state = 15},
  [2863] = {.lex_state = 29, .external_lex_state = 10},
  [2864] = {.lex_state = 188, .external_lex_state = 15},
  [2865] = {.lex_state = 188, .external_lex_state = 15},
  [2866] = {.lex_state = 188, .external_lex_state = 15},
  [2867] = {.lex_state = 188, .external_lex_state = 15},
  [2868] = {.lex_state = 199, .external_lex_state = 23},
  [2869] = {.lex_state = 199, .external_lex_state = 23},
  [2870] = {.lex_state = 199},
  [2871] = {.lex_state = 199, .external_lex_state = 23},
  [2872] = {.lex_state = 199},
  [2873] = {.lex_state = 199, .external_lex_state = 23},
  [2874] = {.lex_state = 199, .external_lex_state = 23},
  [2875] = {.lex_state = 188, .external_lex_state = 15},
  [2876] = {.lex_state = 199, .external_lex_state = 23},
  [2877] = {.lex_state = 199, .external_lex_state = 23},
  [2878] = {.lex_state = 199, .external_lex_state = 23},
  [2879] = {.lex_state = 199, .external_lex_state = 23},
  [2880] = {.lex_state = 199, .external_lex_state = 23},
  [2881] = {.lex_state = 188, .external_lex_state = 15},
  [2882] = {.lex_state = 188, .external_lex_state = 10},
  [2883] = {.lex_state = 199, .external_lex_state = 23},
  [2884] = {.lex_state = 199, .external_lex_state = 23},
  [2885] = {.lex_state = 188, .external_lex_state = 10},
  [2886] = {.lex_state = 199},
  [2887] = {.lex_state = 188, .external_lex_state = 10},
  [2888] = {.lex_state = 188, .external_lex_state = 15},
  [2889] = {.lex_state = 29, .external_lex_state = 10},
  [2890] = {.lex_state = 188, .external_lex_state = 15},
  [2891] = {.lex_state = 188, .external_lex_state = 15},
  [2892] = {.lex_state = 199, .external_lex_state = 23},
  [2893] = {.lex_state = 199, .external_lex_state = 23},
  [2894] = {.lex_state = 199, .external_lex_state = 23},
  [2895] = {.lex_state = 199, .external_lex_state = 23},
  [2896] = {.lex_state = 188, .external_lex_state = 15},
  [2897] = {.lex_state = 188, .external_lex_state = 15},
  [2898] = {.lex_state = 199, .external_lex_state = 23},
  [2899] = {.lex_state = 199, .external_lex_state = 23},
  [2900] = {.lex_state = 188, .external_lex_state = 15},
  [2901] = {.lex_state = 199, .external_lex_state = 23},
  [2902] = {.lex_state = 188, .external_lex_state = 15},
  [2903] = {.lex_state = 188, .external_lex_state = 15},
  [2904] = {.lex_state = 188, .external_lex_state = 15},
  [2905] = {.lex_state = 199},
  [2906] = {.lex_state = 188, .external_lex_state = 15},
  [2907] = {.lex_state = 188, .external_lex_state = 15},
  [2908] = {.lex_state = 100},
  [2909] = {.lex_state = 188, .external_lex_state = 15},
  [2910] = {.lex_state = 188, .external_lex_state = 15},
  [2911] = {.lex_state = 188, .external_lex_state = 15},
  [2912] = {.lex_state = 102},
  [2913] = {.lex_state = 102},
  [2914] = {.lex_state = 188, .external_lex_state = 10},
  [2915] = {.lex_state = 102},
  [2916] = {.lex_state = 91},
  [2917] = {.lex_state = 188, .external_lex_state = 10},
  [2918] = {.lex_state = 188, .external_lex_state = 10},
  [2919] = {.lex_state = 102},
  [2920] = {.lex_state = 102},
  [2921] = {.lex_state = 188, .external_lex_state = 10},
  [2922] = {.lex_state = 102},
  [2923] = {.lex_state = 102},
  [2924] = {.lex_state = 91, .external_lex_state = 17},
  [2925] = {.lex_state = 199},
  [2926] = {.lex_state = 188, .external_lex_state = 10},
  [2927] = {.lex_state = 102},
  [2928] = {.lex_state = 102},
  [2929] = {.lex_state = 102},
  [2930] = {.lex_state = 102},
  [2931] = {.lex_state = 188, .external_lex_state = 10},
  [2932] = {.lex_state = 102},
  [2933] = {.lex_state = 102},
  [2934] = {.lex_state = 102},
  [2935] = {.lex_state = 102},
  [2936] = {.lex_state = 102},
  [2937] = {.lex_state = 102},
  [2938] = {.lex_state = 188, .external_lex_state = 10},
  [2939] = {.lex_state = 91, .external_lex_state = 17},
  [2940] = {.lex_state = 102},
  [2941] = {.lex_state = 188, .external_lex_state = 10},
  [2942] = {.lex_state = 91, .external_lex_state = 17},
  [2943] = {.lex_state = 91},
  [2944] = {.lex_state = 102},
  [2945] = {.lex_state = 188, .external_lex_state = 10},
  [2946] = {.lex_state = 102},
  [2947] = {.lex_state = 188, .external_lex_state = 10},
  [2948] = {.lex_state = 102},
  [2949] = {.lex_state = 188, .external_lex_state = 10},
  [2950] = {.lex_state = 188, .external_lex_state = 10},
  [2951] = {.lex_state = 102},
  [2952] = {.lex_state = 188, .external_lex_state = 10},
  [2953] = {.lex_state = 102},
  [2954] = {.lex_state = 102},
  [2955] = {.lex_state = 188, .external_lex_state = 10},
  [2956] = {.lex_state = 188, .external_lex_state = 10},
  [2957] = {.lex_state = 188, .external_lex_state = 10},
  [2958] = {.lex_state = 188, .external_lex_state = 10},
  [2959] = {.lex_state = 188, .external_lex_state = 10},
  [2960] = {.lex_state = 188, .external_lex_state = 10},
  [2961] = {.lex_state = 102},
  [2962] = {.lex_state = 102},
  [2963] = {.lex_state = 102},
  [2964] = {.lex_state = 102},
  [2965] = {.lex_state = 199},
  [2966] = {.lex_state = 199},
  [2967] = {.lex_state = 102},
  [2968] = {.lex_state = 199},
  [2969] = {.lex_state = 199},
  [2970] = {.lex_state = 199},
  [2971] = {.lex_state = 102},
  [2972] = {.lex_state = 188, .external_lex_state = 10},
  [2973] = {.lex_state = 102},
  [2974] = {.lex_state = 188, .external_lex_state = 10},
  [2975] = {.lex_state = 102},
  [2976] = {.lex_state = 102},
  [2977] = {.lex_state = 91, .external_lex_state = 17},
  [2978] = {.lex_state = 91},
  [2979] = {.lex_state = 91, .external_lex_state = 17},
  [2980] = {.lex_state = 102},
  [2981] = {.lex_state = 188, .external_lex_state = 10},
  [2982] = {.lex_state = 188, .external_lex_state = 10},
  [2983] = {.lex_state = 188, .external_lex_state = 10},
  [2984] = {.lex_state = 188, .external_lex_state = 10},
  [2985] = {.lex_state = 102},
  [2986] = {.lex_state = 103, .external_lex_state = 20},
  [2987] = {.lex_state = 188, .external_lex_state = 10},
  [2988] = {.lex_state = 92, .external_lex_state = 19},
  [2989] = {.lex_state = 102},
  [2990] = {.lex_state = 102},
  [2991] = {.lex_state = 102},
  [2992] = {.lex_state = 92, .external_lex_state = 19},
  [2993] = {.lex_state = 188, .external_lex_state = 10},
  [2994] = {.lex_state = 102},
  [2995] = {.lex_state = 188, .external_lex_state = 10},
  [2996] = {.lex_state = 102},
  [2997] = {.lex_state = 92, .external_lex_state = 19},
  [2998] = {.lex_state = 188, .external_lex_state = 10},
  [2999] = {.lex_state = 188, .external_lex_state = 10},
  [3000] = {.lex_state = 102},
  [3001] = {.lex_state = 102},
  [3002] = {.lex_state = 102},
  [3003] = {.lex_state = 188, .external_lex_state = 10},
  [3004] = {.lex_state = 102},
  [3005] = {.lex_state = 102},
  [3006] = {.lex_state = 188, .external_lex_state = 10},
  [3007] = {.lex_state = 102},
  [3008] = {.lex_state = 92, .external_lex_state = 19},
  [3009] = {.lex_state = 102},
  [3010] = {.lex_state = 102},
  [3011] = {.lex_state = 101, .external_lex_state = 20},
  [3012] = {.lex_state = 199},
  [3013] = {.lex_state = 103, .external_lex_state = 12},
  [3014] = {.lex_state = 101, .external_lex_state = 20},
  [3015] = {.lex_state = 101, .external_lex_state = 20},
  [3016] = {.lex_state = 103, .external_lex_state = 12},
  [3017] = {.lex_state = 103, .external_lex_state = 12},
  [3018] = {.lex_state = 101, .external_lex_state = 20},
  [3019] = {.lex_state = 101, .external_lex_state = 20},
  [3020] = {.lex_state = 103, .external_lex_state = 12},
  [3021] = {.lex_state = 103, .external_lex_state = 12},
  [3022] = {.lex_state = 103, .external_lex_state = 12},
  [3023] = {.lex_state = 101, .external_lex_state = 20},
  [3024] = {.lex_state = 101, .external_lex_state = 20},
  [3025] = {.lex_state = 103, .external_lex_state = 12},
  [3026] = {.lex_state = 101, .external_lex_state = 20},
  [3027] = {.lex_state = 101, .external_lex_state = 20},
  [3028] = {.lex_state = 101, .external_lex_state = 20},
  [3029] = {.lex_state = 103, .external_lex_state = 12},
  [3030] = {.lex_state = 101, .external_lex_state = 20},
  [3031] = {.lex_state = 92, .external_lex_state = 19},
  [3032] = {.lex_state = 103, .external_lex_state = 12},
  [3033] = {.lex_state = 103, .external_lex_state = 12},
  [3034] = {.lex_state = 101, .external_lex_state = 20},
  [3035] = {.lex_state = 103, .external_lex_state = 12},
  [3036] = {.lex_state = 101, .external_lex_state = 20},
  [3037] = {.lex_state = 103, .external_lex_state = 12},
  [3038] = {.lex_state = 103, .external_lex_state = 12},
  [3039] = {.lex_state = 101, .external_lex_state = 20},
  [3040] = {.lex_state = 103, .external_lex_state = 12},
  [3041] = {.lex_state = 101, .external_lex_state = 20},
  [3042] = {.lex_state = 102},
  [3043] = {.lex_state = 102},
  [3044] = {.lex_state = 91},
  [3045] = {.lex_state = 101, .external_lex_state = 20},
  [3046] = {.lex_state = 101, .external_lex_state = 20},
  [3047] = {.lex_state = 103, .external_lex_state = 12},
  [3048] = {.lex_state = 92, .external_lex_state = 19},
  [3049] = {.lex_state = 101, .external_lex_state = 20},
  [3050] = {.lex_state = 103, .external_lex_state = 12},
  [3051] = {.lex_state = 103, .external_lex_state = 12},
  [3052] = {.lex_state = 103, .external_lex_state = 12},
  [3053] = {.lex_state = 101, .external_lex_state = 17},
  [3054] = {.lex_state = 103, .external_lex_state = 12},
  [3055] = {.lex_state = 101, .external_lex_state = 20},
  [3056] = {.lex_state = 103, .external_lex_state = 12},
  [3057] = {.lex_state = 103, .external_lex_state = 12},
  [3058] = {.lex_state = 101, .external_lex_state = 20},
  [3059] = {.lex_state = 101, .external_lex_state = 20},
  [3060] = {.lex_state = 101, .external_lex_state = 20},
  [3061] = {.lex_state = 103, .external_lex_state = 12},
  [3062] = {.lex_state = 103, .external_lex_state = 12},
  [3063] = {.lex_state = 103, .external_lex_state = 12},
  [3064] = {.lex_state = 92, .external_lex_state = 19},
  [3065] = {.lex_state = 103, .external_lex_state = 12},
  [3066] = {.lex_state = 101, .external_lex_state = 20},
  [3067] = {.lex_state = 101, .external_lex_state = 20},
  [3068] = {.lex_state = 101, .external_lex_state = 20},
  [3069] = {.lex_state = 103, .external_lex_state = 12},
  [3070] = {.lex_state = 101, .external_lex_state = 20},
  [3071] = {.lex_state = 101, .external_lex_state = 20},
  [3072] = {.lex_state = 103, .external_lex_state = 12},
  [3073] = {.lex_state = 103, .external_lex_state = 12},
  [3074] = {.lex_state = 101, .external_lex_state = 20},
  [3075] = {.lex_state = 103, .external_lex_state = 12},
  [3076] = {.lex_state = 101, .external_lex_state = 20},
  [3077] = {.lex_state = 101, .external_lex_state = 20},
  [3078] = {.lex_state = 101, .external_lex_state = 17},
  [3079] = {.lex_state = 103, .external_lex_state = 12},
  [3080] = {.lex_state = 199},
  [3081] = {.lex_state = 103, .external_lex_state = 12},
  [3082] = {.lex_state = 101, .external_lex_state = 20},
  [3083] = {.lex_state = 199},
  [3084] = {.lex_state = 103, .external_lex_state = 12},
  [3085] = {.lex_state = 91},
  [3086] = {.lex_state = 91},
  [3087] = {.lex_state = 103, .external_lex_state = 12},
  [3088] = {.lex_state = 103, .external_lex_state = 12},
  [3089] = {.lex_state = 101, .external_lex_state = 20},
  [3090] = {.lex_state = 103, .external_lex_state = 12},
  [3091] = {.lex_state = 101, .external_lex_state = 20},
  [3092] = {.lex_state = 101, .external_lex_state = 20},
  [3093] = {.lex_state = 103, .external_lex_state = 12},
  [3094] = {.lex_state = 101, .external_lex_state = 20},
  [3095] = {.lex_state = 103, .external_lex_state = 12},
  [3096] = {.lex_state = 103, .external_lex_state = 12},
  [3097] = {.lex_state = 199},
  [3098] = {.lex_state = 199},
  [3099] = {.lex_state = 103, .external_lex_state = 12},
  [3100] = {.lex_state = 101, .external_lex_state = 20},
  [3101] = {.lex_state = 101, .external_lex_state = 20},
  [3102] = {.lex_state = 101, .external_lex_state = 20},
  [3103] = {.lex_state = 92, .external_lex_state = 19},
  [3104] = {.lex_state = 103, .external_lex_state = 12},
  [3105] = {.lex_state = 101, .external_lex_state = 20},
  [3106] = {.lex_state = 103, .external_lex_state = 12},
  [3107] = {.lex_state = 103, .external_lex_state = 12},
  [3108] = {.lex_state = 101, .external_lex_state = 20},
  [3109] = {.lex_state = 101, .external_lex_state = 20},
  [3110] = {.lex_state = 103, .external_lex_state = 12},
  [3111] = {.lex_state = 101, .external_lex_state = 20},
  [3112] = {.lex_state = 102},
  [3113] = {.lex_state = 103, .external_lex_state = 12},
  [3114] = {.lex_state = 102},
  [3115] = {.lex_state = 91},
  [3116] = {.lex_state = 91},
  [3117] = {.lex_state = 91},
  [3118] = {.lex_state = 103, .external_lex_state = 12},
  [3119] = {.lex_state = 103, .external_lex_state = 12},
  [3120] = {.lex_state = 101, .external_lex_state = 20},
  [3121] = {.lex_state = 91},
  [3122] = {.lex_state = 103, .external_lex_state = 12},
  [3123] = {.lex_state = 101, .external_lex_state = 20},
  [3124] = {.lex_state = 101, .external_lex_state = 20},
  [3125] = {.lex_state = 101, .external_lex_state = 20},
  [3126] = {.lex_state = 101, .external_lex_state = 17},
  [3127] = {.lex_state = 101, .external_lex_state = 20},
  [3128] = {.lex_state = 103, .external_lex_state = 12},
  [3129] = {.lex_state = 101, .external_lex_state = 20},
  [3130] = {.lex_state = 103, .external_lex_state = 12},
  [3131] = {.lex_state = 101, .external_lex_state = 20},
  [3132] = {.lex_state = 103, .external_lex_state = 12},
  [3133] = {.lex_state = 101, .external_lex_state = 20},
  [3134] = {.lex_state = 103, .external_lex_state = 12},
  [3135] = {.lex_state = 103, .external_lex_state = 12},
  [3136] = {.lex_state = 101, .external_lex_state = 20},
  [3137] = {.lex_state = 101, .external_lex_state = 20},
  [3138] = {.lex_state = 91},
  [3139] = {.lex_state = 102},
  [3140] = {.lex_state = 91},
  [3141] = {.lex_state = 103, .external_lex_state = 12},
  [3142] = {.lex_state = 103, .external_lex_state = 12},
  [3143] = {.lex_state = 101, .external_lex_state = 20},
  [3144] = {.lex_state = 101, .external_lex_state = 20},
  [3145] = {.lex_state = 103, .external_lex_state = 12},
  [3146] = {.lex_state = 103, .external_lex_state = 12},
  [3147] = {.lex_state = 101, .external_lex_state = 20},
  [3148] = {.lex_state = 103, .external_lex_state = 12},
  [3149] = {.lex_state = 101, .external_lex_state = 20},
  [3150] = {.lex_state = 102},
  [3151] = {.lex_state = 101, .external_lex_state = 20},
  [3152] = {.lex_state = 102},
  [3153] = {.lex_state = 101, .external_lex_state = 20},
  [3154] = {.lex_state = 103, .external_lex_state = 12},
  [3155] = {.lex_state = 101, .external_lex_state = 20},
  [3156] = {.lex_state = 101, .external_lex_state = 20},
  [3157] = {.lex_state = 103, .external_lex_state = 12},
  [3158] = {.lex_state = 101, .external_lex_state = 20},
  [3159] = {.lex_state = 102},
  [3160] = {.lex_state = 103, .external_lex_state = 12},
  [3161] = {.lex_state = 103, .external_lex_state = 12},
  [3162] = {.lex_state = 101, .external_lex_state = 17},
  [3163] = {.lex_state = 101, .external_lex_state = 20},
  [3164] = {.lex_state = 101, .external_lex_state = 20},
  [3165] = {.lex_state = 101, .external_lex_state = 20},
  [3166] = {.lex_state = 102},
  [3167] = {.lex_state = 103, .external_lex_state = 12},
  [3168] = {.lex_state = 103, .external_lex_state = 12},
  [3169] = {.lex_state = 102},
  [3170] = {.lex_state = 102},
  [3171] = {.lex_state = 101},
  [3172] = {.lex_state = 90},
  [3173] = {.lex_state = 101},
  [3174] = {.lex_state = 90},
  [3175] = {.lex_state = 199},
  [3176] = {.lex_state = 90},
  [3177] = {.lex_state = 102},
  [3178] = {.lex_state = 102},
  [3179] = {.lex_state = 102},
  [3180] = {.lex_state = 102},
  [3181] = {.lex_state = 102},
  [3182] = {.lex_state = 102},
  [3183] = {.lex_state = 102},
  [3184] = {.lex_state = 102},
  [3185] = {.lex_state = 101},
  [3186] = {.lex_state = 92, .external_lex_state = 19},
  [3187] = {.lex_state = 91},
  [3188] = {.lex_state = 102},
  [3189] = {.lex_state = 102},
  [3190] = {.lex_state = 199},
  [3191] = {.lex_state = 102},
  [3192] = {.lex_state = 102},
  [3193] = {.lex_state = 102},
  [3194] = {.lex_state = 102},
  [3195] = {.lex_state = 199},
  [3196] = {.lex_state = 102},
  [3197] = {.lex_state = 102},
  [3198] = {.lex_state = 102},
  [3199] = {.lex_state = 102},
  [3200] = {.lex_state = 102},
  [3201] = {.lex_state = 102},
  [3202] = {.lex_state = 102},
  [3203] = {.lex_state = 102},
  [3204] = {.lex_state = 102},
  [3205] = {.lex_state = 102},
  [3206] = {.lex_state = 102},
  [3207] = {.lex_state = 102},
  [3208] = {.lex_state = 102},
  [3209] = {.lex_state = 102},
  [3210] = {.lex_state = 199},
  [3211] = {.lex_state = 102},
  [3212] = {.lex_state = 102},
  [3213] = {.lex_state = 102},
  [3214] = {.lex_state = 102},
  [3215] = {.lex_state = 102},
  [3216] = {.lex_state = 102},
  [3217] = {.lex_state = 102},
  [3218] = {.lex_state = 102},
  [3219] = {.lex_state = 199},
  [3220] = {.lex_state = 102},
  [3221] = {.lex_state = 102},
  [3222] = {.lex_state = 102},
  [3223] = {.lex_state = 102},
  [3224] = {.lex_state = 101},
  [3225] = {.lex_state = 101},
  [3226] = {.lex_state = 102},
  [3227] = {.lex_state = 101, .external_lex_state = 20},
  [3228] = {.lex_state = 102},
  [3229] = {.lex_state = 102},
  [3230] = {.lex_state = 92, .external_lex_state = 19},
  [3231] = {.lex_state = 102},
  [3232] = {.lex_state = 102},
  [3233] = {.lex_state = 199},
  [3234] = {.lex_state = 101},
  [3235] = {.lex_state = 102},
  [3236] = {.lex_state = 102},
  [3237] = {.lex_state = 101},
  [3238] = {.lex_state = 102},
  [3239] = {.lex_state = 102},
  [3240] = {.lex_state = 102},
  [3241] = {.lex_state = 101},
  [3242] = {.lex_state = 102},
  [3243] = {.lex_state = 102},
  [3244] = {.lex_state = 101},
  [3245] = {.lex_state = 101, .external_lex_state = 20},
  [3246] = {.lex_state = 102},
  [3247] = {.lex_state = 199},
  [3248] = {.lex_state = 102},
  [3249] = {.lex_state = 101, .external_lex_state = 20},
  [3250] = {.lex_state = 101},
  [3251] = {.lex_state = 101, .external_lex_state = 20},
  [3252] = {.lex_state = 102},
  [3253] = {.lex_state = 199},
  [3254] = {.lex_state = 103, .external_lex_state = 12},
  [3255] = {.lex_state = 102},
  [3256] = {.lex_state = 101},
  [3257] = {.lex_state = 101, .external_lex_state = 20},
  [3258] = {.lex_state = 101, .external_lex_state = 20},
  [3259] = {.lex_state = 101, .external_lex_state = 20},
  [3260] = {.lex_state = 101, .external_lex_state = 20},
  [3261] = {.lex_state = 101, .external_lex_state = 20},
  [3262] = {.lex_state = 101, .external_lex_state = 20},
  [3263] = {.lex_state = 101, .external_lex_state = 20},
  [3264] = {.lex_state = 101, .external_lex_state = 20},
  [3265] = {.lex_state = 102},
  [3266] = {.lex_state = 101, .external_lex_state = 20},
  [3267] = {.lex_state = 102},
  [3268] = {.lex_state = 101},
  [3269] = {.lex_state = 101, .external_lex_state = 20},
  [3270] = {.lex_state = 101, .external_lex_state = 20},
  [3271] = {.lex_state = 101, .external_lex_state = 20},
  [3272] = {.lex_state = 101, .external_lex_state = 20},
  [3273] = {.lex_state = 101, .external_lex_state = 20},
  [3274] = {.lex_state = 101, .external_lex_state = 20},
  [3275] = {.lex_state = 101, .external_lex_state = 20},
  [3276] = {.lex_state = 101, .external_lex_state = 20},
  [3277] = {.lex_state = 199},
  [3278] = {.lex_state = 101, .external_lex_state = 20},
  [3279] = {.lex_state = 102},
  [3280] = {.lex_state = 101, .external_lex_state = 20},
  [3281] = {.lex_state = 101, .external_lex_state = 20},
  [3282] = {.lex_state = 101},
  [3283] = {.lex_state = 101, .external_lex_state = 20},
  [3284] = {.lex_state = 101, .external_lex_state = 20},
  [3285] = {.lex_state = 199},
  [3286] = {.lex_state = 102},
  [3287] = {.lex_state = 91},
  [3288] = {.lex_state = 199},
  [3289] = {.lex_state = 199, .external_lex_state = 24},
  [3290] = {.lex_state = 101, .external_lex_state = 12},
  [3291] = {.lex_state = 101, .external_lex_state = 12},
  [3292] = {.lex_state = 199},
  [3293] = {.lex_state = 91},
  [3294] = {.lex_state = 199},
  [3295] = {.lex_state = 199},
  [3296] = {.lex_state = 91},
  [3297] = {.lex_state = 91},
  [3298] = {.lex_state = 199},
  [3299] = {.lex_state = 91},
  [3300] = {.lex_state = 199, .external_lex_state = 24},
  [3301] = {.lex_state = 91},
  [3302] = {.lex_state = 101, .external_lex_state = 12},
  [3303] = {.lex_state = 95},
  [3304] = {.lex_state = 101, .external_lex_state = 12},
  [3305] = {.lex_state = 91},
  [3306] = {.lex_state = 199},
  [3307] = {.lex_state = 101, .external_lex_state = 12},
  [3308] = {.lex_state = 199, .external_lex_state = 24},
  [3309] = {.lex_state = 101, .external_lex_state = 12},
  [3310] = {.lex_state = 101, .external_lex_state = 12},
  [3311] = {.lex_state = 199},
  [3312] = {.lex_state = 91},
  [3313] = {.lex_state = 199},
  [3314] = {.lex_state = 199},
  [3315] = {.lex_state = 199},
  [3316] = {.lex_state = 91},
  [3317] = {.lex_state = 101, .external_lex_state = 12},
  [3318] = {.lex_state = 101, .external_lex_state = 12},
  [3319] = {.lex_state = 101, .external_lex_state = 12},
  [3320] = {.lex_state = 91},
  [3321] = {.lex_state = 199},
  [3322] = {.lex_state = 199},
  [3323] = {.lex_state = 91},
  [3324] = {.lex_state = 199},
  [3325] = {.lex_state = 91},
  [3326] = {.lex_state = 199},
  [3327] = {.lex_state = 91},
  [3328] = {.lex_state = 199},
  [3329] = {.lex_state = 199},
  [3330] = {.lex_state = 101, .external_lex_state = 12},
  [3331] = {.lex_state = 91},
  [3332] = {.lex_state = 101, .external_lex_state = 12},
  [3333] = {.lex_state = 101, .external_lex_state = 12},
  [3334] = {.lex_state = 101, .external_lex_state = 12},
  [3335] = {.lex_state = 91},
  [3336] = {.lex_state = 101, .external_lex_state = 12},
  [3337] = {.lex_state = 199},
  [3338] = {.lex_state = 199},
  [3339] = {.lex_state = 101, .external_lex_state = 12},
  [3340] = {.lex_state = 91},
  [3341] = {.lex_state = 199},
  [3342] = {.lex_state = 199},
  [3343] = {.lex_state = 199},
  [3344] = {.lex_state = 91},
  [3345] = {.lex_state = 199},
  [3346] = {.lex_state = 91},
  [3347] = {.lex_state = 199},
  [3348] = {.lex_state = 199},
  [3349] = {.lex_state = 91},
  [3350] = {.lex_state = 91},
  [3351] = {.lex_state = 101, .external_lex_state = 12},
  [3352] = {.lex_state = 101, .external_lex_state = 12},
  [3353] = {.lex_state = 199},
  [3354] = {.lex_state = 101, .external_lex_state = 12},
  [3355] = {.lex_state = 91},
  [3356] = {.lex_state = 91},
  [3357] = {.lex_state = 101, .external_lex_state = 12},
  [3358] = {.lex_state = 101, .external_lex_state = 12},
  [3359] = {.lex_state = 101, .external_lex_state = 12},
  [3360] = {.lex_state = 199},
  [3361] = {.lex_state = 91},
  [3362] = {.lex_state = 91},
  [3363] = {.lex_state = 95},
  [3364] = {.lex_state = 199},
  [3365] = {.lex_state = 91},
  [3366] = {.lex_state = 101, .external_lex_state = 12},
  [3367] = {.lex_state = 101, .external_lex_state = 12},
  [3368] = {.lex_state = 199},
  [3369] = {.lex_state = 91},
  [3370] = {.lex_state = 101, .external_lex_state = 12},
  [3371] = {.lex_state = 199},
  [3372] = {.lex_state = 101, .external_lex_state = 12},
  [3373] = {.lex_state = 101, .external_lex_state = 12},
  [3374] = {.lex_state = 101, .external_lex_state = 12},
  [3375] = {.lex_state = 199},
  [3376] = {.lex_state = 91},
  [3377] = {.lex_state = 199},
  [3378] = {.lex_state = 199, .external_lex_state = 24},
  [3379] = {.lex_state = 199},
  [3380] = {.lex_state = 91},
  [3381] = {.lex_state = 91},
  [3382] = {.lex_state = 101, .external_lex_state = 12},
  [3383] = {.lex_state = 91},
  [3384] = {.lex_state = 199},
  [3385] = {.lex_state = 101, .external_lex_state = 12},
  [3386] = {.lex_state = 101, .external_lex_state = 12},
  [3387] = {.lex_state = 91},
  [3388] = {.lex_state = 91},
  [3389] = {.lex_state = 199},
  [3390] = {.lex_state = 91},
  [3391] = {.lex_state = 199},
  [3392] = {.lex_state = 91},
  [3393] = {.lex_state = 101, .external_lex_state = 12},
  [3394] = {.lex_state = 101, .external_lex_state = 12},
  [3395] = {.lex_state = 199},
  [3396] = {.lex_state = 91},
  [3397] = {.lex_state = 199},
  [3398] = {.lex_state = 91},
  [3399] = {.lex_state = 101, .external_lex_state = 12},
  [3400] = {.lex_state = 101, .external_lex_state = 12},
  [3401] = {.lex_state = 91},
  [3402] = {.lex_state = 101, .external_lex_state = 12},
  [3403] = {.lex_state = 199},
  [3404] = {.lex_state = 101, .external_lex_state = 12},
  [3405] = {.lex_state = 101, .external_lex_state = 12},
  [3406] = {.lex_state = 101, .external_lex_state = 12},
  [3407] = {.lex_state = 101, .external_lex_state = 12},
  [3408] = {.lex_state = 101, .external_lex_state = 12},
  [3409] = {.lex_state = 91},
  [3410] = {.lex_state = 199},
  [3411] = {.lex_state = 199},
  [3412] = {.lex_state = 199},
  [3413] = {.lex_state = 199},
  [3414] = {.lex_state = 91},
  [3415] = {.lex_state = 91},
  [3416] = {.lex_state = 101, .external_lex_state = 12},
  [3417] = {.lex_state = 101, .external_lex_state = 12},
  [3418] = {.lex_state = 92, .external_lex_state = 14},
  [3419] = {.lex_state = 199},
  [3420] = {.lex_state = 91},
  [3421] = {.lex_state = 91},
  [3422] = {.lex_state = 199},
  [3423] = {.lex_state = 91},
  [3424] = {.lex_state = 199},
  [3425] = {.lex_state = 92, .external_lex_state = 14},
  [3426] = {.lex_state = 91},
  [3427] = {.lex_state = 101, .external_lex_state = 12},
  [3428] = {.lex_state = 199},
  [3429] = {.lex_state = 199, .external_lex_state = 24},
  [3430] = {.lex_state = 101, .external_lex_state = 12},
  [3431] = {.lex_state = 101, .external_lex_state = 12},
  [3432] = {.lex_state = 91},
  [3433] = {.lex_state = 199},
  [3434] = {.lex_state = 101, .external_lex_state = 12},
  [3435] = {.lex_state = 91},
  [3436] = {.lex_state = 91},
  [3437] = {.lex_state = 199},
  [3438] = {.lex_state = 91},
  [3439] = {.lex_state = 91},
  [3440] = {.lex_state = 91},
  [3441] = {.lex_state = 199},
  [3442] = {.lex_state = 101, .external_lex_state = 12},
  [3443] = {.lex_state = 101, .external_lex_state = 12},
  [3444] = {.lex_state = 101, .external_lex_state = 12},
  [3445] = {.lex_state = 199},
  [3446] = {.lex_state = 101, .external_lex_state = 12},
  [3447] = {.lex_state = 91},
  [3448] = {.lex_state = 101, .external_lex_state = 12},
  [3449] = {.lex_state = 199},
  [3450] = {.lex_state = 199},
  [3451] = {.lex_state = 199},
  [3452] = {.lex_state = 91},
  [3453] = {.lex_state = 199, .external_lex_state = 24},
  [3454] = {.lex_state = 91},
  [3455] = {.lex_state = 101, .external_lex_state = 12},
  [3456] = {.lex_state = 101, .external_lex_state = 12},
  [3457] = {.lex_state = 199},
  [3458] = {.lex_state = 91},
  [3459] = {.lex_state = 199},
  [3460] = {.lex_state = 199},
  [3461] = {.lex_state = 199},
  [3462] = {.lex_state = 90},
  [3463] = {.lex_state = 199},
  [3464] = {.lex_state = 91},
  [3465] = {.lex_state = 101, .external_lex_state = 12},
  [3466] = {.lex_state = 199},
  [3467] = {.lex_state = 92, .external_lex_state = 14},
  [3468] = {.lex_state = 91},
  [3469] = {.lex_state = 101, .external_lex_state = 12},
  [3470] = {.lex_state = 199},
  [3471] = {.lex_state = 199},
  [3472] = {.lex_state = 91},
  [3473] = {.lex_state = 95},
  [3474] = {.lex_state = 91},
  [3475] = {.lex_state = 199},
  [3476] = {.lex_state = 101, .external_lex_state = 12},
  [3477] = {.lex_state = 101, .external_lex_state = 12},
  [3478] = {.lex_state = 91},
  [3479] = {.lex_state = 199},
  [3480] = {.lex_state = 91},
  [3481] = {.lex_state = 101, .external_lex_state = 12},
  [3482] = {.lex_state = 199},
  [3483] = {.lex_state = 90},
  [3484] = {.lex_state = 101, .external_lex_state = 12},
  [3485] = {.lex_state = 101, .external_lex_state = 12},
  [3486] = {.lex_state = 91},
  [3487] = {.lex_state = 199},
  [3488] = {.lex_state = 91},
  [3489] = {.lex_state = 199},
  [3490] = {.lex_state = 199},
  [3491] = {.lex_state = 199},
  [3492] = {.lex_state = 92, .external_lex_state = 14},
  [3493] = {.lex_state = 90},
  [3494] = {.lex_state = 91},
  [3495] = {.lex_state = 91},
  [3496] = {.lex_state = 91},
  [3497] = {.lex_state = 91},
  [3498] = {.lex_state = 199},
  [3499] = {.lex_state = 101, .external_lex_state = 12},
  [3500] = {.lex_state = 199},
};

enum {
  ts_external_token_heredoc_start = 0,
  ts_external_token__simple_heredoc_body = 1,
  ts_external_token__heredoc_body_beginning = 2,
  ts_external_token__heredoc_body_middle = 3,
  ts_external_token__heredoc_body_end = 4,
  ts_external_token_file_descriptor = 5,
  ts_external_token__empty_value = 6,
  ts_external_token__concat = 7,
  ts_external_token_variable_name = 8,
  ts_external_token_regex = 9,
  ts_external_token_RBRACE = 10,
  ts_external_token_RBRACK = 11,
  ts_external_token_LT_LT = 12,
  ts_external_token_LT_LT_DASH = 13,
  ts_external_token_LF = 14,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_heredoc_start] = sym_heredoc_start,
  [ts_external_token__simple_heredoc_body] = sym__simple_heredoc_body,
  [ts_external_token__heredoc_body_beginning] = sym__heredoc_body_beginning,
  [ts_external_token__heredoc_body_middle] = sym__heredoc_body_middle,
  [ts_external_token__heredoc_body_end] = sym__heredoc_body_end,
  [ts_external_token_file_descriptor] = sym_file_descriptor,
  [ts_external_token__empty_value] = sym__empty_value,
  [ts_external_token__concat] = sym__concat,
  [ts_external_token_variable_name] = sym_variable_name,
  [ts_external_token_regex] = sym_regex,
  [ts_external_token_RBRACE] = anon_sym_RBRACE,
  [ts_external_token_RBRACK] = anon_sym_RBRACK,
  [ts_external_token_LT_LT] = anon_sym_LT_LT,
  [ts_external_token_LT_LT_DASH] = anon_sym_LT_LT_DASH,
  [ts_external_token_LF] = anon_sym_LF,
};

static const bool ts_external_scanner_states[25][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_heredoc_start] = true,
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token__heredoc_body_middle] = true,
    [ts_external_token__heredoc_body_end] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__empty_value] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_regex] = true,
    [ts_external_token_RBRACE] = true,
    [ts_external_token_RBRACK] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
  },
  [2] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
  },
  [3] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_RBRACE] = true,
  },
  [4] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
  },
  [5] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [6] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [7] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_RBRACE] = true,
  },
  [8] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [9] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [10] = {
    [ts_external_token_LF] = true,
  },
  [11] = {
    [ts_external_token_regex] = true,
    [ts_external_token_RBRACE] = true,
  },
  [12] = {
    [ts_external_token_RBRACE] = true,
  },
  [13] = {
    [ts_external_token_regex] = true,
  },
  [14] = {
    [ts_external_token_RBRACK] = true,
  },
  [15] = {
    [ts_external_token__concat] = true,
    [ts_external_token_LF] = true,
  },
  [16] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
  },
  [17] = {
    [ts_external_token__concat] = true,
  },
  [18] = {
    [ts_external_token__empty_value] = true,
  },
  [19] = {
    [ts_external_token__concat] = true,
    [ts_external_token_RBRACK] = true,
  },
  [20] = {
    [ts_external_token__concat] = true,
    [ts_external_token_RBRACE] = true,
  },
  [21] = {
    [ts_external_token_variable_name] = true,
    [ts_external_token_RBRACE] = true,
  },
  [22] = {
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
  },
  [23] = {
    [ts_external_token__heredoc_body_middle] = true,
    [ts_external_token__heredoc_body_end] = true,
  },
  [24] = {
    [ts_external_token_heredoc_start] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_word] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_select] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_until] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_done] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_fi] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_esac] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_SEMI_SEMI] = ACTIONS(1),
    [anon_sym_SEMI_AMP] = ACTIONS(1),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_PIPE_AMP] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_typeset] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_unset] = ACTIONS(1),
    [anon_sym_unsetenv] = ACTIONS(1),
    [anon_sym_EQ_TILDE] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_AMP_GT] = ACTIONS(1),
    [anon_sym_AMP_GT_GT] = ACTIONS(1),
    [anon_sym_LT_AMP] = ACTIONS(1),
    [anon_sym_GT_AMP] = ACTIONS(1),
    [anon_sym_GT_PIPE] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_LT_LT_DASH] = ACTIONS(1),
    [anon_sym_LT_LT_LT] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [sym__special_character] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_raw_string] = ACTIONS(1),
    [sym_ansi_c_string] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_COLON_QMARK] = ACTIONS(1),
    [anon_sym_COLON_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_LT_LPAREN] = ACTIONS(1),
    [anon_sym_GT_LPAREN] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [sym_test_operator] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [sym_heredoc_start] = ACTIONS(1),
    [sym__simple_heredoc_body] = ACTIONS(1),
    [sym__heredoc_body_beginning] = ACTIONS(1),
    [sym__heredoc_body_middle] = ACTIONS(1),
    [sym__heredoc_body_end] = ACTIONS(1),
    [sym_file_descriptor] = ACTIONS(1),
    [sym__empty_value] = ACTIONS(1),
    [sym__concat] = ACTIONS(1),
    [sym_variable_name] = ACTIONS(1),
    [sym_regex] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(3450),
    [sym__statements] = STATE(3449),
    [sym_redirected_statement] = STATE(1669),
    [sym_for_statement] = STATE(1669),
    [sym_c_style_for_statement] = STATE(1669),
    [sym_while_statement] = STATE(1669),
    [sym_if_statement] = STATE(1669),
    [sym_case_statement] = STATE(1669),
    [sym_function_definition] = STATE(1669),
    [sym_compound_statement] = STATE(1669),
    [sym_subshell] = STATE(1669),
    [sym_pipeline] = STATE(1669),
    [sym_list] = STATE(1669),
    [sym_negated_command] = STATE(1669),
    [sym_test_command] = STATE(1669),
    [sym_declaration_command] = STATE(1669),
    [sym_unset_command] = STATE(1669),
    [sym_command] = STATE(1669),
    [sym_command_name] = STATE(236),
    [sym_variable_assignment] = STATE(297),
    [sym_subscript] = STATE(3185),
    [sym_file_redirect] = STATE(885),
    [sym_concatenation] = STATE(887),
    [sym_string] = STATE(392),
    [sym_translated_string] = STATE(392),
    [sym_simple_expansion] = STATE(392),
    [sym_expansion] = STATE(392),
    [sym_command_substitution] = STATE(392),
    [sym_process_substitution] = STATE(392),
    [aux_sym__statements_repeat1] = STATE(144),
    [aux_sym_command_repeat1] = STATE(885),
    [aux_sym__literal_repeat1] = STATE(568),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_word] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(9),
    [anon_sym_select] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_until] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(33),
    [anon_sym_typeset] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(33),
    [anon_sym_readonly] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(33),
    [anon_sym_unset] = ACTIONS(35),
    [anon_sym_unsetenv] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [sym__special_character] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [sym_ansi_c_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(57),
  },
  [2] = {
    [aux_sym__statements2] = STATE(18),
    [sym_redirected_statement] = STATE(1705),
    [sym_for_statement] = STATE(1705),
    [sym_c_style_for_statement] = STATE(1705),
    [sym_while_statement] = STATE(1705),
    [sym_if_statement] = STATE(1705),
    [sym_elif_clause] = STATE(2861),
    [sym_else_clause] = STATE(3463),
    [sym_case_statement] = STATE(1705),
    [sym_function_definition] = STATE(1705),
    [sym_compound_statement] = STATE(1705),
    [sym_subshell] = STATE(1705),
    [sym_pipeline] = STATE(1705),
    [sym_list] = STATE(1705),
    [sym_negated_command] = STATE(1705),
    [sym_test_command] = STATE(1705),
    [sym_declaration_command] = STATE(1705),
    [sym_unset_command] = STATE(1705),
    [sym_command] = STATE(1705),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(491),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_if_statement_repeat1] = STATE(2861),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(71),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [3] = {
    [aux_sym__statements2] = STATE(18),
    [sym_redirected_statement] = STATE(1705),
    [sym_for_statement] = STATE(1705),
    [sym_c_style_for_statement] = STATE(1705),
    [sym_while_statement] = STATE(1705),
    [sym_if_statement] = STATE(1705),
    [sym_elif_clause] = STATE(2870),
    [sym_else_clause] = STATE(3324),
    [sym_case_statement] = STATE(1705),
    [sym_function_definition] = STATE(1705),
    [sym_compound_statement] = STATE(1705),
    [sym_subshell] = STATE(1705),
    [sym_pipeline] = STATE(1705),
    [sym_list] = STATE(1705),
    [sym_negated_command] = STATE(1705),
    [sym_test_command] = STATE(1705),
    [sym_declaration_command] = STATE(1705),
    [sym_unset_command] = STATE(1705),
    [sym_command] = STATE(1705),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(491),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_if_statement_repeat1] = STATE(2870),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(113),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [4] = {
    [aux_sym__statements2] = STATE(3),
    [sym_redirected_statement] = STATE(1705),
    [sym_for_statement] = STATE(1705),
    [sym_c_style_for_statement] = STATE(1705),
    [sym_while_statement] = STATE(1705),
    [sym_if_statement] = STATE(1705),
    [sym_elif_clause] = STATE(2905),
    [sym_else_clause] = STATE(3311),
    [sym_case_statement] = STATE(1705),
    [sym_function_definition] = STATE(1705),
    [sym_compound_statement] = STATE(1705),
    [sym_subshell] = STATE(1705),
    [sym_pipeline] = STATE(1705),
    [sym_list] = STATE(1705),
    [sym_negated_command] = STATE(1705),
    [sym_test_command] = STATE(1705),
    [sym_declaration_command] = STATE(1705),
    [sym_unset_command] = STATE(1705),
    [sym_command] = STATE(1705),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(491),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_if_statement_repeat1] = STATE(2905),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(115),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [5] = {
    [aux_sym__statements2] = STATE(18),
    [sym_redirected_statement] = STATE(1705),
    [sym_for_statement] = STATE(1705),
    [sym_c_style_for_statement] = STATE(1705),
    [sym_while_statement] = STATE(1705),
    [sym_if_statement] = STATE(1705),
    [sym_elif_clause] = STATE(2886),
    [sym_else_clause] = STATE(3389),
    [sym_case_statement] = STATE(1705),
    [sym_function_definition] = STATE(1705),
    [sym_compound_statement] = STATE(1705),
    [sym_subshell] = STATE(1705),
    [sym_pipeline] = STATE(1705),
    [sym_list] = STATE(1705),
    [sym_negated_command] = STATE(1705),
    [sym_test_command] = STATE(1705),
    [sym_declaration_command] = STATE(1705),
    [sym_unset_command] = STATE(1705),
    [sym_command] = STATE(1705),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(491),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_if_statement_repeat1] = STATE(2886),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(117),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [6] = {
    [aux_sym__statements2] = STATE(2),
    [sym_redirected_statement] = STATE(1705),
    [sym_for_statement] = STATE(1705),
    [sym_c_style_for_statement] = STATE(1705),
    [sym_while_statement] = STATE(1705),
    [sym_if_statement] = STATE(1705),
    [sym_elif_clause] = STATE(2852),
    [sym_else_clause] = STATE(3475),
    [sym_case_statement] = STATE(1705),
    [sym_function_definition] = STATE(1705),
    [sym_compound_statement] = STATE(1705),
    [sym_subshell] = STATE(1705),
    [sym_pipeline] = STATE(1705),
    [sym_list] = STATE(1705),
    [sym_negated_command] = STATE(1705),
    [sym_test_command] = STATE(1705),
    [sym_declaration_command] = STATE(1705),
    [sym_unset_command] = STATE(1705),
    [sym_command] = STATE(1705),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(491),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_if_statement_repeat1] = STATE(2852),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(119),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [7] = {
    [aux_sym__statements2] = STATE(5),
    [sym_redirected_statement] = STATE(1705),
    [sym_for_statement] = STATE(1705),
    [sym_c_style_for_statement] = STATE(1705),
    [sym_while_statement] = STATE(1705),
    [sym_if_statement] = STATE(1705),
    [sym_elif_clause] = STATE(2872),
    [sym_else_clause] = STATE(3413),
    [sym_case_statement] = STATE(1705),
    [sym_function_definition] = STATE(1705),
    [sym_compound_statement] = STATE(1705),
    [sym_subshell] = STATE(1705),
    [sym_pipeline] = STATE(1705),
    [sym_list] = STATE(1705),
    [sym_negated_command] = STATE(1705),
    [sym_test_command] = STATE(1705),
    [sym_declaration_command] = STATE(1705),
    [sym_unset_command] = STATE(1705),
    [sym_command] = STATE(1705),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(491),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_if_statement_repeat1] = STATE(2872),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(121),
    [anon_sym_elif] = ACTIONS(73),
    [anon_sym_else] = ACTIONS(75),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [8] = {
    [sym__statements] = STATE(2970),
    [sym_redirected_statement] = STATE(1648),
    [sym_for_statement] = STATE(1648),
    [sym_c_style_for_statement] = STATE(1648),
    [sym_while_statement] = STATE(1648),
    [sym_if_statement] = STATE(1648),
    [sym_case_statement] = STATE(1648),
    [sym_function_definition] = STATE(1648),
    [sym_compound_statement] = STATE(1648),
    [sym_subshell] = STATE(1648),
    [sym_pipeline] = STATE(1648),
    [sym_list] = STATE(1648),
    [sym_negated_command] = STATE(1648),
    [sym_test_command] = STATE(1648),
    [sym_declaration_command] = STATE(1648),
    [sym_unset_command] = STATE(1648),
    [sym_command] = STATE(1648),
    [sym_command_name] = STATE(185),
    [sym_variable_assignment] = STATE(276),
    [sym_subscript] = STATE(3250),
    [sym_file_redirect] = STATE(749),
    [sym_concatenation] = STATE(542),
    [sym_string] = STATE(277),
    [sym_translated_string] = STATE(277),
    [sym_simple_expansion] = STATE(277),
    [sym_expansion] = STATE(277),
    [sym_command_substitution] = STATE(277),
    [sym_process_substitution] = STATE(277),
    [aux_sym__statements_repeat1] = STATE(138),
    [aux_sym_command_repeat1] = STATE(749),
    [aux_sym__literal_repeat1] = STATE(311),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_esac] = ACTIONS(137),
    [anon_sym_SEMI_SEMI] = ACTIONS(139),
    [anon_sym_SEMI_AMP] = ACTIONS(141),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(141),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansi_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [9] = {
    [sym__statements] = STATE(2969),
    [sym_redirected_statement] = STATE(1648),
    [sym_for_statement] = STATE(1648),
    [sym_c_style_for_statement] = STATE(1648),
    [sym_while_statement] = STATE(1648),
    [sym_if_statement] = STATE(1648),
    [sym_case_statement] = STATE(1648),
    [sym_function_definition] = STATE(1648),
    [sym_compound_statement] = STATE(1648),
    [sym_subshell] = STATE(1648),
    [sym_pipeline] = STATE(1648),
    [sym_list] = STATE(1648),
    [sym_negated_command] = STATE(1648),
    [sym_test_command] = STATE(1648),
    [sym_declaration_command] = STATE(1648),
    [sym_unset_command] = STATE(1648),
    [sym_command] = STATE(1648),
    [sym_command_name] = STATE(185),
    [sym_variable_assignment] = STATE(276),
    [sym_subscript] = STATE(3250),
    [sym_file_redirect] = STATE(749),
    [sym_concatenation] = STATE(542),
    [sym_string] = STATE(277),
    [sym_translated_string] = STATE(277),
    [sym_simple_expansion] = STATE(277),
    [sym_expansion] = STATE(277),
    [sym_command_substitution] = STATE(277),
    [sym_process_substitution] = STATE(277),
    [aux_sym__statements_repeat1] = STATE(138),
    [aux_sym_command_repeat1] = STATE(749),
    [aux_sym__literal_repeat1] = STATE(311),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_esac] = ACTIONS(177),
    [anon_sym_SEMI_SEMI] = ACTIONS(179),
    [anon_sym_SEMI_AMP] = ACTIONS(181),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(181),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansi_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [10] = {
    [sym__statements] = STATE(2965),
    [sym_redirected_statement] = STATE(1648),
    [sym_for_statement] = STATE(1648),
    [sym_c_style_for_statement] = STATE(1648),
    [sym_while_statement] = STATE(1648),
    [sym_if_statement] = STATE(1648),
    [sym_case_statement] = STATE(1648),
    [sym_function_definition] = STATE(1648),
    [sym_compound_statement] = STATE(1648),
    [sym_subshell] = STATE(1648),
    [sym_pipeline] = STATE(1648),
    [sym_list] = STATE(1648),
    [sym_negated_command] = STATE(1648),
    [sym_test_command] = STATE(1648),
    [sym_declaration_command] = STATE(1648),
    [sym_unset_command] = STATE(1648),
    [sym_command] = STATE(1648),
    [sym_command_name] = STATE(185),
    [sym_variable_assignment] = STATE(276),
    [sym_subscript] = STATE(3250),
    [sym_file_redirect] = STATE(749),
    [sym_concatenation] = STATE(542),
    [sym_string] = STATE(277),
    [sym_translated_string] = STATE(277),
    [sym_simple_expansion] = STATE(277),
    [sym_expansion] = STATE(277),
    [sym_command_substitution] = STATE(277),
    [sym_process_substitution] = STATE(277),
    [aux_sym__statements_repeat1] = STATE(138),
    [aux_sym_command_repeat1] = STATE(749),
    [aux_sym__literal_repeat1] = STATE(311),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_esac] = ACTIONS(183),
    [anon_sym_SEMI_SEMI] = ACTIONS(185),
    [anon_sym_SEMI_AMP] = ACTIONS(187),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(189),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansi_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [11] = {
    [sym__statements] = STATE(2968),
    [sym_redirected_statement] = STATE(1648),
    [sym_for_statement] = STATE(1648),
    [sym_c_style_for_statement] = STATE(1648),
    [sym_while_statement] = STATE(1648),
    [sym_if_statement] = STATE(1648),
    [sym_case_statement] = STATE(1648),
    [sym_function_definition] = STATE(1648),
    [sym_compound_statement] = STATE(1648),
    [sym_subshell] = STATE(1648),
    [sym_pipeline] = STATE(1648),
    [sym_list] = STATE(1648),
    [sym_negated_command] = STATE(1648),
    [sym_test_command] = STATE(1648),
    [sym_declaration_command] = STATE(1648),
    [sym_unset_command] = STATE(1648),
    [sym_command] = STATE(1648),
    [sym_command_name] = STATE(185),
    [sym_variable_assignment] = STATE(276),
    [sym_subscript] = STATE(3250),
    [sym_file_redirect] = STATE(749),
    [sym_concatenation] = STATE(542),
    [sym_string] = STATE(277),
    [sym_translated_string] = STATE(277),
    [sym_simple_expansion] = STATE(277),
    [sym_expansion] = STATE(277),
    [sym_command_substitution] = STATE(277),
    [sym_process_substitution] = STATE(277),
    [aux_sym__statements_repeat1] = STATE(138),
    [aux_sym_command_repeat1] = STATE(749),
    [aux_sym__literal_repeat1] = STATE(311),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_esac] = ACTIONS(191),
    [anon_sym_SEMI_SEMI] = ACTIONS(193),
    [anon_sym_SEMI_AMP] = ACTIONS(195),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(197),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansi_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [12] = {
    [sym__statements] = STATE(2966),
    [sym_redirected_statement] = STATE(1648),
    [sym_for_statement] = STATE(1648),
    [sym_c_style_for_statement] = STATE(1648),
    [sym_while_statement] = STATE(1648),
    [sym_if_statement] = STATE(1648),
    [sym_case_statement] = STATE(1648),
    [sym_function_definition] = STATE(1648),
    [sym_compound_statement] = STATE(1648),
    [sym_subshell] = STATE(1648),
    [sym_pipeline] = STATE(1648),
    [sym_list] = STATE(1648),
    [sym_negated_command] = STATE(1648),
    [sym_test_command] = STATE(1648),
    [sym_declaration_command] = STATE(1648),
    [sym_unset_command] = STATE(1648),
    [sym_command] = STATE(1648),
    [sym_command_name] = STATE(185),
    [sym_variable_assignment] = STATE(276),
    [sym_subscript] = STATE(3250),
    [sym_file_redirect] = STATE(749),
    [sym_concatenation] = STATE(542),
    [sym_string] = STATE(277),
    [sym_translated_string] = STATE(277),
    [sym_simple_expansion] = STATE(277),
    [sym_expansion] = STATE(277),
    [sym_command_substitution] = STATE(277),
    [sym_process_substitution] = STATE(277),
    [aux_sym__statements_repeat1] = STATE(138),
    [aux_sym_command_repeat1] = STATE(749),
    [aux_sym__literal_repeat1] = STATE(311),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_esac] = ACTIONS(183),
    [anon_sym_SEMI_SEMI] = ACTIONS(199),
    [anon_sym_SEMI_AMP] = ACTIONS(201),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(203),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansi_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [13] = {
    [sym__statements] = STATE(3098),
    [sym_redirected_statement] = STATE(1661),
    [sym_for_statement] = STATE(1661),
    [sym_c_style_for_statement] = STATE(1661),
    [sym_while_statement] = STATE(1661),
    [sym_if_statement] = STATE(1661),
    [sym_case_statement] = STATE(1661),
    [sym_function_definition] = STATE(1661),
    [sym_compound_statement] = STATE(1661),
    [sym_subshell] = STATE(1661),
    [sym_pipeline] = STATE(1661),
    [sym_list] = STATE(1661),
    [sym_negated_command] = STATE(1661),
    [sym_test_command] = STATE(1661),
    [sym_declaration_command] = STATE(1661),
    [sym_unset_command] = STATE(1661),
    [sym_command] = STATE(1661),
    [sym_command_name] = STATE(204),
    [sym_variable_assignment] = STATE(288),
    [sym_subscript] = STATE(3241),
    [sym_file_redirect] = STATE(786),
    [sym_concatenation] = STATE(716),
    [sym_string] = STATE(303),
    [sym_translated_string] = STATE(303),
    [sym_simple_expansion] = STATE(303),
    [sym_expansion] = STATE(303),
    [sym_command_substitution] = STATE(303),
    [sym_process_substitution] = STATE(303),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(786),
    [aux_sym__literal_repeat1] = STATE(490),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_SEMI_SEMI] = ACTIONS(207),
    [anon_sym_SEMI_AMP] = ACTIONS(141),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(141),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansi_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [14] = {
    [sym__statements] = STATE(3097),
    [sym_redirected_statement] = STATE(1661),
    [sym_for_statement] = STATE(1661),
    [sym_c_style_for_statement] = STATE(1661),
    [sym_while_statement] = STATE(1661),
    [sym_if_statement] = STATE(1661),
    [sym_case_statement] = STATE(1661),
    [sym_function_definition] = STATE(1661),
    [sym_compound_statement] = STATE(1661),
    [sym_subshell] = STATE(1661),
    [sym_pipeline] = STATE(1661),
    [sym_list] = STATE(1661),
    [sym_negated_command] = STATE(1661),
    [sym_test_command] = STATE(1661),
    [sym_declaration_command] = STATE(1661),
    [sym_unset_command] = STATE(1661),
    [sym_command] = STATE(1661),
    [sym_command_name] = STATE(204),
    [sym_variable_assignment] = STATE(288),
    [sym_subscript] = STATE(3241),
    [sym_file_redirect] = STATE(786),
    [sym_concatenation] = STATE(716),
    [sym_string] = STATE(303),
    [sym_translated_string] = STATE(303),
    [sym_simple_expansion] = STATE(303),
    [sym_expansion] = STATE(303),
    [sym_command_substitution] = STATE(303),
    [sym_process_substitution] = STATE(303),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(786),
    [aux_sym__literal_repeat1] = STATE(490),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_SEMI_SEMI] = ACTIONS(233),
    [anon_sym_SEMI_AMP] = ACTIONS(181),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(181),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansi_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [15] = {
    [sym__statements] = STATE(3012),
    [sym_redirected_statement] = STATE(1661),
    [sym_for_statement] = STATE(1661),
    [sym_c_style_for_statement] = STATE(1661),
    [sym_while_statement] = STATE(1661),
    [sym_if_statement] = STATE(1661),
    [sym_case_statement] = STATE(1661),
    [sym_function_definition] = STATE(1661),
    [sym_compound_statement] = STATE(1661),
    [sym_subshell] = STATE(1661),
    [sym_pipeline] = STATE(1661),
    [sym_list] = STATE(1661),
    [sym_negated_command] = STATE(1661),
    [sym_test_command] = STATE(1661),
    [sym_declaration_command] = STATE(1661),
    [sym_unset_command] = STATE(1661),
    [sym_command] = STATE(1661),
    [sym_command_name] = STATE(204),
    [sym_variable_assignment] = STATE(288),
    [sym_subscript] = STATE(3241),
    [sym_file_redirect] = STATE(786),
    [sym_concatenation] = STATE(716),
    [sym_string] = STATE(303),
    [sym_translated_string] = STATE(303),
    [sym_simple_expansion] = STATE(303),
    [sym_expansion] = STATE(303),
    [sym_command_substitution] = STATE(303),
    [sym_process_substitution] = STATE(303),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(786),
    [aux_sym__literal_repeat1] = STATE(490),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_SEMI_SEMI] = ACTIONS(235),
    [anon_sym_SEMI_AMP] = ACTIONS(187),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(189),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansi_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [16] = {
    [sym__statements] = STATE(3083),
    [sym_redirected_statement] = STATE(1661),
    [sym_for_statement] = STATE(1661),
    [sym_c_style_for_statement] = STATE(1661),
    [sym_while_statement] = STATE(1661),
    [sym_if_statement] = STATE(1661),
    [sym_case_statement] = STATE(1661),
    [sym_function_definition] = STATE(1661),
    [sym_compound_statement] = STATE(1661),
    [sym_subshell] = STATE(1661),
    [sym_pipeline] = STATE(1661),
    [sym_list] = STATE(1661),
    [sym_negated_command] = STATE(1661),
    [sym_test_command] = STATE(1661),
    [sym_declaration_command] = STATE(1661),
    [sym_unset_command] = STATE(1661),
    [sym_command] = STATE(1661),
    [sym_command_name] = STATE(204),
    [sym_variable_assignment] = STATE(288),
    [sym_subscript] = STATE(3241),
    [sym_file_redirect] = STATE(786),
    [sym_concatenation] = STATE(716),
    [sym_string] = STATE(303),
    [sym_translated_string] = STATE(303),
    [sym_simple_expansion] = STATE(303),
    [sym_expansion] = STATE(303),
    [sym_command_substitution] = STATE(303),
    [sym_process_substitution] = STATE(303),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(786),
    [aux_sym__literal_repeat1] = STATE(490),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_SEMI_SEMI] = ACTIONS(237),
    [anon_sym_SEMI_AMP] = ACTIONS(201),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(203),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansi_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [17] = {
    [sym__statements] = STATE(3080),
    [sym_redirected_statement] = STATE(1661),
    [sym_for_statement] = STATE(1661),
    [sym_c_style_for_statement] = STATE(1661),
    [sym_while_statement] = STATE(1661),
    [sym_if_statement] = STATE(1661),
    [sym_case_statement] = STATE(1661),
    [sym_function_definition] = STATE(1661),
    [sym_compound_statement] = STATE(1661),
    [sym_subshell] = STATE(1661),
    [sym_pipeline] = STATE(1661),
    [sym_list] = STATE(1661),
    [sym_negated_command] = STATE(1661),
    [sym_test_command] = STATE(1661),
    [sym_declaration_command] = STATE(1661),
    [sym_unset_command] = STATE(1661),
    [sym_command] = STATE(1661),
    [sym_command_name] = STATE(204),
    [sym_variable_assignment] = STATE(288),
    [sym_subscript] = STATE(3241),
    [sym_file_redirect] = STATE(786),
    [sym_concatenation] = STATE(716),
    [sym_string] = STATE(303),
    [sym_translated_string] = STATE(303),
    [sym_simple_expansion] = STATE(303),
    [sym_expansion] = STATE(303),
    [sym_command_substitution] = STATE(303),
    [sym_process_substitution] = STATE(303),
    [aux_sym__statements_repeat1] = STATE(145),
    [aux_sym_command_repeat1] = STATE(786),
    [aux_sym__literal_repeat1] = STATE(490),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_SEMI_SEMI] = ACTIONS(239),
    [anon_sym_SEMI_AMP] = ACTIONS(195),
    [anon_sym_SEMI_SEMI_AMP] = ACTIONS(197),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansi_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [18] = {
    [aux_sym__statements2] = STATE(18),
    [sym_redirected_statement] = STATE(1705),
    [sym_for_statement] = STATE(1705),
    [sym_c_style_for_statement] = STATE(1705),
    [sym_while_statement] = STATE(1705),
    [sym_if_statement] = STATE(1705),
    [sym_case_statement] = STATE(1705),
    [sym_function_definition] = STATE(1705),
    [sym_compound_statement] = STATE(1705),
    [sym_subshell] = STATE(1705),
    [sym_pipeline] = STATE(1705),
    [sym_list] = STATE(1705),
    [sym_negated_command] = STATE(1705),
    [sym_test_command] = STATE(1705),
    [sym_declaration_command] = STATE(1705),
    [sym_unset_command] = STATE(1705),
    [sym_command] = STATE(1705),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(491),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(241),
    [anon_sym_for] = ACTIONS(244),
    [anon_sym_select] = ACTIONS(247),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_until] = ACTIONS(253),
    [anon_sym_if] = ACTIONS(256),
    [anon_sym_fi] = ACTIONS(259),
    [anon_sym_elif] = ACTIONS(259),
    [anon_sym_else] = ACTIONS(259),
    [anon_sym_case] = ACTIONS(261),
    [anon_sym_function] = ACTIONS(264),
    [anon_sym_LPAREN] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(270),
    [anon_sym_BANG] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(276),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(282),
    [anon_sym_typeset] = ACTIONS(282),
    [anon_sym_export] = ACTIONS(282),
    [anon_sym_readonly] = ACTIONS(282),
    [anon_sym_local] = ACTIONS(282),
    [anon_sym_unset] = ACTIONS(285),
    [anon_sym_unsetenv] = ACTIONS(285),
    [anon_sym_LT] = ACTIONS(288),
    [anon_sym_GT] = ACTIONS(288),
    [anon_sym_GT_GT] = ACTIONS(288),
    [anon_sym_AMP_GT] = ACTIONS(288),
    [anon_sym_AMP_GT_GT] = ACTIONS(288),
    [anon_sym_LT_AMP] = ACTIONS(288),
    [anon_sym_GT_AMP] = ACTIONS(288),
    [anon_sym_GT_PIPE] = ACTIONS(288),
    [anon_sym_DOLLAR] = ACTIONS(291),
    [sym__special_character] = ACTIONS(294),
    [anon_sym_DQUOTE] = ACTIONS(297),
    [sym_raw_string] = ACTIONS(300),
    [sym_ansi_c_string] = ACTIONS(300),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(303),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(306),
    [anon_sym_BQUOTE] = ACTIONS(309),
    [anon_sym_LT_LPAREN] = ACTIONS(312),
    [anon_sym_GT_LPAREN] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(315),
    [sym_variable_name] = ACTIONS(318),
  },
  [19] = {
    [aux_sym__statements2] = STATE(18),
    [sym_redirected_statement] = STATE(1705),
    [sym_for_statement] = STATE(1705),
    [sym_c_style_for_statement] = STATE(1705),
    [sym_while_statement] = STATE(1705),
    [sym_if_statement] = STATE(1705),
    [sym_case_statement] = STATE(1705),
    [sym_function_definition] = STATE(1705),
    [sym_compound_statement] = STATE(1705),
    [sym_subshell] = STATE(1705),
    [sym_pipeline] = STATE(1705),
    [sym_list] = STATE(1705),
    [sym_negated_command] = STATE(1705),
    [sym_test_command] = STATE(1705),
    [sym_declaration_command] = STATE(1705),
    [sym_unset_command] = STATE(1705),
    [sym_command] = STATE(1705),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(491),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(321),
    [anon_sym_elif] = ACTIONS(321),
    [anon_sym_else] = ACTIONS(321),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [20] = {
    [aux_sym__statements2] = STATE(19),
    [sym_redirected_statement] = STATE(1705),
    [sym_for_statement] = STATE(1705),
    [sym_c_style_for_statement] = STATE(1705),
    [sym_while_statement] = STATE(1705),
    [sym_if_statement] = STATE(1705),
    [sym_case_statement] = STATE(1705),
    [sym_function_definition] = STATE(1705),
    [sym_compound_statement] = STATE(1705),
    [sym_subshell] = STATE(1705),
    [sym_pipeline] = STATE(1705),
    [sym_list] = STATE(1705),
    [sym_negated_command] = STATE(1705),
    [sym_test_command] = STATE(1705),
    [sym_declaration_command] = STATE(1705),
    [sym_unset_command] = STATE(1705),
    [sym_command] = STATE(1705),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(491),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(323),
    [anon_sym_elif] = ACTIONS(323),
    [anon_sym_else] = ACTIONS(323),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [21] = {
    [sym__statements] = STATE(3472),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_RPAREN] = ACTIONS(325),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [22] = {
    [sym__statements] = STATE(3299),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_RPAREN] = ACTIONS(327),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [23] = {
    [sym__statements] = STATE(3415),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_RPAREN] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [24] = {
    [aux_sym__statements2] = STATE(24),
    [sym_redirected_statement] = STATE(1703),
    [sym_for_statement] = STATE(1703),
    [sym_c_style_for_statement] = STATE(1703),
    [sym_while_statement] = STATE(1703),
    [sym_if_statement] = STATE(1703),
    [sym_case_statement] = STATE(1703),
    [sym_function_definition] = STATE(1703),
    [sym_compound_statement] = STATE(1703),
    [sym_subshell] = STATE(1703),
    [sym_pipeline] = STATE(1703),
    [sym_list] = STATE(1703),
    [sym_negated_command] = STATE(1703),
    [sym_test_command] = STATE(1703),
    [sym_declaration_command] = STATE(1703),
    [sym_unset_command] = STATE(1703),
    [sym_command] = STATE(1703),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(465),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(241),
    [anon_sym_for] = ACTIONS(244),
    [anon_sym_select] = ACTIONS(247),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_until] = ACTIONS(253),
    [anon_sym_if] = ACTIONS(256),
    [anon_sym_case] = ACTIONS(261),
    [anon_sym_function] = ACTIONS(264),
    [anon_sym_LPAREN] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(270),
    [anon_sym_RBRACE] = ACTIONS(259),
    [anon_sym_BANG] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(276),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(282),
    [anon_sym_typeset] = ACTIONS(282),
    [anon_sym_export] = ACTIONS(282),
    [anon_sym_readonly] = ACTIONS(282),
    [anon_sym_local] = ACTIONS(282),
    [anon_sym_unset] = ACTIONS(285),
    [anon_sym_unsetenv] = ACTIONS(285),
    [anon_sym_LT] = ACTIONS(288),
    [anon_sym_GT] = ACTIONS(288),
    [anon_sym_GT_GT] = ACTIONS(288),
    [anon_sym_AMP_GT] = ACTIONS(288),
    [anon_sym_AMP_GT_GT] = ACTIONS(288),
    [anon_sym_LT_AMP] = ACTIONS(288),
    [anon_sym_GT_AMP] = ACTIONS(288),
    [anon_sym_GT_PIPE] = ACTIONS(288),
    [anon_sym_DOLLAR] = ACTIONS(291),
    [sym__special_character] = ACTIONS(294),
    [anon_sym_DQUOTE] = ACTIONS(297),
    [sym_raw_string] = ACTIONS(300),
    [sym_ansi_c_string] = ACTIONS(300),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(303),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(306),
    [anon_sym_BQUOTE] = ACTIONS(309),
    [anon_sym_LT_LPAREN] = ACTIONS(312),
    [anon_sym_GT_LPAREN] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(315),
    [sym_variable_name] = ACTIONS(318),
  },
  [25] = {
    [sym__statements] = STATE(3410),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [26] = {
    [sym__statements] = STATE(3383),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [27] = {
    [sym__statements] = STATE(3356),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2003),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [28] = {
    [sym__statements] = STATE(3498),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [29] = {
    [sym__statements] = STATE(3452),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2053),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [30] = {
    [sym__statements] = STATE(3392),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [31] = {
    [sym__statements] = STATE(3297),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(1952),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [32] = {
    [sym__statements] = STATE(3454),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [33] = {
    [sym__statements] = STATE(3391),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [34] = {
    [sym__statements] = STATE(3294),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [35] = {
    [sym__statements] = STATE(3293),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [36] = {
    [sym__statements] = STATE(3436),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2050),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [37] = {
    [aux_sym__statements2] = STATE(37),
    [sym_redirected_statement] = STATE(1741),
    [sym_for_statement] = STATE(1741),
    [sym_c_style_for_statement] = STATE(1741),
    [sym_while_statement] = STATE(1741),
    [sym_if_statement] = STATE(1741),
    [sym_case_statement] = STATE(1741),
    [sym_function_definition] = STATE(1741),
    [sym_compound_statement] = STATE(1741),
    [sym_subshell] = STATE(1741),
    [sym_pipeline] = STATE(1741),
    [sym_list] = STATE(1741),
    [sym_negated_command] = STATE(1741),
    [sym_test_command] = STATE(1741),
    [sym_declaration_command] = STATE(1741),
    [sym_unset_command] = STATE(1741),
    [sym_command] = STATE(1741),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(501),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(241),
    [anon_sym_for] = ACTIONS(244),
    [anon_sym_select] = ACTIONS(247),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_until] = ACTIONS(253),
    [anon_sym_done] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(256),
    [anon_sym_case] = ACTIONS(261),
    [anon_sym_function] = ACTIONS(264),
    [anon_sym_LPAREN] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(270),
    [anon_sym_BANG] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(276),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(282),
    [anon_sym_typeset] = ACTIONS(282),
    [anon_sym_export] = ACTIONS(282),
    [anon_sym_readonly] = ACTIONS(282),
    [anon_sym_local] = ACTIONS(282),
    [anon_sym_unset] = ACTIONS(285),
    [anon_sym_unsetenv] = ACTIONS(285),
    [anon_sym_LT] = ACTIONS(288),
    [anon_sym_GT] = ACTIONS(288),
    [anon_sym_GT_GT] = ACTIONS(288),
    [anon_sym_AMP_GT] = ACTIONS(288),
    [anon_sym_AMP_GT_GT] = ACTIONS(288),
    [anon_sym_LT_AMP] = ACTIONS(288),
    [anon_sym_GT_AMP] = ACTIONS(288),
    [anon_sym_GT_PIPE] = ACTIONS(288),
    [anon_sym_DOLLAR] = ACTIONS(291),
    [sym__special_character] = ACTIONS(294),
    [anon_sym_DQUOTE] = ACTIONS(297),
    [sym_raw_string] = ACTIONS(300),
    [sym_ansi_c_string] = ACTIONS(300),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(303),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(306),
    [anon_sym_BQUOTE] = ACTIONS(309),
    [anon_sym_LT_LPAREN] = ACTIONS(312),
    [anon_sym_GT_LPAREN] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(315),
    [sym_variable_name] = ACTIONS(318),
  },
  [38] = {
    [sym__statements] = STATE(3387),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(1959),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [39] = {
    [sym__statements] = STATE(3361),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [40] = {
    [sym__statements] = STATE(3360),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [41] = {
    [sym__statements] = STATE(3428),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [42] = {
    [sym__statements] = STATE(3299),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [43] = {
    [sym__statements] = STATE(3331),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [44] = {
    [sym__statements] = STATE(3329),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [45] = {
    [sym__statements] = STATE(3327),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2058),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [46] = {
    [sym__statements] = STATE(3296),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [47] = {
    [sym__statements] = STATE(3298),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [48] = {
    [sym__statements] = STATE(3301),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2056),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [49] = {
    [sym__statements] = STATE(3340),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [50] = {
    [sym__statements] = STATE(3341),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [51] = {
    [aux_sym__statements2] = STATE(69),
    [sym_redirected_statement] = STATE(1697),
    [sym_for_statement] = STATE(1697),
    [sym_c_style_for_statement] = STATE(1697),
    [sym_while_statement] = STATE(1697),
    [sym_if_statement] = STATE(1697),
    [sym_case_statement] = STATE(1697),
    [sym_function_definition] = STATE(1697),
    [sym_compound_statement] = STATE(1697),
    [sym_subshell] = STATE(1697),
    [sym_pipeline] = STATE(1697),
    [sym_list] = STATE(1697),
    [sym_negated_command] = STATE(1697),
    [sym_test_command] = STATE(1697),
    [sym_declaration_command] = STATE(1697),
    [sym_unset_command] = STATE(1697),
    [sym_command] = STATE(1697),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(488),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(337),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [52] = {
    [sym__statements] = STATE(3346),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(1974),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [53] = {
    [sym__statements] = STATE(3414),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [54] = {
    [sym__statements] = STATE(3419),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [55] = {
    [sym__statements] = STATE(3423),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(1986),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [56] = {
    [sym__statements] = STATE(3486),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [57] = {
    [sym__statements] = STATE(3487),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [58] = {
    [sym__statements] = STATE(3488),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2081),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [59] = {
    [aux_sym__statements2] = STATE(24),
    [sym_redirected_statement] = STATE(1703),
    [sym_for_statement] = STATE(1703),
    [sym_c_style_for_statement] = STATE(1703),
    [sym_while_statement] = STATE(1703),
    [sym_if_statement] = STATE(1703),
    [sym_case_statement] = STATE(1703),
    [sym_function_definition] = STATE(1703),
    [sym_compound_statement] = STATE(1703),
    [sym_subshell] = STATE(1703),
    [sym_pipeline] = STATE(1703),
    [sym_list] = STATE(1703),
    [sym_negated_command] = STATE(1703),
    [sym_test_command] = STATE(1703),
    [sym_declaration_command] = STATE(1703),
    [sym_unset_command] = STATE(1703),
    [sym_command] = STATE(1703),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(465),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [60] = {
    [sym__statements] = STATE(3497),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [61] = {
    [sym__statements] = STATE(3437),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [62] = {
    [sym__statements] = STATE(3500),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [63] = {
    [sym__statements] = STATE(3494),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2032),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [64] = {
    [sym__statements] = STATE(3480),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [65] = {
    [sym__statements] = STATE(3415),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [66] = {
    [aux_sym__statements2] = STATE(37),
    [sym_redirected_statement] = STATE(1741),
    [sym_for_statement] = STATE(1741),
    [sym_c_style_for_statement] = STATE(1741),
    [sym_while_statement] = STATE(1741),
    [sym_if_statement] = STATE(1741),
    [sym_case_statement] = STATE(1741),
    [sym_function_definition] = STATE(1741),
    [sym_compound_statement] = STATE(1741),
    [sym_subshell] = STATE(1741),
    [sym_pipeline] = STATE(1741),
    [sym_list] = STATE(1741),
    [sym_negated_command] = STATE(1741),
    [sym_test_command] = STATE(1741),
    [sym_declaration_command] = STATE(1741),
    [sym_unset_command] = STATE(1741),
    [sym_command] = STATE(1741),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(501),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [67] = {
    [aux_sym__statements2] = STATE(59),
    [sym_redirected_statement] = STATE(1703),
    [sym_for_statement] = STATE(1703),
    [sym_c_style_for_statement] = STATE(1703),
    [sym_while_statement] = STATE(1703),
    [sym_if_statement] = STATE(1703),
    [sym_case_statement] = STATE(1703),
    [sym_function_definition] = STATE(1703),
    [sym_compound_statement] = STATE(1703),
    [sym_subshell] = STATE(1703),
    [sym_pipeline] = STATE(1703),
    [sym_list] = STATE(1703),
    [sym_negated_command] = STATE(1703),
    [sym_test_command] = STATE(1703),
    [sym_declaration_command] = STATE(1703),
    [sym_unset_command] = STATE(1703),
    [sym_command] = STATE(1703),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(465),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(343),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [68] = {
    [aux_sym__statements2] = STATE(70),
    [sym_redirected_statement] = STATE(1703),
    [sym_for_statement] = STATE(1703),
    [sym_c_style_for_statement] = STATE(1703),
    [sym_while_statement] = STATE(1703),
    [sym_if_statement] = STATE(1703),
    [sym_case_statement] = STATE(1703),
    [sym_function_definition] = STATE(1703),
    [sym_compound_statement] = STATE(1703),
    [sym_subshell] = STATE(1703),
    [sym_pipeline] = STATE(1703),
    [sym_list] = STATE(1703),
    [sym_negated_command] = STATE(1703),
    [sym_test_command] = STATE(1703),
    [sym_declaration_command] = STATE(1703),
    [sym_unset_command] = STATE(1703),
    [sym_command] = STATE(1703),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(465),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [69] = {
    [aux_sym__statements2] = STATE(107),
    [sym_redirected_statement] = STATE(1697),
    [sym_for_statement] = STATE(1697),
    [sym_c_style_for_statement] = STATE(1697),
    [sym_while_statement] = STATE(1697),
    [sym_if_statement] = STATE(1697),
    [sym_case_statement] = STATE(1697),
    [sym_function_definition] = STATE(1697),
    [sym_compound_statement] = STATE(1697),
    [sym_subshell] = STATE(1697),
    [sym_pipeline] = STATE(1697),
    [sym_list] = STATE(1697),
    [sym_negated_command] = STATE(1697),
    [sym_test_command] = STATE(1697),
    [sym_declaration_command] = STATE(1697),
    [sym_unset_command] = STATE(1697),
    [sym_command] = STATE(1697),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(488),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_fi] = ACTIONS(347),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [70] = {
    [aux_sym__statements2] = STATE(24),
    [sym_redirected_statement] = STATE(1703),
    [sym_for_statement] = STATE(1703),
    [sym_c_style_for_statement] = STATE(1703),
    [sym_while_statement] = STATE(1703),
    [sym_if_statement] = STATE(1703),
    [sym_case_statement] = STATE(1703),
    [sym_function_definition] = STATE(1703),
    [sym_compound_statement] = STATE(1703),
    [sym_subshell] = STATE(1703),
    [sym_pipeline] = STATE(1703),
    [sym_list] = STATE(1703),
    [sym_negated_command] = STATE(1703),
    [sym_test_command] = STATE(1703),
    [sym_declaration_command] = STATE(1703),
    [sym_unset_command] = STATE(1703),
    [sym_command] = STATE(1703),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(465),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(349),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [71] = {
    [sym__statements] = STATE(3479),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [72] = {
    [sym__statements] = STATE(3478),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2080),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [73] = {
    [sym__statements] = STATE(3468),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [74] = {
    [aux_sym__statements2] = STATE(78),
    [sym_redirected_statement] = STATE(1741),
    [sym_for_statement] = STATE(1741),
    [sym_c_style_for_statement] = STATE(1741),
    [sym_while_statement] = STATE(1741),
    [sym_if_statement] = STATE(1741),
    [sym_case_statement] = STATE(1741),
    [sym_function_definition] = STATE(1741),
    [sym_compound_statement] = STATE(1741),
    [sym_subshell] = STATE(1741),
    [sym_pipeline] = STATE(1741),
    [sym_list] = STATE(1741),
    [sym_negated_command] = STATE(1741),
    [sym_test_command] = STATE(1741),
    [sym_declaration_command] = STATE(1741),
    [sym_unset_command] = STATE(1741),
    [sym_command] = STATE(1741),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(501),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [75] = {
    [sym__statements] = STATE(3432),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2018),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [76] = {
    [sym__statements] = STATE(3440),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [77] = {
    [sym__statements] = STATE(3466),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [78] = {
    [aux_sym__statements2] = STATE(37),
    [sym_redirected_statement] = STATE(1741),
    [sym_for_statement] = STATE(1741),
    [sym_c_style_for_statement] = STATE(1741),
    [sym_while_statement] = STATE(1741),
    [sym_if_statement] = STATE(1741),
    [sym_case_statement] = STATE(1741),
    [sym_function_definition] = STATE(1741),
    [sym_compound_statement] = STATE(1741),
    [sym_subshell] = STATE(1741),
    [sym_pipeline] = STATE(1741),
    [sym_list] = STATE(1741),
    [sym_negated_command] = STATE(1741),
    [sym_test_command] = STATE(1741),
    [sym_declaration_command] = STATE(1741),
    [sym_unset_command] = STATE(1741),
    [sym_command] = STATE(1741),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(501),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(353),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [79] = {
    [sym__statements] = STATE(3464),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2052),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [80] = {
    [sym__statements] = STATE(3445),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [81] = {
    [sym__statements] = STATE(3439),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [82] = {
    [sym__statements] = STATE(3489),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [83] = {
    [sym__statements] = STATE(3438),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2015),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [84] = {
    [sym__statements] = STATE(3474),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2002),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [85] = {
    [sym__statements] = STATE(3420),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [86] = {
    [sym__statements] = STATE(3384),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [87] = {
    [sym__statements] = STATE(3409),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(1980),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [88] = {
    [sym__statements] = STATE(3398),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [89] = {
    [sym__statements] = STATE(3395),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [90] = {
    [sym__statements] = STATE(3390),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(1923),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [91] = {
    [sym__statements] = STATE(3369),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [92] = {
    [sym__statements] = STATE(3368),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [93] = {
    [sym__statements] = STATE(3435),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(1944),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [94] = {
    [aux_sym__statements2] = STATE(95),
    [sym_redirected_statement] = STATE(1703),
    [sym_for_statement] = STATE(1703),
    [sym_c_style_for_statement] = STATE(1703),
    [sym_while_statement] = STATE(1703),
    [sym_if_statement] = STATE(1703),
    [sym_case_statement] = STATE(1703),
    [sym_function_definition] = STATE(1703),
    [sym_compound_statement] = STATE(1703),
    [sym_subshell] = STATE(1703),
    [sym_pipeline] = STATE(1703),
    [sym_list] = STATE(1703),
    [sym_negated_command] = STATE(1703),
    [sym_test_command] = STATE(1703),
    [sym_declaration_command] = STATE(1703),
    [sym_unset_command] = STATE(1703),
    [sym_command] = STATE(1703),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(465),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [95] = {
    [aux_sym__statements2] = STATE(24),
    [sym_redirected_statement] = STATE(1703),
    [sym_for_statement] = STATE(1703),
    [sym_c_style_for_statement] = STATE(1703),
    [sym_while_statement] = STATE(1703),
    [sym_if_statement] = STATE(1703),
    [sym_case_statement] = STATE(1703),
    [sym_function_definition] = STATE(1703),
    [sym_compound_statement] = STATE(1703),
    [sym_subshell] = STATE(1703),
    [sym_pipeline] = STATE(1703),
    [sym_list] = STATE(1703),
    [sym_negated_command] = STATE(1703),
    [sym_test_command] = STATE(1703),
    [sym_declaration_command] = STATE(1703),
    [sym_unset_command] = STATE(1703),
    [sym_command] = STATE(1703),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(465),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_RBRACE] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [96] = {
    [aux_sym__statements2] = STATE(102),
    [sym_redirected_statement] = STATE(1741),
    [sym_for_statement] = STATE(1741),
    [sym_c_style_for_statement] = STATE(1741),
    [sym_while_statement] = STATE(1741),
    [sym_if_statement] = STATE(1741),
    [sym_case_statement] = STATE(1741),
    [sym_function_definition] = STATE(1741),
    [sym_compound_statement] = STATE(1741),
    [sym_subshell] = STATE(1741),
    [sym_pipeline] = STATE(1741),
    [sym_list] = STATE(1741),
    [sym_negated_command] = STATE(1741),
    [sym_test_command] = STATE(1741),
    [sym_declaration_command] = STATE(1741),
    [sym_unset_command] = STATE(1741),
    [sym_command] = STATE(1741),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(501),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(359),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [97] = {
    [sym__statements] = STATE(3447),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2062),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [98] = {
    [sym__statements] = STATE(3355),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [99] = {
    [sym__statements] = STATE(3353),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [100] = {
    [sym__statements] = STATE(3349),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(1960),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [101] = {
    [sym__statements] = STATE(3325),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [102] = {
    [aux_sym__statements2] = STATE(37),
    [sym_redirected_statement] = STATE(1741),
    [sym_for_statement] = STATE(1741),
    [sym_c_style_for_statement] = STATE(1741),
    [sym_while_statement] = STATE(1741),
    [sym_if_statement] = STATE(1741),
    [sym_case_statement] = STATE(1741),
    [sym_function_definition] = STATE(1741),
    [sym_compound_statement] = STATE(1741),
    [sym_subshell] = STATE(1741),
    [sym_pipeline] = STATE(1741),
    [sym_list] = STATE(1741),
    [sym_negated_command] = STATE(1741),
    [sym_test_command] = STATE(1741),
    [sym_declaration_command] = STATE(1741),
    [sym_unset_command] = STATE(1741),
    [sym_command] = STATE(1741),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(501),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(361),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [103] = {
    [sym__statements] = STATE(3388),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2013),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [104] = {
    [sym__statements] = STATE(3482),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [105] = {
    [sym__statements] = STATE(3472),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [106] = {
    [sym__statements] = STATE(3321),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [107] = {
    [aux_sym__statements2] = STATE(107),
    [sym_redirected_statement] = STATE(1697),
    [sym_for_statement] = STATE(1697),
    [sym_c_style_for_statement] = STATE(1697),
    [sym_while_statement] = STATE(1697),
    [sym_if_statement] = STATE(1697),
    [sym_case_statement] = STATE(1697),
    [sym_function_definition] = STATE(1697),
    [sym_compound_statement] = STATE(1697),
    [sym_subshell] = STATE(1697),
    [sym_pipeline] = STATE(1697),
    [sym_list] = STATE(1697),
    [sym_negated_command] = STATE(1697),
    [sym_test_command] = STATE(1697),
    [sym_declaration_command] = STATE(1697),
    [sym_unset_command] = STATE(1697),
    [sym_command] = STATE(1697),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(488),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(241),
    [anon_sym_for] = ACTIONS(244),
    [anon_sym_select] = ACTIONS(247),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_until] = ACTIONS(253),
    [anon_sym_if] = ACTIONS(256),
    [anon_sym_fi] = ACTIONS(259),
    [anon_sym_case] = ACTIONS(261),
    [anon_sym_function] = ACTIONS(264),
    [anon_sym_LPAREN] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(270),
    [anon_sym_BANG] = ACTIONS(273),
    [anon_sym_LBRACK] = ACTIONS(276),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(282),
    [anon_sym_typeset] = ACTIONS(282),
    [anon_sym_export] = ACTIONS(282),
    [anon_sym_readonly] = ACTIONS(282),
    [anon_sym_local] = ACTIONS(282),
    [anon_sym_unset] = ACTIONS(285),
    [anon_sym_unsetenv] = ACTIONS(285),
    [anon_sym_LT] = ACTIONS(288),
    [anon_sym_GT] = ACTIONS(288),
    [anon_sym_GT_GT] = ACTIONS(288),
    [anon_sym_AMP_GT] = ACTIONS(288),
    [anon_sym_AMP_GT_GT] = ACTIONS(288),
    [anon_sym_LT_AMP] = ACTIONS(288),
    [anon_sym_GT_AMP] = ACTIONS(288),
    [anon_sym_GT_PIPE] = ACTIONS(288),
    [anon_sym_DOLLAR] = ACTIONS(291),
    [sym__special_character] = ACTIONS(294),
    [anon_sym_DQUOTE] = ACTIONS(297),
    [sym_raw_string] = ACTIONS(300),
    [sym_ansi_c_string] = ACTIONS(300),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(303),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(306),
    [anon_sym_BQUOTE] = ACTIONS(309),
    [anon_sym_LT_LPAREN] = ACTIONS(312),
    [anon_sym_GT_LPAREN] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(315),
    [sym_variable_name] = ACTIONS(318),
  },
  [108] = {
    [sym__statements] = STATE(3495),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [109] = {
    [sym__statements] = STATE(3458),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2076),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [110] = {
    [sym__statements] = STATE(3320),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(1999),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [111] = {
    [sym__statements] = STATE(3457),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [112] = {
    [sym__statements] = STATE(3335),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [113] = {
    [sym__statements] = STATE(3306),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [114] = {
    [sym__statements] = STATE(3305),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2044),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [115] = {
    [sym__statements] = STATE(3312),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [116] = {
    [sym__statements] = STATE(3314),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [117] = {
    [sym__statements] = STATE(3316),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2089),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [118] = {
    [sym__statements] = STATE(3365),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2004),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [119] = {
    [sym__statements] = STATE(3381),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [120] = {
    [sym__statements] = STATE(3337),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [121] = {
    [sym__statements] = STATE(3350),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(2048),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [122] = {
    [sym__statements] = STATE(3362),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [123] = {
    [sym__statements] = STATE(3364),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [124] = {
    [sym__statements] = STATE(3323),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(1981),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [125] = {
    [sym__statements] = STATE(3376),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [126] = {
    [sym__statements] = STATE(3377),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [127] = {
    [sym__statements] = STATE(3426),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(1948),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [128] = {
    [sym__statements] = STATE(3396),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [129] = {
    [sym__statements] = STATE(3397),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [130] = {
    [aux_sym__statements2] = STATE(66),
    [sym_redirected_statement] = STATE(1741),
    [sym_for_statement] = STATE(1741),
    [sym_c_style_for_statement] = STATE(1741),
    [sym_while_statement] = STATE(1741),
    [sym_if_statement] = STATE(1741),
    [sym_case_statement] = STATE(1741),
    [sym_function_definition] = STATE(1741),
    [sym_compound_statement] = STATE(1741),
    [sym_subshell] = STATE(1741),
    [sym_pipeline] = STATE(1741),
    [sym_list] = STATE(1741),
    [sym_negated_command] = STATE(1741),
    [sym_test_command] = STATE(1741),
    [sym_declaration_command] = STATE(1741),
    [sym_unset_command] = STATE(1741),
    [sym_command] = STATE(1741),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(501),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_done] = ACTIONS(363),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [131] = {
    [sym__statements] = STATE(3401),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(1962),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [132] = {
    [sym__statements] = STATE(3421),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [133] = {
    [sym__statements] = STATE(3496),
    [sym_redirected_statement] = STATE(1688),
    [sym_for_statement] = STATE(1688),
    [sym_c_style_for_statement] = STATE(1688),
    [sym_while_statement] = STATE(1688),
    [sym_if_statement] = STATE(1688),
    [sym_case_statement] = STATE(1688),
    [sym_function_definition] = STATE(1688),
    [sym_compound_statement] = STATE(1688),
    [sym_subshell] = STATE(1688),
    [sym_pipeline] = STATE(1688),
    [sym_list] = STATE(1688),
    [sym_negated_command] = STATE(1688),
    [sym_test_command] = STATE(1688),
    [sym_declaration_command] = STATE(1688),
    [sym_unset_command] = STATE(1688),
    [sym_command] = STATE(1688),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(293),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(139),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [134] = {
    [sym__statements] = STATE(3422),
    [sym_redirected_statement] = STATE(1679),
    [sym_for_statement] = STATE(1679),
    [sym_c_style_for_statement] = STATE(1679),
    [sym_while_statement] = STATE(1679),
    [sym_if_statement] = STATE(1679),
    [sym_case_statement] = STATE(1679),
    [sym_function_definition] = STATE(1679),
    [sym_compound_statement] = STATE(1679),
    [sym_subshell] = STATE(1679),
    [sym_pipeline] = STATE(1679),
    [sym_list] = STATE(1679),
    [sym_negated_command] = STATE(1679),
    [sym_test_command] = STATE(1679),
    [sym_declaration_command] = STATE(1679),
    [sym_unset_command] = STATE(1679),
    [sym_command] = STATE(1679),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(541),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(147),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [135] = {
    [sym__terminated_statement] = STATE(3277),
    [sym_redirected_statement] = STATE(1704),
    [sym_for_statement] = STATE(1704),
    [sym_c_style_for_statement] = STATE(1704),
    [sym_while_statement] = STATE(1704),
    [sym_if_statement] = STATE(1704),
    [sym_case_statement] = STATE(1704),
    [sym_function_definition] = STATE(1704),
    [sym_compound_statement] = STATE(1704),
    [sym_subshell] = STATE(1704),
    [sym_pipeline] = STATE(1704),
    [sym_list] = STATE(1704),
    [sym_negated_command] = STATE(1704),
    [sym_test_command] = STATE(1704),
    [sym_declaration_command] = STATE(1704),
    [sym_unset_command] = STATE(1704),
    [sym_command] = STATE(1704),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(457),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [136] = {
    [sym_redirected_statement] = STATE(1730),
    [sym_for_statement] = STATE(1730),
    [sym_c_style_for_statement] = STATE(1730),
    [sym_while_statement] = STATE(1730),
    [sym_if_statement] = STATE(1730),
    [sym_case_statement] = STATE(1730),
    [sym_function_definition] = STATE(1730),
    [sym_compound_statement] = STATE(1730),
    [sym_subshell] = STATE(1730),
    [sym_pipeline] = STATE(1730),
    [sym_list] = STATE(1730),
    [sym_negated_command] = STATE(1730),
    [sym_test_command] = STATE(1730),
    [sym_declaration_command] = STATE(1730),
    [sym_unset_command] = STATE(1730),
    [sym_command] = STATE(1730),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(498),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(136),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(365),
    [anon_sym_for] = ACTIONS(368),
    [anon_sym_select] = ACTIONS(371),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(374),
    [anon_sym_while] = ACTIONS(377),
    [anon_sym_until] = ACTIONS(377),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_case] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(386),
    [anon_sym_LPAREN] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(392),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_LBRACK] = ACTIONS(398),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(401),
    [anon_sym_declare] = ACTIONS(404),
    [anon_sym_typeset] = ACTIONS(404),
    [anon_sym_export] = ACTIONS(404),
    [anon_sym_readonly] = ACTIONS(404),
    [anon_sym_local] = ACTIONS(404),
    [anon_sym_unset] = ACTIONS(407),
    [anon_sym_unsetenv] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(410),
    [anon_sym_GT] = ACTIONS(410),
    [anon_sym_GT_GT] = ACTIONS(410),
    [anon_sym_AMP_GT] = ACTIONS(410),
    [anon_sym_AMP_GT_GT] = ACTIONS(410),
    [anon_sym_LT_AMP] = ACTIONS(410),
    [anon_sym_GT_AMP] = ACTIONS(410),
    [anon_sym_GT_PIPE] = ACTIONS(410),
    [anon_sym_DOLLAR] = ACTIONS(413),
    [sym__special_character] = ACTIONS(416),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [sym_raw_string] = ACTIONS(422),
    [sym_ansi_c_string] = ACTIONS(422),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(425),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(428),
    [anon_sym_BQUOTE] = ACTIONS(431),
    [anon_sym_LT_LPAREN] = ACTIONS(434),
    [anon_sym_GT_LPAREN] = ACTIONS(434),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(437),
    [sym_variable_name] = ACTIONS(440),
  },
  [137] = {
    [sym__terminated_statement] = STATE(3175),
    [sym_redirected_statement] = STATE(1704),
    [sym_for_statement] = STATE(1704),
    [sym_c_style_for_statement] = STATE(1704),
    [sym_while_statement] = STATE(1704),
    [sym_if_statement] = STATE(1704),
    [sym_case_statement] = STATE(1704),
    [sym_function_definition] = STATE(1704),
    [sym_compound_statement] = STATE(1704),
    [sym_subshell] = STATE(1704),
    [sym_pipeline] = STATE(1704),
    [sym_list] = STATE(1704),
    [sym_negated_command] = STATE(1704),
    [sym_test_command] = STATE(1704),
    [sym_declaration_command] = STATE(1704),
    [sym_unset_command] = STATE(1704),
    [sym_command] = STATE(1704),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(457),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [138] = {
    [sym_redirected_statement] = STATE(1652),
    [sym_for_statement] = STATE(1652),
    [sym_c_style_for_statement] = STATE(1652),
    [sym_while_statement] = STATE(1652),
    [sym_if_statement] = STATE(1652),
    [sym_case_statement] = STATE(1652),
    [sym_function_definition] = STATE(1652),
    [sym_compound_statement] = STATE(1652),
    [sym_subshell] = STATE(1652),
    [sym_pipeline] = STATE(1652),
    [sym_list] = STATE(1652),
    [sym_negated_command] = STATE(1652),
    [sym_test_command] = STATE(1652),
    [sym_declaration_command] = STATE(1652),
    [sym_unset_command] = STATE(1652),
    [sym_command] = STATE(1652),
    [sym_command_name] = STATE(185),
    [sym_variable_assignment] = STATE(275),
    [sym_subscript] = STATE(3250),
    [sym_file_redirect] = STATE(749),
    [sym_concatenation] = STATE(542),
    [sym_string] = STATE(277),
    [sym_translated_string] = STATE(277),
    [sym_simple_expansion] = STATE(277),
    [sym_expansion] = STATE(277),
    [sym_command_substitution] = STATE(277),
    [sym_process_substitution] = STATE(277),
    [aux_sym__statements_repeat1] = STATE(136),
    [aux_sym_command_repeat1] = STATE(749),
    [aux_sym__literal_repeat1] = STATE(311),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansi_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [139] = {
    [sym_redirected_statement] = STATE(1664),
    [sym_for_statement] = STATE(1664),
    [sym_c_style_for_statement] = STATE(1664),
    [sym_while_statement] = STATE(1664),
    [sym_if_statement] = STATE(1664),
    [sym_case_statement] = STATE(1664),
    [sym_function_definition] = STATE(1664),
    [sym_compound_statement] = STATE(1664),
    [sym_subshell] = STATE(1664),
    [sym_pipeline] = STATE(1664),
    [sym_list] = STATE(1664),
    [sym_negated_command] = STATE(1664),
    [sym_test_command] = STATE(1664),
    [sym_declaration_command] = STATE(1664),
    [sym_unset_command] = STATE(1664),
    [sym_command] = STATE(1664),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(340),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(136),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [140] = {
    [sym__terminated_statement] = STATE(3345),
    [sym_redirected_statement] = STATE(1704),
    [sym_for_statement] = STATE(1704),
    [sym_c_style_for_statement] = STATE(1704),
    [sym_while_statement] = STATE(1704),
    [sym_if_statement] = STATE(1704),
    [sym_case_statement] = STATE(1704),
    [sym_function_definition] = STATE(1704),
    [sym_compound_statement] = STATE(1704),
    [sym_subshell] = STATE(1704),
    [sym_pipeline] = STATE(1704),
    [sym_list] = STATE(1704),
    [sym_negated_command] = STATE(1704),
    [sym_test_command] = STATE(1704),
    [sym_declaration_command] = STATE(1704),
    [sym_unset_command] = STATE(1704),
    [sym_command] = STATE(1704),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(457),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [141] = {
    [sym__terminated_statement] = STATE(3371),
    [sym_redirected_statement] = STATE(1704),
    [sym_for_statement] = STATE(1704),
    [sym_c_style_for_statement] = STATE(1704),
    [sym_while_statement] = STATE(1704),
    [sym_if_statement] = STATE(1704),
    [sym_case_statement] = STATE(1704),
    [sym_function_definition] = STATE(1704),
    [sym_compound_statement] = STATE(1704),
    [sym_subshell] = STATE(1704),
    [sym_pipeline] = STATE(1704),
    [sym_list] = STATE(1704),
    [sym_negated_command] = STATE(1704),
    [sym_test_command] = STATE(1704),
    [sym_declaration_command] = STATE(1704),
    [sym_unset_command] = STATE(1704),
    [sym_command] = STATE(1704),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(457),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [142] = {
    [sym__terminated_statement] = STATE(3424),
    [sym_redirected_statement] = STATE(1704),
    [sym_for_statement] = STATE(1704),
    [sym_c_style_for_statement] = STATE(1704),
    [sym_while_statement] = STATE(1704),
    [sym_if_statement] = STATE(1704),
    [sym_case_statement] = STATE(1704),
    [sym_function_definition] = STATE(1704),
    [sym_compound_statement] = STATE(1704),
    [sym_subshell] = STATE(1704),
    [sym_pipeline] = STATE(1704),
    [sym_list] = STATE(1704),
    [sym_negated_command] = STATE(1704),
    [sym_test_command] = STATE(1704),
    [sym_declaration_command] = STATE(1704),
    [sym_unset_command] = STATE(1704),
    [sym_command] = STATE(1704),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(457),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [143] = {
    [sym__terminated_statement] = STATE(3195),
    [sym_redirected_statement] = STATE(1704),
    [sym_for_statement] = STATE(1704),
    [sym_c_style_for_statement] = STATE(1704),
    [sym_while_statement] = STATE(1704),
    [sym_if_statement] = STATE(1704),
    [sym_case_statement] = STATE(1704),
    [sym_function_definition] = STATE(1704),
    [sym_compound_statement] = STATE(1704),
    [sym_subshell] = STATE(1704),
    [sym_pipeline] = STATE(1704),
    [sym_list] = STATE(1704),
    [sym_negated_command] = STATE(1704),
    [sym_test_command] = STATE(1704),
    [sym_declaration_command] = STATE(1704),
    [sym_unset_command] = STATE(1704),
    [sym_command] = STATE(1704),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(457),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [144] = {
    [sym_redirected_statement] = STATE(1683),
    [sym_for_statement] = STATE(1683),
    [sym_c_style_for_statement] = STATE(1683),
    [sym_while_statement] = STATE(1683),
    [sym_if_statement] = STATE(1683),
    [sym_case_statement] = STATE(1683),
    [sym_function_definition] = STATE(1683),
    [sym_compound_statement] = STATE(1683),
    [sym_subshell] = STATE(1683),
    [sym_pipeline] = STATE(1683),
    [sym_list] = STATE(1683),
    [sym_negated_command] = STATE(1683),
    [sym_test_command] = STATE(1683),
    [sym_declaration_command] = STATE(1683),
    [sym_unset_command] = STATE(1683),
    [sym_command] = STATE(1683),
    [sym_command_name] = STATE(236),
    [sym_variable_assignment] = STATE(299),
    [sym_subscript] = STATE(3185),
    [sym_file_redirect] = STATE(885),
    [sym_concatenation] = STATE(887),
    [sym_string] = STATE(392),
    [sym_translated_string] = STATE(392),
    [sym_simple_expansion] = STATE(392),
    [sym_expansion] = STATE(392),
    [sym_command_substitution] = STATE(392),
    [sym_process_substitution] = STATE(392),
    [aux_sym__statements_repeat1] = STATE(136),
    [aux_sym_command_repeat1] = STATE(885),
    [aux_sym__literal_repeat1] = STATE(568),
    [sym_word] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(9),
    [anon_sym_select] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_until] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(33),
    [anon_sym_typeset] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(33),
    [anon_sym_readonly] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(33),
    [anon_sym_unset] = ACTIONS(35),
    [anon_sym_unsetenv] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [sym__special_character] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [sym_ansi_c_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(57),
  },
  [145] = {
    [sym_redirected_statement] = STATE(1653),
    [sym_for_statement] = STATE(1653),
    [sym_c_style_for_statement] = STATE(1653),
    [sym_while_statement] = STATE(1653),
    [sym_if_statement] = STATE(1653),
    [sym_case_statement] = STATE(1653),
    [sym_function_definition] = STATE(1653),
    [sym_compound_statement] = STATE(1653),
    [sym_subshell] = STATE(1653),
    [sym_pipeline] = STATE(1653),
    [sym_list] = STATE(1653),
    [sym_negated_command] = STATE(1653),
    [sym_test_command] = STATE(1653),
    [sym_declaration_command] = STATE(1653),
    [sym_unset_command] = STATE(1653),
    [sym_command] = STATE(1653),
    [sym_command_name] = STATE(204),
    [sym_variable_assignment] = STATE(282),
    [sym_subscript] = STATE(3241),
    [sym_file_redirect] = STATE(786),
    [sym_concatenation] = STATE(716),
    [sym_string] = STATE(303),
    [sym_translated_string] = STATE(303),
    [sym_simple_expansion] = STATE(303),
    [sym_expansion] = STATE(303),
    [sym_command_substitution] = STATE(303),
    [sym_process_substitution] = STATE(303),
    [aux_sym__statements_repeat1] = STATE(136),
    [aux_sym_command_repeat1] = STATE(786),
    [aux_sym__literal_repeat1] = STATE(490),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansi_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [146] = {
    [sym__terminated_statement] = STATE(3288),
    [sym_redirected_statement] = STATE(1704),
    [sym_for_statement] = STATE(1704),
    [sym_c_style_for_statement] = STATE(1704),
    [sym_while_statement] = STATE(1704),
    [sym_if_statement] = STATE(1704),
    [sym_case_statement] = STATE(1704),
    [sym_function_definition] = STATE(1704),
    [sym_compound_statement] = STATE(1704),
    [sym_subshell] = STATE(1704),
    [sym_pipeline] = STATE(1704),
    [sym_list] = STATE(1704),
    [sym_negated_command] = STATE(1704),
    [sym_test_command] = STATE(1704),
    [sym_declaration_command] = STATE(1704),
    [sym_unset_command] = STATE(1704),
    [sym_command] = STATE(1704),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(457),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [147] = {
    [sym_redirected_statement] = STATE(1665),
    [sym_for_statement] = STATE(1665),
    [sym_c_style_for_statement] = STATE(1665),
    [sym_while_statement] = STATE(1665),
    [sym_if_statement] = STATE(1665),
    [sym_case_statement] = STATE(1665),
    [sym_function_definition] = STATE(1665),
    [sym_compound_statement] = STATE(1665),
    [sym_subshell] = STATE(1665),
    [sym_pipeline] = STATE(1665),
    [sym_list] = STATE(1665),
    [sym_negated_command] = STATE(1665),
    [sym_test_command] = STATE(1665),
    [sym_declaration_command] = STATE(1665),
    [sym_unset_command] = STATE(1665),
    [sym_command] = STATE(1665),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(520),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym__statements_repeat1] = STATE(136),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [148] = {
    [sym_redirected_statement] = STATE(1686),
    [sym_for_statement] = STATE(1686),
    [sym_c_style_for_statement] = STATE(1686),
    [sym_while_statement] = STATE(1686),
    [sym_if_statement] = STATE(1686),
    [sym_case_statement] = STATE(1686),
    [sym_function_definition] = STATE(1686),
    [sym_compound_statement] = STATE(1686),
    [sym_subshell] = STATE(1686),
    [sym_pipeline] = STATE(1686),
    [sym_list] = STATE(1686),
    [sym_negated_command] = STATE(1686),
    [sym_test_command] = STATE(1686),
    [sym_declaration_command] = STATE(1686),
    [sym_unset_command] = STATE(1686),
    [sym_command] = STATE(1686),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(321),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [149] = {
    [sym_redirected_statement] = STATE(1660),
    [sym_for_statement] = STATE(1660),
    [sym_c_style_for_statement] = STATE(1660),
    [sym_while_statement] = STATE(1660),
    [sym_if_statement] = STATE(1660),
    [sym_case_statement] = STATE(1660),
    [sym_function_definition] = STATE(1660),
    [sym_compound_statement] = STATE(1660),
    [sym_subshell] = STATE(1660),
    [sym_pipeline] = STATE(1660),
    [sym_list] = STATE(1660),
    [sym_negated_command] = STATE(1660),
    [sym_test_command] = STATE(1660),
    [sym_declaration_command] = STATE(1660),
    [sym_unset_command] = STATE(1660),
    [sym_command] = STATE(1660),
    [sym_command_name] = STATE(232),
    [sym_variable_assignment] = STATE(323),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(883),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(883),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(85),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(91),
    [anon_sym_typeset] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_readonly] = ACTIONS(91),
    [anon_sym_local] = ACTIONS(91),
    [anon_sym_unset] = ACTIONS(93),
    [anon_sym_unsetenv] = ACTIONS(93),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [150] = {
    [sym_redirected_statement] = STATE(1656),
    [sym_for_statement] = STATE(1656),
    [sym_c_style_for_statement] = STATE(1656),
    [sym_while_statement] = STATE(1656),
    [sym_if_statement] = STATE(1656),
    [sym_case_statement] = STATE(1656),
    [sym_function_definition] = STATE(1656),
    [sym_compound_statement] = STATE(1656),
    [sym_subshell] = STATE(1656),
    [sym_pipeline] = STATE(1656),
    [sym_list] = STATE(1656),
    [sym_negated_command] = STATE(1656),
    [sym_test_command] = STATE(1656),
    [sym_declaration_command] = STATE(1656),
    [sym_unset_command] = STATE(1656),
    [sym_command] = STATE(1656),
    [sym_command_name] = STATE(204),
    [sym_variable_assignment] = STATE(291),
    [sym_subscript] = STATE(3241),
    [sym_file_redirect] = STATE(786),
    [sym_concatenation] = STATE(716),
    [sym_string] = STATE(303),
    [sym_translated_string] = STATE(303),
    [sym_simple_expansion] = STATE(303),
    [sym_expansion] = STATE(303),
    [sym_command_substitution] = STATE(303),
    [sym_process_substitution] = STATE(303),
    [aux_sym_command_repeat1] = STATE(786),
    [aux_sym__literal_repeat1] = STATE(490),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansi_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [151] = {
    [sym_redirected_statement] = STATE(1680),
    [sym_for_statement] = STATE(1680),
    [sym_c_style_for_statement] = STATE(1680),
    [sym_while_statement] = STATE(1680),
    [sym_if_statement] = STATE(1680),
    [sym_case_statement] = STATE(1680),
    [sym_function_definition] = STATE(1680),
    [sym_compound_statement] = STATE(1680),
    [sym_subshell] = STATE(1680),
    [sym_pipeline] = STATE(1680),
    [sym_list] = STATE(1680),
    [sym_negated_command] = STATE(1680),
    [sym_test_command] = STATE(1680),
    [sym_declaration_command] = STATE(1680),
    [sym_unset_command] = STATE(1680),
    [sym_command] = STATE(1680),
    [sym_command_name] = STATE(236),
    [sym_variable_assignment] = STATE(305),
    [sym_subscript] = STATE(3185),
    [sym_file_redirect] = STATE(885),
    [sym_concatenation] = STATE(887),
    [sym_string] = STATE(392),
    [sym_translated_string] = STATE(392),
    [sym_simple_expansion] = STATE(392),
    [sym_expansion] = STATE(392),
    [sym_command_substitution] = STATE(392),
    [sym_process_substitution] = STATE(392),
    [aux_sym_command_repeat1] = STATE(885),
    [aux_sym__literal_repeat1] = STATE(568),
    [sym_word] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(9),
    [anon_sym_select] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_until] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(33),
    [anon_sym_typeset] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(33),
    [anon_sym_readonly] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(33),
    [anon_sym_unset] = ACTIONS(35),
    [anon_sym_unsetenv] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [sym__special_character] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [sym_ansi_c_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(57),
  },
  [152] = {
    [sym_redirected_statement] = STATE(1646),
    [sym_for_statement] = STATE(1646),
    [sym_c_style_for_statement] = STATE(1646),
    [sym_while_statement] = STATE(1646),
    [sym_if_statement] = STATE(1646),
    [sym_case_statement] = STATE(1646),
    [sym_function_definition] = STATE(1646),
    [sym_compound_statement] = STATE(1646),
    [sym_subshell] = STATE(1646),
    [sym_pipeline] = STATE(1646),
    [sym_list] = STATE(1646),
    [sym_negated_command] = STATE(1646),
    [sym_test_command] = STATE(1646),
    [sym_declaration_command] = STATE(1646),
    [sym_unset_command] = STATE(1646),
    [sym_command] = STATE(1646),
    [sym_command_name] = STATE(185),
    [sym_variable_assignment] = STATE(273),
    [sym_subscript] = STATE(3250),
    [sym_file_redirect] = STATE(749),
    [sym_concatenation] = STATE(542),
    [sym_string] = STATE(277),
    [sym_translated_string] = STATE(277),
    [sym_simple_expansion] = STATE(277),
    [sym_expansion] = STATE(277),
    [sym_command_substitution] = STATE(277),
    [sym_process_substitution] = STATE(277),
    [aux_sym_command_repeat1] = STATE(749),
    [aux_sym__literal_repeat1] = STATE(311),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansi_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
  [153] = {
    [sym_redirected_statement] = STATE(1685),
    [sym_for_statement] = STATE(1685),
    [sym_c_style_for_statement] = STATE(1685),
    [sym_while_statement] = STATE(1685),
    [sym_if_statement] = STATE(1685),
    [sym_case_statement] = STATE(1685),
    [sym_function_definition] = STATE(1685),
    [sym_compound_statement] = STATE(1685),
    [sym_subshell] = STATE(1685),
    [sym_pipeline] = STATE(1685),
    [sym_list] = STATE(1685),
    [sym_negated_command] = STATE(1685),
    [sym_test_command] = STATE(1685),
    [sym_declaration_command] = STATE(1685),
    [sym_unset_command] = STATE(1685),
    [sym_command] = STATE(1685),
    [sym_command_name] = STATE(236),
    [sym_variable_assignment] = STATE(304),
    [sym_subscript] = STATE(3185),
    [sym_file_redirect] = STATE(885),
    [sym_concatenation] = STATE(887),
    [sym_string] = STATE(392),
    [sym_translated_string] = STATE(392),
    [sym_simple_expansion] = STATE(392),
    [sym_expansion] = STATE(392),
    [sym_command_substitution] = STATE(392),
    [sym_process_substitution] = STATE(392),
    [aux_sym_command_repeat1] = STATE(885),
    [aux_sym__literal_repeat1] = STATE(568),
    [sym_word] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(9),
    [anon_sym_select] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_until] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(33),
    [anon_sym_typeset] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(33),
    [anon_sym_readonly] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(33),
    [anon_sym_unset] = ACTIONS(35),
    [anon_sym_unsetenv] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [sym__special_character] = ACTIONS(41),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [sym_raw_string] = ACTIONS(45),
    [sym_ansi_c_string] = ACTIONS(45),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(47),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(49),
    [anon_sym_BQUOTE] = ACTIONS(51),
    [anon_sym_LT_LPAREN] = ACTIONS(53),
    [anon_sym_GT_LPAREN] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(57),
  },
  [154] = {
    [sym_redirected_statement] = STATE(1660),
    [sym_for_statement] = STATE(1660),
    [sym_c_style_for_statement] = STATE(1660),
    [sym_while_statement] = STATE(1660),
    [sym_if_statement] = STATE(1660),
    [sym_case_statement] = STATE(1660),
    [sym_function_definition] = STATE(1660),
    [sym_compound_statement] = STATE(1660),
    [sym_subshell] = STATE(1660),
    [sym_pipeline] = STATE(1660),
    [sym_list] = STATE(1660),
    [sym_negated_command] = STATE(1660),
    [sym_test_command] = STATE(1660),
    [sym_declaration_command] = STATE(1660),
    [sym_unset_command] = STATE(1660),
    [sym_command] = STATE(1660),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(512),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [155] = {
    [sym_redirected_statement] = STATE(1667),
    [sym_for_statement] = STATE(1667),
    [sym_c_style_for_statement] = STATE(1667),
    [sym_while_statement] = STATE(1667),
    [sym_if_statement] = STATE(1667),
    [sym_case_statement] = STATE(1667),
    [sym_function_definition] = STATE(1667),
    [sym_compound_statement] = STATE(1667),
    [sym_subshell] = STATE(1667),
    [sym_pipeline] = STATE(1667),
    [sym_list] = STATE(1667),
    [sym_negated_command] = STATE(1667),
    [sym_test_command] = STATE(1667),
    [sym_declaration_command] = STATE(1667),
    [sym_unset_command] = STATE(1667),
    [sym_command] = STATE(1667),
    [sym_command_name] = STATE(245),
    [sym_variable_assignment] = STATE(511),
    [sym_subscript] = STATE(3234),
    [sym_file_redirect] = STATE(760),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(449),
    [sym_translated_string] = STATE(449),
    [sym_simple_expansion] = STATE(449),
    [sym_expansion] = STATE(449),
    [sym_command_substitution] = STATE(449),
    [sym_process_substitution] = STATE(449),
    [aux_sym_command_repeat1] = STATE(760),
    [aux_sym__literal_repeat1] = STATE(570),
    [sym_word] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(65),
    [anon_sym_while] = ACTIONS(67),
    [anon_sym_until] = ACTIONS(67),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_LBRACE] = ACTIONS(83),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(89),
    [anon_sym_declare] = ACTIONS(333),
    [anon_sym_typeset] = ACTIONS(333),
    [anon_sym_export] = ACTIONS(333),
    [anon_sym_readonly] = ACTIONS(333),
    [anon_sym_local] = ACTIONS(333),
    [anon_sym_unset] = ACTIONS(335),
    [anon_sym_unsetenv] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [sym__special_character] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [sym_raw_string] = ACTIONS(101),
    [sym_ansi_c_string] = ACTIONS(101),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(103),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(105),
    [anon_sym_BQUOTE] = ACTIONS(107),
    [anon_sym_LT_LPAREN] = ACTIONS(109),
    [anon_sym_GT_LPAREN] = ACTIONS(109),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(111),
  },
  [156] = {
    [sym_redirected_statement] = STATE(1658),
    [sym_for_statement] = STATE(1658),
    [sym_c_style_for_statement] = STATE(1658),
    [sym_while_statement] = STATE(1658),
    [sym_if_statement] = STATE(1658),
    [sym_case_statement] = STATE(1658),
    [sym_function_definition] = STATE(1658),
    [sym_compound_statement] = STATE(1658),
    [sym_subshell] = STATE(1658),
    [sym_pipeline] = STATE(1658),
    [sym_list] = STATE(1658),
    [sym_negated_command] = STATE(1658),
    [sym_test_command] = STATE(1658),
    [sym_declaration_command] = STATE(1658),
    [sym_unset_command] = STATE(1658),
    [sym_command] = STATE(1658),
    [sym_command_name] = STATE(204),
    [sym_variable_assignment] = STATE(292),
    [sym_subscript] = STATE(3241),
    [sym_file_redirect] = STATE(786),
    [sym_concatenation] = STATE(716),
    [sym_string] = STATE(303),
    [sym_translated_string] = STATE(303),
    [sym_simple_expansion] = STATE(303),
    [sym_expansion] = STATE(303),
    [sym_command_substitution] = STATE(303),
    [sym_process_substitution] = STATE(303),
    [aux_sym_command_repeat1] = STATE(786),
    [aux_sym__literal_repeat1] = STATE(490),
    [sym_word] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(211),
    [anon_sym_typeset] = ACTIONS(211),
    [anon_sym_export] = ACTIONS(211),
    [anon_sym_readonly] = ACTIONS(211),
    [anon_sym_local] = ACTIONS(211),
    [anon_sym_unset] = ACTIONS(213),
    [anon_sym_unsetenv] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__special_character] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [sym_raw_string] = ACTIONS(221),
    [sym_ansi_c_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(223),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(227),
    [anon_sym_LT_LPAREN] = ACTIONS(229),
    [anon_sym_GT_LPAREN] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(231),
  },
  [157] = {
    [sym_redirected_statement] = STATE(1649),
    [sym_for_statement] = STATE(1649),
    [sym_c_style_for_statement] = STATE(1649),
    [sym_while_statement] = STATE(1649),
    [sym_if_statement] = STATE(1649),
    [sym_case_statement] = STATE(1649),
    [sym_function_definition] = STATE(1649),
    [sym_compound_statement] = STATE(1649),
    [sym_subshell] = STATE(1649),
    [sym_pipeline] = STATE(1649),
    [sym_list] = STATE(1649),
    [sym_negated_command] = STATE(1649),
    [sym_test_command] = STATE(1649),
    [sym_declaration_command] = STATE(1649),
    [sym_unset_command] = STATE(1649),
    [sym_command] = STATE(1649),
    [sym_command_name] = STATE(185),
    [sym_variable_assignment] = STATE(274),
    [sym_subscript] = STATE(3250),
    [sym_file_redirect] = STATE(749),
    [sym_concatenation] = STATE(542),
    [sym_string] = STATE(277),
    [sym_translated_string] = STATE(277),
    [sym_simple_expansion] = STATE(277),
    [sym_expansion] = STATE(277),
    [sym_command_substitution] = STATE(277),
    [sym_process_substitution] = STATE(277),
    [aux_sym_command_repeat1] = STATE(749),
    [aux_sym__literal_repeat1] = STATE(311),
    [sym_word] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(125),
    [anon_sym_select] = ACTIONS(127),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(129),
    [anon_sym_while] = ACTIONS(131),
    [anon_sym_until] = ACTIONS(131),
    [anon_sym_if] = ACTIONS(133),
    [anon_sym_case] = ACTIONS(135),
    [anon_sym_function] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_BANG] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(151),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(153),
    [anon_sym_declare] = ACTIONS(155),
    [anon_sym_typeset] = ACTIONS(155),
    [anon_sym_export] = ACTIONS(155),
    [anon_sym_readonly] = ACTIONS(155),
    [anon_sym_local] = ACTIONS(155),
    [anon_sym_unset] = ACTIONS(157),
    [anon_sym_unsetenv] = ACTIONS(157),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(37),
    [anon_sym_LT_AMP] = ACTIONS(37),
    [anon_sym_GT_AMP] = ACTIONS(37),
    [anon_sym_GT_PIPE] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(159),
    [sym__special_character] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [sym_raw_string] = ACTIONS(165),
    [sym_ansi_c_string] = ACTIONS(165),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(167),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(169),
    [anon_sym_BQUOTE] = ACTIONS(171),
    [anon_sym_LT_LPAREN] = ACTIONS(173),
    [anon_sym_GT_LPAREN] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(55),
    [sym_variable_name] = ACTIONS(175),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 1,
      sym__simple_heredoc_body,
    ACTIONS(449), 1,
      sym__heredoc_body_beginning,
    STATE(2823), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(445), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [64] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 1,
      sym__simple_heredoc_body,
    ACTIONS(449), 1,
      sym__heredoc_body_beginning,
    STATE(2818), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(453), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [128] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(460), 1,
      anon_sym_DOLLAR,
    ACTIONS(463), 1,
      sym__special_character,
    ACTIONS(466), 1,
      anon_sym_DQUOTE,
    ACTIONS(469), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(472), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(475), 1,
      anon_sym_BQUOTE,
    ACTIONS(481), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(484), 1,
      sym_file_descriptor,
    ACTIONS(486), 1,
      sym_variable_name,
    STATE(310), 1,
      aux_sym__literal_repeat1,
    STATE(3244), 1,
      sym_subscript,
    ACTIONS(478), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(455), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(160), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(278), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(458), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [211] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 1,
      sym__simple_heredoc_body,
    ACTIONS(449), 1,
      sym__heredoc_body_beginning,
    STATE(2863), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(453), 3,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [274] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(493), 1,
      anon_sym_DOLLAR,
    ACTIONS(495), 1,
      sym__special_character,
    ACTIONS(497), 1,
      anon_sym_DQUOTE,
    ACTIONS(499), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(501), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(503), 1,
      anon_sym_BQUOTE,
    ACTIONS(507), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(509), 1,
      sym_file_descriptor,
    ACTIONS(511), 1,
      sym_variable_name,
    STATE(310), 1,
      aux_sym__literal_repeat1,
    STATE(3244), 1,
      sym_subscript,
    ACTIONS(505), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(489), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(163), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(278), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(491), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [357] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(493), 1,
      anon_sym_DOLLAR,
    ACTIONS(495), 1,
      sym__special_character,
    ACTIONS(497), 1,
      anon_sym_DQUOTE,
    ACTIONS(499), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(501), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(503), 1,
      anon_sym_BQUOTE,
    ACTIONS(511), 1,
      sym_variable_name,
    ACTIONS(515), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(517), 1,
      sym_file_descriptor,
    STATE(310), 1,
      aux_sym__literal_repeat1,
    STATE(3244), 1,
      sym_subscript,
    ACTIONS(505), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(489), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(160), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(278), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(513), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [440] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(519), 1,
      sym__simple_heredoc_body,
    ACTIONS(521), 1,
      sym__heredoc_body_beginning,
    STATE(2972), 1,
      sym_heredoc_body,
    ACTIONS(523), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(259), 42,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [501] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 1,
      sym__simple_heredoc_body,
    ACTIONS(449), 1,
      sym__heredoc_body_beginning,
    STATE(2889), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(445), 3,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [564] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 1,
      anon_sym_DQUOTE,
    ACTIONS(529), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(531), 1,
      sym_file_descriptor,
    STATE(312), 1,
      sym_string,
    ACTIONS(527), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(525), 33,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [626] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 1,
      sym_file_descriptor,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(537), 1,
      sym__special_character,
    ACTIONS(539), 1,
      anon_sym_DQUOTE,
    ACTIONS(541), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(543), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(545), 1,
      anon_sym_BQUOTE,
    ACTIONS(549), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(551), 1,
      sym_variable_name,
    STATE(487), 1,
      aux_sym__literal_repeat1,
    STATE(3237), 1,
      sym_subscript,
    ACTIONS(547), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(533), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(169), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(302), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(491), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [708] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(484), 1,
      sym_file_descriptor,
    ACTIONS(556), 1,
      anon_sym_DOLLAR,
    ACTIONS(559), 1,
      sym__special_character,
    ACTIONS(562), 1,
      anon_sym_DQUOTE,
    ACTIONS(565), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(568), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(571), 1,
      anon_sym_BQUOTE,
    ACTIONS(577), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(580), 1,
      sym_variable_name,
    STATE(487), 1,
      aux_sym__literal_repeat1,
    STATE(3237), 1,
      sym_subscript,
    ACTIONS(574), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(553), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(168), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(302), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(458), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [790] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 1,
      sym_file_descriptor,
    ACTIONS(535), 1,
      anon_sym_DOLLAR,
    ACTIONS(537), 1,
      sym__special_character,
    ACTIONS(539), 1,
      anon_sym_DQUOTE,
    ACTIONS(541), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(543), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(545), 1,
      anon_sym_BQUOTE,
    ACTIONS(551), 1,
      sym_variable_name,
    ACTIONS(583), 1,
      aux_sym__simple_variable_name_token1,
    STATE(487), 1,
      aux_sym__literal_repeat1,
    STATE(3237), 1,
      sym_subscript,
    ACTIONS(547), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(533), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(168), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(302), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(513), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [872] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(219), 1,
      anon_sym_DQUOTE,
    ACTIONS(531), 1,
      sym_file_descriptor,
    ACTIONS(587), 1,
      aux_sym__simple_variable_name_token1,
    STATE(395), 1,
      sym_string,
    ACTIONS(585), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(525), 32,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [933] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(597), 1,
      anon_sym_DOLLAR,
    ACTIONS(600), 1,
      sym__special_character,
    ACTIONS(603), 1,
      anon_sym_DQUOTE,
    ACTIONS(606), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(609), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(612), 1,
      anon_sym_BQUOTE,
    ACTIONS(618), 1,
      sym_file_descriptor,
    STATE(171), 1,
      aux_sym_command_repeat2,
    STATE(308), 1,
      aux_sym__literal_repeat1,
    STATE(524), 1,
      sym_concatenation,
    ACTIONS(594), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(615), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(589), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(284), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(592), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1012] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      anon_sym_RPAREN,
    ACTIONS(519), 1,
      sym__simple_heredoc_body,
    ACTIONS(521), 1,
      sym__heredoc_body_beginning,
    STATE(2917), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1073] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(519), 1,
      sym__simple_heredoc_body,
    ACTIONS(521), 1,
      sym__heredoc_body_beginning,
    STATE(3003), 1,
      sym_heredoc_body,
    ACTIONS(523), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(259), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_done,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1132] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(453), 4,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1187] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(519), 1,
      sym__simple_heredoc_body,
    ACTIONS(521), 1,
      sym__heredoc_body_beginning,
    STATE(2974), 1,
      sym_heredoc_body,
    ACTIONS(523), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(259), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1246] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 1,
      sym_file_descriptor,
    ACTIONS(622), 1,
      anon_sym_DOLLAR,
    ACTIONS(624), 1,
      sym__special_character,
    ACTIONS(626), 1,
      anon_sym_DQUOTE,
    ACTIONS(628), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(630), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(632), 1,
      anon_sym_BQUOTE,
    ACTIONS(636), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(638), 1,
      sym_variable_name,
    STATE(571), 1,
      aux_sym__literal_repeat1,
    STATE(3256), 1,
      sym_subscript,
    ACTIONS(634), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(620), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(194), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(463), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(513), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1327] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(445), 4,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1382] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      ts_builtin_sym_end,
    ACTIONS(642), 1,
      sym__simple_heredoc_body,
    ACTIONS(644), 1,
      sym__heredoc_body_beginning,
    STATE(2956), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1443] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 1,
      sym_file_descriptor,
    ACTIONS(622), 1,
      anon_sym_DOLLAR,
    ACTIONS(624), 1,
      sym__special_character,
    ACTIONS(626), 1,
      anon_sym_DQUOTE,
    ACTIONS(628), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(630), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(632), 1,
      anon_sym_BQUOTE,
    ACTIONS(638), 1,
      sym_variable_name,
    ACTIONS(646), 1,
      aux_sym__simple_variable_name_token1,
    STATE(571), 1,
      aux_sym__literal_repeat1,
    STATE(3256), 1,
      sym_subscript,
    ACTIONS(634), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(620), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(176), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(463), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(491), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1524] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(642), 1,
      sym__simple_heredoc_body,
    ACTIONS(644), 1,
      sym__heredoc_body_beginning,
    ACTIONS(648), 1,
      ts_builtin_sym_end,
    STATE(2952), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1585] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 1,
      anon_sym_DQUOTE,
    ACTIONS(652), 1,
      aux_sym__simple_variable_name_token1,
    STATE(319), 1,
      sym_string,
    ACTIONS(531), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(650), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(525), 31,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [1646] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(657), 1,
      anon_sym_DOLLAR,
    ACTIONS(660), 1,
      sym__special_character,
    ACTIONS(663), 1,
      anon_sym_DQUOTE,
    ACTIONS(666), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(669), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(672), 1,
      anon_sym_BQUOTE,
    ACTIONS(678), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(681), 1,
      sym_variable_name,
    STATE(581), 1,
      aux_sym__literal_repeat1,
    STATE(3268), 1,
      sym_subscript,
    ACTIONS(484), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(675), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(654), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(182), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(466), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(458), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1727] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(445), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [1782] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 1,
      anon_sym_DOLLAR,
    ACTIONS(161), 1,
      sym__special_character,
    ACTIONS(163), 1,
      anon_sym_DQUOTE,
    ACTIONS(167), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(169), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(171), 1,
      anon_sym_BQUOTE,
    ACTIONS(690), 1,
      sym_file_descriptor,
    STATE(171), 1,
      aux_sym_command_repeat2,
    STATE(308), 1,
      aux_sym__literal_repeat1,
    STATE(524), 1,
      sym_concatenation,
    ACTIONS(173), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(688), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(684), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(284), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(686), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1861] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 1,
      anon_sym_DOLLAR,
    ACTIONS(161), 1,
      sym__special_character,
    ACTIONS(163), 1,
      anon_sym_DQUOTE,
    ACTIONS(167), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(169), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(171), 1,
      anon_sym_BQUOTE,
    ACTIONS(694), 1,
      sym_file_descriptor,
    STATE(189), 1,
      aux_sym_command_repeat2,
    STATE(308), 1,
      aux_sym__literal_repeat1,
    STATE(524), 1,
      sym_concatenation,
    ACTIONS(173), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(688), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(684), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(284), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(692), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [1940] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_RPAREN,
    ACTIONS(519), 1,
      sym__simple_heredoc_body,
    ACTIONS(521), 1,
      sym__heredoc_body_beginning,
    STATE(2938), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2001] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(519), 1,
      sym__simple_heredoc_body,
    ACTIONS(521), 1,
      sym__heredoc_body_beginning,
    STATE(2981), 1,
      sym_heredoc_body,
    ACTIONS(523), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(259), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2060] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(698), 1,
      anon_sym_DOLLAR,
    ACTIONS(700), 1,
      sym__special_character,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(706), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(708), 1,
      anon_sym_BQUOTE,
    ACTIONS(712), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(714), 1,
      sym_variable_name,
    STATE(581), 1,
      aux_sym__literal_repeat1,
    STATE(3268), 1,
      sym_subscript,
    ACTIONS(509), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(710), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(696), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(192), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(466), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(491), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [2141] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 1,
      anon_sym_DOLLAR,
    ACTIONS(161), 1,
      sym__special_character,
    ACTIONS(163), 1,
      anon_sym_DQUOTE,
    ACTIONS(167), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(169), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(171), 1,
      anon_sym_BQUOTE,
    ACTIONS(718), 1,
      sym_file_descriptor,
    STATE(171), 1,
      aux_sym_command_repeat2,
    STATE(308), 1,
      aux_sym__literal_repeat1,
    STATE(524), 1,
      sym_concatenation,
    ACTIONS(173), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(688), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(684), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(284), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(716), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [2220] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(722), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(720), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2275] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 1,
      anon_sym_DOLLAR,
    ACTIONS(161), 1,
      sym__special_character,
    ACTIONS(163), 1,
      anon_sym_DQUOTE,
    ACTIONS(167), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(169), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(171), 1,
      anon_sym_BQUOTE,
    ACTIONS(728), 1,
      sym_file_descriptor,
    STATE(184), 1,
      aux_sym_command_repeat2,
    STATE(308), 1,
      aux_sym__literal_repeat1,
    STATE(524), 1,
      sym_concatenation,
    ACTIONS(173), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(688), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(684), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(284), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(726), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [2354] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(698), 1,
      anon_sym_DOLLAR,
    ACTIONS(700), 1,
      sym__special_character,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(704), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(706), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(708), 1,
      anon_sym_BQUOTE,
    ACTIONS(714), 1,
      sym_variable_name,
    ACTIONS(730), 1,
      aux_sym__simple_variable_name_token1,
    STATE(581), 1,
      aux_sym__literal_repeat1,
    STATE(3268), 1,
      sym_subscript,
    ACTIONS(517), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(710), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(696), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(182), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(466), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(513), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [2435] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(732), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(720), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2490] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(484), 1,
      sym_file_descriptor,
    ACTIONS(737), 1,
      anon_sym_DOLLAR,
    ACTIONS(740), 1,
      sym__special_character,
    ACTIONS(743), 1,
      anon_sym_DQUOTE,
    ACTIONS(746), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(749), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(752), 1,
      anon_sym_BQUOTE,
    ACTIONS(758), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(761), 1,
      sym_variable_name,
    STATE(571), 1,
      aux_sym__literal_repeat1,
    STATE(3256), 1,
      sym_subscript,
    ACTIONS(755), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(734), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(194), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(463), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(458), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [2571] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_DQUOTE,
    ACTIONS(768), 1,
      aux_sym__simple_variable_name_token1,
    STATE(461), 1,
      sym_string,
    ACTIONS(531), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(764), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(525), 31,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [2632] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(453), 4,
      anon_sym_esac,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2687] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(732), 4,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(720), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2742] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(722), 4,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
    ACTIONS(720), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2797] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      anon_sym_BQUOTE,
    ACTIONS(519), 1,
      sym__simple_heredoc_body,
    ACTIONS(521), 1,
      sym__heredoc_body_beginning,
    STATE(2949), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 38,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [2857] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(531), 1,
      sym_file_descriptor,
    ACTIONS(772), 1,
      aux_sym__simple_variable_name_token1,
    STATE(544), 1,
      sym_string,
    ACTIONS(770), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(525), 31,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [2917] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 1,
      anon_sym_DOLLAR,
    ACTIONS(217), 1,
      sym__special_character,
    ACTIONS(219), 1,
      anon_sym_DQUOTE,
    ACTIONS(223), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(225), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(227), 1,
      anon_sym_BQUOTE,
    ACTIONS(728), 1,
      sym_file_descriptor,
    STATE(202), 1,
      aux_sym_command_repeat2,
    STATE(479), 1,
      aux_sym__literal_repeat1,
    STATE(672), 1,
      sym_concatenation,
    ACTIONS(229), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(776), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(774), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(301), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(726), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [2995] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 1,
      anon_sym_DOLLAR,
    ACTIONS(217), 1,
      sym__special_character,
    ACTIONS(219), 1,
      anon_sym_DQUOTE,
    ACTIONS(223), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(225), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(227), 1,
      anon_sym_BQUOTE,
    ACTIONS(690), 1,
      sym_file_descriptor,
    STATE(212), 1,
      aux_sym_command_repeat2,
    STATE(479), 1,
      aux_sym__literal_repeat1,
    STATE(672), 1,
      sym_concatenation,
    ACTIONS(229), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(776), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(774), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(301), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(686), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3073] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_BQUOTE,
    ACTIONS(519), 1,
      sym__simple_heredoc_body,
    ACTIONS(521), 1,
      sym__heredoc_body_beginning,
    STATE(2950), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 38,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [3133] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 1,
      anon_sym_DOLLAR,
    ACTIONS(217), 1,
      sym__special_character,
    ACTIONS(219), 1,
      anon_sym_DQUOTE,
    ACTIONS(223), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(225), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(227), 1,
      anon_sym_BQUOTE,
    ACTIONS(694), 1,
      sym_file_descriptor,
    STATE(217), 1,
      aux_sym_command_repeat2,
    STATE(479), 1,
      aux_sym__literal_repeat1,
    STATE(672), 1,
      sym_concatenation,
    ACTIONS(229), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(776), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(774), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(301), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(692), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3211] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 1,
      sym_file_descriptor,
    ACTIONS(622), 1,
      anon_sym_DOLLAR,
    ACTIONS(624), 1,
      sym__special_character,
    ACTIONS(626), 1,
      anon_sym_DQUOTE,
    ACTIONS(628), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(630), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(638), 1,
      sym_variable_name,
    ACTIONS(778), 1,
      aux_sym__simple_variable_name_token1,
    STATE(571), 1,
      aux_sym__literal_repeat1,
    STATE(3256), 1,
      sym_subscript,
    ACTIONS(634), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(620), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(213), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(463), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(491), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [3289] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(782), 1,
      aux_sym__simple_variable_name_token1,
    STATE(602), 1,
      sym_string,
    ACTIONS(531), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(780), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(525), 30,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [3349] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(789), 1,
      anon_sym_DOLLAR,
    ACTIONS(792), 1,
      sym__special_character,
    ACTIONS(795), 1,
      anon_sym_DQUOTE,
    ACTIONS(798), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(801), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(804), 1,
      anon_sym_BQUOTE,
    ACTIONS(810), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(813), 1,
      sym_file_descriptor,
    STATE(543), 1,
      aux_sym__literal_repeat1,
    ACTIONS(807), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(207), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(784), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(309), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(787), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3425] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(817), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(815), 42,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [3477] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(259), 42,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [3529] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(539), 1,
      anon_sym_DQUOTE,
    ACTIONS(821), 1,
      aux_sym__simple_variable_name_token1,
    STATE(448), 1,
      sym_string,
    ACTIONS(531), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(819), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(525), 30,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [3589] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      anon_sym_DOLLAR,
    ACTIONS(829), 1,
      sym__special_character,
    ACTIONS(831), 1,
      anon_sym_DQUOTE,
    ACTIONS(833), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(835), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(837), 1,
      anon_sym_BQUOTE,
    ACTIONS(841), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(843), 1,
      sym_file_descriptor,
    STATE(543), 1,
      aux_sym__literal_repeat1,
    ACTIONS(839), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(218), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(823), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(309), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(825), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3665] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 1,
      sym_file_descriptor,
    ACTIONS(851), 1,
      anon_sym_DOLLAR,
    ACTIONS(854), 1,
      sym__special_character,
    ACTIONS(857), 1,
      anon_sym_DQUOTE,
    ACTIONS(860), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(863), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(866), 1,
      anon_sym_BQUOTE,
    STATE(212), 1,
      aux_sym_command_repeat2,
    STATE(479), 1,
      aux_sym__literal_repeat1,
    STATE(672), 1,
      sym_concatenation,
    ACTIONS(848), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(869), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(845), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(301), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(592), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [3743] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 1,
      sym_file_descriptor,
    ACTIONS(622), 1,
      anon_sym_DOLLAR,
    ACTIONS(624), 1,
      sym__special_character,
    ACTIONS(626), 1,
      anon_sym_DQUOTE,
    ACTIONS(628), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(630), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(636), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(638), 1,
      sym_variable_name,
    STATE(571), 1,
      aux_sym__literal_repeat1,
    STATE(3256), 1,
      sym_subscript,
    ACTIONS(634), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(620), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(194), 3,
      sym_variable_assignment,
      sym_concatenation,
      aux_sym_declaration_command_repeat1,
    STATE(463), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(513), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [3821] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(519), 1,
      sym__simple_heredoc_body,
    ACTIONS(521), 1,
      sym__heredoc_body_beginning,
    STATE(2998), 1,
      sym_heredoc_body,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [3879] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(874), 1,
      anon_sym_DQUOTE,
    ACTIONS(876), 1,
      aux_sym__simple_variable_name_token1,
    STATE(630), 1,
      sym_string,
    ACTIONS(531), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(872), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(525), 30,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [3939] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 1,
      sym_file_descriptor,
    ACTIONS(831), 1,
      anon_sym_DQUOTE,
    ACTIONS(880), 1,
      aux_sym__simple_variable_name_token1,
    STATE(517), 1,
      sym_string,
    ACTIONS(878), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(525), 31,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [3999] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(215), 1,
      anon_sym_DOLLAR,
    ACTIONS(217), 1,
      sym__special_character,
    ACTIONS(219), 1,
      anon_sym_DQUOTE,
    ACTIONS(223), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(225), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(227), 1,
      anon_sym_BQUOTE,
    ACTIONS(718), 1,
      sym_file_descriptor,
    STATE(212), 1,
      aux_sym_command_repeat2,
    STATE(479), 1,
      aux_sym__literal_repeat1,
    STATE(672), 1,
      sym_concatenation,
    ACTIONS(229), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(776), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(774), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(301), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(716), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4077] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      anon_sym_DOLLAR,
    ACTIONS(829), 1,
      sym__special_character,
    ACTIONS(831), 1,
      anon_sym_DQUOTE,
    ACTIONS(833), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(835), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(837), 1,
      anon_sym_BQUOTE,
    ACTIONS(884), 1,
      aux_sym__simple_variable_name_token1,
    ACTIONS(886), 1,
      sym_file_descriptor,
    STATE(543), 1,
      aux_sym__literal_repeat1,
    ACTIONS(839), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(207), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(823), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(309), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(882), 22,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_esac,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4153] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(894), 1,
      anon_sym_DOLLAR,
    ACTIONS(897), 1,
      sym__special_character,
    ACTIONS(900), 1,
      anon_sym_DQUOTE,
    ACTIONS(903), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(906), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(909), 1,
      anon_sym_BQUOTE,
    STATE(219), 1,
      aux_sym_command_repeat2,
    STATE(617), 1,
      aux_sym__literal_repeat1,
    STATE(832), 1,
      sym_concatenation,
    ACTIONS(618), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(891), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(912), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(888), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(475), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(592), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4230] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(107), 1,
      anon_sym_BQUOTE,
    ACTIONS(690), 1,
      sym_file_descriptor,
    STATE(228), 1,
      aux_sym_command_repeat2,
    STATE(708), 1,
      aux_sym__literal_repeat1,
    STATE(804), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(917), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(915), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(484), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(686), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4307] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(107), 1,
      anon_sym_BQUOTE,
    ACTIONS(728), 1,
      sym_file_descriptor,
    STATE(220), 1,
      aux_sym_command_repeat2,
    STATE(708), 1,
      aux_sym__literal_repeat1,
    STATE(804), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(917), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(915), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(484), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(726), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4384] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 1,
      sym_file_descriptor,
    ACTIONS(921), 1,
      anon_sym_DQUOTE,
    ACTIONS(923), 1,
      aux_sym__simple_variable_name_token1,
    STATE(612), 1,
      sym_string,
    ACTIONS(919), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(525), 30,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [4443] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(927), 1,
      anon_sym_DQUOTE,
    ACTIONS(929), 1,
      aux_sym__simple_variable_name_token1,
    STATE(766), 1,
      sym_string,
    ACTIONS(531), 3,
      sym_file_descriptor,
      sym_variable_name,
      ts_builtin_sym_end,
    ACTIONS(925), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(525), 28,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [4502] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 1,
      anon_sym_DQUOTE,
    ACTIONS(933), 1,
      aux_sym__simple_variable_name_token1,
    STATE(558), 1,
      sym_string,
    ACTIONS(531), 3,
      sym_file_descriptor,
      sym_variable_name,
      ts_builtin_sym_end,
    ACTIONS(931), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(525), 28,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [4561] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(886), 1,
      sym_file_descriptor,
    ACTIONS(921), 1,
      anon_sym_DQUOTE,
    ACTIONS(937), 1,
      anon_sym_DOLLAR,
    ACTIONS(939), 1,
      sym__special_character,
    ACTIONS(941), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(943), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(945), 1,
      anon_sym_BQUOTE,
    ACTIONS(949), 1,
      aux_sym__simple_variable_name_token1,
    STATE(702), 1,
      aux_sym__literal_repeat1,
    ACTIONS(947), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(231), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(935), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(486), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(882), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4636] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(626), 1,
      anon_sym_DQUOTE,
    ACTIONS(953), 1,
      aux_sym__simple_variable_name_token1,
    STATE(699), 1,
      sym_string,
    ACTIONS(531), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(951), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(525), 29,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [4695] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      anon_sym_DOLLAR,
    ACTIONS(41), 1,
      sym__special_character,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(49), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(51), 1,
      anon_sym_BQUOTE,
    STATE(234), 1,
      aux_sym_command_repeat2,
    STATE(617), 1,
      aux_sym__literal_repeat1,
    STATE(832), 1,
      sym_concatenation,
    ACTIONS(53), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(728), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(957), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(955), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(475), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(726), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4772] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 1,
      sym_file_descriptor,
    ACTIONS(965), 1,
      anon_sym_DOLLAR,
    ACTIONS(968), 1,
      sym__special_character,
    ACTIONS(971), 1,
      anon_sym_DQUOTE,
    ACTIONS(974), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(977), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(980), 1,
      anon_sym_BQUOTE,
    STATE(228), 1,
      aux_sym_command_repeat2,
    STATE(708), 1,
      aux_sym__literal_repeat1,
    STATE(804), 1,
      sym_concatenation,
    ACTIONS(962), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(983), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(959), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(484), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(592), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4849] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(107), 1,
      anon_sym_BQUOTE,
    ACTIONS(718), 1,
      sym_file_descriptor,
    STATE(228), 1,
      aux_sym_command_repeat2,
    STATE(708), 1,
      aux_sym__literal_repeat1,
    STATE(804), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(917), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(915), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(484), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(716), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [4926] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 1,
      sym_file_descriptor,
    ACTIONS(921), 1,
      anon_sym_DQUOTE,
    ACTIONS(937), 1,
      anon_sym_DOLLAR,
    ACTIONS(939), 1,
      sym__special_character,
    ACTIONS(941), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(943), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(945), 1,
      anon_sym_BQUOTE,
    ACTIONS(986), 1,
      aux_sym__simple_variable_name_token1,
    STATE(702), 1,
      aux_sym__literal_repeat1,
    ACTIONS(947), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(225), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(935), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(486), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(825), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5001] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(813), 1,
      sym_file_descriptor,
    ACTIONS(991), 1,
      anon_sym_DOLLAR,
    ACTIONS(994), 1,
      sym__special_character,
    ACTIONS(997), 1,
      anon_sym_DQUOTE,
    ACTIONS(1000), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1003), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1006), 1,
      anon_sym_BQUOTE,
    ACTIONS(1012), 1,
      aux_sym__simple_variable_name_token1,
    STATE(702), 1,
      aux_sym__literal_repeat1,
    ACTIONS(1009), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(231), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(988), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(486), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(787), 21,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_SEMI_AMP,
      anon_sym_SEMI_SEMI_AMP,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5076] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(107), 1,
      anon_sym_BQUOTE,
    ACTIONS(694), 1,
      sym_file_descriptor,
    STATE(229), 1,
      aux_sym_command_repeat2,
    STATE(708), 1,
      aux_sym__literal_repeat1,
    STATE(804), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(917), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(915), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(484), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(692), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5153] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      anon_sym_DOLLAR,
    ACTIONS(41), 1,
      sym__special_character,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(49), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(51), 1,
      anon_sym_BQUOTE,
    STATE(219), 1,
      aux_sym_command_repeat2,
    STATE(617), 1,
      aux_sym__literal_repeat1,
    STATE(832), 1,
      sym_concatenation,
    ACTIONS(53), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(718), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(957), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(955), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(475), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(716), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5230] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      anon_sym_DOLLAR,
    ACTIONS(41), 1,
      sym__special_character,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(49), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(51), 1,
      anon_sym_BQUOTE,
    STATE(219), 1,
      aux_sym_command_repeat2,
    STATE(617), 1,
      aux_sym__literal_repeat1,
    STATE(832), 1,
      sym_concatenation,
    ACTIONS(53), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(690), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(957), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(955), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(475), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(686), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5307] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 1,
      anon_sym_DQUOTE,
    ACTIONS(1019), 1,
      aux_sym__simple_variable_name_token1,
    STATE(866), 1,
      sym_string,
    ACTIONS(531), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(1015), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(525), 29,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [5366] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      anon_sym_DOLLAR,
    ACTIONS(41), 1,
      sym__special_character,
    ACTIONS(43), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(49), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(51), 1,
      anon_sym_BQUOTE,
    STATE(233), 1,
      aux_sym_command_repeat2,
    STATE(617), 1,
      aux_sym__literal_repeat1,
    STATE(832), 1,
      sym_concatenation,
    ACTIONS(53), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(694), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(957), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(955), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(475), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(692), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5443] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(690), 1,
      sym_file_descriptor,
    STATE(228), 1,
      aux_sym_command_repeat2,
    STATE(708), 1,
      aux_sym__literal_repeat1,
    STATE(804), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(917), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(915), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(484), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(686), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [5517] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 1,
      sym_file_descriptor,
    ACTIONS(1023), 1,
      anon_sym_DQUOTE,
    ACTIONS(1025), 1,
      aux_sym__simple_variable_name_token1,
    STATE(811), 1,
      sym_string,
    ACTIONS(1021), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(525), 29,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [5575] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1029), 1,
      anon_sym_DOLLAR,
    ACTIONS(1031), 1,
      sym__special_character,
    ACTIONS(1033), 1,
      anon_sym_DQUOTE,
    ACTIONS(1035), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1037), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1039), 1,
      anon_sym_BQUOTE,
    ACTIONS(1043), 1,
      aux_sym__simple_variable_name_token1,
    STATE(863), 1,
      aux_sym__literal_repeat1,
    ACTIONS(843), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(1041), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(250), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1027), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(587), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(825), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5649] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(843), 1,
      sym_file_descriptor,
    ACTIONS(1023), 1,
      anon_sym_DQUOTE,
    ACTIONS(1047), 1,
      anon_sym_DOLLAR,
    ACTIONS(1049), 1,
      sym__special_character,
    ACTIONS(1051), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1053), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1055), 1,
      anon_sym_BQUOTE,
    ACTIONS(1059), 1,
      aux_sym__simple_variable_name_token1,
    STATE(872), 1,
      aux_sym__literal_repeat1,
    ACTIONS(1057), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(247), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1045), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(572), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(825), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [5723] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      ts_builtin_sym_end,
    ACTIONS(451), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(443), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [5775] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(817), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(815), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_done,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [5825] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(259), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [5875] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1061), 1,
      ts_builtin_sym_end,
    ACTIONS(724), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(720), 39,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [5927] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      sym__special_character,
    ACTIONS(99), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(105), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(694), 1,
      sym_file_descriptor,
    STATE(257), 1,
      aux_sym_command_repeat2,
    STATE(708), 1,
      aux_sym__literal_repeat1,
    STATE(804), 1,
      sym_concatenation,
    ACTIONS(109), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    ACTIONS(917), 2,
      anon_sym_EQ_TILDE,
      anon_sym_EQ_EQ,
    ACTIONS(915), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(484), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(692), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_BQUOTE,
      anon_sym_AMP,
  [6001] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(813), 1,
      sym_file_descriptor,
    ACTIONS(1066), 1,
      anon_sym_DOLLAR,
    ACTIONS(1069), 1,
      sym__special_character,
    ACTIONS(1072), 1,
      anon_sym_DQUOTE,
    ACTIONS(1075), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1078), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1081), 1,
      anon_sym_BQUOTE,
    ACTIONS(1087), 1,
      aux_sym__simple_variable_name_token1,
    STATE(872), 1,
      aux_sym__literal_repeat1,
    ACTIONS(1084), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(246), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1063), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(572), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(787), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [6075] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(886), 1,
      sym_file_descriptor,
    ACTIONS(1023), 1,
      anon_sym_DQUOTE,
    ACTIONS(1047), 1,
      anon_sym_DOLLAR,
    ACTIONS(1049), 1,
      sym__special_character,
    ACTIONS(1051), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1053), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1055), 1,
      anon_sym_BQUOTE,
    ACTIONS(1090), 1,
      aux_sym__simple_variable_name_token1,
    STATE(872), 1,
      aux_sym__literal_repeat1,
    ACTIONS(1057), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(246), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1045), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(572), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(882), 20,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_RPAREN,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [6149] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(259), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_done,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [6199] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1033), 1,
      anon_sym_DQUOTE,
    ACTIONS(1094), 1,
      aux_sym__simple_variable_name_token1,
    STATE(839), 1,
      sym_string,
    ACTIONS(531), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(1092), 9,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_QMARK,
      anon_sym_DOLLAR,
      anon_sym_POUND,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_0,
      anon_sym__,
    ACTIONS(525), 28,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      sym__special_character,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
      anon_sym_AMP,
  [6257] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1029), 1,
      anon_sym_DOLLAR,
    ACTIONS(1031), 1,
      sym__special_character,
    ACTIONS(1033), 1,
      anon_sym_DQUOTE,
    ACTIONS(1035), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1037), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1039), 1,
      anon_sym_BQUOTE,
    ACTIONS(1096), 1,
      aux_sym__simple_variable_name_token1,
    STATE(863), 1,
      aux_sym__literal_repeat1,
    ACTIONS(886), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(1041), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(251), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1027), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(587), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(882), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [6331] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1101), 1,
      anon_sym_DOLLAR,
    ACTIONS(1104), 1,
      sym__special_character,
    ACTIONS(1107), 1,
      anon_sym_DQUOTE,
    ACTIONS(1110), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(1113), 1,
      anon_sym_DOLLAR_LPAREN,
    ACTIONS(1116), 1,
      anon_sym_BQUOTE,
    ACTIONS(1122), 1,
      aux_sym__simple_variable_name_token1,
    STATE(863), 1,
      aux_sym__literal_repeat1,
    ACTIONS(813), 2,
      sym_file_descriptor,
      ts_builtin_sym_end,
    ACTIONS(1119), 2,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
    STATE(251), 2,
      sym_concatenation,
      aux_sym_unset_command_repeat1,
    ACTIONS(1098), 3,
      sym_raw_string,
      sym_ansi_c_string,
      sym_word,
    STATE(587), 6,
      sym_string,
      sym_translated_string,
      sym_simple_expansion,
      sym_expansion,
      sym_command_substitution,
      sym_process_substitution,
    ACTIONS(787), 19,
      anon_sym_LF,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_SEMI_SEMI,
      anon_sym_PIPE_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_LT_LT,
      anon_sym_LT_LT_DASH,
      anon_sym_LT_LT_LT,
      anon_sym_AMP,
  [6405] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(259), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_AMP_GT,
      anon_sym_AMP_GT_GT,
      anon_sym_LT_AMP,
      anon_sym_GT_AMP,
      anon_sym_GT_PIPE,
      anon_sym_DOLLAR,
      sym__special_character,
      anon_sym_DQUOTE,
      sym_raw_string,
      sym_ansi_c_string,
      anon_sym_DOLLAR_LBRACE,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_LT_LPAREN,
      anon_sym_GT_LPAREN,
      sym_word,
  [6455] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(817), 2,
      sym_file_descriptor,
      sym_variable_name,
    ACTIONS(815), 40,
      anon_sym_for,
      anon_sym_select,
      anon_sym_LPAREN_LPAREN,
      anon_sym_while,
      anon_sym_until,
      anon_sym_if,
      anon_sym_fi,
      anon_sym_case,
      anon_sym_function,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG,
      anon_sym_LBRACK,
      anon_sym_LBRACK_LBRACK,
      anon_sym_declare,
      anon_sym_typeset,
      anon_sym_export,
      anon_sym_readonly,
      anon_sym_local,
      anon_sym_unset,
      anon_sym_unsetenv,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_