/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex;

import com.googlecode.d2j.DexType;
import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.MethodHandle;
import com.googlecode.d2j.Proto;
import com.googlecode.d2j.Visibility;
import com.googlecode.d2j.converter.Dex2IRConverter;
import com.googlecode.d2j.converter.IR2JConverter;
import com.googlecode.d2j.dex.ClassVisitorFactory;
import com.googlecode.d2j.dex.DexFix;
import com.googlecode.d2j.node.DexAnnotationNode;
import com.googlecode.d2j.node.DexClassNode;
import com.googlecode.d2j.node.DexFieldNode;
import com.googlecode.d2j.node.DexFileNode;
import com.googlecode.d2j.node.DexMethodNode;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.ts.AggTransformer;
import com.googlecode.dex2jar.ir.ts.CleanLabel;
import com.googlecode.dex2jar.ir.ts.DeadCodeTransformer;
import com.googlecode.dex2jar.ir.ts.EndRemover;
import com.googlecode.dex2jar.ir.ts.ExceptionHandlerTrim;
import com.googlecode.dex2jar.ir.ts.Ir2JRegAssignTransformer;
import com.googlecode.dex2jar.ir.ts.MultiArrayTransformer;
import com.googlecode.dex2jar.ir.ts.NewTransformer;
import com.googlecode.dex2jar.ir.ts.NpeTransformer;
import com.googlecode.dex2jar.ir.ts.RemoveConstantFromSSA;
import com.googlecode.dex2jar.ir.ts.RemoveLocalFromSSA;
import com.googlecode.dex2jar.ir.ts.TypeTransformer;
import com.googlecode.dex2jar.ir.ts.UnSSATransformer;
import com.googlecode.dex2jar.ir.ts.VoidInvokeTransformer;
import com.googlecode.dex2jar.ir.ts.ZeroTransformer;
import com.googlecode.dex2jar.ir.ts.array.FillArrayTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.InnerClassNode;

public class Dex2Asm {
    protected static final int ACC_INTERFACE_ABSTRACT = 1536;
    private static final int NO_CODE_MASK = 9472;
    protected static final CleanLabel T_cleanLabel = new CleanLabel();
    protected static final EndRemover T_endRemove = new EndRemover();
    protected static final Ir2JRegAssignTransformer T_ir2jRegAssign = new Ir2JRegAssignTransformer();
    protected static final NewTransformer T_new = new NewTransformer();
    protected static final RemoveConstantFromSSA T_removeConst = new RemoveConstantFromSSA();
    protected static final RemoveLocalFromSSA T_removeLocal = new RemoveLocalFromSSA();
    protected static final ExceptionHandlerTrim T_trimEx = new ExceptionHandlerTrim();
    protected static final TypeTransformer T_type = new TypeTransformer();
    protected static final DeadCodeTransformer T_deadCode = new DeadCodeTransformer();
    protected static final FillArrayTransformer T_fillArray = new FillArrayTransformer();
    protected static final AggTransformer T_agg = new AggTransformer();
    protected static final UnSSATransformer T_unssa = new UnSSATransformer();
    protected static final ZeroTransformer T_zero = new ZeroTransformer();
    protected static final VoidInvokeTransformer T_voidInvoke = new VoidInvokeTransformer();
    protected static final NpeTransformer T_npe = new NpeTransformer();
    protected static final MultiArrayTransformer T_multiArray = new MultiArrayTransformer();
    private static final Comparator<InnerClassNode> INNER_CLASS_NODE_COMPARATOR = new Comparator<InnerClassNode>(){

        @Override
        public int compare(InnerClassNode o1, InnerClassNode o2) {
            return o1.name.compareTo(o2.name);
        }
    };

    private static int clearClassAccess(boolean isInner, int access) {
        if ((access & 0x200) == 0) {
            access |= 0x20;
        }
        if (isInner && ((access &= 0xFFFFFFF5) & 4) != 0) {
            access &= 0xFFFFFFFB;
            access |= 1;
        }
        return access &= 0xFFFDFFFF;
    }

    private static int clearInnerAccess(int access) {
        if (0 != ((access &= 0xFFFFFFDF) & 2)) {
            access &= 0xFFFFFFFA;
        } else if (0 != (access & 4)) {
            access &= 0xFFFFFFFE;
        }
        return access;
    }

    protected static String toInternalName(DexType type) {
        return Dex2Asm.toInternalName(type.desc);
    }

    protected static String toInternalName(String desc) {
        return Type.getType((String)desc).getInternalName();
    }

    public static void accept(DexAnnotationNode ann, ClassVisitor v) {
        AnnotationVisitor av = v.visitAnnotation(ann.type, ann.visibility != Visibility.BUILD);
        if (av != null) {
            Dex2Asm.accept(ann.items, av);
            av.visitEnd();
        }
    }

    public static void accept(List<DexAnnotationNode> anns, ClassVisitor cv) {
        if (anns != null) {
            for (DexAnnotationNode ann : anns) {
                if (ann.visibility == Visibility.SYSTEM) continue;
                Dex2Asm.accept(ann, cv);
            }
        }
    }

    public static void accept(List<DexAnnotationNode> anns, FieldVisitor fv) {
        if (anns != null) {
            for (DexAnnotationNode ann : anns) {
                if (ann.visibility == Visibility.SYSTEM) continue;
                Dex2Asm.accept(ann, fv);
            }
        }
    }

    public static void accept(List<DexAnnotationNode> anns, MethodVisitor mv) {
        if (anns != null) {
            for (DexAnnotationNode ann : anns) {
                if (ann.visibility == Visibility.SYSTEM) continue;
                Dex2Asm.accept(ann, mv);
            }
        }
    }

    public static void accept(DexAnnotationNode ann, MethodVisitor v) {
        AnnotationVisitor av = v.visitAnnotation(ann.type, ann.visibility != Visibility.BUILD);
        if (av != null) {
            Dex2Asm.accept(ann.items, av);
            av.visitEnd();
        }
    }

    public static void acceptParameter(DexAnnotationNode ann, int index, MethodVisitor v) {
        AnnotationVisitor av = v.visitParameterAnnotation(index, ann.type, ann.visibility != Visibility.BUILD);
        if (av != null) {
            Dex2Asm.accept(ann.items, av);
            av.visitEnd();
        }
    }

    public static void accept(DexAnnotationNode ann, FieldVisitor v) {
        AnnotationVisitor av = v.visitAnnotation(ann.type, ann.visibility != Visibility.BUILD);
        if (av != null) {
            Dex2Asm.accept(ann.items, av);
            av.visitEnd();
        }
    }

    public static void accept(List<DexAnnotationNode.Item> items, AnnotationVisitor av) {
        for (DexAnnotationNode.Item item : items) {
            Dex2Asm.accept(av, item.name, item.value);
        }
    }

    private static void accept(AnnotationVisitor dav, String name, Object o) {
        if (o instanceof Object[]) {
            AnnotationVisitor arrayVisitor = dav.visitArray(name);
            if (arrayVisitor != null) {
                Object[] array;
                for (Object e : array = (Object[])o) {
                    Dex2Asm.accept(arrayVisitor, null, e);
                }
                arrayVisitor.visitEnd();
            }
        } else if (o instanceof DexAnnotationNode) {
            DexAnnotationNode ann = (DexAnnotationNode)o;
            AnnotationVisitor av = dav.visitAnnotation(name, ann.type);
            if (av != null) {
                for (DexAnnotationNode.Item item : ann.items) {
                    Dex2Asm.accept(av, item.name, item.value);
                }
                av.visitEnd();
            }
        } else if (o instanceof Field) {
            Field f = (Field)o;
            dav.visitEnum(name, f.getType(), f.getName());
        } else if (o instanceof DexType) {
            dav.visit(name, (Object)Type.getType((String)((DexType)o).desc));
        } else if (o instanceof Method) {
            System.err.println("WARN: ignored method annotation value");
        } else if (o == null) {
            System.err.println("WARN: ignored null annotation value");
        } else {
            dav.visit(name, o);
        }
    }

    private static MethodVisitor collectBasicMethodInfo(DexMethodNode methodNode, ClassVisitor cv) {
        String[] xthrows = null;
        String signature = null;
        if (methodNode.anns != null) {
            block8: for (DexAnnotationNode ann : methodNode.anns) {
                if (ann.visibility != Visibility.SYSTEM) continue;
                switch (ann.type) {
                    case "Ldalvik/annotation/Throws;": {
                        Object[] strs = (Object[])Dex2Asm.findAnnotationAttribute(ann, "value");
                        if (strs == null) continue block8;
                        xthrows = new String[strs.length];
                        for (int i = 0; i < strs.length; ++i) {
                            DexType type = (DexType)strs[i];
                            xthrows[i] = Dex2Asm.toInternalName(type);
                        }
                        continue block8;
                    }
                    case "Ldalvik/annotation/Signature;": {
                        Object[] strs = (Object[])Dex2Asm.findAnnotationAttribute(ann, "value");
                        if (strs == null) break;
                        StringBuilder sb = new StringBuilder();
                        for (Object str : strs) {
                            sb.append(str);
                        }
                        signature = sb.toString();
                    }
                }
            }
        }
        int access = methodNode.access;
        int cleanFlag = -196609;
        return cv.visitMethod(access &= 0xFFFCFFFF, methodNode.method.getName(), methodNode.method.getDesc(), signature, xthrows);
    }

    protected static Map<String, Clz> collectClzInfo(DexFileNode fileNode) {
        HashMap<String, Clz> classes = new HashMap<String, Clz>();
        for (DexClassNode classNode : fileNode.clzs) {
            Clz clz = Dex2Asm.get(classes, classNode.className);
            clz.access = clz.access & 0xFFFFF9FF | classNode.access;
            if (classNode.anns == null) continue;
            block13: for (DexAnnotationNode ann : classNode.anns) {
                if (ann.visibility != Visibility.SYSTEM) continue;
                switch (ann.type) {
                    case "Ldalvik/annotation/EnclosingClass;": {
                        Clz enclosingClass;
                        DexType type = (DexType)Dex2Asm.findAnnotationAttribute(ann, "value");
                        clz.enclosingClass = enclosingClass = Dex2Asm.get(classes, type.desc);
                        enclosingClass.addInner(clz);
                        break;
                    }
                    case "Ldalvik/annotation/EnclosingMethod;": {
                        Clz enclosingClass;
                        Method m = (Method)Dex2Asm.findAnnotationAttribute(ann, "value");
                        clz.enclosingClass = enclosingClass = Dex2Asm.get(classes, m.getOwner());
                        clz.enclosingMethod = m;
                        enclosingClass.addInner(clz);
                        break;
                    }
                    case "Ldalvik/annotation/InnerClass;": {
                        for (DexAnnotationNode.Item it : ann.items) {
                            if ("accessFlags".equals(it.name)) {
                                clz.access |= (Integer)it.value & 0xFFFFF9FF;
                                continue;
                            }
                            if (!"name".equals(it.name)) continue;
                            clz.innerName = (String)it.value;
                        }
                        continue block13;
                    }
                    case "Ldalvik/annotation/MemberClasses;": {
                        Object[] ts;
                        for (Object v : ts = (Object[])Dex2Asm.findAnnotationAttribute(ann, "value")) {
                            DexType type = (DexType)v;
                            Clz inner = Dex2Asm.get(classes, type.desc);
                            clz.addInner(inner);
                            inner.enclosingClass = clz;
                        }
                        break;
                    }
                }
            }
        }
        return classes;
    }

    public void convertClass(DexClassNode classNode, ClassVisitorFactory cvf, DexFileNode fileNode) {
        this.convertClass(fileNode.dexVersion, classNode, cvf, Dex2Asm.collectClzInfo(fileNode));
    }

    public void convertClass(DexClassNode classNode, ClassVisitorFactory cvf) {
        this.convertClass(0x303335, classNode, cvf);
    }

    public void convertClass(int dexVersion, DexClassNode classNode, ClassVisitorFactory cvf) {
        this.convertClass(dexVersion, classNode, cvf, new HashMap<String, Clz>());
    }

    private static boolean isJavaIdentifier(String str) {
        if (str.length() < 1) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(str.charAt(0))) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            if (Character.isJavaIdentifierPart(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void convertClass(DexClassNode classNode, ClassVisitorFactory cvf, Map<String, Clz> classes) {
        this.convertClass(0x303335, classNode, cvf, classes);
    }

    public void convertClass(DexFileNode dfn, DexClassNode classNode, ClassVisitorFactory cvf, Map<String, Clz> classes) {
        this.convertClass(dfn.dexVersion, classNode, cvf, classes);
    }

    public void convertClass(int dexVersion, DexClassNode classNode, ClassVisitorFactory cvf, Map<String, Clz> classes) {
        ClassVisitor cv = cvf.create(Dex2Asm.toInternalName(classNode.className));
        if (cv == null) {
            return;
        }
        DexFix.fixStaticFinalFieldValue(classNode);
        String signature = null;
        if (classNode.anns != null) {
            for (DexAnnotationNode ann : classNode.anns) {
                if (ann.visibility != Visibility.SYSTEM) continue;
                switch (ann.type) {
                    case "Ldalvik/annotation/Signature;": {
                        Object[] strs = (Object[])Dex2Asm.findAnnotationAttribute(ann, "value");
                        if (strs == null) break;
                        StringBuilder sb = new StringBuilder();
                        for (Object str : strs) {
                            sb.append(str);
                        }
                        signature = sb.toString();
                    }
                }
            }
        }
        String[] interfaceInterNames = null;
        if (classNode.interfaceNames != null) {
            interfaceInterNames = new String[classNode.interfaceNames.length];
            for (int i = 0; i < classNode.interfaceNames.length; ++i) {
                interfaceInterNames[i] = Dex2Asm.toInternalName(classNode.interfaceNames[i]);
            }
        }
        Clz clzInfo = classes.get(classNode.className);
        int access = classNode.access;
        boolean isInnerClass = false;
        if (clzInfo != null) {
            isInnerClass = clzInfo.enclosingClass != null || clzInfo.enclosingMethod != null;
        }
        access = Dex2Asm.clearClassAccess(isInnerClass, access);
        int version = dexVersion >= 0x303337 ? 52 : 50;
        cv.visit(version, access, Dex2Asm.toInternalName(classNode.className), signature, classNode.superClass == null ? null : Dex2Asm.toInternalName(classNode.superClass), interfaceInterNames);
        ArrayList<InnerClassNode> innerClassNodes = new ArrayList<InnerClassNode>(5);
        if (clzInfo != null) {
            Dex2Asm.searchInnerClass(clzInfo, innerClassNodes, classNode.className);
        }
        if (isInnerClass) {
            if (clzInfo.innerName == null) {
                Method enclosingMethod = clzInfo.enclosingMethod;
                if (enclosingMethod != null) {
                    cv.visitOuterClass(Dex2Asm.toInternalName(enclosingMethod.getOwner()), enclosingMethod.getName(), enclosingMethod.getDesc());
                } else {
                    Clz enclosingClass = clzInfo.enclosingClass;
                    cv.visitOuterClass(Dex2Asm.toInternalName(enclosingClass.name), null, null);
                }
            }
            Dex2Asm.searchEnclosing(clzInfo, innerClassNodes);
        }
        Collections.sort(innerClassNodes, INNER_CLASS_NODE_COMPARATOR);
        for (InnerClassNode icn : innerClassNodes) {
            if (icn.innerName != null && !Dex2Asm.isJavaIdentifier(icn.innerName)) {
                System.err.println("WARN: ignored invalid inner class name , treat as anonymous inner class.");
                icn.innerName = null;
                icn.outerName = null;
            }
            icn.accept(cv);
        }
        Dex2Asm.accept((List<DexAnnotationNode>)classNode.anns, cv);
        if (classNode.fields != null) {
            for (DexFieldNode fieldNode : classNode.fields) {
                this.convertField(classNode, fieldNode, cv);
            }
        }
        if (classNode.methods != null) {
            for (DexMethodNode methodNode : classNode.methods) {
                this.convertMethod(classNode, methodNode, cv);
            }
        }
        cv.visitEnd();
    }

    public void convertCode(DexMethodNode methodNode, MethodVisitor mv) {
        IrMethod irMethod = this.dex2ir(methodNode);
        this.optimize(irMethod);
        this.ir2j(irMethod, mv);
    }

    public void convertDex(DexFileNode fileNode, ClassVisitorFactory cvf) {
        if (fileNode.clzs != null) {
            Map<String, Clz> classes = Dex2Asm.collectClzInfo(fileNode);
            for (DexClassNode classNode : fileNode.clzs) {
                this.convertClass(fileNode, classNode, cvf, classes);
            }
        }
    }

    public void convertField(DexClassNode classNode, DexFieldNode fieldNode, ClassVisitor cv) {
        String signature = null;
        if (fieldNode.anns != null) {
            for (DexAnnotationNode ann : fieldNode.anns) {
                if (ann.visibility != Visibility.SYSTEM) continue;
                switch (ann.type) {
                    case "Ldalvik/annotation/Signature;": {
                        Object[] strs = (Object[])Dex2Asm.findAnnotationAttribute(ann, "value");
                        if (strs == null) break;
                        StringBuilder sb = new StringBuilder();
                        for (Object str : strs) {
                            sb.append(str);
                        }
                        signature = sb.toString();
                    }
                }
            }
        }
        Object value = Dex2Asm.convertConstantValue(fieldNode.cst);
        int FieldCleanFlag = -131073;
        FieldVisitor fv = cv.visitField(fieldNode.access & 0xFFFDFFFF, fieldNode.field.getName(), fieldNode.field.getType(), signature, value);
        if (fv == null) {
            return;
        }
        Dex2Asm.accept((List<DexAnnotationNode>)fieldNode.anns, fv);
        fv.visitEnd();
    }

    public static Object[] convertConstantValues(Object[] v) {
        Object[] copy = Arrays.copyOf(v, v.length);
        for (int i = 0; i < copy.length; ++i) {
            Object ele = copy[i];
            copy[i] = ele = Dex2Asm.convertConstantValue(ele);
        }
        return copy;
    }

    public static Object convertConstantValue(Object ele) {
        if (ele instanceof DexType) {
            ele = Type.getType((String)((DexType)ele).desc);
        } else if (ele instanceof MethodHandle) {
            Handle h = null;
            MethodHandle mh = (MethodHandle)ele;
            switch (mh.getType()) {
                case 3: {
                    h = new Handle(1, Dex2Asm.toInternalName(mh.getField().getOwner()), mh.getField().getName(), mh.getField().getType());
                    break;
                }
                case 2: {
                    h = new Handle(3, Dex2Asm.toInternalName(mh.getField().getOwner()), mh.getField().getName(), mh.getField().getType());
                    break;
                }
                case 1: {
                    h = new Handle(1, Dex2Asm.toInternalName(mh.getField().getOwner()), mh.getField().getName(), mh.getField().getType());
                    break;
                }
                case 0: {
                    h = new Handle(3, Dex2Asm.toInternalName(mh.getField().getOwner()), mh.getField().getName(), mh.getField().getType());
                    break;
                }
                case 5: {
                    h = new Handle(5, Dex2Asm.toInternalName(mh.getMethod().getOwner()), mh.getMethod().getName(), mh.getMethod().getDesc());
                    break;
                }
                case 4: {
                    h = new Handle(6, Dex2Asm.toInternalName(mh.getMethod().getOwner()), mh.getMethod().getName(), mh.getMethod().getDesc());
                    break;
                }
                case 6: {
                    h = new Handle(8, Dex2Asm.toInternalName(mh.getMethod().getOwner()), mh.getMethod().getName(), mh.getMethod().getDesc());
                    break;
                }
                case 7: {
                    h = new Handle(7, Dex2Asm.toInternalName(mh.getMethod().getOwner()), mh.getMethod().getName(), mh.getMethod().getDesc());
                    break;
                }
                case 8: {
                    h = new Handle(9, Dex2Asm.toInternalName(mh.getMethod().getOwner()), mh.getMethod().getName(), mh.getMethod().getDesc());
                }
            }
            ele = h;
        } else if (ele instanceof Proto) {
            ele = Type.getMethodType((String)((Proto)ele).getDesc());
        }
        return ele;
    }

    public void convertMethod(DexClassNode classNode, DexMethodNode methodNode, ClassVisitor cv) {
        MethodVisitor mv = Dex2Asm.collectBasicMethodInfo(methodNode, cv);
        if (mv == null) {
            return;
        }
        if (0 != (classNode.access & 0x2000)) {
            AnnotationVisitor av;
            Object defaultValue = null;
            if (classNode.anns != null) {
                for (DexAnnotationNode ann : classNode.anns) {
                    if (ann.visibility != Visibility.SYSTEM || !ann.type.equals("Ldalvik/annotation/AnnotationDefault;")) continue;
                    DexAnnotationNode node = (DexAnnotationNode)Dex2Asm.findAnnotationAttribute(ann, "value");
                    if (node == null) break;
                    defaultValue = Dex2Asm.findAnnotationAttribute(node, methodNode.method.getName());
                    break;
                }
            }
            if (defaultValue != null && (av = mv.visitAnnotationDefault()) != null) {
                Dex2Asm.accept(av, null, defaultValue);
                av.visitEnd();
            }
        }
        Dex2Asm.accept((List<DexAnnotationNode>)methodNode.anns, mv);
        if (methodNode.parameterAnns != null) {
            for (int i = 0; i < methodNode.parameterAnns.length; ++i) {
                List anns = methodNode.parameterAnns[i];
                if (anns == null) continue;
                for (DexAnnotationNode ann : anns) {
                    if (ann.visibility == Visibility.SYSTEM) continue;
                    Dex2Asm.acceptParameter(ann, i, mv);
                }
            }
        }
        if ((0x2500 & methodNode.access) == 0 && methodNode.codeNode != null) {
            mv.visitCode();
            this.convertCode(methodNode, mv);
        }
        mv.visitEnd();
    }

    public IrMethod dex2ir(DexMethodNode methodNode) {
        return new Dex2IRConverter().convert(0 != (methodNode.access & 8), methodNode.method, methodNode.codeNode);
    }

    protected static Object findAnnotationAttribute(DexAnnotationNode ann, String name) {
        for (DexAnnotationNode.Item item : ann.items) {
            if (!item.name.equals(name)) continue;
            return item.value;
        }
        return null;
    }

    private static Clz get(Map<String, Clz> classes, String name) {
        Clz clz = classes.get(name);
        if (clz == null) {
            clz = new Clz(name);
            classes.put(name, clz);
        }
        return clz;
    }

    public void ir2j(IrMethod irMethod, MethodVisitor mv) {
        new IR2JConverter(false).convert(irMethod, mv);
        mv.visitMaxs(-1, -1);
    }

    public void optimize(IrMethod irMethod) {
        T_cleanLabel.transform(irMethod);
        T_deadCode.transform(irMethod);
        T_removeLocal.transform(irMethod);
        T_removeConst.transform(irMethod);
        T_zero.transform(irMethod);
        if (T_npe.transformReportChanged(irMethod)) {
            T_deadCode.transform(irMethod);
            T_removeLocal.transform(irMethod);
            T_removeConst.transform(irMethod);
        }
        T_new.transform(irMethod);
        T_fillArray.transform(irMethod);
        T_agg.transform(irMethod);
        T_multiArray.transform(irMethod);
        T_voidInvoke.transform(irMethod);
        T_type.transform(irMethod);
        T_unssa.transform(irMethod);
        T_trimEx.transform(irMethod);
        T_ir2jRegAssign.transform(irMethod);
    }

    private static void searchEnclosing(Clz clz, List<InnerClassNode> innerClassNodes) {
        Clz enclosingClass;
        HashSet<Clz> visitedClz = new HashSet<Clz>();
        Clz p = clz;
        while (p != null && visitedClz.add(p) && (enclosingClass = p.enclosingClass) != null && enclosingClass != clz) {
            int accessInInner = Dex2Asm.clearInnerAccess(p.access);
            if (p.innerName != null) {
                innerClassNodes.add(new InnerClassNode(Dex2Asm.toInternalName(p.name), Dex2Asm.toInternalName(enclosingClass.name), p.innerName, accessInInner));
            } else {
                innerClassNodes.add(new InnerClassNode(Dex2Asm.toInternalName(p.name), null, null, accessInInner));
            }
            p = p.enclosingClass;
        }
    }

    private static void searchInnerClass(Clz clz, List<InnerClassNode> innerClassNodes, String className) {
        HashSet<Clz> visited = new HashSet<Clz>();
        Stack<Clz> stack = new Stack<Clz>();
        stack.push(clz);
        while (!stack.empty()) {
            clz = (Clz)stack.pop();
            if (visited.contains(clz)) continue;
            visited.add(clz);
            if (clz.inners == null) continue;
            for (Clz inner : clz.inners) {
                if (inner.innerName == null) {
                    innerClassNodes.add(new InnerClassNode(Dex2Asm.toInternalName(inner.name), null, null, Dex2Asm.clearInnerAccess(inner.access)));
                } else {
                    innerClassNodes.add(new InnerClassNode(Dex2Asm.toInternalName(inner.name), Dex2Asm.toInternalName(className), inner.innerName, Dex2Asm.clearInnerAccess(inner.access)));
                }
                stack.push(inner);
            }
        }
    }

    protected static class Clz {
        public int access;
        public Clz enclosingClass;
        public Method enclosingMethod;
        public String innerName;
        public Set<Clz> inners = null;
        public final String name;

        public Clz(String name) {
            this.name = name;
        }

        void addInner(Clz clz) {
            if (this.inners == null) {
                this.inners = new HashSet<Clz>();
            }
            this.inners.add(clz);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Clz other = (Clz)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public String toString() {
            return "" + this.name;
        }
    }
}

