/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.ValueBox;
import com.googlecode.dex2jar.ir.expr.BinopExpr;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.stmt.JumpStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.LookupSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.stmt.TableSwitchStmt;
import com.googlecode.dex2jar.ir.ts.Transformer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public class TopologicalSort
implements Transformer {
    @Override
    public void transform(IrMethod irMethod) {
        if (irMethod.traps.size() > 0) {
            return;
        }
        StmtList stmts = irMethod.stmts;
        this.init(stmts, irMethod.traps);
        this.removeLoop(stmts);
        List<Stmt> out = this.topologicalSort(stmts);
        stmts.clear();
        this.rebuild(stmts, out);
    }

    private void rebuild(StmtList stmts, List<Stmt> out) {
        ArrayList<JumpStmt> gotos = new ArrayList<JumpStmt>();
        int i = 0;
        while (i < out.size()) {
            Stmt stmt = out.get(i);
            stmts.add(stmt);
            Stmt orgNext = stmt._ts_default_next;
            if (orgNext != null && orgNext.st == Stmt.ST.LABEL) {
                if (i + 1 < out.size()) {
                    Stmt next = out.get(i + 1);
                    if (next != orgNext) {
                        if (stmt.st == Stmt.ST.IF) {
                            JumpStmt jumpStmt = (JumpStmt)stmt;
                            if (jumpStmt.target == next) {
                                this.reverseIF(jumpStmt);
                            } else {
                                JumpStmt gotoStmt = Stmts.nGoto((LabelStmt)orgNext);
                                gotos.add(gotoStmt);
                                stmts.add(gotoStmt);
                            }
                        } else {
                            JumpStmt gotoStmt = Stmts.nGoto((LabelStmt)orgNext);
                            gotos.add(gotoStmt);
                            stmts.add(gotoStmt);
                        }
                    }
                } else {
                    JumpStmt gotoStmt = Stmts.nGoto((LabelStmt)orgNext);
                    gotos.add(gotoStmt);
                    stmts.add(gotoStmt);
                }
            }
            ++i;
        }
        block1: for (JumpStmt gotoStmt : gotos) {
            Stmt t = gotoStmt.getNext();
            while (t != null && t.st == Stmt.ST.LABEL) {
                if (t == gotoStmt.target) {
                    stmts.remove(gotoStmt);
                    continue block1;
                }
                t = t.getNext();
            }
        }
    }

    private List<Stmt> topologicalSort(StmtList stmts) {
        ArrayList<Stmt> out = new ArrayList<Stmt>(stmts.getSize());
        Stack<Stmt> stack = new Stack<Stmt>();
        stack.push(stmts.getFirst());
        boolean visitedFlag = false;
        while (!stack.empty()) {
            Stmt stmt = (Stmt)stack.pop();
            if (stmt._cfg_visited == visitedFlag || stmt._cfg_froms.size() != 0 && stack.size() != 0) continue;
            stmt._cfg_visited = visitedFlag;
            out.add(stmt);
            for (Stmt t : stmt._cfg_tos) {
                t._cfg_froms.remove(stmt);
                if (t._cfg_visited == visitedFlag) continue;
                stack.push(t);
            }
        }
        return out;
    }

    private Item buildItem(Stmt stmt) {
        Item item = new Item();
        item.stmt = stmt;
        item.it = new ArrayList<Stmt>(stmt._cfg_tos).iterator();
        return item;
    }

    private void removeLoop(StmtList stmts) {
        if (stmts.getSize() < 50) {
            this.dfsRecursiveCallRemove(stmts.getFirst(), new HashSet<Stmt>());
        } else {
            this.dfsStackRemove(stmts.getFirst(), new HashSet<Stmt>());
        }
    }

    private void dfsStackRemove(Stmt stmt, Set<Stmt> visited) {
        Stack<Item> stack = new Stack<Item>();
        stack.push(this.buildItem(stmt));
        while (!stack.empty()) {
            Item item = (Item)stack.peek();
            stmt = item.stmt;
            item.stmt._cfg_visited = true;
            if (!item.visitedAdded) {
                visited.add(item.stmt);
                item.visitedAdded = true;
            }
            boolean needPop = true;
            Iterator<Stmt> it = item.it;
            while (it.hasNext()) {
                Stmt to = it.next();
                if (visited.contains(to)) {
                    to._cfg_froms.remove(stmt);
                    stmt._cfg_tos.remove(to);
                    continue;
                }
                if (to._cfg_visited) continue;
                needPop = false;
                stack.push(this.buildItem(to));
                break;
            }
            if (!needPop || !item.visitedAdded) continue;
            visited.remove(stmt);
            stack.pop();
        }
    }

    private void dfsRecursiveCallRemove(Stmt stmt, Set<Stmt> visited) {
        if (stmt._cfg_visited) {
            return;
        }
        stmt._cfg_visited = true;
        visited.add(stmt);
        ArrayList<Stmt> tos = new ArrayList<Stmt>(stmt._cfg_tos);
        for (Stmt to : tos) {
            if (visited.contains(to)) {
                to._cfg_froms.remove(stmt);
                stmt._cfg_tos.remove(to);
                continue;
            }
            this.dfsRecursiveCallRemove(to, visited);
        }
        visited.remove(stmt);
    }

    private static void link(Stmt from, Stmt to) {
        if (to == null) {
            return;
        }
        from._cfg_tos.add(to);
        to._cfg_froms.add(from);
    }

    private void init_ts_default_next(StmtList stmts, Stmt stmt) {
        switch (stmt.st) {
            case IF: {
                Stmt n = stmt.getNext();
                if (n != null && n.st != Stmt.ST.LABEL) {
                    LabelStmt ls = Stmts.nLabel();
                    stmts.insertAfter(stmt, ls);
                }
                stmt._ts_default_next = stmt.getNext();
                break;
            }
            case GOTO: {
                Stmt pre = stmt.getPre();
                if (pre == null || pre.st != Stmt.ST.LABEL) {
                    LabelStmt ls = Stmts.nLabel();
                    stmts.insertBefore(stmt, ls);
                    if (pre != null) {
                        this.init_ts_default_next(stmts, pre);
                    }
                    this.init_ts_default_next(stmts, ls);
                }
            }
            case LOOKUP_SWITCH: 
            case RETURN: 
            case RETURN_VOID: 
            case TABLE_SWITCH: 
            case THROW: {
                stmt._ts_default_next = null;
                break;
            }
            default: {
                stmt._ts_default_next = stmt.getNext();
            }
        }
    }

    private void init(StmtList stmts, List<Trap> traps) {
        int n;
        int n2;
        LabelStmt[] labelStmtArray;
        Stmt stmt = stmts.getFirst();
        while (stmt != null) {
            this.init_ts_default_next(stmts, stmt);
            stmt = stmt.getNext();
        }
        stmt = stmts.getFirst();
        while (stmt != null) {
            if (stmt._cfg_froms == null) {
                stmt._cfg_froms = new TreeSet<Stmt>(stmts);
            } else {
                stmt._cfg_froms.clear();
            }
            if (stmt._cfg_tos == null) {
                stmt._cfg_tos = new TreeSet<Stmt>(stmts);
            } else {
                stmt._cfg_tos.clear();
            }
            stmt = stmt.getNext();
        }
        for (Trap t : traps) {
            Stmt s = t.start;
            while (s != t.end) {
                labelStmtArray = t.handlers;
                n2 = t.handlers.length;
                n = 0;
                while (n < n2) {
                    LabelStmt handler = labelStmtArray[n];
                    TopologicalSort.link(s, handler);
                    ++n;
                }
                s = s.getNext();
            }
        }
        stmt = stmts.getFirst();
        while (stmt != null) {
            switch (stmt.st) {
                case GOTO: {
                    TopologicalSort.link(stmt, ((JumpStmt)stmt).target);
                    break;
                }
                case IF: {
                    TopologicalSort.link(stmt, ((JumpStmt)stmt).target);
                    TopologicalSort.link(stmt, stmt.getNext());
                    break;
                }
                case LOOKUP_SWITCH: {
                    LookupSwitchStmt lss = (LookupSwitchStmt)stmt;
                    TopologicalSort.link(stmt, lss.defaultTarget);
                    LabelStmt[] labelStmtArray2 = lss.targets;
                    n = lss.targets.length;
                    int handler = 0;
                    while (handler < n) {
                        LabelStmt ls = labelStmtArray2[handler];
                        TopologicalSort.link(stmt, ls);
                        ++handler;
                    }
                    break;
                }
                case TABLE_SWITCH: {
                    TableSwitchStmt tss = (TableSwitchStmt)stmt;
                    TopologicalSort.link(stmt, tss.defaultTarget);
                    labelStmtArray = tss.targets;
                    n2 = tss.targets.length;
                    n = 0;
                    while (n < n2) {
                        LabelStmt ls = labelStmtArray[n];
                        TopologicalSort.link(stmt, ls);
                        ++n;
                    }
                    break;
                }
                case RETURN: 
                case RETURN_VOID: 
                case THROW: {
                    break;
                }
                default: {
                    TopologicalSort.link(stmt, stmt.getNext());
                }
            }
            stmt = stmt.getNext();
        }
        stmt = stmts.getFirst();
        while (stmt != null) {
            stmt._cfg_visited = false;
            switch (stmt.st) {
                case GOTO: {
                    JumpStmt js = (JumpStmt)stmt;
                    for (Stmt f : stmt._cfg_froms) {
                        f._cfg_tos.remove(stmt);
                        f._cfg_tos.addAll(stmt._cfg_tos);
                        f._ts_default_next = js.target;
                    }
                    for (Stmt t : stmt._cfg_tos) {
                        t._cfg_froms.remove(stmt);
                        t._cfg_froms.addAll(stmt._cfg_froms);
                    }
                    break;
                }
            }
            stmt = stmt.getNext();
        }
    }

    private void reverseIF(JumpStmt js) {
        ValueBox op = js.op;
        BinopExpr e2 = (BinopExpr)op.value;
        switch (e2.vt) {
            case GE: {
                op.value = Exprs.nLt(e2.op1.value, e2.op2.value, e2.type);
                break;
            }
            case GT: {
                op.value = Exprs.nLe(e2.op1.value, e2.op2.value, e2.type);
                break;
            }
            case LT: {
                op.value = Exprs.nGe(e2.op1.value, e2.op2.value, e2.type);
                break;
            }
            case LE: {
                op.value = Exprs.nGt(e2.op1.value, e2.op2.value, e2.type);
                break;
            }
            case EQ: {
                op.value = Exprs.nNe(e2.op1.value, e2.op2.value, e2.type);
                break;
            }
            case NE: {
                op.value = Exprs.nEq(e2.op1.value, e2.op2.value, e2.type);
            }
        }
        LabelStmt tmp = js.target;
        js.target = (LabelStmt)js._ts_default_next;
        js._ts_default_next = tmp;
    }

    private static class Item {
        public Stmt stmt;
        public Iterator<Stmt> it;
        public boolean visitedAdded = false;

        private Item() {
        }
    }
}

