/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.load;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.derbyTesting.system.oe.client.Load;
import org.apache.derbyTesting.system.oe.util.OERandom;

public class SimpleInsert
implements Load {
    Connection conn = null;
    short scale = 1;
    long seed = System.currentTimeMillis();
    OERandom random;

    public void setupLoad(Connection conn, short scale) throws SQLException {
        this.setupConnection(conn, scale);
        Statement s = conn.createStatement();
        try {
            s.execute("DROP TABLE C");
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        conn.commit();
        s.execute("CREATE TABLE C(CLOAD INT)");
        conn.commit();
        this.random = new OERandom(-1, this.seed);
        int loadRandomFactor = this.random.randomInt(0, 255);
        s.execute("INSERT INTO C VALUES(" + loadRandomFactor + ")");
        s.close();
        conn.commit();
        this.setRandomGenerator();
    }

    void setupConnection(Connection conn, short scale) throws SQLException {
        this.conn = conn;
        conn.setAutoCommit(false);
        conn.setTransactionIsolation(8);
        this.scale = scale;
    }

    void setRandomGenerator() throws SQLException {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("SELECT CLOAD FROM C");
        rs.next();
        int loadRandomFactor = rs.getInt(1);
        rs.close();
        this.random = new OERandom(loadRandomFactor, this.seed);
        s.close();
        this.conn.commit();
    }

    public void populateAllTables() throws Exception {
        this.itemTable(1, 100000);
        for (short w = 1; w <= this.scale; w = (short)(w + 1)) {
            this.populateForOneWarehouse(w);
        }
    }

    void populateForOneWarehouse(short w) throws SQLException {
        this.warehouseTable(w);
        this.stockTable(1, 100000, w);
        for (short d = 1; d <= 10; d = (short)(d + 1)) {
            this.districtTable(w, d);
            this.customerTable(w, d);
            this.orderTable(w, d);
        }
    }

    public void itemTable(int itemStart, int itemEnd) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement("INSERT INTO ITEM(I_ID,I_IM_ID,I_NAME,I_PRICE,I_DATA) VALUES (?, ?, ?, ?, ?)");
        for (int i = itemStart; i <= itemEnd; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, this.random.randomInt(1, 10000));
            ps.setString(3, this.random.randomAString14_24());
            String price = this.random.randomDecimalString(100, 9999, 2);
            ps.setString(4, price);
            ps.setString(5, this.random.randomData());
            ps.executeUpdate();
            if (i % 1000 != 0) continue;
            this.conn.commit();
        }
        this.conn.commit();
        ps.close();
    }

    public void warehouseTable(short w) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement("INSERT INTO WAREHOUSE VALUES (?, ?, ?, ?, ?, ?, ?, ?, 300000.00)");
        ps.setShort(1, w);
        ps.setString(2, this.random.randomAString(6, 10));
        ps.setString(3, this.random.randomAString10_20());
        ps.setString(4, this.random.randomAString10_20());
        ps.setString(5, this.random.randomAString10_20());
        ps.setString(6, this.random.randomState());
        ps.setString(7, this.random.randomZIP());
        ps.setString(8, this.random.randomDecimalString(0, 2000, 4));
        ps.executeUpdate();
        this.conn.commit();
        ps.close();
    }

    public void stockTable(int itemStart, int itemEnd, short w) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement("INSERT INTO STOCK (S_I_ID, S_W_ID, S_QUANTITY,S_DIST_01, S_DIST_02, S_DIST_03,S_DIST_04,S_DIST_05,S_DIST_06,S_DIST_07,S_DIST_08,S_DIST_09,S_DIST_10,S_ORDER_CNT, S_REMOTE_CNT, S_YTD, S_DATA ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 0, 0, 0, ?)");
        ps.setShort(2, w);
        for (int i = itemStart; i <= itemEnd; ++i) {
            ps.setInt(1, i);
            ps.setInt(3, this.random.randomInt(10, 100));
            ps.setString(4, this.random.randomAString24());
            ps.setString(5, this.random.randomAString24());
            ps.setString(6, this.random.randomAString24());
            ps.setString(7, this.random.randomAString24());
            ps.setString(8, this.random.randomAString24());
            ps.setString(9, this.random.randomAString24());
            ps.setString(10, this.random.randomAString24());
            ps.setString(11, this.random.randomAString24());
            ps.setString(12, this.random.randomAString24());
            ps.setString(13, this.random.randomAString24());
            ps.setString(14, this.random.randomData());
            ps.executeUpdate();
            if (i % 1000 != 0) continue;
            this.conn.commit();
        }
        this.conn.commit();
        ps.close();
    }

    public void districtTable(short w, short d) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement("INSERT INTO DISTRICT (D_ID, D_W_ID, D_NAME, D_STREET_1, D_STREET_2, D_CITY, D_STATE, D_ZIP, D_TAX, D_YTD, D_NEXT_O_ID)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, 30000.00, 3001)");
        ps.setShort(1, d);
        ps.setShort(2, w);
        ps.setString(3, this.random.randomAString(6, 10));
        ps.setString(4, this.random.randomAString10_20());
        ps.setString(5, this.random.randomAString10_20());
        ps.setString(6, this.random.randomAString10_20());
        ps.setString(7, this.random.randomState());
        ps.setString(8, this.random.randomZIP());
        ps.setString(9, this.random.randomDecimalString(0, 2000, 4));
        ps.executeUpdate();
        this.conn.commit();
        ps.close();
    }

    public void customerTable(short w, short d) throws SQLException {
        PreparedStatement psC = this.conn.prepareStatement("INSERT INTO CUSTOMER (C_ID, C_D_ID, C_W_ID, C_FIRST, C_MIDDLE, C_LAST, C_STREET_1, C_STREET_2,  C_CITY, C_STATE, C_ZIP, C_PHONE, C_SINCE, C_CREDIT, C_CREDIT_LIM, C_DISCOUNT, C_BALANCE, C_YTD_PAYMENT, C_PAYMENT_CNT, C_DELIVERY_CNT, C_DATA)  VALUES (?, ?, ?, ?, 'OE', ?, ?, ?, ?, ?, ?, ?,  CURRENT TIMESTAMP ,?, 50000.00, ?, -10.0, 10.0, 1, 0, ?)");
        PreparedStatement psH = this.conn.prepareStatement("INSERT INTO HISTORY (H_C_ID, H_C_D_ID, H_C_W_ID, H_D_ID, H_W_ID, H_DATE, H_AMOUNT, H_DATA) VALUES (?, ?, ?, ?, ?, CURRENT TIMESTAMP, 10.00, ?)");
        psC.setShort(2, d);
        psC.setShort(3, w);
        psH.setShort(2, d);
        psH.setShort(3, w);
        psH.setShort(4, d);
        psH.setShort(5, w);
        for (int c = 1; c <= 3000; ++c) {
            psC.setInt(1, c);
            psC.setString(4, this.random.randomAString8_16());
            psC.setString(5, this.random.randomCLastPopulate(c));
            psC.setString(6, this.random.randomAString10_20());
            psC.setString(7, this.random.randomAString10_20());
            psC.setString(8, this.random.randomAString10_20());
            psC.setString(9, this.random.randomState());
            psC.setString(10, this.random.randomZIP());
            psC.setString(11, this.random.randomNString(16, 16));
            psC.setString(12, Math.random() < 0.1 ? "BC" : "GC");
            psC.setString(13, this.random.randomDecimalString(0, 5000, 4));
            String str = this.random.randomAString300_500();
            if (str.length() > 255) {
                str = str.substring(255);
            }
            psC.setString(14, str);
            psC.executeUpdate();
            psH.setInt(1, c);
            psH.setString(6, this.random.randomAString(12, 24));
            psH.executeUpdate();
            if (c % 1000 != 0) continue;
            this.conn.commit();
        }
        this.conn.commit();
        psC.close();
        psH.close();
    }

    public void orderTable(short w, short d) throws SQLException {
        PreparedStatement psO = this.conn.prepareStatement("INSERT INTO ORDERS (O_ID, O_D_ID, O_W_ID, O_C_ID, O_ENTRY_D, O_CARRIER_ID, O_OL_CNT, O_ALL_LOCAL) VALUES (?, ?, ?, ?, ?, ?, ?, 1)");
        PreparedStatement psOL = this.conn.prepareStatement("INSERT INTO ORDERLINE (OL_O_ID, OL_D_ID, OL_W_ID, OL_NUMBER, OL_I_ID, OL_SUPPLY_W_ID, OL_DELIVERY_D, OL_QUANTITY, OL_AMOUNT, OL_DIST_INFO)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        PreparedStatement psNO = this.conn.prepareStatement("INSERT INTO NEWORDERS (NO_O_ID, NO_D_ID, NO_W_ID) VALUES (?, ?, ?)");
        psO.setShort(2, d);
        psO.setShort(3, w);
        int[] cid = this.random.randomIntPerm(3000);
        for (int o_id = 1; o_id <= cid.length; ++o_id) {
            psO.setInt(1, o_id);
            psO.setInt(4, cid[o_id - 1]);
            Timestamp o_entry_d = new Timestamp(System.currentTimeMillis());
            psO.setTimestamp(5, o_entry_d);
            if (o_id <= 2100) {
                psO.setShort(6, (short)this.random.randomInt(1, 10));
            } else {
                psO.setNull(6, 5);
            }
            int o_ol_cnt = this.random.randomInt(5, 15);
            psO.setInt(7, o_ol_cnt);
            psO.executeUpdate();
            psOL.setShort(2, d);
            psOL.setShort(3, w);
            psNO.setShort(2, d);
            psNO.setShort(3, w);
            for (int ol_number = 1; ol_number <= o_ol_cnt; ++ol_number) {
                psOL.setInt(1, o_id);
                psOL.setInt(4, ol_number);
                psOL.setInt(5, this.random.randomInt(1, 100000));
                psOL.setShort(6, w);
                if (o_id <= 2100) {
                    psOL.setTimestamp(7, o_entry_d);
                    psOL.setString(9, "0.00");
                } else {
                    psOL.setNull(7, 93);
                    psOL.setString(9, this.random.randomDecimalString(1, 999999, 2));
                }
                psOL.setInt(8, 5);
                psOL.setString(10, this.random.randomAString24());
                psOL.executeUpdate();
            }
            if (o_id > 2100) {
                psNO.setInt(1, o_id);
                psNO.executeUpdate();
            }
            if (o_id % 1000 != 0) continue;
            this.conn.commit();
        }
        this.conn.commit();
        psOL.close();
        psO.close();
        psNO.close();
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setThreadCount(int threadCount) {
    }
}

