/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;

public class BaseLoad100TestSetup
extends CleanDatabaseTestSetup {
    protected int rowsToLoad = 10000;
    protected String tableName = "BASELOAD100";
    private boolean binaryData;

    public BaseLoad100TestSetup(Test test) {
        super(test);
    }

    public BaseLoad100TestSetup(Test test, int rowsToLoad) {
        super(test);
        this.rowsToLoad = rowsToLoad;
    }

    public BaseLoad100TestSetup(Test test, String tableName) {
        super(test);
        this.tableName = tableName;
    }

    public BaseLoad100TestSetup(Test test, int rowsToLoad, String tableName) {
        this(test, rowsToLoad, tableName, false);
    }

    public BaseLoad100TestSetup(Test test, int rowsToLoad, String tableName, boolean binaryData) {
        super(test);
        this.tableName = tableName;
        this.rowsToLoad = rowsToLoad;
        this.binaryData = binaryData;
    }

    protected void setUp() throws Exception {
        super.setUp();
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        PreparedStatement insert = conn.prepareStatement("INSERT INTO " + this.tableName + " VALUES ( ?,?,?,?,?,?,?,?,? )");
        this.loadData(insert);
        insert.close();
        conn.close();
    }

    protected void decorateSQL(Statement s) throws SQLException {
        StringBuffer ddl = new StringBuffer();
        ddl.append("CREATE TABLE ").append(this.tableName);
        ddl.append("(i1 INT, i2 INT, i3 INT, i4 INT, i5 INT");
        for (int i = 6; i <= 9; ++i) {
            ddl.append(", c").append(i).append(" CHAR(20)");
            if (!this.binaryData) continue;
            ddl.append(" FOR BIT DATA");
        }
        ddl.append(')');
        s.execute(ddl.toString());
    }

    private void loadData(PreparedStatement insert) throws Exception {
        for (int i = 0; i < this.rowsToLoad; ++i) {
            insert.setInt(1, i);
            insert.setInt(2, 2);
            if (i % 100 == 57) {
                insert.setInt(3, 436);
            } else {
                insert.setInt(3, 2);
            }
            insert.setInt(4, 2);
            insert.setInt(5, i);
            insert.setObject(6, this.convertData("01234567890123456789"));
            if (i % 100 == 34) {
                insert.setObject(7, this.convertData("012345javaone6789"));
            } else {
                insert.setObject(7, this.convertData("01234567890123456789"));
            }
            insert.setObject(8, this.convertData("01234567890123456789"));
            insert.setObject(9, this.convertData(i + 1000 + "0123456789012"));
            insert.executeUpdate();
        }
        insert.getConnection().commit();
    }

    private Object convertData(String string) throws IOException {
        if (this.binaryData) {
            return string.getBytes("US-ASCII");
        }
        return string;
    }
}

