/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.util.HashMap;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.XADataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class J2EEDataSource {
    public static ConnectionPoolDataSource getConnectionPoolDataSource() {
        return J2EEDataSource.getConnectionPoolDataSource(TestConfiguration.getCurrent(), null);
    }

    static ConnectionPoolDataSource getConnectionPoolDataSource(TestConfiguration config, HashMap beanProperties) {
        if (beanProperties == null) {
            beanProperties = JDBCDataSource.getDataSourceProperties(config);
        }
        String dataSourceClass = config.getJDBCClient().getConnectionPoolDataSourceClassName();
        return (ConnectionPoolDataSource)JDBCDataSource.getDataSourceObject(dataSourceClass, beanProperties);
    }

    public static XADataSource getXADataSource() {
        return J2EEDataSource.getXADataSource(TestConfiguration.getCurrent(), null);
    }

    public static void setBeanProperty(Object ds, String property, Object value) {
        JDBCDataSource.setBeanProperty(ds, property, value);
    }

    static XADataSource getXADataSource(TestConfiguration config, HashMap beanProperties) {
        if (beanProperties == null) {
            beanProperties = JDBCDataSource.getDataSourceProperties(config);
        }
        String dataSourceClass = config.getJDBCClient().getXADataSourceClassName();
        return (XADataSource)JDBCDataSource.getDataSourceObject(dataSourceClass, beanProperties);
    }
}

