/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.derbyTesting.junit.Connector;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DriverManagerConnector
implements Connector {
    private TestConfiguration config;

    public void setConfiguration(TestConfiguration config) {
        this.config = config;
    }

    public Connection openConnection() throws SQLException {
        return this.openConnection(this.config.getDefaultDatabaseName(), this.config.getUserName(), this.config.getUserPassword());
    }

    public Connection openConnection(String databaseName) throws SQLException {
        return this.openConnection(databaseName, this.config.getUserName(), this.config.getUserPassword());
    }

    public Connection openConnection(String user, String password) throws SQLException {
        return this.openConnection(this.config.getDefaultDatabaseName(), user, password);
    }

    public Connection openConnection(String databaseName, String user, String password) throws SQLException {
        return this.openConnection(databaseName, user, password, null);
    }

    public Connection openConnection(String databaseName, String user, String password, Properties connectionProperties) throws SQLException {
        String url = this.config.getJDBCUrl(databaseName);
        try {
            DriverManager.getDriver(url);
        }
        catch (SQLException e) {
            this.loadJDBCDriver();
        }
        Properties connectionAttributes = new Properties(this.config.getConnectionAttributes());
        if (user != null) {
            connectionAttributes.setProperty("user", user);
        }
        if (password != null) {
            connectionAttributes.setProperty("password", password);
        }
        if (connectionProperties != null) {
            connectionAttributes.putAll((Map<?, ?>)connectionProperties);
        }
        try {
            return DriverManager.getConnection(url, connectionAttributes);
        }
        catch (SQLException e) {
            String expectedState;
            String string = expectedState = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!expectedState.equals(e.getSQLState())) {
                throw e;
            }
            Properties attributes = new Properties(connectionAttributes);
            attributes.setProperty("create", "true");
            return DriverManager.getConnection(url, attributes);
        }
    }

    public void shutDatabase() throws SQLException {
        this.getConnectionByAttributes(this.config.getJDBCUrl(), "shutdown", "true");
    }

    public void shutEngine() throws SQLException {
        this.getConnectionByAttributes("jdbc:derby:", "shutdown", "true");
    }

    private Connection getConnectionByAttributes(String url, String key, String value) throws SQLException {
        Properties attributes = new Properties();
        attributes.setProperty("user", this.config.getUserName());
        attributes.setProperty("password", this.config.getUserPassword());
        attributes.setProperty(key, value);
        try {
            DriverManager.getDriver(url);
        }
        catch (SQLException e) {
            this.loadJDBCDriver();
        }
        return DriverManager.getConnection(url, attributes);
    }

    private void loadJDBCDriver() throws SQLException {
        String driverClass = this.config.getJDBCClient().getJDBCDriverName();
        try {
            Class.forName(driverClass).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new SQLException("Failed to load JDBC driver '" + driverClass + "': " + cnfe.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new SQLException("Failed to load JDBC driver '" + driverClass + "': " + iae.getMessage());
        }
        catch (InstantiationException ie) {
            throw new SQLException("Failed to load JDBC driver '" + driverClass + "': " + ie.getMessage());
        }
    }
}

