/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.io.InputStream;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XML;

public class BasicSetup
extends UpgradeChange {
    final int TEST_COUNT = 0;
    final int FAILURES = 1;
    final String A_COL = "a";
    final String B_COL = "b";

    public static Test suite() {
        TestSuite suite = new TestSuite("Upgrade basic setup");
        suite.addTestSuite(BasicSetup.class);
        if (XML.classpathMeetsXMLReqs()) {
            suite.addTest((Test)new BasicSetup("xmlTestTriggerWithXMLOperators"));
        }
        return suite;
    }

    public BasicSetup(String name) {
        super(name);
    }

    public void testTriggerBasic() throws SQLException {
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                s.executeUpdate("CREATE TABLE Trigger_t1 (c1 INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), max_size INTEGER NOT NULL, CONSTRAINT c1_pk PRIMARY KEY (c1))");
                s.executeUpdate("CREATE TABLE Trigger_t2 (c1 INTEGER DEFAULT 0 NOT NULL)");
                s.executeUpdate("CREATE TRIGGER gls_blt_trg AFTER INSERT ON Trigger_t1 FOR EACH ROW MODE DB2SQL INSERT INTO Trigger_t2(c1) VALUES ( (select max(c1) from Trigger_t1))");
                s.executeUpdate("INSERT INTO Trigger_t1(max_size) VALUES(20)");
                break;
            }
            case 1: {
                s.executeUpdate("INSERT INTO Trigger_t1(max_size) VALUES(20)");
                break;
            }
            case 2: {
                if (this.oldSuffersFromDerby4835()) break;
                s.executeUpdate("INSERT INTO Trigger_t1(max_size) VALUES(20)");
                break;
            }
            case 3: {
                s.executeUpdate("INSERT INTO Trigger_t1(max_size) VALUES(20)");
            }
        }
        s.close();
    }

    private boolean oldSuffersFromDerby4835() {
        return this.oldAtLeast(10, 5) && this.oldLessThan(10, 5, 3, 2) || this.oldAtLeast(10, 6) && this.oldLessThan(10, 6, 2, 3);
    }

    public void testOldVersion() throws SQLException {
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                DatabaseMetaData dmd = this.getConnection().getMetaData();
                BasicSetup.assertEquals((String)"Old major (driver): ", (int)this.getOldMajor(), (int)dmd.getDriverMajorVersion());
                BasicSetup.assertEquals((String)"Old minor (driver): ", (int)this.getOldMinor(), (int)dmd.getDriverMinorVersion());
                BasicSetup.assertEquals((String)"Old major (database): ", (int)this.getOldMajor(), (int)dmd.getDatabaseMajorVersion());
                BasicSetup.assertEquals((String)"Old minor (database): ", (int)this.getOldMinor(), (int)dmd.getDatabaseMinorVersion());
            }
        }
    }

    public void testDML() throws SQLException {
        int i;
        int phase = this.getPhase();
        Statement s = this.createStatement();
        switch (phase) {
            case 0: {
                s.executeUpdate("CREATE TABLE PHASE(id INT NOT NULL, ok INT)");
                s.executeUpdate("CREATE TABLE TABLE1(id INT NOT NULL PRIMARY KEY, name varchar(200))");
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        s.close();
        PreparedStatement ps = this.prepareStatement("INSERT INTO PHASE(id) VALUES (?)");
        ps.setInt(1, phase);
        ps.executeUpdate();
        ps.close();
        ps = this.prepareStatement("INSERT INTO TABLE1 VALUES (?, ?)");
        for (i = 1; i < 20; ++i) {
            ps.setInt(1, i + phase * 100);
            ps.setString(2, "p" + phase + "i" + i);
            ps.executeUpdate();
        }
        ps.close();
        ps = this.prepareStatement("UPDATE TABLE1 set name = name || 'U'  where id = ?");
        for (i = 1; i < 20; i += 3) {
            ps.setInt(1, i + phase * 100);
            ps.executeUpdate();
        }
        ps.close();
        ps = this.prepareStatement("DELETE FROM TABLE1 where id = ?");
        for (i = 1; i < 20; i += 4) {
            ps.setInt(1, i + phase * 100);
            ps.executeUpdate();
        }
        ps.close();
        this.commit();
    }

    public void testCreateTable() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            stmt.executeUpdate("DROP table t");
        }
        catch (SQLException se) {
            BasicSetup.assertSQLState("42Y55", se);
        }
        stmt.executeUpdate("CREATE TABLE T (I INT)");
        TestConfiguration.getCurrent().shutdownDatabase();
        stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * from t");
        JDBC.assertEmpty(rs);
        rs.close();
    }

    public void testIndex() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            stmt.executeUpdate("DROP table ti");
        }
        catch (SQLException se) {
            BasicSetup.assertSQLState("42Y55", se);
        }
        stmt.executeUpdate("CREATE TABLE TI (I INT primary key not null)");
        stmt.executeUpdate("INSERT INTO  TI values(1)");
        stmt.executeUpdate("INSERT INTO  TI values(2)");
        stmt.executeUpdate("INSERT INTO  TI values(3)");
        TestConfiguration.getCurrent().shutdownDatabase();
        stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * from TI ORDER BY I");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}, {"2"}, {"3"}});
        rs.close();
    }

    public void noConnectionAfterHardUpgrade() {
        switch (this.getPhase()) {
            case 4: {
                try {
                    this.getConnection();
                    break;
                }
                catch (SQLException e) {
                    SQLException sqle = this.getLastSQLException(e);
                    String sqlState = sqle.getSQLState();
                    if (sqlState.equals("XSLAP") || sqlState.equals("XSLAN")) break;
                    BasicSetup.fail((String)"expected an error indicating no connection");
                }
            }
        }
    }

    public void testDropTableAfterUpgradeWithConstraint() throws SQLException {
        int phase = this.getPhase();
        Statement s = this.createStatement();
        switch (phase) {
            case 0: {
                s.executeUpdate("CREATE SCHEMA S");
                s.executeUpdate("CREATE TABLE S.RS (R_TYPE_ID VARCHAR(64) NOT NULL)");
                s.executeUpdate("ALTER TABLE S.RS ADD CONSTRAINT PK_RS PRIMARY KEY (R_TYPE_ID)");
                s.executeUpdate("CREATE TABLE S.R_TYPE_ID (R_TYPE_ID VARCHAR(64) NOT NULL)");
                s.executeUpdate("ALTER TABLE S.R_TYPE_ID ADD CONSTRAINT PK_R_TYPE_ID PRIMARY KEY (R_TYPE_ID)");
                s.executeUpdate("ALTER TABLE S.RS ADD CONSTRAINT FK_RS_TYPEID FOREIGN KEY (R_TYPE_ID) REFERENCES S.R_TYPE_ID (R_TYPE_ID) ON DELETE CASCADE ON UPDATE NO ACTION");
                break;
            }
            case 1: {
                s.executeUpdate("ALTER TABLE S.RS DROP CONSTRAINT FK_RS_TYPEID");
                s.executeUpdate("ALTER TABLE S.R_TYPE_ID DROP CONSTRAINT PK_R_TYPE_ID");
                s.executeUpdate("ALTER TABLE S.RS DROP CONSTRAINT PK_RS");
                s.executeUpdate("DROP TABLE S.RS");
                s.executeUpdate("DROP TABLE S.R_TYPE_ID");
                s.executeUpdate("DROP SCHEMA S RESTRICT");
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void testDERBY5121TriggerTest2() throws Exception {
        Statement s = this.createStatement();
        boolean modeDb2SqlOptional = this.oldAtLeast(10, 3);
        String updateSQL = "update media set name = 'Mon Liza', description = 'Something snarky.' where mediaID = 1";
        switch (this.getPhase()) {
            case 0: {
                s.execute("create table folder ( folderType\tint\tnot null, folderID\tint\tnot null, folderParent int, folderName varchar(50) not null)");
                s.execute("create table media ( mediaID int not null, name varchar(50)\tnot null, description clob not null, mediaType varchar(50), mediaContents\tblob, folderID int not null\tdefault 7)");
                s.execute("create trigger mediaInsrtDupTrgr after INSERT on media referencing new as nr for each ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "values( nr.folderID, 7, nr.name)");
                s.execute("create trigger mediaUpdtDupTrgr after UPDATE of folderID, name on media referencing new as nr for each ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "values( nr.folderID, 7, nr.name)");
                s.executeUpdate("insert into folder(folderType, folderID, folderParent, folderName ) values ( 7, 7, null, 'media' )");
                s.executeUpdate("insert into media(mediaID, name, description)values (1, 'Mona Lisa', 'A photo of the Mona Lisa')");
                if (this.oldIs(10, 7, 1, 1)) {
                    BasicSetup.assertStatementError("XCL12", s, updateSQL);
                    break;
                }
                s.executeUpdate(updateSQL);
                break;
            }
            case 1: {
                s.executeUpdate(updateSQL);
                break;
            }
            case 2: {
                if (this.oldIs(10, 7, 1, 1)) {
                    BasicSetup.assertStatementError("S0022", s, updateSQL);
                    break;
                }
                s.executeUpdate(updateSQL);
                break;
            }
            case 3: {
                s.executeUpdate(updateSQL);
                break;
            }
            case 4: {
                s.executeUpdate(updateSQL);
                s.executeUpdate("drop table media");
                s.executeUpdate("drop table folder");
            }
        }
    }

    public void preapreFortDERBY5120() throws Exception {
        Statement s = this.createStatement();
        boolean modeDb2SqlOptional = this.oldAtLeast(10, 3);
        this.dropTable("ATDC_BKUP1");
        this.dropTable("ATDC_TAB1");
        s.execute("create table ATDC_TAB1(c11 int, c12 int)");
        s.execute("insert into ATDC_TAB1 values (1,11)");
        s.execute("create table ATDC_BKUP1(c111 int, c112 int)");
        s.execute("create trigger ATDC_TAB1_TRG1 after update of C11 on ATDC_TAB1 REFERENCING old_table as old for each statement " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "insert into ATDC_BKUP1 select * from old");
        s.execute("create trigger ATDC_TAB1_TRG2 after update on ATDC_TAB1 for each row " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "values(1,2)");
    }

    public void testDERBY5120NumRowsInSydependsForTrigger() throws Exception {
        if (this.oldIs(10, 5, 1, 1) || this.oldIs(10, 5, 3, 0) || this.oldIs(10, 6, 1, 0) || this.oldIs(10, 6, 2, 1)) {
            return;
        }
        Statement s = this.createStatement();
        boolean modeDb2SqlOptional = this.oldAtLeast(10, 3);
        switch (this.getPhase()) {
            case 0: {
                this.preapreFortDERBY5120();
                s.execute("update ATDC_TAB1 set c11=11");
                s.executeUpdate("alter table ATDC_TAB1 add column c113 int");
                if (this.oldLessThan(10, 8, 2, 2)) {
                    s.execute("update ATDC_TAB1 set c11=11");
                    break;
                }
                BasicSetup.assertStatementError("42802", s, " update ATDC_TAB1 set c11=2");
                break;
            }
            case 1: 
            case 3: {
                BasicSetup.assertStatementError("42802", s, " update ATDC_TAB1 set c11=2");
                break;
            }
            case 2: {
                BasicSetup.assertStatementError("42802", s, " update ATDC_TAB1 set c11=2");
                this.preapreFortDERBY5120();
                s.execute("update ATDC_TAB1 set c12=11");
                s.executeUpdate("alter table ATDC_TAB1 add column c113 int");
                if (this.oldLessThan(10, 8, 2, 2)) {
                    s.execute("update ATDC_TAB1 set c12=11");
                    break;
                }
                BasicSetup.assertStatementError("42802", s, " update ATDC_TAB1 set c12=11");
                break;
            }
            case 4: {
                BasicSetup.assertStatementError("42802", s, " update ATDC_TAB1 set c11=2");
                this.preapreFortDERBY5120();
                s.execute("update ATDC_TAB1 set c12=11");
                s.executeUpdate("alter table ATDC_TAB1 add column c113 int");
                BasicSetup.assertStatementError("42802", s, " update ATDC_TAB1 set c11=2");
            }
        }
    }

    private int numberOfRowsInSysdepends(Statement st) throws SQLException {
        ResultSet rs = st.executeQuery("SELECT COUNT(*) FROM SYS.SYSDEPENDS");
        rs.next();
        return rs.getInt(1);
    }

    public void testDERBY5044_And_DERBY5120_DropColumn() throws Exception {
        if (!this.oldAtLeast(10, 3)) {
            return;
        }
        if (this.oldIs(10, 5, 1, 1) || this.oldIs(10, 5, 3, 0) || this.oldIs(10, 6, 1, 0) || this.oldIs(10, 6, 2, 1)) {
            return;
        }
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.dropColumn_triggersql_DERBY5044_And_DERBY5120(s);
            }
            case 0: {
                this.preapreForDERBY5044_And_DERBY5120();
                this.triggersql_for_DERBY5044_And_DERBY5120(s);
                this.dropColumn_triggersql_DERBY5044_And_DERBY5120(s);
                this.preapreForDERBY5044_And_DERBY5120();
                this.triggersql_for_DERBY5044_And_DERBY5120(s);
            }
        }
    }

    private void dropColumn_triggersql_DERBY5044_And_DERBY5120(Statement s) throws Exception {
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                ResultSet rs;
                s.executeUpdate("alter table BKUP1_5044_5120 drop column c112");
                if (this.oldLessThan(10, 8, 2, 2)) {
                    BasicSetup.assertStatementError("42802", s, " update TAB1_5044_5120 set c11=999");
                    rs = s.executeQuery("select * from TAB1_5044_5120");
                    JDBC.assertFullResultSet(rs, new String[][]{{"99", "11"}});
                } else {
                    s.execute("update TAB1_5044_5120 set c11=999");
                    rs = s.executeQuery("select * from TAB1_5044_5120");
                    JDBC.assertFullResultSet(rs, new String[][]{{"999", "11"}});
                }
                rs = s.executeQuery("select * from BKUP1_5044_5120");
                JDBC.assertEmpty(rs);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                s.executeUpdate("alter table BKUP1_5044_5120 drop column c112");
                s.executeUpdate("update TAB1_5044_5120 set c11=999");
                ResultSet rs = s.executeQuery("select * from TAB1_5044_5120");
                JDBC.assertFullResultSet(rs, new String[][]{{"999", "11"}});
                rs = s.executeQuery("select * from BKUP1_5044_5120");
                JDBC.assertEmpty(rs);
            }
        }
    }

    private void preapreForDERBY5044_And_DERBY5120() throws Exception {
        Statement s = this.createStatement();
        boolean modeDb2SqlOptional = this.oldAtLeast(10, 3);
        this.dropTable("BKUP1_5044_5120");
        this.dropTable("TAB1_5044_5120");
        s.execute("create table TAB1_5044_5120(c11 int, c12 int)");
        s.execute("insert into TAB1_5044_5120 values (1,11)");
        s.execute("create table BKUP1_5044_5120(c111 int, c112 int)");
        s.execute("create trigger TAB1_TRG1 after update of C11 on TAB1_5044_5120 REFERENCING old_table as old for each statement " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "insert into BKUP1_5044_5120 select * from old");
        s.execute("create trigger TAB1_TRG2 after update on TAB1_5044_5120 for each row " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "values(1,2)");
    }

    private void triggersql_for_DERBY5044_And_DERBY5120(Statement s) throws Exception {
        ResultSet rs = s.executeQuery("select * from TAB1_5044_5120");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "11"}});
        rs = s.executeQuery("select * from BKUP1_5044_5120");
        JDBC.assertEmpty(rs);
        s.executeUpdate("update TAB1_5044_5120 set c11=99");
        rs = s.executeQuery("select * from TAB1_5044_5120");
        JDBC.assertFullResultSet(rs, new String[][]{{"99", "11"}});
        rs = s.executeQuery("select * from BKUP1_5044_5120");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "11"}});
        s.executeUpdate("delete from BKUP1_5044_5120");
    }

    public void testDERBY5044AlterTableDropColumn() throws Exception {
        if (!this.oldAtLeast(10, 3)) {
            return;
        }
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                this.preapreFortDERBY5044();
                ResultSet rs = s.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                JDBC.assertFullResultSet(rs, new String[][]{{"1", "11"}});
                rs = s.executeQuery("select * from ATDC_13_TAB2");
                JDBC.assertFullResultSet(rs, new String[][]{{"1", "11"}});
                s.executeUpdate("update ATDC_13_TAB1 set c12=999");
                rs = s.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                JDBC.assertEmpty(rs);
                rs = s.executeQuery("select * from ATDC_13_TAB2");
                JDBC.assertEmpty(rs);
                s.execute("insert into ATDC_13_TAB1_BACKUP values (1,11)");
                s.execute("insert into ATDC_13_TAB2 values (1,11)");
                if (this.oldLessThan(10, 8, 2, 2)) {
                    s.executeUpdate("alter table ATDC_13_TAB2 drop column c22 restrict");
                    BasicSetup.assertStatementError("42X04", s, "update ATDC_13_TAB1 set c12=999");
                    rs = s.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                    JDBC.assertFullResultSet(rs, new String[][]{{"1", "11"}});
                    rs = s.executeQuery("select * from ATDC_13_TAB2");
                    JDBC.assertFullResultSet(rs, new String[][]{{"1"}});
                    break;
                }
                BasicSetup.assertStatementError("X0Y25", s, "alter table ATDC_13_TAB2 drop column c22 restrict");
                s.executeUpdate("update ATDC_13_TAB1 set c12=999");
                rs = s.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                JDBC.assertEmpty(rs);
                rs = s.executeQuery("select * from ATDC_13_TAB2");
                JDBC.assertEmpty(rs);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.preapreFortDERBY5044();
                ResultSet rs = s.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                JDBC.assertFullResultSet(rs, new String[][]{{"1", "11"}});
                rs = s.executeQuery("select * from ATDC_13_TAB2");
                JDBC.assertFullResultSet(rs, new String[][]{{"1", "11"}});
                s.executeUpdate("update ATDC_13_TAB1 set c12=999");
                rs = s.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                JDBC.assertEmpty(rs);
                rs = s.executeQuery("select * from ATDC_13_TAB2");
                JDBC.assertEmpty(rs);
                s.execute("insert into ATDC_13_TAB1_BACKUP values (1,11)");
                s.execute("insert into ATDC_13_TAB2 values (1,11)");
                BasicSetup.assertStatementError("X0Y25", s, "alter table ATDC_13_TAB2 drop column c22 restrict");
                rs = s.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                JDBC.assertFullResultSet(rs, new String[][]{{"1", "11"}});
                rs = s.executeQuery("select * from ATDC_13_TAB2");
                JDBC.assertFullResultSet(rs, new String[][]{{"1", "11"}});
                s.executeUpdate("update ATDC_13_TAB1 set c12=999");
                rs = s.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                JDBC.assertEmpty(rs);
                rs = s.executeQuery("select * from ATDC_13_TAB2");
                JDBC.assertEmpty(rs);
                s.execute("insert into ATDC_13_TAB1_BACKUP values (1,11)");
                s.execute("insert into ATDC_13_TAB2 values (1,11)");
                s.executeUpdate("alter table ATDC_13_TAB2 drop column c22 ");
                s.executeUpdate("update ATDC_13_TAB1 set c12=999");
                rs = s.executeQuery("select * from ATDC_13_TAB1_BACKUP");
                JDBC.assertEmpty(rs);
                rs = s.executeQuery("select * from ATDC_13_TAB2");
                JDBC.assertFullResultSet(rs, new String[][]{{"1"}});
            }
        }
    }

    public void preapreFortDERBY5044() throws Exception {
        Statement s = this.createStatement();
        boolean modeDb2SqlOptional = this.oldAtLeast(10, 3);
        this.dropTable("ATDC_13_TAB1");
        this.dropTable("ATDC_13_TAB1_BACKUP");
        this.dropTable("ATDC_13_TAB2");
        s.execute("create table ATDC_13_TAB1(c11 int, c12 int)");
        s.execute("insert into ATDC_13_TAB1 values (1,11)");
        s.execute("create table ATDC_13_TAB1_BACKUP(c11 int, c12 int)");
        s.execute("insert into ATDC_13_TAB1_BACKUP values (1,11)");
        s.execute("create table ATDC_13_TAB2(c21 int, c22 int)");
        s.execute("insert into ATDC_13_TAB2 values (1,11)");
        s.executeUpdate(" create trigger ATDC_13_TAB1_trg1 after update on ATDC_13_TAB1 for each row " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "DELETE FROM ATDC_13_TAB1_BACKUP " + "WHERE C12>=1");
        s.executeUpdate(" create trigger ATDC_13_TAB1_trg2 after update on ATDC_13_TAB1 for each row " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "DELETE FROM ATDC_13_TAB2 WHERE " + "C22 IN (values(11))");
    }

    public void testDERBY5121TriggerDataCorruption() throws Exception {
        Statement s = this.createStatement();
        boolean modeDb2SqlOptional = this.oldAtLeast(10, 3);
        switch (this.getPhase()) {
            case 0: {
                s.execute("CREATE TABLE UPGRADE_tab1(id int, name varchar(20))");
                s.execute("CREATE TABLE UPGRADE_tab2(name varchar(20) not null, description int not null, id int)");
                s.execute("create trigger UPGRADE_Trg1 after UPDATE of name on UPGRADE_tab2 referencing new as nr for each ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "insert into UPGRADE_tab1 values ( nr.id, nr.name )");
                s.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                ResultSet rs = s.executeQuery("select * from UPGRADE_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(rs, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                }
                s.execute("delete from UPGRADE_tab1");
                s.execute("delete from UPGRADE_tab2");
                s.execute("CREATE TABLE POSTSFT_UPGRD_tab1(id int, name varchar(20))");
                s.execute("CREATE TABLE POSTSFT_UPGRD_tab2(name varchar(20) not null, description int not null, id int)");
                s.execute("create trigger POSTSFT_UPGRD_Trg1 after UPDATE of name on POSTSFT_UPGRD_tab2 referencing new as nr for each ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "insert into POSTSFT_UPGRD_tab1 values ( nr.id, nr.name )");
                s.execute("insert into POSTSFT_UPGRD_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update POSTSFT_UPGRD_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from POSTSFT_UPGRD_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(rs, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                }
                s.execute("delete from POSTSFT_UPGRD_tab1");
                s.execute("delete from POSTSFT_UPGRD_tab2");
                s.execute("CREATE TABLE HARD_UPGRADE_tab1(id int, name varchar(20))");
                s.execute("CREATE TABLE HARD_UPGRADE_tab2(name varchar(20) not null, description int not null, id int)");
                s.execute("create trigger HARD_UPGRADE_Trg1 after UPDATE of name on HARD_UPGRADE_tab2 referencing new as nr for each ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "insert into HARD_UPGRADE_tab1 values ( nr.id, nr.name )");
                s.execute("insert into HARD_UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update HARD_UPGRADE_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from HARD_UPGRADE_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(rs, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                }
                s.execute("delete from HARD_UPGRADE_tab1");
                s.execute("delete from HARD_UPGRADE_tab2");
                s.execute("CREATE TABLE POSTHRD_UPGRD_tab1(id int, name varchar(20))");
                s.execute("CREATE TABLE POSTHRD_UPGRD_tab2(name varchar(20) not null, description int not null, id int)");
                s.execute("create trigger POSTHRD_UPGRD_Trg1 after UPDATE of name on POSTHRD_UPGRD_tab2 referencing new as nr for each ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "insert into POSTHRD_UPGRD_tab1 values ( nr.id, nr.name )");
                s.execute("insert into POSTHRD_UPGRD_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update POSTHRD_UPGRD_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from POSTHRD_UPGRD_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(rs, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                }
                s.execute("delete from POSTHRD_UPGRD_tab1");
                s.execute("delete from POSTHRD_UPGRD_tab2");
                break;
            }
            case 1: {
                s.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                ResultSet rs = s.executeQuery("select * from UPGRADE_tab1");
                JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                s.execute("delete from UPGRADE_tab1");
                s.execute("delete from UPGRADE_tab2");
                s.execute("drop trigger UPGRADE_Trg1");
                s.execute("create trigger UPGRADE_Trg1 after UPDATE of name on UPGRADE_tab2 referencing new as nr for each ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "insert into UPGRADE_tab1 values ( nr.id, nr.name )");
                s.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from UPGRADE_tab1");
                JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                s.execute("delete from UPGRADE_tab1");
                s.execute("delete from UPGRADE_tab2");
                break;
            }
            case 2: {
                s.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                ResultSet rs = s.executeQuery("select * from UPGRADE_tab1");
                JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                s.execute("delete from UPGRADE_tab1");
                s.execute("delete from UPGRADE_tab2");
                s.execute("drop trigger UPGRADE_Trg1");
                s.execute("create trigger UPGRADE_Trg1 after UPDATE of name on UPGRADE_tab2 referencing new as nr for each ROW " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "insert into UPGRADE_tab1 values ( nr.id, nr.name )");
                s.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from UPGRADE_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(rs, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                }
                s.execute("delete from UPGRADE_tab1");
                s.execute("delete from UPGRADE_tab2");
                s.execute("insert into POSTSFT_UPGRD_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update POSTSFT_UPGRD_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from POSTSFT_UPGRD_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(rs, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                }
                s.execute("delete from POSTSFT_UPGRD_tab1");
                s.execute("delete from POSTSFT_UPGRD_tab2");
                s.execute("insert into HARD_UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update HARD_UPGRADE_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from HARD_UPGRADE_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(rs, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                }
                s.execute("delete from HARD_UPGRADE_tab1");
                s.execute("delete from HARD_UPGRADE_tab2");
                s.execute("insert into POSTHRD_UPGRD_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update POSTHRD_UPGRD_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from POSTHRD_UPGRD_tab1");
                if (this.oldIs(10, 7, 1, 1)) {
                    JDBC.assertFullResultSet(rs, new String[][]{{"1", "Another name"}});
                } else {
                    JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                }
                s.execute("delete from POSTHRD_UPGRD_tab1");
                s.execute("delete from POSTHRD_UPGRD_tab2");
                break;
            }
            case 3: {
                s.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                ResultSet rs = s.executeQuery("select * from UPGRADE_tab1");
                JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                s.execute("delete from UPGRADE_tab1");
                s.execute("delete from UPGRADE_tab2");
                s.execute("insert into HARD_UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update HARD_UPGRADE_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from HARD_UPGRADE_tab1");
                JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                s.execute("delete from HARD_UPGRADE_tab1");
                s.execute("delete from HARD_UPGRADE_tab2");
                break;
            }
            case 4: {
                s.execute("insert into UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update UPGRADE_tab2 set name = 'Another name' , description = 1");
                ResultSet rs = s.executeQuery("select * from UPGRADE_tab1");
                JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                s.execute("delete from UPGRADE_tab1");
                s.execute("delete from UPGRADE_tab2");
                s.execute("insert into HARD_UPGRADE_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update HARD_UPGRADE_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from HARD_UPGRADE_tab1");
                JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                s.execute("delete from HARD_UPGRADE_tab1");
                s.execute("delete from HARD_UPGRADE_tab2");
                s.execute("insert into POSTHRD_UPGRD_tab2(name,description) values ( 'Foo1 Name', 0 )");
                s.execute("update POSTHRD_UPGRD_tab2 set name = 'Another name' , description = 1");
                rs = s.executeQuery("select * from POSTHRD_UPGRD_tab1");
                JDBC.assertFullResultSet(rs, new String[][]{{null, "Another name"}});
                s.execute("delete from POSTHRD_UPGRD_tab1");
                s.execute("delete from POSTHRD_UPGRD_tab2");
            }
        }
    }

    public void atestTriggersWithLOBcolumns() throws Exception {
        Statement s = this.createStatement();
        boolean modeDb2SqlOptional = this.oldAtLeast(10, 3);
        int lobsize = 51200000;
        switch (this.getPhase()) {
            case 0: {
                s.execute("create table table1LOBtest (id int, status smallint, bl blob(2G))");
                PreparedStatement ps = this.prepareStatement("insert into table1LOBtest values (?, 0, ?)");
                ps.setInt(1, 1);
                ps.setBinaryStream(2, (InputStream)new LoopingAlphabetStream(51200000L), 51200000);
                ps.executeUpdate();
                s.execute("create table table2LOBtest (id int, updates int default 0)");
                ps = this.prepareStatement("insert into table2LOBtest (id) values (?)");
                ps.setInt(1, 1);
                ps.executeUpdate();
                s.execute("create trigger trigger1 after update of status on table1LOBtest referencing new as n_row for each row " + (modeDb2SqlOptional ? "" : "MODE DB2SQL ") + "update table2LOBtest set updates = updates + 1 where table2LOBtest.id = n_row.id");
                break;
            }
            case 3: {
                if (this.getConnection().getMetaData().getDatabaseMajorVersion() < 10 || this.getConnection().getMetaData().getDatabaseMinorVersion() < 9) break;
                PreparedStatement ps = this.prepareStatement("update table1LOBtest set status = 1 where id = 1");
                ps.executeUpdate();
            }
        }
    }

    public void testExhuastivePermutationOfTriggerColumns() throws Exception {
        int STATUS_COUNTERS = 2;
        int columnCount = 3;
        int[][] powerSet = this.constructPowerSet(columnCount);
        int[][] permutations = this.permute(powerSet);
        int[] statusCounters = new int[2];
        switch (this.getPhase()) {
            case 0: {
                for (int triggerCols = 0; triggerCols < powerSet.length; ++triggerCols) {
                    for (int perm = 0; perm < permutations.length; ++perm) {
                        this.createT1(powerSet[triggerCols], permutations[perm]);
                        this.createT2(columnCount, powerSet[triggerCols], permutations[perm]);
                        this.createTrigger(powerSet[triggerCols], permutations[perm]);
                    }
                }
                break;
            }
            case 1: {
                for (int triggerCols = 0; triggerCols < powerSet.length; ++triggerCols) {
                    for (int perm = 0; perm < permutations.length; ++perm) {
                        for (int i = 0; i < permutations.length; ++i) {
                            this.runTrigger(statusCounters, columnCount, powerSet[triggerCols], permutations[perm], permutations[i]);
                        }
                    }
                }
                break;
            }
        }
        this.summarize(statusCounters);
    }

    private int[][] constructPowerSet(int count) {
        ArrayList list = new ArrayList();
        boolean[] inclusions = new boolean[count];
        this.include(list, 0, inclusions);
        int[][] result = new int[list.size()][];
        list.toArray((T[])result);
        return result;
    }

    private void include(ArrayList list, int idx, boolean[] inclusions) {
        if (idx >= inclusions.length) {
            int totalLength = inclusions.length;
            int count = 0;
            for (int i = 0; i < totalLength; ++i) {
                if (!inclusions[i]) continue;
                ++count;
            }
            if (count > 0) {
                int[] result = new int[count];
                int index = 0;
                for (int i = 0; i < totalLength; ++i) {
                    if (!inclusions[i]) continue;
                    result[index++] = i;
                }
                list.add(result);
            }
            return;
        }
        this.include(list, idx, inclusions, false);
        this.include(list, idx, inclusions, true);
    }

    private void include(ArrayList list, int idx, boolean[] inclusions, boolean currentCell) {
        inclusions[idx++] = currentCell;
        this.include(list, idx, inclusions);
    }

    private int[][] permute(int[][] original) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < original.length; ++i) {
            this.permute(list, new int[0], original[i]);
        }
        int[][] result = new int[list.size()][];
        list.toArray((T[])result);
        return result;
    }

    private void permute(ArrayList list, int[] start, int[] remainder) {
        int startLength = start.length;
        int remainderLength = remainder.length;
        for (int idx = 0; idx < remainder.length; ++idx) {
            int[] newStart = new int[startLength + 1];
            for (int i = 0; i < startLength; ++i) {
                newStart[i] = start[i];
            }
            newStart[startLength] = remainder[idx];
            if (remainderLength <= 1) {
                list.add(newStart);
                continue;
            }
            int[] newRemainder = new int[remainderLength - 1];
            int index = 0;
            for (int i = 0; i < remainderLength; ++i) {
                if (i == idx) continue;
                newRemainder[index++] = remainder[i];
            }
            this.permute(list, newStart, newRemainder);
        }
    }

    private String columnName(String stub, int idx) {
        return stub + '_' + idx;
    }

    private void createT1(int[] triggerCols, int[] permutation) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("create table " + this.makeTableName("t1", triggerCols, permutation) + "( ");
        for (int i = 0; i < permutation.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.columnName("b", i));
            buffer.append(" int");
        }
        buffer.append(" )");
        Statement s = this.createStatement();
        s.execute(buffer.toString());
    }

    private void createT2(int columnCount, int[] triggerCols, int[] permutation) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("create table " + this.makeTableName("t2", triggerCols, permutation) + "( ");
        for (int i = 0; i < columnCount; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.columnName("a", i));
            buffer.append(" int");
        }
        buffer.append(" )");
        Statement s = this.createStatement();
        s.execute(buffer.toString());
    }

    private String makeTableName(String stub, int[] triggerCols, int[] permutation) {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append(stub);
        for (i = 0; i < triggerCols.length; ++i) {
            buffer.append("_");
            buffer.append(triggerCols[i]);
        }
        buffer.append("__");
        for (i = 0; i < permutation.length; ++i) {
            buffer.append("_");
            buffer.append(permutation[i]);
        }
        return buffer.toString();
    }

    private void createTrigger(int[] triggerCols, int[] permutation) throws Exception {
        int i;
        boolean modeDb2SqlOptional = this.oldAtLeast(10, 3);
        StringBuffer buffer = new StringBuffer();
        buffer.append("create trigger " + this.makeTriggerName("UTrg", triggerCols, permutation) + " after update of ");
        for (i = 0; i < triggerCols.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.columnName("a", triggerCols[i]));
        }
        buffer.append("\n\ton " + this.makeTableName("t2", triggerCols, permutation) + " referencing new as nr for each row ");
        buffer.append(modeDb2SqlOptional ? "" : "\n\tMODE DB2SQL ");
        buffer.append("\n\tinsert into " + this.makeTableName("t1", triggerCols, permutation) + " values ( ");
        for (i = 0; i < permutation.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("nr." + this.columnName("a", permutation[i]));
        }
        buffer.append(" )");
        Statement s = this.createStatement();
        s.execute(buffer.toString());
    }

    private String makeTriggerName(String stub, int[] triggerCols, int[] permutation) {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append(stub);
        for (i = 0; i < triggerCols.length; ++i) {
            buffer.append("_");
            buffer.append(triggerCols[i]);
        }
        buffer.append("__");
        for (i = 0; i < permutation.length; ++i) {
            buffer.append("_");
            buffer.append(permutation[i]);
        }
        return buffer.toString();
    }

    private int[] getResults(int rowLength, String text) throws Exception {
        PreparedStatement ps = this.prepareStatement(text);
        ResultSet rs = ps.executeQuery();
        if (!rs.next()) {
            return new int[0];
        }
        int[] result = new int[rowLength];
        for (int i = 0; i < rowLength; ++i) {
            result[i] = rs.getInt(i + 1);
        }
        rs.close();
        ps.close();
        return result;
    }

    private boolean overlap(int[] left, int[] right) {
        for (int i = 0; i < left.length; ++i) {
            for (int j = 0; j < right.length; ++j) {
                if (left[i] != right[j]) continue;
                return true;
            }
        }
        return false;
    }

    private void vetData(int[] statusCounters, int[] triggerCols, int[] permutation, int[] updateColumns, String updateStatement) throws Exception {
        String t1Name = this.makeTableName("t1", triggerCols, permutation);
        String t2Name = this.makeTableName("t2", triggerCols, permutation);
        int rowLength = permutation.length;
        int[] t1Row = this.getResults(rowLength, "select * from " + t1Name);
        if (!this.overlap(triggerCols, updateColumns)) {
            if (t1Row.length != 0) {
                this.fail(statusCounters, triggerCols, permutation, updateColumns, "No row should have been inserted into t1! updateStatement = '" + updateStatement + "' and t1Row = " + this.stringify(t1Row));
            }
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("select ");
        for (int i = 0; i < permutation.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.columnName("a", permutation[i]));
        }
        buffer.append(" from " + t2Name);
        int[] t2Row = this.getResults(rowLength, buffer.toString());
        if (!this.stringify(t1Row).equals(this.stringify(t2Row))) {
            String detail = "Wrong data inserted into t1! updateStatement = '" + updateStatement + "'. " + "Expected " + this.stringify(t2Row) + " but found " + this.stringify(t1Row);
            this.fail(statusCounters, triggerCols, permutation, updateColumns, detail);
        }
    }

    private void runTrigger(int[] statusCounters, int columnCount, int[] triggerCols, int[] permutation, int[] updateColumns) throws Exception {
        statusCounters[0] = statusCounters[0] + 1;
        this.loadData(columnCount, triggerCols, permutation);
        String updateStatement = this.updateData(statusCounters, triggerCols, permutation, updateColumns);
        this.vetData(statusCounters, triggerCols, permutation, updateColumns, updateStatement);
    }

    private void loadData(int columnCount, int[] triggerCols, int[] permutation) throws Exception {
        String t1Name = this.makeTableName("t1", triggerCols, permutation);
        String t2Name = this.makeTableName("t2", triggerCols, permutation);
        Statement s = this.createStatement();
        s.execute("delete from " + t1Name);
        s.execute("delete from " + t2Name);
        StringBuffer buffer = new StringBuffer();
        buffer.append("insert into " + t2Name + " values ( ");
        for (int i = 0; i < columnCount; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(i);
        }
        buffer.append(" )");
        s.execute(buffer.toString());
    }

    private String updateData(int[] statusCounters, int[] triggerCols, int[] permutation, int[] updateColumns) throws Exception {
        String t2Name = this.makeTableName("t2", triggerCols, permutation);
        StringBuffer buffer = new StringBuffer();
        buffer.append("update " + t2Name + " set ");
        for (int i = 0; i < updateColumns.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.columnName("a", updateColumns[i]));
            buffer.append(" = ");
            buffer.append(100 + i);
        }
        String updateStatement = buffer.toString();
        try {
            Statement s = this.createStatement();
            s.execute(updateStatement);
        }
        catch (SQLException se) {
            this.fail(statusCounters, triggerCols, permutation, updateColumns, "Update statement failed! updateStatement = '" + updateStatement);
        }
        return updateStatement;
    }

    private void fail(int[] statusCounters, int[] triggerCols, int[] permutation, int[] updateColumns, String detail) {
        statusCounters[1] = statusCounters[1] + 1;
        String message = "FAILED for triggerCols = " + this.stringify(triggerCols) + " and permutation = " + this.stringify(permutation) + " and updateColumns = " + this.stringify(updateColumns) + ". " + detail;
        System.out.println(message);
    }

    private void summarize(int[] statusCounters) {
        int testCount = statusCounters[0];
        int failures = statusCounters[1];
        if (failures != 0) {
            System.out.println("FAILURE! " + testCount + " test cases run, of which " + failures + " failed.");
        }
    }

    private String stringify(int[][] array) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        for (int i = 0; i < array.length; ++i) {
            buffer.append("\n\t");
            buffer.append(this.stringify(array[i]));
        }
        buffer.append("\n]\n");
        return buffer.toString();
    }

    private String stringify(int[] array) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        for (int j = 0; j < array.length; ++j) {
            if (j > 0) {
                buffer.append(", ");
            }
            buffer.append(array[j]);
        }
        buffer.append("]");
        return buffer.toString();
    }

    public void xmlTestTriggerWithXMLOperators() throws SQLException {
        if (!this.oldAtLeast(10, 3)) {
            return;
        }
        if (this.getPhase() == 2 && this.oldSuffersFromDerby4835()) {
            return;
        }
        Statement s = this.createStatement();
        if (this.getPhase() == 0) {
            s.execute("create table d3870_t1(i int, x varchar(100))");
            s.execute("create table d3870_t2(i int)");
            try {
                s.execute("create trigger d3870_tr after insert on d3870_t1 for each statement insert into d3870_t2 select i from d3870_t1 where xmlexists('//a' passing by ref xmlparse(document x preserve whitespace))");
            }
            catch (SQLException sqle) {
                BasicSetup.assertSQLState("XML00", sqle);
                return;
            }
        } else {
            s.executeUpdate("delete from d3870_t1");
            s.executeUpdate("delete from d3870_t2");
        }
        ResultSet rs = s.executeQuery("select 1 from sys.systriggers where triggername = 'D3870_TR'");
        boolean hasTrigger = rs.next();
        rs.close();
        if (hasTrigger) {
            s.execute("insert into d3870_t1 values (1, '<a/>'), (2, '<b/>'), (3, '<c/>')");
            JDBC.assertSingleValueResultSet(s.executeQuery("select * from d3870_t2"), "1");
        }
    }

    public void testDERBY5289TriggerUpgradeFormat() throws SQLException {
        if (this.oldSuffersFromDerby4835()) {
            return;
        }
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                s.executeUpdate("CREATE TABLE D5289TABLE1 (COL1 VARCHAR(5))");
                s.executeUpdate("CREATE TABLE D5289TABLE2 (COL2 VARCHAR(5))");
                s.executeUpdate("CREATE TABLE D5289TABLE3 (COL3 VARCHAR(5))");
                s.executeUpdate("CREATE TRIGGER D5289T1_UPDATED AFTER UPDATE ON D5289TABLE1 REFERENCING OLD AS OLD NEW AS NEW FOR EACH ROW MODE DB2SQL UPDATE D5289TABLE2 SET COL2 = NEW.COL1 WHERE COL2 = OLD.COL1");
                s.executeUpdate("CREATE TRIGGER D5289T2_UPDATED AFTER UPDATE ON D5289TABLE2 REFERENCING NEW AS NEW FOR EACH ROW MODE DB2SQL INSERT INTO D5289TABLE3(COL3) VALUES('ccc')");
                s.executeUpdate("insert into D5289TABLE1(COL1) values ('aaa') ");
                s.executeUpdate("insert into D5289TABLE2(COL2) values ('aaa') ");
                s.executeUpdate("UPDATE D5289TABLE1 SET COL1 = 'bbb'");
                this.assertDERBY5289ResultsAndDelete();
                break;
            }
            case 1: {
                s.executeUpdate("insert into D5289TABLE1(COL1) values ('aaa')");
                s.executeUpdate("insert into D5289TABLE2(COL2) values ('aaa')");
                s.executeUpdate("UPDATE D5289TABLE1 SET COL1 = 'bbb'");
                this.assertDERBY5289ResultsAndDelete();
                break;
            }
            case 2: {
                if (this.oldLessThan(10, 8, 2, 0)) break;
                s.executeUpdate("insert into D5289TABLE1(COL1) values ('aaa')");
                s.executeUpdate("insert into D5289TABLE2(COL2) values ('aaa') ");
                s.executeUpdate("UPDATE D5289TABLE1 SET COL1 = 'bbb'");
                this.assertDERBY5289ResultsAndDelete();
                break;
            }
            case 3: {
                s.executeUpdate("insert into D5289TABLE1(COL1) values ('aaa')");
                s.executeUpdate("insert into D5289TABLE2(COL2) values ('aaa') ");
                s.executeUpdate("UPDATE D5289TABLE1 SET COL1 = 'bbb'");
                this.assertDERBY5289ResultsAndDelete();
            }
        }
    }

    private void assertDERBY5289ResultsAndDelete() throws SQLException {
        Statement s = this.createStatement();
        JDBC.assertFullResultSet(s.executeQuery("SELECT * FROM D5289TABLE1"), new String[][]{{"bbb"}});
        JDBC.assertFullResultSet(s.executeQuery("SELECT * FROM D5289TABLE2"), new String[][]{{"bbb"}});
        JDBC.assertFullResultSet(s.executeQuery("SELECT * FROM D5289TABLE3"), new String[][]{{"ccc"}});
        s.executeUpdate("DELETE FROM D5289TABLE1");
        s.executeUpdate("DELETE FROM D5289TABLE2");
        s.executeUpdate("DELETE FROM D5289TABLE3");
        this.commit();
    }
}

