/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.storetests;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.tests.store.BaseTest;

public class st_reclaim_longcol
extends BaseTest {
    static boolean verbose = false;
    private static final int SHORT_BLOB_SIZE = 10;

    private static void setup() throws Exception {
    }

    public void test1(Connection conn, int blob_size, int num_rows) throws SQLException {
        int total_expected_page_max;
        byte[] long_byteVal = new byte[blob_size];
        byte[] short_byteVal = new byte[10];
        this.beginTest(conn, "test1:insert/delete of " + num_rows + " rows with blob(" + blob_size + ")");
        Arrays.fill(long_byteVal, (byte)76);
        Arrays.fill(short_byteVal, (byte)83);
        this.createTable(conn, "longcol", "create table longcol (id int primary key not null, val blob(" + blob_size + "))");
        conn.commit();
        PreparedStatement ins_stmt = conn.prepareStatement("insert into longcol values (?, ?)");
        PreparedStatement del_stmt = conn.prepareStatement("delete from longcol where id = ?");
        int worst_case_max_allocated = 5;
        for (int iter = 1; iter < num_rows; ++iter) {
            ins_stmt.setInt(1, iter);
            ins_stmt.setBytes(2, long_byteVal);
            ins_stmt.executeUpdate();
            ins_stmt.setInt(1, -iter);
            ins_stmt.setBytes(2, short_byteVal);
            ins_stmt.executeUpdate();
            del_stmt.setInt(1, iter);
            del_stmt.executeUpdate();
            conn.commit();
            this.wait_for_max_allocated(conn, "test1", ++worst_case_max_allocated);
        }
        int[] sp_info = this.getSpaceInfo(conn, "APP", "LONGCOL", true);
        int total_pages = sp_info[1] + sp_info[2];
        if (total_pages > (total_expected_page_max = 12 + num_rows)) {
            System.out.println("Test 1 failed, expected less than " + total_expected_page_max + " pages - count is:\n" + "free pages     : " + sp_info[2] + "\nallocated pages: " + sp_info[1]);
        }
        if (verbose) {
            System.out.println("Space information after " + num_rows + "insert/delete pairs of rows in longcol table containing " + blob_size + "blobs:");
            System.out.println("isindex = " + sp_info[0]);
            System.out.println("num_alloc = " + sp_info[1]);
            System.out.println("num_free = " + sp_info[2]);
            System.out.println("page_size = " + sp_info[4]);
            System.out.println("estimspacesaving = " + sp_info[5]);
        }
        this.endTest(conn, "test1:insert/delete of " + num_rows + " rows with blob(" + blob_size + ")");
    }

    public void test2(Connection conn, int blob_size, int work_size, int total_work) throws SQLException {
        int iter;
        byte[] long_byteVal = new byte[blob_size];
        byte[] short_byteVal = new byte[10];
        this.beginTest(conn, "test2:queue of " + work_size + " rows with blob(" + blob_size + "), total_work = " + total_work);
        Arrays.fill(long_byteVal, (byte)76);
        Arrays.fill(short_byteVal, (byte)83);
        this.createTable(conn, "longcol", "create table longcol (id int primary key not null, val blob(" + blob_size + "))");
        conn.commit();
        PreparedStatement ins_stmt = conn.prepareStatement("insert into longcol values (?, ?)");
        PreparedStatement del_stmt = conn.prepareStatement("delete from longcol where id = ?");
        for (iter = 0; iter < work_size; ++iter) {
            ins_stmt.setInt(1, iter);
            ins_stmt.setBytes(2, long_byteVal);
            ins_stmt.executeUpdate();
        }
        conn.commit();
        for (iter = work_size; iter < total_work; ++iter) {
            ins_stmt.setInt(1, iter);
            ins_stmt.setBytes(2, long_byteVal);
            ins_stmt.executeUpdate();
            del_stmt.setInt(1, iter - work_size);
            del_stmt.executeUpdate();
            conn.commit();
        }
        this.wait_for_max_allocated(conn, "test2", 10 * work_size + 5);
        int[] sp_info = this.getSpaceInfo(conn, "APP", "LONGCOL", true);
        int total_pages = sp_info[1] + sp_info[2];
        if (verbose) {
            System.out.println("Space information:");
            System.out.println("isindex = " + sp_info[0]);
            System.out.println("num_alloc = " + sp_info[1]);
            System.out.println("num_free = " + sp_info[2]);
            System.out.println("page_size = " + sp_info[4]);
            System.out.println("estimspacesaving = " + sp_info[5]);
        }
        for (int iter2 = total_work; iter2 < total_work * 2; ++iter2) {
            ins_stmt.setInt(1, iter2);
            ins_stmt.setBytes(2, long_byteVal);
            ins_stmt.executeUpdate();
            del_stmt.setInt(1, iter2 - work_size);
            del_stmt.executeUpdate();
            conn.commit();
        }
        this.wait_for_max_allocated(conn, "test2_2", 10 * work_size + 5);
        int[] second_sp_info = this.getSpaceInfo(conn, "APP", "LONGCOL", true);
        int second_total_pages = sp_info[1] + sp_info[2];
        if (total_pages != second_total_pages) {
            System.out.println("Test 2 failed, expected constant memory after second run.initial total = " + total_pages + "second total = " + second_total_pages);
        }
        if (verbose) {
            System.out.println("Space information:");
            System.out.println("isindex = " + sp_info[0]);
            System.out.println("num_alloc = " + sp_info[1]);
            System.out.println("num_free = " + sp_info[2]);
            System.out.println("page_size = " + sp_info[4]);
            System.out.println("estimspacesaving = " + sp_info[5]);
        }
        this.endTest(conn, "test2:queue of " + work_size + " rows with blob(" + blob_size + "), total_work = " + total_work);
    }

    private void wait_for_max_allocated(Connection conn, String test_name, int alloc_wait_count) throws SQLException {
        int total_alloc;
        try {
            Thread.sleep(100L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        int[] sp_info = this.getSpaceInfo(conn, "APP", "LONGCOL", true);
        int save_total_alloc = total_alloc = sp_info[1];
        int max_wait_for_bg_thread = 10000;
        int ms_waited = 100;
        while (total_alloc > alloc_wait_count) {
            if (ms_waited < max_wait_for_bg_thread) {
                try {
                    ms_waited += 1000;
                    Thread.sleep(1000L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                sp_info = this.getSpaceInfo(conn, "APP", "LONGCOL", true);
                total_alloc = sp_info[1];
                continue;
            }
            if (total_alloc < save_total_alloc) {
                save_total_alloc = total_alloc;
                max_wait_for_bg_thread += 10000;
                continue;
            }
            System.out.println("Test " + test_name + " failed in wait_for_max_allocated(), expected less than " + alloc_wait_count + " allocated pages:\n" + "free pages     : " + sp_info[2] + "\nallocated pages: " + sp_info[1] + "\nWaited " + ms_waited + "ms. for background work.");
            break;
        }
    }

    public void testList(Connection conn) throws SQLException {
        this.test1(conn, 250000, 20);
    }

    public static void main(String[] argv) throws Throwable {
        st_reclaim_longcol test = new st_reclaim_longcol();
        ij.getPropertyArg((String[])argv);
        Connection conn = ij.startJBMS();
        try {
            test.testList(conn);
        }
        catch (SQLException sqle) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
            sqle.printStackTrace(System.out);
        }
    }
}

