/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.ij;

public class checkPoint {
    private static String derbyHome;
    private static File dbDir;
    private static File logDir;
    private static File logControlFile;
    private static long lastCheckPointTime;

    public static void main(String[] args) {
        Connection conn;
        System.out.println("Test checkpoint starting");
        try {
            ij.getPropertyArg((String[])args);
            conn = ij.startJBMS();
            checkPoint.setupAllTestFiles();
            Statement stmt = conn.createStatement();
            stmt.executeUpdate("CREATE PROCEDURE WAIT_FOR_POST_COMMIT() DYNAMIC RESULT SETS 0 LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_Access.waitForPostCommitToFinish' PARAMETER STYLE JAVA");
            stmt.executeUpdate("create table t1(c1 int not null primary key , c2 varchar(200) not null unique , c3 char(200) not null unique)");
            conn.setAutoCommit(true);
            String ins_string = "insert into t1 values(?,?,?)";
            PreparedStatement insStmt = conn.prepareStatement(ins_string);
            stmt.executeUpdate("CALL SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()");
            stmt.executeUpdate("call WAIT_FOR_POST_COMMIT()");
            checkPoint.checkpointOccured();
            boolean modifiedIntervals = false;
            for (int uniqueid = 0; uniqueid < 3500; ++uniqueid) {
                insStmt.setLong(1, uniqueid);
                insStmt.setString(2, "IBM GREAT COMPANY " + uniqueid);
                insStmt.setString(3, "IBM GREAT COMPANY " + uniqueid);
                insStmt.executeUpdate();
                if (uniqueid % 400 == 0) {
                    System.out.println("Checking logs and Checkpoint at Insert:" + uniqueid);
                    stmt.executeUpdate("call WAIT_FOR_POST_COMMIT()");
                    checkPoint.checkpointOccured();
                }
                if (uniqueid <= 2500 || modifiedIntervals) continue;
                System.out.println("Modifying the checkpoint/log intervals");
                String value = "150001";
                stmt.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.logSwitchInterval', '" + value + "'" + ")");
                stmt.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.checkpointInterval', '" + value + "'" + ")");
                ResultSet rs = stmt.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.storage.checkpointInterval')");
                while (rs.next()) {
                    System.out.println("checkPointInterval:" + rs.getString(1));
                }
                rs = stmt.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.storage.logSwitchInterval')");
                while (rs.next()) {
                    System.out.println("logSwitchInterval:" + rs.getString(1));
                }
                modifiedIntervals = true;
            }
            checkPoint.numberOfLogFiles();
            conn.commit();
            stmt.close();
            insStmt.close();
            conn.close();
        }
        catch (SQLException e) {
            checkPoint.dumpSQLExceptions(e);
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
        try {
            conn = DriverManager.getConnection("jdbc:derby:wombat;shutdown=true");
        }
        catch (SQLException se) {
            if (se.getSQLState() != null && se.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly\n");
            } else {
                checkPoint.dumpSQLExceptions(se);
            }
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
        System.out.println("Test checkpoint finished");
    }

    private static void dumpSQLExceptions(SQLException se) {
        System.out.println("FAIL -- unexpected exception: " + se.toString());
        while (se != null) {
            System.out.print("SQLSTATE(" + se.getSQLState() + "):");
            se = se.getNextException();
        }
    }

    private static void setupAllTestFiles() {
        derbyHome = System.getProperty("derby.system.home");
        dbDir = new File(derbyHome, "wombat");
        logDir = new File(dbDir, "log");
        logControlFile = new File(logDir, "log.ctrl");
        lastCheckPointTime = logControlFile.lastModified();
    }

    private static boolean checkpointOccured() {
        long currentModifiedTime = logControlFile.lastModified();
        if (currentModifiedTime > lastCheckPointTime) {
            lastCheckPointTime = currentModifiedTime;
            System.out.println("CHECKPOINT WAS DONE");
            return true;
        }
        return false;
    }

    private static int numberOfLogFiles() {
        File[] logFiles = logDir.listFiles();
        int noFiles = logFiles == null ? 0 : logFiles.length;
        String lastLogFile = "";
        for (int i = 0; i < noFiles; ++i) {
            String current = logFiles[i].getName();
            if (current.compareTo("log.ctrl") == 0 || current.compareTo("logmirror.ctrl") == 0 || current.compareTo(lastLogFile) <= 0) continue;
            lastLogFile = current;
        }
        if (lastLogFile.compareTo("log21.dat") > 0) {
            System.out.println("There seems to be too many log files");
            System.out.println(lastLogFile);
        }
        logFiles = null;
        return noFiles - 2;
    }

    static {
        lastCheckPointTime = 0L;
    }
}

