/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ServicePropertiesFileTest
extends BaseJDBCTestCase {
    private static final String LOG_A_MODE = "derby.storage.logArchiveMode";
    private static final String END_TOKEN = "#--- last line, don't put anything after this line ---";
    private static final String DB_NAME = "spfTestDb";
    private static File databasesDir;
    private static File pristineDb;
    private static boolean dbInitialized;
    private File dbToDelete;
    private File spf;
    private File spfOld;

    public ServicePropertiesFileTest(String name) {
        super(name);
    }

    public void setUp() throws SQLException {
        if (!dbInitialized) {
            DataSource ds = JDBCDataSource.getDataSourceLogical(DB_NAME);
            JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
            ds.getConnection();
            JDBCDataSource.shutdownDatabase(ds);
            File systemHome = new File(ServicePropertiesFileTest.getSystemProperty("derby.system.home"));
            databasesDir = new File(systemHome, "singleUse");
            pristineDb = new File(systemHome, TestConfiguration.getCurrent().getPhysicalDatabaseName(DB_NAME));
            dbInitialized = true;
        }
    }

    public void tearDown() throws Exception {
        if (this.dbToDelete != null) {
            ServicePropertiesFileTest.assertDirectoryDeleted(this.dbToDelete);
        }
        super.tearDown();
    }

    public void testMissingServicePropertiesFileNoBackup() throws IOException, SQLException {
        String db = "spfTestMissingSPFNB";
        this.copyDbAs(db);
        PrivilegedFileOpsForTests.delete(this.spf);
        this.assertPresence(false, false);
        try {
            this.connectThenShutdown(db);
            ServicePropertiesFileTest.fail((String)"booted database without a service.properties file");
        }
        catch (SQLException sqle) {
            ServicePropertiesFileTest.assertSQLState("error message has changed", "XJ004", sqle);
        }
    }

    public void testMissingServicePropertiesFileWithBackup() throws IOException, SQLException {
        String db = "spfTestMissingSPFWB";
        this.copyDbAs(db);
        this.createSPFBackup(false);
        this.assertPresence(false, true);
        this.connectThenShutdown(db);
        this.assertNormalPresence();
    }

    public void testSevicePropertiesFileWithBackup() throws IOException, SQLException {
        String db = "spfTestSPFWB";
        this.copyDbAs(db);
        this.createSPFBackup(true);
        this.assertPresence(true, true);
        this.connectThenShutdown(db);
        this.assertNormalPresence();
        this.assertEOFToken(this.spf);
    }

    public void testSevicePropertiesFileCorruptedWithBackup() throws IOException, SQLException {
        String db = "spfTestSPFCWB";
        this.copyDbAs(db);
        this.createSPFBackup(true);
        this.removeEOFToken(this.spf);
        this.assertPresence(true, true);
        this.connectThenShutdown(db);
        this.assertNormalPresence();
        this.assertEOFToken(this.spf);
    }

    public void testBackupWithBackupExisting() throws IOException, SQLException {
        String db = "spfTestBWBE";
        this.copyDbAs(db);
        this.assertPresence(true, false);
        ServicePropertiesFileTest.assertEquals((int)0, (int)this.grepForToken(LOG_A_MODE, this.spf));
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "databaseName", "singleUse/" + db);
        Connection con = ds.getConnection();
        this.createSPFBackup(true);
        Statement stmt = con.createStatement();
        stmt.execute("CALL SYSCS_UTIL.SYSCS_DISABLE_LOG_ARCHIVE_MODE(0)");
        con.close();
        JDBCDataSource.shutdownDatabase(ds);
        this.assertNormalPresence();
        ServicePropertiesFileTest.assertEquals((int)1, (int)this.grepForToken("derby.storage.logArchiveMode=false", this.spf));
    }

    private void assertNormalPresence() {
        this.assertPresence(true, false);
    }

    private void assertPresence(boolean spfPresence, boolean spfOldPresence) {
        ServicePropertiesFileTest.assertEquals((String)("incorrect '" + this.spf.getAbsolutePath() + "' presence,"), (boolean)spfPresence, (boolean)PrivilegedFileOpsForTests.exists(this.spf));
        ServicePropertiesFileTest.assertEquals((String)("incorrect '" + this.spfOld.getPath() + "' presence,"), (boolean)spfOldPresence, (boolean)PrivilegedFileOpsForTests.exists(this.spfOld));
    }

    private void assertEOFToken(File file) throws IOException {
        String cur;
        BufferedReader in = new BufferedReader(PrivilegedFileOpsForTests.getFileReader(file));
        String prev = null;
        while ((cur = in.readLine()) != null) {
            prev = cur;
        }
        in.close();
        ServicePropertiesFileTest.assertNotNull((String)"last line is null - empty file?", (Object)prev);
        ServicePropertiesFileTest.assertTrue((boolean)prev.startsWith(END_TOKEN));
    }

    private void removeEOFToken(File original) throws IOException {
        String line;
        File renamed = new File(original.getAbsolutePath() + "-renamed");
        PrivilegedFileOpsForTests.copy(original, renamed);
        PrivilegedFileOpsForTests.delete(original);
        BufferedReader in = new BufferedReader(PrivilegedFileOpsForTests.getFileReader(renamed));
        BufferedWriter out = new BufferedWriter(PrivilegedFileOpsForTests.getFileWriter(original));
        String prev = null;
        while ((line = in.readLine()) != null) {
            if (prev != null) {
                out.write(prev);
                out.newLine();
            }
            prev = line;
        }
        ServicePropertiesFileTest.assertEquals((String)END_TOKEN, prev);
        in.close();
        out.close();
        PrivilegedFileOpsForTests.delete(renamed);
    }

    private int grepForToken(String token, File file) throws IOException {
        String line;
        int matchingLines = 0;
        BufferedReader in = new BufferedReader(PrivilegedFileOpsForTests.getFileReader(file));
        while ((line = in.readLine()) != null) {
            if (line.indexOf(token) == -1) continue;
            ++matchingLines;
        }
        in.close();
        return matchingLines;
    }

    private void copyDbAs(String name) throws IOException {
        File newDb;
        this.dbToDelete = newDb = new File(databasesDir, name);
        PrivilegedFileOpsForTests.copy(pristineDb, newDb);
        this.spf = new File(newDb, "service.properties");
        this.spfOld = new File(newDb, "service.propertiesold");
    }

    private void createSPFBackup(boolean keepOriginal) throws IOException {
        PrivilegedFileOpsForTests.copy(this.spf, this.spfOld);
        if (!keepOriginal) {
            PrivilegedFileOpsForTests.delete(this.spf);
        }
    }

    private void connectThenShutdown(String db) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "databaseName", "singleUse/" + db);
        ds.getConnection().close();
        JDBCDataSource.shutdownDatabase(ds);
    }

    public static Test suite() {
        return TestConfiguration.additionalDatabaseDecoratorNoShutdown(TestConfiguration.embeddedSuite(ServicePropertiesFileTest.class), DB_NAME);
    }
}

