/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class HoldCursorExternalSortJDBC30Test
extends BaseJDBCTestCase {
    public HoldCursorExternalSortJDBC30Test(String name) {
        super(name);
    }

    public static Test suite() {
        Properties sysProps = new Properties();
        sysProps.put("derby.storage.sortBufferMax", "5");
        sysProps.put("derby.debug.true", "testSort");
        Test suite = TestConfiguration.embeddedSuite(HoldCursorExternalSortJDBC30Test.class);
        return new CleanDatabaseTestSetup((Test)new SystemPropertyTestSetup(suite, sysProps, true)){

            protected void decorateSQL(Statement s) throws SQLException {
                Connection conn = s.getConnection();
                conn.setAutoCommit(false);
                s.executeUpdate("create table foo (a int, data varchar(2000))");
                s.executeUpdate("create table bar (a int, data varchar(2000))");
                PreparedStatement ps = conn.prepareStatement("insert into foo values(?,?), (?,?), (?,?), (?,?), (?,?), (?,?), (?,?), (?,?), (?,?), (?,?)");
                for (int i = 0; i <= 9; ++i) {
                    ps.setInt(i * 2 + 1, i + 1);
                    ps.setString(i * 2 + 2, Formatters.padString("" + (i + 1), 2000));
                }
                ps.executeUpdate();
                ps.close();
                s.execute("INSERT INTO bar SELECT * FROM foo");
            }
        };
    }

    public void testOrder_Hold() throws SQLException {
        this.setAutoCommit(false);
        Statement stUtil = this.createStatement();
        stUtil.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.language.bulkFetchDefault', '1')");
        Statement st = this.createStatement(1004, 1007, 1);
        st.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ResultSet test1 = st.executeQuery("select * from foo order by a");
        stUtil.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.language.bulkFetchDefault', '16')");
        boolean[] doCommitAfter = new boolean[]{true, false, false, false, true, false, false, false, true, false};
        for (int i = 0; i < 10; ++i) {
            HoldCursorExternalSortJDBC30Test.assertTrue((boolean)test1.next());
            HoldCursorExternalSortJDBC30Test.assertEquals((int)(i + 1), (int)test1.getInt("a"));
            HoldCursorExternalSortJDBC30Test.assertEquals((String)Formatters.padString("" + (i + 1), 2000), (String)test1.getString("data"));
            if (!doCommitAfter[i]) continue;
            this.commit();
        }
        HoldCursorExternalSortJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        this.commit();
        RuntimeStatisticsParser parser = SQLUtilities.getRuntimeStatisticsParser(st);
        HoldCursorExternalSortJDBC30Test.assertTrue((boolean)parser.usedExternalSort());
        st.close();
        stUtil.close();
    }

    public void testOrder_NoHold() throws SQLException {
        this.setAutoCommit(false);
        Statement stUtil = this.createStatement();
        stUtil.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        stUtil.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.language.bulkFetchDefault', '1')");
        Statement st = this.createStatement(1004, 1007, 2);
        st.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ResultSet test1 = st.executeQuery("select * from foo order by a");
        stUtil.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.language.bulkFetchDefault', '16')");
        for (int i = 0; i < 10; ++i) {
            HoldCursorExternalSortJDBC30Test.assertTrue((boolean)test1.next());
            HoldCursorExternalSortJDBC30Test.assertEquals((int)(i + 1), (int)test1.getInt("a"));
            HoldCursorExternalSortJDBC30Test.assertEquals((String)Formatters.padString("" + (i + 1), 2000), (String)test1.getString("data"));
        }
        HoldCursorExternalSortJDBC30Test.assertFalse((boolean)test1.next());
        test1.close();
        this.commit();
        RuntimeStatisticsParser parser = SQLUtilities.getRuntimeStatisticsParser(st);
        HoldCursorExternalSortJDBC30Test.assertTrue((boolean)parser.usedExternalSort());
        st.close();
        stUtil.close();
    }

    public void testOrderWthMultipleLevel() throws SQLException {
        String data;
        int i;
        this.setAutoCommit(false);
        Statement stUtil = this.createStatement();
        stUtil.addBatch("insert into bar select a + 100, data from bar");
        stUtil.addBatch("insert into bar select a + 10,  data from bar");
        stUtil.addBatch("insert into bar select a + 200, data from bar");
        stUtil.addBatch("insert into bar select a + 200, data from bar");
        stUtil.executeBatch();
        stUtil.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.language.bulkFetchDefault', '1')");
        Statement st = this.createStatement(1004, 1007, 1);
        st.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ResultSet test1 = st.executeQuery("select * from bar order by a");
        stUtil.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.language.bulkFetchDefault', '16')");
        boolean[] doCommitAfter = new boolean[]{true, false, false, false, true, false, false, false, true, false, true, false, false, false, true, false, false, false, true, false};
        for (i = 0; i < 20; ++i) {
            HoldCursorExternalSortJDBC30Test.assertTrue((boolean)test1.next());
            data = ((i + 1) % 10 == 0 ? 10 : (i + 1) % 10) + "";
            HoldCursorExternalSortJDBC30Test.assertEquals((int)(i + 1), (int)test1.getInt("a"));
            HoldCursorExternalSortJDBC30Test.assertEquals((String)Formatters.padString(data, 2000), (String)test1.getString("data"));
            if (!doCommitAfter[i % 20]) continue;
            this.commit();
        }
        for (i = 100; i < 120; ++i) {
            HoldCursorExternalSortJDBC30Test.assertTrue((boolean)test1.next());
            data = ((i + 1) % 10 == 0 ? 10 : (i + 1) % 10) + "";
            HoldCursorExternalSortJDBC30Test.assertEquals((int)(i + 1), (int)test1.getInt("a"));
            HoldCursorExternalSortJDBC30Test.assertEquals((String)Formatters.padString(data, 2000), (String)test1.getString("data"));
            if (!doCommitAfter[i % 20]) continue;
            this.commit();
        }
        HoldCursorExternalSortJDBC30Test.assertTrue((boolean)test1.next());
        HoldCursorExternalSortJDBC30Test.assertEquals((int)201, (int)test1.getInt("a"));
        HoldCursorExternalSortJDBC30Test.assertEquals((String)Formatters.padString("1", 2000), (String)test1.getString("data"));
        this.commit();
        test1.close();
        RuntimeStatisticsParser parser = SQLUtilities.getRuntimeStatisticsParser(st);
        HoldCursorExternalSortJDBC30Test.assertTrue((boolean)parser.usedExternalSort());
        stUtil.close();
        st.close();
    }
}

