/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public abstract class EncryptionKeyTest
extends BaseJDBCTestCase {
    protected static final int CORRECT_KEY = 0;
    protected static final int WRONG_KEY = 1;
    protected static final int ODD_LENGTH_KEY = 2;
    protected static final int INVALID_CHAR_KEY = 3;
    private static final String TABLE = "encryptionkeytestdata";
    private static final int[] DATA = new int[]{9, 4, 2, 34, 6543, 3, 123, 434, 5436, -123, 0, 123};
    private final String algorithm;
    private final String keyCorrect;
    private final String keyWrong;
    private final String keyOddLength;
    private final String keyInvalidChar;
    private Connection con = null;

    public EncryptionKeyTest(String name, String algorithm, String correctKey, String wrongKey, String oddLengthKey, String invalidCharKey) {
        super(name);
        this.algorithm = algorithm;
        this.keyCorrect = correctKey;
        this.keyWrong = wrongKey;
        this.keyOddLength = oddLengthKey;
        this.keyInvalidChar = invalidCharKey;
    }

    protected void tearDown() throws Exception {
        if (this.con != null && !this.con.isClosed()) {
            this.con.rollback();
            this.con.close();
        }
        this.con = null;
        super.tearDown();
    }

    public void testConnectionSequence1() throws SQLException {
        String dbName = "encryptedDB_ConnectionSequence1";
        this.con = this.createAndPopulateDB(dbName);
        this.validateDBContents(this.con);
        this.con.close();
        this.shutdown(dbName);
        this.con = this.getConnection(dbName, 0);
        this.validateDBContents(this.con);
        this.con.close();
        this.shutdown(dbName);
        try {
            this.getConnection(dbName, 1);
            EncryptionKeyTest.fail((String)"Booting with an incorrect encryption key should fail.");
        }
        catch (SQLException sqle) {
            EncryptionKeyTest.assertSQLState("XJ040", sqle);
            EncryptionKeyTest.assertSQLState("XBCXK", this.getLastSQLException(sqle));
        }
        this.con = this.getConnection(dbName, 0);
        this.validateDBContents(this.con);
        this.con.close();
        this.shutdown(dbName);
    }

    public void testConnectionSequence2() throws SQLException {
        String dbName;
        block4: {
            dbName = "encryptedDB_ConnectionSequence2";
            this.con = this.createAndPopulateDB(dbName);
            this.validateDBContents(this.con);
            this.con.close();
            this.shutdown(dbName);
            try {
                this.con = this.getConnection(dbName, 2);
                EncryptionKeyTest.fail((String)"Connected with an odd length key.");
            }
            catch (SQLException sqle) {
                EncryptionKeyTest.assertSQLState("XJ040", sqle);
                SQLException lastSQLE = this.getLastSQLException(sqle);
                String sqlState = lastSQLE.getSQLState();
                if (sqlState.equals("XBCX0") || sqlState.equals("XBCXM")) break block4;
                throw lastSQLE;
            }
        }
        this.confirmNonBootedDB(dbName);
        try {
            this.getConnection(dbName, 1);
            EncryptionKeyTest.fail((String)"Booting with an incorrect encryption key should fail.");
        }
        catch (SQLException sqle) {
            EncryptionKeyTest.assertSQLState("XJ040", sqle);
            EncryptionKeyTest.assertSQLState("XBCXK", this.getLastSQLException(sqle));
        }
        this.con = this.getConnection(dbName, 0);
        this.validateDBContents(this.con);
        this.con.close();
        this.shutdown(dbName);
    }

    public void testBackupEncryptedDatabase() throws SQLException {
        String dbName = "encryptionKeyDBToBackup";
        this.con = this.createAndPopulateDB(dbName);
        this.validateDBContents(this.con);
        CallableStatement cs = this.con.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        cs.setString(1, new File("extinout", "backups").getPath());
        cs.execute();
        cs.close();
        this.con.close();
        this.shutdown(dbName);
        this.con = this.getConnection(dbName, 0);
        this.validateDBContents(this.con);
        this.con.close();
        this.shutdown(dbName);
    }

    public void testCreateDbFromBackup() throws SQLException {
        String dbNameRestored;
        String backupDbLocation;
        block6: {
            String dbName = "encryptionKeyDBToCreateFrom";
            backupDbLocation = SupportFilesSetup.getReadWrite(new File("backups", "encryptionKeyDBToCreateFrom").getPath()).getPath();
            this.con = this.createAndPopulateDB("encryptionKeyDBToCreateFrom");
            this.validateDBContents(this.con);
            CallableStatement cs = this.con.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
            cs.setString(1, new File("extinout", "backups").getPath());
            cs.execute();
            cs.close();
            this.con.close();
            this.shutdown("encryptionKeyDBToCreateFrom");
            dbNameRestored = "encryptionKeyDBToCreateFromRestored";
            this.con = this.getConnection(dbNameRestored, 0, "createFrom=" + backupDbLocation);
            this.validateDBContents(this.con);
            this.con.close();
            this.shutdown(dbNameRestored, "restored");
            dbNameRestored = "encryptionKeyDBToCreateFromRestoreAttemptedWrongKey";
            try {
                this.con = this.getConnection(dbNameRestored, 1, "createFrom=" + backupDbLocation);
                EncryptionKeyTest.fail((String)"Created database from encrypted backup with wrong key.");
            }
            catch (SQLException sqle) {
                EncryptionKeyTest.assertSQLState("XJ040", sqle);
                EncryptionKeyTest.assertSQLState("XBCXK", this.getLastSQLException(sqle));
            }
            EncryptionKeyTest.assertTrue((boolean)this.con.isClosed());
            dbNameRestored = "encryptionKeyDBToCreateFromRestoreAttemptedInvalidKey";
            try {
                this.con = this.getConnection(dbNameRestored, 3, "createFrom=" + backupDbLocation);
                EncryptionKeyTest.fail((String)"Created database from encrypted backup with an invalid key.");
            }
            catch (SQLException sqle) {
                EncryptionKeyTest.assertSQLState("XJ040", sqle);
                EncryptionKeyTest.assertSQLState("XBCXN", this.getLastSQLException(sqle));
            }
            EncryptionKeyTest.assertTrue((boolean)this.con.isClosed());
            dbNameRestored = "encryptionKeyDBToCreateFromRestoreAttemptedOddLengthKey";
            try {
                this.con = this.getConnection(dbNameRestored, 2, "createFrom=" + backupDbLocation);
                EncryptionKeyTest.fail((String)"Created db from encrypted backup with an odd length key.");
            }
            catch (SQLException sqle) {
                EncryptionKeyTest.assertSQLState("XJ040", sqle);
                SQLException lastSQLE = this.getLastSQLException(sqle);
                String sqlState = lastSQLE.getSQLState();
                if (sqlState.equals("XBCX0") || sqlState.equals("XBCXM")) break block6;
                throw lastSQLE;
            }
        }
        EncryptionKeyTest.assertTrue((boolean)this.con.isClosed());
        dbNameRestored = "encryptionKeyDBToCreateFromRestoredOnceMore";
        this.con = this.getConnection(dbNameRestored, 0, "createFrom=" + backupDbLocation);
        this.validateDBContents(this.con);
        this.con.close();
        this.shutdown(dbNameRestored, "restored");
    }

    public void testRestoreFrom() throws SQLException {
        String dbName = "encryptionKeyDBToRestoreFrom";
        String dbNameRestored = dbName + "Restored";
        this.createBackupRestore(dbName, dbNameRestored);
        this.shutdown(dbNameRestored, "restored");
    }

    public void testInvalidRestoreFrom() throws SQLException {
        String dbName = "encryptionKeyDBToInvalidRestoreFrom";
        String dbNameRestored = dbName + "Restored";
        this.createBackupRestore(dbName, dbNameRestored);
        this.shutdown(dbNameRestored, "restored");
        this.confirmNonBootedDB("restored/" + dbNameRestored);
        this.con = this.getConnection("restored/" + dbNameRestored, 0);
        this.validateDBContents(this.con);
        this.con.close();
        this.shutdown(dbNameRestored, "restored");
        try {
            this.con = this.getConnection(dbNameRestored, 3, ";restoreFrom=" + this.obtainDbName(dbName, null));
            EncryptionKeyTest.fail((String)"Restored database with an invalid key.");
        }
        catch (SQLException sqle) {
            EncryptionKeyTest.assertSQLState("XBCXN", sqle);
        }
        try {
            this.con = this.getConnection("restored/" + dbNameRestored, 0, "");
            EncryptionKeyTest.fail((String)"Expected connection to fail due to non-existent database.");
        }
        catch (SQLException sqle) {
            EncryptionKeyTest.assertSQLState("XJ004", sqle);
        }
    }

    public void testCreateWithOddEncryptionKeyLength() throws SQLException {
        block2: {
            try {
                this.getConnection("encryptedDB_oddKeyLength", 2);
                EncryptionKeyTest.fail((String)"Database creation with odd key length should fail.");
            }
            catch (SQLException sqle) {
                EncryptionKeyTest.assertSQLState("XJ041", sqle);
                SQLException lastSQLE = this.getLastSQLException(sqle);
                String sqlState = lastSQLE.getSQLState();
                if (sqlState.equals("XBCXM") || sqlState.equals("XJ001")) break block2;
                throw lastSQLE;
            }
        }
    }

    public void testCreateWithInvalidEncryptionKey() {
        try {
            this.getConnection("encryptedDB_invkeyChar", 3);
            EncryptionKeyTest.fail((String)"Database creation with invalid key should fail.");
        }
        catch (SQLException sqle) {
            EncryptionKeyTest.assertSQLState("XJ041", sqle);
            EncryptionKeyTest.assertSQLState("XBCXN", this.getLastSQLException(sqle));
        }
    }

    private String obtainDbName(String dbName, String subdirectory) {
        File tmp = new File(dbName);
        if (subdirectory != null) {
            tmp = new File(subdirectory, dbName);
        }
        final File db = tmp;
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new File("extinout", db.getPath()).getAbsolutePath();
            }
        });
    }

    private void createBackupRestore(String sourceDb, String targetDb) throws SQLException {
        this.con = this.createAndPopulateDB(sourceDb);
        this.validateDBContents(this.con);
        CallableStatement cs = this.con.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        cs.setString(1, new File("extinout", "backups").getPath());
        cs.execute();
        this.con.close();
        this.shutdown(sourceDb);
        this.confirmNonBootedDB(sourceDb);
        this.con = this.getConnection(targetDb, 0, ";restoreFrom=" + this.obtainDbName(sourceDb, "backups"));
        this.validateDBContents(this.con);
        this.con.close();
    }

    private void confirmNonBootedDB(String dbName) {
        DataSource ds = JDBCDataSource.getDataSource(this.obtainDbName(dbName, null));
        try {
            ds.getConnection();
        }
        catch (SQLException sqle) {
            EncryptionKeyTest.assertSQLState("Database booted? <state:" + sqle.getSQLState() + ", msg:" + sqle.getMessage() + ">", "XJ040", sqle);
        }
    }

    private Connection getConnection(String dbName, int keyMode) throws SQLException {
        return this.getConnection(dbName, keyMode, null);
    }

    private Connection getConnection(String dbName, int keyMode, String recoveryAttribute) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(this.obtainDbName(dbName, recoveryAttribute == null ? null : "restored"));
        StringBuffer str = new StringBuffer(75);
        if (recoveryAttribute == null) {
            JDBCDataSource.setBeanProperty(ds, "CreateDatabase", "create");
            str.append("dataEncryption=true;");
        } else {
            str.append(recoveryAttribute);
            str.append(";");
        }
        str.append("encryptionAlgorithm=");
        str.append(this.algorithm);
        str.append(";");
        str.append("encryptionKey=");
        switch (keyMode) {
            case 0: {
                str.append(this.keyCorrect);
                break;
            }
            case 1: {
                str.append(this.keyWrong);
                break;
            }
            case 2: {
                str.append(this.keyOddLength);
                break;
            }
            case 3: {
                str.append(this.keyInvalidChar);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid key mode specified: " + keyMode);
            }
        }
        str.append(";");
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", str.toString());
        return ds.getConnection();
    }

    protected void shutdown(String databaseName) throws SQLException {
        this.shutdown(databaseName, null);
    }

    protected void shutdown(String databaseName, String dir) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(this.obtainDbName(databaseName, dir));
        JDBCDataSource.shutdownDatabase(ds);
    }

    protected Connection createAndPopulateDB(String dbName) throws SQLException {
        Connection newCon = this.getConnection(dbName, 0);
        SQLWarning warning = newCon.getWarnings();
        if (warning != null && "01J01".equals(warning.getSQLState())) {
            EncryptionKeyTest.fail((String)("Refusing to continue, database already exists <" + warning.getMessage() + ">"));
        }
        Statement stmt = newCon.createStatement();
        stmt.executeUpdate("CREATE TABLE encryptionkeytestdata (id int NOT NULL, val int NOT NULL, PRIMARY KEY(id))");
        stmt.close();
        PreparedStatement ps = newCon.prepareStatement("INSERT INTO encryptionkeytestdata (id, val) VALUES (?,?)");
        for (int i = 0; i < DATA.length; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, DATA[i]);
            ps.executeUpdate();
        }
        ps.close();
        return newCon;
    }

    protected void validateDBContents(Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT id, val FROM encryptionkeytestdata ORDER BY id");
        while (rs.next()) {
            int id = rs.getInt(1);
            int val = rs.getInt(2);
            if (id >= DATA.length) {
                EncryptionKeyTest.fail((String)("Id in database out of bounds for data model; " + id + " >= " + DATA.length));
            }
            if (val == DATA[id]) continue;
            EncryptionKeyTest.fail((String)("Mismatch between db and model for id " + id + ";" + val + " != " + DATA[id]));
        }
        rs.close();
        stmt.close();
    }
}

