/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.jdbc.ClientDataSource;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SimplePerfTest_Verify
extends BaseJDBCTestCase {
    private static String dbPath = "UNDEFINED!";
    private static String masterHostName = "UNDEFINED!";
    private static int masterPortNo = -1;
    private static int tuplesToInsert = -1;

    public SimplePerfTest_Verify(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() throws Exception {
        masterHostName = System.getProperty("test.serverHost", "localhost");
        masterPortNo = Integer.parseInt(System.getProperty("test.serverPort", "1527"));
        dbPath = System.getProperty("test.dbPath", "wombat");
        tuplesToInsert = Integer.parseInt(System.getProperty("test.inserts", "0"));
        TestSuite suite = new TestSuite("SimplePerfTest_Verify");
        suite.addTest(SimplePerfTest_Verify.suite(masterHostName, masterPortNo, dbPath));
        return suite;
    }

    public static Test suite(String serverHost, int serverPort, String dbPath) {
        Test t = TestConfiguration.existingServerSuite(SimplePerfTest_Verify.class, false, serverHost, serverPort, dbPath);
        return SecurityManagerSetup.noSecurityManager(t);
    }

    public void testVerify() throws SQLException, IOException, InterruptedException {
        this.verifyTestInserts();
    }

    private void verifyTestInserts() throws SQLException, IOException, InterruptedException {
        Connection conn = this.clientConnection(masterHostName, masterPortNo, dbPath);
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("select count(*) from t");
        rs.next();
        int count = rs.getInt(1);
        SimplePerfTest_Verify.assertEquals((int)count, (int)tuplesToInsert);
    }

    private Connection clientConnection(String hostName, int portNo, String dbPath) throws SQLException {
        ClientDataSource ds = new ClientDataSource();
        ds.setDatabaseName(dbPath);
        ds.setServerName(hostName);
        ds.setPortNumber(portNo);
        return ds.getConnection();
    }
}

