/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.jdbc.ClientDataSource;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SimplePerfTest
extends BaseJDBCTestCase {
    private static String dbPath = "UNDEFINED!";
    private static String masterHostName = "UNDEFINED!";
    private static int masterPortNo = -1;
    private static int tuplesToInsert = 0;
    private static int commitFreq = 0;

    public SimplePerfTest(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() throws Exception {
        masterHostName = System.getProperty("test.serverHost", "localhost");
        masterPortNo = Integer.parseInt(System.getProperty("test.serverPort", "1527"));
        dbPath = System.getProperty("test.dbPath", "wombat");
        TestSuite suite = new TestSuite("SimplePerfTest");
        tuplesToInsert = Integer.parseInt(System.getProperty("test.inserts", "1000"));
        commitFreq = Integer.parseInt(System.getProperty("test.commitFreq", "0"));
        suite.addTest(SimplePerfTest.suite(masterHostName, masterPortNo, dbPath));
        return suite;
    }

    public static Test suite(String serverHost, int serverPort, String dbPath) {
        Test t = TestConfiguration.existingServerSuite(SimplePerfTest.class, false, serverHost, serverPort, dbPath);
        return SecurityManagerSetup.noSecurityManager(t);
    }

    public void testInserts() throws SQLException, IOException, InterruptedException {
        String vc = "";
        for (int i = 0; i < 20000; ++i) {
            vc = vc + "a";
        }
        Connection conn = this.clientConnection(masterHostName, masterPortNo, dbPath);
        Statement s = conn.createStatement();
        try {
            s.executeUpdate("drop table t");
        }
        catch (SQLException ignore) {
            System.out.println("'drop table t' caused: " + ignore.getMessage());
        }
        s.executeUpdate("create table t (i integer primary key, vc varchar(20100))");
        PreparedStatement pSt = conn.prepareStatement("insert into t values (?,?)");
        conn.setAutoCommit(commitFreq == 0);
        for (int i = 0; i < tuplesToInsert; ++i) {
            pSt.setInt(1, i);
            pSt.setString(2, vc + i);
            try {
                pSt.execute();
            }
            catch (Exception e) {
                System.out.println("Exception when inserting: " + e.getMessage());
                return;
            }
            if (commitFreq == 0 || i % commitFreq != 0) continue;
            System.out.println("i: " + i);
            conn.commit();
        }
        conn.commit();
        ResultSet rs = s.executeQuery("select count(*) from t");
        rs.next();
        int count = rs.getInt(1);
        System.out.println("count: " + count);
    }

    public void verifyTestInserts() throws SQLException, IOException, InterruptedException {
        Connection conn = this.clientConnection(masterHostName, masterPortNo, dbPath);
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("select count(*) from t");
        rs.next();
        int count = rs.getInt(1);
    }

    private Connection clientConnection(String hostName, int portNo, String dbPath) throws SQLException {
        ClientDataSource ds = new ClientDataSource();
        ds.setDatabaseName(dbPath);
        ds.setServerName(hostName);
        ds.setPortNumber(portNo);
        return ds.getConnection();
    }
}

