/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Local_StateTest_part1
extends ReplicationRun {
    static final String CANNOT_CONNECT_TO_DB_IN_SLAVE_MODE = "08004";
    static final String LOGIN_FAILED = "08004";
    static final String REPLICATION_DB_NOT_BOOTED = "XRE11";
    static final String REPLICATION_MASTER_ALREADY_BOOTED = "XRE22";
    static final String REPLICATION_NOT_IN_MASTER_MODE = "XRE07";
    static final String REPLICATION_SLAVE_STARTED_OK = "XRE08";

    public ReplicationRun_Local_StateTest_part1(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ReplicationRun_Local_StateTest_part1 Suite");
        suite.addTestSuite(ReplicationRun_Local_StateTest_part1.class);
        return SecurityManagerSetup.noSecurityManager((Test)suite);
    }

    public void testReplication_Local_StateTest_part1() throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        this._testPreStartedMasterServer();
        this.initMaster(masterServerHost, replicatedDb);
        this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this._testPreStartedSlaveServer();
        this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this._testPreInitSlave();
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this._testPreStartedSlave();
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this._testPreStartedMaster();
        replicationTest = "org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationTestRun";
        this.util.DEBUG("replicationTest: " + replicationTest);
        replicationVerify = "org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationTestRun_Verify";
        this.util.DEBUG("replicationVerify: " + replicationVerify);
        this.runTest(replicationTest, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        this.verifySlave();
        this.verifyMaster();
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    private void _testPreStartedMasterServer() {
        Connection conn = null;
        String db = masterDatabasePath + FS + ReplicationRun.masterDbSubPath + FS + replicatedDb;
        String connectionURL = "jdbc:derby://" + masterServerHost + ":" + masterServerPort + "/" + db + ";startMaster=true" + ";slavehost=" + slaveServerHost + ";slaveport=" + slaveServerPort;
        this.util.DEBUG("testPreStartedMasterServer: " + connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
        }
        catch (SQLException se) {
            int ec = se.getErrorCode();
            String ss = se.getSQLState();
            String msg = ec + " " + ss + " " + se.getMessage();
            this.util.DEBUG("testStartMasterConnect_Illegal: " + msg);
            ReplicationRun_Local_StateTest_part1.assertTrue((String)("Unexpected SQLException: " + msg), (boolean)"08001".equals(ss));
            this.util.DEBUG("As expected.");
            return;
        }
        ReplicationRun_Local_StateTest_part1.assertTrue((String)("Expected SQLException: '08001 " + db + "'"), (boolean)false);
    }

    private void _testPreStartedSlaveServer() {
        Connection conn = null;
        String db = slaveDatabasePath + FS + ReplicationRun.slaveDbSubPath + FS + replicatedDb;
        String connectionURL = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + db + ";startSlave=true" + ";slavehost=" + slaveServerHost + ";slaveport=" + slaveServerPort;
        this.util.DEBUG("testPreStartedSlaveServer: " + connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
        }
        catch (SQLException se) {
            int ec = se.getErrorCode();
            String ss = se.getSQLState();
            String msg = ec + " " + ss + " " + se.getMessage();
            this.util.DEBUG("testStartSlaveConnect_Illegal: " + msg);
            ReplicationRun_Local_StateTest_part1.assertTrue((String)("Unexpected SQLException: " + msg), (boolean)"08001".equals(ss));
            this.util.DEBUG("As expected.");
            return;
        }
        ReplicationRun_Local_StateTest_part1.assertTrue((String)("Expected SQLException: '08001 " + db + "'"), (boolean)false);
    }

    private void _testPreInitSlave() {
        String msg;
        String ss;
        int ec;
        String db = null;
        String connectionURL = null;
        Connection conn = null;
        db = masterDatabasePath + FS + ReplicationRun.masterDbSubPath + FS + replicatedDb;
        connectionURL = "jdbc:derby://" + masterServerHost + ":" + masterServerPort + "/" + db + ";stopMaster=true";
        this.util.DEBUG("1. testPreInitSlave:" + connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
            this.util.DEBUG("Unexpectedly connected: " + connectionURL);
            ReplicationRun_Local_StateTest_part1.assertTrue((String)("Unexpectedly connected: " + connectionURL), (boolean)false);
        }
        catch (SQLException se) {
            ec = se.getErrorCode();
            ss = se.getSQLState();
            msg = ec + " " + ss + " " + se.getMessage();
            BaseJDBCTestCase.assertSQLState("stopMaster on master failed: " + msg, REPLICATION_NOT_IN_MASTER_MODE, se);
            this.util.DEBUG("stopMaster on master failed as expected: " + connectionURL + " " + msg);
        }
        db = slaveDatabasePath + FS + ReplicationRun.slaveDbSubPath + FS + replicatedDb;
        connectionURL = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + db + ";stopSlave=true";
        this.util.DEBUG("2. testPreInitSlave: " + connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
            this.util.DEBUG("Unexpectedly connected: " + connectionURL);
            ReplicationRun_Local_StateTest_part1.assertTrue((String)("Unexpectedly connected: " + connectionURL), (boolean)false);
        }
        catch (SQLException se) {
            ec = se.getErrorCode();
            ss = se.getSQLState();
            msg = ec + " " + ss + " " + se.getMessage();
            BaseJDBCTestCase.assertSQLState("stopSlave on slave failed: " + msg, REPLICATION_DB_NOT_BOOTED, se);
            this.util.DEBUG("stopSlave on slave failed as expected: " + connectionURL + " " + msg);
        }
    }

    private void _testPreStartedSlave() {
        Object conn = null;
        String db = slaveDatabasePath + FS + ReplicationRun.slaveDbSubPath + FS + replicatedDb;
        String connectionURL = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + db + ";startSlave=true" + ";slaveHost=" + slaveServerHost + ";slavePort=" + slaveReplPort;
        this.util.DEBUG("testPreStartedSlave: Test moved to TestPostStartedMasterAndSlave! " + connectionURL);
    }

    private void _testPreStartedMaster() throws Exception {
        String msg;
        String ss;
        int ec;
        Connection conn = null;
        String db = masterDatabasePath + FS + ReplicationRun.masterDbSubPath + FS + replicatedDb;
        String connectionURL = "jdbc:derby://" + masterServerHost + ":" + masterServerPort + "/" + db + ";startMaster=true" + ";slaveHost=" + slaveServerHost + ";slavePort=" + slaveReplPort;
        this.util.DEBUG("_testPreStartedMaster: " + connectionURL);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        this.util.DEBUG("2. startMaster attempt should fail on: " + connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
            this.util.DEBUG("2. Unexpectedly connected as: " + connectionURL);
            ReplicationRun_Local_StateTest_part1.assertTrue((String)("2. Unexpectedly connected as: " + connectionURL), (boolean)false);
        }
        catch (SQLException se) {
            ec = se.getErrorCode();
            ss = se.getSQLState();
            msg = ec + " " + ss + " " + se.getMessage();
            this.util.DEBUG("2. startMaster No connection as expected: " + msg);
            BaseJDBCTestCase.assertSQLState("2. Unexpected SQLException: " + msg, REPLICATION_MASTER_ALREADY_BOOTED, se);
        }
        this.util.DEBUG("startSlave attempt should fail on: " + connectionURL);
        db = slaveDatabasePath + FS + ReplicationRun.slaveDbSubPath + FS + replicatedDb;
        connectionURL = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + db + ";startSlave=true" + ";slaveHost=" + slaveServerHost + ";slavePort=" + slaveReplPort;
        this.util.DEBUG(connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
            this.util.DEBUG("3. startSlave Unexpectedly connected as: " + connectionURL);
            ReplicationRun_Local_StateTest_part1.assertTrue((String)("3. startSlave Unexpectedly connected as: " + connectionURL), (boolean)false);
        }
        catch (SQLException se) {
            ec = se.getErrorCode();
            ss = se.getSQLState();
            msg = ec + " " + ss + " " + se.getMessage();
            this.util.DEBUG("3. startSlave No connection as expected: " + msg);
            BaseJDBCTestCase.assertSQLState("3. Unexpected SQLException: " + msg, "08004", se);
        }
    }
}

