/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Full
extends ReplicationRun {
    public ReplicationRun_Full(String testcaseName) {
        super(testcaseName);
        LF = System.getProperties().getProperty("line.separator");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Replication_Full Suite");
        suite.addTestSuite(ReplicationRun_Full.class);
        return SecurityManagerSetup.noSecurityManager((Test)suite);
    }

    public void testReplication() throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        if (runUnReplicated) {
            this.util.DEBUG("**** BEGIN Running test without replication.");
            this.initMaster(masterServerHost, replicatedDb);
            this.startServer(masterJvmVersion, derbyVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
            this.runTest(replicationTest, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
            this.stopServer(masterJvmVersion, derbyMasterVersion, masterServerHost, masterServerPort);
            this.util.DEBUG("**** END Running test without replication.");
        }
        if (this.state.testPreStartedMasterServer()) {
            return;
        }
        this.initMaster(masterServerHost, replicatedDb);
        this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this.startOptionalLoad(masterPreRepl, masterDbSubPath, masterServerHost, masterServerPort);
        if (this.state.testPreStartedSlaveServer()) {
            return;
        }
        this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.xFindServerPID(slaveServerHost, slaveServerPort);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this.startOptionalLoad(masterPostRepl, masterDbSubPath, masterServerHost, masterServerPort);
        this.startOptionalLoad(slavePreSlave, slaveDbSubPath, slaveServerHost, slaveServerPort);
        if (this.state.testPreInitSlave()) {
            return;
        }
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        if (this.state.testPreStartedSlave()) {
            return;
        }
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        if (this.state.testPreStartedMaster()) {
            return;
        }
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        this.startOptionalLoad(masterPostSlave, masterDbSubPath, masterServerHost, masterServerPort);
        this.startOptionalLoad(slavePostSlave, slaveDbSubPath, slaveServerHost, slaveServerPort);
        if (this.state.testPostStartedMasterAndSlave()) {
            return;
        }
        this.runTest(replicationTest, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
        if (this.state.testPreStoppedMaster()) {
            return;
        }
        if (this.state.testPreStoppedMasterServer()) {
            return;
        }
        if (this.state.testPreStoppedSlave()) {
            return;
        }
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        int slavePid = this.xFindServerPID(slaveServerHost, slaveServerPort);
        if (slavePid == -1) {
            this.util.DEBUG("WARNING: slave server not available. Starting.");
            this.startServer(jvmVersion, derbyVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        } else {
            this.util.DEBUG("*********************** DERBY-3205/svn 630806. failover does now unset replication mode on slave.");
        }
        this.verifySlave();
        int masterPid = this.xFindServerPID(masterServerHost, masterServerPort);
        if (masterPid == -1) {
            this.util.DEBUG("WARNING: master server not available. Starting.");
            this.startServer(jvmVersion, derbyVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        }
        this.verifyMaster();
        this.xFindServerPID(slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        if (this.state.testPostStoppedSlaveServer()) {
            return;
        }
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
        masterPid = this.xFindServerPID(masterServerHost, masterServerPort);
        if (masterPid != -1) {
            this.util.DEBUG("*********************** DERBY-3394. master does not accept shutdown after failover.");
            this.killMaster(masterServerHost, masterServerPort);
        }
    }
}

