/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class TriggerTests
extends BaseJDBCTestCase {
    final int lobsize = 51200000;
    boolean testWithLargeDataInLOB = true;
    boolean isDerby1482Fixed = true;

    public TriggerTests(String name) {
        super(name);
    }

    public static Test suite() {
        CleanDatabaseTestSetup suite = new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(TriggerTests.class));
        Properties p = new Properties();
        p.setProperty("derby.storage.pageCacheSize", "100");
        return new SystemPropertyTestSetup((Test)suite, p);
    }

    public void basicSetup() throws SQLException {
        this.dropTable("TABLE1");
        this.dropTable("TABLE2");
        this.dropTable("TABLE3");
        Statement s = this.createStatement();
        try {
            s.execute("drop trigger trigger1");
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        try {
            s.execute("drop trigger trigger2");
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        s.execute("create table table1 (id int, status smallint, bl blob(2G))");
        s.execute("create index i1 on table1(id)");
        s.execute("create table table2 (id int, updates int default 0)");
        s.execute("create index i2 on table2(id)");
        s.execute("create table table3 (id int, status smallint, score int)");
        s.execute("create index i3 on table3(id)");
        PreparedStatement ps = this.prepareStatement("insert into table1 values (?, 0, ?)");
        ps.setInt(1, 1);
        ps.setBinaryStream(2, (InputStream)new LoopingAlphabetStream(51200000L), 51200000);
        ps.executeUpdate();
        ps = this.prepareStatement("insert into table2 (id) values (?)");
        ps.setInt(1, 1);
        ps.executeUpdate();
        ps = this.prepareStatement("insert into table3 values (?, 0, ?)");
        ps.setInt(1, 1);
        ps.setInt(2, 2);
        ps.executeUpdate();
        this.commit();
    }

    public void test1InsertAfterTrigger() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create trigger trigger1 AFTER INSERT on table1 referencing new as n_row for each row insert into table2(id, updates) values (n_row.id, -1)");
        this.commit();
        this.runtest1InsertTriggerTest();
    }

    public void test1InsertAfterTriggerStoredProc() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create procedure proc_test1_InsertAfterTrigger_update_table (p1 int) parameter style java language java MODIFIES SQL DATA external name 'org.apache.derbyTesting.functionTests.tests.memory.TriggerTests.proc_test1_InsertAfterTrigger_update_table'");
        s.execute("create trigger trigger1 after INSERT on table1 referencing new as n_row for each row call proc_test1_InsertAfterTrigger_update_table(n_row.id)");
        this.commit();
        this.runtest1InsertTriggerTest();
    }

    public static void proc_test1_InsertAfterTrigger_update_table(int p1) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("insert into table2(id, updates) values (" + p1 + ",-1)");
        ps.executeUpdate();
        conn.close();
    }

    public void test1DeleteAfterTrigger() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create trigger trigger1 after DELETE on table1 referencing old as o_row for each row delete from table2 where id=o_row.id");
        this.commit();
        this.runDeleteTriggerTest();
    }

    public void test1DeleteAfterTriggerStoredProc() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create procedure proc_test1_DeleteAfterTrigger_update_table (p1 int) parameter style java language java MODIFIES SQL DATA external name 'org.apache.derbyTesting.functionTests.tests.memory.TriggerTests.proc_test1_DeleteAfterTrigger_update_table'");
        s.execute("create trigger trigger1 after DELETE on table1 referencing old as o_row for each row call proc_test1_DeleteAfterTrigger_update_table(o_row.id)");
        this.commit();
        this.runDeleteTriggerTest();
    }

    public static void proc_test1_DeleteAfterTrigger_update_table(int p1) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("delete from table1 where id=" + p1);
        ps.executeUpdate();
        conn.close();
    }

    public void test1UpdateAfterTrigger() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create trigger trigger1 after update of status on table1 referencing new as n_row for each row update table2 set updates = updates + 1 where table2.id = n_row.id");
        this.commit();
        this.runtest1UpdateTrigger();
    }

    public void test1UpdateAfterTriggerStoredProc() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create procedure proc_test1_UpdateAfterTrigger_update_table (p1 int) parameter style java language java MODIFIES SQL DATA external name 'org.apache.derbyTesting.functionTests.tests.memory.TriggerTests.proc_test1_UpdateAfterTrigger_update_table'");
        s.execute("create trigger trigger1 after update of status on table1 REFERENCING NEW as n_row for each row call proc_test1_UpdateAfterTrigger_update_table(n_row.id)");
        this.commit();
        this.runtest1UpdateTrigger();
    }

    public static void proc_test1_UpdateAfterTrigger_update_table(int p1) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("update table2 set updates = updates + 1 where table2.id = " + p1);
        ps.executeUpdate();
        conn.close();
    }

    public void test1InsertBeforeTrigger() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create trigger trigger1 no cascade before INSERT on table1 referencing new as n_row for each row select updates from table2 where table2.id = n_row.id");
        this.commit();
        this.runtest1InsertTriggerTest();
    }

    public void test1InsertBeforeTriggerStoredProc() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create procedure proc_test1_InsertBeforeTrigger_select_table (p1 int) parameter style java language java READS SQL DATA external name 'org.apache.derbyTesting.functionTests.tests.memory.TriggerTests.proc_test1_InsertBeforeTrigger_select_table'");
        s.execute("create trigger trigger1 no cascade before INSERT on table1 referencing new as n_row for each row call proc_test1_InsertBeforeTrigger_select_table(n_row.id)");
        this.commit();
        this.runtest1InsertTriggerTest();
    }

    public static void proc_test1_InsertBeforeTrigger_select_table(int p1) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("select updates from table2 where table2.id = " + p1);
        ps.executeQuery();
        conn.close();
    }

    public void test1DeleteBeforeTrigger() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create trigger trigger1 no cascade before DELETE on table1 referencing old as o_row for each row select updates from table2 where table2.id = o_row.id");
        this.commit();
        this.runDeleteTriggerTest();
    }

    public void test1DeleteBeforeTriggerStoredProc() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create procedure proc_test1_DeleteBeforeTrigger_select_table (p1 int) parameter style java language java READS SQL DATA external name 'org.apache.derbyTesting.functionTests.tests.memory.TriggerTests.proc_test1_DeleteBeforeTrigger_select_table'");
        s.execute("create trigger trigger1 no cascade before DELETE on table1 referencing old as o_row for each row call proc_test1_DeleteBeforeTrigger_select_table(o_row.id)");
        this.commit();
        this.runDeleteTriggerTest();
    }

    public static void proc_test1_DeleteBeforeTrigger_select_table(int p1) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("select updates from table2 where table2.id = " + p1);
        ps.executeQuery();
        conn.close();
    }

    public void test1UpdateBeforeTrigger() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create trigger trigger1 no cascade before update of status on table1 referencing new as n_row for each row select updates from table2 where table2.id = n_row.id");
        this.commit();
        this.runtest1UpdateTrigger();
    }

    public void test1UpdateBeforeTriggerStoredProc() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create procedure proc_test1_UpdateBeforeTrigger_select_table (p1 int) parameter style java language java READS SQL DATA external name 'org.apache.derbyTesting.functionTests.tests.memory.TriggerTests.proc_test1_UpdateBeforeTrigger_select_table'");
        s.execute("create trigger trigger1 no cascade before update of status on table1 REFERENCING NEW as n_row for each row call proc_test1_UpdateBeforeTrigger_select_table(n_row.id)");
        this.commit();
        this.runtest1UpdateTrigger();
    }

    public static void proc_test1_UpdateBeforeTrigger_select_table(int p1) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("select updates from table2 where table2.id = " + p1);
        ps.executeQuery();
        conn.close();
    }

    public void test2InsertAfterTriggerAccessLOB() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("drop table table2");
        s.execute("create table table2 (id int, bl_table2 blob(2G))");
        PreparedStatement ps = this.prepareStatement("insert into table2 (id) values (?)");
        ps.setInt(1, 1);
        ps.executeUpdate();
        s.execute("create trigger trigger1 after INSERT on table1 referencing new as n_row for each row insert into table2(id, bl_table2) values (n_row.id, n_row.bl)");
        this.commit();
        this.runtest2InsertTriggerTest();
    }

    public void test2DeleteAfterTriggerAccessLOB() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("drop table table2");
        s.execute("create table table2 (id int, bl_table2 blob(2G))");
        PreparedStatement ps = this.prepareStatement("insert into table2 (id) values (?)");
        ps.setInt(1, 1);
        ps.executeUpdate();
        this.commit();
        s.execute("create trigger trigger1 after DELETE on table1 referencing old as o_row for each row delete from table2 where id = o_row.id and o_row.bl is not null");
        this.commit();
        this.runDeleteTriggerTest();
    }

    public void test2UpdateAfterTriggerAccessLOB() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("drop table table2");
        s.execute("create table table2 (id int, bl_table2 blob(2G))");
        s.execute("create trigger trigger1 after update of status on table1 referencing new as n_row for each row update table2 set bl_table2 = n_row.bl where table2.id = n_row.id");
        PreparedStatement ps = this.prepareStatement("insert into table2 (id) values (?)");
        ps.setInt(1, 1);
        ps.executeUpdate();
        this.commit();
        this.runtest1UpdateTrigger();
    }

    public void test2InsertAfterTriggerUpdatedLOB() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("drop table table1");
        s.execute("create table table1 (id int, status smallint, bl blob(2G), bl_null blob(2G))");
        PreparedStatement ps = this.prepareStatement("insert into table1 values (?, 0, ?, null)");
        ps.setInt(1, 1);
        ps.setBinaryStream(2, (InputStream)new LoopingAlphabetStream(51200000L), 51200000);
        ps.executeUpdate();
        s.execute("create trigger trigger1 after INSERT on table1 referencing new as n_row for each row update table1 set bl_null=n_row.bl where bl_null is null");
        this.commit();
        this.runtest2InsertTriggerTest();
    }

    public void test2UpdateAfterTriggerUpdatedLOB() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("drop table table1");
        s.execute("create table table1 (id int, status smallint, bl blob(2G), bl_null blob(2G))");
        s.execute("create trigger trigger1 after update of status on table1 referencing new as n_row for each row update table1 set bl_null=n_row.bl where bl_null is null");
        PreparedStatement ps = this.prepareStatement("insert into table1 values (?, 0, ?, null)");
        ps.setInt(1, 1);
        ps.setBinaryStream(2, (InputStream)new LoopingAlphabetStream(51200000L), 51200000);
        ps.executeUpdate();
        this.commit();
        this.runtest1UpdateTrigger();
    }

    public void test2InsertBeforeTriggerAccessLOB() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("drop table table2");
        s.execute("create table table2 (id int, bl_table2 blob(2G))");
        s.execute("create trigger trigger1 no cascade before INSERT on table1 referencing new as n_row for each row values(n_row.bl)");
        PreparedStatement ps = this.prepareStatement("insert into table2 (id) values (?)");
        ps.setInt(1, 1);
        ps.executeUpdate();
        this.commit();
        this.runtest2InsertTriggerTest();
    }

    public void test2DeleteBeforeTriggerAccessLOB() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("drop table table2");
        s.execute("create table table2 (id int, bl_table2 blob(2G))");
        s.execute("create trigger trigger1 no cascade before DELETE on table1 referencing old as o_row for each row values(o_row.bl)");
        PreparedStatement ps = this.prepareStatement("insert into table2 (id) values (?)");
        ps.setInt(1, 1);
        ps.executeUpdate();
        this.commit();
        this.runDeleteTriggerTest();
    }

    public void test2UpdateBeforeTriggerAccessLOB() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("drop table table2");
        s.execute("create table table2 (id int, bl_table2 blob(2G))");
        s.execute("create trigger trigger1 no cascade before update of status on table1 referencing new as n_row for each row values(n_row.bl)");
        PreparedStatement ps = this.prepareStatement("insert into table2 (id) values (?)");
        ps.setInt(1, 1);
        ps.executeUpdate();
        this.commit();
        this.runtest1UpdateTrigger();
    }

    public void test3UpdateAfterTrigger() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create trigger trigger1 after update of bl on table1 referencing new as n_row for each row update table2 set updates = n_row.status where table2.id = n_row.id");
        this.commit();
        this.runtest2UpdateTrigger();
    }

    public void test3UpdateAfterTriggerStoredProc() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create procedure proc_test3_UpdateAfterTrigger_update_table (p1 int, p2 int) parameter style java language java MODIFIES SQL DATA external name 'org.apache.derbyTesting.functionTests.tests.memory.TriggerTests.proc_test3_UpdateAfterTrigger_update_table'");
        s.execute("create trigger trigger1 after update of bl on table1 REFERENCING NEW as n_row for each row call proc_test3_UpdateAfterTrigger_update_table(n_row.status, n_row.id)");
        this.commit();
        this.runtest2UpdateTrigger();
    }

    public static void proc_test3_UpdateAfterTrigger_update_table(int p1, int p2) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("update table2 set updates = " + p1 + " where table2.id = " + p2);
        ps.executeUpdate();
        conn.close();
    }

    public void test3UpdateBeforeTrigger() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create trigger trigger1 no cascade before update of bl on table1 referencing new as n_row for each row select updates from table2 where table2.id = n_row.id");
        this.commit();
        this.runtest2UpdateTrigger();
    }

    public void test3UpdateBeforeTriggerStoredProc() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create procedure proc_test3_UpdateBeforeTrigger_select_table (p1 int) parameter style java language java READS SQL DATA external name 'org.apache.derbyTesting.functionTests.tests.memory.TriggerTests.proc_test3_UpdateBeforeTrigger_select_table'");
        s.execute("create trigger trigger1 no cascade before update of bl on table1 REFERENCING NEW as n_row for each row call proc_test3_UpdateBeforeTrigger_select_table(n_row.id)");
        this.commit();
        this.runtest2UpdateTrigger();
    }

    public static void proc_test3_UpdateBeforeTrigger_select_table(int p1) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("select updates from table2 where table2.id = " + p1);
        ps.executeQuery();
        conn.close();
    }

    public void test4UpdateAfterTriggerAccessLOB() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("drop table table2");
        s.execute("create table table2 (id int, bl_table2 blob(2G))");
        s.execute("create trigger trigger1 after update of bl on table1 referencing new as n_row for each row update table2 set bl_table2 = n_row.bl where table2.id = n_row.id");
        PreparedStatement ps = this.prepareStatement("insert into table2 (id) values (?)");
        ps.setInt(1, 1);
        ps.executeUpdate();
        this.commit();
        this.runtest2UpdateTrigger();
    }

    public void test4UpdateAfterTriggerUpdatedLOB() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("drop table table1");
        s.execute("create table table1 (id int, status smallint, bl blob(2G), bl_null blob(2G))");
        s.execute("create trigger trigger1 after update of bl_null on table1 referencing new as n_row for each row update table1 set bl_null=n_row.bl where bl_null is null");
        PreparedStatement ps = this.prepareStatement("insert into table1 values (?, 0, ?, ?)");
        ps.setInt(1, 1);
        ps.setBinaryStream(2, (InputStream)new LoopingAlphabetStream(51200000L), 51200000);
        ps.setBinaryStream(3, (InputStream)new LoopingAlphabetStream(51200000L), 51200000);
        ps.executeUpdate();
        this.commit();
        this.runtest3UpdateTrigger();
    }

    public void test4UpdateBeforeTrigger() throws SQLException {
        if (!this.isDerby1482Fixed) {
            return;
        }
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("drop table table2");
        s.execute("create table table2 (id int, bl_table2 blob(2G))");
        s.execute("create trigger trigger1 no cascade before update of bl on table1 referencing new as n_row for each row values(n_row.bl)");
        PreparedStatement ps = this.prepareStatement("insert into table2 (id) values (?)");
        ps.setInt(1, 1);
        ps.executeUpdate();
        this.commit();
        this.runtest2UpdateTrigger();
    }

    public void test5InsertAfterTriggerNoReferencingClause() throws SQLException {
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create trigger trigger1 AFTER INSERT on table1 insert into table2(id, updates) values (100, -1)");
        this.commit();
        this.runtest1InsertTriggerTest();
    }

    public void test5InsertBeforeTriggerNoReferencingClause() throws SQLException {
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create trigger trigger1 NO CASCADE BEFORE INSERT on table1 select updates from table2 where table2.id = 1");
        this.commit();
        this.runtest1InsertTriggerTest();
    }

    public void test5DeleteAfterTriggerNoReferencingClause() throws SQLException {
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create trigger trigger1 AFTER DELETE on table1 delete from table2 where id=1");
        this.commit();
        this.runDeleteTriggerTest();
    }

    public void test5DeleteBeforeTriggerNoReferencingClause() throws SQLException {
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create trigger trigger1 NO CASCADE BEFORE DELETE on table1 select updates from table2 where table2.id = 1");
        this.commit();
        this.runDeleteTriggerTest();
    }

    public void test5UpdateAfterTriggerNoReferencingClause() throws SQLException {
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create trigger trigger1 AFTER UPDATE of status on table1 update table2 set updates = updates + 1 where table2.id = 1");
        this.commit();
        this.runtest1UpdateTrigger();
    }

    public void test5UpdateBeforeTriggerNoReferencingClause() throws SQLException {
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("create trigger trigger1 NO CASCADE BEFORE UPDATE of status on table1 select updates from table2 where table2.id = 1");
        this.commit();
        this.runtest1UpdateTrigger();
    }

    public void test6UpdateAfterTriggerNoTriggerColumn() throws SQLException {
        if (this.testWithLargeDataInLOB) {
            return;
        }
        this.basicSetup();
        Statement s = this.createStatement();
        s.execute("drop table table2");
        s.execute("create table table2 (id int, bl_table2 blob(2G))");
        s.execute("create trigger trigger1 after update on table1 referencing new as n_row for each row update table2 set bl_table2 = n_row.bl where table2.id = n_row.id");
        PreparedStatement ps = this.prepareStatement("insert into table2 (id) values (?)");
        ps.setInt(1, 1);
        ps.executeUpdate();
        this.commit();
        this.runtest2UpdateTrigger();
    }

    public void runtest1InsertTriggerTest() throws SQLException {
        PreparedStatement ps = this.prepareStatement("insert into table1(id, status) values(101, 0)");
        ps.executeUpdate();
        this.commit();
    }

    public void runtest2InsertTriggerTest() throws SQLException {
        PreparedStatement ps = this.prepareStatement("insert into table1(id, status, bl) values(101, 0, ?)");
        ps.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(51200000L), 51200000);
        ps.executeUpdate();
        this.commit();
    }

    public void runtest1UpdateTrigger() throws SQLException {
        PreparedStatement ps = this.prepareStatement("update table1 set status = 1 where id = 1");
        ps.executeUpdate();
        this.commit();
    }

    public void runtest2UpdateTrigger() throws SQLException {
        PreparedStatement ps = this.prepareStatement("update table1 set bl = ? where id = 1");
        ps.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(51200000L), 51200000);
        ps.executeUpdate();
        this.commit();
    }

    public void runtest3UpdateTrigger() throws SQLException {
        PreparedStatement ps = this.prepareStatement("update table1 set bl_null=null where id = 1");
        ps.executeUpdate();
        this.commit();
    }

    public void runDeleteTriggerTest() throws SQLException {
        PreparedStatement ps = this.prepareStatement("delete from table1 where id=1");
        ps.executeUpdate();
        this.commit();
    }
}

