/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class MemoryLeakFixesTest
extends BaseJDBCTestCase {
    private static long HALFMB = 512000L;
    private static int numRows = 100;
    private static int numPreparedStmts = 2000;

    public MemoryLeakFixesTest(String name) {
        super(name);
    }

    public void testPrepStmtD210() throws Exception {
        Connection conn = this.getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        conn.setAutoCommit(false);
        Statement stmt = this.createStatement();
        stmt.execute("create table t1 (lvc  LONG VARCHAR)");
        stmt.close();
        String insertTabSql = "insert into t1 values(?)";
        ps = conn.prepareStatement(insertTabSql);
        for (int i = 0; i < numRows; ++i) {
            ps.setString(1, "Hello" + i);
            ps.executeUpdate();
        }
        ps.close();
        String selTabSql = "select * from t1";
        for (int i = 0; i < numPreparedStmts; ++i) {
            ps = conn.prepareStatement(selTabSql);
            rs = ps.executeQuery();
            while (rs.next()) {
                rs.getString(1);
            }
            rs.close();
            if (i % 100 != 0) continue;
            MemoryLeakFixesTest.runFinalizerIfNeeded();
        }
        conn.commit();
    }

    public void testReExecuteD557() throws Exception {
        MemoryLeakFixesTest.println("DERBY-557: reExecuteStatementTest() ");
        Connection conn = this.getConnection();
        Statement stmt = conn.createStatement();
        for (int i = 0; i < 50000; ++i) {
            if (i % 1000 == 0) {
                MemoryLeakFixesTest.runFinalizerIfNeeded();
            }
            ResultSet rs = stmt.executeQuery("values(1)");
        }
        conn.commit();
        stmt.close();
        conn.close();
    }

    public void testResultSetgcD3316() throws Exception {
        MemoryLeakFixesTest.println("DERBY-3316: Multiple statement executions ");
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE TAB (col1 varchar(32672))");
        PreparedStatement ps = conn.prepareStatement("INSERT INTO TAB VALUES(?)");
        ps.setString(1, "hello");
        ps.executeUpdate();
        ps.setString(1, "hello");
        ps.executeUpdate();
        ps.close();
        for (int i = 0; i < 2000; ++i) {
            s = conn.createStatement();
            ResultSet rs = s.executeQuery("SELECT * from tab");
            while (rs.next()) {
            }
            if (i % 100 != 0) continue;
            MemoryLeakFixesTest.runFinalizerIfNeeded();
        }
        conn.close();
        conn = this.getConnection();
        s = conn.createStatement();
        s.executeUpdate("DROP TABLE TAB");
        s.close();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRepeatedDatabaseCreationWithAutoStats() throws SQLException {
        String DB_NAME = "derby-memory-test";
        File DB_DIR = new File("system", "derby-memory-test");
        DataSource ds = JDBCDataSource.getDataSource("derby-memory-test");
        int iter = 0;
        while (iter < 20) {
            MemoryLeakFixesTest.println("-- " + iter++);
            if (PrivilegedFileOpsForTests.exists(DB_DIR)) {
                MemoryLeakFixesTest.assertDirectoryDeleted(DB_DIR);
            }
            JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
            Connection conn = ds.getConnection();
            JDBCDataSource.clearStringBeanProperty(ds, "createDatabase");
            conn.setAutoCommit(false);
            Statement s = conn.createStatement();
            s.executeUpdate("CREATE TABLE TEST (CINT INT)");
            s.executeUpdate("CREATE INDEX NDX ON TEST (CINT)");
            PreparedStatement ins = conn.prepareStatement("INSERT INTO TEST VALUES ?");
            for (int i = 0; i < 200; ++i) {
                ins.setInt(1, i);
                ins.executeUpdate();
            }
            ins.close();
            conn.commit();
            JDBC.assertDrainResults(s.executeQuery("SELECT * FROM TEST WHERE CINT=42"));
            s.close();
            conn.rollback();
            conn.close();
            JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
            try {
                ds.getConnection();
                MemoryLeakFixesTest.fail((String)"Expected shutdown exception");
            }
            catch (SQLException e) {
                MemoryLeakFixesTest.assertSQLState("08006", e);
            }
            finally {
                JDBCDataSource.clearStringBeanProperty(ds, "shutdownDatabase");
            }
        }
        MemoryLeakFixesTest.assertTrue((boolean)PrivilegedFileOpsForTests.exists(DB_DIR));
    }

    private static void runFinalizerIfNeeded() {
        Runtime rt = Runtime.getRuntime();
        if (rt.freeMemory() < HALFMB) {
            MemoryLeakFixesTest.println("Waiting for finalizer ");
            rt.runFinalization();
        }
    }

    public static Test suite() {
        Test suite = TestConfiguration.defaultSuite(MemoryLeakFixesTest.class);
        return suite;
    }
}

