/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UngroupedAggregatesNegativeTest
extends BaseJDBCTestCase {
    public UngroupedAggregatesNegativeTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(UngroupedAggregatesNegativeTest.class);
    }

    public void setUp() throws SQLException {
        String sql = "create table t1 (c1 int)";
        Statement st = this.createStatement();
        st.executeUpdate(sql);
        sql = "create table t2 (c1 int)";
        st.executeUpdate(sql);
        sql = "insert into t2 values 1,2,3";
        UngroupedAggregatesNegativeTest.assertEquals((int)3, (int)st.executeUpdate(sql));
        st.close();
    }

    public void tearDown() throws Exception {
        this.dropTable("t1");
        this.dropTable("t2");
        super.tearDown();
    }

    public void testSelect() throws SQLException {
        String sql = "select c1, max(c1) from t1";
        this.assertCompileError("42Y35", sql);
        sql = "select c1 * max(c1) from t1";
        this.assertCompileError("42Y35", sql);
    }

    public void testWhereClause() {
        String sql = "select c1 from t1 where max(c1) = 1";
        this.assertCompileError("42903", sql);
    }

    public void testOnClause() {
        String sql = "select * from t1 join t1 as t2 on avg(t2.c1) > 10";
        this.assertCompileError("42Z07", sql);
    }

    public void testSubquery() throws SQLException {
        String sql = "select max(c1), (select t2.c1 from t2 where t1.c1 = t2.c1) from t1";
        this.assertCompileError("42Y29", sql);
        sql = "select max(c1), (select t2.c1 from t2) from t1";
        Statement st = this.createStatement();
        UngroupedAggregatesNegativeTest.assertStatementError("21000", st, sql);
        st.close();
    }
}

