/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;

public class RoutineTest
extends BaseJDBCTestCase {
    private static final String CANNOT_STUFF_NULL_INTO_PRIMITIVE = "39004";

    public RoutineTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(RoutineTest.class, "RoutineTest");
        return new CleanDatabaseTestSetup((Test)suite);
    }

    public void testFunctionResultDataTypeValidation() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE FUNCTION SMALLINT_P_SHORT(VARCHAR(10)) RETURNS SMALLINT EXTERNAL NAME 'java.lang.Short.parseShort' LANGUAGE JAVA PARAMETER STYLE JAVA");
        PreparedStatement ps = this.prepareStatement("VALUES SMALLINT_P_SHORT(?)");
        ps.setString(1, "123");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123");
        s.executeUpdate("CREATE FUNCTION SMALLINT_O_INTEGER(VARCHAR(10)) RETURNS SMALLINT EXTERNAL NAME 'java.lang.Integer.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA");
        ps = this.prepareStatement("VALUES SMALLINT_O_INTEGER(?)");
        ps.setString(1, "123");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123");
        s.executeUpdate("CREATE FUNCTION INTEGER_P_INT(VARCHAR(10)) RETURNS INTEGER EXTERNAL NAME 'java.lang.Integer.parseInt' LANGUAGE JAVA PARAMETER STYLE JAVA");
        ps = this.prepareStatement("VALUES INTEGER_P_INT(?)");
        ps.setString(1, "123");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123");
        s.executeUpdate("CREATE FUNCTION INTEGER_O_INTEGER(VARCHAR(10)) RETURNS INTEGER EXTERNAL NAME 'java.lang.Integer.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA");
        ps = this.prepareStatement("VALUES INTEGER_O_INTEGER(?)");
        ps.setString(1, "123");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123");
        s.executeUpdate("CREATE FUNCTION BIGINT_P_LONG(VARCHAR(10)) RETURNS BIGINT EXTERNAL NAME 'java.lang.Long.parseLong' LANGUAGE JAVA PARAMETER STYLE JAVA");
        ps = this.prepareStatement("VALUES BIGINT_P_LONG(?)");
        ps.setString(1, "123");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123");
        s.executeUpdate("CREATE FUNCTION BIGINT_O_LONG(VARCHAR(10)) RETURNS BIGINT EXTERNAL NAME 'java.lang.Long.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA");
        ps = this.prepareStatement("VALUES BIGINT_O_LONG(?)");
        ps.setString(1, "123");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123");
        s.executeUpdate("CREATE FUNCTION REAL_P_FLOAT(VARCHAR(10)) RETURNS REAL EXTERNAL NAME 'java.lang.Float.parseFloat' LANGUAGE JAVA PARAMETER STYLE JAVA");
        ps = this.prepareStatement("VALUES REAL_P_FLOAT(?)");
        ps.setString(1, "123.0");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123.0");
        s.executeUpdate("CREATE FUNCTION REAL_O_FLOAT(VARCHAR(10)) RETURNS REAL EXTERNAL NAME 'java.lang.Float.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA");
        ps = this.prepareStatement("VALUES REAL_O_FLOAT(?)");
        ps.setString(1, "123.0");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123.0");
        s.executeUpdate("CREATE FUNCTION DOUBLE_P_DOUBLE(VARCHAR(10)) RETURNS DOUBLE EXTERNAL NAME 'java.lang.Double.parseDouble' LANGUAGE JAVA PARAMETER STYLE JAVA");
        ps = this.prepareStatement("VALUES DOUBLE_P_DOUBLE(?)");
        ps.setString(1, "123.0");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123.0");
        s.executeUpdate("CREATE FUNCTION DOUBLE_O_DOUBLE(VARCHAR(10)) RETURNS DOUBLE EXTERNAL NAME 'java.lang.Double.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA");
        ps = this.prepareStatement("VALUES DOUBLE_O_DOUBLE(?)");
        ps.setString(1, "123.0");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123.0");
        ps.close();
        s.close();
    }

    public void testFunctionReturnsNullOnNullInput() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE FUNCTION SMALLINT_P_SHORT_RN(VARCHAR(10)) RETURNS SMALLINT EXTERNAL NAME 'java.lang.Short.parseShort' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        PreparedStatement ps = this.prepareStatement("VALUES SMALLINT_P_SHORT_RN(?)");
        ps.setString(1, "123");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123");
        ps.setString(1, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        s.executeUpdate("CREATE FUNCTION SMALLINT_O_INTEGER_RN(VARCHAR(10)) RETURNS SMALLINT EXTERNAL NAME 'java.lang.Integer.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        ps = this.prepareStatement("VALUES SMALLINT_O_INTEGER_RN(?)");
        ps.setString(1, "123");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123");
        ps.setString(1, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        s.executeUpdate("CREATE FUNCTION INTEGER_P_INT_RN(VARCHAR(10)) RETURNS INTEGER EXTERNAL NAME 'java.lang.Integer.parseInt' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        ps = this.prepareStatement("VALUES INTEGER_P_INT_RN(?)");
        ps.setString(1, "123");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123");
        s.executeUpdate("CREATE FUNCTION INTEGER_O_INTEGER_RN(VARCHAR(10)) RETURNS INTEGER EXTERNAL NAME 'java.lang.Integer.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        ps = this.prepareStatement("VALUES INTEGER_O_INTEGER_RN(?)");
        ps.setString(1, "123");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123");
        ps.setString(1, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        s.executeUpdate("CREATE FUNCTION BIGINT_P_LONG_RN(VARCHAR(10)) RETURNS BIGINT EXTERNAL NAME 'java.lang.Long.parseLong' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        ps = this.prepareStatement("VALUES BIGINT_P_LONG_RN(?)");
        ps.setString(1, "123");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123");
        ps.setString(1, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        s.executeUpdate("CREATE FUNCTION BIGINT_O_LONG_NR(VARCHAR(10)) RETURNS BIGINT EXTERNAL NAME 'java.lang.Long.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        ps = this.prepareStatement("VALUES BIGINT_O_LONG_NR(?)");
        ps.setString(1, "123");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123");
        ps.setString(1, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        s.executeUpdate("CREATE FUNCTION REAL_P_FLOAT_NR(VARCHAR(10)) RETURNS REAL EXTERNAL NAME 'java.lang.Float.parseFloat' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        ps = this.prepareStatement("VALUES REAL_P_FLOAT_NR(?)");
        ps.setString(1, "123.0");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123.0");
        ps.setString(1, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        s.executeUpdate("CREATE FUNCTION REAL_O_FLOAT_NR(VARCHAR(10)) RETURNS REAL EXTERNAL NAME 'java.lang.Float.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        ps = this.prepareStatement("VALUES REAL_O_FLOAT_NR(?)");
        ps.setString(1, "123.0");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123.0");
        ps.setString(1, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        s.executeUpdate("CREATE FUNCTION DOUBLE_P_DOUBLE_NR(VARCHAR(10)) RETURNS DOUBLE EXTERNAL NAME 'java.lang.Double.parseDouble' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        ps = this.prepareStatement("VALUES DOUBLE_P_DOUBLE_NR(?)");
        ps.setString(1, "123.0");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123.0");
        ps.setString(1, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        s.executeUpdate("CREATE FUNCTION DOUBLE_O_DOUBLE_NR(VARCHAR(10)) RETURNS DOUBLE EXTERNAL NAME 'java.lang.Double.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA RETURNS NULL ON NULL INPUT");
        ps = this.prepareStatement("VALUES DOUBLE_O_DOUBLE_NR(?)");
        ps.setString(1, "123.0");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "123.0");
        ps.setString(1, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.close();
        s.close();
    }

    public void testFunctionNullHandling() throws SQLException, UnsupportedEncodingException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE FUNCTION SV_NOCALL(INTEGER) RETURNS VARCHAR(10) RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.String.valueOf'  LANGUAGE JAVA PARAMETER STYLE JAVA");
        s.executeUpdate("CREATE FUNCTION SV_CALL(INTEGER) RETURNS VARCHAR(10) CALLED ON NULL INPUT EXTERNAL NAME 'java.lang.String.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA");
        s.executeUpdate("CREATE FUNCTION SV_DEFAULT(INTEGER) RETURNS VARCHAR(10) EXTERNAL NAME 'java.lang.String.valueOf' LANGUAGE JAVA PARAMETER STYLE JAVA");
        PreparedStatement ps = this.prepareStatement("VALUES SV_NOCALL(?)");
        ps.setInt(1, 42);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "42");
        ps.setNull(1, 4);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.close();
        ps = this.prepareStatement("VALUES SV_CALL(?)");
        ps.setInt(1, 52);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "52");
        ps.setNull(1, 4);
        RoutineTest.assertStatementError(CANNOT_STUFF_NULL_INTO_PRIMITIVE, ps);
        ps.close();
        ps = this.prepareStatement("VALUES SV_DEFAULT(?)");
        ps.setInt(1, 62);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "62");
        ps.setNull(1, 4);
        RoutineTest.assertStatementError(CANNOT_STUFF_NULL_INTO_PRIMITIVE, ps);
        ps.close();
        s.executeUpdate("CREATE FUNCTION CONCAT_NOCALL(VARCHAR(10), VARCHAR(10)) RETURNS VARCHAR(20) RETURNS NULL ON NULL INPUT EXTERNAL NAME '" + RoutineTest.class.getName() + ".concat'  " + "LANGUAGE JAVA PARAMETER STYLE JAVA");
        s.executeUpdate("CREATE FUNCTION CONCAT_CALL(VARCHAR(10), VARCHAR(10)) RETURNS VARCHAR(20) CALLED ON NULL INPUT EXTERNAL NAME '" + RoutineTest.class.getName() + ".concat'  " + "LANGUAGE JAVA PARAMETER STYLE JAVA");
        ps = this.prepareStatement("VALUES CONCAT_NOCALL(?, ?)");
        ps.setString(1, "good");
        ps.setString(2, "bye");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "goodbye");
        ps.setString(1, null);
        ps.setString(2, "bye");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.setString(1, "good");
        ps.setString(2, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.setString(1, null);
        ps.setString(2, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.close();
        ps = this.prepareStatement("VALUES CONCAT_CALL(?, ?)");
        ps.setString(1, "good");
        ps.setString(2, "bye");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "goodbye");
        ps.setString(1, null);
        ps.setString(2, "bye");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "s1NULLbye");
        ps.setString(1, "good");
        ps.setString(2, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "goods2NULL");
        ps.setString(1, null);
        ps.setString(2, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "s1NULLs2NULL");
        ps.close();
        ps = this.prepareStatement("VALUES CONCAT_NOCALL(CONCAT_NOCALL(?, 'RNNI'), CONCAT_CALL(?, 'CONI'))");
        ps.setString(1, "p1");
        ps.setString(2, "p2");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "p1RNNIp2CONI");
        ps.setString(1, null);
        ps.setString(2, "p2");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.setString(1, "p1");
        ps.setString(2, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "p1RNNIs1NULLCONI");
        ps.setString(1, null);
        ps.setString(2, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.close();
        ps = this.prepareStatement("VALUES CONCAT_CALL(CONCAT_NOCALL(?, 'RNNI'), CONCAT_CALL(?, 'CONI'))");
        ps.setString(1, "p1");
        ps.setString(2, "p2");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "p1RNNIp2CONI");
        ps.setString(1, null);
        ps.setString(2, "p2");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "s1NULLp2CONI");
        ps.setString(1, "p1");
        ps.setString(2, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "p1RNNIs1NULLCONI");
        ps.setString(1, null);
        ps.setString(2, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "s1NULLs1NULLCONI");
        ps.close();
        s.executeUpdate("CREATE FUNCTION SAME_NOCALL(INTEGER) RETURNS INTEGER RETURNS NULL ON NULL INPUT EXTERNAL NAME '" + RoutineTest.class.getName() + ".same'  " + "LANGUAGE JAVA PARAMETER STYLE JAVA");
        s.executeUpdate("CREATE FUNCTION SAME_CALL(INTEGER) RETURNS INTEGER CALLED ON NULL INPUT EXTERNAL NAME '" + RoutineTest.class.getName() + ".same'  " + "LANGUAGE JAVA PARAMETER STYLE JAVA");
        ps = this.prepareStatement("VALUES SAME_NOCALL(SAME_NOCALL(?))");
        ps.setInt(1, 41);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "41");
        ps.setNull(1, 4);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.close();
        ps = this.prepareStatement("VALUES SAME_NOCALL(SAME_CALL(?))");
        ps.setInt(1, 47);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "47");
        ps.setNull(1, 4);
        RoutineTest.assertStatementError(CANNOT_STUFF_NULL_INTO_PRIMITIVE, ps);
        ps.close();
        ps = this.prepareStatement("VALUES SAME_CALL(SAME_NOCALL(?))");
        ps.setInt(1, 41);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "41");
        ps.setNull(1, 4);
        RoutineTest.assertStatementError(CANNOT_STUFF_NULL_INTO_PRIMITIVE, ps);
        ps.close();
        ps = this.prepareStatement("VALUES SAME_CALL(SAME_CALL(?))");
        ps.setInt(1, 53);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "53");
        ps.setNull(1, 4);
        RoutineTest.assertStatementError(CANNOT_STUFF_NULL_INTO_PRIMITIVE, ps);
        ps.close();
        s.executeUpdate("CREATE FUNCTION NOON_NOCALL(TIME) RETURNS TIME RETURNS NULL ON NULL INPUT EXTERNAL NAME '" + RoutineTest.class.getName() + ".nullAtNoon'  " + "LANGUAGE JAVA PARAMETER STYLE JAVA");
        s.executeUpdate("CREATE FUNCTION NOON_CALL(TIME) RETURNS TIME CALLED ON NULL INPUT EXTERNAL NAME '" + RoutineTest.class.getName() + ".nullAtNoon'  " + "LANGUAGE JAVA PARAMETER STYLE JAVA");
        Time noon = Time.valueOf("12:00:00");
        Time tea = Time.valueOf("15:30:00");
        ps = this.prepareStatement("VALUES NOON_NOCALL(?)");
        ps.setTime(1, tea);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), tea.toString());
        ps.setTime(1, noon);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.setTime(1, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.close();
        ps = this.prepareStatement("VALUES NOON_CALL(?)");
        ps.setTime(1, tea);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), tea.toString());
        ps.setTime(1, noon);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.setTime(1, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "11:00:00");
        ps.close();
        ps = this.prepareStatement("VALUES NOON_NOCALL(NOON_NOCALL(?))");
        ps.setTime(1, tea);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), tea.toString());
        ps.setTime(1, noon);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.setTime(1, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.close();
        ps = this.prepareStatement("VALUES NOON_NOCALL(NOON_CALL(?))");
        ps.setTime(1, tea);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), tea.toString());
        ps.setTime(1, noon);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.setTime(1, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "11:30:00");
        ps.close();
        ps = this.prepareStatement("VALUES NOON_CALL(NOON_NOCALL(?))");
        ps.setTime(1, tea);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), tea.toString());
        ps.setTime(1, noon);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "11:00:00");
        ps.setTime(1, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "11:00:00");
        ps.close();
        ps = this.prepareStatement("VALUES NOON_CALL(NOON_CALL(?))");
        ps.setTime(1, tea);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), tea.toString());
        ps.setTime(1, noon);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "11:00:00");
        ps.setTime(1, null);
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "11:30:00");
        ps.close();
        s.close();
    }

    public void testAggregateArgument() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE TEST (I INT)");
        s.executeUpdate("INSERT INTO TEST VALUES(1)");
        s.executeUpdate("INSERT INTO TEST VALUES(2)");
        s.executeUpdate("CREATE FUNCTION CheckCount(count integer) RETURNS INTEGER PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.RoutineTest.checkCount'");
        ResultSet rs = s.executeQuery("select checkCount(count(*)) from test");
        JDBC.assertSingleValueResultSet(rs, "2");
    }

    public void test_4459() throws Exception {
        Statement s = this.createStatement();
        s.executeUpdate("create function getNullInt() returns int language java parameter style java\nexternal name '" + RoutineTest.class.getName() + ".getNullInt'");
        s.executeUpdate("create function negateInt( a int ) returns int language java parameter style java\nexternal name '" + RoutineTest.class.getName() + ".negateInt'");
        RoutineTest.assertStatementError(CANNOT_STUFF_NULL_INTO_PRIMITIVE, s, "values( negateInt( cast( null as int) ) )");
        RoutineTest.assertStatementError(CANNOT_STUFF_NULL_INTO_PRIMITIVE, s, "values( negateInt( getNullInt() ) )");
    }

    public void test_5749() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t5749(v varchar(5))");
        s.executeUpdate("create procedure p5749 (a varchar(5)) modifies sql data external name '" + RoutineTest.class.getName() + ".p5749' " + "language java parameter style java");
        CallableStatement cs = this.prepareCall("call p5749(?)");
        cs.setString(1, "123456");
        try {
            cs.execute();
            RoutineTest.fail();
        }
        catch (SQLException e) {
            RoutineTest.assertSQLState("22001", e);
        }
        try {
            s.executeUpdate("call p5749('123456')");
            RoutineTest.fail();
        }
        catch (SQLException e) {
            RoutineTest.assertSQLState("22001", e);
        }
        PreparedStatement ps = this.prepareStatement("insert into t5749 values(?)");
        ps.setString(1, "123456");
        try {
            ps.execute();
            RoutineTest.fail();
        }
        catch (SQLException e) {
            RoutineTest.assertSQLState("22001", e);
        }
    }

    public static String concat(String s1, String s2) {
        if (s1 == null) {
            s1 = "s1NULL";
        }
        if (s2 == null) {
            s2 = "s2NULL";
        }
        return s1.concat(s2);
    }

    public static int same(int i) {
        return i;
    }

    public static Time nullAtNoon(Time t) {
        if (t == null) {
            return Time.valueOf("11:00:00");
        }
        String s = t.toString();
        if ("11:00:00".equals(s)) {
            return Time.valueOf("11:30:00");
        }
        if ("12:00:00".equals(s)) {
            return null;
        }
        return t;
    }

    public static int checkCount(int count) throws SQLException {
        if (count == 0) {
            throw new SQLException("No results found", "38777");
        }
        return count;
    }

    public static int negateInt(int arg) {
        return -arg;
    }

    public static Integer getNullInt() {
        return null;
    }

    public static void p5749(String s) {
    }
}

