/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OffsetFetchNextTest
extends BaseJDBCTestCase {
    private static final String LANG_FORMAT_EXCEPTION = "22018";
    private static final String LANG_INTEGER_LITERAL_EXPECTED = "42X20";
    private static final String LANG_INVALID_ROW_COUNT_FIRST = "2201W";
    private static final String LANG_INVALID_ROW_COUNT_OFFSET = "2201X";
    private static final String LANG_MISSING_PARMS = "07000";
    private static final String LANG_SYNTAX_ERROR = "42X01";
    private static final String LANG_ROW_COUNT_OFFSET_FIRST_IS_NULL = "2201Z";
    private static final String PERCENT_TOKEN = "%";
    private static final String FIRST_ROWS_ONLY = "fetch first % rows only";
    private static final String FIRST_ROW_ONLY = "fetch first % row only";
    private static final String NEXT_ROWS_ONLY = "fetch next % rows only";
    private static final int SQL_STANDARD_VARIANT = 0;
    private static final int JDBC_VARIANT = 1;
    private static final int VARIANT_COUNT = 2;

    public OffsetFetchNextTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("OffsetFetchNextTest");
        suite.addTest(OffsetFetchNextTest.baseSuite("OffsetFetchNextTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(OffsetFetchNextTest.baseSuite("OffsetFetchNextTest:client")));
        return suite;
    }

    public static Test baseSuite(String suiteName) {
        return new CleanDatabaseTestSetup((Test)new TestSuite(OffsetFetchNextTest.class, suiteName)){

            protected void decorateSQL(Statement s) throws SQLException {
                OffsetFetchNextTest.createSchemaObjects(s);
            }
        };
    }

    private static void createSchemaObjects(Statement st) throws SQLException {
        st.executeUpdate("create table t1 (a int, b bigint)");
        st.executeUpdate("insert into t1 (a, b) values (1,1), (1,2), (1,3), (1,4), (1,5)");
        st.executeUpdate("create table t2 (a int primary key, b bigint)");
        st.executeUpdate("insert into t2 (a, b) values (1,1), (2,1), (3,1), (4,1), (5,1)");
        st.executeUpdate("create table t3 (a int primary key,                  b bigint unique)");
        st.executeUpdate("insert into t3 (a, b) values (1,1), (2,2), (3,3), (4,4), (5,5)");
    }

    public void testErrors() throws Exception {
        Statement st = this.createStatement();
        String stub = "select * from t1 %";
        this.vetStatement(st, LANG_INVALID_ROW_COUNT_OFFSET, stub, FIRST_ROWS_ONLY, "-1", null, null);
        this.vetStatement(st, LANG_SYNTAX_ERROR, stub, FIRST_ROWS_ONLY, "-?", null, null);
        OffsetFetchNextTest.assertStatementError(LANG_INVALID_ROW_COUNT_FIRST, st, "select * from t1 fetch first 0 rows only");
        this.vetStatement(st, LANG_INVALID_ROW_COUNT_FIRST, stub, FIRST_ROWS_ONLY, null, "-1", null);
        this.vetStatement(st, LANG_INTEGER_LITERAL_EXPECTED, stub, FIRST_ROWS_ONLY, null, "3.14", null);
        OffsetFetchNextTest.assertStatementError(LANG_SYNTAX_ERROR, st, "select * from t1 fetch first 0 rows only offset 0 rows");
        OffsetFetchNextTest.assertStatementError(LANG_SYNTAX_ERROR, st, "select * from t1 { offset 0 limit 0 }");
    }

    public void testNewKeywordNonReserved() throws Exception {
        this.setAutoCommit(false);
        this.prepareStatement("select a,b as offset from t1 offset 0 rows");
        this.prepareStatement("select a,b as limit from t1 offset 0 rows");
        this.prepareStatement("select a,b from t1 as offset");
        this.prepareStatement("select a,b from t1 as limit");
        this.prepareStatement("select a,b offset from t1 offset");
        this.prepareStatement("select a,b limit from t1 limit");
        this.prepareStatement("select a,b offset from t1 offset +2 rows");
        this.prepareStatement("select a offset,b from t1 offset ? rows");
        this.prepareStatement("select offset.a, offset.b offset from t1 as offset offset ? rows");
        this.prepareStatement("select limit.a, limit.b offset from t1 as limit offset ? rows");
        Statement s = this.createStatement();
        s.executeUpdate("create table t4562(i int, offset int)");
        ResultSet rs = s.executeQuery("select * from t4562 where i > 0 and offset + i < 0 offset 2 rows");
        rs.next();
        rs = s.executeQuery("select * from t4562 where i > 0 and offset - i < 0 offset 2 rows");
        rs.next();
        rs = s.executeQuery("select * from t4562 where i > 0 and offset * i < 0 offset 2 rows");
        rs.next();
        rs.close();
        this.rollback();
    }

    public void testOffsetFetchFirstReadOnlyForwardOnlyRS() throws Exception {
        Statement stm = this.createStatement();
        this.vetStatement(stm, null, "select a, b from t1%", FIRST_ROWS_ONLY, "0", null, new String[][]{{"1", "1"}, {"1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.vetStatement(stm, null, "select a,b from t2%", FIRST_ROWS_ONLY, "0", null, new String[][]{{"1", "1"}, {"2", "1"}, {"3", "1"}, {"4", "1"}, {"5", "1"}});
        this.vetStatement(stm, null, "select a,b from t3%", FIRST_ROWS_ONLY, "0", null, new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}});
        this.vetStatement(stm, null, "select a,b from t1%", FIRST_ROWS_ONLY, "1", null, new String[][]{{"1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.vetStatement(stm, null, "select a,b from t2%", FIRST_ROWS_ONLY, "1", null, new String[][]{{"2", "1"}, {"3", "1"}, {"4", "1"}, {"5", "1"}});
        this.vetStatement(stm, null, "select a,b from t3%", FIRST_ROWS_ONLY, "1", null, new String[][]{{"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}});
        this.vetStatement(stm, null, "select a,b from t1%", FIRST_ROWS_ONLY, "4", null, new String[][]{{"1", "5"}});
        this.vetStatement(stm, null, "select a,b from t2%", FIRST_ROWS_ONLY, "4", null, new String[][]{{"5", "1"}});
        this.vetStatement(stm, null, "select a,b from t3%", FIRST_ROWS_ONLY, "4", null, new String[][]{{"5", "5"}});
        this.vetStatement(stm, null, "select a,b from t1%", FIRST_ROWS_ONLY, "1", "1", new String[][]{{"1", "2"}});
        this.vetStatement(stm, null, "select a,b from t2%", FIRST_ROWS_ONLY, "1", "1", new String[][]{{"2", "1"}});
        this.vetStatement(stm, null, "select a,b from t3%", FIRST_ROWS_ONLY, "1", "1", new String[][]{{"2", "2"}});
        this.vetStatement(stm, null, "select a,b from t1%", FIRST_ROW_ONLY, "1", "10", new String[][]{{"1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.vetStatement(stm, null, "select a,b from t2%", FIRST_ROW_ONLY, "1", "10", new String[][]{{"2", "1"}, {"3", "1"}, {"4", "1"}, {"5", "1"}});
        this.vetStatement(stm, null, "select a,b from t3%", FIRST_ROW_ONLY, "1", "10", new String[][]{{"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}});
        this.vetStatement(stm, null, "select a,b from t1%", FIRST_ROW_ONLY, "10", null, new String[0][]);
        this.vetStatement(stm, null, "select a,b from t2%", FIRST_ROW_ONLY, "10", null, new String[0][]);
        this.vetStatement(stm, null, "select a,b from t3%", FIRST_ROW_ONLY, "10", null, new String[0][]);
        this.queryAndCheck(stm, "select a,b from t1 fetch first row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t2 fetch next row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 fetch next row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t1 order by b asc fetch first row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t2 order by a asc fetch next row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 order by a asc fetch next row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t1 order by b desc fetch first row only", new String[][]{{"1", "5"}});
        this.queryAndCheck(stm, "select a,b from t2 order by a desc fetch next row only", new String[][]{{"5", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 order by a desc fetch next row only", new String[][]{{"5", "5"}});
        this.queryAndCheck(stm, "select max(a) from t1 group by b fetch first row only", new String[][]{{"1"}});
        this.vetStatement(stm, null, "select max(a) from t2 group by b %", FIRST_ROW_ONLY, "0", null, new String[][]{{"5"}});
        this.vetStatement(stm, null, "select max(a) from t3 group by b order by max(a) %", NEXT_ROWS_ONLY, null, "2", new String[][]{{"1"}, {"2"}});
        this.vetStatement(stm, null, "select * from t1 union all select * from t1 %", FIRST_ROW_ONLY, null, "2", new String[][]{{"1", "1"}, {"1", "2"}});
        this.vetStatement(stm, null, "select t2.b, t3.b from t2,t3 where t2.a=t3.a %", FIRST_ROW_ONLY, null, "2", new String[][]{{"1", "1"}, {"1", "2"}});
        stm.close();
    }

    public void testOffsetFetchFirstUpdatableForwardOnlyRS() throws Exception {
        ResultSet rs;
        int i;
        Statement stm = this.createStatement(1003, 1008);
        this.setAutoCommit(false);
        String[] variants = this.makeVariants("select * from t1 %", FIRST_ROWS_ONLY, "0", null);
        for (i = 0; i < variants.length; ++i) {
            rs = stm.executeQuery(variants[i]);
            rs.next();
            rs.next();
            rs.updateInt(1, -rs.getInt(1));
            rs.updateRow();
            rs.close();
            this.queryAndCheck(stm, "select a,b from t1", new String[][]{{"1", "1"}, {"-1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
            this.rollback();
        }
        variants = this.makeVariants("select * from t1 %", FIRST_ROWS_ONLY, "1", null);
        for (i = 0; i < variants.length; ++i) {
            rs = stm.executeQuery(variants[i]);
            rs.next();
            rs.updateInt(1, -rs.getInt(1));
            rs.updateRow();
            rs.close();
            this.queryAndCheck(stm, "select a,b from t1", new String[][]{{"1", "1"}, {"-1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
            this.rollback();
        }
        stm.close();
    }

    public void testOffsetFetchFirstReadOnlyScrollableRS() throws Exception {
        ResultSet rs;
        int i;
        Statement stm = this.createStatement(1004, 1007);
        String[] variants = this.makeVariants("select * from t1 %", FIRST_ROWS_ONLY, "0", null);
        for (i = 0; i < variants.length; ++i) {
            rs = stm.executeQuery(variants[i]);
            rs.next();
            rs.next();
            OffsetFetchNextTest.assertTrue((rs.getInt(2) == 2 ? 1 : 0) != 0);
            rs.close();
        }
        variants = this.makeVariants("select * from t1 %", FIRST_ROWS_ONLY, "1", "3");
        for (i = 0; i < variants.length; ++i) {
            rs = stm.executeQuery(variants[i]);
            rs.next();
            rs.next();
            OffsetFetchNextTest.assertTrue((rs.getInt(2) == 3 ? 1 : 0) != 0);
            rs.previous();
            OffsetFetchNextTest.assertTrue((rs.getInt(2) == 2 ? 1 : 0) != 0);
            rs.previous();
            OffsetFetchNextTest.assertTrue((boolean)rs.isBeforeFirst());
            rs.next();
            rs.next();
            rs.next();
            rs.next();
            OffsetFetchNextTest.assertTrue((boolean)rs.isAfterLast());
        }
        stm.close();
    }

    public void testOffsetFetchFirstUpdatableScrollableRS() throws Exception {
        ResultSet rs;
        int i;
        Statement stm = this.createStatement(1004, 1008);
        this.setAutoCommit(false);
        String[] variants = this.makeVariants("select * from t1 % for update", FIRST_ROWS_ONLY, "0", null);
        for (i = 0; i < variants.length; ++i) {
            rs = stm.executeQuery(variants[i]);
            rs.next();
            rs.next();
            rs.updateInt(1, -rs.getInt(1));
            rs.updateRow();
            rs.close();
            this.queryAndCheck(stm, "select a,b from t1", new String[][]{{"1", "1"}, {"-1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
            this.rollback();
        }
        variants = this.makeVariants("select * from t1 %", NEXT_ROWS_ONLY, "1", "3");
        for (i = 0; i < variants.length; ++i) {
            rs = stm.executeQuery(variants[i]);
            rs.next();
            rs.next();
            rs.updateInt(1, -rs.getInt(1));
            rs.updateRow();
            rs.previous();
            rs.updateInt(1, -rs.getInt(1));
            rs.updateRow();
            rs.previous();
            OffsetFetchNextTest.assertTrue((boolean)rs.isBeforeFirst());
            rs.next();
            rs.next();
            rs.next();
            rs.next();
            OffsetFetchNextTest.assertTrue((boolean)rs.isAfterLast());
            rs.moveToInsertRow();
            rs.updateInt(1, 42);
            rs.updateInt(2, 42);
            rs.insertRow();
            rs.previous();
            rs.deleteRow();
            rs.previous();
            rs.next();
            OffsetFetchNextTest.assertTrue((boolean)rs.rowDeleted());
            rs.close();
            this.queryAndCheck(stm, "select a,b from t1", new String[][]{{"1", "1"}, {"-1", "2"}, {"-1", "3"}, {"1", "5"}, {"42", "42"}});
            this.rollback();
        }
        variants = this.makeVariants("select * from t1 where a + 1 < b%", NEXT_ROWS_ONLY, "1", null);
        for (i = 0; i < variants.length; ++i) {
            rs = stm.executeQuery(variants[i]);
            rs.absolute(2);
            OffsetFetchNextTest.assertTrue((rs.getInt(2) == 5 ? 1 : 0) != 0);
            rs.updateInt(2, -5);
            rs.updateRow();
            rs.close();
            this.queryAndCheck(stm, "select a,b from t1", new String[][]{{"1", "1"}, {"1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "-5"}});
            this.rollback();
        }
        stm.close();
    }

    public void testValues() throws Exception {
        Statement stm = this.createStatement();
        this.vetStatement(stm, null, "values 4%", FIRST_ROW_ONLY, null, "2", new String[][]{{"4"}});
        this.vetStatement(stm, null, "values 4%", FIRST_ROW_ONLY, "1", null, new String[0][]);
        stm.close();
    }

    public void testMetadata() throws Exception {
        Statement stm = this.createStatement();
        String[] variants = this.makeVariants("select * from t1%", NEXT_ROWS_ONLY, "1", null);
        for (int j = 0; j < variants.length; ++j) {
            ResultSet rs = stm.executeQuery(variants[j]);
            ResultSetMetaData rsmd = rs.getMetaData();
            int cnt = rsmd.getColumnCount();
            String[] cols = new String[]{"A", "B"};
            int[] types = new int[]{4, -5};
            for (int i = 1; i <= cnt; ++i) {
                String name = rsmd.getColumnName(i);
                int type = rsmd.getColumnType(i);
                OffsetFetchNextTest.assertTrue((boolean)name.equals(cols[i - 1]));
                OffsetFetchNextTest.assertTrue((type == types[i - 1] ? 1 : 0) != 0);
            }
            rs.close();
        }
        stm.close();
    }

    public void testRunTimeStatistics() throws Exception {
        Statement stm = this.createStatement();
        String[] variants = this.makeVariants("select a,b from t1%", NEXT_ROWS_ONLY, "2", null);
        for (int i = 0; i < variants.length; ++i) {
            stm.executeUpdate("call syscs_util.syscs_set_runtimestatistics(1)");
            this.queryAndCheck(stm, variants[i], new String[][]{{"1", "3"}, {"1", "4"}, {"1", "5"}});
            stm.executeUpdate("call syscs_util.syscs_set_runtimestatistics(0)");
            ResultSet rs = stm.executeQuery("values syscs_util.syscs_get_runtimestatistics()");
            rs.next();
            String plan = rs.getString(1);
            OffsetFetchNextTest.assertTrue((plan.indexOf("Row Count (1):\nNumber of opens = 1\nRows seen = 3\nRows filtered = 2") != -1 ? 1 : 0) != 0);
            rs.close();
        }
        stm.close();
    }

    public void testBigTable() throws Exception {
        Statement stm = this.createStatement();
        this.setAutoCommit(false);
        stm.executeUpdate("declare global temporary table session.t (i int) on commit preserve rows not logged");
        PreparedStatement ps = this.prepareStatement("insert into session.t values ?");
        for (int i = 1; i <= 100000; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
            if (i % 10000 != 0) continue;
            this.commit();
        }
        this.queryAndCheck(stm, "select count(*) from session.t", new String[][]{{"100000"}});
        this.vetStatement(stm, null, "select i from session.t%", FIRST_ROWS_ONLY, "99999", null, new String[][]{{"100000"}});
        stm.executeUpdate("drop table session.t");
        stm.close();
    }

    public void testRepeatedExecution() throws Exception {
        String[] variants = this.makeVariants("select * from t1 order by b%", NEXT_ROWS_ONLY, "2", "2");
        for (int j = 0; j < variants.length; ++j) {
            PreparedStatement ps = this.prepareStatement(variants[j]);
            String[][] expected = new String[][]{{"1", "3"}, {"1", "4"}};
            for (int i = 0; i < 10; ++i) {
                JDBC.assertFullResultSet(ps.executeQuery(), expected);
            }
        }
    }

    public void testDynamicArgs() throws Exception {
        int fetchParam;
        int offsetParam;
        PreparedStatement ps;
        int i;
        String[][] expected = null;
        String[] variants = this.makeVariants("select * from t1%", NEXT_ROWS_ONLY, "?", null);
        for (i = 0; i < variants.length; ++i) {
            ps = this.prepareStatement(variants[i]);
        }
        variants = this.makeVariants("select * from t1 order by b%", NEXT_ROWS_ONLY, "?", "?");
        for (int j = 0; j < variants.length; ++j) {
            offsetParam = j == 0 ? 1 : 2;
            fetchParam = j == 0 ? 2 : 1;
            expected = new String[][]{{"1", "3"}, {"1", "4"}};
            ps = this.prepareStatement(variants[j]);
            ps.setInt(offsetParam, 0);
            OffsetFetchNextTest.assertPreparedStatementError(LANG_MISSING_PARMS, ps);
            ps.setInt(offsetParam, -1);
            ps.setInt(fetchParam, 2);
            OffsetFetchNextTest.assertPreparedStatementError(LANG_INVALID_ROW_COUNT_OFFSET, ps);
            ps.setInt(offsetParam, 0);
            ps.setInt(fetchParam, j == 0 ? 0 : -1);
            OffsetFetchNextTest.assertPreparedStatementError(LANG_INVALID_ROW_COUNT_FIRST, ps);
            try {
                ps.setString(offsetParam, "aaa");
            }
            catch (SQLException e) {
                OffsetFetchNextTest.assertSQLState(LANG_FORMAT_EXCEPTION, e);
            }
            try {
                ps.setString(fetchParam, "aaa");
            }
            catch (SQLException e) {
                OffsetFetchNextTest.assertSQLState(LANG_FORMAT_EXCEPTION, e);
            }
            for (int i2 = 0; i2 < 2; ++i2) {
                ps.setInt(offsetParam, 2);
                ps.setInt(fetchParam, 2);
                JDBC.assertFullResultSet(ps.executeQuery(), expected);
            }
            ps.setLong(offsetParam, 1L);
            ps.setInt(fetchParam, 3);
            expected = new String[][]{{"1", "2"}, {"1", "3"}, {"1", "4"}};
            JDBC.assertFullResultSet(ps.executeQuery(), expected);
            ps.setLong(offsetParam, 0xFFFFFFFEL);
            ps.setInt(fetchParam, 5);
            JDBC.assertEmpty(ps.executeQuery());
        }
        variants = this.makeVariants("select * from t1 order by b%", NEXT_ROWS_ONLY, "?", "3");
        for (i = 0; i < variants.length; ++i) {
            ps = this.prepareStatement(variants[i]);
            ps.setLong(1, 1L);
            JDBC.assertFullResultSet(ps.executeQuery(), expected);
        }
        variants = this.makeVariants("select * from t1 order by b%", NEXT_ROWS_ONLY, "4", "?");
        for (i = 0; i < variants.length; ++i) {
            ps = this.prepareStatement(variants[i]);
            ps.setLong(1, 1L);
            JDBC.assertFullResultSet(ps.executeQuery(), new String[][]{{"1", "5"}});
        }
        variants = this.makeVariants("select * from t1 where a = ? order by b%", NEXT_ROWS_ONLY, "?", "3");
        for (i = 0; i < variants.length; ++i) {
            ps = this.prepareStatement(variants[i]);
            ps.setInt(1, 1);
            ps.setLong(2, 1L);
            JDBC.assertFullResultSet(ps.executeQuery(), expected);
        }
        variants = this.makeVariants("select * from t1 where a = ? order by b%", NEXT_ROWS_ONLY, "1", "?");
        for (i = 0; i < variants.length; ++i) {
            ps = this.prepareStatement(variants[i]);
            ps.setInt(1, 1);
            ps.setLong(2, 2L);
            expected = new String[][]{{"1", "2"}, {"1", "3"}};
            JDBC.assertFullResultSet(ps.executeQuery(), expected);
        }
        variants = this.makeVariants("select * from t1 order by b%", NEXT_ROWS_ONLY, "?", "?");
        for (i = 0; i < variants.length; ++i) {
            ps = this.prepareStatement(variants[i]);
            offsetParam = i == 0 ? 1 : 2;
            fetchParam = i == 0 ? 2 : 1;
            ps.setNull(offsetParam, -5);
            ps.setInt(fetchParam, 2);
            OffsetFetchNextTest.assertPreparedStatementError(LANG_ROW_COUNT_OFFSET_FIRST_IS_NULL, ps);
            ps.setInt(offsetParam, 1);
            ps.setNull(fetchParam, -5);
            OffsetFetchNextTest.assertPreparedStatementError(LANG_ROW_COUNT_OFFSET_FIRST_IS_NULL, ps);
            ps.close();
        }
    }

    public void testDynamicArgsMetaData() throws Exception {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        String[] variants = this.makeVariants("select * from t1 where a = ? order by b%", NEXT_ROWS_ONLY, "?", "?");
        for (int j = 0; j < variants.length; ++j) {
            PreparedStatement ps = this.prepareStatement(variants[j]);
            ParameterMetaData pmd = ps.getParameterMetaData();
            int[] expectedTypes = new int[]{4, -5, -5};
            for (int i = 0; i < 3; ++i) {
                OffsetFetchNextTest.assertEquals((String)"Unexpected parameter type", (int)expectedTypes[i], (int)pmd.getParameterType(i + 1));
                OffsetFetchNextTest.assertEquals((String)"Derby ? args are nullable", (int)1, (int)pmd.isNullable(i + 1));
            }
            ps.close();
        }
    }

    public void testJDBCLimitOffset() throws Exception {
        PreparedStatement ps = this.prepareStatement("select a from t2 order by a { limit ? }");
        ps.setInt(1, 0);
        JDBC.assertFullResultSet(ps.executeQuery(), new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}});
        ps.close();
        ps = this.prepareStatement("select a from t2 order by a { limit ? offset 3 }");
        ps.setInt(1, 0);
        JDBC.assertFullResultSet(ps.executeQuery(), new String[][]{{"4"}, {"5"}});
        ps.close();
        ps = this.prepareStatement("select t.a from\n( select * from t2 order by a { limit 3 offset 1 } ) t,\n( select * from t3 order by a offset 2 rows fetch next 10 rows only ) s\nwhere t.a = s.a order by t.a");
        JDBC.assertFullResultSet(ps.executeQuery(), new String[][]{{"3"}, {"4"}});
        ps.close();
    }

    private void vetStatement(Statement stmt, String sqlState, String stub, String fetchFormat, String offset, String fetchFirst, String[][] expectedResults) throws Exception {
        String[] variants = this.makeVariants(stub, fetchFormat, offset, fetchFirst);
        for (int i = 0; i < variants.length; ++i) {
            String text = variants[i];
            if (sqlState != null) {
                OffsetFetchNextTest.assertStatementError(sqlState, stmt, text);
                continue;
            }
            this.queryAndCheck(stmt, text, expectedResults);
        }
    }

    private String[] makeVariants(String stub, String fetchFormat, String offset, String fetchFirst) throws Exception {
        String[] result = new String[]{this.makeSQLStandardText(stub, fetchFormat, offset, fetchFirst), this.makeJDBCText(stub, offset, fetchFirst)};
        return result;
    }

    private String makeSQLStandardText(String stub, String fetchFormat, String offset, String fetchFirst) throws Exception {
        String sqlStandardText = "";
        if (offset != null) {
            sqlStandardText = " offset " + offset + " rows ";
        }
        if (fetchFirst != null) {
            sqlStandardText = sqlStandardText + this.substitute(fetchFormat, PERCENT_TOKEN, fetchFirst);
        }
        sqlStandardText = this.substitute(stub, PERCENT_TOKEN, sqlStandardText);
        OffsetFetchNextTest.println(sqlStandardText);
        return sqlStandardText;
    }

    private String makeJDBCText(String stub, String offset, String fetchFirst) throws Exception {
        String jdbcText = "";
        if (offset != null) {
            jdbcText = " offset " + offset;
        }
        jdbcText = fetchFirst != null ? " limit " + fetchFirst + " " + jdbcText : "limit 0 " + jdbcText;
        jdbcText = this.substitute(stub, PERCENT_TOKEN, " { " + jdbcText + " } ");
        OffsetFetchNextTest.println(jdbcText);
        return jdbcText;
    }

    private String substitute(String stub, String token, int replacement) throws Exception {
        return this.substitute(stub, token, Integer.toString(replacement));
    }

    private String substitute(String stub, String token, String replacement) throws Exception {
        int substitutionIndex = stub.indexOf(token);
        if (substitutionIndex < 0) {
            OffsetFetchNextTest.fail((String)("Bad stub: " + stub + ". Can't find token: " + token));
        }
        String prefix = stub.substring(0, substitutionIndex);
        String suffix = substitutionIndex == stub.length() - 1 ? "" : stub.substring(substitutionIndex + 1, stub.length());
        return prefix + replacement + suffix;
    }

    private void queryAndCheck(Statement stm, String queryText, String[][] expectedRows) throws SQLException {
        ResultSet rs = stm.executeQuery(queryText);
        JDBC.assertFullResultSet(rs, expectedRows);
    }
}

