/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class JoinTest
extends BaseJDBCTestCase {
    private static final String SYNTAX_ERROR = "42X01";
    private static final String AMBIGUOUS_COLNAME = "42X03";
    private static final String COLUMN_NOT_IN_SCOPE = "42X04";
    private static final String NON_COMPARABLE = "42818";
    private static final String NO_COLUMNS = "42X81";
    private static final String TABLE_NAME_NOT_IN_SCOPE = "42X10";
    private static final String VALUES_WITH_NULL = "42X07";

    public JoinTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(JoinTest.class);
    }

    public void testNullabilityInValues() throws SQLException {
        Statement s = this.createStatement();
        JoinTest.assertStatementError(VALUES_WITH_NULL, s, "select a.* from (values (null)) a left outer join (values ('a')) b on 1=1");
        JoinTest.assertStatementError(VALUES_WITH_NULL, s, "select a.* from (values (null)) a");
        String[][] expectedResult = new String[][]{{"a"}, {"a"}, {"b"}, {"b"}, {null}, {null}};
        JDBC.assertUnorderedResultSet(s.executeQuery("select a.* from (values ('a'),('b'),(cast(null as char(1)))) a left outer join (values ('c'),('d')) b on 1=1"), expectedResult);
    }

    public void testNullabilityInLeftOrRightOuterJoin() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t (c1 int not null, c2 int not null, c3 int)");
        ResultSet rs = s.executeQuery("select * from t t1 left outer join t t2 on 1=1");
        JDBC.assertNullability(rs, new boolean[]{false, false, true, true, true, true});
        JDBC.assertEmpty(rs);
        rs = s.executeQuery("select * from t t1 right outer join t t2 on 1=1");
        JDBC.assertNullability(rs, new boolean[]{true, true, true, false, false, true});
        JDBC.assertEmpty(rs);
        rs = s.executeQuery("select cast(t1.c1 as int), cast(t2.c2 as int) from t t1 left outer join t t2 on 1=1");
        JDBC.assertNullability(rs, new boolean[]{false, true});
        JDBC.assertEmpty(rs);
        rs = s.executeQuery("select cast(t1.c1 as int), cast(t2.c2 as int) from t t1 right outer join t t2 on 1=1");
        JDBC.assertNullability(rs, new boolean[]{true, false});
        JDBC.assertEmpty(rs);
        rs = s.executeQuery("select t1.c1, t2.c1, t3.c1 from t t1 left join (t t2 left join t t3 on 1=1) on 1=1");
        JDBC.assertNullability(rs, new boolean[]{false, true, true});
        JDBC.assertEmpty(rs);
        rs = s.executeQuery("select t1.c1, t2.c1, t3.c1 from t t1 right join (t t2 right join t t3 on 1=1) on 1=1");
        JDBC.assertNullability(rs, new boolean[]{true, true, false});
        JDBC.assertEmpty(rs);
        rs = s.executeQuery("select t1.c1, t2.c1, t3.c1, t4.c1 from (t t1 left join t t2 on 1=1) left join (t t3 left join t t4 on 1=1) on 1=1");
        JDBC.assertNullability(rs, new boolean[]{false, true, true, true});
        JDBC.assertEmpty(rs);
        rs = s.executeQuery("select t1.c1, t2.c1, t3.c1, t4.c1 from (t t1 left join t t2 on 1=1) right join (t t3 left join t t4 on 1=1) on 1=1");
        JDBC.assertNullability(rs, new boolean[]{true, true, false, true});
        JDBC.assertEmpty(rs);
        rs = s.executeQuery("select t1.c1, t2.c1, t3.c1, t4.c1 from (t t1 right join t t2 on 1=1) left join (t t3 left join t t4 on 1=1) on 1=1");
        JDBC.assertNullability(rs, new boolean[]{true, false, true, true});
        JDBC.assertEmpty(rs);
    }

    public void testDerby4372() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table d4372_1 (a int, b int)");
        s.execute("create table d4372_2 (c int)");
        s.execute("insert into d4372_1 values (1,1),(null,1),(1,null),(2,2),(2,null),(null,2),(3,3),(null,3),(3,null),(null,null)");
        s.execute("insert into d4372_2 values (1), (3)");
        String[][] expectedJoinResult = new String[][]{{"1", "1", "1"}, {null, "1", "1"}, {"1", null, "1"}, {"3", "3", "3"}, {null, "3", "3"}, {"3", null, "3"}};
        PreparedStatement ps = this.prepareStatement("select * from d4372_1 join d4372_2 on c in (a, b)");
        JDBC.assertUnorderedResultSet(ps.executeQuery(), expectedJoinResult);
        s.execute("create index d4372_idx on d4372_2(c)");
        JDBC.assertUnorderedResultSet(ps.executeQuery(), expectedJoinResult);
        s.execute("drop table d4372_1");
        s.execute("drop table d4372_2");
    }

    public void testCrossJoins() throws SQLException {
        this.setAutoCommit(false);
        String[][] T1 = new String[][]{{"1", "one"}, {"2", "two"}, {"3", null}, {"5", "five"}, {"6", "six"}};
        String[][] T2 = new String[][]{{"1", null}, {"2", "II"}, {"4", "IV"}};
        Statement s = this.createStatement();
        s.execute("create table t1(c1 int, c2 varchar(10))");
        this.fillTable("insert into t1 values (?,?)", T1);
        s.execute("create table t2(c1 int, c2 varchar(10))");
        this.fillTable("insert into t2 values (?,?)", T2);
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 cross join t2"), JoinTest.cross(T1, T2));
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 cross join t1 USING(c1)");
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 a cross join t1 b"), JoinTest.cross(T1, T1));
        JDBC.assertUnorderedResultSet(s.executeQuery("select t2.*, t1.* from t1 cross join t2"), JoinTest.cross(T2, T1));
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 cross join t2 cross join t1 t3"), JoinTest.cross(T1, JoinTest.cross(T2, T1)));
        JDBC.assertUnorderedResultSet(s.executeQuery("select t1.c2 from t1 cross join t2"), JoinTest.project(new int[]{1}, JoinTest.cross(T1, T2)));
        JDBC.assertUnorderedResultSet(s.executeQuery("select t1.c1, t2.c2, t2.c2 from t1 cross join t2"), JoinTest.project(new int[]{0, 3, 3}, JoinTest.cross(T1, T2)));
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from t1 cross join t2"), Integer.toString(T1.length * T2.length));
        String[][] expectedInnerJoin = new String[][]{{"1", "one", "1", null}, {"2", "two", "2", "II"}};
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 cross join t2 where t1.c1=t2.c1"), expectedInnerJoin);
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 inner join t2 on t1.c1=t2.c1"), expectedInnerJoin);
        JDBC.assertFullResultSet(s.executeQuery("select * from t1 cross join t2 order by t1.c1 desc"), JoinTest.reverse(JoinTest.cross(T1, T2)));
        JDBC.assertFullResultSet(s.executeQuery("select t1.c1, count(t1.c2) from t1 cross join t2 group by t1.c1 order by t1.c1"), new String[][]{{"1", "3"}, {"2", "3"}, {"3", "0"}, {"5", "3"}, {"6", "3"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from (values 1,2) v1 cross join (values 'a','b') v2"), new String[][]{{"1", "a"}, {"1", "b"}, {"2", "a"}, {"2", "b"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 a cross join t2 b inner join t2 c on 1=1"), JoinTest.cross(T1, JoinTest.cross(T2, T2)));
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 a inner join t2 b on 1=1 cross join t2 c"), JoinTest.cross(T1, JoinTest.cross(T2, T2)));
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 a inner join (t2 b cross join t2 c) on 1=1"), JoinTest.cross(T1, JoinTest.cross(T2, T2)));
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 a inner join t2 b cross join t2 c on 1=1"), JoinTest.cross(T1, JoinTest.cross(T2, T2)));
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from t2 a cross join t1 b right join t2 c on a.c1=c.c1"), Integer.toString(T1.length * T2.length));
        String[][] expectedCorrectlyNested = new String[][]{{null, null, null, null, "4", "IV"}};
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t2 a cross join t1 b right join t2 c on b.c1=c.c1 where c.c1=4"), expectedCorrectlyNested);
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from (t2 a cross join t1 b) right join t2 c on b.c1=c.c1 where c.c1=4"), expectedCorrectlyNested);
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t2 a cross join (t1 b right join t2 c on b.c1=c.c1) where c.c1=4"), new String[][]{{"1", null, null, null, "4", "IV"}, {"2", "II", null, null, "4", "IV"}, {"4", "IV", null, null, "4", "IV"}});
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, s, "select * from t1 cross join t1");
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, s, "select c1 from t1 cross join t2");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 cross join t2 on t1.c1 = t2.c2");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 inner join t2 cross join t2 t3");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 left join t2 cross join t2 t3");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 right join t2 cross join t2 t3");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 cross join t2 inner join t2 t3");
    }

    private void fillTable(String sql, String[][] data) throws SQLException {
        PreparedStatement ins = this.prepareStatement(sql);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                ins.setString(j + 1, data[i][j]);
            }
            ins.executeUpdate();
        }
        ins.close();
    }

    private static String[][] cross(String[][] t12, String[][] t22) {
        String[][] result = new String[t12.length * t22.length][];
        for (int i = 0; i < result.length; ++i) {
            String[] r1 = t12[i / t22.length];
            String[] r2 = t22[i % t22.length];
            result[i] = new String[r1.length + r2.length];
            System.arraycopy(r1, 0, result[i], 0, r1.length);
            System.arraycopy(r2, 0, result[i], r1.length, r2.length);
        }
        return result;
    }

    private static String[][] project(int[] cols, String[][] rows) {
        String[][] result = new String[rows.length][cols.length];
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < cols.length; ++j) {
                result[i][j] = rows[i][cols[j]];
            }
        }
        return result;
    }

    private static String[][] reverse(String[][] rows) {
        String[][] result = new String[rows.length][];
        for (int i = 0; i < rows.length; ++i) {
            result[i] = rows[rows.length - 1 - i];
        }
        return result;
    }

    public void testUsingClause() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t1(a int, b int, c int)");
        s.execute("create table t2(b int, c int, d int)");
        s.execute("create table t3(d int, e varchar(5), f int)");
        s.execute("insert into t1 values (1,2,3),(2,3,4),(4,4,4)");
        s.execute("insert into t2 values (1,2,3),(2,3,4),(5,5,5)");
        s.execute("insert into t3 values (2,'abc',3),(4,'def',5),(null,null,null)");
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 join t2 using (b)"), new String[][]{{"2", "1", "3", "3", "4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 inner join t2 using (b)"), new String[][]{{"2", "1", "3", "3", "4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 left join t2 using (b)"), new String[][]{{"2", "1", "3", "3", "4"}, {"3", "2", "4", null, null}, {"4", "4", "4", null, null}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 left outer join t2 using (b)"), new String[][]{{"2", "1", "3", "3", "4"}, {"3", "2", "4", null, null}, {"4", "4", "4", null, null}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 right join t2 using (b)"), new String[][]{{"2", "1", "3", "3", "4"}, {"1", null, null, "2", "3"}, {"5", null, null, "5", "5"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 right outer join t2 using (b)"), new String[][]{{"2", "1", "3", "3", "4"}, {"1", null, null, "2", "3"}, {"5", null, null, "5", "5"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 join t2 using (b, c)"), new String[][]{{"2", "3", "1", "4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 join t2 using (c, b)"), new String[][]{{"3", "2", "1", "4"}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select t1.* from t1 join t2 using (b, c)"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select t2.* from t1 join t2 using (b, c)"), "4");
        JDBC.assertUnorderedResultSet(s.executeQuery("select t1.*, t2.* from t1 join t2 using (b, c)"), new String[][]{{"1", "4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select t1.* from t1 left join t2 using (b, c)"), new String[][]{{"1"}, {"2"}, {"4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select t1.* from t1 right join t2 using (b, c)"), new String[][]{{"1"}, {null}, {null}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select t3.e from t1 join t2 using (b) join t3 using (d)"), "def");
        JDBC.assertSingleValueResultSet(s.executeQuery("select t3.e from t1 join t2 join t3 using (d) using (b)"), "def");
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 left join t2 using (b) right join t3 using (d)"), new String[][]{{"2", null, null, null, null, "abc", "3"}, {"4", "2", "1", "3", "3", "def", "5"}, {null, null, null, null, null, null, null}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 left join t2 right join t3 using (d) using (b)"), new String[][]{{"2", "1", "3", "4", "3", "def", "5"}, {"3", "2", "4", null, null, null, null}, {"4", "4", "4", null, null, null, null}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select a from t1 join t2 using (b, c)"), "1");
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 join t2 using (\"B\")"), new String[][]{{"2", "1", "3", "3", "4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select b from t1 left join t2 using (b)"), new String[][]{{"2"}, {"3"}, {"4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select b from t1 right join t2 using (b)"), new String[][]{{"1"}, {"2"}, {"5"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select d, t2.d, t3.d from t2 left join t3 using (d)"), new String[][]{{"3", "3", null}, {"4", "4", "4"}, {"5", "5", null}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select d, t2.d, t3.d from t2 right join t3 using (d)"), new String[][]{{"2", null, "2"}, {"4", "4", "4"}, {null, null, null}});
        JDBC.assertEmpty(s.executeQuery("select * from t2 left join t3 using (d) where d is null"));
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t2 right join t3 using (d) where d is null"), new String[][]{{null, null, null, null, null}});
        JDBC.assertFullResultSet(s.executeQuery("select c from t1 left join t2 using (b, c) order by c desc nulls last"), new String[][]{{"4"}, {"4"}, {"3"}});
        JDBC.assertFullResultSet(s.executeQuery("select c from t1 left join t2 using (b, c) order by t1.c desc nulls last"), new String[][]{{"4"}, {"4"}, {"3"}});
        JDBC.assertFullResultSet(s.executeQuery("select c from t1 left join t2 using (b, c) order by t2.c desc nulls last"), new String[][]{{"3"}, {"4"}, {"4"}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select c from t1 right join t2 using (b, c) order by c desc nulls last fetch next row only"), "5");
        JDBC.assertSingleValueResultSet(s.executeQuery("select c from t1 right join t2 using (b, c) order by t1.c desc nulls last fetch next row only"), "3");
        JDBC.assertSingleValueResultSet(s.executeQuery("select c from t1 right join t2 using (b, c) order by t2.c desc nulls last fetch next row only"), "5");
        JDBC.assertFullResultSet(s.executeQuery("select b, count(t2.b) from t1 left join t2 using (b) group by b order by b"), new String[][]{{"2", "1"}, {"3", "0"}, {"4", "0"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 table_a(col1, col2, col3) inner join t3 table_b(col1, col2, col3) using (col1)"), new String[][]{{"2", "3", "4", "abc", "3"}, {"4", "4", "4", "def", "5"}});
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, s, "select b from t1 join t2 using (b) join t3 using(c)");
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, s, "select b from t1 join t2 using (c)");
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, s, "select * from t1 join t2 using (b) order by c");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 join t2 using (t1.b)");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 join t2 using b");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 join t2 using ()");
        JoinTest.assertStatementError(NON_COMPARABLE, s, "select * from t2 a(x,y,z) join t3 b(x,y,z) using(y)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, s, "select t3.e from t1 join t2 join t3 using (b) using (d)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, s, "select * from t1 join t2 using (a)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, s, "select * from t1 join t2 using (d)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, s, "select * from t1 join t2 using (a,d)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, s, "select * from t1 join t2 using (a,b,c)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, s, "select * from t1 join t2 using (x)");
        JoinTest.assertStatementError(COLUMN_NOT_IN_SCOPE, s, "select * from t1 join t2 using (b,c,x)");
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, s, "select * from (t1 cross join t2) join t2 tt2 using(b)");
        JoinTest.assertStatementError(NO_COLUMNS, s, "select x.* from t1 x inner join t1 y using (a,b,c)");
        JoinTest.assertStatementError(NO_COLUMNS, s, "select x.* from t1 x left join t1 y using (a,b,c)");
        JoinTest.assertStatementError(NO_COLUMNS, s, "select x.* from t1 x right join t1 y using (a,b,c)");
        JoinTest.assertStatementError(NO_COLUMNS, s, "select x.*, y.* from t1 x inner join t1 y using (a, b, c)");
        JoinTest.assertStatementError(TABLE_NAME_NOT_IN_SCOPE, s, "select xyz.* from t1 join t2 using (b)");
    }

    public void testNaturalJoin() throws SQLException {
        this.setAutoCommit(false);
        String[][] T1 = new String[][]{{"1", "2", "3"}, {"4", "5", "6"}, {"7", "8", "9"}};
        String[][] T2 = new String[][]{{"4", "3", "2"}, {"1", "2", "3"}, {"3", "2", "1"}};
        String[][] T3 = new String[][]{{"4", "100"}};
        Statement s = this.createStatement();
        s.execute("create table t1(a int, b int, c int)");
        s.execute("create table t2(d int, c int, b int)");
        s.execute("create table t3(d int, e int)");
        this.fillTable("insert into t1 values (?,?,?)", T1);
        this.fillTable("insert into t2 values (?,?,?)", T2);
        this.fillTable("insert into t3 values (?,?)", T3);
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t2 natural join t3"), new String[][]{{"4", "3", "2", "100"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t3 natural join t2"), new String[][]{{"4", "100", "3", "2"}});
        ResultSet rs = s.executeQuery("select * from t1 natural join t2");
        JDBC.assertColumnNames(rs, new String[]{"B", "C", "A", "D"});
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"2", "3", "1", "4"}});
        rs = s.executeQuery("select * from t2 natural join t1");
        JDBC.assertColumnNames(rs, new String[]{"C", "B", "D", "A"});
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"3", "2", "4", "1"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 natural join t3"), JoinTest.cross(T1, T3));
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 as a(c1, c2, c3) natural join t2 as b(c4, c5, c6)"), JoinTest.cross(T1, T2));
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from (values 1,2) v1(x) natural join (values 'a','b') v2(y)"), new String[][]{{"1", "a"}, {"1", "b"}, {"2", "a"}, {"2", "b"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from (select * from t1) table1 natural join (select * from t2) table2"), new String[][]{{"2", "3", "1", "4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from (select b+c from t1) as x natural join (select b+c from t2) as y"), JoinTest.cross(new String[][]{{"5"}, {"11"}, {"17"}}, new String[][]{{"5"}, {"5"}, {"3"}}));
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from (select b+c c1 from t1) as x natural join (select b+c c1 from t2) as y"), new String[][]{{"5"}, {"5"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 natural join t2 natural join t3"), new String[][]{{"4", "2", "3", "1", "100"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from (t1 natural join t2) natural join t3"), new String[][]{{"4", "2", "3", "1", "100"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 natural join (t2 natural join t3)"), new String[][]{{"2", "3", "1", "4", "100"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 natural join t2 cross join t3"), new String[][]{{"2", "3", "1", "4", "4", "100"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 natural join t2 inner join t3 on 1=1"), new String[][]{{"2", "3", "1", "4", "4", "100"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 cross join t2 natural join t3"), new String[][]{{"4", "1", "2", "3", "3", "2", "100"}, {"4", "4", "5", "6", "3", "2", "100"}, {"4", "7", "8", "9", "3", "2", "100"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 inner join t2 on 1=1 natural join t3"), new String[][]{{"4", "1", "2", "3", "3", "2", "100"}, {"4", "4", "5", "6", "3", "2", "100"}, {"4", "7", "8", "9", "3", "2", "100"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 inner join t2 natural join t3 on 1=1"), new String[][]{{"1", "2", "3", "4", "3", "2", "100"}, {"4", "5", "6", "4", "3", "2", "100"}, {"7", "8", "9", "4", "3", "2", "100"}});
        s.execute("create table insert_src (c1 int, c2 int, c3 int, c4 int)");
        s.execute("insert into insert_src select * from t1 natural join t2");
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from insert_src"), new String[][]{{"2", "3", "1", "4"}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select t1.* from t1 natural join t2"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select t2.* from t1 natural join t2"), "4");
        JDBC.assertUnorderedResultSet(s.executeQuery("select t1.*, t2.* from t1 natural join t2"), new String[][]{{"1", "4"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 natural inner join t2"), new String[][]{{"2", "3", "1", "4"}});
        String[][] ljRows = new String[][]{{"2", "3", "1", "4"}, {"5", "6", "4", null}, {"8", "9", "7", null}};
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 natural left join t2"), ljRows);
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 natural left outer join t2"), ljRows);
        JDBC.assertUnorderedResultSet(s.executeQuery("select b, t1.b, t2.b from t1 natural left join t2"), new String[][]{{"2", "2", "2"}, {"5", "5", null}, {"8", "8", null}});
        String[][] rjRows = new String[][]{{"1", "2", null, "3"}, {"2", "3", "1", "4"}, {"3", "2", null, "1"}};
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 natural right join t2"), rjRows);
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 natural right outer join t2"), rjRows);
        JDBC.assertUnorderedResultSet(s.executeQuery("select b, t1.b, t2.b from t1 natural right join t2"), new String[][]{{"1", null, "1"}, {"2", "2", "2"}, {"3", null, "3"}});
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 natural join t2 on t1.b=t2.b");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 natural join t2 using (b)");
        JoinTest.assertStatementError(SYNTAX_ERROR, s, "select * from t1 natural cross join t2");
        JoinTest.assertStatementError(AMBIGUOUS_COLNAME, s, "select * from t1 t(d,x,y) natural join (t2 cross join t3)");
        JoinTest.assertStatementError(NO_COLUMNS, s, "select x.* from t1 x natural join t1 y");
        JoinTest.assertStatementError(NO_COLUMNS, s, "select y.* from t1 x natural join t1 y");
        JoinTest.assertStatementError(NO_COLUMNS, s, "select x.*, y.* from t1 x natural join t1 y");
        JoinTest.assertStatementError(NON_COMPARABLE, s, "select * from t1 natural join (values ('one', 'two')) v1(a,b)");
    }

    public void testSubqueryInON() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t1(a int)");
        s.execute("insert into t1 values 1,2,3");
        s.execute("create table t2(b int)");
        s.execute("insert into t2 values 1,2");
        s.execute("create table t3(c int)");
        s.execute("insert into t3 values 2,3");
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 join t2 on a = some (select c from t3)"), new String[][]{{"2", "1"}, {"2", "2"}, {"3", "1"}, {"3", "2"}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t1 left join t2 on a = b and b not in (select c from t3)"), new String[][]{{"1", "1"}, {"2", null}, {"3", null}});
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from t3 join t2 on exists (select * from t2 join t1 on exists (select * from t3 where c = a))"), new String[][]{{"2", "1"}, {"2", "2"}, {"3", "1"}, {"3", "2"}});
        JDBC.assertSingleValueResultSet(s.executeQuery("select a from t1 join t2 on a = (select count(*) from t3) and a = b"), "2");
        JDBC.assertEmpty(s.executeQuery("select * from t1 join t2 on exists (select * from t3 x left join t3 y on 1=0 where y.c=1)"));
    }

    public void testDerby4387() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("create table c (a int, b int, c int)");
        s.executeUpdate("create table cc (aa int)");
        ResultSet rs = s.executeQuery("select * from cc t1, c t2, cc t3     where t3.aa = t2.a and           t3.aa = t2.b and           t3.aa = t2.c");
        this.rollback();
    }

    public void testDerby_4405() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("CREATE TABLE COUNTRIES(COUNTRY VARCHAR(26) UNIQUE NOT NULL,COUNTRY_ISO_CODE CHAR(2) PRIMARY KEY NOT NULL)");
        s.execute("CREATE TABLE CITIES(CITY_ID INTEGER primary key NOT NULL ,COUNTRY VARCHAR(26) NOT NULL,AIRPORT VARCHAR(3))");
        s.execute("CREATE TABLE FLIGHTS(FLIGHT_ID CHAR(6) NOT NULL ,ORIG_AIRPORT CHAR(3),PRIMARY KEY (FLIGHT_ID))");
        s.execute("CREATE INDEX ORIGINDEX ON FLIGHTS (ORIG_AIRPORT)");
        PreparedStatement ps = this.getConnection().prepareStatement("insert into COUNTRIES values ( ?,? )");
        JoinTest.insertTourRow(ps, "Afghanistan", "AF");
        JoinTest.insertTourRow(ps, "Albania", "AL");
        JoinTest.insertTourRow(ps, "Algeria", "DZ");
        JoinTest.insertTourRow(ps, "American Samoa", "AS");
        JoinTest.insertTourRow(ps, "Angola", "AO");
        JoinTest.insertTourRow(ps, "Argentina", "AR");
        JoinTest.insertTourRow(ps, "Armenia", "AM");
        JoinTest.insertTourRow(ps, "Australia", "AU");
        JoinTest.insertTourRow(ps, "Austria", "AT");
        JoinTest.insertTourRow(ps, "Azerbaijan", "AZ");
        JoinTest.insertTourRow(ps, "Bahamas", "BS");
        JoinTest.insertTourRow(ps, "Bangladesh", "BD");
        JoinTest.insertTourRow(ps, "Barbados", "BB");
        JoinTest.insertTourRow(ps, "Belgium", "BE");
        JoinTest.insertTourRow(ps, "Belize", "BZ");
        JoinTest.insertTourRow(ps, "Bermuda", "BM");
        JoinTest.insertTourRow(ps, "Bolivia", "BO");
        JoinTest.insertTourRow(ps, "Botswana", "BW");
        JoinTest.insertTourRow(ps, "Brazil", "BR");
        JoinTest.insertTourRow(ps, "Bulgaria", "BG");
        JoinTest.insertTourRow(ps, "Cambodia", "KH");
        JoinTest.insertTourRow(ps, "Cameroon", "CM");
        JoinTest.insertTourRow(ps, "Canada", "CA");
        JoinTest.insertTourRow(ps, "Cape Verde", "CV");
        JoinTest.insertTourRow(ps, "Chile", "CL");
        JoinTest.insertTourRow(ps, "China", "CN");
        JoinTest.insertTourRow(ps, "Colombia", "CO");
        JoinTest.insertTourRow(ps, "Congo", "CG");
        JoinTest.insertTourRow(ps, "Costa Rica", "CR");
        JoinTest.insertTourRow(ps, "Cote d'Ivoire", "CI");
        JoinTest.insertTourRow(ps, "Cuba", "CU");
        JoinTest.insertTourRow(ps, "Czech Republic", "CZ");
        JoinTest.insertTourRow(ps, "Denmark", "DK");
        JoinTest.insertTourRow(ps, "Dominical Republic", "DO");
        JoinTest.insertTourRow(ps, "Ecuador", "EC");
        JoinTest.insertTourRow(ps, "Egypt", "EG");
        JoinTest.insertTourRow(ps, "El Salvador", "SV");
        JoinTest.insertTourRow(ps, "Ethiopia", "ET");
        JoinTest.insertTourRow(ps, "Falkland Islands", "FK");
        JoinTest.insertTourRow(ps, "Fiji", "FJ");
        JoinTest.insertTourRow(ps, "Finland", "FI");
        JoinTest.insertTourRow(ps, "France", "FR");
        JoinTest.insertTourRow(ps, "Georgia", "GE");
        JoinTest.insertTourRow(ps, "Germany", "DE");
        JoinTest.insertTourRow(ps, "Ghana", "GH");
        JoinTest.insertTourRow(ps, "Greece", "GR");
        JoinTest.insertTourRow(ps, "Guadeloupe", "GP");
        JoinTest.insertTourRow(ps, "Guatemala", "GT");
        JoinTest.insertTourRow(ps, "Honduras", "HN");
        JoinTest.insertTourRow(ps, "Hungary", "HU");
        JoinTest.insertTourRow(ps, "Iceland", "IS");
        JoinTest.insertTourRow(ps, "India", "IN");
        JoinTest.insertTourRow(ps, "Indonesia", "ID");
        JoinTest.insertTourRow(ps, "Iran", "IR");
        JoinTest.insertTourRow(ps, "Iraq", "IQ");
        JoinTest.insertTourRow(ps, "Ireland", "IE");
        JoinTest.insertTourRow(ps, "Israel", "IL");
        JoinTest.insertTourRow(ps, "Italy", "IT");
        JoinTest.insertTourRow(ps, "Jamaica", "JM");
        JoinTest.insertTourRow(ps, "Japan", "JP");
        JoinTest.insertTourRow(ps, "Jordan", "JO");
        JoinTest.insertTourRow(ps, "Kenya", "KE");
        JoinTest.insertTourRow(ps, "Lebanon", "LB");
        JoinTest.insertTourRow(ps, "Lithuania", "LT");
        JoinTest.insertTourRow(ps, "Madagascar", "MG");
        JoinTest.insertTourRow(ps, "Malaysia", "MY");
        JoinTest.insertTourRow(ps, "Mali", "ML");
        JoinTest.insertTourRow(ps, "Mexico", "MX");
        JoinTest.insertTourRow(ps, "Morocco", "MA");
        JoinTest.insertTourRow(ps, "Mozambique", "MZ");
        JoinTest.insertTourRow(ps, "Nepal", "NP");
        JoinTest.insertTourRow(ps, "Netherlands", "NL");
        JoinTest.insertTourRow(ps, "New Zealand", "NZ");
        JoinTest.insertTourRow(ps, "Nicaragua", "NI");
        JoinTest.insertTourRow(ps, "Nigeria", "NG");
        JoinTest.insertTourRow(ps, "Norway", "NO");
        JoinTest.insertTourRow(ps, "Pakistan", "PK");
        JoinTest.insertTourRow(ps, "Paraguay", "PY");
        JoinTest.insertTourRow(ps, "Peru", "PE");
        JoinTest.insertTourRow(ps, "Philippines", "PH");
        JoinTest.insertTourRow(ps, "Poland", "PL");
        JoinTest.insertTourRow(ps, "Portugal", "PT");
        JoinTest.insertTourRow(ps, "Russia", "RU");
        JoinTest.insertTourRow(ps, "Samoa", "WS");
        JoinTest.insertTourRow(ps, "Senegal", "SN");
        JoinTest.insertTourRow(ps, "Sierra Leone", "SL");
        JoinTest.insertTourRow(ps, "Singapore", "SG");
        JoinTest.insertTourRow(ps, "Slovakia", "SK");
        JoinTest.insertTourRow(ps, "South Africa", "ZA");
        JoinTest.insertTourRow(ps, "Spain", "ES");
        JoinTest.insertTourRow(ps, "Sri Lanka", "LK");
        JoinTest.insertTourRow(ps, "Sudan", "SD");
        JoinTest.insertTourRow(ps, "Sweden", "SE");
        JoinTest.insertTourRow(ps, "Switzerland", "CH");
        JoinTest.insertTourRow(ps, "Syrian Arab Republic", "SY");
        JoinTest.insertTourRow(ps, "Tajikistan", "TJ");
        JoinTest.insertTourRow(ps, "Tanzania", "TZ");
        JoinTest.insertTourRow(ps, "Thailand", "TH");
        JoinTest.insertTourRow(ps, "Trinidad and Tobago", "TT");
        JoinTest.insertTourRow(ps, "Tunisia", "TN");
        JoinTest.insertTourRow(ps, "Turkey", "TR");
        JoinTest.insertTourRow(ps, "Ukraine", "UA");
        JoinTest.insertTourRow(ps, "United Kingdom", "GB");
        JoinTest.insertTourRow(ps, "United States", "US");
        JoinTest.insertTourRow(ps, "Uruguay", "UY");
        JoinTest.insertTourRow(ps, "Uzbekistan", "UZ");
        JoinTest.insertTourRow(ps, "Venezuela", "VE");
        JoinTest.insertTourRow(ps, "Viet Nam", "VN");
        JoinTest.insertTourRow(ps, "Virgin Islands (British)", "VG");
        JoinTest.insertTourRow(ps, "Virgin Islands (U.S.)", "VI");
        JoinTest.insertTourRow(ps, "Yugoslavia", "YU");
        JoinTest.insertTourRow(ps, "Zaire", "ZR");
        JoinTest.insertTourRow(ps, "Zimbabwe", "ZW");
        ps = this.getConnection().prepareStatement("insert into CITIES VALUES (?,?,?)");
        JoinTest.insertTourRow(ps, 1, "Netherlands", "AMS");
        JoinTest.insertTourRow(ps, 2, "Greece", "ATH");
        JoinTest.insertTourRow(ps, 3, "New Zealand", "AKL");
        JoinTest.insertTourRow(ps, 4, "Lebanon", "BEY");
        JoinTest.insertTourRow(ps, 5, "Colombia", "BOG");
        JoinTest.insertTourRow(ps, 6, "India", "BOM");
        JoinTest.insertTourRow(ps, 7, "Hungary", "BUD");
        JoinTest.insertTourRow(ps, 8, "Argentina", "BUE");
        JoinTest.insertTourRow(ps, 9, "Egypt", "CAI");
        JoinTest.insertTourRow(ps, 10, "India", "CCU");
        JoinTest.insertTourRow(ps, 11, "South Africa", "CPT");
        JoinTest.insertTourRow(ps, 12, "Venezuela", "CCS");
        JoinTest.insertTourRow(ps, 13, "Morocco", "CAS");
        JoinTest.insertTourRow(ps, 14, "Denmark", "CPH");
        JoinTest.insertTourRow(ps, 15, "Ireland", "DUB");
        JoinTest.insertTourRow(ps, 16, "Switzerland", "GVA");
        JoinTest.insertTourRow(ps, 17, "China", "HKG");
        JoinTest.insertTourRow(ps, 18, "Turkey", "IST");
        JoinTest.insertTourRow(ps, 19, "Indonesia", "JKT");
        JoinTest.insertTourRow(ps, 20, "Afghanistan", "KBL");
        JoinTest.insertTourRow(ps, 21, "Pakistan", "KHI");
        JoinTest.insertTourRow(ps, 22, "Nigeria", "LOS");
        JoinTest.insertTourRow(ps, 23, "Peru", "LIM");
        JoinTest.insertTourRow(ps, 24, "Portugal", "LIS");
        JoinTest.insertTourRow(ps, 25, "United Kingdom", "LHR");
        JoinTest.insertTourRow(ps, 26, "Spain", "MAD");
        JoinTest.insertTourRow(ps, 27, "Philippines", "MNL");
        JoinTest.insertTourRow(ps, 28, "Australia", "MEL");
        JoinTest.insertTourRow(ps, 29, "Mexico", "MEX");
        JoinTest.insertTourRow(ps, 30, "Canada", "YUL");
        JoinTest.insertTourRow(ps, 31, "Russia", "SVO");
        JoinTest.insertTourRow(ps, 32, "Kenya", "NBO");
        JoinTest.insertTourRow(ps, 33, "Japan", "OSA");
        JoinTest.insertTourRow(ps, 34, "Norway", "OSL");
        JoinTest.insertTourRow(ps, 35, "France", "CDG");
        JoinTest.insertTourRow(ps, 36, "Czech Republic", "PRG");
        JoinTest.insertTourRow(ps, 37, "Iceland", "REY");
        JoinTest.insertTourRow(ps, 38, "Brazil", "GIG");
        JoinTest.insertTourRow(ps, 39, "Italy", "FCO");
        JoinTest.insertTourRow(ps, 40, "Chile", "SCL");
        JoinTest.insertTourRow(ps, 41, "Brazil", "GRU");
        JoinTest.insertTourRow(ps, 43, "China", "SHA");
        JoinTest.insertTourRow(ps, 44, "Singapore", "SIN");
        JoinTest.insertTourRow(ps, 45, "Sweden", "ARN");
        JoinTest.insertTourRow(ps, 46, "Australia", "SYD");
        JoinTest.insertTourRow(ps, 47, "United States", "SJC");
        JoinTest.insertTourRow(ps, 48, "Iran", "THR");
        JoinTest.insertTourRow(ps, 49, "Japan", "NRT");
        JoinTest.insertTourRow(ps, 50, "Canada", "YYZ");
        JoinTest.insertTourRow(ps, 51, "Poland", "WAW");
        JoinTest.insertTourRow(ps, 52, "United States", "ALB");
        JoinTest.insertTourRow(ps, 53, "United States", "ABQ");
        JoinTest.insertTourRow(ps, 54, "United States", "ATL");
        JoinTest.insertTourRow(ps, 55, "United States", "BOI");
        JoinTest.insertTourRow(ps, 56, "United States", "BOS");
        JoinTest.insertTourRow(ps, 57, "United States", "CHS");
        JoinTest.insertTourRow(ps, 58, "United States", "MDW");
        JoinTest.insertTourRow(ps, 59, "United States", "CLE");
        JoinTest.insertTourRow(ps, 60, "United States", "DFW");
        JoinTest.insertTourRow(ps, 61, "United States", "DEN");
        JoinTest.insertTourRow(ps, 62, "United States", "DSM");
        JoinTest.insertTourRow(ps, 63, "United States", "FAI");
        JoinTest.insertTourRow(ps, 64, "United States", "HLN");
        JoinTest.insertTourRow(ps, 65, "United States", "HNL");
        JoinTest.insertTourRow(ps, 66, "United States", "HOU");
        JoinTest.insertTourRow(ps, 67, "United States", "JNU");
        JoinTest.insertTourRow(ps, 68, "United States", "MCI");
        JoinTest.insertTourRow(ps, 69, "United States", "LAX");
        JoinTest.insertTourRow(ps, 70, "United States", "MEM");
        JoinTest.insertTourRow(ps, 71, "United States", "MIA");
        JoinTest.insertTourRow(ps, 72, "United States", "MKE");
        JoinTest.insertTourRow(ps, 73, "United States", "MSP");
        JoinTest.insertTourRow(ps, 74, "United States", "BNA");
        JoinTest.insertTourRow(ps, 75, "United States", "MSY");
        JoinTest.insertTourRow(ps, 76, "United States", "JFK");
        JoinTest.insertTourRow(ps, 77, "United States", "OKC");
        JoinTest.insertTourRow(ps, 78, "United States", "PHL");
        JoinTest.insertTourRow(ps, 79, "United States", "PHX");
        JoinTest.insertTourRow(ps, 80, "United States", "STL");
        JoinTest.insertTourRow(ps, 81, "United States", "SLC");
        JoinTest.insertTourRow(ps, 82, "United States", "SAT");
        JoinTest.insertTourRow(ps, 83, "United States", "SAN");
        JoinTest.insertTourRow(ps, 84, "United States", "SFO");
        JoinTest.insertTourRow(ps, 85, "United States", "SJU");
        JoinTest.insertTourRow(ps, 86, "United States", "SEA");
        JoinTest.insertTourRow(ps, 87, "United States", "IAD");
        ps = this.getConnection().prepareStatement("insert into FLIGHTS values (?,?)");
        JoinTest.insertTourRow(ps, "AA1111", "ABQ");
        JoinTest.insertTourRow(ps, "AA1112", "LAX");
        JoinTest.insertTourRow(ps, "AA1113", "ABQ");
        JoinTest.insertTourRow(ps, "AA1114", "PHX");
        JoinTest.insertTourRow(ps, "AA1115", "ABQ");
        JoinTest.insertTourRow(ps, "AA1116", "OKC");
        JoinTest.insertTourRow(ps, "AA1117", "AKL");
        JoinTest.insertTourRow(ps, "AA1118", "HNL");
        JoinTest.insertTourRow(ps, "AA1119", "AKL");
        JoinTest.insertTourRow(ps, "AA1120", "NRT");
        JoinTest.insertTourRow(ps, "AA1121", "AKL");
        JoinTest.insertTourRow(ps, "AA1122", "SYD");
        JoinTest.insertTourRow(ps, "AA1123", "ALB");
        JoinTest.insertTourRow(ps, "AA1124", "JFK");
        JoinTest.insertTourRow(ps, "AA1125", "ALB");
        JoinTest.insertTourRow(ps, "AA1126", "BOS");
        JoinTest.insertTourRow(ps, "AA1127", "ALB");
        JoinTest.insertTourRow(ps, "AA1128", "IAD");
        JoinTest.insertTourRow(ps, "US1517", "AMS");
        JoinTest.insertTourRow(ps, "US1516", "JFK");
        JoinTest.insertTourRow(ps, "AA1131", "AMS");
        JoinTest.insertTourRow(ps, "AA1132", "ATH");
        JoinTest.insertTourRow(ps, "AA1133", "AMS");
        JoinTest.insertTourRow(ps, "AA1134", "CDG");
        JoinTest.insertTourRow(ps, "AA1135", "ARN");
        JoinTest.insertTourRow(ps, "AA1136", "BOS");
        JoinTest.insertTourRow(ps, "AA1137", "ARN");
        JoinTest.insertTourRow(ps, "AA1138", "SVO");
        JoinTest.insertTourRow(ps, "AA1139", "ARN");
        JoinTest.insertTourRow(ps, "AA1140", "CPH");
        JoinTest.insertTourRow(ps, "AA1141", "ATH");
        JoinTest.insertTourRow(ps, "AA1142", "LHR");
        JoinTest.insertTourRow(ps, "AA1143", "ATH");
        JoinTest.insertTourRow(ps, "AA1144", "CAI");
        JoinTest.insertTourRow(ps, "AA1145", "ATH");
        JoinTest.insertTourRow(ps, "AA1146", "CDG");
        JoinTest.insertTourRow(ps, "AA1147", "ATL");
        JoinTest.insertTourRow(ps, "AA1148", "LAX");
        JoinTest.insertTourRow(ps, "AA1149", "ATL");
        JoinTest.insertTourRow(ps, "AA1150", "DFW");
        JoinTest.insertTourRow(ps, "AA1151", "ATL");
        JoinTest.insertTourRow(ps, "AA1152", "SEA");
        JoinTest.insertTourRow(ps, "AA1153", "BEY");
        JoinTest.insertTourRow(ps, "AA1154", "CAI");
        JoinTest.insertTourRow(ps, "AA1270", "BEY");
        JoinTest.insertTourRow(ps, "AA1269", "MAD");
        JoinTest.insertTourRow(ps, "AA1157", "BEY");
        JoinTest.insertTourRow(ps, "AA1158", "BOM");
        JoinTest.insertTourRow(ps, "AA1159", "BNA");
        JoinTest.insertTourRow(ps, "AA1160", "MIA");
        JoinTest.insertTourRow(ps, "AA1161", "BNA");
        JoinTest.insertTourRow(ps, "AA1162", "JFK");
        JoinTest.insertTourRow(ps, "AA1163", "BNA");
        JoinTest.insertTourRow(ps, "AA1164", "GIG");
        JoinTest.insertTourRow(ps, "US1591", "BOG");
        JoinTest.insertTourRow(ps, "AA1190", "MIA");
        JoinTest.insertTourRow(ps, "AA1167", "BOG");
        JoinTest.insertTourRow(ps, "AA1168", "LIM");
        JoinTest.insertTourRow(ps, "AA1169", "BOG");
        JoinTest.insertTourRow(ps, "AA1170", "GIG");
        JoinTest.insertTourRow(ps, "AA1171", "BOI");
        JoinTest.insertTourRow(ps, "AA1172", "SEA");
        JoinTest.insertTourRow(ps, "AA1173", "BOI");
        JoinTest.insertTourRow(ps, "AA1174", "DSM");
        JoinTest.insertTourRow(ps, "AA1175", "BOI");
        JoinTest.insertTourRow(ps, "AA1176", "HLN");
        JoinTest.insertTourRow(ps, "AA1177", "BOM");
        JoinTest.insertTourRow(ps, "AA1178", "CCU");
        JoinTest.insertTourRow(ps, "AA1179", "BOM");
        JoinTest.insertTourRow(ps, "AA1180", "KHI");
        JoinTest.insertTourRow(ps, "AA1181", "BOM");
        JoinTest.insertTourRow(ps, "AA1182", "HKG");
        JoinTest.insertTourRow(ps, "AA1183", "BOS");
        JoinTest.insertTourRow(ps, "AA1184", "SFO");
        JoinTest.insertTourRow(ps, "AA1185", "BOS");
        JoinTest.insertTourRow(ps, "AA1186", "MIA");
        JoinTest.insertTourRow(ps, "AA1187", "BOS");
        JoinTest.insertTourRow(ps, "AA1188", "IAD");
        JoinTest.insertTourRow(ps, "AA1189", "BUD");
        JoinTest.insertTourRow(ps, "AA1191", "BUD");
        JoinTest.insertTourRow(ps, "AA1192", "SVO");
        JoinTest.insertTourRow(ps, "AA1193", "BUD");
        JoinTest.insertTourRow(ps, "AA1194", "FCO");
        JoinTest.insertTourRow(ps, "AA1195", "CAI");
        JoinTest.insertTourRow(ps, "AA1196", "MIA");
        JoinTest.insertTourRow(ps, "AA1197", "CAI");
        JoinTest.insertTourRow(ps, "AA1198", "IST");
        JoinTest.insertTourRow(ps, "AA1199", "CAI");
        JoinTest.insertTourRow(ps, "AA1200", "GIG");
        JoinTest.insertTourRow(ps, "AA1201", "CAS");
        JoinTest.insertTourRow(ps, "AA1202", "KHI");
        JoinTest.insertTourRow(ps, "AA1203", "CAS");
        JoinTest.insertTourRow(ps, "AA1204", "LOS");
        JoinTest.insertTourRow(ps, "AA1205", "CAS");
        JoinTest.insertTourRow(ps, "AA1206", "MAD");
        JoinTest.insertTourRow(ps, "AA1207", "CCS");
        JoinTest.insertTourRow(ps, "AA1208", "SCL");
        JoinTest.insertTourRow(ps, "AA1209", "CCS");
        JoinTest.insertTourRow(ps, "AA1210", "MEX");
        JoinTest.insertTourRow(ps, "AA1211", "CCS");
        JoinTest.insertTourRow(ps, "AA1212", "BUE");
        JoinTest.insertTourRow(ps, "AA1213", "CCU");
        JoinTest.insertTourRow(ps, "AA1214", "HKG");
        JoinTest.insertTourRow(ps, "AA1215", "CCU");
        JoinTest.insertTourRow(ps, "AA1216", "NRT");
        JoinTest.insertTourRow(ps, "AA1217", "CCU");
        JoinTest.insertTourRow(ps, "AA1218", "SIN");
        JoinTest.insertTourRow(ps, "AA1219", "CDG");
        JoinTest.insertTourRow(ps, "AA1220", "LHR");
        JoinTest.insertTourRow(ps, "AA1221", "CDG");
        JoinTest.insertTourRow(ps, "AA1222", "JFK");
        JoinTest.insertTourRow(ps, "AA1223", "CDG");
        JoinTest.insertTourRow(ps, "AA1224", "SVO");
        JoinTest.insertTourRow(ps, "AA1225", "CHS");
        JoinTest.insertTourRow(ps, "AA1226", "ATL");
        JoinTest.insertTourRow(ps, "AA1227", "CHS");
        JoinTest.insertTourRow(ps, "AA1228", "MCI");
        JoinTest.insertTourRow(ps, "AA1229", "CHS");
        JoinTest.insertTourRow(ps, "AA1230", "MSY");
        JoinTest.insertTourRow(ps, "AA1231", "CLE");
        JoinTest.insertTourRow(ps, "AA1232", "LAX");
        JoinTest.insertTourRow(ps, "AA1233", "CLE");
        JoinTest.insertTourRow(ps, "AA1234", "DFW");
        JoinTest.insertTourRow(ps, "AA1235", "CLE");
        JoinTest.insertTourRow(ps, "AA1236", "MDW");
        JoinTest.insertTourRow(ps, "AA1237", "CPH");
        JoinTest.insertTourRow(ps, "AA1238", "FCO");
        JoinTest.insertTourRow(ps, "AA1239", "CPH");
        JoinTest.insertTourRow(ps, "AA1240", "REY");
        JoinTest.insertTourRow(ps, "AA1241", "CPH");
        JoinTest.insertTourRow(ps, "AA1242", "CDG");
        JoinTest.insertTourRow(ps, "AA1243", "CPT");
        JoinTest.insertTourRow(ps, "AA1244", "LOS");
        JoinTest.insertTourRow(ps, "AA1245", "CPT");
        JoinTest.insertTourRow(ps, "AA1246", "NBO");
        JoinTest.insertTourRow(ps, "AA1247", "CPT");
        JoinTest.insertTourRow(ps, "AA1248", "LHR");
        JoinTest.insertTourRow(ps, "AA1249", "DEN");
        JoinTest.insertTourRow(ps, "AA1250", "SEA");
        JoinTest.insertTourRow(ps, "AA1251", "DEN");
        JoinTest.insertTourRow(ps, "AA1252", "BOI");
        JoinTest.insertTourRow(ps, "AA1253", "DEN");
        JoinTest.insertTourRow(ps, "AA1254", "JFK");
        JoinTest.insertTourRow(ps, "AA1255", "DFW");
        JoinTest.insertTourRow(ps, "AA1256", "SAT");
        JoinTest.insertTourRow(ps, "AA1257", "DFW");
        JoinTest.insertTourRow(ps, "AA1258", "ATL");
        JoinTest.insertTourRow(ps, "AA1259", "DFW");
        JoinTest.insertTourRow(ps, "AA1260", "MIA");
        JoinTest.insertTourRow(ps, "AA1261", "DSM");
        JoinTest.insertTourRow(ps, "AA1262", "MDW");
        JoinTest.insertTourRow(ps, "AA1263", "DSM");
        JoinTest.insertTourRow(ps, "AA1264", "SLC");
        JoinTest.insertTourRow(ps, "AA1265", "DSM");
        JoinTest.insertTourRow(ps, "AA1266", "OKC");
        JoinTest.insertTourRow(ps, "AA1267", "DUB");
        JoinTest.insertTourRow(ps, "AA1268", "LHR");
        JoinTest.insertTourRow(ps, "AA1272", "CDG");
        JoinTest.insertTourRow(ps, "AA1273", "BUE");
        JoinTest.insertTourRow(ps, "AA1274", "SCL");
        JoinTest.insertTourRow(ps, "AA1275", "BUE");
        JoinTest.insertTourRow(ps, "AA1276", "GRU");
        JoinTest.insertTourRow(ps, "US1509", "BUE");
        JoinTest.insertTourRow(ps, "US1508", "MIA");
        JoinTest.insertTourRow(ps, "AA1279", "FAI");
        JoinTest.insertTourRow(ps, "AA1280", "JNU");
        JoinTest.insertTourRow(ps, "AA1281", "FAI");
        JoinTest.insertTourRow(ps, "AA1282", "SEA");
        JoinTest.insertTourRow(ps, "US1443", "FAI");
        JoinTest.insertTourRow(ps, "US1444", "NRT");
        JoinTest.insertTourRow(ps, "AA1285", "FCO");
        JoinTest.insertTourRow(ps, "AA1286", "CDG");
        JoinTest.insertTourRow(ps, "AA1287", "FCO");
        JoinTest.insertTourRow(ps, "AA1288", "CAI");
        JoinTest.insertTourRow(ps, "AA1289", "FCO");
        JoinTest.insertTourRow(ps, "AA1290", "JFK");
        JoinTest.insertTourRow(ps, "AA1291", "GIG");
        JoinTest.insertTourRow(ps, "AA1292", "MIA");
        JoinTest.insertTourRow(ps, "AA1293", "GIG");
        JoinTest.insertTourRow(ps, "AA1294", "LIM");
        JoinTest.insertTourRow(ps, "AA1295", "GIG");
        JoinTest.insertTourRow(ps, "AA1296", "BUE");
        JoinTest.insertTourRow(ps, "US1249", "GRU");
        JoinTest.insertTourRow(ps, "US1250", "CCS");
        JoinTest.insertTourRow(ps, "US1251", "GRU");
        JoinTest.insertTourRow(ps, "US1252", "JFK");
        JoinTest.insertTourRow(ps, "US1253", "GRU");
        JoinTest.insertTourRow(ps, "US1254", "LAX");
        JoinTest.insertTourRow(ps, "AA1053", "GRU");
        JoinTest.insertTourRow(ps, "AA1054", "LIM");
        JoinTest.insertTourRow(ps, "US1255", "GVA");
        JoinTest.insertTourRow(ps, "US1256", "CPH");
        JoinTest.insertTourRow(ps, "US1257", "GVA");
        JoinTest.insertTourRow(ps, "US1258", "LIS");
        JoinTest.insertTourRow(ps, "US1259", "GVA");
        JoinTest.insertTourRow(ps, "US1260", "OSL");
        JoinTest.insertTourRow(ps, "US1266", "HKG");
        JoinTest.insertTourRow(ps, "US1264", "SIN");
        JoinTest.insertTourRow(ps, "US1267", "HLN");
        JoinTest.insertTourRow(ps, "US1268", "SEA");
        JoinTest.insertTourRow(ps, "US1269", "HLN");
        JoinTest.insertTourRow(ps, "US1270", "BOI");
        JoinTest.insertTourRow(ps, "US1271", "HLN");
        JoinTest.insertTourRow(ps, "US1272", "DEN");
        JoinTest.insertTourRow(ps, "US1276", "HNL");
        JoinTest.insertTourRow(ps, "US1274", "NRT");
        JoinTest.insertTourRow(ps, "US1277", "HNL");
        JoinTest.insertTourRow(ps, "US1278", "SYD");
        JoinTest.insertTourRow(ps, "US1281", "HOU");
        JoinTest.insertTourRow(ps, "US1282", "SAT");
        JoinTest.insertTourRow(ps, "US1283", "HOU");
        JoinTest.insertTourRow(ps, "US1284", "IAD");
        JoinTest.insertTourRow(ps, "US1285", "IAD");
        JoinTest.insertTourRow(ps, "US1286", "BOS");
        JoinTest.insertTourRow(ps, "US1287", "IAD");
        JoinTest.insertTourRow(ps, "US1288", "MSP");
        JoinTest.insertTourRow(ps, "US1289", "IAD");
        JoinTest.insertTourRow(ps, "US1290", "MIA");
        JoinTest.insertTourRow(ps, "US1291", "IST");
        JoinTest.insertTourRow(ps, "US1292", "THR");
        JoinTest.insertTourRow(ps, "US1293", "IST");
        JoinTest.insertTourRow(ps, "US1294", "FCO");
        JoinTest.insertTourRow(ps, "US1295", "IST");
        JoinTest.insertTourRow(ps, "US1296", "ATH");
        JoinTest.insertTourRow(ps, "US1381", "JFK");
        JoinTest.insertTourRow(ps, "US1382", "CDG");
        JoinTest.insertTourRow(ps, "US1349", "JFK");
        JoinTest.insertTourRow(ps, "US1300", "LAX");
        JoinTest.insertTourRow(ps, "US1301", "JFK");
        JoinTest.insertTourRow(ps, "US1302", "GRU");
        JoinTest.insertTourRow(ps, "US1303", "JKT");
        JoinTest.insertTourRow(ps, "US1304", "HKG");
        JoinTest.insertTourRow(ps, "US1308", "JKT");
        JoinTest.insertTourRow(ps, "US1307", "SYD");
        JoinTest.insertTourRow(ps, "US1309", "JNU");
        JoinTest.insertTourRow(ps, "US1310", "SEA");
        JoinTest.insertTourRow(ps, "US1311", "JNU");
        JoinTest.insertTourRow(ps, "US1312", "SFO");
        JoinTest.insertTourRow(ps, "US1313", "JNU");
        JoinTest.insertTourRow(ps, "US1314", "HNL");
        JoinTest.insertTourRow(ps, "US1315", "KBL");
        JoinTest.insertTourRow(ps, "US1316", "KHI");
        JoinTest.insertTourRow(ps, "US1317", "KBL");
        JoinTest.insertTourRow(ps, "US1318", "IST");
        JoinTest.insertTourRow(ps, "US1321", "KHI");
        JoinTest.insertTourRow(ps, "US1322", "IST");
        JoinTest.insertTourRow(ps, "US1323", "KHI");
        JoinTest.insertTourRow(ps, "US1324", "IST");
        JoinTest.insertTourRow(ps, "US1325", "KHI");
        JoinTest.insertTourRow(ps, "US1326", "THR");
        JoinTest.insertTourRow(ps, "US1327", "LAX");
        JoinTest.insertTourRow(ps, "US1328", "HNL");
        JoinTest.insertTourRow(ps, "US1329", "LAX");
        JoinTest.insertTourRow(ps, "US1330", "GRU");
        JoinTest.insertTourRow(ps, "US1331", "LAX");
        JoinTest.insertTourRow(ps, "US1332", "NRT");
        JoinTest.insertTourRow(ps, "US1333", "LHR");
        JoinTest.insertTourRow(ps, "US1334", "WAW");
        JoinTest.insertTourRow(ps, "US1335", "LHR");
        JoinTest.insertTourRow(ps, "US1336", "YYZ");
        JoinTest.insertTourRow(ps, "US1337", "LHR");
        JoinTest.insertTourRow(ps, "US1338", "NBO");
        JoinTest.insertTourRow(ps, "US1501", "LIM");
        JoinTest.insertTourRow(ps, "US1340", "MIA");
        JoinTest.insertTourRow(ps, "US1344", "LIM");
        JoinTest.insertTourRow(ps, "US1342", "BUE");
        JoinTest.insertTourRow(ps, "US1345", "LIS");
        JoinTest.insertTourRow(ps, "US1346", "CDG");
        JoinTest.insertTourRow(ps, "US1347", "LIS");
        JoinTest.insertTourRow(ps, "US1348", "CAS");
        JoinTest.insertTourRow(ps, "US1353", "LOS");
        JoinTest.insertTourRow(ps, "US1354", "MAD");
        JoinTest.insertTourRow(ps, "US1355", "LOS");
        JoinTest.insertTourRow(ps, "US1356", "ATH");
        JoinTest.insertTourRow(ps, "US1357", "MAD");
        JoinTest.insertTourRow(ps, "US1358", "CDG");
        JoinTest.insertTourRow(ps, "US1361", "MAD");
        JoinTest.insertTourRow(ps, "US1362", "JFK");
        JoinTest.insertTourRow(ps, "US1363", "MCI");
        JoinTest.insertTourRow(ps, "US1364", "LAX");
        JoinTest.insertTourRow(ps, "US1365", "MCI");
        JoinTest.insertTourRow(ps, "US1366", "DFW");
        JoinTest.insertTourRow(ps, "US1367", "MCI");
        JoinTest.insertTourRow(ps, "US1368", "JFK");
        JoinTest.insertTourRow(ps, "US1379", "MDW");
        JoinTest.insertTourRow(ps, "US1380", "LAX");
        JoinTest.insertTourRow(ps, "US1473", "MDW");
        JoinTest.insertTourRow(ps, "US1474", "JFK");
        JoinTest.insertTourRow(ps, "US1383", "MDW");
        JoinTest.insertTourRow(ps, "US1384", "ATL");
        JoinTest.insertTourRow(ps, "US1385", "MEL");
        JoinTest.insertTourRow(ps, "US1386", "SYD");
        JoinTest.insertTourRow(ps, "US1387", "MEL");
        JoinTest.insertTourRow(ps, "US1388", "SIN");
        JoinTest.insertTourRow(ps, "US1389", "MEL");
        JoinTest.insertTourRow(ps, "US1390", "HNL");
        JoinTest.insertTourRow(ps, "US1391", "MEM");
        JoinTest.insertTourRow(ps, "US1392", "MIA");
        JoinTest.insertTourRow(ps, "US1393", "MEM");
        JoinTest.insertTourRow(ps, "US1394", "JFK");
        JoinTest.insertTourRow(ps, "US1395", "MEM");
        JoinTest.insertTourRow(ps, "US1396", "LAX");
        JoinTest.insertTourRow(ps, "US1397", "MEX");
        JoinTest.insertTourRow(ps, "US1398", "SFO");
        JoinTest.insertTourRow(ps, "US1399", "MEX");
        JoinTest.insertTourRow(ps, "US1400", "LAX");
        JoinTest.insertTourRow(ps, "US1401", "MEX");
        JoinTest.insertTourRow(ps, "US1402", "BOG");
        JoinTest.insertTourRow(ps, "US1403", "MIA");
        JoinTest.insertTourRow(ps, "US1404", "GRU");
        JoinTest.insertTourRow(ps, "US1405", "MIA");
        JoinTest.insertTourRow(ps, "US1406", "LAX");
        JoinTest.insertTourRow(ps, "US1407", "MIA");
        JoinTest.insertTourRow(ps, "US1408", "JFK");
        JoinTest.insertTourRow(ps, "US1409", "MKE");
        JoinTest.insertTourRow(ps, "US1410", "JFK");
        JoinTest.insertTourRow(ps, "US1411", "MKE");
        JoinTest.insertTourRow(ps, "US1412", "MDW");
        JoinTest.insertTourRow(ps, "US1413", "MKE");
        JoinTest.insertTourRow(ps, "US1414", "JFK");
        JoinTest.insertTourRow(ps, "US1415", "MNL");
        JoinTest.insertTourRow(ps, "US1416", "SYD");
        JoinTest.insertTourRow(ps, "US1417", "MNL");
        JoinTest.insertTourRow(ps, "US1418", "TPE");
        JoinTest.insertTourRow(ps, "US1419", "MNL");
        JoinTest.insertTourRow(ps, "US1420", "SIN");
        JoinTest.insertTourRow(ps, "AA1419", "MNL");
        JoinTest.insertTourRow(ps, "AA1420", "HKG");
        JoinTest.insertTourRow(ps, "AA1421", "MNL");
        JoinTest.insertTourRow(ps, "US1422", "HNL");
        JoinTest.insertTourRow(ps, "US1423", "MSP");
        JoinTest.insertTourRow(ps, "US1424", "MDW");
        JoinTest.insertTourRow(ps, "AA1423", "MDW");
        JoinTest.insertTourRow(ps, "AA1424", "MIA");
        JoinTest.insertTourRow(ps, "US1427", "MSY");
        JoinTest.insertTourRow(ps, "US1428", "SFO");
        JoinTest.insertTourRow(ps, "US1429", "MSY");
        JoinTest.insertTourRow(ps, "US1430", "ATL");
        JoinTest.insertTourRow(ps, "US1431", "MSY");
        JoinTest.insertTourRow(ps, "US1432", "JFK");
        JoinTest.insertTourRow(ps, "US1433", "NBO");
        JoinTest.insertTourRow(ps, "US1434", "FCO");
        JoinTest.insertTourRow(ps, "US1435", "NBO");
        JoinTest.insertTourRow(ps, "US1436", "MAD");
        JoinTest.insertTourRow(ps, "US1437", "NBO");
        JoinTest.insertTourRow(ps, "US1438", "CAS");
        JoinTest.insertTourRow(ps, "US1439", "NRT");
        JoinTest.insertTourRow(ps, "US1440", "SYD");
        JoinTest.insertTourRow(ps, "US1441", "NRT");
        JoinTest.insertTourRow(ps, "US1442", "LAX");
        JoinTest.insertTourRow(ps, "US1445", "OKC");
        JoinTest.insertTourRow(ps, "US1446", "SLC");
        JoinTest.insertTourRow(ps, "US1447", "OKC");
        JoinTest.insertTourRow(ps, "US1448", "JFK");
        JoinTest.insertTourRow(ps, "US1449", "OKC");
        JoinTest.insertTourRow(ps, "US1450", "LAX");
        JoinTest.insertTourRow(ps, "US1451", "OSA");
        JoinTest.insertTourRow(ps, "US1452", "NRT");
        JoinTest.insertTourRow(ps, "US1453", "OSA");
        JoinTest.insertTourRow(ps, "US1454", "TPE");
        JoinTest.insertTourRow(ps, "US1455", "OSA");
        JoinTest.insertTourRow(ps, "US1456", "SVO");
        JoinTest.insertTourRow(ps, "US1457", "OSL");
        JoinTest.insertTourRow(ps, "US1458", "PRG");
        JoinTest.insertTourRow(ps, "US1459", "OSL");
        JoinTest.insertTourRow(ps, "US1460", "ARN");
        JoinTest.insertTourRow(ps, "US1461", "OSL");
        JoinTest.insertTourRow(ps, "US1462", "WAW");
        JoinTest.insertTourRow(ps, "AA1462", "OSL");
        JoinTest.insertTourRow(ps, "AA1463", "CDG");
        JoinTest.insertTourRow(ps, "US1463", "PHL");
        JoinTest.insertTourRow(ps, "US1464", "IAD");
        JoinTest.insertTourRow(ps, "US1465", "PHL");
        JoinTest.insertTourRow(ps, "US1466", "MIA");
        JoinTest.insertTourRow(ps, "US1469", "PHX");
        JoinTest.insertTourRow(ps, "US1470", "LAX");
        JoinTest.insertTourRow(ps, "US1471", "PHX");
        JoinTest.insertTourRow(ps, "US1472", "SEA");
        JoinTest.insertTourRow(ps, "US1475", "PRG");
        JoinTest.insertTourRow(ps, "US1476", "CDG");
        JoinTest.insertTourRow(ps, "US1477", "PRG");
        JoinTest.insertTourRow(ps, "US1478", "FCO");
        JoinTest.insertTourRow(ps, "US1479", "PRG");
        JoinTest.insertTourRow(ps, "US1480", "REY");
        JoinTest.insertTourRow(ps, "US1481", "REY");
        JoinTest.insertTourRow(ps, "US1482", "SVO");
        JoinTest.insertTourRow(ps, "US1483", "REY");
        JoinTest.insertTourRow(ps, "US1484", "CDG");
        JoinTest.insertTourRow(ps, "US1485", "REY");
        JoinTest.insertTourRow(ps, "US1486", "DUB");
        JoinTest.insertTourRow(ps, "US1487", "SAN");
        JoinTest.insertTourRow(ps, "US1488", "SFO");
        JoinTest.insertTourRow(ps, "US1489", "SAN");
        JoinTest.insertTourRow(ps, "US1490", "DFW");
        JoinTest.insertTourRow(ps, "US1491", "SAN");
        JoinTest.insertTourRow(ps, "US1492", "MEX");
        JoinTest.insertTourRow(ps, "US1493", "SAT");
        JoinTest.insertTourRow(ps, "US1494", "ATL");
        JoinTest.insertTourRow(ps, "US1495", "SAT");
        JoinTest.insertTourRow(ps, "US1496", "LAX");
        JoinTest.insertTourRow(ps, "US1497", "SAT");
        JoinTest.insertTourRow(ps, "US1498", "MIA");
        JoinTest.insertTourRow(ps, "US1499", "SCL");
        JoinTest.insertTourRow(ps, "US1500", "GRU");
        JoinTest.insertTourRow(ps, "US1503", "SCL");
        JoinTest.insertTourRow(ps, "US1504", "BUE");
        JoinTest.insertTourRow(ps, "US1505", "SEA");
        JoinTest.insertTourRow(ps, "AA1505", "SFO");
        JoinTest.insertTourRow(ps, "US1506", "SEA");
        JoinTest.insertTourRow(ps, "US1507", "JFK");
        JoinTest.insertTourRow(ps, "US1510", "SEL");
        JoinTest.insertTourRow(ps, "US1511", "NRT");
        JoinTest.insertTourRow(ps, "US1514", "SEL");
        JoinTest.insertTourRow(ps, "US1515", "SHA");
        JoinTest.insertTourRow(ps, "US1518", "SFO");
        JoinTest.insertTourRow(ps, "US1519", "SCL");
        JoinTest.insertTourRow(ps, "US1529", "SFO");
        JoinTest.insertTourRow(ps, "US1521", "HNL");
        JoinTest.insertTourRow(ps, "US1522", "SHA");
        JoinTest.insertTourRow(ps, "US1523", "SIN");
        JoinTest.insertTourRow(ps, "US1524", "SHA");
        JoinTest.insertTourRow(ps, "US1525", "HKG");
        JoinTest.insertTourRow(ps, "US1526", "SHA");
        JoinTest.insertTourRow(ps, "US1527", "SVO");
        JoinTest.insertTourRow(ps, "AA1528", "SIN");
        JoinTest.insertTourRow(ps, "AA1529", "SYD");
        JoinTest.insertTourRow(ps, "AA1532", "SIN");
        JoinTest.insertTourRow(ps, "AA1533", "HKG");
        JoinTest.insertTourRow(ps, "US1536", "SJU");
        JoinTest.insertTourRow(ps, "US1537", "CCS");
        JoinTest.insertTourRow(ps, "US1538", "SJU");
        JoinTest.insertTourRow(ps, "US1539", "MEL");
        JoinTest.insertTourRow(ps, "US1540", "SLC");
        JoinTest.insertTourRow(ps, "US1541", "DEN");
        JoinTest.insertTourRow(ps, "US1542", "SLC");
        JoinTest.insertTourRow(ps, "US1543", "SFO");
        JoinTest.insertTourRow(ps, "US1544", "SLC");
        JoinTest.insertTourRow(ps, "US1545", "MDW");
        JoinTest.insertTourRow(ps, "US1546", "STL");
        JoinTest.insertTourRow(ps, "US1547", "MDW");
        JoinTest.insertTourRow(ps, "US1548", "STL");
        JoinTest.insertTourRow(ps, "US1549", "JFK");
        JoinTest.insertTourRow(ps, "US1550", "STL");
        JoinTest.insertTourRow(ps, "US1551", "LAX");
        JoinTest.insertTourRow(ps, "US1552", "SVO");
        JoinTest.insertTourRow(ps, "US1553", "CDG");
        JoinTest.insertTourRow(ps, "US1554", "SVO");
        JoinTest.insertTourRow(ps, "US1555", "NRT");
        JoinTest.insertTourRow(ps, "US1558", "SYD");
        JoinTest.insertTourRow(ps, "US1559", "AKL");
        JoinTest.insertTourRow(ps, "US1560", "SYD");
        JoinTest.insertTourRow(ps, "US1561", "HNL");
        JoinTest.insertTourRow(ps, "US1562", "SYD");
        JoinTest.insertTourRow(ps, "US1563", "HKG");
        JoinTest.insertTourRow(ps, "US1564", "THR");
        JoinTest.insertTourRow(ps, "US1565", "KBL");
        JoinTest.insertTourRow(ps, "US1566", "THR");
        JoinTest.insertTourRow(ps, "US1567", "KHI");
        JoinTest.insertTourRow(ps, "US1568", "THR");
        JoinTest.insertTourRow(ps, "US1569", "CAI");
        JoinTest.insertTourRow(ps, "US1572", "TPE");
        JoinTest.insertTourRow(ps, "US1573", "SYD");
        JoinTest.insertTourRow(ps, "US1574", "TPE");
        JoinTest.insertTourRow(ps, "US1575", "OSA");
        JoinTest.insertTourRow(ps, "US1576", "WAW");
        JoinTest.insertTourRow(ps, "US1577", "PRG");
        JoinTest.insertTourRow(ps, "US1578", "WAW");
        JoinTest.insertTourRow(ps, "US1579", "SVO");
        JoinTest.insertTourRow(ps, "US1580", "WAW");
        JoinTest.insertTourRow(ps, "US1581", "ARN");
        JoinTest.insertTourRow(ps, "US1584", "YUL");
        JoinTest.insertTourRow(ps, "US1585", "JFK");
        JoinTest.insertTourRow(ps, "US1586", "YUL");
        JoinTest.insertTourRow(ps, "US1587", "SFO");
        JoinTest.insertTourRow(ps, "US1588", "YYZ");
        JoinTest.insertTourRow(ps, "US1589", "SEA");
        JoinTest.insertTourRow(ps, "US1590", "YYZ");
        JoinTest.insertTourRow(ps, "US1592", "YYZ");
        JoinTest.insertTourRow(ps, "US1593", "LHR");
        JoinTest.insertTourRow(ps, "AA1600", "SFO");
        JoinTest.insertTourRow(ps, "AA1601", "LAX");
        JoinTest.insertTourRow(ps, "AA1602", "SFO");
        JoinTest.insertTourRow(ps, "AA1603", "LAX");
        JoinTest.insertTourRow(ps, "US1600", "YYZ");
        JoinTest.insertTourRow(ps, "US1601", "SCL");
        s.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ResultSet rs = s.executeQuery("SELECT * FROM CITIES LEFT OUTER JOIN     (SELECT * FROM FLIGHTS, COUNTRIES) S   ON CITIES.AIRPORT = S.ORIG_AIRPORT   WHERE S.COUNTRY_ISO_CODE = 'US'");
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        JoinTest.assertTrue((boolean)rtsp.usedHashJoin());
        rs = s.executeQuery("SELECT * FROM CITIES LEFT OUTER JOIN FLIGHTS     INNER JOIN COUNTRIES ON 1=1     ON CITIES.AIRPORT = FLIGHTS.ORIG_AIRPORT   WHERE COUNTRIES.COUNTRY_ISO_CODE = 'US'");
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        JoinTest.assertFalse((boolean)rtsp.usedNLLeftOuterJoin());
        JoinTest.assertTrue((boolean)rtsp.usedHashJoin());
        rs = s.executeQuery("SELECT * FROM FLIGHTS     INNER JOIN COUNTRIES ON 1=1     RIGHT OUTER JOIN CITIES     ON CITIES.AIRPORT = FLIGHTS.ORIG_AIRPORT   WHERE COUNTRIES.COUNTRY_ISO_CODE = 'US'");
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        JoinTest.assertFalse((boolean)rtsp.usedNLLeftOuterJoin());
        JoinTest.assertTrue((boolean)rtsp.usedHashJoin());
        rs = s.executeQuery("SELECT * FROM CITIES LEFT OUTER JOIN    (FLIGHTS CROSS JOIN COUNTRIES)   ON CITIES.AIRPORT = FLIGHTS.ORIG_AIRPORT   WHERE COUNTRIES.COUNTRY_ISO_CODE = 'US'");
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        JoinTest.assertFalse((boolean)rtsp.usedNLLeftOuterJoin());
        JoinTest.assertTrue((boolean)rtsp.usedHashJoin());
        rs = s.executeQuery("SELECT * FROM    (FLIGHTS CROSS JOIN COUNTRIES) RIGHT OUTER JOIN     CITIES ON CITIES.AIRPORT = FLIGHTS.ORIG_AIRPORT   WHERE COUNTRIES.COUNTRY_ISO_CODE = 'US'");
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        JoinTest.assertFalse((boolean)rtsp.usedNLLeftOuterJoin());
        JoinTest.assertTrue((boolean)rtsp.usedHashJoin());
    }

    static void insertTourRow(PreparedStatement ps, String a, String b) throws SQLException {
        ps.setString(1, a);
        ps.setString(2, b);
        ps.execute();
    }

    static void insertTourRow(PreparedStatement ps, int a, String b, String c) throws SQLException {
        ps.setInt(1, a);
        ps.setString(2, b);
        ps.setString(3, c);
        ps.execute();
    }

    public void testDerby_4679() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table abstract_instance (    jz_discriminator int,     item_id char(32),     family_item_id char(32),     state_id char(32),     visibility bigint)");
        s.execute("create table lab_resource_operatingsystem (    jz_parent_id char(32),     item_id char(32))");
        s.execute("create table operating_system_software_install (    jz_parent_id char(32),     item_id char(32))");
        s.execute("create table family (    item_id char(32),     root_item_id char(32))");
        s.execute("insert into abstract_instance (    jz_discriminator,     item_id,     family_item_id,     visibility) values (238, 'aaaa', 'bbbb', 0),       (0, 'cccc', 'dddd', 0),       (1, 'eeee', '_5VetVWTeEd-Q8aOqWJPEIQ', 0)");
        s.execute("insert into lab_resource_operatingsystem values ('aaaa', 'cccc')");
        s.execute("insert into operating_system_software_install values ('cccc', 'eeee')");
        s.execute("insert into family values ('dddd', '_5ZDlwWTeEd-Q8aOqWJPEIQ'),       ('bbbb', '_5nN9mmTeEd-Q8aOqWJPEIQ')");
        ResultSet rs = s.executeQuery("select distinct t1.ITEM_ID, t1.state_id, t1.JZ_DISCRIMINATOR    from ((((((select * from ABSTRACT_INSTANCE z1       where z1.JZ_DISCRIMINATOR = 238) t1       left outer join LAB_RESOURCE_OPERATINGSYSTEM j1           on (t1.ITEM_ID = j1.JZ_PARENT_ID))      left outer join ABSTRACT_INSTANCE t2         on (j1.ITEM_ID = t2.ITEM_ID))     left outer join OPERATING_SYSTEM_SOFTWARE_INSTALL j2        on (t2.ITEM_ID = j2.JZ_PARENT_ID))   left outer join ABSTRACT_INSTANCE t3 on        (j2.ITEM_ID = t3.ITEM_ID)   inner join FAMILY t5 on (t2.FAMILY_ITEM_ID = t5.ITEM_ID))  inner join FAMILY t7 on (t1.FAMILY_ITEM_ID = t7.ITEM_ID)) where (t3.FAMILY_ITEM_ID IN('_5VetVWTeEd-Q8aOqWJPEIQ') and       (t5.ROOT_ITEM_ID = '_5ZDlwWTeEd-Q8aOqWJPEIQ') and       (t7.ROOT_ITEM_ID ='_5nN9mmTeEd-Q8aOqWJPEIQ') and       (t1.VISIBILITY = 0))");
        JDBC.assertFullResultSet(rs, new String[][]{{"aaaa", null, "238"}});
        rs = s.executeQuery("select distinct t1.ITEM_ID, t1.state_id, t1.JZ_DISCRIMINATOR     from ((((((select * from ABSTRACT_INSTANCE z1       where z1.JZ_DISCRIMINATOR = 238) t1       left outer join LAB_RESOURCE_OPERATINGSYSTEM j1           on (t1.ITEM_ID = j1.JZ_PARENT_ID))      left outer join ABSTRACT_INSTANCE t2          on (j1.ITEM_ID = t2.ITEM_ID))     left outer join OPERATING_SYSTEM_SOFTWARE_INSTALL j2        on (t2.ITEM_ID = j2.JZ_PARENT_ID))   left outer join (select * from ABSTRACT_INSTANCE) tCorr        on (j2.ITEM_ID = tCorr.ITEM_ID)   inner join FAMILY t5 on (t2.FAMILY_ITEM_ID = t5.ITEM_ID))  inner join FAMILY t7 on (t1.FAMILY_ITEM_ID = t7.ITEM_ID)) where (tCorr.FAMILY_ITEM_ID IN('_5VetVWTeEd-Q8aOqWJPEIQ') and       (t5.ROOT_ITEM_ID = '_5ZDlwWTeEd-Q8aOqWJPEIQ') and       (t7.ROOT_ITEM_ID ='_5nN9mmTeEd-Q8aOqWJPEIQ') and       (t1.VISIBILITY = 0))");
        JDBC.assertFullResultSet(rs, new String[][]{{"aaaa", null, "238"}});
        rs = s.executeQuery("select distinct t1.ITEM_ID, t1.state_id, t1.JZ_DISCRIMINATOR     from ((((((select * from ABSTRACT_INSTANCE z1       where z1.JZ_DISCRIMINATOR = 238) t1       left outer join LAB_RESOURCE_OPERATINGSYSTEM j1           on (t1.ITEM_ID = j1.JZ_PARENT_ID))      left outer join ABSTRACT_INSTANCE t2          on (j1.ITEM_ID = t2.ITEM_ID))     left outer join OPERATING_SYSTEM_SOFTWARE_INSTALL j2         on (t2.ITEM_ID = j2.JZ_PARENT_ID))   left outer join        (values (238, 'aaaa', 'bbbb', 0),       (0, 'cccc', 'dddd', 0),       (1, 'eeee', '_5VetVWTeEd-Q8aOqWJPEIQ', 0))        tCorr(jz_discriminator,item_id,family_item_id,visibility)       on (j2.ITEM_ID = tCorr.ITEM_ID)   inner join FAMILY t5 on (t2.FAMILY_ITEM_ID = t5.ITEM_ID))  inner join FAMILY t7 on (t1.FAMILY_ITEM_ID = t7.ITEM_ID)) where (tCorr.FAMILY_ITEM_ID IN('_5VetVWTeEd-Q8aOqWJPEIQ') and       (t5.ROOT_ITEM_ID = '_5ZDlwWTeEd-Q8aOqWJPEIQ') and       (t7.ROOT_ITEM_ID ='_5nN9mmTeEd-Q8aOqWJPEIQ') and       (t1.VISIBILITY = 0))");
        JDBC.assertFullResultSet(rs, new String[][]{{"aaaa", null, "238"}});
        s.executeUpdate("create view tView as select * from ABSTRACT_INSTANCE");
        rs = s.executeQuery("select distinct t1.ITEM_ID, t1.state_id, t1.JZ_DISCRIMINATOR     from ((((((select * from ABSTRACT_INSTANCE z1       where z1.JZ_DISCRIMINATOR = 238) t1       left outer join LAB_RESOURCE_OPERATINGSYSTEM j1           on (t1.ITEM_ID = j1.JZ_PARENT_ID))      left outer join ABSTRACT_INSTANCE t2          on (j1.ITEM_ID = t2.ITEM_ID))     left outer join OPERATING_SYSTEM_SOFTWARE_INSTALL j2         on (t2.ITEM_ID = j2.JZ_PARENT_ID))   left outer join tView on (j2.ITEM_ID = tView.ITEM_ID)   inner join FAMILY t5 on (t2.FAMILY_ITEM_ID = t5.ITEM_ID))  inner join FAMILY t7 on (t1.FAMILY_ITEM_ID = t7.ITEM_ID)) where (tView.FAMILY_ITEM_ID IN('_5VetVWTeEd-Q8aOqWJPEIQ') and       (t5.ROOT_ITEM_ID = '_5ZDlwWTeEd-Q8aOqWJPEIQ') and       (t7.ROOT_ITEM_ID ='_5nN9mmTeEd-Q8aOqWJPEIQ') and       (t1.VISIBILITY = 0))");
        JDBC.assertFullResultSet(rs, new String[][]{{"aaaa", null, "238"}});
        this.rollback();
    }

    public void testDerby_4695() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("create table b2 (c1 int, c2 int, c3 char(1),                  c4 int, c5 int, c6 int)");
        s.executeUpdate("create table b4 (c7 int, c4 int, c6 int)");
        s.executeUpdate("create table b3 (c1 int, c9 int, c5 int, c6 int)");
        s.executeUpdate("create table b (c1 int, c2 int, c3 char(1),                 c4 int, c5 int, c6 int)");
        s.executeUpdate("create view bvw (c5, c1 ,c2 ,c3 ,c4) as select c5, c1 ,c2 ,c3 ,c4 from b2 union select c5, c1 ,c2 ,c3 ,c4 from b");
        s.executeUpdate("insert into b4 (c7,c4,c6) values (4, 42, 31)");
        s.executeUpdate("insert into b2 (c5,c1,c3,c4,c6)     values (3,4, 'F',43,23)");
        s.executeUpdate("insert into b3 (c5,c1,c9,c6) values (2,3,19,28)");
        s.executeUpdate("insert into b values (4, 10, 'x', 10, 10, 10)");
        ResultSet rs = s.executeQuery("select b3.* from b3 join bvw on (b3.c1 = bvw.c5)                     join b4 on (bvw.c1 = b4.c7)     where b4.c4 = 42");
        JDBC.assertFullResultSet(rs, new String[][]{{"3", "19", "2", "28"}});
        rs = s.executeQuery("select b3.*, bvw.c1 from b3 inner join bvw on (b3.c1 = bvw.c5)                             inner join b4  on (bvw.c1 = b4.c7)                             inner join b  on  (bvw.c1 = b.c1)                            inner join b bcorr on                                                bvw.c1 = bcorr.c1    where b4.c4 = 42");
        JDBC.assertFullResultSet(rs, new String[][]{{"3", "19", "2", "28", "4"}});
        this.rollback();
    }
}

