/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class GeneratedColumnsPermsTest
extends GeneratedColumnsHelper {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String JANET = "JANET";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "JANET"};

    public GeneratedColumnsPermsTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = (TestSuite)TestConfiguration.embeddedSuite(GeneratedColumnsPermsTest.class);
        CleanDatabaseTestSetup cleanTest = new CleanDatabaseTestSetup((Test)suite);
        Test authenticatedTest = DatabasePropertyTestSetup.builtinAuthentication((Test)cleanTest, LEGAL_USERS, "generatedColumnsPermissions");
        Test authorizedTest = TestConfiguration.sqlAuthorizationDecorator(authenticatedTest);
        return authorizedTest;
    }

    public void test_001_basicPermissions() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection janetConnection = this.openUserConnection(JANET);
        this.goodStatement(dboConnection, "create table t_bp_1( a int, b int generated always as ( -a ) )");
        this.goodStatement(dboConnection, "insert into t_bp_1( a ) values ( 1 )");
        this.goodStatement(dboConnection, "grant select ( a ) on t_bp_1 to public");
        this.goodStatement(dboConnection, "grant update ( a ) on t_bp_1 to public");
        this.expectExecutionError(janetConnection, "42500", "insert into test_dbo.t_bp_1( a ) values ( 100 )");
        this.expectExecutionError(janetConnection, "42502", "update test_dbo.t_bp_1 set a = a+ 1");
        this.expectExecutionError(janetConnection, "42500", "delete from test_dbo.t_bp_1 where a = 2");
        this.expectExecutionError(janetConnection, "42502", "select * from test_dbo.t_bp_1 order by a");
        this.assertResults(janetConnection, "select a from test_dbo.t_bp_1 order by a", new String[][]{{"1"}}, false);
        this.goodStatement(dboConnection, "grant select ( b ) on t_bp_1 to public");
        this.expectExecutionError(janetConnection, "42500", "insert into test_dbo.t_bp_1( a ) values ( 100 )");
        this.expectExecutionError(janetConnection, "42502", "update test_dbo.t_bp_1 set a = a+ 1");
        this.expectExecutionError(janetConnection, "42500", "delete from test_dbo.t_bp_1 where a = 2");
        this.assertResults(janetConnection, "select * from test_dbo.t_bp_1 order by a", new String[][]{{"1", "-1"}}, false);
        this.goodStatement(dboConnection, "grant update ( b ) on t_bp_1 to public");
        this.expectExecutionError(janetConnection, "42500", "insert into test_dbo.t_bp_1( a ) values ( 100 )");
        this.goodStatement(janetConnection, "update test_dbo.t_bp_1 set a = a+ 1");
        this.expectExecutionError(janetConnection, "42500", "delete from test_dbo.t_bp_1 where a = 2");
        this.assertResults(janetConnection, "select * from test_dbo.t_bp_1 order by a", new String[][]{{"2", "-2"}}, false);
        this.goodStatement(dboConnection, "grant insert on t_bp_1 to public");
        this.goodStatement(janetConnection, "insert into test_dbo.t_bp_1( a ) values ( 100 )");
        this.expectExecutionError(janetConnection, "42500", "delete from test_dbo.t_bp_1 where a = 2");
        this.assertResults(janetConnection, "select * from test_dbo.t_bp_1 order by a", new String[][]{{"2", "-2"}, {"100", "-100"}}, false);
        this.goodStatement(dboConnection, "grant delete on t_bp_1 to public");
        this.goodStatement(janetConnection, "delete from test_dbo.t_bp_1 where a = 2");
        this.assertResults(janetConnection, "select * from test_dbo.t_bp_1 order by a", new String[][]{{"100", "-100"}}, false);
    }

    public void test_002_functionPermissions() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection janetConnection = this.openUserConnection(JANET);
        this.goodStatement(dboConnection, "create function f_fp_minus\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.minus'\n");
        this.goodStatement(dboConnection, "create table t_fp_1( a int, b int generated always as ( test_dbo.f_fp_minus( a ) ) )");
        this.goodStatement(dboConnection, "grant update on t_fp_1 to public");
        this.goodStatement(dboConnection, "grant insert on t_fp_1 to public");
        this.goodStatement(dboConnection, "grant select on t_fp_1 to public");
        this.goodStatement(dboConnection, "insert into test_dbo.t_fp_1( a ) values ( 100 )");
        this.goodStatement(janetConnection, "create function f_fp_minus\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'java.lang.Math.abs'\n");
        this.expectExecutionError(janetConnection, "42504", "update test_dbo.t_fp_1 set a = a + 1");
        this.expectExecutionError(janetConnection, "42504", "insert into test_dbo.t_fp_1( a ) values ( 200 )");
        this.assertResults(janetConnection, "select * from test_dbo.t_fp_1 order by a", new String[][]{{"100", "-100"}}, false);
        this.goodStatement(dboConnection, "grant execute on function f_fp_minus to public");
        this.goodStatement(janetConnection, "update test_dbo.t_fp_1 set a = a + 1");
        this.goodStatement(janetConnection, "insert into test_dbo.t_fp_1( a ) values ( 200 )");
        this.assertResults(janetConnection, "select * from test_dbo.t_fp_1 order by a", new String[][]{{"101", "-101"}, {"200", "-200"}}, false);
    }

    public void test_003_ddl() throws Exception {
        Connection conn = this.getConnection();
        this.expectCompilationError("42XA2", "create table t_ddl_1( a int, b varchar( 128 ) generated always as ( current_role ) )");
    }

    public void test_004_functionSchema() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection janetConnection = this.openUserConnection(JANET);
        this.goodStatement(dboConnection, "create function f_fsch_1\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.minus'\n");
        this.goodStatement(dboConnection, "create table t_fsch_1( a int, b generated always as ( f_fsch_1( a ) ) )");
        this.goodStatement(dboConnection, "create table t_fsch_2( a int )");
        this.goodStatement(dboConnection, "alter table t_fsch_2 add column b generated always as ( f_fsch_1( a ) )");
        this.goodStatement(dboConnection, "grant execute on function f_fsch_1 to public");
        this.goodStatement(dboConnection, "grant select on t_fsch_1 to public");
        this.goodStatement(dboConnection, "grant insert on t_fsch_1 to public");
        this.goodStatement(dboConnection, "grant update on t_fsch_1 to public");
        this.goodStatement(dboConnection, "grant select on t_fsch_2 to public");
        this.goodStatement(dboConnection, "grant insert on t_fsch_2 to public");
        this.goodStatement(dboConnection, "grant update on t_fsch_2 to public");
        this.goodStatement(janetConnection, "create function f_fsch_1\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'java.lang.Math.abs'\n");
        this.goodStatement(dboConnection, "insert into test_dbo.t_fsch_1( a ) values ( 1 )");
        this.goodStatement(dboConnection, "insert into test_dbo.t_fsch_2( a ) values ( 2 )");
        this.goodStatement(janetConnection, "insert into test_dbo.t_fsch_1( a ) values ( 1 )");
        this.assertResults(janetConnection, "select * from test_dbo.t_fsch_1 order by a", new String[][]{{"1", "-1"}, {"1", "-1"}}, false);
        this.goodStatement(janetConnection, "insert into test_dbo.t_fsch_2( a ) values ( 2 )");
        this.assertResults(janetConnection, "select * from test_dbo.t_fsch_2 order by a", new String[][]{{"2", "-2"}, {"2", "-2"}}, false);
        this.goodStatement(janetConnection, "update test_dbo.t_fsch_1 set a = 100 + a");
        this.assertResults(janetConnection, "select * from test_dbo.t_fsch_1 order by a", new String[][]{{"101", "-101"}, {"101", "-101"}}, false);
        this.goodStatement(janetConnection, "update test_dbo.t_fsch_2 set a = 100 + a");
        this.assertResults(janetConnection, "select * from test_dbo.t_fsch_2 order by a", new String[][]{{"102", "-102"}, {"102", "-102"}}, false);
    }

    public void test_005_functionSchema() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection janetConnection = this.openUserConnection(JANET);
        this.goodStatement(dboConnection, "create function f_3944\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.minus'\n");
        this.goodStatement(dboConnection, "create table t_3944( a int, constraint t_3944_check check ( f_3944( a ) < 0 ) )");
        this.goodStatement(dboConnection, "grant insert on t_3944 to public");
        this.goodStatement(dboConnection, "grant execute on function f_3944 to public");
        this.expectExecutionError(janetConnection, "23513", "insert into test_dbo.t_3944( a ) values ( -100 )");
        this.goodStatement(janetConnection, "insert into test_dbo.t_3944( a ) values ( 200 )");
        this.assertResults(dboConnection, "select * from t_3944 order by a", new String[][]{{"200"}}, false);
    }

    public void test_006_functionSchema() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection janetConnection = this.openUserConnection(JANET);
        this.goodStatement(dboConnection, "create function f_3953\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsTest.minus'\n");
        this.goodStatement(dboConnection, "create view v_3953( a, b ) as values ( f_3953( 1 ), f_3953( 2 ) )");
        this.goodStatement(dboConnection, "grant select on v_3953 to public");
        this.goodStatement(dboConnection, "grant execute on function f_3953 to public");
        this.goodStatement(janetConnection, "create function f_3953\n(\n    a int\n)\nreturns int\nlanguage java\ndeterministic\nparameter style java\nno sql\nexternal name 'java.lang.Math.abs'\n");
        this.assertResults(janetConnection, "values ( f_3953( 1 ), f_3953( 2 ) )", new String[][]{{"1", "2"}}, false);
        this.assertResults(janetConnection, "select * from test_dbo.v_3953", new String[][]{{"-1", "-2"}}, false);
    }
}

