/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DeadlockDetectionTest
extends BaseJDBCTestCase {
    private static final String DEADLOCK = "40001";

    public static Test suite() {
        Test test = TestConfiguration.embeddedSuite(DeadlockDetectionTest.class);
        test = DatabasePropertyTestSetup.setLockTimeouts(test, 1, 30);
        return new CleanDatabaseTestSetup(test);
    }

    public DeadlockDetectionTest(String name) {
        super(name);
    }

    public void testDerby3980_repeatable_read() throws Exception {
        int i;
        Statement s = this.createStatement();
        s.executeUpdate("create table derby3980 (i int)");
        s.executeUpdate("insert into derby3980 values 1956, 180, 456, 3");
        Thread[] threads = new Thread[2];
        Connection[] conns = new Connection[threads.length];
        final Barrier readLockBarrier = new Barrier(threads.length);
        final List exceptions = Collections.synchronizedList(new ArrayList());
        for (i = 0; i < threads.length; ++i) {
            final Connection c = this.openDefaultConnection();
            c.setTransactionIsolation(4);
            c.setAutoCommit(false);
            final PreparedStatement select = c.prepareStatement("select * from derby3980 where i = 456");
            final PreparedStatement update = c.prepareStatement("update derby3980 set i = 456 where i = 456");
            threads[i] = new Thread(){

                public void run() {
                    try {
                        JDBC.assertSingleValueResultSet(select.executeQuery(), "456");
                        readLockBarrier.await();
                        BaseJDBCTestCase.assertUpdateCount(update, 1);
                        c.rollback();
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                }
            };
            conns[i] = c;
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
            conns[i].rollback();
            conns[i].close();
        }
        Iterator it = exceptions.iterator();
        while (it.hasNext()) {
            Exception e = (Exception)it.next();
            if (e instanceof SQLException) {
                DeadlockDetectionTest.assertSQLState(DEADLOCK, (SQLException)e);
                continue;
            }
            throw e;
        }
        DeadlockDetectionTest.assertEquals((String)"Number of victims", (int)1, (int)exceptions.size());
    }

    public void testDerby5073_dodgy_victims() throws Exception {
        int i;
        int i2;
        Statement s = this.createStatement();
        s.executeUpdate("create table derby5073(x int primary key, y int)");
        s.executeUpdate("insert into derby5073(x) values 0, 1, 2");
        Connection[] conns = new Connection[6];
        Thread[] threads = new Thread[conns.length];
        for (i2 = 0; i2 < conns.length; ++i2) {
            conns[i2] = this.openDefaultConnection();
            conns[i2].setAutoCommit(false);
        }
        for (i2 = 3; i2 < 6; ++i2) {
            PreparedStatement ps = conns[i2].prepareStatement("update derby5073 set y = x where x = ?");
            ps.setInt(1, i2 % 3);
            DeadlockDetectionTest.assertUpdateCount(ps, 1);
        }
        final List exceptions = Collections.synchronizedList(new ArrayList());
        for (i = 0; i < threads.length; ++i) {
            final PreparedStatement ps = conns[i].prepareStatement("select x from derby5073 where x = ?");
            final int row = (i + 1) % 3;
            ps.setInt(1, row);
            threads[i] = new Thread(){

                public void run() {
                    try {
                        JDBC.assertSingleValueResultSet(ps.executeQuery(), Integer.toString(row));
                        ps.getConnection().commit();
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                }
            };
            threads[i].start();
            if (i != 2) continue;
            Thread.sleep(100L);
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
            conns[i].rollback();
            conns[i].close();
        }
        Iterator it = exceptions.iterator();
        while (it.hasNext()) {
            Exception e = (Exception)it.next();
            if (e instanceof SQLException) {
                DeadlockDetectionTest.assertSQLState(DEADLOCK, (SQLException)e);
                continue;
            }
            throw e;
        }
        DeadlockDetectionTest.assertEquals((String)"Number of victims", (int)1, (int)exceptions.size());
    }

    private static class Barrier {
        int numThreads;

        Barrier(int numThreads) {
            this.numThreads = numThreads;
        }

        synchronized void await() throws InterruptedException {
            Assert.assertTrue((String)"Too many threads reached the barrier", (this.numThreads > 0 ? 1 : 0) != 0);
            if (--this.numThreads <= 0) {
                this.notifyAll();
            }
            while (this.numThreads > 0) {
                this.wait();
            }
        }
    }
}

