/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BigDataTest
extends BaseJDBCTestCase {
    private static final String BIG_TABLE_NAME = "big";

    public BigDataTest(String name) throws SQLException {
        super(name);
    }

    public static String getSelectSql(String tableName) {
        return "select * from " + tableName;
    }

    private void createTable(String tableName, int[] lengths, boolean[] useClob) throws SQLException {
        StringBuffer sqlSb = new StringBuffer();
        sqlSb.append("create table ");
        sqlSb.append(tableName);
        sqlSb.append(" (");
        for (int i = 0; i < lengths.length - 1; ++i) {
            sqlSb.append("c" + (i + 1) + (useClob[i] ? " clob(" : " varchar(") + lengths[i] + "),");
        }
        sqlSb.append("c" + lengths.length + (useClob[lengths.length - 1] ? " clob(" : " varchar(") + lengths[lengths.length - 1] + ")");
        sqlSb.append(")");
        String sql = sqlSb.toString();
        this.createTable(sql);
    }

    private void createTable(String sql) throws SQLException {
        Statement ps = this.createStatement();
        ps.executeUpdate(sql);
        ps.close();
    }

    private String[] getStringArray(String[] sa, int[] timesArray) {
        String[] result = new String[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            result[i] = new String(Formatters.repeatChar(sa[i], timesArray[i]));
        }
        return result;
    }

    private String[][] getRowsWithOnlyOneColumn(String[] sa, int[] timesArray) {
        String[][] result = new String[sa.length][1];
        for (int i = 0; i < sa.length; ++i) {
            result[i][0] = new String(Formatters.repeatChar(sa[i], timesArray[i]));
        }
        return result;
    }

    private void insertOneRow(String tableName, String[] sa, int[] timesArray) throws SQLException {
        String[] params = this.getStringArray(sa, timesArray);
        this.insertOneRow(tableName, params);
    }

    private void insertOneRow(String tableName, String[] columns) throws SQLException {
        StringBuffer sqlSb = new StringBuffer();
        sqlSb.append("insert into ");
        sqlSb.append(tableName);
        sqlSb.append(" values (");
        for (int i = 0; i < columns.length - 1; ++i) {
            sqlSb.append("?, ");
        }
        sqlSb.append("?)");
        String sql = sqlSb.toString();
        PreparedStatement ps = this.prepareStatement(sql);
        for (int i = 1; i <= columns.length; ++i) {
            ps.setString(i, columns[i - 1]);
        }
        ps.executeUpdate();
        ps.close();
    }

    private void insertMultipleRows(String tableName, String[][] rows) throws SQLException {
        for (int i = 0; i < rows.length; ++i) {
            String[] row = rows[i];
            this.insertOneRow(tableName, row);
        }
    }

    private void validTable(String[][] expected, String tableName) throws SQLException {
        String sql = BigDataTest.getSelectSql(tableName);
        Statement st = this.createStatement();
        ResultSet rs = st.executeQuery(sql);
        JDBC.assertFullResultSet(rs, expected);
        st.close();
    }

    private void validSingleRow(String[] exected, boolean[] useClob, ResultSet rs) throws SQLException {
        for (int i = 0; i < exected.length; ++i) {
            String real;
            if (useClob[i]) {
                Clob c = rs.getClob(i + 1);
                real = c.getSubString(1L, (int)c.length());
            } else {
                real = rs.getString(i + 1);
            }
            BigDataTest.assertEquals((String)("Compare column " + (i + 1)), (String)exected[i], (String)real);
        }
    }

    public void tearDown() throws Exception {
        this.dropTable(BIG_TABLE_NAME);
        super.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("BigDataTest");
        suite.addTest(TestConfiguration.defaultSuite(BigDataTest.class));
        return suite;
    }

    public void testMixture() throws SQLException {
        int[] ia = new int[]{32672, 32672, 32672, 32672};
        boolean[] useClob = new boolean[]{true, false, false, true};
        this.createTable(BIG_TABLE_NAME, ia, useClob);
        String[] sa = new String[]{"a", "b", "c", "d"};
        this.insertOneRow(BIG_TABLE_NAME, sa, ia);
        String[] row = this.getStringArray(sa, ia);
        String[][] expected = new String[][]{row};
        this.validTable(expected, BIG_TABLE_NAME);
        this.insertOneRow(BIG_TABLE_NAME, sa, ia);
        this.insertOneRow(BIG_TABLE_NAME, sa, ia);
        expected = new String[][]{row, row, row};
        this.validTable(expected, BIG_TABLE_NAME);
        String sql1 = BigDataTest.getSelectSql(BIG_TABLE_NAME);
        Statement st = this.createStatement(1004, 1007);
        ResultSet rs = st.executeQuery(sql1);
        BigDataTest.assertEquals((String)"Before operation, row No. is 0.", (int)0, (int)rs.getRow());
        rs.first();
        BigDataTest.assertEquals((String)"After calling first(), row No. is 1.", (int)1, (int)rs.getRow());
        this.validSingleRow(row, useClob, rs);
        rs.next();
        BigDataTest.assertEquals((String)"After calling next(), row No. is 2.", (int)2, (int)rs.getRow());
        this.validSingleRow(row, useClob, rs);
        rs.previous();
        BigDataTest.assertEquals((String)"After calling previous(), row No. is 1.", (int)1, (int)rs.getRow());
        this.validSingleRow(row, useClob, rs);
        rs.last();
        BigDataTest.assertEquals((String)"After calling last(), row No. is 3.", (int)3, (int)rs.getRow());
        this.validSingleRow(row, useClob, rs);
        rs.close();
        st.close();
    }

    public void testScrolling() throws SQLException {
        int[] lens = new int[]{10000, 10000, 10000, 10000};
        boolean[] useClob = new boolean[]{false, false, false, false};
        this.createTable(BIG_TABLE_NAME, lens, useClob);
        String[] sa1 = new String[]{"a", "b", "c", "d"};
        this.insertOneRow(BIG_TABLE_NAME, sa1, lens);
        String[] sa2 = new String[]{"e", "f", "g", "h"};
        this.insertOneRow(BIG_TABLE_NAME, sa2, lens);
        String[] sa3 = new String[]{"i", "j", "k", "l"};
        this.insertOneRow(BIG_TABLE_NAME, sa3, lens);
        String[] sa4 = new String[]{"m", "n", "o", "p"};
        this.insertOneRow(BIG_TABLE_NAME, sa4, lens);
        String[] row1 = this.getStringArray(sa1, lens);
        String[] row2 = this.getStringArray(sa2, lens);
        String[] row3 = this.getStringArray(sa3, lens);
        String[] row4 = this.getStringArray(sa4, lens);
        String[][] expected = new String[][]{row1, row2, row3, row4};
        this.validTable(expected, BIG_TABLE_NAME);
        String sql = BigDataTest.getSelectSql(BIG_TABLE_NAME);
        Statement st = this.createStatement(1004, 1007);
        ResultSet rs = st.executeQuery(sql);
        rs.first();
        this.validSingleRow(row1, useClob, rs);
        rs.next();
        this.validSingleRow(row2, useClob, rs);
        rs.previous();
        this.validSingleRow(row1, useClob, rs);
        rs.last();
        this.validSingleRow(row4, useClob, rs);
        rs.close();
        rs = st.executeQuery(sql);
        rs.last();
        this.validSingleRow(row4, useClob, rs);
        rs.close();
        st.close();
    }

    public void testBigColumn() throws SQLException {
        int[] ia = new int[]{40000};
        boolean[] useClob = new boolean[]{true};
        this.createTable(BIG_TABLE_NAME, ia, useClob);
        String[] sa = new String[]{"a"};
        this.insertOneRow(BIG_TABLE_NAME, sa, ia);
        String[][] expected = new String[][]{this.getStringArray(sa, ia)};
        this.validTable(expected, BIG_TABLE_NAME);
    }

    public void testSeveralBigColumns() throws SQLException {
        int[] ia = new int[]{40000, 40000, 40000};
        boolean[] useClob = new boolean[]{true, true, true};
        this.createTable(BIG_TABLE_NAME, ia, useClob);
        String[] sa = new String[]{"a", "b", "c"};
        this.insertOneRow(BIG_TABLE_NAME, sa, ia);
        String[] sa1 = new String[]{"d", "e", "f"};
        this.insertOneRow(BIG_TABLE_NAME, sa1, ia);
        String[][] expected = new String[][]{this.getStringArray(sa, ia), this.getStringArray(sa1, ia)};
        this.validTable(expected, BIG_TABLE_NAME);
    }

    public void testBigRow() throws SQLException {
        int[] ia = new int[]{10000, 10000, 10000, 10000};
        boolean[] useClob = new boolean[]{false, false, false, false};
        this.createTable(BIG_TABLE_NAME, ia, useClob);
        String[] sa = new String[]{"a", "b", "c", "d"};
        this.insertOneRow(BIG_TABLE_NAME, sa, ia);
        String[][] expected = new String[][]{this.getStringArray(sa, ia)};
        this.validTable(expected, BIG_TABLE_NAME);
        String[] sa1 = new String[]{"e", "f", "g", "h"};
        this.insertOneRow(BIG_TABLE_NAME, sa1, ia);
        expected = new String[][]{expected[0], this.getStringArray(sa1, ia)};
        this.validTable(expected, BIG_TABLE_NAME);
    }

    public void testDefaultQueryBlock() throws SQLException {
        int[] lens = new int[]{30000, 2752};
        boolean[] useClob = new boolean[]{false, false};
        this.createTable(BIG_TABLE_NAME, lens, useClob);
        String[] sa = new String[]{"a", "b"};
        this.insertOneRow(BIG_TABLE_NAME, sa, lens);
        String[][] expected = new String[][]{this.getStringArray(sa, lens)};
        this.validTable(expected, BIG_TABLE_NAME);
    }

    public void testSpanQRYDTABlocks() throws SQLException {
        int[] lens = new int[]{32672, 32672, 32672, 32672};
        boolean[] useClob = new boolean[]{false, false, false, false};
        this.createTable(BIG_TABLE_NAME, lens, useClob);
        String[] sa = new String[]{"a", "b", "c", "d"};
        this.insertOneRow(BIG_TABLE_NAME, sa, lens);
        String[] row = this.getStringArray(sa, lens);
        String[][] expected = new String[][]{row};
        this.validTable(expected, BIG_TABLE_NAME);
        this.insertOneRow(BIG_TABLE_NAME, sa, lens);
        this.insertOneRow(BIG_TABLE_NAME, sa, lens);
        expected = new String[][]{row, row, row};
        this.validTable(expected, BIG_TABLE_NAME);
        String sql1 = BigDataTest.getSelectSql(BIG_TABLE_NAME);
        Statement st = this.createStatement(1004, 1007);
        ResultSet rs = st.executeQuery(sql1);
        BigDataTest.assertEquals((String)"Before operation, row No. is 0.", (int)0, (int)rs.getRow());
        rs.first();
        BigDataTest.assertEquals((String)"After calling first(), row No. is 1.", (int)1, (int)rs.getRow());
        this.validSingleRow(row, useClob, rs);
        rs.next();
        BigDataTest.assertEquals((String)"After calling next(), row No. is 2.", (int)2, (int)rs.getRow());
        this.validSingleRow(row, useClob, rs);
        rs.previous();
        BigDataTest.assertEquals((String)"After calling previous(), row No. is 1.", (int)1, (int)rs.getRow());
        this.validSingleRow(row, useClob, rs);
        rs.last();
        BigDataTest.assertEquals((String)"After calling last(), row No. is 3.", (int)3, (int)rs.getRow());
        this.validSingleRow(row, useClob, rs);
        rs.close();
        st.close();
    }

    public void testTooBigSQLCARD() throws SQLException {
        int[] lens = new int[]{30000, 2750};
        boolean[] useClob = new boolean[]{false, false};
        this.createTable(BIG_TABLE_NAME, lens, useClob);
        String[] sa = new String[]{"a", "b"};
        this.insertOneRow(BIG_TABLE_NAME, sa, lens);
        String[][] expected = new String[][]{this.getStringArray(sa, lens)};
        this.validTable(expected, BIG_TABLE_NAME);
    }

    public void testLongVarchar() throws SQLException {
        String sql = "create table big(lvc long varchar )";
        this.createTable(sql);
        String[] sa = new String[]{"a", "a", "a", "a", "a"};
        int[] timesArray = new int[]{1000, 2000, 3000, 32000, 32700};
        String[][] rows = this.getRowsWithOnlyOneColumn(sa, timesArray);
        this.insertMultipleRows(BIG_TABLE_NAME, rows);
        this.validTable(rows, BIG_TABLE_NAME);
    }

    public void testVarchar() throws SQLException {
        String sql = "create table big(vc varchar(32672))";
        this.createTable(sql);
        String[] sa = new String[]{"a", "a", "a", "a", "a"};
        int[] timesArray = new int[]{1000, 2000, 3000, 32000, 32672};
        String[][] rows = this.getRowsWithOnlyOneColumn(sa, timesArray);
        this.insertMultipleRows(BIG_TABLE_NAME, rows);
        this.validTable(rows, BIG_TABLE_NAME);
    }
}

