/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.client.ClientXid;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XATestUtil;

public class XATransactionTest
extends BaseJDBCTestCase {
    public void testPendingLocalTranAndServerShutdown() throws Exception {
        if (XATransactionTest.usingEmbedded()) {
            return;
        }
        XADataSource xaDataSource = J2EEDataSource.getXADataSource();
        XAConnection xaconn = xaDataSource.getXAConnection();
        XAResource xar = xaconn.getXAResource();
        Connection conn = xaconn.getConnection();
        Statement s = conn.createStatement();
        s.executeUpdate("create table tab(i int)");
        s.executeUpdate("insert into tab values (1),(2),(3),(4)");
        conn.commit();
        conn.setAutoCommit(false);
        ResultSet rs = s.executeQuery("select * from tab");
        rs.next();
        TestConfiguration.getCurrent().stopNetworkServer();
        TestConfiguration.getCurrent().startNetworkServer();
    }

    public void testGlobalXIDinTransactionTable() throws Exception {
        Statement stm = this.getConnection().createStatement();
        stm.execute("create table XATT2 (i int, text char(10))");
        XADataSource xaDataSource = J2EEDataSource.getXADataSource();
        XAConnection xaConn = xaDataSource.getXAConnection();
        XAResource xaRes = xaConn.getXAResource();
        Connection conn = xaConn.getConnection();
        byte[] gid = new byte[64];
        byte[] bid = new byte[64];
        for (int i = 0; i < 64; ++i) {
            gid[i] = (byte)i;
            bid[i] = (byte)(64 - i);
        }
        ClientXid xid = new ClientXid(4660, gid, bid);
        xaConn = xaDataSource.getXAConnection();
        xaRes = xaConn.getXAResource();
        conn = xaConn.getConnection();
        xaRes.start((Xid)xid, 0);
        stm = conn.createStatement();
        stm.execute("insert into XATT2 values (1234, 'Test_Entry')");
        stm.close();
        xaRes.end((Xid)xid, 0x4000000);
        ResultSet rs = null;
        stm = null;
        try {
            stm = this.getConnection().createStatement();
            String query = "select global_xid from syscs_diag.transaction_table where global_xid is not null";
            rs = stm.executeQuery(query);
            XATransactionTest.assertTrue((boolean)rs.next());
            Xid rXid = XATransactionTest.parseXid(rs.getString(1));
            XATransactionTest.assertEquals((Object)xid, (Object)rXid);
            XATransactionTest.assertFalse((boolean)rs.next());
        }
        catch (Exception ex) {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
                xaRes.rollback((Xid)xid);
                xaConn.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw ex;
        }
        rs.close();
        stm.close();
        xaRes.rollback((Xid)xid);
        xaConn.close();
    }

    public void testXATransactionTimeout() throws Exception {
        int timeoutStatementsToExecute = 66;
        int timeoutCommitEveryStatement = 3;
        int timeoutStatementsCommitted = (timeoutStatementsToExecute + timeoutCommitEveryStatement - 1) / timeoutCommitEveryStatement;
        Statement stm = this.getConnection().createStatement();
        stm.execute("create table XATT (i int, text char(10))");
        XADataSource xaDataSource = J2EEDataSource.getXADataSource();
        XAConnection[] xaConn = new XAConnection[timeoutStatementsToExecute];
        XAResource xaRes = null;
        Connection conn = null;
        for (int i = 0; i < timeoutStatementsToExecute; ++i) {
            xaConn[i] = xaDataSource.getXAConnection();
            xaRes = xaConn[i].getXAResource();
            conn = xaConn[i].getConnection();
            Xid xid = XATransactionTest.createXid(123, i);
            xaRes.setTransactionTimeout(8);
            xaRes.start(xid, 0);
            stm = conn.createStatement();
            stm.execute("insert into XATT values (" + i + ", 'Test_Entry')");
            if (i % timeoutCommitEveryStatement == 0) {
                stm.close();
                xaRes.end(xid, 0x4000000);
                xaRes.prepare(xid);
                xaRes.commit(xid, false);
                continue;
            }
            if (i % 11 != 0) {
                block8: {
                    try {
                        xaRes.end(xid, 0x20000000);
                        XATransactionTest.fail();
                    }
                    catch (XAException ex) {
                        if (ex.errorCode >= 100 && ex.errorCode <= 107) break block8;
                        throw ex;
                    }
                }
                stm.close();
                continue;
            }
            if (i % 2 != 0) continue;
            xaRes.end(xid, 0x4000000);
            stm.close();
        }
        ResultSet rs = null;
        stm = this.getConnection().createStatement();
        rs = stm.executeQuery("select count(*) from XATT");
        rs.next();
        XATransactionTest.assertTrue((rs.getInt(1) == timeoutStatementsCommitted ? 1 : 0) != 0);
        XAConnection xaConn2 = xaDataSource.getXAConnection();
        xaRes = xaConn2.getXAResource();
        conn = xaConn2.getConnection();
        Xid xid = XATransactionTest.createXid(124, 100);
        xaRes.setTransactionTimeout(10);
        xaRes.start(xid, 0);
        stm = conn.createStatement();
        try {
            rs = stm.executeQuery("select count(*) from sys.syscolumns a, sys.syscolumns b, sys.syscolumns c, sys.syscolumns d, sys.syscolumns e group by a.referenceid, b.referenceid, c.referenceid, d.referenceid");
            XATransactionTest.fail((String)"An exception is expected here");
        }
        catch (SQLException ex) {
            XATransactionTest.assertSQLState("XCL52.S".substring(0, 5), ex);
        }
        stm = this.getConnection().createStatement();
        rs = stm.executeQuery("select count(*) from XATT");
        rs.next();
        for (int i = 0; i < timeoutStatementsToExecute; ++i) {
            XATransactionTest.assertNotNull((Object)xaConn[i]);
            xaConn[i].close();
        }
        XATransactionTest.assertTrue((rs.getInt(1) == timeoutStatementsCommitted ? 1 : 0) != 0);
    }

    public void testTransactionTimeoutAndSuspendResume() throws Exception {
        XADataSource xads = J2EEDataSource.getXADataSource();
        XAConnection xac = xads.getXAConnection();
        XAResource xar = xac.getXAResource();
        Xid xid = XATestUtil.getXid(1, 2, 3);
        xar.setTransactionTimeout(500);
        xar.start(xid, 0);
        xar.end(xid, 0x2000000);
        xar.start(xid, 0x8000000);
        xar.end(xid, 0x4000000);
        xar.rollback(xid);
        xac.close();
    }

    public void testTransactionTimeoutAndJoin() throws Exception {
        XADataSource xads = J2EEDataSource.getXADataSource();
        XAConnection xac1 = xads.getXAConnection();
        XAResource xar1 = xac1.getXAResource();
        Xid xid1 = XATestUtil.getXid(4, 5, 6);
        xar1.setTransactionTimeout(500);
        xar1.start(xid1, 0);
        xar1.end(xid1, 0x4000000);
        XAConnection xac2 = xads.getXAConnection();
        XAResource xar2 = xac2.getXAResource();
        xar2.setTransactionTimeout(500);
        Xid xid2 = XATestUtil.getXid(4, 5, 7);
        xar2.start(xid2, 0);
        xar2.end(xid2, 0x4000000);
        xar2.rollback(xid2);
        XATransactionTest.assertTrue((String)"Branches can only be joined if RM is same", (boolean)xar1.isSameRM(xar2));
        xar2.start(xid1, 0x200000);
        xar2.end(xid1, 0x4000000);
        xar2.rollback(xid1);
        xac1.close();
        xac2.close();
    }

    public void testXAExceptionErrorCodeOnSQLExceptionDerby4141() throws Exception {
        XADataSource xaDataSource = J2EEDataSource.getXADataSource();
        XAConnection xaConn = xaDataSource.getXAConnection();
        XAResource xaRes = xaConn.getXAResource();
        Xid xid = XATransactionTest.createXid(123, 1);
        xaConn.close();
        try {
            xaRes.start(xid, 0);
            XATransactionTest.fail((String)"Should have gotten an XAException. xaConn is closed.");
        }
        catch (XAException xae) {
            XATransactionTest.assertEquals((int)-7, (int)xae.errorCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForgetExceptionDerby1016PROTO() throws XAException, SQLException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xads, "databaseName", "wombat");
        XAConnection xaconn = xads.getXAConnection();
        XAResource xar = xaconn.getXAResource();
        Xid xid = XATransactionTest.createXid(93, 18);
        xar.start(xid, 0);
        Connection conn = xaconn.getConnection();
        Statement s = conn.createStatement();
        s.executeUpdate("CREATE TABLE Derby1016 (I INT)");
        xar.end(xid, 0x4000000);
        xar.prepare(xid);
        try {
            xar.forget(xid);
            XATransactionTest.fail((String)"FAIL: prepared XA-Transaction forgotten");
        }
        catch (XAException XAeForget) {
            XATransactionTest.assertEquals((String)("FAIL: Got unexpected exception " + XAeForget.getMessage() + " errorCode: " + XAeForget.errorCode + "  calling forget on a prepared transaction"), (int)-6, (int)XAeForget.errorCode);
        }
        finally {
            s.close();
            xar.rollback(xid);
            conn.close();
            xaconn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForgetExceptionDerby1016NOTA() throws XAException, SQLException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xads, "databaseName", "wombat");
        XAConnection xaconn = xads.getXAConnection();
        XAResource xar = xaconn.getXAResource();
        Xid xid = XATransactionTest.createXid(93, 18);
        xar.start(xid, 0);
        Connection conn = xaconn.getConnection();
        Statement s = conn.createStatement();
        s.executeUpdate("CREATE TABLE Derby1016 (I INT)");
        xar.end(xid, 0x4000000);
        xar.prepare(xid);
        xar.commit(xid, false);
        try {
            xar.forget(xid);
            XATransactionTest.fail((String)"FAIL: able to forget committed XA-Transaction");
        }
        catch (XAException XAeForget) {
            XATransactionTest.assertEquals((String)("FAIL: Got unexpected exception " + XAeForget.getMessage() + " errorCode: " + XAeForget.errorCode + "  calling forget on a committed transaction"), (int)-4, (int)XAeForget.errorCode);
        }
        finally {
            s.executeUpdate("DROP TABLE Derby1016");
            conn.commit();
            s.close();
            conn.close();
            xaconn.close();
        }
    }

    public void testDerby5562ReadOnlyTimeout() throws InterruptedException, SQLException, XAException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        XAConnection xac = xads.getXAConnection();
        XAResource xar = xac.getXAResource();
        Xid xid = XATransactionTest.createXid(55, 62);
        XATransactionTest.assertTrue((boolean)xar.setTransactionTimeout(4));
        xar.start(xid, 0);
        Connection c = xac.getConnection();
        Statement s = c.createStatement();
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from sysibm.sysdummy1"), "Y");
        s.close();
        c.close();
        xar.end(xid, 0x4000000);
        XATransactionTest.assertEquals((String)"XA_RDONLY", (int)3, (int)xar.prepare(xid));
        XATransactionTest.assertTrue((boolean)xar.setTransactionTimeout(0));
        xar.start(xid, 0);
        c = xac.getConnection();
        s = c.createStatement();
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from sysibm.sysdummy1"), "Y");
        s.close();
        c.close();
        Thread.sleep(5000L);
        xar.end(xid, 0x4000000);
        XATransactionTest.assertEquals((String)"XA_RDONLY", (int)3, (int)xar.prepare(xid));
        xac.close();
    }

    static Xid createXid(int gtrid, int bqual) throws XAException {
        byte[] gid = new byte[]{(byte)(gtrid % 256), (byte)(gtrid / 256)};
        byte[] bid = new byte[]{(byte)(bqual % 256), (byte)(bqual / 256)};
        ClientXid xid = new ClientXid(4660, gid, bid);
        return xid;
    }

    private static Xid parseXid(String str) {
        int i;
        XATransactionTest.assertNotNull((Object)str);
        XATransactionTest.assertTrue((boolean)str.matches("\\(\\p{Digit}+,\\p{XDigit}+,\\p{XDigit}+\\)"));
        String formatIdS = str.substring(1, str.indexOf(44));
        String gtidS = str.substring(str.indexOf(44) + 1, str.lastIndexOf(44));
        String bqualS = str.substring(str.lastIndexOf(44) + 1, str.length() - 1);
        XATransactionTest.assertTrue((gtidS.length() % 2 == 0 ? 1 : 0) != 0);
        XATransactionTest.assertTrue((bqualS.length() % 2 == 0 ? 1 : 0) != 0);
        int fmtid = Integer.parseInt(formatIdS);
        byte[] gtid = new byte[gtidS.length() / 2];
        byte[] bqual = new byte[bqualS.length() / 2];
        for (i = 0; i < gtid.length; ++i) {
            gtid[i] = (byte)Integer.parseInt(gtidS.substring(2 * i, 2 * i + 2), 16);
        }
        for (i = 0; i < bqual.length; ++i) {
            bqual[i] = (byte)Integer.parseInt(bqualS.substring(2 * i, 2 * i + 2), 16);
        }
        return new ClientXid(fmtid, gtid, bqual);
    }

    public XATransactionTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJDBC3()) {
            Test test = TestConfiguration.defaultSuite(XATransactionTest.class);
            test = DatabasePropertyTestSetup.setLockTimeouts(test, 20, 60);
            return test;
        }
        return new TestSuite("XATransactionTest cannot run without XA support");
    }
}

