/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class InternationalConnectTest
extends BaseJDBCTestCase {
    private ArrayList databasesForCleanup = new ArrayList();

    public InternationalConnectTest(String name) {
        super(name);
    }

    public void testBoundaries() throws SQLException, UnsupportedEncodingException {
        if (InternationalConnectTest.usingEmbedded()) {
            return;
        }
        this.getConnection();
        if (InternationalConnectTest.getSystemProperty("os.name").startsWith("Windows") && InternationalConnectTest.getSystemProperty("java.version").startsWith("1.4.2")) {
            return;
        }
        int maxNameLength = 241;
        String[] testCharacters = new String[]{"A", "\u00e7", "\u4e10", "\u1f030"};
        for (int ch = 0; ch < testCharacters.length; ++ch) {
            StringBuffer dbName = new StringBuffer();
            int maxChars = maxNameLength / testCharacters[ch].getBytes("UTF-8").length;
            for (int i = 0; i < maxChars; ++i) {
                dbName.append(testCharacters[ch]);
            }
            String url = TestConfiguration.getCurrent().getJDBCUrl(dbName.toString() + ";create=true");
            Connection conn = DriverManager.getConnection(url);
            conn.close();
            this.databasesForCleanup.add(dbName.toString());
            for (int i = 0; i < 3; ++i) {
                dbName.append(testCharacters[ch]);
            }
            url = TestConfiguration.getCurrent().getJDBCUrl(dbName.toString() + ";create=true");
            try {
                conn = DriverManager.getConnection(url);
                InternationalConnectTest.assertTrue((String)"Used more characters than possible in database name", (boolean)false);
                continue;
            }
            catch (SQLException e) {
                InternationalConnectTest.assertSQLState("08001", e);
            }
        }
    }

    public void testDriverManagerConnect() throws SQLException {
        this.getConnection();
        Connection conn = null;
        String url = null;
        url = TestConfiguration.getCurrent().getJDBCUrl("\u4e10;create=true");
        conn = DriverManager.getConnection(url);
        conn.close();
        url = TestConfiguration.getCurrent().getJDBCUrl("\u4e10;user=\u4e10");
        conn = DriverManager.getConnection(url);
        conn.close();
        url = TestConfiguration.getCurrent().getJDBCUrl("\u4e10");
        conn = DriverManager.getConnection(url, "\u4e10", "pass");
        conn.close();
        url = TestConfiguration.getCurrent().getJDBCUrl("\u4e10;user=user;password=\u4e10");
        conn = DriverManager.getConnection(url);
        conn.close();
        url = TestConfiguration.getCurrent().getJDBCUrl("\u4e10");
        conn = DriverManager.getConnection(url, "\u4e10", "\u4e10");
        conn.close();
        this.databasesForCleanup.add("\u4e10");
    }

    public void testXADSConnect() throws SQLException {
        XADataSource ds = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(ds, "databaseName", "\u4e10");
        J2EEDataSource.setBeanProperty(ds, "createDatabase", "create");
        XAConnection xaconn = ds.getXAConnection();
        Connection conn = xaconn.getConnection();
        conn.close();
        xaconn.close();
        J2EEDataSource.setBeanProperty(ds, "user", "\u4e10");
        xaconn = ds.getXAConnection();
        conn = xaconn.getConnection();
        conn.close();
        xaconn.close();
        J2EEDataSource.setBeanProperty(ds, "password", "\u4e10");
        xaconn = ds.getXAConnection();
        conn = xaconn.getConnection();
        conn.close();
        xaconn.close();
        this.databasesForCleanup.add("\u4e10");
    }

    public void testCPDSConnect() throws SQLException {
        ConnectionPoolDataSource ds = J2EEDataSource.getConnectionPoolDataSource();
        J2EEDataSource.setBeanProperty(ds, "databaseName", "\u4e10");
        J2EEDataSource.setBeanProperty(ds, "createDatabase", "create");
        PooledConnection poolConn = ds.getPooledConnection();
        Connection conn = poolConn.getConnection();
        conn.close();
        poolConn.close();
        J2EEDataSource.setBeanProperty(ds, "user", "\u4e10");
        poolConn = ds.getPooledConnection();
        conn = poolConn.getConnection();
        conn.close();
        poolConn.close();
        J2EEDataSource.setBeanProperty(ds, "password", "\u4e10");
        poolConn = ds.getPooledConnection();
        conn = poolConn.getConnection();
        conn.close();
        poolConn.close();
        this.databasesForCleanup.add("\u4e10");
    }

    public void testFailureOnNonExistentDatabase() throws SQLException {
        String url = TestConfiguration.getCurrent().getJDBCUrl("abcdefghijklmnopq\u00e5");
        try {
            DriverManager.getConnection(url);
            InternationalConnectTest.fail((String)(url + " should not exist"));
        }
        catch (SQLException sqle) {
            String expected = InternationalConnectTest.usingEmbedded() ? "XJ004" : "08004";
            InternationalConnectTest.assertSQLState(expected, sqle);
        }
    }

    public void tearDown() throws Exception {
        for (int i = 0; i < this.databasesForCleanup.size(); ++i) {
            String shutdownUrl = TestConfiguration.getCurrent().getJDBCUrl(this.databasesForCleanup.get(i) + ";shutdown=true");
            try {
                DriverManager.getConnection(shutdownUrl);
                InternationalConnectTest.fail((String)"Database didn't shut down");
            }
            catch (SQLException se) {
                InternationalConnectTest.assertSQLState("08006", se);
            }
            InternationalConnectTest.removeDirectory(InternationalConnectTest.getSystemProperty("derby.system.home") + File.separator + this.databasesForCleanup.get(i));
        }
        this.databasesForCleanup = null;
        super.tearDown();
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(InternationalConnectTest.class);
    }
}

