/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.TimeZoneTestSetup;

public class DaylightSavingTest
extends BaseJDBCTestCase {
    public DaylightSavingTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TimeZoneTestSetup(TestConfiguration.defaultSuite(DaylightSavingTest.class), "America/Chicago");
    }

    public void testConversionToGMTAroundDSTChange() throws SQLException {
        int i;
        int i2;
        Statement s = this.createStatement();
        s.execute("CREATE TABLE DERBY4582(ID INT PRIMARY KEY GENERATED ALWAYS AS IDENTITY, TS TIMESTAMP, T TIME, D DATE, T2 TIME, D2 DATE, TS_STR VARCHAR(100), T_STR VARCHAR(100), D_STR VARCHAR(100))");
        Calendar localCal = Calendar.getInstance();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1, 2010);
        cal.set(2, 2);
        cal.set(5, 12);
        cal.set(11, 0);
        cal.set(12, 1);
        cal.set(13, 0);
        cal.set(14, 0);
        Timestamp[] timestamps = new Timestamp[96];
        Time[] times = new Time[timestamps.length];
        java.sql.Date[] dates = new java.sql.Date[timestamps.length];
        for (int i3 = 0; i3 < timestamps.length; ++i3) {
            long time = cal.getTimeInMillis();
            timestamps[i3] = new Timestamp(time);
            times[i3] = new Time(time);
            dates[i3] = new java.sql.Date(time);
            cal.setTimeInMillis(time + 3600000L);
        }
        PreparedStatement insert = this.prepareStatement("INSERT INTO DERBY4582 (TS, T, D, T2, D2, TS_STR, T_STR, D_STR) VALUES (?,?,?,?,?,?,?,?)");
        for (int i4 = 0; i4 < timestamps.length; ++i4) {
            Timestamp ts = timestamps[i4];
            Time t = times[i4];
            java.sql.Date d = dates[i4];
            insert.setTimestamp(1, ts, cal);
            insert.setTime(2, t, cal);
            insert.setDate(3, d, cal);
            insert.setTimestamp(4, ts, cal);
            insert.setTimestamp(5, ts, cal);
            insert.setTimestamp(6, ts, cal);
            insert.setTime(7, t, cal);
            insert.setDate(8, d, cal);
            insert.execute();
        }
        ResultSet rs = s.executeQuery("SELECT * FROM DERBY4582 ORDER BY ID");
        for (i2 = 0; i2 < timestamps.length; ++i2) {
            DaylightSavingTest.assertTrue((String)("found only " + i2 + " rows"), (boolean)rs.next());
            DaylightSavingTest.assertEquals((String)"ID", (int)(i2 + 1), (int)rs.getInt(1));
            DaylightSavingTest.assertEquals((String)"TS", (Object)timestamps[i2], (Object)rs.getTimestamp(2, cal));
            DaylightSavingTest.assertEquals("T", DaylightSavingTest.stripDate(times[i2], cal), rs.getTime(3, cal));
            DaylightSavingTest.assertEquals((String)"D", (Object)DaylightSavingTest.stripTime(dates[i2], cal), (Object)rs.getDate(4, cal));
            DaylightSavingTest.assertEquals("T2", DaylightSavingTest.stripDate(times[i2], cal), rs.getTime(5, cal));
            DaylightSavingTest.assertEquals((String)"D2", (Object)DaylightSavingTest.stripTime(dates[i2], cal), (Object)rs.getDate(6, cal));
            DaylightSavingTest.assertEquals((String)"TS_STR", (Object)timestamps[i2], (Object)rs.getTimestamp(7, cal));
            DaylightSavingTest.assertEquals("T_STR", DaylightSavingTest.stripDate(times[i2], cal), rs.getTime(8, cal));
            DaylightSavingTest.assertEquals((String)"D_STR", (Object)DaylightSavingTest.stripTime(dates[i2], cal), (Object)rs.getDate(9, cal));
        }
        JDBC.assertEmpty(rs);
        rs = s.executeQuery("SELECT ID,T,D,TS,TS FROM DERBY4582 ORDER BY ID");
        for (i2 = 0; i2 < timestamps.length; ++i2) {
            DaylightSavingTest.assertTrue((String)("found only " + i2 + " rows"), (boolean)rs.next());
            DaylightSavingTest.assertEquals((String)"ID", (int)(i2 + 1), (int)rs.getInt(1));
            DaylightSavingTest.assertEquals((String)"TIME AS TIMESTAMP", (Object)DaylightSavingTest.timeToTimestamp(DaylightSavingTest.stripDate(times[i2], cal), cal), (Object)rs.getTimestamp(2, cal));
            DaylightSavingTest.assertEquals((String)"DATE AS TIMESTAMP", (Object)DaylightSavingTest.dateToTimestamp(DaylightSavingTest.stripTime(dates[i2], cal), cal), (Object)rs.getTimestamp(3, cal));
            DaylightSavingTest.assertEquals("TIMESTAMP AS TIME", DaylightSavingTest.stripDate(timestamps[i2], cal), rs.getTime(4, cal));
            DaylightSavingTest.assertEquals((String)"TIMESTAMP AS DATE", (Object)DaylightSavingTest.stripTime(timestamps[i2], cal), (Object)rs.getDate(5, cal));
        }
        JDBC.assertEmpty(rs);
        Statement updStmt = this.createStatement(1003, 1008);
        rs = updStmt.executeQuery("SELECT TS, T, D FROM DERBY4582");
        for (i = 0; i < timestamps.length; ++i) {
            DaylightSavingTest.assertTrue((String)("found only " + i + " rows"), (boolean)rs.next());
            Timestamp ts1 = timestamps[i];
            rs.updateTimestamp(1, ts1);
            DaylightSavingTest.assertEquals((String)"TS (default calendar)", (Object)ts1, (Object)rs.getTimestamp(1));
            Timestamp ts2 = rs.getTimestamp(1, cal);
            cal.clear();
            cal.setTime(ts2);
            localCal.clear();
            localCal.setTime(ts1);
            DaylightSavingTest.assertEquals((String)"TS.YEAR", (int)localCal.get(1), (int)cal.get(1));
            DaylightSavingTest.assertEquals((String)"TS.MONTH", (int)localCal.get(2), (int)cal.get(2));
            DaylightSavingTest.assertEquals((String)"TS.DATE", (int)localCal.get(5), (int)cal.get(5));
            DaylightSavingTest.assertEquals((String)"TS.HOURS", (int)localCal.get(11), (int)cal.get(11));
            DaylightSavingTest.assertEquals((String)"TS.MINUTES", (int)localCal.get(12), (int)cal.get(12));
            DaylightSavingTest.assertEquals((String)"TS.SECONDS", (int)localCal.get(13), (int)cal.get(13));
            DaylightSavingTest.assertEquals((String)"TS.NANOS", (int)ts1.getNanos(), (int)ts2.getNanos());
            Time t12 = times[i];
            rs.updateTime(2, t12);
            DaylightSavingTest.assertEquals("T (default calendar)", DaylightSavingTest.stripDate(t12, localCal), rs.getTime(2));
            Time t22 = rs.getTime(2, cal);
            cal.clear();
            cal.setTime(t22);
            localCal.clear();
            localCal.setTime(t12);
            DaylightSavingTest.assertEquals((String)"T.HOURS", (int)localCal.get(11), (int)cal.get(11));
            DaylightSavingTest.assertEquals((String)"T.MINUTES", (int)localCal.get(12), (int)cal.get(12));
            DaylightSavingTest.assertEquals((String)"T.SECONDS", (int)localCal.get(13), (int)cal.get(13));
            java.sql.Date d1 = dates[i];
            rs.updateDate(3, d1);
            DaylightSavingTest.assertEquals((String)"D (default calendar)", (Object)DaylightSavingTest.stripTime(d1, localCal), (Object)rs.getDate(3));
            java.sql.Date d2 = rs.getDate(3, cal);
            cal.clear();
            cal.setTime(d2);
            localCal.clear();
            localCal.setTime(d1);
            DaylightSavingTest.assertEquals((String)"D.YEAR", (int)localCal.get(1), (int)cal.get(1));
            DaylightSavingTest.assertEquals((String)"D.MONTH", (int)localCal.get(2), (int)cal.get(2));
            DaylightSavingTest.assertEquals((String)"D.DATE", (int)localCal.get(5), (int)cal.get(5));
            rs.updateRow();
        }
        JDBC.assertEmpty(rs);
        rs = s.executeQuery("SELECT TS, T, D FROM DERBY4582 ORDER BY TS");
        for (i = 0; i < timestamps.length; ++i) {
            DaylightSavingTest.assertTrue((String)("found only " + i + " rows"), (boolean)rs.next());
            DaylightSavingTest.assertEquals((String)"TS", (Object)timestamps[i], (Object)rs.getTimestamp(1));
            DaylightSavingTest.assertEquals("T", DaylightSavingTest.stripDate(times[i], localCal), rs.getTime(2));
            DaylightSavingTest.assertEquals((String)"D", (Object)DaylightSavingTest.stripTime(dates[i], localCal), (Object)rs.getDate(3));
        }
        JDBC.assertEmpty(rs);
    }

    private static Time stripDate(Date time, Calendar cal) {
        cal.clear();
        cal.setTime(time);
        cal.set(1970, 0, 1);
        return new Time(cal.getTimeInMillis());
    }

    private static java.sql.Date stripTime(Date date, Calendar cal) {
        cal.clear();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    private static Timestamp timeToTimestamp(Time time, Calendar cal) {
        cal.clear();
        cal.setTimeInMillis(System.currentTimeMillis());
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        cal.clear();
        cal.setTime(time);
        cal.set(year, month, day);
        return new Timestamp(cal.getTimeInMillis());
    }

    private static Timestamp dateToTimestamp(java.sql.Date date, Calendar cal) {
        cal.clear();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new Timestamp(cal.getTimeInMillis());
    }
}

