/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LobStreamTest
extends BaseJDBCTestCase {
    private InputStream in = null;
    private OutputStream out = null;
    private Blob blob;

    public LobStreamTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        Connection conn = this.getConnection();
        this.blob = conn.createBlob();
        this.in = this.blob.getBinaryStream();
        this.out = this.blob.setBinaryStream(1L);
    }

    @Override
    protected void tearDown() throws Exception {
        this.blob.free();
        this.blob = null;
        super.tearDown();
    }

    public void testReadWriteNoParameters() throws IOException {
        int i;
        for (i = 0; i < 8000; ++i) {
            this.out.write(i % 255);
        }
        for (i = 0; i < 8000; ++i) {
            int value = this.in.read();
            LobStreamTest.assertEquals((String)"Output does not match input", (int)(i % 255), (int)value);
        }
        this.in.close();
        this.in = null;
        this.out.close();
        this.out = null;
    }

    public void testReadNoParameterWriteOneParameter() throws IOException {
        int i;
        byte[] b = new byte[100];
        for (i = 0; i < 8000; ++i) {
            b[i % 100] = (byte)((byte)(i % 255) & 0xFF);
            if (i % 100 != 99) continue;
            this.out.write(b);
        }
        for (i = 0; i < 8000; ++i) {
            int value = this.in.read();
            LobStreamTest.assertEquals((String)"Output does not match input", (int)(i % 255), (int)value);
        }
        this.in.close();
        this.in = null;
        this.out.close();
        this.out = null;
    }

    public void testReadWriteOneParameter() throws IOException {
        int i;
        byte[] b = new byte[100];
        for (i = 0; i < 8000; ++i) {
            b[i % 100] = (byte)((byte)(i % 255) & 0xFF);
            if (i % 100 != 99) continue;
            this.out.write(b);
        }
        for (i = 0; i < 80; ++i) {
            int count = this.in.read(b);
            for (int j = 0; j < count; ++j) {
                int value = b[j] & 0xFF;
                LobStreamTest.assertEquals((String)"Output does not match input", (int)((i * 100 + j) % 255), (int)value);
            }
        }
        this.in.close();
        this.in = null;
        this.out.close();
        this.out = null;
    }

    public void testReadWriteThreeParameter() throws IOException {
        int i;
        byte[] b = new byte[200];
        int offset = 0;
        for (i = 0; i < 8000; ++i) {
            b[i % 100 + offset] = (byte)((byte)(i % 255) & 0xFF);
            if (i % 100 != 99) continue;
            this.out.write(b, offset, 100);
            ++offset;
        }
        offset = 0;
        for (i = 0; i < 80; ++i) {
            int count = this.in.read(b, offset, 100);
            for (int j = 0; j < count; ++j) {
                int value = b[j + offset] & 0xFF;
                LobStreamTest.assertEquals((String)"Output does not match input", (int)((i * 100 + j) % 255), (int)value);
            }
            ++offset;
        }
        this.in.close();
        this.in = null;
        this.out.close();
        this.out = null;
    }

    public void testEndOfStreamValue() throws IOException {
        for (int i = 0; i < 8000; ++i) {
            this.out.write(i % 255);
        }
        int count = 0;
        while (this.in.read() != -1) {
            ++count;
        }
        LobStreamTest.assertEquals((String)"All values have been read", (int)8000, (int)count);
        this.in.close();
        this.in = null;
        this.out.close();
        this.out = null;
    }

    public void testEndOfStreamOnReadOneParameter() throws IOException {
        for (int i = 0; i < 8050; ++i) {
            this.out.write(i % 255);
        }
        int count = 0;
        int totalCount = 0;
        byte[] b = new byte[100];
        LobStreamTest.assertTrue((String)"b.length should not be = 0", (b.length != 0 ? 1 : 0) != 0);
        while ((count = this.in.read(b)) != -1) {
            LobStreamTest.assertTrue((String)"Number of bytes read can not be = 0", (count != 0 ? 1 : 0) != 0);
            totalCount += count;
        }
        LobStreamTest.assertEquals((String)"All values have been read", (int)8050, (int)totalCount);
        this.in.close();
        this.in = null;
        this.out.close();
        this.out = null;
    }

    public void testEndOfStreamOnReadThreeParameters() throws IOException {
        for (int i = 0; i < 8050; ++i) {
            this.out.write(i % 255);
        }
        int count = 0;
        int totalCount = 0;
        int offset = 0;
        byte[] b = new byte[200];
        LobStreamTest.assertTrue((String)"b.length should not be = 0", (b.length != 0 ? 1 : 0) != 0);
        while ((count = this.in.read(b, offset, 100)) != -1) {
            LobStreamTest.assertTrue((String)"Number of bytes read can not be = 0", (count != 0 ? 1 : 0) != 0);
            totalCount += count;
            ++offset;
        }
        LobStreamTest.assertEquals((String)"All values have been read", (int)8050, (int)totalCount);
        this.in.close();
        this.in = null;
        this.out.close();
        this.out = null;
    }

    public void testSkip() throws IOException {
        int i;
        for (i = 0; i < 8000; ++i) {
            this.out.write(i % 255);
        }
        i = 0;
        while (i < 8000) {
            if (i % 255 < 100) {
                int value = this.in.read();
                LobStreamTest.assertEquals((String)"Output does not match input", (int)(i % 255), (int)value);
                ++i;
                continue;
            }
            long count = this.in.skip(155L);
            i = (int)((long)i + count);
        }
        this.in.close();
        this.out.close();
        this.in = null;
        this.out = null;
    }

    public void testWriteWithInvalidParameterValues() throws IOException {
        for (int i = 0; i < 8000; ++i) {
            this.out.write(i % 255);
        }
        byte[] b = null;
        try {
            this.out.write(b, 100, 20);
            LobStreamTest.fail((String)"byte[] = null should cause exception");
        }
        catch (Exception e) {
            LobStreamTest.assertTrue((String)"Expected NullPointerException", (boolean)(e instanceof NullPointerException));
        }
        b = new byte[100];
        try {
            this.out.write(b, 0, 200);
            LobStreamTest.fail((String)"length > b.length should cause exception");
        }
        catch (Exception e) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.out.write(b, 150, 0);
            LobStreamTest.fail((String)"offset > b.length should cause exception");
        }
        catch (Exception e) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.out.write(b, 50, 100);
            LobStreamTest.fail((String)"length + offset > b.length should cause exception");
        }
        catch (Exception e) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.out.write(b, -50, 100);
            LobStreamTest.fail((String)"negative offset should cause exception");
        }
        catch (Exception e) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.out.write(b, 0, -100);
            LobStreamTest.fail((String)"negative length should cause exception");
        }
        catch (Exception e) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(e instanceof IndexOutOfBoundsException));
        }
        this.out.close();
        try {
            this.out.write(b, 0, 100);
            LobStreamTest.fail((String)"Stream should be closed");
        }
        catch (Exception e) {
            LobStreamTest.assertTrue((String)"Expected IOException", (boolean)(e instanceof IOException));
        }
        this.out = null;
        this.in.close();
        this.in = null;
    }

    public void testReadWithInvalidParameterValues() throws IOException {
        for (int i = 0; i < 8000; ++i) {
            this.out.write(i % 255);
        }
        this.out.close();
        this.out = null;
        byte[] b = null;
        try {
            this.in.read(b, 100, 20);
            LobStreamTest.fail((String)"byte[] = null should cause exception");
        }
        catch (Exception e) {
            LobStreamTest.assertTrue((String)"Expected NullPointerException", (boolean)(e instanceof NullPointerException));
        }
        b = new byte[100];
        try {
            int count = this.in.read(b, 0, 200);
            LobStreamTest.fail((String)"length > b.length should cause exception");
        }
        catch (Exception e) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.in.read(b, 150, 0);
            LobStreamTest.fail((String)"offset > b.length should cause exception");
        }
        catch (Exception e) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            int count = this.in.read(b, 50, 100);
            LobStreamTest.fail((String)"offset + length > b.length should cause exception");
        }
        catch (Exception e) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.in.read(b, -50, 100);
            LobStreamTest.fail((String)"negative offset should cause exception");
        }
        catch (Exception e) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.in.read(b, 0, -100);
            LobStreamTest.fail((String)"negative length should cause exception");
        }
        catch (Exception e) {
            LobStreamTest.assertTrue((String)"Expected IndexOutOfBoundException", (boolean)(e instanceof IndexOutOfBoundsException));
        }
        this.in.close();
        try {
            this.in.read(b, 0, 100);
            LobStreamTest.fail((String)"Stream should be closed");
        }
        catch (Exception e) {
            LobStreamTest.assertTrue((String)"Expected IOException", (boolean)(e instanceof IOException));
        }
        this.in = null;
    }

    public static Test suite() {
        TestSuite ts = new TestSuite("LobStreamTest");
        ts.addTest(TestConfiguration.embeddedSuite(LobStreamTest.class));
        TestSuite encSuite = new TestSuite("LobStreamsTest:encrypted");
        encSuite.addTestSuite(LobStreamTest.class);
        ts.addTest(Decorator.encryptedDatabase((Test)encSuite));
        return ts;
    }
}

