/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41Conn;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41Test;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConnectionMethodsTest
extends Wrapper41Test {
    public static final String CLOSED_CONNECTION = "08003";
    FileInputStream is;

    public ConnectionMethodsTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ConnectionMethodsTest");
        suite.addTest(ConnectionMethodsTest.baseSuite("ConnectionMethodsTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(ConnectionMethodsTest.baseSuite("ConnectionMethodsTest:client")));
        return suite;
    }

    public static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(ConnectionMethodsTest.class, name);
        SupportFilesSetup test = new SupportFilesSetup((Test)suite, new String[]{"functionTests/testData/ConnectionMethods/short.txt"});
        return new CleanDatabaseTestSetup((Test)test){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("create table clobtable2(n int,clobcol CLOB)");
                s.execute("create table blobtable2(n int,blobcol BLOB)");
                s.execute("create table abort_table(a int)");
                s.execute("create schema foo");
                s.execute("create table foo.set_schema_table( a int )");
            }
        };
    }

    public void testCreateClob() throws SQLException, FileNotFoundException, IOException, Exception {
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        PreparedStatement ps = this.prepareStatement("insert into clobtable2 (n, clobcol) values(?,?)");
        ps.setInt(1, 1000);
        Clob clob = conn.createClob();
        try {
            this.is = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws FileNotFoundException {
                    return new FileInputStream("extin/short.txt");
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
        OutputStream os = clob.setAsciiStream(1L);
        ArrayList<Integer> beforeUpdateList = new ArrayList<Integer>();
        int c = this.is.read();
        while (c > 0) {
            os.write(c);
            beforeUpdateList.add(c);
            c = this.is.read();
        }
        ps.setClob(2, clob);
        ps.executeUpdate();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select clobcol from clobtable2 where n = 1000");
        ConnectionMethodsTest.assertTrue((boolean)rs.next());
        clob = rs.getClob(1);
        ConnectionMethodsTest.assertEquals((long)beforeUpdateList.size(), (long)clob.length());
        InputStream in = clob.getAsciiStream();
        ArrayList<Integer> afterUpdateList = new ArrayList<Integer>();
        int b = in.read();
        while (b > -1) {
            afterUpdateList.add(b);
            b = in.read();
        }
        ConnectionMethodsTest.assertEquals((int)beforeUpdateList.size(), (int)afterUpdateList.size());
        int i = 0;
        while ((long)i < clob.length()) {
            ConnectionMethodsTest.assertEquals(beforeUpdateList.get(i), afterUpdateList.get(i));
            ++i;
        }
        os.close();
        this.is.close();
    }

    public void testCreateBlob() throws SQLException, FileNotFoundException, IOException, Exception {
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        PreparedStatement ps = this.prepareStatement("insert into blobtable2 (n, blobcol) values(?,?)");
        ps.setInt(1, 1000);
        Blob blob = conn.createBlob();
        try {
            this.is = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws FileNotFoundException {
                    return new FileInputStream("extin/short.txt");
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
        OutputStream os = blob.setBinaryStream(1L);
        ArrayList<Integer> beforeUpdateList = new ArrayList<Integer>();
        int actualLength = 0;
        int c = this.is.read();
        while (c > 0) {
            os.write(c);
            beforeUpdateList.add(c);
            c = this.is.read();
            ++actualLength;
        }
        ps.setBlob(2, blob);
        ps.executeUpdate();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select blobcol from blobtable2 where n = 1000");
        ConnectionMethodsTest.assertTrue((boolean)rs.next());
        blob = rs.getBlob(1);
        ConnectionMethodsTest.assertEquals((long)beforeUpdateList.size(), (long)blob.length());
        InputStream in = blob.getBinaryStream();
        ArrayList<Integer> afterUpdateList = new ArrayList<Integer>();
        int b = in.read();
        while (b > -1) {
            afterUpdateList.add(b);
            b = in.read();
        }
        ConnectionMethodsTest.assertEquals((int)beforeUpdateList.size(), (int)afterUpdateList.size());
        int i = 0;
        while ((long)i < blob.length()) {
            ConnectionMethodsTest.assertEquals(beforeUpdateList.get(i), afterUpdateList.get(i));
            ++i;
        }
        os.close();
        this.is.close();
    }

    public void testConnectionIsValid() throws SQLException, Exception {
        Connection conn = this.getConnection();
        try {
            conn.isValid(-1);
            ConnectionMethodsTest.fail((String)"FAIL: isValid(-1): Invalid argument execption not thrown");
        }
        catch (SQLException e) {
            ConnectionMethodsTest.assertSQLState("XJ081", e);
        }
        if (!conn.isValid(0)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(0): returned false");
        }
        if (!conn.isValid(1)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(1): returned false");
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            ConnectionMethodsTest.assertSQLState(CLOSED_CONNECTION, e);
        }
        if (conn.isValid(0)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on closed connection: returned true");
        }
        if (!(conn = this.getConnection()).isValid(0)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on open connection: returned false");
        }
        TestConfiguration.getCurrent().shutdownDatabase();
        if (conn.isValid(0)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on stopped database: returned true");
        }
        if (!(conn = this.getConnection()).isValid(0)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on new connection: returned false");
        }
        if (!ConnectionMethodsTest.usingEmbedded()) {
            TestConfiguration.getCurrent().stopNetworkServer();
            if (conn.isValid(0)) {
                ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on stopped database: returned true");
            }
            TestConfiguration.getCurrent().startNetworkServer();
            conn = this.getConnection();
            if (!conn.isValid(0)) {
                ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on new connection: returned false");
            }
        }
    }

    public void testAbortPhysical() throws Exception {
        if (!TestConfiguration.loadingFromJars()) {
            return;
        }
        Connection conn0 = this.openUserConnection("user0");
        Connection conn1 = this.openUserConnection("user1");
        Connection conn2 = this.openUserConnection("user2");
        this.abortVetter(conn0, conn1, conn2);
    }

    public void testAbortPooled() throws Exception {
        if (!TestConfiguration.loadingFromJars()) {
            return;
        }
        ConnectionPoolDataSource cpDs = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection conn0 = this.getPooledConnection(cpDs, "user0");
        PooledConnection conn1 = this.getPooledConnection(cpDs, "user1");
        PooledConnection conn2 = this.getPooledConnection(cpDs, "user2");
        this.abortVetter(conn0.getConnection(), conn1.getConnection(), conn2.getConnection());
        try {
            conn1.getConnection();
            ConnectionMethodsTest.fail((String)"Expected physical connection to be closed.");
        }
        catch (SQLException se) {
            ConnectionMethodsTest.assertSQLState(CLOSED_CONNECTION, se);
        }
    }

    private PooledConnection getPooledConnection(ConnectionPoolDataSource cpDs, String userName) throws Exception {
        return cpDs.getPooledConnection(userName, this.getTestConfiguration().getPassword(userName));
    }

    public void testAbortXA() throws Exception {
        if (!TestConfiguration.loadingFromJars()) {
            return;
        }
        XADataSource xads = J2EEDataSource.getXADataSource();
        XAConnection conn0 = this.getXAConnection(xads, "user0");
        XAConnection conn1 = this.getXAConnection(xads, "user1");
        XAConnection conn2 = this.getXAConnection(xads, "user2");
        this.abortVetter(conn0.getConnection(), conn1.getConnection(), conn2.getConnection());
        try {
            conn1.getConnection();
            ConnectionMethodsTest.fail((String)"Expected physical connection to be closed.");
        }
        catch (SQLException se) {
            ConnectionMethodsTest.assertSQLState(CLOSED_CONNECTION, se);
        }
    }

    private XAConnection getXAConnection(XADataSource xads, String userName) throws Exception {
        return xads.getXAConnection(userName, this.getTestConfiguration().getPassword(userName));
    }

    public void abortVetter(Connection conn0, Connection conn1, Connection conn2) throws Exception {
        conn0.close();
        Wrapper41Conn wrapper0 = new Wrapper41Conn(conn0);
        wrapper0.abort(new DirectExecutor());
        conn1.setAutoCommit(false);
        final Wrapper41Conn wrapper1 = new Wrapper41Conn(conn1);
        try {
            wrapper1.abort(null);
        }
        catch (SQLException se) {
            ConnectionMethodsTest.assertSQLState("XCZ02", se);
        }
        PreparedStatement ps = this.prepareStatement(conn1, "insert into app.abort_table( a ) values ( 1 )");
        ps.execute();
        ps.close();
        ps = this.prepareStatement(conn1, "select * from app.abort_table");
        ResultSet rsconn1 = ps.executeQuery();
        ConnectionMethodsTest.assertTrue((boolean)rsconn1.next());
        rsconn1.close();
        ps.close();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DirectExecutor executor = new DirectExecutor();
                    wrapper1.abort(executor);
                    return null;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            conn1.rollback();
            ConnectionMethodsTest.fail((String)"Could not abort connection!");
        }
        try {
            this.prepareStatement(conn1, "select * from sys.systables");
            ConnectionMethodsTest.fail((String)"Connection should be dead!");
        }
        catch (SQLException se) {
            ConnectionMethodsTest.assertSQLState(CLOSED_CONNECTION, se);
        }
        ps = this.prepareStatement(conn2, "select * from app.abort_table");
        ResultSet rs = ps.executeQuery();
        ConnectionMethodsTest.assertFalse((boolean)rs.next());
        rs.close();
        ps.close();
        conn2.close();
    }

    public void testGetSetSchema() throws Exception {
        Connection conn = this.getConnection();
        ConnectionMethodsTest.println("Testing get/setSchema() on a " + conn.getClass().getName());
        Wrapper41Conn wrapper = new Wrapper41Conn(conn);
        ConnectionMethodsTest.assertEquals((String)"APP", (String)wrapper.getSchema());
        try {
            this.prepareStatement("select * from set_schema_table");
        }
        catch (SQLException se) {
            ConnectionMethodsTest.assertSQLState("42X05", se);
        }
        wrapper.setSchema("FOO");
        ConnectionMethodsTest.assertEquals((String)"FOO", (String)wrapper.getSchema());
        this.prepareStatement("select * from set_schema_table");
        try {
            wrapper.setSchema("foo");
            ConnectionMethodsTest.fail((String)"Should not have been able to change to a non-existent schema.");
        }
        catch (SQLException se) {
            ConnectionMethodsTest.assertSQLState("42Y07", se);
        }
        conn.close();
        try {
            wrapper.setSchema("APP");
            ConnectionMethodsTest.fail((String)"Should fail on a closed connection.");
        }
        catch (SQLException se) {
            ConnectionMethodsTest.assertSQLState(CLOSED_CONNECTION, se);
        }
        try {
            wrapper.getSchema();
            ConnectionMethodsTest.fail((String)"Should fail on a closed connection.");
        }
        catch (SQLException se) {
            ConnectionMethodsTest.assertSQLState(CLOSED_CONNECTION, se);
        }
    }

    public void testGetSetNetworkTimeout() throws Exception {
        Connection conn = this.getConnection();
        ConnectionMethodsTest.println("Testing get/setNetoworkTimeout() on a " + conn.getClass().getName());
        Wrapper41Conn wrapper = new Wrapper41Conn(conn);
        try {
            wrapper.getNetworkTimeout();
            ConnectionMethodsTest.fail((String)"Should raise an Unimplemented Feature exception.");
        }
        catch (SQLException se) {
            ConnectionMethodsTest.assertEquals((String)SQLFeatureNotSupportedException.class.getName(), (String)se.getClass().getName());
        }
        try {
            wrapper.setNetworkTimeout(null, 3);
            ConnectionMethodsTest.fail((String)"Should raise an Unimplemented Feature exception.");
        }
        catch (SQLException se) {
            ConnectionMethodsTest.assertEquals((String)SQLFeatureNotSupportedException.class.getName(), (String)se.getClass().getName());
        }
        conn.close();
        try {
            wrapper.getNetworkTimeout();
            ConnectionMethodsTest.fail((String)"Should raise an Unimplemented Feature exception.");
        }
        catch (SQLException se) {
            ConnectionMethodsTest.assertEquals((String)SQLFeatureNotSupportedException.class.getName(), (String)se.getClass().getName());
        }
        try {
            wrapper.setNetworkTimeout(null, 3);
            ConnectionMethodsTest.fail((String)"Should raise an Unimplemented Feature exception.");
        }
        catch (SQLException se) {
            ConnectionMethodsTest.assertEquals((String)SQLFeatureNotSupportedException.class.getName(), (String)se.getClass().getName());
        }
    }

    public static final class DirectExecutor
    implements Executor {
        @Override
        public void execute(Runnable r) {
            r.run();
        }
    }
}

