/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;

public class BlobClobTestSetup
extends BaseJDBCTestSetup {
    public static final int ID_NULLVALUES = 1;
    public static final int ID_SAMPLEVALUES = 2;
    public static int ID = 3;
    private static final byte[] blobData = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
    private static final String clobData = "This is a string, inserted into a CLOB";

    public BlobClobTestSetup(Test test) {
        super(test);
    }

    protected void setUp() throws IOException, SQLException {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        stmt.execute("create table BLOBCLOB (ID int primary key, BLOBDATA blob,CLOBDATA clob)");
        stmt.execute("insert into BLOBCLOB VALUES (1, null, null)");
        stmt.execute("insert into BLOBCLOB VALUES (2, null, null)");
        stmt.close();
    }

    @Override
    protected void tearDown() throws Exception {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        stmt.execute("drop table BLOBCLOB");
        stmt.close();
        super.tearDown();
    }

    public static Blob getSampleBlob(Connection con) throws SQLException {
        ByteArrayInputStream blobInput = new ByteArrayInputStream(blobData, 0, blobData.length);
        PreparedStatement pStmt = con.prepareStatement("update BLOBCLOB set BLOBDATA = ? where ID = ?");
        try {
            ((InputStream)blobInput).reset();
        }
        catch (IOException ioe) {
            BlobClobTestSetup.fail((String)("Failed to reset blob input stream: " + ioe.getMessage()));
        }
        pStmt.setBlob(1, blobInput, blobData.length);
        pStmt.setInt(2, 2);
        BlobClobTestSetup.assertEquals((String)"Invalid update count", (int)1, (int)pStmt.executeUpdate());
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("select BLOBDATA from BLOBCLOB where ID = 2");
        rs.next();
        Blob blob = rs.getBlob(1);
        rs.close();
        stmt.close();
        return blob;
    }

    public static Clob getSampleClob(Connection con) throws SQLException {
        StringReader clobInput = new StringReader(clobData);
        PreparedStatement pStmt = con.prepareStatement("update BLOBCLOB set CLOBDATA = ? where ID = ?");
        try {
            ((Reader)clobInput).reset();
        }
        catch (IOException ioe) {
            BlobClobTestSetup.fail((String)("Failed to reset clob input stream: " + ioe.getMessage()));
        }
        pStmt.setClob(1, clobInput, clobData.length());
        pStmt.setInt(2, 2);
        BlobClobTestSetup.assertEquals((String)"Invalid update count", (int)1, (int)pStmt.executeUpdate());
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("select CLOBDATA from BLOBCLOB where ID = 2");
        rs.next();
        Clob clob = rs.getClob(1);
        rs.close();
        stmt.close();
        return clob;
    }

    public static int getID() {
        return ID++;
    }
}

