/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ErrorStreamTest
extends BaseJDBCTestCase {
    private static final String FILE_PROP = "derby.stream.error.file";
    private static final String METHOD_PROP = "derby.stream.error.method";
    private static final String FIELD_PROP = "derby.stream.error.field";
    private static int runNo = 0;
    private File fileStreamFile;
    private static OutputStream methodStream;
    private File methodStreamFile;
    public static OutputStream fieldStream;
    private File fieldStreamFile;
    private OutputStream errStream;
    private File errStreamFile;

    public ErrorStreamTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.embeddedSuite(ErrorStreamTest.class);
    }

    public void setUp() throws Exception {
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.openStreams();
    }

    public void tearDown() throws Exception {
        ErrorStreamTest.resetProps();
        this.deleteStreamFiles();
        this.nullFields();
        super.tearDown();
    }

    public void testDefault() throws IOException, SQLException {
        File derbyLog = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), "derby.log");
        this.bootDerby();
        ErrorStreamTest.assertIsExisting(derbyLog);
        ErrorStreamTest.assertNotDirectory(derbyLog);
        ErrorStreamTest.assertNotEmpty(derbyLog);
        ErrorStreamTest.println("Shutdown database");
        this.getTestConfiguration().shutdownDatabase();
        ErrorStreamTest.assertIsExisting(derbyLog);
        ErrorStreamTest.assertNotDirectory(derbyLog);
        ErrorStreamTest.assertNotEmpty(derbyLog);
        ErrorStreamTest.println("Shutdown engine");
        this.getTestConfiguration().shutdownEngine();
        boolean deleted = ErrorStreamTest.deleteFile(derbyLog);
        ErrorStreamTest.assertTrue((String)("File " + derbyLog + " could not be deleted"), (boolean)deleted);
    }

    public void testFile() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FILE_PROP, ErrorStreamTest.getCanonicalPath(this.fileStreamFile));
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testWrongFile() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FILE_PROP, ErrorStreamTest.getCanonicalPath(new File(new File(ErrorStreamTest.getSystemProperty("derby.system.home"), "foo"), ErrorStreamTest.makeStreamFilename("file"))));
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertNotEmpty(this.errStreamFile);
    }

    public void testMethod() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(METHOD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.getStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertNotEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testWrongMethod() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(METHOD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.nonExistingGetStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertNotEmpty(this.errStreamFile);
    }

    public void testField() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FIELD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.fieldStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertNotEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testWrongField() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FIELD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.nonExistingFieldStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertNotEmpty(this.errStreamFile);
    }

    public void testFileOverMethod() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FILE_PROP, ErrorStreamTest.getCanonicalPath(this.fileStreamFile));
        ErrorStreamTest.setSystemProperty(METHOD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.getStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testFileOverField() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FILE_PROP, ErrorStreamTest.getCanonicalPath(this.fileStreamFile));
        ErrorStreamTest.setSystemProperty(FIELD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.fieldStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testFileOverMethodAndField() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FILE_PROP, ErrorStreamTest.getCanonicalPath(this.fileStreamFile));
        ErrorStreamTest.setSystemProperty(METHOD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.getStream");
        ErrorStreamTest.setSystemProperty(FIELD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.fieldStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testMethodOverField() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(METHOD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.getStream");
        ErrorStreamTest.setSystemProperty(FIELD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.fieldStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertNotEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public static OutputStream getStream() {
        return methodStream;
    }

    private static String makeStreamFilename(String type) {
        return type + "-" + runNo + ".log";
    }

    private void openStreams() throws IOException {
        String systemHome = ErrorStreamTest.getSystemProperty("derby.system.home");
        ErrorStreamTest.makeDirIfNotExisting(systemHome);
        ++runNo;
        this.methodStreamFile = new File(systemHome, ErrorStreamTest.makeStreamFilename("method"));
        this.fileStreamFile = new File(systemHome, ErrorStreamTest.makeStreamFilename("file"));
        this.fieldStreamFile = new File(systemHome, ErrorStreamTest.makeStreamFilename("field"));
        this.errStreamFile = new File(systemHome, ErrorStreamTest.makeStreamFilename("err"));
        methodStream = ErrorStreamTest.newFileOutputStream(this.methodStreamFile);
        fieldStream = ErrorStreamTest.newFileOutputStream(this.fieldStreamFile);
        this.errStream = ErrorStreamTest.newFileOutputStream(this.errStreamFile);
        ErrorStreamTest.setSystemErr(new PrintStream(this.errStream));
    }

    private void closeStreams() throws IOException {
        try {
            methodStream.close();
            fieldStream.close();
            this.errStream.close();
            ErrorStreamTest.setSystemErr(System.out);
        }
        catch (IOException e) {
            ErrorStreamTest.println("Could not close stream files");
            throw e;
        }
    }

    private static void assertIsDirectory(final File f) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    Assert.assertTrue((String)("assertIsDirectory failed: " + f.getCanonicalPath()), (boolean)f.isDirectory());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private static void assertNotDirectory(final File f) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    Assert.assertFalse((String)("assertNotDirectory failed: " + f.getCanonicalPath()), (boolean)f.isDirectory());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private static void assertIsEmpty(final File f) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    Assert.assertTrue((String)("assertIsEmpty failed: " + f.getCanonicalPath()), (f.exists() && f.length() == 0L ? 1 : 0) != 0);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private static void assertNotEmpty(final File f) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    Assert.assertTrue((String)("assertNotEmpty failed: " + f.getCanonicalPath() + " does not exist."), (boolean)f.exists());
                    FileInputStream fis = new FileInputStream(f);
                    int result = fis.read();
                    fis.close();
                    Assert.assertTrue((String)("assertNotEmpty failed: " + f.getCanonicalPath() + " is empty."), (-1 != result ? 1 : 0) != 0);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private static void assertIsExisting(final File f) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    Assert.assertTrue((String)("assertIsExisting failed: " + f.getCanonicalPath()), (boolean)f.exists());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private static void assertNotExisting(final File f) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    Assert.assertFalse((String)("assertNotExisting failed: " + f.getCanonicalPath()), (boolean)f.exists());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private static boolean deleteFile(final File f) {
        Boolean deleted = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(f.delete());
            }
        });
        return deleted;
    }

    private static String getCanonicalPath(final File f) throws IOException {
        String path = null;
        try {
            path = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return f.getCanonicalPath();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        return path;
    }

    private static void makeDirIfNotExisting(final String filename) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File f = new File(filename);
                if (!f.exists()) {
                    f.mkdir();
                }
                return null;
            }
        });
    }

    private static void setSystemErr(final PrintStream err) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.setErr(err);
                return null;
            }
        });
    }

    private static FileOutputStream newFileOutputStream(final File f) throws FileNotFoundException {
        FileOutputStream outStream = null;
        try {
            outStream = (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileOutputStream(f);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
        return outStream;
    }

    private static void resetProps() {
        ErrorStreamTest.removeSystemProperty(FILE_PROP);
        ErrorStreamTest.removeSystemProperty(METHOD_PROP);
        ErrorStreamTest.removeSystemProperty(FIELD_PROP);
    }

    private void deleteStreamFiles() {
        ErrorStreamTest.deleteFile(this.fileStreamFile);
        ErrorStreamTest.deleteFile(this.methodStreamFile);
        ErrorStreamTest.deleteFile(this.fieldStreamFile);
        ErrorStreamTest.deleteFile(this.errStreamFile);
    }

    private void nullFields() {
        this.fileStreamFile = null;
        this.methodStreamFile = null;
        this.fieldStreamFile = null;
        this.errStreamFile = null;
        methodStream = null;
        fieldStream = null;
        this.errStream = null;
    }

    private void bootDerby() throws SQLException {
        this.getConnection();
        this.getConnection().close();
    }
}

