/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.impl.drda.ProtocolTestAdapter;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.functionTests.util.ProtocolTestGrammar;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ProtocolTest
extends BaseTestCase {
    private static final String PREFIX = "org/apache/derbyTesting/functionTests/tests/derbynet/";
    private static final String NL = BaseTestCase.getSystemProperty("line.separator");
    private static final String MULTIVAL_START = "MULTIVALSTART";
    private static final String MULTIVAL_SEP = "SEP";
    private static final String MULTIVAL_END = "MULTIVALEND";
    private static final String UTF8_TEST_MATCH = "%UTF8TestString%";
    private static final String UTF8_TEST_STRING = "\u4f60\u597d\u4e16\u754cABCDEFGHIJKLMNOPQ";
    private final String filename;
    private final int startLine;
    private final int lineCount;
    private String commandSequence;
    private ProtocolTestAdapter adapter;

    private ProtocolTest(String file, String cmds, int startLine, int lines) {
        super("testProtocolSequence");
        this.filename = file;
        this.commandSequence = cmds;
        this.startLine = startLine;
        this.lineCount = lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProtocolSequence() throws IOException, UnknownHostException {
        super.setName(this.filename + "_" + this.startLine + "_" + (this.startLine + this.lineCount));
        ProtocolTest.println(this.getName() + " :: STARTED");
        ProtocolTest.assertEquals((String)"Actual line count does not match the specified count", (int)this.lineCount, (int)(this.commandSequence.length() - this.commandSequence.replaceAll("\n", "").length() - 1));
        this.adapter = new ProtocolTestAdapter(ProtocolTest.createSocket());
        StringReader cmdStream = new StringReader(this.commandSequence);
        try {
            this.processCommands(cmdStream);
        }
        finally {
            try {
                this.adapter.close();
            }
            catch (IOException ioe) {
                ProtocolTest.alarm("adapter.close() failed: " + ioe.getMessage());
            }
        }
    }

    public void tearDown() throws Exception {
        this.commandSequence = null;
        this.adapter.close();
        this.adapter = null;
        super.tearDown();
    }

    private static Socket createSocket() throws IOException, UnknownHostException {
        Socket socket = null;
        final TestConfiguration cfg = TestConfiguration.getCurrent();
        try {
            socket = AccessController.doPrivileged(new PrivilegedExceptionAction<Socket>(){

                @Override
                public Socket run() throws IOException, UnknownHostException {
                    return new Socket(cfg.getHostName(), cfg.getPort());
                }
            });
        }
        catch (PrivilegedActionException pae) {
            if (pae.getCause() instanceof IOException) {
                throw (IOException)pae.getCause();
            }
            if (pae.getCause() instanceof UnknownHostException) {
                throw (UnknownHostException)pae.getCause();
            }
            ProtocolTest.fail("Unhandled exception", pae);
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(String fileName) throws IOException {
        File incFile = SupportFilesSetup.getReadOnly(fileName);
        ProtocolTest.assertTrue((String)("Missing file: " + fileName), (boolean)PrivilegedFileOpsForTests.exists(incFile));
        BufferedReader bIn = new BufferedReader(PrivilegedFileOpsForTests.getFileReader(incFile));
        try {
            this.processCommands(bIn);
        }
        finally {
            bIn.close();
        }
    }

    private void processCommands(Reader cmdStream) throws IOException {
        int val;
        StreamTokenizer tkn = new StreamTokenizer(cmdStream);
        boolean endSignalled = false;
        while ((val = tkn.nextToken()) != -1) {
            ProtocolTest.assertFalse((String)("End signalled, data to process left: " + tkn.sval), (boolean)endSignalled);
            switch (val) {
                case -2: {
                    break;
                }
                case -3: {
                    endSignalled = this.processCommand(tkn);
                    break;
                }
            }
        }
    }

    private boolean processCommand(StreamTokenizer tkn) throws IOException {
        ProtocolTestGrammar cmd = ProtocolTestGrammar.cmdFromString(tkn.sval.toLowerCase(Locale.ENGLISH));
        if (cmd == null) {
            ProtocolTest.fail((String)("Unknown command '" + tkn.sval + "' in line " + this.ln(tkn)));
        }
        switch (cmd) {
            case INCLUDE: {
                this.processFile(this.getString(tkn));
                break;
            }
            case CREATE_DSS_REQUEST: {
                this.adapter.wCreateDssRequest();
                break;
            }
            case CREATE_DSS_OBJECT: {
                this.adapter.wCreateDssObject();
                break;
            }
            case CREATE_DSS_REPLY: {
                this.adapter.wCreateDssReply();
                break;
            }
            case END_DSS: {
                tkn.nextToken();
                tkn.pushBack();
                if (tkn.sval != null && tkn.sval.startsWith("0x")) {
                    this.adapter.wEndDss(this.getBytes(tkn)[0]);
                    break;
                }
                this.adapter.wEndDss();
                break;
            }
            case END_DDM: {
                this.adapter.wEndDdm();
                break;
            }
            case END_DDM_AND_DSS: {
                this.adapter.wEndDdmAndDss();
                break;
            }
            case START_DDM: {
                this.adapter.wStartDdm(this.getCP(tkn));
                break;
            }
            case WRITE_SCALAR_STRING: {
                this.adapter.wWriteScalarString(this.getCP(tkn), this.getString(tkn));
                break;
            }
            case WRITE_SCALAR_2BYTES: {
                this.adapter.wWriteScalar2Bytes(this.getCP(tkn), this.getIntOrCP(tkn));
                break;
            }
            case WRITE_SCALAR_1BYTE: {
                this.adapter.wWriteScalar1Byte(this.getCP(tkn), this.getInt(tkn));
                break;
            }
            case WRITE_SCALAR_BYTES: {
                this.adapter.wWriteScalarBytes(this.getCP(tkn), this.getBytes(tkn));
                break;
            }
            case WRITE_SCALAR_PADDED_BYTES: {
                this.adapter.wWriteScalarPaddedBytes(this.getCP(tkn), this.getBytes(tkn), this.getInt(tkn), ProtocolTestAdapter.SPACE);
                break;
            }
            case WRITE_BYTE: {
                this.adapter.wWriteByte(this.getInt(tkn));
                break;
            }
            case WRITE_BYTES: {
                this.adapter.wWriteBytes(this.getBytes(tkn));
                break;
            }
            case WRITE_SHORT: {
                this.adapter.wWriteShort(this.getInt(tkn));
                break;
            }
            case WRITE_INT: {
                this.adapter.wWriteInt(this.getInt(tkn));
                break;
            }
            case WRITE_CODEPOINT_4BYTES: {
                this.adapter.wWriteCodePoint4Bytes(this.getCP(tkn), this.getInt(tkn));
                break;
            }
            case WRITE_STRING: {
                String str = this.getString(tkn);
                this.adapter.wWriteBytes(this.getEBCDIC(str));
                break;
            }
            case WRITE_ENCODED_STRING: {
                this.writeEncodedString(this.getString(tkn), this.getString(tkn));
                break;
            }
            case WRITE_ENCODED_LDSTRING: {
                this.writeEncodedLDString(this.getString(tkn), this.getString(tkn), this.getInt(tkn));
                break;
            }
            case WRITE_PADDED_STRING: {
                String str = this.getString(tkn);
                this.adapter.wWriteBytes(this.getEBCDIC(str));
                int reqLen = this.getInt(tkn);
                int strLen = str.length();
                if (strLen >= reqLen) break;
                this.adapter.wPadBytes(ProtocolTestAdapter.SPACE, reqLen - strLen);
                break;
            }
            case READ_REPLY_DSS: {
                this.adapter.rReadReplyDss();
                break;
            }
            case SKIP_DSS: {
                this.adapter.rSkipDss();
                break;
            }
            case SKIP_DDM: {
                this.adapter.rSkipDdm();
                break;
            }
            case MORE_DATA: {
                String str = this.getString(tkn);
                boolean expbool = Boolean.parseBoolean(str);
                ProtocolTest.assertEquals((String)"Too much/little data", (boolean)expbool, (boolean)this.adapter.rMoreData());
                break;
            }
            case READ_LENGTH_AND_CODEPOINT: {
                this.readLengthAndCodePoint(tkn);
                break;
            }
            case READ_SCALAR_2BYTES: {
                this.readLengthAndCodePoint(tkn);
                int val = this.adapter.rReadNetworkShort();
                this.checkIntOrCP(tkn, val);
                break;
            }
            case READ_SCALAR_1BYTE: {
                this.readLengthAndCodePoint(tkn);
                byte val = this.adapter.rReadByte();
                this.checkIntOrCP(tkn, val);
                break;
            }
            case READ_SECMEC_AND_SECCHKCD: {
                this.readSecMecAndSECCHKCD();
                break;
            }
            case READ_BYTES: {
                ProtocolTest.assertTrue((String)"Mismatch between the byte arrays", (boolean)Arrays.equals(this.getBytes(tkn), this.adapter.rReadBytes()));
                break;
            }
            case READ_NETWORK_SHORT: {
                int val = this.adapter.rReadNetworkShort();
                this.checkIntOrCP(tkn, val);
                break;
            }
            case FLUSH: {
                this.adapter.wFlush();
                break;
            }
            case DISPLAY: {
                ProtocolTest.println(this.getString(tkn));
                break;
            }
            case CHECKERROR: {
                this.checkError(tkn);
                break;
            }
            case CHECK_SQLCARD: {
                this.checkSQLCARD(this.getInt(tkn), this.getString(tkn));
                break;
            }
            case END_TEST: {
                ProtocolTest.println(this.getName() + " :: FINISHED");
                return true;
            }
            case SKIP_BYTES: {
                this.adapter.rSkipBytes();
                break;
            }
            case SWITCH_TO_UTF8_CCSID_MANAGER: {
                this.adapter.setUtf8Ccsid();
                break;
            }
            case DELETE_DATABASE: {
                this.deleteDatabase(this.getString(tkn));
                break;
            }
            default: {
                ProtocolTest.fail((String)("Command in line " + this.ln(tkn) + " not implemented: " + cmd.toString()));
            }
        }
        return false;
    }

    private int getInt(StreamTokenizer tkn) throws IOException {
        int mult = 1;
        int val = tkn.nextToken();
        if (tkn.sval != null && tkn.sval.equals("-")) {
            mult = -1;
            val = tkn.nextToken();
        }
        if (val != -2) {
            ProtocolTest.assertNotNull((String)("Invalid string on line " + this.ln(tkn)), (Object)tkn.sval);
            String str = tkn.sval.toLowerCase(Locale.ENGLISH);
            if (!str.startsWith("0x")) {
                ProtocolTest.fail((String)("Expecting number, got " + tkn.sval + " on line " + this.ln(tkn)));
            } else {
                return this.convertHex(str, this.ln(tkn));
            }
        }
        return new Double(tkn.nval).intValue() * mult;
    }

    private int convertHex(String str, int lineNumber) throws IOException {
        int retval = 0;
        int len = str.length();
        if (len % 2 == 1 || len > 10) {
            ProtocolTest.fail((String)("Invalid length for byte string, " + len + " on line " + lineNumber));
        }
        for (int i = 2; i < len; ++i) {
            retval <<= 4;
            retval += Byte.valueOf(str.substring(i, i + 1), 16).byteValue();
        }
        return retval;
    }

    private boolean checkIntOrCP(StreamTokenizer tkn, int val) throws IOException {
        boolean rval = false;
        int tknType = tkn.nextToken();
        String reqVal = " ";
        if (tknType == -3 && tkn.sval.trim().equals(MULTIVAL_START)) {
            do {
                int nextVal = this.getIntOrCP(tkn);
                reqVal = reqVal + nextVal + " ";
                rval = rval || val == nextVal;
                tkn.nextToken();
            } while (tkn.sval.trim().equals(MULTIVAL_SEP));
            if (!tkn.sval.trim().equals(MULTIVAL_END)) {
                ProtocolTest.fail((String)("Invalid test file format, requires MULTIVALEND, got: " + tkn.sval));
            }
        } else {
            tkn.pushBack();
            int nextVal = this.getIntOrCP(tkn);
            reqVal = " " + nextVal;
            rval = val == nextVal;
        }
        ProtocolTest.assertTrue((String)("Expected '" + reqVal + "', got '" + val + "'"), (boolean)rval);
        return rval;
    }

    private int getIntOrCP(StreamTokenizer tkn) throws IOException {
        int val = tkn.nextToken();
        if (val == -2) {
            return Double.valueOf(tkn.nval).intValue();
        }
        if (val == -3) {
            return this.decodeCP(tkn.sval, this.ln(tkn));
        }
        ProtocolTest.fail((String)("Expecting number, got '" + tkn.sval + "' on line " + this.ln(tkn)));
        return 0;
    }

    private byte[] getBytes(StreamTokenizer tkn) throws IOException {
        tkn.nextToken();
        ProtocolTest.assertNotNull((String)("Missing input on line " + this.ln(tkn)), (Object)tkn.sval);
        String str = tkn.sval.toLowerCase(Locale.ENGLISH);
        if (!str.startsWith("0x")) {
            return this.getEBCDIC(str);
        }
        int len = str.length();
        if (len % 2 == 1) {
            ProtocolTest.fail((String)("Invalid length for byte string, " + len + " on line " + this.ln(tkn)));
        }
        byte[] retval = new byte[(len - 2) / 2];
        int j = 0;
        for (int i = 2; i < len; i += 2) {
            retval[j] = (byte)(Byte.valueOf(str.substring(i, i + 1), 16) << 4);
            int n = j++;
            retval[n] = (byte)(retval[n] + Byte.valueOf(str.substring(i + 1, i + 2), 16));
        }
        return retval;
    }

    private String getString(StreamTokenizer tkn) throws IOException {
        int val = tkn.nextToken();
        ProtocolTest.assertTrue((String)("Expected string, got number '" + tkn.nval + "' on line " + this.ln(tkn)), (val != -2 ? 1 : 0) != 0);
        if (tkn.sval.contains(UTF8_TEST_MATCH)) {
            return tkn.sval.replace(UTF8_TEST_MATCH, UTF8_TEST_STRING);
        }
        return tkn.sval;
    }

    private int getCP(StreamTokenizer tkn) throws IOException {
        String strval = this.getString(tkn);
        return this.decodeCP(strval, this.ln(tkn));
    }

    private int decodeCP(String strval, int lineNumber) {
        Integer cp = this.adapter.decodeCodePoint(strval);
        ProtocolTest.assertNotNull((String)("Unknown codepoint '" + strval + "' in line " + lineNumber), (Object)cp);
        return cp;
    }

    private void checkError(StreamTokenizer tkn) throws IOException {
        int svrcod = 0;
        int invalidCodePoint = 0;
        byte prccnvcd = 0;
        byte synerrcd = 0;
        ArrayList<Integer> manager = new ArrayList<Integer>();
        ArrayList<Integer> managerLevel = new ArrayList<Integer>();
        this.adapter.rReadReplyDss();
        int error = this.adapter.rReadLengthAndCodePoint(false);
        int reqCP = this.getCP(tkn);
        this.assertCP(reqCP, error);
        block7: while (this.adapter.rMoreDssData()) {
            int codepoint = this.adapter.rReadLengthAndCodePoint(false);
            switch (codepoint) {
                case 4425: {
                    svrcod = this.adapter.rReadNetworkShort();
                    continue block7;
                }
                case 12: {
                    invalidCodePoint = this.adapter.rReadNetworkShort();
                    continue block7;
                }
                case 4415: {
                    prccnvcd = this.adapter.rReadByte();
                    continue block7;
                }
                case 4426: {
                    synerrcd = this.adapter.rReadByte();
                    continue block7;
                }
                case 5124: {
                    while (this.adapter.rMoreDdmData()) {
                        manager.add(this.adapter.rReadNetworkShort());
                        managerLevel.add(this.adapter.rReadNetworkShort());
                    }
                    continue block7;
                }
            }
            this.adapter.rSkipBytes();
            ProtocolTest.println("Skipped bytes for codepoint " + codepoint + " (" + this.adapter.lookupCodePoint(codepoint) + ")");
        }
        int reqVal = this.getInt(tkn);
        ProtocolTest.assertEquals((String)("Wrong svrcod (0x" + Integer.toHexString(reqVal) + " != 0x" + Integer.toHexString(svrcod) + ")"), (int)reqVal, (int)svrcod);
        if (error == 4677) {
            reqVal = this.getInt(tkn);
            ProtocolTest.assertEquals((String)("Wrong prccnvcd (0x" + Integer.toHexString(reqVal) + " != 0x" + Integer.toHexString(prccnvcd) + ")"), (int)reqVal, (int)prccnvcd);
        }
        if (error == 4684) {
            reqVal = this.getInt(tkn);
            ProtocolTest.assertEquals((String)("Wrong synerrcd (0x" + Integer.toHexString(reqVal) + " != 0x" + Integer.toHexString(synerrcd) + ")"), (int)reqVal, (int)synerrcd);
            reqVal = this.getIntOrCP(tkn);
            this.assertCP(reqVal, invalidCodePoint);
        }
        if (error == 4624) {
            for (int i = 0; i < manager.size(); ++i) {
                reqVal = this.getCP(tkn);
                int mgr = (Integer)manager.get(i);
                this.assertCP(reqVal, mgr);
                int mgrLevel = (Integer)managerLevel.get(i);
                reqVal = this.getInt(tkn);
                ProtocolTest.assertEquals((String)("Wrong manager level (0x" + Integer.toHexString(reqVal) + " != 0x" + Integer.toHexString(mgrLevel) + ")"), (int)reqVal, (int)mgrLevel);
            }
        }
    }

    private void readLengthAndCodePoint(StreamTokenizer tkn) throws IOException {
        int codepoint = this.adapter.rReadLengthAndCodePoint(false);
        int reqCP = this.getCP(tkn);
        this.assertCP(reqCP, codepoint);
    }

    private void readSecMecAndSECCHKCD() throws IOException {
        boolean notDone = true;
        do {
            int codepoint = this.adapter.rReadLengthAndCodePoint(false);
            switch (codepoint) {
                case 4514: {
                    int val = this.adapter.rReadNetworkShort();
                    ProtocolTest.println("SECMEC=" + val);
                    break;
                }
                case 4516: {
                    int val = this.adapter.rReadByte();
                    ProtocolTest.println("SECCHKCD=" + val);
                    notDone = false;
                    break;
                }
                default: {
                    notDone = false;
                }
            }
        } while (notDone);
    }

    private void assertCP(int reqCP, int cp) {
        String cpName = this.adapter.lookupCodePoint(cp);
        String reqCPName = this.adapter.lookupCodePoint(reqCP);
        ProtocolTest.assertEquals((String)("Wrong codepoint (0x" + Integer.toHexString(reqCP) + "/" + reqCPName + " != 0x" + Integer.toHexString(cp) + "/" + cpName + ")"), (int)reqCP, (int)cp);
    }

    private byte[] getEBCDIC(String str) {
        return this.adapter.convertFromJavaString(str);
    }

    private void writeEncodedString(String str, String encoding) {
        try {
            byte[] buf = str.getBytes(encoding);
            this.adapter.wWriteBytes(buf);
        }
        catch (UnsupportedEncodingException e) {
            ProtocolTest.fail("Unsupported encoding " + encoding, e);
        }
    }

    private void writeEncodedLDString(String str, String encoding, int len) {
        try {
            byte[] buf = str.getBytes(encoding);
            if (len == 2) {
                this.adapter.wWriteShort(buf.length);
            } else {
                this.adapter.wWriteInt(buf.length);
            }
            this.adapter.wWriteBytes(buf);
        }
        catch (UnsupportedEncodingException e) {
            ProtocolTest.fail("Unsupported encoding " + encoding, e);
        }
    }

    private void checkSQLCARD(int sqlCode, String sqlState) throws IOException {
        this.adapter.rReadReplyDss();
        int codepoint = this.adapter.rReadLengthAndCodePoint(false);
        ProtocolTest.assertEquals((String)("Expected SQLCARD (0x2408), got " + Integer.toHexString(codepoint)), (int)9224, (int)codepoint);
        this.adapter.rReadByte();
        int code = this.adapter.rReadNetworkInt();
        ProtocolTest.assertEquals((String)("Expected " + Integer.toHexString(sqlCode) + ", got " + Integer.toHexString(code)), (int)sqlCode, (int)code);
        String state = this.adapter.rReadString(5, "UTF-8");
        ProtocolTest.assertEquals((String)"Wrong SQL state", (String)sqlState, (String)state);
        this.adapter.rSkipBytes();
    }

    private int ln(StreamTokenizer st) {
        return this.startLine + st.lineno() - 1;
    }

    private void deleteDatabase(String name) {
        String shutdownUrl = "jdbc:derby:" + name + ";shutdown=true";
        try {
            DriverManager.getConnection(shutdownUrl);
        }
        catch (SQLException sqle) {
            BaseJDBCTestCase.assertSQLState("08006", sqle);
        }
        ProtocolTest.removeDirectory(ProtocolTest.getSystemProperty("derby.system.home") + File.separator + name);
    }

    public static Test suite() throws Exception {
        String line;
        TestSuite suite = new TestSuite("Derby DRDA protocol tests");
        String testFile = "org/apache/derbyTesting/functionTests/tests/derbynet/protocol.tests";
        URL testFileURL = BaseTestCase.getTestResource("org/apache/derbyTesting/functionTests/tests/derbynet/protocol.tests");
        BufferedReader bIn = new BufferedReader(new InputStreamReader(ProtocolTest.openTestResource(testFileURL), Charset.forName("UTF-8")));
        String END_TEST = ProtocolTestGrammar.END_TEST.toCmdString();
        int currentLine = 1;
        int startLine = 1;
        ArrayList<String> cmdLines = new ArrayList<String>();
        StringBuilder str = new StringBuilder();
        while ((line = bIn.readLine()) != null) {
            cmdLines.add(line);
            str.append(line).append(NL);
            if (line.toLowerCase(Locale.ENGLISH).startsWith(END_TEST)) {
                suite.addTest((Test)new ProtocolTest("protocol.tests", str.toString(), startLine, currentLine - startLine));
                cmdLines.clear();
                str.setLength(0);
                startLine = currentLine + 1;
            }
            ++currentLine;
        }
        bIn.close();
        String resourcePath = "functionTests/tests/derbynet";
        return new SecurityManagerSetup(TestConfiguration.clientServerDecorator((Test)new SupportFilesSetup((Test)suite, new String[]{"functionTests/tests/derbynet/connect.inc", "functionTests/tests/derbynet/excsat_accsecrd1.inc", "functionTests/tests/derbynet/excsat_accsecrd2.inc", "functionTests/tests/derbynet/excsat_accsecrd_nordb.inc", "functionTests/tests/derbynet/excsat_secchk_nordbonaccsec.inc", "functionTests/tests/derbynet/excsat_secchk.inc", "functionTests/tests/derbynet/values1.inc", "functionTests/tests/derbynet/values64kblksz.inc"})), "org/apache/derbyTesting/functionTests/tests/derbynet/ProtocolTest.policy", true);
    }
}

