/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_MultiThreadedIterations;
import org.apache.derbyTesting.unitTests.store.T_RawStoreRow;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_FileSystemData
extends T_MultiThreadedIterations {
    private static final String testService = "fileSystemDataTest";
    static final String REC_001 = "McLaren";
    static final String REC_002 = "Ferrari";
    static final String REC_003 = "Benetton";
    static final String REC_004 = "Prost";
    static final String REC_005 = "Tyrell";
    static final String REC_006 = "Derby, Natscape, Goatscape, the popular names";
    static final String REC_007 = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz";
    static final String SP1 = "savepoint1";
    static final String SP2 = "savepoint2";
    static RawStoreFactory factory;
    static LockFactory lf;
    static long commonContainer;
    static boolean testRollback;
    static final String TEST_ROLLBACK_OFF = "derby.RawStore.RollbackTestOff";
    private static ContextService contextService;
    private T_Util t_util;

    public void boot(boolean create, Properties startParams) throws StandardException {
        super.boot(create, startParams);
        contextService = ContextService.getFactory();
    }

    protected String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.raw.RawStoreFactory";
    }

    protected void setupTest() throws T_Fail {
        String rollbackOff = PropertyUtil.getSystemProperty((String)TEST_ROLLBACK_OFF);
        boolean bl = testRollback = Boolean.valueOf(rollbackOff) == false;
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams = T_Util.setEncryptionParam(this.startParams);
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
        try {
            factory = (RawStoreFactory)Monitor.createPersistentService((String)this.getModuleToTestProtocolName(), (String)testService, (Properties)this.startParams);
            if (factory == null) {
                throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
            }
            lf = factory.getLockFactory();
            if (lf == null) {
                throw T_Fail.testFailMsg("LockFactory.MODULE not found");
            }
        }
        catch (StandardException mse) {
            throw T_Fail.exceptionFail(mse);
        }
        this.t_util = new T_Util(factory, lf, contextService);
        commonContainer = this.commonContainer();
    }

    protected void joinSetupTest() throws T_Fail {
        T_Fail.T_ASSERT(factory != null, "raw store factory not setup ");
        T_Fail.T_ASSERT(contextService != null, "Context service not setup ");
        T_Fail.T_ASSERT(commonContainer != -1L, "common container not setup ");
        this.t_util = new T_Util(factory, lf, contextService);
    }

    protected T_MultiThreadedIterations newTestObject() {
        return new T_FileSystemData();
    }

    protected void runTestSet() throws T_Fail {
        ContextManager cm1 = contextService.newContextManager();
        contextService.setCurrentContextManager(cm1);
        try {
            this.runCostEstimationTests();
            this.runAllocationTests();
        }
        catch (StandardException se) {
            cm1.cleanupOnError((Throwable)se);
            throw T_Fail.exceptionFail(se);
        }
        finally {
            contextService.resetCurrentContextManager(cm1);
        }
    }

    private long commonContainer() throws T_Fail {
        long cid;
        ContextManager cm1 = contextService.newContextManager();
        contextService.setCurrentContextManager(cm1);
        try {
            Transaction t = this.t_util.t_startTransaction();
            cid = this.t_util.t_addContainer(t, 0L);
            this.t_util.t_commit(t);
            t.close();
        }
        catch (StandardException se) {
            cm1.cleanupOnError((Throwable)se);
            throw T_Fail.exceptionFail(se);
        }
        finally {
            contextService.resetCurrentContextManager(cm1);
        }
        return cid;
    }

    protected void runCostEstimationTests() throws T_Fail, StandardException {
        this.CostEstimationTest1();
    }

    protected void runAllocationTests() throws T_Fail, StandardException {
        if (this.threadNumber < 2) {
            this.AllocTest1();
            this.AllocTest2();
            this.AllocTest3();
            this.AllocTest4();
        }
        this.AllocMTest1(commonContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void CostEstimationTest1() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L);
        this.t_util.t_commit(t);
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        try {
            int numRows = 10;
            T_RawStoreRow row = new T_RawStoreRow(REC_001);
            RecordHandle[] rh = new RecordHandle[numRows];
            for (int i = 0; i < numRows; ++i) {
                rh[i] = this.t_util.t_insert(c, row);
            }
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            if (c.getEstimatedRowCount(0) != (long)numRows && c.getEstimatedRowCount(0) != (long)(numRows - 1)) {
                throw T_Fail.testFailMsg("expect estimated row count to be " + (numRows - 1) + " or " + numRows + ", got " + c.getEstimatedRowCount(0));
            }
            T_RawStoreRow longRow = new T_RawStoreRow(REC_007);
            for (int i = 0; i < numRows; ++i) {
                this.t_util.t_update(c, rh[i], longRow);
            }
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            if (c.getEstimatedRowCount(0) != (long)numRows && c.getEstimatedRowCount(0) != (long)numRows && c.getEstimatedRowCount(0) != (long)(numRows - 1)) {
                throw T_Fail.testFailMsg("expect after update same estimated row count, but it is not.expect estimated row count to be " + (numRows - 1) + " or " + numRows + ", got " + c.getEstimatedRowCount(0));
            }
            c.setEstimatedRowCount((long)(2 * numRows), 0);
            if (c.getEstimatedRowCount(0) != (long)(2 * numRows)) {
                throw T_Fail.testFailMsg("forcibly setting estimated row count doesn't seem to work");
            }
            Page p = null;
            long pnum = 0L;
            long purgedCount = 0L;
            p = c.getFirstPage();
            while (p != null) {
                int rcount = p.recordCount() / 3;
                pnum = p.getPageNumber();
                p.deleteAtSlot(0, true, (LogicalUndo)null);
                p.purgeAtSlot(rcount, rcount, true);
                purgedCount += (long)(rcount + 1);
                p.unlatch();
                p = c.getNextPage(pnum);
            }
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            if (c.getEstimatedRowCount(0) != (long)(2 * numRows) - purgedCount) {
                throw T_Fail.testFailMsg("expect " + ((long)(2 * numRows) - purgedCount) + " after purge");
            }
            this.REPORT("before page delete, estRC = " + 2 * numRows + " - " + purgedCount);
            p = c.getFirstPage();
            while (p != null) {
                pnum = p.getPageNumber();
                if (pnum % 2L == 0L) {
                    purgedCount += (long)p.nonDeletedRecordCount();
                    c.removePage(p);
                } else {
                    p.unlatch();
                }
                p = c.getNextPage(pnum);
            }
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            if (c.getEstimatedRowCount(0) != (long)(2 * numRows) - purgedCount) {
                throw T_Fail.testFailMsg("expect " + ((long)(2 * numRows) - purgedCount) + " after page remove, got " + c.getEstimatedRowCount(0));
            }
            this.PASS("CostEstimationTest1");
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void AllocTest1() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        try {
            int i;
            long cid = this.t_util.t_addContainer(t, 0L);
            this.t_util.t_commit(t);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page1 = this.t_util.t_getPage(c, 1L);
            long p1 = page1.getPageNumber();
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            T_Util.t_insert(page1, row1);
            Page page2 = this.t_util.t_addPage(c);
            long p2 = page2.getPageNumber();
            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
            int rid2 = T_Util.t_insert(page2, row2).getId();
            Page page3 = this.t_util.t_addPage(c);
            long p3 = page3.getPageNumber();
            T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
            T_Util.t_insert(page3, row3);
            Page page4 = this.t_util.t_addPage(c);
            long p4 = page4.getPageNumber();
            T_RawStoreRow row4 = new T_RawStoreRow(REC_004);
            int rid4 = T_Util.t_insert(page4, row4).getId();
            Page page5 = this.t_util.t_addPage(c);
            long p5 = page5.getPageNumber();
            T_RawStoreRow row5 = new T_RawStoreRow(REC_005);
            T_Util.t_insert(page5, row5);
            this.t_util.t_removePage(c, page2);
            this.t_util.t_removePage(c, page4);
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page p = c.getFirstPage();
            if (p == null) {
                throw T_Fail.testFailMsg("get first page failed: expect " + p1 + " got null");
            }
            if (p.getPageNumber() != p1) {
                throw T_Fail.testFailMsg("get first page failed: expect " + p1 + " got " + p.getPageNumber());
            }
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            p = c.getNextPage(p1);
            if (p == null || p.getPageNumber() != p3) {
                throw T_Fail.testFailMsg("get next page failed");
            }
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            p = c.getNextPage(p3);
            if (p == null || p.getPageNumber() != p5) {
                throw T_Fail.testFailMsg("get next page failed");
            }
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            p = this.t_util.t_getLastPage(c);
            if (p == null || p.getPageNumber() != p5) {
                throw T_Fail.testFailMsg("getLastPage failed");
            }
            this.t_util.t_commit(t);
            int tries = 100;
            T_RawStoreRow row6 = new T_RawStoreRow(REC_001);
            long[] pnums = new long[tries];
            int[] rids = new int[tries];
            pnums[0] = p2;
            rids[0] = rid2;
            pnums[1] = p4;
            rids[1] = rid4;
            int match = -1;
            for (i = 2; match < 0 && i < tries; ++i) {
                c = this.t_util.t_openContainer(t, 0L, cid, true);
                p = this.t_util.t_addPage(c);
                pnums[i] = p.getPageNumber();
                for (int j = 0; j < i - 1; ++j) {
                    if (pnums[j] != pnums[i]) continue;
                    match = j;
                    break;
                }
                if (match >= 0) {
                    T_Util.t_checkEmptyPage(p);
                    RecordHandle rh = T_Util.t_insert(p, row6);
                    if (rh.getId() != rids[match]) break;
                    throw T_Fail.testFailMsg("reused page recordId is not preserved");
                }
                rids[i] = T_Util.t_insert(p, row6).getId();
                this.t_util.t_removePage(c, p);
                this.t_util.t_commit(t);
            }
            this.t_util.t_dropContainer(t, 0L, cid);
            if (match >= 0) {
                this.PASS("AllocTest1 success in " + i + " tries");
            } else {
                this.REPORT("AllocTest1 Not successful in " + i + " tries.  This is a timing depenedent test so this is not necessarily an indication of failure.");
            }
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void AllocTest2() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        int numpages = 30;
        try {
            int i;
            long cid = this.t_util.t_addContainer(t, 0L);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page[] page = new Page[numpages];
            for (i = 0; i < numpages; ++i) {
                page[i] = this.t_util.t_addPage(c);
                this.t_util.t_removePage(c, page[i]);
            }
            this.t_util.t_dropContainer(t, 0L, cid);
            this.t_util.t_commit(t);
            if (testRollback) {
                cid = this.t_util.t_addContainer(t, 0L);
                c = this.t_util.t_openContainer(t, 0L, cid, true);
                for (i = 0; i < numpages; ++i) {
                    page[i] = this.t_util.t_addPage(c);
                    this.t_util.t_removePage(c, page[i]);
                }
                this.t_util.t_abort(t);
            }
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("AllocTest2");
    }

    protected void AllocTest3() throws StandardException, T_Fail {
        this.REPORT("allocTest3 cannot be run on an insane server");
    }

    protected void AllocTest4() throws StandardException, T_Fail {
        this.REPORT("allocTest3 cannot be run on an insane server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void AllocTest5() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        try {
            Page p;
            int i;
            long cid = this.t_util.t_addContainer(t, 0L, 1024, 0, 90, false);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            int numRows = 9;
            T_RawStoreRow[] rows = new T_RawStoreRow[numRows];
            for (int j = 0; j < numRows; ++j) {
                rows[j] = new T_RawStoreRow("row " + j);
            }
            for (i = 0; i < numRows; ++i) {
                p = this.t_util.t_addPage(c);
                this.t_util.t_getPage(c, 1L).unlatch();
                for (int j = 0; j <= i; ++j) {
                    if (T_Util.t_insert(p, rows[j]) != null) continue;
                    throw T_Fail.testFailMsg("failed to insert " + (j + 1) + " rows into page " + p);
                }
                p.unlatch();
            }
            p = c.getPageForInsert(0);
            if (p != null) {
                throw T_Fail.testFailMsg("Expect last page to be full");
            }
            for (i = 2; i < 6; ++i) {
                p = c.getPageForInsert(1);
                if (p == null) {
                    throw T_Fail.testFailMsg("Expect next unfilled page to be " + i);
                }
                if (p.getPageNumber() != (long)i) {
                    throw T_Fail.testFailMsg("Expect next unfilled page to be " + i + ", it is " + p.getPageNumber());
                }
                T_Util.t_insert(p, rows[i]);
                p.unlatch();
                while ((p = c.getPageForInsert(0)) != null) {
                    if (p.getPageNumber() != (long)i) {
                        throw T_Fail.testFailMsg("Don't expect page number to change from " + i + " to " + p.getPageNumber());
                    }
                    T_Util.t_insert(p, rows[i]);
                    p.unlatch();
                }
            }
            p = c.getPageForInsert(1);
            if (p != null) {
                throw T_Fail.testFailMsg("don't expect any more pages to be found");
            }
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("AllocTest5 ");
    }

    protected void AllocMTest1(long cid) throws StandardException, T_Fail {
        this.REPORT("AllocMTest1 cannot be run on an insane server");
    }

    static {
        commonContainer = -1L;
    }
}

