/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.test;

import java.util.HashMap;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.system.oe.client.Display;
import org.apache.derbyTesting.system.oe.client.Operations;
import org.apache.derbyTesting.system.oe.client.Submitter;
import org.apache.derbyTesting.system.oe.direct.Standard;
import org.apache.derbyTesting.system.oe.model.Customer;
import org.apache.derbyTesting.system.oe.model.District;
import org.apache.derbyTesting.system.oe.model.Order;
import org.apache.derbyTesting.system.oe.model.OrderLine;
import org.apache.derbyTesting.system.oe.model.Warehouse;
import org.apache.derbyTesting.system.oe.util.OERandom;

public class OperationsTester
extends BaseJDBCTestCase
implements Display {
    private Operations ops;
    private OERandom rand;
    private final short w = 1;

    public OperationsTester(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.ops = new Standard(this.getConnection());
        this.rand = Submitter.getRuntimeRandom(this.getConnection());
    }

    protected void tearDown() throws Exception {
        this.ops.close();
        super.tearDown();
    }

    public void testStockLevel() throws Exception {
        this.ops.stockLevel(null, null, (short)1, this.rand.district(), this.rand.threshold());
        for (int i = 0; i < 20; ++i) {
            short d = this.rand.district();
            int threshold = this.rand.threshold();
            HashMap<String, Number> inputData = new HashMap<String, Number>();
            inputData.put("d", new Short(d));
            inputData.put("threshold", new Integer(threshold));
            this.ops.stockLevel(this, inputData, (short)1, d, threshold);
            OperationsTester.assertTrue((boolean)inputData.isEmpty());
        }
    }

    public void testOrderStatus() throws Exception {
        HashMap<String, Object> inputData;
        short d;
        int i;
        this.ops.orderStatus(null, null, (short)1, this.rand.district(), this.rand.NURand1023());
        for (i = 0; i < 50; ++i) {
            d = this.rand.district();
            int c = this.rand.NURand1023();
            inputData = new HashMap<String, Object>();
            inputData.put("d", new Short(d));
            inputData.put("c", new Integer(c));
            this.ops.orderStatus((Display)this, inputData, (short)1, d, c);
            OperationsTester.assertTrue((boolean)inputData.isEmpty());
        }
        this.ops.orderStatus(null, null, (short)1, this.rand.district(), this.rand.randomCLast());
        for (i = 0; i < 50; ++i) {
            d = this.rand.district();
            String customerLast = this.rand.randomCLast();
            inputData = new HashMap();
            inputData.put("d", new Short(d));
            inputData.put("customerLast", customerLast);
            this.ops.orderStatus((Display)this, inputData, (short)1, d, customerLast);
            OperationsTester.assertTrue((boolean)inputData.isEmpty());
        }
    }

    public void testPayment() throws Exception {
        int i;
        this.ops.payment(null, null, (short)1, this.rand.district(), (short)1, this.rand.district(), this.rand.randomCLast(), this.rand.payment().toString());
        for (i = 0; i < 50; ++i) {
            this.ops.payment((Display)this, null, (short)1, this.rand.district(), (short)1, this.rand.district(), this.rand.randomCLast(), this.rand.payment().toString());
        }
        this.ops.payment(null, null, (short)1, this.rand.district(), (short)1, this.rand.district(), this.rand.NURand1023(), this.rand.payment().toString());
        for (i = 0; i < 50; ++i) {
            this.ops.payment((Display)this, null, (short)1, this.rand.district(), (short)1, this.rand.district(), this.rand.NURand1023(), this.rand.payment().toString());
        }
    }

    public void testNewOrder() throws Exception {
        for (int x = 0; x < 50; ++x) {
            int itemCount = this.rand.randomInt(5, 15);
            int[] items = new int[itemCount];
            short[] quantities = new short[itemCount];
            short[] supplyW = new short[itemCount];
            boolean willFail = this.rand.randomInt(1, 100) == 1;
            for (int i = 0; i < itemCount; ++i) {
                items[i] = willFail && i == itemCount - 1 ? 500000 : this.rand.NURand8191();
                quantities[i] = (short)this.rand.randomInt(1, 10);
                supplyW[i] = 1;
            }
            this.ops.newOrder(this, null, (short)1, this.rand.district(), this.rand.NURand1023(), items, quantities, supplyW);
        }
    }

    public void testScheduleDelivery() throws Exception {
        for (int i = 0; i < 50; ++i) {
            this.ops.scheduleDelivery(this, null, (short)1, this.rand.carrier());
        }
    }

    public void testDelivery() throws Exception {
        this.testScheduleDelivery();
        for (int i = 0; i < 50; ++i) {
            this.ops.delivery();
        }
    }

    public void displayStockLevel(Object displayData, short w, short d, int threshold, int lowStock) throws Exception {
        if (displayData == null) {
            return;
        }
        HashMap inputData = (HashMap)displayData;
        OperationsTester.assertEquals((String)"sl:w", (short)this.w, (short)w);
        OperationsTester.assertEquals((String)"sl:d", (short)((Short)inputData.get("d")), (short)d);
        OperationsTester.assertEquals((String)"sl:threshold", (int)((Integer)inputData.get("threshold")), (int)threshold);
        OperationsTester.assertTrue((String)"sl:low stock", (lowStock >= 0 ? 1 : 0) != 0);
        inputData.clear();
    }

    public void displayOrderStatus(Object displayData, boolean byName, Customer customer, Order order, OrderLine[] lineItems) throws Exception {
        if (displayData == null) {
            return;
        }
        HashMap inputData = (HashMap)displayData;
        OperationsTester.assertEquals((String)"os:w", (short)this.w, (short)customer.getWarehouse());
        OperationsTester.assertEquals((String)"os:d", (short)((Short)inputData.get("d")), (short)customer.getDistrict());
        if (byName) {
            OperationsTester.assertNotNull(inputData.get("customerLast"));
        } else {
            OperationsTester.assertNull(inputData.get("customerLast"));
        }
        inputData.clear();
    }

    public void displayPayment(Object displayData, String amount, boolean byName, Warehouse warehouse, District district, Customer customer) throws Exception {
    }

    public void displayNewOrder(Object displayData, Warehouse warehouse, District district, Customer customer, Order order) throws Exception {
    }

    public void displayScheduleDelivery(Object displayData, short w, short carrier) throws Exception {
    }

    public void testSubmitter() throws Exception {
        Submitter submitter = new Submitter(this, this.ops, this.rand, 1);
        int tranCount = 37;
        for (int i = 0; i < tranCount; ++i) {
            submitter.runTransaction(null);
        }
        int tranCount2 = 47;
        submitter.runTransactions(null, tranCount2);
        int[] executeCounts = submitter.getTransactionCount();
        int totalTran = 0;
        for (int i = 0; i < executeCounts.length; ++i) {
            totalTran += executeCounts[i];
        }
        OperationsTester.assertEquals((String)"Mismatch on Submitter transaction count", (int)(tranCount + tranCount2), (int)totalTran);
    }
}

