/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.apache.derbyTesting.functionTests.util.UniqueRandomSequence;
import org.apache.derbyTesting.perf.clients.DBFiller;
import org.apache.derbyTesting.perf.clients.WisconsinFiller;

public class SingleRecordFiller
implements DBFiller {
    private final int numberOfTables;
    private final int tableSize;
    private final int dataType;
    private final String dataTypeString;
    private final boolean withSecIndexColumn;
    private final boolean withNonIndexedColumn;
    static final int TEXT_SIZE = 100;
    private static final String[] RANDOM_STRINGS = new String[16];
    private static final byte[][] RANDOM_BYTES = new byte[16][100];

    public SingleRecordFiller(int records, int tables) {
        this(records, tables, 12, false, false);
    }

    public SingleRecordFiller(int records, int tables, int type, boolean withSecIndex, boolean withNonIndexed) {
        this.tableSize = records;
        this.numberOfTables = tables;
        this.dataType = type;
        switch (type) {
            case 12: {
                this.dataTypeString = "VARCHAR";
                break;
            }
            case 2004: {
                this.dataTypeString = "BLOB";
                break;
            }
            case 2005: {
                this.dataTypeString = "CLOB";
                break;
            }
            default: {
                throw new IllegalArgumentException("type = " + type);
            }
        }
        this.withSecIndexColumn = withSecIndex;
        this.withNonIndexedColumn = withNonIndexed;
    }

    public void fill(Connection c) throws SQLException {
        c.setAutoCommit(false);
        Statement s = c.createStatement();
        for (int table = 0; table < this.numberOfTables; ++table) {
            String tableName = SingleRecordFiller.getTableName(this.tableSize, table, this.dataType, this.withSecIndexColumn, this.withNonIndexedColumn);
            WisconsinFiller.dropTable(c, tableName);
            s.executeUpdate("CREATE TABLE " + tableName + "(ID INT PRIMARY KEY, " + (this.withSecIndexColumn ? "SEC INT, " : "") + (this.withNonIndexedColumn ? "NI INT, " : "") + "TEXT " + this.dataTypeString + "(" + 100 + "))");
            String extraCols = "";
            String extraParams = "";
            if (this.withSecIndexColumn) {
                extraCols = extraCols + ", SEC";
                extraParams = extraParams + ", ?";
            }
            if (this.withNonIndexedColumn) {
                extraCols = extraCols + ", NI";
                extraParams = extraParams + ", ?";
            }
            PreparedStatement ps = c.prepareStatement("INSERT INTO " + tableName + "(ID, TEXT" + extraCols + ") VALUES (?, ?" + extraParams + ")");
            UniqueRandomSequence secIdSequence = null;
            if (this.withSecIndexColumn) {
                secIdSequence = new UniqueRandomSequence(this.tableSize);
            }
            UniqueRandomSequence nonIndexedSequence = null;
            if (this.withNonIndexedColumn) {
                nonIndexedSequence = new UniqueRandomSequence(this.tableSize);
            }
            for (int i = 0; i < this.tableSize; ++i) {
                int col = 1;
                ps.setInt(col++, i);
                if (this.dataType == 12) {
                    ps.setString(col++, SingleRecordFiller.randomString(i));
                } else if (this.dataType == 2005) {
                    StringReader reader = new StringReader(SingleRecordFiller.randomString(i));
                    ps.setCharacterStream(col++, (Reader)reader, 100);
                } else if (this.dataType == 2004) {
                    ByteArrayInputStream stream = new ByteArrayInputStream(SingleRecordFiller.randomBytes(i));
                    ps.setBinaryStream(col++, (InputStream)stream, 100);
                }
                if (this.withSecIndexColumn) {
                    ps.setInt(col++, secIdSequence.nextValue());
                }
                if (this.withNonIndexedColumn) {
                    ps.setInt(col++, nonIndexedSequence.nextValue());
                }
                ps.executeUpdate();
                if (i % 1000 != 0) continue;
                c.commit();
            }
            if (this.withSecIndexColumn) {
                s.executeUpdate("CREATE INDEX " + tableName + "_SECONDARY_INDEX ON " + tableName + "(SEC)");
            }
            ps.close();
            c.commit();
        }
        s.close();
    }

    static String randomString(int seed) {
        return RANDOM_STRINGS[(seed & Integer.MAX_VALUE) % RANDOM_STRINGS.length];
    }

    static byte[] randomBytes(int seed) {
        return RANDOM_BYTES[(seed & Integer.MAX_VALUE) % RANDOM_BYTES.length];
    }

    static String getTableName(int records, int table, int dataType, boolean withSecIndex, boolean withNonIndexed) {
        String name = "SINGLE_RECORD_" + records + "_" + table;
        if (withSecIndex) {
            name = name + "_SECIDX";
        }
        if (withNonIndexed) {
            name = name + "_NONIDX";
        }
        if (dataType == 12) {
            name = name + "_VARCHAR";
        } else if (dataType == 2004) {
            name = name + "_BLOB";
        } else if (dataType == 2005) {
            name = name + "_CLOB";
        } else {
            throw new IllegalArgumentException("dataType = " + dataType);
        }
        return name;
    }

    static {
        String alphabet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890_-+*/(){}[]&%$#!";
        Random r = new Random();
        for (int i = 0; i < RANDOM_STRINGS.length; ++i) {
            StringBuffer buf = new StringBuffer(100);
            for (int x = 0; x < 100; ++x) {
                buf.append("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890_-+*/(){}[]&%$#!".charAt(r.nextInt("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890_-+*/(){}[]&%$#!".length())));
            }
            SingleRecordFiller.RANDOM_STRINGS[i] = buf.toString();
            for (int j = 0; j < 100; ++j) {
                SingleRecordFiller.RANDOM_BYTES[i][j] = (byte)RANDOM_STRINGS[i].charAt(j);
            }
        }
    }
}

